       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03407.                                         
COB303 DATE-WRITTEN.  OCT 30, 2003.                                     
      *                                                                 00040000
       DATE-COMPILED.                                                   
      *                                                                 00060000
      *---------------------------------------------------------------- 00070000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00070000
      *--                   STORED PROCEDURE:  CSR03407              -- 00070000
      *---------------------------------------------------------------- 00070000
      *--                         S U M M A R Y                      -- 00070000
      *--                                                            -- 00070000
      *--  CSR03407 :                                                -- 00080000
      *--                                                            -- 00090000
      *--  THIS STORED PROCEDURE VALIDATES ACCOUNT AND SEND BACK     -- 00100000
      *--  ACCOUNT DETAILS FOR BILLMATRIX.                           -- 00110000
      *--                                                            -- 00120000
      *---------------------------------------------------------------- 00130000
      *---------------------------------------------------------------- 00130000
      *--                                                            -- 00180000
      *--  PARAMETERS                                                -- 00190000
      *--                                                            -- 00200000
      *--  INPUT    - 1 PARAMETERS                                   -- 00210000
      *--                                                            -- 00210000
      *--         I_ACCT_NO        CHAR(13)                          -- 00210000
      *--         I_CALL_TYPE      CHAR(1)                           -- 00210000
      *--                                                            -- 00210000
      *--  OUTPUT   - NO PARAMETERS                                  -- 00210000
      *--  IN/OUT   - NO PARAMETERS                                  -- 00210000
      *--                                                            -- 00070000
      *--  RESULT SET = 1                                            -- 00350000
      *--  --------------                                            -- 00360000
      *--      RETURN_CODE           INTEGER                         -- 00360000
      *--      ACCOUNT_NO            CHAR(13)                        -- 00360000
      *--      CUSTOMER_NO           CHAR(10)                        -- 00360000
      *--      PREMISE_NO            CHAR(10)                        -- 00360000
      *--      CODE_ACCT_STAT        CHAR(01)                        -- 00360000
      *--      ACCOUNT_TYPE_CODE     CHAR(01)                        -- 00360000
      *--      LOCAL_OFFICE          CHAR(03)                        -- 00360000
      *--      CODE_CRIT_OUTAGE      CHAR(02)                        -- 00360000
      *--      CASH_ONLY             CHAR(01)                        -- 00360000
      *--      BILLED_BALANCE        PACKED DECIMAL(9,2)             -- 00390000
      *--      NAME                  CHAR(56)                        -- 00390000
      *--      SERVICE_DATE          CHAR(10)                        -- 00390000
      *--      CUST_SSN              CHAR(09)                        -- 00390000
      *--      PHONE_NO              CHAR(10)                        -- 00390000
      *--      REV_DISTRICT_CD       CHAR(03)                        -- 00390000
      *--      COUNTY                CHAR(03)                        -- 00390000
      *--      CITY                  CHAR(26)                        -- 00390000
      *--      STATE                 CHAR(02)                        -- 00390000
      *--      ZIPCODE               CHAR(05)                        -- 00390000
      *---------------------------------------------------------------- 00400000
      *--                        MODIFICATION LOG                    -- 00410000
      *--                                                            -- 00420000
      *--  DATE          INITIALS    COMMENTS                        -- 00430000
      *--  -----------   --------    ---------------------------------- 00440000
      *--  10/29/2003    SK88120     NEW SP FOR BILLMATRIX.          -- 00450000
      *--                                                            -- 00420000
      *--  07/29/2004    SK88120     COMMAND CENTER CHANGES.         -- 00450000
      *--                                                            -- 00420000
APS   *--  10/21/2004    SK88120     CHANGES WERE MADE TO PASS SPACES-- 00450000
      *--                            FOR BILLED-BALANCE(FOR APS ONLY)-- 00420000
C32309*--                                                            -- 00420000
C32309*--  06/29/2005    SK88120     ADDED REFUSED-SSN-FLAG IN RETURN-- 00450000
C32309*--                            PARAMETERS FOR PHOENIX.         -- 00420000
ACT106*--  05/16/2015    RS7M249     DELETE UNUSED COPYBOOK(S)       --         
      *---------------------------------------------------------------- 00470000
      *                                                                 00490000
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03407'.
MSQ017     COPY MFASQLM.
      *                                                                 00570000
      ******************************************************************00580000
      *    DB2 INCLUDES                                                *00590000
      ******************************************************************00600000
      *                                                                 00610000
       01 WS-REVENUE-MNTH.                                              
COB305     05 WS-REV-MTH-LOWER-LIMIT        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.       
COB305     05 WS-REV-MTH-UPPER-LIMIT        PIC S9(6)V USAGE COMP-3 
COB305       VALUE 0.       
      *                                                                 00650000
           EXEC SQL                                                     00620000
              INCLUDE SQLCA                                             00630000
           END-EXEC.                                                    00640000
      *----< CSS_ACCOUNT >                                              00650000
           EXEC SQL                                                     00660000
              INCLUDE TBACCT                                            00670000
           END-EXEC.                                                    00680000
      *----< CSS_CUSTOMER >                                             00690000
           EXEC SQL                                                     00660000
              INCLUDE TBCUST                                            00670000
           END-EXEC.                                                    00680000
      *----< CSS_PREMISE >                                              00690000
           EXEC SQL                                                     00660000
              INCLUDE TBPREM                                            00670000
           END-EXEC.                                                    00680000
      *---< CSS_NAME >                                                  00690000
           EXEC SQL                                                     00660000
              INCLUDE TBNAME                                            00670000
           END-EXEC.                                                    00680000
      *----< CSS_CUST_STATS >                                           00690000
           EXEC SQL                                                     00660000
              INCLUDE TBCSTSTS                                          00670000
           END-EXEC.                                                    00680000
      *----< CSS_ADDR_FORMATTED >                                       00690000
           EXEC SQL                                                     00660000
              INCLUDE TBADRFMT                                          00670000
           END-EXEC.                                                    00680000
      *----< CSS_ADDR_FREEFORM >                                        00690000
           EXEC SQL                                                     00660000
              INCLUDE TBADRFRE                                          00670000
           END-EXEC.                                                    00680000
      *---< CSS_CUST_PHONE >                                                    
           EXEC SQL                                                     00660000
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
      *---< CSS_CREDIT_PROFILE >                                                
           EXEC SQL                                                     00660000
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
      *---< CSS_ZIP_CODE >                                                      
           EXEC SQL                                                     00660000
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
      *---< CSS_WQ_ITEMS >                                                      
           EXEC SQL                                                     00660000
              INCLUDE TBWQITS                                                   
           END-EXEC.                                                            
      *---< CSS_JOB_PARM >                                                      
           EXEC SQL                                                     00660000
              INCLUDE TBJBPARM                                                  
           END-EXEC.                                                            
      *---< CSS_BILLING_DET >                                                   
           EXEC SQL                                                     00660000
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *---< CSS_DELINQUENCY >                                                   
           EXEC SQL                                                     00660000
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *---< CSS_AR_CNTL >                                                       
           EXEC SQL                                                     00660000
              INCLUDE TBARCNTL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
      *--------< LINKAGE SECTION VARIABLES FOR SCSCO068 >                       
           COPY CWS0068L.                                                       
      *                                                                         
      *--------< WORKING STORAGE TO SUPPORT CPD00068 >                          
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
      *                                                                 00820000
           EXEC SQL                                                             
                INCLUDE CWSX0010                                                
           END-EXEC.                                                    00820000
      *                                                                         
           COPY CWS00027.                                               00830000
           COPY CWS00303.                                               00840000
           COPY CWS00056.                                               00840000
      *                                                                         
      *---------------------------------------------------------------          
      *--  RETURN FIELDS                                            --          
      *---------------------------------------------------------------          
      *                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE              PIC S9(9)     COMP VALUE 0.   
           05  S-ACCOUNT-NO               PIC X(13)     VALUE SPACES.   
           05  S-CUSTOMER-NO              PIC X(10)     VALUE SPACES.   
           05  S-PREMISE-NO               PIC X(10)     VALUE SPACES.   
           05  S-CODE-ACCT-STAT           PIC X(1)      VALUE SPACES.   
           05  S-ACCOUNT-TYPE-CODE        PIC X(1)      VALUE SPACES.   
           05  S-LOCAL-OFFICE             PIC X(3)      VALUE SPACES.   
           05  S-CODE-CRIT-OUTAGE         PIC X(2)      VALUE SPACES.   
           05  S-CASH-ONLY                PIC X(1)      VALUE 'N'.      
           05  S-BILLED-BALANCE           PIC X(13)     VALUE SPACES.   
           05  S-NAME                     PIC X(56)     VALUE SPACES.   
           05  S-SERVICE-DATE             PIC X(10)     VALUE SPACES.   
           05  S-CUST-SSN                 PIC X(09)     VALUE SPACES.   
           05  S-PHONE-NUMBER             PIC X(10)     VALUE SPACES.   
           05  S-REV-DISTRICT-CD          PIC X(03)     VALUE SPACES.   
           05  S-COUNTY                   PIC X(03)     VALUE SPACES.   
           05  S-CITY                     PIC X(26)     VALUE SPACES.   
           05  S-STATE                    PIC X(02)     VALUE SPACES.   
           05  S-ZIPCODE                  PIC X(05)     VALUE SPACES.   
           05  S-TIMESTAMP                PIC X(26)     VALUE SPACES.   
           05  S-COMPANY-NO               PIC X(04)     VALUE SPACES.   
C32309     05  S-REFUSED-SSN-FL           PIC X(01)     VALUE SPACES.   
      *                                                                         
      ******************************************************************00880000
      *    WORK AREAS                                                  *00870000
      ******************************************************************00880000
      *                                                                         
       01  WS-MISC.                                                     
           05  PROGRAM-NAME               PIC X(8)  VALUE 'CSR03407'.   
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
           05  MCSCB068                   PIC X(8)  VALUE 'MCSCB068'.   
           05  WS-ACCOUNT-NO-A            PIC X(13) VALUE SPACES.       
           05  WS-ACCOUNT-NO-N REDEFINES  WS-ACCOUNT-NO-A               
                                          PIC 9(13).                    
           05  WS-CUSTOMER-NO-A           PIC X(10) VALUE SPACES.       
           05  WS-CUSTOMER-NO-N REDEFINES WS-CUSTOMER-NO-A              
                                          PIC 9(10).                    
           05  WS-PREMISE-NO-A            PIC X(10) VALUE SPACES.       
           05  WS-PREMISE-NO-N  REDEFINES WS-PREMISE-NO-A               
                                          PIC 9(10).                    
           05  WS-ACCOUNT-NO-NUM          PIC S9(13) COMP-3 VALUE ZERO. 
           05  WS-DATE-BILL-00-IND        PIC S9(04) COMP   VALUE +0.   
           05  WS-DATE-BILL-30-IND        PIC S9(04) COMP   VALUE +0.   
           05  WS-DATE-BILL-60-IND        PIC S9(04) COMP   VALUE +0.   
           05  WS-DATE-BILL-90-IND        PIC S9(04) COMP   VALUE +0.   
           05  WS-FINAL-NULL-IND          PIC S9(04) COMP   VALUE +0.   
           05  WS-SERVC-NULL-IND          PIC S9(04) COMP   VALUE +0.   
           05  WS-BILLED-BALANCE-C        PIC X(12).                    
           05  WS-BILLED-BALANCE-N        REDEFINES WS-BILLED-BALANCE-C 
                                          PIC -(9).99.                  
COB305     05 WS-BILLED-BALANCE        PIC S9(09)V99 COMP-3 VALUE 0.         
           05  WS-FROM.                                                 
               10  WS-FROM-X              OCCURS 51 TIMES PIC X.        
           05  WS-DELIMITER               PIC X VALUE ';'.              
           05  WS-SUB                     PIC S9(8) COMP VALUE ZERO.    
           05  WS-HOME                    PIC X(2)  VALUE 'H1'.         
           05  WS-BUSINESS                PIC X(2)  VALUE 'B1'.         
           05  WS-PHONE-TYPE              PIC X(2)  VALUE SPACES.       
           05  WS-RETURN-CODE             PIC S9(4) COMP VALUE 0.       
           05  WS-RETURN-CODE1            PIC S9(4) COMP VALUE 0.       
           05  WS-WQ-EXIST                PIC X(1)  VALUE SPACES.       
           05  WS-CANREBIL-EXIST          PIC X(1)  VALUE SPACES.       
           05  MULTIPLE-ROWS              PIC S9(04) COMP VALUE -811.   
APS        05  WS-A                       PIC X(1)  VALUE 'A'.          
           05  WS-B                       PIC X(1)  VALUE 'B'.          
           05  WS-S                       PIC X(1)  VALUE 'S'.          
           05  WS-P                       PIC X(1)  VALUE 'P'.          
           05  WS-C                       PIC X(1)  VALUE 'C'.          
           05  WS-F                       PIC X(1)  VALUE 'F'.          
           05  WS-PARM-DATA               PIC X(20).                    
           05  WS-PARM-DATA-N             REDEFINES WS-PARM-DATA.       
               10  WS-PARM-TEXT           PIC X(14).                    
               10  WS-PARM-REVMNTH        PIC X(6).                     
           05  WS-REV-MNTH.                                             
               10  WS-YEAR                PIC 9(4).                     
               10  WS-MNTH                PIC 9(2).                     
           05 WS-DATE1.                                                 
              10  WS-CCYY1               PIC 9(4).                      
              10  WS-MM1                 PIC 9(2).                      
           05 WS-DATE2.                                                 
              10  WS-CCYY2               PIC 9(4).                      
              10  WS-MM2                 PIC 9(2).                      
           05 WS-DATE3                   PIC 9(6).                      
           05 WS-DATABASE                PIC 9(01) VALUE 0.             
              88  CSR-DATABASE                     VALUE 1.             
              88  SEB-DATABASE                     VALUE 2.             
      *                                                                         
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
      *                                                                 01660000
HPCCDM*EJECT                                                            01830000
      *                                                                 01660000
       LINKAGE SECTION.                                                 
      *                                                                         
       01  PARM-ACCT-NO                   PIC X(13).                    
       01  PARM-CALL-TYPE                 PIC X(1).                     
       01  PARM-TIMESTAMP                 PIC X(26).                    
       01  PARM-COMPANY-NO                PIC X(4).                     
      *                                                                         
       PROCEDURE DIVISION USING PARM-ACCT-NO,                           
                                PARM-CALL-TYPE,                         
                                PARM-TIMESTAMP,                         
                                PARM-COMPANY-NO.                        
      *                                                                 01850000
      ******************************************************************01860000
      * 0000-MAINLINE                                                  *01870000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01880000
      ******************************************************************01890000
       0000-MAINLINE.                                                   
      *                                                                 01920000
           PERFORM 1000-INITIALIZE     THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 01970000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02000000
      ******************************************************************02010000
      * 1000-INITIALIZE                                                *02020000
      *                                                                *02030000
      *     1. RESET DB2 ERROR HANDLERS                                *02040000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02050000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02060000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02070000
      *                                                                *02080000
      ******************************************************************02090000
       1000-INITIALIZE.                                                 
      *                                                                         
      * GET CURRENT DATABASE                                                    
           MOVE '01'                     TO C8-COMPANY-NO.              
           MOVE 'DATABASE'               TO C8-DELINQ-CD.               
           PERFORM 8300-GET-DATABASE     THRU 8300-EXIT.                
           MOVE C8-DELINQ-VALUE          TO WS-DATABASE.                
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
           IF PARM-CALL-TYPE = WS-B                                     
APS        OR PARM-CALL-TYPE = WS-A                                     
              PERFORM 1100-DECLARE-C1-CURSOR THRU 1100-C1-EXIT          
           ELSE                                                         
              PERFORM 1100-DECLARE-C2-CURSOR THRU 1100-C2-EXIT          
           END-IF.                                                      
      *                                                                 02320000
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02350000
       1100-DECLARE-C1-CURSOR.                                          
      *                                                                 02350000
           EXEC SQL                                                     
              DECLARE C1 CURSOR  FOR                         
              SELECT :S-RETURN-CODE        AS RETURN_CODE               
                    ,:S-ACCOUNT-NO         AS ACCOUNT_NO                
                    ,:S-CASH-ONLY          AS CASH_ONLY                 
                    ,:S-BILLED-BALANCE     AS BILLED_BALANCE            
                    ,:S-TIMESTAMP          AS TIMESTAMP                 
                    ,:S-COMPANY-NO         AS COMPANY_NO                
              FROM CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE        AS RETURN_CODE                       
MFA-TR*             ,:S-ACCOUNT-NO         AS ACCOUNT_NO                        
MFA-TR*             ,:S-CASH-ONLY          AS CASH_ONLY                         
MFA-TR*             ,:S-BILLED-BALANCE     AS BILLED_BALANCE                    
MFA-TR*             ,:S-TIMESTAMP          AS TIMESTAMP                         
MFA-TR*             ,:S-COMPANY-NO         AS COMPANY_NO                        
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                 02350000
       1100-C1-EXIT.                                                    
           EXIT.                                                        
      *                                                                 02350000
       1100-DECLARE-C2-CURSOR.                                          
      *                                                                 02350000
           EXEC SQL                                                     
              DECLARE C2 CURSOR  FOR                         
              SELECT :S-RETURN-CODE        AS RETURN_CODE               
                    ,:S-ACCOUNT-NO         AS ACCOUNT_NO                
                    ,:S-CUSTOMER-NO        AS CUSTOMER_NO               
                    ,:S-PREMISE-NO         AS PREMISE_NO                
                    ,:S-CODE-ACCT-STAT     AS CODE_ACCT_STAT            
                    ,:S-ACCOUNT-TYPE-CODE  AS ACCOUNT_TYPE_CODE         
                    ,:S-LOCAL-OFFICE       AS LOCAL_OFFICE              
                    ,:S-CODE-CRIT-OUTAGE   AS CODE_CRIT_OUTAGE          
                    ,:S-CASH-ONLY          AS CASH_ONLY                 
                    ,:S-BILLED-BALANCE     AS BILLED_BALANCE            
                    ,:S-NAME               AS NAME                      
                    ,:S-SERVICE-DATE       AS SERVICE_DATE              
                    ,:S-CUST-SSN           AS CUST_SSN                  
                    ,:S-PHONE-NUMBER       AS PHONE_NUMBER              
                    ,:S-REV-DISTRICT-CD    AS REV_DISTRICT_CD           
                    ,:S-COUNTY             AS COUNTY                    
                    ,:S-CITY               AS CITY                      
                    ,:S-STATE              AS STATE                     
                    ,:S-ZIPCODE            AS ZIPCODE                   
C32309              ,:S-REFUSED-SSN-FL     AS REFUSED_SSN_FL            
              FROM CIS.SYSDUMMY1                                     
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C2 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT :S-RETURN-CODE        AS RETURN_CODE                       
MFA-TR*             ,:S-ACCOUNT-NO         AS ACCOUNT_NO                        
MFA-TR*             ,:S-CUSTOMER-NO        AS CUSTOMER_NO                       
MFA-TR*             ,:S-PREMISE-NO         AS PREMISE_NO                        
MFA-TR*             ,:S-CODE-ACCT-STAT     AS CODE_ACCT_STAT                    
MFA-TR*             ,:S-ACCOUNT-TYPE-CODE  AS ACCOUNT_TYPE_CODE                 
MFA-TR*             ,:S-LOCAL-OFFICE       AS LOCAL_OFFICE                      
MFA-TR*             ,:S-CODE-CRIT-OUTAGE   AS CODE_CRIT_OUTAGE                  
MFA-TR*             ,:S-CASH-ONLY          AS CASH_ONLY                         
MFA-TR*             ,:S-BILLED-BALANCE     AS BILLED_BALANCE                    
MFA-TR*             ,:S-NAME               AS NAME                              
MFA-TR*             ,:S-SERVICE-DATE       AS SERVICE_DATE                      
MFA-TR*             ,:S-CUST-SSN           AS CUST_SSN                          
MFA-TR*             ,:S-PHONE-NUMBER       AS PHONE_NUMBER                      
MFA-TR*             ,:S-REV-DISTRICT-CD    AS REV_DISTRICT_CD                   
MFA-TR*             ,:S-COUNTY             AS COUNTY                            
MFA-TR*             ,:S-CITY               AS CITY                              
MFA-TR*             ,:S-STATE              AS STATE                             
MFA-TR*             ,:S-ZIPCODE            AS ZIPCODE                           
MFA-TR*             ,:S-REFUSED-SSN-FL     AS REFUSED_SSN_FL                    
MFA-TR*       FROM SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC                                                             
      *                                                                 02350000
       1100-C2-EXIT.                                                    
           EXIT.                                                        
      *                                                                 02350000
      ******************************************************************02670000
      * 2000-PROCESS-OUTPUT.                                           *02680000
      *                                                                *02690000
      ******************************************************************02700000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 02720000
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
      *                                                                 02760000
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02790000
      ******************************************************************04220000
      ** 2200-BUILD-RESULT                                             *04230000
      ******************************************************************04240000
       2200-BUILD-RESULT.                                               
      *                                                                         
      ******GET DETAILS FROM ACCOUNT TABLE                                      
           MOVE PARM-ACCT-NO                  TO AT-ACCOUNT-NO          
           IF ((PARM-CALL-TYPE EQUAL 'B' OR                             
APS             PARM-CALL-TYPE EQUAL 'A' OR                             
                PARM-CALL-TYPE EQUAL 'C' ) AND                          
               (PARM-TIMESTAMP NOT EQUAL SPACES))                       
              IF PARM-CALL-TYPE EQUAL 'B'                               
APS           OR PARM-CALL-TYPE EQUAL 'A'                               
                 PERFORM 7000A-SELECT-CSS-ACCOUNT    THRU 7000A-EXIT    
              ELSE                                                      
                 PERFORM 7000B-SELECT-CSS-ACCOUNT    THRU 7000B-EXIT    
              END-IF                                                    
      *                                                                         
      ******CALL CPD00068 TO GET ACCOUNT BALANCE                                
           IF WS-ACTIVE-RETURN-CODE = 0                                 
      ******GET CUSTOMER SSN                                                    
              PERFORM 7400-SELECT-CUST-STATS  THRU 7400-EXIT            
              IF PARM-CALL-TYPE = WS-B                                  
APS           OR PARM-CALL-TYPE = WS-A                                  
                 PERFORM 8000-SELECT-WQ          THRU 8000-EXIT         
                 PERFORM 8100-SELECT-REVMNTH     THRU 8100-EXIT         
                 MOVE WS-YEAR                    TO WS-CCYY1            
                 MOVE WS-MNTH                    TO WS-MM1              
                 MOVE WS-DATE1                   TO WS-DATE3            
                 MOVE WS-DATE3                   TO                     
                                                 WS-REV-MTH-UPPER-LIMIT 
                 IF WS-MNTH = '01'                                      
                    COMPUTE WS-YEAR = WS-YEAR - 1                       
                    COMPUTE WS-MNTH  = 11                               
                 ELSE                                                   
                    IF WS-MNTH = '02'                                   
                       COMPUTE WS-YEAR = WS-YEAR - 1                    
                       COMPUTE WS-MNTH  = 12                            
                    ELSE                                                
                       COMPUTE WS-MNTH = WS-MNTH - 2                    
                    END-IF                                              
                 END-IF                                                 
                 MOVE WS-YEAR                    TO WS-CCYY2            
                 MOVE WS-MNTH                    TO WS-MM2              
                 MOVE WS-DATE2                   TO WS-DATE3            
                 MOVE WS-DATE3                   TO                     
                                                 WS-REV-MTH-LOWER-LIMIT 
                 PERFORM 8200-SELECT-CANREBIL-ROW  THRU 8200-EXIT       
              END-IF                                                    
      *                                                                         
              MOVE AT-CODES-DATA-PRESENT      TO  WS-CODES-DATA-PRESENT 
              IF WS-DATE-BILL-00-IND < 0                                
                  MOVE LOW-VALUES             TO AT-DATE-BILL-DAY-00    
              END-IF                                                    
              IF (((AT-MST-SUB-ACCT-IND = WS-S OR                       
                   AT-CODE-ACCT-STAT   = WS-P OR                        
                  (AT-CODE-ACCT-STAT   = WS-B AND                       
                   AT-ACCT-FINALED-DT  = SPACES) OR                     
                   AT-BANKRUPTCY-IND   = WS-B OR                        
                   WS-WQ-EXIST         = WS-Y OR                        
                   WS-CANREBIL-EXIST   = WS-Y OR                        
                   CE-PASSWORD-TX      NOT EQUAL SPACES) AND            
                   (PARM-CALL-TYPE      = WS-B)) OR                     
APS                (PARM-CALL-TYPE      = WS-A))                        
                 MOVE SPACES                     TO S-BILLED-BALANCE    
              ELSE                                                      
                 PERFORM 2250-BUILD-CPD68-RESULT THRU 2250-EXIT         
                 IF WS-BILLED-BALANCE < 0 AND PARM-CALL-TYPE     = WS-B 
                    MOVE '         0.00'   TO S-BILLED-BALANCE          
                 ELSE                                                   
                    MOVE WS-BILLED-BALANCE       TO WS-BILLED-BALANCE-N 
                    MOVE WS-BILLED-BALANCE-C     TO S-BILLED-BALANCE    
                 END-IF                                                 
              END-IF                                                    
      *                                                                         
      ******GET CASH-ONLY FLAG                                                  
              PERFORM 7100-SELECT-CRED-PROF   THRU 7100-EXIT            
              IF S-CASH-ONLY NOT = 'Y'                                  
                  PERFORM 7150-SELECT-AR-CNTL     THRU 7150-EXIT        
              END-IF                                                    
      *                                                                         
              IF PARM-CALL-TYPE EQUAL 'C'                               
      **** GET PREMISE DETAILS                                                  
                 PERFORM 7600-GET-PREM-DTLS      THRU 7600-EXIT         
                 IF PR-ADDRESS-FORMAT = 'A'                             
                   PERFORM 7700-SELECT-ADDR-FORM THRU 7700-EXIT         
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                      MOVE DY-ZIP-CODE            TO S-ZIPCODE          
                      PERFORM 7900-SELECT-TOWN-ST THRU 7900-EXIT        
                   END-IF                                               
                 ELSE                                                   
                   PERFORM 7800-SELECT-ADDR-FREE  THRU 7800-EXIT        
                   MOVE DZ-ADDR-ZIP-CODE          TO S-ZIPCODE          
                 END-IF                                                 
      **** GET CUSTOMER NAME / BUSINESS NAME                                    
                 MOVE AT-CUSTOMER-NO               TO CU-CUSTOMER-NO    
                 PERFORM 7300-GET-CUST-DTLS        THRU 7300-EXIT       
                 IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
                    IF WS-SERVC-NULL-IND < 0                            
                       MOVE SPACES                   TO S-SERVICE-DATE  
                    ELSE                                                
                       MOVE CU-SERVICE-EST-DATE      TO S-SERVICE-DATE  
                    END-IF                                              
                    PERFORM 7200-GET-NAME        THRU 7200-EXIT         
                    IF DQ-NAME-FORMAT = 'I'                             
                       MOVE DQ-LAST-NAME TO WS-FROM                     
                       PERFORM 2260-PROCESS-FROM-STRING THRU 2260-EXIT  
                       MOVE WS-FROM TO DQ-LAST-NAME                     
      *                                                                 30640000
                       MOVE DQ-FIRST-NAME TO WS-FROM                    
                       PERFORM 2260-PROCESS-FROM-STRING THRU 2260-EXIT  
                       MOVE WS-FROM TO DQ-FIRST-NAME                    
      *                                                                 30680000
                       IF DQ-MIDDLE-NAME NOT = SPACE                    
                          MOVE DQ-MIDDLE-NAME TO WS-FROM                
                          PERFORM 2260-PROCESS-FROM-STRING              
                                                        THRU 2260-EXIT  
                          MOVE WS-FROM TO DQ-MIDDLE-NAME                
                       END-IF                                           
     *                                                                  
                       MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                
                     PERFORM 2260-PROCESS-FROM-STRING    THRU 2260-EXIT 
                       MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                
     *                                                                  
                       IF DQ-MIDDLE-NAME = SPACE                        
                          STRING DQ-LAST-NAME DELIMITED WS-DELIMITER    
                              ', ' DELIMITED SIZE                       
                              DQ-FIRST-NAME DELIMITED WS-DELIMITER      
                              ' ' DELIMITED SIZE                        
                              DQ-TITLE-SUFFIX-1 DELIMITED WS-DELIMITER  
                            INTO S-NAME                                 
                         END-STRING                                     
                       ELSE                                             
                          STRING DQ-LAST-NAME DELIMITED WS-DELIMITER    
                              ', ' DELIMITED SIZE                       
                              DQ-FIRST-NAME DELIMITED WS-DELIMITER      
                              ' ' DELIMITED SIZE                        
                              DQ-MIDDLE-NAME DELIMITED WS-DELIMITER     
                              ' ' DELIMITED SIZE                        
                              DQ-TITLE-SUFFIX-1 DELIMITED WS-DELIMITER  
                            INTO S-NAME                                 
                          END-STRING                                    
                       END-IF                                           
                       MOVE WS-HOME                   TO WS-PHONE-TYPE  
                       PERFORM 7500-SELECT-CUST-PHONE THRU 7500-EXIT    
                       MOVE  CB-PHONE-NO              TO S-PHONE-NUMBER 
                    ELSE                                                
                       MOVE DQ-FULL-NAME              TO S-NAME         
                       MOVE WS-BUSINESS               TO WS-PHONE-TYPE  
                       MOVE DQ-FULL-NAME              TO S-NAME         
                       PERFORM 7500-SELECT-CUST-PHONE THRU 7500-EXIT    
                       MOVE  CB-PHONE-NO              TO S-PHONE-NUMBER 
                    END-IF                                              
                 END-IF                                                 
              END-IF                                                    
           END-IF                                                       
           ELSE                                                         
              MOVE +1000                      TO WS-RETURN-CODE1        
           END-IF                                                       
      *                                                                         
           PERFORM 2300-PROCESS-OUTPUT        THRU 2300-EXIT.           
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04220000
      *  2250-BUILD-CPD68-RESULT                                       *04230000
      ******************************************************************04240000
       2250-BUILD-CPD68-RESULT.                                         
      *                                                                         
      * SET CPD00068 SWITCHES THAT ARE NEEDED                                   
           MOVE 'Y' TO CALC-BALANCE-SW                                  
                       CALC-ARREARS-SW                                  
                       CALC-PAST-DUE-SW.                                
      *                                                                         
           MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
           MOVE CWS00068-FIELDS            TO WS-CWS68-FIELDS-LK.       
           MOVE WS-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT-LK. 
           MOVE DCLCSS-ACCOUNT             TO WS-DCLCSS-ACCOUNT-LK.     
           MOVE ABEND-FILE                 TO WS-ABEND-FILE-LK.         
           MOVE WS-RETURN-CODE             TO WS-RETURN-CODE-LK.        
           MOVE SPACES                     TO ABEND-FUNCTION .          
           PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
      *                                                                         
           IF AT-CODE-ACCT-STAT = 'S'                                   
              MOVE WS-WO-BALANCE            TO WS-BILLED-BALANCE        
           ELSE                                                         
              MOVE AT-TOTAL-AR-BALANCE      TO WS-BILLED-BALANCE        
           END-IF.                                                      
      *                                                                         
       2250-EXIT.                                                       
           EXIT.                                                        
      *                                                                 04210000
      ******************************************************************32240000
      * 2260-PROCESS-FROM-STRING                                       *32250000
      *     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *32270000
      *     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *32280000
      ******************************************************************32300000
       2260-PROCESS-FROM-STRING.                                        
      *                                                                 32330000
           PERFORM                                                      
               VARYING WS-SUB FROM 51 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1             TO WS-SUB.                                 
           MOVE WS-DELIMITER TO WS-FROM-X (WS-SUB).                     
      *                                                                 32410000
       2260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      * 2300-PROCESS-OUTPUT                                            *04490000
      *      CALLS   8100-SEND-RESULT                                  *        
      *      CALLED FROM 2200-BUILD-RESULT                             *        
      *      SENDS THE FIELDS TO THE IVR                               *        
      ******************************************************************        
       2300-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE PARM-TIMESTAMP           TO S-TIMESTAMP                 
           MOVE AT-ACCOUNT-NO            TO WS-ACCOUNT-NO-N             
           MOVE WS-ACCOUNT-NO-A          TO S-ACCOUNT-NO                
           MOVE AT-CUSTOMER-NO           TO WS-CUSTOMER-NO-N            
           MOVE WS-CUSTOMER-NO-A         TO S-CUSTOMER-NO               
           MOVE AT-PREMISE-NO            TO WS-PREMISE-NO-N             
           MOVE WS-PREMISE-NO-A          TO S-PREMISE-NO                
           MOVE AT-CODE-ACCT-STAT        TO S-CODE-ACCT-STAT            
           MOVE AT-ACCOUNT-TYPE-CODE     TO S-ACCOUNT-TYPE-CODE         
           MOVE AT-LOCAL-OFFICE          TO S-LOCAL-OFFICE              
           MOVE AT-CODE-CRIT-OUTAGE      TO S-CODE-CRIT-OUTAGE          
           IF CSR-DATABASE                                              
              IF AT-COMPANY-NO = '01'                                   
                 MOVE 'SCEG'                TO S-COMPANY-NO             
              ELSE                                                      
                 MOVE 'PSNC'                TO S-COMPANY-NO             
              END-IF                                                    
           ELSE                                                         
              MOVE 'SEB'                 TO S-COMPANY-NO                
           END-IF                                                       
           IF WS-RETURN-CODE1 = NOT-FOUND                               
              MOVE +100                  TO S-RETURN-CODE               
              MOVE SPACES                TO S-COMPANY-NO                
           ELSE                                                         
              MOVE WS-RETURN-CODE1          TO S-RETURN-CODE            
              IF WS-RETURN-CODE1 NOT EQUAL 0                            
                 MOVE SPACES                TO S-COMPANY-NO             
              END-IF                                                    
           END-IF                                                       
      *                                                                         
           ADD +1       TO CTR-ROWS.                                    
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7000A-SELECT-CSS-ACCOUNT                                      *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *     SELECTS CSS_ACCOUNT                                       *         
      *****************************************************************         
       7000A-SELECT-CSS-ACCOUNT.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.CUSTOMER_NO                                     
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.PREMISE_NO                                      
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.CODE_CRIT_OUTAGE                                
                    ,AT.NOTICE_EXEMPT_CD                                
                    ,AT.CODE_DISC_OK                                    
                    ,AT.DATE_BILL_DAY_00                                
                    ,AT.DATE_BILL_DAY_30                                
                    ,AT.DATE_BILL_DAY_60                                
                    ,AT.DATE_BILL_DAY_90                                
                    ,AT.COMPANY_NO                                      
                    ,AT.BANKRUPTCY_IND                                  
                    ,AT.CREDIT_GROUP                                    
                    ,AT.IVR_EXEMPT_CD                                   
                    ,AT.MST_SUB_ACCT_IND                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                 
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODE-CRIT-OUTAGE                               
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND           
                    ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND           
                    ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND           
                    ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND           
                    ,:AT-COMPANY-NO                                     
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-ACCT-FINALED-DT :WS-FINAL-NULL-IND              
                FROM CSS_ACCOUNT AT                                     
               WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
                 AND AT.CODE_ACCT_STAT <> 'J'                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.CODE_CRIT_OUTAGE                                        
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CODE-CRIT-OUTAGE                                       
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00:WS-DATE-BILL-00-IND                   
MFA-TR*             ,:AT-DATE-BILL-DAY-30:WS-DATE-BILL-30-IND                   
MFA-TR*             ,:AT-DATE-BILL-DAY-60:WS-DATE-BILL-60-IND                   
MFA-TR*             ,:AT-DATE-BILL-DAY-90:WS-DATE-BILL-90-IND                   
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-FINAL-NULL-IND                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*          AND AT.CODE_ACCT_STAT <> 'J'                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               MOVE WS-ACTIVE-RETURN-CODE        TO WS-RETURN-CODE1     
               IF WS-FINAL-NULL-IND < 0                                 
                  MOVE SPACES                    TO AT-ACCT-FINALED-DT  
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE SQLCODE                      TO ABEND-SQLCODE       
               MOVE SQLSTATE                     TO ABEND-SQLSTATE      
               MOVE '7000A'                      TO ACTIVE-PARAGRAPH    
               MOVE 'SELECT'                     TO ABEND-FUNCTION      
               MOVE 'CSS_ACCOUNT'                TO TABLE-1             
               MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
               MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
               PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT         
      *        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                 
      *        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7000B-SELECT-CSS-ACCOUNT                                      *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *     SELECTS CSS_ACCOUNT                                       *         
      *****************************************************************         
       7000B-SELECT-CSS-ACCOUNT.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.CODES_DATA_PRESENT                              
                    ,AT.CODE_ACCT_STAT                                  
                    ,AT.CUSTOMER_NO                                     
                    ,AT.ACCOUNT_TYPE_CODE                               
                    ,AT.LOCAL_OFFICE                                    
                    ,AT.PREMISE_NO                                      
                    ,AT.TOTAL_AR_BALANCE                                
                    ,AT.CODE_CRIT_OUTAGE                                
                    ,AT.NOTICE_EXEMPT_CD                                
                    ,AT.CODE_DISC_OK                                    
                    ,AT.DATE_BILL_DAY_00                                
                    ,AT.DATE_BILL_DAY_30                                
                    ,AT.DATE_BILL_DAY_60                                
                    ,AT.DATE_BILL_DAY_90                                
                    ,AT.COMPANY_NO                                      
                    ,AT.BANKRUPTCY_IND                                  
                    ,AT.CREDIT_GROUP                                    
                    ,AT.IVR_EXEMPT_CD                                   
                    ,AT.MST_SUB_ACCT_IND                                
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           AT.ACCT_FINALED_DT, 121), ' ', '-'), ':', '.') 
           ACCT_FINALED_DT                                 
                INTO :AT-CODES-DATA-PRESENT                             
                    ,:AT-CODE-ACCT-STAT                                 
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-ACCOUNT-TYPE-CODE                              
                    ,:AT-LOCAL-OFFICE                                   
                    ,:AT-PREMISE-NO                                     
                    ,:AT-TOTAL-AR-BALANCE                               
                    ,:AT-CODE-CRIT-OUTAGE                               
                    ,:AT-NOTICE-EXEMPT-CD                               
                    ,:AT-CODE-DISC-OK                                   
                    ,:AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND           
                    ,:AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND           
                    ,:AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND           
                    ,:AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND           
                    ,:AT-COMPANY-NO                                     
                    ,:AT-BANKRUPTCY-IND                                 
                    ,:AT-CREDIT-GROUP                                   
                    ,:AT-IVR-EXEMPT-CD                                  
                    ,:AT-MST-SUB-ACCT-IND                               
                    ,:AT-ACCT-FINALED-DT :WS-FINAL-NULL-IND              
                FROM CSS_ACCOUNT AT                                     
               WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AT.CODES_DATA_PRESENT                                      
MFA-TR*             ,AT.CODE_ACCT_STAT                                          
MFA-TR*             ,AT.CUSTOMER_NO                                             
MFA-TR*             ,AT.ACCOUNT_TYPE_CODE                                       
MFA-TR*             ,AT.LOCAL_OFFICE                                            
MFA-TR*             ,AT.PREMISE_NO                                              
MFA-TR*             ,AT.TOTAL_AR_BALANCE                                        
MFA-TR*             ,AT.CODE_CRIT_OUTAGE                                        
MFA-TR*             ,AT.NOTICE_EXEMPT_CD                                        
MFA-TR*             ,AT.CODE_DISC_OK                                            
MFA-TR*             ,AT.DATE_BILL_DAY_00                                        
MFA-TR*             ,AT.DATE_BILL_DAY_30                                        
MFA-TR*             ,AT.DATE_BILL_DAY_60                                        
MFA-TR*             ,AT.DATE_BILL_DAY_90                                        
MFA-TR*             ,AT.COMPANY_NO                                              
MFA-TR*             ,AT.BANKRUPTCY_IND                                          
MFA-TR*             ,AT.CREDIT_GROUP                                            
MFA-TR*             ,AT.IVR_EXEMPT_CD                                           
MFA-TR*             ,AT.MST_SUB_ACCT_IND                                        
MFA-TR*             ,AT.ACCT_FINALED_DT                                         
MFA-TR*         INTO :AT-CODES-DATA-PRESENT                                     
MFA-TR*             ,:AT-CODE-ACCT-STAT                                         
MFA-TR*             ,:AT-CUSTOMER-NO                                            
MFA-TR*             ,:AT-ACCOUNT-TYPE-CODE                                      
MFA-TR*             ,:AT-LOCAL-OFFICE                                           
MFA-TR*             ,:AT-PREMISE-NO                                             
MFA-TR*             ,:AT-TOTAL-AR-BALANCE                                       
MFA-TR*             ,:AT-CODE-CRIT-OUTAGE                                       
MFA-TR*             ,:AT-NOTICE-EXEMPT-CD                                       
MFA-TR*             ,:AT-CODE-DISC-OK                                           
MFA-TR*             ,:AT-DATE-BILL-DAY-00:WS-DATE-BILL-00-IND                   
MFA-TR*             ,:AT-DATE-BILL-DAY-30:WS-DATE-BILL-30-IND                   
MFA-TR*             ,:AT-DATE-BILL-DAY-60:WS-DATE-BILL-60-IND                   
MFA-TR*             ,:AT-DATE-BILL-DAY-90:WS-DATE-BILL-90-IND                   
MFA-TR*             ,:AT-COMPANY-NO                                             
MFA-TR*             ,:AT-BANKRUPTCY-IND                                         
MFA-TR*             ,:AT-CREDIT-GROUP                                           
MFA-TR*             ,:AT-IVR-EXEMPT-CD                                          
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-ACCT-FINALED-DT:WS-FINAL-NULL-IND                      
MFA-TR*         FROM CSS_ACCOUNT AT                                             
MFA-TR*        WHERE AT.ACCOUNT_NO      = :AT-ACCOUNT-NO                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               MOVE WS-ACTIVE-RETURN-CODE        TO WS-RETURN-CODE1     
               IF WS-FINAL-NULL-IND < 0                                 
                  MOVE SPACES                    TO AT-ACCT-FINALED-DT  
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE SQLCODE                      TO ABEND-SQLCODE       
               MOVE SQLSTATE                     TO ABEND-SQLSTATE      
               MOVE '7000B'                      TO ACTIVE-PARAGRAPH    
               MOVE 'SELECT'                     TO ABEND-FUNCTION      
               MOVE 'CSS_ACCOUNT'                TO TABLE-1             
               MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1     
               MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
               PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT         
      *        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                 
      *        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                         
       7000B-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-SELECT-CRED-PROF                                          *        
      ******************************************************************        
       7100-SELECT-CRED-PROF.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT CASH_ONLY_FL                                       
              INTO  :CZ-CASH-ONLY-FL                                    
              FROM   CSS_CREDIT_PROFILE                                 
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 IF CZ-CASH-ONLY-FL = 'Y'                               
                    MOVE 'Y'                    TO S-CASH-ONLY          
                 ELSE                                                   
                    MOVE 'N'                    TO S-CASH-ONLY          
                 END-IF                                                 
              ELSE                                                      
                    MOVE 'N'                    TO S-CASH-ONLY          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '7100'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_CRED_PROFILE'           TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7150-SELECT-AR-CNTL                                            *        
      ******************************************************************        
       7150-SELECT-AR-CNTL.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
              INTO  :AC-ACCOUNT-NO                                      
              FROM   CSS_AR_CNTL AC                                     
              WHERE  ACCOUNT_NO = :AT-ACCOUNT-NO                        
                AND  PYMT_PRIORITY_LVL IN (20,29)                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
                                      MULTIPLE-ROWS                     
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                    MOVE 'N'                    TO S-CASH-ONLY          
              ELSE                                                      
                    MOVE 'Y'                    TO S-CASH-ONLY          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '7150'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL'                TO TABLE-1              
              MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7150-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************53980000
      * 7200-GET-NAME                                                  *53990000
      *                                                                *54000000
      *     GET CUSTOMER'S NAME.                                       *54010000
      *                                                                *54020000
      ******************************************************************54030000
       7200-GET-NAME.                                                   
      *                                                                 54060000
           EXEC SQL                                                     
               SELECT TOP(1) NAME_TYPE,
              NAME_FORMAT,
              LAST_NAME,
              FIRST_NAME,
              MIDDLE_NAME,
              TITLE_PREFIX,
              TITLE_SUFFIX_1,
              TITLE_SUFFIX_2,
              FULL_NAME                                         
                INTO :DQ-NAME-TYPE,                                     
                     :DQ-NAME-FORMAT,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-TITLE-PREFIX,                                  
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-TITLE-SUFFIX-2,                                
                     :DQ-FULL-NAME                                      
                 FROM CSS_NAME                                          
                WHERE NAME_ID      = :CU-NAME-ID                        
                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     54070000
MFA-TR*        SELECT NAME_TYPE,                                        54080000
MFA-TR*               NAME_FORMAT,                                      54090000
MFA-TR*               LAST_NAME,                                        54100000
MFA-TR*               FIRST_NAME,                                       54110000
MFA-TR*               MIDDLE_NAME,                                      54120000
MFA-TR*               TITLE_PREFIX,                                     54130000
MFA-TR*               TITLE_SUFFIX_1,                                   54140000
MFA-TR*               TITLE_SUFFIX_2,                                   54150000
MFA-TR*               FULL_NAME                                         54160000
MFA-TR*         INTO :DQ-NAME-TYPE,                                     54170000
MFA-TR*              :DQ-NAME-FORMAT,                                   54180000
MFA-TR*              :DQ-LAST-NAME,                                     54190000
MFA-TR*              :DQ-FIRST-NAME,                                    54200000
MFA-TR*              :DQ-MIDDLE-NAME,                                   54210000
MFA-TR*              :DQ-TITLE-PREFIX,                                  54220000
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                54230000
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                54240000
MFA-TR*              :DQ-FULL-NAME                                      54250000
MFA-TR*          FROM CSS_NAME                                          54260000
MFA-TR*         WHERE NAME_ID      = :CU-NAME-ID                        54270000
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*    END-EXEC.                                                    54280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 54290000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
                  MOVE SPACE TO DQ-NAME-TYPE                            
                                DQ-NAME-FORMAT                          
                                DQ-LAST-NAME                            
                                DQ-FIRST-NAME                           
                                DQ-MIDDLE-NAME                          
                                DQ-TITLE-PREFIX                         
                                DQ-TITLE-SUFFIX-1                       
                                DQ-TITLE-SUFFIX-2                       
                                DQ-FULL-NAME                            
               ELSE                                                     
                  MOVE PROGRAM-NAME                TO ABEND-PROGRAM     
                  MOVE SQLCODE                     TO ABEND-SQLCODE     
                  MOVE SQLSTATE                    TO ABEND-SQLSTATE    
                  MOVE '7200'                      TO ACTIVE-PARAGRAPH  
                  MOVE 'SELECT'                    TO ABEND-FUNCTION    
                  MOVE 'CSS_NAME'                  TO TABLE-1           
                  MOVE 'NAME_ID'                   TO TABLE-ELEMENT-1   
                  MOVE CU-NAME-ID                  TO HOSTVAR-ELEMENT-1 
                  PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT      
      *           PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT              
      *           PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT              
               END-IF                                                   
           END-IF.                                                      
      *                                                                 54590000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                 54590000
      ******************************************************************38810000
      * 7300-GET-CUST-DTLS                                             *38820000
      *     GET CUSTOMER DETAILS.                                      *38840000
      ******************************************************************38860000
       7300-GET-CUST-DTLS.                                              
      *                                                                 38890000
           EXEC SQL                                                     
               SELECT CU.NAME_ID,                                       
                      CU.SERVICE_EST_DATE                               
                INTO :CU-NAME-ID,                                       
                     :CU-SERVICE-EST-DATE :WS-SERVC-NULL-IND             
                FROM CSS_CUSTOMER CU                                    
                WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE SQLCODE                      TO ABEND-SQLCODE       
               MOVE SQLSTATE                     TO ABEND-SQLSTATE      
               MOVE '7300'                       TO ACTIVE-PARAGRAPH    
               MOVE 'SELECT'                     TO ABEND-FUNCTION      
               MOVE 'CSS_CUSTOMER'               TO TABLE-1             
               MOVE 'CUSTOMER_NO'                TO TABLE-ELEMENT-1     
               MOVE AT-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1   
               PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT         
      *        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                 
      *        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                 39080000
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39110000
      ******************************************************************        
      * 7400-SELECT-CUST-STATS                                         *        
      *     SELECTS A ROW FROM THE CSS_CUST_STATS TABLE                *        
      ******************************************************************        
       7400-SELECT-CUST-STATS.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT CE.SSN                                             
                    ,CE.PASSWORD_TX                                     
C32309              ,CE.REFUSED_SSN_FL                                  
              INTO  :CE-SSN                                             
                   ,:CE-PASSWORD-TX                                     
C32309             ,:CE-REFUSED-SSN-FL                                  
              FROM   CSS_CUST_STATS CE                                  
              WHERE  CE.CUSTOMER_NO     = :AT-CUSTOMER-NO               
              AND    CE.CUSTOMER_TYPE   = :WS-C                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE CE-SSN                  TO S-CUST-SSN             
C32309           MOVE CE-REFUSED-SSN-FL       TO S-REFUSED-SSN-FL       
              ELSE                                                      
                 MOVE SPACES                  TO S-CUST-SSN             
                                                ,CE-PASSWORD-TX         
C32309                                          ,S-REFUSED-SSN-FL       
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '7400'                       TO ACTIVE-PARAGRAPH     
              MOVE 'CSS_CUST_STATS'             TO TABLE-1              
              MOVE 'CUSTOMER-NO'                TO TABLE-ELEMENT-1      
              MOVE AT-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-SELECT-CUST-PHONE                                        *         
      *    SELECTS ROWS FROM CSS_CUST_PHONE                           *         
      ******************************************************************        
       7500-SELECT-CUST-PHONE.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT CB.PHONE_NO                                        
              INTO  :CB-PHONE-NO                                        
              FROM  CSS_CUST_PHONE CB                                   
              WHERE  CB.CUSTOMER_NO     = :AT-CUSTOMER-NO               
              AND    CB.CUSTOMER_TYPE   = :WS-C                         
              AND    CB.PHONE_TYPE      = :WS-PHONE-TYPE                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
           OR                         NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE '7500'                       TO ACTIVE-PARAGRAPH     
              MOVE 'CSS_CUST_PHONE'             TO TABLE-1              
              MOVE 'CUSTOMER-NO'                TO TABLE-ELEMENT-1      
              MOVE 'PHONE_TYPE'                 TO TABLE-ELEMENT-2      
              MOVE AT-CUSTOMER-NO               TO HOSTVAR-ELEMENT-1    
              MOVE WS-PHONE-TYPE                TO HOSTVAR-ELEMENT-2    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************38810000
      * 7600-GET-PREM-DTLS                                             *38820000
      *     GET PREMISE  DETAILS.                                      *38840000
      ******************************************************************38860000
       7600-GET-PREM-DTLS.                                              
      *                                                                 38890000
           EXEC SQL                                                     
               SELECT PR.REV_DISTRICT_CD,                               
                      PR.COUNTY,                                        
                      PR.ADDRESS_ID,                                    
                      PR.ADDRESS_FORMAT                                 
                INTO :PR-REV-DISTRICT-CD,                               
                     :PR-COUNTY,                                        
                     :PR-ADDRESS-ID,                                    
                     :PR-ADDRESS-FORMAT                                 
                FROM CSS_PREMISE  PR                                    
                WHERE PREMISE_NO = :AT-PREMISE-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 38930000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                 38950000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE PR-REV-DISTRICT-CD         TO S-REV-DISTRICT-CD   
                 MOVE PR-COUNTY                  TO S-COUNTY            
              ELSE                                                      
                 MOVE SPACES                     TO S-REV-DISTRICT-CD   
                 MOVE SPACES                     TO S-COUNTY            
              END-IF                                                    
           ELSE                                                         
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE SQLCODE                      TO ABEND-SQLCODE       
               MOVE SQLSTATE                     TO ABEND-SQLSTATE      
               MOVE '7600'                       TO ACTIVE-PARAGRAPH    
               MOVE 'SELECT'                     TO ABEND-FUNCTION      
               MOVE 'CSS_PREMISE'                TO TABLE-1             
               MOVE 'PREMISE_NO'                 TO TABLE-ELEMENT-1     
               MOVE AT-PREMISE-NO                TO HOSTVAR-ELEMENT-1   
               PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT         
      *        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                 
      *        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                 
           END-IF.                                                      
      *                                                                 39080000
       7600-EXIT.                                                       
           EXIT.                                                        
      *                                                                 39110000
      ******************************************************************        
      * 7700-SELECT-ADDR-FORM                                          *        
      *     RETRIEVE THE FORMATTED ADDRESS DETAILS.                    *        
      ******************************************************************        
       7700-SELECT-ADDR-FORM.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  HOUSE_NO,                                         
                      ADDR_PREFIX_1,                                    
                      ADDR_PREFIX_2,                                    
                      STREET_NAME,                                      
                      STREET_SUFFIX,                                    
                      STREET_LOCATION_1,                                
                      STREET_LOCATION_2,                                
                      ADDRESS_OVERFLOW,                                 
                      ZIP_CODE,                                         
                      ZIP_CODE_PLUS_FOUR,                               
                      ZIP_CODE_TOKEN,                                   
                      ADDR_SUFFIX,                                      
                      CARRIER_ROUTE                                     
              INTO    :DY-HOUSE-NO,                                     
                      :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-STREET-NAME,                                  
                      :DY-STREET-SUFFIX,                                
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-ADDRESS-OVERFLOW,                             
                      :DY-ZIP-CODE,                                     
                      :DY-ZIP-CODE-PLUS-FOUR,                           
                      :DY-ZIP-CODE-TOKEN,                               
                      :DY-ADDR-SUFFIX,                                  
                      :DY-CARRIER-ROUTE                                 
              FROM    CSS_ADDR_FORMATTED                                
              WHERE   ADDRESS_ID                = :PR-ADDRESS-ID        
              AND     ADDR_USAGE_CD             = :WS-F                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '7700'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_ADDR_FORMATTED'         TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE PR-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7800-SELECT-ADDR-FREE                                          *        
      *     RETRIEVE THE FREEFORM ADDRESS DETAILS.                     *        
      ******************************************************************        
       7800-SELECT-ADDR-FREE.                                           
      *                                                                         
           EXEC SQL                                                     
              SELECT  ADDR_STREET,                                      
                      ADDRESS_OVERFLOW,                                 
                      ADDR_CITY_STATE,                                  
                      ADDR_ZIP_CODE,                                    
                      ADDR_COUNTRY                                      
              INTO    :DZ-ADDR-STREET,                                  
                      :DZ-ADDRESS-OVERFLOW,                             
                      :DZ-ADDR-CITY-STATE,                              
                      :DZ-ADDR-ZIP-CODE,                                
                      :DZ-ADDR-COUNTRY                                  
              FROM    CSS_ADDR_FREEFORM                                 
              WHERE   ADDRESS_ID                = :PR-ADDRESS-ID        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '7800'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_ADDR_FREEFORM'          TO TABLE-1              
              MOVE 'ADDRESS_ID'                 TO TABLE-ELEMENT-1      
              MOVE PR-ADDRESS-ID                TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7900-SELECT-TOWN-ST                                            *        
      *     RETRIEVE THE TOWN AND STATE FOR A GIVEN ZIP CODE.          *        
      ******************************************************************        
       7900-SELECT-TOWN-ST.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT  TOWN,                                             
                      STATE                                             
              INTO    :A4-TOWN,                                         
                      :A4-STATE                                         
              FROM    CSS_ZIP_CODE                                      
              WHERE   ZIP_CODE                  = :DY-ZIP-CODE          
                AND   ZIP_CODE_TOKEN            = :DY-ZIP-CODE-TOKEN    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE A4-TOWN                   TO S-CITY               
                 MOVE A4-STATE                  TO S-STATE              
              ELSE                                                      
                 MOVE SPACES                    TO S-CITY               
                 MOVE SPACES                    TO S-STATE              
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '7900'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_ZIP_CODE'               TO TABLE-1              
              MOVE 'ZIP_CODE'                   TO TABLE-ELEMENT-1      
              MOVE 'ZIP_CODE_TOKEN'             TO TABLE-ELEMENT-2      
              MOVE DY-ZIP-CODE                  TO HOSTVAR-ELEMENT-1    
              MOVE DY-ZIP-CODE-TOKEN            TO HOSTVAR-ELEMENT-2    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       7900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000-SELECT-WQ                                                 *        
      *     SELECTS ACTIVE/INPROGRESS BILL EXCEPTION WQ'S.             *        
      ******************************************************************        
       8000-SELECT-WQ.                                                  
      *                                                                         
           EXEC SQL                                                     
              SELECT  WQ.ACCOUNT_NO                                     
              INTO    :WQ-ACCOUNT-NO                                    
              FROM    CSS_WQ_ITEMS WQ                                   
              WHERE  WQ.ACCOUNT_NO             = :AT-ACCOUNT-NO         
                AND  STATUS                    IN ('A','I')             
                AND  CATEGORY_ID               IN (17,137,138,139)      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS  
                                      OR NOT-FOUND                      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR MULTIPLE-ROWS
                 MOVE 'Y'                       TO WS-WQ-EXIST          
              ELSE                                                      
                 MOVE 'N'                       TO WS-WQ-EXIST          
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '8000'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_WQ_ITEMS'               TO TABLE-1              
              MOVE 'ACCOUNT-NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8100-SELECT-REVMNTH                                           *         
      *     SELECTS CURRENT REVENUE MONTH FROM CSS_JOB_PARM            *        
      ******************************************************************        
       8100-SELECT-REVMNTH.                                             
      *                                                                         
           EXEC SQL                                                     
              SELECT  PARM_DATA                                         
              INTO    :G6-PARM-DATA                                     
              FROM    CSS_JOB_PARM G6                                   
              WHERE  PROGRAM_NAME          = 'COMMON'                   
                AND  COMPANY_NO            = '01'                       
                AND  CMND_CODE             = 'DATE'                     
                AND  SEQ_NO                = 20                         
                AND  STATUS                = 'A'                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE G6-PARM-DATA                 TO WS-PARM-DATA         
              MOVE WS-PARM-REVMNTH              TO WS-REV-MNTH          
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '8100'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_JOB_PARM'               TO TABLE-1              
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8200-SELECT-CANREBIL-ROW                                       *        
      *     SELECTS CANCEL/REBILL ROWS IN LAST 2 MONTHS(IF EXISTS)     *        
      ******************************************************************        
       8200-SELECT-CANREBIL-ROW.                                        
      *                                                                         
           EXEC SQL                                                     
              SELECT  DISTINCT(ACCOUNT_NO)                              
              INTO    :BG-ACCOUNT-NO                                    
              FROM    CSS_BILLING_DET BG                                
              WHERE  ACCOUNT_NO         = :AT-ACCOUNT-NO                
                AND  REV_MTH_ORIG_BILL >= :WS-REV-MTH-LOWER-LIMIT       
                AND  REV_MTH_ORIG_BILL <= :WS-REV-MTH-UPPER-LIMIT       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
             IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
                 MOVE 'Y'                       TO WS-CANREBIL-EXIST    
              ELSE                                                      
                 MOVE 'N'                       TO WS-CANREBIL-EXIST    
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '8200'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_BILLING_DET'            TO TABLE-1              
              MOVE 'ACCOUNT-NO'                 TO TABLE-ELEMENT-1      
              MOVE AT-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8300-GET-DATABASE                                              *        
      *     SELECTS THE CURRENT DATABASE                               *        
      ******************************************************************        
       8300-GET-DATABASE.                                               
      *                                                                         
           EXEC SQL                                                     
              SELECT  DELINQ_VALUE                                      
              INTO    :C8-DELINQ-VALUE                                  
              FROM    CSS_DELINQUENCY                                   
              WHERE   DELINQ_CD  = :C8-DELINQ-CD                        
              AND     COMPANY_NO = :C8-COMPANY-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
              MOVE SQLCODE                      TO ABEND-SQLCODE        
              MOVE SQLSTATE                     TO ABEND-SQLSTATE       
              MOVE '8300'                       TO ACTIVE-PARAGRAPH     
              MOVE 'SELECT'                     TO ABEND-FUNCTION       
              MOVE 'CSS_DELINQUENCY'            TO TABLE-1              
              MOVE 'DELINQ_CD'                  TO TABLE-ELEMENT-1      
              MOVE C8-DELINQ-CD                 TO HOSTVAR-ELEMENT-1    
              PERFORM 8888-PROCESS-BAD-RET-CODE THRU 8888-EXIT          
      *       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                  
      *       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                  
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05630000
      * 8888-PROCESS-BAD-RET-CODE                                       05620000
      ******************************************************************        
       8888-PROCESS-BAD-RET-CODE.                                       

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-1)) + ',' + 
           LTRIM(RTRIM(:TABLE-2)) + ',' + LTRIM(RTRIM(:TABLE-3)) + 
           ',' + LTRIM(RTRIM(:TABLE-4)) + ',' + 'ERRMSG-' + 
           LTRIM(RTRIM(:ABEND-SQLERRMC))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
      *                                                                         
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-1) CONCAT         
MFA-TR*              ',' CONCAT STRIP(:TABLE-2) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-3) CONCAT                          
MFA-TR*              ',' CONCAT STRIP(:TABLE-4) CONCAT                          
MFA-TR*              ',' CONCAT 'ERRMSG-' CONCAT STRIP(:ABEND-SQLERRMC)         
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
      *                                                                         
       8888-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************05630000
      * 9500-CALL-CPD00068                                              05620000
      ******************************************************************        
       9500-CALL-CPD00068.                                              
      *                                                                         
           MOVE '9500' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           CALL MCSCB068  USING  CWS00068-FIELDS                        
                                 WS-CODES-DATA-PRESENT                  
                                 DCLCSS-ACCOUNT                         
                                 ABEND-FILE                             
                                 WS-RETURN-CODE.                        
           MOVE WS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
                                             S-RETURN-CODE,             
                                             SQLCODE.                   
           IF ABEND-FUNCTION  > SPACES                                  
              IF ABEND-FUNCTION EQUAL 'BADDATA'                         
                 MOVE -1                    TO WS-RETURN-CODE,          
                                               WS-ACTIVE-RETURN-CODE    
              END-IF                                                    
              MOVE WS-RETURN-CODE           TO WS-RETURN-CODE1          
              PERFORM 2300-PROCESS-OUTPUT   THRU 2300-EXIT              
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       9500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND - COMBINED ERROR HANDLING INCLUDE           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************05630000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     05640000
      ******************************************************************05650000
      *                                                                         
           EXEC SQL                                                     05660000
              INCLUDE CPDSP300                                          05670000
           END-EXEC.                                                    05680000
      *                                                                 05690000
      ******************************************************************00048000
      *   8900-SEND-DONE                                               *00049000
      ******************************************************************00050000
       8900-SEND-DONE.                                                  
      *                                                                 00070000
           IF PARM-CALL-TYPE = WS-B                                     
APS        OR PARM-CALL-TYPE = WS-A                                     
              PERFORM 8900-SEND-C1 THRU 8900-C1-EXIT                    
           ELSE                                                         
              PERFORM 8900-SEND-C2 THRU 8900-C2-EXIT                    
           END-IF.                                                      
      *                                                                 00070000
       8900-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************00048000
      *   8900-SEND-C1                                                  00049000
      ******************************************************************00050000
       8900-SEND-C1.                                                    
      *                                                                 00070000
              EXEC SQL                                                  
                  OPEN C1                                               
              END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                 
      *                                                                 00070000
       8900-C1-EXIT.                                                    
           EXIT.                                                        
      ******************************************************************00048000
      *   8900-SEND-C2                                                  00049000
      ******************************************************************00050000
       8900-SEND-C2.                                                    
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                 00110000
       8900-C2-EXIT.                                                    
           EXIT.                                                        
      ******************************************************************00140000
      * 9000-SEND-ERROR-RESULT                                         *00150000
      ******************************************************************00160000
       9000-SEND-ERROR-RESULT.                                          
      *                                                                 00180000
           MOVE WS-N                  TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                 00240001
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 00300000
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                 00341100
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 00341700
      ******************************************************************00341800
      *   9999-END-PROGRAM                                             *00341900
      ******************************************************************00342000
      *                                                                 00343000
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************00347000
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *00348000
      ******************************************************************00349000
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
