       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03287.                                     
COB303 DATE-WRITTEN.     JUNE 01, 2003.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03287              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03287 :                                                --         
      *--                                                            --         
      *--  #  RETRIEVES EDI BILL HEADER ROW WITH THE CRITERIA        --         
      *--     PROVIDED IN PROGRAM FOR BIZ TALK.                      --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--            ACCOUNT_NO            CHAR(13)                  --         
      *--            SCHED_SENT_DT         CHAR(10)                  --         
      *--            STATUS_CD             CHAR(10)                  --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  02 JUN 2003   PD80186     NEW CODE                        --         
      *--  01 SEP 2004   RS40309     ADD ESTIMATED FL AND REVENUE MO --         
C36867*--  25 APR 2008   RS40309     ADD AGL ACCOUNT NUMBER          --         
A04083*--  30 JAN 2013   AP40911     FOR CHECKFREE E-BILL WHEN THERE --         
      *--                            IS CREDIT OR ZERO BALANCE ON THE--         
      *--                            ACCOUNT MOVE APPROPRIATE TEXT   --         
      *--                            TO DUE DATE TEXT.                          
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03287'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBILHDR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACDEST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBEDIDES                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBATMISC                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
A04083     EXEC SQL                                                             
A04083       INCLUDE TBCDVALU                                                   
A04083     END-EXEC.                                                            
                                                                        
      *                                                                         
                                                                        
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03287'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR03287_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           10 S-ACCOUNT-NO           PIC X(13) VALUE SPACES.            
           10 S-AMT-DUE              PIC S9(9)V9(2) USAGE COMP-3        
                                     VALUE 0.                           
           10 S-BILL-DUE-DATE        PIC X(10) VALUE SPACES.            
           10 S-BILL-NO              PIC S9(9) USAGE COMP               
                                     VALUE 0.                           
           10 S-CODE-STATE-ID        PIC X(2) VALUE SPACES.             
           10 S-CUSTOMER-NA-TEXT     PIC X(60) VALUE SPACES.            
           10 S-DATE-BILLED          PIC X(10) VALUE SPACES.            
           10 S-DATE-CREATED         PIC X(10) VALUE SPACES.            
           10 S-DATE-READ            PIC X(10) VALUE SPACES.            
           10 S-EXTRACTED-FL         PIC X(1) VALUE SPACES.             
           10 S-EXTRACTED-TS         PIC X(26) VALUE SPACES.            
           10 S-LAST-UPDATE-TS       PIC X(26) VALUE SPACES.            
           10 S-LAST-UPD-USERID      PIC X(7) VALUE SPACES.             
           10 S-MST-ACCT-NO          PIC X(13) VALUE SPACES.            
           10 S-MST-SUB-ACCT-IND     PIC X(1) VALUE SPACES.             
           10 S-PURPOSE-CD           PIC X(2) VALUE SPACES.             
           10 S-SCHED-SEND-DT        PIC X(10) VALUE SPACES.            
           10 S-STATUS-CD            PIC X(1) VALUE SPACES.             
           10 S-STREET-ADDR-1        PIC X(55) VALUE SPACES.            
           10 S-STREET-ADDR-2        PIC X(55)  VALUE SPACES.           
           10 S-TRANS-CD             PIC X(1)   VALUE SPACES.           
           10 S-UPDATE-IND           PIC X(1)   VALUE SPACES.           
           10 S-ZIP-CODE             PIC X(9)   VALUE SPACES.           
RS0901     10 S-REVENUE-MONTH        PIC X(6)   VALUE SPACES.           
RS0901     10 S-ESTIMATED-FL         PIC X(1)   VALUE SPACES.           
C36867     10 S-DIST-ACCT-NO         PIC X(20)  VALUE SPACES.           
           10 S-EDI-TP-FL            PIC X(01)  VALUE SPACES.           
           10 S-FORMAT-TYPE          PIC X(01)  VALUE SPACES.           
           10 S-HTTP-ADDR            PIC X(255) VALUE SPACES.           
           10 S-TP-AUTO-EMAIL-FL     PIC X(01)  VALUE SPACES.           
           10 S-TP-EDI-ID-QUAL       PIC X(02)  VALUE SPACES.           
           10 S-TP-EDI-RECEIVER-ID   PIC X(15)  VALUE SPACES.           
           10 S-TP-EMAIL-GROUP       PIC X(30)  VALUE SPACES.           
           10 S-AUTOMATIC-EMAIL-FL   PIC X(01)  VALUE SPACES.           
           10 S-EDI-ID-QUAL          PIC X(02)  VALUE SPACES.           
           10 S-EDI-RECEIVER-ID      PIC X(15)  VALUE SPACES.           
           10 S-EMAIL-GROUP          PIC X(30)  VALUE SPACES.           
           10 S-CITY                 PIC X(26)  VALUE SPACES.           
           10 S-ADDL-BILL-NM         PIC X(35)  VALUE SPACES.           
A04083     10 S-PYMT-DUE-TXT-FL      PIC X(1)   VALUE SPACES.           
A04083     10 S-PYMT-DUE-TEXT        PIC X(15)  VALUE SPACES.           
      *                                                                         
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
           05  WS-PARM-ACCOUNT-NO      PIC 9(13) VALUE ZERO.            
           05  WS-AMT-DUE              PIC 9(11)V9(2) VALUE 0.          
           05  WS-AMT-DUE-T            PIC 9(13) VALUE 0.               
           05  WS-MST-ACCT-NO          PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-ACCOUNT-NO-L         PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-ACCOUNT-NO-H         PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-STATUS-CD-L          PIC X(01) VALUE SPACES.          
           05  WS-STATUS-CD-H          PIC X(01) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-L      PIC X(10) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-H      PIC X(10) VALUE SPACES.          
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-2     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND-BILL-DUE    PIC S9(04) COMP VALUE +0.        
           05  WS-DEST-ID              PIC X(10).                       
A04083     05  WS-PYMT-DUE-TEXT        PIC X(15) VALUE SPACES.          
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
      *                                                                         
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
              DECLARE HDR1_CURSOR CURSOR FOR                            
                SELECT                                                  
                      HZ.ACCOUNT_NO                                     
                     ,HZ.AMT_DUE                                        
                     ,HZ.BILL_DUE_DATE                                  
                     ,HZ.BILL_NO                                        
                     ,HZ.CODE_STATE_ID                                  
                     ,HZ.CUSTOMER_NA                                    
                     ,HZ.DATE_BILLED                                    
                     ,HZ.DATE_CREATED                                   
                     ,HZ.DATE_READ                                      
                     ,HZ.EXTRACTED_FL                                   
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), HZ.EXTRACTED_TS
           , 121), ' ', '-'), ':', '.') EXTRACTED_TS                           
                     ,REPLACE(REPLACE(CONVERT(CHAR(26), 
           HZ.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS        
                     ,HZ.LAST_UPDATE_USERID                             
                     ,HZ.MST_ACCT_NO                                    
                     ,HZ.MST_SUB_ACCT_IND                               
                     ,HZ.PURPOSE_CD                                     
                     ,HZ.SCHED_SEND_DT                                  
                     ,HZ.STATUS_CD                                      
                     ,HZ.STREET_ADDR_1                                  
                     ,HZ.STREET_ADDR_2                                  
                     ,HZ.TRANS_CD                                       
                     ,HZ.UPDATE_IND                                     
                     ,HZ.ZIP_CODE                                       
RS0901               ,HZ.REVENUE_MONTH                                  
RS0901               ,HZ.ESTIMATED_FL                                   
C36867               ,HZ.DIST_ACCT_NO                                   
                     ,NJ.EDI_TP_FL                                      
                     ,NJ.FORMAT_TYPE                                    
                     ,NJ.HTTP_ADDR                                      
                     ,NJ.TP_AUTO_EMAIL_FL                               
                     ,NJ.TP_EDI_ID_QUAL                                 
                     ,NJ.TP_EDI_RECEIVER_ID                             
                     ,NJ.TP_EMAIL_GROUP                                 
                     ,NF.AUTOMATIC_EMAIL_FL                             
                     ,NF.EDI_ID_QUAL                                    
                     ,NF.EDI_RECEIVER_ID                                
                     ,NF.EMAIL_GROUP                                    
                FROM CSS_EDI_BILL_HDR  HZ                               
                    ,CSS_EDI_ACCT_DEST NF                               
                    ,CSS_EDI_DEST      NJ                               
                WHERE HZ.STATUS_CD      IN ('R', 'D')                   
                  AND SCHED_SEND_DT    <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                  AND NJ.DEST_ID        = :WS-DEST-ID                   
                  AND HZ.ACCOUNT_NO     = NF.ACCOUNT_NO                 
                  AND NF.DEST_ID        = NJ.DEST_ID                    
                  AND NF.STAT_BEGIN_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                  AND NF.STAT_END_DT   >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)                  
                  AND NF.STATUS_CD      = 'A'                           
                  AND HZ.MST_SUB_ACCT_IND <> 'S'                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE HDR1_CURSOR CURSOR FOR                                    
MFA-TR*         SELECT                                                          
MFA-TR*               HZ.ACCOUNT_NO                                             
MFA-TR*              ,HZ.AMT_DUE                                                
MFA-TR*              ,HZ.BILL_DUE_DATE                                          
MFA-TR*              ,HZ.BILL_NO                                                
MFA-TR*              ,HZ.CODE_STATE_ID                                          
MFA-TR*              ,HZ.CUSTOMER_NA                                            
MFA-TR*              ,HZ.DATE_BILLED                                            
MFA-TR*              ,HZ.DATE_CREATED                                           
MFA-TR*              ,HZ.DATE_READ                                              
MFA-TR*              ,HZ.EXTRACTED_FL                                           
MFA-TR*              ,HZ.EXTRACTED_TS                                           
MFA-TR*              ,HZ.LAST_UPDATE_TS                                         
MFA-TR*              ,HZ.LAST_UPDATE_USERID                                     
MFA-TR*              ,HZ.MST_ACCT_NO                                            
MFA-TR*              ,HZ.MST_SUB_ACCT_IND                                       
MFA-TR*              ,HZ.PURPOSE_CD                                             
MFA-TR*              ,HZ.SCHED_SEND_DT                                          
MFA-TR*              ,HZ.STATUS_CD                                              
MFA-TR*              ,HZ.STREET_ADDR_1                                          
MFA-TR*              ,HZ.STREET_ADDR_2                                          
MFA-TR*              ,HZ.TRANS_CD                                               
MFA-TR*              ,HZ.UPDATE_IND                                             
MFA-TR*              ,HZ.ZIP_CODE                                               
MFA-TR*              ,HZ.REVENUE_MONTH                                          
MFA-TR*              ,HZ.ESTIMATED_FL                                           
MFA-TR*              ,HZ.DIST_ACCT_NO                                           
MFA-TR*              ,NJ.EDI_TP_FL                                              
MFA-TR*              ,NJ.FORMAT_TYPE                                            
MFA-TR*              ,NJ.HTTP_ADDR                                              
MFA-TR*              ,NJ.TP_AUTO_EMAIL_FL                                       
MFA-TR*              ,NJ.TP_EDI_ID_QUAL                                         
MFA-TR*              ,NJ.TP_EDI_RECEIVER_ID                                     
MFA-TR*              ,NJ.TP_EMAIL_GROUP                                         
MFA-TR*              ,NF.AUTOMATIC_EMAIL_FL                                     
MFA-TR*              ,NF.EDI_ID_QUAL                                            
MFA-TR*              ,NF.EDI_RECEIVER_ID                                        
MFA-TR*              ,NF.EMAIL_GROUP                                            
MFA-TR*         FROM CSS_EDI_BILL_HDR  HZ                               00450010
MFA-TR*             ,CSS_EDI_ACCT_DEST NF                               00450010
MFA-TR*             ,CSS_EDI_DEST      NJ                               00450010
MFA-TR*         WHERE HZ.STATUS_CD      IN ('R', 'D')                           
MFA-TR*           AND SCHED_SEND_DT    <= CURRENT DATE                          
MFA-TR*           AND NJ.DEST_ID        = :WS-DEST-ID                           
MFA-TR*           AND HZ.ACCOUNT_NO     = NF.ACCOUNT_NO                         
MFA-TR*           AND NF.DEST_ID        = NJ.DEST_ID                            
MFA-TR*           AND NF.STAT_BEGIN_DT <= CURRENT DATE                          
MFA-TR*           AND NF.STAT_END_DT   >= CURRENT DATE                          
MFA-TR*           AND NF.STATUS_CD      = 'A'                                   
MFA-TR*           AND HZ.MST_SUB_ACCT_IND <> 'S'                                
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  IN-DEST-ID                  PIC X(10).                       
      *                                                                         
       PROCEDURE DIVISION USING IN-DEST-ID.                             
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------          
      *--  0100A-DECLARE-GTT                                        --          
      *--  DECLARE TEMPORARY TABLE                                  --          
      *---------------------------------------------------------------          
      *                                                                         
       0100A-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR03287_R1'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03287_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03287_R1
              (                                                    
             RETURN_CODE           INT                              
            ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2               
            ,AMT_DUE               DECIMAL(11,2)                       
            ,BILL_DUE_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,BILL_NO               INT                              
            ,CODE_STATE_ID CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2             
            ,CUSTOMER_NA_TEXT CHAR(60)  COLLATE LATIN1_GENERAL_100_BIN2         
            ,DATE_BILLED CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2              
            ,DATE_CREATED CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
            ,DATE_READ CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2                
            ,EXTRACTED_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2              
            ,EXTRACTED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2             
            ,LAST_UPDATE_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2           
            ,LAST_UPD_USERID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2           
            ,MST_ACCT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2              
            ,MST_SUB_ACCT_IND CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
            ,PURPOSE_CD CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2                
            ,SCHED_SEND_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,STATUS_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                 
            ,STREET_ADDR_1 CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,STREET_ADDR_2 CHAR(55)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,TRANS_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                  
            ,UPDATE_IND CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                
            ,ZIP_CODE CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2                  
RS0901      ,REVENUE_MONTH CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2             
RS0901      ,ESTIMATED_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2              
C36867      ,DIST_ACCT_NO CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2             
            ,EDI_TP_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2                 
            ,FORMAT_TYPE CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2               
            ,HTTP_ADDR CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2               
            ,TP_AUTO_EMAIL_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
            ,TP_EDI_ID_QUAL CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2            
            ,TP_EDI_RECEIVER_ID CHAR(15)  COLLATE 
                          LATIN1_GENERAL_100_BIN2                             
            ,TP_EMAIL_GROUP CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2           
            ,AUTOMATIC_EMAIL_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2        
            ,EDI_ID_QUAL CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2               
            ,EDI_RECEIVER_ID CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
            ,EMAIL_GROUP CHAR(30)  COLLATE LATIN1_GENERAL_100_BIN2              
            ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                     
            ,ADDL_BILL_NM CHAR(35)  COLLATE LATIN1_GENERAL_100_BIN2             
A04083      ,PYMT_DUE_TXT_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
A04083      ,PYMT_DUE_TEXT CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2            
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03287_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
               SELECT *                                                 
               FROM #CSR03287_R1                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR03287_R1                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT  THRU 2200-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
           MOVE IN-DEST-ID              TO WS-DEST-ID                   
           PERFORM 7000-OPEN-HDR-CURSOR THRU 7000-EXIT                  
           PERFORM 7100-FETCH-HDR-CURSOR THRU 7100-EXIT                 
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              PERFORM 2300-MOVE-VALUES      THRU 2300-EXIT              
              PERFORM 7100-FETCH-HDR-CURSOR THRU 7100-EXIT              
           END-PERFORM                                                  
           PERFORM 7200-CLOSE-HDR-CURSOR THRU 7200-EXIT.                
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE NOT-FOUND TO S-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2300-MOVE-VALUES.                                                
      *                                                                         
           MOVE 0                        TO  S-RETURN-CODE              
           MOVE HZ-ACCOUNT-NO            TO  WS-ACCOUNT-NO              
           MOVE WS-ACCOUNT-NO            TO  S-ACCOUNT-NO               
           MOVE HZ-AMT-DUE               TO  S-AMT-DUE                  
           IF WS-NULL-IND-BILL-DUE < 0                                  
              MOVE SPACES                TO  S-BILL-DUE-DATE            
           ELSE                                                         
              MOVE HZ-BILL-DUE-DATE      TO  S-BILL-DUE-DATE            
           END-IF                                                       
A04083     IF S-AMT-DUE <= 0 AND WS-DEST-ID = 'CHECKFREE'               
A04083       PERFORM 7500-GET-PYMT-DUE-TEXT THRU 7500-EXIT              
A04083       MOVE  'Y'                   TO  S-PYMT-DUE-TXT-FL          
A04083       MOVE WS-PYMT-DUE-TEXT       TO  S-PYMT-DUE-TEXT            
A04083     ELSE                                                         
A04083       MOVE SPACES                 TO  S-PYMT-DUE-TXT-FL          
A04083                                       S-PYMT-DUE-TEXT            
A04083     END-IF                                                       
           MOVE HZ-BILL-NO               TO  S-BILL-NO                  
           MOVE HZ-CODE-STATE-ID         TO  S-CODE-STATE-ID            
           MOVE HZ-CUSTOMER-NA-TEXT      TO  S-CUSTOMER-NA-TEXT         
           MOVE HZ-DATE-BILLED           TO  S-DATE-BILLED              
           MOVE HZ-DATE-CREATED          TO  S-DATE-CREATED             
           MOVE HZ-DATE-READ             TO  S-DATE-READ                
           MOVE HZ-EXTRACTED-FL          TO  S-EXTRACTED-FL             
           IF WS-NULL-INDICATOR-1 < 0                                   
              MOVE SPACES                TO  S-EXTRACTED-TS             
           ELSE                                                         
              MOVE HZ-EXTRACTED-TS       TO  S-EXTRACTED-TS             
           END-IF                                                       
           MOVE HZ-LAST-UPDATE-TS        TO  S-LAST-UPDATE-TS           
           MOVE HZ-LAST-UPDATE-USERID    TO  S-LAST-UPD-USERID          
           MOVE HZ-MST-ACCT-NO           TO  WS-MST-ACCT-NO             
           MOVE WS-MST-ACCT-NO           TO  S-MST-ACCT-NO              
           MOVE HZ-MST-SUB-ACCT-IND      TO  S-MST-SUB-ACCT-IND         
           MOVE HZ-PURPOSE-CD            TO  S-PURPOSE-CD               
           IF WS-NULL-INDICATOR-2 < 0                                   
              MOVE SPACES                   TO  S-SCHED-SEND-DT         
           ELSE                                                         
              MOVE HZ-SCHED-SEND-DT         TO  S-SCHED-SEND-DT         
           END-IF                                                       
           MOVE HZ-STATUS-CD             TO  S-STATUS-CD                
           MOVE HZ-STREET-ADDR-1-TEXT    TO  S-STREET-ADDR-1            
           MOVE HZ-STREET-ADDR-2-TEXT    TO  S-STREET-ADDR-2            
           MOVE HZ-TRANS-CD              TO  S-TRANS-CD                 
           MOVE HZ-UPDATE-IND            TO  S-UPDATE-IND               
           MOVE HZ-ZIP-CODE              TO  S-ZIP-CODE.                
           MOVE HZ-ZIP-CODE              TO  A4-ZIP-CODE.               
RS0901     MOVE HZ-REVENUE-MONTH         TO  S-REVENUE-MONTH.           
RS0901     MOVE HZ-ESTIMATED-FL          TO  S-ESTIMATED-FL.            
C36867     MOVE HZ-DIST-ACCT-NO          TO  S-DIST-ACCT-NO.            
           MOVE SPACES                   TO A4-TOWN.                    
           PERFORM 7300-GET-CITY         THRU 7300-EXIT.                
           MOVE A4-TOWN                  TO  S-CITY.                    
           MOVE SPACES                   TO TA-ADDTL-BILL-NAME-TX.      
           MOVE HZ-ACCOUNT-NO            TO TA-ACCOUNT-NO.              
           PERFORM 7400-ADDL-BILL-NM     THRU 7400-EXIT.                
           MOVE TA-ADDTL-BILL-NAME-TX    TO  S-ADDL-BILL-NM.            
           MOVE NJ-EDI-TP-FL             TO  S-EDI-TP-FL                
           MOVE NJ-FORMAT-TYPE           TO  S-FORMAT-TYPE              
           MOVE SPACES                   TO  S-HTTP-ADDR                
           MOVE NJ-HTTP-ADDR-TEXT        TO  S-HTTP-ADDR                
           MOVE NJ-TP-AUTO-EMAIL-FL      TO  S-TP-AUTO-EMAIL-FL         
           MOVE NJ-TP-EDI-ID-QUAL        TO  S-TP-EDI-ID-QUAL           
           MOVE NJ-TP-EDI-RECEIVER-ID    TO  S-TP-EDI-RECEIVER-ID       
           MOVE NJ-TP-EMAIL-GROUP        TO  S-TP-EMAIL-GROUP           
           MOVE NF-AUTOMATIC-EMAIL-FL    TO  S-AUTOMATIC-EMAIL-FL       
           MOVE NF-EDI-ID-QUAL           TO  S-EDI-ID-QUAL              
           MOVE NF-EDI-RECEIVER-ID       TO  S-EDI-RECEIVER-ID          
           MOVE NF-EMAIL-GROUP           TO  S-EMAIL-GROUP              
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *                                                                         
                                                                        
      ******************************************************************        
      * 7000-OPEN-HDR-CURSOR.                                          *        
      ******************************************************************        
                                                                        
       7000-OPEN-HDR-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              OPEN HDR1_CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7000'          TO ACTIVE-PARAGRAPH                  
              MOVE 'OPEN '              TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-HDR-CURSOR.                                         *        
      *     FETCH HEADER CURSOR TO GET ALL RECORDS SELECTED.           *        
      ******************************************************************        
                                                                        
       7100-FETCH-HDR-CURSOR.                                           
                                                                        
            MOVE SPACES TO HZ-STREET-ADDR-1-TEXT                        
            MOVE SPACES TO HZ-STREET-ADDR-2-TEXT                        
            MOVE SPACES TO HZ-CUSTOMER-NA-TEXT                          
            MOVE SPACES TO NJ-HTTP-ADDR-TEXT                            
                                                                        
           EXEC SQL                                                     
              FETCH HDR1_CURSOR                                         
              INTO                                                      
                      :HZ-ACCOUNT-NO                                    
                     ,:HZ-AMT-DUE                                       
                     ,:HZ-BILL-DUE-DATE :WS-NULL-IND-BILL-DUE            
                     ,:HZ-BILL-NO                                       
                     ,:HZ-CODE-STATE-ID                                 
                     ,:HZ-CUSTOMER-NA                                   
                     ,:HZ-DATE-BILLED                                   
                     ,:HZ-DATE-CREATED                                  
                     ,:HZ-DATE-READ                                     
                     ,:HZ-EXTRACTED-FL                                  
                     ,:HZ-EXTRACTED-TS :WS-NULL-INDICATOR-1              
                     ,:HZ-LAST-UPDATE-TS                                
                     ,:HZ-LAST-UPDATE-USERID                            
                     ,:HZ-MST-ACCT-NO                                   
                     ,:HZ-MST-SUB-ACCT-IND                              
                     ,:HZ-PURPOSE-CD                                    
                     ,:HZ-SCHED-SEND-DT :WS-NULL-INDICATOR-2             
                     ,:HZ-STATUS-CD                                     
                     ,:HZ-STREET-ADDR-1                                 
                     ,:HZ-STREET-ADDR-2                                 
                     ,:HZ-TRANS-CD                                      
                     ,:HZ-UPDATE-IND                                    
                     ,:HZ-ZIP-CODE                                      
RS0901               ,:HZ-REVENUE-MONTH                                 
RS0901               ,:HZ-ESTIMATED-FL                                  
C36867               ,:HZ-DIST-ACCT-NO                                  
                     ,:NJ-EDI-TP-FL                                     
                     ,:NJ-FORMAT-TYPE                                   
                     ,:NJ-HTTP-ADDR                                     
                     ,:NJ-TP-AUTO-EMAIL-FL                              
                     ,:NJ-TP-EDI-ID-QUAL                                
                     ,:NJ-TP-EDI-RECEIVER-ID                            
                     ,:NJ-TP-EMAIL-GROUP                                
                     ,:NF-AUTOMATIC-EMAIL-FL                            
                     ,:NF-EDI-ID-QUAL                                   
                     ,:NF-EDI-RECEIVER-ID                               
                     ,:NF-EMAIL-GROUP                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7100'          TO ACTIVE-PARAGRAPH                  
              MOVE 'FETCH'              TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'      TO TABLE-1                   
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-CLOSE-HDR-CURSOR.                                         *        
      ******************************************************************        
                                                                        
       7200-CLOSE-HDR-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
              CLOSE HDR1_CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7200'          TO ACTIVE-PARAGRAPH                  
              MOVE 'CLOSE'             TO ABEND-FUNCTION                
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7300-GET-CITY.                                                 *        
      ******************************************************************        
                                                                        
       7300-GET-CITY.                                                   
                                                                        
           EXEC SQL                                                     
              SELECT TOWN                                               
              INTO   :A4-TOWN                                           
              FROM CSS_ZIP_CODE                                         
              WHERE ZIP_CODE = :A4-ZIP-CODE                             
              AND   ZIP_CODE_TOKEN = '1'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7300'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ZIP-CODE'       TO TABLE-1                      
              MOVE 'ZIP-CODE'           TO TABLE-ELEMENT-1              
              MOVE A4-ZIP-CODE          TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-ADDL-BILL-NM.                                             *        
      ******************************************************************        
                                                                        
       7400-ADDL-BILL-NM.                                               
                                                                        
           EXEC SQL                                                     
              SELECT ADDTL_BILL_NAME_TX                                 
              INTO   :TA-ADDTL-BILL-NAME-TX                             
              FROM CSS_ACCT_MISC_INFO                                   
              WHERE ACCOUNT_NO = :TA-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7400'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE TA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
A04083******************************************************************        
A04083* 7500-GET-PYMT-DUE-TEXT                                         *        
A04083******************************************************************        
       7500-GET-PYMT-DUE-TEXT.                                          
           EXEC SQL                                                     
             SELECT CODE_SHORT_DESC                                     
              INTO :UV-CODE-SHORT-DESC                                  
               FROM CSS_CODE_VALUE WITH(READUNCOMMITTED)                        
              WHERE TABLE_NA   = 'CSS_EDI_BILL_HDR'                     
                AND COMPANY_NO = '01'                                   
                AND COLUMN_NA  = 'PYMT_DUE_TEXT'                        
                AND PROGRAM_ID = 'ALL'                                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CODE_SHORT_DESC                                             
MFA-TR*       INTO :UV-CODE-SHORT-DESC                                          
MFA-TR*        FROM CSS_CODE_VALUE                                              
MFA-TR*       WHERE TABLE_NA   = 'CSS_EDI_BILL_HDR'                             
MFA-TR*         AND COMPANY_NO = '01'                                           
MFA-TR*         AND COLUMN_NA  = 'PYMT_DUE_TEXT'                                
MFA-TR*         AND PROGRAM_ID = 'ALL'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              MOVE UV-CODE-SHORT-DESC-TEXT(1:15) TO WS-PYMT-DUE-TEXT    
           ELSE                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
              MOVE 'NO PAYMENT DUE'   TO WS-PYMT-DUE-TEXT               
           ELSE                                                         
              MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
              MOVE '7500'             TO ACTIVE-PARAGRAPH               
              MOVE 'SELECT'           TO ABEND-FUNCTION                 
              MOVE 'CSS_CODE_VALUE'   TO TABLE-1                        
              MOVE 'CSS_EDI_BILL_HDR' TO TABLE-ELEMENT-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
      *                                                                         
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR03287_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03287_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03287_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
                                                                        
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *    EXEC SQL                                                             
      *       INCLUDE CPD00300                                                  
      *    END-EXEC.                                                            
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
      *    COPY CPD00302.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR03287_R1'                               
                                         TO S-SQL-STATEMENT-V.          
                                                                        
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR03287_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,ACCOUNT_NO                                         
                    ,AMT_DUE                                            
                    ,BILL_DUE_DATE                                      
                    ,BILL_NO                                            
                    ,CODE_STATE_ID                                      
                    ,CUSTOMER_NA_TEXT                                   
                    ,DATE_BILLED                                        
                    ,DATE_CREATED                                       
                    ,DATE_READ                                          
                    ,EXTRACTED_FL                                       
                    ,EXTRACTED_TS                                       
                    ,LAST_UPDATE_TS                                     
                    ,LAST_UPD_USERID                                    
                    ,MST_ACCT_NO                                        
                    ,MST_SUB_ACCT_IND                                   
                    ,PURPOSE_CD                                         
                    ,SCHED_SEND_DT                                      
                    ,STATUS_CD                                          
                    ,STREET_ADDR_1                                      
                    ,STREET_ADDR_2                                      
                    ,TRANS_CD                                           
                    ,UPDATE_IND                                         
                    ,ZIP_CODE                                           
RS0901              ,REVENUE_MONTH                                      
RS0901              ,ESTIMATED_FL                                       
C36867              ,DIST_ACCT_NO                                       
                    ,EDI_TP_FL                                          
                    ,FORMAT_TYPE                                        
                    ,HTTP_ADDR                                          
                    ,TP_AUTO_EMAIL_FL                                   
                    ,TP_EDI_ID_QUAL                                     
                    ,TP_EDI_RECEIVER_ID                                 
                    ,TP_EMAIL_GROUP                                     
                    ,AUTOMATIC_EMAIL_FL                                 
                    ,EDI_ID_QUAL                                        
                    ,EDI_RECEIVER_ID                                    
                    ,EMAIL_GROUP                                        
                    ,CITY                                               
                    ,ADDL_BILL_NM                                       
A04083              ,PYMT_DUE_TXT_FL                                    
A04083              ,PYMT_DUE_TEXT                                      
                   )                                                    
               VALUES                                                   
                   (                                                    
                    :S-RETURN-CODE                                      
                   ,:S-ACCOUNT-NO                                       
                   ,:S-AMT-DUE                                          
                   ,:S-BILL-DUE-DATE                                    
                   ,:S-BILL-NO                                          
                   ,:S-CODE-STATE-ID                                    
                   ,:S-CUSTOMER-NA-TEXT                                 
                   ,:S-DATE-BILLED                                      
                   ,:S-DATE-CREATED                                     
                   ,:S-DATE-READ                                        
                   ,:S-EXTRACTED-FL                                     
                   ,:S-EXTRACTED-TS                                     
                   ,:S-LAST-UPDATE-TS                                   
                   ,:S-LAST-UPD-USERID                                  
                   ,:S-MST-ACCT-NO                                      
                   ,:S-MST-SUB-ACCT-IND                                 
                   ,:S-PURPOSE-CD                                       
                   ,:S-SCHED-SEND-DT                                    
                   ,:S-STATUS-CD                                        
                   ,:S-STREET-ADDR-1                                    
                   ,:S-STREET-ADDR-2                                    
                   ,:S-TRANS-CD                                         
                   ,:S-UPDATE-IND                                       
                   ,:S-ZIP-CODE                                         
RS0901             ,:S-REVENUE-MONTH                                    
RS0901             ,:S-ESTIMATED-FL                                     
C36867             ,:S-DIST-ACCT-NO                                     
                   ,:S-EDI-TP-FL                                        
                   ,:S-FORMAT-TYPE                                      
                   ,:S-HTTP-ADDR                                        
                   ,:S-TP-AUTO-EMAIL-FL                                 
                   ,:S-TP-EDI-ID-QUAL                                   
                   ,:S-TP-EDI-RECEIVER-ID                               
                   ,:S-TP-EMAIL-GROUP                                   
                   ,:S-AUTOMATIC-EMAIL-FL                               
                   ,:S-EDI-ID-QUAL                                      
                   ,:S-EDI-RECEIVER-ID                                  
                   ,:S-EMAIL-GROUP                                      
                   ,:S-CITY                                             
                   ,:S-ADDL-BILL-NM                                     
A04083             ,:S-PYMT-DUE-TXT-FL                                  
A04083             ,:S-PYMT-DUE-TEXT                                    
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR03287_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ACCOUNT_NO                                                 
MFA-TR*             ,AMT_DUE                                                    
MFA-TR*             ,BILL_DUE_DATE                                              
MFA-TR*             ,BILL_NO                                                    
MFA-TR*             ,CODE_STATE_ID                                              
MFA-TR*             ,CUSTOMER_NA_TEXT                                           
MFA-TR*             ,DATE_BILLED                                                
MFA-TR*             ,DATE_CREATED                                               
MFA-TR*             ,DATE_READ                                                  
MFA-TR*             ,EXTRACTED_FL                                               
MFA-TR*             ,EXTRACTED_TS                                               
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,LAST_UPD_USERID                                            
MFA-TR*             ,MST_ACCT_NO                                                
MFA-TR*             ,MST_SUB_ACCT_IND                                           
MFA-TR*             ,PURPOSE_CD                                                 
MFA-TR*             ,SCHED_SEND_DT                                              
MFA-TR*             ,STATUS_CD                                                  
MFA-TR*             ,STREET_ADDR_1                                              
MFA-TR*             ,STREET_ADDR_2                                              
MFA-TR*             ,TRANS_CD                                                   
MFA-TR*             ,UPDATE_IND                                                 
MFA-TR*             ,ZIP_CODE                                                   
MFA-TR*             ,REVENUE_MONTH                                              
MFA-TR*             ,ESTIMATED_FL                                               
MFA-TR*             ,DIST_ACCT_NO                                               
MFA-TR*             ,EDI_TP_FL                                                  
MFA-TR*             ,FORMAT_TYPE                                                
MFA-TR*             ,HTTP_ADDR                                                  
MFA-TR*             ,TP_AUTO_EMAIL_FL                                           
MFA-TR*             ,TP_EDI_ID_QUAL                                             
MFA-TR*             ,TP_EDI_RECEIVER_ID                                         
MFA-TR*             ,TP_EMAIL_GROUP                                             
MFA-TR*             ,AUTOMATIC_EMAIL_FL                                         
MFA-TR*             ,EDI_ID_QUAL                                                
MFA-TR*             ,EDI_RECEIVER_ID                                            
MFA-TR*             ,EMAIL_GROUP                                                
MFA-TR*             ,CITY                                                       
MFA-TR*             ,ADDL_BILL_NM                                               
MFA-TR*             ,PYMT_DUE_TXT_FL                                            
MFA-TR*             ,PYMT_DUE_TEXT                                              
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-ACCOUNT-NO                                               
MFA-TR*            ,:S-AMT-DUE                                                  
MFA-TR*            ,:S-BILL-DUE-DATE                                            
MFA-TR*            ,:S-BILL-NO                                                  
MFA-TR*            ,:S-CODE-STATE-ID                                            
MFA-TR*            ,:S-CUSTOMER-NA-TEXT                                         
MFA-TR*            ,:S-DATE-BILLED                                              
MFA-TR*            ,:S-DATE-CREATED                                             
MFA-TR*            ,:S-DATE-READ                                                
MFA-TR*            ,:S-EXTRACTED-FL                                             
MFA-TR*            ,:S-EXTRACTED-TS                                             
MFA-TR*            ,:S-LAST-UPDATE-TS                                           
MFA-TR*            ,:S-LAST-UPD-USERID                                          
MFA-TR*            ,:S-MST-ACCT-NO                                              
MFA-TR*            ,:S-MST-SUB-ACCT-IND                                         
MFA-TR*            ,:S-PURPOSE-CD                                               
MFA-TR*            ,:S-SCHED-SEND-DT                                            
MFA-TR*            ,:S-STATUS-CD                                                
MFA-TR*            ,:S-STREET-ADDR-1                                            
MFA-TR*            ,:S-STREET-ADDR-2                                            
MFA-TR*            ,:S-TRANS-CD                                                 
MFA-TR*            ,:S-UPDATE-IND                                               
MFA-TR*            ,:S-ZIP-CODE                                                 
MFA-TR*            ,:S-REVENUE-MONTH                                            
MFA-TR*            ,:S-ESTIMATED-FL                                             
MFA-TR*            ,:S-DIST-ACCT-NO                                             
MFA-TR*            ,:S-EDI-TP-FL                                                
MFA-TR*            ,:S-FORMAT-TYPE                                              
MFA-TR*            ,:S-HTTP-ADDR                                                
MFA-TR*            ,:S-TP-AUTO-EMAIL-FL                                         
MFA-TR*            ,:S-TP-EDI-ID-QUAL                                           
MFA-TR*            ,:S-TP-EDI-RECEIVER-ID                                       
MFA-TR*            ,:S-TP-EMAIL-GROUP                                           
MFA-TR*            ,:S-AUTOMATIC-EMAIL-FL                                       
MFA-TR*            ,:S-EDI-ID-QUAL                                              
MFA-TR*            ,:S-EDI-RECEIVER-ID                                          
MFA-TR*            ,:S-EMAIL-GROUP                                              
MFA-TR*            ,:S-CITY                                                     
MFA-TR*            ,:S-ADDL-BILL-NM                                             
MFA-TR*            ,:S-PYMT-DUE-TXT-FL                                          
MFA-TR*            ,:S-PYMT-DUE-TEXT                                            
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
              MOVE '8900'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR03287_R1'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE S-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1             
************* PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
                                                                        
               ROLLBACK                                                 
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
***********PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                          
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9100-CHECK-ERROR                                               *        
      ******************************************************************        
       9100-CHECK-ERROR.                                                
           EXIT.                                                        
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
