       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03286.                                     
COB303 DATE-WRITTEN.     JUNE 01, 2003.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03286              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03286 :                                                --         
      *--                                                            --         
      *--  #  UPDATES EDI ACCOUNT DESTINATION MAPPING.               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--   PROCESS_FL            CHAR(01)                                      
      *--   ACCOUNT_NO            CHAR(13)                                      
      *--   DEST_ID               CHAR(10)                           --         
      *--   AUTO_EMAIL_FL         CHAR(01)                           --         
      *--   EDI_ID_QUAL           CHAR(02)                           --         
      *--   EDI_RECV_ID           CHAR(15)                           --         
      *--   EMAIL_GROUP           CHAR(30)                           --         
      *--   STAT_BEGIN_DT         CHAR(10)                           --         
      *--   STAT_END_DT           CHAR(10)                           --         
      *--   STATUS_CD             CHAR(01)                           --         
      *--                                                            --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *****************************************************************         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  02 JUN 2003   PD80186     NEW CODE                        --         
T35434*--  31 OCT 2007   MK92804     REPLACED CSS_MODEL_SQL WITH     --         
T35434*--                            SET STATEMENTS AND ADDED        --         
T35434*--                            'WITH UR' FOR SINGLETON SELECTS --         
P00768*--  16 JUL 2013   SS97726     EDI PAPERLESS/EMAIL & PAPER     --         
P00768*--                            ONLY UPDATES.                   --         
      *--                                                            --         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03286'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_ACCOUNT                                                  *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_EDI_ACCT_DEST                                            *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACDEST                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_MNT_TRANS_HIST                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_MT_TRN_HST_DET                                           *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_ACCT_ATTRIBUTE                                           *        
      ******************************************************************        
P00768                                                                  
P00768     EXEC SQL                                                     00630000
P00768        INCLUDE TBACTATT                                          00640000
P00768     END-EXEC.                                                    00650000
      *                                                                         
      ******************************************************************        
      *   CSS_ATTRIBUTE                                                *        
      ******************************************************************        
P00768                                                                  
P00768     EXEC SQL                                                     00630000
P00768        INCLUDE TBATTRIB                                          00640000
P00768     END-EXEC.                                                    00650000
      *                                                                         
      ******************************************************************        
      *   CSS_CUST_STATS                                               *        
      ******************************************************************        
P00768                                                                  
P00768     EXEC SQL                                                     00630000
P00768        INCLUDE TBCSTSTS                                          00640000
P00768     END-EXEC.                                                    00650000
      *                                                                         
      ******************************************************************        
      *   CSS_ADDR_FREEFORM                                            *        
      ******************************************************************        
P00768                                                                  
P00768     EXEC SQL                                                     00630000
P00768        INCLUDE TBADRFRE                                          00640000
P00768     END-EXEC.                                                    00650000
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03286'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-NAME                PIC X(26) VALUE                  
                                           'SESSION.CSR03286_R1'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
       01  LS-DATABASE                   PIC 9(01)  VALUE 0.            
           88 CSR-DATABASE                          VALUE 1.            
           88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      ****************************************************************          
      *    ERROR PROCESSING VARIABLES                               -*          
      ****************************************************************          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           10 S-ERROR-MSG            PIC X(07) VALUE SPACES.            
      *                                                                         
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-CCYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
           05  WS-SQLSTATE            PIC X(05) VALUE SPACES.           
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-PRESENT              PIC X(01)  VALUE 'N'.            
           05  WS-PARM-ACCOUNT-NO      PIC 9(13)  VALUE ZERO.           
           05  WS-ACCOUNT-NO           PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-CURRENT-DATE         PIC X(10)  VALUE SPACES.         
           05  WS-CURRENT-TIMESTAMP    PIC X(26)  VALUE SPACES.         
           05  WS-USER-ID              PIC X(07)  VALUE SPACES.         
           05  WS-PROGRAM-ID           PIC X(09)  VALUE SPACES.         
P00768     05  WS-BILL-NOTIFICATION    PIC X(01)  VALUE SPACES.         
P00768     05  WS-NEW-BILL-NOTIFICATION                                 
P00768                                 PIC X(01)  VALUE SPACES.         
P00768     05  WS-ATTRIBUTE-TYPE       PIC X(08)  VALUE SPACES.         
P00768     05  WS-NO-NOTIFICATION      PIC X(01)  VALUE 'N'.            
P00768         88 NO-NOTIFICATION                 VALUE 'Y'.            
P00768     05  WS-PAPER-ONLY           PIC X(01)  VALUE 'N'.            
P00768         88 PAPER-ONLY                      VALUE 'Y'.            
P00768     05  WS-PAPERLESS            PIC X(01)  VALUE SPACES.         
P00768     05  WS-OLD-NO-COPIES        PIC S9(4)  COMP VALUE ZEROS.     
P00768     05  WS-PRV-CODE-PERM-BILL   PIC X(01)  VALUE SPACE.          
P00768     05  WS-INTER-ADD            PIC X(01)  VALUE SPACES.         
      *                                                                         
       01  PREVIOUS-FIELD-VALUES.                                       
           05  WS-PREV-AUTO-EMAIL-FL   PIC X(01) VALUE SPACES.          
           05  WS-PREV-EDI-ID-QUAL     PIC X(02) VALUE SPACES.          
           05  WS-PREV-EDI-RECEIVER-ID PIC X(15) VALUE SPACES.          
           05  WS-PREV-EMAIL-GROUP     PIC X(30) VALUE SPACES.          
           05  WS-PREV-STAT-BEGIN-DT   PIC X(10) VALUE SPACES.          
           05  WS-PREV-STAT-END-DT     PIC X(10) VALUE SPACES.          
           05  WS-PREV-STATUS-CD       PIC X(01) VALUE SPACES.          
           05  WS-PREV-HOLD-DAYS-NO    PIC S9(4) COMP VALUE +0.         
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  IN-PROCESS-FL            PIC X(01).                          
       01  IN-ACCOUNT-NO            PIC X(13).                          
       01  IN-DEST-ID               PIC X(10).                          
       01  IN-AUTO-EMAIL-FL         PIC X(01).                          
       01  IN-EDI-ID-QUAL           PIC X(02).                          
       01  IN-EDI-RECV-ID           PIC X(15).                          
       01  IN-EMAIL-GROUP           PIC X(30).                          
       01  IN-STAT-BEGIN-DT         PIC X(10).                          
       01  IN-STAT-END-DT           PIC X(10).                          
       01  IN-STATUS-CD             PIC X(01).                          
       01  IN-HOLD-DAYS-NO          PIC S9(04) COMP.                    
       01  IN-MESSAGE               PIC X(210).                         
       01  IN-USER-ID               PIC X(07).                          
      *                                                                         
       PROCEDURE DIVISION USING IN-PROCESS-FL                           
                               ,IN-ACCOUNT-NO                           
                               ,IN-DEST-ID                              
                               ,IN-AUTO-EMAIL-FL                        
                               ,IN-EDI-ID-QUAL                          
                               ,IN-EDI-RECV-ID                          
                               ,IN-EMAIL-GROUP                          
                               ,IN-STAT-BEGIN-DT                        
                               ,IN-STAT-END-DT                          
                               ,IN-STATUS-CD                            
                               ,IN-HOLD-DAYS-NO                         
                               ,IN-MESSAGE                              
                               ,IN-USER-ID.                             
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *--  0100A-DECLARE-GTT                                        -*          
      *--  DECLARE TEMPORARY TABLE                                  -*          
      ****************************************************************          
      *                                                                         
       0100A-DECLARE-GTT.                                               
           MOVE                                                         
           'DECLARE GLOBAL TEMPORARY TABLE CSR03286_R1'                 
                                          TO S-SQL-STATEMENT-V.         
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03286_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03286_R1
              (                                                    
                    RETURN_CODE           INT                       
                   ,ERROR_MSG CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2         
                   )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03286_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
       0100A-EXIT.                                                      
           EXIT.                                                        
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           PERFORM 0100A-DECLARE-GTT         THRU 0100A-EXIT.           
      *                                                                         
           EXEC SQL                                                     
                                                                        
               DECLARE C1 CURSOR  FOR                        
               SELECT *                                                 
               FROM #CSR03286_R1                                 
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT *                                                         
MFA-TR*        FROM SESSION.CSR03286_R1                                         
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
      *                                                                         
           PERFORM 1500-PROCESS-INPUT         THRU 1500-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 1500-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1500-PROCESS-INPUT.                                              
      *                                                                         
           MOVE IN-ACCOUNT-NO            TO WS-PARM-ACCOUNT-NO          
           MOVE IN-USER-ID               TO WS-USER-ID.                 
           MOVE WS-PARM-ACCOUNT-NO       TO NF-ACCOUNT-NO               
                                            AT-ACCOUNT-NO               
P00768     MOVE ZEROS                    TO WS-OLD-NO-COPIES.           
P00768     MOVE SPACES                   TO WS-PRV-CODE-PERM-BILL.      
           PERFORM 7300-VALIDATE-ACCOUNT THRU 7300-EXIT.                
           MOVE IN-DEST-ID               TO NF-DEST-ID                  
           MOVE IN-AUTO-EMAIL-FL         TO NF-AUTOMATIC-EMAIL-FL       
           MOVE IN-EDI-ID-QUAL           TO NF-EDI-ID-QUAL              
           MOVE IN-EDI-RECV-ID           TO NF-EDI-RECEIVER-ID          
           MOVE IN-EMAIL-GROUP           TO NF-EMAIL-GROUP              
           MOVE IN-STAT-BEGIN-DT         TO NF-STAT-BEGIN-DT            
           MOVE IN-STAT-END-DT           TO NF-STAT-END-DT              
           MOVE IN-STATUS-CD             TO NF-STATUS-CD                
           MOVE IN-HOLD-DAYS-NO          TO NF-HOLD-DAYS-NO             
           EVALUATE IN-PROCESS-FL                                       
              WHEN 'I'                                                  
                 MOVE SPACES TO WS-PRESENT                              
                 PERFORM 7000-GET-DEST-PRESENT  THRU 7000-EXIT          
                 IF WS-PRESENT = 'Y'                                    
                    MOVE 100                      TO  S-RETURN-CODE     
                    MOVE 'D5050'                  TO  S-ERROR-MSG       
                    PERFORM 8100-SEND-RESULT      THRU 8100-EXIT        
                    PERFORM 9999-END-PROGRAM      THRU 9999-EXIT        
                 ELSE                                                   
                    PERFORM 8210-INSERT-ACCT-DEST THRU 8210-EXIT        
                    MOVE 'PAN209DI'       TO WS-PROGRAM-ID              
                    PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT     
                    MOVE 'ACCOUNT NO'     TO MI-COLUMN-DESC             
                    MOVE +3               TO MI-PRV-COLUMN-VALUE-LEN    
                    MOVE 'NEW'            TO MI-PRV-COLUMN-VALUE-TEXT   
                    MOVE +13              TO MI-CHG-COLUMN-VALUE-LEN    
                    MOVE WS-PARM-ACCOUNT-NO TO                          
                                                MI-CHG-COLUMN-VALUE-TEXT
                    PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT          
                                                                        
                    MOVE 'DEST ID'        TO MI-COLUMN-DESC             
                    MOVE +3               TO MI-PRV-COLUMN-VALUE-LEN    
                    MOVE 'NEW'            TO MI-PRV-COLUMN-VALUE-TEXT   
                    MOVE +8               TO MI-CHG-COLUMN-VALUE-LEN    
                    MOVE NF-DEST-ID       TO MI-CHG-COLUMN-VALUE-TEXT   
                    PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT          
                 END-IF                                                 
              WHEN 'U'                                                  
                 PERFORM 7500-GET-PREV-ACCT-DEST  THRU 7500-EXIT        
                 PERFORM 8200-UPDATE-ACCT-DEST    THRU 8200-EXIT        
                 MOVE 'PAN209DU'         TO WS-PROGRAM-ID               
                 PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT        
                 PERFORM 7510-FIND-CHANGED-FIELDS THRU 7510-EXIT        
              WHEN 'D'                                                  
                 PERFORM 8220-DELETE-ACCT-DEST THRU 8220-EXIT           
                 MOVE 'PAN209DD'         TO WS-PROGRAM-ID               
                 PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT        
                 MOVE 'ACCOUNT NO'       TO MI-COLUMN-DESC              
                 MOVE +7                 TO MI-PRV-COLUMN-VALUE-LEN     
                 MOVE 'DELETED'          TO MI-PRV-COLUMN-VALUE-TEXT    
                 MOVE +13                TO MI-CHG-COLUMN-VALUE-LEN     
                 MOVE WS-PARM-ACCOUNT-NO TO MI-CHG-COLUMN-VALUE-TEXT    
                 PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT             
                                                                        
                 MOVE 'DEST ID'        TO MI-COLUMN-DESC                
                 MOVE +7               TO MI-PRV-COLUMN-VALUE-LEN       
                 MOVE 'DELETED'        TO MI-PRV-COLUMN-VALUE-TEXT      
                 MOVE +8               TO MI-CHG-COLUMN-VALUE-LEN       
                 MOVE NF-DEST-ID       TO MI-CHG-COLUMN-VALUE-TEXT      
                 PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT             
           END-EVALUATE.                                                
                                                                        
P00768** SETUP ACCOUNT FOR PAPERLESS BILLING WHEN EDI VENDOR IS SETUP.          
P00768** SETUP ACCOUNT FOR PAPER ONLY WHEN THERE IS NO ACTIVE EDI VENDOR        
P00768     MOVE 'N'                    TO WS-NO-NOTIFICATION            
P00768                                    WS-PAPER-ONLY.                
P00768     MOVE SPACES                 TO WS-BILL-NOTIFICATION          
P00768                                    WS-NEW-BILL-NOTIFICATION      
P00768                                    WS-ATTRIBUTE-TYPE             
P00768                                    WS-PAPERLESS                  
P00768                                    WS-INTER-ADD.                 
P00768     MOVE WS-PARM-ACCOUNT-NO     TO YP-ACCOUNT-NO                 
P00768                                    AT-ACCOUNT-NO.                
P00768     MOVE AT-COMPANY-NO          TO WZ-COMPANY-NO.                
P00768                                                                  
P00768     PERFORM 7600-GET-ACTIVE-ACCT-DEST         THRU 7600-EXIT.    
P00768     PERFORM 2400-GET-BILL-NOTIFICATION        THRU 2400-EXIT.    
P00768                                                                  
P00768     IF NF-DEST-ID NOT EQUAL 'CHECKFREE'                          
P00768        IF WS-PAPERLESS = 'Y'                                     
P00768           IF WS-BILL-NOTIFICATION NOT EQUAL '1'                  
P00768              MOVE '1'           TO WS-NEW-BILL-NOTIFICATION      
P00768              PERFORM 2410-PAPERLESS-EMAIL-ONLY                   
P00768                                               THRU 2410-EXIT     
P00768           END-IF                                                 
P00768        ELSE                                                      
P00768           IF WS-BILL-NOTIFICATION NOT EQUAL '3'                  
P00768              MOVE '3'           TO WS-NEW-BILL-NOTIFICATION      
P00768              PERFORM 2420-PAPER-ONLY          THRU 2420-EXIT     
P00768           END-IF                                                 
P00768        END-IF                                                    
P00768     END-IF.                                                      
P00768                                                                  
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT  THRU 2200-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2200-BUILD-RESULT.                                               
      *                                                                         
           PERFORM 2300-MOVE-VALUES THRU 2300-EXIT                      
           IF CTR-ROWS = 0                                              
              INITIALIZE GTT-RETURN-FIELDS                              
              MOVE NOT-FOUND TO S-RETURN-CODE                           
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2300-MOVE-VALUES.                                                       
      ******************************************************************        
       2300-MOVE-VALUES.                                                
      *                                                                         
           MOVE 0                        TO  S-RETURN-CODE              
           MOVE SPACES                   TO  S-ERROR-MSG                
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
P00768******************************************************************        
P00768* 2400-GET-BILL-NOTIFICATION                                     *        
P00768*     SELECT FROM CSS_ACCOUNT AND CSS_ACCT_ATTRIBUTE             *07530029
P00768******************************************************************07550000
P00768 2400-GET-BILL-NOTIFICATION.                                      
P00768*                                                                         
P00768     MOVE 'EMAIL_BILLNOTIFY'           TO YP-ATTRIBUTE-DESC.      
P00768     PERFORM 7650-CHECK-ACCT-ATTRB     THRU 7650-EXIT.            
P00768     IF NO-NOTIFICATION                                           
P00768        MOVE '4'                       TO WS-BILL-NOTIFICATION    
P00768     ELSE                                                         
P00768        IF WS-OLD-NO-COPIES EQUAL 0                               
P00768           MOVE '1'                    TO WS-BILL-NOTIFICATION    
P00768        ELSE                                                      
P00768           IF WS-OLD-NO-COPIES > 0                                
P00768              MOVE 'EMAIL_PAPERONLY'   TO YP-ATTRIBUTE-DESC       
P00768              MOVE 'EMAIL'             TO WS-ATTRIBUTE-TYPE       
P00768              PERFORM 7700-CHECK-ATTRB THRU 7700-EXIT             
P00768              IF PAPER-ONLY                                       
P00768                 MOVE '3'              TO WS-BILL-NOTIFICATION    
P00768              ELSE                                                
P00768                 MOVE '5'              TO WS-BILL-NOTIFICATION    
P00768              END-IF                                              
P00768           END-IF                                                 
P00768        END-IF                                                    
P00768     END-IF.                                                      
P00768                                                                  
P00768     PERFORM 7750-GET-EBILL-REG-IND    THRU 7750-EXIT.            
P00768     IF (WS-PAPERLESS = 'Y' OR                                    
P00768         CE-EBILL-REGISTER-IND = 'Y') AND                         
P00768         WS-BILL-NOTIFICATION = '5'                               
P00768         MOVE '2'                      TO WS-BILL-NOTIFICATION    
P00768     END-IF.                                                      
P00768*                                                                         
P00768 2400-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
P00768 2410-PAPERLESS-EMAIL-ONLY.                                       
P00768*                                                                         
P00768     MOVE WS-PRV-CODE-PERM-BILL        TO AT-CODE-PERM-BILL.      
P00768     MOVE WS-OLD-NO-COPIES             TO AT-NO-BILL-COPIES.      
P00768                                                                  
P00768     IF WS-OLD-NO-COPIES NOT EQUAL ZEROS                          
P00768        MOVE ZEROS                     TO AT-NO-BILL-COPIES       
P00768        IF WS-PRV-CODE-PERM-BILL = 'D'                            
P00768           MOVE 'A'                    TO AT-CODE-PERM-BILL       
P00768        END-IF                                                    
P00768     END-IF.                                                      
P00768                                                                  
P00768     PERFORM 7900-UPDATE-ACCT          THRU 7900-EXIT.            
P00768                                                                  
P00768     MOVE 'EMAIL_PAPERONLY'            TO YP-ATTRIBUTE-DESC.      
P00768     PERFORM 7650-CHECK-ACCT-ATTRB     THRU 7650-EXIT             
P00768     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00768        PERFORM 7800-DELETE-ATTRB-CD   THRU 7800-EXIT             
P00768     END-IF.                                                      
P00768                                                                  
P00768     MOVE 'EMAIL_BILLNOTIFY'           TO YP-ATTRIBUTE-DESC.      
P00768     PERFORM 7650-CHECK-ACCT-ATTRB     THRU 7650-EXIT             
P00768     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00768        PERFORM 7800-DELETE-ATTRB-CD   THRU 7800-EXIT             
P00768     END-IF.                                                      
P00768     PERFORM 7520-BILL-NOTIFY-MNT-TRNHIST                         
P00768                                       THRU 7520-EXIT.            
P00768*                                                                         
P00768 2410-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
P00768 2420-PAPER-ONLY.                                                 
P00768*                                                                         
P00768     MOVE WS-PRV-CODE-PERM-BILL        TO AT-CODE-PERM-BILL.      
P00768     MOVE WS-OLD-NO-COPIES             TO AT-NO-BILL-COPIES.      
P00768                                                                  
P00768     IF WS-PRV-CODE-PERM-BILL = 'A' AND                           
P00768        WS-OLD-NO-COPIES      = 0   AND                           
P00768        AT-ADDRESS-ID         > 0   AND                           
P00768        AT-ADDRESS-FORMAT     = 'B'                               
P00768        PERFORM 7550-CHECK-ADDRESS     THRU 7550-EXIT             
P00768        IF WS-INTER-ADD = 'Y'                                     
P00768           MOVE 'D'                    TO AT-CODE-PERM-BILL       
P00768        END-IF                                                    
P00768     END-IF.                                                      
P00768                                                                  
P00768     IF WS-OLD-NO-COPIES EQUAL ZEROS                              
P00768        MOVE +1                        TO AT-NO-BILL-COPIES       
P00768     END-IF.                                                      
P00768                                                                  
P00768     PERFORM 7900-UPDATE-ACCT          THRU 7900-EXIT.            
P00768                                                                  
P00768     MOVE 'EMAIL_PAPERONLY'            TO YP-ATTRIBUTE-DESC.      
P00768     PERFORM 7650-CHECK-ACCT-ATTRB     THRU 7650-EXIT             
P00768     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
P00768        MOVE WS-PARM-ACCOUNT-NO        TO YP-ACCOUNT-NO           
P00768        MOVE 'A'                       TO YP-STATUS-CD            
P00768        MOVE 'YES'                     TO YP-ATTRIBUTE-VALUE-CD   
P00768        MOVE +15                                                  
P00768             TO YP-ATTRIBUTE-VALUE-TX-LEN                         
P00768        MOVE 'EMAIL_PAPERONLY'                                    
P00768             TO YP-ATTRIBUTE-VALUE-TX-TEXT                        
P00768        PERFORM 7950-INSERT-ATTRB-CD   THRU 7950-EXIT             
P00768     END-IF.                                                      
P00768                                                                  
P00768     MOVE 'EMAIL_BILLNOTIFY'           TO YP-ATTRIBUTE-DESC.      
P00768     PERFORM 7650-CHECK-ACCT-ATTRB     THRU 7650-EXIT             
P00768     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00768        PERFORM 7800-DELETE-ATTRB-CD   THRU 7800-EXIT             
P00768     END-IF.                                                      
P00768                                                                  
P00768     PERFORM 7520-BILL-NOTIFY-MNT-TRNHIST                         
P00768                                       THRU 7520-EXIT.            
P00768*                                                                         
P00768 2420-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
      *****************************************************************         
      * 2500-MAINTENANCE-HISTORY.                                     *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
       2500-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '2500'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7050-SELECT-CURRENT-DATE THRU 7050-EXIT.             
           MOVE WS-CURRENT-TIMESTAMP   TO MH-TRANS-HIST-SEQ-NO,         
           MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS                 
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE NF-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE WS-USER-ID             TO MH-USER-ID.                   
           MOVE WS-PROGRAM-ID          TO MH-APPL-PROGRAM-ID.           
           MOVE 210                    TO MH-TRAN-COMMENT-LEN.          
           MOVE IN-MESSAGE             TO MH-TRAN-COMMENT-TEXT.         
           MOVE +0                     TO MI-TRAN-APPL-NO.              
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2550-WRITE-MNT-HIST.                                          *         
      *     WRITE TRAN HISTORY                                        *         
      *****************************************************************         
       2550-WRITE-MNT-HIST.                                             
           ADD  +1                     TO MI-TRAN-APPL-NO               
           MOVE SPACES                 TO MI-TABLE-ID                   
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO    
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *     JOURNALING ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 7000-GET-DEST-PRESENT.                                        *         
      *****************************************************************         
       7000-GET-DEST-PRESENT.                                           
                                                                        
           EXEC SQL                                                     
              SELECT DISTINCT 'Y'                                       
                INTO :WS-PRESENT                                        
                FROM CSS_EDI_ACCT_DEST WITH(READUNCOMMITTED)                    
               WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                        
               AND   DEST_ID    = :NF-DEST-ID                           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DISTINCT 'Y'                                               
MFA-TR*         INTO :WS-PRESENT                                                
MFA-TR*         FROM CSS_EDI_ACCT_DEST                                          
MFA-TR*        WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                                
MFA-TR*        AND   DEST_ID    = :NF-DEST-ID                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_ACCT_DEST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE NF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'DEST_ID   '         TO TABLE-ELEMENT-2              
              MOVE NF-DEST-ID           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7050-SELECT-CURRENT-DATE.                                     *          
      ****************************************************************          
       7050-SELECT-CURRENT-DATE.                                        
           EXEC SQL                                                     
T35434       SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP              
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-DATE = CURRENT DATE                                
MFA-TR*         ,:WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
T35434         MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-VALIDATE-ACCOUNT                                          *        
      *      CHECK TO MAKE SURE THAT ACCOUNT NO EXISTS                 *        
      ******************************************************************        
       7300-VALIDATE-ACCOUNT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT ACCOUNT_NO                                        
P00768               ,NO_BILL_COPIES                                    
P00768               ,COMPANY_NO                                        
P00768               ,CODE_PERM_BILL                                    
P00768               ,ADDRESS_ID                                        
P00768               ,ADDRESS_FORMAT                                    
                 INTO :AT-ACCOUNT-NO                                    
P00768               ,:WS-OLD-NO-COPIES                                 
P00768               ,:AT-COMPANY-NO                                    
P00768               ,:WS-PRV-CODE-PERM-BILL                            
P00768               ,:AT-ADDRESS-ID                                    
P00768               ,:AT-ADDRESS-FORMAT                                
                 FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ACCOUNT_NO                                                
MFA-TR*              ,NO_BILL_COPIES                                            
MFA-TR*              ,COMPANY_NO                                                
MFA-TR*              ,CODE_PERM_BILL                                            
MFA-TR*              ,ADDRESS_ID                                                
MFA-TR*              ,ADDRESS_FORMAT                                            
MFA-TR*          INTO :AT-ACCOUNT-NO                                            
MFA-TR*              ,:WS-OLD-NO-COPIES                                         
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*              ,:WS-PRV-CODE-PERM-BILL                                    
MFA-TR*              ,:AT-ADDRESS-ID                                            
MFA-TR*              ,:AT-ADDRESS-FORMAT                                        
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SQLCODE                  TO  S-RETURN-CODE           
              MOVE 'D0142'                  TO  S-ERROR-MSG             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 7500-GET-PREV-ACCT-DEST.                                       *        
      *      GET THE PREVIOUS VALUES FROM CSS_EDI_ACCT-DEST SO THAT    *        
      *      THE CHANGED VALUES WILL BE KNOWN FOR MAINTENANCE HISTORY  *        
      ******************************************************************        
       7500-GET-PREV-ACCT-DEST.                                         
      *                                                                         
            EXEC SQL                                                    
                                                                        
                SELECT AUTOMATIC_EMAIL_FL                               
                      ,EDI_ID_QUAL                                      
                      ,EDI_RECEIVER_ID                                  
                      ,EMAIL_GROUP                                      
                      ,STAT_BEGIN_DT                                    
                      ,STAT_END_DT                                      
                      ,STATUS_CD                                        
                      ,HOLD_DAYS_NO                                     
                  INTO                                                  
                       :WS-PREV-AUTO-EMAIL-FL                           
                      ,:WS-PREV-EDI-ID-QUAL                             
                      ,:WS-PREV-EDI-RECEIVER-ID                         
                      ,:WS-PREV-EMAIL-GROUP                             
                      ,:WS-PREV-STAT-BEGIN-DT                           
                      ,:WS-PREV-STAT-END-DT                             
                      ,:WS-PREV-STATUS-CD                               
                      ,:WS-PREV-HOLD-DAYS-NO                            
                  FROM CSS_EDI_ACCT_DEST WITH(READUNCOMMITTED)                  
                 WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                      
                   AND DEST_ID    = :NF-DEST-ID                         
T35434                                                           
            END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*                                                                         
MFA-TR*         SELECT AUTOMATIC_EMAIL_FL                                       
MFA-TR*               ,EDI_ID_QUAL                                              
MFA-TR*               ,EDI_RECEIVER_ID                                          
MFA-TR*               ,EMAIL_GROUP                                              
MFA-TR*               ,STAT_BEGIN_DT                                            
MFA-TR*               ,STAT_END_DT                                              
MFA-TR*               ,STATUS_CD                                                
MFA-TR*               ,HOLD_DAYS_NO                                             
MFA-TR*           INTO                                                          
MFA-TR*                :WS-PREV-AUTO-EMAIL-FL                                   
MFA-TR*               ,:WS-PREV-EDI-ID-QUAL                                     
MFA-TR*               ,:WS-PREV-EDI-RECEIVER-ID                                 
MFA-TR*               ,:WS-PREV-EMAIL-GROUP                                     
MFA-TR*               ,:WS-PREV-STAT-BEGIN-DT                                   
MFA-TR*               ,:WS-PREV-STAT-END-DT                                     
MFA-TR*               ,:WS-PREV-STATUS-CD                                       
MFA-TR*               ,:WS-PREV-HOLD-DAYS-NO                                    
MFA-TR*           FROM CSS_EDI_ACCT_DEST                                        
MFA-TR*          WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                              
MFA-TR*            AND DEST_ID    = :NF-DEST-ID                                 
MFA-TR*           WITH UR                                                       
MFA-TR*     END-EXEC.                                                           
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                   
                                                                        
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7510-FIND-CHANGED-FIELDS.                                      *        
      ******************************************************************        
       7510-FIND-CHANGED-FIELDS.                                        
                                                                        
            IF WS-PREV-AUTO-EMAIL-FL NOT = NF-AUTOMATIC-EMAIL-FL        
               MOVE 'EMAIL FLAG'          TO MI-COLUMN-DESC             
               MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-AUTO-EMAIL-FL TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE NF-AUTOMATIC-EMAIL-FL TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-EDI-ID-QUAL NOT = NF-EDI-ID-QUAL                 
               MOVE 'EDI ID QUAL'         TO MI-COLUMN-DESC             
               MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-EDI-ID-QUAL   TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE NF-EDI-ID-QUAL        TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-EDI-RECEIVER-ID NOT = NF-EDI-RECEIVER-ID         
               MOVE 'DUN NO'                TO MI-COLUMN-DESC           
               MOVE +15                     TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE WS-PREV-EDI-RECEIVER-ID TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE +15                     TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE NF-EDI-RECEIVER-ID      TO MI-CHG-COLUMN-VALUE-TEXT 
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-EMAIL-GROUP NOT = NF-EMAIL-GROUP                 
               MOVE 'EMAIL GROUP'        TO MI-COLUMN-DESC              
               MOVE +30                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-EMAIL-GROUP  TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +30                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE NF-EMAIL-GROUP       TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            MOVE WS-PREV-STAT-BEGIN-DT TO WS-DATE-CCYY-MM-DD            
            MOVE WS-DATE-CCYY          TO WS-DATE2-CCYY                 
            MOVE WS-DATE-MM            TO WS-DATE2-MM                   
            MOVE WS-DATE-DD            TO WS-DATE2-DD                   
            MOVE WS-DATE-MM-DD-CCYY    TO WS-PREV-STAT-BEGIN-DT         
            IF WS-PREV-STAT-BEGIN-DT NOT = NF-STAT-BEGIN-DT             
               MOVE 'STAT BEGIN DT'       TO MI-COLUMN-DESC             
               MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-STAT-BEGIN-DT TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE NF-STAT-BEGIN-DT      TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            MOVE WS-PREV-STAT-END-DT   TO WS-DATE-CCYY-MM-DD            
            MOVE WS-DATE-CCYY          TO WS-DATE2-CCYY                 
            MOVE WS-DATE-MM            TO WS-DATE2-MM                   
            MOVE WS-DATE-DD            TO WS-DATE2-DD                   
            MOVE WS-DATE-MM-DD-CCYY    TO WS-PREV-STAT-END-DT           
            IF WS-PREV-STAT-END-DT NOT = NF-STAT-END-DT                 
               MOVE 'STAT END DT'        TO MI-COLUMN-DESC              
               MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-STAT-END-DT  TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE NF-STAT-END-DT       TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-STATUS-CD NOT = NF-STATUS-CD                     
               MOVE 'STATUS CD'          TO MI-COLUMN-DESC              
               MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-STATUS-CD    TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE NF-STATUS-CD         TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-HOLD-DAYS-NO NOT = NF-HOLD-DAYS-NO               
               MOVE 'HOLD DAYS'           TO MI-COLUMN-DESC             
               MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-HOLD-DAYS-NO  TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE NF-HOLD-DAYS-NO       TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
                                                                        
       7510-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
P00768******************************************************************        
P00768* 7520-BILL-NOTIFY-MNT-TRNHIST.                                  *        
P00768* WRITE TRAN HISTORY FOR PAPERLESS/EMAIL & PAPER ONLY UPDATES    *        
P00768******************************************************************        
P00768 7520-BILL-NOTIFY-MNT-TRNHIST.                                    
P00768*                                                                         
P00768     IF WS-OLD-NO-COPIES NOT EQUAL AT-NO-BILL-COPIES              
P00768        MOVE 'NO BILL COPIES'          TO MI-COLUMN-DESC          
P00768        MOVE +4                        TO MI-PRV-COLUMN-VALUE-LEN 
P00768        MOVE WS-OLD-NO-COPIES          TO MI-PRV-COLUMN-VALUE-TEXT
P00768        MOVE +4                        TO MI-CHG-COLUMN-VALUE-LEN 
P00768        MOVE AT-NO-BILL-COPIES         TO MI-CHG-COLUMN-VALUE-TEXT
P00768        MOVE SPACES                    TO MI-TABLE-ID             
P00768        PERFORM 2550-WRITE-MNT-HIST    THRU 2550-EXIT             
P00768     END-IF.                                                      
P00768                                                                  
P00768     IF WS-PRV-CODE-PERM-BILL NOT EQUAL AT-CODE-PERM-BILL         
P00768        MOVE 'PERM PULL CODE'          TO MI-COLUMN-DESC          
P00768        EVALUATE WS-PRV-CODE-PERM-BILL                            
P00768            WHEN 'A'                                              
P00768               MOVE +17                TO MI-PRV-COLUMN-VALUE-LEN 
P00768               MOVE 'NORMAL/NOT PULLED'                           
P00768                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00768            WHEN 'D'                                              
P00768               MOVE +13                TO MI-PRV-COLUMN-VALUE-LEN 
P00768               MOVE 'EXTRA POSTAGE'                               
P00768                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00768        END-EVALUATE                                              
P00768        EVALUATE AT-CODE-PERM-BILL                                
P00768            WHEN 'A'                                              
P00768               MOVE +17                TO MI-PRV-COLUMN-VALUE-LEN 
P00768               MOVE 'NORMAL/NOT PULLED'                           
P00768                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00768            WHEN 'D'                                              
P00768               MOVE +13                TO MI-PRV-COLUMN-VALUE-LEN 
P00768               MOVE 'EXTRA POSTAGE'                               
P00768                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00768        END-EVALUATE                                              
P00768        MOVE SPACES                    TO MI-TABLE-ID             
P00768        PERFORM 2550-WRITE-MNT-HIST    THRU 2550-EXIT             
P00768     END-IF.                                                      
P00768                                                                  
P00768     IF WS-BILL-NOTIFICATION NOT EQUAL WS-NEW-BILL-NOTIFICATION   
P00768        MOVE 'BILL NOTIFY OPT'         TO MI-COLUMN-DESC          
P00768        EVALUATE WS-BILL-NOTIFICATION                             
P00768            WHEN 1                                                
P00768              MOVE +15                 TO MI-PRV-COLUMN-VALUE-LEN 
P00768              MOVE 'PAPERLESS/EMAIL'   TO MI-PRV-COLUMN-VALUE-TEXT
P00768            WHEN 2                                                
P00768              MOVE +15                 TO MI-PRV-COLUMN-VALUE-LEN 
P00768              MOVE 'EMAIL AND PAPER'   TO MI-PRV-COLUMN-VALUE-TEXT
P00768            WHEN 3                                                
P00768              MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN 
P00768              MOVE 'PAPER ONLY'        TO MI-PRV-COLUMN-VALUE-TEXT
P00768            WHEN 4                                                
P00768              MOVE +17                 TO MI-PRV-COLUMN-VALUE-LEN 
P00768              MOVE 'NO PAPER/NO EMAIL' TO MI-PRV-COLUMN-VALUE-TEXT
P00768            WHEN 5                                                
P00768              MOVE +25                 TO MI-PRV-COLUMN-VALUE-LEN 
P00768              MOVE 'SYSTEM DEFAULT PAPER ONLY'                    
P00768                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00768        END-EVALUATE                                              
P00768        EVALUATE WS-NEW-BILL-NOTIFICATION                         
P00768            WHEN 1                                                
P00768              MOVE +15                 TO MI-CHG-COLUMN-VALUE-LEN 
P00768              MOVE 'PAPERLESS/EMAIL'   TO MI-CHG-COLUMN-VALUE-TEXT
P00768            WHEN 2                                                
P00768              MOVE +15                 TO MI-CHG-COLUMN-VALUE-LEN 
P00768              MOVE 'EMAIL AND PAPER'   TO MI-CHG-COLUMN-VALUE-TEXT
P00768            WHEN 3                                                
P00768              MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN 
P00768              MOVE 'PAPER ONLY'        TO MI-CHG-COLUMN-VALUE-TEXT
P00768            WHEN 4                                                
P00768              MOVE +17                 TO MI-CHG-COLUMN-VALUE-LEN 
P00768              MOVE 'NO PAPER/NO EMAIL' TO MI-CHG-COLUMN-VALUE-TEXT
P00768            WHEN 5                                                
P00768              MOVE +25                 TO MI-CHG-COLUMN-VALUE-LEN 
P00768              MOVE 'SYSTEM DEFAULT PAPER ONLY'                    
P00768                                       TO MI-CHG-COLUMN-VALUE-TEXT
P00768        END-EVALUATE                                              
P00768        MOVE SPACES                    TO MI-TABLE-ID             
P00768        PERFORM 2550-WRITE-MNT-HIST    THRU 2550-EXIT             
P00768     END-IF.                                                      
P00768*                                                                         
P00768 7520-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
P00768 7550-CHECK-ADDRESS.                                              
P00768                                                                  
P00768     EXEC SQL                                                     
P00768         SELECT ADDR_COUNTRY                                      
P00768           INTO :DZ-ADDR-COUNTRY                                  
P00768           FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
P00768          WHERE ADDRESS_ID    = :AT-ADDRESS-ID                    
P00768            AND ADDR_COUNTRY  > ' '                               
P00768            AND ADDR_COUNTRY <> 'USA'                             
P00768            AND ADDR_COUNTRY <> 'US'                              
P00768            AND ADDR_COUNTRY <> 'UNITED STATES'                   
P00768                                                           
P00768                                                      
P00768     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDR_COUNTRY                                              
MFA-TR*          INTO :DZ-ADDR-COUNTRY                                          
MFA-TR*          FROM CSS_ADDR_FREEFORM                                         
MFA-TR*         WHERE ADDRESS_ID    = :AT-ADDRESS-ID                            
MFA-TR*           AND ADDR_COUNTRY  > ' '                                       
MFA-TR*           AND ADDR_COUNTRY = 'USA'                                     
MFA-TR*           AND ADDR_COUNTRY = 'US'                                      
MFA-TR*           AND ADDR_COUNTRY = 'UNITED STATES'                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768                                                                  
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768                                                                  
P00768     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00768         WHEN SUCCESSFUL-CALL                                     
P00768             MOVE 'Y'                   TO WS-INTER-ADD           
P00768         WHEN NOT-FOUND                                           
P00768             MOVE 'N'                   TO WS-INTER-ADD           
P00768         WHEN OTHER                                               
P00768             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
P00768             MOVE '7550'                TO ACTIVE-PARAGRAPH       
P00768             MOVE 'SELECT'              TO ABEND-FUNCTION         
P00768             MOVE 'CSS_ADDR_FREEFORM'   TO TABLE-1                
P00768             MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1        
P00768             MOVE AT-ADDRESS-ID         TO HOSTVAR-ELEMENT-1      
P00768             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
P00768             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
P00768     END-EVALUATE.                                                
P00768                                                                  
P00768 7550-EXIT.                                                       
P00768     EXIT.                                                        
P00768                                                                  
P00768******************************************************************        
P00768* 7600-GET-ACTIVE-ACCT-DEST.                                     *        
P00768*      CHECK IF ACCOUNT IS CURRENTLY SETUP ON EDI.               *        
P00768******************************************************************        
P00768 7600-GET-ACTIVE-ACCT-DEST.                                       
P00768*                                                                         
P00768     EXEC SQL                                                     
P00768        SELECT TOP(1) 'Y',
              DEST_ID                                            
P00768          INTO :WS-PAPERLESS                                      
P00768              ,:NF-DEST-ID                                        
P00768          FROM CSS_EDI_ACCT_DEST WITH(READUNCOMMITTED)                    
P00768         WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                        
P00768           AND STATUS_CD  = 'A'                                   
P00768         ORDER BY STAT_BEGIN_DT                                   
P00768                                              
P00768                                                           
P00768     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,DEST_ID                                                    
MFA-TR*         INTO :WS-PAPERLESS                                              
MFA-TR*             ,:NF-DEST-ID                                                
MFA-TR*         FROM CSS_EDI_ACCT_DEST                                          
MFA-TR*        WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                                
MFA-TR*          AND STATUS_CD  = 'A'                                           
MFA-TR*        ORDER BY STAT_BEGIN_DT                                           
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768                                                                  
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768                                                                  
P00768     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00768        CONTINUE                                                  
P00768     ELSE                                                         
P00768        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00768        MOVE '7600'                     TO ACTIVE-PARAGRAPH       
P00768        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00768        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
P00768                                           ABEND-TABLES           
P00768        MOVE 'CSS_EDI_ACCT_DEST'        TO TABLE-1                
P00768        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00768        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00768     END-IF.                                                      
P00768                                                                  
P00768 7600-EXIT.                                                       
P00768      EXIT.                                                       
P00768*                                                                         
P00768******************************************************************07969900
P00768* 7650-CHECK-ACCT-ATTRB                                          *07492029
P00768*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
P00768******************************************************************07550000
P00768 7650-CHECK-ACCT-ATTRB.                                           
P00768                                                                  
P00768     EXEC SQL                                                     
P00768          SELECT 'Y'                                              
P00768            INTO :WS-NO-NOTIFICATION                              
P00768            FROM CSS_ATTRIBUTE      WZ                            
P00768                ,CSS_ACCT_ATTRIBUTE YP                            
P00768           WHERE YP.ACCOUNT_NO        = :YP-ACCOUNT-NO            
P00768             AND WZ.COMPANY_NO        = :WZ-COMPANY-NO            
P00768             AND WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
P00768             AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
P00768             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
P00768     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768                                                                  
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768                                                                  
P00768     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00768        NEXT SENTENCE                                             
P00768     ELSE                                                         
P00768        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00768        MOVE '7650'                     TO ACTIVE-PARAGRAPH       
P00768        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00768        MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
P00768        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00768        MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00768        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00768        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00768     END-IF.                                                      
P00768                                                                  
P00768 7650-EXIT.                                                       
P00768     EXIT.                                                        
P00768******************************************************************07969900
P00768* 7700-CHECK-ATTRB                                               *07492029
P00768*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
P00768******************************************************************07550000
P00768 7700-CHECK-ATTRB.                                                
P00768                                                                  
P00768     EXEC SQL                                                     
P00768          SELECT 'Y'                                              
P00768            INTO :WS-PAPER-ONLY                                   
P00768            FROM CSS_ATTRIBUTE WZ                                 
P00768                ,CSS_ACCT_ATTRIBUTE YP                            
P00768           WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
P00768             AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
P00768             AND WZ.COMPANY_NO        = :WZ-COMPANY-NO            
P00768             AND YP.ACCOUNT_NO        = :YP-ACCOUNT-NO            
P00768             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
P00768             AND WZ.ATTRIBUTE_TYPE_TX = :WS-ATTRIBUTE-TYPE        
P00768     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768                                                                  
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768                                                                  
P00768     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00768        NEXT SENTENCE                                             
P00768     ELSE                                                         
P00768        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00768        MOVE '7700'                     TO ACTIVE-PARAGRAPH       
P00768        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00768        MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
P00768        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00768        MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00768        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00768        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00768     END-IF.                                                      
P00768                                                                  
P00768 7700-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
P00768******************************************************************07969900
P00768* 7750-GET-EBILL-REG-IND                                         *07492029
P00768*     SELECT FROM CSS_CUST_STATS                                 *07530029
P00768******************************************************************07550000
P00768 7750-GET-EBILL-REG-IND.                                          
P00768                                                                  
P00768     EXEC SQL                                                     
P00768          SELECT TOP(1) EBILL_REGISTER_IND                               
P00768            INTO :CE-EBILL-REGISTER-IND                           
P00768            FROM CSS_CUST_STATS CE WITH(READUNCOMMITTED)                  
P00768                ,CSS_ACCOUNT    AT WITH(READUNCOMMITTED)                  
P00768           WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                
P00768             AND AT.CUSTOMER_NO   = CE.CUSTOMER_NO                
P00768             AND CE.CUSTOMER_TYPE = 'C'                           
P00768                                              
P00768                                                           
P00768     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT EBILL_REGISTER_IND                                       
MFA-TR*           INTO :CE-EBILL-REGISTER-IND                                   
MFA-TR*           FROM CSS_CUST_STATS CE                                        
MFA-TR*               ,CSS_ACCOUNT    AT                                        
MFA-TR*          WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                        
MFA-TR*            AND AT.CUSTOMER_NO   = CE.CUSTOMER_NO                        
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*          FETCH FIRST ROW ONLY                                           
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768                                                                  
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768                                                                  
P00768     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00768        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00768           MOVE SPACES                  TO CE-EBILL-REGISTER-IND  
P00768        ELSE                                                      
P00768           NEXT SENTENCE                                          
P00768        END-IF                                                    
P00768     ELSE                                                         
P00768        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00768        MOVE '7750'                     TO ACTIVE-PARAGRAPH       
P00768        MOVE 'SELECT'                   TO ABEND-FUNCTION         
P00768        MOVE 'CSS_CUST_STATS'           TO TABLE-1                
P00768        MOVE 'CSS_ACCOUNT'              TO TABLE-2                
P00768        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00768        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00768        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00768        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00768     END-IF.                                                      
P00768                                                                  
P00768 7750-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                 07470000
P00768******************************************************************        
P00768**  7800-DELETE-ATTRB-CD                                        **        
P00768**  DELETE ROW IN CSS_ACCT_ATTRIBUTE                            **        
P00768******************************************************************        
P00768 7800-DELETE-ATTRB-CD.                                            
P00768*                                                                         
P00768     EXEC SQL                                                     
P00768         DELETE FROM CSS_ACCT_ATTRIBUTE                           
P00768          WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
P00768            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
P00768                                                      
P00768     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_ATTRIBUTE                                   
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768*                                                                         
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768*                                                                         
P00768     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00768        NEXT SENTENCE                                             
P00768     ELSE                                                         
P00768        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00768        MOVE '7800'                     TO ACTIVE-PARAGRAPH       
P00768        MOVE 'DELETE'                   TO ABEND-FUNCTION         
P00768        MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
P00768        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00768        MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00768        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00768        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00768     END-IF.                                                      
P00768*                                                                         
P00768 7800-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
P00768******************************************************************        
P00768**  7900-UPDATE-ACCT                                            **        
P00768**  UPDATE NO OF BILL COPIES FIELD ON CSS_ACCOUNT TABLE         **        
P00768******************************************************************        
P00768 7900-UPDATE-ACCT.                                                
P00768*                                                                         
P00768     EXEC SQL                                                     
P00768         UPDATE CSS_ACCOUNT                                       
P00768            SET NO_BILL_COPIES = :AT-NO-BILL-COPIES               
P00768               ,CODE_PERM_BILL = :AT-CODE-PERM-BILL               
P00768          WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
P00768                                                      
P00768     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                       
MFA-TR*              ,CODE_PERM_BILL = :AT-CODE-PERM-BILL                       
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768*                                                                         
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768*                                                                         
P00768     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00768        NEXT SENTENCE                                             
P00768     ELSE                                                         
P00768        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00768        MOVE '7900'                     TO ACTIVE-PARAGRAPH       
P00768        MOVE 'UPDATE'                   TO ABEND-FUNCTION         
P00768        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
P00768        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00768        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00768        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00768        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00768     END-IF.                                                      
P00768*                                                                         
P00768 7900-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
P00768******************************************************************        
P00768**  7950-INSERT-ATTRB-CD                                        **        
P00768**  INSERT A ROW IN CSS_ACCT_ATTRIBUTE TABLE                    **        
P00768******************************************************************        
P00768 7950-INSERT-ATTRB-CD.                                            
P00768*                                                                         
P00768     EXEC SQL                                                     
P00768         INSERT INTO CSS_ACCT_ATTRIBUTE                           
P00768               (ACCOUNT_NO                                        
P00768               ,ATTRIBUTE_DESC                                    
P00768               ,ATTRIBUTE_VALUE_CD                                
P00768               ,ATTRIBUTE_VALUE_DT                                
P00768               ,ATTRIBUTE_VALUE_TX                                
P00768               ,STATUS_CD)                                        
P00768         VALUES                                                   
P00768               (:YP-ACCOUNT-NO                                    
P00768               ,:YP-ATTRIBUTE-DESC                                
P00768               ,:YP-ATTRIBUTE-VALUE-CD                            
P00768               ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
P00768               ,:YP-ATTRIBUTE-VALUE-TX                            
P00768               ,:YP-STATUS-CD)                                    
P00768     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*              (ACCOUNT_NO                                                
MFA-TR*              ,ATTRIBUTE_DESC                                            
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,ATTRIBUTE_VALUE_TX                                        
MFA-TR*              ,STATUS_CD)                                                
MFA-TR*        VALUES                                                           
MFA-TR*              (:YP-ACCOUNT-NO                                            
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                        
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,CURRENT DATE                                              
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX                                    
MFA-TR*              ,:YP-STATUS-CD)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00768*                                                                         
P00768     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
P00768*                                                                         
P00768     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00768        NEXT SENTENCE                                             
P00768     ELSE                                                         
P00768        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
P00768        MOVE '7950'                     TO ACTIVE-PARAGRAPH       
P00768        MOVE 'INSERT'                   TO ABEND-FUNCTION         
P00768        MOVE 'CSS_ACCT_ATTRIBUTE'       TO TABLE-1                
P00768        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
P00768        MOVE YP-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
P00768        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00768        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00768     END-IF.                                                      
P00768*                                                                         
P00768 7950-EXIT.                                                       
P00768     EXIT.                                                        
P00768*                                                                         
      ******************************************************************        
      * 8000A-DELETE-GTT-ROWS.                                         *        
      ******************************************************************        
       8000A-DELETE-GTT-ROWS.                                           
                                                                        
           MOVE                                                         
           'DELETE ROWS'                                                
               TO S-SQL-STATEMENT-V.                                    
      *                                                                         
            EXEC SQL                                                    
                DELETE FROM #CSR03286_R1                         
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR03286_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
                NEXT SENTENCE                                           
            ELSE                                                        
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE SQLCODE              TO ABEND-SQLCODE               
               MOVE SQLSTATE             TO ABEND-SQLSTATE              
               MOVE '8000A'              TO ACTIVE-PARAGRAPH            
               MOVE 'DELETE'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSR03286_R1'        TO TABLE-1                     
               MOVE SPACES               TO TABLE-ELEMENT-1             
               MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       8000A-EXIT.                                                      
           EXIT.                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           MOVE 'INSERT INTO CSR03286_R1' TO S-SQL-STATEMENT-V.         
                                                                        
           EXEC SQL                                                     
                                                                        
               INSERT INTO #CSR03286_R1                          
                   (                                                    
                     RETURN_CODE                                        
                    ,ERROR_MSG                                          
                   )                                                    
               VALUES                                                   
                   (                                                    
                    :S-RETURN-CODE                                      
                   ,:S-ERROR-MSG                                        
                   )                                                    
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO SESSION.CSR03286_R1                                  
MFA-TR*            (                                                            
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,ERROR_MSG                                                  
MFA-TR*            )                                                            
MFA-TR*        VALUES                                                           
MFA-TR*            (                                                            
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-ERROR-MSG                                                
MFA-TR*            )                                                            
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8900'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSR03286_R1'        TO TABLE-1                      
              MOVE 'RETURN_CODE'        TO TABLE-ELEMENT-1              
              MOVE S-RETURN-CODE        TO HOSTVAR-ELEMENT-1            
************* PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           ADD 1 TO CTR-ROWS.                                           
           INITIALIZE GTT-RETURN-FIELDS.                                
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-UPDATE-ACCT-DEST.                                         *        
      ******************************************************************        
       8200-UPDATE-ACCT-DEST.                                           
      *                                                                         
           EXEC SQL                                                     
                                                                        
               UPDATE CSS_EDI_ACCT_DEST                                 
                SET                                                     
                 AUTOMATIC_EMAIL_FL   = :NF-AUTOMATIC-EMAIL-FL          
                ,EDI_ID_QUAL          = :NF-EDI-ID-QUAL                 
                ,EDI_RECEIVER_ID      = :NF-EDI-RECEIVER-ID             
                ,EMAIL_GROUP          = :NF-EMAIL-GROUP                 
                ,LAST_UPDATE_TS       = CIS.CURRENT$TIMESTAMP()               
                ,LAST_UPDATE_USERID   = :WS-USER-ID                     
                ,STAT_BEGIN_DT        = IIF(TRY_CONVERT(DATE, 
                                                      :NF-STAT-BEGIN-DT
              ) IS NULL OR (PATINDEX('%.%', :NF-STAT-BEGIN-DT
              ) <> 0) OR (LEN(:NF-STAT-BEGIN-DT) <> 10), CIS.CHAR2DATE(
                                                      :NF-STAT-BEGIN-DT
              ), CONVERT(DATE, :NF-STAT-BEGIN-DT) )               
                ,STAT_END_DT          = IIF(TRY_CONVERT(DATE, 
                                                        :NF-STAT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :NF-STAT-END-DT
              ) <> 0) OR (LEN(:NF-STAT-END-DT) <> 10), CIS.CHAR2DATE(
                                                        :NF-STAT-END-DT
              ), CONVERT(DATE, :NF-STAT-END-DT) )                 
                ,STATUS_CD            = :NF-STATUS-CD                   
                ,HOLD_DAYS_NO         = :NF-HOLD-DAYS-NO                
               WHERE ACCOUNT_NO       = :NF-ACCOUNT-NO                  
               AND   DEST_ID          = :NF-DEST-ID                     
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        UPDATE CSS_EDI_ACCT_DEST                                         
MFA-TR*         SET                                                             
MFA-TR*          AUTOMATIC_EMAIL_FL   = :NF-AUTOMATIC-EMAIL-FL                  
MFA-TR*         ,EDI_ID_QUAL          = :NF-EDI-ID-QUAL                         
MFA-TR*         ,EDI_RECEIVER_ID      = :NF-EDI-RECEIVER-ID                     
MFA-TR*         ,EMAIL_GROUP          = :NF-EMAIL-GROUP                         
MFA-TR*         ,LAST_UPDATE_TS       = CURRENT TIMESTAMP                       
MFA-TR*         ,LAST_UPDATE_USERID   = :WS-USER-ID                             
MFA-TR*         ,STAT_BEGIN_DT        = :NF-STAT-BEGIN-DT                       
MFA-TR*         ,STAT_END_DT          = :NF-STAT-END-DT                         
MFA-TR*         ,STATUS_CD            = :NF-STATUS-CD                           
MFA-TR*         ,HOLD_DAYS_NO         = :NF-HOLD-DAYS-NO                        
MFA-TR*        WHERE ACCOUNT_NO       = :NF-ACCOUNT-NO                          
MFA-TR*        AND   DEST_ID          = :NF-DEST-ID                             
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_ACCT_DEST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE NF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'DEST_ID   '         TO TABLE-ELEMENT-2              
              MOVE NF-DEST-ID           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8210-INSERT-ACCT-DEST.                                         *        
      ******************************************************************        
       8210-INSERT-ACCT-DEST.                                           
      *                                                                         
           EXEC SQL                                                     
                                                                        
               INSERT INTO CSS_EDI_ACCT_DEST                            
                  (                                                     
                   ACCOUNT_NO                                           
                  ,DEST_ID                                              
                  ,AUTOMATIC_EMAIL_FL                                   
                  ,EDI_ID_QUAL                                          
                  ,EDI_RECEIVER_ID                                      
                  ,EMAIL_GROUP                                          
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,STAT_BEGIN_DT                                        
                  ,STAT_END_DT                                          
                  ,STATUS_CD                                            
                  ,HOLD_DAYS_NO                                         
                  )                                                     
                 VALUES                                                 
                  (                                                     
                   :NF-ACCOUNT-NO                                       
                  ,:NF-DEST-ID                                          
                  ,:NF-AUTOMATIC-EMAIL-FL                               
                  ,:NF-EDI-ID-QUAL                                      
                  ,:NF-EDI-RECEIVER-ID                                  
                  ,:NF-EMAIL-GROUP                                      
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:WS-USER-ID                                          
                  ,IIF(TRY_CONVERT(DATE, :NF-STAT-BEGIN-DT
              ) IS NULL OR (PATINDEX('%.%', :NF-STAT-BEGIN-DT
              ) <> 0) OR (LEN(:NF-STAT-BEGIN-DT) <> 10), CIS.CHAR2DATE(
                                                      :NF-STAT-BEGIN-DT
              ), CONVERT(DATE, :NF-STAT-BEGIN-DT) )                            
                  ,IIF(TRY_CONVERT(DATE, :NF-STAT-END-DT
              ) IS NULL OR (PATINDEX('%.%', :NF-STAT-END-DT
              ) <> 0) OR (LEN(:NF-STAT-END-DT) <> 10), CIS.CHAR2DATE(
                                                        :NF-STAT-END-DT
              ), CONVERT(DATE, :NF-STAT-END-DT) )                              
                  ,:NF-STATUS-CD                                        
                  ,:NF-HOLD-DAYS-NO                                     
                  )                                                     
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO CSS_EDI_ACCT_DEST                                    
MFA-TR*           (                                                             
MFA-TR*            ACCOUNT_NO                                                   
MFA-TR*           ,DEST_ID                                                      
MFA-TR*           ,AUTOMATIC_EMAIL_FL                                           
MFA-TR*           ,EDI_ID_QUAL                                                  
MFA-TR*           ,EDI_RECEIVER_ID                                              
MFA-TR*           ,EMAIL_GROUP                                                  
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,STAT_BEGIN_DT                                                
MFA-TR*           ,STAT_END_DT                                                  
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*           ,HOLD_DAYS_NO                                                 
MFA-TR*           )                                                             
MFA-TR*          VALUES                                                         
MFA-TR*           (                                                             
MFA-TR*            :NF-ACCOUNT-NO                                               
MFA-TR*           ,:NF-DEST-ID                                                  
MFA-TR*           ,:NF-AUTOMATIC-EMAIL-FL                                       
MFA-TR*           ,:NF-EDI-ID-QUAL                                              
MFA-TR*           ,:NF-EDI-RECEIVER-ID                                          
MFA-TR*           ,:NF-EMAIL-GROUP                                              
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*           ,:NF-STAT-BEGIN-DT                                            
MFA-TR*           ,:NF-STAT-END-DT                                              
MFA-TR*           ,:NF-STATUS-CD                                                
MFA-TR*           ,:NF-HOLD-DAYS-NO                                             
MFA-TR*           )                                                             
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_ACCT_DEST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE NF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'DEST_ID   '         TO TABLE-ELEMENT-2              
              MOVE NF-DEST-ID           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8220-DELETE-ACCT-DEST.                                         *        
      ******************************************************************        
       8220-DELETE-ACCT-DEST.                                           
                                                                        
           EXEC SQL                                                     
                                                                        
               DELETE FROM CSS_EDI_ACCT_DEST                            
               WHERE ACCOUNT_NO = :NF-ACCOUNT-NO                        
               AND   DEST_ID    = :NF-DEST-ID                           
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8220'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_ACCT_DEST'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE NF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'DEST_ID   '         TO TABLE-ELEMENT-2              
              MOVE NF-DEST-ID           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       8220-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           INITIALIZE GTT-RETURN-FIELDS.                                
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
                                                                        
               ROLLBACK                                                 
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
***********PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                          
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9100-CHECK-ERROR                                               *        
      ******************************************************************        
       9100-CHECK-ERROR.                                                
           EXIT.                                                        
                                                                        
       9100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
