       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR03279.                                     
COB303 DATE-WRITTEN.     JUNE 01, 2003.                                 
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR03279              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR03279 :                                                --         
      *--                                                            --         
      *--  #  UPDATES EDI DATA FOR HEADER, CHARGES AND USAGE.        --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--  PARAMETERS                                                --         
      *--                                                            --         
      *--      IN                                                    --         
      *--                                                            --         
      *--   ACCOUNT_NO            CHAR(13)                                      
      *--   AMT_DUE               DECIMAL(11,2)                                 
      *--   BILL_DUE_DATE         CHAR(10)                                      
      *--   BILL_NO               INTEGER                                       
      *--   CODE_STATE_ID         CHAR(2)                                       
      *--   CUSTOMER_NA           CHAR(60)                                      
      *--   DATE_BILLED           CHAR(10)                                      
      *--   DATE_CREATED          CHAR(10)                                      
      *--   DATE_READ             CHAR(10)                                      
      *--   MST_ACCT_NO           CHAR(13)                                      
      *--   MST_SUB_ACCT          CHAR(1)                                       
      *--   PURPOSE_CD            CHAR(2)                                       
      *--   SCHED_SEND_DT         CHAR(10)                                      
      *--   STATUS_CD             CHAR(1)                                       
      *--   STREET_ADDR_1         CHAR(55)                                      
      *--   STREET_ADDR_2         CHAR(55)                                      
      *--   TRANS_CD              CHAR(1)                                       
      *--   ZIP_CODE              CHAR(9)                                       
      *--   BEGIN_READ_DT         CHAR(10)                                      
      *--   BEGIN_READING         INTEGER                                       
      *--   CODE_TIME_PER         CHAR(01)                                      
      *--   CONSTANT              INTEGER                                       
      *--   END_READ_DT           CHAR(10)                                      
      *--   END_READING           INTEGER                                       
      *--   METER_NO              CHAR(10)                                      
      *--   NO_UNITS              INTEGER                                       
      *--   RATE_PLAN_NO          CHAR(03)                                      
      *--   SEQ_NO                SMALLINT                                      
      *--   USAGE_CD              CHAR(02)                                      
      *--   IC_NO                 SMALLINT                                      
      *--   CODE_UTIL_TYPE        CHAR(01)                                      
      *--   BILL_UNITS            INTEGER                                       
      *--   BILLED_AM             DECIMAL(9,2)                                  
      *--   CHARGE_TYPE_TX        CHAR(10)                                      
      *--   CHARGE_TYPE_DES       CHAR(255)                                     
      *--   SUB_ACCT_NO           CHAR(13)                                      
      *--   DATA_TYPE             CHAR(10)                                      
      *--   PROC_MODE             CHAR(01)                                      
      *--   EXTRACTED_FL          CHAR(01)                                      
      *--                                                            --         
      *--                                                            --         
      *--      OUT                                                   --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--      INOUT                                                 --         
      *--                                                            --         
      *--            NONE                                            --         
      *--                                                            --         
      *--  RESULT SET                                                --         
      *--                                                            --         
      *--      1                                                     --         
      *--                                                            --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                        MODIFICATION LOG                    --         
      *--                                                            --         
      *--  DATE          INITIALS    COMMENTS                        --         
      *--  -----------   --------    ----------------------------------         
      *--  02 JUN 2003   PD80186     NEW CODE                        --         
T35434*--  18 JULY 2007  PA97450     REPLACED CSS_MODEL_SQL WITH SET --         
T35434*--                            STMTS AND FOR FETCH ONLY WITH UR--         
T35434*--                            FOR CURSOR SELECTS AND WITH UR  --         
T35434*--                            FOR SINGELTON SELECTS.          --         
A01201*--  06 JUNE 2009  AP40911     TO INTERPRET EDI STATUS CODE    --         
A01201*--                            CORRECTLY.                      --         
A02177*--  24 MAR  2010  SP94986     TO AVOID THE ERROR MSG WHEN SEB --         
A02177*--                            METER NO AND AGL METER NO IS    --         
A02177*--                            NOT MATCHING BY CHECKING WITH   --         
A02177*--                            TM TABLE(ONLY FOR SEB).         --         
A02085*--  05 MAY  2010  RS40309     THE EXTRACTED FLAG WAS NOT USED --         
A02085*--                            AND IS NOW BEING USED AS THE    --         
A02085*--                            RECONCILIATION FLAG.            --         
A05460*--  25 APRIL 2016             GET THE USER ID AS INPUT FROM UI--         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03279'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_ACCOUNT -AT                                              *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_EDI_BILL_HDR -HZ                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILHDR                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_EDI_BILL_CHRGS -HF                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLCHGS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_EDI_BILL_USAGE -HW                                       *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBLUSGE                                                  
           END-EXEC.                                                            
                                                                        
A02177******************************************************************        
A02177*   CSS_DELINQUENCY - C8                                                  
A02177******************************************************************        
A02177     EXEC SQL                                                             
A02177        INCLUDE TBDELQ                                                    
A02177     END-EXEC.                                                            
A02177*                                                                         
      ******************************************************************        
      *   CSS_MTRD_ENVRNMT -MN                                        *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
A02177******************************************************************        
A02177*   CSS_DIST_XREF_MTR -  TM                                     *         
A02177******************************************************************        
A02177     EXEC SQL                                                             
A02177        INCLUDE TBMRKXMT                                                  
A02177     END-EXEC.                                                            
A02177*                                                                         
A02177******************************************************************        
A02177*   CSS_MKT_XREF_ACCT -  XM                                     *         
A02177******************************************************************        
A02177     EXEC SQL                                                             
A02177        INCLUDE TBMRKXR                                                   
A02177     END-EXEC.                                                            
A02177*                                                                         
      ******************************************************************        
      *   CSS_UTIL_ENVRNMT -UT                                        *         
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *   CSS_MNT_TRANS_HIST -MH                                      *         
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_MT_TRN_HST_DET -MI                                      *         
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----< ERROR HANDLING >                                                   
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
      *                                                                         
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      *                                                                 01570004
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
      *                                                                         
       01  WS-ACTIVE-RETURN-CODE1     PIC S9(9)  COMP VALUE 0.          
      *                                                                         
       01  GTT-MISC-FIELDS.                                             
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR03279'.      
           05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
           05  GTT-ROW.                                                 
               49 GTT-ROW-LEN          PIC S9(04) COMP.                 
               49 GTT-ROW-CHAR         PIC X(1024).                     
           05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  WS-LITERALS.                                                 
           05  WS-SUBROUTINE-IDS.                                       
               10  CSRERLOG              PIC X(8) VALUE 'CSRERLOG'.     
      *                                                                         
A02177 01  WS-DATABASE                   PIC 9(01)  VALUE 0.            
A02177     88 SEB-DATABASE                          VALUE 2.            
      *                                                                         
      *---------------------------------------------------------------          
      *--  ERROR PROCESSING VARIABLES                               --          
      *---------------------------------------------------------------          
      *                                                                         
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
           10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
           10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
           10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
               49  S-HOST-VARIABLES-V    PIC X(255).                    
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
               49  S-SQL-STATEMENT-V     PIC X(255).                    
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
               49  S-SQL-DESCRIPTION-V   PIC X(255).                    
           10  WS-ABEND-SQLERRMC.                                       
               49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
               49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE          PIC S9(9) VALUE 0 COMP.            
           10 S-ERROR-MSG            PIC X(07) VALUE 'D0021'.           
      *                                                                         
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-CCYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
           05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
      *                                                                         
       01  WS-MISC-ITEMS.                                               
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
           05  WS-PARM-ACCOUNT-NO      PIC 9(13) VALUE ZERO.            
           05  WS-BTU-FACTOR           PIC 9(02)V9(05) VALUE 0.         
           05  WS-CONSTANT             PIC 9(06)V9(05) VALUE 0.         
           05  WS-AMT-DUE              PIC S9(11)V9(02) VALUE 0.        
           05  WS-BILLED-AM            PIC S9(09)V9(02) VALUE 0.        
           05  WS-BILLED-AM-ACCUM      PIC S9(11)V9(02) VALUE 0.        
           05  WS-AMT-DUE-T            PIC 9(14) VALUE 0.               
           05  WS-BILLED-AM-T          PIC 9(11) VALUE 0.               
           05  WS-MST-ACCT-NO          PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO           PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-STATUS-CD-L          PIC X(01) VALUE SPACES.          
           05  WS-STATUS-CD-H          PIC X(01) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-L      PIC X(10) VALUE SPACES.          
           05  WS-SCHED-SEND-DT-H      PIC X(10) VALUE SPACES.          
           05  WS-SCHED-DT-NULL        PIC S9(04) COMP VALUE +0.        
           05  WS-DATE-READ-NULL       PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-INDICATOR-1     PIC S9(04) COMP VALUE +0.        
           05  WS-NULL-IND1            PIC S9(04) COMP VALUE +0.        
           05  WS-SEQ-NULL             PIC S9(04) COMP VALUE +0.        
           05  WS-BILL-NULL            PIC S9(04) COMP VALUE +0.        
           05  WS-MAX-SEQ-NO           PIC S9(04) COMP VALUE +0.        
           05  WS-MAX-BILL-NO          PIC S9(08) COMP VALUE +0.        
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-CURRENT-TIMESTAMP    PIC X(26) VALUE SPACES.          
           05  WS-USER-ID              PIC X(07) VALUE SPACES.          
           05  WS-PROGRAM-ID           PIC X(09) VALUE SPACES.          
      *                                                                         
       01  WS-PREV-COLUMN-VALUE.                                        
           05  WS-PREV-COLUMN-AM       PIC -$$$$$$$$$$9.99.             
           05  WS-PREV-COLUMN-BTU      PIC Z9.99999.                    
           05  WS-PREV-COLUMN-CONSTANT PIC ZZZZZ9.99999.                
      *                                                                         
       01  WS-CHG-COLUMN-VALUE.                                         
           05  WS-CHG-COLUMN-AM        PIC -$$$$$$$$$$9.99.             
           05  WS-CHG-COLUMN-BTU       PIC Z9.99999.                    
           05  WS-CHG-COLUMN-CONSTANT  PIC ZZZZZ9.99999.                
      *                                                                         
       01  WS-PREVIOUS-HEADER.                                          
COB305     05 WS-PREV-AMT-DUE        PIC S9(9)V99 COMP-3 VALUE 0.      
           05  WS-PREV-CODE-STATE-ID          PIC X(02).                
           05  WS-PREV-CUSTOMER-NA.                                     
               49  WS-PREV-CUSTOMER-NA-LEN    PIC S9(04) COMP.          
               49  WS-PREV-CUSTOMER-NA-TEXT   PIC X(60).                
COB305     05 WS-PREV-MST-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.       
           05  WS-PREV-MST-SUB-ACCT-IND       PIC X(01).                
           05  WS-PREV-PURPOSE-CD             PIC X(02).                
           05  WS-PREV-SCHED-SEND-DT          PIC X(10).                
           05  WS-PREV-STATUS-CD              PIC X(01).                
           05  WS-PREV-STREET-ADDR-1.                                   
               49  WS-PREV-STREET-ADDR-1-LEN  PIC S9(04) COMP.          
               49  WS-PREV-STREET-ADDR-1-TEXT PIC X(55).                
           05  WS-PREV-STREET-ADDR-2.                                   
               49  WS-PREV-STREET-ADDR-2-LEN  PIC S9(04) COMP.          
               49  WS-PREV-STREET-ADDR-2-TEXT PIC X(55).                
           05  WS-PREV-TRANS-CD               PIC X(01).                
           05  WS-PREV-ZIP-CODE               PIC X(09).                
COB305     05 WS-PREV-REVENUE-MONTH        PIC S9(6)V COMP-3 VALUE 0.        
A02085     05  WS-PREV-EXTRACTED-FL           PIC X(01).                
      *                                                                         
       01  WS-PREVIOUS-CHRGS.                                           
COB305     05 WS-PREV-BILL-UNITS        PIC S9(9)V COMP-3 VALUE 0.          
COB305     05 WS-PREV-BILLED-AM        PIC S9(9)V9(2) COMP-3 VALUE 0.      
           05  WS-PREV-CHARGE-TYPE-TX       PIC X(10).                  
           05  WS-PREV-IC-NO-C              PIC S9(4) COMP.             
           05  WS-PREV-USAGE-CD             PIC X(2).                   
A03699     05  WS-PREV-CHARGE-TYPE-DESC.                                
A03699        10 WS-CHARGE-TYPE-DESC-LEN    PIC S9(4) USAGE COMP.       
A03699        10 WS-CHARGE-TYPE-DESC-TEXT   PIC X(255).                 
COB305     05 WS-PREV-SUB-ACCT-NO        PIC S9(13)V COMP-3 VALUE 0.         
           05  WS-PREV-CODE-UTIL-TYPE-C     PIC X(01).                  
      *                                                                         
       01  WS-PREVIOUS-USAGE.                                           
           05  WS-PREV-BEGIN-READ-DT        PIC X(10).                  
COB305     05 WS-PREV-BEGIN-READING        PIC S9(11)V COMP-3 VALUE 0.         
COB305     05 WS-PREV-BTU-FACTOR        PIC S9(02)V9(05) COMP-3 VALUE 0.    
           05  WS-PREV-CODE-TIME-PERIOD     PIC X(02).                  
           05  WS-PREV-CODE-UTIL-TYPE-U     PIC X(01).                  
COB305     05 WS-PREV-CONSTANT        PIC S9(06)V9(05) COMP-3 VALUE 0.    
           05  WS-PREV-END-READ-DT          PIC X(10).                  
COB305     05 WS-PREV-END-READING        PIC S9(11)V COMP-3 VALUE 0.         
           05  WS-PREV-IC-NO-U              PIC S9(04) COMP.            
           05  WS-PREV-METER-NO             PIC X(09).                  
COB305     05 WS-PREV-NO-UNITS        PIC S9(09)V COMP-3 VALUE 0.         
           05  WS-PREV-RATE-PLAN-NO         PIC X(03).                  
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       LINKAGE SECTION.                                                 
      *                                                                         
       01  IN-ACCOUNT-NO            PIC X(13).                          
       01  IN-AMT-DUE               PIC S9(13)V COMP-3 VALUE 0.         
       01  IN-BILL-DUE-DATE         PIC X(10).                          
       01  IN-BILL-NO               PIC S9(8) COMP VALUE 0.             
       01  IN-CODE-STATE-ID         PIC X(02).                          
       01  IN-CUSTOMER-NA           PIC X(60).                          
       01  IN-DATE-BILLED           PIC X(10).                          
       01  IN-DATE-CREATED          PIC X(10).                          
       01  IN-DATE-READ             PIC X(10).                          
       01  IN-MST-ACCT-NO           PIC X(13).                          
       01  IN-MST-SUB-ACCT          PIC X(01).                          
       01  IN-PURPOSE-CD            PIC X(02).                          
       01  IN-SCHED-SEND-DT         PIC X(10).                          
       01  IN-STATUS-CD             PIC X(01).                          
       01  IN-STREET-ADDR-1         PIC X(55).                          
       01  IN-STREET-ADDR-2         PIC X(55).                          
       01  IN-TRANS-CD              PIC X(01).                          
       01  IN-ZIP-CODE              PIC X(09).                          
       01  IN-BEGIN-READ-DT         PIC X(10).                          
       01  IN-BEGIN-READING         PIC S9(08) USAGE COMP VALUE 0.      
       01  IN-CODE-TIME-PER         PIC X(01).                          
       01  IN-CONSTANT              PIC S9(08) USAGE COMP VALUE 0.      
       01  IN-END-READ-DT           PIC X(10).                          
       01  IN-END-READING           PIC S9(08) USAGE COMP VALUE 0.      
       01  IN-METER-NO              PIC X(10).                          
       01  IN-NO-UNITS              PIC S9(08) USAGE COMP VALUE 0.      
       01  IN-RATE-PLAN-NO          PIC X(03).                          
       01  IN-SEQ-NO                PIC S9(04) USAGE COMP VALUE 0.      
       01  IN-USAGE-CD              PIC X(02).                          
       01  IN-IC-NO                 PIC S9(04) USAGE COMP VALUE 0.      
       01  IN-CODE-UTIL-TYPE        PIC X(01).                          
       01  IN-BILL-UNITS            PIC S9(08) USAGE COMP VALUE 0.      
       01  IN-BILLED-AM             PIC S9(13)V USAGE COMP-3 VALUE 0.   
       01  IN-CHARGE-TYPE-TX        PIC X(10).                          
A03699 01  IN-CHARGE-TYPE-DES       PIC X(255).                         
       01  IN-SUB-ACCT-NO           PIC X(13).                          
       01  IN-DATA-TYPE             PIC X(10).                          
       01  IN-PROC-MODE             PIC X(01).                          
       01  IN-MESSAGE               PIC X(210).                         
       01  IN-REVENUE-MONTH         PIC S9(08) USAGE COMP VALUE 0.      
A02085 01  IN-EXTRACTED-FL          PIC X(01).                          
A05460 01  IN-USER-ID               PIC X(07).                          
      *                                                                         
       PROCEDURE DIVISION USING IN-ACCOUNT-NO                           
                               ,IN-AMT-DUE                              
                               ,IN-BILL-DUE-DATE                        
                               ,IN-BILL-NO                              
                               ,IN-CODE-STATE-ID                        
                               ,IN-CUSTOMER-NA                          
                               ,IN-DATE-BILLED                          
                               ,IN-DATE-CREATED                         
                               ,IN-DATE-READ                            
                               ,IN-MST-ACCT-NO                          
                               ,IN-MST-SUB-ACCT                         
                               ,IN-PURPOSE-CD                           
                               ,IN-SCHED-SEND-DT                        
                               ,IN-STATUS-CD                            
                               ,IN-STREET-ADDR-1                        
                               ,IN-STREET-ADDR-2                        
                               ,IN-TRANS-CD                             
                               ,IN-ZIP-CODE                             
                               ,IN-BEGIN-READ-DT                        
                               ,IN-BEGIN-READING                        
                               ,IN-CODE-TIME-PER                        
                               ,IN-CONSTANT                             
                               ,IN-END-READ-DT                          
                               ,IN-END-READING                          
                               ,IN-METER-NO                             
                               ,IN-NO-UNITS                             
                               ,IN-RATE-PLAN-NO                         
                               ,IN-SEQ-NO                               
                               ,IN-USAGE-CD                             
                               ,IN-IC-NO                                
                               ,IN-CODE-UTIL-TYPE                       
                               ,IN-BILL-UNITS                           
                               ,IN-BILLED-AM                            
                               ,IN-CHARGE-TYPE-TX                       
                               ,IN-CHARGE-TYPE-DES                      
                               ,IN-SUB-ACCT-NO                          
                               ,IN-DATA-TYPE                            
                               ,IN-PROC-MODE                            
                               ,IN-MESSAGE                              
                               ,IN-REVENUE-MONTH                        
A02085                         ,IN-EXTRACTED-FL                         
A05460                         ,IN-USER-ID.                             
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-INITIALIZE-PROCEDURE THRU 1000-EXIT.            
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT.            
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT.            
           GOBACK.                                                      
                                                                        
                                                                        
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
      *                                                                         
      *---------------------------------------------------------------          
      *--  SET UP SQL ERROR PROCESSING                              --          
      *--  DECLARE ASSOCIATED CURSOR                                --          
      *---------------------------------------------------------------          
      *                                                                         
       1000-INITIALIZE-PROCEDURE.                                       
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                 :S-RETURN-CODE                                         
                ,:S-ERROR-MSG                                           
A01201         FROM CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                         
T35434         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          :S-RETURN-CODE                                                 
MFA-TR*         ,:S-ERROR-MSG                                                   
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR  FOR                        
               SELECT :IN-DATA-TYPE,:IN-PROC-MODE                       
A01201         FROM CIS.SYSDUMMY1 WITH(READUNCOMMITTED)                         
T35434         FOR READ ONLY                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT :IN-DATA-TYPE,:IN-PROC-MODE                               
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE MASTER-ACCT CURSOR FOR                           
                  SELECT HF.SUB_ACCT_NO                                 
                    FROM CSS_EDI_BILL_CHRGS HF WITH(READUNCOMMITTED)            
                   WHERE HF.ACCOUNT_NO = :HF-ACCOUNT-NO                 
                     AND HF.BILL_NO    = :HF-BILL-NO                    
T35434               FOR READ ONLY                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE MASTER-ACCT CURSOR FOR                                   
MFA-TR*           SELECT HF.SUB_ACCT_NO                                         
MFA-TR*             FROM CSS_EDI_BILL_CHRGS HF                                  
MFA-TR*            WHERE HF.ACCOUNT_NO = :HF-ACCOUNT-NO                         
MFA-TR*              AND HF.BILL_NO    = :HF-BILL-NO                            
MFA-TR*              FOR FETCH ONLY WITH UR                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
               DECLARE SUB-ACCT CURSOR FOR                              
                   SELECT HF.BILLED_AM                                  
                     FROM CSS_EDI_BILL_CHRGS HF WITH(READUNCOMMITTED),          
                          CSS_EDI_BILL_HDR HZ WITH(READUNCOMMITTED)             
                    WHERE HF.ACCOUNT_NO = :HF-ACCOUNT-NO                
                      AND HZ.ACCOUNT_NO = HF.ACCOUNT_NO                 
                      AND HF.BILL_NO    = :HF-BILL-NO                   
                      AND HF.BILL_NO    = HZ.BILL_NO                    
                      AND HZ.STATUS_CD = 'R'                            
                      AND HF.CHARGE_TYPE_TX = 'SUB001'                  
T35434                FOR READ ONLY                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE SUB-ACCT CURSOR FOR                                      
MFA-TR*            SELECT HF.BILLED_AM                                          
MFA-TR*              FROM CSS_EDI_BILL_CHRGS HF,                                
MFA-TR*                   CSS_EDI_BILL_HDR HZ                                   
MFA-TR*             WHERE HF.ACCOUNT_NO = :HF-ACCOUNT-NO                        
MFA-TR*               AND HZ.ACCOUNT_NO = HF.ACCOUNT_NO                         
MFA-TR*               AND HF.BILL_NO    = :HF-BILL-NO                           
MFA-TR*               AND HF.BILL_NO    = HZ.BILL_NO                            
MFA-TR*               AND HZ.STATUS_CD = 'R'                                    
MFA-TR*               AND HF.CHARGE_TYPE_TX = 'SUB001'                          
MFA-TR*               FOR FETCH ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
           PERFORM 1500-PROCESS-INPUT         THRU 1500-EXIT.           
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1500-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1500-PROCESS-INPUT.                                              
      *                                                                         
           MOVE IN-ACCOUNT-NO            TO WS-PARM-ACCOUNT-NO          
A05460     MOVE IN-USER-ID               TO WS-USER-ID.                 
           MOVE WS-PARM-ACCOUNT-NO       TO HZ-ACCOUNT-NO               
                                            HF-ACCOUNT-NO               
                                            AT-ACCOUNT-NO.              
           PERFORM 7300-VALIDATE-ACCOUNT THRU 7300-EXIT.                
           MOVE IN-BILL-NO               TO HZ-BILL-NO                  
                                            HF-BILL-NO.                 
           IF IN-DATA-TYPE = 'HEADER'                                   
             COMPUTE HZ-AMT-DUE = IN-AMT-DUE / 100 END-COMPUTE          
             MOVE IN-BILL-DUE-DATE         TO HZ-BILL-DUE-DATE          
             MOVE IN-CODE-STATE-ID         TO HZ-CODE-STATE-ID          
             MOVE IN-CUSTOMER-NA           TO HZ-CUSTOMER-NA-TEXT       
             MOVE 60                       TO HZ-CUSTOMER-NA-LEN        
             MOVE IN-DATE-BILLED           TO HZ-DATE-BILLED            
             IF IN-DATE-READ <= SPACES                                  
                MOVE -1                    TO WS-DATE-READ-NULL         
             END-IF                                                     
             MOVE IN-DATE-READ             TO HZ-DATE-READ              
             MOVE IN-MST-ACCT-NO           TO WS-PARM-ACCOUNT-NO        
             MOVE WS-PARM-ACCOUNT-NO       TO HZ-MST-ACCT-NO            
                                              AT-ACCOUNT-NO             
             IF AT-ACCOUNT-NO > 0                                       
                 PERFORM 7310-VALIDATE-MASTER THRU 7310-EXIT            
             END-IF                                                     
             MOVE IN-MST-SUB-ACCT          TO HZ-MST-SUB-ACCT-IND       
             MOVE IN-PURPOSE-CD            TO HZ-PURPOSE-CD             
             MOVE IN-SCHED-SEND-DT         TO HZ-SCHED-SEND-DT          
             IF IN-SCHED-SEND-DT <= SPACES                              
                MOVE -1                    TO WS-SCHED-DT-NULL          
             END-IF                                                     
             MOVE IN-STATUS-CD             TO HZ-STATUS-CD              
             MOVE IN-STREET-ADDR-1         TO HZ-STREET-ADDR-1-TEXT     
             MOVE 55                       TO HZ-STREET-ADDR-1-LEN      
             MOVE IN-STREET-ADDR-2         TO HZ-STREET-ADDR-2-TEXT     
             MOVE 55                       TO HZ-STREET-ADDR-2-LEN      
             MOVE IN-TRANS-CD              TO HZ-TRANS-CD               
             MOVE IN-ZIP-CODE              TO HZ-ZIP-CODE               
             MOVE IN-REVENUE-MONTH         TO HZ-REVENUE-MONTH          
A02085       MOVE IN-EXTRACTED-FL          TO HZ-EXTRACTED-FL           
             EVALUATE IN-PROC-MODE                                      
                WHEN 'I'                                                
                     PERFORM 7200-GET-MAX-BILL-NO   THRU 7200-EXIT      
                     IF WS-BILL-NULL < 0                                
                        MOVE 9000          TO HZ-BILL-NO                
                     ELSE                                               
                        COMPUTE HZ-BILL-NO = WS-MAX-BILL-NO + 1         
                        END-COMPUTE                                     
                     END-IF                                             
                     PERFORM 8210-INSERT-HEADER THRU 8210-EXIT          
                     MOVE 'PAN206HI'         TO WS-PROGRAM-ID           
                     PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT    
                     MOVE 'ACCOUNT NO'       TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +13                TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE WS-PARM-ACCOUNT-NO TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'BILL NO'          TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE HF-BILL-NO         TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                WHEN 'U'                                                
                     PERFORM 7400-VALIDATE-MASTER-AMT THRU 7400-EXIT    
                     PERFORM 7500-GET-PREVIOUS-HEADER THRU 7500-EXIT    
                     PERFORM 8200-UPDATE-HEADER THRU 8200-EXIT          
                     MOVE 'PAN206HU'         TO WS-PROGRAM-ID           
                     PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT    
                     PERFORM 7510-FIND-CHANGED-HEADER THRU 7510-EXIT    
                WHEN 'D'                                                
                     PERFORM 8220-DELETE-HEADER THRU 8220-EXIT          
                     MOVE 'PAN206HD'         TO WS-PROGRAM-ID           
                     PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT    
                     MOVE 'ACCOUNT NO'       TO MI-COLUMN-DESC          
                     MOVE +13                TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE WS-PARM-ACCOUNT-NO TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'BILL NO'          TO MI-COLUMN-DESC          
                     MOVE +8                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE HF-BILL-NO         TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
             END-EVALUATE                                               
           END-IF                                                       
                                                                        
           IF IN-DATA-TYPE = 'USAGE'                                    
             MOVE HZ-ACCOUNT-NO            TO HW-ACCOUNT-NO             
                                              MN-ACCOUNT-NO             
             MOVE HZ-BILL-NO               TO HW-BILL-NO                
             MOVE IN-BEGIN-READ-DT         TO HW-BEGIN-READ-DT          
             MOVE IN-BEGIN-READING         TO HW-BEGIN-READING          
             MOVE IN-CODE-TIME-PER         TO HW-CODE-TIME-PERIOD       
             MOVE IN-CONSTANT              TO HW-CONSTANT               
             MOVE IN-END-READ-DT           TO HW-END-READ-DT            
             MOVE IN-END-READING           TO HW-END-READING            
             MOVE IN-METER-NO              TO HW-METER-NO               
                                              MN-METER-NO               
A02177                                        TM-DIST-METER-NO          
A02177       MOVE IN-ACCOUNT-NO            TO UT-ACCOUNT-NO             
A02177       MOVE IN-IC-NO                 TO UT-IC-NO                  
A02177                                        MN-IC-NO                  
A02177       MOVE IN-CODE-UTIL-TYPE        TO UT-CODE-UTIL-TYPE         
A02177                                        MN-CODE-UTIL-TYPE         
A02177       MOVE IN-RATE-PLAN-NO          TO UT-RATE-PLAN-NO           
A02177*                                                                 02692000
A02177       MOVE ZERO                     TO WS-DATABASE               
A02177       MOVE 'DATABASE'               TO C8-DELINQ-CD              
A02177       MOVE AT-COMPANY-NO            TO C8-COMPANY-NO             
A02177       PERFORM 7560-GET-DELINQUENCY-VALUE THRU 7560-EXIT          
A02177       MOVE C8-DELINQ-VALUE          TO WS-DATABASE               
A02177*                                                                 02692000
A02177       IF SEB-DATABASE                                            
A02177          IF TM-DIST-METER-NO > 0                                 
A02177             PERFORM 7350-VALIDATE-SEB-METER THRU 7350-EXIT       
A02177             PERFORM 7340-VALID-UTIL-ENV     THRU 7340-EXIT       
A02177          END-IF                                                  
A02177       ELSE                                                       
A02177          IF MN-METER-NO > 0                                      
A02177             PERFORM 7330-VALIDATE-METER THRU 7330-EXIT           
A02177             PERFORM 7340-VALID-UTIL-ENV THRU 7340-EXIT           
A02177          END-IF                                                  
A02177       END-IF                                                     
A02177*                                                                         
             MOVE IN-NO-UNITS              TO HW-NO-UNITS               
             MOVE IN-RATE-PLAN-NO          TO HW-RATE-PLAN-NO           
             MOVE IN-SEQ-NO                TO HW-SEQ-NO                 
             MOVE IN-USAGE-CD              TO HW-USAGE-CD               
             MOVE IN-IC-NO                 TO HW-IC-NO                  
             MOVE IN-CODE-UTIL-TYPE        TO HW-CODE-UTIL-TYPE         
             EVALUATE IN-PROC-MODE                                      
                WHEN 'I'                                                
                     PERFORM 7000-GET-MAX-USAGE-SEQ THRU 7000-EXIT      
                     IF WS-SEQ-NULL < 0                                 
                        MOVE 1             TO HW-SEQ-NO                 
                     ELSE                                               
                        COMPUTE HW-SEQ-NO = WS-MAX-SEQ-NO + 1           
                        END-COMPUTE                                     
                     END-IF                                             
                     PERFORM 8310-INSERT-USAGE  THRU 8310-EXIT          
                     MOVE 'PAN206UI'         TO WS-PROGRAM-ID           
                     PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT    
                     MOVE 'ACCOUNT NO'       TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +13                TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE WS-PARM-ACCOUNT-NO TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'BILL NO'          TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE HF-BILL-NO         TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'SEQ NO'           TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE HF-SEQ-NO          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'USAGE CD'         TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +2                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE HF-USAGE-CD        TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                WHEN 'U'                                                
                     PERFORM 8300-UPDATE-USAGE  THRU 8300-EXIT          
                WHEN 'D'                                                
                     PERFORM 8320-DELETE-USAGE  THRU 8320-EXIT          
                     MOVE 'PAN206UD'         TO WS-PROGRAM-ID           
                     PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT    
                     MOVE 'ACCOUNT NO'       TO MI-COLUMN-DESC          
                     MOVE +13                TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE WS-PARM-ACCOUNT-NO TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'BILL NO'          TO MI-COLUMN-DESC          
                     MOVE +8                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE HF-BILL-NO         TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'SEQ NO'           TO MI-COLUMN-DESC          
                     MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE HF-SEQ-NO          TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'USAGE CD'         TO MI-COLUMN-DESC          
                     MOVE +2                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE HF-USAGE-CD        TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
             END-EVALUATE                                               
           END-IF                                                       
                                                                        
           IF IN-DATA-TYPE = 'CHARGES'                                  
             MOVE HZ-ACCOUNT-NO            TO HF-ACCOUNT-NO             
             MOVE HZ-BILL-NO               TO HF-BILL-NO                
             MOVE IN-SEQ-NO                TO HF-SEQ-NO                 
             MOVE IN-USAGE-CD              TO HF-USAGE-CD               
             MOVE IN-IC-NO                 TO HF-IC-NO                  
             MOVE IN-CODE-UTIL-TYPE        TO HF-CODE-UTIL-TYPE         
             MOVE IN-BILL-UNITS            TO HF-BILL-UNITS             
             COMPUTE HF-BILLED-AM = IN-BILLED-AM / 100 END-COMPUTE      
             MOVE IN-CHARGE-TYPE-TX        TO HF-CHARGE-TYPE-TX         
A03699       MOVE LENGTH OF IN-CHARGE-TYPE-DES TO                       
A03699                                        HF-CHARGE-TYPE-DESC-LEN   
A03699       IF HF-CHARGE-TYPE-DESC-LEN > 0 THEN                        
A03699           MOVE IN-CHARGE-TYPE-DES   TO HF-CHARGE-TYPE-DESC-TEXT  
A03699       ELSE                                                       
A03699           MOVE SPACES               TO HF-CHARGE-TYPE-DESC-TEXT  
A03699           MOVE ZERO                 TO HF-CHARGE-TYPE-DESC-LEN   
A03699       END-IF                                                     
             IF IN-SUB-ACCT-NO = '0000000000000'                        
                MOVE -1 TO WS-NULL-IND1                                 
             ELSE                                                       
                MOVE 0  TO WS-NULL-IND1                                 
             END-IF                                                     
             MOVE IN-SUB-ACCT-NO           TO WS-PARM-ACCOUNT-NO        
             MOVE WS-PARM-ACCOUNT-NO       TO HF-SUB-ACCT-NO            
                                              AT-ACCOUNT-NO             
             IF AT-ACCOUNT-NO > 0                                       
                PERFORM 7320-VALIDATE-SUB THRU 7320-EXIT                
             END-IF                                                     
             EVALUATE IN-PROC-MODE                                      
                WHEN 'I'                                                
                     PERFORM 7100-GET-MAX-CHARGES-SEQ THRU 7100-EXIT    
                     IF WS-SEQ-NULL < 0                                 
                        MOVE 1             TO HF-SEQ-NO                 
                     ELSE                                               
                        COMPUTE HF-SEQ-NO = WS-MAX-SEQ-NO + 1           
                        END-COMPUTE                                     
                     END-IF                                             
                     PERFORM 8410-INSERT-CHARGES THRU 8410-EXIT         
                     MOVE 'PAN206CI'         TO WS-PROGRAM-ID           
                     PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT    
                     MOVE 'ACCOUNT NO'       TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +13                TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE WS-PARM-ACCOUNT-NO TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'BILL NO'          TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE HF-BILL-NO         TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'SEQ NO'           TO MI-COLUMN-DESC          
                     MOVE +3                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE 'NEW'              TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +4                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE HF-SEQ-NO          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                WHEN 'U'                                                
                     PERFORM 8400-UPDATE-CHARGES THRU 8400-EXIT         
                WHEN 'D'                                                
                     PERFORM 8420-DELETE-CHARGES THRU 8420-EXIT         
                     MOVE 'PAN206CD'         TO WS-PROGRAM-ID           
                     PERFORM 2500-MAINTENANCE-HISTORY THRU 2500-EXIT    
                     MOVE 'ACCOUNT NO'       TO MI-COLUMN-DESC          
                     MOVE +13                TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE WS-PARM-ACCOUNT-NO TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'BILL NO'          TO MI-COLUMN-DESC          
                     MOVE +8                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE HF-BILL-NO         TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
                                                                        
                     MOVE 'SEQ NO'           TO MI-COLUMN-DESC          
                     MOVE +4                 TO MI-PRV-COLUMN-VALUE-LEN 
                     MOVE HF-SEQ-NO          TO MI-PRV-COLUMN-VALUE-TEXT
                     MOVE +8                 TO MI-CHG-COLUMN-VALUE-LEN 
                     MOVE 'DELETED'          TO MI-CHG-COLUMN-VALUE-TEXT
                     PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT         
             END-EVALUATE                                               
           END-IF.                                                      
      *                                                                         
       1500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT  THRU 2200-EXIT.                   
           PERFORM 9999-END-PROGRAM   THRU 9999-EXIT.                   
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
      *                                                                         
           PERFORM 2300-MOVE-VALUES THRU 2300-EXIT                      
           IF CTR-ROWS = 0                                              
              MOVE NOT-FOUND TO S-RETURN-CODE                           
              MOVE 'D5498'   TO S-ERROR-MSG                             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
           END-IF.                                                      
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2300-MOVE-VALUES.                                                
      *                                                                         
           MOVE 0                        TO  S-RETURN-CODE              
           MOVE SPACES                   TO  S-ERROR-MSG                
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 2500-MAINTENANCE-HISTORY.                                     *         
      *                                                               *         
      *                                                               *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
                                                                        
       2500-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '2500'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7050-SELECT-CURRENT-DATE THRU 7050-EXIT.             
           MOVE WS-CURRENT-TIMESTAMP   TO MH-TRANS-HIST-SEQ-NO,         
           MOVE WS-CURRENT-DATE        TO MH-DATE-TRANS                 
           MOVE 'F'                    TO MH-CODE-TRAN-TYPE.            
           MOVE HZ-ACCOUNT-NO          TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE WS-USER-ID             TO MH-USER-ID.                   
           MOVE WS-PROGRAM-ID          TO MH-APPL-PROGRAM-ID.           
           MOVE 210                    TO MH-TRAN-COMMENT-LEN.          
           MOVE IN-MESSAGE             TO MH-TRAN-COMMENT-TEXT.         
           MOVE +0                     TO MI-TRAN-APPL-NO.              
       2500-EXIT.                                                       
           EXIT.                                                        
      *****************************************************************         
      * 2550-WRITE-MNT-HIST.                                          *         
      *                                                               *         
      *                                                               *         
      *     WRITE TRAN HISTORY                                        *         
      *****************************************************************         
                                                                        
       2550-WRITE-MNT-HIST.                                             
           ADD  +1                     TO MI-TRAN-APPL-NO               
A01201     IF MI-COLUMN-DESC = 'STATUS CD'                              
A01201       MOVE 'HZ'                TO MI-TABLE-ID                    
A01201     ELSE                                                         
             MOVE SPACES              TO MI-TABLE-ID                    
A01201     END-IF.                                                      
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO    
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *                                                                *        
      *                                                                *        
      *     JOURNALING ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
       7000-GET-MAX-USAGE-SEQ.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MAX(SEQ_NO)                                        
                INTO :WS-MAX-SEQ-NO :WS-SEQ-NULL                         
                FROM CSS_EDI_BILL_USAGE WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :HW-ACCOUNT-NO                        
               AND   BILL_NO    = :HW-BILL-NO                           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(SEQ_NO)                                                
MFA-TR*         INTO :WS-MAX-SEQ-NO:WS-SEQ-NULL                                 
MFA-TR*         FROM CSS_EDI_BILL_USAGE                                         
MFA-TR*        WHERE ACCOUNT_NO = :HW-ACCOUNT-NO                                
MFA-TR*        AND   BILL_NO    = :HW-BILL-NO                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '7000'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_USAGE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HW-BILL-NO           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7050-SELECT-CURRENT-DATE.                                     *          
      ****************************************************************          
A02177*                                                                         
       7050-SELECT-CURRENT-DATE.                                        
           EXEC SQL                                                     
A02177         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIMESTAMP           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-CURRENT-DATE      =  CURRENT DATE                        
MFA-TR*           ,:WS-CURRENT-TIMESTAMP =  CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
T35434         MOVE 'SET'                      TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      *7100-GET-MAX-CHARGES-SEQ.                                     *          
      ****************************************************************          
       7100-GET-MAX-CHARGES-SEQ.                                        
                                                                        
           EXEC SQL                                                     
              SELECT MAX(SEQ_NO)                                        
                INTO :WS-MAX-SEQ-NO :WS-SEQ-NULL                         
                FROM CSS_EDI_BILL_CHRGS WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO = :HF-ACCOUNT-NO                        
               AND   BILL_NO    = :HF-BILL-NO                           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(SEQ_NO)                                                
MFA-TR*         INTO :WS-MAX-SEQ-NO:WS-SEQ-NULL                                 
MFA-TR*         FROM CSS_EDI_BILL_CHRGS                                         
MFA-TR*        WHERE ACCOUNT_NO = :HF-ACCOUNT-NO                                
MFA-TR*        AND   BILL_NO    = :HF-BILL-NO                                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_CHRGS' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HF-BILL-NO           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-GET-MAX-BILL-NO                                           *        
      ******************************************************************        
       7200-GET-MAX-BILL-NO.                                            
           MOVE 0 TO WS-BILL-NULL                                       
                                                                        
           EXEC SQL                                                     
              SELECT MAX(BILL_NO)                                       
                INTO :WS-MAX-BILL-NO :WS-BILL-NULL                       
                FROM CSS_EDI_BILL_HDR WITH(READUNCOMMITTED)                     
               WHERE ACCOUNT_NO = :HZ-ACCOUNT-NO                        
               AND   BILL_NO >= 9000                                    
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(BILL_NO)                                               
MFA-TR*         INTO :WS-MAX-BILL-NO:WS-BILL-NULL                               
MFA-TR*         FROM CSS_EDI_BILL_HDR                                           
MFA-TR*        WHERE ACCOUNT_NO = :HZ-ACCOUNT-NO                                
MFA-TR*        AND   BILL_NO >= 9000                                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '7200'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR  ' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-VALIDATE-ACCOUNT                                          *        
      *      CHECK TO MAKE SURE THAT ACCOUNT NO EXISTS                 *        
      ******************************************************************        
       7300-VALIDATE-ACCOUNT.                                           
                                                                        
           EXEC SQL                                                     
               SELECT AT.ACCOUNT_NO                                     
A02177               ,AT.COMPANY_NO                                     
                 INTO :AT-ACCOUNT-NO                                    
A02177               ,:AT-COMPANY-NO                                    
                 FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                      
                WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                    
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT AT.ACCOUNT_NO                                             
MFA-TR*              ,AT.COMPANY_NO                                             
MFA-TR*          INTO :AT-ACCOUNT-NO                                            
MFA-TR*              ,:AT-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT AT                                            
MFA-TR*         WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                            
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SQLCODE                  TO  S-RETURN-CODE           
              MOVE 'D0142'                  TO  S-ERROR-MSG             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
A02177        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7310-VALIDATE-MASTER                                           *        
      *      CHECK TO MAKE SURE THAT MASTER ACCOUNT NUMBER ENTERED     *        
      *      (IF ANY) IS A VALID MASTER ACCOUNT NO                     *        
      ******************************************************************        
       7310-VALIDATE-MASTER.                                            
                                                                        
            EXEC SQL                                                    
A02177          SELECT AT.ACCOUNT_NO                                    
                  INTO :AT-ACCOUNT-NO                                   
A02177            FROM CSS_ACCOUNT AT WITH(READUNCOMMITTED)                     
A02177           WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
A02177             AND AT.MST_SUB_ACCT_IND = 'M'                        
T35434                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*           INTO :AT-ACCOUNT-NO                                           
MFA-TR*           FROM CSS_ACCOUNT AT                                           
MFA-TR*          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*            AND AT.MST_SUB_ACCT_IND = 'M'                                
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SQLCODE                  TO  S-RETURN-CODE           
              MOVE 'D0964'                  TO  S-ERROR-MSG             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
A02177     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02177        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02177        MOVE '7310'                     TO ACTIVE-PARAGRAPH       
A02177        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A02177        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A02177                                           ABEND-TABLES           
A02177        MOVE 'CSS_ACCOUNT'              TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
A02177        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02177        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02177        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02177     END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7320-VALIDATE-SUB                                              *        
      *      CHECK TO MAKE SURE THAT SUB    ACCOUNT NUMBER ENTERED     *        
      *      (IF ANY) IS A VALID MASTER ACCOUNT NO                     *        
      ******************************************************************        
       7320-VALIDATE-SUB.                                               
                                                                        
            EXEC SQL                                                    
A02177          SELECT AT.ACCOUNT_NO                                    
                  INTO :AT-ACCOUNT-NO                                   
A02177           FROM CSS_ACCOUNT   AT WITH(READUNCOMMITTED)                    
A02177           WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                   
A02177             AND AT.MST_SUB_ACCT_IND = 'S'                        
T35434                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*         SELECT AT.ACCOUNT_NO                                            
MFA-TR*           INTO :AT-ACCOUNT-NO                                           
MFA-TR*          FROM CSS_ACCOUNT   AT                                          
MFA-TR*          WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                           
MFA-TR*            AND AT.MST_SUB_ACCT_IND = 'S'                                
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SQLCODE                  TO  S-RETURN-CODE           
              MOVE 'D5575'                  TO  S-ERROR-MSG             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7320'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
A02177        MOVE AT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7330-VALIDATE-METER                                            *        
      *      CHECK TO MAKE SURE THAT THE METER ENTERED IS ASSOCIATED   *        
      *      WITH THE ACCOUNT NO                                       *        
      ******************************************************************        
       7330-VALIDATE-METER.                                             
                                                                        
           EXEC SQL                                                     
A02177         SELECT TOP(1) MN.METER_NO                                       
                 INTO :MN-METER-NO                                      
A02177           FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                 
A02177          WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                
A02177            AND MN.METER_NO       = :MN-METER-NO                  
A02177            AND MN.IC_NO          = :MN-IC-NO                     
A02177            AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE            
A02177                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MN.METER_NO                                               
MFA-TR*          INTO :MN-METER-NO                                              
MFA-TR*          FROM CSS_MTRD_ENVRNMT MN                                       
MFA-TR*         WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                        
MFA-TR*           AND MN.METER_NO       = :MN-METER-NO                          
MFA-TR*           AND MN.IC_NO          = :MN-IC-NO                             
MFA-TR*           AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                    
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SQLCODE                  TO  S-RETURN-CODE           
              MOVE 'D0536'                  TO  S-ERROR-MSG             
              PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7330'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
A02177        MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
A02177        MOVE 'METER_NO   '              TO TABLE-ELEMENT-1        
A02177        MOVE MN-METER-NO                TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-2        
A02177        MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
A02177        MOVE 'IC_NO      '              TO TABLE-ELEMENT-3        
A02177        MOVE MN-IC-NO                   TO HOSTVAR-ELEMENT-3      
A02177        MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-4        
A02177        MOVE MN-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-4      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
            EXIT.                                                       
      ******************************************************************        
      * 7340-VALID-UTIL-ENV.                                           *        
      *     VERIFIES THAT THE COMBINATION OF IC-NO, CODE_UTIL_TYPE,    *        
      *     AND RATE_PLAN_NO IS VALID                                  *        
      ******************************************************************        
       7340-VALID-UTIL-ENV.                                             
                                                                        
                                                                        
           EXEC SQL                                                     
               SELECT TOP(1) 'Y'                                               
                 INTO :WS-EXISTS-FLAG                                   
A02177           FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
A02177          WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                
A02177            AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE            
A02177            AND UT.IC_NO          = :UT-IC-NO                     
A02177            AND UT.RATE_PLAN_NO   = :UT-RATE-PLAN-NO              
A02177                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-EXISTS-FLAG                                           
MFA-TR*          FROM CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                        
MFA-TR*           AND UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE                    
MFA-TR*           AND UT.IC_NO          = :UT-IC-NO                             
MFA-TR*           AND UT.RATE_PLAN_NO   = :UT-RATE-PLAN-NO                      
MFA-TR*           FETCH FIRST ROW ONLY WITH UR                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
A02177         MOVE '7340'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE 'D0537'                    TO S-ERROR-MSG           
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_UTIL_ENVRNMT'         TO TABLE-1               
A02177         MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1       
A02177         MOVE UT-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
A02177         MOVE 'IC_NO      '              TO TABLE-ELEMENT-2       
A02177         MOVE UT-IC-NO                   TO HOSTVAR-ELEMENT-2     
A02177         MOVE 'CODE-UTIL_TYPE'           TO TABLE-ELEMENT-3       
A02177         MOVE UT-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-3     
A02177         MOVE 'RATE_PLAN_NO  '           TO TABLE-ELEMENT-4       
A02177         MOVE UT-RATE-PLAN-NO            TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
            EXIT.                                                       
A02177*                                                                         
A02177******************************************************************        
A02177* 7350-VALIDATE-SEB-METER.                                       *        
A02177*      CHECK TO MAKE SURE THAT THE METER ENTERED IS ASSOCIATED   *        
A02177*      WITH THE ACCOUNT NO                                       *        
A02177******************************************************************        
A02177 7350-VALIDATE-SEB-METER.                                         
A02177                                                                  
A02177     EXEC SQL                                                     
A02177         SELECT TOP(1) MN.METER_NO                                       
A02177           INTO :MN-METER-NO                                      
A02177           FROM CSS_DIST_XREF_MTR TM WITH(READUNCOMMITTED)                
A02177               ,CSS_MTRD_ENVRNMT  MN WITH(READUNCOMMITTED)                
A02177               ,CSS_MKT_XREF_ACCT XM WITH(READUNCOMMITTED)                
A02177          WHERE TM.DIST_METER_NO  = :TM-DIST-METER-NO             
A02177            AND MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                
A02177            AND MN.ACCOUNT_NO     = XM.ACCOUNT_NO                 
A02177            AND MN.METER_NO       = TM.METER_NO                   
A02177            AND MN.IC_NO          = :MN-IC-NO                     
A02177            AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE            
A02177                                       
A02177     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MN.METER_NO                                               
MFA-TR*          INTO :MN-METER-NO                                              
MFA-TR*          FROM CSS_DIST_XREF_MTR TM                                      
MFA-TR*              ,CSS_MTRD_ENVRNMT  MN                                      
MFA-TR*              ,CSS_MKT_XREF_ACCT XM                                      
MFA-TR*         WHERE TM.DIST_METER_NO  = :TM-DIST-METER-NO                     
MFA-TR*           AND MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                        
MFA-TR*           AND MN.ACCOUNT_NO     = XM.ACCOUNT_NO                         
MFA-TR*           AND MN.METER_NO       = TM.METER_NO                           
MFA-TR*           AND MN.IC_NO          = :MN-IC-NO                             
MFA-TR*           AND MN.CODE_UTIL_TYPE = :MN-CODE-UTIL-TYPE                    
MFA-TR*         FETCH FIRST ROW ONLY WITH UR                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02177                                                                  
A02177     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
A02177     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
A02177        MOVE SQLCODE                  TO  S-RETURN-CODE           
A02177        MOVE 'D0536'                  TO  S-ERROR-MSG             
A02177        PERFORM 8100-SEND-RESULT      THRU 8100-EXIT              
A02177        PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
A02177     END-IF.                                                      
A02177                                                                  
A02177     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02177        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02177        MOVE '7350'                     TO ACTIVE-PARAGRAPH       
A02177        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A02177        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A02177                                           ABEND-TABLES           
A02177        MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
A02177        MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'CODE UTIL TYPE'           TO TABLE-ELEMENT-2        
A02177        MOVE MN-CODE-UTIL-TYPE          TO HOSTVAR-ELEMENT-2      
A02177        MOVE 'CSS_DIST_XREF_MTR'        TO TABLE-2                
A02177        MOVE 'DIST_METER_NO'            TO TABLE-ELEMENT-3        
A02177        MOVE TM-DIST-METER-NO           TO HOSTVAR-ELEMENT-3      
A02177        MOVE 'CSS_MKT_XREF_ACCT'        TO TABLE-3                
A02177        MOVE 'IC_NO      '              TO TABLE-ELEMENT-4        
A02177        MOVE MN-IC-NO                   TO HOSTVAR-ELEMENT-4      
A02177        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02177        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02177     END-IF.                                                      
A02177                                                                  
A02177 7350-EXIT.                                                       
A02177      EXIT.                                                       
A02177*                                                                         
      ******************************************************************        
      * 7400-VALIDATE-MASTER-AMT.                                      *        
      *      PARAGRAPH CHECKS TO SEE IF ACCOUNT IS A MASTER ACCOUNT.   *        
      * IF IT IS AND THE STATUS_CD IS 'R'(READY), THEN THE VALUE IN    *        
      * AMT_DUE IS VERIFED TO BE THE SUM OF THE TRANSFERRED AMOUNTS    *        
      * OF ALL THE "READY" SUBS BELONGING TO THAT MASTER ACCOUNT.      *        
      ******************************************************************        
       7400-VALIDATE-MASTER-AMT.                                        
           IF IN-MST-SUB-ACCT = 'M'                                     
             PERFORM 7410-OPEN-MASTER-ACCT    THRU 7410-EXIT            
             IF SQLCODE NOT = NOT-FOUND                                 
                PERFORM 7440-FETCH-LOOP                                 
                  UNTIL SQLCODE NOT = NOT-FOUND                         
             END-IF                                                     
             PERFORM 7430-CLOSE-MASTER-ACCT   THRU 7430-EXIT            
             IF WS-BILLED-AM-ACCUM NOT = HZ-AMT-DUE                     
                MOVE -1                       TO  S-RETURN-CODE         
                MOVE 'D5576'                  TO  S-ERROR-MSG           
                PERFORM 8100-SEND-RESULT      THRU 8100-EXIT            
                PERFORM 9999-END-PROGRAM      THRU 9999-EXIT            
             END-IF                                                     
           END-IF.                                                      
       7400-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      * 7410-OPEN-MASTER-ACCT.                                      *           
      *     OPENS THE CURSOR MASTER-ACCT                            *           
      ***************************************************************           
       7410-OPEN-MASTER-ACCT.                                           
           EXEC SQL                                                     
               OPEN MASTER-ACCT                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7410'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'MASTER_ACCT CURSOR'       TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7410-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      * 7420-FETCH-MASTER-ACCT.                                     *           
      *     FETCHES THE CURSOR MASTER-ACCT                          *           
      ***************************************************************           
       7420-FETCH-MASTER-ACCT.                                          
            EXEC SQL                                                    
                FETCH MASTER-ACCT                                       
                 INTO :HF-ACCOUNT-NO                                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
            IF WS-ACTIVE-RETURN-CODE NOT = NOT-FOUND                    
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7420'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'MASTER_ACCT CURSOR'       TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A02177        MOVE  HF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'BILL_NO   '               TO TABLE-ELEMENT-1        
A02177        MOVE  HF-BILL-NO                TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF                                                      
           END-IF.                                                      
                                                                        
       7420-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ***************************************************************           
      * 7430-CLOSE-MASTER-ACCT.                                     *           
      *    CLOSES THE CURSOR MASTER-ACCT                            *           
      ***************************************************************           
       7430-CLOSE-MASTER-ACCT.                                          
            EXEC SQL                                                    
                CLOSE MASTER-ACCT                                       
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7430'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'MASTER_ACCT CURSOR'       TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A02177        MOVE  HF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'BILL_NO   '               TO TABLE-ELEMENT-2        
A02177        MOVE  HF-BILL-NO                TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7430-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7440-FETCH-LOOP.                                               *        
      ******************************************************************        
       7440-FETCH-LOOP.                                                 
                                                                        
            PERFORM 7420-FETCH-MASTER-ACCT     THRU 7420-EXIT           
            PERFORM 7450-CHECK-SUB-ACCT-CHARGE THRU 7450-EXIT           
            .                                                           
      *                                                                         
      ******************************************************************        
      * 7450-CHECK-SUB-ACCT-CHARGE.                                    *        
      *      THIS SECTION WILL CHECK THE SUB ACCOUNTS SELECTED IN THE  *        
      *   MASTER-ACCT CURSOR.  IF THEIR STATUS IS 'READY' ('R'), THEN  *        
      *   ANY CHARGES OF TYPE 'SUB001' WILL BE ACCUMULATED TO VERIFY   *        
      *   THAT THIS TOTAL IS EQUAL TO THE AMOUNT IN THE FIELD AMT_DUE  *        
      *   FOR THE MASTER ACCOUNT.                                      *        
      ******************************************************************        
       7450-CHECK-SUB-ACCT-CHARGE.                                      
                                                                        
           EXEC SQL                                                     
              OPEN SUB-ACCT                                             
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN  '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SUB_ACCT CURSOR'          TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF                                                       
                                                                        
           EXEC SQL                                                     
              FETCH SUB-ACCT                                            
               INTO :HF-BILLED-AM                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              COMPUTE                                                   
                WS-BILLED-AM-ACCUM = WS-BILLED-AM-ACCUM + HF-BILLED-AM  
              END-COMPUTE                                               
           END-IF                                                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
            IF WS-ACTIVE-RETURN-CODE NOT = NOT-FOUND                    
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'FETCH '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SUB_ACCT CURSOR'          TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A02177        MOVE  HF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'BILL_NO   '               TO TABLE-ELEMENT-2        
A02177        MOVE  HF-BILL-NO                TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF                                                      
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              CLOSE SUB-ACCT                                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
           IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7450'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE '                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'SUB_ACCT CURSOR'          TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A02177        MOVE  HF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'BILL_NO   '               TO TABLE-ELEMENT-2        
A02177        MOVE  HF-BILL-NO                TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7500-GET-PREVIOUS-HEADER.                                      *        
      *      GET THE PREVIOUS VALUES FROM CSS_EDI_BILL_HDR SO THAT     *        
      *      THE CHANGED VALUES WILL BE KNOWN FOR MAINTENANCE HISTORY  *        
      ******************************************************************        
       7500-GET-PREVIOUS-HEADER.                                        
                                                                        
            EXEC SQL                                                    
                                                                        
A02177          SELECT HZ.AMT_DUE                                       
A02177                ,HZ.CODE_STATE_ID                                 
A02177                ,HZ.CUSTOMER_NA                                   
A02177                ,HZ.MST_ACCT_NO                                   
A02177                ,HZ.MST_SUB_ACCT_IND                              
A02177                ,HZ.PURPOSE_CD                                    
A02177                ,HZ.SCHED_SEND_DT                                 
A02177                ,HZ.STATUS_CD                                     
A02177                ,HZ.STREET_ADDR_1                                 
A02177                ,HZ.STREET_ADDR_2                                 
A02177                ,HZ.TRANS_CD                                      
A02177                ,HZ.ZIP_CODE                                      
A02177                ,HZ.REVENUE_MONTH                                 
A02085                ,EXTRACTED_FL                                     
                  INTO                                                  
                       :WS-PREV-AMT-DUE                                 
                      ,:WS-PREV-CODE-STATE-ID                           
                      ,:WS-PREV-CUSTOMER-NA                             
                      ,:WS-PREV-MST-ACCT-NO                             
                      ,:WS-PREV-MST-SUB-ACCT-IND                        
                      ,:WS-PREV-PURPOSE-CD                              
                      ,:WS-PREV-SCHED-SEND-DT                           
                      ,:WS-PREV-STATUS-CD                               
                      ,:WS-PREV-STREET-ADDR-1                           
                      ,:WS-PREV-STREET-ADDR-2                           
                      ,:WS-PREV-TRANS-CD                                
                      ,:WS-PREV-ZIP-CODE                                
                      ,:WS-PREV-REVENUE-MONTH                           
A02085                ,:WS-PREV-EXTRACTED-FL                            
A02177            FROM CSS_EDI_BILL_HDR HZ WITH(READUNCOMMITTED)                
A02177           WHERE HZ.ACCOUNT_NO = :HZ-ACCOUNT-NO                   
A02177             AND HZ.BILL_NO    = :HZ-BILL-NO                      
T35434                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*                                                                         
MFA-TR*         SELECT HZ.AMT_DUE                                               
MFA-TR*               ,HZ.CODE_STATE_ID                                         
MFA-TR*               ,HZ.CUSTOMER_NA                                           
MFA-TR*               ,HZ.MST_ACCT_NO                                           
MFA-TR*               ,HZ.MST_SUB_ACCT_IND                                      
MFA-TR*               ,HZ.PURPOSE_CD                                            
MFA-TR*               ,HZ.SCHED_SEND_DT                                         
MFA-TR*               ,HZ.STATUS_CD                                             
MFA-TR*               ,HZ.STREET_ADDR_1                                         
MFA-TR*               ,HZ.STREET_ADDR_2                                         
MFA-TR*               ,HZ.TRANS_CD                                              
MFA-TR*               ,HZ.ZIP_CODE                                              
MFA-TR*               ,HZ.REVENUE_MONTH                                         
MFA-TR*               ,EXTRACTED_FL                                             
MFA-TR*           INTO                                                          
MFA-TR*                :WS-PREV-AMT-DUE                                         
MFA-TR*               ,:WS-PREV-CODE-STATE-ID                                   
MFA-TR*               ,:WS-PREV-CUSTOMER-NA                                     
MFA-TR*               ,:WS-PREV-MST-ACCT-NO                                     
MFA-TR*               ,:WS-PREV-MST-SUB-ACCT-IND                                
MFA-TR*               ,:WS-PREV-PURPOSE-CD                                      
MFA-TR*               ,:WS-PREV-SCHED-SEND-DT                                   
MFA-TR*               ,:WS-PREV-STATUS-CD                                       
MFA-TR*               ,:WS-PREV-STREET-ADDR-1                                   
MFA-TR*               ,:WS-PREV-STREET-ADDR-2                                   
MFA-TR*               ,:WS-PREV-TRANS-CD                                        
MFA-TR*               ,:WS-PREV-ZIP-CODE                                        
MFA-TR*               ,:WS-PREV-REVENUE-MONTH                                   
MFA-TR*               ,:WS-PREV-EXTRACTED-FL                                    
MFA-TR*           FROM CSS_EDI_BILL_HDR HZ                                      
MFA-TR*          WHERE HZ.ACCOUNT_NO = :HZ-ACCOUNT-NO                           
MFA-TR*            AND HZ.BILL_NO    = :HZ-BILL-NO                              
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02177     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02177        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02177        MOVE '7500'                     TO ACTIVE-PARAGRAPH       
A02177        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A02177        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A02177                                           ABEND-TABLES           
A02177        MOVE 'CSS_EDI_BILL_HDR'         TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
A02177        MOVE HZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'BILL NO    '              TO TABLE-ELEMENT-2        
A02177        MOVE HZ-BILL-NO                 TO HOSTVAR-ELEMENT-2      
A02177        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02177        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02177     END-IF.                                                      
A02177*                                                                         
       7500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7510-FIND-CHANGED-HEADER.                                      *        
      ******************************************************************        
       7510-FIND-CHANGED-HEADER.                                        
                                                                        
            IF WS-PREV-AMT-DUE NOT = HZ-AMT-DUE                         
               MOVE 'AMOUNT DUE'         TO MI-COLUMN-DESC              
               MOVE +17                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-AMT-DUE      TO WS-AMT-DUE                  
               MOVE WS-AMT-DUE           TO WS-PREV-COLUMN-AM           
               MOVE WS-PREV-COLUMN-AM    TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +17                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-AMT-DUE           TO WS-AMT-DUE                  
               MOVE WS-AMT-DUE           TO WS-CHG-COLUMN-AM            
               MOVE WS-CHG-COLUMN-AM     TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
               INITIALIZE WS-PREV-COLUMN-VALUE,                         
                          WS-CHG-COLUMN-VALUE                           
            END-IF                                                      
            IF WS-PREV-CODE-STATE-ID NOT = HZ-CODE-STATE-ID             
               MOVE 'STATE ID'            TO MI-COLUMN-DESC             
               MOVE +2                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-CODE-STATE-ID TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +2                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE HZ-CODE-STATE-ID      TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-CUSTOMER-NA-TEXT NOT = HZ-CUSTOMER-NA-TEXT       
               MOVE 'CUST NAME'          TO MI-COLUMN-DESC              
               MOVE WS-PREV-CUSTOMER-NA-LEN                             
                                         TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-CUSTOMER-NA-TEXT                            
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE HZ-CUSTOMER-NA-LEN   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-CUSTOMER-NA-TEXT  TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-MST-ACCT-NO      NOT = HZ-MST-ACCT-NO            
               MOVE 'MST ACCT NO'        TO MI-COLUMN-DESC              
               MOVE +13                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-MST-ACCT-NO  TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +13                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-MST-ACCT-NO       TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-MST-SUB-ACCT-IND NOT = HZ-MST-SUB-ACCT-IND       
               MOVE 'MST/SUB IND'        TO MI-COLUMN-DESC              
               MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-MST-SUB-ACCT-IND                            
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +13                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-MST-SUB-ACCT-IND  TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-PURPOSE-CD NOT = HZ-PURPOSE-CD                   
               MOVE 'PURPOSE CD'         TO MI-COLUMN-DESC              
               MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-PURPOSE-CD   TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +2                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-PURPOSE-CD        TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            MOVE WS-PREV-SCHED-SEND-DT TO WS-DATE-CCYY-MM-DD            
            MOVE WS-DATE-CCYY          TO WS-DATE2-CCYY                 
            MOVE WS-DATE-MM            TO WS-DATE2-MM                   
            MOVE WS-DATE-DD            TO WS-DATE2-DD                   
            MOVE WS-DATE-MM-DD-CCYY    TO WS-PREV-SCHED-SEND-DT         
            IF WS-PREV-SCHED-SEND-DT NOT = HZ-SCHED-SEND-DT             
               MOVE 'SCHED SEND DT'       TO MI-COLUMN-DESC             
               MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-SCHED-SEND-DT TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE HZ-SCHED-SEND-DT      TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-STATUS-CD NOT = HZ-STATUS-CD                     
               MOVE 'STATUS CD'          TO MI-COLUMN-DESC              
               MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-STATUS-CD    TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-STATUS-CD         TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-STREET-ADDR-1-TEXT NOT = HZ-STREET-ADDR-1-TEXT   
               MOVE 'ST ADDR-1'           TO MI-COLUMN-DESC             
               MOVE WS-PREV-STREET-ADDR-1-LEN                           
                                          TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-STREET-ADDR-1-TEXT                          
                                          TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE HZ-STREET-ADDR-1-LEN  TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE HZ-STREET-ADDR-1-TEXT TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-STREET-ADDR-2-TEXT NOT = HZ-STREET-ADDR-2-TEXT   
               MOVE 'ST ADDR-2'          TO MI-COLUMN-DESC              
               MOVE WS-PREV-STREET-ADDR-2-LEN                           
                                         TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-STREET-ADDR-2-TEXT                          
                                         TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE HZ-STREET-ADDR-2-LEN  TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE HZ-STREET-ADDR-2-TEXT TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-TRANS-CD NOT = HZ-TRANS-CD                       
               MOVE 'TRANS CD'           TO MI-COLUMN-DESC              
               MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-TRANS-CD     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-TRANS-CD          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-ZIP-CODE NOT = HZ-ZIP-CODE                       
               MOVE 'ZIP CODE'           TO MI-COLUMN-DESC              
               MOVE +9                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-ZIP-CODE     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HZ-ZIP-CODE          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-REVENUE-MONTH NOT = HZ-REVENUE-MONTH             
               MOVE 'REV MONTH'           TO MI-COLUMN-DESC             
               MOVE +6                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-REVENUE-MONTH TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +6                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE HZ-REVENUE-MONTH      TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
A02085      IF WS-PREV-EXTRACTED-FL NOT = HZ-EXTRACTED-FL               
A02085         MOVE 'EXTRCT FL'           TO MI-COLUMN-DESC             
A02085         MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN    
A02085         MOVE WS-PREV-EXTRACTED-FL  TO MI-PRV-COLUMN-VALUE-TEXT   
A02085         MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN    
A02085         MOVE HZ-EXTRACTED-FL       TO MI-CHG-COLUMN-VALUE-TEXT   
A02085         PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
A02085      END-IF.                                                     
                                                                        
       7510-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7520-GET-PREVIOUS-CHRGS.                                       *        
      ******************************************************************        
       7520-GET-PREVIOUS-CHRGS.                                         
            EXEC SQL                                                    
                                                                        
A02177          SELECT HF.BILL_UNITS                                    
A02177                ,HF.BILLED_AM                                     
A02177                ,HF.CHARGE_TYPE_TX                                
A02177                ,HF.IC_NO                                         
A02177                ,HF.USAGE_CD                                      
A02177                ,HF.CHARGE_TYPE_DESC                              
A02177                ,HF.SUB_ACCT_NO                                   
A02177                ,HF.CODE_UTIL_TYPE                                
                  INTO                                                  
                       :WS-PREV-BILL-UNITS                              
                      ,:WS-PREV-BILLED-AM                               
                      ,:WS-PREV-CHARGE-TYPE-TX                          
                      ,:WS-PREV-IC-NO-C                                 
                      ,:WS-PREV-USAGE-CD                                
                      ,:WS-PREV-CHARGE-TYPE-DESC                        
                      ,:WS-PREV-SUB-ACCT-NO                             
                      ,:WS-PREV-CODE-UTIL-TYPE-C                        
A02177            FROM CSS_EDI_BILL_CHRGS  HF WITH(READUNCOMMITTED)             
A02177           WHERE HF.ACCOUNT_NO = :HF-ACCOUNT-NO                   
A02177             AND HF.BILL_NO    = :HF-BILL-NO                      
A02177             AND HF.SEQ_NO     = :HF-SEQ-NO                       
T35434                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*                                                                         
MFA-TR*         SELECT HF.BILL_UNITS                                            
MFA-TR*               ,HF.BILLED_AM                                             
MFA-TR*               ,HF.CHARGE_TYPE_TX                                        
MFA-TR*               ,HF.IC_NO                                                 
MFA-TR*               ,HF.USAGE_CD                                              
MFA-TR*               ,HF.CHARGE_TYPE_DESC                                      
MFA-TR*               ,HF.SUB_ACCT_NO                                           
MFA-TR*               ,HF.CODE_UTIL_TYPE                                        
MFA-TR*           INTO                                                          
MFA-TR*                :WS-PREV-BILL-UNITS                                      
MFA-TR*               ,:WS-PREV-BILLED-AM                                       
MFA-TR*               ,:WS-PREV-CHARGE-TYPE-TX                                  
MFA-TR*               ,:WS-PREV-IC-NO-C                                         
MFA-TR*               ,:WS-PREV-USAGE-CD                                        
MFA-TR*               ,:WS-PREV-CHARGE-TYPE-DESC                                
MFA-TR*               ,:WS-PREV-SUB-ACCT-NO                                     
MFA-TR*               ,:WS-PREV-CODE-UTIL-TYPE-C                                
MFA-TR*           FROM CSS_EDI_BILL_CHRGS  HF                                   
MFA-TR*          WHERE HF.ACCOUNT_NO = :HF-ACCOUNT-NO                           
MFA-TR*            AND HF.BILL_NO    = :HF-BILL-NO                              
MFA-TR*            AND HF.SEQ_NO     = :HF-SEQ-NO                               
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
A02177     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02177        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02177        MOVE '7520'                     TO ACTIVE-PARAGRAPH       
A02177        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A02177        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A02177                                           ABEND-TABLES           
A02177        MOVE 'CSS_EDI_BILL_CHRGS'       TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
A02177        MOVE HF-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'BILL NO    '              TO TABLE-ELEMENT-2        
A02177        MOVE HF-BILL-NO                 TO HOSTVAR-ELEMENT-2      
A02177        MOVE 'SEQ  NO    '              TO TABLE-ELEMENT-3        
A02177        MOVE HF-SEQ-NO                  TO HOSTVAR-ELEMENT-3      
A02177        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02177        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02177     END-IF.                                                      
A02177*                                                                         
       7520-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7530-FIND-CHANGED-CHRGS.                                       *        
      ******************************************************************        
       7530-FIND-CHANGED-CHRGS.                                         
            IF WS-PREV-BILL-UNITS NOT = HF-BILL-UNITS                   
               MOVE 'BILL UNITS'          TO MI-COLUMN-DESC             
               MOVE +9                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-BILL-UNITS    TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE HF-BILL-UNITS         TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-BILLED-AM NOT = HF-BILLED-AM                     
               MOVE 'BILLED AMT'          TO MI-COLUMN-DESC             
               MOVE +14                   TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE WS-PREV-BILLED-AM     TO WS-BILLED-AM               
               MOVE WS-BILLED-AM          TO WS-PREV-COLUMN-AM          
               MOVE WS-PREV-COLUMN-AM     TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE +14                   TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE HF-BILLED-AM          TO WS-BILLED-AM               
               MOVE WS-BILLED-AM          TO WS-CHG-COLUMN-VALUE        
               MOVE WS-CHG-COLUMN-AM      TO MI-CHG-COLUMN-VALUE-TEXT   
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
               INITIALIZE WS-PREV-COLUMN-VALUE,                         
                          WS-CHG-COLUMN-VALUE                           
            END-IF                                                      
            IF WS-PREV-CHARGE-TYPE-TX NOT = HF-CHARGE-TYPE-TX           
               MOVE 'CHRG TYPE'            TO MI-COLUMN-DESC            
               MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-CHARGE-TYPE-TX TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE HF-CHARGE-TYPE-TX      TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-IC-NO-C NOT = HF-IC-NO                           
               MOVE 'IC NO'                TO MI-COLUMN-DESC            
               MOVE +4                     TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-IC-NO-C        TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +4                     TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE HF-IC-NO               TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-USAGE-CD NOT = HF-USAGE-CD                       
               MOVE 'USAGE CD'             TO MI-COLUMN-DESC            
               MOVE +2                     TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-USAGE-CD       TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +2                     TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE HF-USAGE-CD            TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
A03699      IF WS-CHARGE-TYPE-DESC-TEXT NOT = HF-CHARGE-TYPE-DESC-TEXT  
               MOVE 'CHRG TYPE DESC'         TO MI-COLUMN-DESC          
A03699         MOVE WS-CHARGE-TYPE-DESC-LEN  TO MI-PRV-COLUMN-VALUE-LEN 
A03699         MOVE WS-CHARGE-TYPE-DESC-TEXT TO MI-PRV-COLUMN-VALUE-TEXT
A03699         MOVE HF-CHARGE-TYPE-DESC-LEN  TO MI-CHG-COLUMN-VALUE-LEN 
A03699         MOVE HF-CHARGE-TYPE-DESC-TEXT TO MI-CHG-COLUMN-VALUE-TEXT
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-SUB-ACCT-NO NOT = HF-SUB-ACCT-NO                 
               MOVE 'SUB ACCT NO'          TO MI-COLUMN-DESC            
               MOVE +13                    TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-SUB-ACCT-NO    TO WS-PARM-ACCOUNT-NO        
               MOVE WS-PARM-ACCOUNT-NO     TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +13                    TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE HF-SUB-ACCT-NO         TO WS-PARM-ACCOUNT-NO        
               MOVE WS-PARM-ACCOUNT-NO     TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-CODE-UTIL-TYPE-C NOT = HF-CODE-UTIL-TYPE         
               MOVE 'CODE UTIL TYPE'         TO MI-COLUMN-DESC          
               MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE WS-PREV-CODE-UTIL-TYPE-C TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE HF-CODE-UTIL-TYPE        TO MI-CHG-COLUMN-VALUE-TEXT
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
                                                                        
       7530-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7540-GET-PREVIOUS-USAGE.                                       *        
      ******************************************************************        
       7540-GET-PREVIOUS-USAGE.                                         
            EXEC SQL                                                    
                                                                        
A02177          SELECT HW.BEGIN_READ_DT                                 
A02177                ,HW.BEGIN_READING                                 
A02177                ,HW.BTU_FACTOR                                    
A02177                ,HW.CODE_TIME_PERIOD                              
A02177                ,HW.CODE_UTIL_TYPE                                
A02177                ,HW.CONSTANT                                      
A02177                ,HW.END_READ_DT                                   
A02177                ,HW.END_READING                                   
A02177                ,HW.IC_NO                                         
A02177                ,HW.METER_NO                                      
A02177                ,HW.NO_UNITS                                      
A02177                ,HW.RATE_PLAN_NO                                  
                  INTO                                                  
                       :WS-PREV-BEGIN-READ-DT                           
                      ,:WS-PREV-BEGIN-READING                           
                      ,:WS-PREV-BTU-FACTOR                              
                      ,:WS-PREV-CODE-TIME-PERIOD                        
                      ,:WS-PREV-CODE-UTIL-TYPE-U                        
                      ,:WS-PREV-CONSTANT                                
                      ,:WS-PREV-END-READ-DT                             
                      ,:WS-PREV-END-READING                             
                      ,:WS-PREV-IC-NO-U                                 
                      ,:WS-PREV-METER-NO                                
                      ,:WS-PREV-NO-UNITS                                
                      ,:WS-PREV-RATE-PLAN-NO                            
A02177            FROM CSS_EDI_BILL_USAGE HW WITH(READUNCOMMITTED)              
A02177           WHERE HW.ACCOUNT_NO = :HW-ACCOUNT-NO                   
A02177             AND HW.BILL_NO    = :HW-BILL-NO                      
A02177             AND HW.SEQ_NO     = :HW-SEQ-NO                       
A02177             AND HW.USAGE_CD   = :HW-USAGE-CD                     
T35434                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*                                                                         
MFA-TR*         SELECT HW.BEGIN_READ_DT                                         
MFA-TR*               ,HW.BEGIN_READING                                         
MFA-TR*               ,HW.BTU_FACTOR                                            
MFA-TR*               ,HW.CODE_TIME_PERIOD                                      
MFA-TR*               ,HW.CODE_UTIL_TYPE                                        
MFA-TR*               ,HW.CONSTANT                                              
MFA-TR*               ,HW.END_READ_DT                                           
MFA-TR*               ,HW.END_READING                                           
MFA-TR*               ,HW.IC_NO                                                 
MFA-TR*               ,HW.METER_NO                                              
MFA-TR*               ,HW.NO_UNITS                                              
MFA-TR*               ,HW.RATE_PLAN_NO                                          
MFA-TR*           INTO                                                          
MFA-TR*                :WS-PREV-BEGIN-READ-DT                                   
MFA-TR*               ,:WS-PREV-BEGIN-READING                                   
MFA-TR*               ,:WS-PREV-BTU-FACTOR                                      
MFA-TR*               ,:WS-PREV-CODE-TIME-PERIOD                                
MFA-TR*               ,:WS-PREV-CODE-UTIL-TYPE-U                                
MFA-TR*               ,:WS-PREV-CONSTANT                                        
MFA-TR*               ,:WS-PREV-END-READ-DT                                     
MFA-TR*               ,:WS-PREV-END-READING                                     
MFA-TR*               ,:WS-PREV-IC-NO-U                                         
MFA-TR*               ,:WS-PREV-METER-NO                                        
MFA-TR*               ,:WS-PREV-NO-UNITS                                        
MFA-TR*               ,:WS-PREV-RATE-PLAN-NO                                    
MFA-TR*           FROM CSS_EDI_BILL_USAGE HW                                    
MFA-TR*          WHERE HW.ACCOUNT_NO = :HW-ACCOUNT-NO                           
MFA-TR*            AND HW.BILL_NO    = :HW-BILL-NO                              
MFA-TR*            AND HW.SEQ_NO     = :HW-SEQ-NO                               
MFA-TR*            AND HW.USAGE_CD   = :HW-USAGE-CD                             
MFA-TR*            WITH UR                                                      
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02177*                                                                         
A02177     IF WS-ACTIVE-RETURN-CODE NOT = SUCCESSFUL-CALL               
A02177        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A02177        MOVE '7540'                     TO ACTIVE-PARAGRAPH       
A02177        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A02177        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A02177                                           ABEND-TABLES           
A02177        MOVE 'CSS_EDI_BILL_CHRGS'       TO TABLE-1                
A02177        MOVE 'ACCOUNT_NO '              TO TABLE-ELEMENT-1        
A02177        MOVE HW-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A02177        MOVE 'BILL NO    '              TO TABLE-ELEMENT-2        
A02177        MOVE HW-BILL-NO                 TO HOSTVAR-ELEMENT-2      
A02177        MOVE 'SEQ  NO    '              TO TABLE-ELEMENT-3        
A02177        MOVE HW-SEQ-NO                  TO HOSTVAR-ELEMENT-3      
A02177        MOVE 'USAGE CD   '              TO TABLE-ELEMENT-4        
A02177        MOVE HW-USAGE-CD                TO HOSTVAR-ELEMENT-4      
A02177        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A02177        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02177     END-IF.                                                      
A02177*                                                                         
       7540-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 7550-FIND-CHANGED-USAGE.                                       *        
      ******************************************************************        
       7550-FIND-CHANGED-USAGE.                                         
            MOVE WS-PREV-BEGIN-READ-DT TO WS-DATE-CCYY-MM-DD            
            MOVE WS-DATE-CCYY          TO WS-DATE2-CCYY                 
            MOVE WS-DATE-MM            TO WS-DATE2-MM                   
            MOVE WS-DATE-DD            TO WS-DATE2-DD                   
            MOVE WS-DATE-MM-DD-CCYY    TO WS-PREV-BEGIN-READ-DT         
            IF WS-PREV-BEGIN-READ-DT NOT = HW-BEGIN-READ-DT             
               MOVE 'BEGIN READ DT'        TO MI-COLUMN-DESC            
               MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-BEGIN-READ-DT  TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE HW-BEGIN-READ-DT       TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-BEGIN-READING NOT = HW-BEGIN-READING             
               MOVE 'BEGIN READING'        TO MI-COLUMN-DESC            
               MOVE +11                    TO MI-PRV-COLUMN-VALUE-LEN   
               MOVE WS-PREV-BEGIN-READING  TO MI-PRV-COLUMN-VALUE-TEXT  
               MOVE +11                    TO MI-CHG-COLUMN-VALUE-LEN   
               MOVE HW-BEGIN-READING       TO MI-CHG-COLUMN-VALUE-TEXT  
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-BTU-FACTOR NOT = HW-BTU-FACTOR                   
               MOVE 'BTU FACTOR'         TO MI-COLUMN-DESC              
               MOVE +8                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-BTU-FACTOR   TO WS-BTU-FACTOR               
               MOVE WS-BTU-FACTOR        TO WS-PREV-COLUMN-BTU          
               MOVE WS-PREV-COLUMN-BTU   TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +8                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HW-BTU-FACTOR        TO WS-BTU-FACTOR               
               MOVE WS-BTU-FACTOR        TO WS-CHG-COLUMN-BTU           
               MOVE WS-CHG-COLUMN-BTU    TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
               INITIALIZE WS-PREV-COLUMN-VALUE,                         
                          WS-CHG-COLUMN-VALUE                           
            END-IF                                                      
            IF WS-PREV-CODE-TIME-PERIOD NOT = HW-CODE-TIME-PERIOD       
               MOVE 'TIME PERIOD'            TO MI-COLUMN-DESC          
               MOVE +2                       TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE WS-PREV-CODE-TIME-PERIOD TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE +2                       TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE HW-CODE-TIME-PERIOD      TO MI-CHG-COLUMN-VALUE-TEXT
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-CODE-UTIL-TYPE-U NOT = HW-CODE-UTIL-TYPE         
               MOVE 'CODE UTIL TYPE'         TO MI-COLUMN-DESC          
               MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE WS-PREV-CODE-UTIL-TYPE-U TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE HW-CODE-UTIL-TYPE        TO MI-CHG-COLUMN-VALUE-TEXT
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-CONSTANT NOT = HW-CONSTANT                       
               MOVE 'CONSTANT'               TO MI-COLUMN-DESC          
               MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN 
               MOVE WS-PREV-CONSTANT         TO WS-CONSTANT             
               MOVE WS-CONSTANT              TO WS-PREV-COLUMN-CONSTANT 
               MOVE WS-PREV-COLUMN-CONSTANT  TO MI-PRV-COLUMN-VALUE-TEXT
               MOVE +12                      TO MI-CHG-COLUMN-VALUE-LEN 
               MOVE HW-CONSTANT              TO WS-CONSTANT             
               MOVE WS-CONSTANT              TO WS-CHG-COLUMN-CONSTANT  
               MOVE WS-CHG-COLUMN-CONSTANT   TO MI-CHG-COLUMN-VALUE-TEXT
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
               INITIALIZE WS-PREV-COLUMN-VALUE,                         
                          WS-CHG-COLUMN-VALUE                           
            END-IF                                                      
            MOVE WS-PREV-END-READ-DT TO WS-DATE-CCYY-MM-DD              
            MOVE WS-DATE-CCYY        TO WS-DATE2-CCYY                   
            MOVE WS-DATE-MM          TO WS-DATE2-MM                     
            MOVE WS-DATE-DD          TO WS-DATE2-DD                     
            MOVE WS-DATE-MM-DD-CCYY  TO WS-PREV-END-READ-DT             
            IF WS-PREV-END-READ-DT NOT = HW-END-READ-DT                 
               MOVE 'END READ DT'        TO MI-COLUMN-DESC              
               MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-END-READ-DT  TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HW-END-READ-DT       TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-END-READING NOT = HW-END-READING                 
               MOVE 'END READING'        TO MI-COLUMN-DESC              
               MOVE +11                  TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-END-READING  TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +11                  TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HW-END-READING       TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-IC-NO-U NOT = HW-IC-NO                           
               MOVE 'IC NO'              TO MI-COLUMN-DESC              
               MOVE +4                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-IC-NO-U      TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HW-IC-NO             TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-METER-NO NOT = HW-METER-NO                       
               MOVE 'METER NO'           TO MI-COLUMN-DESC              
               MOVE +9                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-METER-NO     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HW-METER-NO          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-NO-UNITS NOT = HW-NO-UNITS                       
               MOVE 'NO UNITS'           TO MI-COLUMN-DESC              
               MOVE +9                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-NO-UNITS     TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HW-NO-UNITS          TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF                                                      
            IF WS-PREV-RATE-PLAN-NO NOT = HW-RATE-PLAN-NO               
               MOVE 'RATE PLAN NO'       TO MI-COLUMN-DESC              
               MOVE +3                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE WS-PREV-RATE-PLAN-NO TO MI-PRV-COLUMN-VALUE-TEXT    
               MOVE +3                   TO MI-CHG-COLUMN-VALUE-LEN     
               MOVE HW-RATE-PLAN-NO      TO MI-CHG-COLUMN-VALUE-TEXT    
               PERFORM 2550-WRITE-MNT-HIST THRU 2550-EXIT               
            END-IF.                                                     
                                                                        
       7550-EXIT.                                                       
            EXIT.                                                       
A02177*                                                                         
A02177******************************************************************17920000
A02177*   TO INDENTIFY THE SEB DATABASE.                               *17930000
A02177******************************************************************17940000
A02177*                                                                         
A02177 7560-GET-DELINQUENCY-VALUE.                                      
A02177*                                                                 17950000
A02177     EXEC SQL                                                     
A02177        SELECT C8.DELINQ_VALUE                                    
A02177          INTO :C8-DELINQ-VALUE                                   
A02177        FROM  CSS_DELINQUENCY C8 WITH(READUNCOMMITTED)                    
A02177        WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                       
A02177          AND C8.COMPANY_NO = :C8-COMPANY-NO                      
A02177                                                           
A02177     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     17960000
MFA-TR*       SELECT C8.DELINQ_VALUE                                    17970000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   17980000
MFA-TR*       FROM  CSS_DELINQUENCY C8                                  17990000
MFA-TR*       WHERE C8.DELINQ_CD  = :C8-DELINQ-CD                       18000000
MFA-TR*         AND C8.COMPANY_NO = :C8-COMPANY-NO                      18010000
MFA-TR*       WITH UR                                                   18011000
MFA-TR*    END-EXEC.                                                    18020000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02177                                                                  
A02177     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02177                                                                  
A02177     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
A02177        NEXT SENTENCE                                             
A02177     ELSE                                                         
A02177        MOVE PROGRAM-NAME            TO ABEND-PROGRAM             
A02177        MOVE '7560'                  TO ACTIVE-PARAGRAPH          
A02177        MOVE 'SELECT'                TO ABEND-FUNCTION            
A02177        MOVE SPACES                  TO ABEND-SQL-PREDICATES      
A02177                                        ABEND-TABLES              
A02177        MOVE 'CSS_DELINQUENCY'       TO TABLE-1                   
A02177        MOVE 'DATABASE'              TO TABLE-ELEMENT-1           
A02177        MOVE C8-DELINQ-CD            TO HOSTVAR-ELEMENT-1         
A02177        MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-2           
A02177        MOVE C8-COMPANY-NO           TO HOSTVAR-ELEMENT-2         
A02177        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
A02177        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A02177     END-IF.                                                      
A02177                                                                  
A02177 7560-EXIT.                                                       
A02177     EXIT.                                                        
A02177*                                                                 18230000
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
                                                                        
           ADD 1 TO CTR-ROWS.                                           
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-UPDATE-HEADER.                                            *        
      ******************************************************************        
       8200-UPDATE-HEADER.                                              
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_EDI_BILL_HDR                                  
                SET  AMT_DUE    =  :HZ-AMT-DUE                          
                 ,BILL_DUE_DATE  = IIF(TRY_CONVERT(DATE, 
                                                      :HZ-BILL-DUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :HZ-BILL-DUE-DATE
              ) <> 0) OR (LEN(:HZ-BILL-DUE-DATE) <> 10), CIS.CHAR2DATE(
                                                      :HZ-BILL-DUE-DATE
              ), CONVERT(DATE, :HZ-BILL-DUE-DATE) )                    
                 ,CODE_STATE_ID  = :HZ-CODE-STATE-ID                    
                 ,CUSTOMER_NA    = :HZ-CUSTOMER-NA                      
                 ,DATE_BILLED    = IIF(TRY_CONVERT(DATE, :HZ-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :HZ-DATE-BILLED
              ) <> 0) OR (LEN(:HZ-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :HZ-DATE-BILLED
              ), CONVERT(DATE, :HZ-DATE-BILLED) )                      
                 ,DATE_READ      = IIF(TRY_CONVERT(DATE, :HZ-DATE-READ 
                                                     :WS-DATE-READ-NULL
              ) IS NULL OR (PATINDEX('%.%', :HZ-DATE-READ 
                                                     :WS-DATE-READ-NULL
              ) <> 0) OR (LEN(:HZ-DATE-READ :WS-DATE-READ-NULL
              ) <> 10), CIS.CHAR2DATE(:HZ-DATE-READ :WS-DATE-READ-NULL
              ), CONVERT(DATE, :HZ-DATE-READ :WS-DATE-READ-NULL) )      
                 ,MST_ACCT_NO    = :HZ-MST-ACCT-NO                      
                 ,MST_SUB_ACCT_IND=:HZ-MST-SUB-ACCT-IND                 
                 ,PURPOSE_CD     = :HZ-PURPOSE-CD                       
                 ,SCHED_SEND_DT  = IIF(TRY_CONVERT(DATE, 
                                                     :HZ-SCHED-SEND-DT 
                                                      :WS-SCHED-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :HZ-SCHED-SEND-DT 
                                                      :WS-SCHED-DT-NULL
              ) <> 0) OR (LEN(:HZ-SCHED-SEND-DT :WS-SCHED-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:HZ-SCHED-SEND-DT 
                                                      :WS-SCHED-DT-NULL
              ), CONVERT(DATE, :HZ-SCHED-SEND-DT :WS-SCHED-DT-NULL) )   
                 ,STATUS_CD      = :HZ-STATUS-CD                        
                 ,STREET_ADDR_1  = :HZ-STREET-ADDR-1                    
                 ,STREET_ADDR_2  = :HZ-STREET-ADDR-2                    
                 ,TRANS_CD       = :HZ-TRANS-CD                         
                 ,ZIP_CODE       = :HZ-ZIP-CODE                         
                 ,LAST_UPDATE_TS = CIS.CURRENT$TIMESTAMP()                    
                 ,LAST_UPDATE_USERID = :WS-USER-ID                      
                 ,UPDATE_IND     = 'Y'                                  
                 ,REVENUE_MONTH  = :HZ-REVENUE-MONTH                    
A02085           ,EXTRACTED_FL   = :HZ-EXTRACTED-FL                     
A02085           ,EXTRACTED_TS   = CIS.CURRENT$TIMESTAMP()                    
               WHERE ACCOUNT_NO  = :HZ-ACCOUNT-NO                       
               AND   BILL_NO     = :HZ-BILL-NO                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EDI_BILL_HDR                                          
MFA-TR*         SET  AMT_DUE    =  :HZ-AMT-DUE                                  
MFA-TR*          ,BILL_DUE_DATE  = :HZ-BILL-DUE-DATE                            
MFA-TR*          ,CODE_STATE_ID  = :HZ-CODE-STATE-ID                            
MFA-TR*          ,CUSTOMER_NA    = :HZ-CUSTOMER-NA                              
MFA-TR*          ,DATE_BILLED    = :HZ-DATE-BILLED                              
MFA-TR*          ,DATE_READ      = :HZ-DATE-READ:WS-DATE-READ-NULL              
MFA-TR*          ,MST_ACCT_NO    = :HZ-MST-ACCT-NO                              
MFA-TR*          ,MST_SUB_ACCT_IND=:HZ-MST-SUB-ACCT-IND                         
MFA-TR*          ,PURPOSE_CD     = :HZ-PURPOSE-CD                               
MFA-TR*          ,SCHED_SEND_DT  = :HZ-SCHED-SEND-DT:WS-SCHED-DT-NULL           
MFA-TR*          ,STATUS_CD      = :HZ-STATUS-CD                                
MFA-TR*          ,STREET_ADDR_1  = :HZ-STREET-ADDR-1                            
MFA-TR*          ,STREET_ADDR_2  = :HZ-STREET-ADDR-2                            
MFA-TR*          ,TRANS_CD       = :HZ-TRANS-CD                                 
MFA-TR*          ,ZIP_CODE       = :HZ-ZIP-CODE                                 
MFA-TR*          ,LAST_UPDATE_TS = CURRENT TIMESTAMP                            
MFA-TR*          ,LAST_UPDATE_USERID = :WS-USER-ID                              
MFA-TR*          ,UPDATE_IND     = 'Y'                                          
MFA-TR*          ,REVENUE_MONTH  = :HZ-REVENUE-MONTH                            
MFA-TR*          ,EXTRACTED_FL   = :HZ-EXTRACTED-FL                             
MFA-TR*          ,EXTRACTED_TS   = CURRENT TIMESTAMP                            
MFA-TR*        WHERE ACCOUNT_NO  = :HZ-ACCOUNT-NO                               
MFA-TR*        AND   BILL_NO     = :HZ-BILL-NO                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HZ-BILL-NO           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8210-INSERT-HEADER.                                            *        
      ******************************************************************        
       8210-INSERT-HEADER.                                              
                                                                        
           EXEC SQL                                                     
                                                                        
               INSERT INTO CSS_EDI_BILL_HDR                             
                  (                                                     
                   ACCOUNT_NO                                           
                  ,BILL_NO                                              
                  ,AMT_DUE                                              
                  ,BILL_DUE_DATE                                        
                  ,CODE_STATE_ID                                        
                  ,CUSTOMER_NA                                          
                  ,DATE_BILLED                                          
                  ,DATE_READ                                            
                  ,MST_ACCT_NO                                          
                  ,MST_SUB_ACCT_IND                                     
                  ,PURPOSE_CD                                           
                  ,SCHED_SEND_DT                                        
                  ,STATUS_CD                                            
                  ,STREET_ADDR_1                                        
                  ,STREET_ADDR_2                                        
                  ,TRANS_CD                                             
                  ,ZIP_CODE                                             
                  ,DATE_CREATED                                         
                  ,LAST_UPDATE_TS                                       
                  ,LAST_UPDATE_USERID                                   
                  ,UPDATE_IND                                           
                  ,REVENUE_MONTH                                        
                  )                                                     
                 VALUES                                                 
                  (                                                     
                   :HZ-ACCOUNT-NO                                       
                  ,:HZ-BILL-NO                                          
                  ,:HZ-AMT-DUE                                          
                  ,IIF(TRY_CONVERT(DATE, :HZ-BILL-DUE-DATE
              ) IS NULL OR (PATINDEX('%.%', :HZ-BILL-DUE-DATE
              ) <> 0) OR (LEN(:HZ-BILL-DUE-DATE) <> 10), CIS.CHAR2DATE(
                                                      :HZ-BILL-DUE-DATE
              ), CONVERT(DATE, :HZ-BILL-DUE-DATE) )                            
                  ,:HZ-CODE-STATE-ID                                    
                  ,:HZ-CUSTOMER-NA                                      
                  ,IIF(TRY_CONVERT(DATE, :HZ-DATE-BILLED
              ) IS NULL OR (PATINDEX('%.%', :HZ-DATE-BILLED
              ) <> 0) OR (LEN(:HZ-DATE-BILLED) <> 10), CIS.CHAR2DATE(
                                                        :HZ-DATE-BILLED
              ), CONVERT(DATE, :HZ-DATE-BILLED) )                              
                  ,IIF(TRY_CONVERT(DATE, :HZ-DATE-READ 
                                         :WS-DATE-READ-NULL
              ) IS NULL OR (PATINDEX('%.%', :HZ-DATE-READ 
                                                     :WS-DATE-READ-NULL
              ) <> 0) OR (LEN(:HZ-DATE-READ :WS-DATE-READ-NULL
              ) <> 10), CIS.CHAR2DATE(:HZ-DATE-READ :WS-DATE-READ-NULL
              ), CONVERT(DATE, :HZ-DATE-READ :WS-DATE-READ-NULL) )             
                  ,:HZ-MST-ACCT-NO                                      
                  ,:HZ-MST-SUB-ACCT-IND                                 
                  ,:HZ-PURPOSE-CD                                       
                  ,IIF(TRY_CONVERT(DATE, :HZ-SCHED-SEND-DT 
                                         :WS-SCHED-DT-NULL
              ) IS NULL OR (PATINDEX('%.%', :HZ-SCHED-SEND-DT 
                                                      :WS-SCHED-DT-NULL
              ) <> 0) OR (LEN(:HZ-SCHED-SEND-DT :WS-SCHED-DT-NULL
              ) <> 10), CIS.CHAR2DATE(:HZ-SCHED-SEND-DT 
                                                      :WS-SCHED-DT-NULL
              ), CONVERT(DATE, :HZ-SCHED-SEND-DT :WS-SCHED-DT-NULL) )          
                  ,:HZ-STATUS-CD                                        
                  ,:HZ-STREET-ADDR-1                                    
                  ,:HZ-STREET-ADDR-2                                    
                  ,:HZ-TRANS-CD                                         
                  ,:HZ-ZIP-CODE                                         
                  ,CAST(SYSDATETIMEOFFSET() AS DATE)                            
                  ,CIS.CURRENT$TIMESTAMP()                                    
                  ,:WS-USER-ID                                          
                  ,'N'                                                  
                  ,:HZ-REVENUE-MONTH                                    
                  )                                                     
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO CSS_EDI_BILL_HDR                                     
MFA-TR*           (                                                             
MFA-TR*            ACCOUNT_NO                                                   
MFA-TR*           ,BILL_NO                                                      
MFA-TR*           ,AMT_DUE                                                      
MFA-TR*           ,BILL_DUE_DATE                                                
MFA-TR*           ,CODE_STATE_ID                                                
MFA-TR*           ,CUSTOMER_NA                                                  
MFA-TR*           ,DATE_BILLED                                                  
MFA-TR*           ,DATE_READ                                                    
MFA-TR*           ,MST_ACCT_NO                                                  
MFA-TR*           ,MST_SUB_ACCT_IND                                             
MFA-TR*           ,PURPOSE_CD                                                   
MFA-TR*           ,SCHED_SEND_DT                                                
MFA-TR*           ,STATUS_CD                                                    
MFA-TR*           ,STREET_ADDR_1                                                
MFA-TR*           ,STREET_ADDR_2                                                
MFA-TR*           ,TRANS_CD                                                     
MFA-TR*           ,ZIP_CODE                                                     
MFA-TR*           ,DATE_CREATED                                                 
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,LAST_UPDATE_USERID                                           
MFA-TR*           ,UPDATE_IND                                                   
MFA-TR*           ,REVENUE_MONTH                                                
MFA-TR*           )                                                             
MFA-TR*          VALUES                                                         
MFA-TR*           (                                                             
MFA-TR*            :HZ-ACCOUNT-NO                                               
MFA-TR*           ,:HZ-BILL-NO                                                  
MFA-TR*           ,:HZ-AMT-DUE                                                  
MFA-TR*           ,:HZ-BILL-DUE-DATE                                            
MFA-TR*           ,:HZ-CODE-STATE-ID                                            
MFA-TR*           ,:HZ-CUSTOMER-NA                                              
MFA-TR*           ,:HZ-DATE-BILLED                                              
MFA-TR*           ,:HZ-DATE-READ:WS-DATE-READ-NULL                              
MFA-TR*           ,:HZ-MST-ACCT-NO                                              
MFA-TR*           ,:HZ-MST-SUB-ACCT-IND                                         
MFA-TR*           ,:HZ-PURPOSE-CD                                               
MFA-TR*           ,:HZ-SCHED-SEND-DT:WS-SCHED-DT-NULL                           
MFA-TR*           ,:HZ-STATUS-CD                                                
MFA-TR*           ,:HZ-STREET-ADDR-1                                            
MFA-TR*           ,:HZ-STREET-ADDR-2                                            
MFA-TR*           ,:HZ-TRANS-CD                                                 
MFA-TR*           ,:HZ-ZIP-CODE                                                 
MFA-TR*           ,CURRENT DATE                                                 
MFA-TR*           ,CURRENT TIMESTAMP                                            
MFA-TR*           ,:WS-USER-ID                                                  
MFA-TR*           ,'N'                                                          
MFA-TR*           ,:HZ-REVENUE-MONTH                                            
MFA-TR*           )                                                             
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8210'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HZ-BILL-NO           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8220-DELETE-HEADER.                                            *        
      ******************************************************************        
       8220-DELETE-HEADER.                                              
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_EDI_BILL_HDR                             
               WHERE ACCOUNT_NO = :HZ-ACCOUNT-NO                        
               AND   BILL_NO    = :HZ-BILL-NO                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8220'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_HDR'   TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HZ-BILL-NO           TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-UPDATE-USAGE.                                             *        
      ******************************************************************        
       8300-UPDATE-USAGE.                                               
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_EDI_BILL_USAGE                                
               SET  BEGIN_READ_DT    =IIF(TRY_CONVERT(DATE, 
                                                      :HW-BEGIN-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :HW-BEGIN-READ-DT
              ) <> 0) OR (LEN(:HW-BEGIN-READ-DT) <> 10), CIS.CHAR2DATE(
                                                      :HW-BEGIN-READ-DT
              ), CONVERT(DATE, :HW-BEGIN-READ-DT) )                 
                 ,  BEGIN_READING    =:HW-BEGIN-READING                 
                 ,  CODE_TIME_PERIOD =:HW-CODE-TIME-PERIOD              
                 ,  CONSTANT         =:HW-CONSTANT                      
                 ,  END_READ_DT      =IIF(TRY_CONVERT(DATE, 
                                                        :HW-END-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :HW-END-READ-DT
              ) <> 0) OR (LEN(:HW-END-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :HW-END-READ-DT
              ), CONVERT(DATE, :HW-END-READ-DT) )                   
                 ,  END_READING      =:HW-END-READING                   
                 ,  METER_NO         =:HW-METER-NO                      
                 ,  NO_UNITS         =:HW-NO-UNITS                      
                 ,  RATE_PLAN_NO     =:HW-RATE-PLAN-NO                  
                 ,  USAGE_CD         =:HW-USAGE-CD                      
                 ,  IC_NO            =:HW-IC-NO                         
                 ,  CODE_UTIL_TYPE   =:HW-CODE-UTIL-TYPE                
               WHERE ACCOUNT_NO = :HW-ACCOUNT-NO                        
               AND   BILL_NO    = :HW-BILL-NO                           
               AND   SEQ_NO     = :HW-SEQ-NO                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_EDI_BILL_USAGE                                        
MFA-TR*        SET  BEGIN_READ_DT    =:HW-BEGIN-READ-DT                         
MFA-TR*          ,  BEGIN_READING    =:HW-BEGIN-READING                         
MFA-TR*          ,  CODE_TIME_PERIOD =:HW-CODE-TIME-PERIOD                      
MFA-TR*          ,  CONSTANT         =:HW-CONSTANT                              
MFA-TR*          ,  END_READ_DT      =:HW-END-READ-DT                           
MFA-TR*          ,  END_READING      =:HW-END-READING                           
MFA-TR*          ,  METER_NO         =:HW-METER-NO                              
MFA-TR*          ,  NO_UNITS         =:HW-NO-UNITS                              
MFA-TR*          ,  RATE_PLAN_NO     =:HW-RATE-PLAN-NO                          
MFA-TR*          ,  USAGE_CD         =:HW-USAGE-CD                              
MFA-TR*          ,  IC_NO            =:HW-IC-NO                                 
MFA-TR*          ,  CODE_UTIL_TYPE   =:HW-CODE-UTIL-TYPE                        
MFA-TR*        WHERE ACCOUNT_NO = :HW-ACCOUNT-NO                                
MFA-TR*        AND   BILL_NO    = :HW-BILL-NO                                   
MFA-TR*        AND   SEQ_NO     = :HW-SEQ-NO                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
A02177        MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_USAGE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HW-BILL-NO           TO HOSTVAR-ELEMENT-2            
              MOVE 'SEQ_NO    '         TO TABLE-ELEMENT-3              
              MOVE HW-SEQ-NO            TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
      *                                                                         
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-UPDATE-USAGE.                                             *        
      ******************************************************************        
       8310-INSERT-USAGE.                                               
                                                                        
           EXEC SQL                                                     
                                                                        
               INSERT INTO CSS_EDI_BILL_USAGE                           
                 (                                                      
                    ACCOUNT_NO                                          
                   ,BILL_NO                                             
                   ,SEQ_NO                                              
                   ,BEGIN_READ_DT                                       
                   ,BEGIN_READING                                       
                   ,CODE_TIME_PERIOD                                    
                   ,CONSTANT                                            
                   ,END_READ_DT                                         
                   ,END_READING                                         
                   ,METER_NO                                            
                   ,NO_UNITS                                            
                   ,RATE_PLAN_NO                                        
                   ,USAGE_CD                                            
                   ,IC_NO                                               
                   ,CODE_UTIL_TYPE                                      
                 )                                                      
                 VALUES                                                 
                 (                                                      
                   :HW-ACCOUNT-NO                                       
                  ,:HW-BILL-NO                                          
                  ,:HW-SEQ-NO                                           
                  ,IIF(TRY_CONVERT(DATE, :HW-BEGIN-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :HW-BEGIN-READ-DT
              ) <> 0) OR (LEN(:HW-BEGIN-READ-DT) <> 10), CIS.CHAR2DATE(
                                                      :HW-BEGIN-READ-DT
              ), CONVERT(DATE, :HW-BEGIN-READ-DT) )                            
                  ,:HW-BEGIN-READING                                    
                  ,:HW-CODE-TIME-PERIOD                                 
                  ,:HW-CONSTANT                                         
                  ,IIF(TRY_CONVERT(DATE, :HW-END-READ-DT
              ) IS NULL OR (PATINDEX('%.%', :HW-END-READ-DT
              ) <> 0) OR (LEN(:HW-END-READ-DT) <> 10), CIS.CHAR2DATE(
                                                        :HW-END-READ-DT
              ), CONVERT(DATE, :HW-END-READ-DT) )                              
                  ,:HW-END-READING                                      
                  ,:HW-METER-NO                                         
                  ,:HW-NO-UNITS                                         
                  ,:HW-RATE-PLAN-NO                                     
                  ,:HW-USAGE-CD                                         
                  ,:HW-IC-NO                                            
                  ,:HW-CODE-UTIL-TYPE                                   
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        INSERT INTO CSS_EDI_BILL_USAGE                                   
MFA-TR*          (                                                              
MFA-TR*             ACCOUNT_NO                                                  
MFA-TR*            ,BILL_NO                                                     
MFA-TR*            ,SEQ_NO                                                      
MFA-TR*            ,BEGIN_READ_DT                                               
MFA-TR*            ,BEGIN_READING                                               
MFA-TR*            ,CODE_TIME_PERIOD                                            
MFA-TR*            ,CONSTANT                                                    
MFA-TR*            ,END_READ_DT                                                 
MFA-TR*            ,END_READING                                                 
MFA-TR*            ,METER_NO                                                    
MFA-TR*            ,NO_UNITS                                                    
MFA-TR*            ,RATE_PLAN_NO                                                
MFA-TR*            ,USAGE_CD                                                    
MFA-TR*            ,IC_NO                                                       
MFA-TR*            ,CODE_UTIL_TYPE                                              
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*            :HW-ACCOUNT-NO                                               
MFA-TR*           ,:HW-BILL-NO                                                  
MFA-TR*           ,:HW-SEQ-NO                                                   
MFA-TR*           ,:HW-BEGIN-READ-DT                                            
MFA-TR*           ,:HW-BEGIN-READING                                            
MFA-TR*           ,:HW-CODE-TIME-PERIOD                                         
MFA-TR*           ,:HW-CONSTANT                                                 
MFA-TR*           ,:HW-END-READ-DT                                              
MFA-TR*           ,:HW-END-READING                                              
MFA-TR*           ,:HW-METER-NO                                                 
MFA-TR*           ,:HW-NO-UNITS                                                 
MFA-TR*           ,:HW-RATE-PLAN-NO                                             
MFA-TR*           ,:HW-USAGE-CD                                                 
MFA-TR*           ,:HW-IC-NO                                                    
MFA-TR*           ,:HW-CODE-UTIL-TYPE                                           
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8310'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_USAGE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HW-BILL-NO           TO HOSTVAR-ELEMENT-2            
              MOVE 'SEQ_NO    '         TO TABLE-ELEMENT-3              
              MOVE HW-SEQ-NO            TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       8310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8320-DELETE-USAGE.                                             *        
      ******************************************************************        
       8320-DELETE-USAGE.                                               
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_EDI_BILL_USAGE                           
               WHERE ACCOUNT_NO = :HW-ACCOUNT-NO                        
               AND   BILL_NO    = :HW-BILL-NO                           
               AND   SEQ_NO     = :HW-SEQ-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8320'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_USAGE' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HW-BILL-NO           TO HOSTVAR-ELEMENT-2            
              MOVE 'SEQ_NO    '         TO TABLE-ELEMENT-3              
              MOVE HW-SEQ-NO            TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       8320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8400-UPDATE-CHARGES.                                           *        
      ******************************************************************        
       8400-UPDATE-CHARGES.                                             
                                                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_EDI_BILL_CHRGS                                
               SET  USAGE_CD         =:HF-USAGE-CD                      
                 ,  IC_NO            =:HF-IC-NO                         
                 ,  CODE_UTIL_TYPE   =:HF-CODE-UTIL-TYPE                
                 ,  BILL_UNITS       =:HF-BILL-UNITS                    
                 ,  BILLED_AM        =:HF-BILLED-AM                     
                 ,  CHARGE_TYPE_TX   =:HF-CHARGE-TYPE-TX                
                 ,  CHARGE_TYPE_DESC =:HF-CHARGE-TYPE-DESC              
                 ,  SUB_ACCT_NO      =:HF-SUB-ACCT-NO :WS-NULL-IND1      
               WHERE ACCOUNT_NO = :HF-ACCOUNT-NO                        
               AND   BILL_NO    = :HF-BILL-NO                           
               AND   SEQ_NO     = :HF-SEQ-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_CHRGS' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HF-BILL-NO           TO HOSTVAR-ELEMENT-2            
              MOVE 'SEQ_NO    '         TO TABLE-ELEMENT-3              
              MOVE HF-SEQ-NO            TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8410-INSERT-CHARGES.                                           *        
      ******************************************************************        
       8410-INSERT-CHARGES.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_EDI_BILL_CHRGS                           
                   (                                                    
                     ACCOUNT_NO                                         
                    ,BILL_NO                                            
                    ,SEQ_NO                                             
                    ,USAGE_CD                                           
                    ,IC_NO                                              
                    ,CODE_UTIL_TYPE                                     
                    ,BILL_UNITS                                         
                    ,BILLED_AM                                          
                    ,CHARGE_TYPE_TX                                     
                    ,CHARGE_TYPE_DESC                                   
                    ,SUB_ACCT_NO                                        
                   )                                                    
                 VALUES                                                 
                   (                                                    
                    :HF-ACCOUNT-NO                                      
                   ,:HF-BILL-NO                                         
                   ,:HF-SEQ-NO                                          
                   ,:HF-USAGE-CD                                        
                   ,:HF-IC-NO                                           
                   ,:HF-CODE-UTIL-TYPE                                  
                   ,:HF-BILL-UNITS                                      
                   ,:HF-BILLED-AM                                       
                   ,:HF-CHARGE-TYPE-TX                                  
                   ,:HF-CHARGE-TYPE-DESC                                
                   ,:HF-SUB-ACCT-NO :WS-NULL-IND1                        
                   )                                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8410'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_CHRGS' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HF-BILL-NO           TO HOSTVAR-ELEMENT-2            
              MOVE 'SEQ_NO    '         TO TABLE-ELEMENT-3              
              MOVE HF-SEQ-NO            TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       8410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8420-DELETE-CHARGES.                                           *        
      ******************************************************************        
       8420-DELETE-CHARGES.                                             
                                                                        
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_EDI_BILL_CHRGS                           
               WHERE ACCOUNT_NO = :HF-ACCOUNT-NO                        
               AND   BILL_NO    = :HF-BILL-NO                           
               AND   SEQ_NO     = :HF-SEQ-NO                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE SQLCODE              TO ABEND-SQLCODE                
              MOVE SQLSTATE             TO ABEND-SQLSTATE               
              MOVE '8420'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_EDI_BILL_CHRGS' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE HF-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'BILL_NO   '         TO TABLE-ELEMENT-2              
              MOVE HF-BILL-NO           TO HOSTVAR-ELEMENT-2            
              MOVE 'SEQ_NO    '         TO TABLE-ELEMENT-3              
              MOVE HF-SEQ-NO            TO HOSTVAR-ELEMENT-3            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
      *                                                                         
       8420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
       8900-SEND-DONE.                                                  
                                                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         ABEND-SQLCODE.                 
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9900-SQL-ERROR-ROUTINE                                        *         
      *****************************************************************         
       9900-SQL-ERROR-ROUTINE.                                          
      *                                                                         
           PERFORM 9975-ABEND-CONTROL-TRANSFER THRU 9975-EXIT.          
                                                                        
       9900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 9975-ABEND-CONTROL-TRANSFER                                   *         
      *****************************************************************         
       9975-ABEND-CONTROL-TRANSFER.                                     
                                                                        
           PERFORM 8900-SEND-DONE              THRU 8900-EXIT           

MSQ002     EXEC SQL
MSQ002         SELECT LTRIM(RTRIM(CASE                                          
                        WHEN :TABLE-ELEMENT-1 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-1)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-1))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-2 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-2)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-2))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-3 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-3)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-3))                    
                        ELSE                                            
                           ''                                           
                     END + CASE                                               
                        WHEN :TABLE-ELEMENT-4 > ' ' THEN                
                           LTRIM(RTRIM(:TABLE-ELEMENT-4)) + '=' + 
           LTRIM(RTRIM(:HOSTVAR-ELEMENT-4))                    
                        ELSE                                            
                           ''                                           
                     END))
MSQ002              , :ABEND-FUNCTION
MSQ002              , 'PARAGRAPH-' + LTRIM(RTRIM(:ACTIVE-PARAGRAPH)) + 
           ',' + 'TABLES-' + LTRIM(RTRIM(:TABLE-2)) + LTRIM(RTRIM(
                                                               :TABLE-3
           )) + LTRIM(RTRIM(:TABLE-4))
MSQ002           INTO :MFA-CSRERLOG.ARG-5
MSQ002              , :MFA-CSRERLOG.ARG-6
MSQ002              , :MFA-CSRERLOG.ARG-7
MSQ002     END-EXEC
                                                                        
           EXEC SQL                                                     
               CALL CSRERLOG ( :ABEND-PROGRAM
                  , :ABEND-SQLCODE
                  , :ABEND-SQLSTATE
                  , :TABLE-1
                  , :MFA-CSRERLOG.ARG-5
                  , :MFA-CSRERLOG.ARG-6
                  , :MFA-CSRERLOG.ARG-7
                  )                                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ002
MFA-TR*    EXEC SQL                                                             
MFA-TR*        CALL CSRERLOG (                                                  
MFA-TR*             :ABEND-PROGRAM,                                             
MFA-TR*             :ABEND-SQLCODE,                                             
MFA-TR*             :ABEND-SQLSTATE,                                            
MFA-TR*             :TABLE-1,                                                   
MFA-TR*              VARCHAR(STRIP(                                             
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-1 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-1) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-1)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-2 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-2) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-2)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-3 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-3) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-3)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END CONCAT                                                 
MFA-TR*              CASE                                                       
MFA-TR*                 WHEN :TABLE-ELEMENT-4 > ' ' THEN                        
MFA-TR*                    STRIP(:TABLE-ELEMENT-4) CONCAT '=' CONCAT            
MFA-TR*                    STRIP(:HOSTVAR-ELEMENT-4)                            
MFA-TR*                 ELSE                                                    
MFA-TR*                    ''                                                   
MFA-TR*              END                                                        
MFA-TR*              )),                                                        
MFA-TR*              VARCHAR(:ABEND-FUNCTION),                                  
MFA-TR*              VARCHAR(                                                   
MFA-TR*              'PARAGRAPH-' CONCAT STRIP(:ACTIVE-PARAGRAPH) CONCAT        
MFA-TR*              ',' CONCAT 'TABLES-' CONCAT STRIP(:TABLE-2) CONCAT         
MFA-TR*              STRIP(:TABLE-3) CONCAT STRIP(:TABLE-4)                     
MFA-TR*              )                                                          
MFA-TR*             )                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           
MSQ016        GOBACK.                                                    
      *                                                                         
       9975-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           ELSE                                                         
              PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
                                                                        
