       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR03106.                                         
COB303 DATE-WRITTEN.  APR 23,2016.                                      
       DATE-COMPILED.                                                   
      *                                                                         
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *  RETRIEVE DATA FOR BTU FACTOR AND BTU INDUSTRIAL DETAIL        *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/23/16  MS7M727    PROCEDURE ORIGINALLY CODED.              *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       ENVIRONMENT DIVISION.                                            
      *                                                                         
       DATA DIVISION.                                                   
      *                                                                         
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR03106'.
MSQ017     COPY MFASQLM.
      *                                                                         
       01 WS-LITERALS.                                                  
          05 PROGRAM-NAME               PIC X(08) VALUE 'CSR03106'.     
      *                                                                         
       01 WS-MISC.                                                      
          05 WS-GTT-NAME                PIC X(19) VALUE SPACES.         
          05 CTR-ROWS1                  PIC S9(9) COMP VALUE 0.         
          05 WS-SQLSTATE                PIC X(05) VALUE SPACES.         
      *                                                                         
       01 WS-SWITCHES.                                                  
          05 SEND-DONE-SW               PIC X(01) VALUE 'Y'.            
             88 SEND-DONE-ERROR                   VALUE 'N'.            
             88 SEND-DONE-OK                      VALUE 'Y'.            
          05  WS-NO-MORE-RECORDS        PIC X(01) VALUE 'N'.            
              88 NO-MORE-RECORDS                  VALUE 'Y'.            
      *                                                                         
       01 GTT-RETURN-FIELDS-R1.                                         
          05 S-RETURN-CODE              PIC S9(09) COMP VALUE 0.        
          05 S-COMPANY-NO               PIC X(02) VALUE SPACES.         
          05 S-BTU-DT                   PIC X(10) VALUE SPACES.         
          05 S-MCF-TRANSCO              PIC S9(7)V USAGE COMP-3         
                                                  VALUE ZERO.           
          05 S-BTU-TRANSCO              PIC S9(3)V9(5) USAGE COMP-3     
                                                  VALUE ZERO.           
          05 S-MCF-SALLEY-BOILOFF       PIC S9(7)V USAGE COMP-3         
                                                  VALUE ZERO.           
          05 S-BTU-SALLEY-BOILOFF       PIC S9(3)V9(5) USAGE COMP-3     
                                                  VALUE ZERO.           
          05 S-MCF-SALLEY-VAPOR         PIC S9(7)V USAGE COMP-3         
                                                  VALUE ZERO.           
          05 S-BTU-SALLEY-VAPOR         PIC S9(3)V9(5) USAGE COMP-3     
                                                  VALUE ZERO.           
          05 S-MCF-TOTAL                PIC S9(7)V USAGE COMP-3         
                                                  VALUE ZERO.           
          05 S-MMBTU-TOTAL              PIC S9(7)V USAGE COMP-3         
                                                  VALUE ZERO.           
          05 S-BTU-SNG                  PIC S9(7)V USAGE COMP-3         
                                                  VALUE ZERO.           
          05 S-LAST-UPDATE-TS           PIC X(26) VALUE SPACES.         
          05 S-LAST-UPDATE-USERID       PIC X(07) VALUE SPACES.         
      *                                                                         
       01 GTT-RETURN-FIELDS-R2.                                         
          05 S-RETURN-CODE1             PIC S9(09) COMP VALUE 0.        
          05 S-COMPANY-NO1              PIC X(02) VALUE SPACES.         
          05 S-INDUST-BTU-ID            PIC X(03) VALUE SPACES.         
          05 S-BTU-DT1                  PIC X(10) VALUE SPACES.         
          05 S-BTU-FACTOR               PIC S9(2)V9(5) USAGE COMP-3     
                                                  VALUE ZERO.           
          05 S-SPECIFIC-GRAVITY         PIC S9(1)V9(3) USAGE COMP-3     
                                                  VALUE ZERO.           
      *                                                                         
      *****************************************************************         
      *    ERROR HANDLING                                                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSX0010                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    COPYBOOK FOR STORED PROCEDURE ERROR PROCESSING                       
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CWSSP001                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    SUPPORTS DB2 AND SQL ERROR CHECKING                         *        
      ******************************************************************        
      *                                                                         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    COMMON SYSTEM AREA                                          *        
      ******************************************************************        
      *                                                                         
           COPY CCA00001.                                                       
      *                                                                         
      ******************************************************************        
      *   SQL COMMUNICATION AREA                                       *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
               INCLUDE SQLCA                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BTU_INDUST_FCT  - FE                                    *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBINDFCT                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CSS_BTU_FACTOR      - TF                                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
                INCLUDE TBBTUFCT                                                
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    CURSOR FOR GET_BTU_FACTOR                                            
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             DECLARE GET_BTU_FACTOR CURSOR FOR                          
              SELECT TF.COMPANY_NO,                                     
                     TF.BTU_DT,                                         
                     TF.MCF_TRANSCO,                                    
                     TF.BTU_TRANSCO,                                    
                     TF.MCF_SALLEY_BOILOFF,                             
                     TF.BTU_SALLEY_BOILOFF,                             
                     TF.MCF_SALLEY_VAPOR,                               
                     TF.BTU_SALLEY_VAPOR,                               
                     TF.MCF_TOTAL,                                      
                     TF.MMBTU_TOTAL,                                    
                     TF.BTU_SNG,                                        
                     REPLACE(REPLACE(CONVERT(CHAR(26), TF.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                     TF.LAST_UPDATE_USERID                              
                FROM CSS_BTU_FACTOR TF WITH(READUNCOMMITTED)                    
               ORDER BY COMPANY_NO                                      
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_BTU_FACTOR CURSOR FOR                                  
MFA-TR*       SELECT TF.COMPANY_NO,                                             
MFA-TR*              TF.BTU_DT,                                                 
MFA-TR*              TF.MCF_TRANSCO,                                            
MFA-TR*              TF.BTU_TRANSCO,                                            
MFA-TR*              TF.MCF_SALLEY_BOILOFF,                                     
MFA-TR*              TF.BTU_SALLEY_BOILOFF,                                     
MFA-TR*              TF.MCF_SALLEY_VAPOR,                                       
MFA-TR*              TF.BTU_SALLEY_VAPOR,                                       
MFA-TR*              TF.MCF_TOTAL,                                              
MFA-TR*              TF.MMBTU_TOTAL,                                            
MFA-TR*              TF.BTU_SNG,                                                
MFA-TR*              TF.LAST_UPDATE_TS,                                         
MFA-TR*              TF.LAST_UPDATE_USERID                                      
MFA-TR*         FROM CSS_BTU_FACTOR TF                                          
MFA-TR*        ORDER BY COMPANY_NO                                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      *                                                                         
      ******************************************************************        
      *    CURSOR FOR GET_BTU_INDUS                                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                     
             DECLARE GET_BTU_INDUS CURSOR FOR                           
              SELECT  FE.COMPANY_NO                                     
                     ,FE.INDUST_BTU_ID                                  
                     ,FE.BTU_DT                                         
                     ,FE.BTU_FACTOR                                     
                     ,FE.SPECIFIC_GRAVITY                               
                FROM  CSS_BTU_INDUST_FCT FE WITH(READUNCOMMITTED)               
                                                                
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE GET_BTU_INDUS CURSOR FOR                                   
MFA-TR*       SELECT  FE.COMPANY_NO                                             
MFA-TR*              ,FE.INDUST_BTU_ID                                          
MFA-TR*              ,FE.BTU_DT                                                 
MFA-TR*              ,FE.BTU_FACTOR                                             
MFA-TR*              ,FE.SPECIFIC_GRAVITY                                       
MFA-TR*         FROM  CSS_BTU_INDUST_FCT FE                                     
MFA-TR*         WITH  UR                                                        
MFA-TR*      QUERYNO  7100                                                      
MFA-TR*    END-EXEC.                                                            
      *                                                                         
       PROCEDURE DIVISION.                                              
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 1000-PROCESS-GTT            THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 0100A-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100A-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR03106_R1'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03106_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03106_R1
              (                                                       
                    RETURN_CODE             INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,BTU_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,MCF_TRANSCO             DECIMAL(7,0)               
                   ,BTU_TRANSCO             DECIMAL(8,5)               
                   ,MCF_SALLEY_BOILOFF CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,BTU_SALLEY_BOILOFF      DECIMAL(8,5)               
                   ,MCF_SALLEY_VAPOR        DECIMAL(7,0)               
                   ,BTU_SALLEY_VAPOR        DECIMAL(8,5)               
                   ,MCF_TOTAL               DECIMAL(7,0)               
                   ,MMBTU_TOTAL             DECIMAL(7,0)               
                   ,BTU_SNG                 DECIMAL(8,5)               
                   ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                    
                   ,LAST_UPDATE_USERID CHAR(7)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DEL-GTT-ROWS       THRU 8000A-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100A'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,COMPANY_NO              AS COMPANY_NO            
                      ,BTU_DT                  AS BTU_DT                
                      ,MCF_TRANSCO             AS MCF_TRANSCO           
                      ,BTU_TRANSCO             AS BTU_TRANSCO           
                      ,MCF_SALLEY_BOILOFF      AS MCF_SALLEY_BOILOFF    
                      ,BTU_SALLEY_BOILOFF      AS BTU_SALLEY_BOILOFF    
                      ,MCF_SALLEY_VAPOR        AS MCF_SALLEY_VAPOR      
                      ,BTU_SALLEY_VAPOR        AS BTU_SALLEY_VAPOR      
                      ,MCF_TOTAL               AS MCF_TOTAL             
                      ,MMBTU_TOTAL             AS MMBTU_TOTAL           
                      ,BTU_SNG                 AS BTU_SNG               
                      ,LAST_UPDATE_TS          AS LAST_UPDATE_TS        
                      ,LAST_UPDATE_USERID      AS LAST_UPDATE_USERID    
                  FROM #CSR03106_R1                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,COMPANY_NO              AS COMPANY_NO                    
MFA-TR*               ,BTU_DT                  AS BTU_DT                        
MFA-TR*               ,MCF_TRANSCO             AS MCF_TRANSCO                   
MFA-TR*               ,BTU_TRANSCO             AS BTU_TRANSCO                   
MFA-TR*               ,MCF_SALLEY_BOILOFF      AS MCF_SALLEY_BOILOFF            
MFA-TR*               ,BTU_SALLEY_BOILOFF      AS BTU_SALLEY_BOILOFF            
MFA-TR*               ,MCF_SALLEY_VAPOR        AS MCF_SALLEY_VAPOR              
MFA-TR*               ,BTU_SALLEY_VAPOR        AS BTU_SALLEY_VAPOR              
MFA-TR*               ,MCF_TOTAL               AS MCF_TOTAL                     
MFA-TR*               ,MMBTU_TOTAL             AS MMBTU_TOTAL                   
MFA-TR*               ,BTU_SNG                 AS BTU_SNG                       
MFA-TR*               ,LAST_UPDATE_TS          AS LAST_UPDATE_TS                
MFA-TR*               ,LAST_UPDATE_USERID      AS LAST_UPDATE_USERID            
MFA-TR*           FROM SESSION.CSR03106_R1                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 0100B-DECLARE-GTT                                              *        
      ******************************************************************        
      *                                                                         
       0100B-DECLARE-GTT.                                               
      *                                                                         
           MOVE 'SESSION.CSR03106_R2'        TO WS-GTT-NAME.            
                                                                        
           EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR03106_R2')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR03106_R2
              (                                                       
                    RETURN_CODE             INT                     
                   ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
                   ,INDUST_BTU_ID CHAR(3)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
                   ,BTU_DT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
                   ,BTU_FACTOR              DECIMAL(7,5)               
                   ,SPECIFIC_GRAVITY        DECIMAL(4,3)               
                )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLSTATE                 TO WS-SQLSTATE.                
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000B-DEL-GTT-ROWS       THRU 8000B-EXIT          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 CONTINUE                                               
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '0100B'            TO ACTIVE-PARAGRAPH            
                 MOVE SQLCODE            TO ABEND-SQLCODE               
                 MOVE SQLSTATE           TO ABEND-SQLSTATE              
                 MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
                 MOVE SPACES             TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
                 MOVE WS-GTT-NAME        TO TABLE-1                     
                 MOVE SPACES             TO TABLE-ELEMENT-1             
                 MOVE SPACES             TO HOSTVAR-ELEMENT-1           
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               DECLARE C2 CURSOR                             
                                 WITH ROWSET POSITIONING FOR            
                SELECT RETURN_CODE                                      
                      ,COMPANY_NO              AS COMPANY_NO            
                      ,INDUST_BTU_ID           AS INDUST_BTU_ID         
                      ,BTU_DT                  AS BTU_DT                
                      ,BTU_FACTOR              AS BTU_FACTOR            
                      ,SPECIFIC_GRAVITY        AS SPECIFIC_GRAVITY      
                  FROM #CSR03106_R2                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C2 CURSOR WITH RETURN                                    
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*         SELECT RETURN_CODE                                              
MFA-TR*               ,COMPANY_NO              AS COMPANY_NO                    
MFA-TR*               ,INDUST_BTU_ID           AS INDUST_BTU_ID                 
MFA-TR*               ,BTU_DT                  AS BTU_DT                        
MFA-TR*               ,BTU_FACTOR              AS BTU_FACTOR                    
MFA-TR*               ,SPECIFIC_GRAVITY        AS SPECIFIC_GRAVITY              
MFA-TR*           FROM SESSION.CSR03106_R2                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 1000-PROCESS-GTT                                               *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-GTT.                                                
      *                                                                         
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
           PERFORM 0100B-DECLARE-GTT  THRU 0100B-EXIT.                  
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT                                            *        
      ******************************************************************        
      *                                                                         
       2000-PROCESS-OUTPUT.                                             
      *                                                                         
           PERFORM 2100-PROCESS-BTU-FACTOR      THRU 2100-EXIT.         
           PERFORM 2200-PROCESS-BTU-INDUS       THRU 2200-EXIT.         
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2100-PROCESS-BTU-FACTOR                                        *        
      ******************************************************************        
      *                                                                         
       2100-PROCESS-BTU-FACTOR.                                         
      *                                                                         
           PERFORM 7000-OPEN-BTU-FACTOR-CUR     THRU 7000-EXIT.         
           PERFORM 7100-FETCH-BTU-FACTOR-CUR    THRU 7100-EXIT.         
           PERFORM 5000-LOAD-BTU-FACTOR         THRU 5000-EXIT          
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           IF CTR-ROWS = 0                                              
              MOVE SQLCODE               TO S-RETURN-CODE               
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF                                                       
           PERFORM 7200-CLOSE-BTU-FACTOR-CUR    THRU 7200-EXIT.         
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-BTU-INDUS                                                  
      ******************************************************************        
      *                                                                         
       2200-PROCESS-BTU-INDUS.                                          
      *                                                                         
           PERFORM 7300-OPEN-BTU-INDUS-FAC-CUR  THRU 7300-EXIT.         
           PERFORM 7400-FETCH-BTU-INDUS-FAC-CUR THRU 7400-EXIT.         
           PERFORM 5100-LOAD-BTU-FACTOR-FAC     THRU 5100-EXIT          
             UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.               
           IF CTR-ROWS1 = 0                                             
              MOVE SQLCODE               TO S-RETURN-CODE1              
              PERFORM 8200-SEND-RESULT          THRU 8200-EXIT          
           END-IF                                                       
           PERFORM 7500-CLOSE-BTU-INDUS-FAC-CUR THRU 7500-EXIT.         
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5000-LOAD-BTU-FACTOR                                                    
      ******************************************************************        
      *                                                                         
       5000-LOAD-BTU-FACTOR.                                            
      *                                                                         
           MOVE TF-COMPANY-NO            TO S-COMPANY-NO                
           MOVE TF-BTU-DT                TO S-BTU-DT                    
           MOVE TF-MCF-TRANSCO           TO S-MCF-TRANSCO               
           MOVE TF-BTU-TRANSCO           TO S-BTU-TRANSCO               
           MOVE TF-MCF-SALLEY-BOILOFF    TO S-MCF-SALLEY-BOILOFF        
           MOVE TF-BTU-SALLEY-BOILOFF    TO S-BTU-SALLEY-BOILOFF        
           MOVE TF-MCF-SALLEY-VAPOR      TO S-MCF-SALLEY-VAPOR          
           MOVE TF-BTU-SALLEY-VAPOR      TO S-BTU-SALLEY-VAPOR          
           MOVE TF-MCF-TOTAL             TO S-MCF-TOTAL                 
           MOVE TF-MMBTU-TOTAL           TO S-MMBTU-TOTAL               
           MOVE TF-BTU-SNG               TO S-BTU-SNG                   
           MOVE TF-LAST-UPDATE-TS        TO S-LAST-UPDATE-TS            
           MOVE TF-LAST-UPDATE-USERID    TO S-LAST-UPDATE-USERID        
      *                                                                         
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
      *                                                                         
           PERFORM 7100-FETCH-BTU-FACTOR-CUR    THRU 7100-EXIT.         
      *                                                                         
       5000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 5100-LOAD-BTU-FACTOR-FAC                                                
      ******************************************************************        
      *                                                                         
       5100-LOAD-BTU-FACTOR-FAC.                                        
      *                                                                         
           MOVE FE-COMPANY-NO            TO S-COMPANY-NO1               
           MOVE FE-INDUST-BTU-ID         TO S-INDUST-BTU-ID             
           MOVE FE-BTU-DT                TO S-BTU-DT1                   
           MOVE FE-BTU-FACTOR            TO S-BTU-FACTOR                
           MOVE FE-SPECIFIC-GRAVITY      TO S-SPECIFIC-GRAVITY          
      *                                                                         
           PERFORM 8200-SEND-RESULT             THRU 8200-EXIT.         
      *                                                                         
           PERFORM 7400-FETCH-BTU-INDUS-FAC-CUR THRU 7400-EXIT.         
      *                                                                         
       5100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7000-OPEN-BTU-FACTOR-CUR                                                
      ******************************************************************        
      *                                                                         
       7000-OPEN-BTU-FACTOR-CUR.                                        
      *                                                                         
           EXEC SQL                                                     
               OPEN GET_BTU_FACTOR                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN  '                  TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_FACTOR'          TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7100-FETCH-BTU-FACTOR-CUR                                      *        
      ******************************************************************        
      *                                                                         
       7100-FETCH-BTU-FACTOR-CUR.                                       
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_BTU_FACTOR INTO                                 
                    :TF-COMPANY-NO                                      
                   ,:TF-BTU-DT                                          
                   ,:TF-MCF-TRANSCO                                     
                   ,:TF-BTU-TRANSCO                                     
                   ,:TF-MCF-SALLEY-BOILOFF                              
                   ,:TF-BTU-SALLEY-BOILOFF                              
                   ,:TF-MCF-SALLEY-VAPOR                                
                   ,:TF-BTU-SALLEY-VAPOR                                
                   ,:TF-MCF-TOTAL                                       
                   ,:TF-MMBTU-TOTAL                                     
                   ,:TF-BTU-SNG                                         
                   ,:TF-LAST-UPDATE-TS                                  
                   ,:TF-LAST-UPDATE-USERID                              
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              NOT-FOUND                                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '1000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH '                  TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_FACTOR'          TO TABLE-1                 
              MOVE 'BTU_DT    '              TO TABLE-ELEMENT-1         
              MOVE TF-BTU-DT                 TO HOSTVAR-ELEMENT-1       
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE TF-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7200-CLOSE-BTU-FACTOR-CUR                                      *        
      ******************************************************************        
      *                                                                         
       7200-CLOSE-BTU-FACTOR-CUR.                                       
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_BTU_FACTOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE '                  TO ABEND-FUNCTION          
              MOVE 'GET_BTU_FACTOR    '      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-BTU-INDUS-FAC-CUR                                             
      ******************************************************************        
      *                                                                         
       7300-OPEN-BTU-INDUS-FAC-CUR.                                     
      *                                                                         
           EXEC SQL                                                     
               OPEN GET_BTU_INDUS                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN  '                  TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_INDUST_FCT'      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7400-FETCH-BTU-INDUS-FAC-CUR                                   *        
      ******************************************************************        
      *                                                                         
       7400-FETCH-BTU-INDUS-FAC-CUR.                                    
      *                                                                         
           EXEC SQL                                                     
              FETCH GET_BTU_INDUS INTO                                  
                    :FE-COMPANY-NO                                      
                   ,:FE-INDUST-BTU-ID                                   
                   ,:FE-BTU-DT                                          
                   ,:FE-BTU-FACTOR                                      
                   ,:FE-SPECIFIC-GRAVITY                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR            
              NOT-FOUND                                                 
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH '                  TO ABEND-FUNCTION          
              MOVE 'CSS_BTU_INDUST_FCT'      TO TABLE-1                 
              MOVE 'INDUST_BTU_ID '          TO TABLE-ELEMENT-1         
              MOVE FE-INDUST-BTU-ID          TO HOSTVAR-ELEMENT-1       
              MOVE 'COMPANY_NO'              TO TABLE-ELEMENT-1         
              MOVE FE-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7500-CLOSE-BTU-INDUS-FAC-CUR                                   *        
      ******************************************************************        
      *                                                                         
       7500-CLOSE-BTU-INDUS-FAC-CUR.                                    
      *                                                                         
           EXEC SQL                                                     
              CLOSE GET_BTU_INDUS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE '                  TO ABEND-FUNCTION          
              MOVE 'GET_BTU_INDUS     '      TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
      *                                                                         
       7500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 8000A-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000A-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR03106_R1                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR03106_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR03106_R1'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000A-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8000B-DEL-GTT-ROWS.                                            *        
      ******************************************************************        
      *                                                                         
       8000B-DEL-GTT-ROWS.                                              
      *                                                                         
           EXEC SQL                                                     
               DELETE FROM #CSR03106_R2                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR03106_R2                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE.          
      *                                                                         
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
                    MOVE ZEROES              TO WS-ACTIVE-RETURN-CODE   
                                                S-RETURN-CODE           
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME        TO ABEND-PROGRAM           
                    MOVE SQLCODE             TO ABEND-SQLCODE           
                    MOVE SQLSTATE            TO ABEND-SQLSTATE          
                    MOVE '8000A'             TO ACTIVE-PARAGRAPH        
                    MOVE 'DELETE'            TO ABEND-FUNCTION          
                    MOVE SPACES              TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
                    MOVE 'CSR03106_R2'       TO TABLE-1                 
                    MOVE SPACES              TO TABLE-ELEMENT-1         
                    MOVE SPACES              TO HOSTVAR-ELEMENT-1       
                    PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
           END-EVALUATE.                                                
      *                                                                         
       8000B-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT.                                              *        
      ******************************************************************        
      *                                                                         
       8100-SEND-RESULT.                                                
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR03106_R1                          
                  (                                                     
                    RETURN_CODE                                         
                   ,COMPANY_NO                                          
                   ,BTU_DT                                              
                   ,MCF_TRANSCO                                         
                   ,BTU_TRANSCO                                         
                   ,MCF_SALLEY_BOILOFF                                  
                   ,BTU_SALLEY_BOILOFF                                  
                   ,MCF_SALLEY_VAPOR                                    
                   ,BTU_SALLEY_VAPOR                                    
                   ,MCF_TOTAL                                           
                   ,MMBTU_TOTAL                                         
                   ,BTU_SNG                                             
                   ,LAST_UPDATE_TS                                      
                   ,LAST_UPDATE_USERID                                  
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE                                      
                   ,:S-COMPANY-NO                                       
                   ,:S-BTU-DT                                           
                   ,:S-MCF-TRANSCO                                      
                   ,:S-BTU-TRANSCO                                      
                   ,:S-MCF-SALLEY-BOILOFF                               
                   ,:S-BTU-SALLEY-BOILOFF                               
                   ,:S-MCF-SALLEY-VAPOR                                 
                   ,:S-BTU-SALLEY-VAPOR                                 
                   ,:S-MCF-TOTAL                                        
                   ,:S-MMBTU-TOTAL                                      
                   ,:S-BTU-SNG                                          
                   ,:S-LAST-UPDATE-TS                                   
                   ,:S-LAST-UPDATE-USERID                               
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR03106_R1                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,BTU_DT                                                      
MFA-TR*            ,MCF_TRANSCO                                                 
MFA-TR*            ,BTU_TRANSCO                                                 
MFA-TR*            ,MCF_SALLEY_BOILOFF                                          
MFA-TR*            ,BTU_SALLEY_BOILOFF                                          
MFA-TR*            ,MCF_SALLEY_VAPOR                                            
MFA-TR*            ,BTU_SALLEY_VAPOR                                            
MFA-TR*            ,MCF_TOTAL                                                   
MFA-TR*            ,MMBTU_TOTAL                                                 
MFA-TR*            ,BTU_SNG                                                     
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE                                              
MFA-TR*            ,:S-COMPANY-NO                                               
MFA-TR*            ,:S-BTU-DT                                                   
MFA-TR*            ,:S-MCF-TRANSCO                                              
MFA-TR*            ,:S-BTU-TRANSCO                                              
MFA-TR*            ,:S-MCF-SALLEY-BOILOFF                                       
MFA-TR*            ,:S-BTU-SALLEY-BOILOFF                                       
MFA-TR*            ,:S-MCF-SALLEY-VAPOR                                         
MFA-TR*            ,:S-BTU-SALLEY-VAPOR                                         
MFA-TR*            ,:S-MCF-TOTAL                                                
MFA-TR*            ,:S-MMBTU-TOTAL                                              
MFA-TR*            ,:S-BTU-SNG                                                  
MFA-TR*            ,:S-LAST-UPDATE-TS                                           
MFA-TR*            ,:S-LAST-UPDATE-USERID                                       
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE.              
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS                   
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8100'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR03106_R1'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
        8100-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 8200-SEND-RESULT.                                              *        
      ******************************************************************        
      *                                                                         
       8200-SEND-RESULT.                                                
      *                                                                         
            EXEC SQL                                                    
               INSERT INTO #CSR03106_R2                          
                  (                                                     
                    RETURN_CODE                                         
                   ,COMPANY_NO                                          
                   ,INDUST_BTU_ID                                       
                   ,BTU_DT                                              
                   ,BTU_FACTOR                                          
                   ,SPECIFIC_GRAVITY                                    
                  )                                                     
               VALUES                                                   
                  (                                                     
                    :S-RETURN-CODE1                                     
                   ,:S-COMPANY-NO1                                      
                   ,:S-INDUST-BTU-ID                                    
                   ,:S-BTU-DT1                                          
                   ,:S-BTU-FACTOR                                       
                   ,:S-SPECIFIC-GRAVITY                                 
                  )                                                     
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*        INSERT INTO SESSION.CSR03106_R2                                  
MFA-TR*           (                                                             
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,COMPANY_NO                                                  
MFA-TR*            ,INDUST_BTU_ID                                               
MFA-TR*            ,BTU_DT                                                      
MFA-TR*            ,BTU_FACTOR                                                  
MFA-TR*            ,SPECIFIC_GRAVITY                                            
MFA-TR*           )                                                             
MFA-TR*        VALUES                                                           
MFA-TR*           (                                                             
MFA-TR*             :S-RETURN-CODE1                                             
MFA-TR*            ,:S-COMPANY-NO1                                              
MFA-TR*            ,:S-INDUST-BTU-ID                                            
MFA-TR*            ,:S-BTU-DT1                                                  
MFA-TR*            ,:S-BTU-FACTOR                                               
MFA-TR*            ,:S-SPECIFIC-GRAVITY                                         
MFA-TR*           )                                                             
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE1.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              ADD +1                     TO  CTR-ROWS1                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO  ABEND-PROGRAM              
              MOVE '8200'                TO  ACTIVE-PARAGRAPH           
              MOVE SQLCODE               TO  ABEND-SQLCODE              
              MOVE 'INSERT'              TO  ABEND-FUNCTION             
              MOVE SPACES                TO  ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSR03106_R2'         TO  TABLE-1                    
              MOVE SPACES                TO  TABLE-ELEMENT-1            
              MOVE SPACES                TO  HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                         
        8200-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *   8900-SEND-DONE                                               *        
      ******************************************************************        
      *                                                                         
       8900-SEND-DONE.                                                  
      *                                                                         
           EXEC SQL                                                     
               OPEN C1                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C1 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF
      *                                                                         
           EXEC SQL                                                     
               OPEN C2                                                  
           END-EXEC.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     IF SQLCODE = 0 
MSQ034       EXEC SQL 
MSQ034           CLOSE C2 WITH RETURN TO CALLER
MSQ034       END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ034     END-IF.
                                                    
      *                                                                         
       8900-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9000-SEND-ERROR-RESULT                                         *        
      ******************************************************************        
       9000-SEND-ERROR-RESULT.                                          
      *                                                                         
           MOVE 'N'                   TO SEND-DONE-SW.                  
                                                                        
           INITIALIZE GTT-RETURN-FIELDS-R1.                             
           INITIALIZE GTT-RETURN-FIELDS-R2.                             
           MOVE WS-ACTIVE-RETURN-CODE TO S-RETURN-CODE                  
                                         S-RETURN-CODE1                 
                                         ABEND-SQLCODE.                 
                                                                        
           MOVE SQLERRMC              TO ABEND-SQLERRMC.                
      *                                                                         
           EXEC SQL                                                     
               ROLLBACK                                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           IF SQLCODE = 0                                               
              CONTINUE                                                  
           ELSE                                                         
              MOVE 'ROLLBACK'         TO ABEND-FUNCTION                 
           END-IF.                                                      
      *                                                                         
           PERFORM 0100A-DECLARE-GTT  THRU 0100A-EXIT.                  
           PERFORM 8100-SEND-RESULT   THRU 8100-EXIT.                   
           PERFORM 0100B-DECLARE-GTT  THRU 0100B-EXIT.                  
           PERFORM 8200-SEND-RESULT   THRU 8200-EXIT.                   
      *                                                                         
       9000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *   9999-END-PROGRAM                                             *        
      ******************************************************************        
      *                                                                         
       9999-END-PROGRAM.                                                
                                                                        
           IF CTR-ROWS < 1                                              
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
MAN010* Opening result sets twice, duplicates returned result sets
MAN010*    ELSE                                                         
MAN010*       PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
                                                                        
           IF CTR-ROWS1 < 1                                             
      ******************************************************************        
      *         PROGRAMMER LOGIC ERROR - SHOULD ALWAYS SEND A ROW!     *        
      ******************************************************************        
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '9999-END-PROGRAM'   TO ABEND-FUNCTION               
              MOVE 'PROGRAMMER LOGIC'   TO TABLE-1                      
              MOVE 'FAILED TO SEND'     TO TABLE-ELEMENT-1              
              MOVE 'RESULT SET'         TO HOSTVAR-ELEMENT-1            
              MOVE -1                   TO WS-ACTIVE-RETURN-CODE        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
MAN010* Opening result sets twice, duplicates returned result sets
MAN010*    ELSE                                                         
MAN010*       PERFORM 8900-SEND-DONE    THRU 8900-EXIT                  
           END-IF.                                                      
                                                                        
MAN010     PERFORM 8900-SEND-DONE    THRU 8900-EXIT.
           
MSQ016        GOBACK.                                                    
                                                                        
       9999-EXIT.                                                       
           EXIT.                                                        
     *                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *                                                                         
      ******************************************************************        
      * INCLUDE CPD0023C FOR 9700- ERROR HANDLING                      *        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
