       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02562.                                         
COB303 DATE-WRITTEN.  AUG 1, 2003.                                      
                                                                        
       DATE-COMPILED.                                                   
                                                                        
      *---------------------------------------------------------------- 00070000
      *--                  SOUTH CAROLINA ELECTRIC & GAS             -- 00070000
      *---------------------------------------------------------------- 00070000
      *--                   STORED PROCEDURE:  S562                  -- 00070000
      *---------------------------------------------------------------- 00070000
      *--                         S U M M A R Y                      -- 00070000
      *--                                                            -- 00070000
      *--  S562 :                                                    -- 00080000
      *--                                                            -- 00090000
      *--  RETRIEVES DATA FROM CSS_IVR_NOTICES FOR THE PSNC 2ND      -- 00100000
      *--    MAILING PROCESS ON THE IVR PHONE SYSTEM.                -- 00110000
      *--                                                            -- 00120000
      *---------------------------------------------------------------- 00130000
      *---------------------------------------------------------------- 00130000
      *--                                                            -- 00180000
      *--  PARAMETERS                                                -- 00190000
      *--                                                            -- 00200000
      *--  INPUT    -  8 PARAMETERS                                  -- 00210000
      *--                                                            -- 00210000
      *--         I_ACCT_NO        CHAR(13)                          -- 00210000
      *--         I_CUST_NO        CHAR(10)                          -- 00210000
      *--         I_ORIG_CALL_DT   CHAR(10)                          -- 00210000
      *--         I_CREATED_TS     CHAR(26)                          -- 00210000
      *--         I_CALL_CNTR      CHAR(05)                          -- 00210000
      *--         I_CALL_STATUS    CHAR(01)                          -- 00210000
      *--         I_IVR_SCRIPT_CD  CHAR(02)                          -- 00210000
      *--         I_CUST_PHONE_NO  CHAR(10)                          -- 00210000
      *--                                                            -- 00210000
      *--  OUTPUT   - NO PARAMETERS                                  -- 00210000
      *--  IN/OUT   - NO PARAMETERS                                  -- 00210000
      *--                                                            -- 00210000
      *--                                                            -- 00210000
      *--  RESULT SET = 1                                            -- 00210000
      *--                                                            -- 00210000
      *--         RETURN_CODE      INTEGER                           -- 00350000
      *--                                                            -- 00360000
      *--                                                            -- 00390000
      *---------------------------------------------------------------- 00400000
      *--                        MODIFICATION LOG                    -- 00410000
      *--                                                            -- 00420000
      *--  DATE          INITIALS    COMMENTS                        -- 00430000
      *--  -----------   --------    ---------------------------------- 00440000
      *--  07/01/2003    DP19151     NEW SP FOR IVR PSNC 2ND NOTICES -- 00450000
T29746*--  10/06/2003    DP19151     CML 29746 - CALL STATUS G ADDED -- 00450000
T28788*--  10/23/2003    DP19151     FIX FOR -181 WHEN THE ACCT IS   -- 00450000
T28788*--                            EQUAL TO 0-0000-0000-0000.      -- 00450000
T28788*--                            THERE ARE MORE NOTES BELOW.     -- 00450000
T31874*--  03/25/2005     GOKUL      CONVERTED THE DB2 SP TO RPC     -- 00460000
T31874*--                            DUE TO PERFORMANCE ISSUES IN IVR-- 00460000
C32545*--  09/28/2005    DP19151     COVNERTED THE IVR STATUS CD     -- 00460000
C32545*--                            EVALUATE TO A SQL DB2 CALL      -- 00460000
      *--                                                            -- 00460000
REARCH*--  05/23/2006    CVNS        RPC CONVERTED TO COBOL SP       --         
REARCH*--                CHENNAI                                     --         
A04527*--  06/12/2013    MC95456     REMOVED UNUSED COPY BOOK CWS00056-         
A04776*--  08/29/2013    AS7C117     REMOVED UNUSED COPYBOOKS CWS00068-         
A04776*--                            AND CWS0068L                     -         
A04776*--                            REMOVED UNUSED DCLGENS           -         
      *---------------------------------------------------------------- 00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02562'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************00580000
      *    DB2 INCLUDES                                                *00590000
      ******************************************************************00600000
      *                                                                 00610000
           EXEC SQL                                                     00620000
              INCLUDE SQLCA                                             00630000
           END-EXEC.                                                    00640000
                                                                        
C32545*----< CSS_MODEL_SQL - MS >                                               
           EXEC SQL                                                     00700000
              INCLUDE TBMODEL                                           00710000
           END-EXEC.                                                    00720000
                                                                        
C32545*----< CSS_ACCOUNT - AT >                                                 
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
C32545*----< CSS_IVR_NOTICE - IY >                                              
           EXEC SQL                                                             
              INCLUDE TBIVRNOT                                                  
           END-EXEC.                                                            
                                                                        
C32545*----< CSS_IVR_CODES - I9 >                                               
C32545     EXEC SQL                                                             
C32545        INCLUDE TBIVRCDS                                                  
C32545     END-EXEC.                                                            
                                                                        
C32545*----< CSS_COMM_DATA - KO >                                               
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
      *                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               00840000
      *                                                                 00850000
      *                                                                         
                                                                        
      *---------------------------------------------------------------          
      *--  RETURN FIELDS                                            --          
      *---------------------------------------------------------------          
      *                                                                         
                                                                        
      ******************************************************************00860000
      *    WORK AREAS                                                  *00870000
      ******************************************************************00880000
      *                                                                         
      *                                                                         
       01  FILLER           PIC X(11) VALUE 'PARM FIELDS'.              
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(9) COMP.                
           05  WRKLEN1                   PIC S9(9) COMP.                
           05  WRKLEN2                   PIC S9(9) COMP.                
           05  WRK-DONE-STATUS           PIC S9(9) COMP.                
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                     VALUE 'SESSION.CSR02562_R1'. 
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(9) COMP VALUE 0.        
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MISC.                                                     
           05  WS-PGRMNAME               PIC X(8)  VALUE 'CSR02562'.    
           05  WS-DUMMY                  PIC X(10) VALUE SPACES.        
           05  PROGRAM-NAME              PIC X(08) VALUE 'CSR02562'.    
           05  WS-DATE-CREDIT-ACT-NI     PIC S9(4) COMP VALUE +0.       
           05  WS-DATE-NOTC-MAIL-NI      PIC S9(4) COMP VALUE +0.       
           05  WS-LAST-CALL-TS-NI        PIC S9(4) COMP VALUE +0.       
           05  WS-NOTICE-DUE-DT-NI       PIC S9(4) COMP VALUE +0.       
           05  WS-RED-FL-NULL-IND        PIC S9(4) COMP VALUE 0.        
           05  WS-END-NULL-IND           PIC S9(4) COMP VALUE 0.        
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
           05  WS-CURRENT-TIME           PIC X(08) VALUE SPACES.        
           05  WS-CURRENT-TIMESTMP       PIC X(26) VALUE SPACES.        
C32545     05  WS-IVR-STATUS-DESC.                                      
C32545         10 WS-IVR-STATUS-DESC-LEN   PIC S9(4) USAGE COMP.        
C32545         10 WS-IVR-STATUS-DESC-TEXT  PIC X(200).                  
           05  WS-INITIAL-COMMENT-TX.                                   
               10 WS-INITIAL-COMMENT-TX-LEN   PIC S9(4) USAGE COMP.     
               10 WS-INITIAL-COMMENT-TX-TEXT  PIC X(255).               
           05  WS-INIT-COMMENTS-LEN     PIC S9(4) USAGE COMP VALUE +56. 
           05  WS-INIT-COMMENTS-TEXT.                                   
               10 WS-INIT-COMM-TEXT-PHONE     PIC X(13) VALUE SPACES.   
               10 WS-INIT-COMM-TEXT-DASH      PIC X(03) VALUE ' - '.    
               10 WS-INIT-COMM-TEXT-INFO      PIC X(40) VALUE SPACES.   
           05  WS-NULL-IND1            PIC S9(4) COMP.                  
           05  WS-NULL-IND2            PIC S9(4) COMP.                  
           05  WS-NULL-1                    PIC S9(4)  COMP.            
           05  WS-NULL-2                    PIC S9(4)  COMP.            
           05  WS-DATABASE                  PIC 9(01) VALUE ZERO.       
               88  CSR-DATABASE             VALUE 1.                    
               88  SEB-DATABASE             VALUE 2.                    
           05  WS-EIBRESP                   PIC S9(8)                   
                                            COMP SYNC VALUE ZERO.       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-OUTGOING            PIC X(01) VALUE 'O'.              
           05  WS-PHONE               PIC X(01) VALUE 'P'.              
           05  WS-YES                 PIC X(01) VALUE 'Y'.              
           05  WS-NO                  PIC X(01) VALUE 'N'.              
A04776     05  WS-A                   PIC X(01) VALUE 'A'.              
A04776     05  WS-N                   PIC X(01) VALUE 'N'.              
           05  WS-ACTIVE-CODE         PIC X(01) VALUE 'A'.              
                                                                        
                                                                        
       01  WS-RETURN-FIELDS.                                            
           05  WS-RETURN-CODE       PIC S9(9)  COMP VALUE 0.            
           05  WS-CALL-COUNTER      PIC S9(9)  COMP VALUE 0.            
           05  WS-ORIG-CALL-DT      PIC X(10)  VALUE SPACES.            
           05  WS-CURRENT-DT        PIC X(10)  VALUE SPACES.            
           05  WS-CUST-PHONE        PIC X(10) VALUE SPACES.             
           05  WS-CUST-PHONE-BLANK  PIC X(13) VALUE '(000)000-0000'.    
           05  WS-CUST-PHONE-FRMT.                                      
               10 WS-CUST-PHONE-LP     PIC X(01) VALUE '('.             
               10 WS-CUST-PHONE-ZIP    PIC X(03) VALUE '000'.           
               10 WS-CUST-PHONE-RP     PIC X(01) VALUE ')'.             
               10 WS-CUST-PHONE-1ST    PIC X(03) VALUE '000'.           
               10 WS-CUST-PHONE-DASH   PIC X(01) VALUE '-'.             
               10 WS-CUST-PHONE-2ND    PIC X(04) VALUE '0000'.          
           05  WS-IVR-CALL-COUNTER-N.                                   
               10 WS-IVR-CALL-CNTR-1   PIC 9(01) VALUE 0.               
               10 WS-IVR-CALL-CNTR-2   PIC 9(01) VALUE 0.               
               10 WS-IVR-CALL-CNTR-3   PIC 9(01) VALUE 0.               
               10 WS-IVR-CALL-CNTR-4   PIC 9(01) VALUE 0.               
               10 WS-IVR-CALL-CNTR-5   PIC 9(01) VALUE 0.               
           05  WS-PARM-CALL-COUNTER.                                    
               10  WS-PARM-CALL-CNTR-1ST  PIC X(04) VALUE SPACES.       
               10  WS-PARM-CALL-CNTR-2ND  PIC X(01) VALUE SPACES.       
           05  WS-IVR-CALL-COUNTER-A.                                   
               10 WS-IVR-CALL-CNTR-1ST.                                 
                  15 WS-IVR-CALL-CNTR-A   PIC X(01) VALUE SPACES.       
               10 WS-IVR-CALL-CNTR-2ND.                                 
                  15 WS-IVR-CALL-CNTR-B   PIC X(01) VALUE SPACES.       
                  15 WS-IVR-CALL-CNTR-C   PIC X(01) VALUE SPACES.       
                  15 WS-IVR-CALL-CNTR-D   PIC X(01) VALUE SPACES.       
                  15 WS-IVR-CALL-CNTR-E   PIC X(01) VALUE SPACES.       
           05  WS-CURRENT-TIMESTAMP     PIC X(26) VALUE SPACES.         
           05  WS-IVR-TIMESTAMP         PIC X(26) VALUE SPACES.         
           05  WS-IVR-TS-FULL.                                          
               10 WS-IVR-TS-DATE        PIC X(10) VALUE SPACES.         
               10 WS-IVR-TS-FILLER-1    PIC X(1) VALUE SPACES.          
               10 WS-IVR-TS-HOUR        PIC X(2) VALUE SPACES.          
               10 WS-IVR-TS-FILLER-2    PIC X(1) VALUE SPACES.          
               10 WS-IVR-TS-MIN         PIC X(2) VALUE SPACES.          
               10 WS-IVR-TS-FILLER-2    PIC X(1) VALUE SPACES.          
               10 WS-IVR-TS-SEC-NANO    PIC X(9) VALUE SPACES.          
           05  WS-IVR-TIME.                                             
               10 WS-IVR-TIME-HOUR      PIC X(2) VALUE SPACES.          
               10 WS-IVR-TIME-MIN       PIC X(2) VALUE SPACES.          
                                                                        
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW           PIC X(01) VALUE 'N'.               
               88 NOT-ALL-DONE                 VALUE 'N'.               
               88 ALL-DONE                     VALUE 'Y'.               
           05  SEND-DONE-SW          PIC X(01) VALUE 'Y'.               
               88 SEND-DONE-ERROR              VALUE 'N'.               
               88 SEND-DONE-OK                 VALUE 'Y'.               
                                                                        
                                                                        
HPCCDM*EJECT                                                            01830000
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01    PARM-ACCT-NO              PIC X(13)   VALUE SPACES.        
REARCH 01    PARM-CUST-NO              PIC X(10)   VALUE SPACES.        
REARCH 01    PARM-ORIG-CALL-DT         PIC X(10)   VALUE SPACES.        
REARCH 01    PARM-CREATED-TS           PIC X(26)   VALUE SPACES.        
REARCH 01    PARM-CALL-CNTR            PIC X(05)   VALUE SPACES.        
REARCH 01    PARM-CALL-STATUS          PIC X(01)   VALUE SPACES.        
REARCH 01    PARM-IVR-SCRIPT-CD        PIC X(02)   VALUE SPACES.        
REARCH 01    PARM-CUST-PHONE-NO        PIC X(10)   VALUE SPACES.        
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING                                         
REARCH                           PARM-ACCT-NO                           
REARCH                          ,PARM-CUST-NO                           
REARCH                          ,PARM-ORIG-CALL-DT                      
REARCH                          ,PARM-CREATED-TS                        
REARCH                          ,PARM-CALL-CNTR                         
REARCH                          ,PARM-CALL-STATUS                       
REARCH                          ,PARM-IVR-SCRIPT-CD                     
REARCH                          ,PARM-CUST-PHONE-NO.                    
REARCH*                                                                         
      ******************************************************************01860000
      * 0000-MAINLINE                                                  *01870000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *01880000
      ******************************************************************01890000
       0000-MAINLINE.                                                   
      *                                                                 01920000
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                 01970000
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 02000000
      ******************************************************************02010000
      * 0100-INITIALIZE                                                *02020000
      ******************************************************************02090000
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               :S-RETURN-CODE         AS RETURN_CODE              
REARCH          FROM                                                    
REARCH               CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02670000
      * 1000-PROCESS-INPUT                                             *02680000
      ******************************************************************02700000
       1000-PROCESS-INPUT.                                              
      *                                                                 02720000
           PERFORM 7000-SELECT-TIMESTAMP-DATE                           
                                            THRU 7000-EXIT.             
      *                                                                         
           MOVE PARM-ACCT-NO                TO IY-ACCOUNT-NO.           
           MOVE PARM-ORIG-CALL-DT           TO IY-ORIGINAL-CALL-DT.     
           MOVE PARM-CREATED-TS             TO IY-CREATED-TS.           
                                                                        
T28788**  THIS IS A TEMP FIX TO KEEP THIS STORED PROCEDURE FROM                 
T28788*      INSERTING ROWS INTO CSS_ERROR_LOG WHEN THE BLANK                   
T28788*      DATASET ROW IS SENT TO THE IVR APP BY RETRIEVE                     
T28788*      SP CSR03343 WHEN THERE IS NOONE TO CALL.                           
T28788                                                                  
T28788     IF PARM-ACCT-NO = '0000000000000' AND                        
T28788        PARM-ORIG-CALL-DT = '1901-01-01'                          
T28788         ADD +1                        TO CTR-ROWS                
T28788         PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
T28788     END-IF.                                                      
      *                                                                 02320000
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02670000
      * 2000-PROCESS-OUTPUT                                            *02680000
      ******************************************************************02700000
       2000-PROCESS-OUTPUT.                                             
      *                                                                 02720000
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           PERFORM 7100-SELECT-IVR-NOTICE   THRU 7100-EXIT              
      *                                                                         
           MOVE PARM-ACCT-NO                TO AT-ACCOUNT-NO.           
           PERFORM 7050-SELECT-CSS-ACCOUNT  THRU 7050-EXIT.             
      *                                                                         
           PERFORM 2300-UPDATE-IVR-VALUES   THRU 2300-EXIT.             
      *                                                                         
           PERFORM 2400-PROCESS-COMM-DATA   THRU 2400-EXIT.             
      *                                                                         
      *                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT.            
      *                                                                         
           ADD +1                           TO CTR-ROWS.                
      *                                                                 02760000
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH***************************************************************           
REARCH*  2000A-MOVE-RESULT.                                         *           
REARCH***************************************************************           
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                 03410000
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************04220000
      *  2300-UPDATE-IVR-VALUES                                        *04230000
      ******************************************************************04240000
       2300-UPDATE-IVR-VALUES.                                          
      *                                                                         
           MOVE '2300' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           MOVE PARM-CALL-CNTR         TO WS-IVR-CALL-COUNTER-A.        
           MOVE PARM-CALL-CNTR         TO WS-PARM-CALL-COUNTER.         
      *                                                                         
           IF WS-IVR-CALL-CNTR-E NOT EQUAL '0'                          
               MOVE '0'                    TO WS-IVR-CALL-CNTR-1ST      
               MOVE WS-PARM-CALL-CNTR-1ST  TO WS-IVR-CALL-CNTR-2ND      
           ELSE                                                         
               MOVE PARM-CALL-CNTR         TO WS-IVR-CALL-COUNTER-A     
           END-IF.                                                      
      *                                                                         
           MOVE PARM-CALL-STATUS       TO IY-CALL-STATUS-CD.            
           MOVE PARM-IVR-SCRIPT-CD     TO IY-IVR-SCRIPT-LOC-CD.         
           MOVE WS-IVR-CALL-COUNTER-A  TO IY-CALL-COUNTER.              
      *                                                                         
           MOVE PARM-CUST-PHONE-NO(1:3)   TO WS-CUST-PHONE-ZIP.         
           MOVE PARM-CUST-PHONE-NO(4:3)   TO WS-CUST-PHONE-1ST.         
           MOVE PARM-CUST-PHONE-NO(7:4)   TO WS-CUST-PHONE-2ND.         
      *                                                                         
           PERFORM 7200-UPDATE-IVR-CALL-STATUS  THRU 7200-EXIT.         
      *                                                                         
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04480000
      * 2400-PROCESS-COMM-DATA                                         *04490000
      ******************************************************************        
       2400-PROCESS-COMM-DATA.                                          
      *                                                                         
           PERFORM 2450-SETUP-INITIAL-COMMENTS    THRU 2450-EXIT.       
      *                                                                         
           MOVE IY-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE IY-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE AT-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE AT-COMPANY-NO          TO KO-COMPANY-NO.                
           MOVE WS-N                   TO KO-RED-FLAG-IND.              
           MOVE SPACES                 TO KO-RED-FLAG-EXPIRE-DT.        
           MOVE -1                     TO WS-RED-FL-NULL-IND.           
           MOVE WS-PHONE               TO KO-COMM-METHOD.               
           MOVE WS-OUTGOING            TO KO-COMM-DIRECTION.            
           MOVE '40'                   TO KO-COMM-TYPE-CD.              
           MOVE '11'                   TO KO-COMM-SUBTYPE-CODE.         
           MOVE 'SYSTEM'               TO KO-USER-ID-ORIG.              
           MOVE SPACES                 TO KO-CONTACT-NAME.              
           MOVE SPACES                 TO KO-PROMOTION-ID.              
           MOVE WS-N                   TO KO-PSC-COMPLIANCE-IND.        
           MOVE 0                      TO KO-CALL-ORIGIN-ID.            
           MOVE SPACES                 TO KO-CALL-END-TIME.             
           MOVE -1                     TO WS-END-NULL-IND.              
           MOVE 0                      TO KO-NUMBER-TRANSFERS.          
           MOVE 0                      TO KO-HOLD-TIME.                 
           MOVE 0                      TO KO-QUEUE-TIME.                
           MOVE WS-N                   TO KO-SCREEN-POP-IND.            
           MOVE 0                      TO KO-TOTAL-CALL-TIME.           
           MOVE WS-INITIAL-COMMENT-TX  TO KO-INITIAL-COMMENT-TX.        
           MOVE SPACES                 TO KO-RESPONSE-REASON-CD.        
           MOVE SPACES                 TO KO-RESPONSE-TYPE-CD.          
           MOVE SPACES                 TO KO-SOLICITATION-CD.           
           MOVE WS-A                   TO KO-COMM-ASSOC-CD.             
           MOVE WS-N                   TO KO-COMPLAINT-FL.              
           MOVE SPACES                 TO KO-DISCOVERY-MTHD-CD.         
           MOVE SPACES                 TO KO-PREV-MARKETER-CD.          
      *                                                                         
           PERFORM 8700-INSERT-COMM-DATA         THRU 8700-EXIT.        
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 2450-SETUP-INITIAL-COMMENTS                                  *          
      ****************************************************************          
       2450-SETUP-INITIAL-COMMENTS.                                     
      *                                                                         
C32545     MOVE SPACES                      TO WS-INIT-COMM-TEXT-INFO.  
C32545     MOVE SPACES                      TO I9-IVR-CODE-DESC.        
C32545     MOVE IY-COMPANY-NO               TO I9-COMPANY-NO            
C32545     MOVE PARM-CALL-STATUS            TO I9-IVR-CD                
C32545     MOVE 'IVR-STATUS-CODE'           TO I9-IVR-VALUE-TX          
                                                                        
C32545     PERFORM 7650-SELECT-IVR-STAT-DESC  THRU 7650-EXIT.           
                                                                        
C32545     MOVE I9-IVR-CODE-DESC            TO WS-IVR-STATUS-DESC.      
C32545     MOVE WS-IVR-STATUS-DESC-TEXT     TO WS-INIT-COMM-TEXT-INFO.  
           MOVE WS-CUST-PHONE-FRMT     TO WS-INIT-COMM-TEXT-PHONE.      
           MOVE WS-INIT-COMMENTS-LEN   TO WS-INITIAL-COMMENT-TX-LEN.    
           MOVE WS-INIT-COMMENTS-TEXT  TO WS-INITIAL-COMMENT-TX-TEXT.   
      *                                                                         
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ****************************************************************          
      * 7000-SELECT-TIMESTAMP-DATE                                   *          
      ****************************************************************          
       7000-SELECT-TIMESTAMP-DATE.                                      
      *                                                                         
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(CONVERT(CHAR(8), CIS.CURRENT$TIME(), 108), ':', 
           '.')
            INTO
              :WS-CURRENT-TIMESTMP,
              :WS-CURRENT-DATE,
              :WS-CURRENT-TIME                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TIMESTMP = CURRENT TIMESTAMP,                     
MFA-TR*           :WS-CURRENT-DATE     = CURRENT DATE,                          
MFA-TR*           :WS-CURRENT-TIME     = CURRENT TIME                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            RS-RETURN-CODE.             
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
      *       MOVE 'SELECT'              TO ABEND-FUNCTION                      
      *       MOVE 'CSS_MODEL_SQL'       TO TABLE-1                             
      *       MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1                     
      *       MOVE PARM-ACCT-NO          TO HOSTVAR-ELEMENT-1                   
              PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
              PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
           END-IF.                                                      
      *                                                                         
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7050-SELECT-CSS-ACCOUNT                                       *         
      *     SELECTS CSS_ACCOUNT                                       *         
      *****************************************************************         
       7050-SELECT-CSS-ACCOUNT.                                         
      *                                                                         
           MOVE '7050'               TO ACTIVE-PARAGRAPH.               
      *                                                                         
           EXEC SQL                                                     
              SELECT AT.COMPANY_NO                                      
                    ,AT.CUSTOMER_NO                                     
                    ,AT.PREMISE_NO                                      
                INTO :AT-COMPANY-NO                                     
                    ,:AT-CUSTOMER-NO                                    
                    ,:AT-PREMISE-NO                                     
                FROM CSS_ACCOUNT AT                                     
               WHERE AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
                                       RS-RETURN-CODE.                  
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE SQLCODE               TO ABEND-SQLCODE              
               MOVE '7050'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                         
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 05330000
      * 7100-SELECT-IVR-NOTICE                                        * 05620000
      *      UPDATES THE IVR SND NOTICE CALL STATUS                   *         
      *****************************************************************         
       7100-SELECT-IVR-NOTICE.                                          
      *                                                                         
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
                    ,ORIGINAL_CALL_DT                                   
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS
           , 121), ' ', '-'), ':', '.') CREATED_TS                             
                    ,CALL_COUNTER                                       
                    ,CALL_STATUS_CD                                     
                    ,CODE_SPECIAL_TYPE                                  
                    ,CURR_PAST_DUE_BAL                                  
                    ,CUSTOMER_NO                                        
                    ,DATE_CREDIT_ACTION                                 
                    ,DATE_NOTICE_MAIL                                   
                    ,IVR_SCRIPT_LOC_CD                                  
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_CALL_TS
           , 121), ' ', '-'), ':', '.') LAST_CALL_TS                           
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,NOTICE_DUE_DT                                      
                    ,ORIG_PAST_DUE_BAL                                  
C32545              ,COMPANY_NO                                         
               INTO  :IY-ACCOUNT-NO                                     
                    ,:IY-ORIGINAL-CALL-DT                               
                    ,:IY-CREATED-TS                                     
                    ,:IY-CALL-COUNTER                                   
                    ,:IY-CALL-STATUS-CD                                 
                    ,:IY-CODE-SPECIAL-TYPE                              
                    ,:IY-CURR-PAST-DUE-BAL                              
                    ,:IY-CUSTOMER-NO                                    
                    ,:IY-DATE-CREDIT-ACTION :WS-DATE-CREDIT-ACT-NI       
                    ,:IY-DATE-NOTICE-MAIL :WS-DATE-NOTC-MAIL-NI          
                    ,:IY-IVR-SCRIPT-LOC-CD                              
                    ,:IY-LAST-CALL-TS :WS-LAST-CALL-TS-NI                
                    ,:IY-LAST-UPDATE-TS                                 
                    ,:IY-NOTICE-DUE-DT :WS-NOTICE-DUE-DT-NI              
                    ,:IY-ORIG-PAST-DUE-BAL                              
C32545              ,:IY-COMPANY-NO                                     
              FROM CSS_IVR_NOTICE                                       
              WHERE ACCOUNT_NO       = :IY-ACCOUNT-NO                   
                AND ORIGINAL_CALL_DT = IIF(TRY_CONVERT(DATE, 
                                                   :IY-ORIGINAL-CALL-DT
              ) IS NULL OR (PATINDEX('%.%', :IY-ORIGINAL-CALL-DT
              ) <> 0) OR (LEN(:IY-ORIGINAL-CALL-DT
              ) <> 10), CIS.CHAR2DATE(:IY-ORIGINAL-CALL-DT
              ), CONVERT(DATE, :IY-ORIGINAL-CALL-DT) )             
                AND CREATED_TS       = CIS.CHAR2TIMESTAMP(:IY-CREATED-TS
              )                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*             ,ORIGINAL_CALL_DT                                           
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,CALL_COUNTER                                               
MFA-TR*             ,CALL_STATUS_CD                                             
MFA-TR*             ,CODE_SPECIAL_TYPE                                          
MFA-TR*             ,CURR_PAST_DUE_BAL                                          
MFA-TR*             ,CUSTOMER_NO                                                
MFA-TR*             ,DATE_CREDIT_ACTION                                         
MFA-TR*             ,DATE_NOTICE_MAIL                                           
MFA-TR*             ,IVR_SCRIPT_LOC_CD                                          
MFA-TR*             ,LAST_CALL_TS                                               
MFA-TR*             ,LAST_UPDATE_TS                                             
MFA-TR*             ,NOTICE_DUE_DT                                              
MFA-TR*             ,ORIG_PAST_DUE_BAL                                          
MFA-TR*             ,COMPANY_NO                                                 
MFA-TR*        INTO  :IY-ACCOUNT-NO                                             
MFA-TR*             ,:IY-ORIGINAL-CALL-DT                                       
MFA-TR*             ,:IY-CREATED-TS                                             
MFA-TR*             ,:IY-CALL-COUNTER                                           
MFA-TR*             ,:IY-CALL-STATUS-CD                                         
MFA-TR*             ,:IY-CODE-SPECIAL-TYPE                                      
MFA-TR*             ,:IY-CURR-PAST-DUE-BAL                                      
MFA-TR*             ,:IY-CUSTOMER-NO                                            
MFA-TR*             ,:IY-DATE-CREDIT-ACTION:WS-DATE-CREDIT-ACT-NI               
MFA-TR*             ,:IY-DATE-NOTICE-MAIL:WS-DATE-NOTC-MAIL-NI                  
MFA-TR*             ,:IY-IVR-SCRIPT-LOC-CD                                      
MFA-TR*             ,:IY-LAST-CALL-TS:WS-LAST-CALL-TS-NI                        
MFA-TR*             ,:IY-LAST-UPDATE-TS                                         
MFA-TR*             ,:IY-NOTICE-DUE-DT:WS-NOTICE-DUE-DT-NI                      
MFA-TR*             ,:IY-ORIG-PAST-DUE-BAL                                      
MFA-TR*             ,:IY-COMPANY-NO                                             
MFA-TR*       FROM CSS_IVR_NOTICE                                               
MFA-TR*       WHERE ACCOUNT_NO       = :IY-ACCOUNT-NO                           
MFA-TR*         AND ORIGINAL_CALL_DT = :IY-ORIGINAL-CALL-DT                     
MFA-TR*         AND CREATED_TS       = :IY-CREATED-TS                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE ACTIVE-PARAGRAPH      TO ABEND-FUNCTION              
              MOVE 'CSS_IVR_NOTICE'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ORIGINAL_CALL_DT'    TO TABLE-ELEMENT-2             
              MOVE 'CREATED_TS'          TO TABLE-ELEMENT-3             
              MOVE IY-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE IY-ORIGINAL-CALL-DT   TO HOSTVAR-ELEMENT-2           
              MOVE IY-CREATED-TS         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 05290000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ***************************************************************** 05330000
      * 7200-UPDATE-IVR-CALL-STATUS                                   * 05620000
      *      UPDATES THE IVR SND NOTICE CALL STATUS                   *         
      *****************************************************************         
       7200-UPDATE-IVR-CALL-STATUS.                                     
      *                                                                         
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
      *                                                                         
           EXEC SQL                                                     
              UPDATE CSS_IVR_NOTICE                                     
              SET    CALL_STATUS_CD    = :IY-CALL-STATUS-CD             
                    ,IVR_SCRIPT_LOC_CD = :IY-IVR-SCRIPT-LOC-CD          
                    ,CALL_COUNTER      = :IY-CALL-COUNTER               
                    ,LAST_CALL_TS      = CIS.CHAR2TIMESTAMP(
                                                   :WS-CURRENT-TIMESTMP
              )           
                    ,LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                   :WS-CURRENT-TIMESTMP
              )           
              WHERE  ACCOUNT_NO       = :IY-ACCOUNT-NO                  
                AND  ORIGINAL_CALL_DT = IIF(TRY_CONVERT(DATE, 
                                                   :IY-ORIGINAL-CALL-DT
              ) IS NULL OR (PATINDEX('%.%', :IY-ORIGINAL-CALL-DT
              ) <> 0) OR (LEN(:IY-ORIGINAL-CALL-DT
              ) <> 10), CIS.CHAR2DATE(:IY-ORIGINAL-CALL-DT
              ), CONVERT(DATE, :IY-ORIGINAL-CALL-DT) )            
                AND  CREATED_TS       = CIS.CHAR2TIMESTAMP(
                                                         :IY-CREATED-TS
              )                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_IVR_NOTICE                                             
MFA-TR*       SET    CALL_STATUS_CD    = :IY-CALL-STATUS-CD                     
MFA-TR*             ,IVR_SCRIPT_LOC_CD = :IY-IVR-SCRIPT-LOC-CD                  
MFA-TR*             ,CALL_COUNTER      = :IY-CALL-COUNTER                       
MFA-TR*             ,LAST_CALL_TS      = :WS-CURRENT-TIMESTMP                   
MFA-TR*             ,LAST_UPDATE_TS    = :WS-CURRENT-TIMESTMP                   
MFA-TR*       WHERE  ACCOUNT_NO       = :IY-ACCOUNT-NO                          
MFA-TR*         AND  ORIGINAL_CALL_DT = :IY-ORIGINAL-CALL-DT                    
MFA-TR*         AND  CREATED_TS       = :IY-CREATED-TS                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE ACTIVE-PARAGRAPH      TO ABEND-FUNCTION              
              MOVE 'CSS_IVR_NOTICE'      TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'ORIGINAL_CALL_DT'    TO TABLE-ELEMENT-2             
              MOVE 'CREATED_TS'          TO TABLE-ELEMENT-3             
              MOVE IY-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE IY-ORIGINAL-CALL-DT   TO HOSTVAR-ELEMENT-2           
              MOVE IY-CREATED-TS         TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                 05290000
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
C32545*****************************************************************         
C32545* 7650-SELECT-IVR-STAT-DESC                                     *         
C32545*****************************************************************         
C32545 7650-SELECT-IVR-STAT-DESC.                                       
C32545                                                                  
C32545     MOVE '7650' TO ACTIVE-PARAGRAPH.                             
C32545                                                                  
C32545     EXEC SQL                                                     
C32545          SELECT I9.IVR_CODE_DESC                                 
C32545          INTO  :I9-IVR-CODE-DESC                                 
C32545          FROM CSS_IVR_CODES I9 WITH(READUNCOMMITTED)                     
C32545          WHERE I9.COMPANY_NO    = :I9-COMPANY-NO                 
C32545            AND I9.IVR_CD        = :I9-IVR-CD                     
C32545            AND I9.IVR_VALUE_TX  = :I9-IVR-VALUE-TX               
C32545                                                           
C32545     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT I9.IVR_CODE_DESC                                         
MFA-TR*         INTO  :I9-IVR-CODE-DESC                                         
MFA-TR*         FROM CSS_IVR_CODES I9                                           
MFA-TR*         WHERE I9.COMPANY_NO    = :I9-COMPANY-NO                         
MFA-TR*           AND I9.IVR_CD        = :I9-IVR-CD                             
MFA-TR*           AND I9.IVR_VALUE_TX  = :I9-IVR-VALUE-TX                       
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C32545                                                                  
C32545     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
C32545                     WS-RETURN-CODE.                              
C32545                                                                  
C32545                                                                  
C32545*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
C32545     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C32545        NEXT SENTENCE                                             
C32545     ELSE                                                         
C32545        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
C32545        MOVE SQLCODE                TO ABEND-SQLCODE              
C32545        MOVE 'SELECT'               TO ABEND-FUNCTION             
C32545        MOVE 'CSS_IVR_CODES'        TO TABLE-1                    
C32545        MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-1            
C32545        MOVE I9-COMPANY-NO          TO HOSTVAR-ELEMENT-1          
C32545        MOVE 'IVR_CD'               TO TABLE-ELEMENT-2            
C32545        MOVE I9-IVR-CD              TO HOSTVAR-ELEMENT-2          
C32545        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C32545        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C32545     END-IF.                                                      
C32545                                                                  
C32545 7650-EXIT.                                                       
C32545     EXIT.                                                        
                                                                        
      ****************************************************************          
      *   8700-INSERT-COMM-DATA                                      *          
      ****************************************************************          
       8700-INSERT-COMM-DATA.                                           
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_COMM_DATA                               
                        (COMMUNICATION_ID,                              
                         ACCOUNT_NO,                                    
                         CUSTOMER_NO,                                   
                         PREMISE_NO,                                    
                         COMPANY_NO,                                    
                         RED_FLAG_IND,                                  
                         RED_FLAG_EXPIRE_DT,                            
                         COMM_METHOD,                                   
                         COMM_DIRECTION,                                
                         COMM_TYPE_CD,                                  
                         COMM_SUBTYPE_CODE,                             
                         USER_ID_ORIG,                                  
                         CONTACT_NAME,                                  
                         PROMOTION_ID,                                  
                         PSC_COMPLIANCE_IND,                            
                         CALL_ORIGIN_ID,                                
                         CALL_END_TIME,                                 
                         NUMBER_TRANSFERS,                              
                         HOLD_TIME,                                     
                         QUEUE_TIME,                                    
                         SCREEN_POP_IND,                                
                         TOTAL_CALL_TIME,                               
                         INITIAL_COMMENT_TX,                            
                         RESPONSE_REASON_CD,                            
                         RESPONSE_TYPE_CD,                              
                         SOLICITATION_CD,                               
                         COMM_ASSOC_CD,                                 
                         COMPLAINT_FL,                                  
                         DISCOVERY_MTHD_CD,                             
                         PREV_MARKETER_CD)                              
                VALUES   (CIS.CURRENT$TIMESTAMP(),                            
                         :KO-ACCOUNT-NO,                                
                         :KO-CUSTOMER-NO,                               
                         :KO-PREMISE-NO,                                
                         :KO-COMPANY-NO,                                
                         :KO-RED-FLAG-IND,                              
                         CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                            :WS-RED-FL-NULL-IND),     
                         :KO-COMM-METHOD,                               
                         :KO-COMM-DIRECTION,                            
                         :KO-COMM-TYPE-CD,                              
                         :KO-COMM-SUBTYPE-CODE,                         
                         :KO-USER-ID-ORIG,                              
                         :KO-CONTACT-NAME,                              
                         :KO-PROMOTION-ID,                              
                         :KO-PSC-COMPLIANCE-IND,                        
                         :KO-CALL-ORIGIN-ID,                            
                         CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                            :WS-END-NULL-IND),             
                         :KO-NUMBER-TRANSFERS,                          
                         :KO-HOLD-TIME,                                 
                         :KO-QUEUE-TIME,                                
                         :KO-SCREEN-POP-IND,                            
                         :KO-TOTAL-CALL-TIME,                           
                         :KO-INITIAL-COMMENT-TX,                        
                         :KO-RESPONSE-REASON-CD,                        
                         :KO-RESPONSE-TYPE-CD,                          
                         :KO-SOLICITATION-CD,                           
                         :KO-COMM-ASSOC-CD,                             
                         :KO-COMPLAINT-FL,                              
                         :KO-DISCOVERY-MTHD-CD,                         
                         :KO-PREV-MARKETER-CD)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_COMM_DATA                                       
MFA-TR*                 (COMMUNICATION_ID,                                      
MFA-TR*                  ACCOUNT_NO,                                            
MFA-TR*                  CUSTOMER_NO,                                           
MFA-TR*                  PREMISE_NO,                                            
MFA-TR*                  COMPANY_NO,                                            
MFA-TR*                  RED_FLAG_IND,                                          
MFA-TR*                  RED_FLAG_EXPIRE_DT,                                    
MFA-TR*                  COMM_METHOD,                                           
MFA-TR*                  COMM_DIRECTION,                                        
MFA-TR*                  COMM_TYPE_CD,                                          
MFA-TR*                  COMM_SUBTYPE_CODE,                                     
MFA-TR*                  USER_ID_ORIG,                                          
MFA-TR*                  CONTACT_NAME,                                          
MFA-TR*                  PROMOTION_ID,                                          
MFA-TR*                  PSC_COMPLIANCE_IND,                                    
MFA-TR*                  CALL_ORIGIN_ID,                                        
MFA-TR*                  CALL_END_TIME,                                         
MFA-TR*                  NUMBER_TRANSFERS,                                      
MFA-TR*                  HOLD_TIME,                                             
MFA-TR*                  QUEUE_TIME,                                            
MFA-TR*                  SCREEN_POP_IND,                                        
MFA-TR*                  TOTAL_CALL_TIME,                                       
MFA-TR*                  INITIAL_COMMENT_TX,                                    
MFA-TR*                  RESPONSE_REASON_CD,                                    
MFA-TR*                  RESPONSE_TYPE_CD,                                      
MFA-TR*                  SOLICITATION_CD,                                       
MFA-TR*                  COMM_ASSOC_CD,                                         
MFA-TR*                  COMPLAINT_FL,                                          
MFA-TR*                  DISCOVERY_MTHD_CD,                                     
MFA-TR*                  PREV_MARKETER_CD)                                      
MFA-TR*         VALUES   (CURRENT TIMESTAMP,                                    
MFA-TR*                  :KO-ACCOUNT-NO,                                        
MFA-TR*                  :KO-CUSTOMER-NO,                                       
MFA-TR*                  :KO-PREMISE-NO,                                        
MFA-TR*                  :KO-COMPANY-NO,                                        
MFA-TR*                  :KO-RED-FLAG-IND,                                      
MFA-TR*                  :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,             
MFA-TR*                  :KO-COMM-METHOD,                                       
MFA-TR*                  :KO-COMM-DIRECTION,                                    
MFA-TR*                  :KO-COMM-TYPE-CD,                                      
MFA-TR*                  :KO-COMM-SUBTYPE-CODE,                                 
MFA-TR*                  :KO-USER-ID-ORIG,                                      
MFA-TR*                  :KO-CONTACT-NAME,                                      
MFA-TR*                  :KO-PROMOTION-ID,                                      
MFA-TR*                  :KO-PSC-COMPLIANCE-IND,                                
MFA-TR*                  :KO-CALL-ORIGIN-ID,                                    
MFA-TR*                  :KO-CALL-END-TIME:WS-END-NULL-IND,                     
MFA-TR*                  :KO-NUMBER-TRANSFERS,                                  
MFA-TR*                  :KO-HOLD-TIME,                                         
MFA-TR*                  :KO-QUEUE-TIME,                                        
MFA-TR*                  :KO-SCREEN-POP-IND,                                    
MFA-TR*                  :KO-TOTAL-CALL-TIME,                                   
MFA-TR*                  :KO-INITIAL-COMMENT-TX,                                
MFA-TR*                  :KO-RESPONSE-REASON-CD,                                
MFA-TR*                  :KO-RESPONSE-TYPE-CD,                                  
MFA-TR*                  :KO-SOLICITATION-CD,                                   
MFA-TR*                  :KO-COMM-ASSOC-CD,                                     
MFA-TR*                  :KO-COMPLAINT-FL,                                      
MFA-TR*                  :KO-DISCOVERY-MTHD-CD,                                 
MFA-TR*                  :KO-PREV-MARKETER-CD)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               CONTINUE                                                 
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE SQLCODE               TO ABEND-SQLCODE               
              MOVE ACTIVE-PARAGRAPH      TO ABEND-FUNCTION              
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE IY-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE IY-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       8700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************12640000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     12650000
      ******************************************************************12660000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************12710000
      *       END PROGRAM COPYLIB                                      *12720000
      ******************************************************************12730000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00321                                                 
REARCH     END-EXEC.                                                            
      ******************************************************************        
      * 9700-PROCESS-ABEND - COMBINED ERROR HANDLING INCLUDE           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
                                                                        
