       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02561.                                         
COB303 DATE-WRITTEN.     FEBRUARY 2005.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S561 CONVERTED TO DB2 SP CSR02561 ON 03/07/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      ****             SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S561                                           *        
      *  PROGRAM:       S561                                           *        
      *  CALLING SP:    PA_S561                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM IS CALLED FROM A TCL PROGRAM. THIS IS CALLED TO  *        
      *  GET METER INFO FOR AMR.                                       *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  02/2005     MSR      PROGRAM INITIALLY WRITTEN.               *        
      *  07/26/2005  MSR      ADD MTR-STORAGE-FAC-CD TO THE RESULT SET *        
      *  02/16/2006  MSR      SEND SPACES TO METER FORM IF THERE IS NO *        
      *                       CLASS&SPEC COMBINATION IN ELEC_CL_SPEC   *        
      *  10/15/2008  AHF      CML 37807 - ADDED QUALIFIERS TO SELECT IN*        
      *                       PARAGRAPH 7000-GET-ELEC-METER.           *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02561'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                   PIC X(40) VALUE                   
           'WORKING STORAGE FOR RPC S561 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_ELEC_METER                                                       
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBELMTR                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_ELEC_CL_SPEC                                                     
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBELCLSP                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_METER_ATTCHMTS                                                   
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBMTRATT                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_GAS_METER                                                        
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBGASMTR                                                   
           END-EXEC.                                                            
C30989*                                                                         
C30989*****************************************************************         
C30989*    CSS_EQUIPMENT                                                        
C30989*****************************************************************         
C30989     EXEC SQL                                                             
C30989       INCLUDE TBEQUIP                                                    
C30989     END-EXEC.                                                            
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-ERT-ID.                                                
              10 WS-PAD-ZERO              PIC X(01) VALUE '0'.          
              10 WS-DEVICE-NO             PIC X(09) VALUE SPACES.       
           05 WS-METER-NO                 PIC X(09) VALUE SPACES.       
           05 WS-COMPANY-NO               PIC X(01) VALUE SPACES.       
           05 WS-CODE-UTIL-TYPE           PIC X(01) VALUE SPACES.       
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-E                        PIC X(01)  VALUE 'E'.         
           05 WS-G                        PIC X(01)  VALUE 'G'.         
           05 WS-IT                       PIC X(02)  VALUE 'IT'.        
           05 PROGRAM-NAME                PIC X(08)  VALUE 'S561    '.  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01)  VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW               PIC X(01)  VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  WS-SEND-RESULT             PIC X(01)  VALUE 'N'.         
               88 SEND-RESULT                        VALUE 'Y'.         
      *                                                                 00052000
HPCCDM*    EJECT                                                        00096000
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                   POINTER.                              
CVT999*    05  GWL-INIT-HANDLE            POINTER.                              
CVT999*    05  GWL-RC                     PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-NR              PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-DONE            PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-COUNT           PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-COMM            PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-RETURN-CODE     PIC S9(9)   COMP.                     
           05  GWL-STATUS-SUBCODE         PIC S9(9)   COMP.             
      *                                                                         
       01  FILLER                         PIC X(11)  VALUE              
                                                    'PARM FIELDS'.      
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9)   COMP.               
CVT999*    05  PARM-ID1                 PIC S9(9)   COMP VALUE 1.               
           05  PARM-ACCOUNT-NO            PIC X(13)  VALUE SPACES.      
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO       
                                          PIC 9(13).                    
           05  PARM-COMPANY-NO            PIC X(02)  VALUE SPACES.      
           05  PARM-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.      
           05  PARM-METER-NO              PIC X(10)  VALUE SPACES.      
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9)   COMP.             
CVT999*    05  SNA-CONNECTION-NAME        PIC X(8)   VALUE SPACES.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                 PIC S9(9)   COMP                      
CVT999*                                              VALUE 1.                   
CVT999*    05  CTR-ROWS                   PIC S9(9)   COMP                      
CVT999*                                              VALUE 0.                   
           05  WS-ROW-COUNT               PIC S9(9)   COMP              
                                                     VALUE 0.           
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM            PIC S9(9)   COMP.                     
CVT999*    05  WRKLEN1                    PIC S9(9)   COMP.                     
CVT999*    05  WRKLEN2                    PIC S9(9)   COMP.                     
           05  WRK-DONE-STATUS            PIC S9(9)   COMP.             
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE             PIC S9(9)   COMP              
                                                     VALUE ZEROS.       
            05  S-RETURN-CODE             PIC S9(9)   COMP              
                                                     VALUE ZEROS.       
            05 RS-METER-FORM              PIC X(04)  VALUE SPACES.      
            05 RS-ERT-ID                  PIC X(10)  VALUE SPACES.      
            05 RS-MTR-DRIVE-RATE          PIC X(04)  VALUE SPACES.      
            05 RS-MTR-CAPACITY            PIC X(05)  VALUE SPACES       
                                                     JUST RIGHT.        
            05 RS-MTR-CONNECT-TYP-ID      PIC X(10)  VALUE SPACES.      
C30989      05 RS-MTR-STORAGE-FAC-CD      PIC X(03)  VALUE SPACES.      
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE            PIC X(11)  VALUE                      
CVT999*                                         'RETURN CODE'.                  
CVT999*     05 CNS-METER-FORM             PIC X(10)  VALUE                      
CVT999*                                         'METER FORM'.                   
CVT999*     05 CNS-ERT-ID                 PIC X(06)  VALUE                      
CVT999*                                         'ERT ID'.                       
CVT999*     05 CNS-MTR-DRIVE-RATE         PIC X(14)  VALUE                      
CVT999*                                         'MTR DRIVE RATE'.               
CVT999*     05 CNS-MTR-CAPACITY           PIC X(12)  VALUE                      
CVT999*                                         'MTR CAPACITY'.                 
CVT999*     05 CNS-MTR-CONNECT-TYP-ID     PIC X(18)  VALUE                      
CVT999*                                         'MTR CONNECT TYP ID'.           
CVT999*     05 CNS-MTR-STORAGE-FAC-CD     PIC X(18)  VALUE                      
CVT999*                                         'MTR STORAGE FAC CD'.           
CVT999*                                                                         
HPCCDM*    EJECT                                                        02620001
      *                                                                         
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-COMPANY-NO          PIC X(02)                .          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-METER-NO            PIC X(10)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-COMPANY-NO                                         
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-METER-NO                                           
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
      *                                                                         
           IF  CTR-ROWS < 1                                             
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE +100                         TO RS-RETURN-CODE      
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                           TO ACTIVE-PARAGRAPH.   
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                  TO ABEND-PROGRAM               
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'            TO TABLE-1                     
CVT999*       MOVE GWL-RC                        TO                             
CVT999*                                           WS-ACTIVE-RETURN-CODE         
CVT999*       PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT                 
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT                 
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-METER-FORM               AS    METER_FORM             
CVT000       ,:RS-ERT-ID                   AS    ERT_ID                 
CVT000       ,:RS-MTR-DRIVE-RATE           AS    MTR_DRIVE_RATE         
CVT000       ,:RS-MTR-CAPACITY             AS    MTR_CAPACITY           
CVT000       ,:RS-MTR-CONNECT-TYP-ID       AS    MTR_CONNECT_TYP_ID     
CVT000       ,:RS-MTR-STORAGE-FAC-CD       AS    MTR_STORAGE_FAC_CD     
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-METER-FORM               AS    METER_FORM                     
MFA-TR*      ,:RS-ERT-ID                   AS    ERT_ID                         
MFA-TR*      ,:RS-MTR-DRIVE-RATE           AS    MTR_DRIVE_RATE                 
MFA-TR*      ,:RS-MTR-CAPACITY             AS    MTR_CAPACITY                   
MFA-TR*      ,:RS-MTR-CONNECT-TYP-ID       AS    MTR_CONNECT_TYP_ID             
MFA-TR*      ,:RS-MTR-STORAGE-FAC-CD       AS    MTR_STORAGE_FAC_CD             
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-METER-NO             TO PARM-METER-NO            . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 1100-RECEIVE-PARMS            THRU 1100-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
      ***** RECEIVING PARAMETER ACCOUNT NO                                      
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      ***** RECEIVING PARAMETER COMPANY NO                                      
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMPANY-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMPANY-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      ***** RECEIVING PARAMETER CODE UTIL TYPE                                  
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE    TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE-UTIL-TYPE,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      ***** RECEIVING PARAMETER METER NO                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-METER-NO          TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-METER-NO,                                 
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT-IM                                 *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT-IM          THRU 2200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
      *                                                                         
           MOVE '2100'                           TO ACTIVE-PARAGRAPH.   
                                                                        
CVT999*    MOVE 1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSINT4                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSINT4                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-RETURN-CODE         TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE        TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
CVT999*    ADD 1                                 TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-METER-FORM          TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-METER-FORM         TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-METER-FORM,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-METER-FORM,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
CVT999*    ADD 1                                 TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-ERT-ID              TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-ERT-ID             TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ERT-ID,                                     
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ERT-ID,                                    
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
CVT999*    ADD 1                                 TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-MTR-DRIVE-RATE      TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-MTR-DRIVE-RATE     TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MTR-DRIVE-RATE,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MTR-DRIVE-RATE,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
CVT999*    ADD 1                                 TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-MTR-CAPACITY        TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-MTR-CAPACITY       TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MTR-CAPACITY,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MTR-CAPACITY,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
CVT999*    ADD 1                                 TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-MTR-CONNECT-TYP-ID  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-MTR-CONNECT-TYP-ID TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MTR-CONNECT-TYP-ID,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MTR-CONNECT-TYP-ID,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
CVT999*    ADD 1                                 TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-MTR-STORAGE-FAC-CD  TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-MTR-STORAGE-FAC-CD TO WRKLEN2.                    
C30989                                                                  
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MTR-STORAGE-FAC-CD,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MTR-STORAGE-FAC-CD,                        
CVT999*                          WRKLEN2.                                       
C30989                                                                  
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
C30989                                                                  
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2200-BUILD-RESULT-IM                                        *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      ******************************************************************        
       2200-BUILD-RESULT-IM.                                            
      *                                                                         
           MOVE '2200'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2500-GET-METER-DETAILS        THRU 2500-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * THIS PARA GETS THE METER DETAILS.                             *         
      *****************************************************************         
       2500-GET-METER-DETAILS.                                          
                                                                        
           MOVE '2500'                          TO ACTIVE-PARAGRAPH.    
           MOVE PARM-COMPANY-NO                 TO WS-COMPANY-NO        
C30989                                             EQ-COMPANY-NO.       
           MOVE PARM-CODE-UTIL-TYPE             TO WS-CODE-UTIL-TYPE    
C30989                                             EQ-CODE-UTIL-TYPE.   
           MOVE PARM-METER-NO                   TO WS-METER-NO          
C30989                                             EQ-DEVICE-NO.        
C30989     PERFORM 7300-GET-MTR-STG-FAC         THRU 7300-EXIT.         
C30989     MOVE EQ-LOCAL-OFFICE                TO RS-MTR-STORAGE-FAC-CD.
           EVALUATE PARM-CODE-UTIL-TYPE                                 
              WHEN WS-E                                                 
                 MOVE PARM-COMPANY-NO          TO EM-COMPANY-NO         
                 MOVE PARM-CODE-UTIL-TYPE      TO EM-CODE-UTIL-TYPE     
                 MOVE PARM-METER-NO            TO EM-METER-NO           
                 PERFORM 7000-GET-ELEC-MTR     THRU 7000-EXIT           
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    SET SEND-RESULT TO TRUE                             
                    MOVE EM-MTR-CONNECT-TYP-ID TO RS-MTR-CONNECT-TYP-ID 
                    MOVE U0-ELEC-MTR-FORM-CD   TO RS-METER-FORM         
                 ELSE                                                   
                    SET SEND-RESULT TO TRUE                             
                    MOVE ZEROS                 TO RS-RETURN-CODE        
                    MOVE SPACES                TO RS-MTR-CONNECT-TYP-ID 
                    MOVE SPACES                TO RS-METER-FORM         
                 END-IF                                                 
                 IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND               
                    NEXT SENTENCE                                       
                 ELSE                                                   
                    PERFORM 7100-GET-MTR-ATT      THRU 7100-EXIT        
                                                                        
                    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL      
                       SET SEND-RESULT TO TRUE                          
                       MOVE MA-DEVICE-NO          TO WS-DEVICE-NO       
                    END-IF                                              
                 END-IF                                                 
                 MOVE WS-ERT-ID                TO RS-ERT-ID             
              WHEN WS-G                                                 
                 MOVE PARM-COMPANY-NO          TO GM-COMPANY-NO         
                 MOVE PARM-CODE-UTIL-TYPE      TO GM-CODE-UTIL-TYPE     
                 MOVE PARM-METER-NO            TO GM-METER-NO           
                 PERFORM 7200-GET-GAS-MTR      THRU 7200-EXIT           
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    SET SEND-RESULT TO TRUE                             
                    MOVE GM-NUMBER-OF-DRIVE    TO RS-MTR-DRIVE-RATE     
                    MOVE GM-CCF-CAP-PER-HR     TO RS-MTR-CAPACITY       
                    MOVE GM-CONNECTION-TYPE-CD TO RS-MTR-CONNECT-TYP-ID 
                 END-IF                                                 
                 PERFORM 7100-GET-MTR-ATT      THRU 7100-EXIT           
                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
                    SET SEND-RESULT TO TRUE                             
                    MOVE MA-DEVICE-NO          TO WS-DEVICE-NO          
                 END-IF                                                 
                 MOVE WS-ERT-ID                TO RS-ERT-ID             
           END-EVALUATE.                                                
           IF SEND-RESULT                                               
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF.                                                      
HPCCDM*EJECT                                                                    
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** SELECT ELEC METER DETAILS                                   **         
      *****************************************************************         
       7000-GET-ELEC-MTR.                                               
      *                                                                 05910000
           EXEC SQL                                                     
C37807          SELECT EM.MTR_CONNECT_TYP_ID                            
C37807                ,U0.ELEC_MTR_FORM_CD                              
                  INTO :EM-MTR-CONNECT-TYP-ID                           
                      ,:U0-ELEC-MTR-FORM-CD                             
                  FROM CSS_ELEC_METER EM                                
                      ,CSS_ELEC_CL_SPEC U0                              
C37807           WHERE EM.COMPANY_NO        = :EM-COMPANY-NO            
C37807             AND EM.CODE_UTIL_TYPE    = :EM-CODE-UTIL-TYPE        
C37807             AND EM.METER_NO          = :EM-METER-NO              
                   AND U0.ELEC_MTR_CLASS_CD = EM.ELEC_MTR_CLASS_CD      
                   AND U0.ELEC_MTR_SPEC_CD  = EM.ELEC_MTR_SPEC_CD       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7000'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_ELEC_METER'     TO TABLE-1                     
               MOVE 'CSS_ELEC_CL_SPEC'   TO TABLE-2                     
               MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'METER_NO'           TO TABLE-ELEMENT-3             
               MOVE EM-COMPANY-NO        TO HOSTVAR-ELEMENT-1           
               MOVE EM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE EM-METER-NO          TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
HPCCDM*EJECT                                                                    
      *                                                                 06060000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      ** SELECT METER ATTACHMENT DETAILS                             **         
      *****************************************************************         
       7100-GET-MTR-ATT.                                                
      *                                                                 05910000
           EXEC SQL                                                     
                SELECT DEVICE_NO                                        
                  INTO :MA-DEVICE-NO                                    
                  FROM CSS_METER_ATTCHMTS                               
                 WHERE COMPANY_NO     = :WS-COMPANY-NO                  
                   AND CODE_UTIL_TYPE = :WS-CODE-UTIL-TYPE              
                   AND METER_NO       = :WS-METER-NO                    
                   AND CODE_ATT_TYPE  = :WS-IT                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7100'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_METER_ATTCHMTS' TO TABLE-1                     
               MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'METER_NO'           TO TABLE-ELEMENT-3             
               MOVE EM-COMPANY-NO        TO HOSTVAR-ELEMENT-1           
               MOVE EM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE EM-METER-NO          TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
HPCCDM*EJECT                                                                    
      *                                                                 06060000
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************18100000
      * 7200-GET-GAS-MTR                                               *18110000
      *      SELECT GAS METER DETAILS                                  *18120000
      ******************************************************************18140000
       7200-GET-GAS-MTR.                                                
      *                                                                 18160000
           EXEC SQL                                                     
               SELECT NUMBER_OF_DRIVE                                   
                     ,CCF_CAP_PER_HR                                    
                     ,CONNECTION_TYPE_CD                                
                 INTO :GM-NUMBER-OF-DRIVE                               
                     ,:GM-CCF-CAP-PER-HR                                
                     ,:GM-CONNECTION-TYPE-CD                            
                 FROM CSS_GAS_METER                                     
                WHERE COMPANY_NO     = :GM-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :GM-CODE-UTIL-TYPE               
                  AND METER_NO       = :GM-METER-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18230000
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_GAS_METER'      TO TABLE-1                     
               MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1             
               MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
               MOVE 'METER_NO'           TO TABLE-ELEMENT-3             
               MOVE GM-COMPANY-NO        TO HOSTVAR-ELEMENT-1           
               MOVE GM-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
               MOVE GM-METER-NO          TO HOSTVAR-ELEMENT-3           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18390000
        7200-EXIT.                                                      
            EXIT.                                                       
C30989*                                                                         
C30989******************************************************************18100000
C30989* 7300-GET-MTR-STG-FAC                                           *18110000
C30989*      SELECT LOCAL OFFICE FROM CSS_EQUIPMENT                    *18120000
C30989******************************************************************18140000
C30989 7300-GET-MTR-STG-FAC.                                            
C30989*                                                                 18160000
C30989     EXEC SQL                                                     
C30989         SELECT LOCAL_OFFICE                                      
C30989           INTO :EQ-LOCAL-OFFICE                                  
C30989           FROM CSS_EQUIPMENT                                     
C30989          WHERE COMPANY_NO     = :EQ-COMPANY-NO                   
C30989            AND CODE_UTIL_TYPE = :EQ-CODE-UTIL-TYPE               
C30989            AND DEVICE_NO      = :EQ-DEVICE-NO                    
C30989     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30989*                                                                 18230000
C30989     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
C30989                                                                  
C30989     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30989         NEXT SENTENCE                                            
C30989     ELSE                                                         
C30989         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
C30989         MOVE '7300'                TO ACTIVE-PARAGRAPH           
C30989         MOVE 'SELECT'              TO ABEND-FUNCTION             
C30989         MOVE SPACES                TO ABEND-SQL-PREDICATES       
C30989                                       ABEND-TABLES               
C30989         MOVE 'CSS_EQUIPMENT'      TO TABLE-1                     
C30989         MOVE 'COMPANY_NO'         TO TABLE-ELEMENT-1             
C30989         MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2             
C30989         MOVE 'DEVICE_NO'          TO TABLE-ELEMENT-3             
C30989         MOVE EQ-COMPANY-NO        TO HOSTVAR-ELEMENT-1           
C30989         MOVE EQ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2           
C30989         MOVE EQ-DEVICE-NO         TO HOSTVAR-ELEMENT-3           
C30989         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30989         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30989     END-IF.                                                      
C30989*                                                                 18390000
C30989  7300-EXIT.                                                      
C30989      EXIT.                                                       
      *                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
