       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02557.                                         
COB303 DATE-WRITTEN.     APR 28, 2004.                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S557                                           *        
      *  PROGRAM:       S557                                           *        
      *  CALLING SP:    PA_S557                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM VALIDATES SPOUSE SSN FROM THE WEB.               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/29/04    FMB      PROCEDURE ORIGINALLY CODED.              *        
C29533*  02/07/05  SS19371    ADDING SSN TO BEGINNING OF COMMENTS OF WQ*        
REARCH*  01/11/07  CVNS       RPC TO DB2 SP CONVERSION                 *        
REARCH*            CHENNAI                                             *        
A00466*  11/24/08  FMB        CHANGE TO DYNAMIC CALL OF MCSCB068.      *        
A01233*  06/19/09  FMB        MASK SSN IN WQ.                          *        
A04860** 05/19/16  MR7E794    REPLACE CSS_WQ_ITEMS_MF WITH             *        
A04860**           ACT117     CSS_WQ_ITEMS.                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02557'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02557 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           EXEC SQL                                                             
               INCLUDE CWS00068                                                 
           END-EXEC.                                                            
           COPY CWS0068L.                                                       
           COPY CWS00056.                                                       
ACT117******************************************************************        
ACT117* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
ACT117******************************************************************        
ACT117*                                                                         
ACT117     EXEC SQL                                                             
ACT117        INCLUDE CWS00077                                                  
ACT117     END-EXEC.                                                            
ACT117*                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02557'.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-CUSTOMER-NO        PIC X(10).                       
           05  PARM-SSN                PIC X(9).                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
           05  WS-ACCOUNT-COUNT        PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-DATE-BILL-00-IND     PIC S9(04)    COMP   VALUE +0.   
           05  WS-DATE-BILL-30-IND     PIC S9(04)    COMP   VALUE +0.   
           05  WS-DATE-BILL-60-IND     PIC S9(04)    COMP   VALUE +0.   
           05  WS-DATE-BILL-90-IND     PIC S9(04)    COMP   VALUE +0.   
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  MISC.                                                        
           05  WS-ACCOUNT-NO-RED        PIC X(13).                      
           05  WS-ACCOUNT-NO-NUM        REDEFINES WS-ACCOUNT-NO-RED     
                                        PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.       
           05  WS-CUSTOMER-NO-RED       PIC X(10).                      
           05  WS-CUSTOMER-NO-NUM       REDEFINES WS-CUSTOMER-NO-RED    
                                        PIC 9(10).                      
COB305     05 WS-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.       
           05  WS-MULT-ACCT-COMMENT.                                    
               10  FILLER               PIC X(10) VALUE 'ACCOUNTS: '.   
               10  WS-ACCOUNT-LINE      OCCURS 10.                      
                   15  WS-WQ-MULTI-ACCT PIC X(16).                      
                   15  FILLER           PIC X VALUE ' '.                
           05  WS-SINGLE-ACCT-COMMENT.                                  
C29533         10  FILLER               PIC X(09) VALUE 'SSN: '.        
C29533         10  WS-WQ-SSN            PIC X(11).                      
               10  FILLER               PIC X(10) VALUE ' ACCOUNT: '.   
               10  WS-WQ-ACCT           PIC X(16).                      
               10  FILLER               PIC X(09) VALUE ' 90 DAY: '.    
               10  WS-WQ-90             PIC Z(5).99.                    
               10  FILLER               PIC X(09) VALUE ' 60 DAY: '.    
               10  WS-WQ-60             PIC Z(5).99.                    
               10  FILLER               PIC X(09) VALUE ' 30 DAY: '.    
               10  WS-WQ-30             PIC Z(5).99.                    
               10  FILLER               PIC X(11) VALUE ' ACCT BAL: '.  
               10  WS-ACCT-BAL          PIC Z(6).99.                    
           05  WS-LIMITS-MET            PIC X(01) VALUE 'N'.            
           05  WS-FORMATTED-ACCOUNT     PIC X(16).                      
C29533     05  WS-FORMATTED-SSN         PIC X(11).                      
           05  WS-UNFORMATTED-ACCOUNT   PIC 9(13).                      
           05  WS-60-PLUS-90            PIC S9(9)V99 COMP-3 VALUE 0.    
           05  WS-EIBRESP               PIC S9(8) COMP SYNC VALUE ZERO. 
           05  WS-LOCAL-OFFICE          PIC X(03).                      
           05  WS-COMPANY-NO            PIC X(02).                      
A00466     05  WS-MCSCB068              PIC X(08) VALUE 'MCSCB068'.     
ACT117     05  MCSCB077                 PIC X(08) VALUE 'MCSCB077'.     
ACT117     05  WS-MCSCB077-RET-CODE     PIC S9(04) COMP VALUE 0.        
                                                                        
           EXEC SQL                                                     
               DECLARE SSN-CURSOR CURSOR FOR                            
                   SELECT ACCOUNT_NO,                                   
                          CODE_ACCT_STAT,                               
                          DATE_BILL_DAY_00,                             
                          DATE_BILL_DAY_30,                             
                          DATE_BILL_DAY_60,                             
                          DATE_BILL_DAY_90,                             
                          CREDIT_GROUP,                                 
                          BANKRUPTCY_IND,                               
                          TOTAL_AR_BALANCE,                             
                          CODES_DATA_PRESENT,                           
                          NOTICE_EXEMPT_CD,                             
                          CODE_DISC_OK,                                 
                          COMPANY_NO,                                   
                          LOCAL_OFFICE,                                 
                          IVR_EXEMPT_CD,                                
                          TOTAL_AR_BALANCE,                             
                          PREMISE_NO,                                   
                          AT.CUSTOMER_NO                                
                   FROM CSS_ACCOUNT AT,                                 
                        CSS_CUST_STATS CE                               
                   WHERE CE.SSN = :CE-SSN                               
                     AND CE.CUSTOMER_NO = AT.CUSTOMER_NO                
                     AND AT.CODE_ACCT_STAT IN ('B', 'S')                
           END-EXEC.                                                    
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-CUSTOMER-NO         PIC X(10)                .          
CVT000 01  LINK-SSN                 PIC X(9)                 .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-CUSTOMER-NO                                        
CVT000         ,LINK-SSN                                                
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH          :S-RETURN-CODE            AS    RETURN_CODE             
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*         :S-RETURN-CODE            AS    RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
CVT000     MOVE LINK-SSN                  TO PARM-SSN                 . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-CUSTOMER-NO      TO WS-CUSTOMER-NO-RED.            
           IF WS-CUSTOMER-NO-RED NOT NUMERIC                            
               MOVE ZEROES TO WS-CUSTOMER-NO-RED
           END-IF.                       
           MOVE WS-CUSTOMER-NO-NUM TO WS-CUSTOMER-NO.                   
           PERFORM 7100-GET-CUSTOMER THRU 7100-EXIT.                    
           MOVE 0.00 TO WS-WQ-30 WS-WQ-60 WS-WQ-90 WS-ACCT-BAL.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
           MOVE ZEROES                     TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
REARCH     PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT                                              *        
REARCH******************************************************************        
REARCH                                                                  
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE              TO S-RETURN-CODE.           
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           MOVE PARM-SSN TO CE-SSN.                                     
                                                                        
           EXEC SQL                                                     
               OPEN SSN-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_STATS'           TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE PARM-SSN                   TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 2300-FETCH                 THRU 2300-EXIT.           
                                                                        
           EXEC SQL                                                     
               CLOSE SSN-CURSOR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_CUST_STATS'           TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE PARM-SSN                   TO TABLE-ELEMENT-1        
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF WS-ACCOUNT-COUNT > 0                                      
               PERFORM 4000-WRITE-WQ THRU 4000-EXIT
           END-IF.                    
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-FETCH.                                                      
                                                                        
           MOVE '2300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
             FETCH SSN-CURSOR                                           
              INTO  :AT-ACCOUNT-NO,                                     
                    :AT-CODE-ACCT-STAT,                                 
                    :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND,           
                    :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND,           
                    :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND,           
                    :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND,           
                    :AT-CREDIT-GROUP,                                   
                    :AT-BANKRUPTCY-IND,                                 
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-NOTICE-EXEMPT-CD,                               
                    :AT-CODE-DISC-OK,                                   
                    :AT-COMPANY-NO,                                     
                    :AT-LOCAL-OFFICE,                                   
                    :AT-IVR-EXEMPT-CD,                                  
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-PREMISE-NO,                                     
                    :AT-CUSTOMER-NO                                     
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE 'N' TO WS-LIMITS-MET                              
                 PERFORM 2400-CHECK-BALANCES THRU 2400-EXIT             
                 IF WS-LIMITS-MET = 'Y'                                 
                    ADD 1 TO WS-ACCOUNT-COUNT                           
                    PERFORM 2500-FORMAT-ACCOUNT THRU 2500-EXIT          
A01233              STRING '***-**-' CE-SSN(6:4)                        
C29533                 DELIMITED BY SIZE INTO WS-FORMATTED-SSN          
                    MOVE WS-FORMATTED-ACCOUNT TO                        
                         WS-WQ-MULTI-ACCT(WS-ACCOUNT-COUNT)             
                    IF WS-ACCOUNT-COUNT = 1                             
                       MOVE WS-AMT-30-DAY TO WS-WQ-30                   
                       MOVE WS-AMT-60-DAY TO WS-WQ-60                   
                       MOVE WS-AMT-90-DAY TO WS-WQ-90                   
                       MOVE WS-FORMATTED-ACCOUNT TO WS-WQ-ACCT          
C29533                 MOVE WS-FORMATTED-SSN     TO WS-WQ-SSN           
                    END-IF                                              
                 END-IF                                                 
              WHEN NOT-FOUND                                            
                 GO TO 2300-EXIT                                        
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
                 MOVE 'FETCH'               TO ABEND-FUNCTION           
                 MOVE SPACES                TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                 MOVE 'CSS_CUST_STATS'      TO TABLE-1                  
                 MOVE 'CSS_ACCOUNT'         TO TABLE-2                  
                 MOVE PARM-SSN              TO TABLE-ELEMENT-1          
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
           GO TO 2300-FETCH.                                            
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2400-CHECK-BALANCES.                                             
                                                                        
           MOVE 'Y'                   TO CALC-ARREARS-SW                
                                         CALC-PAST-DUE-SW               
                                         CALC-BALANCE-SW.               
                                                                        
           MOVE PROGRAM-NAME          TO WS-CPD00068-CALLING-PGM.       
           MOVE SPACES                TO ABEND-FUNCTION.                
           PERFORM 9500-CALL-CPD00068 THRU 9500-EXIT.                   
           MOVE RS-RETURN-CODE        TO WS-ACTIVE-RETURN-CODE          
                                         SQLCODE.                       
           IF ABEND-FUNCTION  > SPACES                                  
               PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.               
                                                                        
           COMPUTE WS-60-PLUS-90 = WS-AMT-60-DAY + WS-AMT-90-DAY.       
                                                                        
           IF AT-CODE-ACCT-STAT = 'B' AND                               
              AT-TOTAL-AR-BALANCE > 10.00 AND                           
              WS-60-PLUS-90 > 3.00                                      
                  MOVE AT-TOTAL-AR-BALANCE TO WS-ACCT-BAL               
                  MOVE 'Y' TO WS-LIMITS-MET
           END-IF.                            
           IF AT-CODE-ACCT-STAT = 'S' AND                               
              WS-WO-BALANCE > 10.00                                     
                  MOVE WS-WO-BALANCE TO WS-ACCT-BAL                     
                  MOVE 'Y' TO WS-LIMITS-MET
           END-IF.                            
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-FORMAT-ACCOUNT.                                             
                                                                        
           MOVE AT-ACCOUNT-NO TO WS-UNFORMATTED-ACCOUNT.                
           MOVE WS-UNFORMATTED-ACCOUNT(1:1) TO                          
                WS-FORMATTED-ACCOUNT(1:1)                               
           MOVE WS-UNFORMATTED-ACCOUNT(2:4) TO                          
                WS-FORMATTED-ACCOUNT(3:4)                               
           MOVE WS-UNFORMATTED-ACCOUNT(6:4) TO                          
                WS-FORMATTED-ACCOUNT(8:4)                               
           MOVE WS-UNFORMATTED-ACCOUNT(10:4) TO                         
                WS-FORMATTED-ACCOUNT(13:4)                              
           MOVE '-' TO WS-FORMATTED-ACCOUNT(2:1)                        
                       WS-FORMATTED-ACCOUNT(7:1)                        
                       WS-FORMATTED-ACCOUNT(12:1).                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       4000-WRITE-WQ.                                                   
                                                                        
ACT117     INITIALIZE CWS00077-FIELDS.                                  
ACT117     MOVE 329                       TO WS-77-CATEGORY-ID.         
           PERFORM 7000-GET-RESP-AREA THRU 7000-EXIT.                   
ACT117     MOVE PF-RESP-AREA-ID           TO WS-77-RESP-AREA-ID.        
           EXEC SQL                                                     
ACT117         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-77-DATE-CREATED                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :WS-77-DATE-CREATED = CURRENT DATE                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT117     MOVE WS-77-DATE-CREATED        TO WS-77-DATE-REQUIRED.       
ACT117     MOVE 0                         TO WS-77-ACCOUNT-NO.          
ACT117     MOVE 0                         TO WS-77-PREMISE-NO.          
ACT117     MOVE WS-CUSTOMER-NO            TO WS-77-CUSTOMER-NO.         
ACT117     MOVE WS-LOCAL-OFFICE           TO WS-77-LOCAL-OFFICE.        
ACT117     MOVE '4'                       TO WS-77-ROUTE-CATEGORY.      
ACT117     MOVE 'N'                       TO WS-77-PRIORITY.            
           EVALUATE WS-ACCOUNT-COUNT                                    
               WHEN 1                                                   
ACT117             MOVE WS-SINGLE-ACCT-COMMENT  TO WS-77-COMMENTS-TEXT  
                   MOVE LENGTH OF WS-SINGLE-ACCT-COMMENT TO             
ACT117                            WS-77-COMMENTS-LEN                    
               WHEN OTHER                                               
ACT117             MOVE WS-MULT-ACCT-COMMENT  TO WS-77-COMMENTS-TEXT    
                   MOVE LENGTH OF WS-MULT-ACCT-COMMENT TO               
ACT117                            WS-77-COMMENTS-LEN                    
           END-EVALUATE.                                                
ACT117     MOVE SPACES                    TO WS-77-FREE-FORM-TXT.       
ACT117     MOVE ZERO                      TO WS-77-FREE-FORM-LEN.       
ACT117     MOVE PROGRAM-NAME              TO WS-77-CREATED-BY.          
           PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
                                                                        
       4000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-GET-RESP-AREA.                                              
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = 'ECSPRD1'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'ECSPRD1'             TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-CUSTOMER.                                               
                                                                        
           EXEC SQL                                                     
              SELECT COMPANY_NO_ORIG,                                   
                     LOCAL_OFFICE_ORIG                                  
                INTO :WS-COMPANY-NO,                                    
                     :WS-LOCAL-OFFICE                                   
                FROM CSS_CUSTOMER                                       
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_CUSTOMER'        TO TABLE-1                     
              MOVE WS-CUSTOMER-NO-NUM    TO TABLE-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
ACT117*                                                                         
ACT117 8895-INSERT-WORK-QUEUE.                                          
ACT117                                                                  
ACT117     CALL MCSCB077 USING CWS00077-FIELDS                          
ACT117                        ,ABEND-FILE                               
ACT117                        ,WS-MCSCB077-RET-CODE.                    
ACT117                                                                  
ACT117     MOVE WS-MCSCB077-RET-CODE         TO WS-ACTIVE-RETURN-CODE.  
ACT117                                                                  
ACT117     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT117         CONTINUE                                                 
ACT117     ELSE                                                         
ACT117         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT117         DISPLAY 'CALL MCSCB077         '                         
ACT117         MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
ACT117         MOVE '8895'             TO ACTIVE-PARAGRAPH              
ACT117         MOVE 'CALL'             TO ABEND-FUNCTION                
ACT117         MOVE 'MCSCB077'         TO TABLE-1                       
ACT117         MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
ACT117         MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-2               
ACT117         MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3               
ACT117         MOVE WS-77-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1             
ACT117         MOVE WS-77-PREMISE-NO   TO HOSTVAR-ELEMENT-2             
ACT117         MOVE WS-77-CUSTOMER-NO  TO HOSTVAR-ELEMENT-3             
ACT117         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
ACT117         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
ACT117     END-IF.                                                      
ACT117                                                                  
ACT117 8895-EXIT.                                                       
ACT117     EXIT.                                                        
                                                                        
       9500-CALL-CPD00068.                                              
                                                                        
A00466     CALL WS-MCSCB068  USING CWS00068-FIELDS,                     
CVT000                             WS-CODES-DATA-PRESENT,               
CVT000                             DCLCSS-ACCOUNT,                      
CVT000                             ABEND-FILE,                          
CVT000                             RS-RETURN-CODE.                      
REARCH     MOVE RS-RETURN-CODE             TO WS-ACTIVE-RETURN-CODE,    
REARCH                                        S-RETURN-CODE.            
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH         IF ABEND-FUNCTION EQUAL 'BADDATA'                        
REARCH            MOVE -1                  TO WS-ACTIVE-RETURN-CODE,    
REARCH                                        S-RETURN-CODE             
REARCH         END-IF                                                   
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
REARCH         PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
REARCH     END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
