       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02555.                                         
COB303 DATE-WRITTEN.  APR 03, 2003                                      
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S555 CONVERTED TO DB2 SP CSR02555 ON 09/15/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S555                                           *        
      *  PROGRAM:       S555                                           *        
      *  CALLING SP:    PA_S555                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES ALL THE COMPONENTS APPLICABLE TO     *        
      *  A FACTOR . (CALLED THRU PANEL 390 & PANEL444)                 *        
      *  A FACTOR      SAI09                                           *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/03/03   SK88120   PROCEDURE ORIGINALLY CODED.              *        
REARCH*  09/19/05   CVNS      RPC TO DB2 SP CONVERSION                 *        
REARCH*             CHENNAI                                            *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02555'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02555 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      **** CSS_RATE_COMPONENT ***                                               
           EXEC SQL                                                             
              INCLUDE TBRTCPNT                                                  
           END-EXEC.                                                            
                                                                        
      **** CSS_SPCL_FCT_CMPNT ***                                               
           EXEC SQL                                                             
              INCLUDE TBFCTCMP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
           COPY CWS00303.                                                       
                                                                        
           COPY CCA00001.                                                       
CVT999*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *  WORK AREA                                                     *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02555'.     
           05  WS-FACTOR-ID             PIC X(09).                      
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                 POINTER.                                
CVT999*    05  GWL-INIT-HANDLE          POINTER.                                
CVT999*    05  GWL-RC                   PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
           05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                     PIC S9(9) COMP.               
CVT999*    05  PARM-ID1                   PIC S9(9) COMP VALUE 1.               
           05  PARM-FACTOR-ID             PIC X(09).                    
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                PIC S9(9) COMP.                  
           05  MSG-SEVERITY            PIC S9(9) COMP VALUE 11.         
           05  MSG-NR                  PIC S9(9) COMP VALUE  2.         
           05  MSG-RPC                 PIC X(4)       VALUE 'S472'.     
           05  MSG-RPC-L               PIC S9(9) COMP.                  
           05  MSG-TEXT                PIC X(100).                      
           05  MSG-TEXT-L              PIC S9(9) COMP.                  
           05  MSG-SQL-ERROR.                                           
               10  FILLER              PIC X(10) VALUE 'SQLCODE = '.    
               10  MSG-SQL-ERROR-C     PIC -9(3) DISPLAY.               
               10  FILLER              PIC X(16)                        
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K     PIC X(70).                       
               10  MSG-SQL-ERROR-K-CHARS                                
                                       REDEFINES MSG-SQL-ERROR-K        
                                       OCCURS 70 TIMES                  
                                       PIC X.                           
           05  MSG-SQL-ERROR-SS        PIC S9(4) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
           05  RS-RATE-CMPNT-DESC       PIC X(15) VALUE SPACE.          
           05  RS-RATE-CMPNT-ID         PIC X(02) VALUE SPACES.         
           05  RS-RETURN-CODE           PIC S9(09) COMP VALUE 0.        
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RATE-CMPNT-DESC       PIC X(15) VALUE SPACE.           
REARCH     05  S-RATE-CMPNT-ID         PIC X(02) VALUE SPACES.          
REARCH     05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
CVT999*01  CN-COLUMN-NAMES.                                                     
CVT999*    05  CN-RATE-CMPNT-DESC       PIC X(15)                               
CVT999*                                  VALUE 'RATE_CMPNT_DESC'.               
CVT999*    05  CN-RATE-CMPNT-ID         PIC X(13)                               
CVT999*                                  VALUE 'RATE_CMPNT_ID'.                 
CVT999*    05  CN-RETURN-CODE           PIC X(11)                               
CVT999*                                  VALUE 'RETURN_CODE'.                   
CVT999*                                                                         
           EXEC SQL DECLARE SPCL-FCT-CMPNT-CSR CURSOR FOR               
               SELECT  N6.RATE_CMPNT_ID                                 
                     , N6.RATE_CMPNT_DESC                               
               FROM    CSS_SPCL_FCT_CMPNT SK                            
                     , CSS_RATE_COMPONENT N6                            
               WHERE   SK.FACTOR_ID        = :PARM-FACTOR-ID            
                 AND   N6.RATE_CMPNT_ID    = SK.CMPNT_ID_CD             
               ORDER BY SK.CMPNT_ID_CD                                  
           END-EXEC.                                                    
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT                                                   
REARCH         LTRIM(RTRIM(RATE_CMPNT_DESC))   AS RATE_CMPNT_DESC              
REARCH        ,LTRIM(RTRIM(RATE_CMPNT_ID))     AS RATE_CMPNT_ID                
REARCH        ,RETURN_CODE                                              
CVT000         FROM #CSR02555_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*        STRIP(RATE_CMPNT_DESC)   AS RATE_CMPNT_DESC                      
MFA-TR*       ,STRIP(RATE_CMPNT_ID)     AS RATE_CMPNT_ID                        
MFA-TR*       ,RETURN_CODE                                                      
MFA-TR*        FROM SESSION.CSR02555_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-FACTOR-ID           PIC X(09)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-FACTOR-ID                                          
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
REARCH*    PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                          
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM THRU 9999-EXIT.                     
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-FACTOR-ID            TO PARM-FACTOR-ID           . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02555_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02555_R1
              (                                                          
CVT000         RATE_CMPNT_DESC CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,RATE_CMPNT_ID CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,RETURN_CODE              INT                         
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLSTATE TO WS-SQLSTATE.                                
CVT000     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
CVT000                                                                  
CVT000     IF WS-SQLSTATE = '42710'                                     
CVT000        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
CVT000     ELSE                                                         
CVT000         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
CVT000             NEXT SENTENCE                                        
CVT000         ELSE                                                     
CVT000            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
CVT000            MOVE SQLCODE              TO ABEND-SQLCODE            
CVT000            MOVE SQLSTATE             TO ABEND-SQLSTATE           
CVT000            MOVE '0100A'               TO ACTIVE-PARAGRAPH        
CVT000            MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
CVT000            MOVE SPACES               TO ABEND-SQL-PREDICATES     
CVT000                                         ABEND-TABLES             
REARCH            MOVE 'CSR02555_R1'        TO TABLE-1                  
CVT000            MOVE SPACES               TO TABLE-ELEMENT-1          
CVT000            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
CVT000            PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
CVT000         END-IF                                                   
CVT000     END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
CVT000                                                                  
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
REARCH*1000-PROCESS-INPUT.                                                      
REARCH*                                                                         
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
REARCH*                                                                         
REARCH*1000-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *                                                                *        
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *        
      *                                                                *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
                                                                        
CVT999*    MOVE 1                            TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-FACTOR-ID     TO MAX-LENGTH-PARM,                
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-FACTOR-ID,                                
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. RETRIEVE DB2 DATA                                       *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE PARM-FACTOR-ID    TO WS-FACTOR-ID.                      
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                         
           PERFORM 2200-BUILD-RESULT    THRU 2200-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************05310000
REARCH* 2000A-MOVE-RESULT                                              *05320000
REARCH******************************************************************05310000
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RATE-CMPNT-DESC  TO S-RATE-CMPNT-DESC.               
REARCH     MOVE RS-RATE-CMPNT-ID    TO S-RATE-CMPNT-ID.                 
REARCH     MOVE RS-RETURN-CODE      TO S-RETURN-CODE.                   
REARCH 2000A-EXIT.                                                      
REARCH       EXIT.                                                      
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
                                                                        
CVT999*    MOVE 1        TO CTR-COLUMN.                                         
CVT999*    MOVE TDSCHAR  TO DB-HOST-TYPE.                                       
CVT999*    MOVE TDSCHAR  TO DB-CLIENT-TYPE.                                     
CVT999*    MOVE LENGTH OF RS-RATE-CMPNT-DESC   TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CN-RATE-CMPNT-DESC   TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RATE-CMPNT-DESC,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RATE-CMPNT-DESC,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1         TO CTR-COLUMN.                                         
CVT999*    MOVE TDSCHAR  TO DB-HOST-TYPE.                                       
CVT999*    MOVE TDSCHAR  TO DB-CLIENT-TYPE.                                     
CVT999*    MOVE LENGTH OF RS-RATE-CMPNT-ID    TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CN-RATE-CMPNT-ID    TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RATE-CMPNT-ID,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RATE-CMPNT-ID,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1       TO CTR-COLUMN.                                           
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *  1. FIND ALL RATE COMPONENTS FOR THE FACTOR SELECTED.          *        
      *  2. SEND RESULT                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           PERFORM 7000-OPEN-SPCL-FCT-CMPNT   THRU 7000-EXIT.           
           PERFORM 7100-FETCH-SPCL-FCT-CMPNT  THRU 7100-EXIT.           
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE SPACES                     TO RS-RATE-CMPNT-DESC     
              MOVE SPACES                     TO RS-RATE-CMPNT-ID       
              MOVE +100                       TO RS-RETURN-CODE         
REARCH        PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT           
              PERFORM 8100-SEND-RESULT        THRU 8100-EXIT            
           ELSE                                                         
              PERFORM 2500-POPULATE-RESULTS   THRU 2500-EXIT            
                    UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND             
           END-IF                                                       
                                                                        
           PERFORM 7200-CLOSE-SPCL-FCT-CMPNT  THRU 7200-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-POPULATE-RESULTS                                          *        
      ******************************************************************        
                                                                        
       2500-POPULATE-RESULTS.                                           
                                                                        
           MOVE N6-RATE-CMPNT-ID          TO RS-RATE-CMPNT-ID           
           MOVE N6-RATE-CMPNT-DESC        TO RS-RATE-CMPNT-DESC         
           MOVE ZEROS                     TO RS-RETURN-CODE             
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                    
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT                      
                                                                        
           MOVE SPACES                    TO RS-RATE-CMPNT-DESC         
           MOVE SPACES                    TO RS-RATE-CMPNT-ID           
           MOVE ZEROS                     TO RS-RETURN-CODE             
                                                                        
           PERFORM 7100-FETCH-SPCL-FCT-CMPNT  THRU 7100-EXIT.           
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7000-OPEN-SPCL-FCT-CMPNT                                     *          
      ****************************************************************          
                                                                        
       7000-OPEN-SPCL-FCT-CMPNT.                                        
                                                                        
           EXEC SQL                                                     
               OPEN SPCL-FCT-CMPNT-CSR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCT_CMPNT'      TO TABLE-1                 
              MOVE 'CSS_RATE_COMPONENT'      TO TABLE-2                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE PARM-FACTOR-ID            TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 7100-FETCH-SPCL-FCT-CMPNT                                    *          
      ****************************************************************          
                                                                        
       7100-FETCH-SPCL-FCT-CMPNT.                                       
                                                                        
           EXEC SQL                                                     
               FETCH SPCL-FCT-CMPNT-CSR                                 
               INTO                                                     
                  :N6-RATE-CMPNT-ID                                     
                 ,:N6-RATE-CMPNT-DESC                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'FETCH'                   TO ABEND-FUNCTION          
              MOVE 'CSS_SPCL_FCT_CMPNT'      TO TABLE-1                 
              MOVE 'CSS_RATE_COMPONENT'      TO TABLE-2                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE PARM-FACTOR-ID            TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 7200-CLOSE-SPCL-FCT-CMPNT                                    *          
      ****************************************************************          
                                                                        
       7200-CLOSE-SPCL-FCT-CMPNT.                                       
                                                                        
            EXEC SQL                                                    
                CLOSE SPCL-FCT-CMPNT-CSR                                
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
                NEXT SENTENCE                                           
            ELSE                                                        
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_SPCL_FCT_CMPNT'      TO TABLE-1                 
              MOVE 'CSS_RATE_COMPONENT'      TO TABLE-2                 
              MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-1         
              MOVE PARM-FACTOR-ID            TO HOSTVAR-ELEMENT-1       
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
            END-IF.                                                     
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
      ****************************************************************          
      *       END PROGRAM COPYLIB                                               
      ****************************************************************          
CVT999*COPY CPD00302.                                                           
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02555_R1                            
CVT000       (                                                          
CVT000        RATE_CMPNT_DESC                                           
CVT000       ,RATE_CMPNT_ID                                             
CVT000       ,RETURN_CODE                                               
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RATE-CMPNT-DESC                                        
REARCH       ,:S-RATE-CMPNT-ID                                          
REARCH       ,:S-RETURN-CODE                                            
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02555_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RATE_CMPNT_DESC                                                   
MFA-TR*      ,RATE_CMPNT_ID                                                     
MFA-TR*      ,RETURN_CODE                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RATE-CMPNT-DESC                                                
MFA-TR*      ,:S-RATE-CMPNT-ID                                                  
MFA-TR*      ,:S-RETURN-CODE                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000        MOVE SQLCODE              TO ABEND-SQLCODE                
CVT000        MOVE SQLSTATE             TO ABEND-SQLSTATE               
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR02555_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02555_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02555_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02555_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
