       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02549.                                         
COB303 DATE-WRITTEN.      SEPT 28, 2004.                                
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S549 CONVERTED TO DB2 SP CSR02549 ON 01/30/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S549                                           *00120000
      *  PROGRAM:       S549                                          * 00130000
      *  CALLING SP:    S549                                           *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES REVENUE DISTRICT ON CSS_PREMISE VIA THE  *00200000
      *  PBTRANSINDRIVER.                                              *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
C31607*  09/28/04    RR       RPC ORIGINALLY ADDED.                    *00290000
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02549'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S549 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE TBMODEL                                           00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBPREM                                            00980000
           END-EXEC.                                                    00990000
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRVDST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBMNHIST                                          00980000
           END-EXEC.                                                    00990000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBMNHDT                                           00980000
           END-EXEC.                                                    00990000
                                                                        
CVT999*    COPY SYGWCOB.                                                01500000
CVT999*    COPY SYDBCOB.                                                01510000
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
           COPY CWS00027.                                               01560000
CVT999*    COPY CWS00010.                                               01570000
                                                                        
           EXEC SQL                                                     01590000
              INCLUDE CWS00013                                          01600000
           END-EXEC.                                                    01610000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                         01840000
CVT999*    05  GWL-INIT-HANDLE         POINTER.                         01850000
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                  01860000
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  01870000
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  01880000
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  01890000
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  01900000
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  01910000
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9) COMP.                 
CVT999*    05  PARM-ID1                 PIC S9(9) COMP VALUE 1.         01980000
           05  PARM-PREMISE-NO          PIC X(10) VALUE SPACES.         
           05  PARM-REV-DISTRICT-CD     PIC X(03) VALUE SPACES.         
           05  PARM-USERID              PIC X(07) VALUE SPACES.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          02470000
                                                                        
CVT999*01  COUNTER-FIELDS.                                              02490000
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          02500000
CVT999*    05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          02510000
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  02540000
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                  02550000
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                  02560000
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(09) COMP VALUE +0.   
CVT999     05   S-RETURN-CODE               PIC S9(09) COMP VALUE +0.   
                                                                        
CVT999*01  CN-COLUMN-NAMES.                                             02660000
CVT999*    05  CN-RETURN-CODE          PIC X(11) VALUE 'RETURN_CODE'.   02670000
CVT999*                                                                 02710000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-TRANS-APPL-NO         PIC S9(04) COMP VALUE 0.        
           05  WS-PREMISE-NO-RED        PIC X(10).                      
           05  WS-PREMISE-NO            REDEFINES WS-PREMISE-NO-RED     
                                        PIC 9(10).                      
           05  PROGRAM-NAME             PIC X(08) VALUE 'S549    '.     
           05  WS-CURRENT-TS            PIC X(26).                      
           05  WS-REV-DISTRICT-CD       PIC X(03).                      
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-REV-DISTRICT-CD     PIC X(03)                .          
CVT000 01  LINK-USERID              PIC X(07)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-PREMISE-NO                                         
CVT000         ,LINK-REV-DISTRICT-CD                                    
CVT000         ,LINK-USERID                                             
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              04620000
                                                                        
      ******************************************************************04640000
      * 0000-MAINLINE                                                  *04650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04660000
      ******************************************************************04670000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04790000
      * 0100-INITIALIZE                                                *04800000
      *                                                                *04810000
      *     1. RESET DB2 ERROR HANDLERS                                *04820000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04830000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04840000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04850000
      *                                                                *04860000
      ******************************************************************04870000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              04900000
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              04910000
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              04920000
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     04940000
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     04960000
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.         04970000
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      04990000
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                             05010000
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                05020000
CVT999*       MOVE '0100'               TO ACTIVE-PARAGRAPH             05030000
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      05050000
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO TABLE-2             05051000
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        05060000
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            05070000
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            05080000
CVT999*    END-IF.                                                      05090000
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-REV-DISTRICT-CD      TO PARM-REV-DISTRICT-CD     . 
CVT000     MOVE LINK-USERID               TO PARM-USERID              . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05140000
      * 1000-PROCESS-INPUT.                                            *05150000
      *                                                                *05160000
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *05170000
      *     2.  FORMAT PACKED NUMERICS.                                *05180000
      *                                                                *05190000
      ******************************************************************05200000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS           THRU 1100-EXIT.         
           MOVE PARM-PREMISE-NO       TO WS-PREMISE-NO-RED.             
           MOVE WS-PREMISE-NO         TO PR-PREMISE-NO.                 
           MOVE PARM-REV-DISTRICT-CD  TO PR-REV-DISTRICT-CD.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05300000
      *   1100-RECEIVE-PARMS                                           *05310000
      *                                                                *05320000
      *     1.  RECEIVE PARMS FROM THE CLIENT.                         *05330000
      *                                                                *05340000
      ******************************************************************05350000
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                              TO PARM-ID1.             05380000
CVT999*    MOVE LENGTH OF PARM-PREMISE-NO      TO MAX-LENGTH-PARM,              
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              05800000
CVT999*                          GWL-RC,                                05810000
CVT999*                          PARM-ID1,                              05820000
CVT999*                          PARM-PREMISE-NO,                               
CVT999*                          TDSCHAR,                               05840000
CVT999*                          MAX-LENGTH-PARM,                       05850000
CVT999*                          PARM-L.                                05860000
                                                                        
CVT999*    ADD 1                                 TO PARM-ID1.           05380000
CVT999*    MOVE LENGTH OF PARM-REV-DISTRICT-CD   TO MAX-LENGTH-PARM,            
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              05800000
CVT999*                          GWL-RC,                                05810000
CVT999*                          PARM-ID1,                              05820000
CVT999*                          PARM-REV-DISTRICT-CD,                          
CVT999*                          TDSCHAR,                               05840000
CVT999*                          MAX-LENGTH-PARM,                       05850000
CVT999*                          PARM-L.                                05860000
                                                                        
CVT999*    ADD 1                               TO PARM-ID1.             09190000
CVT999*    MOVE LENGTH OF PARM-USERID          TO MAX-LENGTH-PARM,              
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-USERID,                                   
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09200000
      *   2000-PROCESS-OUTPUT                                          *09210000
      *                                                                *09220000
      *       1. DESCRIBE RESULT SET                                   *09230000
      *       2. RETRIEVE DB2 DATA                                     *09240000
      *       3. BUILD RESULT SET                                      *09250000
      *       4. SEND RESULT SET                                       *09260000
      *                                                                *09270000
      ******************************************************************09280000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT        THRU 2100-EXIT.          
                                                                        
           PERFORM 5000-BUILD-RESULT       THRU 5000-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      *   2100-DESCRIBE-RESULT                                         *09430000
      *                                                                *09440000
      *       1.  DESCRIBE EACH COLUMN IN THE RESULT SET.              *09450000
      *                                                                *09460000
      ******************************************************************09470000
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                   TO ACTIVE-PARAGRAPH.           
                                                                        
CVT999*    MOVE 1                        TO CTR-COLUMN.                 09510000
CVT999*    MOVE TDSINT4                  TO DB-HOST-TYPE.               09520000
CVT999*    MOVE TDSINT4                  TO DB-CLIENT-TYPE.             09530000
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                    09550000
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              09560000
CVT999*                          GWL-RC,                                09570000
CVT999*                          CTR-COLUMN,                            09580000
CVT999*                          DB-HOST-TYPE,                          09590000
CVT999*                          WRKLEN1,                               09600000
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                     09620000
CVT999*                          TDS-FALSE,                             09630000
CVT999*                          DB-CLIENT-TYPE,                        09640000
CVT999*                          WRKLEN1,                               09650000
CVT999*                          CN-RETURN-CODE,                        09660000
CVT999*                          WRKLEN2.                               09670000
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     09680000
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5000-BUILD-RESULT.                                               
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                INTO :WS-CURRENT-TS                                     
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP                                          
MFA-TR*         INTO :WS-CURRENT-TS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 5100-FORMAT-MH THRU 5100-EXIT.                       
           PERFORM 5200-UPDATE-REV-DIST THRU 5200-EXIT.                 
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-FORMAT-MH.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :MH-DATE-TRANS                                     
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE                                               
MFA-TR*         INTO :MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-CURRENT-TS            TO MH-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           PERFORM 7100-RESP-AREA        THRU 7100-EXIT.                
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE ZEROES                   TO MH-CUSTOMER-NO.             
           MOVE ZEROES                   TO MH-ACCOUNT-NO.              
           MOVE WS-PREMISE-NO            TO MH-PREMISE-NO.              
           MOVE PARM-USERID              TO MH-USER-ID.                 
           MOVE 'PANEL077'               TO MH-APPL-PROGRAM-ID.         
           MOVE 1                        TO WS-TRANS-APPL-NO.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-UPDATE-REV-DIST.                                            
                                                                        
           MOVE '5200'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7000-GET-REVENUE-DIST THRU 7000-EXIT.                
           PERFORM 8000-UPDATE-PREMISE THRU 8000-EXIT.                  
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
           MOVE WS-TRANS-APPL-NO       TO MI-TRAN-APPL-NO.              
           IF PR-REV-DISTRICT-CD NOT = WS-REV-DISTRICT-CD               
              MOVE WS-TRANS-APPL-NO        TO MI-TRAN-APPL-NO           
              IF PR-REV-DISTRICT-CD > SPACES                            
                 MOVE +35                  TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE PR-REV-DISTRICT-CD   TO A9-REV-DISTRICT-CD        
                 PERFORM 7200-SELECT-REV-DISTRICT THRU 7200-EXIT        
                 MOVE A9-REV-DISTRICT-DESC TO MI-CHG-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF WS-REV-DISTRICT-CD > SPACES                            
                 MOVE +35                  TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE WS-REV-DISTRICT-CD   TO A9-REV-DISTRICT-CD        
                 PERFORM 7200-SELECT-REV-DISTRICT THRU 7200-EXIT        
                 MOVE A9-REV-DISTRICT-DESC TO MI-PRV-COLUMN-VALUE-TEXT  
              ELSE                                                      
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'REV DISTRICT   ' TO MI-COLUMN-DESC                  
                                                                        
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
                                                                        
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-GET-REVENUE-DIST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT REV_DISTRICT_CD                                    
                INTO :WS-REV-DISTRICT-CD                                
                FROM CSS_PREMISE                                        
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-RESP-AREA.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = :PARM-USERID                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE PARM-USERID           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
       7200-SELECT-REV-DISTRICT.                                        
                                                                        
           EXEC SQL                                                     
              SELECT REV_DISTRICT_DESC                                  
                INTO :A9-REV-DISTRICT-DESC                              
                FROM CSS_REV_DISTRICT                                   
               WHERE REV_DISTRICT_CD = :A9-REV-DISTRICT-CD              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_REV_DISTRICT'    TO TABLE-1                     
              MOVE 'REV-DISTRICT-CD'     TO TABLE-ELEMENT-1             
              MOVE A9-REV-DISTRICT-CD    TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8000-UPDATE-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
                 SET REV_DISTRICT_CD = :PR-REV-DISTRICT-CD              
               WHERE PREMISE_NO      = :PR-PREMISE-NO                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_PREMISE'         TO TABLE-1                     
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-1             
              MOVE 'REV-DISTRICT-NO'     TO TABLE-ELEMENT-2             
              MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-1           
              MOVE PARM-REV-DISTRICT-CD  TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                     46890000
              INCLUDE CPDSP300                                          46900000
           END-EXEC.                                                    46910000
                                                                        
CVT999*    COPY CPD00302.                                               46960000
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
