       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02548.                                         
COB303 DATE-WRITTEN.     JUNE 2004.                                     
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S548 CONVERTED TO DB2 SP CSR02548 ON 06/15/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      ****             SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S548                                           *        
      *  PROGRAM:       S548                                           *        
      *  CALLING SP:    PA_S548                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM UPDATES THE MAINTANANCE TRANSACTION TABLES FOR   *        
      *  ANY UPADTES ON THE PANELS.                                    *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
C30702*  06/2004     MSR      PROGRAM INITIALLY WRITTEN.               *        
C30702*                                                                *        
A05317*  10/06/2016  FMB      FIX S0C7 ABEND.                          *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02548'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                   PIC X(40) VALUE                   
           'WORKING STORAGE FOR RPC S548 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_MNT_TRANS_HIST                                                   
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_MT_TRN_HST_DET.                                                  
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBMNHDT                                                    
           END-EXEC.                                                            
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
      *                                                                         
       01  WS-MISC.                                                     
           05  WS-CURRENT-DATE            PIC X(10)  VALUE SPACES.      
           05  WS-CURRENT-TIMESTAMP       PIC X(26)  VALUE SPACES.      
           05  WS-RESP-AREA-ID            PIC X(03)  VALUE SPACES.      
           05  WS-INPUT-DATA              PIC X(170) VALUE SPACES.      
           05  WS-PRV-COLUMN-VALUE-LEN    PIC X(02)  JUST RIGHT         
                                                     VALUE SPACES.      
           05  WS-CHG-COLUMN-VALUE-LEN    PIC X(02)  JUST RIGHT         
                                                     VALUE SPACES.      
       01  WS-LITERALS.                                                 
           05 WS-1                        PIC 9(01)  VALUE 1.           
           05 WS-DILIMITER                PIC X(01)  VALUE ';'.         
           05 PROGRAM-NAME                PIC X(08)  VALUE 'S548    '.  
           05  WS-CODE-TRAN-TYPE          PIC X(01)  VALUE 'F'.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01)  VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW               PIC X(01)  VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
      *                                                                 00052000
HPCCDM*    EJECT                                                        00096000
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                   POINTER.                              
CVT999*    05  GWL-INIT-HANDLE            POINTER.                              
CVT999*    05  GWL-RC                     PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-NR              PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-DONE            PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-COUNT           PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-COMM            PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-RETURN-CODE     PIC S9(9)   COMP.                     
           05  GWL-STATUS-SUBCODE         PIC S9(9)   COMP.             
      *                                                                         
       01  FILLER                         PIC X(11)  VALUE              
                                                    'PARM FIELDS'.      
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                     PIC S9(9)   COMP.             
CVT999*    05  PARM-ID1                   PIC S9(9)   COMP VALUE 1.             
           05  PARM-ACCOUNT-NO            PIC X(13)  VALUE SPACES.      
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO       
                                          PIC 9(13).                    
           05  PARM-CUSTOMER-NO           PIC X(10)  VALUE SPACES.      
           05  PARM-CUSTOMER-NO-RED      REDEFINES PARM-CUSTOMER-NO     
                                          PIC 9(10).                    
           05  PARM-PREMISE-NO            PIC X(10)  VALUE SPACES.      
           05  PARM-PREMISE-NO-RED      REDEFINES PARM-PREMISE-NO       
                                          PIC 9(10).                    
           05  PARM-USER-ID               PIC X(07)  VALUE SPACES.      
           05  PARM-APPL-PROGRAM-ID       PIC X(09)  VALUE SPACES.      
           05  PARM-TRANS-HIST-SEQ-NO     PIC X(26)  VALUE SPACES.      
           05  PARM-COMMENT-TEXT          PIC X(210) VALUE SPACES.      
           05  PARM-COMMENT-LEN           PIC S9(04) COMP VALUE ZEROS.  
           05  PARM-COLS-UPDT             PIC S9(04) COMP VALUE ZEROS.  
           05  PARM-COLUMN1               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN2               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN3               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN4               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN5               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN6               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN7               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN8               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN9               PIC X(170) VALUE SPACES.      
           05  PARM-COLUMN10              PIC X(170) VALUE SPACES.      
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9)   COMP.             
CVT999*    05  SNA-CONNECTION-NAME        PIC X(8)   VALUE SPACES.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                 PIC S9(9)   COMP                      
CVT999*                                              VALUE 1.                   
           05  CTR-ROWS                   PIC S9(9)   COMP              
                                                     VALUE 0.           
           05  WS-ROW-COUNT               PIC S9(9)   COMP              
                                                     VALUE 0.           
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM            PIC S9(9)   COMP.                     
CVT999*    05  WRKLEN1                    PIC S9(9)   COMP.                     
CVT999*    05  WRKLEN2                    PIC S9(9)   COMP.                     
           05  WRK-DONE-STATUS            PIC S9(9)   COMP.             
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE             PIC S9(9) COMP VALUE ZEROS.   
            05 RS-TRANS-HIST-SEQ-NO       PIC X(26)  VALUE SPACES.      
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE            PIC X(11)  VALUE                      
CVT999*                                         'RETURN_CODE'.                  
CVT999*     05 CNS-TRANS-HIST-SEQ-NO      PIC X(17)  VALUE                      
CVT999*                                         'TRANS_HIST_SEQ_NO'.            
CVT999*                                                                         
CVT999******************************************************************01014000
CVT999*                                                                *01015000
CVT999*  CURSOR DECLARATION FOR GETTING THE METER READ HISTORY FOR AN  *01016000
CVT999*  INSTALLATION.                                                 *01019000
CVT999******************************************************************01020000
CVT999*                                                                         
HPCCDM*    EJECT                                                        02620001
      *                                                                         
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-CUSTOMER-NO         PIC X(10)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-USER-ID             PIC X(07)                .          
CVT000 01  LINK-APPL-PROGRAM-ID     PIC X(09)                .          
CVT000 01  LINK-TRANS-HIST-SEQ-NO   PIC X(26)                .          
CVT000 01  LINK-COMMENT-TEXT        PIC X(210)               .          
CVT000 01  LINK-COMMENT-LEN         PIC S9(04) COMP          .          
CVT000 01  LINK-COLS-UPDT           PIC S9(04) COMP          .          
CVT000 01  LINK-COLUMN1             PIC X(170)               .          
CVT000 01  LINK-COLUMN2             PIC X(170)               .          
CVT000 01  LINK-COLUMN3             PIC X(170)               .          
CVT000 01  LINK-COLUMN4             PIC X(170)               .          
CVT000 01  LINK-COLUMN5             PIC X(170)               .          
CVT000 01  LINK-COLUMN6             PIC X(170)               .          
CVT000 01  LINK-COLUMN7             PIC X(170)               .          
CVT000 01  LINK-COLUMN8             PIC X(170)               .          
CVT000 01  LINK-COLUMN9             PIC X(170)               .          
CVT000 01  LINK-COLUMN10            PIC X(170)               .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-CUSTOMER-NO                                        
CVT000         ,LINK-PREMISE-NO                                         
CVT000         ,LINK-USER-ID                                            
CVT000         ,LINK-APPL-PROGRAM-ID                                    
CVT000         ,LINK-TRANS-HIST-SEQ-NO                                  
CVT000         ,LINK-COMMENT-TEXT                                       
CVT000         ,LINK-COMMENT-LEN                                        
CVT000         ,LINK-COLS-UPDT                                          
CVT000         ,LINK-COLUMN1                                            
CVT000         ,LINK-COLUMN2                                            
CVT000         ,LINK-COLUMN3                                            
CVT000         ,LINK-COLUMN4                                            
CVT000         ,LINK-COLUMN5                                            
CVT000         ,LINK-COLUMN6                                            
CVT000         ,LINK-COLUMN7                                            
CVT000         ,LINK-COLUMN8                                            
CVT000         ,LINK-COLUMN9                                            
CVT000         ,LINK-COLUMN10                                           
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
      *                                                                         
           IF  CTR-ROWS < 1                                             
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE +100                         TO RS-RETURN-CODE      
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                           TO ACTIVE-PARAGRAPH.   
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                  TO ABEND-PROGRAM               
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'            TO TABLE-1                     
CVT999*       MOVE GWL-RC                        TO                             
CVT999*                                           WS-ACTIVE-RETURN-CODE         
CVT999*       PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT                 
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT                 
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-TRANS-HIST-SEQ-NO        AS    TRANS_HIST_SEQ_NO      
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-TRANS-HIST-SEQ-NO        AS    TRANS_HIST_SEQ_NO              
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-APPL-PROGRAM-ID      TO PARM-APPL-PROGRAM-ID     . 
CVT000     MOVE LINK-TRANS-HIST-SEQ-NO    TO PARM-TRANS-HIST-SEQ-NO   . 
CVT000     MOVE LINK-COMMENT-TEXT         TO PARM-COMMENT-TEXT        . 
CVT000     MOVE LINK-COMMENT-LEN          TO PARM-COMMENT-LEN         . 
CVT000     MOVE LINK-COLS-UPDT            TO PARM-COLS-UPDT           . 
CVT000     MOVE LINK-COLUMN1              TO PARM-COLUMN1             . 
CVT000     MOVE LINK-COLUMN2              TO PARM-COLUMN2             . 
CVT000     MOVE LINK-COLUMN3              TO PARM-COLUMN3             . 
CVT000     MOVE LINK-COLUMN4              TO PARM-COLUMN4             . 
CVT000     MOVE LINK-COLUMN5              TO PARM-COLUMN5             . 
CVT000     MOVE LINK-COLUMN6              TO PARM-COLUMN6             . 
CVT000     MOVE LINK-COLUMN7              TO PARM-COLUMN7             . 
CVT000     MOVE LINK-COLUMN8              TO PARM-COLUMN8             . 
CVT000     MOVE LINK-COLUMN9              TO PARM-COLUMN9             . 
CVT000     MOVE LINK-COLUMN10             TO PARM-COLUMN10            . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
           PERFORM 1100-RECEIVE-PARMS            THRU 1100-EXIT.        
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
      ***** RECEIVING PARAMETER ACCOUNT NO                                      
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      ***** RECEIVING PARAMETER CUSTOMER NO                                     
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CUSTOMER-NO       TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CUSTOMER-NO,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      ***** RECEIVING PARAMETER PREMISE NO                                      
CVT999*    ADD 1                                 TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-PREMISE-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-PREMISE-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      ***** RECEIVING PARAMETER USER ID                                         
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-USER-ID           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-USER-ID,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      **** RECEIVING PARAMETER APPL PROGRAM ID                                  
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-APPL-PROGRAM-ID   TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-APPL-PROGRAM-ID,                          
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      **** RECEIVING PARAMETER TRANS HIST SEQ NO                                
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-TRANS-HIST-SEQ-NO TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-TRANS-HIST-SEQ-NO,                        
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER PARM COMMENT TEXT                                
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMMENT-TEXT      TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMMENT-TEXT,                             
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER PARM COMMENT LEN                                 
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMMENT-LEN       TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMMENT-LEN,                              
CVT999*                          TDSINT2,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLS UPDT                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLS-UPDT         TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLS-UPDT,                                
CVT999*                          TDSINT2,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN1                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN1           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN1,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN2                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN2           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN2,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN3                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN3           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN3,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN4                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN4           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN4,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN5                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN5           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN5,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN6                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN6           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN6,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN7                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN7           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN7,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN8                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN8           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN8,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN9                                          
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN9           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN9,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER COLUMN10                                         
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COLUMN10          TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COLUMN10,                                 
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      *                                                                         
       1100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT-IM                                 *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT-IM          THRU 2200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
      *                                                                         
           MOVE '2100'                           TO ACTIVE-PARAGRAPH.   
                                                                        
CVT999*    MOVE 1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSINT4                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSINT4                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-RETURN-CODE         TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE        TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
CVT999*    ADD 1                                 TO CTR-COLUMN.                 
CVT999*    MOVE TDSCHAR                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSCHAR                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-TRANS-HIST-SEQ-NO   TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-TRANS-HIST-SEQ-NO  TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRANS-HIST-SEQ-NO,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRANS-HIST-SEQ-NO,                         
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
      *                                                                         
       2100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    2200-BUILD-RESULT-IM                                        *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      ******************************************************************        
       2200-BUILD-RESULT-IM.                                            
      *                                                                         
           MOVE '2200'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2500-SET-MNT-TRANS-VARS       THRU 2500-EXIT.        
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * THIS PARA SETS VALUES TO MNT TRANS HIST TABLE VARIABLES.      *         
      *****************************************************************         
       2500-SET-MNT-TRANS-VARS.                                         
                                                                        
           MOVE '2500'                          TO ACTIVE-PARAGRAPH.    
           PERFORM 7000-GET-TIMESTMP            THRU 7000-EXIT.         
           PERFORM 7200-GET-RESP-AREA-ID        THRU 7200-EXIT.         
           IF PARM-TRANS-HIST-SEQ-NO > SPACES                           
              MOVE PARM-TRANS-HIST-SEQ-NO       TO MH-TRANS-HIST-SEQ-NO 
           ELSE                                                         
              MOVE WS-CURRENT-TIMESTAMP         TO MH-TRANS-HIST-SEQ-NO 
           END-IF.                                                      
           MOVE WS-CURRENT-DATE                 TO MH-DATE-TRANS.       
           MOVE WS-CODE-TRAN-TYPE               TO MH-CODE-TRAN-TYPE.   
           MOVE WS-RESP-AREA-ID                 TO MH-RESP-AREA-ID.     
           MOVE PARM-ACCOUNT-NO-RED             TO MH-ACCOUNT-NO.       
           MOVE PARM-CUSTOMER-NO-RED            TO MH-CUSTOMER-NO.      
           MOVE PARM-PREMISE-NO-RED             TO MH-PREMISE-NO.       
           MOVE PARM-USER-ID                    TO MH-USER-ID.          
           MOVE PARM-APPL-PROGRAM-ID            TO MH-APPL-PROGRAM-ID.  
           MOVE PARM-COMMENT-TEXT               TO MH-TRAN-COMMENT-TEXT.
           MOVE PARM-COMMENT-LEN                TO MH-TRAN-COMMENT-LEN. 
                                                                        
           IF PARM-TRANS-HIST-SEQ-NO > SPACES                           
              MOVE PARM-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO 
              PERFORM 7300-GET-TRN-APPL-NO      THRU 7300-EXIT          
           ELSE                                                         
              MOVE WS-CURRENT-TIMESTAMP         TO MI-TRANS-HIST-SEQ-NO 
              MOVE ZEROS                        TO MI-TRAN-APPL-NO      
           END-IF.                                                      
           MOVE SPACES                          TO MI-TABLE-ID.         
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN1                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN2                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN3                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN4                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN5                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN6                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN7                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN8                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN9                 TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           IF PARM-COLS-UPDT > 0                                        
              MOVE PARM-COLUMN10                TO WS-INPUT-DATA        
              PERFORM 2600-MOVE-TRN-HIST-DET    THRU 2600-EXIT          
              SUBTRACT WS-1                     FROM PARM-COLS-UPDT     
           END-IF.                                                      
           MOVE 0                               TO RS-RETURN-CODE.      
           MOVE MH-TRANS-HIST-SEQ-NO            TO RS-TRANS-HIST-SEQ-NO.
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
HPCCDM*EJECT                                                                    
                                                                        
       2500-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * THIS PARA SETS VALUES TO MNT TRANS HIST DET TABLE VARIABLES.  *         
      *****************************************************************         
       2600-MOVE-TRN-HIST-DET.                                          
                                                                        
           ADD WS-1                          TO MI-TRAN-APPL-NO.        
           UNSTRING WS-INPUT-DATA                                       
           DELIMITED BY WS-DILIMITER                                    
           INTO MI-COLUMN-DESC                                          
                MI-PRV-COLUMN-VALUE-TEXT                                
                WS-PRV-COLUMN-VALUE-LEN                                 
                MI-CHG-COLUMN-VALUE-TEXT                                
                WS-CHG-COLUMN-VALUE-LEN.                                
A05317     INSPECT WS-PRV-COLUMN-VALUE-LEN REPLACING                    
A05317         ALL LOW-VALUES BY ' '.                                   
A05317     INSPECT WS-CHG-COLUMN-VALUE-LEN REPLACING                    
A05317         ALL LOW-VALUES BY ' '.                                   
           INSPECT WS-PRV-COLUMN-VALUE-LEN REPLACING LEADING SPACES     
                   BY ZEROS.                                            
           INSPECT WS-CHG-COLUMN-VALUE-LEN REPLACING LEADING SPACES     
                   BY ZEROS.                                            
           MOVE WS-PRV-COLUMN-VALUE-LEN      TO MI-PRV-COLUMN-VALUE-LEN.
           MOVE WS-CHG-COLUMN-VALUE-LEN      TO MI-CHG-COLUMN-VALUE-LEN.
           PERFORM 6530-LOAD-MNT-TRANS-HIST      THRU 6530-EXIT.        
           MOVE SPACES                       TO WS-INPUT-DATA.          
HPCCDM*EJECT                                                                    
                                                                        
       2600-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      *****************************************************************         
      ** SELECT CURRENT TIME STAMP                                   **         
      *****************************************************************         
       7000-GET-TIMESTMP.                                               
      *                                                                 05910000
           EXEC SQL                                                     
                SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                      ,CAST(SYSDATETIMEOFFSET() AS DATE)                        
                  INTO :WS-CURRENT-TIMESTAMP                            
                      ,:WS-CURRENT-DATE                                 
                  FROM CSS_MODEL_SQL                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     05920000
MFA-TR*         SELECT CURRENT TIMESTAMP                                05930000
MFA-TR*               ,CURRENT DATE                                             
MFA-TR*           INTO :WS-CURRENT-TIMESTAMP                            05940000
MFA-TR*               ,:WS-CURRENT-DATE                                         
MFA-TR*           FROM CSS_MODEL_SQL                                    05950000
MFA-TR*    END-EXEC.                                                    05960000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 05970000
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
      *                                                                 05970000
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7000'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_MODEL_SQL'      TO TABLE-1                     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
HPCCDM*EJECT                                                                    
      *                                                                 06060000
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************18100000
      * 7200 GET RESP AREA ID                                          *18110000
      *      -- THIS MODULE FINDS THE RESPONSIBLE AREA IDENTIFICATION  *18120000
      *         ACCORDING TO A USERS ID.                               *18130000
      ******************************************************************18140000
       7200-GET-RESP-AREA-ID.                                           
      *                                                                 18160000
           EXEC SQL                                                     
               SELECT RESP_AREA_ID                                      
                 INTO :WS-RESP-AREA-ID                                  
                 FROM CSS_USER_PROFILE                                  
                WHERE USER_ID = :PARM-USER-ID                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18230000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_USER_PROFILE  '  TO TABLE-1                    
               MOVE 'USER_ID'             TO TABLE-ELEMENT-1            
               MOVE PARM-USER-ID          TO HOSTVAR-ELEMENT-1          
               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2            
               MOVE PARM-PREMISE-NO-RED   TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18390000
        7200-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************18100000
      * 7300 GET TRN APPL NO                                           *18110000
      *      -- THIS MODULE GETS THE MAX TRAN APPL NO FROM TRANS DET   *18120000
      *         TABLE.                                                 *18130000
      ******************************************************************18140000
       7300-GET-TRN-APPL-NO.                                            
      *                                                                 18160000
           EXEC SQL                                                     
               SELECT MAX(TRAN_APPL_NO)                                 
                 INTO :MI-TRAN-APPL-NO                                  
                 FROM CSS_MT_TRN_HST_DET                                
                WHERE TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :MI-TRANS-HIST-SEQ-NO
              )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     18170000
MFA-TR*        SELECT MAX(TRAN_APPL_NO)                                 18180000
MFA-TR*          INTO :MI-TRAN-APPL-NO                                  18190000
MFA-TR*          FROM CSS_MT_TRN_HST_DET                                18200000
MFA-TR*         WHERE TRANS_HIST_SEQ_NO = :MI-TRANS-HIST-SEQ-NO         18210000
MFA-TR*    END-EXEC.                                                    18220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 18230000
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7300'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_MT_TRN_HST_DET'  TO TABLE-1                    
               MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-1            
               MOVE MI-TRANS-HIST-SEQ-NO  TO HOSTVAR-ELEMENT-1          
               MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-2            
               MOVE PARM-PREMISE-NO-RED   TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 18390000
        7300-EXIT.                                                      
            EXIT.                                                       
      *                                                                         
      ******************************************************************        
      *    COPY BOOK FOR MNT TRANSACTION HIST TABLE.                   *        
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE CPD00067                                                 
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
