       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02544.                                         
COB303 DATE-WRITTEN.      OCTOBER 9, 2003.                              
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S544 CONVERTED TO DB2 SP CSR02544 ON 06/15/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:     S544                                              *        
      *  PROGRAM:    S544                                              *        
      *  CALLING SP: PA_S544                                           *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE RETRIEVES THE METER READ INSTRUCTIONS          *        
      *  DESCRIPTION THAT WILL BE SENT TO CAD AND PRINTED ON THE       *        
      *  ORDER.                                                        *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/09/03    AF       PROCEDURE ORIGINALLY CODED.              *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02544'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S544 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRINS                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                   POINTER.                              
CVT999*    05  GWL-INIT-HANDLE            POINTER.                              
CVT999*    05  GWL-RC                     PIC S9(9) COMP.                       
CVT999*    05  GWL-STATUS-NR              PIC S9(9) COMP.                       
CVT999*    05  GWL-STATUS-DONE            PIC S9(9) COMP.                       
CVT999*    05  GWL-STATUS-COUNT           PIC S9(9) COMP.                       
CVT999*    05  GWL-STATUS-COMM            PIC S9(9) COMP.                       
CVT999*    05  GWL-STATUS-RETURN-CODE     PIC S9(9) COMP.                       
           05  GWL-STATUS-SUBCODE         PIC S9(9) COMP.               
                                                                        
       01  FILLER                         PIC X(11) VALUE 'PARM FIELDS'.
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                     PIC S9(9) COMP.               
CVT999*    05  PARM-ID1                   PIC S9(9) COMP VALUE 0.               
           05  PARM-ACCOUNT-NO            PIC X(13) VALUE SPACES.       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9) COMP.               
CVT999*    05  SNA-CONNECTION-NAME        PIC X(8)  VALUE SPACES.               
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                 PIC S9(9) COMP VALUE 0.               
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM            PIC S9(9) COMP.                       
CVT999*    05  WRKLEN1                    PIC S9(9) COMP.                       
CVT999*    05  WRKLEN2                    PIC S9(9) COMP.                       
           05  WRK-DONE-STATUS            PIC S9(9) COMP.               
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE             PIC S9(09) COMP VALUE 0.      
           05  RS-MTR-RD-INSTR-DESC       PIC X(14) VALUE SPACES.       
                                                                        
CVT999*01  CN-COLUMN-NAMES.                                                     
CVT999*    05  CNS-RETURN-CODE          PIC X(11)                               
CVT999*                                 VALUE 'RETURN_CODE'.                    
CVT999*    05  CNS-MTR-RD-INSTR-DESC    PIC X(17)                               
CVT999*                                 VALUE 'MTR_RD_INSTR_DESC'.              
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
                                                                        
       01  WS-PROGRAM-NAME.                                             
           05  PROGRAM-NAME               PIC X(08) VALUE 'S544    '.   
                                                                        
       01  STORAGE-FIELDS.                                              
           05  WS-PARM-FIELDS.                                          
               10 WS-ACCOUNT-NO.                                        
                  11 WS-ACCOUNT-NO-N      PIC S9(13)V.                  
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < CURSOR FOR CSS_MTRD_ENVRNMT >                                      
                                                                        
           EXEC SQL DECLARE MTR-RD-INST-CURSOR CURSOR FOR               
               SELECT B.MTR_RD_INSTR_DESC                               
                 FROM CSS_MTRD_ENVRNMT A ,                              
                      CSS_MTR_RD_INST B                                 
                WHERE A.ACCOUNT_NO        = :MN-ACCOUNT-NO              
                  AND A.CODE_MTR_RD_INST1 > ''                          
                  AND A.CODE_MTR_RD_INST1 = B.CODE_MTR_RD_INST          
           END-EXEC.                                                    
                                                                        
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT *                                                 
CVT000         FROM #CSR02544_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT *                                                 00000400
MFA-TR*        FROM SESSION.CSR02544_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                 THRU 0100-EXIT.      
           PERFORM 1000-PROCESS-INPUT              THRU 1000-EXIT.      
           PERFORM 2000-PROCESS-OUTPUT             THRU 2000-EXIT.      
           PERFORM 9999-END-PROGRAM                THRU 9999-EXIT.      
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT' USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.               
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*        MOVE PROGRAM-NAME                   TO ABEND-PROGRAM             
CVT999*        MOVE '0100'                         TO ACTIVE-PARAGRAPH          
CVT999*        MOVE 'TDRESULT - NO RPC PARM SENT'  TO ABEND-FUNCTION            
CVT999*        MOVE 'CICS TRANSACTION'             TO TABLE-1                   
CVT999*        MOVE GWL-RC                     TO WS-ACTIVE-RETURN-CODE         
CVT999*        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT                 
CVT999*        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT                 
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02544_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02544_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,MTR_RD_INSTR_DESC CHAR(14)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *     2. ASSIGNS PARMS TO WORKING STORAGE.                       *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS            THRU 1100-EXIT.        
           PERFORM 1150-ASSIGN-VARS              THRU 1150-EXIT.        
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *                                                                *        
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *        
      *                                                                *        
      ******************************************************************        
       1100-RECEIVE-PARMS.                                              
      *-------------< ACCOUNT_NO         >                                      
CVT999*    ADD  1                             TO PARM-ID1.                      
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO     TO MAX-LENGTH-PARM,               
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1150 ASSIGN-VARS                                               *        
      *     -- THIS MODULE MOVES THE PASSED IN PARAMETER VALUES AND    *        
      *        MOVES THEM INTO WORKING STORAGE VARIABLES.  THEN,       *        
      *        THESE WORKING STORAGE VARIABLES ARE MOVED INTO THEIR    *        
      *        RESPECTIVE REDEFINED FIELDS FOR COMPLETING THE SQL      *        
      *        SELECT STATEMENTS.                                      *        
      ******************************************************************        
       1150-ASSIGN-VARS.                                                
                                                                        
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO-N       TO MN-ACCOUNT-NO.                 
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. RETRIVE DB2 DATA                                        *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT            THRU 2100-EXIT.      
           PERFORM 2300-BUILD-RESULT               THRU 2300-EXIT.      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *                                                                *        
      ******************************************************************        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'                       TO ACTIVE-PARAGRAPH.       
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                    TO CTR-COLUMN.              
CVT999*    MOVE TDSCHAR                             TO DB-HOST-TYPE.            
CVT999*    MOVE TDSCHAR                             TO DB-CLIENT-TYPE.          
CVT999*    MOVE LENGTH OF RS-MTR-RD-INSTR-DESC      TO WRKLEN1.                 
CVT999*    MOVE LENGTH OF CNS-MTR-RD-INSTR-DESC      TO WRKLEN2.                
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MTR-RD-INSTR-DESC,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MTR-RD-INSTR-DESC,                         
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     MAJOR PROCESSING LOOP.                                     *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7100-OPEN-MTR-RD-INST-CURSOR    THRU 7100-EXIT.      
           PERFORM 7200-FETCH-MTR-RD-INST-CURSOR   THRU 7200-EXIT.      
           PERFORM 7300-CLOSE-MTR-RD-INST-CURSOR   THRU 7300-EXIT.      
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               PERFORM 8100-SEND-RESULT      THRU 8100-EXIT             
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2350-INITIALIZE-RETURN-FIELDS                                  *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      ******************************************************************        
       2350-INITIALIZE-RETURN-FIELDS.                                   
                                                                        
           MOVE '2350'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           INITIALIZE    RS-RETURN-CODE.                                
                                                                        
           MOVE SPACES                   TO RS-MTR-RD-INSTR-DESC.       
                                                                        
       2350-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  7100-OPEN-MTR-RD-INST-CURSOR                                 *         
      *                                                                *        
      ******************************************************************        
       7100-OPEN-MTR-RD-INST-CURSOR.                                    
                                                                        
           MOVE '7100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              OPEN MTR-RD-INST-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'CSS_MTR_RD_INST'          TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  7200-FETCH-MTR-RD-INST-CURSOR                                *         
      *                                                                *        
      ******************************************************************        
       7200-FETCH-MTR-RD-INST-CURSOR.                                   
                                                                        
           MOVE '7200'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH MTR-RD-INST-CURSOR                                  
              INTO :Q5-MTR-RD-INSTR-DESC                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
              WHEN SUCCESSFUL-CALL                                      
                 MOVE Q5-MTR-RD-INSTR-DESC     TO RS-MTR-RD-INSTR-DESC  
                 PERFORM 8100-SEND-RESULT      THRU 8100-EXIT           
                 PERFORM 2350-INITIALIZE-RETURN-FIELDS THRU 2350-EXIT   
              WHEN NOT-FOUND                                            
                 GO TO 7200-EXIT                                        
              WHEN OTHER                                                
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
                 MOVE 'FETCH'                    TO ABEND-FUNCTION      
                 MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1             
                 MOVE 'CSS_MTR_RD_INST'          TO TABLE-2             
                 MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1     
                 MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1   
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
           END-EVALUATE.                                                
                                                                        
           GO TO 7200-FETCH-MTR-RD-INST-CURSOR.                         
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      *  7300-CLOSE-MTR-RD-INST-CURSOR                                *         
      *                                                                *        
      ******************************************************************        
       7300-CLOSE-MTR-RD-INST-CURSOR.                                   
                                                                        
           MOVE '7300'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              CLOSE MTR-RD-INST-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
              MOVE 'CSS_MTR_RD_INST'          TO TABLE-2                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE WS-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
      ******************************************************************        
      * 9999- END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02544_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,MTR_RD_INSTR_DESC                                         
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-MTR-RD-INSTR-DESC                                     
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02544_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,MTR_RD_INSTR_DESC                                                 
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-MTR-RD-INSTR-DESC                                             
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02544_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02544_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02544_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
