       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02541.                                         
COB303 DATE-WRITTEN.     MAY  15, 2003.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S541 CONVERTED TO DB2 SP CSR02541 ON 03/30/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S541                                           *        
      *  PROGRAM:       S541                                           *        
      *  CALLING SP:    PA_S541                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES EITHER THE AGL ACCOUNT OR SEB ACCOUNT  *        
      *  DEPENDING ON WHAT IS SENT.                                    *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  05/20/03  MJG        PROCEDURE ORIGINALLY CODED               *        
A37666*  05/15/10  SJ97149    ADDING AGL_DIST_ACCT_NO FROM HST_ACCOUNT *        
A37666*            ACT071     TABLE FOR ARCHIVED ACCOUNTS FOR ACCOUNT  *        
A37666*                       NO COPY FOR SEB.                         *        
A04527*  06/06/13  MC95456    REMOVED UNUSED COPY BOOK CWS00056        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02541'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S541 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMRKXR                                                  
           END-EXEC.                                                            
                                                                        
A37666*    HST_ACCOUNT - HA                                                     
A37666     EXEC SQL                                                             
A37666        INCLUDE TBHACCT                                                   
A37666     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
       01  WS-MISC.                                                     
           05 WS-D                     PIC X(01) VALUE 'D'.             
           05 WS-E                     PIC X(01) VALUE 'E'.             
           05  WS-FOUR                 PIC X(1)  VALUE '4'.             
           05 WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
           05 WS-DUMMY-DATE            PIC X(10) VALUE SPACES.          
           05 WS-TIME                  PIC X(08) VALUE SPACES.          
           05 WS-DATE                  PIC X(10) VALUE SPACES.          
           05 WS-SUB                   PIC 9(02) VALUE 1.               
           05 WS-NULL-IND-DATE         PIC S9(04) COMP.                 
           05 WS-NULL-IND-TIME         PIC S9(04) COMP.                 
           05 WS-NULL-DUMMY-IND        PIC S9(04) COMP.                 
           05 PROGRAM-NAME             PIC X(8)  VALUE 'S541    '.      
      *                                                                         
       01  SWITCHES.                                                    
           05  WS-MST-SUB-ACCT-IND     PIC X(01) VALUE SPACES.          
               88 MASTER-ACCOUNT                 VALUE 'M'.             
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
HPCCDM*    EJECT                                                        00096000
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-SELECT-TYPE        PIC X(03).                       
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO            
                                       PIC 9(13).                       
           05  PARM-AGL-ACCT-NO        PIC X(20).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
CVT999*    05  CTR-ROWS                PIC S9(9) COMP VALUE 0.                  
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE           PIC S9(9) COMP  VALUE 0.        
            05  S-RETURN-CODE           PIC S9(9) COMP  VALUE 0.        
            05 RS-ACCOUNT-NO            PIC X(13)       VALUE SPACES.   
            05 RS-AGL-ACCT-NO           PIC X(20)       VALUE SPACES.   
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE          PIC X(11) VALUE 'RETURN_CODE'.          
CVT999*     05 CNS-ACCOUNT-NO   PIC X(11) VALUE 'ACCOUNT-NO'.                   
CVT999*     05 CNS-AGL-ACCT-NO  PIC X(11) VALUE 'AGL-ACCT-NO'.                  
CVT999******************************************************************        
CVT999*    CURSOR DECLARATIONS                                         *        
CVT999******************************************************************        
CVT999*                                                                         
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-SELECT-TYPE         PIC X(03)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-AGL-ACCT-NO         PIC X(20)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-SELECT-TYPE                                        
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-AGL-ACCT-NO                                        
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-ACCOUNT-NO               AS    ACCOUNT_NO             
CVT000       ,:RS-AGL-ACCT-NO              AS    AGL_ACCT_NO            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-ACCOUNT-NO               AS    ACCOUNT_NO                     
MFA-TR*      ,:RS-AGL-ACCT-NO              AS    AGL_ACCT_NO                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-SELECT-TYPE          TO PARM-SELECT-TYPE         . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-AGL-ACCT-NO          TO PARM-AGL-ACCT-NO         . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-SELECT-TYPE       TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-SELECT-TYPE,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO    TO MAX-LENGTH-PARM.                
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-AGL-ACCT-NO    TO MAX-LENGTH-PARM.               
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-AGL-ACCT-NO,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLS 2110-DESC-RET-CODE                                  *         
      *           2140-DESC-CD-DATA                                   *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2110'                             TO ACTIVE-PARAGRAPH. 
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                   TO CTR-COLUMN.               
CVT999*    MOVE TDSCHAR                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSCHAR                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-ACCOUNT-NO            TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-ACCOUNT-NO          TO WRKLEN2.                   
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCOUNT-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACCOUNT-NO,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                   TO CTR-COLUMN.               
CVT999*    MOVE TDSCHAR                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSCHAR                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-AGL-ACCT-NO           TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-AGL-ACCT-NO          TO WRKLEN2.                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-AGL-ACCT-NO,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-AGL-ACCT-NO,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'               TO ACTIVE-PARAGRAPH.               
           IF PARM-SELECT-TYPE = 'AGL'                                  
              MOVE PARM-ACCOUNT-NO-NUM TO XM-ACCOUNT-NO                 
              PERFORM 7000-SELECT-AGL-ACCT THRU 7000-EXIT               
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE PARM-ACCOUNT-NO-NUM   TO RS-ACCOUNT-NO            
                 MOVE XM-DIST-ACCT-NO       TO RS-AGL-ACCT-NO           
              END-IF                                                    
A37666        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
A37666           MOVE PARM-ACCOUNT-NO-NUM      TO HA-ACCOUNT-NO         
A37666           PERFORM 7100-SELECT-HST-AGL-ACCT THRU 7100-EXIT        
A37666           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL         
A37666              MOVE PARM-ACCOUNT-NO-NUM   TO RS-ACCOUNT-NO         
A37666              MOVE HA-DIST-ACCT-NO       TO RS-AGL-ACCT-NO        
A37666           END-IF                                                 
A37666        END-IF                                                    
           ELSE                                                         
              MOVE PARM-AGL-ACCT-NO    TO XM-DIST-ACCT-NO               
              PERFORM 7050-SELECT-SEB-ACCT THRU 7050-EXIT               
              IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL            
                 MOVE XM-DIST-ACCT-NO  TO RS-AGL-ACCT-NO                
                 MOVE XM-ACCOUNT-NO    TO RS-ACCOUNT-NO                 
              END-IF                                                    
           END-IF.                                                      
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      *   7000-SELECT-AGL-ACCT.                                        *        
      *                                                                *        
      *   1. SELECT NEW ACCOUNT NO                                              
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-SELECT-AGL-ACCT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT DIST_ACCT_NO                                       
              INTO   :XM-DIST-ACCT-NO                                   
              FROM   CSS_MKT_XREF_ACCT WITH(READUNCOMMITTED)                    
              WHERE  ACCOUNT_NO   = :XM-ACCOUNT-NO                      
A37666                                                           
A37666                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DIST_ACCT_NO                                               
MFA-TR*       INTO   :XM-DIST-ACCT-NO                                           
MFA-TR*       FROM   CSS_MKT_XREF_ACCT                                          
MFA-TR*       WHERE  ACCOUNT_NO   = :XM-ACCOUNT-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS__MKT_XREF_ACCT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE XM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *   7050-SELECT-SEB-ACCT.                                        *        
      *                                                                *        
      *   1. SELECT SEB ACCOUNT NO                                              
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7050-SELECT-SEB-ACCT.                                            
                                                                        
           EXEC SQL                                                     
              SELECT ACCOUNT_NO                                         
              INTO :XM-ACCOUNT-NO                                       
              FROM  CSS_MKT_XREF_ACCT WITH(READUNCOMMITTED)                     
              WHERE DIST_ACCT_NO   = :XM-DIST-ACCT-NO                   
A37666                                                           
A37666                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*       INTO :XM-ACCOUNT-NO                                               
MFA-TR*       FROM  CSS_MKT_XREF_ACCT                                           
MFA-TR*       WHERE DIST_ACCT_NO   = :XM-DIST-ACCT-NO                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7050                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE SQLCODE TO RS-RETURN-CODE.                              
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7050'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MKT_XREF_ACCT'   TO TABLE-1                     
              MOVE 'DIST_ACCT_NO'        TO TABLE-ELEMENT-1             
              MOVE XM-DIST-ACCT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
A37666******************************************************************        
A37666*  7100-SELECT-HST-AGL-ACCT                                      *        
A37666*                                                                *        
A37666*   1. SELECT AGL_DIST_ACCT_NO FOR ARCHIVED ACCOUNTS                      
A37666*                                                                *        
A37666******************************************************************        
A37666                                                                  
A37666 7100-SELECT-HST-AGL-ACCT.                                        
A37666                                                                  
A37666     EXEC SQL                                                     
A37666        SELECT DIST_ACCT_NO                                       
A37666        INTO   :HA-DIST-ACCT-NO                                   
A37666        FROM   HST_ACCOUNT HA WITH(READUNCOMMITTED)                       
A37666        WHERE  HA.ACCOUNT_NO   = :HA-ACCOUNT-NO                   
A37666                                                           
A37666                                                      
A37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT DIST_ACCT_NO                                               
MFA-TR*       INTO   :HA-DIST-ACCT-NO                                           
MFA-TR*       FROM   HST_ACCOUNT HA                                             
MFA-TR*       WHERE  HA.ACCOUNT_NO   = :HA-ACCOUNT-NO                           
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7100                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A37666                                                                  
A37666     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A37666     MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
A37666                                                                  
A37666     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
A37666        NEXT SENTENCE                                             
A37666     ELSE                                                         
A37666        MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
A37666        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
A37666        MOVE '7100'                     TO ACTIVE-PARAGRAPH       
A37666        MOVE 'SELECT'                   TO ABEND-FUNCTION         
A37666        MOVE SPACES                     TO ABEND-SQL-PREDICATES   
A37666                                           ABEND-TABLES           
A37666        MOVE 'HST_ACCOUNT'              TO TABLE-1                
A37666        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
A37666        MOVE HA-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
A37666        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A37666        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A37666     END-IF.                                                      
A37666                                                                  
A37666 7100-EXIT.                                                       
A37666     EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
