       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02539.                                         
COB303 DATE-WRITTEN.                                                    
COB303            JANUARY 27, 2003.                                     
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S539 CONVERTED TO DB2 SP CSR02539 ON 07/27/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      *****************************************************************         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).            
C25730*  THIS RPC IS ALSO CALLED FROM SECURITIES PANEL 057.                     
      *                                                                         
      *  TRANID:        S539                                                    
      *  PROGRAM:       S539                                                    
      *  CALLING SP:    PA_S539                                                 
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM                      
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                                
      *                                                                         
      *  THIS PROGRAM UPDATES MAXIMUM DEPOSIT REVIEW FIELDS FOUND               
      *  ON CSS_ACCOUNT AND CSS_MAX_DEP_REVIEW.                                 
      *                                                                         
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  01/27/03    MJ       CREATED.                                 *        
REARCH*  07/27/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
T35434*  10/31/07   MK92804   REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED 'WITH UR' FOR SINGLETON SELECTS*        
      ******************************************************************        
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02539'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02539 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    DB2 INCLUDES                                                         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBDEPREV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
                                                                        
CVT999*COPY SYGWCOB.                                                            
CVT999*COPY SYDBCOB.                                                            
       COPY CCA00001.                                                           
CVT999*COPY CWS00010.                                                           
       COPY CWS00027.                                                           
       COPY CWS00303.                                                           
                                                                        
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02539'.     
           05  WS-LAST-MAX-AT-REV-DT    PIC X(10) VALUE SPACES.         
           05  WS-MAX-DEP-REFUND-CD     PIC X(01) VALUE SPACES.         
           05  WS-MAX-DEP-REF-XMT-CD    PIC X(01) VALUE SPACES.         
           05  WS-TRAN-APPL-NO          PIC 9(02) VALUE 0.              
           05  WS-TRAN-COMMENT-LEN      PIC 9(4) VALUE 0.               
           05  WS-TRAN-COMMENT-LEN-NUM  PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-TRAN-COMMENT-TEXT     PIC X(210) VALUE SPACES.        
           05  WS-COMMENT-LEN           PIC 9(4) VALUE 0.               
           05  WS-COMMENTS.                                             
               49  WS-COMMENT-LEN-NUM   PIC S9(4) USAGE COMP.           
               49  WS-COMMENT-TEXT      PIC X(72).                      
           05  WS-AMT-DISPLAY           PIC $$$$$$$$$9.9(2).            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-A                     PIC X(01) VALUE 'A'.            
           05  WS-B                     PIC X(01) VALUE 'B'.            
           05  WS-P                     PIC X(01) VALUE 'P'.            
           05  WS-R                     PIC X(01) VALUE 'R'.            
           05  WS-55                    PIC X(02) VALUE '55'.           
           05  WS-56                    PIC X(02) VALUE '56'.           
           05  WS-DATE-NI               PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-NULL-IND              PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-POINTER               PIC S9(3) COMP-3 VALUE ZERO.    
           05  WS-TEMP-TEXT             PIC X(72).                      
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  WS-MAX-DEP-SW            PIC X(01) VALUE 'N'.            
               88 MAX-DEP-DOES-NOT-EXIST          VALUE 'N'.            
               88 MAX-DEP-DOES-EXIST              VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  EXISTS-SW                PIC X(01) VALUE 'N'.            
               88 EXISTS-YES                      VALUE 'Y'.            
               88 EXISTS-NO                       VALUE 'N'.            
           05  UPDATE-MAX-DEP-SW        PIC X(01) VALUE 'N'.            
               88 UPDATE-MAX-DEP                  VALUE 'Y'.            
           05  UPDATE-ACCOUNT-SW        PIC X(01) VALUE 'N'.            
               88 UPDATE-ACCOUNT                  VALUE 'Y'.            
                                                                        
       01  WS-ACCOUNT-NO-REDEFINITION.                                  
           05  WS-ACCOUNT              PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT                      
                                       PIC 9(13).                       
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.        
      *                                                                 02990000
      ******************************************************************        
      * WORKING STORAGE FOR JOURNALING                                 *        
      ******************************************************************        
       01  MNT-TRANSACTION-STORAGE.                                     
           05  CURRENT-TIMESTAMP       PIC X(26).                       
           05  CURRENT-DATE            PIC X(10).                       
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
CVT999*    05  GWL-PROC                 POINTER.                                
CVT999*    05  GWL-INIT-HANDLE          POINTER.                                
CVT999*    05  GWL-RC                   PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
CVT999*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                         
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-USER-ID            PIC X(7).                        
           05  PARM-ACTION-CODE        PIC X(1).                        
           05  PARM-ACCOUNT-NO         PIC X(13).                       
*********  05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO                
*********                              PIC 9(13).                               
           05  PARM-LAST-MAX-AT-REV-DT PIC X(10) VALUE SPACES.          
           05  PARM-MAX-DEP-AT-REV-AM  PIC X(13) VALUE SPACES.          
********** 05  PARM-MAX-DEP-REV-AMT-NU REDEFINES PARM-MAX-DEP-AT-REV-AM         
**********                             PIC 9(11)V9(2).                          
           05  PARM-PD-DEP-AT-REV-AM   PIC X(13) VALUE SPACES.          
********** 05  PARM-PD-DEP-REV-AM-NU   REDEFINES PARM-PD-DEP-AT-REV-AM          
**********                             PIC 9(11)V9(2).                          
           05  PARM-MAX-DEP-REFUND-CD  PIC X(01) VALUE SPACES.          
           05  PARM-MAX-DEP-REF-XMT-CD PIC X(01) VALUE SPACES.          
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-MAX-DEP-AT-REV-C      PIC X(13).                      
           05  WS-MAX-DEP-AT-REV-N REDEFINES WS-MAX-DEP-AT-REV-C        
                                        PIC 9(11)V99.                   
COB305     05 WS-MAX-DEP-AT-REV-AM        PIC S9(11)V99 COMP-3 VALUE 0.         
           05  WS-PD-DEP-AT-REV-C       PIC X(13).                      
           05  WS-PD-DEP-AT-REV-N  REDEFINES WS-PD-DEP-AT-REV-C         
                                        PIC 9(11)V99.                   
COB305     05 WS-PD-DEP-AT-REV-AM        PIC S9(11)V99 COMP-3 VALUE 0.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
                                                                        
CVT999*01  CN-COLUMN-NAMES.                                                     
CVT999*    05  CN-RETURN-CODE  PIC X(11) VALUE 'RETURN_CODE'.                   
CVT999*                                                                         
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-USER-ID             PIC X(7)                 .          
CVT000 01  LINK-ACTION-CODE         PIC X(1)                 .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-LAST-MAX-AT-REV-DT  PIC X(10)                .          
CVT000 01  LINK-MAX-DEP-AT-REV-AM   PIC X(13)                .          
CVT000 01  LINK-PD-DEP-AT-REV-AM    PIC X(13)                .          
CVT000 01  LINK-MAX-DEP-REFUND-CD   PIC X(01)                .          
CVT000 01  LINK-MAX-DEP-REF-XMT-CD  PIC X(01)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-USER-ID                                            
CVT000          LINK-ACTION-CODE                                        
CVT000          LINK-ACCOUNT-NO                                         
CVT000          LINK-LAST-MAX-AT-REV-DT                                 
CVT000          LINK-MAX-DEP-AT-REV-AM                                  
CVT000          LINK-PD-DEP-AT-REV-AM                                   
CVT000          LINK-MAX-DEP-REFUND-CD                                  
CVT000          LINK-MAX-DEP-REF-XMT-CD                                 
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
REARCH*    PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                          
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. RESET DB2 ERROR HANDLERS                                         
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                           
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)            
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)         
      *                                                                         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH           :S-RETURN-CODE              AS    RETURN_CODE          
REARCH       FROM CIS.SYSDUMMY1                                      
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*          :S-RETURN-CODE              AS    RETURN_CODE                  
MFA-TR*      FROM SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-ACTION-CODE          TO PARM-ACTION-CODE         . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-LAST-MAX-AT-REV-DT   TO PARM-LAST-MAX-AT-REV-DT  . 
CVT000     MOVE LINK-MAX-DEP-AT-REV-AM    TO PARM-MAX-DEP-AT-REV-AM   . 
CVT000     MOVE LINK-PD-DEP-AT-REV-AM     TO PARM-PD-DEP-AT-REV-AM    . 
CVT000     MOVE LINK-MAX-DEP-REFUND-CD    TO PARM-MAX-DEP-REFUND-CD   . 
CVT000     MOVE LINK-MAX-DEP-REF-XMT-CD   TO PARM-MAX-DEP-REF-XMT-CD  . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1000-PROCESS-INPUT                                                      
      *     1. RECEIVE PARMS.                                                   
      *****************************************************************         
                                                                        
REARCH*1000-PROCESS-INPUT.                                                      
REARCH*                                                                         
REARCH*    PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.                       
REARCH*                                                                         
REARCH*1000-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      *****************************************************************         
      * 1100-RECEIVE-PARMS                                                      
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE                    
      *****************************************************************         
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
                                                                        
CVT999*    MOVE 1                            TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-USER-ID       TO MAX-LENGTH-PARM,                
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-USER-ID,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD +1                            TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-ACTION-CODE   TO MAX-LENGTH-PARM,                
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACTION-CODE,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                            TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM,                   
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-LAST-MAX-AT-REV-DT                               
CVT999*                                      TO MAX-LENGTH-PARM,                
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-LAST-MAX-AT-REV-DT,                       
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-MAX-DEP-AT-REV-AM TO MAX-LENGTH-PARM,            
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-MAX-DEP-AT-REV-AM,                        
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.                       
CVT999*    MOVE LENGTH OF PARM-PD-DEP-AT-REV-AM  TO MAX-LENGTH-PARM,            
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-PD-DEP-AT-REV-AM,                         
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                              TO PARM-ID1.                      
CVT999*    MOVE LENGTH OF PARM-MAX-DEP-REFUND-CD TO MAX-LENGTH-PARM,            
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-MAX-DEP-REFUND-CD,                        
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD 1                              TO PARM-ID1.                      
CVT999*    MOVE LENGTH OF PARM-MAX-DEP-REF-XMT-CD TO MAX-LENGTH-PARM,           
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-MAX-DEP-REF-XMT-CD,                       
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *                                                                         
      *     1. DESCRIBE RESULT SET                                              
      *     2. UPDATE DB2 DATA                                                  
      *     3. BUILD RESULT SET                                                 
      *     4. SEND RESULT SET                                                  
      *                                                                         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                         
           PERFORM 5000-UPDATE          THRU 5000-EXIT.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************** 05040000
REARCH*2000A-MOVE-RESULT                                              * 05040000
REARCH***************************************************************** 05040000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      *****************************************************************         
      * 2100-DESCRIBE-RESULT                                                    
      *                                                                         
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                             
      *                                                                         
      *****************************************************************         
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE '2100' TO ACTIVE-PARAGRAPH.                                     
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ***************************************************************           
      * MAIN UPDATE PARAGRAPH.                                      *           
      ***************************************************************           
                                                                        
       5000-UPDATE.                                                     
                                                                        
           MOVE '5000'                    TO ACTIVE-PARAGRAPH.          
           PERFORM 5100-MOVE-PARM-FIELDS  THRU 5100-EXIT.               
                                                                        
           EVALUATE PARM-ACTION-CODE                                    
                                                                        
            WHEN 'U'                                                    
              MOVE 'N'                    TO UPDATE-MAX-DEP-SW          
                                             UPDATE-ACCOUNT-SW          
              PERFORM 7100-SELECT-MAX-DEP       THRU 7100-EXIT          
              PERFORM 7700-SELECT-ACCOUNT       THRU 7700-EXIT          
              PERFORM 5250-JRNL-TRAN-HEAD       THRU 5250-EXIT          
              PERFORM 5300-INSERT-UPDATE-JRNL   THRU 5300-EXIT          
              IF UPDATE-MAX-DEP                                         
                 MOVE WS-LAST-MAX-AT-REV-DT   TO MG-LAST-MAX-AT-REV-DT  
                 MOVE WS-MAX-DEP-AT-REV-N     TO WS-MAX-DEP-AT-REV-AM   
                 MOVE WS-MAX-DEP-AT-REV-AM    TO MG-MAX-DEP-AT-REV-AM   
                 MOVE WS-PD-DEP-AT-REV-N      TO WS-PD-DEP-AT-REV-AM    
                 MOVE WS-PD-DEP-AT-REV-AM     TO MG-PD-DEP-AT-REV-AM    
                 MOVE WS-MAX-DEP-REFUND-CD    TO MG-MAX-DEP-REFUND-CD   
                 PERFORM 8200-UPDATE-MAX-DEP       THRU 8200-EXIT       
              END-IF                                                    
              IF UPDATE-ACCOUNT                                         
                 MOVE WS-MAX-DEP-REF-XMT-CD   TO AT-MAX-DEP-REF-XMT-CD  
                 PERFORM 8300-UPDATE-ACCOUNT       THRU 8300-EXIT       
              END-IF                                                    
                                                                        
           END-EVALUATE.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
           MOVE '5000'                TO ACTIVE-PARAGRAPH.              
REARCH     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * MOVE PARAMETER FIELDS INTO WORKING STORAGE                 *            
      **************************************************************            
                                                                        
       5100-MOVE-PARM-FIELDS.                                           
                                                                        
           MOVE PARM-USER-ID              TO PF-USER-ID.                
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT.                
           MOVE WS-ACCOUNT-DEC            TO WS-ACCOUNT-NO              
                                             MG-ACCOUNT-NO              
                                             AT-ACCOUNT-NO.             
           MOVE PARM-LAST-MAX-AT-REV-DT   TO WS-LAST-MAX-AT-REV-DT.     
           MOVE PARM-MAX-DEP-AT-REV-AM    TO WS-MAX-DEP-AT-REV-C.       
           MOVE PARM-PD-DEP-AT-REV-AM     TO WS-PD-DEP-AT-REV-C.        
           MOVE PARM-MAX-DEP-REFUND-CD    TO WS-MAX-DEP-REFUND-CD.      
           MOVE PARM-MAX-DEP-REF-XMT-CD   TO WS-MAX-DEP-REF-XMT-CD.     
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * JOURNAL MAINTENANCE TRANSACTION HEADER                      *           
      ***************************************************************           
                                                                        
       5250-JRNL-TRAN-HEAD.                                             
                                                                        
           PERFORM 7300-SELECT-TIMESTAMP      THRU 7300-EXIT.           
           PERFORM 7400-SELECT-DATE           THRU 7400-EXIT.           
           PERFORM 7500-SELECT-RESP-AREA      THRU 7500-EXIT.           
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO.      
           MOVE 1                         TO WS-TRAN-APPL-NO.           
                                                                        
           MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
           MOVE WS-ACCOUNT-NO             TO MH-ACCOUNT-NO.             
           MOVE PF-RESP-AREA-ID           TO MH-RESP-AREA-ID.           
           MOVE 0                         TO MH-CUSTOMER-NO.            
           MOVE 0                         TO MH-PREMISE-NO.             
           MOVE PF-USER-ID                TO MH-USER-ID.                
           MOVE 'PANEL057'                TO MH-APPL-PROGRAM-ID.        
           MOVE WS-TRAN-COMMENT-LEN-NUM   TO MH-TRAN-COMMENT-LEN.       
           MOVE WS-TRAN-COMMENT-TEXT      TO MH-TRAN-COMMENT-TEXT.      
                                                                        
       5250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      **************************************************************            
      * JOURNAL EVERY CHANGED ENTRY FIELD                          *            
      **************************************************************            
                                                                        
       5300-INSERT-UPDATE-JRNL.                                         
                                                                        
           IF MAX-DEP-DOES-EXIST                                        
              PERFORM 5305-LAST-MAX-JRNL     THRU 5305-EXIT             
              PERFORM 5310-MAX-DEP-JRNL      THRU 5310-EXIT             
              PERFORM 5315-PD-DEP-JRNL       THRU 5315-EXIT             
              PERFORM 5320-REFUND-CD-JRNL    THRU 5320-EXIT             
           END-IF.                                                      
                                                                        
           PERFORM 5325-REF-XMT-CD-JRNL   THRU 5325-EXIT.               
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL LAST MAX DEPOSIT DATE                                 *         
      *****************************************************************         
                                                                        
       5305-LAST-MAX-JRNL.                                              
                                                                        
           IF MG-LAST-MAX-AT-REV-DT NOT = WS-LAST-MAX-AT-REV-DT         
              MOVE 'Y'                    TO UPDATE-MAX-DEP-SW          
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
                                                                        
              IF WS-LAST-MAX-AT-REV-DT > SPACES                         
                 MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-LAST-MAX-AT-REV-DT  TO MI-CHG-COLUMN-VALUE-TEXT
              END-IF                                                    
              IF MG-LAST-MAX-AT-REV-DT > SPACES                         
                 MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN 
                 MOVE MG-LAST-MAX-AT-REV-DT  TO MI-PRV-COLUMN-VALUE-TEXT
              END-IF                                                    
              MOVE 'LAST REVIEW DT'       TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5305-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL MAX DEPOSIT AMOUNT                                    *         
      *****************************************************************         
                                                                        
       5310-MAX-DEP-JRNL.                                               
                                                                        
           IF MG-MAX-DEP-AT-REV-AM  NOT = WS-MAX-DEP-AT-REV-N           
              MOVE 'Y'                    TO UPDATE-MAX-DEP-SW          
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
                                                                        
              MOVE +13                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-MAX-DEP-AT-REV-N  TO WS-AMT-DISPLAY               
              MOVE WS-AMT-DISPLAY        TO MI-CHG-COLUMN-VALUE-TEXT    
                                                                        
              MOVE +13                   TO MI-PRV-COLUMN-VALUE-LEN     
              MOVE MG-MAX-DEP-AT-REV-AM  TO WS-AMT-DISPLAY              
              MOVE WS-AMT-DISPLAY        TO MI-PRV-COLUMN-VALUE-TEXT    
                                                                        
              MOVE 'MAX DEP AMT'          TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL PAID DEPOSIT                                          *         
      *****************************************************************         
                                                                        
       5315-PD-DEP-JRNL.                                                
                                                                        
           IF MG-PD-DEP-AT-REV-AM NOT = WS-PD-DEP-AT-REV-N              
              MOVE 'Y'                    TO UPDATE-MAX-DEP-SW          
              MOVE SPACES                 TO MI-TABLE-ID                
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
                                                                        
              MOVE +13                 TO MI-CHG-COLUMN-VALUE-LEN       
              MOVE WS-PD-DEP-AT-REV-N  TO WS-AMT-DISPLAY                
              MOVE WS-AMT-DISPLAY      TO MI-CHG-COLUMN-VALUE-TEXT      
                                                                        
              MOVE +13                 TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE MG-PD-DEP-AT-REV-AM TO WS-AMT-DISPLAY                
              MOVE WS-AMT-DISPLAY      TO MI-PRV-COLUMN-VALUE-TEXT      
                                                                        
              MOVE 'PD DEPOSITS'          TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL REFUND CD                                             *         
      *****************************************************************         
                                                                        
       5320-REFUND-CD-JRNL.                                             
                                                                        
           IF MG-MAX-DEP-REFUND-CD  NOT = WS-MAX-DEP-REFUND-CD          
              MOVE 'Y'                    TO UPDATE-MAX-DEP-SW          
              MOVE 74                     TO MI-TABLE-ID                
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
                                                                        
              IF WS-MAX-DEP-REFUND-CD > SPACES                          
                 MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN   
                 MOVE WS-MAX-DEP-REFUND-CD TO MI-CHG-COLUMN-VALUE-TEXT  
              END-IF                                                    
              IF MG-MAX-DEP-REFUND-CD  > SPACES                         
                 MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE MG-MAX-DEP-REFUND-CD TO MI-PRV-COLUMN-VALUE-TEXT  
              END-IF                                                    
              MOVE 'REFUND CD'            TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * JOURNAL REFUND XMT CD                               *                   
      *****************************************************************         
                                                                        
       5325-REF-XMT-CD-JRNL.                                            
                                                                        
           IF AT-MAX-DEP-REF-XMT-CD NOT = WS-MAX-DEP-REF-XMT-CD         
              MOVE 'Y'                    TO UPDATE-ACCOUNT-SW          
              MOVE 75                     TO MI-TABLE-ID                
              MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO            
                                                                        
              MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN       
              MOVE WS-MAX-DEP-REF-XMT-CD TO MI-CHG-COLUMN-VALUE-TEXT    
                                                                        
              MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN       
              MOVE AT-MAX-DEP-REF-XMT-CD TO MI-PRV-COLUMN-VALUE-TEXT    
                                                                        
              MOVE 'MAX XMT CD'           TO MI-COLUMN-DESC             
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1 TO WS-TRAN-APPL-NO                                  
           END-IF.                                                      
                                                                        
       5325-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  JOURNALING COPYBOOK.                                          *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
                                                                        
      ******************************************************************        
      * SELECT EXISTING FIELD VALUES FROM CSS_MAX_DEP_REFUND FOR       *        
      * MAINTENANCE TRANSACTION HISTORY UPDATE                         *        
      ******************************************************************        
                                                                        
       7100-SELECT-MAX-DEP.                                             
                                                                        
           MOVE '7100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
              SELECT CIS.CHAR2$DATE(LAST_MAX_AT_REV_DT,'USA'),                  
                     MAX_DEP_AT_REV_AM,                                 
                     PD_DEP_AT_REV_AM,                                  
                     MAX_DEP_REFUND_CD                                  
                INTO :MG-LAST-MAX-AT-REV-DT :WS-DATE-NI,                 
                     :MG-MAX-DEP-AT-REV-AM,                             
                     :MG-PD-DEP-AT-REV-AM,                              
                     :MG-MAX-DEP-REFUND-CD                              
                FROM CSS_MAX_DEP_REVIEW WITH(READUNCOMMITTED)                   
               WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CHAR(LAST_MAX_AT_REV_DT,USA),                              
MFA-TR*              MAX_DEP_AT_REV_AM,                                         
MFA-TR*              PD_DEP_AT_REV_AM,                                          
MFA-TR*              MAX_DEP_REFUND_CD                                          
MFA-TR*         INTO :MG-LAST-MAX-AT-REV-DT:WS-DATE-NI,                         
MFA-TR*              :MG-MAX-DEP-AT-REV-AM,                                     
MFA-TR*              :MG-PD-DEP-AT-REV-AM,                                      
MFA-TR*              :MG-MAX-DEP-REFUND-CD                                      
MFA-TR*         FROM CSS_MAX_DEP_REVIEW                                         
MFA-TR*        WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-DATE-NI EQUAL -1                                    
                 MOVE SPACES            TO MG-LAST-MAX-AT-REV-DT        
              END-IF                                                    
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 'N'               TO WS-MAX-DEP-SW                
              ELSE                                                      
                 MOVE 'Y'               TO WS-MAX-DEP-SW                
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7100'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_MAX_DEP_REVIEW' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * SELECT CURRENT TIMESTAMP                                       *        
      ******************************************************************        
                                                                        
       7300-SELECT-TIMESTAMP.                                           
                                                                        
           MOVE '7300'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7300'               TO ACTIVE-PARAGRAPH             
T35434        MOVE 'SET'                TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-DATE.                                                
                                                                        
           MOVE '7400'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-DATE-TRANS = CURRENT DATE                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7400'               TO ACTIVE-PARAGRAPH             
T35434        MOVE 'SET'                TO ABEND-FUNCTION               
CBSI          MOVE SPACES               TO ABEND-SQL-PREDICATES         
CBSI                                       ABEND-TABLES                 
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7500-SELECT-RESP-AREA.                                           
                                                                        
           MOVE '7500'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
              INTO :PF-RESP-AREA-ID                                     
              FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                       
              WHERE USER_ID = :PF-USER-ID                               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*       INTO :PF-RESP-AREA-ID                                             
MFA-TR*       FROM CSS_USER_PROFILE                                             
MFA-TR*       WHERE USER_ID = :PF-USER-ID                                       
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7500'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_USER_PROFILE'   TO TABLE-1                      
CBSI          MOVE 'USER_ID'            TO TABLE-ELEMENT-1              
              MOVE PF-USER-ID           TO HOSTVAR-ELEMENT-1            
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
       7700-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '7700' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT MAX_DEP_REF_XMT_CD                                 
                INTO :AT-MAX-DEP-REF-XMT-CD                             
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                        
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX_DEP_REF_XMT_CD                                         
MFA-TR*         INTO :AT-MAX-DEP-REF-XMT-CD                                     
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02539'               TO ABEND-PROGRAM            
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-UPDATE-MAX-DEP.                                             
                                                                        
           MOVE '8200'                  TO ACTIVE-PARAGRAPH.            
           IF WS-LAST-MAX-AT-REV-DT <= SPACES                           
              MOVE -1                     TO WS-DATE-NI                 
           ELSE                                                         
              MOVE 0                      TO WS-DATE-NI                 
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_MAX_DEP_REVIEW                                 
                SET  LAST_MAX_AT_REV_DT    = IIF(TRY_CONVERT(DATE, 
                                                :MG-LAST-MAX-AT-REV-DT 
                                                            :WS-DATE-NI
              ) IS NULL OR (PATINDEX('%.%', :MG-LAST-MAX-AT-REV-DT 
                                                            :WS-DATE-NI
              ) <> 0) OR (LEN(:MG-LAST-MAX-AT-REV-DT :WS-DATE-NI
              ) <> 10), CIS.CHAR2DATE(:MG-LAST-MAX-AT-REV-DT 
                                                            :WS-DATE-NI
              ), CONVERT(DATE, :MG-LAST-MAX-AT-REV-DT :WS-DATE-NI) ),          
                     MAX_DEP_AT_REV_AM     = :MG-MAX-DEP-AT-REV-AM,     
                     PD_DEP_AT_REV_AM      = :MG-PD-DEP-AT-REV-AM,      
                     MAX_DEP_REFUND_CD     = :MG-MAX-DEP-REFUND-CD,     
                     LAST_UPDATE_TS        = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )      
               WHERE ACCOUNT_NO            = :WS-ACCOUNT-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_MAX_DEP_REVIEW                                         
MFA-TR*         SET  LAST_MAX_AT_REV_DT    = :MG-LAST-MAX-AT-REV-DT             
MFA-TR*                                      :WS-DATE-NI,                       
MFA-TR*              MAX_DEP_AT_REV_AM     = :MG-MAX-DEP-AT-REV-AM,             
MFA-TR*              PD_DEP_AT_REV_AM      = :MG-PD-DEP-AT-REV-AM,              
MFA-TR*              MAX_DEP_REFUND_CD     = :MG-MAX-DEP-REFUND-CD,             
MFA-TR*              LAST_UPDATE_TS        = :MH-TRANS-HIST-SEQ-NO              
MFA-TR*        WHERE ACCOUNT_NO            = :WS-ACCOUNT-NO                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
                                           ABEND-TABLES                 
              MOVE 'CSS_MAX_DEP_REVIEW' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * 8300-UPDATE-ACCOUNT.                                        *           
      ***************************************************************           
                                                                        
       8300-UPDATE-ACCOUNT.                                             
           MOVE '8300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
           UPDATE CSS_ACCOUNT                                           
           SET      MAX_DEP_REF_XMT_CD = :AT-MAX-DEP-REF-XMT-CD         
           WHERE    ACCOUNT_NO         = :WS-ACCOUNT-NO                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES               TO ABEND-TABLES                 
              MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH        MOVE 'CSR02539'               TO ABEND-PROGRAM            
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_ACCOUNT'        TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'MAX_DEP_REF_XMT_CD' TO TABLE-ELEMENT-2              
              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE AT-MAX-DEP-REF-XMT-CD TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ****************************************************************          
              EXEC SQL                                                          
                 INCLUDE CPDSP300                                               
              END-EXEC.                                                         
                                                                        
      ****************************************************************          
      *       END PROGRAM COPYLIB                                               
      ****************************************************************          
CVT999*COPY CPD00302.                                                           
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
