       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02538.                                     
COB303 DATE-WRITTEN.      MAY 30,2003.                                  
      *****************************************************************         
      *                                                                         
      *                SOUTH CAROLINA ELECTRIC & GAS                            
      *                                                                         
      *****************************************************************         
      *                 P R O G R A M  S U M M A R Y                            
      *                                                                         
      *  THIS PROGRAM RETRIEVES THE GROUP VOLUME DISPLAY INFORMATION FOR        
      *  CIG ACCOUNTS.                                                          
      *                                                                         
      *****************************************************************         
      *                                                                         
      *                     PROGRAM MODIFICATION LOG                            
      *                                                                         
      *    DATE    INITIALS   COMMENTS                                          
      *  --------  --------   ---------------------------------------           
      *  01/10/03   LF19392   INITIAL VERSION                                   
      *  03/27/03   SK88120   CHANGES WERE MADE TO DISPLAY                      
      *                       A) DAY INSTEAD OF DATE                            
      *                       B) METERED TOTALS FOR EVERY DAY                   
      *                       C) ALL DETAILS FOR BASE / TRNSP ROWS              
      *  04/24/03   SK88120   CHANGES WERE MADE TO                              
      *                       DISPLAY MULTIPLE COMPETETIVE PRICES               
      *  04/24/03   SK88120   CHANGES WERE MADE TO                              
      *                       INCRESE THE NO.OF COULMNS FROM 10 TO 36           
T32708*  05/07/05   VV90387   INCREASED LENGTH OF WS-BILL-NO TO BE SAME         
T32708*                       AS BG-BILL-NO TO AVOID TRUNCATION.                
REARCH*  10/03/05   CVNS      RPC CONVERTED TO COBOL SP                         
REARCH*             CHENNAI                                                     
C35902*  07/23/07   CVNS      PANEL 499 GROUP VOLUME SUBSELECTION -             
C35902*                       CATEGORY.                                         
P00251*  03/01/10   VY95550   HANDLE NEGATIVE DAILY USAGES FROM                 
P00251*                       CSS_VOL_DAILY TABLE.                              
P00251*  04/19/10   MN90523   CHANGES MADE TO INCLUDE CODE TIME                 
P00251*                       PERIOD                                            
PRDFIX*  06/18/10   MN90523   CHANGE MADES TO DISPLAY CX - ZERO CODE            
PRDFIX*                       TIME PERIOD ROWS                                  
ACT321*  10/26/16   AD7F921   MOVE SPACES TO TOTAL OF                           
ACT321*                       TRANS AVAIL DEKATHERMS AND                        
ACT321*                       TRANS BALANCE FWD - APPL00005460-ACT321.          
      *****************************************************************         
      *                                                                         
      *                ---- BASIC SEQUENCE STRUCTURE ----                       
      *                                                                         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION                      
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                             
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                            
      *  3000 - 4999  NOT USED                                                  
      *  5000 - 5999  COMMON PROGRAM MODULES                                    
      *  6000 - 6999  COMMON SYSTEM MODULES                                     
      *  7000 - 7999  INPUT MODULES                                             
      *  8000 - 8999  OUTPUT MODULES                                            
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES                      
      *                                                                         
      *****************************************************************         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02538'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02538 STARTS HERE'.                  
                                                                        
      *****************************************************************         
      *    COBOL WORKING STORAGE COPY BOOKS                                     
      *****************************************************************         
      * CONTAINS THE COBOL EQUATES NEEDED FOR USING THE                         
      * SYBASE OPEN SERVER FOR CICS FACILITIES.                                 
REARCH*    COPY SYGWCOB.                                                        
      * ADDED TO SUPPORT CICS RPCS                                              
REARCH*    COPY SYDBCOB.                                                        
      * COMMON SYSTEM AREA                                                      
           COPY CCA00001.                                                       
      * ERROR HANDLING                                                          
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*    COPY CWS00010.                                                       
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
      *                                                                         
      *****************************************************************         
      *    WORK AREAS                                                           
      *****************************************************************         
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02538'.     
           05  WS-SQLSTATE              PIC X(05) VALUE '     '.        
           05  PANEL-NAME               PIC X(08) VALUE 'PANEL499'.     
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-EIBRESP             PIC S9(8)                         
                                       COMP SYNC VALUE ZERO.            
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                 POINTER.                                
REARCH*    05  GWL-INIT-HANDLE          POINTER.                                
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(09) COMP.                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                   PIC S9(9) COMP.                         
REARCH*    05  PARM-ID1                 PIC S9(9) COMP VALUE 0.                 
REARCH*    05  PARM-COMPANY-NO          PIC X(02) VALUE SPACES.                 
REARCH     05  PARM-ACCOUNT-NO-TEMP     PIC X(13) VALUE SPACES.         
REARCH     05  PARM-ACCOUNT-NO-X        REDEFINES PARM-ACCOUNT-NO-TEMP  
REARCH                                  PIC 9(13).                      
REARCH*        10 PARM-ACCOUNT-NO       PIC 9(13).                              
REARCH*    05  PARM-BILL-NO             PIC S9(09) USAGE COMP VALUE 0.          
REARCH*    05  PARM-CODE-UTIL-TYPE      PIC X(01).                              
REARCH*    05  PARM-IC-NO               PIC S9(04) USAGE COMP VALUE 0.          
REARCH*    05  PARM-BILL-ITEM-TS        PIC X(26).                              
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01) VALUE 'N'.          
               88 NOT-ALL-DONE                      VALUE 'N'.          
               88 ALL-DONE                          VALUE 'Y'.          
           05  SEND-DONE-SW               PIC X(01) VALUE 'Y'.          
               88 SEND-DONE-ERROR                   VALUE 'N'.          
               88 SEND-DONE-OK                      VALUE 'Y'.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9) COMP.               
           05  SNA-CONNECTION-NAME        PIC X(8)  VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                 PIC S9(9) COMP VALUE 0.       
           05  CTR-ROWS                   PIC S9(9) COMP VALUE 0.       
                                                                        
       01  WS-NULL-IND-VARS.                                            
           05  WS-NULL-IND1               PIC S9(04) COMP.              
           05  WS-NULL-IND2               PIC S9(04) COMP.              
           05  WS-NULL-IND3               PIC S9(04) COMP.              
           05  WS-NULL-IND4               PIC S9(04) COMP.              
           05  WS-NULL-IND5               PIC S9(04) COMP.              
           05  WS-BILL-DAY-00-NI          PIC S9(04) COMP.              
           05  WS-BILL-DAY-30-NI          PIC S9(04) COMP.              
           05  WS-BILL-DAY-60-NI          PIC S9(04) COMP.              
           05  WS-BILL-DAY-90-NI          PIC S9(04) COMP.              
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM            PIC S9(9) COMP.               
           05  WRKLEN1                    PIC S9(9) COMP.               
           05  WRKLEN2                    PIC S9(9) COMP.               
           05  WRK-DONE-STATUS            PIC S9(9) COMP.               
                                                                        
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                     VALUE 'SESSION.CSR02538_R1'. 
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-DATE                 PIC X(10) VALUE SPACES.          
P00251     05  RS-CODE-TIME-PERIOD     PIC S9(04) COMP VALUE 0.         
           05  RS-VOL-GROUP            PIC S9(04) COMP VALUE 0.         
           05  RS-TYPE-ROW             PIC X(01) VALUE SPACES.          
           05  RS-COLUMNS.                                              
               10  RS-COLUMN-1             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-2             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-3             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-4             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-5             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-6             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-7             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-8             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-9             PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-10            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-11            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-12            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-13            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-14            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-15            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-16            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-17            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-18            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-19            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-20            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-21            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-22            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-23            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-24            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-25            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-26            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-27            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-28            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-29            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-30            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-31            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-32            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-33            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-34            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-35            PIC X(14) VALUE SPACES.      
               10  RS-COLUMN-36            PIC X(14) VALUE SPACES.      
           05  RS-COLUMNS-TABLE REDEFINES RS-COLUMNS.                   
               10  RS-COLUMN OCCURS 36 TIMES                            
                                           PIC X(14).                   
           05  RS-RATE-PLAN                PIC X(03).                   
           05  RS-REVENUE-CLASS            PIC X(03).                   
           05  RS-CATEGORY                 PIC X(02).                   
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(9)  COMP VALUE 0.       
REARCH     05  S-DATE                    PIC X(10) VALUE SPACES.        
P00251     05  S-CODE-TIME-PERIOD        PIC S9(04) COMP VALUE 0.       
REARCH     05  S-VOL-GROUP               PIC S9(04) COMP VALUE 0.       
REARCH     05  S-TYPE-ROW                PIC X(01) VALUE SPACES.        
REARCH     05  S-COLUMN-1                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-2                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-3                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-4                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-5                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-6                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-7                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-8                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-9                PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-10               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-11               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-12               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-13               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-14               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-15               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-16               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-17               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-18               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-19               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-20               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-21               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-22               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-23               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-24               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-25               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-26               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-27               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-28               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-29               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-30               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-31               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-32               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-33               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-34               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-35               PIC X(14) VALUE SPACES.        
REARCH     05  S-COLUMN-36               PIC X(14) VALUE SPACES.        
REARCH     05  S-RATE-PLAN               PIC X(03).                     
REARCH     05  S-REVENUE-CLASS           PIC X(03).                     
REARCH     05  S-CATEGORY                PIC X(02).                     
REARCH*                                                                         
REARCH*01  CN-COLUMN-NAMES.                                                     
REARCH*    05  CN-RETURN-CODE          PIC X(11) VALUE                          
REARCH*                                'RETURN_CODE'.                           
REARCH*    05  CN-DAY                  PIC X(03) VALUE                          
REARCH*                                'DAY'.                                   
REARCH*    05  CN-VOL-GROUP            PIC X(09) VALUE                          
REARCH*                                'VOL_GROUP'.                             
REARCH*    05  CN-TYPE-ROW             PIC X(08) VALUE                          
REARCH*                                'TYPE_ROW'.                              
REARCH*    05  CN-HEADING-1            PIC X(09) VALUE                          
REARCH*                                'HEADING_1'.                             
REARCH*    05  CN-HEADING-2            PIC X(09) VALUE                          
REARCH*                                'HEADING_2'.                             
REARCH*    05  CN-HEADING-3            PIC X(09) VALUE                          
REARCH*                                'HEADING_3'.                             
REARCH*    05  CN-HEADING-4            PIC X(09) VALUE                          
REARCH*                                'HEADING_4'.                             
REARCH*    05  CN-COLUMN-1             PIC X(08) VALUE                          
REARCH*                                'COLUMN_1'.                              
REARCH*    05  CN-COLUMN-2             PIC X(08) VALUE                          
REARCH*                                'COLUMN_2'.                              
REARCH*    05  CN-COLUMN-3             PIC X(08) VALUE                          
REARCH*                                'COLUMN_3'.                              
REARCH*    05  CN-COLUMN-4             PIC X(08) VALUE                          
REARCH*                                'COLUMN_4'.                              
REARCH*    05  CN-COLUMN-5             PIC X(08) VALUE                          
REARCH*                                'COLUMN_5'.                              
REARCH*    05  CN-COLUMN-6             PIC X(08) VALUE                          
REARCH*                                'COLUMN_6'.                              
REARCH*    05  CN-COLUMN-7             PIC X(08) VALUE                          
REARCH*                                'COLUMN_7'.                              
REARCH*    05  CN-COLUMN-8             PIC X(08) VALUE                          
REARCH*                                'COLUMN_8'.                              
REARCH*    05  CN-COLUMN-9             PIC X(08) VALUE                          
REARCH*                                'COLUMN_9'.                              
REARCH*    05  CN-COLUMN-10            PIC X(09) VALUE                          
REARCH*                                'COLUMN_10'.                             
REARCH*    05  CN-COLUMN-11            PIC X(09) VALUE                          
REARCH*                                'COLUMN_11'.                             
REARCH*    05  CN-COLUMN-12            PIC X(09) VALUE                          
REARCH*                                'COLUMN_12'.                             
REARCH*    05  CN-COLUMN-13            PIC X(09) VALUE                          
REARCH*                                'COLUMN_13'.                             
REARCH*    05  CN-COLUMN-14            PIC X(09) VALUE                          
REARCH*                                'COLUMN_14'.                             
REARCH*    05  CN-COLUMN-15            PIC X(09) VALUE                          
REARCH*                                'COLUMN_15'.                             
REARCH*    05  CN-COLUMN-16            PIC X(09) VALUE                          
REARCH*                                'COLUMN_16'.                             
REARCH*    05  CN-COLUMN-17            PIC X(09) VALUE                          
REARCH*                                'COLUMN_17'.                             
REARCH*    05  CN-COLUMN-18            PIC X(09) VALUE                          
REARCH*                                'COLUMN_18'.                             
REARCH*    05  CN-COLUMN-19            PIC X(09) VALUE                          
REARCH*                                'COLUMN_19'.                             
REARCH*    05  CN-COLUMN-20            PIC X(09) VALUE                          
REARCH*                                'COLUMN_20'.                             
REARCH*    05  CN-COLUMN-21            PIC X(09) VALUE                          
REARCH*                                'COLUMN_21'.                             
REARCH*    05  CN-COLUMN-22            PIC X(09) VALUE                          
REARCH*                                'COLUMN_22'.                             
REARCH*    05  CN-COLUMN-23            PIC X(09) VALUE                          
REARCH*                                'COLUMN_23'.                             
REARCH*    05  CN-COLUMN-24            PIC X(09) VALUE                          
REARCH*                                'COLUMN_24'.                             
REARCH*    05  CN-COLUMN-25            PIC X(09) VALUE                          
REARCH*                                'COLUMN_25'.                             
REARCH*    05  CN-COLUMN-26            PIC X(09) VALUE                          
REARCH*                                'COLUMN_26'.                             
REARCH*    05  CN-COLUMN-27            PIC X(09) VALUE                          
REARCH*                                'COLUMN_27'.                             
REARCH*    05  CN-COLUMN-28            PIC X(09) VALUE                          
REARCH*                                'COLUMN_28'.                             
REARCH*    05  CN-COLUMN-29            PIC X(09) VALUE                          
REARCH*                                'COLUMN_29'.                             
REARCH*    05  CN-COLUMN-30            PIC X(09) VALUE                          
REARCH*                                'COLUMN_30'.                             
REARCH*    05  CN-COLUMN-31            PIC X(09) VALUE                          
REARCH*                                'COLUMN_31'.                             
REARCH*    05  CN-COLUMN-32            PIC X(09) VALUE                          
REARCH*                                'COLUMN_32'.                             
REARCH*    05  CN-COLUMN-33            PIC X(09) VALUE                          
REARCH*                                'COLUMN_33'.                             
REARCH*    05  CN-COLUMN-34            PIC X(09) VALUE                          
REARCH*                                'COLUMN_34'.                             
REARCH*    05  CN-COLUMN-35            PIC X(09) VALUE                          
REARCH*                                'COLUMN_35'.                             
REARCH*    05  CN-COLUMN-36            PIC X(09) VALUE                          
REARCH*                                'COLUMN_36'.                             
REARCH*    05  CN-RATE-PLAN            PIC X(09) VALUE                          
REARCH*                                'RATE_PLAN'.                             
REARCH*    05  CN-REVENUE-CLASS        PIC X(13) VALUE                          
REARCH*                                'REVENUE_CLASS'.                         
REARCH*    05  CN-CATEGORY             PIC X(08) VALUE                          
REARCH*                                'CATEGORY'.                              
                                                                        
       01  WS-COLUMN-IND              PIC 9(02) VALUE 0.                
       01  WS-HEAD-IND                PIC 9(02) VALUE 0.                
       01  WS-DAY-IND                 PIC 9(02) VALUE 0.                
P00251 01  WS-TM-PRD-IND              PIC 9(02) VALUE 0.                
       01  WS-SAVE-VOL-GROUP-CD       PIC 9(02) VALUE 0.                
                                                                        
       01  WS-COLUMN-TABLE.                                             
           05  WS-HEADING-INFO OCCURS 36 TIMES.                         
               10  WS-HEADINGS.                                         
                   15  WS-HEADING-1           PIC X(14).                
                   15  WS-HEADING-2           PIC X(14).                
                   15  WS-HEADING-3           PIC X(14).                
                   15  WS-HEADING-4           PIC X(14).                
               10  WS-HEADING-TAB REDEFINES WS-HEADINGS.                
                   15  WS-HEADING OCCURS 4 TIMES  PIC X(14).            
               10  WS-COLUMN-TOT              PIC S9(09)V9.             
                                                                        
       01  WS-DAY-TABLE.                                                
           05  WS-DAY-INFO OCCURS 31 TIMES.                             
               10  WS-DATE                   PIC X(10).                 
               10  WS-VOL-GROUP              PIC 9(02).                 
P00251         10  WS-TIME-PERIOD-INFO OCCURS 4 TIMES.                  
P00251             15  WS-CODE-TIME-PERIOD   PIC S9(04) COMP.           
                   15  WS-UNITS-TABLE OCCURS 36 TIMES.                  
                       20  WS-UNITS          PIC X(11).                 
                                                                        
                                                                        
       01  WS-TOTALS                  PIC X(11).                        
                                                                        
       01  WS-DATE-READ.                                                
           05  WS-DATE-READ-YY        PIC X(04).                        
           05  FILLER                 PIC X(01).                        
           05  WS-DATE-READ-MM        PIC X(02).                        
           05  FILLER                 PIC X(01).                        
           05  WS-DATE-READ-DD        PIC X(04).                        
           05  WS-DATE-READ-DD-N                                        
                 REDEFINES WS-DATE-READ-DD                              
                                      PIC 9(02).                        
                                                                        
P00251 01  WS-CNTR                    PIC S9(2)   VALUE ZEROS.          
       01  WS-NO-UNITS                PIC 9(09)V9 VALUE ZEROS.          
       01  WS-SIGN-UNITS              PIC -(09).                        
       01  WS-UNITS-NEG               PIC S9(09)V9.                     
       01  WS-HOLD-UNITS              PIC X(14).                        
       01  WS-DATA-FOUND-FLAG         PIC X(01) VALUE 'N'.              
           88  WS-DATA-FOUND          VALUE 'Y'.                        
                                                                        
       01  WS-VOL-GRP-DATA-FOUND-FLAG PIC X(01) VALUE 'N'.              
           88  WS-VOL-GRP-DATA-FOUND  VALUE 'Y'.                        
                                                                        
       01  WS-CIGVOL-START-DATE       PIC X(10).                        
       01  WS-CIGVOL-END-DATE         PIC X(10).                        
                                                                        
       01  WS-NULL-IND-1              PIC S9(04) COMP.                  
       01  WS-NULL-IND-2              PIC S9(04) COMP.                  
       01  WS-NULL-IND-3              PIC S9(04) COMP.                  
       01  WS-NULL-IND-4              PIC S9(04) COMP.                  
                                                                        
       01  WS-TRNSP-SHRINK-PCT        PIC 9(02)V99 VALUE ZEROS.         
                                                                        
       01  WS-DISPLAY-PCT             PIC Z9.99.                        
                                                                        
       01  WS-RATE-PLAN               PIC X(03) VALUE SPACES.           
       01  WS-CATEGORY                PIC X(02) VALUE SPACES.           
       01  WS-DISPLAY-HEADING         PIC X(14) VALUE SPACES.           
       01  WS-DISPLAY-HEADING-1       PIC X(14) VALUE SPACES.           
       01  WS-DISPLAY-HEADING-2       PIC X(14) VALUE SPACES.           
       01  WS-DISPLAY-HEADING-3       PIC X(14) VALUE SPACES.           
       01  WS-DISPLAY-HEADING-4       PIC X(14) VALUE SPACES.           
       01  WS-HOLD-HEADER             PIC X(14) VALUE SPACES.           
       01  WS-COMPPRICE               PIC X(09) VALUE 'COMPPRICE'.      
       01  WS-CMPNT-ID-CD             PIC X(02) VALUE '15'.             
       01  WS-FACTOR                  PIC 9(8)V9(4).                    
       01  WS-FACTOR-EDIT             PIC $(8).9(4).                    
       01  WS-FACTOR-CHAR             PIC X(13) VALUE SPACES.           
       01  WS-SAVE-METER-NO           PIC X(09) VALUE SPACES.           
       01  WS-TRNSP-TS1               PIC X(26) VALUE SPACES.           
       01  WS-TRNSP-TS2               PIC X(26) VALUE SPACES.           
       01  WS-CURRENT-TS              PIC X(26) VALUE SPACES.           
       01  WS-DATE-READ-FH            PIC X(10) VALUE SPACES.           
       01  WS-FIXED-FCTR-SEQ-NO       PIC S9(4) USAGE COMP.             
       01  WS-MAX-SEQ-NO              PIC S9(4) USAGE COMP VALUE 0.     
       01  WS-PREV-SEQ-NO             PIC S9(4) USAGE COMP VALUE 0.     
       01  WS-NULL-IND                PIC S9(04) COMP.                  
                                                                        
       01  WS-PARAMETERS.                                               
           05  WS-COMPANY-NO          PIC X(02).                        
           05  WS-ACCOUNT-NO          PIC 9(13).                        
T32708*    05  WS-BILL-NO             PIC 9(02).                                
T32708     05  WS-BILL-NO             PIC 9(09).                        
           05  WS-CODE-UTIL-TYPE      PIC X(01).                        
           05  WS-IC-NO               PIC 9(04).                        
           05  WS-BILL-ITEM-TS        PIC X(26).                        
                                                                        
      *****************************************************************         
      * DATABASE DEFINITION                                                     
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBVOLDLY                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBVOLTYP                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSVCCAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCNSMP                                                   
           END-EXEC.                                                            
                                                                        
      **********************************                                        
      * CSS_BILLING_DET                *                                        
      **********************************                                        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
      *                                                                         
      **********************************                                        
      * CSS_TRNSP_CONTRACT             *                                        
      **********************************                                        
      *                                                                         
            EXEC SQL                                                            
                 INCLUDE TBTRNCNT                                               
            END-EXEC.                                                           
      *                                                                         
      **********************************                                        
      * CSS_BILL_CONTRACT              *                                        
      **********************************                                        
      *                                                                         
            EXEC SQL                                                            
                 INCLUDE TBBLCNTR                                               
            END-EXEC.                                                           
      *                                                                         
      **********************************                                        
      * CSS_FIXED_FCT_HIST             *                                        
      **********************************                                        
      *                                                                         
            EXEC SQL                                                            
                 INCLUDE TBFXHST                                                
            END-EXEC.                                                           
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-COMPANY-NO          PIC X(02).                          
REARCH 01  PARM-ACCOUNT-NO          PIC X(13).                          
REARCH 01  PARM-BILL-NO             PIC S9(09) USAGE COMP.              
REARCH 01  PARM-CODE-UTIL-TYPE      PIC X(01).                          
REARCH 01  PARM-IC-NO               PIC S9(04) USAGE COMP.              
REARCH 01  PARM-BILL-ITEM-TS        PIC X(26).                          
REARCH*                                                                         
      ***************************************************************           
      ***  CURSOR TO FETCH HEADINGS FOR VOLUME GROUP CD SELECTED  ***           
      ***  ON GROUP VOLUME DISPLAY PANEL                          ***           
      ***************************************************************           
                                                                        
           EXEC SQL                                                     
             DECLARE HEADINGS-CSR CURSOR FOR                            
             SELECT  X8.VOL_TYPE_CD,                                    
                     X8.VOL_GROUP_CD,                                   
                     X8.ENERGY_UNIT_CD,                                 
                     X8.CMPNT_ID_CD,                                    
                     X8.MANUAL_ENTRY_FL,                                
                     X8.ACCUM_TOTAL_FL,                                 
                     X8.COLUMN_HEADER1,                                 
                     X8.COLUMN_HEADER2,                                 
                     X8.COLUMN_HEADER3,                                 
                     X8.COLUMN_HEADER4,                                 
                     X8.STATUS_CD,                                      
                     X8.STATUS_CHANGE_DT                                
             FROM CSS_VOL_TYPE X8 WITH(READUNCOMMITTED)                         
             WHERE X8.COMPANY_NO     = :X8-COMPANY-NO                   
               AND X8.CODE_UTIL_TYPE = :X8-CODE-UTIL-TYPE               
             ORDER BY X8.VOL_GROUP_CD,X8.VOL_GROUP_SEQ ASC              
C35902       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE HEADINGS-CSR CURSOR FOR                                    
MFA-TR*      SELECT  X8.VOL_TYPE_CD,                                            
MFA-TR*              X8.VOL_GROUP_CD,                                           
MFA-TR*              X8.ENERGY_UNIT_CD,                                         
MFA-TR*              X8.CMPNT_ID_CD,                                            
MFA-TR*              X8.MANUAL_ENTRY_FL,                                        
MFA-TR*              X8.ACCUM_TOTAL_FL,                                         
MFA-TR*              X8.COLUMN_HEADER1,                                         
MFA-TR*              X8.COLUMN_HEADER2,                                         
MFA-TR*              X8.COLUMN_HEADER3,                                         
MFA-TR*              X8.COLUMN_HEADER4,                                         
MFA-TR*              X8.STATUS_CD,                                              
MFA-TR*              X8.STATUS_CHANGE_DT                                        
MFA-TR*      FROM CSS_VOL_TYPE X8                                               
MFA-TR*      WHERE X8.COMPANY_NO     = :X8-COMPANY-NO                           
MFA-TR*        AND X8.CODE_UTIL_TYPE = :X8-CODE-UTIL-TYPE                       
MFA-TR*      ORDER BY X8.VOL_GROUP_CD,X8.VOL_GROUP_SEQ ASC                      
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      ***  CURSOR TO FETCH TRANSPORTATION AND VOLUME TOTALS FOR   ***           
      ***  GROUP VOLUME DISPLAY PANEL                             ***           
      ***************************************************************           
                                                                        
           EXEC SQL                                                     
             DECLARE TRANS-VOL-CSR CURSOR FOR                           
             SELECT  SUM(ND.NO_UNITS),                                  
                     ND.DATE_READ,                                      
P00251               ND.CODE_TIME_PERIOD,                               
                     ND.FIXED_FCTR_SEQ_NO                               
             FROM CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                        
             WHERE ND.ACCOUNT_NO     = :ND-ACCOUNT-NO                   
               AND ND.BILL_NO        = :ND-BILL-NO                      
               AND ND.CODE_UTIL_TYPE = :ND-CODE-UTIL-TYPE               
               AND ND.IC_NO          = :ND-IC-NO                        
               AND ND.VOL_TYPE_CD    = :ND-VOL-TYPE-CD                  
               AND ND.ENERGY_UNIT_CD = :ND-ENERGY-UNIT-CD               
               AND ((ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              ))    
                OR  (ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                          :WS-TRNSP-TS1
              ))             
                OR  (ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                          :WS-TRNSP-TS2
              )))            
             GROUP BY ND.DATE_READ                                      
P00251               ,ND.CODE_TIME_PERIOD                               
                     ,ND.FIXED_FCTR_SEQ_NO                              
             ORDER BY ND.DATE_READ                                      
P00251               ,ND.CODE_TIME_PERIOD                               
                     ,ND.FIXED_FCTR_SEQ_NO                              
C35902       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE TRANS-VOL-CSR CURSOR FOR                                   
MFA-TR*      SELECT  SUM(ND.NO_UNITS),                                          
MFA-TR*              ND.DATE_READ,                                              
MFA-TR*              ND.CODE_TIME_PERIOD,                                       
MFA-TR*              ND.FIXED_FCTR_SEQ_NO                                       
MFA-TR*      FROM CSS_VOL_DAILY ND                                              
MFA-TR*      WHERE ND.ACCOUNT_NO     = :ND-ACCOUNT-NO                           
MFA-TR*        AND ND.BILL_NO        = :ND-BILL-NO                              
MFA-TR*        AND ND.CODE_UTIL_TYPE = :ND-CODE-UTIL-TYPE                       
MFA-TR*        AND ND.IC_NO          = :ND-IC-NO                                
MFA-TR*        AND ND.VOL_TYPE_CD    = :ND-VOL-TYPE-CD                          
MFA-TR*        AND ND.ENERGY_UNIT_CD = :ND-ENERGY-UNIT-CD                       
MFA-TR*        AND ((ND.BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP)            
MFA-TR*         OR  (ND.BILL_ITEM_TIMESTMP = :WS-TRNSP-TS1)                     
MFA-TR*         OR  (ND.BILL_ITEM_TIMESTMP = :WS-TRNSP-TS2))                    
MFA-TR*      GROUP BY ND.DATE_READ                                              
MFA-TR*              ,ND.CODE_TIME_PERIOD                                       
MFA-TR*              ,ND.FIXED_FCTR_SEQ_NO                                      
MFA-TR*      ORDER BY ND.DATE_READ                                              
MFA-TR*              ,ND.CODE_TIME_PERIOD                                       
MFA-TR*              ,ND.FIXED_FCTR_SEQ_NO                                      
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
      ***************************************************************           
      ***  CURSOR TO FETCH CNSMPTN HISTORY DETAILS FOR THE METERS ***           
      ***  ATTACHED                                               ***           
      ***************************************************************           
                                                                        
           EXEC SQL                                                     
             DECLARE CNSMPTN-CSR CURSOR FOR                             
             SELECT  CX.METER_NO,                                       
                     CX.DATE_READ,                                      
P00251               CX.CODE_TIME_PERIOD,                               
                     CX.NO_UNITS,                                       
                     CX.CODE_DEBIT_CREDIT                               
             FROM CSS_CNSMPTN_HIST CX WITH(READUNCOMMITTED)                     
             WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO               
               AND CX.BILL_NO            = :CX-BILL-NO                  
               AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE           
               AND CX.IC_NO              = :CX-IC-NO                    
               AND CX.METER_NO          <> '0CIGDUMMY'                  
               AND ((CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :CX-BILL-ITEM-TIMESTMP
              ))    
                OR (CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                          :WS-TRNSP-TS1
              ))              
                OR (CX.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                          :WS-TRNSP-TS2
              )))             
             ORDER BY CX.METER_NO,                                      
                      CX.DATE_READ,                                     
P00251                CX.CODE_TIME_PERIOD                               
C35902       FOR READ ONLY                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CNSMPTN-CSR CURSOR FOR                                     
MFA-TR*      SELECT  CX.METER_NO,                                               
MFA-TR*              CX.DATE_READ,                                              
MFA-TR*              CX.CODE_TIME_PERIOD,                                       
MFA-TR*              CX.NO_UNITS,                                               
MFA-TR*              CX.CODE_DEBIT_CREDIT                                       
MFA-TR*      FROM CSS_CNSMPTN_HIST CX                                           
MFA-TR*      WHERE CX.ACCOUNT_NO         = :CX-ACCOUNT-NO                       
MFA-TR*        AND CX.BILL_NO            = :CX-BILL-NO                          
MFA-TR*        AND CX.CODE_UTIL_TYPE     = :CX-CODE-UTIL-TYPE                   
MFA-TR*        AND CX.IC_NO              = :CX-IC-NO                            
MFA-TR*        AND CX.METER_NO          = '0CIGDUMMY'                          
MFA-TR*        AND ((CX.BILL_ITEM_TIMESTMP = :CX-BILL-ITEM-TIMESTMP)            
MFA-TR*         OR (CX.BILL_ITEM_TIMESTMP = :WS-TRNSP-TS1)                      
MFA-TR*         OR (CX.BILL_ITEM_TIMESTMP = :WS-TRNSP-TS2))                     
MFA-TR*      ORDER BY CX.METER_NO,                                              
MFA-TR*               CX.DATE_READ,                                             
MFA-TR*               CX.CODE_TIME_PERIOD                                       
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
      *                                                                         
REARCH PROCEDURE DIVISION USING  PARM-COMPANY-NO                        
REARCH                          ,PARM-ACCOUNT-NO                        
REARCH                          ,PARM-BILL-NO                           
REARCH                          ,PARM-CODE-UTIL-TYPE                    
REARCH                          ,PARM-IC-NO                             
REARCH                          ,PARM-BILL-ITEM-TS.                     
                                                                        
      *****************************************************************         
      * 0000-MAINLINE                                                           
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                               
      *****************************************************************         
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 0100-INITIALIZE                                                         
      *                                                                         
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                           
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)            
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)         
      *                                                                         
      *****************************************************************         
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100' TO ACTIVE-PARAGRAPH.                             
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR CONTINUE END-EXEC.                
           EXEC SQL WHENEVER NOT FOUND CONTINUE END-EXEC.               
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH                                                                  
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH              RETURN_CODE                                         
REARCH             ,LTRIM(RTRIM(DAY))           AS DAY                         
P00251             ,CODE_TIME_PERIOD                                    
REARCH             ,VOL_GROUP                                           
REARCH             ,LTRIM(RTRIM(TYPE_ROW))      AS TYPE_ROW                    
REARCH             ,RTRIM(COLUMN_1)      AS COLUMN_1                    
REARCH             ,RTRIM(COLUMN_2)      AS COLUMN_2                    
REARCH             ,RTRIM(COLUMN_3)      AS COLUMN_3                    
REARCH             ,RTRIM(COLUMN_4)      AS COLUMN_4                    
REARCH             ,RTRIM(COLUMN_5)      AS COLUMN_5                    
REARCH             ,RTRIM(COLUMN_6)      AS COLUMN_6                    
REARCH             ,RTRIM(COLUMN_7)      AS COLUMN_7                    
REARCH             ,RTRIM(COLUMN_8)      AS COLUMN_8                    
REARCH             ,RTRIM(COLUMN_9)      AS COLUMN_9                    
REARCH             ,RTRIM(COLUMN_10)     AS COLUMN_10                   
REARCH             ,RTRIM(COLUMN_11)     AS COLUMN_11                   
REARCH             ,RTRIM(COLUMN_12)     AS COLUMN_12                   
REARCH             ,RTRIM(COLUMN_13)     AS COLUMN_13                   
REARCH             ,RTRIM(COLUMN_14)     AS COLUMN_14                   
REARCH             ,RTRIM(COLUMN_15)     AS COLUMN_15                   
REARCH             ,RTRIM(COLUMN_16)     AS COLUMN_16                   
REARCH             ,RTRIM(COLUMN_17)     AS COLUMN_17                   
REARCH             ,RTRIM(COLUMN_18)     AS COLUMN_18                   
REARCH             ,RTRIM(COLUMN_19)     AS COLUMN_19                   
REARCH             ,RTRIM(COLUMN_20)     AS COLUMN_20                   
REARCH             ,RTRIM(COLUMN_21)     AS COLUMN_21                   
REARCH             ,RTRIM(COLUMN_22)     AS COLUMN_22                   
REARCH             ,RTRIM(COLUMN_23)     AS COLUMN_23                   
REARCH             ,RTRIM(COLUMN_24)     AS COLUMN_24                   
REARCH             ,RTRIM(COLUMN_25)     AS COLUMN_25                   
REARCH             ,RTRIM(COLUMN_26)     AS COLUMN_26                   
REARCH             ,RTRIM(COLUMN_27)     AS COLUMN_27                   
REARCH             ,RTRIM(COLUMN_28)     AS COLUMN_28                   
REARCH             ,RTRIM(COLUMN_29)     AS COLUMN_29                   
REARCH             ,RTRIM(COLUMN_30)     AS COLUMN_30                   
REARCH             ,RTRIM(COLUMN_31)     AS COLUMN_31                   
REARCH             ,RTRIM(COLUMN_32)     AS COLUMN_32                   
REARCH             ,RTRIM(COLUMN_33)     AS COLUMN_33                   
REARCH             ,RTRIM(COLUMN_34)     AS COLUMN_34                   
REARCH             ,RTRIM(COLUMN_35)     AS COLUMN_35                   
REARCH             ,RTRIM(COLUMN_36)     AS COLUMN_36                   
REARCH             ,LTRIM(RTRIM(RATE_PLAN))     AS RATE_PLAN                   
REARCH             ,LTRIM(RTRIM(REVENUE_CLASS)) AS REVENUE_CLASS               
REARCH             ,LTRIM(RTRIM(CATEGORY))      AS CATEGORY                    
REARCH         FROM                                                     
REARCH             #CSR02538_R1                                  
REARCH                                                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,STRIP(DAY)           AS DAY                                 
MFA-TR*            ,CODE_TIME_PERIOD                                            
MFA-TR*            ,VOL_GROUP                                                   
MFA-TR*            ,STRIP(TYPE_ROW)      AS TYPE_ROW                            
MFA-TR*            ,RTRIM(COLUMN_1)      AS COLUMN_1                            
MFA-TR*            ,RTRIM(COLUMN_2)      AS COLUMN_2                            
MFA-TR*            ,RTRIM(COLUMN_3)      AS COLUMN_3                            
MFA-TR*            ,RTRIM(COLUMN_4)      AS COLUMN_4                            
MFA-TR*            ,RTRIM(COLUMN_5)      AS COLUMN_5                            
MFA-TR*            ,RTRIM(COLUMN_6)      AS COLUMN_6                            
MFA-TR*            ,RTRIM(COLUMN_7)      AS COLUMN_7                            
MFA-TR*            ,RTRIM(COLUMN_8)      AS COLUMN_8                            
MFA-TR*            ,RTRIM(COLUMN_9)      AS COLUMN_9                            
MFA-TR*            ,RTRIM(COLUMN_10)     AS COLUMN_10                           
MFA-TR*            ,RTRIM(COLUMN_11)     AS COLUMN_11                           
MFA-TR*            ,RTRIM(COLUMN_12)     AS COLUMN_12                           
MFA-TR*            ,RTRIM(COLUMN_13)     AS COLUMN_13                           
MFA-TR*            ,RTRIM(COLUMN_14)     AS COLUMN_14                           
MFA-TR*            ,RTRIM(COLUMN_15)     AS COLUMN_15                           
MFA-TR*            ,RTRIM(COLUMN_16)     AS COLUMN_16                           
MFA-TR*            ,RTRIM(COLUMN_17)     AS COLUMN_17                           
MFA-TR*            ,RTRIM(COLUMN_18)     AS COLUMN_18                           
MFA-TR*            ,RTRIM(COLUMN_19)     AS COLUMN_19                           
MFA-TR*            ,RTRIM(COLUMN_20)     AS COLUMN_20                           
MFA-TR*            ,RTRIM(COLUMN_21)     AS COLUMN_21                           
MFA-TR*            ,RTRIM(COLUMN_22)     AS COLUMN_22                           
MFA-TR*            ,RTRIM(COLUMN_23)     AS COLUMN_23                           
MFA-TR*            ,RTRIM(COLUMN_24)     AS COLUMN_24                           
MFA-TR*            ,RTRIM(COLUMN_25)     AS COLUMN_25                           
MFA-TR*            ,RTRIM(COLUMN_26)     AS COLUMN_26                           
MFA-TR*            ,RTRIM(COLUMN_27)     AS COLUMN_27                           
MFA-TR*            ,RTRIM(COLUMN_28)     AS COLUMN_28                           
MFA-TR*            ,RTRIM(COLUMN_29)     AS COLUMN_29                           
MFA-TR*            ,RTRIM(COLUMN_30)     AS COLUMN_30                           
MFA-TR*            ,RTRIM(COLUMN_31)     AS COLUMN_31                           
MFA-TR*            ,RTRIM(COLUMN_32)     AS COLUMN_32                           
MFA-TR*            ,RTRIM(COLUMN_33)     AS COLUMN_33                           
MFA-TR*            ,RTRIM(COLUMN_34)     AS COLUMN_34                           
MFA-TR*            ,RTRIM(COLUMN_35)     AS COLUMN_35                           
MFA-TR*            ,RTRIM(COLUMN_36)     AS COLUMN_36                           
MFA-TR*            ,STRIP(RATE_PLAN)     AS RATE_PLAN                           
MFA-TR*            ,STRIP(REVENUE_CLASS) AS REVENUE_CLASS                       
MFA-TR*            ,STRIP(CATEGORY)      AS CATEGORY                            
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02538_R1                                          
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE                                                         
REARCH     'DECLARE GLOBAL TEMPORARY TABLE CSR02538_R1'                 
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02538_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02538_R1
              (                                                        
REARCH              RETURN_CODE            INT                      
REARCH             ,DAY CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
P00251             ,CODE_TIME_PERIOD       SMALLINT                     
REARCH             ,VOL_GROUP              SMALLINT                     
REARCH             ,TYPE_ROW CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_1 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_2 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_3 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_4 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_5 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_6 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_7 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_8 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_9 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,COLUMN_10 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_11 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_12 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_13 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_14 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_15 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_16 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_17 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_18 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_19 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_20 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_21 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_22 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_23 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_24 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_25 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_26 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_27 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_28 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_29 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_30 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_31 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_32 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_33 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_34 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_35 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,COLUMN_36 CHAR(14)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,RATE_PLAN CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,REVENUE_CLASS CHAR(03)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                     
REARCH             ,CATEGORY CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE TO WS-SQLSTATE.                                
REARCH     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
REARCH            MOVE SQLCODE              TO ABEND-SQLCODE            
REARCH            MOVE SQLSTATE             TO ABEND-SQLSTATE           
REARCH            MOVE '0100A'              TO ACTIVE-PARAGRAPH         
REARCH            MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
REARCH            MOVE SPACES               TO ABEND-SQL-PREDICATES     
REARCH                                         ABEND-TABLES             
REARCH            MOVE 'CSR02538_R1'        TO TABLE-1                  
REARCH            MOVE SPACES               TO TABLE-ELEMENT-1          
REARCH            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH 0100A-EXIT.                                                      
REARCH*                                                                         
      *****************************************************************         
      * 1000-PROCESS-INPUT.                                                     
      *                                                                         
      *     1. RECEIVE PARMS.                                                   
      *                                                                         
      *****************************************************************         
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                           
           MOVE PARM-COMPANY-NO     TO WS-COMPANY-NO.                   
REARCH     MOVE PARM-ACCOUNT-NO     TO PARM-ACCOUNT-NO-TEMP.            
           MOVE PARM-ACCOUNT-NO-X   TO WS-ACCOUNT-NO.                   
           MOVE PARM-BILL-NO        TO WS-BILL-NO.                      
           MOVE PARM-CODE-UTIL-TYPE TO WS-CODE-UTIL-TYPE.               
           MOVE PARM-IC-NO          TO WS-IC-NO.                        
           MOVE PARM-BILL-ITEM-TS   TO WS-BILL-ITEM-TS.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1100-RECEIVE-PARMS                                            *         
      *                                                               *         
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE          *         
      *                                                               *         
      *****************************************************************         
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
REARCH*    MOVE 1                           TO PARM-ID1.                        
REARCH*    MOVE LENGTH OF PARM-COMPANY-NO   TO MAX-LENGTH-PARM,                 
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-COMPANY-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                                TO PARM-ID1.                    
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO-X     TO MAX-LENGTH-PARM.             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO-X,                             
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                                TO PARM-ID1.                    
REARCH*    MOVE LENGTH OF PARM-BILL-NO          TO MAX-LENGTH-PARM.             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-BILL-NO,                                  
REARCH*                          TDSINT4,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                                TO PARM-ID1.                    
REARCH*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE   TO MAX-LENGTH-PARM.             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-CODE-UTIL-TYPE,                           
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                                TO PARM-ID1.                    
REARCH*    MOVE LENGTH OF PARM-IC-NO            TO MAX-LENGTH-PARM.             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-IC-NO,                                    
REARCH*                          TDSINT2,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD 1                                TO PARM-ID1.                    
REARCH*    MOVE LENGTH OF PARM-BILL-ITEM-TS     TO MAX-LENGTH-PARM.             
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-BILL-ITEM-TS,                             
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      *****************************************************************         
      * 2000-PROCESS-OUTPUT.                                                    
      *                                                                         
      *     1. DESCRIBE RESULT SET                                              
      *     2. UPDATE DB2 DATA                                                  
      *     3. BUILD RESULT SET                                                 
      *     4. SEND RESULT SET                                                  
      *                                                                         
      *****************************************************************         
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                         
           PERFORM 2200-GROUP-VOLUME THRU 2200-EXIT.                    
           IF WS-VOL-GRP-DATA-FOUND                                     
              PERFORM 2300-SEND-RESULT THRU 2300-EXIT                   
           ELSE                                                         
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*                                                             *           
REARCH*  2000A-MOVE-RESULT.                                         *           
REARCH*                                                             *           
REARCH***************************************************************           
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
ACT321                                                                  
ACT321       IF ( RS-DATE                = 'TOTAL'                      
ACT321          AND RS-CODE-TIME-PERIOD  = 9                            
ACT321          AND RS-VOL-GROUP         = 10 )                         
ACT321       MOVE SPACES                TO RS-COLUMN-4                  
ACT321                                     RS-COLUMN-5                  
ACT321       END-IF.                                                    
ACT321                                                                  
REARCH       MOVE RS-RETURN-CODE        TO S-RETURN-CODE.               
REARCH       MOVE RS-DATE               TO S-DATE.                      
REARCH       MOVE RS-CODE-TIME-PERIOD   TO S-CODE-TIME-PERIOD.          
REARCH       MOVE RS-VOL-GROUP          TO S-VOL-GROUP.                 
REARCH       MOVE RS-TYPE-ROW           TO S-TYPE-ROW.                  
REARCH       MOVE RS-COLUMN-1           TO S-COLUMN-1.                  
REARCH       MOVE RS-COLUMN-2           TO S-COLUMN-2.                  
REARCH       MOVE RS-COLUMN-3           TO S-COLUMN-3.                  
REARCH       MOVE RS-COLUMN-4           TO S-COLUMN-4.                  
REARCH       MOVE RS-COLUMN-5           TO S-COLUMN-5.                  
REARCH       MOVE RS-COLUMN-6           TO S-COLUMN-6.                  
REARCH       MOVE RS-COLUMN-7           TO S-COLUMN-7.                  
REARCH       MOVE RS-COLUMN-8           TO S-COLUMN-8.                  
REARCH       MOVE RS-COLUMN-9           TO S-COLUMN-9.                  
REARCH       MOVE RS-COLUMN-10          TO S-COLUMN-10.                 
REARCH       MOVE RS-COLUMN-11          TO S-COLUMN-11.                 
REARCH       MOVE RS-COLUMN-12          TO S-COLUMN-12.                 
REARCH       MOVE RS-COLUMN-13          TO S-COLUMN-13.                 
REARCH       MOVE RS-COLUMN-14          TO S-COLUMN-14.                 
REARCH       MOVE RS-COLUMN-15          TO S-COLUMN-15.                 
REARCH       MOVE RS-COLUMN-16          TO S-COLUMN-16.                 
REARCH       MOVE RS-COLUMN-17          TO S-COLUMN-17.                 
REARCH       MOVE RS-COLUMN-18          TO S-COLUMN-18.                 
REARCH       MOVE RS-COLUMN-19          TO S-COLUMN-19.                 
REARCH       MOVE RS-COLUMN-20          TO S-COLUMN-20.                 
REARCH       MOVE RS-COLUMN-21          TO S-COLUMN-21.                 
REARCH       MOVE RS-COLUMN-22          TO S-COLUMN-22.                 
REARCH       MOVE RS-COLUMN-23          TO S-COLUMN-23.                 
REARCH       MOVE RS-COLUMN-24          TO S-COLUMN-24.                 
REARCH       MOVE RS-COLUMN-25          TO S-COLUMN-25.                 
REARCH       MOVE RS-COLUMN-26          TO S-COLUMN-26.                 
REARCH       MOVE RS-COLUMN-27          TO S-COLUMN-27.                 
REARCH       MOVE RS-COLUMN-28          TO S-COLUMN-28.                 
REARCH       MOVE RS-COLUMN-29          TO S-COLUMN-29.                 
REARCH       MOVE RS-COLUMN-30          TO S-COLUMN-30.                 
REARCH       MOVE RS-COLUMN-31          TO S-COLUMN-31.                 
REARCH       MOVE RS-COLUMN-32          TO S-COLUMN-32.                 
REARCH       MOVE RS-COLUMN-33          TO S-COLUMN-33.                 
REARCH       MOVE RS-COLUMN-34          TO S-COLUMN-34.                 
REARCH       MOVE RS-COLUMN-35          TO S-COLUMN-35.                 
REARCH       MOVE RS-COLUMN-36          TO S-COLUMN-36.                 
REARCH       MOVE RS-RATE-PLAN          TO S-RATE-PLAN.                 
REARCH       MOVE RS-REVENUE-CLASS      TO S-REVENUE-CLASS.             
REARCH       MOVE RS-CATEGORY           TO S-CATEGORY.                  
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      *****************************************************************         
      *                                                                         
      * 2100-DESCRIBE-RESULT                                                    
      *                                                                         
      *****************************************************************         
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE '2100'          TO ACTIVE-PARAGRAPH                             
REARCH*                                                                         
REARCH*    MOVE 1                        TO CTR-COLUMN.                         
REARCH*    MOVE TDSINT4                  TO DB-HOST-TYPE                        
REARCH*                                     DB-CLIENT-TYPE.                     
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-RETURN-CODE,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-DATE           TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-DAY            TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-DATE,                                       
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-DAY,                                        
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSINT2                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSINT2                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-VOL-GROUP      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-VOL-GROUP      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-VOL-GROUP,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-VOL-GROUP,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-TYPE-ROW       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-TYPE-ROW       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-TYPE-ROW,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-TYPE-ROW,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-1       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-1       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-1,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-1,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-2       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-2       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-2,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-2,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-3       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-3       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-3,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-3,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE                     
REARCH*                                        DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-4       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-4       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-4,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-4,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-5       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-5       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-5,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-5,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-6       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-6       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-6,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-6,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-7       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-7       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-7,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-7,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-8       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-8       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-8,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-8,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-9       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-9       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-9,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-9,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-10      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-10      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-10,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-10,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-11      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-11      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-11,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-11,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-12      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-12      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-12,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-12,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-13      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-13      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-13,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-13,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-14      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-14      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-14,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-14,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-15      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-15      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-15,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-15,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-16      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-16      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-16,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-16,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-17      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-17      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-17,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-17,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-18      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-18      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-18,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-18,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-19      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-19      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-19,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-19,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-20      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-20      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-20,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-20,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-21      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-21      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-21,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-21,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-22      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-22      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-22,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-22,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-23      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-23      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-23,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-23,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-24      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-24      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-24,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-24,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-25      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-25      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-25,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-25,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-26      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-26      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-26,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-26,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-27      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-27      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-27,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-27,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-28      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-28      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-28,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-28,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-29      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-29      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-29,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-29,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-30      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-30      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-30,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-30,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-31      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-31      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-31,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-31,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-32      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-32      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-32,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-32,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-33      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-33      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-33,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-33,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-34      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-34      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-34,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-34,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-35      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-35      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-35,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-35,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-COLUMN-36      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-COLUMN-36      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-COLUMN-36,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-COLUMN-36,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-RATE-PLAN      TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-RATE-PLAN      TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RATE-PLAN,                                  
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-RATE-PLAN,                                  
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-REVENUE-CLASS  TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-REVENUE-CLASS  TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-REVENUE-CLASS,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-REVENUE-CLASS,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*    ADD  1                           TO CTR-COLUMN.                      
REARCH*    MOVE TDSCHAR                     TO DB-HOST-TYPE.                    
REARCH*    MOVE TDSCHAR                     TO DB-CLIENT-TYPE.                  
REARCH*    MOVE LENGTH OF RS-CATEGORY       TO WRKLEN1.                         
REARCH*    MOVE LENGTH OF CN-CATEGORY       TO WRKLEN2.                         
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CATEGORY,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-CATEGORY,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
      *                                                                         
      *****************************************************************         
      * 2200-GROUP-VOLUME.                                                      
      *                                                                         
      *****************************************************************         
       2200-GROUP-VOLUME.                                               
                                                                        
           MOVE '2200'              TO ACTIVE-PARAGRAPH.                
                                                                        
      ****************************************************************          
      * GET INFORMATION FOR PANEL HEADINGS                           *          
      ****************************************************************          
                                                                        
           MOVE 0 TO WS-DAY-IND, WS-COLUMN-IND .                        
           INITIALIZE WS-COLUMN-TABLE, WS-DAY-TABLE.                    
           MOVE 'N' TO WS-DATA-FOUND-FLAG, WS-VOL-GRP-DATA-FOUND-FLAG.  
                                                                        
           MOVE WS-COMPANY-NO TO X8-COMPANY-NO.                         
           MOVE WS-CODE-UTIL-TYPE TO X8-CODE-UTIL-TYPE.                 
                                                                        
           PERFORM 2600-GET-BILLING-DET THRU 2600-EXIT.                 
                                                                        
           PERFORM 7270-GET-TIMESTMP       THRU 7270-EXIT.              
           PERFORM 7280-GET-TIMESTMP       THRU 7280-EXIT.              
                                                                        
           PERFORM 7000-OPEN-HEADINGS-CSR   THRU 7000-EXIT.             
           PERFORM 7010-FETCH-HEADINGS-CSR  THRU 7010-EXIT.             
           MOVE X8-VOL-GROUP-CD TO WS-SAVE-VOL-GROUP-CD.                
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
                IF X8-VOL-GROUP-CD NOT = WS-SAVE-VOL-GROUP-CD           
                   IF WS-VOL-GRP-DATA-FOUND                             
                      PERFORM 2300-SEND-RESULT THRU 2300-EXIT           
                   END-IF                                               
                   INITIALIZE WS-DAY-TABLE , WS-COLUMN-TABLE            
                   MOVE 0 TO WS-DAY-IND, WS-COLUMN-IND                  
                   IF X8-VOL-GROUP-CD = 20                              
                     MOVE WS-ACCOUNT-NO     TO CX-ACCOUNT-NO            
                     MOVE WS-BILL-NO        TO CX-BILL-NO               
                     MOVE WS-CODE-UTIL-TYPE TO CX-CODE-UTIL-TYPE        
                     MOVE WS-IC-NO          TO CX-IC-NO                 
                     MOVE WS-BILL-ITEM-TS   TO CX-BILL-ITEM-TIMESTMP    
                                                                        
                     PERFORM 7230-OPEN-CNSMPTN-CSR  THRU 7230-EXIT      
                     PERFORM 7240-FETCH-CNSMPTN-CSR THRU 7240-EXIT      
                     MOVE CX-METER-NO     TO WS-SAVE-METER-NO           
                     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL         
                       ADD +1             TO WS-COLUMN-IND              
                       MOVE '  METER   '  TO WS-DISPLAY-HEADING-1       
                       MOVE CX-METER-NO   TO WS-DISPLAY-HEADING-2       
                       MOVE '   MCF     ' TO WS-DISPLAY-HEADING-3       
                       MOVE SPACES        TO WS-DISPLAY-HEADING-4       
                       MOVE WS-DISPLAY-HEADING-1                        
                                        TO WS-HEADING-1(WS-COLUMN-IND)  
                       MOVE WS-DISPLAY-HEADING-2                        
                                        TO WS-HEADING-2(WS-COLUMN-IND)  
                       MOVE WS-DISPLAY-HEADING-3                        
                                        TO WS-HEADING-3(WS-COLUMN-IND)  
                       MOVE WS-DISPLAY-HEADING-4                        
                                        TO WS-HEADING-4(WS-COLUMN-IND)  
                       PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND  
                       IF CX-METER-NO     NOT = WS-SAVE-METER-NO        
                          MOVE 0 TO WS-DAY-IND                          
                          ADD +1             TO WS-COLUMN-IND           
                          MOVE CX-METER-NO   TO WS-SAVE-METER-NO        
                          MOVE '  METER   '  TO WS-DISPLAY-HEADING-1    
                          MOVE CX-METER-NO   TO WS-DISPLAY-HEADING-2    
                          MOVE '   MCF     ' TO WS-DISPLAY-HEADING-3    
                          MOVE WS-DISPLAY-HEADING-1                     
                                        TO WS-HEADING-1(WS-COLUMN-IND)  
                          MOVE WS-DISPLAY-HEADING-2                     
                                        TO WS-HEADING-2(WS-COLUMN-IND)  
                          MOVE WS-DISPLAY-HEADING-3                     
                                        TO WS-HEADING-3(WS-COLUMN-IND)  
                          MOVE WS-DISPLAY-HEADING-4                     
                                        TO WS-HEADING-4(WS-COLUMN-IND)  
                       END-IF                                           
                       PERFORM 7260-LOAD-CX-TABLE     THRU 7260-EXIT    
                       PERFORM 7240-FETCH-CNSMPTN-CSR THRU 7240-EXIT    
                       END-PERFORM                                      
                    END-IF                                              
                    PERFORM 7250-CLOSE-CNSMPTN-CSR THRU 7250-EXIT       
                   END-IF                                               
                   MOVE X8-VOL-GROUP-CD TO WS-SAVE-VOL-GROUP-CD         
                   MOVE 'N' TO WS-VOL-GRP-DATA-FOUND-FLAG               
                END-IF                                                  
                MOVE 'N' TO WS-DATA-FOUND-FLAG                          
                PERFORM 2500-GET-TRANS-VOLUME THRU 2500-EXIT            
                IF WS-DATA-FOUND                                        
                   PERFORM 2400-LOAD-HEADINGS THRU 2400-EXIT            
                END-IF                                                  
                  PERFORM 7010-FETCH-HEADINGS-CSR THRU 7010-EXIT        
           END-PERFORM.                                                 
           PERFORM 7020-CLOSE-HEADINGS-CSR  THRU 7020-EXIT.             
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2300-SEND-RESULT.                                                
                                                                        
P00251*    FOR HEADER AND SUMMARY ROWS TIME PERIOD SET AS 9                     
P00251     MOVE +9      TO RS-CODE-TIME-PERIOD.                         
           PERFORM VARYING WS-HEAD-IND FROM 1 BY 1                      
              UNTIL WS-HEAD-IND > 4                                     
              MOVE 'H' TO RS-TYPE-ROW                                   
              MOVE WS-SAVE-VOL-GROUP-CD TO RS-VOL-GROUP                 
              IF WS-HEAD-IND = 2                                        
      *                                                                         
      *          STRING WS-DATE-READ-MM '/'                                     
      *                 WS-DATE-READ-YY DELIMITED BY SIZE                       
                 MOVE WS-DATE-READ                                      
                           TO RS-DATE                                   
              END-IF                                                    
              PERFORM VARYING WS-COLUMN-IND FROM 1 BY 1                 
                UNTIL WS-COLUMN-IND > 36                                
                   MOVE WS-HEADING(WS-COLUMN-IND, WS-HEAD-IND)          
                                  TO RS-COLUMN(WS-COLUMN-IND)           
              END-PERFORM                                               
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-PERFORM.                                                 
                                                                        
           INITIALIZE RS-COLUMNS.                                       
                                                                        
           PERFORM VARYING WS-DAY-IND FROM 1 BY 1                       
              UNTIL WS-DAY-IND > 31                                     
              IF (WS-DATE(WS-DAY-IND) NOT = SPACES AND LOW-VALUES)      
P00251          PERFORM VARYING WS-TM-PRD-IND FROM 1 BY 1               
P00251          UNTIL WS-TM-PRD-IND > 4                                 
P00251            INITIALIZE RS-COLUMNS                                 
P00251            IF WS-CODE-TIME-PERIOD(WS-DAY-IND, WS-TM-PRD-IND)     
P00251                                > ZERO                            
P00251               IF WS-CODE-TIME-PERIOD(WS-DAY-IND, WS-TM-PRD-IND)  
P00251                  = +4                                            
P00251                  MOVE ZERO              TO RS-CODE-TIME-PERIOD   
P00251               ELSE                                               
P00251                  MOVE                                            
P00251                    WS-CODE-TIME-PERIOD(WS-DAY-IND, WS-TM-PRD-IND)
P00251                                         TO RS-CODE-TIME-PERIOD   
P00251               END-IF                                             
                     MOVE WS-DATE(WS-DAY-IND)      TO RS-DATE           
                     MOVE WS-VOL-GROUP(WS-DAY-IND) TO RS-VOL-GROUP      
                     MOVE 'D'                      TO RS-TYPE-ROW       
                     PERFORM VARYING WS-COLUMN-IND FROM 1 BY 1          
                     UNTIL WS-COLUMN-IND > 36                           
P00251                  MOVE                                            
P00251                WS-UNITS(WS-DAY-IND, WS-TM-PRD-IND, WS-COLUMN-IND)
                                         TO RS-COLUMN(WS-COLUMN-IND)    
                     END-PERFORM                                        
REARCH               PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT          
                     PERFORM 8100-SEND-RESULT THRU 8100-EXIT            
                  END-IF                                                
                END-PERFORM                                             
              END-IF                                                    
           END-PERFORM.                                                 
                                                                        
           MOVE 'TOTAL' TO RS-DATE.                                     
P00251     MOVE +9      TO RS-CODE-TIME-PERIOD.                         
           PERFORM VARYING WS-COLUMN-IND FROM 1 BY 1                    
              UNTIL WS-COLUMN-IND > 36                                  
              MOVE WS-COLUMN-TOT(WS-COLUMN-IND) TO WS-NO-UNITS          
              IF ( WS-COLUMN-TOT(WS-COLUMN-IND) >= 0)                   
                 INSPECT WS-NO-UNITS REPLACING LEADING ZEROS BY SPACES  
                 STRING WS-NO-UNITS(1:9) '.' WS-NO-UNITS(10:1)          
                        DELIMITED BY SIZE                               
                        INTO WS-TOTALS                                  
              ELSE                                                      
                COMPUTE WS-SIGN-UNITS =                                 
                                   WS-COLUMN-TOT(WS-COLUMN-IND)         
                STRING WS-SIGN-UNITS(1:9) '.' WS-NO-UNITS(10:1)         
                       DELIMITED BY SIZE                                
                       INTO WS-TOTALS                                   
              END-IF                                                    
              IF WS-COLUMN-TOT(WS-COLUMN-IND) = 0                       
                 MOVE SPACES TO  WS-TOTALS                              
              END-IF                                                    
              MOVE WS-TOTALS TO RS-COLUMN(WS-COLUMN-IND)                
           END-PERFORM.                                                 
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           MOVE SPACES TO RS-DATE.                                      
           MOVE ZEROS  TO RS-RETURN-CODE.                               
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2400-LOAD-HEADINGS.                                              
                                                                        
           IF X8-COLUMN-HEADER1(1:1) = '&'                              
              MOVE SPACES TO WS-DISPLAY-HEADING                         
              MOVE X8-COLUMN-HEADER1 TO WS-HOLD-HEADER                  
              PERFORM 2410-GET-VAR-HEAD THRU 2410-EXIT                  
              MOVE WS-DISPLAY-HEADING TO WS-DISPLAY-HEADING-1           
           ELSE                                                         
              MOVE X8-COLUMN-HEADER1 TO WS-DISPLAY-HEADING-1            
           END-IF.                                                      
                                                                        
           IF X8-COLUMN-HEADER2(1:1) = '&'                              
              MOVE SPACES TO WS-DISPLAY-HEADING                         
              MOVE X8-COLUMN-HEADER2 TO WS-HOLD-HEADER                  
              PERFORM 2410-GET-VAR-HEAD THRU 2410-EXIT                  
              MOVE WS-DISPLAY-HEADING TO WS-DISPLAY-HEADING-2           
           ELSE                                                         
              MOVE X8-COLUMN-HEADER2 TO WS-DISPLAY-HEADING-2            
           END-IF.                                                      
                                                                        
           IF X8-COLUMN-HEADER3(1:1) = '&'                              
              MOVE SPACES TO WS-DISPLAY-HEADING                         
              MOVE X8-COLUMN-HEADER3 TO WS-HOLD-HEADER                  
              PERFORM 2410-GET-VAR-HEAD THRU 2410-EXIT                  
              MOVE WS-DISPLAY-HEADING TO WS-DISPLAY-HEADING-3           
           ELSE                                                         
              MOVE X8-COLUMN-HEADER3 TO WS-DISPLAY-HEADING-3            
           END-IF.                                                      
                                                                        
           IF X8-COLUMN-HEADER4(1:1) = '&'                              
              MOVE SPACES TO WS-DISPLAY-HEADING                         
              MOVE X8-COLUMN-HEADER4 TO WS-HOLD-HEADER                  
              PERFORM 2410-GET-VAR-HEAD THRU 2410-EXIT                  
              MOVE WS-DISPLAY-HEADING TO WS-DISPLAY-HEADING-4           
           ELSE                                                         
              MOVE X8-COLUMN-HEADER4 TO WS-DISPLAY-HEADING-4            
           END-IF.                                                      
                                                                        
           IF WS-DISPLAY-HEADING-1 NOT = SPACES                         
              MOVE WS-DISPLAY-HEADING-1 TO WS-HEADING-1(WS-COLUMN-IND)  
              MOVE WS-DISPLAY-HEADING-2 TO WS-HEADING-2(WS-COLUMN-IND)  
              MOVE WS-DISPLAY-HEADING-3 TO WS-HEADING-3(WS-COLUMN-IND)  
              MOVE WS-DISPLAY-HEADING-4 TO WS-HEADING-4(WS-COLUMN-IND)  
           ELSE                                                         
            IF WS-DISPLAY-HEADING-2 NOT = SPACES                        
               MOVE WS-DISPLAY-HEADING-2 TO WS-HEADING-1(WS-COLUMN-IND) 
               MOVE WS-DISPLAY-HEADING-3 TO WS-HEADING-2(WS-COLUMN-IND) 
               MOVE WS-DISPLAY-HEADING-4 TO WS-HEADING-3(WS-COLUMN-IND) 
               MOVE SPACES TO WS-HEADING-4(WS-COLUMN-IND)               
            ELSE                                                        
              IF WS-DISPLAY-HEADING-3 NOT = SPACES                      
                 MOVE WS-DISPLAY-HEADING-3                              
                                TO WS-HEADING-1(WS-COLUMN-IND)          
                 MOVE WS-DISPLAY-HEADING-4                              
                                TO WS-HEADING-2(WS-COLUMN-IND)          
                 MOVE SPACES TO WS-HEADING-3(WS-COLUMN-IND),            
                                WS-HEADING-4(WS-COLUMN-IND)             
              ELSE                                                      
                MOVE WS-DISPLAY-HEADING-4 TO WS-HEADING-1(WS-COLUMN-IND)
                MOVE SPACES TO WS-HEADING-2(WS-COLUMN-IND),             
                               WS-HEADING-3(WS-COLUMN-IND),             
                               WS-HEADING-4(WS-COLUMN-IND)              
              END-IF                                                    
            END-IF                                                      
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2410-GET-VAR-HEAD.                                               
                                                                        
           EVALUATE WS-HOLD-HEADER                                      
              WHEN '&SHRINK'                                            
                    PERFORM 2420-GET-SHRINK-PERCENT THRU 2420-EXIT      
              WHEN '&RATE'                                              
                    PERFORM 2430-GET-RATE-SCHED THRU 2430-EXIT          
              WHEN '&PRICE'                                             
                    PERFORM 2440-GET-PRICE THRU 2440-EXIT               
              WHEN '&CAT'                                               
                    PERFORM 2450-GET-SERVICE-CAT THRU 2450-EXIT         
           END-EVALUATE.                                                
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2420-GET-SHRINK-PERCENT.                                         
                                                                        
           PERFORM 7200-GET-CONTRACT-DATE THRU 7200-EXIT.               
           MOVE ND-ACCOUNT-NO TO TW-ACCOUNT-NO.                         
           MOVE ND-CODE-UTIL-TYPE TO TW-CODE-UTIL-TYPE.                 
           MOVE ND-IC-NO TO TW-PRIMARY-IC-NO.                           
           PERFORM 7210-GET-PERCENT THRU 7210-EXIT.                     
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE TW-TRNSP-SHRINK-PCT TO WS-TRNSP-SHRINK-PCT           
           ELSE                                                         
              MOVE ZEROS TO WS-TRNSP-SHRINK-PCT                         
           END-IF.                                                      
                                                                        
           MOVE WS-TRNSP-SHRINK-PCT TO WS-DISPLAY-PCT.                  
           STRING WS-DISPLAY-PCT '%' DELIMITED BY SIZE                  
                  INTO WS-DISPLAY-HEADING.                              
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2430-GET-RATE-SCHED.                                             
                                                                        
           STRING 'RATE '                                               
                  WS-RATE-PLAN DELIMITED BY SIZE                        
             INTO WS-DISPLAY-HEADING.                                   
                                                                        
       2430-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2440-GET-PRICE.                                                  
                                                                        
           MOVE WS-ACCOUNT-NO     TO FH-ACCOUNT-NO.                     
           MOVE WS-BILL-NO        TO FH-BILL-NO.                        
           MOVE WS-CODE-UTIL-TYPE TO FH-CODE-UTIL-TYPE.                 
           MOVE WS-IC-NO          TO FH-IC-NO.                          
           MOVE WS-BILL-ITEM-TS   TO FH-BILL-ITEM-TIMESTMP.             
                                                                        
           PERFORM 7220-GET-COMP-PRICE    THRU 7220-EXIT.               
                                                                        
           MOVE WS-FACTOR-CHAR    TO WS-DISPLAY-HEADING.                
                                                                        
       2440-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2450-GET-SERVICE-CAT.                                            
                                                                        
           STRING 'CATEGORY'                                            
                  WS-CATEGORY DELIMITED BY SIZE                         
             INTO WS-DISPLAY-HEADING.                                   
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-GET-TRANS-VOLUME.                                           
                                                                        
           MOVE WS-ACCOUNT-NO TO ND-ACCOUNT-NO.                         
           MOVE WS-BILL-NO TO ND-BILL-NO.                               
           MOVE WS-CODE-UTIL-TYPE TO ND-CODE-UTIL-TYPE.                 
           MOVE WS-IC-NO TO ND-IC-NO.                                   
           MOVE WS-BILL-ITEM-TS TO ND-BILL-ITEM-TIMESTMP.               
           MOVE X8-VOL-TYPE-CD TO ND-VOL-TYPE-CD.                       
           MOVE X8-ENERGY-UNIT-CD TO ND-ENERGY-UNIT-CD.                 
           IF X8-VOL-GROUP-CD = 30 AND X8-VOL-TYPE-CD = 'CP'            
              PERFORM 7290-GET-MAX-SEQ THRU 7290-EXIT                   
           END-IF                                                       
C35902                                                                  
C35902     IF X8-VOL-TYPE-CD = 'VM'                                     
C35902       MOVE ND-BILL-ITEM-TIMESTMP TO WS-TRNSP-TS1                 
C35902                                     WS-TRNSP-TS2                 
C35902     END-IF.                                                      
           PERFORM 7050-OPEN-TRANS-VOL-CSR THRU 7050-EXIT.              
           PERFORM 7060-FETCH-TRANS-VOL-CSR THRU 7060-EXIT.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE ND-FIXED-FCTR-SEQ-NO TO WS-PREV-SEQ-NO               
              ADD 1 TO WS-COLUMN-IND                                    
           END-IF                                                       
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               MOVE 'Y' TO WS-DATA-FOUND-FLAG,                          
                           WS-VOL-GRP-DATA-FOUND-FLAG                   
               MOVE ND-FIXED-FCTR-SEQ-NO TO WS-FIXED-FCTR-SEQ-NO        
               IF X8-VOL-GROUP-CD = 30  AND X8-VOL-TYPE-CD = 'CP'       
               AND WS-FIXED-FCTR-SEQ-NO NOT EQUAL WS-PREV-SEQ-NO        
                  MOVE WS-DATE-READ      TO WS-DATE-READ-FH             
                  PERFORM 2400-LOAD-HEADINGS THRU 2400-EXIT             
                  ADD 1 TO WS-COLUMN-IND                                
                  MOVE ND-FIXED-FCTR-SEQ-NO TO WS-PREV-SEQ-NO           
               END-IF                                                   
               PERFORM 2550-LOAD-TRANS-VOL-TABLE THRU 2550-EXIT         
               PERFORM 7060-FETCH-TRANS-VOL-CSR THRU 7060-EXIT          
           END-PERFORM.                                                 
           PERFORM 7070-CLOSE-TRANS-VOL-CSR THRU 7070-EXIT.             
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2550-LOAD-TRANS-VOL-TABLE.                                       
                                                                        
           MOVE ND-DATE-READ      TO WS-DATE-READ                       
                                     WS-DATE-READ-FH                    
           MOVE WS-DATE-READ-DD-N TO WS-DAY-IND.                        
           MOVE WS-DATE-READ      TO WS-DATE(WS-DAY-IND).               
P00251*    FOR ZERO TIME PERIOD SET AS +4 AND LATER CHANGED TO ZERO             
P00251     IF ND-CODE-TIME-PERIOD = ZERO                                
P00251        MOVE +4                  TO WS-TM-PRD-IND                 
P00251                                    ND-CODE-TIME-PERIOD           
P00251     ELSE                                                         
P00251        MOVE ND-CODE-TIME-PERIOD TO WS-TM-PRD-IND                 
P00251     END-IF                                                       
P00251     MOVE ND-CODE-TIME-PERIOD TO                                  
P00251                  WS-CODE-TIME-PERIOD(WS-DAY-IND,WS-TM-PRD-IND).  
                                                                        
           MOVE ND-NO-UNITS TO WS-NO-UNITS.                             
           IF ND-NO-UNITS > 0                                           
           INSPECT WS-NO-UNITS REPLACING LEADING ZEROS BY SPACES        
           STRING WS-NO-UNITS(1:9) '.' WS-NO-UNITS(10:1)                
                  DELIMITED BY SIZE                                     
P00251     INTO WS-UNITS(WS-DAY-IND, WS-TM-PRD-IND, WS-COLUMN-IND)      
P00251     ELSE                                                         
P00251        IF ND-NO-UNITS < 0                                        
P00251           MOVE ND-NO-UNITS TO WS-UNITS-NEG                       
P00251           INITIALIZE WS-CNTR                                     
P00251           INSPECT WS-UNITS-NEG TALLYING WS-CNTR FOR LEADING      
P00251                                                       ZEROS      
P00251                           REPLACING LEADING ZEROS BY SPACES      
P00251                                                                  
P00251           STRING  WS-UNITS-NEG(1:(WS-CNTR - 1))                  
P00251                  '-' WS-UNITS-NEG((WS-CNTR + 1):(9 - WS-CNTR))   
P00251                                          '.' WS-NO-UNITS(10:1)   
P00251                  DELIMITED BY SIZE                               
P00251           INTO WS-UNITS(WS-DAY-IND,WS-TM-PRD-IND, WS-COLUMN-IND) 
MAN015      INSPECT WS-UNITS(WS-DAY-IND,WS-TM-PRD-IND, WS-COLUMN-IND)   
MAN015                           REPLACING LEADING ZEROS BY SPACES      
P00251        END-IF                                                    
           END-IF.                                                      
           MOVE X8-VOL-GROUP-CD TO WS-VOL-GROUP(WS-DAY-IND).            
           ADD ND-NO-UNITS TO WS-COLUMN-TOT(WS-COLUMN-IND).             
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-GET-BILLING-DET.                                            
                                                                        
           MOVE WS-ACCOUNT-NO TO BG-ACCOUNT-NO.                         
           MOVE WS-BILL-NO TO BG-BILL-NO.                               
           MOVE WS-CODE-UTIL-TYPE TO BG-CODE-UTIL-TYPE.                 
           MOVE WS-IC-NO TO BG-IC-NO.                                   
           MOVE WS-BILL-ITEM-TS TO BG-BILL-ITEM-TIMESTMP.               
                                                                        
           PERFORM 7100-GET-BILLING-DET THRU 7100-EXIT.                 
                                                                        
           MOVE BG-RATE-PLAN-NO TO RS-RATE-PLAN, WS-RATE-PLAN.          
           MOVE BG-CODE-REVENUE-CLASS TO RS-REVENUE-CLASS.              
                                                                        
           MOVE BG-COMPANY-NO TO Z4-COMPANY-NO.                         
T32708     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T32708        MOVE ZEROS TO BG-CODE-CURTAIL-PRTY                        
T32708     ELSE                                                         
              MOVE BG-CODE-CURTAIL-PRTY TO Z4-CODE-CURTAIL-PRTY         
T32708     END-IF.                                                      
                                                                        
           PERFORM 7150-GET-CATEGORY THRU 7150-EXIT.                    
                                                                        
           MOVE Z4-PRTY-SVC-CAT-CD TO RS-CATEGORY, WS-CATEGORY.         
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      *                                                                         
      * DATABASE SELECTS                                                        
      *                                                                         
      *****************************************************************         
                                                                        
       7000-OPEN-HEADINGS-CSR.                                          
                                                                        
           MOVE '7000'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               OPEN HEADINGS-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7000'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_VOL_TYPE'            TO TABLE-1                 
              MOVE 'VOL_GROUP_CD'            TO TABLE-ELEMENT-1         
              MOVE X8-VOL-GROUP-CD           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7010-FETCH-HEADINGS-CSR.                                         
                                                                        
           EXEC SQL                                                     
              FETCH HEADINGS-CSR                                        
              INTO  :X8-VOL-TYPE-CD,                                    
                    :X8-VOL-GROUP-CD,                                   
                    :X8-ENERGY-UNIT-CD,                                 
                    :X8-CMPNT-ID-CD,                                    
                    :X8-MANUAL-ENTRY-FL,                                
                    :X8-ACCUM-TOTAL-FL,                                 
                    :X8-COLUMN-HEADER1,                                 
                    :X8-COLUMN-HEADER2,                                 
                    :X8-COLUMN-HEADER3,                                 
                    :X8-COLUMN-HEADER4,                                 
                    :X8-STATUS-CD,                                      
                    :X8-STATUS-CHANGE-DT                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7010'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
              MOVE 'CSS_VOL-TYPE'         TO TABLE-1                    
              MOVE 'VOL_GROUP_CD'         TO TABLE-ELEMENT-1            
              MOVE X8-VOL-GROUP-CD        TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CLOSE-HEADINGS-CSR.                                         
                                                                        
           EXEC SQL                                                     
              CLOSE HEADINGS-CSR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7020'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_VOL_TYPE'            TO TABLE-1                 
              MOVE 'VOL_GROUP_CD'            TO TABLE-ELEMENT-1         
              MOVE X8-VOL-GROUP-CD           TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
       7050-OPEN-TRANS-VOL-CSR.                                         
                                                                        
           MOVE '7050'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               OPEN TRANS-VOL-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7050'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_VOL_DAILY'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE ND-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7060-FETCH-TRANS-VOL-CSR.                                        
                                                                        
           EXEC SQL                                                     
              FETCH TRANS-VOL-CSR                                       
              INTO  :ND-NO-UNITS,                                       
                    :ND-DATE-READ,                                      
P00251              :ND-CODE-TIME-PERIOD,                               
                    :ND-FIXED-FCTR-SEQ-NO                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                     
                 MOVE +100             TO RS-RETURN-CODE                
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE '7060'                 TO ACTIVE-PARAGRAPH        
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE SPACES                 TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
                 MOVE 'CSS_VOL-DAILY'        TO TABLE-1                 
                 MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1         
                 MOVE ND-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1       
                 PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT            
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7070-CLOSE-TRANS-VOL-CSR.                                        
                                                                        
           EXEC SQL                                                     
              CLOSE TRANS-VOL-CSR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7070'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_VOL_DAILY'           TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE ND-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7100-GET-BILLING-DET.                                            
                                                                        
           EXEC SQL                                                     
              SELECT RATE_PLAN_NO,                                      
                     CODE_REVENUE_CLASS,                                
                     CODE_CURTAIL_PRTY,                                 
                     COMPANY_NO                                         
              INTO  :BG-RATE-PLAN-NO,                                   
                    :BG-CODE-REVENUE-CLASS,                             
                    :BG-CODE-CURTAIL-PRTY,                              
                    :BG-COMPANY-NO                                      
              FROM CSS_BILLING_DET BG WITH(READUNCOMMITTED)                     
              WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                 
                AND BILL_NO            = :BG-BILL-NO                    
                AND IC_NO              = :BG-IC-NO                      
                AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE             
                AND BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :BG-BILL-ITEM-TIMESTMP
              )         
C35902                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RATE_PLAN_NO,                                              
MFA-TR*              CODE_REVENUE_CLASS,                                        
MFA-TR*              CODE_CURTAIL_PRTY,                                         
MFA-TR*              COMPANY_NO                                                 
MFA-TR*       INTO  :BG-RATE-PLAN-NO,                                           
MFA-TR*             :BG-CODE-REVENUE-CLASS,                                     
MFA-TR*             :BG-CODE-CURTAIL-PRTY,                                      
MFA-TR*             :BG-COMPANY-NO                                              
MFA-TR*       FROM CSS_BILLING_DET BG                                           
MFA-TR*       WHERE ACCOUNT_NO         = :BG-ACCOUNT-NO                         
MFA-TR*         AND BILL_NO            = :BG-BILL-NO                            
MFA-TR*         AND IC_NO              = :BG-IC-NO                              
MFA-TR*         AND CODE_UTIL_TYPE     = :BG-CODE-UTIL-TYPE                     
MFA-TR*         AND BILL_ITEM_TIMESTMP = :BG-BILL-ITEM-TIMESTMP                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7100'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
              MOVE 'CSS_BILLING_DET'      TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE BG-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7150-GET-CATEGORY.                                               
                                                                        
           EXEC SQL                                                     
               SELECT PRTY_SVC_CAT_CD                                   
                 INTO :Z4-PRTY-SVC-CAT-CD                               
                 FROM CSS_PRTY_SVC_CAT Z4 WITH(READUNCOMMITTED)                 
                WHERE COMPANY_NO        = :Z4-COMPANY-NO                
                  AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY         
C35902                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PRTY_SVC_CAT_CD                                           
MFA-TR*          INTO :Z4-PRTY-SVC-CAT-CD                                       
MFA-TR*          FROM CSS_PRTY_SVC_CAT Z4                                       
MFA-TR*         WHERE COMPANY_NO        = :Z4-COMPANY-NO                        
MFA-TR*           AND CODE_CURTAIL_PRTY = :Z4-CODE-CURTAIL-PRTY                 
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
T32708     ELSE                                                         
T32708       IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                       
T32708          MOVE SPACES TO Z4-PRTY-SVC-CAT-CD                       
             ELSE                                                       
                MOVE PROGRAM-NAME           TO ABEND-PROGRAM            
                MOVE '7150'                 TO ACTIVE-PARAGRAPH         
                MOVE 'FETCH'                TO ABEND-FUNCTION           
                MOVE SPACES                 TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
                MOVE 'CSS_PRTY_SVC_CAT'     TO TABLE-1                  
                MOVE 'CODE_CURTAIL_PRTY'    TO TABLE-ELEMENT-1          
                MOVE Z4-COMPANY-NO          TO HOSTVAR-ELEMENT-1        
                PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT             
             END-IF                                                     
T32708     END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-GET-CONTRACT-DATE.                                          
                                                                        
            EXEC SQL                                                    
               SELECT MIN(DATE_READ)                                    
                     ,MAX(DATE_READ)                                    
                 INTO :WS-CIGVOL-START-DATE :WS-NULL-IND-1              
                     ,:WS-CIGVOL-END-DATE :WS-NULL-IND-2              
                 FROM CSS_VOL_DAILY WITH(READUNCOMMITTED)                       
                WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO               
                  AND BILL_NO            = :ND-BILL-NO                  
                  AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE           
                  AND IC_NO              = :ND-IC-NO                    
                  AND BILL_ITEM_TIMESTMP=  CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              )       
C35902                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT MIN(DATE_READ)                                            
MFA-TR*              ,MAX(DATE_READ)                                            
MFA-TR*          INTO :WS-CIGVOL-START-DATE :WS-NULL-IND-1                      
MFA-TR*              ,:WS-CIGVOL-END-DATE   :WS-NULL-IND-2                      
MFA-TR*          FROM CSS_VOL_DAILY                                             
MFA-TR*         WHERE ACCOUNT_NO         = :ND-ACCOUNT-NO                       
MFA-TR*           AND BILL_NO            = :ND-BILL-NO                          
MFA-TR*           AND CODE_UTIL_TYPE     = :ND-CODE-UTIL-TYPE                   
MFA-TR*           AND IC_NO              = :ND-IC-NO                            
MFA-TR*           AND BILL_ITEM_TIMESTMP=  :ND-BILL-ITEM-TIMESTMP               
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7200'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
              MOVE 'CSS_VOL_DAILY'        TO TABLE-1                    
              MOVE 'CODE_CURTAIL_PRTY'    TO TABLE-ELEMENT-1            
              MOVE ND-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7210-GET-PERCENT.                                                
                                                                        
            EXEC SQL                                                    
               SELECT TRNSP_MDQ                                         
                     ,TRNSP_SHRINK_PCT                                  
                 INTO :TW-TRNSP-MDQ :WS-NULL-IND-3                     
                     ,:TW-TRNSP-SHRINK-PCT :WS-NULL-IND-4               
                 FROM CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED)               
                     ,CSS_BILL_CONTRACT BC WITH(READUNCOMMITTED)                
                WHERE TW.ACCOUNT_NO         = :TW-ACCOUNT-NO            
                  AND TW.CODE_UTIL_TYPE     = :TW-CODE-UTIL-TYPE        
                  AND TW.PRIMARY_IC_NO      = :TW-PRIMARY-IC-NO         
                  AND TW.ACCOUNT_NO         = BC.ACCOUNT_NO             
                  AND TW.CODE_UTIL_TYPE     = BC.CODE_UTIL_TYPE         
                  AND TW.PRIMARY_IC_NO      = BC.IC_NO                  
                  AND BC.CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-CIGVOL-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CIGVOL-START-DATE
              ) <> 0) OR (LEN(:WS-CIGVOL-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CIGVOL-START-DATE
              ), CONVERT(DATE, :WS-CIGVOL-START-DATE) )       
                  AND BC.CNTRCT_END_DT   >= IIF(TRY_CONVERT(DATE, 
                                                    :WS-CIGVOL-END-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CIGVOL-END-DATE
              ) <> 0) OR (LEN(:WS-CIGVOL-END-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CIGVOL-END-DATE
              ), CONVERT(DATE, :WS-CIGVOL-END-DATE) )         
              AND TW.CNTRCT_START_DT = (SELECT MAX(T1.CNTRCT_START_DT)  
                            FROM CSS_TRNSP_CONTRACT T1
                           WITH(READUNCOMMITTED)                  
                            WHERE T1.ACCOUNT_NO  = TW.ACCOUNT_NO        
                            AND   T1.CODE_UTIL_TYPE = TW.CODE_UTIL_TYPE 
                            AND   T1.PRIMARY_IC_NO   = TW.PRIMARY_IC_NO 
                      AND T1.CNTRCT_START_DT <= IIF(TRY_CONVERT(DATE, 
                                                  :WS-CIGVOL-START-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CIGVOL-START-DATE
              ) <> 0) OR (LEN(:WS-CIGVOL-START-DATE
              ) <> 10), CIS.CHAR2DATE(:WS-CIGVOL-START-DATE
              ), CONVERT(DATE, :WS-CIGVOL-START-DATE) ) ) 
C35902                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT TRNSP_MDQ                                                 
MFA-TR*              ,TRNSP_SHRINK_PCT                                          
MFA-TR*          INTO :TW-TRNSP-MDQ  :WS-NULL-IND-3                             
MFA-TR*              ,:TW-TRNSP-SHRINK-PCT :WS-NULL-IND-4                       
MFA-TR*          FROM CSS_TRNSP_CONTRACT TW                                     
MFA-TR*              ,CSS_BILL_CONTRACT BC                                      
MFA-TR*         WHERE TW.ACCOUNT_NO         = :TW-ACCOUNT-NO                    
MFA-TR*           AND TW.CODE_UTIL_TYPE     = :TW-CODE-UTIL-TYPE                
MFA-TR*           AND TW.PRIMARY_IC_NO      = :TW-PRIMARY-IC-NO                 
MFA-TR*           AND TW.ACCOUNT_NO         = BC.ACCOUNT_NO                     
MFA-TR*           AND TW.CODE_UTIL_TYPE     = BC.CODE_UTIL_TYPE                 
MFA-TR*           AND TW.PRIMARY_IC_NO      = BC.IC_NO                          
MFA-TR*           AND BC.CNTRCT_START_DT <= :WS-CIGVOL-START-DATE               
MFA-TR*           AND BC.CNTRCT_END_DT   >= :WS-CIGVOL-END-DATE                 
MFA-TR*       AND TW.CNTRCT_START_DT = (SELECT MAX(T1.CNTRCT_START_DT)          
MFA-TR*                     FROM CSS_TRNSP_CONTRACT T1                          
MFA-TR*                     WHERE T1.ACCOUNT_NO  = TW.ACCOUNT_NO                
MFA-TR*                     AND   T1.CODE_UTIL_TYPE = TW.CODE_UTIL_TYPE         
MFA-TR*                     AND   T1.PRIMARY_IC_NO   = TW.PRIMARY_IC_NO         
MFA-TR*               AND T1.CNTRCT_START_DT <= :WS-CIGVOL-START-DATE )         
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            IF WS-NULL-IND-3 < 0                                        
               MOVE ZEROES TO  TW-TRNSP-MDQ                             
            END-IF.                                                     
            IF WS-NULL-IND-4 < 0                                        
               MOVE 1.00  TO  TW-TRNSP-SHRINK-PCT                       
            END-IF.                                                     
                                                                        
            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE ZERO             TO TW-TRNSP-MDQ                  
                 MOVE ZERO             TO TW-TRNSP-SHRINK-PCT           
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7210'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
              MOVE 'CSS_TRNSP_CONTRACT'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE TW-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7210-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7220-GET-COMP-PRICE.                                             
                                                                        
            EXEC SQL                                                    
               SELECT FH.FACTOR                                         
                 INTO :FH-FACTOR                                        
                 FROM CSS_FIXED_FCT_HIST FH WITH(READUNCOMMITTED)               
                WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO            
                  AND FH.BILL_NO            = :FH-BILL-NO               
                  AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE        
                  AND FH.IC_NO              = :FH-IC-NO                 
                  AND FH.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :FH-BILL-ITEM-TIMESTMP
              )    
                  AND FH.FACTOR_ID          = :WS-COMPPRICE             
                  AND FH.CMPNT_ID_CD        = :WS-CMPNT-ID-CD           
                  AND FH.EFF_DATE_FROM     <= IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-READ-FH
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ-FH
              ) <> 0) OR (LEN(:WS-DATE-READ-FH) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-READ-FH
              ), CONVERT(DATE, :WS-DATE-READ-FH) )          
                  AND FH.EFF_DATE_TO       >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-DATE-READ-FH
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-READ-FH
              ) <> 0) OR (LEN(:WS-DATE-READ-FH) <> 10), CIS.CHAR2DATE(
                                                       :WS-DATE-READ-FH
              ), CONVERT(DATE, :WS-DATE-READ-FH) )          
C35902                                                           
            END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*        SELECT FH.FACTOR                                                 
MFA-TR*          INTO :FH-FACTOR                                                
MFA-TR*          FROM CSS_FIXED_FCT_HIST FH                                     
MFA-TR*         WHERE FH.ACCOUNT_NO         = :FH-ACCOUNT-NO                    
MFA-TR*           AND FH.BILL_NO            = :FH-BILL-NO                       
MFA-TR*           AND FH.CODE_UTIL_TYPE     = :FH-CODE-UTIL-TYPE                
MFA-TR*           AND FH.IC_NO              = :FH-IC-NO                         
MFA-TR*           AND FH.BILL_ITEM_TIMESTMP = :FH-BILL-ITEM-TIMESTMP            
MFA-TR*           AND FH.FACTOR_ID          = :WS-COMPPRICE                     
MFA-TR*           AND FH.CMPNT_ID_CD        = :WS-CMPNT-ID-CD                   
MFA-TR*           AND FH.EFF_DATE_FROM     <= :WS-DATE-READ-FH                  
MFA-TR*           AND FH.EFF_DATE_TO       >= :WS-DATE-READ-FH                  
MFA-TR*          WITH UR                                                        
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
                 MOVE FH-FACTOR           TO WS-FACTOR                  
                 MOVE WS-FACTOR           TO WS-FACTOR-EDIT             
                 MOVE WS-FACTOR-EDIT      TO WS-FACTOR-CHAR             
              ELSE                                                      
                 MOVE SPACES              TO WS-FACTOR-CHAR             
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7220'                 TO ACTIVE-PARAGRAPH           
              MOVE 'SELECT'               TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
              MOVE 'CSS_FIXED_FCT_HIST'   TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE FH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7230-OPEN-CNSMPTN-CSR.                                           
                                                                        
           MOVE '7230'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
               OPEN CNSMPTN-CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7230'                    TO ACTIVE-PARAGRAPH        
              MOVE 'OPEN'                    TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT            
           END-IF.                                                      
                                                                        
       7230-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7240-FETCH-CNSMPTN-CSR.                                          
                                                                        
           EXEC SQL                                                     
              FETCH CNSMPTN-CSR                                         
              INTO  :CX-METER-NO,                                       
                    :CX-DATE-READ,                                      
P00251              :CX-CODE-TIME-PERIOD,                               
                    :CX-NO-UNITS,                                       
                    :CX-CODE-DEBIT-CREDIT                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7240'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-TABLES               
                                             ABEND-SQL-PREDICATES       
              MOVE 'CSS_CNSMPTN_HIST'     TO TABLE-1                    
              MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1            
              MOVE CX-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1          
              MOVE 'BILL_NO'              TO TABLE-ELEMENT-2            
              MOVE CX-BILL-NO             TO HOSTVAR-ELEMENT-2          
              PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7250-CLOSE-CNSMPTN-CSR.                                          
                                                                        
           EXEC SQL                                                     
              CLOSE CNSMPTN-CSR                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7250'                    TO ACTIVE-PARAGRAPH        
              MOVE 'CLOSE'                   TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_CNSMPTN_HIST'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE CX-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'BILL_NO'                 TO TABLE-ELEMENT-2         
              MOVE CX-BILL-NO                TO HOSTVAR-ELEMENT-2       
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7260-LOAD-CX-TABLE.                                              
                                                                        
           MOVE CX-DATE-READ      TO WS-DATE-READ.                      
           MOVE WS-DATE-READ-DD-N TO WS-DAY-IND.                        
           MOVE WS-DATE-READ      TO WS-DATE(WS-DAY-IND).               
                                                                        
P00251*    FOR ZERO TIME PERIOD SET AS +4 AND LATER CHANGED TO ZERO             
P00251     IF CX-CODE-TIME-PERIOD = ZERO                                
P00251        MOVE +4                  TO WS-TM-PRD-IND                 
PRDFIX                                    CX-CODE-TIME-PERIOD           
P00251     ELSE                                                         
P00251        MOVE CX-CODE-TIME-PERIOD TO WS-TM-PRD-IND                 
P00251     END-IF                                                       
P00251     MOVE CX-CODE-TIME-PERIOD TO                                  
P00251                    WS-CODE-TIME-PERIOD(WS-DAY-IND,WS-TM-PRD-IND).
           IF CX-NO-UNITS > 0                                           
           COMPUTE  WS-NO-UNITS   = CX-NO-UNITS / 10                    
           INSPECT WS-NO-UNITS REPLACING LEADING ZEROS BY SPACES        
           IF CX-CODE-DEBIT-CREDIT = 'C'                                
                COMPUTE WS-SIGN-UNITS = WS-NO-UNITS * -1                
                COMPUTE WS-UNITS-NEG  = WS-NO-UNITS * -1                
                STRING WS-SIGN-UNITS(1:9) '.' WS-NO-UNITS(10:1)         
                       DELIMITED BY SIZE                                
P00251          INTO WS-UNITS(WS-DAY-IND, WS-TM-PRD-IND, WS-COLUMN-IND) 
                ADD WS-UNITS-NEG TO WS-COLUMN-TOT (WS-COLUMN-IND)       
           ELSE                                                         
                STRING WS-NO-UNITS(1:9) '.' WS-NO-UNITS(10:1)           
                       DELIMITED BY SIZE                                
P00251          INTO WS-UNITS(WS-DAY-IND, WS-TM-PRD-IND, WS-COLUMN-IND) 
                ADD WS-NO-UNITS TO WS-COLUMN-TOT (WS-COLUMN-IND)        
           END-IF                                                       
           END-IF.                                                      
           MOVE  20             TO WS-VOL-GROUP(WS-DAY-IND).            
                                                                        
       7260-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7270-GET-TIMESTMP                                        **         
      *****************************************************************         
       7270-GET-TIMESTMP.                                               
      *                                                                         
           EXEC SQL                                                     
C35902        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, 
              1, CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRNSP-TS1,
              :WS-CURRENT-TS                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TRNSP-TS1 =                                               
MFA-TR*           TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) + 1 MICROSECOND             
MFA-TR*          ,:WS-CURRENT-TS = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7270'                    TO ACTIVE-PARAGRAPH        
C35902        MOVE 'SET   '                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7270-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      **    7280-GET-TIMESTMP                                        **         
      *****************************************************************         
       7280-GET-TIMESTMP.                                               
      *                                                                         
           EXEC SQL                                                     
C35902        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( MICROSECOND, -1
              , CIS.CHAR2TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) ), 121), 
           ' ', '-'), ':', '.'),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-TRNSP-TS2,
              :WS-CURRENT-TS                    
C35902     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TRNSP-TS2 =                                               
MFA-TR*           TIMESTAMP(:BG-BILL-ITEM-TIMESTMP) - 1 MICROSECOND             
MFA-TR*          ,:WS-CURRENT-TS = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7280'                    TO ACTIVE-PARAGRAPH        
C35902        MOVE 'SET   '                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7280-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      **    7290-GET-MAX-SEQ.                                        **         
      *****************************************************************         
       7290-GET-MAX-SEQ.                                                
      *                                                                         
           EXEC SQL                                                     
             SELECT  MAX(ND.FIXED_FCTR_SEQ_NO)                          
             INTO    :WS-MAX-SEQ-NO :WS-NULL-IND                         
             FROM    CSS_VOL_DAILY ND WITH(READUNCOMMITTED)                     
             WHERE ND.ACCOUNT_NO     = :ND-ACCOUNT-NO                   
               AND ND.BILL_NO        = :ND-BILL-NO                      
               AND ND.CODE_UTIL_TYPE = :ND-CODE-UTIL-TYPE               
               AND ND.IC_NO          = :ND-IC-NO                        
               AND ND.VOL_TYPE_CD    = :ND-VOL-TYPE-CD                  
               AND ND.ENERGY_UNIT_CD = :ND-ENERGY-UNIT-CD               
               AND ((ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                 :ND-BILL-ITEM-TIMESTMP
              ))    
                OR  (ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                          :WS-TRNSP-TS1
              ))             
                OR  (ND.BILL_ITEM_TIMESTMP = CIS.CHAR2TIMESTAMP(
                                                          :WS-TRNSP-TS2
              )))            
C35902                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT  MAX(ND.FIXED_FCTR_SEQ_NO)                                  
MFA-TR*      INTO    :WS-MAX-SEQ-NO:WS-NULL-IND                                 
MFA-TR*      FROM    CSS_VOL_DAILY ND                                           
MFA-TR*      WHERE ND.ACCOUNT_NO     = :ND-ACCOUNT-NO                           
MFA-TR*        AND ND.BILL_NO        = :ND-BILL-NO                              
MFA-TR*        AND ND.CODE_UTIL_TYPE = :ND-CODE-UTIL-TYPE                       
MFA-TR*        AND ND.IC_NO          = :ND-IC-NO                                
MFA-TR*        AND ND.VOL_TYPE_CD    = :ND-VOL-TYPE-CD                          
MFA-TR*        AND ND.ENERGY_UNIT_CD = :ND-ENERGY-UNIT-CD                       
MFA-TR*        AND ((ND.BILL_ITEM_TIMESTMP = :ND-BILL-ITEM-TIMESTMP)            
MFA-TR*         OR  (ND.BILL_ITEM_TIMESTMP = :WS-TRNSP-TS1)                     
MFA-TR*         OR  (ND.BILL_ITEM_TIMESTMP = :WS-TRNSP-TS2))                    
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
      *                                                                         
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7290'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-TABLES            
                                                ABEND-SQL-PREDICATES    
              MOVE 'CSS_VOL_DAILY'           TO TABLE-1                 
              PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT             
           END-IF.                                                      
      *                                                                         
       7290-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************           
REARCH*                                                             *           
REARCH* 8000A-DELETE-GTT-ROWS                                       *           
REARCH*                                                             *           
REARCH***************************************************************           
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02538_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02538_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH          NEXT SENTENCE                                           
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
REARCH         MOVE SQLCODE               TO ABEND-SQLCODE              
REARCH         MOVE SQLSTATE              TO ABEND-SQLSTATE             
REARCH         MOVE '8000A'               TO ACTIVE-PARAGRAPH           
REARCH         MOVE 'DELETE'              TO ABEND-FUNCTION             
REARCH         MOVE SPACES                TO ABEND-SQL-PREDICATES       
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02538_R1'         TO TABLE-1                    
REARCH         MOVE SPACES                TO TABLE-ELEMENT-1            
REARCH         MOVE SPACES                TO HOSTVAR-ELEMENT-1          
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      *                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02538_R1                        
REARCH           (                                                      
REARCH                 RETURN_CODE                                      
REARCH                ,DAY                                              
P00251                ,CODE_TIME_PERIOD                                 
REARCH                ,VOL_GROUP                                        
REARCH                ,TYPE_ROW                                         
REARCH                ,COLUMN_1                                         
REARCH                ,COLUMN_2                                         
REARCH                ,COLUMN_3                                         
REARCH                ,COLUMN_4                                         
REARCH                ,COLUMN_5                                         
REARCH                ,COLUMN_6                                         
REARCH                ,COLUMN_7                                         
REARCH                ,COLUMN_8                                         
REARCH                ,COLUMN_9                                         
REARCH                ,COLUMN_10                                        
REARCH                ,COLUMN_11                                        
REARCH                ,COLUMN_12                                        
REARCH                ,COLUMN_13                                        
REARCH                ,COLUMN_14                                        
REARCH                ,COLUMN_15                                        
REARCH                ,COLUMN_16                                        
REARCH                ,COLUMN_17                                        
REARCH                ,COLUMN_18                                        
REARCH                ,COLUMN_19                                        
REARCH                ,COLUMN_20                                        
REARCH                ,COLUMN_21                                        
REARCH                ,COLUMN_22                                        
REARCH                ,COLUMN_23                                        
REARCH                ,COLUMN_24                                        
REARCH                ,COLUMN_25                                        
REARCH                ,COLUMN_26                                        
REARCH                ,COLUMN_27                                        
REARCH                ,COLUMN_28                                        
REARCH                ,COLUMN_29                                        
REARCH                ,COLUMN_30                                        
REARCH                ,COLUMN_31                                        
REARCH                ,COLUMN_32                                        
REARCH                ,COLUMN_33                                        
REARCH                ,COLUMN_34                                        
REARCH                ,COLUMN_35                                        
REARCH                ,COLUMN_36                                        
REARCH                ,RATE_PLAN                                        
REARCH                ,REVENUE_CLASS                                    
REARCH                ,CATEGORY                                         
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                :S-RETURN-CODE                                    
REARCH               ,:S-DATE                                           
P00251               ,:S-CODE-TIME-PERIOD                               
REARCH               ,:S-VOL-GROUP                                      
REARCH               ,:S-TYPE-ROW                                       
REARCH               ,:S-COLUMN-1                                       
REARCH               ,:S-COLUMN-2                                       
REARCH               ,:S-COLUMN-3                                       
REARCH               ,:S-COLUMN-4                                       
REARCH               ,:S-COLUMN-5                                       
REARCH               ,:S-COLUMN-6                                       
REARCH               ,:S-COLUMN-7                                       
REARCH               ,:S-COLUMN-8                                       
REARCH               ,:S-COLUMN-9                                       
REARCH               ,:S-COLUMN-10                                      
REARCH               ,:S-COLUMN-11                                      
REARCH               ,:S-COLUMN-12                                      
REARCH               ,:S-COLUMN-13                                      
REARCH               ,:S-COLUMN-14                                      
REARCH               ,:S-COLUMN-15                                      
REARCH               ,:S-COLUMN-16                                      
REARCH               ,:S-COLUMN-17                                      
REARCH               ,:S-COLUMN-18                                      
REARCH               ,:S-COLUMN-19                                      
REARCH               ,:S-COLUMN-20                                      
REARCH               ,:S-COLUMN-21                                      
REARCH               ,:S-COLUMN-22                                      
REARCH               ,:S-COLUMN-23                                      
REARCH               ,:S-COLUMN-24                                      
REARCH               ,:S-COLUMN-25                                      
REARCH               ,:S-COLUMN-26                                      
REARCH               ,:S-COLUMN-27                                      
REARCH               ,:S-COLUMN-28                                      
REARCH               ,:S-COLUMN-29                                      
REARCH               ,:S-COLUMN-30                                      
REARCH               ,:S-COLUMN-31                                      
REARCH               ,:S-COLUMN-32                                      
REARCH               ,:S-COLUMN-33                                      
REARCH               ,:S-COLUMN-34                                      
REARCH               ,:S-COLUMN-35                                      
REARCH               ,:S-COLUMN-36                                      
REARCH               ,:S-RATE-PLAN                                      
REARCH               ,:S-REVENUE-CLASS                                  
REARCH               ,:S-CATEGORY                                       
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02538_R1                                
MFA-TR*          (                                                              
MFA-TR*                RETURN_CODE                                              
MFA-TR*               ,DAY                                                      
MFA-TR*               ,CODE_TIME_PERIOD                                         
MFA-TR*               ,VOL_GROUP                                                
MFA-TR*               ,TYPE_ROW                                                 
MFA-TR*               ,COLUMN_1                                                 
MFA-TR*               ,COLUMN_2                                                 
MFA-TR*               ,COLUMN_3                                                 
MFA-TR*               ,COLUMN_4                                                 
MFA-TR*               ,COLUMN_5                                                 
MFA-TR*               ,COLUMN_6                                                 
MFA-TR*               ,COLUMN_7                                                 
MFA-TR*               ,COLUMN_8                                                 
MFA-TR*               ,COLUMN_9                                                 
MFA-TR*               ,COLUMN_10                                                
MFA-TR*               ,COLUMN_11                                                
MFA-TR*               ,COLUMN_12                                                
MFA-TR*               ,COLUMN_13                                                
MFA-TR*               ,COLUMN_14                                                
MFA-TR*               ,COLUMN_15                                                
MFA-TR*               ,COLUMN_16                                                
MFA-TR*               ,COLUMN_17                                                
MFA-TR*               ,COLUMN_18                                                
MFA-TR*               ,COLUMN_19                                                
MFA-TR*               ,COLUMN_20                                                
MFA-TR*               ,COLUMN_21                                                
MFA-TR*               ,COLUMN_22                                                
MFA-TR*               ,COLUMN_23                                                
MFA-TR*               ,COLUMN_24                                                
MFA-TR*               ,COLUMN_25                                                
MFA-TR*               ,COLUMN_26                                                
MFA-TR*               ,COLUMN_27                                                
MFA-TR*               ,COLUMN_28                                                
MFA-TR*               ,COLUMN_29                                                
MFA-TR*               ,COLUMN_30                                                
MFA-TR*               ,COLUMN_31                                                
MFA-TR*               ,COLUMN_32                                                
MFA-TR*               ,COLUMN_33                                                
MFA-TR*               ,COLUMN_34                                                
MFA-TR*               ,COLUMN_35                                                
MFA-TR*               ,COLUMN_36                                                
MFA-TR*               ,RATE_PLAN                                                
MFA-TR*               ,REVENUE_CLASS                                            
MFA-TR*               ,CATEGORY                                                 
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-DATE                                                   
MFA-TR*              ,:S-CODE-TIME-PERIOD                                       
MFA-TR*              ,:S-VOL-GROUP                                              
MFA-TR*              ,:S-TYPE-ROW                                               
MFA-TR*              ,:S-COLUMN-1                                               
MFA-TR*              ,:S-COLUMN-2                                               
MFA-TR*              ,:S-COLUMN-3                                               
MFA-TR*              ,:S-COLUMN-4                                               
MFA-TR*              ,:S-COLUMN-5                                               
MFA-TR*              ,:S-COLUMN-6                                               
MFA-TR*              ,:S-COLUMN-7                                               
MFA-TR*              ,:S-COLUMN-8                                               
MFA-TR*              ,:S-COLUMN-9                                               
MFA-TR*              ,:S-COLUMN-10                                              
MFA-TR*              ,:S-COLUMN-11                                              
MFA-TR*              ,:S-COLUMN-12                                              
MFA-TR*              ,:S-COLUMN-13                                              
MFA-TR*              ,:S-COLUMN-14                                              
MFA-TR*              ,:S-COLUMN-15                                              
MFA-TR*              ,:S-COLUMN-16                                              
MFA-TR*              ,:S-COLUMN-17                                              
MFA-TR*              ,:S-COLUMN-18                                              
MFA-TR*              ,:S-COLUMN-19                                              
MFA-TR*              ,:S-COLUMN-20                                              
MFA-TR*              ,:S-COLUMN-21                                              
MFA-TR*              ,:S-COLUMN-22                                              
MFA-TR*              ,:S-COLUMN-23                                              
MFA-TR*              ,:S-COLUMN-24                                              
MFA-TR*              ,:S-COLUMN-25                                              
MFA-TR*              ,:S-COLUMN-26                                              
MFA-TR*              ,:S-COLUMN-27                                              
MFA-TR*              ,:S-COLUMN-28                                              
MFA-TR*              ,:S-COLUMN-29                                              
MFA-TR*              ,:S-COLUMN-30                                              
MFA-TR*              ,:S-COLUMN-31                                              
MFA-TR*              ,:S-COLUMN-32                                              
MFA-TR*              ,:S-COLUMN-33                                              
MFA-TR*              ,:S-COLUMN-34                                              
MFA-TR*              ,:S-COLUMN-35                                              
MFA-TR*              ,:S-COLUMN-36                                              
MFA-TR*              ,:S-RATE-PLAN                                              
MFA-TR*              ,:S-REVENUE-CLASS                                          
MFA-TR*              ,:S-CATEGORY                                               
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02538_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************        
      * 9700- PROCESS-ABEND ERROR HANDLING INCLUDE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                              
      *****************************************************************         
           EXEC SQL                                                             
REARCH         INCLUDE CPDSP300                                                 
REARCH*       INCLUDE CPD00300                                                  
           END-EXEC.                                                            
                                                                        
      *****************************************************************         
      *       END PROGRAM COPYLIB                                               
      *****************************************************************         
REARCH*    EXEC SQL                                                             
REARCH*        INCLUDE CPDSP302                                                 
REARCH*    END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
REARCH*    COPY CPD00302.                                                       
