       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02529.                                          
       DATE-WRITTEN. JUL 13, 2005.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S529                                           *        
      *  PROGRAM:       S529                                           *        
      *  CALLING SP:    PN_S529                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM SELECTS FROM CSS_PIM_POINT TO POPULATE PANEL011. *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  02/04/03    FMB      CREATED.                                 *        
REARCH*  07/13/05    CVNS     RPC TO COBOL CONVERSIOON.                *        
REARCH*              CHENNAI                                           *        
C33743*  05/15/08    SC       POINT-ID PROJECT - REPLACE SNE_POINT     *        
C33743*                       TABLE WITH CSS_PIM_POINT                 *        
A03662*  09/14/11    FMB      REPLACED WMS_OP_AREA WITH CSS_OP_AREA    *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02529'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02529 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRENV                                                  
           END-EXEC.                                                            
                                                                        
C33743     EXEC SQL                                                             
C33743        INCLUDE TBPIMPNT                                                  
C33743     END-EXEC.                                                            
                                                                        
C33743     EXEC SQL                                                             
A03662        INCLUDE TBOPAREA                                                  
C33743     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       COPY CWS00011.                                                           
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02529'.      
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                 VALUE 'SESSION.CSR02529_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-LST-UPD-DT-NULL-IND PIC S9(4) COMP                    
                                      VALUE -1.                         
C33743*    05  WS-GIS-DT-NULL-IND     PIC S9(4) COMP                            
C33743*                               VALUE -1.                                 
           05  WS-GRID-CELL-TX-NI     PIC S9(4) COMP                    
                                      VALUE -1.                         
           05  WS-SUBSTATION-ID-NI    PIC S9(4) COMP                    
                                      VALUE -1.                         
           05  WS-CIRCUIT-ID-NI       PIC S9(4) COMP                    
                                      VALUE -1.                         
C33743*    05  WS-COUNTY-CD-NI        PIC S9(4) COMP                            
C33743*                               VALUE -1.                                 
           05  WS-WORK-REQUEST-ID-NI  PIC S9(4) COMP                    
                                      VALUE -1.                         
           05  WS-LAST-UPDATE-ID-NI   PIC S9(4) COMP                    
                                      VALUE -1.                         
C33743*    05  WS-USER-DEF-1-TX-T-NI  PIC S9(4) COMP                            
C33743*                               VALUE -1.                                 
C33743*    05  WS-USER-DEF-2-TX-T-NI  PIC S9(4) COMP                            
C33743*                               VALUE -1.                                 
C33743*    05  WS-USER-DEF-3-TX-T-NI  PIC S9(4) COMP                            
C33743*                               VALUE -1.                                 
C33743*    05  WS-USER-DEF-4-TX-T-NI  PIC S9(4) COMP                            
C33743*                               VALUE -1.                                 
C33743*   05  WS-POLE-ID-NI          PIC S9(4) COMP                             
C33743*                              VALUE -1.                                  
C33743*   05  WS-SWITCHGEAR-ID-NI    PIC S9(4) COMP                             
C33743*                              VALUE -1.                                  
C33743*   05  WS-UGSTRUCTURE-ID-NI   PIC S9(4) COMP                             
C33743*                              VALUE -1.                                  
C33743*   05  WS-UGTRANSFORMER-ID-NI PIC S9(4) COMP                             
C33743*                              VALUE -1.                                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-MAX-RETURN-ROWS      PIC S9(3) COMP VALUE +50.        
           05  WS-ROW-CT               PIC S9(3) COMP VALUE 0.          
           05  WS-TOTAL-ROWS           PIC S9(5) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WS-TRANS-APPL-NO        PIC S9(04) COMP VALUE 0.         
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-ACCOUNT-NO-X         PIC X(13).                       
           05  WS-ACCOUNT-NO           REDEFINES WS-ACCOUNT-NO-X        
                                       PIC 9(13).                       
           05  WS-POINT-ID             PIC X(09) VALUE SPACES.          
C33743*    05  WS-POLE-ID              PIC X(09) VALUE SPACES.                  
C33743*    05  WS-WORK-REQUEST-ID      PIC X(13) VALUE SPACES.                  
C33743*    05  WS-SWITCHGEAR-ID        PIC X(09) VALUE SPACES.                  
C33743*    05  WS-UGSTRUCTURE-ID       PIC X(09) VALUE SPACES.                  
C33743*    05  WS-UGTRANSFORMER-ID     PIC X(09) VALUE SPACES.                  
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(9)   COMP VALUE 0.      
           05  RS-METER-NO               PIC X(9)    VALUE SPACES.      
           05  RS-CODE-METER-STATUS      PIC X(1)    VALUE SPACES.      
           05  RS-POINT-ID               PIC X(9)    VALUE SPACES.      
           05  RS-GIS-LOC-OFF-CD         PIC X(3)    VALUE SPACES.      
           05  RS-TAG-NM                 PIC X(10)   VALUE SPACES.      
C33743*    05  RS-POINT-TYPE-CD          PIC X(03)   VALUE SPACES.              
           05  RS-GRID-CELL-TX           PIC X(10)   VALUE SPACES.      
           05  RS-SUBSTATION-ID          PIC X(05)   VALUE SPACES.      
           05  RS-CIRCUIT-ID             PIC X(05)   VALUE SPACES.      
           05  RS-GIS-LOC-OFF-TX         PIC X(40)   VALUE SPACES.      
C33743*   05  RS-COUNTY-CD              PIC X(03)   VALUE SPACES.               
C33743*   05  RS-WORK-REQUEST-ID        PIC X(13)   VALUE SPACES.               
           05  RS-LAST-UPDATE-ID         PIC X(7)    VALUE SPACES.      
           05  RS-LAST-UPDATE-DT         PIC X(26)   VALUE SPACES.      
C33743*    05  RS-GIS-DT                 PIC X(26)   VALUE SPACES.              
C33743*    05  RS-USER-DEF-1-TX-TEXT     PIC X(255)  VALUE SPACES.              
C33743*    05  RS-USER-DEF-2-TX-TEXT     PIC X(255)  VALUE SPACES.              
C33743*    05  RS-USER-DEF-3-TX-TEXT     PIC X(255)  VALUE SPACES.              
C33743*    05  RS-USER-DEF-4-TX-TEXT     PIC X(255)  VALUE SPACES.              
C33743*    05  RS-POLE-ID                PIC X(9)    VALUE SPACES.              
C33743*    05  RS-SWITCHGEAR-ID          PIC X(9)    VALUE SPACES.              
C33743*    05  RS-UGSTRUCTURE-ID         PIC X(9)    VALUE SPACES.              
C33743*    05  RS-UGTRANSFORMER-ID       PIC X(9)    VALUE SPACES.              
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(9)   COMP VALUE 0.      
REARCH     05  S-METER-NO                PIC X(9)    VALUE SPACES.      
REARCH     05  S-CODE-METER-STATUS       PIC X(1)    VALUE SPACES.      
REARCH     05  S-POINT-ID                PIC X(9)    VALUE SPACES.      
REARCH     05  S-GIS-LOC-OFF-CD          PIC X(3)    VALUE SPACES.      
REARCH     05  S-TAG-NM                  PIC X(10)   VALUE SPACES.      
C33743*    05  S-POINT-TYPE-CD           PIC X(03)   VALUE SPACES.              
REARCH     05  S-GRID-CELL-TX            PIC X(10)   VALUE SPACES.      
REARCH     05  S-SUBSTATION-ID           PIC X(05)   VALUE SPACES.      
REARCH     05  S-CIRCUIT-ID              PIC X(05)   VALUE SPACES.      
REARCH     05  S-GIS-LOC-OFF-TX          PIC X(40)   VALUE SPACES.      
C33743*    05  S-COUNTY-CD               PIC X(03)   VALUE SPACES.              
C33743*    05  S-WORK-REQUEST-ID         PIC X(13)   VALUE SPACES.              
REARCH     05  S-LAST-UPDATE-ID          PIC X(7)    VALUE SPACES.      
REARCH     05  S-LAST-UPDATE-DT          PIC X(26)   VALUE SPACES.      
C33743*    05  S-GIS-DT                  PIC X(26)   VALUE SPACES.              
C33743*    05  S-USER-DEF-1-TX-TEXT      PIC X(255)  VALUE SPACES.              
C33743*    05  S-USER-DEF-2-TX-TEXT      PIC X(255)  VALUE SPACES.              
C33743*    05  S-USER-DEF-3-TX-TEXT      PIC X(255)  VALUE SPACES.              
C33743*    05  S-USER-DEF-4-TX-TEXT      PIC X(255)  VALUE SPACES.              
C33743*    05  S-POLE-ID                 PIC X(9)    VALUE SPACES.              
C33743*    05  S-SWITCHGEAR-ID           PIC X(9)    VALUE SPACES.              
C33743*    05  S-UGSTRUCTURE-ID          PIC X(9)    VALUE SPACES.              
C33743*    05  S-UGTRANSFORMER-ID        PIC X(9)    VALUE SPACES.              
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
                                                                        
      *--- < CURSOR FOR CSS_PIM_POINT   SELECTION >                             
                                                                        
           EXEC SQL DECLARE PIM-POINT-CUR   CURSOR FOR                  
               SELECT MN.METER_NO,                                      
                      MN.CODE_METER_STATUS,                             
                      PT.POINT_ID,                                      
C33743                PT.AREA_ID,                                       
                      PT.TAG_NM,                                        
C33743*               PT.POINT_TYPE_CD,                                         
                      PT.GRID_CELL_TX,                                  
                      PT.SUBSTATION_ID,                                 
                      PT.CIRCUIT_ID,                                    
C33743*               PT.COUNTY_CD,                                             
C33743*               PT.WORK_REQUEST_ID,                                       
C33743                PT.LAST_UPDATE_USERID,                            
C33743                REPLACE(REPLACE(CONVERT(CHAR(26), 
           PT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
C33743*               PT.GIS_DT,                                                
C33743*               PT.USER_DEF_1_TX,                                         
C33743*               PT.USER_DEF_2_TX,                                         
C33743*               PT.USER_DEF_3_TX,                                         
C33743*               PT.USER_DEF_4_TX,                                         
C33743*               PT.POLE_ID,                                               
C33743*               PT.SWITCHGEAR_ID,                                         
C33743*               PT.UGSTRUCTURE_ID,                                        
C33743*               PT.UGTRANSFORMER_ID,                                      
C33743                WM.AREA_TX                                        
C33743       FROM CSS_PIM_POINT  PT,                                    
C03662            CSS_OP_AREA    WM,                                    
                  CSS_MTRD_ENVRNMT MN                                   
             WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                   
               AND PT.POINT_ID       = MN.GIS_POINT_ID                  
C33743         AND PT.AREA_ID        = WM.AREA_ID                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE PIM-POINT-CUR   CURSOR FOR                          
MFA-TR*        SELECT MN.METER_NO,                                              
MFA-TR*               MN.CODE_METER_STATUS,                                     
MFA-TR*               PT.POINT_ID,                                              
MFA-TR*               PT.AREA_ID,                                               
MFA-TR*               PT.TAG_NM,                                                
MFA-TR*               PT.POINT_TYPE_CD,                                         
MFA-TR*               PT.GRID_CELL_TX,                                          
MFA-TR*               PT.SUBSTATION_ID,                                         
MFA-TR*               PT.CIRCUIT_ID,                                            
MFA-TR*               PT.COUNTY_CD,                                             
MFA-TR*               PT.WORK_REQUEST_ID,                                       
MFA-TR*               PT.LAST_UPDATE_USERID,                                    
MFA-TR*               PT.LAST_UPDATE_TS,                                        
MFA-TR*               PT.GIS_DT,                                                
MFA-TR*               PT.USER_DEF_1_TX,                                         
MFA-TR*               PT.USER_DEF_2_TX,                                         
MFA-TR*               PT.USER_DEF_3_TX,                                         
MFA-TR*               PT.USER_DEF_4_TX,                                         
MFA-TR*               PT.POLE_ID,                                               
MFA-TR*               PT.SWITCHGEAR_ID,                                         
MFA-TR*               PT.UGSTRUCTURE_ID,                                        
MFA-TR*               PT.UGTRANSFORMER_ID,                                      
MFA-TR*               WM.AREA_TX                                                
MFA-TR*      FROM CSS_PIM_POINT  PT,                                            
MFA-TR*           CSS_OP_AREA    WM,                                            
MFA-TR*           CSS_MTRD_ENVRNMT MN                                           
MFA-TR*      WHERE MN.ACCOUNT_NO     = :MN-ACCOUNT-NO                           
MFA-TR*        AND PT.POINT_ID       = MN.GIS_POINT_ID                          
MFA-TR*        AND PT.AREA_ID        = WM.AREA_ID                               
MFA-TR*      QUERYNO 2310                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.              
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH                                                                  
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           RETURN_CODE                                            
REARCH          ,METER_NO                                               
REARCH          ,METER_STAT                                             
REARCH          ,POINT_ID                                               
REARCH          ,GIS_LOC_OFF_CD                                         
REARCH          ,LTRIM(RTRIM(TAG_NM))              AS TAG_NM                   
C33743*         ,POINT_TYPE_CD                                                  
REARCH          ,LTRIM(RTRIM(GRID_CELL_TX))        AS GRID_CELL_TX             
REARCH          ,SUBSTATION_ID                                          
REARCH          ,CIRCUIT_ID                                             
REARCH          ,LTRIM(RTRIM(LOCAL_OFFICE_TX))     AS LOCAL_OFFICE_TX          
C33743*         ,COUNTY_CD                                                      
C33743*         ,WORK_REQUEST_ID                                                
REARCH          ,LAST_UPDATE_ID                                         
REARCH          ,LAST_UPDATE_DT                                         
C33743*         ,GIS_DT                                                         
C33743*         ,STRIP(USER_DEF_1_TX_TEXT) AS USER_DEF_1_TX_TEXT                
C33743*         ,STRIP(USER_DEF_2_TX_TEXT) AS USER_DEF_2_TX_TEXT                
C33743*         ,STRIP(USER_DEF_3_TX_TEXT) AS USER_DEF_3_TX_TEXT                
C33743*         ,STRIP(USER_DEF_4_TX_TEXT) AS USER_DEF_4_TX_TEXT                
C33743*         ,POLE_ID                                                        
C33743*         ,SWITCHGEAR_ID                                                  
C33743*         ,UGSTRUCTURE_ID                                                 
C33743*         ,UGTRANSFORMER_ID                                               
REARCH         FROM                                                     
REARCH             #CSR02529_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          RETURN_CODE                                                    
MFA-TR*         ,METER_NO                                                       
MFA-TR*         ,METER_STAT                                                     
MFA-TR*         ,POINT_ID                                                       
MFA-TR*         ,GIS_LOC_OFF_CD                                                 
MFA-TR*         ,STRIP(TAG_NM)              AS TAG_NM                           
MFA-TR*         ,POINT_TYPE_CD                                                  
MFA-TR*         ,STRIP(GRID_CELL_TX)        AS GRID_CELL_TX                     
MFA-TR*         ,SUBSTATION_ID                                                  
MFA-TR*         ,CIRCUIT_ID                                                     
MFA-TR*         ,STRIP(LOCAL_OFFICE_TX)     AS LOCAL_OFFICE_TX                  
MFA-TR*         ,COUNTY_CD                                                      
MFA-TR*         ,WORK_REQUEST_ID                                                
MFA-TR*         ,LAST_UPDATE_ID                                                 
MFA-TR*         ,LAST_UPDATE_DT                                                 
MFA-TR*         ,GIS_DT                                                         
MFA-TR*         ,STRIP(USER_DEF_1_TX_TEXT) AS USER_DEF_1_TX_TEXT                
MFA-TR*         ,STRIP(USER_DEF_2_TX_TEXT) AS USER_DEF_2_TX_TEXT                
MFA-TR*         ,STRIP(USER_DEF_3_TX_TEXT) AS USER_DEF_3_TX_TEXT                
MFA-TR*         ,STRIP(USER_DEF_4_TX_TEXT) AS USER_DEF_4_TX_TEXT                
MFA-TR*         ,POLE_ID                                                        
MFA-TR*         ,SWITCHGEAR_ID                                                  
MFA-TR*         ,UGSTRUCTURE_ID                                                 
MFA-TR*         ,UGTRANSFORMER_ID                                               
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02529_R1                                          
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                                       
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
                                                                        
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02529_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02529_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02529_R1
               (                                                       
REARCH              RETURN_CODE            INT                      
REARCH             ,METER_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,METER_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,POINT_ID CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,GIS_LOC_OFF_CD CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,TAG_NM CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
C33743*            ,POINT_TYPE_CD          CHAR(03)                             
REARCH             ,GRID_CELL_TX CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,SUBSTATION_ID CHAR(05)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,CIRCUIT_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,LOCAL_OFFICE_TX CHAR(40)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
C33743*            ,COUNTY_CD              CHAR(03)                             
C33743*            ,WORK_REQUEST_ID        CHAR(13)                             
REARCH             ,LAST_UPDATE_ID CHAR(07)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH             ,LAST_UPDATE_DT CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
C33743*            ,GIS_DT                 CHAR(26)                             
C33743*            ,USER_DEF_1_TX_TEXT     CHAR(255)                            
C33743*            ,USER_DEF_2_TX_TEXT     CHAR(255)                            
C33743*            ,USER_DEF_3_TX_TEXT     CHAR(255)                            
C33743*            ,USER_DEF_4_TX_TEXT     CHAR(255)                            
C33743*            ,POLE_ID                CHAR(09)                             
C33743*            ,SWITCHGEAR_ID          CHAR(09)                             
C33743*            ,UGSTRUCTURE_ID         CHAR(09)                             
C33743*            ,UGTRANSFORMER_ID       CHAR(09)                             
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02529_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
                                                                        
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH                                                                  
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2300-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                                       
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
                                                                        
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-METER-NO            TO S-METER-NO.                   
REARCH     MOVE RS-CODE-METER-STATUS   TO S-CODE-METER-STATUS.          
REARCH     MOVE RS-POINT-ID            TO S-POINT-ID.                   
REARCH     MOVE RS-GIS-LOC-OFF-CD      TO S-GIS-LOC-OFF-CD.             
REARCH     MOVE RS-TAG-NM              TO S-TAG-NM.                     
C33743*    MOVE RS-POINT-TYPE-CD       TO S-POINT-TYPE-CD.                      
REARCH     MOVE RS-GRID-CELL-TX        TO S-GRID-CELL-TX.               
REARCH     MOVE RS-SUBSTATION-ID       TO S-SUBSTATION-ID.              
REARCH     MOVE RS-CIRCUIT-ID          TO S-CIRCUIT-ID.                 
REARCH     MOVE RS-GIS-LOC-OFF-TX      TO S-GIS-LOC-OFF-TX.             
C33743*    MOVE RS-COUNTY-CD           TO S-COUNTY-CD.                          
C33743*    MOVE RS-WORK-REQUEST-ID     TO S-WORK-REQUEST-ID.                    
REARCH     MOVE RS-LAST-UPDATE-ID      TO S-LAST-UPDATE-ID.             
REARCH     MOVE RS-LAST-UPDATE-DT      TO S-LAST-UPDATE-DT.             
C33743*    MOVE RS-GIS-DT              TO S-GIS-DT.                             
C33743*    MOVE RS-USER-DEF-1-TX-TEXT  TO S-USER-DEF-1-TX-TEXT.                 
C33743*    MOVE RS-USER-DEF-2-TX-TEXT  TO S-USER-DEF-2-TX-TEXT.                 
C33743*    MOVE RS-USER-DEF-3-TX-TEXT  TO S-USER-DEF-3-TX-TEXT.                 
C33743*    MOVE RS-USER-DEF-4-TX-TEXT  TO S-USER-DEF-4-TX-TEXT.                 
C33743*    MOVE RS-POLE-ID             TO S-POLE-ID.                            
C33743*    MOVE RS-SWITCHGEAR-ID       TO S-SWITCHGEAR-ID.                      
C33743*    MOVE RS-UGSTRUCTURE-ID      TO S-UGSTRUCTURE-ID.                     
C33743*    MOVE RS-UGTRANSFORMER-ID    TO S-UGTRANSFORMER-ID.                   
                                                                        
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE PARM-ACCOUNT-NO TO WS-ACCOUNT-NO-X.                     
           MOVE WS-ACCOUNT-NO TO MN-ACCOUNT-NO.                         
                                                                        
           PERFORM 2310-OPEN-POINT-CURSOR THRU 2310-EXIT.               
           PERFORM 2315-FETCH-POINT-CURSOR THRU 2315-EXIT.              
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE  100      TO RS-RETURN-CODE                          
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
              PERFORM 2315-FETCH-POINT-CURSOR THRU 2315-EXIT            
                 UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           END-IF                                                       
           PERFORM 2320-CLOSE-POINT-CURSOR THRU 2320-EXIT.              
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-OPEN-POINT-CURSOR                                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN POINT CURSOR                                          *        
      ******************************************************************        
                                                                        
       2310-OPEN-POINT-CURSOR.                                          
                                                                        
           MOVE '2310'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
C33743        OPEN PIM-POINT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                ABEND-TABLES            
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
C33743        MOVE 'CSS_PIM_POINT'                TO TABLE-2            
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2315-FETCH-POINT-CURSOR                                        *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCH POINT CURSOR                                         *        
      ******************************************************************        
                                                                        
       2315-FETCH-POINT-CURSOR.                                         
                                                                        
           MOVE '2315'              TO ACTIVE-PARAGRAPH.                
                                                                        
C33743*    MOVE SPACES TO USER-DEF-1-TX-TEXT.                                   
C33743*    MOVE SPACES TO USER-DEF-2-TX-TEXT.                                   
C33743*    MOVE SPACES TO USER-DEF-3-TX-TEXT.                                   
C33743*    MOVE SPACES TO USER-DEF-4-TX-TEXT.                                   
                                                                        
           EXEC SQL                                                     
C33743        FETCH PIM-POINT-CUR                                       
               INTO :MN-METER-NO,                                       
                    :MN-CODE-METER-STATUS,                              
                    :PP-POINT-ID,                                       
                    :PP-AREA-ID,                                        
                    :PP-TAG-NM,                                         
C33743*             :POINT-TYPE-CD,                                             
                    :PP-GRID-CELL-TX :WS-GRID-CELL-TX-NI,                
                    :PP-SUBSTATION-ID :WS-SUBSTATION-ID-NI,              
                    :PP-CIRCUIT-ID :WS-CIRCUIT-ID-NI,                    
C33743*             :COUNTY-CD:WS-COUNTY-CD-NI,                                 
C33743*             :WORK-REQUEST-ID:WS-WORK-REQUEST-ID-NI,                     
C33743              :PP-LAST-UPDATE-USERID :WS-LAST-UPDATE-ID-NI,        
C33743              :PP-LAST-UPDATE-TS :WS-LST-UPD-DT-NULL-IND,          
C33743*             :GIS-DT:WS-GIS-DT-NULL-IND,                                 
C33743*             :USER-DEF-1-TX:WS-USER-DEF-1-TX-T-NI,                       
C33743*             :USER-DEF-2-TX:WS-USER-DEF-2-TX-T-NI,                       
C33743*             :USER-DEF-3-TX:WS-USER-DEF-3-TX-T-NI,                       
C33743*             :USER-DEF-4-TX:WS-USER-DEF-4-TX-T-NI,                       
C33743*             :POLE-ID:WS-POLE-ID-NI,                                     
C33743*             :SWITCHGEAR-ID:WS-SWITCHGEAR-ID-NI,                         
C33743*             :UGSTRUCTURE-ID:WS-UGSTRUCTURE-ID-NI,                       
C33743*             :UGTRANSFORMER-ID:WS-UGTRANSFORMER-ID-NI,                   
A03662              :QG-AREA-TX                                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    PERFORM 2400-MOVE-RESULT-SET THRU 2400-EXIT         
                    GO TO 2315-EXIT                                     
               WHEN NOT-FOUND                                           
                    GO TO 2315-EXIT                                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_MTRD_ENVRNMT'   TO TABLE-1                
C33743              MOVE 'CSS_PIM_POINT'          TO TABLE-2            
                    MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
                    MOVE MN-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
                    MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE        
REARCH              PERFORM 2000A-MOVE-RESULT                           
REARCH                                       THRU 2000A-EXIT            
                    PERFORM 8100-SEND-RESULT THRU 8100-EXIT             
           END-EVALUATE.                                                
                                                                        
       2315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-CLOSE-POINT-CURSOR                                        *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN POINT CURSOR                                          *        
      ******************************************************************        
                                                                        
       2320-CLOSE-POINT-CURSOR.                                         
                                                                        
           MOVE '2320'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
C33743        CLOSE PIM-POINT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                ABEND-TABLES            
              MOVE 'CSS_MTRD_ENVRNMT'         TO TABLE-1                
C33743        MOVE 'CSS_PIM_POINT'                TO TABLE-2            
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE MN-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-MOVE-RESULT-SET                                           *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT-SET                          *        
      *                                                                *        
      *     MOVE DATA TO RESULT SET.                                   *        
      ******************************************************************        
                                                                        
       2400-MOVE-RESULT-SET.                                            
                                                                        
           MOVE MN-METER-NO TO RS-METER-NO.                             
           MOVE MN-CODE-METER-STATUS TO RS-CODE-METER-STATUS.           
           MOVE PP-POINT-ID TO RS-POINT-ID.                             
C33743     MOVE PP-AREA-ID        TO RS-GIS-LOC-OFF-CD.                 
           MOVE PP-TAG-NM TO RS-TAG-NM.                                 
C33743*    MOVE POINT-TYPE-CD TO RS-POINT-TYPE-CD.                              
           IF WS-GRID-CELL-TX-NI < 0                                    
               MOVE SPACES TO RS-GRID-CELL-TX                           
           ELSE                                                         
C33743         MOVE PP-GRID-CELL-TX TO RS-GRID-CELL-TX                  
           END-IF.                                                      
           IF WS-SUBSTATION-ID-NI < 0                                   
               MOVE SPACES TO RS-SUBSTATION-ID                          
           ELSE                                                         
C33743         MOVE PP-SUBSTATION-ID TO RS-SUBSTATION-ID                
           END-IF.                                                      
           IF WS-CIRCUIT-ID-NI < 0                                      
               MOVE SPACES TO RS-CIRCUIT-ID                             
           ELSE                                                         
C33743         MOVE PP-CIRCUIT-ID TO RS-CIRCUIT-ID                      
           END-IF.                                                      
C33743*    IF WS-COUNTY-CD-NI < 0                                               
C33743*        MOVE SPACES TO RS-COUNTY-CD                                      
C33743*    ELSE                                                                 
C33743*        MOVE COUNTY-CD TO RS-COUNTY-CD                                   
C33743*    END-IF.                                                              
C33743*    IF WS-WORK-REQUEST-ID-NI < 0                                         
C33743*        MOVE SPACES TO RS-WORK-REQUEST-ID                                
C33743*    ELSE                                                                 
C33743*        MOVE WORK-REQUEST-ID TO RS-WORK-REQUEST-ID                       
C33743*    END-IF.                                                              
           IF WS-LAST-UPDATE-ID-NI < 0                                  
               MOVE SPACES TO RS-LAST-UPDATE-ID                         
           ELSE                                                         
C33743         MOVE PP-LAST-UPDATE-USERID TO RS-LAST-UPDATE-ID          
           END-IF.                                                      
           IF WS-LST-UPD-DT-NULL-IND < 0                                
               MOVE SPACES TO RS-LAST-UPDATE-DT                         
           ELSE                                                         
C33743         MOVE PP-LAST-UPDATE-TS TO RS-LAST-UPDATE-DT              
           END-IF.                                                      
C33743*    IF WS-GIS-DT-NULL-IND < 0                                            
C33743*        MOVE SPACES TO RS-GIS-DT                                         
C33743*    ELSE                                                                 
C33743*        MOVE GIS-DT TO RS-GIS-DT                                         
C33743*    END-IF.                                                              
C33743*    IF WS-USER-DEF-1-TX-T-NI < 0                                         
C33743*        MOVE SPACES TO RS-USER-DEF-1-TX-TEXT                             
C33743*    ELSE                                                                 
C33743*        IF USER-DEF-1-TX-LEN = ZERO                                      
C33743*            MOVE SPACES TO RS-USER-DEF-1-TX-TEXT                         
C33743*        ELSE                                                             
C33743*            MOVE USER-DEF-1-TX-TEXT TO RS-USER-DEF-1-TX-TEXT             
C33743*        END-IF                                                           
C33743*    END-IF.                                                              
C33743*    IF WS-USER-DEF-2-TX-T-NI < 0                                         
C33743*        MOVE SPACES TO RS-USER-DEF-2-TX-TEXT                             
C33743*    ELSE                                                                 
C33743*        IF USER-DEF-2-TX-LEN = ZERO                                      
C33743*            MOVE SPACES TO RS-USER-DEF-2-TX-TEXT                         
C33743*        ELSE                                                             
C33743*            MOVE USER-DEF-2-TX-TEXT TO RS-USER-DEF-2-TX-TEXT             
C33743*        END-IF                                                           
C33743*    END-IF.                                                              
C33743*    IF WS-USER-DEF-3-TX-T-NI < 0                                         
C33743*        MOVE SPACES TO RS-USER-DEF-3-TX-TEXT                             
C33743*    ELSE                                                                 
C33743*        IF USER-DEF-3-TX-LEN = ZERO                                      
C33743*            MOVE SPACES TO RS-USER-DEF-3-TX-TEXT                         
C33743*        ELSE                                                             
C33743*            MOVE USER-DEF-3-TX-TEXT TO RS-USER-DEF-3-TX-TEXT             
C33743*        END-IF                                                           
C33743*    END-IF.                                                              
C33743*    IF WS-USER-DEF-4-TX-T-NI < 0                                         
C33743*        MOVE SPACES TO RS-USER-DEF-4-TX-TEXT                             
C33743*    ELSE                                                                 
C33743*        IF USER-DEF-4-TX-LEN = ZERO                                      
C33743*            MOVE SPACES TO RS-USER-DEF-4-TX-TEXT                         
C33743*        ELSE                                                             
C33743*            MOVE USER-DEF-4-TX-TEXT TO RS-USER-DEF-4-TX-TEXT             
C33743*        END-IF                                                           
C33743*    END-IF.                                                              
C33743*    IF WS-POLE-ID-NI < 0                                                 
C33743*        MOVE SPACES TO RS-POLE-ID                                        
C33743*    ELSE                                                                 
C33743*        MOVE POLE-ID TO RS-POLE-ID                                       
C33743*    END-IF.                                                              
C33743*    IF WS-SWITCHGEAR-ID-NI < 0                                           
C33743*        MOVE SPACES TO RS-SWITCHGEAR-ID                                  
C33743*    ELSE                                                                 
C33743*        MOVE SWITCHGEAR-ID TO RS-SWITCHGEAR-ID                           
C33743*    END-IF.                                                              
C33743*    IF WS-UGSTRUCTURE-ID-NI < 0                                          
C33743*        MOVE SPACES TO RS-UGSTRUCTURE-ID                                 
C33743*    ELSE                                                                 
C33743*        MOVE UGSTRUCTURE-ID TO RS-UGSTRUCTURE-ID                         
C33743*    END-IF.                                                              
C33743*    IF WS-UGTRANSFORMER-ID-NI < 0                                        
C33743*        MOVE SPACES TO RS-UGTRANSFORMER-ID                               
C33743*    ELSE                                                                 
C33743*        MOVE UGTRANSFORMER-ID TO RS-UGTRANSFORMER-ID                     
C33743*    END-IF.                                                              
A03662     MOVE QG-AREA-TX       TO RS-GIS-LOC-OFF-TX.                  
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
REARCH     PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT.                  
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                                   
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
                                                                        
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
                                                                        
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02529_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02529_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
                                                                        
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02529_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
                                                                        
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
                                                                        
REARCH******************************************************************        
REARCH*8100-SEND-RESULT.                                                        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02529_R1                        
REARCH           (                                                      
REARCH                RETURN_CODE                                       
REARCH               ,METER_NO                                          
REARCH               ,METER_STAT                                        
REARCH               ,POINT_ID                                          
REARCH               ,GIS_LOC_OFF_CD                                    
REARCH               ,TAG_NM                                            
C33743*              ,POINT_TYPE_CD                                             
REARCH               ,GRID_CELL_TX                                      
REARCH               ,SUBSTATION_ID                                     
REARCH               ,CIRCUIT_ID                                        
REARCH               ,LOCAL_OFFICE_TX                                   
C33743*              ,COUNTY_CD                                                 
C33743*              ,WORK_REQUEST_ID                                           
                     ,LAST_UPDATE_ID                                    
                     ,LAST_UPDATE_DT                                    
C33743*              ,GIS_DT                                                    
C33743*              ,USER_DEF_1_TX_TEXT                                        
C33743*              ,USER_DEF_2_TX_TEXT                                        
C33743*              ,USER_DEF_3_TX_TEXT                                        
C33743*              ,USER_DEF_4_TX_TEXT                                        
C33743*              ,POLE_ID                                                   
C33743*              ,SWITCHGEAR_ID                                             
C33743*              ,UGSTRUCTURE_ID                                            
C33743*              ,UGTRANSFORMER_ID                                          
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                 :S-RETURN-CODE                                   
REARCH                ,:S-METER-NO                                      
REARCH                ,:S-CODE-METER-STATUS                             
REARCH                ,:S-POINT-ID                                      
REARCH                ,:S-GIS-LOC-OFF-CD                                
REARCH                ,:S-TAG-NM                                        
C33743*               ,:S-POINT-TYPE-CD                                         
REARCH                ,:S-GRID-CELL-TX                                  
REARCH                ,:S-SUBSTATION-ID                                 
REARCH                ,:S-CIRCUIT-ID                                    
REARCH                ,:S-GIS-LOC-OFF-TX                                
C33743*               ,:S-COUNTY-CD                                             
C33743*               ,:S-WORK-REQUEST-ID                                       
REARCH                ,:S-LAST-UPDATE-ID                                
C33743                ,:S-LAST-UPDATE-DT                                
C33743*               ,:S-GIS-DT                                                
C33743*               ,:S-USER-DEF-1-TX-TEXT                                    
C33743*               ,:S-USER-DEF-2-TX-TEXT                                    
C33743*               ,:S-USER-DEF-3-TX-TEXT                                    
C33743*               ,:S-USER-DEF-4-TX-TEXT                                    
C33743*               ,:S-POLE-ID                                               
C33743*               ,:S-SWITCHGEAR-ID                                         
C33743*               ,:S-UGSTRUCTURE-ID                                        
C33743*               ,:S-UGTRANSFORMER-ID                                      
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02529_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,METER_NO                                                  
MFA-TR*              ,METER_STAT                                                
MFA-TR*              ,POINT_ID                                                  
MFA-TR*              ,GIS_LOC_OFF_CD                                            
MFA-TR*              ,TAG_NM                                                    
MFA-TR*              ,POINT_TYPE_CD                                             
MFA-TR*              ,GRID_CELL_TX                                              
MFA-TR*              ,SUBSTATION_ID                                             
MFA-TR*              ,CIRCUIT_ID                                                
MFA-TR*              ,LOCAL_OFFICE_TX                                           
MFA-TR*              ,COUNTY_CD                                                 
MFA-TR*              ,WORK_REQUEST_ID                                           
MFA-TR*              ,LAST_UPDATE_ID                                            
MFA-TR*              ,LAST_UPDATE_DT                                            
MFA-TR*              ,GIS_DT                                                    
MFA-TR*              ,USER_DEF_1_TX_TEXT                                        
MFA-TR*              ,USER_DEF_2_TX_TEXT                                        
MFA-TR*              ,USER_DEF_3_TX_TEXT                                        
MFA-TR*              ,USER_DEF_4_TX_TEXT                                        
MFA-TR*              ,POLE_ID                                                   
MFA-TR*              ,SWITCHGEAR_ID                                             
MFA-TR*              ,UGSTRUCTURE_ID                                            
MFA-TR*              ,UGTRANSFORMER_ID                                          
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*                :S-RETURN-CODE                                           
MFA-TR*               ,:S-METER-NO                                              
MFA-TR*               ,:S-CODE-METER-STATUS                                     
MFA-TR*               ,:S-POINT-ID                                              
MFA-TR*               ,:S-GIS-LOC-OFF-CD                                        
MFA-TR*               ,:S-TAG-NM                                                
MFA-TR*               ,:S-POINT-TYPE-CD                                         
MFA-TR*               ,:S-GRID-CELL-TX                                          
MFA-TR*               ,:S-SUBSTATION-ID                                         
MFA-TR*               ,:S-CIRCUIT-ID                                            
MFA-TR*               ,:S-GIS-LOC-OFF-TX                                        
MFA-TR*               ,:S-COUNTY-CD                                             
MFA-TR*               ,:S-WORK-REQUEST-ID                                       
MFA-TR*               ,:S-LAST-UPDATE-ID                                        
MFA-TR*               ,:S-LAST-UPDATE-DT                                        
MFA-TR*               ,:S-GIS-DT                                                
MFA-TR*               ,:S-USER-DEF-1-TX-TEXT                                    
MFA-TR*               ,:S-USER-DEF-2-TX-TEXT                                    
MFA-TR*               ,:S-USER-DEF-3-TX-TEXT                                    
MFA-TR*               ,:S-USER-DEF-4-TX-TEXT                                    
MFA-TR*               ,:S-POLE-ID                                               
MFA-TR*               ,:S-SWITCHGEAR-ID                                         
MFA-TR*               ,:S-UGSTRUCTURE-ID                                        
MFA-TR*               ,:S-UGTRANSFORMER-ID                                      
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
                                                                        
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02529_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
                                                                        
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
