       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02528.                                         
       DATE-WRITTEN. JAN 7, 2003.                                       
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S528 CONVERTED TO DB2 SP CSR02528 ON 03/08/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S528                                           *        
      *  PROGRAM:       S528                                           *        
      *  CALLING SP:    PN_S528                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
C33743*  THIS PROGRAM SELECTS FROM CSS_PIM_POINT.                      *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  01/07/03    LHO      CREATED.                                 *        
REARCH*  03/13/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
C33743*  05/16/08  SC41135    POINT-ID PROJECT - REPLACE SNE_POINT     *        
C33743*                       WITH CSS_PIM_POINT                       *        
A1423 *  07/08/09  SC41135    CHGS TO FIX THE LOOPING ISSUE WITH FETCH *        
A03662*  09/14/11  FMB        REPLACED WMS_OP_AREA WITH CSS_OP_AREA    *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02528'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02528 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_PREMISE       PR  TABLE                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
C33743*----< CSS_PIM_POINT       TABLE                                          
C33743     EXEC SQL                                                             
C33743        INCLUDE TBPIMPNT                                                  
C33743     END-EXEC.                                                            
C33743                                                                  
A03662*----< CSS_OP_AREA         TABLE                                          
C33743     EXEC SQL                                                             
A03662        INCLUDE TBOPAREA                                                  
C33743     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       COPY CWS00011.                                                           
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02528'.      
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-TAGNUMBER          PIC X(10) VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-LST-UPD-DT-NULL-IND PIC S9(4) COMP                    
                                      VALUE -1.                         
           05  WS-GIS-DT-NULL-IND     PIC S9(4) COMP                    
                                      VALUE -1.                         
           05  WS-GRID-CELL-TX-NI     PIC S9(4) COMP                    
                                      VALUE -1.                         
           05  WS-SUBSTATION-ID-NI    PIC S9(4) COMP                    
                                      VALUE -1.                         
           05  WS-CIRCUIT-ID-NI       PIC S9(4) COMP                    
                                      VALUE -1.                         
C33743     05  WS-INACTIVE-TS-NI      PIC S9(4) COMP VALUE ZERO.        
           05  WS-LAST-UPDATE-ID-NI   PIC S9(4) COMP                    
                                      VALUE -1.                         
C33743    05  WS-LOCATION-TX-NI      PIC S9(4) COMP                     
C33743                               VALUE -1.                          
C33743    05  WS-COMMENTS-TX-NI      PIC S9(4) COMP                     
C33743                               VALUE -1.                          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-MAX-RETURN-ROWS      PIC S9(3) COMP VALUE +50.        
           05  WS-ROW-CT               PIC S9(3) COMP VALUE 0.          
           05  WS-TOTAL-ROWS           PIC S9(5) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WS-TRANS-APPL-NO        PIC S9(04) COMP VALUE 0.         
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-PREMISE-NO-X         PIC X(10).                       
           05  WS-PREMISE-NO           REDEFINES WS-PREMISE-NO-X        
                                       PIC 9(10).                       
           05  WS-TAG-NUMBER-X         PIC X(10).                       
           05  WS-TAG-NO               REDEFINES WS-TAG-NUMBER-X.       
               07  WS-GIS-LOCAL-OFF    PIC X(3).                        
               07  WS-TAG-NUMBER       PIC X(7).                        
           05  WS-CURRENT-TS           PIC X(26).                       
           05  WS-POINT-ID             PIC X(09) VALUE SPACES.          
           05  WS-POLE-ID              PIC X(09) VALUE SPACES.          
           05  WS-WORK-REQUEST-ID      PIC X(13) VALUE SPACES.          
           05  WS-SWITCHGEAR-ID        PIC X(09) VALUE SPACES.          
           05  WS-UGSTRUCTURE-ID       PIC X(09) VALUE SPACES.          
           05  WS-UGTRANSFORMER-ID     PIC X(09) VALUE SPACES.          
C33743     05  WS-LOCATION-TX          PIC X(255) VALUE SPACES.         
C33743     05  WS-COMMENTS-TX          PIC X(255) VALUE SPACES.         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(9)   COMP VALUE 0.      
           05  RS-POINT-ID               PIC X(9)    VALUE SPACES.      
           05  RS-GIS-LOC-OFF-CD         PIC X(3)    VALUE SPACES.      
           05  RS-TAG-NM                 PIC X(10)   VALUE SPACES.      
           05  RS-POINT-TYPE-CD          PIC X(03)   VALUE SPACES.      
           05  RS-GRID-CELL-TX           PIC X(10)   VALUE SPACES.      
           05  RS-SUBSTATION-ID          PIC X(05)   VALUE SPACES.      
           05  RS-CIRCUIT-ID             PIC X(05)   VALUE SPACES.      
           05  RS-COUNTY-CD              PIC X(03)   VALUE SPACES.      
           05  RS-WORK-REQUEST-ID        PIC X(13)   VALUE SPACES.      
           05  RS-LAST-UPDATE-ID         PIC X(7)    VALUE SPACES.      
           05  RS-LAST-UPDATE-DT         PIC X(26)   VALUE SPACES.      
           05  RS-GIS-DT                 PIC X(26)   VALUE SPACES.      
           05  RS-POLE-ID                PIC X(9)    VALUE SPACES.      
           05  RS-SWITCHGEAR-ID          PIC X(9)    VALUE SPACES.      
           05  RS-UGSTRUCTURE-ID         PIC X(9)    VALUE SPACES.      
           05  RS-UGTRANSFORMER-ID       PIC X(9)    VALUE SPACES.      
           05  RS-GIS-LOC-OFF-TX         PIC X(40)   VALUE SPACES.      
C33743     05  RS-LOCATION-TX            PIC X(255)  VALUE SPACES.      
C33743     05  RS-COMMENTS-TX            PIC X(255)  VALUE SPACES.      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE             PIC S9(9)   COMP VALUE 0.      
REARCH     05  S-POINT-ID                PIC X(9)    VALUE SPACES.      
REARCH     05  S-GIS-LOC-OFF-CD          PIC X(3)    VALUE SPACES.      
REARCH     05  S-TAG-NM                  PIC X(10)   VALUE SPACES.      
REARCH     05  S-POINT-TYPE-CD           PIC X(03)   VALUE SPACES.      
REARCH     05  S-GRID-CELL-TX            PIC X(10)   VALUE SPACES.      
REARCH     05  S-SUBSTATION-ID           PIC X(05)   VALUE SPACES.      
REARCH     05  S-CIRCUIT-ID              PIC X(05)   VALUE SPACES.      
REARCH     05  S-COUNTY-CD               PIC X(03)   VALUE SPACES.      
REARCH     05  S-WORK-REQUEST-ID         PIC X(13)   VALUE SPACES.      
REARCH     05  S-LAST-UPDATE-ID          PIC X(7)    VALUE SPACES.      
REARCH     05  S-LAST-UPDATE-DT          PIC X(26)   VALUE SPACES.      
REARCH     05  S-GIS-DT                  PIC X(26)   VALUE SPACES.      
REARCH     05  S-GIS-LOC-OFF-TX          PIC X(40)   VALUE SPACES.      
C33743     05  S-LOCATION-TX             PIC X(255)  VALUE SPACES.      
C33743     05  S-COMMENTS-TX             PIC X(255)  VALUE SPACES.      
                                                                        
C33743*--- < CURSOR FOR CSS_PIM_POINT   SELECTION >                             
                                                                        
C33743     EXEC SQL DECLARE PIM-POINT-CUR   CURSOR FOR                  
C33743         SELECT PT.POINT_ID,                                      
C33743                PT.AREA_ID,                                       
C33743                PT.TAG_NM,                                        
C33743                PT.GRID_CELL_TX,                                  
C33743                PT.SUBSTATION_ID,                                 
C33743                PT.CIRCUIT_ID,                                    
C33743                PT.LAST_UPDATE_USERID,                            
C33743                REPLACE(REPLACE(CONVERT(CHAR(26), 
           PT.LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') 
           LAST_UPDATE_TS,                                
C33743                LO.AREA_TX,                                       
C33743                PT.LOCATION_TX,                                   
C33743                PT.COMMENTS_TX,                                   
C33743                REPLACE(REPLACE(CONVERT(CHAR(26), PT.INACTIVE_TS
           , 121), ' ', '-'), ':', '.') INACTIVE_TS                            
C33743       FROM CSS_PIM_POINT  PT,                                    
A03662            CSS_OP_AREA    LO                                     
C33743       WHERE PT.TAG_NM         = :PP-TAG-NM                       
C33743         AND PT.AREA_ID        = :PP-AREA-ID                      
C33743         AND PT.AREA_ID        = LO.AREA_ID                       
A1423          AND PT.INACTIVE_TS IS NULL                               
             ORDER BY TAG_NM                                            
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE PIM-POINT-CUR   CURSOR FOR                          
MFA-TR*        SELECT PT.POINT_ID,                                              
MFA-TR*               PT.AREA_ID,                                               
MFA-TR*               PT.TAG_NM,                                                
MFA-TR*               PT.GRID_CELL_TX,                                          
MFA-TR*               PT.SUBSTATION_ID,                                         
MFA-TR*               PT.CIRCUIT_ID,                                            
MFA-TR*               PT.LAST_UPDATE_USERID,                                    
MFA-TR*               PT.LAST_UPDATE_TS,                                        
MFA-TR*               LO.AREA_TX,                                               
MFA-TR*               PT.LOCATION_TX,                                           
MFA-TR*               PT.COMMENTS_TX,                                           
MFA-TR*               PT.INACTIVE_TS                                            
MFA-TR*      FROM CSS_PIM_POINT  PT,                                            
MFA-TR*           CSS_OP_AREA    LO                                             
MFA-TR*      WHERE PT.TAG_NM         = :PP-TAG-NM                               
MFA-TR*        AND PT.AREA_ID        = :PP-AREA-ID                              
MFA-TR*        AND PT.AREA_ID        = LO.AREA_ID                               
MFA-TR*        AND PT.INACTIVE_TS IS NULL                                       
MFA-TR*      ORDER BY TAG_NM                                                    
MFA-TR*      QUERYNO 2310                                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             RETURN_CODE                 AS RETURN_CODE           
REARCH            ,LTRIM(RTRIM(POINT_ID))             AS POINT_ID              
REARCH            ,LTRIM(RTRIM(GIS_LOC_OFF_CD))       AS GIS_LOC_OFF_CD        
REARCH            ,LTRIM(RTRIM(TAG_NM))               AS TAG_NM                
REARCH            ,LTRIM(RTRIM(GRID_CELL_TX))         AS GRID_CELL_TX          
REARCH            ,LTRIM(RTRIM(SUBSTATION_ID))        AS SUBSTATION_ID         
REARCH            ,LTRIM(RTRIM(CIRCUIT_ID))           AS CIRCUIT_ID            
REARCH            ,LTRIM(RTRIM(LAST_UPDATE_ID))       AS LAST_UPDATE_ID        
REARCH            ,LTRIM(RTRIM(LAST_UPDATE_DT))       AS LAST_UPDATE_DT        
REARCH            ,LTRIM(RTRIM(GIS_LOC_OFF_TX))       AS LOCAL_OFFICE_TX       
C33743            ,LTRIM(RTRIM(LOCATION_TX))          AS LOCATION_TX           
C33743            ,LTRIM(RTRIM(COMMENTS_TX))          AS COMMENTS_TX           
CVT000         FROM #CSR02528_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                 AS RETURN_CODE                   
MFA-TR*           ,STRIP(POINT_ID)             AS POINT_ID                      
MFA-TR*           ,STRIP(GIS_LOC_OFF_CD)       AS GIS_LOC_OFF_CD                
MFA-TR*           ,STRIP(TAG_NM)               AS TAG_NM                        
MFA-TR*           ,STRIP(GRID_CELL_TX)         AS GRID_CELL_TX                  
MFA-TR*           ,STRIP(SUBSTATION_ID)        AS SUBSTATION_ID                 
MFA-TR*           ,STRIP(CIRCUIT_ID)           AS CIRCUIT_ID                    
MFA-TR*           ,STRIP(LAST_UPDATE_ID)       AS LAST_UPDATE_ID                
MFA-TR*           ,STRIP(LAST_UPDATE_DT)       AS LAST_UPDATE_DT                
MFA-TR*           ,STRIP(GIS_LOC_OFF_TX)       AS LOCAL_OFFICE_TX               
MFA-TR*           ,STRIP(LOCATION_TX)          AS LOCATION_TX                   
MFA-TR*           ,STRIP(COMMENTS_TX)          AS COMMENTS_TX                   
MFA-TR*        FROM SESSION.CSR02528_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-TAGNUMBER           PIC X(10)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-TAGNUMBER,                                         
CVT000          LINK-PREMISE-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT000     MOVE LINK-TAGNUMBER            TO PARM-TAGNUMBER           . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02528_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02528_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,POINT_ID CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,GIS_LOC_OFF_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,TAG_NM CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2                 
CVT000        ,GRID_CELL_TX CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,SUBSTATION_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,CIRCUIT_ID CHAR(05)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,LAST_UPDATE_ID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,LAST_UPDATE_DT CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,GIS_LOC_OFF_TX CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
C33743        ,LOCATION_TX CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2           
C33743        ,COMMENTS_TX CHAR(255)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
REARCH            MOVE 'CSR02528_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2300-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                               *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH     MOVE RS-POINT-ID            TO S-POINT-ID.                   
REARCH     MOVE RS-GIS-LOC-OFF-CD      TO S-GIS-LOC-OFF-CD.             
REARCH     MOVE RS-TAG-NM              TO S-TAG-NM.                     
REARCH     MOVE RS-GRID-CELL-TX        TO S-GRID-CELL-TX.               
REARCH     MOVE RS-SUBSTATION-ID       TO S-SUBSTATION-ID.              
REARCH     MOVE RS-CIRCUIT-ID          TO S-CIRCUIT-ID.                 
REARCH     MOVE RS-LAST-UPDATE-ID      TO S-LAST-UPDATE-ID.             
REARCH     MOVE RS-LAST-UPDATE-DT      TO S-LAST-UPDATE-DT.             
REARCH     MOVE RS-GIS-LOC-OFF-TX      TO S-GIS-LOC-OFF-TX.             
C33743     MOVE RS-LOCATION-TX         TO S-LOCATION-TX.                
C33743     MOVE RS-COMMENTS-TX         TO S-COMMENTS-TX.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                 03680000
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE PARM-TAGNUMBER TO WS-TAG-NUMBER-X.                      
C33743     MOVE WS-TAG-NUMBER  TO PP-TAG-NM.                            
C33743     MOVE WS-GIS-LOCAL-OFF TO PP-AREA-ID.                         
                                                                        
           PERFORM 2310-OPEN-POINT-CURSOR THRU 2310-EXIT.               
           PERFORM 2315-FETCH-POINT-CURSOR THRU 2315-EXIT               
A1423          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                  
A1423 *    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                                 
A1423         IF WS-TOTAL-ROWS = 0 THEN                                 
              MOVE  100      TO RS-RETURN-CODE                          
REARCH        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF                                                       
A1423 *       PERFORM 2315-FETCH-POINT-CURSOR THRU 2315-EXIT                    
A1423 *          UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
A1423 *    END-IF                                                               
           PERFORM 2320-CLOSE-POINT-CURSOR THRU 2320-EXIT.              
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2310-OPEN-POINT-CURSOR                                         *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN POINT CURSOR                                          *        
      ******************************************************************        
                                                                        
       2310-OPEN-POINT-CURSOR.                                          
                                                                        
           MOVE '2310'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
C33743        OPEN PIM-POINT-CUR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                ABEND-TABLES            
              MOVE 'CSS_PIM_POINT'            TO TABLE-1                
              MOVE 'TAG_NO'                   TO TABLE-ELEMENT-1        
              MOVE PARM-TAGNUMBER             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2315-FETCH-POINT-CURSOR                                        *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     FETCH POINT CURSOR                                         *        
      ******************************************************************        
                                                                        
       2315-FETCH-POINT-CURSOR.                                         
                                                                        
           MOVE '2315'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
C33743        FETCH PIM-POINT-CUR                                       
C33743         INTO :PP-POINT-ID,                                       
C33743              :PP-AREA-ID,                                        
C33743              :PP-TAG-NM,                                         
C33743              :PP-GRID-CELL-TX :WS-GRID-CELL-TX-NI,                
C33743              :PP-SUBSTATION-ID :WS-SUBSTATION-ID-NI,              
C33743              :PP-CIRCUIT-ID :WS-CIRCUIT-ID-NI,                    
C33743              :PP-LAST-UPDATE-USERID :WS-LAST-UPDATE-ID-NI,        
C33743              :PP-LAST-UPDATE-TS :WS-LST-UPD-DT-NULL-IND,          
A03662             :QG-AREA-TX,                                         
C33743             :PP-LOCATION-TX :WS-LOCATION-TX-NI,                   
C33743             :PP-COMMENTS-TX :WS-COMMENTS-TX-NI,                   
C33743             :PP-INACTIVE-TS :WS-INACTIVE-TS-NI                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
A1423               MOVE SPACES TO PP-INACTIVE-TS                       
                    PERFORM 2400-MOVE-RESULT-SET THRU 2400-EXIT         
A1423               ADD  1   TO WS-TOTAL-ROWS                           
               WHEN NOT-FOUND                                           
                    GO TO 2315-EXIT                                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
C33743              MOVE 'CSS_PIM_POINT'      TO TABLE-1                
                    MOVE 'TAG-NO'             TO TABLE-ELEMENT-1        
                    MOVE PARM-TAGNUMBER       TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
                    MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE        
REARCH              PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT           
                    PERFORM 8100-SEND-RESULT THRU 8100-EXIT             
           END-EVALUATE.                                                
                                                                        
       2315-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2320-CLOSE-POINT-CURSOR                                        *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     OPEN POINT CURSOR                                          *        
      ******************************************************************        
                                                                        
       2320-CLOSE-POINT-CURSOR.                                         
                                                                        
           MOVE '2320'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
C33743        CLOSE PIM-POINT-CUR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                ABEND-TABLES            
              MOVE 'CSS_PIM_POINT'            TO TABLE-1                
              MOVE 'TAG_NO'                   TO TABLE-ELEMENT-1        
              MOVE PARM-TAGNUMBER             TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-MOVE-RESULT-SET                                           *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT-SET                          *        
      *                                                                *        
      *     MOVE DATA TO RESULT SET.                                   *        
      ******************************************************************        
                                                                        
       2400-MOVE-RESULT-SET.                                            
                                                                        
C33743     MOVE PP-POINT-ID TO RS-POINT-ID.                             
C33743     MOVE PP-AREA-ID TO RS-GIS-LOC-OFF-CD.                        
C33743     MOVE PP-TAG-NM TO RS-TAG-NM.                                 
           IF WS-GRID-CELL-TX-NI < 0                                    
               MOVE SPACES TO RS-GRID-CELL-TX                           
           ELSE                                                         
C33743         MOVE PP-GRID-CELL-TX TO RS-GRID-CELL-TX                  
           END-IF.                                                      
           IF WS-SUBSTATION-ID-NI < 0                                   
               MOVE SPACES TO RS-SUBSTATION-ID                          
           ELSE                                                         
C33743         MOVE PP-SUBSTATION-ID TO RS-SUBSTATION-ID                
           END-IF.                                                      
           IF WS-CIRCUIT-ID-NI < 0                                      
               MOVE SPACES TO RS-CIRCUIT-ID                             
           ELSE                                                         
C33743         MOVE PP-CIRCUIT-ID TO RS-CIRCUIT-ID                      
           END-IF.                                                      
C33743     IF WS-LOCATION-TX-NI < 0                                     
C33743         MOVE SPACES TO RS-LOCATION-TX                            
C33743     ELSE                                                         
C33743         MOVE PP-LOCATION-TX TO RS-LOCATION-TX                    
C33743     END-IF.                                                      
C33743     IF WS-COMMENTS-TX-NI < 0                                     
C33743         MOVE SPACES TO RS-COMMENTS-TX                            
C33743     ELSE                                                         
C33743         MOVE PP-COMMENTS-TX TO RS-COMMENTS-TX                    
C33743     END-IF.                                                      
                                                                        
           IF WS-LAST-UPDATE-ID-NI < 0                                  
               MOVE SPACES TO RS-LAST-UPDATE-ID                         
           ELSE                                                         
C33743         MOVE PP-LAST-UPDATE-USERID TO RS-LAST-UPDATE-ID          
           END-IF.                                                      
           IF WS-LST-UPD-DT-NULL-IND < 0                                
               MOVE SPACES TO RS-LAST-UPDATE-DT                         
           ELSE                                                         
C33743         MOVE PP-LAST-UPDATE-TS TO RS-LAST-UPDATE-DT              
           END-IF.                                                      
A03662     MOVE QG-AREA-TX        TO RS-GIS-LOC-OFF-TX.                 
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02528_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02528_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02528_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02528_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,POINT_ID                                                  
CVT000       ,GIS_LOC_OFF_CD                                            
CVT000       ,TAG_NM                                                    
CVT000       ,GRID_CELL_TX                                              
CVT000       ,SUBSTATION_ID                                             
CVT000       ,CIRCUIT_ID                                                
CVT000       ,LAST_UPDATE_ID                                            
CVT000       ,LAST_UPDATE_DT                                            
CVT000       ,GIS_LOC_OFF_TX                                            
C33743       ,LOCATION_TX                                               
C33743       ,COMMENTS_TX                                               
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-POINT-ID                                               
REARCH       ,:S-GIS-LOC-OFF-CD                                         
REARCH       ,:S-TAG-NM                                                 
REARCH       ,:S-GRID-CELL-TX                                           
REARCH       ,:S-SUBSTATION-ID                                          
REARCH       ,:S-CIRCUIT-ID                                             
REARCH       ,:S-LAST-UPDATE-ID                                         
REARCH       ,:S-LAST-UPDATE-DT                                         
REARCH       ,:S-GIS-LOC-OFF-TX                                         
C33743       ,:S-LOCATION-TX                                            
C33743       ,:S-COMMENTS-TX                                            
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02528_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,POINT_ID                                                          
MFA-TR*      ,GIS_LOC_OFF_CD                                                    
MFA-TR*      ,TAG_NM                                                            
MFA-TR*      ,GRID_CELL_TX                                                      
MFA-TR*      ,SUBSTATION_ID                                                     
MFA-TR*      ,CIRCUIT_ID                                                        
MFA-TR*      ,LAST_UPDATE_ID                                                    
MFA-TR*      ,LAST_UPDATE_DT                                                    
MFA-TR*      ,GIS_LOC_OFF_TX                                                    
MFA-TR*      ,LOCATION_TX                                                       
MFA-TR*      ,COMMENTS_TX                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-POINT-ID                                                       
MFA-TR*      ,:S-GIS-LOC-OFF-CD                                                 
MFA-TR*      ,:S-TAG-NM                                                         
MFA-TR*      ,:S-GRID-CELL-TX                                                   
MFA-TR*      ,:S-SUBSTATION-ID                                                  
MFA-TR*      ,:S-CIRCUIT-ID                                                     
MFA-TR*      ,:S-LAST-UPDATE-ID                                                 
MFA-TR*      ,:S-LAST-UPDATE-DT                                                 
MFA-TR*      ,:S-GIS-LOC-OFF-TX                                                 
MFA-TR*      ,:S-LOCATION-TX                                                    
MFA-TR*      ,:S-COMMENTS-TX                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000        MOVE SQLCODE              TO ABEND-SQLCODE                
CVT000        MOVE SQLSTATE             TO ABEND-SQLSTATE               
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02528_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
                                                                        
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
