       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02520.                                         
COB303 DATE-WRITTEN.      JULY 5, 2002.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S520 CONVERTED TO DB2 SP CSR02520 ON 01/29/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S520                                           *00120000
      *  PROGRAM:       S520                                           *00130000
      *  CALLING SP:    S520                                           *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM UPDATES THE SENIOR FLAG AND SENIOR RATES.        *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
C26959*  07/05/02    FMB      RPC ORIGINALLY ADDED.                    *00290000
C27578*  03/14/03    RR       MODIFY EXP DATE ON DHR IF EXISTS         *        
C30688*  04/27/04    DD       UPDATE CSS_REG_PROFILE WHEN CSS_DHR_HIST *00550000
C30688*                       IS UPDATED.                              *        
C32157*  01/29/05    RR       UPDATE SENIOR RATE FOR BOTH DEREG AND REG*        
C32579*  07/27/05    AW       FALL CAMPAIGN 2005                       *        
C34696*  08/15/06    AW       FALL CAMPAIGN 2006                       *        
C34992*  10/24/06    SC       FALL CAMPAIGN 2006                       *        
C35248*  01/10/07    SC       SEB NEW RATES 2007                       *        
C35356*  02/06/07    SC       SEB NEW RATES 2007                       *        
C35436*  02/27/07    SC       SEB NEW RATES 2007 - MARCH DIRECT MAILING*        
C36211*  08/31/07    SC       SEB NEW RATES 2007 - FALL OFFERS,                 
C36211*                       REGULATED AND INTRO RATES.                        
C36340*  09/20/07    SC       SCANA ENERGY TV RATES AND OCTOBER RATES  *        
C36340*                       NEW COMMERCIAL RATES                     *        
C36456*  10/22/07    SC       SEB - NOVEMBER PROMO RATES, TIER RATES,  *        
C36456*                       TV RATES AND SAVANNAH NEWSPAPER RATES    *        
C36659*  12/20/07    SC       SEB NEW RATES - SENIOR UPDATES           *        
C36670*  01/09/08    SC       SEB NEW RATES - DIRECT MAIL              *        
C34569*  01/10/08    SS       SEB RATE REENGINEERING                   *        
ID0113*  01/14/09    DB18339  ADDED CHECK FOR SENIOR RATE              *        
P00141*  04/14/09    SS97726  ADD START/END DATE TO OPT_ATTR_INCTV     *        
P00172*  07/12/09    SS19371  REMOVE ALL REFERENCES TO CSS_DHR_HIST    *        
P00172*                       AND USE DHR_FL FROM  CSS_CUSTOMER        *        
P00473*  09/16/11    DB18339  MODERNIZATION CHANGES TO PARA 7030       *        
P00677*  06/13/12    DB18339  ADDED GROUP 2 TO FIXED RATE WQ CHECK     *        
ACT220*  14/07/16    TP7R341  REPLACE CSR00028 WITH CSR04675                    
ACT220*   A05460                                                                
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02520'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S520 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
      **************************************************************            
      * CSS_REG_PROFILE                                                         
      **************************************************************            
           EXEC SQL                                                     00970000
              INCLUDE TBREGPRF                                          00980000
           END-EXEC.                                                    00990000
                                                                        
      **************************************************************            
      * CSS_ACCOUNT                                                             
      **************************************************************            
C32157     EXEC SQL                                                             
C32157        INCLUDE TBACCT                                                    
C32157     END-EXEC.                                                            
                                                                        
P00172**************************************************************            
P00172* CSS_CUSTOMER                                                            
P00172**************************************************************            
P00172     EXEC SQL                                                             
P00172        INCLUDE TBCUST                                                    
P00172     END-EXEC.                                                            
                                                                        
      **************************************************************            
      * CSS_UTIL_ENVRNMT                                                        
      **************************************************************            
           EXEC SQL                                                     00970000
              INCLUDE TBUTLENV                                          00980000
           END-EXEC.                                                    00990000
                                                                        
      **************************************************************            
      * CSS_MODEL_SQL                                                           
      **************************************************************            
           EXEC SQL                                                     01300000
              INCLUDE TBMODEL                                           01310000
           END-EXEC.                                                    01320000
                                                                        
      **************************************************************            
      * CSS_MNT_TRANS_HIST                                                      
      **************************************************************            
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
                                                                        
      **************************************************************            
      * CSS_MT_TRN_HST_DET                                                      
      **************************************************************            
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
                                                                        
      **************************************************************            
      * CSS_ACCT_ATTRIBUTE                                                      
      **************************************************************            
C34569     EXEC SQL                                                     01420000
C34569        INCLUDE TBACTATT                                          01430000
C34569     END-EXEC.                                                    01440000
                                                                        
      **************************************************************            
      * CSS_FIXED_FACTOR                                                        
      **************************************************************            
C34569     EXEC SQL                                                     01420000
C34569        INCLUDE TBFXDFCT                                          01430000
C34569     END-EXEC.                                                    01440000
                                                                        
      **************************************************************            
      * CSS_BILL_WINDOW                                                         
      **************************************************************            
C34569     EXEC SQL                                                     01420000
C34569        INCLUDE TBBILWDW                                          01430000
C34569     END-EXEC.                                                    01440000
                                                                        
      **************************************************************            
      * CSS_ACCT_RTPK_AGR                                                       
      **************************************************************            
C34569     EXEC SQL                                                     01420000
C34569        INCLUDE TBACCTRG                                          01430000
C34569     END-EXEC.                                                    01440000
                                                                        
      **************************************************************            
      * CSS_RATE_PLAN_DESC - RD                                                 
      **************************************************************            
ID0113     EXEC SQL                                                     01420000
ID0113        INCLUDE TBRTDESC                                          01430000
ID0113     END-EXEC.                                                    01440000
                                                                        
           COPY CWS00303.                                               01520000
           COPY CWS00027.                                               01560000
                                                                        
           EXEC SQL                                                     01590000
              INCLUDE CWS00013                                          01600000
           END-EXEC.                                                    01610000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9) COMP.                 
           05  PARM-ACCOUNT-NO          PIC X(13) VALUE SPACES.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(09) COMP VALUE +0.   
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
C32157     05  REGULATED-SW            PIC X(01) VALUE 'N'.             
C32157         88 REG-ACCT                       VALUE 'Y'.             
C32157         88 DEREG-ACCT                     VALUE 'N'.             
C32157     05  UPDATE-RATE             PIC X(01) VALUE 'N'.             
C32157         88 RATE-FOUND                     VALUE 'Y'.             
C32157         88 RATE-NOT-FOUND                 VALUE 'N'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-TRANS-APPL-NO         PIC S9(04) COMP VALUE 0.        
           05  WS-ACCOUNT-NO-RED        PIC X(13).                      
           05  WS-ACCOUNT-NO            REDEFINES WS-ACCOUNT-NO-RED     
                                        PIC 9(13).                      
           05  PROGRAM-NAME             PIC X(08) VALUE 'S520    '.     
           05  WS-NEW-RATE-PLAN         PIC X(03) VALUE SPACES.         
           05  WS-OLD-RATE-PLAN         PIC X(03) VALUE SPACES.         
           05  WS-CURRENT-TS            PIC X(26).                      
           05  WS-CURRENT-DATE          PIC X(10).                      
C27578     05  WS-DHR-EXISTS            PIC X(01) VALUE 'N'.            
C27578     05  WS-HOLD-DATE             PIC X(10).                      
C27578     05  WS-EFF-DATE              PIC X(10) VALUE SPACES.         
C27578     05  WS-EFF-DATE-FROM.                                        
C27578         10  WS-EFF-DATE-FROM-YYYY PIC X(4) VALUE SPACES.         
C27578         10  WS-DASH-1             PIC X(1) VALUE '-'.            
C27578         10  WS-EFF-DATE-FROM-MM   PIC X(2) VALUE SPACES.         
C27578         10  WS-DASH-2             PIC X(1) VALUE '-'.            
C27578         10  WS-EFF-DATE-FROM-DD   PIC X(2) VALUE '01'.           
C27578     05  WS-REVENUE-MONTH-RED      PIC X(6) VALUE SPACES.         
C27578     05  WS-REVENUE-MONTH.                                        
C27578         10  WS-REVENUE-YYYY       PIC X(4) VALUE SPACES.         
C27578         10  WS-REVENUE-MM         PIC X(2) VALUE SPACES.         
C34569     05  WS-FIXED-RATE             PIC X(1) VALUE SPACES.         
C34569     05  WS-MESSAGE.                                              
C34569         10 WS-MESSAGE-PT1         PIC X(42) VALUE                
                  'Group 1 AGL Discount Senior; Verify Fixed '.         
C34569         10 WS-MESSAGE-PT2         PIC X(46) VALUE                
                  'Rate Price is Price at time of customer set up'.     
P00677     05  WS-MESSAGE-2.                                            
P00677         10 WS-MESSAGE-2-PT1       PIC X(42) VALUE                
P00677            'Group 2 AGL Discount Senior; Verify Fixed '.         
P00677         10 WS-MESSAGE-2-PT2       PIC X(46) VALUE                
P00677            'Rate Price is Price at time of customer set up'.     
C34569     05  WS-WQ-ITEM-ID             PIC S9(10)V COMP-3 VALUE +0.   
C34569     05  WS-WQ-ROUTE-CATEGORY      PIC X(01).                     
C34569     05  WS-WQ-LOCAL-OFFICE        PIC X(03).                     
C34569     05  WS-WQ-USER-ID-ASGN        PIC X(07).                     
C34569     05  WS-WQ-USER-ID-ORIG        PIC X(07).                     
C34569     05  WS-WQ-RESP-AREA-ID        PIC X(03).                     
C34569     05  WS-WQ-CATEGORY-ID         PIC S9(04) USAGE COMP.         
COB305     05 WS-WQ-ACCOUNT-NO        PIC S9(13)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-WQ-PREMISE-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-WQ-CUSTOMER-NO        PIC S9(10)V USAGE COMP-3 VALUE 0.      
COB305     05 WS-WQ-SERV-ORDER-NO        PIC S9(13)V USAGE COMP-3 
COB305       VALUE 0.      
C34569     05  WS-WQ-COMMENTS.                                          
C34569         49 WS-WQ-COMMENTS-LEN     PIC S9(04) USAGE COMP.         
C34569         49 WS-WQ-COMMENTS-TEXT    PIC X(250).                    
C34569     05  WS-WQ-DATE-REQUIRED       PIC X(26).                     
C34569     05  WS-WQ-DATE-CREATED        PIC X(26).                     
C34569     05  WS-WQ-PRIORITY            PIC X(01).                     
C34569     05  WS-WQ-FREE-FORM-AREA.                                    
C34569         49 WS-WQ-FREEFORM-LEN     PIC S9(04) USAGE COMP.         
C34569         49 WS-WQ-FREEFORM-TEXT    PIC X(255).                    
COB305     05 WS-DUP-WQ-CNT        PIC S9(03) USAGE COMP-3 VALUE 0.       
C34569     05  WS-DUP-WQ-CNT-IND         PIC S9(04) COMP VALUE ZERO.    
C34569     05  WS-NULL-IND-01            PIC S9(04) COMP VALUE ZERO.    
C34569     05  WS-EXISTING-FACTOR        PIC S9(04) COMP VALUE ZERO.    
ID0113     05  WS-CORRECT-RATE           PIC X(01) VALUE SPACES.        
P00172     05  WS-NULL-IND               PIC S9(04) COMP.               
ACT220     05  WS-WQ-CREATED-BY          PIC X(16) VALUE SPACES.        
                                                                        
ACT220 01  WS-CSR04675-OUTPUT.                                          
ACT220     05  WS-CSR04675-RET-CODE      PIC S9(09) COMP VALUE 0.       
                                                                        
ACT220 01  CSR04675-RETURN-DATA.                                        
ACT220     05  RETURN-CODE-4675          PIC S9(9) COMP VALUE 0.        
ACT220     05  OUT-ITEM-ID-4675          PIC S9(10)V COMP-3 VALUE 0.    
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************04640000
      * 0000-MAINLINE                                                  *04650000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04660000
      ******************************************************************04670000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04790000
      * 0100-INITIALIZE                                                *04800000
      *     1. RESET DB2 ERROR HANDLERS                                *04820000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *04830000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *04840000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*04850000
      ******************************************************************04870000
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE              AS    RETURN_CODE             
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
           MOVE PARM-ACCOUNT-NO TO WS-ACCOUNT-NO-RED.                   
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09200000
      *   2000-PROCESS-OUTPUT                                          *09210000
      *       1. DESCRIBE RESULT SET                                   *09230000
      *       2. RETRIEVE DB2 DATA                                     *09240000
      *       3. BUILD RESULT SET                                      *09250000
      *       4. SEND RESULT SET                                       *09260000
      ******************************************************************09280000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-BUILD-ACCOUNT-RESULT   THRU 5000-EXIT.          
                                                                        
      *  BAD RETURN CODES HANDLED VIA 9000- ROUTINE.                            
      *  DO NOT RETURN +100 WHEN RATES NOT FOUND.                               
                                                                        
           MOVE SUCCESSFUL-CALL            TO S-RETURN-CODE.            
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 5000-BUILD-ACCOUNT-RESULT                                               
      ******************************************************************09420000
       5000-BUILD-ACCOUNT-RESULT.                                       
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :WS-CURRENT-TS,                                    
                     :WS-CURRENT-DATE                                   
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-TS,                                            
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-ACCOUNT-NO TO LR-ACCOUNT-NO                          
C32157                           AT-ACCOUNT-NO                          
C34569                           YP-ACCOUNT-NO                          
C34569                           FF-ACCOUNT-NO                          
C34569                           DF-ACCOUNT-NO                          
C34569                           UT-ACCOUNT-NO.                         
                                                                        
           PERFORM 7000-RETRIEVE-PROFILE THRU 7000-EXIT.                
           PERFORM 7020-RETRIEVE-UTL-ENV THRU 7020-EXIT.                
                                                                        
C32157     IF DEREG-ACCT                                                
C32157        PERFORM 7005-RETRIEVE-DEREG-CUST THRU 7005-EXIT           
C32157     END-IF.                                                      
                                                                        
           PERFORM 5100-FORMAT-MH        THRU 5100-EXIT.                
                                                                        
C32157     IF REG-ACCT                                                  
C27578        PERFORM 7010-RETRIEVE-DHR-FL  THRU 7010-EXIT              
              PERFORM 5200-REG-PROFILE      THRU 5200-EXIT              
C32157     END-IF.                                                      
                                                                        
C34569     PERFORM 5500-ASSIGN-ACCT-ATT-VALUES  THRU 5500-EXIT.         
C34569     PERFORM 5600-ASSIGN-FACTOR-VALUES    THRU 5600-EXIT.         
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 5100-FORMAT-MH                                                          
      ******************************************************************09420000
       5100-FORMAT-MH.                                                  
                                                                        
           MOVE WS-CURRENT-DATE          TO MH-DATE-TRANS.              
           MOVE WS-CURRENT-TS            TO MH-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE 'AGL'                    TO MH-RESP-AREA-ID.            
           MOVE LR-CUSTOMER-NO           TO MH-CUSTOMER-NO.             
           MOVE WS-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE ZEROES                   TO MH-PREMISE-NO.              
           MOVE 'SYSTEM'                 TO MH-USER-ID.                 
           MOVE 'S520'                   TO MH-APPL-PROGRAM-ID.         
           MOVE 1                        TO WS-TRANS-APPL-NO.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 5200-REG-PROFILE                                                        
      ******************************************************************09420000
       5200-REG-PROFILE.                                                
                                                                        
           PERFORM 8000-UPDATE-REG-PROFILE THRU 8000-EXIT.              
                                                                        
           MOVE '5200'                TO ACTIVE-PARAGRAPH.              
           MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO.          
           MOVE WS-TRANS-APPL-NO      TO MI-TRAN-APPL-NO.               
           MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN.       
           MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN.       
           MOVE LR-SENIOR-FL          TO MI-PRV-COLUMN-VALUE-TEXT.      
           MOVE 'Y'                   TO MI-CHG-COLUMN-VALUE-TEXT.      
           MOVE 'SENIOR FLAG    '     TO MI-COLUMN-DESC.                
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD +1                     TO WS-TRANS-APPL-NO.              
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 5500-ASSIGN-ACCT-ATT-VALUES                                             
      ******************************************************************09420000
C34569 5500-ASSIGN-ACCT-ATT-VALUES.                                     
                                                                        
           MOVE 'AGL DISCOUNT SR'    TO YP-ATTRIBUTE-DESC.              
           MOVE 'YES'                TO YP-ATTRIBUTE-VALUE-CD.          
           MOVE ' '                  TO YP-ATTRIBUTE-VALUE-TX-TEXT.     
           MOVE 1                    TO YP-ATTRIBUTE-VALUE-TX-LEN.      
           MOVE 'A'                  TO YP-STATUS-CD                    
                                                                        
P00677     IF LR-REG-GROUP-CD = '100' OR '200'                          
ID0113*CHECK FOR SENIOR RATE WITH NEW PARAGRAPH                                 
ID0113       MOVE UT-RATE-PLAN-NO   TO RD-RATE-PLAN-NO                  
ID0113       MOVE UT-CODE-UTIL-TYPE TO RD-CODE-UTIL-TYPE                
ID0113       PERFORM 7040-SENIOR-RATE-CHECK THRU 7040-EXIT              
ID0113       IF WS-CORRECT-RATE = 'Y'                                   
ID0113          CONTINUE                                                
ID0113       ELSE                                                       
      *CHECK TO SEE IF FIXED OR VARIABLE RATE                                   
                PERFORM 7030-DETERMINE-RATE-TYPE THRU 7030-EXIT         
                IF WS-FIXED-RATE = 'Y'                                  
ACT220*            CREATE WQ BY CALLING CSR04675                                
                   PERFORM 8030-INSERT-WQ THRU 8030-EXIT                
                ELSE                                                    
                   MOVE 'P'               TO YP-STATUS-CD               
                END-IF                                                  
ID0113       END-IF                                                     
           END-IF.                                                      
                                                                        
           PERFORM 8020-INSERT-ACCT-ATTRIBUTE THRU 8020-EXIT.           
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 5600-ASSIGN-FACTOR-VALUES                                               
      ******************************************************************09420000
C34569 5600-ASSIGN-FACTOR-VALUES.                                       
                                                                        
      * FIND THE LOWEST REVENUE MONTH OPEN FOR CURRENT DATE                     
      * AND USE THAT AS THE MM AND YYYY FOR EFF-DATE-FROM                       
           PERFORM 7025-RETRIEVE-MIN-REV-MO THRU 7025-EXIT.             
           MOVE WS-EFF-DATE-FROM      TO FF-EFF-DATE-FROM.              
                                                                        
           MOVE UT-CODE-UTIL-TYPE     TO FF-CODE-UTIL-TYPE.             
           MOVE UT-IC-NO              TO FF-IC-NO.                      
           MOVE '10'                  TO FF-CMPNT-ID-CD.                
           MOVE 'B'                   TO FF-CODE-SEASON.                
           MOVE 'R'                   TO FF-INSTR-USE-TYPE-CD.          
           MOVE 0                     TO FF-CODE-TIME-PERIOD.           
           MOVE '2999-12-31'          TO FF-EFF-DATE-TO.                
           MOVE '00'                  TO FF-FIXED-FCTR-TYP-CD.          
           MOVE  0                    TO FF-FACTOR.                     
           MOVE  0                    TO FF-FAC-CHRG-BASE-AM.           
           MOVE  0                    TO FF-RT-PKG-OPT-SEQ-NO.          
                                                                        
           PERFORM 7015-RETRIEVE-MAX-SEQ-NO THRU 7015-EXIT.             
                                                                        
           MOVE 'AGLSR CUS'              TO FF-FACTOR-ID.               
           PERFORM 8025-INSERT-FIXED-FACTOR THRU 8025-EXIT.             
                                                                        
           MOVE 'AGLSR SOC'              TO FF-FACTOR-ID.               
           PERFORM 8025-INSERT-FIXED-FACTOR THRU 8025-EXIT.             
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 7000-RETRIEVE-PROFILE                                                   
      ******************************************************************09420000
       7000-RETRIEVE-PROFILE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT SENIOR_FL,                                         
                     CUSTOMER_NO,                                       
                     REG_GROUP_CD,                                      
                     DHR_EXPIRATION_DT                                  
                INTO :LR-SENIOR-FL,                                     
                     :LR-CUSTOMER-NO,                                   
                     :LR-REG-GROUP-CD,                                  
                     :LR-DHR-EXPIRATION-DT :WS-NULL-IND                 
                FROM CSS_REG_PROFILE                                    
               WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
C32157             MOVE 'Y' TO REGULATED-SW                             
                   CONTINUE                                             
C32157         WHEN NOT-FOUND                                           
C32157             MOVE 'N' TO REGULATED-SW                             
C32157             CONTINUE                                             
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7000'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_REG_PROFILE' TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE LR-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 7005-RETRIEVE-DEREG-CUST                                                
      ******************************************************************09420000
C32157 7005-RETRIEVE-DEREG-CUST.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO                                        
                INTO :AT-CUSTOMER-NO                                    
                FROM CSS_ACCOUNT                                        
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CUSTOMER-NO TO LR-CUSTOMER-NO                
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7005'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_ACCOUNT'     TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7005-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00172******************************************************************09420000
P00172* 7010-RETRIEVE-DHR-FL                                                    
P00172******************************************************************09420000
P00172 7010-RETRIEVE-DHR-FL.                                            
P00172                                                                  
P00172     EXEC SQL                                                     
P00172        SELECT CU.DHR_FL                                          
P00172          INTO :WS-DHR-EXISTS                                     
P00172          FROM CSS_CUSTOMER CU,                                   
P00172               CSS_ACCOUNT AT                                     
P00172         WHERE AT.CUSTOMER_NO = CU.CUSTOMER_NO                    
P00172           AND AT.ACCOUNT_NO = :AT-ACCOUNT-NO                     
P00172     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00172                                                                  
P00172     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00172                                                                  
P00172     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00172         WHEN SUCCESSFUL-CALL                                     
P00172             MOVE '2999-12-31' TO LR-DHR-EXPIRATION-DT            
P00172         WHEN OTHER                                               
P00172             MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
P00172             MOVE '7010'            TO ACTIVE-PARAGRAPH           
P00172             MOVE 'SELECT'          TO ABEND-FUNCTION             
P00172             MOVE 'CSS_CUSTOMER'    TO TABLE-1                    
P00172             MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
P00172             MOVE AT-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
P00172             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
P00172             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
P00172     END-EVALUATE.                                                
P00172                                                                  
P00172 7010-EXIT.                                                       
P00172     EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 7015-RETRIEVE-MAX-SEQ-NO.                                               
      ******************************************************************09420000
       7015-RETRIEVE-MAX-SEQ-NO.                                        
                                                                        
           EXEC SQL                                                     
               SELECT MAX(FIXED_FCTR_SEQ_NO)                            
                 INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-01              
                 FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                   
                WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO            
                  AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE        
                  AND FF.IC_NO              = :FF-IC-NO                 
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(FIXED_FCTR_SEQ_NO)                                    
MFA-TR*          INTO :FF-FIXED-FCTR-SEQ-NO:WS-NULL-IND-01                      
MFA-TR*          FROM CSS_FIXED_FCTR FF                                         
MFA-TR*         WHERE FF.ACCOUNT_NO         = :FF-ACCOUNT-NO                    
MFA-TR*           AND FF.CODE_UTIL_TYPE     = :FF-CODE-UTIL-TYPE                
MFA-TR*           AND FF.IC_NO              = :FF-IC-NO                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
               WHEN NOT-FOUND                                           
                   IF WS-NULL-IND-01 < 0                                
                      MOVE 0 TO FF-FIXED-FCTR-SEQ-NO                    
                   END-IF                                               
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME      TO ABEND-PROGRAM              
                   MOVE '7015'            TO ACTIVE-PARAGRAPH           
                   MOVE 'SELECT'          TO ABEND-FUNCTION             
                   MOVE 'CSS_FIXED_FCTR'  TO TABLE-1                    
                   MOVE 'ACCOUNT_NO'      TO TABLE-ELEMENT-1            
                   MOVE FF-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1          
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7015-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 7020-RETRIEVE-UTL-ENV                                                   
      ******************************************************************09420000
       7020-RETRIEVE-UTL-ENV.                                           
                                                                        
           EXEC SQL                                                     
               SELECT UT.IC_NO ,                                        
                      UT.CODE_UTIL_TYPE,                                
ID0113                UT.RATE_PLAN_NO                                   
                 INTO :UT-IC-NO,                                        
                      :UT-CODE-UTIL-TYPE,                               
ID0113                :UT-RATE-PLAN-NO                                  
                 FROM CSS_UTIL_ENVRNMT UT                               
                WHERE UT.ACCOUNT_NO = :UT-ACCOUNT-NO                    
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7020'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_UTL_ENVRNMT'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE UT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 7025-RETRIEVE-MIN-REV-MO                                                
      ******************************************************************09420000
       7025-RETRIEVE-MIN-REV-MO.                                        
                                                                        
           MOVE WS-CURRENT-DATE TO BN-DATE-EXTRACT                      
                                                                        
           EXEC SQL                                                     
               SELECT MIN(REVENUE_MONTH)                                
                 INTO :BN-REVENUE-MONTH                                 
                 FROM CSS_BILL_WINDOW BN                                
                WHERE BN.DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :BN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :BN-DATE-EXTRACT
              ) <> 0) OR (LEN(:BN-DATE-EXTRACT) <> 10), CIS.CHAR2DATE(
                                                       :BN-DATE-EXTRACT
              ), CONVERT(DATE, :BN-DATE-EXTRACT) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MIN(REVENUE_MONTH)                                        
MFA-TR*          INTO :BN-REVENUE-MONTH                                         
MFA-TR*          FROM CSS_BILL_WINDOW BN                                        
MFA-TR*         WHERE BN.DATE_EXTRACT = :BN-DATE-EXTRACT                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE BN-REVENUE-MONTH     TO WS-REVENUE-MONTH-RED         
              MOVE WS-REVENUE-MONTH-RED TO WS-REVENUE-MONTH             
              MOVE WS-REVENUE-YYYY      TO WS-EFF-DATE-FROM-YYYY        
              MOVE WS-REVENUE-MM        TO WS-EFF-DATE-FROM-MM          
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7025'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
              MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-1              
              MOVE WS-CURRENT-DATE      TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
C34569******************************************************************09420000
C34569* 7030-DETERMINE-RATE-TYPE.                                               
C34569******************************************************************09420000
C34569 7030-DETERMINE-RATE-TYPE.                                        
                                                                        
C34569     EXEC SQL                                                     
C34569        SELECT TOP(1) 'Y'                                                
C34569          INTO :WS-FIXED-RATE                                     
C34569          FROM CSS_SPCL_FCTR      SF,                             
C34569               CRM_OPT_ATTR_INCTV HQ,                             
C34569               CSS_ACCT_RTPK_AGR  DF                              
C34569         WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO             
C34569           AND DF.IC_NO              = 1                          
C34569           AND DF.CODE_UTIL_TYPE     = 'G'                        
C34569           AND HQ.COMPANY_NO         = '01'                       
C34569           AND HQ.OPTION_CD          = DF.OPTION_CD               
P00141           AND HQ.ATTR_INCTV_STRT_DT <= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00141           AND HQ.ATTR_INCTV_END_DT  >= CAST(SYSDATETIMEOFFSET() 
           AS DATE)              
P00473           AND HQ.OPT_ATTR_VSTART_TS <= CIS.CURRENT$TIMESTAMP()         
P00473           AND HQ.OPT_ATTR_VEND_TS   >= CIS.CURRENT$TIMESTAMP()         
P00473           AND HQ.PROC_STATUS_CD     = 'AC'                       
C34569           AND SF.FACTOR_ID          = HQ.FACTOR_ID               
C34569           AND SF.OVR_RT_CALC_TYP_CD = '02'                       
C34569                                           
C34569        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-FIXED-RATE                                             
MFA-TR*         FROM CSS_SPCL_FCTR      SF,                                     
MFA-TR*              CRM_OPT_ATTR_INCTV HQ,                                     
MFA-TR*              CSS_ACCT_RTPK_AGR  DF                                      
MFA-TR*        WHERE DF.ACCOUNT_NO         = :DF-ACCOUNT-NO                     
MFA-TR*          AND DF.IC_NO              = 1                                  
MFA-TR*          AND DF.CODE_UTIL_TYPE     = 'G'                                
MFA-TR*          AND HQ.COMPANY_NO         = '01'                               
MFA-TR*          AND HQ.OPTION_CD          = DF.OPTION_CD                       
MFA-TR*          AND HQ.ATTR_INCTV_STRT_DT <= CURRENT DATE                      
MFA-TR*          AND HQ.ATTR_INCTV_END_DT  >= CURRENT DATE                      
MFA-TR*          AND HQ.OPT_ATTR_VSTART_TS <= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.OPT_ATTR_VEND_TS   >= CURRENT TIMESTAMP                 
MFA-TR*          AND HQ.PROC_STATUS_CD     = 'AC'                               
MFA-TR*          AND SF.FACTOR_ID          = HQ.FACTOR_ID                       
MFA-TR*          AND SF.OVR_RT_CALC_TYP_CD = '02'                               
MFA-TR*           FETCH FIRST 1 ROWS ONLY                                       
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C34569     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C34569     EVALUATE WS-ACTIVE-RETURN-CODE                               
C34569         WHEN SUCCESSFUL-CALL                                     
C34569            CONTINUE                                              
C34569         WHEN NOT-FOUND                                           
C34569            MOVE 'N' TO WS-FIXED-RATE                             
C34569         WHEN OTHER                                               
C34569            MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
C34569            MOVE '7030'              TO ACTIVE-PARAGRAPH          
C34569            MOVE 'SELECT'            TO ABEND-FUNCTION            
C34569            MOVE 'CSS_ACCT_RTPK_AGR' TO TABLE-1                   
C34569            MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1           
C34569            MOVE DF-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1         
C34569            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
C34569            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
C34569     END-EVALUATE.                                                
                                                                        
C34569 7030-EXIT.                                                       
C34569     EXIT.                                                        
                                                                        
ID0113******************************************************************09420000
ID0113* 7040-SENIOR-RATE-CHECK.                                                 
ID0113******************************************************************09420000
ID0113 7040-SENIOR-RATE-CHECK.                                          
ID0113                                                                  
ID0113     EXEC SQL                                                     
ID0113        SELECT TOP(1) 'Y'                                                
ID0113          INTO :WS-CORRECT-RATE                                   
ID0113          FROM CSS_RATE_PLAN_DESC RD                              
ID0113         WHERE RD.RATE_PLAN_NO = :RD-RATE-PLAN-NO                 
ID0113           AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE             
ID0113           AND RD.SENIOR_RATE_FL = 'Y'                            
ID0113                                              
ID0113        END-EXEC.                                                 

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-CORRECT-RATE                                           
MFA-TR*         FROM CSS_RATE_PLAN_DESC RD                                      
MFA-TR*        WHERE RD.RATE_PLAN_NO = :RD-RATE-PLAN-NO                         
MFA-TR*          AND RD.CODE_UTIL_TYPE = :RD-CODE-UTIL-TYPE                     
MFA-TR*          AND RD.SENIOR_RATE_FL = 'Y'                                    
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*       END-EXEC.                                                         

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ID0113                                                                  
ID0113     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
ID0113                                                                  
ID0113     EVALUATE WS-ACTIVE-RETURN-CODE                               
ID0113         WHEN SUCCESSFUL-CALL                                     
ID0113            CONTINUE                                              
ID0113         WHEN NOT-FOUND                                           
ID0113            MOVE 'N' TO WS-CORRECT-RATE                           
ID0113         WHEN OTHER                                               
ID0113            MOVE PROGRAM-NAME        TO ABEND-PROGRAM             
ID0113            MOVE '7040'              TO ACTIVE-PARAGRAPH          
ID0113            MOVE 'SELECT'            TO ABEND-FUNCTION            
ID0113            MOVE 'CSS_RATE_PLAN_DESC' TO TABLE-1                  
ID0113            MOVE 'RATE_PLAN_NO'      TO TABLE-ELEMENT-1           
ID0113            MOVE RD-RATE-PLAN-NO     TO HOSTVAR-ELEMENT-1         
ID0113            MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2           
ID0113            MOVE RD-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2         
ID0113            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
ID0113            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
ID0113     END-EVALUATE.                                                
ID0113                                                                  
ID0113 7040-EXIT.                                                       
ID0113     EXIT.                                                        
                                                                        
      ******************************************************************09420000
      * 8000-UPDATE-REG-PROFILE                                                 
      ******************************************************************09420000
       8000-UPDATE-REG-PROFILE.                                         
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_REG_PROFILE                                    
                 SET SENIOR_FL      = 'Y',                              
                     LAST_UPDATE_TS = CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS
              ),                   
P00172               DHR_EXPIRATION_DT = IIF(TRY_CONVERT(DATE, 
                                                  :LR-DHR-EXPIRATION-DT
              ) IS NULL OR (PATINDEX('%.%', :LR-DHR-EXPIRATION-DT
              ) <> 0) OR (LEN(:LR-DHR-EXPIRATION-DT
              ) <> 10), CIS.CHAR2DATE(:LR-DHR-EXPIRATION-DT
              ), CONVERT(DATE, :LR-DHR-EXPIRATION-DT) )          
               WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_REG_PROFILE                                            
MFA-TR*          SET SENIOR_FL      = 'Y',                                      
MFA-TR*              LAST_UPDATE_TS = :WS-CURRENT-TS,                           
MFA-TR*              DHR_EXPIRATION_DT = :LR-DHR-EXPIRATION-DT                  
MFA-TR*        WHERE ACCOUNT_NO = :LR-ACCOUNT-NO                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_REG_PROFILE'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'SENIOR_FL'          TO TABLE-ELEMENT-2              
              MOVE LR-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'Y'                  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 8020-INSERT-ACCT-ATTRIBUTE.                                             
      *****************************************************************         
C34569 8020-INSERT-ACCT-ATTRIBUTE.                                      
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_ACCT_ATTRIBUTE                            
                     (ACCOUNT_NO        ,                               
                      ATTRIBUTE_DESC    ,                               
                      ATTRIBUTE_VALUE_CD,                               
                      ATTRIBUTE_VALUE_DT,                               
                      ATTRIBUTE_VALUE_TX,                               
                      CREATED_TS        ,                               
                      STATUS_CD )                                       
              VALUES                                                    
                     (:YP-ACCOUNT-NO        ,                           
                      :YP-ATTRIBUTE-DESC    ,                           
                      :YP-ATTRIBUTE-VALUE-CD,                           
                      CAST(SYSDATETIMEOFFSET() AS DATE)          ,              
                      :YP-ATTRIBUTE-VALUE-TX,                           
                      CIS.CURRENT$TIMESTAMP()     ,                           
                      :YP-STATUS-CD)                                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_ACCT_ATTRIBUTE                            01720001
MFA-TR*              (ACCOUNT_NO        ,                                       
MFA-TR*               ATTRIBUTE_DESC    ,                                       
MFA-TR*               ATTRIBUTE_VALUE_CD,                                       
MFA-TR*               ATTRIBUTE_VALUE_DT,                                       
MFA-TR*               ATTRIBUTE_VALUE_TX,                                       
MFA-TR*               CREATED_TS        ,                                       
MFA-TR*               STATUS_CD )                                               
MFA-TR*       VALUES                                                            
MFA-TR*              (:YP-ACCOUNT-NO        ,                                   
MFA-TR*               :YP-ATTRIBUTE-DESC    ,                                   
MFA-TR*               :YP-ATTRIBUTE-VALUE-CD,                                   
MFA-TR*               CURRENT DATE          ,                                   
MFA-TR*               :YP-ATTRIBUTE-VALUE-TX,                                   
MFA-TR*               CURRENT TIMESTAMP     ,                                   
MFA-TR*               :YP-STATUS-CD)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8020'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8020-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
C34569*****************************************************************         
C34569* 8025-INSERT-FIXED-FACTOR                                                
C34569*****************************************************************         
C34569 8025-INSERT-FIXED-FACTOR.                                        
                                                                        
C34569*CHECK FIRST TO MAKE SURE FACTOR DOES NOT ALREADY EXIST                   
C34569     EXEC SQL                                                     
C34569         SELECT COUNT(*)                                          
C34569           INTO :WS-EXISTING-FACTOR                               
C34569           FROM CSS_FIXED_FCTR                                    
C34569          WHERE ACCOUNT_NO = :FF-ACCOUNT-NO                       
C34569            AND CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE               
C34569            AND FACTOR_ID = :FF-FACTOR-ID                         
C34569     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C34569     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
C34569        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C34569        MOVE '8025'                TO ACTIVE-PARAGRAPH            
C34569        MOVE 'SELECT'              TO ABEND-FUNCTION              
C34569        MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                     
C34569        MOVE 'FF-ACCOUNT_NO'       TO TABLE-ELEMENT-1             
C34569        MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C34569        MOVE 'FF-FACTOR-ID'        TO TABLE-ELEMENT-2             
C34569        MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2           
C34569        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C34569        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C34569     END-IF.                                                      
                                                                        
C34569     IF WS-EXISTING-FACTOR = 0                                    
C34569        ADD 1 TO FF-FIXED-FCTR-SEQ-NO                             
C34569        EXEC SQL                                                  
C34569            INSERT INTO CSS_FIXED_FCTR                            
C34569                   (ACCOUNT_NO        ,                           
C34569                    CODE_UTIL_TYPE    ,                           
C34569                    IC_NO             ,                           
C34569                    FIXED_FCTR_SEQ_NO ,                           
C34569                    FACTOR_ID         ,                           
C34569                    EFF_DATE_FROM     ,                           
C34569                    CMPNT_ID_CD       ,                           
C34569                    CODE_SEASON       ,                           
C34569                    INSTR_USE_TYPE_CD ,                           
C34569                    CODE_TIME_PERIOD  ,                           
C34569                    EFF_DATE_TO       ,                           
C34569                    FIXED_FCTR_TYP_CD ,                           
C34569                    FACTOR            ,                           
C34569                    FAC_CHRG_BASE_AM  ,                           
C34569                    LAST_UPDATE_TS    ,                           
C34569                    DURATION_REMAIN_NO,                           
C34569                    RT_PKG_OPT_SEQ_NO)                            
C34569             VALUES                                               
C34569                    (:FF-ACCOUNT-NO       ,                       
C34569                     :FF-CODE-UTIL-TYPE   ,                       
C34569                     :FF-IC-NO            ,                       
C34569                     :FF-FIXED-FCTR-SEQ-NO,                       
C34569                     :FF-FACTOR-ID        ,                       
C34569                     IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )    ,                       
C34569                     :FF-CMPNT-ID-CD      ,                       
C34569                     :FF-CODE-SEASON      ,                       
C34569                     :FF-INSTR-USE-TYPE-CD,                       
C34569                     :FF-CODE-TIME-PERIOD ,                       
C34569                     IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )      ,                       
C34569                     :FF-FIXED-FCTR-TYP-CD,                       
C34569                     :FF-FACTOR           ,                       
C34569                     :FF-FAC-CHRG-BASE-AM ,                       
C34569                     CIS.CURRENT$TIMESTAMP()    ,                       
C34569                     NULL                 ,                       
C34569                     :FF-RT-PKG-OPT-SEQ-NO)                       
C34569        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*       EXEC SQL                                                          
MFA-TR*           INSERT INTO CSS_FIXED_FCTR                            01720001
MFA-TR*                  (ACCOUNT_NO        ,                                   
MFA-TR*                   CODE_UTIL_TYPE    ,                                   
MFA-TR*                   IC_NO             ,                                   
MFA-TR*                   FIXED_FCTR_SEQ_NO ,                                   
MFA-TR*                   FACTOR_ID         ,                                   
MFA-TR*                   EFF_DATE_FROM     ,                                   
MFA-TR*                   CMPNT_ID_CD       ,                                   
MFA-TR*                   CODE_SEASON       ,                                   
MFA-TR*                   INSTR_USE_TYPE_CD ,                                   
MFA-TR*                   CODE_TIME_PERIOD  ,                                   
MFA-TR*                   EFF_DATE_TO       ,                                   
MFA-TR*                   FIXED_FCTR_TYP_CD ,                                   
MFA-TR*                   FACTOR            ,                                   
MFA-TR*                   FAC_CHRG_BASE_AM  ,                                   
MFA-TR*                   LAST_UPDATE_TS    ,                                   
MFA-TR*                   DURATION_REMAIN_NO,                                   
MFA-TR*                   RT_PKG_OPT_SEQ_NO)                                    
MFA-TR*            VALUES                                                       
MFA-TR*                   (:FF-ACCOUNT-NO       ,                               
MFA-TR*                    :FF-CODE-UTIL-TYPE   ,                               
MFA-TR*                    :FF-IC-NO            ,                               
MFA-TR*                    :FF-FIXED-FCTR-SEQ-NO,                               
MFA-TR*                    :FF-FACTOR-ID        ,                               
MFA-TR*                    :FF-EFF-DATE-FROM    ,                               
MFA-TR*                    :FF-CMPNT-ID-CD      ,                               
MFA-TR*                    :FF-CODE-SEASON      ,                               
MFA-TR*                    :FF-INSTR-USE-TYPE-CD,                               
MFA-TR*                    :FF-CODE-TIME-PERIOD ,                               
MFA-TR*                    :FF-EFF-DATE-TO      ,                               
MFA-TR*                    :FF-FIXED-FCTR-TYP-CD,                               
MFA-TR*                    :FF-FACTOR           ,                               
MFA-TR*                    :FF-FAC-CHRG-BASE-AM ,                               
MFA-TR*                    CURRENT TIMESTAMP    ,                               
MFA-TR*                    NULL                 ,                               
MFA-TR*                    :FF-RT-PKG-OPT-SEQ-NO)                               
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C34569        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                     
                                                                        
C34569        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C34569           CONTINUE                                               
C34569        ELSE                                                      
C34569           MOVE PROGRAM-NAME          TO ABEND-PROGRAM            
C34569           MOVE '8025'                TO ACTIVE-PARAGRAPH         
C34569           MOVE 'INSERT'              TO ABEND-FUNCTION           
C34569           MOVE 'CSS_FIXED_FCTR'      TO TABLE-1                  
C34569           MOVE 'FF-ACCOUNT_NO'       TO TABLE-ELEMENT-1          
C34569           MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1        
C34569           MOVE 'FF-FACTOR-ID'        TO TABLE-ELEMENT-2          
C34569           MOVE FF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-2        
C34569           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
C34569           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
C34569        END-IF                                                    
C34569     END-IF.                                                      
                                                                        
C34569 8025-EXIT.                                                       
C34569     EXIT.                                                        
                                                                        
C34569*****************************************************************         
C34569* 8030-INSERT-WQ.                                                         
C34569*****************************************************************         
C34569 8030-INSERT-WQ.                                                  
                                                                        
ACT220     INITIALIZE   WS-CSR04675-OUTPUT.                             
ACT220     MOVE 0              TO WS-WQ-ITEM-ID.                        
ACT220     MOVE '4'            TO WS-WQ-ROUTE-CATEGORY.                 
ACT220     MOVE SPACES         TO WS-WQ-LOCAL-OFFICE.                   
ACT220     MOVE 'SYSTEM'       TO WS-WQ-USER-ID-ORIG.                   
ACT220     MOVE SPACES         TO WS-WQ-USER-ID-ASGN.                   
ACT220     MOVE '003'          TO WS-WQ-RESP-AREA-ID.                   
ACT220     MOVE +185           TO WS-WQ-CATEGORY-ID.                    
ACT220     MOVE WS-ACCOUNT-NO  TO WS-WQ-ACCOUNT-NO.                     
ACT220     MOVE 0              TO WS-WQ-PREMISE-NO.                     
ACT220     MOVE LR-CUSTOMER-NO TO WS-WQ-CUSTOMER-NO.                    
ACT220     MOVE 0              TO WS-WQ-SERV-ORDER-NO.                  
ACT220     IF LR-REG-GROUP-CD = '100'                                   
ACT220      MOVE WS-MESSAGE    TO  WS-WQ-COMMENTS-TEXT                  
ACT220     ELSE                                                         
ACT220      MOVE WS-MESSAGE-2  TO  WS-WQ-COMMENTS-TEXT                  
ACT220     END-IF.                                                      
ACT220     MOVE 88             TO WS-WQ-COMMENTS-LEN.                   
ACT220     MOVE SPACES         TO WS-WQ-DATE-REQUIRED.                  
ACT220     MOVE SPACES         TO WS-WQ-DATE-CREATED.                   
ACT220     MOVE 'N'            TO WS-WQ-PRIORITY.                       
ACT220     MOVE SPACES         TO WS-WQ-FREEFORM-TEXT.                  
ACT220     MOVE 0              TO WS-WQ-FREEFORM-LEN.                   
ACT220     MOVE 'CSR02520'     TO WS-WQ-CREATED-BY.                     
                                                                        
C34569     EXEC SQL                                                     
ACT220        CALL CSR04675 (:WS-WQ-ITEM-ID,                            
ACT220                       :WS-WQ-ROUTE-CATEGORY,                     
ACT220                       :WS-WQ-LOCAL-OFFICE,                       
ACT220                       :WS-WQ-USER-ID-ORIG,                       
ACT220                       :WS-WQ-USER-ID-ASGN,                       
ACT220                       :WS-WQ-RESP-AREA-ID,                       
ACT220                       :WS-WQ-CATEGORY-ID,                        
ACT220                       :WS-WQ-ACCOUNT-NO,                         
ACT220                       :WS-WQ-PREMISE-NO,                         
ACT220                       :WS-WQ-CUSTOMER-NO,                        
ACT220                       :WS-WQ-SERV-ORDER-NO,                      
ACT220                       :WS-WQ-COMMENTS,                           
ACT220                       :WS-WQ-DATE-REQUIRED,                      
ACT220                       :WS-WQ-DATE-CREATED,                       
ACT220                       :WS-WQ-PRIORITY,                           
ACT220                       :WS-WQ-FREE-FORM-AREA,                     
ACT220                       :WS-WQ-CREATED-BY)                         
C34569     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C34569     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE          
C34569     IF WS-ACTIVE-RETURN-CODE NOT EQUAL +466                      
C34569        MOVE 200                       TO WS-ACTIVE-RETURN-CODE   
C34569        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
C34569        MOVE '8030'                    TO ACTIVE-PARAGRAPH        
C34569        MOVE 'DB2 SP CALL'             TO ABEND-FUNCTION          
ACT220        MOVE 'CSR04675'                TO TABLE-1                 
C34569        MOVE 'WS-ACTIVE-RETURN-CODE'   TO TABLE-ELEMENT-1         
C34569        MOVE WS-ACTIVE-RETURN-CODE     TO HOSTVAR-ELEMENT-1       
C34569        MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-2         
C34569        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C34569        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C34569     END-IF.                                                      
                                                                        
C34569 8030-EXIT.                                                       
C34569     EXIT.                                                        
                                                                        
CVT000*****************************************************************         
CVT000* 8100-SEND-RESULT.                                                       
CVT000*****************************************************************         
CVT000 8100-SEND-RESULT.                                                
                                                                        
CVT000     ADD 1 TO CTR-ROWS.                                           
                                                                        
CVT000 8100-EXIT.                                                       
CVT000     EXIT.                                                        
                                                                        
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
