       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02518.                                         
       DATE-WRITTEN. AUG 06, 2002.                                      
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S518 CONVERTED TO DB2 SP CSR02518 ON 03/14/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S518                                           *        
      *  PROGRAM:       S518                                           *        
      *  CALLING SP:    PN_S518                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES COMMUNICATION DATA.                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   -----------------                        *        
      *  08/06/02    LHO      CREATED.                                 *        
      *  12/11/02    MJG      FIX TO BRING BACK THE LAST COMMUNICATION *        
      *                       FOR CERTAIN CRITERIA WHEN A Z IS SENT AS *        
      *                       THE PARM CODE                                     
PERF  *  12/18/02    MJG      FIX TO ENSURE THERE ARE NO LOOKUPS DOWN  *        
PERF  *                       WITH 0S FOR ACCT, CUST, PREM             *        
T28151*  01/13/03    MJG      FIX TO SHOW RED FLAGS THAT ARE ASSOC W/  *        
T28151*                       THE PREM DURING THE INITIAL LOOKUP.      *        
T28151*  04/05/03    MJG      DISPLAY ALL ACTIVE RED FLAGS INITIALLY   *        
T28151*                       ALONG WITH THE 1ST 30 COMMUNICATIONS.    *        
T29026*  05/20/03    MJG      CHANGE RETURN SO YOU KNOW 100% IF MORE   *        
T29026*                       ROWS EXIST FOR SEARCH CRITERIA.          *        
T30461*  03/01/04    DD       CHANGE PARM-FR-DATE TO 1/1/1998 WHEN IT  *        
T30461*                       COMES IN AS 01/01/1998.  ALSO ADDED A    *        
T30461*                       CHECK FOR RED FLAG YEAR                  *        
T30408*  03/15/04    DD       CHANGE YEAR IN PARM-FR-DATE TO 1991      *        
T30906*  05/18/04    DD       RESETTING ROW COUNT FOR PREMISE RED FLAG *        
T30906*                       SEARCH                                   *        
T30940*  02/28/05    MSR      INCREASE THE SIZE OF THE ADDRESS FIELD.  *        
T34097*  01/17/07    MC95456  REPLACED CSS_MODEL_SQL WITH SET COMMAND  *        
T35927*  08/02/07    AW41078  DISPLAY 'PREMISE HAS BEEN DELETED' IF    *        
T35927*                       ROW NOT FOUND IN PARA 2930               *        
T35615*  09/25/07    SC41135  RETRIEVE RED-FLAGS CORRECTLY             *        
T36933*  07/28/08    SV85244  INCREASE LENGTH OF ADDRESS               *        
A37342*  03/20/09    SJ97149  IMPROVE PERFORMANCE - ADDING ROWSET      *        
A37342*                       POSITIONING FOR GLOBAL TEMP TABLES &     *        
A37342*                       WITH UR CHANGES TO CURSORS*              *        
A02884*  10/28/10    MSR      DO NOT RETRIEVE ROWS WITH RED FLAG IND   *        
A02884*                       AS SPACES AFTER THE ROW COUNT LIMIT.     *        
ACT072*  03/23/15    BD09555  ALLOW A ROW COUNT OF MORE THAN 9999      *        
ACT072*  A05136-ACT072                                                 *        
      ******************************************************************        
      *                                                                *        
      *                -- BASIC SEQUENCE STRUCTURE --                  *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02518'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S018 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *----< CSS_COMMUNICATION TABLE                                            
           EXEC SQL                                                             
              INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_COMM_COMMENT  TABLE                                            
           EXEC SQL                                                             
              INCLUDE TBCOMCMT                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_USER_PROFILE  TABLE                                            
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *----< CSS_PREMISE       TABLE                                            
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
      *----< CSS_ACCOUNT       TABLE                                            
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      *---< CSS_APPL_PGM_DESC >                                                 
      *    EXEC SQL                                                             
      *       INCLUDE TBPGMDSC                                                  
      *    END-EXEC.                                                            
                                                                        
      *---< CSS_ADDR_FORMATTED >                                                
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *----< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >                  
      *----< SYBASE OPEN SERVER FOR CICS FACILITIES.             >              
CVT999*    COPY SYGWCOB.                                                        
      *----< ADDED TO SUPPORT CICS RPCS >                                       
CVT999*    COPY SYDBCOB.                                                        
      *----<COMMON SYSTEM AREA >                                                
           COPY CCA00001.                                                       
      *----< ERROR HANDLING >                                                   
CVT999*    COPY CWS00010.                                                       
      *----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
           COPY CWS00027.                                                       
      *----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
       COPY CWS00011.                                                           
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'S518    '.      
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-CODE               PIC X     VALUE SPACES.          
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-CUSTOMER-NO        PIC X(10) VALUE SPACES.          
           05  PARM-PREMISE-NO         PIC X(10) VALUE SPACES.          
           05  PARM-COMM-ID            PIC X(26) VALUE SPACES.          
           05  PARM-FR-DATE            PIC X(10) VALUE SPACES.          
           05  PARM-TO-DATE            PIC X(10) VALUE SPACES.          
           05  PARM-COMM-TYPE-CD       PIC X(2)  VALUE SPACES.          
           05  PARM-COMM-SUBTYPE-CD    PIC X(2)  VALUE SPACES.          
           05  PARM-COMM-DIRECTION     PIC X     VALUE SPACES.          
           05  PARM-USER-ID            PIC X(7)  VALUE SPACES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05  WS-COMMENT-TX-NULL-IND  PIC S9(4) COMP.                  
           05  WS-COMMENT-NULL-IND     PIC S9(4) COMP.                  
           05  WS-RED-FLG-NULL-IND     PIC S9(4) COMP.                  
           05  WS-CALL-NULL-IND        PIC S9(4) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
CVT999*    05  CTR-ROWS                PIC S9(9) COMP VALUE 0.                  
           05  WS-MAX-RETURN-ROWS      PIC S9(3) COMP VALUE +30.        
           05  WS-ROW-CT               PIC S9(3) COMP VALUE 0.          
CVT000     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-LAST-NAME            PIC X(15) VALUE SPACES.          
           05  WS-FIRST-NAME           PIC X(12) VALUE SPACES.          
           05  WS-RESP-AREA            PIC X(3)  VALUE SPACES.          
ACT072     05  WS-TOTAL-COMMENTS       PIC S9(8) COMP   VALUE 0.        
ACT072     05  WS-TOT-COMMUNICATIONS   PIC S9(8) COMP   VALUE 0.        
           05  WS-PARM-CODE            PIC X     VALUE SPACES.          
           05  WS-ACCOUNT-NO-X         PIC X(13).                       
           05  WS-ACCOUNT-NO           REDEFINES WS-ACCOUNT-NO-X        
                                       PIC 9(13).                       
           05  WS-CUSTOMER-NO-X        PIC X(10).                       
           05  WS-CUSTOMER-NO          REDEFINES WS-CUSTOMER-NO-X       
                                       PIC 9(10).                       
           05  WS-PREMISE-NO-X         PIC X(10).                       
           05  WS-PREMISE-NO           REDEFINES WS-PREMISE-NO-X        
                                       PIC 9(10).                       
           05  WS-COMM-ID              PIC X(26).                       
           05  WS-PARM-TO-TS.                                           
               10  WS-PARM-TO-DATE     PIC X(10).                       
               10  FILLER              PIC X(16) VALUE                  
                                       '-23.59.59.000001'.              
           05  WS-TO-DATE              PIC X(26) VALUE SPACE.           
           05  WS-PARM-FR-TS.                                           
               10  WS-PARM-FR-DATE     PIC X(10).                       
               10  FILLER              PIC X(16) VALUE                  
                                       '-00.00.00.000001'.              
           05  WS-FR-DATE              PIC X(26) VALUE SPACE.           
           05  WS-HOLD-DATE            PIC X(10).                       
           05  WS-DB2-DATE             PIC X(10).                       
           05  WS-COMM-TYPE-CD         PIC X(2).                        
           05  WS-COMM-SUBTYPE-CD      PIC X(2).                        
           05  WS-COMM-DIRECTION       PIC X.                           
           05  WS-USER-ID              PIC X(7).                        
           05  WS-RED-FLAG-PREM        PIC X(1) VALUE SPACE.            
T28151     05  WS-TODAYS-DATE          PIC X(10).                       
T28151     05  WS-RED-FLAG-TS.                                          
T28151         10 WS-DATE              PIC X(10) VALUE SPACE.           
T28151         10 WS-FILLER            PIC X(16) VALUE                  
                                       '-00.00.00.000001'.              
           05  WS-HOLD-TIMESTAMP.                                       
T28151         10 WS-HOLD-RED-FL.                                       
                  15 WS-RED-FL-YR      PIC 9(04).                       
                  15 FILLER            PIC X(01).                       
                  15 WS-RED-FL-MO      PIC 9(02).                       
                  15 WS-FILLER         PIC X(01).                       
                  15 WS-RED-FL-DY      PIC 9(02).                       
T28151         10 WS-FILLER            PIC X(16).                       
                                                                        
           05  WS-TODAYS-TIMESTAMP     PIC X(26).                       
           05  WS-TODAYS-DATE-RED      PIC X(10).                       
           05  WS-DATE-REDEFINED       REDEFINES WS-TODAYS-DATE-RED.    
               10 WS-YEAR              PIC 9(04).                       
               10 FILLER               PIC X(01).                       
               10 WS-MONTH             PIC 9(02).                       
               10 FILLER               PIC X(01).                       
               10 WS-DAY               PIC 9(02).                       
           05  WS-SKIP-ROW             PIC X(01).                       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(9)   COMP VALUE 0.      
CVT000     05   S-RETURN-CODE            PIC S9(9)   COMP VALUE 0.      
           05  RS-COMM-ID                PIC X(26)   VALUE SPACE.       
           05  RS-ACCOUNT-NO             PIC X(13)   VALUE SPACE.       
           05  RS-CUSTOMER-NO            PIC X(10)   VALUE SPACE.       
           05  RS-PREMISE-NO             PIC X(10)   VALUE SPACE.       
           05  RS-COMPANY-NO             PIC X(2)    VALUE SPACE.       
           05  RS-RED-FLAG-IND           PIC X(1)    VALUE SPACE.       
           05  RS-RED-FLAG-EXPIRE-DT     PIC X(26)   VALUE SPACE.       
           05  RS-COMM-METHOD            PIC X(1)    VALUE SPACE.       
           05  RS-COMM-DIRECTION         PIC X(1)    VALUE SPACE.       
           05  RS-COMM-TYPE-CD           PIC X(2)    VALUE SPACE.       
           05  RS-COMM-SUBTYPE-CODE      PIC X(2)    VALUE SPACE.       
           05  RS-USER-ID-ORIG           PIC X(7)    VALUE SPACE.       
           05  RS-CONTACT-NAME           PIC X(25)   VALUE SPACE.       
           05  RS-PROMOTION-ID           PIC X(12)   VALUE SPACE.       
           05  RS-PSC-COMPLIANCE-IND     PIC X(1)    VALUE SPACE.       
           05  RS-CALL-ORIGIN-ID         PIC S9(4)V  USAGE COMP-3       
                                         VALUE ZEROES.                  
           05  RS-CALL-END-TIME          PIC X(26)   VALUE SPACE.       
           05  RS-NUMBER-TRANSFERS       PIC S9(9) USAGE COMP VALUE 0.  
           05  RS-HOLD-TIME              PIC S9(5)V9(2) USAGE COMP-3    
                                         VALUE ZEROES.                  
           05  RS-QUEUE-TIME             PIC S9(5)V9(2) USAGE COMP-3    
                                         VALUE ZEROES.                  
           05  RS-SCREEN-POP-IND         PIC X(01)   VALUE SPACE.       
           05  RS-TOTAL-CALL-TIME        PIC S9(5)V9(2) USAGE COMP-3    
                                         VALUE ZEROES.                  
           05  RS-INITIAL-COMMENT-TE     PIC X(255)  VALUE SPACE.       
C30940*    05  RS-ADDRESS                PIC X(42)   VALUE SPACE.               
T36933     05  RS-ADDRESS                PIC X(76)   VALUE SPACE.       
           05  RS-RESP-AREA              PIC X(3)    VALUE SPACE.       
           05  RS-CURRENT-COMMENTS       PIC X(255)  VALUE SPACE.       
           05  RS-TOTAL-COMMENTS PIC S9(4)V USAGE COMP-3 VALUE 0.       
           05  RS-LAST-NAME              PIC X(15)   VALUE SPACES.      
           05  RS-FIRST-NAME             PIC X(12)   VALUE SPACES.      
           05  RS-RESPONSE-REASON-CD     PIC X(4)    VALUE SPACES.      
           05  RS-RESPONSE-TYPE-CD       PIC X(4)    VALUE SPACES.      
           05  RS-SOLICITATION-CD        PIC X(3)    VALUE SPACES.      
           05  RS-COMM-ASSOC-CD          PIC X(1)    VALUE SPACES.      
           05  RS-USER-ID                PIC X(7)    VALUE SPACES.      
           05  RS-UPDATE-TS              PIC X(26)   VALUE SPACES.      
           05  RS-COMPLAINT-FL           PIC X(1)    VALUE SPACES.      
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE           PIC X(11) VALUE 'RETURN_CODE'.         
CVT999*    05  CNS-COMM-ID               PIC X(07) VALUE 'COMM_ID'.             
CVT999*    05  CNS-ACCOUNT-NO            PIC X(10) VALUE 'ACCOUNT_NO'.          
CVT999*    05  CNS-CUSTOMER-NO           PIC X(11) VALUE 'CUSTOMER_NO'.         
CVT999*    05  CNS-PREMISE-NO            PIC X(10) VALUE 'PREMISE_NO'.          
CVT999*    05  CNS-COMPANY-NO            PIC X(10) VALUE                        
CVT999*                                      'COMPANY_NO'.                      
CVT999*    05  CNS-RED-FLAG-IND          PIC X(12) VALUE                        
CVT999*                                      'RED_FLAG_IND'.                    
CVT999*    05  CNS-RED-FLAG-EXPIRE-DT    PIC X(18) VALUE                        
CVT999*                                      'RED_FLAG_EXPIRE_DT'.              
CVT999*    05  CNS-COMM-METHOD           PIC X(11) VALUE 'COMM_METHOD'.         
CVT999*    05  CNS-COMM-DIRECTION        PIC X(14) VALUE                        
CVT999*                                      'COMM_DIRECTION'.                  
CVT999*    05  CNS-COMM-TYPE-CD          PIC X(12) VALUE                        
CVT999*                                      'COMM_TYPE_CD'.                    
CVT999*    05  CNS-COMM-SUBTYPE-CODE     PIC X(17) VALUE                        
CVT999*                                      'COMM_SUBTYPE_CODE'.               
CVT999*    05  CNS-USER-ID-ORIG          PIC X(12) VALUE                        
CVT999*                                      'USER_ID_ORIG'.                    
CVT999*    05  CNS-CONTACT-NAME          PIC X(12) VALUE                        
CVT999*                                      'CONTACT_NAME'.                    
CVT999*    05  CNS-PROMOTION-ID          PIC X(12) VALUE                        
CVT999*                                      'PROMOTION_ID'.                    
CVT999*    05  CNS-PSC-COMPLIANCE-IND    PIC X(18) VALUE                        
CVT999*                                      'PSC_COMPLIANCE_IND'.              
CVT999*    05  CNS-CALL-ORIGIN-ID        PIC X(14) VALUE                        
CVT999*                                      'CALL_ORIGIN_ID'.                  
CVT999*    05  CNS-CALL-END-TIME         PIC X(13) VALUE                        
CVT999*                                      'CALL_END_TIME'.                   
CVT999*    05  CNS-NUMBER-TRANSFERS      PIC X(16) VALUE                        
CVT999*                                      'NUMBER_TRANSFERS'.                
CVT999*    05  CNS-HOLD-TIME             PIC X(9)  VALUE 'HOLD_TIME'.           
CVT999*    05  CNS-QUEUE-TIME            PIC X(10) VALUE 'QUEUE_TIME'.          
CVT999*    05  CNS-SCREEN-POP-IND        PIC X(14) VALUE                        
CVT999*                                      'SCREEN_POP_IND'.                  
CVT999*    05  CNS-TOTAL-CALL-TIME       PIC X(15) VALUE                        
CVT999*                                      'TOTAL_CALL_TIME'.                 
CVT999*    05  CNS-INITIAL-COMMENT-TEXT  PIC X(20) VALUE                        
CVT999*                                      'INITIAL_COMMENT_TEXT'.            
CVT999*    05  CNS-ADDRESS               PIC X(07) VALUE 'ADDRESS'.             
CVT999*    05  CNS-RESP-AREA             PIC X(9)  VALUE 'RESP_AREA'.           
CVT999*    05  CNS-CURRENT-COMMENTS      PIC X(16) VALUE                        
CVT999*                                      'CURRENT_COMMENTS'.                
CVT999*    05  CNS-TOTAL-COMMENTS        PIC X(14) VALUE                        
CVT999*                                      'TOTAL_COMMENTS'.                  
CVT999*    05  CNS-LAST-NAME             PIC X(09)  VALUE 'LAST_NAME'.          
CVT999*    05  CNS-FIRST-NAME            PIC X(10)  VALUE 'FIRST_NAME'.         
CVT999*    05  CNS-RESPONSE-REASON-CD    PIC X(18)  VALUE                       
CVT999*                                  'RESPONSE_REASON_CD'.                  
CVT999*    05  CNS-RESPONSE-TYPE-CD      PIC X(16)  VALUE                       
CVT999*                                  'RESPONSE_TYPE_CD'.                    
CVT999*    05  CNS-SOLICITATION-CD       PIC X(15)   VALUE                      
CVT999*                                  'SOLICITATION_CD'.                     
CVT999*    05  CNS-COMM-ASSOC-CD         PIC X(13)   VALUE                      
CVT999*                                  'COMM_ASSOC_CD'.                       
CVT999*    05  CNS-USER-ID               PIC X(07)   VALUE 'USER_ID'.           
CVT999*    05  CNS-UPDATE-TS             PIC X(09)   VALUE 'UPDATE_TS'.         
CVT999*    05  CNS-COMPLAINT-FL          PIC X(12)   VALUE                      
CVT999*                                  'COMPLAINT_FL'.                        
CVT999*                                                                         
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      *--- < CURSOR FOR KO COMM_DATA SELECTION >                                
      *--- < FILTERED BY ACCOUNT_NO >                                           
                                                                        
           EXEC SQL DECLARE KO-COMM-DATA-ACCT CURSOR FOR                
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPANY_NO,                                       
                      RED_FLAG_IND,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
                      COMM_METHOD,                                      
                      COMM_DIRECTION,                                   
                      COMM_TYPE_CD,                                     
                      COMM_SUBTYPE_CODE,                                
                      USER_ID_ORIG,                                     
                      CONTACT_NAME,                                     
                      PROMOTION_ID,                                     
                      PSC_COMPLIANCE_IND,                               
                      CALL_ORIGIN_ID,                                   
                      REPLACE(REPLACE(CONVERT(CHAR(26), CALL_END_TIME
           , 121), ' ', '-'), ':', '.') CALL_END_TIME,                         
                      NUMBER_TRANSFERS,                                 
                      HOLD_TIME,                                        
                      QUEUE_TIME,                                       
                      SCREEN_POP_IND,                                   
                      TOTAL_CALL_TIME,                                  
                      INITIAL_COMMENT_TX,                               
                      RESPONSE_REASON_CD,                               
                      RESPONSE_TYPE_CD,                                 
                      SOLICITATION_CD,                                  
                      COMM_ASSOC_CD,                                    
                      COMPLAINT_FL                                      
             FROM     CSS_COMM_DATA WITH(READUNCOMMITTED)                       
             WHERE    ACCOUNT_NO       = :KO-ACCOUNT-NO                 
               AND    COMMUNICATION_ID BETWEEN                          
                      CIS.CHAR2TIMESTAMP(:WS-FR-DATE) AND 
              CIS.CHAR2TIMESTAMP(:WS-TO-DATE)                       
               AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                
               AND    COMM_SUBTYPE_CODE LIKE                            
                      :WS-COMM-SUBTYPE-CD                               
               AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION            
               AND    (USER_ID_ORIG LIKE :WS-USER-ID                    
               OR     EXISTS                                            
                      (SELECT A.COMMUNICATION_ID                        
                         FROM CSS_COMM_COMMENT A WITH(READUNCOMMITTED)          
                        WHERE A.COMMUNICATION_ID = COMMUNICATION_ID     
                          AND USER_ID LIKE :WS-USER-ID))                
             ORDER BY COMMUNICATION_ID DESC
            OPTION(FAST 1)
            FOR READ ONLY
                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE KO-COMM-DATA-ACCT CURSOR FOR                        
MFA-TR*      SELECT   COMMUNICATION_ID,                                         
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               PROMOTION_ID,                                             
MFA-TR*               PSC_COMPLIANCE_IND,                                       
MFA-TR*               CALL_ORIGIN_ID,                                           
MFA-TR*               CALL_END_TIME,                                            
MFA-TR*               NUMBER_TRANSFERS,                                         
MFA-TR*               HOLD_TIME,                                                
MFA-TR*               QUEUE_TIME,                                               
MFA-TR*               SCREEN_POP_IND,                                           
MFA-TR*               TOTAL_CALL_TIME,                                          
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               RESPONSE_REASON_CD,                                       
MFA-TR*               RESPONSE_TYPE_CD,                                         
MFA-TR*               SOLICITATION_CD,                                          
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMPLAINT_FL                                              
MFA-TR*      FROM     CSS_COMM_DATA                                             
MFA-TR*      WHERE    ACCOUNT_NO       = :KO-ACCOUNT-NO                         
MFA-TR*        AND    COMMUNICATION_ID BETWEEN                                  
MFA-TR*               :WS-FR-DATE AND :WS-TO-DATE                               
MFA-TR*        AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                        
MFA-TR*        AND    COMM_SUBTYPE_CODE LIKE                                    
MFA-TR*               :WS-COMM-SUBTYPE-CD                                       
MFA-TR*        AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION                    
MFA-TR*        AND    (USER_ID_ORIG LIKE :WS-USER-ID                            
MFA-TR*        OR     EXISTS                                                    
MFA-TR*               (SELECT A.COMMUNICATION_ID                                
MFA-TR*                  FROM CSS_COMM_COMMENT A                                
MFA-TR*                 WHERE A.COMMUNICATION_ID = COMMUNICATION_ID             
MFA-TR*                   AND USER_ID LIKE :WS-USER-ID))                        
MFA-TR*      ORDER BY COMMUNICATION_ID DESC                                     
MFA-TR*      OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR KO COMM_DATA SELECTION >                                
      *--- < FILTERED BY PREMISE_NO >                                           
                                                                        
           EXEC SQL DECLARE KO-COMM-DATA-PREM CURSOR FOR                
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPANY_NO,                                       
                      RED_FLAG_IND,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
                      COMM_METHOD,                                      
                      COMM_DIRECTION,                                   
                      COMM_TYPE_CD,                                     
                      COMM_SUBTYPE_CODE,                                
                      USER_ID_ORIG,                                     
                      CONTACT_NAME,                                     
                      PROMOTION_ID,                                     
                      PSC_COMPLIANCE_IND,                               
                      CALL_ORIGIN_ID,                                   
                      REPLACE(REPLACE(CONVERT(CHAR(26), CALL_END_TIME
           , 121), ' ', '-'), ':', '.') CALL_END_TIME,                         
                      NUMBER_TRANSFERS,                                 
                      HOLD_TIME,                                        
                      QUEUE_TIME,                                       
                      SCREEN_POP_IND,                                   
                      TOTAL_CALL_TIME,                                  
                      INITIAL_COMMENT_TX,                               
                      RESPONSE_REASON_CD,                               
                      RESPONSE_TYPE_CD,                                 
                      SOLICITATION_CD,                                  
                      COMM_ASSOC_CD,                                    
                      COMPLAINT_FL                                      
             FROM     CSS_COMM_DATA WITH(READUNCOMMITTED)                       
             WHERE    PREMISE_NO  = :KO-PREMISE-NO                      
               AND    COMMUNICATION_ID BETWEEN                          
                      CIS.CHAR2TIMESTAMP(:WS-FR-DATE) AND 
              CIS.CHAR2TIMESTAMP(:WS-TO-DATE)                       
               AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                
               AND    COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD        
               AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION            
               AND    (USER_ID_ORIG LIKE :WS-USER-ID                    
               OR     EXISTS                                            
                      (SELECT COMMUNICATION_ID                          
                         FROM CSS_COMM_COMMENT WITH(READUNCOMMITTED)            
                        WHERE USER_ID LIKE :WS-USER-ID))
            OPTION(FAST 1)
            FOR READ ONLY
                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE KO-COMM-DATA-PREM CURSOR FOR                        
MFA-TR*      SELECT   COMMUNICATION_ID,                                         
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               PROMOTION_ID,                                             
MFA-TR*               PSC_COMPLIANCE_IND,                                       
MFA-TR*               CALL_ORIGIN_ID,                                           
MFA-TR*               CALL_END_TIME,                                            
MFA-TR*               NUMBER_TRANSFERS,                                         
MFA-TR*               HOLD_TIME,                                                
MFA-TR*               QUEUE_TIME,                                               
MFA-TR*               SCREEN_POP_IND,                                           
MFA-TR*               TOTAL_CALL_TIME,                                          
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               RESPONSE_REASON_CD,                                       
MFA-TR*               RESPONSE_TYPE_CD,                                         
MFA-TR*               SOLICITATION_CD,                                          
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMPLAINT_FL                                              
MFA-TR*      FROM     CSS_COMM_DATA                                             
MFA-TR*      WHERE    PREMISE_NO  = :KO-PREMISE-NO                              
MFA-TR*        AND    COMMUNICATION_ID BETWEEN                                  
MFA-TR*               :WS-FR-DATE AND :WS-TO-DATE                               
MFA-TR*        AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                        
MFA-TR*        AND    COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD                
MFA-TR*        AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION                    
MFA-TR*        AND    (USER_ID_ORIG LIKE :WS-USER-ID                            
MFA-TR*        OR     EXISTS                                                    
MFA-TR*               (SELECT COMMUNICATION_ID                                  
MFA-TR*                  FROM CSS_COMM_COMMENT                                  
MFA-TR*                 WHERE USER_ID LIKE :WS-USER-ID))                        
MFA-TR*      OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR KO COMM_DATA SELECTION >                                
      *--- < FILTERED BY PREMISE_NO ASSOC = P AND RED FLAG >                    
                                                                        
T28151                                                                  
T28151     EXEC SQL DECLARE KO-COMM-PREM-FLAG CURSOR FOR                
T28151       SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
T28151                ACCOUNT_NO,                                       
T28151                CUSTOMER_NO,                                      
T28151                PREMISE_NO,                                       
T28151                COMPANY_NO,                                       
T28151                RED_FLAG_IND,                                     
T28151                REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
T28151                COMM_METHOD,                                      
T28151                COMM_DIRECTION,                                   
T28151                COMM_TYPE_CD,                                     
T28151                COMM_SUBTYPE_CODE,                                
T28151                USER_ID_ORIG,                                     
T28151                CONTACT_NAME,                                     
T28151                PROMOTION_ID,                                     
T28151                PSC_COMPLIANCE_IND,                               
T28151                CALL_ORIGIN_ID,                                   
T28151                REPLACE(REPLACE(CONVERT(CHAR(26), CALL_END_TIME
           , 121), ' ', '-'), ':', '.') CALL_END_TIME,                         
T28151                NUMBER_TRANSFERS,                                 
T28151                HOLD_TIME,                                        
T28151                QUEUE_TIME,                                       
T28151                SCREEN_POP_IND,                                   
T28151                TOTAL_CALL_TIME,                                  
T28151                INITIAL_COMMENT_TX,                               
T28151                RESPONSE_REASON_CD,                               
T28151                RESPONSE_TYPE_CD,                                 
T28151                SOLICITATION_CD,                                  
T28151                COMM_ASSOC_CD,                                    
T28151                COMPLAINT_FL                                      
T28151       FROM     CSS_COMM_DATA WITH(READUNCOMMITTED)                       
T28151       WHERE    PREMISE_NO  = :KO-PREMISE-NO                      
T28151         AND    (RED_FLAG_EXPIRE_DT >= CIS.CHAR2TIMESTAMP(
                                                   :WS-TODAYS-TIMESTAMP
              )       
T28151                OR   RED_FLAG_EXPIRE_DT IS NULL)                  
T28151         AND    RED_FLAG_IND = 'Y'                                
T28151         AND    COMM_ASSOC_CD = 'P'                               
T28151         AND    CUSTOMER_NO <> :KO-CUSTOMER-NO
            OPTION(FAST 1)
            FOR READ ONLY
                              
T28151     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE KO-COMM-PREM-FLAG CURSOR FOR                        
MFA-TR*      SELECT   COMMUNICATION_ID,                                         
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               PROMOTION_ID,                                             
MFA-TR*               PSC_COMPLIANCE_IND,                                       
MFA-TR*               CALL_ORIGIN_ID,                                           
MFA-TR*               CALL_END_TIME,                                            
MFA-TR*               NUMBER_TRANSFERS,                                         
MFA-TR*               HOLD_TIME,                                                
MFA-TR*               QUEUE_TIME,                                               
MFA-TR*               SCREEN_POP_IND,                                           
MFA-TR*               TOTAL_CALL_TIME,                                          
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               RESPONSE_REASON_CD,                                       
MFA-TR*               RESPONSE_TYPE_CD,                                         
MFA-TR*               SOLICITATION_CD,                                          
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMPLAINT_FL                                              
MFA-TR*      FROM     CSS_COMM_DATA                                             
MFA-TR*      WHERE    PREMISE_NO  = :KO-PREMISE-NO                              
MFA-TR*        AND    (RED_FLAG_EXPIRE_DT >= :WS-TODAYS-TIMESTAMP               
MFA-TR*               OR   RED_FLAG_EXPIRE_DT IS NULL)                          
MFA-TR*        AND    RED_FLAG_IND = 'Y'                                        
MFA-TR*        AND    COMM_ASSOC_CD = 'P'                                       
MFA-TR*        AND    CUSTOMER_NO = :KO-CUSTOMER-NO                            
MFA-TR*      ORDER BY COMMUNICATION_ID DESC                                     
MFA-TR*      OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR KO COMM_DATA SELECTION >                                
      *--- < FILTERED BY CUSTOMER_NO AND USER_ID PASSED >                       
                                                                        
           EXEC SQL DECLARE KO-COMM-CUST-USER CURSOR FOR                
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPANY_NO,                                       
                      RED_FLAG_IND,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
                      COMM_METHOD,                                      
                      COMM_DIRECTION,                                   
                      COMM_TYPE_CD,                                     
                      COMM_SUBTYPE_CODE,                                
                      USER_ID_ORIG,                                     
                      CONTACT_NAME,                                     
                      PROMOTION_ID,                                     
                      PSC_COMPLIANCE_IND,                               
                      CALL_ORIGIN_ID,                                   
                      REPLACE(REPLACE(CONVERT(CHAR(26), CALL_END_TIME
           , 121), ' ', '-'), ':', '.') CALL_END_TIME,                         
                      NUMBER_TRANSFERS,                                 
                      HOLD_TIME,                                        
                      QUEUE_TIME,                                       
                      SCREEN_POP_IND,                                   
                      TOTAL_CALL_TIME,                                  
                      INITIAL_COMMENT_TX,                               
                      RESPONSE_REASON_CD,                               
                      RESPONSE_TYPE_CD,                                 
                      SOLICITATION_CD,                                  
                      COMM_ASSOC_CD,                                    
                      COMPLAINT_FL                                      
             FROM     CSS_COMM_DATA WITH(READUNCOMMITTED)                       
             WHERE    CUSTOMER_NO  = :KO-CUSTOMER-NO                    
               AND    COMMUNICATION_ID BETWEEN                          
                      CIS.CHAR2TIMESTAMP(:WS-FR-DATE) AND 
              CIS.CHAR2TIMESTAMP(:WS-TO-DATE)                       
               AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                
               AND    COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD        
               AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION            
               AND    (USER_ID_ORIG LIKE :WS-USER-ID                    
               OR     EXISTS                                            
                      (SELECT A.COMMUNICATION_ID                        
                         FROM CSS_COMM_COMMENT A WITH(READUNCOMMITTED)          
                        WHERE A.COMMUNICATION_ID = COMMUNICATION_ID     
                          AND A.USER_ID LIKE :WS-USER-ID))              
             ORDER BY COMMUNICATION_ID DESC
            OPTION(FAST 1)
            FOR READ ONLY
                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE KO-COMM-CUST-USER CURSOR FOR                        
MFA-TR*      SELECT   COMMUNICATION_ID,                                         
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               PROMOTION_ID,                                             
MFA-TR*               PSC_COMPLIANCE_IND,                                       
MFA-TR*               CALL_ORIGIN_ID,                                           
MFA-TR*               CALL_END_TIME,                                            
MFA-TR*               NUMBER_TRANSFERS,                                         
MFA-TR*               HOLD_TIME,                                                
MFA-TR*               QUEUE_TIME,                                               
MFA-TR*               SCREEN_POP_IND,                                           
MFA-TR*               TOTAL_CALL_TIME,                                          
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               RESPONSE_REASON_CD,                                       
MFA-TR*               RESPONSE_TYPE_CD,                                         
MFA-TR*               SOLICITATION_CD,                                          
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMPLAINT_FL                                              
MFA-TR*      FROM     CSS_COMM_DATA                                             
MFA-TR*      WHERE    CUSTOMER_NO  = :KO-CUSTOMER-NO                            
MFA-TR*        AND    COMMUNICATION_ID BETWEEN                                  
MFA-TR*               :WS-FR-DATE AND :WS-TO-DATE                               
MFA-TR*        AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                        
MFA-TR*        AND    COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD                
MFA-TR*        AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION                    
MFA-TR*        AND    (USER_ID_ORIG LIKE :WS-USER-ID                            
MFA-TR*        OR     EXISTS                                                    
MFA-TR*               (SELECT A.COMMUNICATION_ID                                
MFA-TR*                  FROM CSS_COMM_COMMENT A                                
MFA-TR*                 WHERE A.COMMUNICATION_ID = COMMUNICATION_ID             
MFA-TR*                   AND A.USER_ID LIKE :WS-USER-ID))                      
MFA-TR*      ORDER BY COMMUNICATION_ID DESC                                     
MFA-TR*      OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR                          
MFA-TR*    END-EXEC.                                                            
                                                                        
      *--- < CURSOR FOR KO COMM_DATA SELECTION >                                
      *--- < FILTERED BY CUSTOMER_NO NO USER_ID PASSED >                        
                                                                        
           EXEC SQL DECLARE KO-COMM-DATA-CUST CURSOR FOR                
             SELECT   REPLACE(REPLACE(CONVERT(CHAR(26), COMMUNICATION_ID
           , 121), ' ', '-'), ':', '.') COMMUNICATION_ID,                      
                      ACCOUNT_NO,                                       
                      CUSTOMER_NO,                                      
                      PREMISE_NO,                                       
                      COMPANY_NO,                                       
                      RED_FLAG_IND,                                     
                      REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                               
                      COMM_METHOD,                                      
                      COMM_DIRECTION,                                   
                      COMM_TYPE_CD,                                     
                      COMM_SUBTYPE_CODE,                                
                      USER_ID_ORIG,                                     
                      CONTACT_NAME,                                     
                      PROMOTION_ID,                                     
                      PSC_COMPLIANCE_IND,                               
                      CALL_ORIGIN_ID,                                   
                      REPLACE(REPLACE(CONVERT(CHAR(26), CALL_END_TIME
           , 121), ' ', '-'), ':', '.') CALL_END_TIME,                         
                      NUMBER_TRANSFERS,                                 
                      HOLD_TIME,                                        
                      QUEUE_TIME,                                       
                      SCREEN_POP_IND,                                   
                      TOTAL_CALL_TIME,                                  
                      INITIAL_COMMENT_TX,                               
                      RESPONSE_REASON_CD,                               
                      RESPONSE_TYPE_CD,                                 
                      SOLICITATION_CD,                                  
                      COMM_ASSOC_CD,                                    
                      COMPLAINT_FL                                      
             FROM     CSS_COMM_DATA WITH(READUNCOMMITTED)                       
             WHERE    CUSTOMER_NO  = :KO-CUSTOMER-NO                    
               AND    COMMUNICATION_ID BETWEEN                          
                      CIS.CHAR2TIMESTAMP(:WS-FR-DATE) AND 
              CIS.CHAR2TIMESTAMP(:WS-TO-DATE)                       
               AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                
               AND    COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD        
               AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION            
             ORDER BY COMMUNICATION_ID DESC
            OPTION(FAST 1)
            FOR READ ONLY
                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE KO-COMM-DATA-CUST CURSOR FOR                        
MFA-TR*      SELECT   COMMUNICATION_ID,                                         
MFA-TR*               ACCOUNT_NO,                                               
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               PREMISE_NO,                                               
MFA-TR*               COMPANY_NO,                                               
MFA-TR*               RED_FLAG_IND,                                             
MFA-TR*               RED_FLAG_EXPIRE_DT,                                       
MFA-TR*               COMM_METHOD,                                              
MFA-TR*               COMM_DIRECTION,                                           
MFA-TR*               COMM_TYPE_CD,                                             
MFA-TR*               COMM_SUBTYPE_CODE,                                        
MFA-TR*               USER_ID_ORIG,                                             
MFA-TR*               CONTACT_NAME,                                             
MFA-TR*               PROMOTION_ID,                                             
MFA-TR*               PSC_COMPLIANCE_IND,                                       
MFA-TR*               CALL_ORIGIN_ID,                                           
MFA-TR*               CALL_END_TIME,                                            
MFA-TR*               NUMBER_TRANSFERS,                                         
MFA-TR*               HOLD_TIME,                                                
MFA-TR*               QUEUE_TIME,                                               
MFA-TR*               SCREEN_POP_IND,                                           
MFA-TR*               TOTAL_CALL_TIME,                                          
MFA-TR*               INITIAL_COMMENT_TX,                                       
MFA-TR*               RESPONSE_REASON_CD,                                       
MFA-TR*               RESPONSE_TYPE_CD,                                         
MFA-TR*               SOLICITATION_CD,                                          
MFA-TR*               COMM_ASSOC_CD,                                            
MFA-TR*               COMPLAINT_FL                                              
MFA-TR*      FROM     CSS_COMM_DATA                                             
MFA-TR*      WHERE    CUSTOMER_NO  = :KO-CUSTOMER-NO                            
MFA-TR*        AND    COMMUNICATION_ID BETWEEN                                  
MFA-TR*               :WS-FR-DATE AND :WS-TO-DATE                               
MFA-TR*        AND    COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                        
MFA-TR*        AND    COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD                
MFA-TR*        AND    COMM_DIRECTION LIKE :WS-COMM-DIRECTION                    
MFA-TR*      ORDER BY COMMUNICATION_ID DESC                                     
MFA-TR*      OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR                          
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      *--- < CURSOR FOR KN COMM_COMMENT SELECTION >                             
                                                                        
           EXEC SQL DECLARE KN-COMM-COMMENT CURSOR FOR                  
             SELECT   COMMENT_TX,                                       
                      USER_ID,                                          
                      REPLACE(REPLACE(CONVERT(CHAR(26), UPDATE_TS
           , 121), ' ', '-'), ':', '.') UPDATE_TS                              
             FROM     CSS_COMM_COMMENT WITH(READUNCOMMITTED)                    
             WHERE    COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )           
             ORDER BY COMMUNICATION_ID DESC, UPDATE_TS DESC
            OPTION(FAST 1)
            FOR READ ONLY
                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ021
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE KN-COMM-COMMENT CURSOR FOR                          
MFA-TR*      SELECT   COMMENT_TX,                                               
MFA-TR*               USER_ID,                                                  
MFA-TR*               UPDATE_TS                                                 
MFA-TR*      FROM     CSS_COMM_COMMENT                                          
MFA-TR*      WHERE    COMMUNICATION_ID = :KO-COMMUNICATION-ID                   
MFA-TR*      ORDER BY COMMUNICATION_ID DESC, UPDATE_TS DESC                     
MFA-TR*      OPTIMIZE FOR 1 ROW FOR FETCH ONLY WITH UR                          
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR                             
A37342                           WITH ROWSET POSITIONING FOR            
CVT000         SELECT *                                                 
CVT000         FROM #CSR02518_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT *                                                 00000400
MFA-TR*        FROM SESSION.CSR02518_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-CODE                PIC X                    .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-CUSTOMER-NO         PIC X(10)                .          
CVT000 01  LINK-PREMISE-NO          PIC X(10)                .          
CVT000 01  LINK-COMM-ID             PIC X(26)                .          
CVT000 01  LINK-FR-DATE             PIC X(10)                .          
CVT000 01  LINK-TO-DATE             PIC X(10)                .          
CVT000 01  LINK-COMM-TYPE-CD        PIC X(2)                 .          
CVT000 01  LINK-COMM-SUBTYPE-CD     PIC X(2)                 .          
CVT000 01  LINK-COMM-DIRECTION      PIC X                    .          
CVT000 01  LINK-USER-ID             PIC X(7)                 .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-CODE                                               
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-CUSTOMER-NO                                        
CVT000         ,LINK-PREMISE-NO                                         
CVT000         ,LINK-COMM-ID                                            
CVT000         ,LINK-FR-DATE                                            
CVT000         ,LINK-TO-DATE                                            
CVT000         ,LINK-COMM-TYPE-CD                                       
CVT000         ,LINK-COMM-SUBTYPE-CD                                    
CVT000         ,LINK-COMM-DIRECTION                                     
CVT000         ,LINK-USER-ID                                            
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME               TO ABEND-PROGRAM                  
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'         TO TABLE-1                        
CVT999*       MOVE GWL-RC                     TO WS-ACTIVE-RETURN-CODE          
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-CODE                 TO PARM-CODE                . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
CVT000     MOVE LINK-PREMISE-NO           TO PARM-PREMISE-NO          . 
CVT000     MOVE LINK-COMM-ID              TO PARM-COMM-ID             . 
CVT000     MOVE LINK-FR-DATE              TO PARM-FR-DATE             . 
CVT000     MOVE LINK-TO-DATE              TO PARM-TO-DATE             . 
CVT000     MOVE LINK-COMM-TYPE-CD         TO PARM-COMM-TYPE-CD        . 
CVT000     MOVE LINK-COMM-SUBTYPE-CD      TO PARM-COMM-SUBTYPE-CD     . 
CVT000     MOVE LINK-COMM-DIRECTION       TO PARM-COMM-DIRECTION      . 
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02518_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02518_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,COMM_ID CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,PREMISE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,COMPANY_NO CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,RED_FLAG_IND CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,RED_FLAG_EXPIRE_DT CHAR(26)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,COMM_METHOD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,COMM_DIRECTION CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,COMM_TYPE_CD CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,COMM_SUBTYPE_CODE CHAR(2)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,USER_ID_ORIG CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CONTACT_NAME CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,PROMOTION_ID CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,PSC_COMPLIANCE_IND CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,CALL_ORIGIN_ID           DECIMAL(04,0)                   
CVT000        ,CALL_END_TIME CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,NUMBER_TRANSFERS         INT                         
CVT000        ,HOLD_TIME                DECIMAL(05,0)                   
CVT000        ,QUEUE_TIME               DECIMAL(05,0)                   
CVT000        ,SCREEN_POP_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,TOTAL_CALL_TIME          DECIMAL(05,0)                   
CVT004        ,INITIAL_COMMENT_TE CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                       
CVT000        ,ADDRESS CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2                
CVT000        ,RESP_AREA CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,CURRENT_COMMENTS CHAR(255)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                       
CVT000        ,TOTAL_COMMENTS           DECIMAL(04,0)                   
CVT000        ,LAST_NAME CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,FIRST_NAME CHAR(12)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,RESPONSE_REASON_CD CHAR(4)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
CVT000        ,RESPONSE_TYPE_CD CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,SOLICITATION_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,COMM_ASSOC_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,USER_ID CHAR(7)  COLLATE LATIN1_GENERAL_100_BIN2                 
CVT000        ,UPDATE_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2              
CVT000        ,COMPLAINT_FL CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,COMM_SUB_TYPE CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,COMM_TODAY               DATE                            
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
           MOVE PARM-CODE TO WS-PARM-CODE.                              
           MOVE PARM-ACCOUNT-NO TO WS-ACCOUNT-NO-X.                     
           MOVE PARM-PREMISE-NO TO WS-PREMISE-NO-X.                     
           IF WS-PREMISE-NO-X NOT NUMERIC THEN                          
               MOVE ZEROES TO WS-PREMISE-NO                             
           END-IF.                                                      
           MOVE PARM-CUSTOMER-NO TO WS-CUSTOMER-NO-X.                   
           MOVE PARM-COMM-ID   TO WS-COMM-ID.                           
           MOVE PARM-FR-DATE          TO WS-HOLD-DATE.                  
           PERFORM 1110-TRANS-DATE    THRU 1110-EXIT.                   
           MOVE WS-DB2-DATE           TO WS-PARM-FR-DATE.               
           MOVE WS-PARM-FR-TS         TO WS-FR-DATE.                    
           MOVE PARM-TO-DATE          TO WS-HOLD-DATE.                  
           PERFORM 1110-TRANS-DATE    THRU 1110-EXIT.                   
           MOVE WS-DB2-DATE           TO WS-PARM-TO-DATE.               
           MOVE WS-PARM-TO-TS         TO WS-TO-DATE.                    
           IF PARM-COMM-TYPE-CD = SPACES                                
               MOVE '%%' TO WS-COMM-TYPE-CD                             
           ELSE                                                         
               MOVE PARM-COMM-TYPE-CD TO WS-COMM-TYPE-CD                
           END-IF.                                                      
           IF PARM-COMM-SUBTYPE-CD = SPACES                             
               MOVE '%%' TO WS-COMM-SUBTYPE-CD                          
           ELSE                                                         
               MOVE PARM-COMM-SUBTYPE-CD TO WS-COMM-SUBTYPE-CD          
           END-IF.                                                      
           IF PARM-COMM-DIRECTION = SPACES                              
               MOVE '%' TO WS-COMM-DIRECTION                            
           ELSE                                                         
               MOVE PARM-COMM-DIRECTION TO WS-COMM-DIRECTION            
           END-IF.                                                      
           IF PARM-USER-ID = SPACES                                     
               MOVE '%%%%%%%' TO WS-USER-ID                             
           ELSE                                                         
               MOVE PARM-USER-ID TO WS-USER-ID                          
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
                                                                        
      *----< GET PARM-CODE  >                                                   
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CODE              TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE,                                     
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
                                                                        
      *----< GET ACCOUNT-NO >                                                   
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *----< GET CUSTOMER-NO >                                                  
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CUSTOMER-NO       TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CUSTOMER-NO,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *----< GET PREMISE-NO >                                                   
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-PREMISE-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-PREMISE-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
                                                                        
      *----< GET COMM-ID    >                                                   
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMM-ID           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMM-ID,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
                                                                        
      *----< GET PARM-FR-DATE >                                                 
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-FR-DATE           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-FR-DATE,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
T30461     IF PARM-FR-DATE = '01/01/1991'                               
T30461        MOVE '1/1/1991' TO PARM-FR-DATE                           
T30461     END-IF                                                       
                                                                        
      *----< GET PARM-TO-DATE >                                                 
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-TO-DATE           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-TO-DATE,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *----< GET PARM-COMM-TYPE CD              >                               
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMM-TYPE-CD      TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMM-TYPE-CD,                             
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *----< GET PARM-COMM-SUBTYPE CD              >                            
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMM-SUBTYPE-CD  TO MAX-LENGTH-PARM.             
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMM-SUBTYPE-CD,                          
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *----< GET PARM-COMM-DIRECTION            >                               
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-COMM-DIRECTION    TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-COMM-DIRECTION,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      *----< GET PARM-USER-ID                   >                               
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-USER-ID           TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-USER-ID,                                  
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
            .                                                           
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1110-TRANS-DATE                                                *        
      *     TRANLATE THE DATE INTO DB2 FORMAT                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1110-TRANS-DATE.                                                 
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              IIF(TRY_CONVERT(DATE, :WS-HOLD-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-HOLD-DATE
              ) <> 0) OR (LEN(:WS-HOLD-DATE) <> 10), CIS.CHAR2DATE(
                                                          :WS-HOLD-DATE
              ), CONVERT(DATE, :WS-HOLD-DATE) )
            INTO
              :WS-DB2-DATE                   
           END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-DB2-DATE  = DATE(:WS-HOLD-DATE)                           
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
                                                                        
       1110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2300-BUILD-RESULT                                    *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EXEC SQL                                                     
T34097        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TODAYS-DATE  =  CURRENT DATE                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE WS-TODAYS-DATE             TO WS-DATE.                  
           MOVE WS-RED-FLAG-TS             TO WS-TODAYS-TIMESTAMP.      
           MOVE WS-DATE                    TO WS-TODAYS-DATE-RED.       
                                                                        
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2100-DESCRIBE-RESULT    THRU 2100-EXIT.              
           PERFORM 2300-BUILD-RESULT       THRU 2300-EXIT.              
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *      CALLED FROM 2000-PROCESS-OUTPUT                           *        
      *                                                                *        
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                  *        
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMM-ID         TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-COMM-ID        TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMM-ID,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMM-ID,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-ACCOUNT-NO      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ACCOUNT-NO     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCOUNT-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACCOUNT-NO,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUSTOMER-NO     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-CUSTOMER-NO    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUSTOMER-NO,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUSTOMER-NO,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-PREMISE-NO      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-PREMISE-NO     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PREMISE-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PREMISE-NO,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMPANY-NO      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-COMPANY-NO     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMPANY-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMPANY-NO,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RED-FLAG-IND    TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RED-FLAG-IND   TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RED-FLAG-IND,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RED-FLAG-IND,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RED-FLAG-EXPIRE-DT                                 
CVT999*                                      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RED-FLAG-EXPIRE-DT                                
CVT999*                                      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RED-FLAG-EXPIRE-DT,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RED-FLAG-EXPIRE-DT,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMM-METHOD     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-COMM-METHOD    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMM-METHOD,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMM-METHOD,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMM-DIRECTION  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-COMM-DIRECTION TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMM-DIRECTION,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMM-DIRECTION,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMM-TYPE-CD    TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-COMM-TYPE-CD   TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMM-TYPE-CD,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMM-TYPE-CD,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMM-SUBTYPE-CODE                                  
CVT999*                                      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-COMM-SUBTYPE-CODE                                 
CVT999*                                      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMM-SUBTYPE-CODE,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMM-SUBTYPE-CODE,                         
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-USER-ID-ORIG    TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-USER-ID-ORIG   TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-USER-ID-ORIG,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-USER-ID-ORIG,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-CONTACT-NAME    TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-CONTACT-NAME   TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CONTACT-NAME,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CONTACT-NAME,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-PROMOTION-ID    TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-PROMOTION-ID  TO WRKLEN2.                         
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PROMOTION-ID,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PROMOTION-ID,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-PSC-COMPLIANCE-IND                                 
CVT999*                                      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-PSC-COMPLIANCE-IND                                
CVT999*                                      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-PSC-COMPLIANCE-IND,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-PSC-COMPLIANCE-IND,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CALL-ORIGIN-ID  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-CALL-ORIGIN-ID TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CALL-ORIGIN-ID,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CALL-ORIGIN-ID,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-CALL-END-TIME   TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-CALL-END-TIME  TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CALL-END-TIME,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CALL-END-TIME,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                 TO DB-HOST-TYPE.                        
CVT999*    MOVE TDSINT4                 TO DB-CLIENT-TYPE.                      
CVT999*    MOVE LENGTH OF RS-NUMBER-TRANSFERS                                   
CVT999*                                      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-NUMBER-TRANSFERS                                  
CVT999*                                      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-NUMBER-TRANSFERS,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-NUMBER-TRANSFERS,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-HOLD-TIME       TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-HOLD-TIME      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-HOLD-TIME,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-HOLD-TIME,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-QUEUE-TIME      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-QUEUE-TIME     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-QUEUE-TIME,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-QUEUE-TIME,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-SCREEN-POP-IND  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-SCREEN-POP-IND TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SCREEN-POP-IND,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SCREEN-POP-IND,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.                
CVT999*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TOTAL-CALL-TIME TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-TOTAL-CALL-TIME                                   
CVT999*                                      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TOTAL-CALL-TIME,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TOTAL-CALL-TIME,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    MOVE +2 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-INITIAL-COMMENT-TE                                 
CVT999*                                      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-INITIAL-COMMENT-TEXT                              
CVT999*                                      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-INITIAL-COMMENT-TE,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-INITIAL-COMMENT-TEXT,                      
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-ADDRESS         TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ADDRESS        TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDRESS,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ADDRESS,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RESP-AREA       TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RESP-AREA      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RESP-AREA,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RESP-AREA,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-CURRENT-COMMENTS TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-CURRENT-COMMENTS TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CURRENT-COMMENTS,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CURRENT-COMMENTS,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSDECIMAL                   TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSFLT8                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-TOTAL-COMMENTS  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-TOTAL-COMMENTS TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TOTAL-COMMENTS,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TOTAL-COMMENTS,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    MOVE +0 TO WRKLEN2.                                                  
CVT999*    CALL 'TDSETBCD' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          TDS-OBJECT-COL,                                
CVT999*                          CTR-COLUMN,                                    
CVT999*                          WRKLEN1,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-LAST-NAME       TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-LAST-NAME      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LAST-NAME,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-LAST-NAME,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FIRST-NAME      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FIRST-NAME     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FIRST-NAME,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FIRST-NAME,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RESPONSE-REASON-CD TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-RESPONSE-REASON-CD TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RESPONSE-REASON-CD,                         
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RESPONSE-REASON-CD,                        
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RESPONSE-TYPE-CD TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-RESPONSE-TYPE-CD TO WRKLEN2.                      
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RESPONSE-TYPE-CD,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RESPONSE-TYPE-CD,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-SOLICITATION-CD TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-SOLICITATION-CD TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SOLICITATION-CD,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SOLICITATION-CD,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMM-ASSOC-CD TO WRKLEN1.                          
CVT999*    MOVE LENGTH OF CNS-COMM-ASSOC-CD TO WRKLEN2.                         
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMM-ASSOC-CD,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMM-ASSOC-CD,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-USER-ID         TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-USER-ID        TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-USER-ID,                                    
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-USER-ID,                                   
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-UPDATE-TS       TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-UPDATE-TS      TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-UPDATE-TS,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-UPDATE-TS,                                 
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-COMPLAINT-FL    TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-COMPLAINT-FL   TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-COMPLAINT-FL,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-COMPLAINT-FL,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE ZERO TO WS-ROW-CT.                                      
           EVALUATE WS-PARM-CODE                                        
               WHEN 'C'                                                 
PERF               IF WS-CUSTOMER-NO = ZEROES                           
PERF                  MOVE 9999999999     TO KO-CUSTOMER-NO             
PERF               ELSE                                                 
                      MOVE WS-CUSTOMER-NO TO KO-CUSTOMER-NO             
PERF               END-IF                                               
PERF               IF WS-PREMISE-NO = ZEROES                            
PERF                  MOVE 9999999999     TO KO-PREMISE-NO              
PERF               ELSE                                                 
                      MOVE WS-PREMISE-NO TO KO-PREMISE-NO               
PERF               END-IF                                               
PERF               IF WS-USER-ID = '%%%%%%%'                            
                       PERFORM 2400-SELECT-CUSTOMER THRU 2400-EXIT      
                   ELSE                                                 
                       PERFORM 3000-SELECT-CUST-USER THRU 3000-EXIT     
                   END-IF                                               
               WHEN 'A'                                                 
PERF               IF WS-ACCOUNT-NO = ZEROES                            
PERF                  MOVE 9999999999999  TO KO-ACCOUNT-NO              
PERF               ELSE                                                 
                      MOVE WS-ACCOUNT-NO TO KO-ACCOUNT-NO               
PERF               END-IF                                               
                   PERFORM 2500-SELECT-ACCOUNT  THRU 2500-EXIT          
               WHEN 'P'                                                 
PERF               IF WS-PREMISE-NO = ZEROES                            
PERF                  MOVE 9999999999     TO KO-PREMISE-NO              
PERF               ELSE                                                 
                      MOVE WS-PREMISE-NO TO KO-PREMISE-NO               
PERF               END-IF                                               
                   PERFORM 2600-SELECT-PREMISE  THRU 2600-EXIT          
               WHEN 'U'                                                 
                   MOVE WS-COMM-ID   TO KO-COMMUNICATION-ID             
                   PERFORM 2700-SELECT-COMM-ID  THRU 2700-EXIT          
               WHEN 'Z'                                                 
                   MOVE WS-ACCOUNT-NO TO KO-ACCOUNT-NO                  
                   MOVE WS-CUSTOMER-NO TO KO-CUSTOMER-NO                
                   PERFORM 2800-MAX-COMM-ID  THRU 2800-EXIT             
                   PERFORM 2700-SELECT-COMM-ID  THRU 2700-EXIT          
               WHEN OTHER                                               
                   MOVE  1        TO RS-RETURN-CODE                     
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
           END-EVALUATE.                                                
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2400-SELECT-CUSTOMER                                           *        
      *      CALLS      2410-OPEN-CUSTOMER-CURSOR                      *        
      *                 2420-FETCH-CUSTOMER-CURSOR                     *        
      *                 2430-CLOSE-CUSTOMER-CURSOR                     *        
      *                 2440-PROCESS-ROWS                              *        
      *                                                                *        
      *     RETRIEVES COMMUNICATION DATA BY CUSTOMER NO                *        
      ******************************************************************        
                                                                        
       2400-SELECT-CUSTOMER.                                            
                                                                        
           MOVE '2400'              TO ACTIVE-PARAGRAPH.                
      ***  SEE HOW MANY ROWS EXIST FOR THIS CRITERIA                            
           PERFORM 2925-COMM-COUNT  THRU 2925-EXIT.                     
           PERFORM 2410-OPEN-CUSTOMER-CURSOR THRU 2410-EXIT.            
           PERFORM 2420-FETCH-CUSTOMER-CURSOR THRU 2420-EXIT            
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T28151***  IF THIS IS THE INITIAL CALL LOOK FOR PREMISE RED FLAGS               
T28151        IF PARM-FR-DATE = '1/1/1991'                              
T28151           MOVE 'Y'         TO WS-RED-FLAG-PREM                   
              ELSE                                                      
                 MOVE  100      TO RS-RETURN-CODE                       
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
              END-IF                                                    
           ELSE                                                         
              PERFORM 2440-PROCESS-ROWS     THRU 2440-EXIT              
                 UNTIL (WS-ROW-CT > WS-MAX-RETURN-ROWS                  
                   AND  PARM-FR-DATE NOT EQUAL '1/1/1991')              
                    OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           END-IF                                                       
                                                                        
           PERFORM 2430-CLOSE-CUSTOMER-CURSOR THRU 2430-EXIT.           
                                                                        
T28151***  IF THIS CALLS LOOK FOR PREMISE RED FLAGS                             
T28151***  WHEN THE COMMUNICATION PANEL IS INITIALLY OPENED                     
T28151     IF PARM-FR-DATE = '1/1/1991' OR                              
T28151        WS-RED-FLAG-PREM EQUAL 'Y'                                
PERF          IF WS-CUSTOMER-NO = ZEROES                                
PERF             MOVE 9999999999     TO KO-CUSTOMER-NO                  
PERF          ELSE                                                      
                 MOVE WS-CUSTOMER-NO TO KO-CUSTOMER-NO                  
PERF          END-IF                                                    
PERF          IF WS-PREMISE-NO = ZEROES                                 
PERF             MOVE 9999999999     TO KO-PREMISE-NO                   
PERF          ELSE                                                      
                 MOVE WS-PREMISE-NO  TO KO-PREMISE-NO                   
PERF          END-IF                                                    
T28151        PERFORM 2660-SEL-PREM-FLAG THRU 2660-EXIT                 
              IF WS-ROW-CT = 0 THEN                                     
                 MOVE  100      TO RS-RETURN-CODE                       
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
              END-IF                                                    
T28151     END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2410-OPEN-CUSTOMER-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       2410-OPEN-CUSTOMER-CURSOR.                                       
                                                                        
           MOVE '2410'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN KO-COMM-DATA-CUST                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE PARM-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2420-FETCH-CUSTOMER-CURSOR                                     *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       2420-FETCH-CUSTOMER-CURSOR.                                      
                                                                        
           MOVE '2420'        TO ACTIVE-PARAGRAPH.                      
           MOVE SPACES TO KO-INITIAL-COMMENT-TX-TEXT.                   
                                                                        
           EXEC SQL                                                     
              FETCH KO-COMM-DATA-CUST                                   
               INTO :KO-COMMUNICATION-ID,                               
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    :KO-RED-FLAG-EXPIRE-DT :WS-RED-FLG-NULL-IND,         
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    :KO-CALL-END-TIME :WS-CALL-NULL-IND,                 
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-RESPONSE-REASON-CD,                             
                    :KO-RESPONSE-TYPE-CD,                               
                    :KO-SOLICITATION-CD,                                
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    GO TO 2420-EXIT                                     
               WHEN NOT-FOUND                                           
                    GO TO 2420-EXIT                                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_COMM-ID'        TO TABLE-1                
                    MOVE 'CUSTOMER-NO'        TO TABLE-ELEMENT-1        
                    MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2430-CLOSE-CUSTOMER-CURSOR                                     *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       2430-CLOSE-CUSTOMER-CURSOR.                                      
                                                                        
           MOVE '2430'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE KO-COMM-DATA-CUST                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE PARM-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2430-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2440-PROCESS-ROWS                                              *        
      *     CALLS  8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE BACK.  THAT IS, THERE ARE NO          *        
      *     TRANSACTION HISTORY SUMMARY ROWS.                          *        
      ******************************************************************        
                                                                        
       2440-PROCESS-ROWS.                                               
                                                                        
           IF KO-COMM-ASSOC-CD = 'P' THEN                               
               IF KO-PREMISE-NO NOT = WS-PREMISE-NO                     
                   PERFORM 2420-FETCH-CUSTOMER-CURSOR                   
                      THRU 2420-EXIT                                    
                   GO TO 2440-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
                                                                        
      ***  THE ONLY TIME YOU CAN HAVE 51 ROWS IN THIS LOOK IS IF                
      ***  THIS IS WHEN THE PANEL IS INITIALLY OPENED AND THE PARM              
      ***  DATE IS 1/1/1991.  IN THIS CASE WE ARE GOING TO CONTINUE             
      ***  PROCESSING UNTIL ALL OF THE RED FLAGS ARE RETURNED.                  
                                                                        
           MOVE         'N'   TO WS-SKIP-ROW.                           
                                                                        
           IF WS-ROW-CT < 31                                            
              ADD +1 TO WS-ROW-CT                                       
           ELSE                                                         
              IF PARM-FR-DATE = '1/1/1991'                              
A02884           IF KO-RED-FLAG-IND = 'N' OR                            
A02884              KO-RED-FLAG-IND = SPACES                            
                    MOVE 'Y' TO WS-SKIP-ROW                             
                 ELSE                                                   
                    IF WS-RED-FLG-NULL-IND NOT EQUAL -1                 
                       MOVE KO-RED-FLAG-EXPIRE-DT   TO                  
                            WS-HOLD-TIMESTAMP                           
                       IF WS-RED-FL-YR < WS-YEAR                        
                          MOVE 'Y' TO WS-SKIP-ROW                       
                       ELSE                                             
                          IF WS-RED-FL-YR = WS-YEAR                     
                             IF WS-RED-FL-MO < WS-MONTH                 
                                MOVE 'Y'  TO  WS-SKIP-ROW               
                             ELSE                                       
T30461                        IF WS-RED-FL-MO = WS-MONTH                
                                IF WS-RED-FL-DY < WS-DAY                
                                   MOVE 'Y'  TO  WS-SKIP-ROW            
                                END-IF                                  
                              END-IF                                    
                             END-IF                                     
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'Y' TO WS-SKIP-ROW                                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-SKIP-ROW = 'Y'                                         
              PERFORM 2420-FETCH-CUSTOMER-CURSOR                        
                 THRU 2420-EXIT                                         
              GO TO 2440-EXIT                                           
           END-IF.                                                      
                                                                        
           IF KO-PREMISE-NO NOT = 0                                     
               PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT               
           ELSE                                                         
               IF KO-ACCOUNT-NO NOT = 0                                 
                   PERFORM 2550-SELECT-ACCOUNT THRU 2550-EXIT           
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                       PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT       
                   ELSE                                                 
                       MOVE SPACES TO RS-ADDRESS                        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
      *    IF KO-PREMISE-NO NOT = 0                                             
      *        PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT                       
      *    ELSE                                                                 
      *        MOVE SPACES TO RS-ADDRESS                                        
      *    END-IF.                                                              
                                                                        
           PERFORM 2910-SELECT-COMMENTS THRU 2910-EXIT.                 
           PERFORM 2920-SELECT-PROFILE  THRU 2920-EXIT.                 
           PERFORM 2900-MOVE-TO-RETURN-FIELDS THRU 2900-EXIT.           
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           PERFORM 2420-FETCH-CUSTOMER-CURSOR THRU 2420-EXIT.           
                                                                        
                                                                        
       2440-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2500-SELECT-ACCOUNT                                            *        
      *      CALLS      2510-OPEN-ACCOUNT-CURSOR                       *        
      *                 2520-FETCH-ACCOUNT-CURSOR                      *        
      *                 2530-CLOSE-ACCOUNT-CURSOR                      *        
      *                 2540-PROCESS-ROWS                              *        
      *                                                                *        
      *     RETRIEVES COMMUNICATION DATA BY ACCOUNT NO                 *        
      ******************************************************************        
                                                                        
       2500-SELECT-ACCOUNT.                                             
                                                                        
           MOVE '2500'              TO ACTIVE-PARAGRAPH.                
           PERFORM 2510-OPEN-ACCOUNT-CURSOR THRU 2510-EXIT.             
           PERFORM 2520-FETCH-ACCOUNT-CURSOR THRU 2520-EXIT             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              MOVE  100      TO RS-RETURN-CODE                          
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           ELSE                                                         
              PERFORM 2540-PROCESS-ROWS     THRU 2540-EXIT              
                 UNTIL WS-ROW-CT > WS-MAX-RETURN-ROWS                   
                    OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           END-IF                                                       
           PERFORM 2530-CLOSE-ACCOUNT-CURSOR THRU 2530-EXIT.            
                                                                        
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2510-OPEN-ACCOUNT-CURSOR                                       *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       2510-OPEN-ACCOUNT-CURSOR.                                        
                                                                        
           MOVE '2510'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN KO-COMM-DATA-ACCT                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2520-FETCH-ACCOUNT-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       2520-FETCH-ACCOUNT-CURSOR.                                       
                                                                        
           MOVE '2520'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE SPACES TO KO-INITIAL-COMMENT-TX-TEXT.                   
           EXEC SQL                                                     
              FETCH KO-COMM-DATA-ACCT                                   
               INTO :KO-COMMUNICATION-ID,                               
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    :KO-RED-FLAG-EXPIRE-DT :WS-RED-FLG-NULL-IND,         
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    :KO-CALL-END-TIME :WS-CALL-NULL-IND,                 
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-RESPONSE-REASON-CD,                             
                    :KO-RESPONSE-TYPE-CD,                               
                    :KO-SOLICITATION-CD,                                
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    GO TO 2520-EXIT                                     
               WHEN NOT-FOUND                                           
                    GO TO 2520-EXIT                                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_COMM-ID'        TO TABLE-1                
                    MOVE 'ACCOUNT-NO'         TO TABLE-ELEMENT-1        
                    MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       2520-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2530-CLOSE-ACCOUNT-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       2530-CLOSE-ACCOUNT-CURSOR.                                       
                                                                        
           MOVE '2530'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE KO-COMM-DATA-ACCT                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2530-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2540-PROCESS-ROWS                                              *        
      *     CALLS  8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE BACK.  THAT IS, THERE ARE NO          *        
      *     TRANSACTION HISTORY SUMMARY ROWS.                          *        
      ******************************************************************        
                                                                        
       2540-PROCESS-ROWS.                                               
                                                                        
                                                                        
           ADD +1 TO WS-ROW-CT.                                         
                                                                        
           IF KO-PREMISE-NO NOT = 0                                     
               PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT               
           ELSE                                                         
               IF KO-ACCOUNT-NO NOT = 0                                 
                   PERFORM 2550-SELECT-ACCOUNT THRU 2550-EXIT           
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                       PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT       
                   ELSE                                                 
                       MOVE SPACES TO RS-ADDRESS                        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 2910-SELECT-COMMENTS THRU 2910-EXIT.                 
           PERFORM 2920-SELECT-PROFILE  THRU 2920-EXIT.                 
           PERFORM 2900-MOVE-TO-RETURN-FIELDS THRU 2900-EXIT.           
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           PERFORM 2520-FETCH-ACCOUNT-CURSOR THRU 2520-EXIT.            
                                                                        
                                                                        
       2540-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2550-SELECT-ACCOUNT                                            *        
      *                                                                *        
      *     CALLED FROM 2540-PROCESS-ROWS                              *        
      *                                                                *        
      *     SELECT PREMISE_NO FROM CSS_ACCOUNT                         *        
      ******************************************************************        
                                                                        
       2550-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
               SELECT PREMISE_NO                                        
                INTO  :AT-PREMISE-NO                                    
                FROM  CSS_ACCOUNT WITH(READUNCOMMITTED)                         
                WHERE ACCOUNT_NO = :KO-ACCOUNT-NO                       
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT PREMISE_NO                                                
MFA-TR*         INTO  :AT-PREMISE-NO                                            
MFA-TR*         FROM  CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :KO-ACCOUNT-NO                               
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              MOVE AT-PREMISE-NO TO KO-PREMISE-NO                       
C35615*                             WS-PREMISE-NO                               
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                  MOVE SPACES TO RS-ADDRESS                             
                  GO TO 2550-EXIT                                       
              ELSE                                                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ACCOUNT'              TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE KO-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2600-SELECT-PREMISE                                            *        
      *      CALLS      2610-OPEN-PREMISE-CURSOR                       *        
      *                 2620-FETCH-PREMISE-CURSOR                      *        
      *                 2630-CLOSE-PREMISE-CURSOR                      *        
      *                 2640-PROCESS-ROWS                              *        
      *                                                                *        
      *     RETRIEVES COMMUNICATION DATA BY PREMISE NO                 *        
      ******************************************************************        
                                                                        
       2600-SELECT-PREMISE.                                             
                                                                        
           MOVE '2600'              TO ACTIVE-PARAGRAPH.                
           PERFORM 2610-OPEN-PREMISE-CURSOR THRU 2610-EXIT.             
           PERFORM 2620-FETCH-PREMISE-CURSOR THRU 2620-EXIT             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
                 MOVE  100      TO RS-RETURN-CODE                       
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
           ELSE                                                         
              PERFORM 2640-PROCESS-ROWS     THRU 2640-EXIT              
                 UNTIL WS-ROW-CT > WS-MAX-RETURN-ROWS                   
                    OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           END-IF                                                       
           PERFORM 2630-CLOSE-PREMISE-CURSOR THRU 2630-EXIT.            
                                                                        
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2610-OPEN-PREMISE-CURSOR                                       *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       2610-OPEN-PREMISE-CURSOR.                                        
                                                                        
           MOVE '2610'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN KO-COMM-DATA-PREM                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-PREMISE-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2620-FETCH-PREMISE-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       2620-FETCH-PREMISE-CURSOR.                                       
                                                                        
           MOVE '2620'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE SPACES TO KO-INITIAL-COMMENT-TX-TEXT.                   
           EXEC SQL                                                     
              FETCH KO-COMM-DATA-PREM                                   
               INTO :KO-COMMUNICATION-ID,                               
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    :KO-RED-FLAG-EXPIRE-DT :WS-RED-FLG-NULL-IND,         
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    :KO-CALL-END-TIME :WS-CALL-NULL-IND,                 
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-RESPONSE-REASON-CD,                             
                    :KO-RESPONSE-TYPE-CD,                               
                    :KO-SOLICITATION-CD,                                
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    GO TO 2620-EXIT                                     
               WHEN NOT-FOUND                                           
                    GO TO 2620-EXIT                                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_COMM-ID'        TO TABLE-1                
                    MOVE 'PREMISE-NO'         TO TABLE-ELEMENT-1        
                    MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       2620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2630-CLOSE-PREMISE-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       2630-CLOSE-PREMISE-CURSOR.                                       
                                                                        
           MOVE '2630'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE KO-COMM-DATA-PREM                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2630-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2640-PROCESS-ROWS                                              *        
      *     CALLS  8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE BACK.  THAT IS, THERE ARE NO          *        
      *     TRANSACTION HISTORY SUMMARY ROWS.                          *        
      ******************************************************************        
                                                                        
       2640-PROCESS-ROWS.                                               
                                                                        
           ADD +1 TO WS-ROW-CT.                                         
                                                                        
           IF KO-PREMISE-NO NOT = 0                                     
               PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT               
           ELSE                                                         
               MOVE SPACES TO RS-ADDRESS                                
           END-IF.                                                      
                                                                        
           PERFORM 2910-SELECT-COMMENTS THRU 2910-EXIT.                 
           PERFORM 2920-SELECT-PROFILE  THRU 2920-EXIT.                 
           PERFORM 2900-MOVE-TO-RETURN-FIELDS THRU 2900-EXIT.           
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           PERFORM 2620-FETCH-PREMISE-CURSOR THRU 2620-EXIT.            
                                                                        
                                                                        
       2640-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2660-SEL-PREM-FLAG                                             *        
      *      CALLS      2661-OPEN-PREMISE-CURSOR                       *        
      *                 2662-FETCH-PREMISE-CURSOR                      *        
      *                 2663-CLOSE-PREMISE-CURSOR                      *        
      *                 2664-PROCESS-ROWS                              *        
      *                                                                *        
      *     RETRIEVES COMMUNICATION DATA BY PREMISE NO                 *        
      ******************************************************************        
                                                                        
       2660-SEL-PREM-FLAG.                                              
                                                                        
           MOVE '2660'              TO ACTIVE-PARAGRAPH.                
           PERFORM 2661-OPEN-PREMISE-CURSOR THRU 2661-EXIT.             
           PERFORM 2662-FETCH-PREMISE-CURSOR THRU 2662-EXIT             
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              NEXT SENTENCE                                             
           ELSE                                                         
T30906        MOVE 0 TO WS-ROW-CT                                       
              PERFORM 2664-PROCESS-ROWS     THRU 2664-EXIT              
                 UNTIL WS-ROW-CT > WS-MAX-RETURN-ROWS                   
                    OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           END-IF                                                       
           PERFORM 2663-CLOSE-PREMISE-CURSOR THRU 2663-EXIT.            
                                                                        
                                                                        
       2660-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2661-OPEN-PREMISE-CURSOR                                       *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       2661-OPEN-PREMISE-CURSOR.                                        
                                                                        
           MOVE '2661'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN KO-COMM-PREM-FLAG                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-PREMISE-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2661-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2662-FETCH-PREMISE-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       2662-FETCH-PREMISE-CURSOR.                                       
                                                                        
           MOVE '2662'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE SPACES TO KO-INITIAL-COMMENT-TX-TEXT.                   
           EXEC SQL                                                     
              FETCH KO-COMM-PREM-FLAG                                   
               INTO :KO-COMMUNICATION-ID,                               
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    :KO-RED-FLAG-EXPIRE-DT :WS-RED-FLG-NULL-IND,         
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    :KO-CALL-END-TIME :WS-CALL-NULL-IND,                 
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-RESPONSE-REASON-CD,                             
                    :KO-RESPONSE-TYPE-CD,                               
                    :KO-SOLICITATION-CD,                                
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    GO TO 2662-EXIT                                     
               WHEN NOT-FOUND                                           
                    GO TO 2662-EXIT                                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_COMM-ID'        TO TABLE-1                
                    MOVE 'PREMISE-NO'         TO TABLE-ELEMENT-1        
                    MOVE PARM-PREMISE-NO      TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       2662-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2663-CLOSE-PREMISE-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       2663-CLOSE-PREMISE-CURSOR.                                       
                                                                        
           MOVE '2663'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE KO-COMM-PREM-FLAG                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2663-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2664-PROCESS-ROWS                                              *        
      *     CALLS  8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE BACK.  THAT IS, THERE ARE NO          *        
      *     TRANSACTION HISTORY SUMMARY ROWS.                          *        
      ******************************************************************        
                                                                        
       2664-PROCESS-ROWS.                                               
                                                                        
           ADD +1 TO WS-ROW-CT.                                         
                                                                        
           IF KO-PREMISE-NO NOT = 0                                     
               PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT               
           ELSE                                                         
               MOVE SPACES TO RS-ADDRESS                                
           END-IF.                                                      
                                                                        
           PERFORM 2910-SELECT-COMMENTS THRU 2910-EXIT.                 
           PERFORM 2920-SELECT-PROFILE  THRU 2920-EXIT.                 
           PERFORM 2900-MOVE-TO-RETURN-FIELDS THRU 2900-EXIT.           
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           PERFORM 2662-FETCH-PREMISE-CURSOR THRU 2662-EXIT.            
                                                                        
                                                                        
       2664-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2700-SELECT-COMM-ID                                            *        
      *      CALLS      2610-OPEN-PREMISE-CURSOR                       *        
      *                 2620-FETCH-PREMISE-CURSOR                      *        
      *                 2630-CLOSE-PREMISE-CURSOR                      *        
      *                 2640-PROCESS-ROWS                              *        
      *                                                                *        
      *     RETRIEVES COMMUNICATION DATA BY COMMUNICATION ID           *        
      ******************************************************************        
                                                                        
       2700-SELECT-COMM-ID.                                             
                                                                        
           MOVE '2700'              TO ACTIVE-PARAGRAPH.                
           EXEC SQL                                                     
             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CD.COMMUNICATION_ID, 121), ' ', '-'), ':', '.') 
           COMMUNICATION_ID,                                
                    CD.ACCOUNT_NO,                                      
                    CD.CUSTOMER_NO,                                     
                    CD.PREMISE_NO,                                      
                    CD.COMPANY_NO,                                      
                    CD.RED_FLAG_IND,                                    
                    REPLACE(REPLACE(CONVERT(CHAR(26), 
           CD.RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                              
                    CD.COMM_METHOD,                                     
                    CD.COMM_DIRECTION,                                  
                    CD.COMM_TYPE_CD,                                    
                    CD.COMM_SUBTYPE_CODE,                               
                    CD.USER_ID_ORIG,                                    
                    CD.CONTACT_NAME,                                    
                    CD.PROMOTION_ID,                                    
                    CD.PSC_COMPLIANCE_IND,                              
                    CD.CALL_ORIGIN_ID,                                  
                    REPLACE(REPLACE(CONVERT(CHAR(26), CD.CALL_END_TIME
           , 121), ' ', '-'), ':', '.') CALL_END_TIME,                         
                    CD.NUMBER_TRANSFERS,                                
                    CD.HOLD_TIME,                                       
                    CD.QUEUE_TIME,                                      
                    CD.SCREEN_POP_IND,                                  
                    CD.TOTAL_CALL_TIME,                                 
                    CD.INITIAL_COMMENT_TX,                              
                    CD.RESPONSE_REASON_CD,                              
                    CD.RESPONSE_TYPE_CD,                                
                    CD.SOLICITATION_CD,                                 
                    CD.COMM_ASSOC_CD,                                   
                    CD.COMPLAINT_FL                                     
             INTO   :KO-COMMUNICATION-ID,                               
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    :KO-RED-FLAG-EXPIRE-DT :WS-RED-FLG-NULL-IND,         
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    :KO-CALL-END-TIME :WS-CALL-NULL-IND,                 
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX :WS-COMMENT-NULL-IND,         
                    :KO-RESPONSE-REASON-CD,                             
                    :KO-RESPONSE-TYPE-CD,                               
                    :KO-SOLICITATION-CD,                                
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL                                    
             FROM   CSS_COMM_DATA CD WITH(READUNCOMMITTED)                      
             WHERE  CD.COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                          :PARM-COMM-ID
              )                 
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CD.COMMUNICATION_ID,                                        
MFA-TR*             CD.ACCOUNT_NO,                                              
MFA-TR*             CD.CUSTOMER_NO,                                             
MFA-TR*             CD.PREMISE_NO,                                              
MFA-TR*             CD.COMPANY_NO,                                              
MFA-TR*             CD.RED_FLAG_IND,                                            
MFA-TR*             CD.RED_FLAG_EXPIRE_DT,                                      
MFA-TR*             CD.COMM_METHOD,                                             
MFA-TR*             CD.COMM_DIRECTION,                                          
MFA-TR*             CD.COMM_TYPE_CD,                                            
MFA-TR*             CD.COMM_SUBTYPE_CODE,                                       
MFA-TR*             CD.USER_ID_ORIG,                                            
MFA-TR*             CD.CONTACT_NAME,                                            
MFA-TR*             CD.PROMOTION_ID,                                            
MFA-TR*             CD.PSC_COMPLIANCE_IND,                                      
MFA-TR*             CD.CALL_ORIGIN_ID,                                          
MFA-TR*             CD.CALL_END_TIME,                                           
MFA-TR*             CD.NUMBER_TRANSFERS,                                        
MFA-TR*             CD.HOLD_TIME,                                               
MFA-TR*             CD.QUEUE_TIME,                                              
MFA-TR*             CD.SCREEN_POP_IND,                                          
MFA-TR*             CD.TOTAL_CALL_TIME,                                         
MFA-TR*             CD.INITIAL_COMMENT_TX,                                      
MFA-TR*             CD.RESPONSE_REASON_CD,                                      
MFA-TR*             CD.RESPONSE_TYPE_CD,                                        
MFA-TR*             CD.SOLICITATION_CD,                                         
MFA-TR*             CD.COMM_ASSOC_CD,                                           
MFA-TR*             CD.COMPLAINT_FL                                             
MFA-TR*      INTO   :KO-COMMUNICATION-ID,                                       
MFA-TR*             :KO-ACCOUNT-NO,                                             
MFA-TR*             :KO-CUSTOMER-NO,                                            
MFA-TR*             :KO-PREMISE-NO,                                             
MFA-TR*             :KO-COMPANY-NO,                                             
MFA-TR*             :KO-RED-FLAG-IND,                                           
MFA-TR*             :KO-RED-FLAG-EXPIRE-DT:WS-RED-FLG-NULL-IND,                 
MFA-TR*             :KO-COMM-METHOD,                                            
MFA-TR*             :KO-COMM-DIRECTION,                                         
MFA-TR*             :KO-COMM-TYPE-CD,                                           
MFA-TR*             :KO-COMM-SUBTYPE-CODE,                                      
MFA-TR*             :KO-USER-ID-ORIG,                                           
MFA-TR*             :KO-CONTACT-NAME,                                           
MFA-TR*             :KO-PROMOTION-ID,                                           
MFA-TR*             :KO-PSC-COMPLIANCE-IND,                                     
MFA-TR*             :KO-CALL-ORIGIN-ID,                                         
MFA-TR*             :KO-CALL-END-TIME:WS-CALL-NULL-IND,                         
MFA-TR*             :KO-NUMBER-TRANSFERS,                                       
MFA-TR*             :KO-HOLD-TIME,                                              
MFA-TR*             :KO-QUEUE-TIME,                                             
MFA-TR*             :KO-SCREEN-POP-IND,                                         
MFA-TR*             :KO-TOTAL-CALL-TIME,                                        
MFA-TR*             :KO-INITIAL-COMMENT-TX:WS-COMMENT-NULL-IND,                 
MFA-TR*             :KO-RESPONSE-REASON-CD,                                     
MFA-TR*             :KO-RESPONSE-TYPE-CD,                                       
MFA-TR*             :KO-SOLICITATION-CD,                                        
MFA-TR*             :KO-COMM-ASSOC-CD,                                          
MFA-TR*             :KO-COMPLAINT-FL                                            
MFA-TR*      FROM   CSS_COMM_DATA CD                                            
MFA-TR*      WHERE  CD.COMMUNICATION_ID = :PARM-COMM-ID                         
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE  100      TO RS-RETURN-CODE                       
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 GO TO 2700-EXIT                                        
              END-IF                                                    
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'COMMUNICATION_ID'         TO TABLE-ELEMENT-1        
              MOVE PARM-COMM-ID               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           IF KO-PREMISE-NO NOT = 0                                     
               PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT               
           ELSE                                                         
               MOVE SPACES TO RS-ADDRESS                                
           END-IF.                                                      
                                                                        
           PERFORM 2910-SELECT-COMMENTS THRU 2910-EXIT.                 
           PERFORM 2920-SELECT-PROFILE  THRU 2920-EXIT.                 
           PERFORM 2900-MOVE-TO-RETURN-FIELDS THRU 2900-EXIT.           
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2800-SELECT-COMM-ID                                            *        
      *     RETRIEVES MAX COMM DATA BASED ON PARMS                     *        
      ******************************************************************        
                                                                        
       2800-MAX-COMM-ID.                                                
                                                                        
           MOVE '2800'              TO ACTIVE-PARAGRAPH.                
           EXEC SQL                                                     
             SELECT REPLACE(REPLACE(CONVERT(CHAR(26), MAX(
           COMMUNICATION_ID), 121), ' ', '-'), ':', '.')                       
               INTO :PARM-COMM-ID                                       
             FROM   CSS_COMM_DATA CD WITH(READUNCOMMITTED)                      
             WHERE  ACCOUNT_NO             =  :KO-ACCOUNT-NO            
               AND  CUSTOMER_NO            =  :KO-CUSTOMER-NO           
               AND  COMM_TYPE_CD           =  :WS-COMM-TYPE-CD          
               AND  COMM_SUBTYPE_CODE      =  :WS-COMM-SUBTYPE-CD       
               AND  USER_ID_ORIG           =  :WS-USER-ID               
               AND  COMMUNICATION_ID BETWEEN                            
                    CIS.CHAR2TIMESTAMP(:WS-FR-DATE) AND 
              CIS.CHAR2TIMESTAMP(:WS-TO-DATE)                         
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(COMMUNICATION_ID)                                       
MFA-TR*        INTO :PARM-COMM-ID                                               
MFA-TR*      FROM   CSS_COMM_DATA CD                                            
MFA-TR*      WHERE  ACCOUNT_NO             =  :KO-ACCOUNT-NO                    
MFA-TR*        AND  CUSTOMER_NO            =  :KO-CUSTOMER-NO                   
MFA-TR*        AND  COMM_TYPE_CD           =  :WS-COMM-TYPE-CD                  
MFA-TR*        AND  COMM_SUBTYPE_CODE      =  :WS-COMM-SUBTYPE-CD               
MFA-TR*        AND  USER_ID_ORIG           =  :WS-USER-ID                       
MFA-TR*        AND  COMMUNICATION_ID BETWEEN                                    
MFA-TR*             :WS-FR-DATE AND :WS-TO-DATE                                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE  100      TO RS-RETURN-CODE                       
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
                 GO TO 2700-EXIT                                        
              END-IF                                                    
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2900-MOVE-TO-RETURN-FIELDS.                                    *        
      *                                                                *        
      *     CALLED FROM 2440-PROCESS-ROWS                              *        
      *                 2540-PROCESS-ROWS                              *        
      *                 2640-PROCESS-ROWS                              *        
      *                 2700-SELECT-COMM-ID                            *        
      *                                                                *        
      *     MOVE FIELDS TO COLUMNS TO BE RETURN.                       *        
      ******************************************************************        
                                                                        
       2900-MOVE-TO-RETURN-FIELDS.                                      
                                                                        
           COMPUTE RS-TOTAL-COMMENTS = WS-TOTAL-COMMENTS + 1.           
           MOVE ZERO TO RS-RETURN-CODE.                                 
           MOVE KO-COMMUNICATION-ID TO RS-COMM-ID.                      
           MOVE KO-ACCOUNT-NO TO RS-ACCOUNT-NO.                         
           MOVE KO-CUSTOMER-NO TO RS-CUSTOMER-NO.                       
           MOVE KO-PREMISE-NO TO RS-PREMISE-NO,                         
           MOVE KO-COMPANY-NO TO RS-COMPANY-NO.                         
           MOVE KO-RED-FLAG-IND TO RS-RED-FLAG-IND.                     
                                                                        
           IF WS-RED-FLG-NULL-IND < 0                                   
               MOVE SPACES TO RS-RED-FLAG-EXPIRE-DT                     
           ELSE                                                         
               MOVE KO-RED-FLAG-EXPIRE-DT TO                            
                    RS-RED-FLAG-EXPIRE-DT                               
           END-IF.                                                      
           MOVE KO-COMM-METHOD TO RS-COMM-METHOD.                       
           MOVE KO-COMM-DIRECTION TO RS-COMM-DIRECTION.                 
           MOVE KO-COMM-TYPE-CD TO RS-COMM-TYPE-CD.                     
           MOVE KO-COMM-SUBTYPE-CODE TO RS-COMM-SUBTYPE-CODE.           
           MOVE KO-USER-ID-ORIG TO RS-USER-ID-ORIG.                     
           MOVE KO-CONTACT-NAME TO RS-CONTACT-NAME.                     
           MOVE KO-PROMOTION-ID TO RS-PROMOTION-ID.                     
           MOVE KO-PSC-COMPLIANCE-IND TO RS-PSC-COMPLIANCE-IND.         
           MOVE KO-CALL-ORIGIN-ID TO RS-CALL-ORIGIN-ID.                 
           IF WS-CALL-NULL-IND < 0                                      
               MOVE SPACES TO RS-CALL-END-TIME                          
           ELSE                                                         
               MOVE KO-CALL-END-TIME TO RS-CALL-END-TIME                
           END-IF.                                                      
           MOVE KO-NUMBER-TRANSFERS TO RS-NUMBER-TRANSFERS.             
           MOVE KO-HOLD-TIME TO RS-HOLD-TIME.                           
           MOVE KO-QUEUE-TIME TO RS-QUEUE-TIME.                         
           MOVE WS-TOT-COMMUNICATIONS TO RS-QUEUE-TIME.                 
           MOVE KO-SCREEN-POP-IND TO RS-SCREEN-POP-IND.                 
           MOVE KO-TOTAL-CALL-TIME TO RS-TOTAL-CALL-TIME.               
           IF KO-INITIAL-COMMENT-TX-LEN = ZERO                          
               MOVE SPACES TO RS-INITIAL-COMMENT-TE                     
           ELSE                                                         
               MOVE KO-INITIAL-COMMENT-TX-TEXT TO                       
                    RS-INITIAL-COMMENT-TE                               
           END-IF.                                                      
           MOVE KO-RESPONSE-REASON-CD TO RS-RESPONSE-REASON-CD.         
           MOVE KO-RESPONSE-TYPE-CD TO RS-RESPONSE-TYPE-CD.             
           MOVE KO-SOLICITATION-CD TO RS-SOLICITATION-CD.               
           MOVE KO-COMM-ASSOC-CD TO RS-COMM-ASSOC-CD.                   
           MOVE KO-COMPLAINT-FL TO RS-COMPLAINT-FL.                     
           MOVE WS-LAST-NAME TO RS-LAST-NAME.                           
           MOVE WS-FIRST-NAME TO RS-FIRST-NAME.                         
           MOVE WS-RESP-AREA TO RS-RESP-AREA.                           
      *    IF KO-COMM-ASSOC-CD = 'C'                                            
      *        MOVE SPACES TO RS-ADDRESS                                        
      *    END-IF.                                                              
                                                                        
       2900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2910-SELECT-COMMENTS                                           *        
      *                                                                *        
      *     CALLED FROM 2440-PROCESS-ROWS                              *        
      *                 2540-PROCESS-ROWS                              *        
      *                 2640-PROCESS-ROWS                              *        
      *                                                                *        
      *     SELECT CURRENT COMMENTS FOR EACH COMMUNICATION             *        
      ******************************************************************        
                                                                        
       2910-SELECT-COMMENTS.                                            
                                                                        
           PERFORM 2911-OPEN-COMMENT-CURSOR THRU 2911-EXIT.             
           MOVE SPACES TO RS-CURRENT-COMMENTS.                          
           PERFORM 2912-FETCH-COMMENT-CURSOR THRU 2912-EXIT.            
           PERFORM 2913-CLOSE-COMMENT-CURSOR THRU 2913-EXIT.            
                                                                        
                                                                        
                                                                        
       2910-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2911-OPEN-COMMENT-CURSOR                                       *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       2911-OPEN-COMMENT-CURSOR.                                        
                                                                        
           MOVE '2911'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN KN-COMM-COMMENT                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_COMMENT'         TO TABLE-1                
              MOVE 'CUMMUNICATION_ID'         TO TABLE-ELEMENT-1        
              MOVE KO-COMMUNICATION-ID        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2911-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2912-FETCH-COMMENT-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       2912-FETCH-COMMENT-CURSOR.                                       
                                                                        
           MOVE '2912'        TO ACTIVE-PARAGRAPH.                      
                                                                        
           MOVE SPACES TO KN-COMMENT-TX.                                
                                                                        
           EXEC SQL                                                     
              FETCH KN-COMM-COMMENT                                     
               INTO :KN-COMMENT-TX :WS-COMMENT-TX-NULL-IND,              
                    :KN-USER-ID,                                        
                    :KN-UPDATE-TS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    IF WS-COMMENT-TX-NULL-IND < 0                       
                       MOVE SPACES TO RS-CURRENT-COMMENTS               
                    ELSE                                                
                       MOVE KN-COMMENT-TX-TEXT TO RS-CURRENT-COMMENTS   
                    END-IF                                              
                    MOVE KN-USER-ID TO RS-USER-ID                       
                    MOVE KN-UPDATE-TS TO RS-UPDATE-TS                   
                    PERFORM 2915-SELECT-TOTAL-COMMENTS THRU             
                            2915-EXIT                                   
               WHEN NOT-FOUND                                           
                    MOVE SPACES TO RS-CURRENT-COMMENTS                  
                    MOVE SPACES TO RS-USER-ID                           
                    MOVE SPACES TO RS-UPDATE-TS                         
                    MOVE ZEROES TO WS-TOTAL-COMMENTS                    
                    MOVE ZEROES TO RS-TOTAL-COMMENTS                    
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_COMM-COMMENT'   TO TABLE-1                
                    MOVE 'COMMUNICATION_ID'   TO TABLE-ELEMENT-1        
                    MOVE KO-COMMUNICATION-ID  TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       2912-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2913-CLOSE-COMMENT-CURSOR                                      *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       2913-CLOSE-COMMENT-CURSOR.                                       
                                                                        
           MOVE '2913'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE KN-COMM-COMMENT                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_COMMENT'         TO TABLE-1                
              MOVE 'COMMUNICATION-ID'         TO TABLE-ELEMENT-1        
              MOVE KO-COMMUNICATION-ID        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2913-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2915-SELECT-TOTAL-COMMENTS                                     *        
      *                                                                *        
      *     CALLED FROM 2910-SELECT-COMMENTS                           *        
      *                 2700-SELECT-COMM-ID                            *        
      *                                                                *        
      *     SELECT TOTAL COMMENTS.                                     *        
      ******************************************************************        
                                                                        
       2915-SELECT-TOTAL-COMMENTS.                                      
                                                                        
           MOVE ZEROES TO WS-TOTAL-COMMENTS.                            
           MOVE ZEROES TO RS-TOTAL-COMMENTS.                            
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-TOTAL-COMMENTS                                
                FROM CSS_COMM_COMMENT WITH(READUNCOMMITTED)                     
               WHERE COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )            
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-TOTAL-COMMENTS                                        
MFA-TR*         FROM CSS_COMM_COMMENT                                           
MFA-TR*        WHERE COMMUNICATION_ID = :KO-COMMUNICATION-ID                    
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                  MOVE ZEROES TO WS-TOTAL-COMMENTS                      
                  GO TO 2915-EXIT                                       
              ELSE                                                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_COMMENT'         TO TABLE-1                
              MOVE 'COMUNICATION_ID'          TO TABLE-ELEMENT-1        
              MOVE KO-COMMUNICATION-ID        TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
                                                                        
       2915-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2920-SELECT-PROFILE                                            *        
      *                                                                *        
      *     CALLED FROM 2440-PROCESS-ROWS                              *        
      *                 2540-PROCESS-ROWS                              *        
      *                 2640-PROCESS-ROWS                              *        
      *                                                                *        
      *     SELECT INFORMATIO FROM CSS_USER_PROFILE                    *        
      ******************************************************************        
                                                                        
       2920-SELECT-PROFILE.                                             
                                                                        
           EXEC SQL                                                     
               SELECT LAST_NAME,                                        
                      FIRST_NAME,                                       
                      RESP_AREA_ID                                      
                INTO  :WS-LAST-NAME,                                    
                      :WS-FIRST-NAME,                                   
                      :WS-RESP-AREA                                     
                FROM  CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :KO-USER-ID-ORIG                        
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_NAME,                                                
MFA-TR*               FIRST_NAME,                                               
MFA-TR*               RESP_AREA_ID                                              
MFA-TR*         INTO  :WS-LAST-NAME,                                            
MFA-TR*               :WS-FIRST-NAME,                                           
MFA-TR*               :WS-RESP-AREA                                             
MFA-TR*         FROM  CSS_USER_PROFILE                                          
MFA-TR*         WHERE USER_ID = :KO-USER-ID-ORIG                                
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                  MOVE SPACES TO RS-CURRENT-COMMENTS                    
                  GO TO 2920-EXIT                                       
              ELSE                                                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
              MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
              MOVE KO-USER-ID-ORIG            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
                                                                        
       2920-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2925-COMM-COUNT                                                *        
      *                                                                *        
      *     CALLED FROM 2440-PROCESS-ROWS                              *        
      *                                                                *        
      *     SELECT INFORMATION FROM CSS_COMM_DATA                      *        
      ******************************************************************        
                                                                        
       2925-COMM-COUNT.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT COUNT(*)                                          
                 INTO :WS-TOT-COMMUNICATIONS                            
                 FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                       
                WHERE CUSTOMER_NO  = :KO-CUSTOMER-NO                    
                  AND COMMUNICATION_ID BETWEEN                          
                      CIS.CHAR2TIMESTAMP(:WS-FR-DATE) AND 
              CIS.CHAR2TIMESTAMP(:WS-TO-DATE)                       
                  AND COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                
                  AND COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD        
                  AND COMM_DIRECTION LIKE :WS-COMM-DIRECTION            
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-TOT-COMMUNICATIONS                                    
MFA-TR*          FROM CSS_COMM_DATA                                             
MFA-TR*         WHERE CUSTOMER_NO  = :KO-CUSTOMER-NO                            
MFA-TR*           AND COMMUNICATION_ID BETWEEN                                  
MFA-TR*               :WS-FR-DATE AND :WS-TO-DATE                               
MFA-TR*           AND COMM_TYPE_CD LIKE :WS-COMM-TYPE-CD                        
MFA-TR*           AND COMM_SUBTYPE_CODE LIKE :WS-COMM-SUBTYPE-CD                
MFA-TR*           AND COMM_DIRECTION LIKE :WS-COMM-DIRECTION                    
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                  MOVE 0      TO WS-TOT-COMMUNICATIONS                  
                  GO TO 2920-EXIT                                       
              ELSE                                                      
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE PARM-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
                                                                        
       2925-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2930-SELECT-PREM-ADDR                                          *        
      *                                                                *        
      *     CALLED FROM 2440-PROCESS-ROWS                              *        
      *                                                                *        
      *     SELECT PREMISE ADDRESS                                     *        
      ******************************************************************        
                                                                        
       2930-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
               SELECT B.ADDR_PREFIX_1,                                  
                      B.ADDR_PREFIX_2,                                  
                      B.HOUSE_NO,                                       
                      B.STREET_LOCATION_1,                              
                      B.STREET_LOCATION_2,                              
                      B.STREET_NAME,                                    
                      B.ADDR_SUFFIX,                                    
                      B.STREET_SUFFIX                                   
                INTO  :DY-ADDR-PREFIX-1,                                
                      :DY-ADDR-PREFIX-2,                                
                      :DY-HOUSE-NO,                                     
                      :DY-STREET-LOCATION-1,                            
                      :DY-STREET-LOCATION-2,                            
                      :DY-STREET-NAME,                                  
                      :DY-ADDR-SUFFIX,                                  
                      :DY-STREET-SUFFIX                                 
                FROM  CSS_PREMISE A WITH(READUNCOMMITTED),                      
                      CSS_ADDR_FORMATTED B WITH(READUNCOMMITTED)                
                WHERE A.PREMISE_NO = :KO-PREMISE-NO                     
                  AND B.ADDRESS_ID = A.ADDRESS_ID                       
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT B.ADDR_PREFIX_1,                                          
MFA-TR*               B.ADDR_PREFIX_2,                                          
MFA-TR*               B.HOUSE_NO,                                               
MFA-TR*               B.STREET_LOCATION_1,                                      
MFA-TR*               B.STREET_LOCATION_2,                                      
MFA-TR*               B.STREET_NAME,                                            
MFA-TR*               B.ADDR_SUFFIX,                                            
MFA-TR*               B.STREET_SUFFIX                                           
MFA-TR*         INTO  :DY-ADDR-PREFIX-1,                                        
MFA-TR*               :DY-ADDR-PREFIX-2,                                        
MFA-TR*               :DY-HOUSE-NO,                                             
MFA-TR*               :DY-STREET-LOCATION-1,                                    
MFA-TR*               :DY-STREET-LOCATION-2,                                    
MFA-TR*               :DY-STREET-NAME,                                          
MFA-TR*               :DY-ADDR-SUFFIX,                                          
MFA-TR*               :DY-STREET-SUFFIX                                         
MFA-TR*         FROM  CSS_PREMISE A,                                            
MFA-TR*               CSS_ADDR_FORMATTED B                                      
MFA-TR*         WHERE A.PREMISE_NO = :KO-PREMISE-NO                             
MFA-TR*           AND B.ADDRESS_ID = A.ADDRESS_ID                               
MFA-TR*           WITH UR                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL OR      
T35927                                          NOT-FOUND               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_ADDR_FORMATED'        TO TABLE-1                
              MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-1        
              MOVE KO-PREMISE-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
T35927     IF WS-ACTIVE-RETURN-CODE =         SUCCESSFUL-CALL           
                                                                        
              MOVE SPACES                     TO WS-EMB-INPUT           
                                                 WS-CMP-TABLE           
              STRING DY-HOUSE-NO,                                       
                     ' ',                                               
                     DY-ADDR-PREFIX-1,                                  
                     ' ',                                               
                     DY-ADDR-PREFIX-2,                                  
                     ' ',                                               
                     DY-STREET-NAME,                                    
                     ' ',                                               
                     DY-STREET-SUFFIX,                                  
                     ' ',                                               
                     DY-ADDR-SUFFIX,                                    
                     ' ',                                               
                     DY-STREET-LOCATION-1,                              
                     ' ',                                               
                     DY-STREET-LOCATION-2                               
              DELIMITED BY SIZE INTO WS-EMB-INPUT                       
              PERFORM 6010-REDUCE-EMBEDDED-SPACES THRU 6010-EXIT        
              MOVE WS-CMP-TABLE TO RS-ADDRESS                           
                                                                        
T35927     ELSE IF WS-ACTIVE-RETURN-CODE =         NOT-FOUND            
T35927        MOVE 'PREMISE HAS BEEN DELETED' TO RS-ADDRESS             
T35927     END-IF
           END-IF.                                                      
                                                                        
       2930-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3000-SELECT-CUST-USER                                          *        
      *      CALLS      3010-OPEN-CUSTOMER-CURSOR                      *        
      *                 3020-FETCH-CUSTOMER-CURSOR                     *        
      *                 3030-CLOSE-CUSTOMER-CURSOR                     *        
      *                 3040-PROCESS-ROWS                              *        
      *                                                                *        
      *     RETRIEVES COMMUNICATION DATA BY CUSTOMER NO                *        
      ******************************************************************        
                                                                        
       3000-SELECT-CUST-USER.                                           
                                                                        
           MOVE '3000'              TO ACTIVE-PARAGRAPH.                
           PERFORM 3010-OPEN-CUST-CURSOR-USER THRU 3010-EXIT.           
           PERFORM 3020-FETCH-CUST-CURSOR-USER THRU 3020-EXIT           
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T28151***  IF THIS IS THE INITIAL CALL LOOK FOR PREMISE RED FLAGS               
T28151        IF PARM-FR-DATE = '1/1/1991'                              
T28151           MOVE 'Y'         TO WS-RED-FLAG-PREM                   
              ELSE                                                      
                 MOVE  100      TO RS-RETURN-CODE                       
                 PERFORM 8100-SEND-RESULT THRU 8100-EXIT                
              END-IF                                                    
           ELSE                                                         
              PERFORM 3040-PROCESS-ROWS     THRU 3040-EXIT              
                 UNTIL (WS-ROW-CT > WS-MAX-RETURN-ROWS                  
                   AND  PARM-FR-DATE NOT EQUAL '1/1/1991')              
                    OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                
           END-IF                                                       
                                                                        
           PERFORM 3030-CLOSE-CUST-CURSOR-USER THRU 3030-EXIT.          
                                                                        
           IF WS-ROW-CT = 0 THEN                                        
              MOVE  100      TO RS-RETURN-CODE                          
              PERFORM 8100-SEND-RESULT THRU 8100-EXIT                   
           END-IF.                                                      
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3010-OPEN-CUST-CURSOR-USER                                     *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *                                                                *        
      *     OPENS THE CURSOR                                           *        
      ******************************************************************        
                                                                        
       3010-OPEN-CUST-CURSOR-USER.                                      
                                                                        
           MOVE '3010'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              OPEN KO-COMM-CUST-USER                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE PARM-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3020-FETCH-CUST-CURSOR-USER                                    *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCHES A ROW FROM THE TABLE                               *        
      ******************************************************************        
                                                                        
       3020-FETCH-CUST-CURSOR-USER.                                     
                                                                        
           MOVE '3020'        TO ACTIVE-PARAGRAPH.                      
           MOVE SPACES TO KO-INITIAL-COMMENT-TX-TEXT.                   
                                                                        
           EXEC SQL                                                     
              FETCH KO-COMM-CUST-USER                                   
               INTO :KO-COMMUNICATION-ID,                               
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    :KO-RED-FLAG-EXPIRE-DT :WS-RED-FLG-NULL-IND,         
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    :KO-CALL-END-TIME :WS-CALL-NULL-IND,                 
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-RESPONSE-REASON-CD,                             
                    :KO-RESPONSE-TYPE-CD,                               
                    :KO-SOLICITATION-CD,                                
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    GO TO 3020-EXIT                                     
               WHEN NOT-FOUND                                           
                    GO TO 3020-EXIT                                     
               WHEN OTHER                                               
                    MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
                    MOVE 'FETCH'              TO ABEND-FUNCTION         
                    MOVE SPACES               TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                    MOVE 'CSS_COMM-ID'        TO TABLE-1                
                    MOVE 'CUSTOMER-NO'        TO TABLE-ELEMENT-1        
                    MOVE PARM-CUSTOMER-NO     TO HOSTVAR-ELEMENT-1      
                    PERFORM 9000-SEND-ERROR-RESULT                      
                       THRU 9000-EXIT                                   
                    PERFORM 9900-SQL-ERROR-ROUTINE                      
                       THRU 9900-EXIT                                   
           END-EVALUATE.                                                
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3030-CLOSE-CUST-CURSOR-USER                                    *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     CLOSES THE CURSOR                                          *        
      ******************************************************************        
                                                                        
       3030-CLOSE-CUST-CURSOR-USER.                                     
                                                                        
           MOVE '3030'              TO ACTIVE-PARAGRAPH.                
                                                                        
           EXEC SQL                                                     
              CLOSE KO-COMM-CUST-USER                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE           = SUCCESSFUL-CALL         
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE'                    TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
              MOVE 'CSS_COMM_DATA'            TO TABLE-1                
              MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1        
              MOVE PARM-CUSTOMER-NO           TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       3030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3040-PROCESS-ROWS                                              *        
      *     CALLS  8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SENDS AN EMPTY TABLE BACK.  THAT IS, THERE ARE NO          *        
      *     TRANSACTION HISTORY SUMMARY ROWS.                          *        
      ******************************************************************        
                                                                        
       3040-PROCESS-ROWS.                                               
                                                                        
           IF KO-COMM-ASSOC-CD = 'P' THEN                               
               IF KO-PREMISE-NO NOT = WS-PREMISE-NO                     
                   PERFORM 3020-FETCH-CUST-CURSOR-USER                  
                      THRU 3020-EXIT                                    
                   GO TO 3040-EXIT                                      
               END-IF                                                   
           END-IF.                                                      
                                                                        
           MOVE         'N'   TO WS-SKIP-ROW.                           
                                                                        
           IF WS-ROW-CT < 31                                            
              ADD +1 TO WS-ROW-CT                                       
           ELSE                                                         
              IF PARM-FR-DATE = '1/1/1991'                              
                 IF KO-RED-FLAG-IND = 'N'                               
                    MOVE 'Y' TO WS-SKIP-ROW                             
                 ELSE                                                   
                    IF WS-RED-FLG-NULL-IND NOT EQUAL -1                 
                       MOVE KO-RED-FLAG-EXPIRE-DT   TO                  
                            WS-HOLD-TIMESTAMP                           
                       IF WS-RED-FL-YR < WS-YEAR                        
                          MOVE 'Y' TO WS-SKIP-ROW                       
                       ELSE                                             
                          IF WS-RED-FL-YR = WS-YEAR                     
                             IF WS-RED-FL-MO < WS-MONTH                 
                                MOVE 'Y'  TO  WS-SKIP-ROW               
                             ELSE                                       
                                IF WS-RED-FL-DY < WS-DAY                
                                   MOVE 'Y'  TO  WS-SKIP-ROW            
                                END-IF                                  
                             END-IF                                     
                          END-IF                                        
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
              ELSE                                                      
                 MOVE 'Y' TO WS-SKIP-ROW                                
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-SKIP-ROW = 'Y'                                         
              PERFORM 3020-FETCH-CUST-CURSOR-USER                       
                 THRU 3020-EXIT                                         
              GO TO 3040-EXIT                                           
           END-IF.                                                      
                                                                        
           IF KO-PREMISE-NO NOT = 0                                     
               PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT               
           ELSE                                                         
               IF KO-ACCOUNT-NO NOT = 0                                 
                   PERFORM 2550-SELECT-ACCOUNT THRU 2550-EXIT           
                   IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL           
                       PERFORM 2930-SELECT-ADDRESS THRU 2930-EXIT       
                   ELSE                                                 
                       MOVE SPACES TO RS-ADDRESS                        
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
           PERFORM 2910-SELECT-COMMENTS THRU 2910-EXIT.                 
           PERFORM 2920-SELECT-PROFILE  THRU 2920-EXIT.                 
           PERFORM 2900-MOVE-TO-RETURN-FIELDS THRU 2900-EXIT.           
                                                                        
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
           PERFORM 3020-FETCH-CUST-CURSOR-USER THRU 3020-EXIT.          
                                                                        
                                                                        
       3040-EXIT.                                                       
           EXIT.                                                        
                                                                        
           COPY CPD00004.                                                       
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02518_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,COMM_ID                                                   
CVT000       ,ACCOUNT_NO                                                
CVT000       ,CUSTOMER_NO                                               
CVT000       ,PREMISE_NO                                                
CVT000       ,COMPANY_NO                                                
CVT000       ,RED_FLAG_IND                                              
CVT000       ,RED_FLAG_EXPIRE_DT                                        
CVT000       ,COMM_METHOD                                               
CVT000       ,COMM_DIRECTION                                            
CVT000       ,COMM_TYPE_CD                                              
CVT000       ,COMM_SUBTYPE_CODE                                         
CVT000       ,USER_ID_ORIG                                              
CVT000       ,CONTACT_NAME                                              
CVT000       ,PROMOTION_ID                                              
CVT000       ,PSC_COMPLIANCE_IND                                        
CVT000       ,CALL_ORIGIN_ID                                            
CVT000       ,CALL_END_TIME                                             
CVT000       ,NUMBER_TRANSFERS                                          
CVT000       ,HOLD_TIME                                                 
CVT000       ,QUEUE_TIME                                                
CVT000       ,SCREEN_POP_IND                                            
CVT000       ,TOTAL_CALL_TIME                                           
CVT000       ,INITIAL_COMMENT_TE                                        
CVT000       ,ADDRESS                                                   
CVT000       ,RESP_AREA                                                 
CVT000       ,CURRENT_COMMENTS                                          
CVT000       ,TOTAL_COMMENTS                                            
CVT000       ,LAST_NAME                                                 
CVT000       ,FIRST_NAME                                                
CVT000       ,RESPONSE_REASON_CD                                        
CVT000       ,RESPONSE_TYPE_CD                                          
CVT000       ,SOLICITATION_CD                                           
CVT000       ,COMM_ASSOC_CD                                             
CVT000       ,USER_ID                                                   
CVT000       ,UPDATE_TS                                                 
CVT000       ,COMPLAINT_FL                                              
CVT000       ,COMM_SUB_TYPE                                             
CVT000       ,COMM_TODAY                                                
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-COMM-ID                                               
CVT000       ,:RS-ACCOUNT-NO                                            
CVT000       ,:RS-CUSTOMER-NO                                           
CVT000       ,:RS-PREMISE-NO                                            
CVT000       ,:RS-COMPANY-NO                                            
CVT000       ,:RS-RED-FLAG-IND                                          
CVT000       ,:RS-RED-FLAG-EXPIRE-DT                                    
CVT000       ,:RS-COMM-METHOD                                           
CVT000       ,:RS-COMM-DIRECTION                                        
CVT000       ,:RS-COMM-TYPE-CD                                          
CVT000       ,:RS-COMM-SUBTYPE-CODE                                     
CVT000       ,:RS-USER-ID-ORIG                                          
CVT000       ,:RS-CONTACT-NAME                                          
CVT000       ,:RS-PROMOTION-ID                                          
CVT000       ,:RS-PSC-COMPLIANCE-IND                                    
CVT000       ,:RS-CALL-ORIGIN-ID                                        
CVT000       ,:RS-CALL-END-TIME                                         
CVT000       ,:RS-NUMBER-TRANSFERS                                      
CVT000       ,:RS-HOLD-TIME                                             
CVT000       ,:RS-QUEUE-TIME                                            
CVT000       ,:RS-SCREEN-POP-IND                                        
CVT000       ,:RS-TOTAL-CALL-TIME                                       
CVT000       ,:RS-INITIAL-COMMENT-TE                                    
CVT000       ,:RS-ADDRESS                                               
CVT000       ,:RS-RESP-AREA                                             
CVT000       ,:RS-CURRENT-COMMENTS                                      
CVT000       ,:RS-TOTAL-COMMENTS                                        
CVT000       ,:RS-LAST-NAME                                             
CVT000       ,:RS-FIRST-NAME                                            
CVT000       ,:RS-RESPONSE-REASON-CD                                    
CVT000       ,:RS-RESPONSE-TYPE-CD                                      
CVT000       ,:RS-SOLICITATION-CD                                       
CVT000       ,:RS-COMM-ASSOC-CD                                         
CVT000       ,:RS-USER-ID                                               
CVT000       ,:RS-UPDATE-TS                                             
CVT000       ,:RS-COMPLAINT-FL                                          
CVT000       ,''                                                        
CVT000       ,IIF(TRY_CONVERT(DATE, '1900-01-01'
              ) IS NULL OR (PATINDEX('%.%', '1900-01-01'
              ) <> 0) OR (LEN('1900-01-01') <> 10), CIS.CHAR2DATE(
              '1900-01-01'), CONVERT(DATE, '1900-01-01') )                     
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02518_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,COMM_ID                                                           
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,CUSTOMER_NO                                                       
MFA-TR*      ,PREMISE_NO                                                        
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,RED_FLAG_IND                                                      
MFA-TR*      ,RED_FLAG_EXPIRE_DT                                                
MFA-TR*      ,COMM_METHOD                                                       
MFA-TR*      ,COMM_DIRECTION                                                    
MFA-TR*      ,COMM_TYPE_CD                                                      
MFA-TR*      ,COMM_SUBTYPE_CODE                                                 
MFA-TR*      ,USER_ID_ORIG                                                      
MFA-TR*      ,CONTACT_NAME                                                      
MFA-TR*      ,PROMOTION_ID                                                      
MFA-TR*      ,PSC_COMPLIANCE_IND                                                
MFA-TR*      ,CALL_ORIGIN_ID                                                    
MFA-TR*      ,CALL_END_TIME                                                     
MFA-TR*      ,NUMBER_TRANSFERS                                                  
MFA-TR*      ,HOLD_TIME                                                         
MFA-TR*      ,QUEUE_TIME                                                        
MFA-TR*      ,SCREEN_POP_IND                                                    
MFA-TR*      ,TOTAL_CALL_TIME                                                   
MFA-TR*      ,INITIAL_COMMENT_TE                                                
MFA-TR*      ,ADDRESS                                                           
MFA-TR*      ,RESP_AREA                                                         
MFA-TR*      ,CURRENT_COMMENTS                                                  
MFA-TR*      ,TOTAL_COMMENTS                                                    
MFA-TR*      ,LAST_NAME                                                         
MFA-TR*      ,FIRST_NAME                                                        
MFA-TR*      ,RESPONSE_REASON_CD                                                
MFA-TR*      ,RESPONSE_TYPE_CD                                                  
MFA-TR*      ,SOLICITATION_CD                                                   
MFA-TR*      ,COMM_ASSOC_CD                                                     
MFA-TR*      ,USER_ID                                                           
MFA-TR*      ,UPDATE_TS                                                         
MFA-TR*      ,COMPLAINT_FL                                                      
MFA-TR*      ,COMM_SUB_TYPE                                                     
MFA-TR*      ,COMM_TODAY                                                        
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-COMM-ID                                                       
MFA-TR*      ,:RS-ACCOUNT-NO                                                    
MFA-TR*      ,:RS-CUSTOMER-NO                                                   
MFA-TR*      ,:RS-PREMISE-NO                                                    
MFA-TR*      ,:RS-COMPANY-NO                                                    
MFA-TR*      ,:RS-RED-FLAG-IND                                                  
MFA-TR*      ,:RS-RED-FLAG-EXPIRE-DT                                            
MFA-TR*      ,:RS-COMM-METHOD                                                   
MFA-TR*      ,:RS-COMM-DIRECTION                                                
MFA-TR*      ,:RS-COMM-TYPE-CD                                                  
MFA-TR*      ,:RS-COMM-SUBTYPE-CODE                                             
MFA-TR*      ,:RS-USER-ID-ORIG                                                  
MFA-TR*      ,:RS-CONTACT-NAME                                                  
MFA-TR*      ,:RS-PROMOTION-ID                                                  
MFA-TR*      ,:RS-PSC-COMPLIANCE-IND                                            
MFA-TR*      ,:RS-CALL-ORIGIN-ID                                                
MFA-TR*      ,:RS-CALL-END-TIME                                                 
MFA-TR*      ,:RS-NUMBER-TRANSFERS                                              
MFA-TR*      ,:RS-HOLD-TIME                                                     
MFA-TR*      ,:RS-QUEUE-TIME                                                    
MFA-TR*      ,:RS-SCREEN-POP-IND                                                
MFA-TR*      ,:RS-TOTAL-CALL-TIME                                               
MFA-TR*      ,:RS-INITIAL-COMMENT-TE                                            
MFA-TR*      ,:RS-ADDRESS                                                       
MFA-TR*      ,:RS-RESP-AREA                                                     
MFA-TR*      ,:RS-CURRENT-COMMENTS                                              
MFA-TR*      ,:RS-TOTAL-COMMENTS                                                
MFA-TR*      ,:RS-LAST-NAME                                                     
MFA-TR*      ,:RS-FIRST-NAME                                                    
MFA-TR*      ,:RS-RESPONSE-REASON-CD                                            
MFA-TR*      ,:RS-RESPONSE-TYPE-CD                                              
MFA-TR*      ,:RS-SOLICITATION-CD                                               
MFA-TR*      ,:RS-COMM-ASSOC-CD                                                 
MFA-TR*      ,:RS-USER-ID                                                       
MFA-TR*      ,:RS-UPDATE-TS                                                     
MFA-TR*      ,:RS-COMPLAINT-FL                                                  
MFA-TR*      ,''                                                                
MFA-TR*      ,'1900-01-01'                                                      
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02518_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02518_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02518_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
