       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02517.                                         
COB303 DATE-WRITTEN.      AUGUST 9, 2002.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S517                                           *00120000
      *  PROGRAM:       S517 (CSR02517)                                *00130000
      *  CALLING SP:    S517                                           *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM INSERTS CUSTOMER COMMUNICATIONS.                 *00200000
      *                                                                *00220000
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
C26305*  08/09/02    FMB      RPC ORIGINALLY ADDED.                    *00290000
C27707*  02/07/03    MJG      RESPONSE REASON CODE AND RESPONSE TYPE   *00290000
      *                       WERE NO LONGER NEEDED BY MARKETING SO    *00550000
      *                       WE ARE PASSING HOW DID YOU HEAR ABOUT US *00550000
      *                       AND PREVIOUS PROVIDER IN THOSE FIELDS    *00550000
      *                       REASON-CODE IS THE DISCOVERY MENTHOD AND *00550000
      *                       REASON TYPE IS THE PREVIOUS PROVIDER     *00550000
      *  08/15/03    MJG      WRITE TO NEW CTI_COMM_XREF TABLE.        *00290000
      *                       THE CONNECTION_ID IS BEING PASSED IN THE *        
      *                       PARM-CALL-END-TIME FOR NOW.  EVENTUALLY  *        
      *                       WE SHOULD ADD A NEW PARM.                *        
      *  05/23/05    CVNS     RPC TO COBOL SP CONVERSION.              *        
      *              CHENNAI                                           *        
T34875*  10/03/06    VKD      RESOLVE -311 ERROR WHILE INSERTING COMM  *        
T34875*                       RECORD. PARM-COMMNET-LEN VALIDATION ADDED*        
A05305*  11/04/15    FMB      SEB PROMOTION CODE                       *        
A05317*  02/12/16    FMB      ADD ARCHIVED ACCOUNT LOGIC.              *        
A05317*  10/21/16    FMB      REMOVE REFERENCES TO CSS_CTI_COMM_XREF.  *        
A05317*                       CALL_END_TIME IS STILL SET TO NULL.      *        
      ******************************************************************00560000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02517'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02517 STARTS HERE'.                  
                                                                        
      ******************************************************************00650000
      *    DB2 INCLUDES                                                *00660000
      ******************************************************************00670000
                                                                        
           EXEC SQL                                                     00690000
              INCLUDE SQLCA                                             00700000
           END-EXEC.                                                    00710000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBCOMDAT                                          00980000
           END-EXEC.                                                    00990000
                                                                        
           EXEC SQL                                                     01300000
              INCLUDE TBCOMCMT                                          01310000
           END-EXEC.                                                    01320000
                                                                        
           EXEC SQL                                                     01380000
              INCLUDE TBMNHIST                                          01390000
           END-EXEC.                                                    01400000
                                                                        
           EXEC SQL                                                     01420000
              INCLUDE TBMNHDT                                           01430000
           END-EXEC.                                                    01440000
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
A05317     EXEC SQL                                                             
A05317        INCLUDE TBHACCT                                                   
A05317     END-EXEC.                                                            
                                                                        
A05305     EXEC SQL                                                             
A05305        INCLUDE TBACCTRG                                                  
A05305     END-EXEC.                                                            
                                                                        
           COPY CWS00303.                                               01520000
           COPY CCA00001.                                               01550000
           COPY CWS00027.                                               01560000
           EXEC SQL                                                     01570000
               INCLUDE CWSX0010                                         01570000
           END-EXEC.                                                    01570000
                                                                        
           EXEC SQL                                                     01590000
              INCLUDE CWS00013                                          01600000
           END-EXEC.                                                    01610000
                                                                        
       01   GTT-MISC-FIELDS.                                            
            05  GTT-NAME                PIC X(26)                       
                                        VALUE 'SESSION.CSR02517_R1'.    
            05  GTT-ROW.                                                
                49 GTT-ROW-LEN          PIC S9(04) COMP.                
                49 GTT-ROW-CHAR         PIC X(1024).                    
            05  GTT-SQLCODE             PIC S9(9) COMP.                 
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
       01  PARM-FIELDS.                                                 
           05  PARM-COMMENT.                                            
               49  PARM-COMMENT-LEN     PIC S9(04) COMP SYNC VALUE +0.  
               49  PARM-COMMENT-TEXT    PIC X(255) VALUE SPACES.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(09) COMP VALUE +0.   
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE                PIC S9(09) COMP VALUE +0.   
                                                                        
       01  CSRERLOG-P.                                                  
           10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
           10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
           10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
           10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
           10  S-HOST-VARIABLES.                                        
               49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
               49  S-HOST-VARIABLES-V  PIC X(255).                      
           10  S-SQL-STATEMENT.                                         
               49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
               49  S-SQL-STATEMENT-V   PIC X(255).                      
           10  S-SQL-DESCRIPTION.                                       
               49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
               49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-TRANS-APPL-NO         PIC S9(04) COMP VALUE 0.        
           05  WS-ACCOUNT-NO-RED        PIC X(13).                      
           05  WS-ACCOUNT-NO            REDEFINES WS-ACCOUNT-NO-RED     
                                        PIC 9(13).                      
           05  WS-CUSTOMER-NO-RED       PIC X(10).                      
           05  WS-CUSTOMER-NO           REDEFINES WS-CUSTOMER-NO-RED    
                                        PIC 9(10).                      
           05  WS-PREMISE-NO-RED        PIC X(10).                      
           05  WS-PREMISE-NO            REDEFINES WS-PREMISE-NO-RED     
                                        PIC 9(10).                      
           05  WS-CALL-ORIGIN-ID-RED    PIC X(04).                      
           05  WS-CALL-ORIGIN-ID        REDEFINES WS-CALL-ORIGIN-ID-RED 
                                        PIC 9(04).                      
           05  WS-NUMBER-TRANSFERS-RED  PIC X(09).                      
           05  WS-NUMBER-TRANSFERS      REDEFINES                       
                                        WS-NUMBER-TRANSFERS-RED         
                                        PIC 9(09).                      
           05  WS-HOLD-TIME-RED         PIC X(05).                      
           05  WS-HOLD-TIME             REDEFINES WS-HOLD-TIME-RED      
                                        PIC 9(05).                      
           05  WS-QUEUE-TIME-RED        PIC X(05).                      
           05  WS-QUEUE-TIME            REDEFINES WS-QUEUE-TIME-RED     
                                        PIC 9(05).                      
           05  WS-TOTAL-CALL-TIME-RED   PIC X(05).                      
           05  WS-TOTAL-CALL-TIME       REDEFINES WS-TOTAL-CALL-TIME-RED
                                        PIC 9(05).                      
           05  PROGRAM-NAME             PIC X(08) VALUE 'CSR02517'.     
           05  WS-CURRENT-TS            PIC X(26).                      
           05  WS-RED-FL-NULL-IND       PIC S9(4) COMP VALUE 0.         
           05  WS-END-NULL-IND          PIC S9(4) COMP VALUE 0.         
           05  WS-RED-FLAG-CHANGE       PIC X(01) VALUE 'N'.            
           05  WS-RED-FLAG-DATE-CHANGE  PIC X(01) VALUE 'N'.            
           05  WS-PSC-FLAG-CHANGE       PIC X(01) VALUE 'N'.            
           05  WS-COMPLAINT-CHANGE      PIC X(01) VALUE 'N'.            
           05  WS-CREATE-XREF           PIC X(01) VALUE 'N'.            
A05305     05  WS-PROMOTION-ID.                                         
A05305         10 WS-RT-PKG-OPT-SEQ-NO  PIC 9(04) VALUE 0.              
A05305         10 WS-STATUS-CD          PIC X(01) VALUE SPACES.         
A05305         10 WS-AGREEMNT-SOURCE-CD PIC X(03) VALUE SPACES.         
                                                                        
       LINKAGE SECTION.                                                 
       01  PARM-ACTION-CD           PIC X(01) VALUE SPACES.             
       01  PARM-ACCOUNT-NO          PIC X(13) VALUE SPACES.             
       01  PARM-CUSTOMER-NO         PIC X(10) VALUE SPACES.             
       01  PARM-PREMISE-NO          PIC X(10) VALUE SPACES.             
       01  PARM-COMMUNICATION-ID    PIC X(26) VALUE SPACES.             
       01  PARM-COMPANY-NO          PIC X(02) VALUE SPACES.             
       01  PARM-RED-FLAG-IND        PIC X(01) VALUE SPACES.             
       01  PARM-RED-FLAG-EXP-DT     PIC X(26) VALUE SPACES.             
       01  PARM-COMM-METHOD         PIC X(01) VALUE SPACES.             
       01  PARM-COMM-DIRECTION      PIC X(01) VALUE SPACES.             
       01  PARM-COMM-TYPE-CD        PIC X(02) VALUE SPACES.             
       01  PARM-COMM-SUBTYPE-CD     PIC X(02) VALUE SPACES.             
       01  PARM-USER-ID-ORIG        PIC X(07) VALUE SPACES.             
       01  PARM-CONTACT-NAME        PIC X(25) VALUE SPACES.             
       01  PARM-PROMOTION-ID        PIC X(12) VALUE SPACES.             
       01  PARM-PSC-COMPLIANCE-IND  PIC X(01) VALUE SPACES.             
       01  PARM-CALL-ORIGIN-ID      PIC X(04) VALUE SPACES.             
       01  PARM-CALL-END-TIME       PIC X(26) VALUE SPACES.             
       01  PARM-NUMBER-TRANSFERS    PIC X(09) VALUE SPACES.             
       01  PARM-HOLD-TIME           PIC X(05) VALUE SPACES.             
       01  PARM-QUEUE-TIME          PIC X(05) VALUE SPACES.             
       01  PARM-SCREEN-POP-IND      PIC X(01) VALUE SPACES.             
       01  PARM-TOTAL-CALL-TIME     PIC X(05) VALUE SPACES.             
       01  PARM-COMMENT-LEN-TMP     PIC S9(04) COMP SYNC VALUE +0.      
       01  PARM-COMMENT-TEXT-TMP    PIC X(255) VALUE SPACES.            
       01  PARM-COMM-ASSOC-CD       PIC X(01) VALUE SPACES.             
       01  PARM-COMPLAINT-FL        PIC X(01) VALUE SPACES.             
       01  PARM-RESPONSE-REASON-CD  PIC X(04) VALUE SPACES.             
       01  PARM-RESPONSE-TYPE-CD    PIC X(04) VALUE SPACES.             
       01  PARM-SOLICITATION-CD     PIC X(03) VALUE SPACES.             
                                                                        
       PROCEDURE DIVISION USING  PARM-ACTION-CD                         
                                 PARM-ACCOUNT-NO                        
                                 PARM-CUSTOMER-NO                       
                                 PARM-PREMISE-NO                        
                                 PARM-COMMUNICATION-ID                  
                                 PARM-COMPANY-NO                        
                                 PARM-RED-FLAG-IND                      
                                 PARM-RED-FLAG-EXP-DT                   
                                 PARM-COMM-METHOD                       
                                 PARM-COMM-DIRECTION                    
                                 PARM-COMM-TYPE-CD                      
                                 PARM-COMM-SUBTYPE-CD                   
                                 PARM-USER-ID-ORIG                      
                                 PARM-CONTACT-NAME                      
                                 PARM-PROMOTION-ID                      
                                 PARM-PSC-COMPLIANCE-IND                
                                 PARM-CALL-ORIGIN-ID                    
                                 PARM-CALL-END-TIME                     
                                 PARM-NUMBER-TRANSFERS                  
                                 PARM-HOLD-TIME                         
                                 PARM-QUEUE-TIME                        
                                 PARM-SCREEN-POP-IND                    
                                 PARM-TOTAL-CALL-TIME                   
                                 PARM-COMMENT-LEN-TMP                   
                                 PARM-COMMENT-TEXT-TMP                  
                                 PARM-COMM-ASSOC-CD                     
                                 PARM-COMPLAINT-FL                      
                                 PARM-RESPONSE-REASON-CD                
                                 PARM-RESPONSE-TYPE-CD                  
                                 PARM-SOLICITATION-CD.                  
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
           EXEC SQL                                                     
               DECLARE C1 CURSOR  FOR                        
               SELECT                                                   
                   :S-RETURN-CODE          AS  RETURN_CODE              
               FROM                                                     
                   CIS.SYSDUMMY1                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            :S-RETURN-CODE          AS  RETURN_CODE                      
MFA-TR*        FROM                                                             
MFA-TR*            SYSIBM.SYSDUMMY1                                             
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
T34875     IF PARM-COMMENT-LEN-TMP > 255 THEN                           
T34875        MOVE 255                TO PARM-COMMENT-LEN               
T34875     ELSE                                                         
T34875        IF PARM-COMMENT-LEN-TMP < 0 THEN                          
T34875           MOVE 0               TO PARM-COMMENT-LEN               
T34875        ELSE                                                      
                 MOVE PARM-COMMENT-LEN-TMP  TO PARM-COMMENT-LEN         
T34875        END-IF                                                    
T34875     END-IF.                                                      
           MOVE PARM-COMMENT-TEXT-TMP TO PARM-COMMENT-TEXT.             
           IF PARM-COMMENT-TEXT <= ' '                                  
               MOVE SPACES TO PARM-COMMENT-TEXT                         
           END-IF.                                                      
           MOVE PARM-ACCOUNT-NO       TO WS-ACCOUNT-NO-RED.             
           MOVE PARM-CUSTOMER-NO      TO WS-CUSTOMER-NO-RED.            
           MOVE PARM-PREMISE-NO       TO WS-PREMISE-NO-RED.             
           MOVE PARM-CALL-ORIGIN-ID   TO WS-CALL-ORIGIN-ID-RED.         
           MOVE PARM-NUMBER-TRANSFERS TO WS-NUMBER-TRANSFERS-RED.       
           MOVE PARM-HOLD-TIME        TO WS-HOLD-TIME-RED.              
           MOVE PARM-QUEUE-TIME       TO WS-QUEUE-TIME-RED.             
           MOVE PARM-TOTAL-CALL-TIME  TO WS-TOTAL-CALL-TIME-RED.        
           IF WS-ACCOUNT-NO-RED NOT NUMERIC                             
               MOVE ZEROES TO WS-ACCOUNT-NO-RED
           END-IF.                        
           IF WS-PREMISE-NO-RED NOT NUMERIC                             
               MOVE ZEROES TO WS-PREMISE-NO-RED
           END-IF.                        
           IF WS-CUSTOMER-NO-RED NOT NUMERIC                            
               MOVE ZEROES TO WS-CUSTOMER-NO-RED
           END-IF.                       
           IF WS-CALL-ORIGIN-ID-RED NOT NUMERIC                         
               MOVE ZEROES TO WS-CALL-ORIGIN-ID-RED                     
               MOVE WS-CALL-ORIGIN-ID TO PARM-CALL-ORIGIN-ID            
           END-IF.                                                      
           IF WS-NUMBER-TRANSFERS-RED NOT NUMERIC                       
               MOVE ZEROES TO WS-NUMBER-TRANSFERS-RED                   
               MOVE WS-NUMBER-TRANSFERS TO PARM-NUMBER-TRANSFERS        
           END-IF.                                                      
           IF WS-HOLD-TIME-RED NOT NUMERIC                              
               MOVE ZEROES TO WS-HOLD-TIME-RED                          
               MOVE WS-HOLD-TIME TO PARM-HOLD-TIME                      
           END-IF.                                                      
           IF WS-QUEUE-TIME-RED NOT NUMERIC                             
               MOVE ZEROES TO WS-QUEUE-TIME-RED                         
               MOVE WS-QUEUE-TIME TO PARM-QUEUE-TIME                    
           END-IF.                                                      
           IF WS-TOTAL-CALL-TIME-RED NOT NUMERIC                        
               MOVE ZEROES TO WS-TOTAL-CALL-TIME-RED                    
               MOVE WS-TOTAL-CALL-TIME TO PARM-TOTAL-CALL-TIME          
           END-IF.                                                      
           IF PARM-RED-FLAG-IND <= ' '                                  
               MOVE 'N' TO PARM-RED-FLAG-IND
           END-IF.                           
           IF PARM-PSC-COMPLIANCE-IND <= ' '                            
               MOVE 'N' TO PARM-PSC-COMPLIANCE-IND
           END-IF.                     
           IF PARM-SCREEN-POP-IND <= ' '                                
               MOVE 'N' TO PARM-SCREEN-POP-IND
           END-IF.                         
           IF PARM-COMPLAINT-FL <= ' '                                  
               MOVE 'N' TO PARM-COMPLAINT-FL
           END-IF.                           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-BUILD-RESULT       THRU 5000-EXIT.              
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE.           
           MOVE '2000'                     TO ACTIVE-PARAGRAPH.         
           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT.             
           ADD +1                          TO CTR-ROWS.                 
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
            MOVE RS-RETURN-CODE           TO S-RETURN-CODE.             
                                                                        
       2000A-EXIT.                                                      
            EXIT.                                                       
                                                                        
       5000-BUILD-RESULT.                                               
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TS                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-TS = CURRENT TIMESTAMP                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           PERFORM 5100-FORMAT-MH THRU 5100-EXIT.                       
                                                                        
           EVALUATE PARM-ACTION-CD                                      
               WHEN 'I'                                                 
                   PERFORM 5300-INSERT-COMMUNICATION THRU 5300-EXIT     
               WHEN 'U'                                                 
                   MOVE PARM-COMMUNICATION-ID TO KO-COMMUNICATION-ID    
                   PERFORM 7000-SELECT-COMMUNICATION THRU 7000-EXIT     
                   IF (PARM-RED-FLAG-IND = KO-RED-FLAG-IND AND          
                       PARM-RED-FLAG-EXP-DT = KO-RED-FLAG-EXPIRE-DT AND 
                       PARM-PSC-COMPLIANCE-IND =                        
                            KO-PSC-COMPLIANCE-IND AND                   
                       PARM-COMPLAINT-FL = KO-COMPLAINT-FL)             
                           MOVE 'N' TO WS-RED-FLAG-CHANGE               
                                       WS-RED-FLAG-DATE-CHANGE          
                                       WS-PSC-FLAG-CHANGE               
                                       WS-COMPLAINT-CHANGE              
                   ELSE                                                 
                       IF PARM-RED-FLAG-IND NOT = KO-RED-FLAG-IND       
                           MOVE 'Y' TO WS-RED-FLAG-CHANGE               
                       END-IF                                           
                       IF PARM-RED-FLAG-EXP-DT NOT =                    
                          KO-RED-FLAG-EXPIRE-DT                         
                              MOVE 'Y' TO WS-RED-FLAG-DATE-CHANGE       
                       END-IF                                           
                       IF PARM-PSC-COMPLIANCE-IND NOT =                 
                          KO-PSC-COMPLIANCE-IND                         
                              MOVE 'Y' TO WS-PSC-FLAG-CHANGE            
                       END-IF                                           
                       IF PARM-COMPLAINT-FL NOT = KO-COMPLAINT-FL       
                           MOVE 'Y' TO WS-COMPLAINT-CHANGE              
                       END-IF                                           
                       PERFORM 8300-UPDATE-COMM       THRU 8300-EXIT    
                   END-IF                                               
                   PERFORM 5200-MULTIPLE-COMMENTS THRU 5200-EXIT        
               WHEN OTHER                                               
                   MOVE +100 TO WS-ACTIVE-RETURN-CODE                   
           END-EVALUATE.                                                
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5100-FORMAT-MH.                                                  
                                                                        
           MOVE WS-CURRENT-TS            TO MH-TRANS-HIST-SEQ-NO.       
           MOVE WS-CURRENT-TS(1:10)      TO MH-DATE-TRANS.              
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           PERFORM 7200-RESP-AREA        THRU 7200-EXIT.                
           MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID.            
           MOVE WS-CUSTOMER-NO           TO MH-CUSTOMER-NO.             
           MOVE WS-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE WS-PREMISE-NO            TO MH-PREMISE-NO.              
           MOVE PARM-USER-ID-ORIG        TO MH-USER-ID.                 
           MOVE 'PANEL081'               TO MH-APPL-PROGRAM-ID.         
           MOVE 1                        TO WS-TRANS-APPL-NO.           
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-MULTIPLE-COMMENTS.                                          
                                                                        
           MOVE '5200'                     TO ACTIVE-PARAGRAPH.         
           MOVE PARM-COMMUNICATION-ID      TO KN-COMMUNICATION-ID.      
           MOVE WS-CURRENT-TS              TO KN-UPDATE-TS.             
           MOVE PARM-USER-ID-ORIG          TO KN-USER-ID.               
           MOVE PARM-COMMENT-TEXT          TO KN-COMMENT-TX-TEXT.       
           MOVE PARM-COMMENT-LEN           TO KN-COMMENT-TX-LEN.        
           PERFORM 8000-INSERT-COMM-COMMENT THRU 8000-EXIT.             
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
           MOVE WS-TRANS-APPL-NO       TO MI-TRAN-APPL-NO.              
           MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE +26                    TO MI-CHG-COLUMN-VALUE-LEN.      
           MOVE PARM-COMMUNICATION-ID  TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE 'COMMENT'              TO MI-COLUMN-DESC.               
      *    PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.                    
           ADD +1                      TO WS-TRANS-APPL-NO.             
                                                                        
           IF WS-RED-FLAG-CHANGE = 'Y'                                  
               MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO       
               MOVE WS-TRANS-APPL-NO      TO MI-TRAN-APPL-NO            
               MOVE +1                    TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +1                    TO MI-CHG-COLUMN-VALUE-LEN    
               MOVE PARM-RED-FLAG-IND     TO MI-CHG-COLUMN-VALUE-TEXT   
               MOVE KO-RED-FLAG-IND       TO MI-PRV-COLUMN-VALUE-TEXT   
               MOVE 'RED FLAG IND'        TO MI-COLUMN-DESC             
      *        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                  
               ADD +1                     TO WS-TRANS-APPL-NO
           END-IF.          
                                                                        
           IF WS-RED-FLAG-DATE-CHANGE = 'Y'                             
               MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO       
               MOVE WS-TRANS-APPL-NO      TO MI-TRAN-APPL-NO            
               MOVE +26                   TO MI-PRV-COLUMN-VALUE-LEN    
               MOVE +26                   TO MI-CHG-COLUMN-VALUE-LEN    
               IF PARM-RED-FLAG-EXP-DT <= ' '                           
                   MOVE '*DELETED*'       TO MI-CHG-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE PARM-RED-FLAG-EXP-DT  TO                        
                        MI-CHG-COLUMN-VALUE-TEXT                        
               END-IF                                                   
               IF KO-RED-FLAG-EXPIRE-DT <= ' '                          
                   MOVE '*NEW'            TO MI-PRV-COLUMN-VALUE-TEXT   
               ELSE                                                     
                   MOVE KO-RED-FLAG-EXPIRE-DT TO                        
                        MI-PRV-COLUMN-VALUE-TEXT                        
               END-IF                                                   
               MOVE 'RED FLAG EXP DT'     TO MI-COLUMN-DESC             
      *        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                  
               ADD +1                     TO WS-TRANS-APPL-NO
           END-IF.          
                                                                        
           IF WS-PSC-FLAG-CHANGE = 'Y'                                  
               MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO     
               MOVE WS-TRANS-APPL-NO        TO MI-TRAN-APPL-NO          
               MOVE +1                      TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE PARM-PSC-COMPLIANCE-IND TO MI-CHG-COLUMN-VALUE-TEXT 
               MOVE KO-PSC-COMPLIANCE-IND   TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE 'PSC COMPLIANCE'        TO MI-COLUMN-DESC           
      *        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                  
               ADD +1                       TO WS-TRANS-APPL-NO
           END-IF.        
                                                                        
           IF WS-COMPLAINT-CHANGE = 'Y'                                 
               MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO     
               MOVE WS-TRANS-APPL-NO        TO MI-TRAN-APPL-NO          
               MOVE +1                      TO MI-PRV-COLUMN-VALUE-LEN  
               MOVE +1                      TO MI-CHG-COLUMN-VALUE-LEN  
               MOVE PARM-COMPLAINT-FL       TO MI-CHG-COLUMN-VALUE-TEXT 
               MOVE KO-COMPLAINT-FL         TO MI-PRV-COLUMN-VALUE-TEXT 
               MOVE 'COMPLAINT FLAG'        TO MI-COLUMN-DESC           
      *        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT                  
               ADD +1                       TO WS-TRANS-APPL-NO
           END-IF.        
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5300-INSERT-COMMUNICATION.                                       
                                                                        
           MOVE '5300'                 TO ACTIVE-PARAGRAPH.             
           MOVE WS-CURRENT-TS          TO KO-COMMUNICATION-ID.          
           IF WS-ACCOUNT-NO > 0                                         
               MOVE WS-ACCOUNT-NO TO AT-ACCOUNT-NO                      
               PERFORM 7100-SELECT-ACCOUNT THRU 7100-EXIT
           END-IF.              
           MOVE WS-ACCOUNT-NO          TO KO-ACCOUNT-NO.                
           MOVE WS-CUSTOMER-NO         TO KO-CUSTOMER-NO.               
           MOVE WS-PREMISE-NO          TO KO-PREMISE-NO.                
           MOVE PARM-COMPANY-NO        TO KO-COMPANY-NO.                
           IF PARM-COMPANY-NO <= ' '                                    
               MOVE SPACES TO  PARM-COMPANY-NO                          
               MOVE SPACES TO  KO-COMPANY-NO                            
           END-IF.                                                      
           MOVE PARM-RED-FLAG-IND      TO KO-RED-FLAG-IND.              
           MOVE PARM-RED-FLAG-EXP-DT   TO KO-RED-FLAG-EXPIRE-DT.        
           IF PARM-RED-FLAG-EXP-DT <= ' '                               
               MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT                     
               MOVE SPACES TO PARM-RED-FLAG-EXP-DT                      
           END-IF.                                                      
           MOVE PARM-COMM-METHOD       TO KO-COMM-METHOD.               
           IF PARM-COMM-METHOD <= ' '                                   
               MOVE SPACES TO  PARM-COMM-METHOD                         
               MOVE SPACES TO  KO-COMM-METHOD                           
           END-IF.                                                      
           MOVE PARM-COMM-DIRECTION    TO KO-COMM-DIRECTION.            
           IF PARM-COMM-DIRECTION <= ' '                                
               MOVE SPACES TO  PARM-COMM-DIRECTION                      
               MOVE SPACES TO  KO-COMM-DIRECTION                        
           END-IF.                                                      
           MOVE PARM-COMM-TYPE-CD      TO KO-COMM-TYPE-CD.              
           IF PARM-COMM-TYPE-CD <= ' '                                  
               MOVE SPACES TO  PARM-COMM-TYPE-CD                        
               MOVE SPACES TO  KO-COMM-TYPE-CD                          
           END-IF.                                                      
           MOVE PARM-COMM-SUBTYPE-CD   TO KO-COMM-SUBTYPE-CODE.         
           IF PARM-COMM-SUBTYPE-CD <= ' '                               
               MOVE SPACES TO  PARM-COMM-SUBTYPE-CD                     
               MOVE SPACES TO  KO-COMM-SUBTYPE-CODE                     
           END-IF.                                                      
           MOVE PARM-USER-ID-ORIG      TO KO-USER-ID-ORIG.              
           MOVE PARM-CONTACT-NAME      TO KO-CONTACT-NAME.              
           IF PARM-CONTACT-NAME <= ' '                                  
               MOVE SPACES TO  PARM-CONTACT-NAME                        
               MOVE SPACES TO  KO-CONTACT-NAME                          
           END-IF.                                                      
           MOVE PARM-PROMOTION-ID      TO KO-PROMOTION-ID.              
           IF PARM-PROMOTION-ID <= ' '                                  
               MOVE SPACES TO  PARM-PROMOTION-ID                        
               MOVE SPACES TO  KO-PROMOTION-ID                          
           END-IF.                                                      
                                                                        
A05305     IF AT-ACCOUNT-TYPE-CODE = 'R' AND                            
A05305        AT-CODE-ACCT-STAT = 'A' AND                               
A05305       (KO-COMM-DIRECTION = 'I' OR 'O') AND                       
A05305       (KO-COMM-METHOD = 'P' OR 'C') AND                          
A05305        AT-REV-MTH-LST-NRML > 0                                   
A05305            PERFORM 7300-GET-RTPK-AGR-DATA THRU 7300-EXIT         
A05305            IF DF-RT-PKG-OPT-SEQ-NO  > 0                          
A05305               MOVE DF-RT-PKG-OPT-SEQ-NO TO WS-RT-PKG-OPT-SEQ-NO  
A05305               MOVE DF-STATUS-CD TO WS-STATUS-CD                  
A05305               MOVE DF-AGREEMNT-SOURCE-CD TO WS-AGREEMNT-SOURCE-CD
A05305               MOVE WS-PROMOTION-ID TO KO-PROMOTION-ID
                  END-IF
           END-IF.           
                                                                        
           MOVE PARM-PSC-COMPLIANCE-IND TO KO-PSC-COMPLIANCE-IND.       
           MOVE PARM-CALL-ORIGIN-ID     TO KO-CALL-ORIGIN-ID.           
           MOVE PARM-CALL-END-TIME      TO KO-CALL-END-TIME.            
           MOVE PARM-NUMBER-TRANSFERS   TO KO-NUMBER-TRANSFERS.         
           MOVE PARM-HOLD-TIME          TO KO-HOLD-TIME.                
           MOVE PARM-QUEUE-TIME         TO KO-QUEUE-TIME.               
           MOVE PARM-SCREEN-POP-IND     TO KO-SCREEN-POP-IND.           
           MOVE PARM-TOTAL-CALL-TIME    TO KO-TOTAL-CALL-TIME.          
           MOVE PARM-COMMENT-TEXT       TO KO-INITIAL-COMMENT-TX-TEXT.  
           MOVE PARM-COMMENT-LEN        TO KO-INITIAL-COMMENT-TX-LEN.   
           MOVE PARM-COMM-ASSOC-CD      TO KO-COMM-ASSOC-CD.            
           IF  PARM-COMM-ASSOC-CD <= ' '                                
               MOVE SPACES TO  PARM-COMM-ASSOC-CD                       
               MOVE SPACES TO  KO-COMM-ASSOC-CD                         
           END-IF.                                                      
           MOVE PARM-COMPLAINT-FL       TO KO-COMPLAINT-FL.             
           MOVE SPACES                  TO KO-RESPONSE-REASON-CD        
                                           KO-RESPONSE-TYPE-CD          
                                           KO-SOLICITATION-CD.          
           MOVE PARM-RESPONSE-REASON-CD TO KO-DISCOVERY-MTHD-CD         
           IF PARM-RESPONSE-REASON-CD <= ' '                            
              MOVE SPACES TO KO-DISCOVERY-MTHD-CD                       
              MOVE SPACES TO PARM-RESPONSE-REASON-CD                    
           END-IF.                                                      
           MOVE PARM-RESPONSE-TYPE-CD   TO KO-PREV-MARKETER-CD          
           IF PARM-RESPONSE-TYPE-CD <= ' '                              
              MOVE SPACES TO KO-PREV-MARKETER-CD                        
              MOVE SPACES TO PARM-RESPONSE-TYPE-CD                      
           END-IF.                                                      
                                                                        
           IF PARM-RED-FLAG-EXP-DT <= ' '                               
               MOVE -1 TO WS-RED-FL-NULL-IND
           END-IF.                           
                                                                        
           MOVE ' '                TO KO-CALL-END-TIME.                 
           MOVE -1                 TO WS-END-NULL-IND.                  
                                                                        
           PERFORM 8200-INSERT-COMM-DATA THRU 8200-EXIT.                
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO.         
           MOVE WS-TRANS-APPL-NO       TO MI-TRAN-APPL-NO.              
           MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN.      
           MOVE +26                    TO MI-CHG-COLUMN-VALUE-LEN.      
           MOVE KO-COMMUNICATION-ID    TO MI-CHG-COLUMN-VALUE-TEXT.     
           MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT.     
           MOVE 'COMMUNICATION'        TO MI-COLUMN-DESC.               
      *    PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.                    
           ADD +1                      TO WS-TRANS-APPL-NO.             
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-SELECT-COMMUNICATION.                                       
                                                                        
           EXEC SQL                                                     
              SELECT RED_FLAG_IND,                                      
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           RED_FLAG_EXPIRE_DT, 121), ' ', '-'), ':', '.') 
           RED_FLAG_EXPIRE_DT,                                
                     PSC_COMPLIANCE_IND,                                
                     COMPLAINT_FL                                       
                INTO :KO-RED-FLAG-IND,                                  
                     :KO-RED-FLAG-EXPIRE-DT :WS-RED-FL-NULL-IND,         
                     :KO-PSC-COMPLIANCE-IND,                            
                     :KO-COMPLAINT-FL                                   
                FROM CSS_COMM_DATA WITH(READUNCOMMITTED)                        
               WHERE COMMUNICATION_ID = CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )            
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RED_FLAG_IND,                                              
MFA-TR*              RED_FLAG_EXPIRE_DT,                                        
MFA-TR*              PSC_COMPLIANCE_IND,                                        
MFA-TR*              COMPLAINT_FL                                               
MFA-TR*         INTO :KO-RED-FLAG-IND,                                          
MFA-TR*              :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,                 
MFA-TR*              :KO-PSC-COMPLIANCE-IND,                                    
MFA-TR*              :KO-COMPLAINT-FL                                           
MFA-TR*         FROM CSS_COMM_DATA                                              
MFA-TR*        WHERE COMMUNICATION_ID = :KO-COMMUNICATION-ID                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7000                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-RED-FL-NULL-IND < 0                                 
                  MOVE SPACES TO KO-RED-FLAG-EXPIRE-DT                  
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'COMMUNICATION_ID'    TO TABLE-ELEMENT-1             
              MOVE KO-COMMUNICATION-ID   TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
A05305               ACCOUNT_TYPE_CODE,                                 
A05305               CODE_ACCT_STAT,                                    
A05305               REV_MTH_LST_NRML                                   
                INTO :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO,                                    
A05305               :AT-ACCOUNT-TYPE-CODE,                             
A05305               :AT-CODE-ACCT-STAT,                                
A05305               :AT-REV-MTH-LST-NRML                               
                FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                          
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              REV_MTH_LST_NRML                                           
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-CODE-ACCT-STAT,                                        
MFA-TR*              :AT-REV-MTH-LST-NRML                                       
MFA-TR*         FROM CSS_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE AT-CUSTOMER-NO TO WS-CUSTOMER-NO                
                   MOVE AT-PREMISE-NO TO WS-PREMISE-NO                  
               WHEN NOT-FOUND                                           
A05317             PERFORM 7110-SELECT-HIST-ACCT THRU 7110-EXIT         
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7100'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_ACCOUNT'    TO TABLE-1                     
                   MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
                   MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05317 7110-SELECT-HIST-ACCT.                                           
A05317                                                                  
A05317     EXEC SQL                                                     
A05317        SELECT CUSTOMER_NO,                                       
A05317               PREMISE_NO,                                        
A05317               ACCOUNT_TYPE_CODE,                                 
A05317               CODE_ACCT_STAT                                     
A05317          INTO :AT-CUSTOMER-NO,                                   
A05317               :AT-PREMISE-NO,                                    
A05317               :AT-ACCOUNT-TYPE-CODE,                             
A05317               :AT-CODE-ACCT-STAT                                 
A05317          FROM HST_ACCOUNT WITH(READUNCOMMITTED)                          
A05317         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
A05317                                                           
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              ACCOUNT_TYPE_CODE,                                         
MFA-TR*              CODE_ACCT_STAT                                             
MFA-TR*         INTO :AT-CUSTOMER-NO,                                           
MFA-TR*              :AT-PREMISE-NO,                                            
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :AT-CODE-ACCT-STAT                                         
MFA-TR*         FROM HST_ACCOUNT                                                
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317                                                                  
A05317     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A05317        MOVE AT-CUSTOMER-NO  TO WS-CUSTOMER-NO                    
A05317        MOVE AT-PREMISE-NO   TO WS-PREMISE-NO                     
A05317        MOVE ZEROES TO AT-REV-MTH-LST-NRML                        
A05317     ELSE                                                         
A05317        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A05317        MOVE '7110'                TO ACTIVE-PARAGRAPH            
A05317        MOVE 'SELECT'              TO ABEND-FUNCTION              
A05317        MOVE 'HST_ACCOUNT'         TO TABLE-1                     
A05317        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A05317        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A05317        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A05317        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A05317     END-IF.                                                      
A05317                                                                  
A05317 7110-EXIT.                                                       
A05317     EXIT.                                                        
A05317                                                                  
       7200-RESP-AREA.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :PF-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PARM-USER-ID-ORIG                       
                                                                 
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RESP_AREA_ID                                               
MFA-TR*         INTO :PF-RESP-AREA-ID                                           
MFA-TR*         FROM CSS_USER_PROFILE                                           
MFA-TR*        WHERE USER_ID = :PARM-USER-ID-ORIG                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE PARM-USER-ID-ORIG     TO HOSTVAR-ELEMENT-1           
              MOVE WS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
A05305 7300-GET-RTPK-AGR-DATA.                                          
A05305                                                                  
A05305     EXEC SQL                                                     
A05305        SELECT TOP(1) RT_PKG_OPT_SEQ_NO,
              STATUS_CD,
              AGREEMNT_SOURCE_CD                                 
A05305          INTO :DF-RT-PKG-OPT-SEQ-NO,                             
A05305               :DF-STATUS-CD,                                     
A05305               :DF-AGREEMNT-SOURCE-CD                             
A05305          FROM CSS_ACCT_RTPK_AGR WITH(READUNCOMMITTED)                    
A05305         WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
A05305         ORDER BY RT_PKG_OPT_SEQ_NO DESC                          
A05305                                              
A05305                                                           
A05305                                                      
A05305     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT RT_PKG_OPT_SEQ_NO,                                         
MFA-TR*              STATUS_CD,                                                 
MFA-TR*              AGREEMNT_SOURCE_CD                                         
MFA-TR*         INTO :DF-RT-PKG-OPT-SEQ-NO,                                     
MFA-TR*              :DF-STATUS-CD,                                             
MFA-TR*              :DF-AGREEMNT-SOURCE-CD                                     
MFA-TR*         FROM CSS_ACCT_RTPK_AGR                                          
MFA-TR*        WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                                
MFA-TR*        ORDER BY RT_PKG_OPT_SEQ_NO DESC                                  
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05305                                                                  
A05305     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A05305                                                                  
A05305     EVALUATE WS-ACTIVE-RETURN-CODE                               
A05305         WHEN SUCCESSFUL-CALL                                     
A05305             CONTINUE                                             
A05305         WHEN NOT-FOUND                                           
A05305             MOVE ZEROES TO WS-ACTIVE-RETURN-CODE                 
A05305                            DF-RT-PKG-OPT-SEQ-NO                  
A05305         WHEN OTHER                                               
A05305             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A05305             MOVE '7300'           TO ACTIVE-PARAGRAPH            
A05305             MOVE 'SELECT'         TO ABEND-FUNCTION              
A05305             MOVE 'CSS_ACCT_RTPK_AGR' TO TABLE-1                  
A05305             MOVE 'ACCOUNT_NO'     TO TABLE-ELEMENT-1             
A05305             MOVE AT-ACCOUNT-NO    TO HOSTVAR-ELEMENT-1           
A05305             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A05305             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A05305     END-EVALUATE.                                                
A05305                                                                  
A05305 7300-EXIT.                                                       
A05305     EXIT.                                                        
A05305                                                                  
       8000-INSERT-COMM-COMMENT.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_COMM_COMMENT                              
                   ( COMMUNICATION_ID,                                  
                     UPDATE_TS,                                         
                     USER_ID,                                           
                     COMMENT_TX)                                        
              VALUES                                                    
                   (CIS.CHAR2TIMESTAMP(:KN-COMMUNICATION-ID),                   
                    CIS.CHAR2TIMESTAMP(:KN-UPDATE-TS),                          
                    :KN-USER-ID,                                        
                    :KN-COMMENT-TX)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COMM_COMMENT                                      
MFA-TR*            ( COMMUNICATION_ID,                                          
MFA-TR*              UPDATE_TS,                                                 
MFA-TR*              USER_ID,                                                   
MFA-TR*              COMMENT_TX)                                                
MFA-TR*       VALUES                                                            
MFA-TR*            (:KN-COMMUNICATION-ID,                                       
MFA-TR*             :KN-UPDATE-TS,                                              
MFA-TR*             :KN-USER-ID,                                                
MFA-TR*             :KN-COMMENT-TX)                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8000'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_COMM_COMMENT'    TO TABLE-1                     
              MOVE 'COMM_ID'             TO TABLE-ELEMENT-1             
              MOVE PARM-COMMUNICATION-ID TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8200-INSERT-COMM-DATA.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_COMM_DATA                                 
                   ( COMMUNICATION_ID,                                  
                     ACCOUNT_NO,                                        
                     CUSTOMER_NO,                                       
                     PREMISE_NO,                                        
                     COMPANY_NO,                                        
                     RED_FLAG_IND,                                      
                     RED_FLAG_EXPIRE_DT,                                
                     COMM_METHOD,                                       
                     COMM_DIRECTION,                                    
                     COMM_TYPE_CD,                                      
                     COMM_SUBTYPE_CODE,                                 
                     USER_ID_ORIG,                                      
                     CONTACT_NAME,                                      
                     PROMOTION_ID,                                      
                     PSC_COMPLIANCE_IND,                                
                     CALL_ORIGIN_ID,                                    
                     CALL_END_TIME,                                     
                     NUMBER_TRANSFERS,                                  
                     HOLD_TIME,                                         
                     QUEUE_TIME,                                        
                     SCREEN_POP_IND,                                    
                     TOTAL_CALL_TIME,                                   
                     INITIAL_COMMENT_TX,                                
                     COMM_ASSOC_CD,                                     
                     COMPLAINT_FL,                                      
                     DISCOVERY_MTHD_CD,                                 
                     PREV_MARKETER_CD)                                  
              VALUES                                                    
                   (CIS.CHAR2TIMESTAMP(:KO-COMMUNICATION-ID),                   
                    :KO-ACCOUNT-NO,                                     
                    :KO-CUSTOMER-NO,                                    
                    :KO-PREMISE-NO,                                     
                    :KO-COMPANY-NO,                                     
                    :KO-RED-FLAG-IND,                                   
                    CIS.CHAR2TIMESTAMP(:KO-RED-FLAG-EXPIRE-DT 
                                       :WS-RED-FL-NULL-IND),          
                    :KO-COMM-METHOD,                                    
                    :KO-COMM-DIRECTION,                                 
                    :KO-COMM-TYPE-CD,                                   
                    :KO-COMM-SUBTYPE-CODE,                              
                    :KO-USER-ID-ORIG,                                   
                    :KO-CONTACT-NAME,                                   
                    :KO-PROMOTION-ID,                                   
                    :KO-PSC-COMPLIANCE-IND,                             
                    :KO-CALL-ORIGIN-ID,                                 
                    CIS.CHAR2TIMESTAMP(:KO-CALL-END-TIME 
                                       :WS-END-NULL-IND),                  
                    :KO-NUMBER-TRANSFERS,                               
                    :KO-HOLD-TIME,                                      
                    :KO-QUEUE-TIME,                                     
                    :KO-SCREEN-POP-IND,                                 
                    :KO-TOTAL-CALL-TIME,                                
                    :KO-INITIAL-COMMENT-TX,                             
                    :KO-COMM-ASSOC-CD,                                  
                    :KO-COMPLAINT-FL,                                   
                    :KO-DISCOVERY-MTHD-CD,                              
                    :KO-PREV-MARKETER-CD)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_COMM_DATA                                         
MFA-TR*            ( COMMUNICATION_ID,                                          
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              CUSTOMER_NO,                                               
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              COMPANY_NO,                                                
MFA-TR*              RED_FLAG_IND,                                              
MFA-TR*              RED_FLAG_EXPIRE_DT,                                        
MFA-TR*              COMM_METHOD,                                               
MFA-TR*              COMM_DIRECTION,                                            
MFA-TR*              COMM_TYPE_CD,                                              
MFA-TR*              COMM_SUBTYPE_CODE,                                         
MFA-TR*              USER_ID_ORIG,                                              
MFA-TR*              CONTACT_NAME,                                              
MFA-TR*              PROMOTION_ID,                                              
MFA-TR*              PSC_COMPLIANCE_IND,                                        
MFA-TR*              CALL_ORIGIN_ID,                                            
MFA-TR*              CALL_END_TIME,                                             
MFA-TR*              NUMBER_TRANSFERS,                                          
MFA-TR*              HOLD_TIME,                                                 
MFA-TR*              QUEUE_TIME,                                                
MFA-TR*              SCREEN_POP_IND,                                            
MFA-TR*              TOTAL_CALL_TIME,                                           
MFA-TR*              INITIAL_COMMENT_TX,                                        
MFA-TR*              COMM_ASSOC_CD,                                             
MFA-TR*              COMPLAINT_FL,                                              
MFA-TR*              DISCOVERY_MTHD_CD,                                         
MFA-TR*              PREV_MARKETER_CD)                                          
MFA-TR*       VALUES                                                            
MFA-TR*            (:KO-COMMUNICATION-ID,                                       
MFA-TR*             :KO-ACCOUNT-NO,                                             
MFA-TR*             :KO-CUSTOMER-NO,                                            
MFA-TR*             :KO-PREMISE-NO,                                             
MFA-TR*             :KO-COMPANY-NO,                                             
MFA-TR*             :KO-RED-FLAG-IND,                                           
MFA-TR*             :KO-RED-FLAG-EXPIRE-DT:WS-RED-FL-NULL-IND,                  
MFA-TR*             :KO-COMM-METHOD,                                            
MFA-TR*             :KO-COMM-DIRECTION,                                         
MFA-TR*             :KO-COMM-TYPE-CD,                                           
MFA-TR*             :KO-COMM-SUBTYPE-CODE,                                      
MFA-TR*             :KO-USER-ID-ORIG,                                           
MFA-TR*             :KO-CONTACT-NAME,                                           
MFA-TR*             :KO-PROMOTION-ID,                                           
MFA-TR*             :KO-PSC-COMPLIANCE-IND,                                     
MFA-TR*             :KO-CALL-ORIGIN-ID,                                         
MFA-TR*             :KO-CALL-END-TIME:WS-END-NULL-IND,                          
MFA-TR*             :KO-NUMBER-TRANSFERS,                                       
MFA-TR*             :KO-HOLD-TIME,                                              
MFA-TR*             :KO-QUEUE-TIME,                                             
MFA-TR*             :KO-SCREEN-POP-IND,                                         
MFA-TR*             :KO-TOTAL-CALL-TIME,                                        
MFA-TR*             :KO-INITIAL-COMMENT-TX,                                     
MFA-TR*             :KO-COMM-ASSOC-CD,                                          
MFA-TR*             :KO-COMPLAINT-FL,                                           
MFA-TR*             :KO-DISCOVERY-MTHD-CD,                                      
MFA-TR*             :KO-PREV-MARKETER-CD)                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8100'                TO ACTIVE-PARAGRAPH            
              MOVE 'INSERT'              TO ABEND-FUNCTION              
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2             
              MOVE 'PREMISE_NO'          TO TABLE-ELEMENT-3             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE WS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-2           
              MOVE WS-PREMISE-NO         TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       8300-UPDATE-COMM.                                                
                                                                        
           IF PARM-RED-FLAG-EXP-DT <= ' '                               
               MOVE -1 TO WS-RED-FL-NULL-IND                            
           ELSE                                                         
               MOVE 0  TO WS-RED-FL-NULL-IND
           END-IF.                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_COMM_DATA                                      
                 SET RED_FLAG_IND       = :PARM-RED-FLAG-IND,           
                     RED_FLAG_EXPIRE_DT = CIS.CHAR2TIMESTAMP(
                                                 :PARM-RED-FLAG-EXP-DT 
                                                    :WS-RED-FL-NULL-IND
              ),          
                     PSC_COMPLIANCE_IND = :PARM-PSC-COMPLIANCE-IND,     
                     COMPLAINT_FL       = :PARM-COMPLAINT-FL            
               WHERE COMMUNICATION_ID   = CIS.CHAR2TIMESTAMP(
                                                   :KO-COMMUNICATION-ID
              )          
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_COMM_DATA                                              
MFA-TR*          SET RED_FLAG_IND       = :PARM-RED-FLAG-IND,                   
MFA-TR*              RED_FLAG_EXPIRE_DT = :PARM-RED-FLAG-EXP-DT                 
MFA-TR*                                   :WS-RED-FL-NULL-IND,                  
MFA-TR*              PSC_COMPLIANCE_IND = :PARM-PSC-COMPLIANCE-IND,             
MFA-TR*              COMPLAINT_FL       = :PARM-COMPLAINT-FL                    
MFA-TR*        WHERE COMMUNICATION_ID   = :KO-COMMUNICATION-ID                  
MFA-TR*        QUERYNO 8300                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '8300'                TO ACTIVE-PARAGRAPH            
              MOVE 'UPDATE'              TO ABEND-FUNCTION              
              MOVE 'CSS_COMM_DATA'       TO TABLE-1                     
              MOVE 'COMMUNICATION_ID'    TO TABLE-ELEMENT-1             
              MOVE 'RED_FLAG_IND'        TO TABLE-ELEMENT-2             
              MOVE 'RED_FLAG_EXP_DT'     TO TABLE-ELEMENT-3             
              MOVE PARM-COMMUNICATION-ID TO HOSTVAR-ELEMENT-1           
              MOVE PARM-RED-FLAG-IND     TO HOSTVAR-ELEMENT-2           
              MOVE PARM-RED-FLAG-EXP-DT  TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     29920000
              INCLUDE CPD00067                                          29930000
           END-EXEC.                                                    29940000
                                                                        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
