       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02476.                                     
COB303 DATE-WRITTEN.      SEP 12, 2002                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00150000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM INSERTS / UPDATES / DELETES TRANSPORTATION       *00200000
      *  AGREEMENT DETAILS.                                            *00201000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  08/29/02   SK88120   RPC ORIGINALLY ADDED.                    *00280000
      *                                                                *00290000
REARCH*  10/04/05   CVNS       RPC CONVERTED TO COBOL SP               *00300000
REARCH*             CHENNAI                                            *00310000
T35434*  07/18/07   PA97450   REPLACED CSS_MODEL_SQL WITH SET STMTS    *00320000
T35434*                       AND FETCH ONLY WITH UR FOR CURSOR        *00330000
T35434*                       SELECTS AND WITH UR FOR SINGELTON        *00340000
T35434*                       SELECTS.                                 *00350000
      ******************************************************************00990000
      *                                                                *01000000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01010000
      *                                                                *01020000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01030000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01040000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01050000
      *  3000 - 4999  NOT USED                                         *01060000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01070000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01080000
      *  7000 - 7999  INPUT MODULES                                    *01090000
      *  8000 - 8999  OUTPUT MODULES                                   *01100000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01110000
      *                                                                *01120000
      ******************************************************************01130000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02476'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02476 STARTS HERE'.                  
                                                                        
      ******************************************************************01220000
      *    DB2 INCLUDES                                                *01230000
      ******************************************************************01240000
                                                                        
           EXEC SQL                                                     01260000
              INCLUDE SQLCA                                             01270000
           END-EXEC.                                                    01280000
                                                                        
      **** CSS_TRNSP_CONTRACT ****                                      01290100
           EXEC SQL                                                     01290200
              INCLUDE TBTRNCNT                                          01290300
           END-EXEC.                                                    01290400
                                                                        
      **** CSS_TRNSP_VOL_BLK ****                                       01290600
           EXEC SQL                                                     01290700
              INCLUDE TBTRNBLK                                          01290800
           END-EXEC.                                                    01290900
                                                                        
      **** CSS_UTIL_ENVRNMT ****                                        01500000
           EXEC SQL                                                     01510000
              INCLUDE TBUTLENV                                          01520000
           END-EXEC.                                                    01530000
                                                                        
      **** CSS_BILL_CONTRACT ****                                       01550000
           EXEC SQL                                                     01560000
              INCLUDE TBBLCNTR                                          01570000
           END-EXEC.                                                    01580000
                                                                        
                                                                        
      **** CSS_MNT_TRANS_HIST ****                                      01700000
           EXEC SQL                                                     01710000
              INCLUDE TBMNHIST                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      **** CSS_MT_TRN_HST_DET ****                                      01750000
           EXEC SQL                                                     01760000
              INCLUDE TBMNHDT                                           01770000
           END-EXEC.                                                    01780000
                                                                        
      **** CSS_ACCOUNT ****                                             01800000
           EXEC SQL                                                     01830000
              INCLUDE TBACCT                                            01840000
           END-EXEC.                                                    01850000
                                                                        
      **** CSS_USER_PROFILE ***                                         01870000
           EXEC SQL                                                     01880000
              INCLUDE TBUSRPRF                                          01890000
           END-EXEC.                                                    01900000
                                                                        
      **** CSS_RATE_COMP_DEF ***                                        01910100
           EXEC SQL                                                     01910200
              INCLUDE TBRTCDEF                                          01910300
           END-EXEC.                                                    01911000
                                                                        
      ******************************************************************02400000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02410000
      ******************************************************************02420000
                                                                        
REARCH*    COPY SYGWCOB.                                                02440000
REARCH*    COPY SYDBCOB.                                                02450000
           COPY CWS00303.                                               02460000
                                                                        
           COPY CCA00001.                                               02480000
           COPY CWS00027.                                               02490000
REARCH     EXEC SQL                                                     02491000
REARCH         INCLUDE CWSX0010                                         02492000
REARCH     END-EXEC.                                                    02493000
REARCH*    COPY CWS00010.                                               02494000
                                                                        
           EXEC SQL                                                     02520000
              INCLUDE CWS00013                                          02530000
           END-EXEC.                                                    02540000
                                                                        
      ******************************************************************02560000
      *    WORK AREAS                                                  *02570000
      ******************************************************************02580000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          02600000
REARCH*    05  GWL-PROC                POINTER.                         02610000
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         02620000
REARCH*    05  GWL-RC                  PIC S9(9) COMP.                  02630000
REARCH*    05  GWL-STATUS-NR           PIC S9(9) COMP.                  02640000
REARCH*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                  02650000
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                  02660000
REARCH*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                  02670000
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                  02680000
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  02690000
REARCH*                                                                 02704000
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                  PIC S9(9)   COMP.                02740000
REARCH*    05  PARM-ID1                PIC S9(9)   COMP   VALUE 1.      02750000
REARCH*    05  PARM-UPDATE-TYPE        PIC X(01)          VALUE SPACES. 02760000
REARCH*    05  PARM-USERID             PIC X(07)          VALUE SPACES. 02770000
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13)          VALUE SPACES. 02780000
REARCH*    05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        02790000
REARCH*                                PIC 9(13).                       02800000
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13) VALUE SPACES.          
REARCH     05  PARM-ACCOUNT-NO-RED REDEFINES PARM-ACCOUNT-NO-TEMP       
REARCH                                 PIC 9(13).                       
           05  PARM-ACCOUNT-NO-NUM     PIC S9(13)V COMP-3 VALUE 0.      
REARCH*    05  PARM-CODE-UTIL-TYPE     PIC X(01)          VALUE SPACES. 02820000
REARCH*    05  PARM-PRIMARY-IC-NO      PIC S9(4)   COMP   VALUE 0.      02920000
REARCH*    05  PARM-CNTRCT-START-DT    PIC X(10)          VALUE SPACES. 02920100
REARCH*    05  PARM-TRNSP-SHRINK-PCT   PIC X(04)          VALUE SPACES. 02920200
REARCH*    05  PARM-TRNSP-MDQ          PIC X(07)          VALUE SPACES. 02920300
REARCH*    05  PARM-TRANSM-ACCT-NO     PIC X(05)          VALUE SPACES. 02920400
REARCH*    05  PARM-SHIPPER            PIC X(01)          VALUE SPACES. 02920500
REARCH*    05  PARM-IC-NO              PIC S9(4)   COMP   VALUE 0.      02921000
REARCH*    05  PARM-CODE-REVENUE-CLASS PIC X(03)          VALUE SPACES. 03070000
REARCH*    05  PARM-RATE-PLAN-NO       PIC X(03)          VALUE SPACES. 03080000
REARCH*    05  PARM-TRAN-COMMENT-LEN   PIC X(04)          VALUE SPACES. 03090000
REARCH*    05  PARM-TRAN-COMMENT-TEXT  PIC X(210)         VALUE SPACES. 03120000
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
REARCH*                                                                 03474000
REARCH*                                                                 03474100
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18)      VALUE SPACES.   
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)       VALUE ' '.      
REARCH     10  S-TABLE-NAME              PIC X(18)      VALUE SPACES.   
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                 03475600
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                    PIC X(07) VALUE 'ROWICMS'.    
REARCH     05  GTT-NAME                   PIC X(26)                     
REARCH                                      VALUE 'SESSION.CSR02476_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN             PIC S9(04) COMP.              
REARCH         49 GTT-ROW-CHAR            PIC X(1024).                  
REARCH     05  GTT-SQLCODE                PIC S9(9) COMP.               
      *                                                                 03479400
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
REARCH*                                                                 03530000
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH*01  CN-COLUMN-NAMES.                                             03560000
REARCH*    05  CN-RETURN-CODE          PIC X(11) VALUE 'RETURN_CODE'.   03570000
                                                                        
       01  FLAGS.                                                       
           05  WS-CONT-EXISTS-FLAG     PIC X(03) VALUE 'NO '.           
               88 CONT-EXISTS                    VALUE 'YES'.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-IC-EXIST-SW          PIC X(01)      VALUE 'N'.        
               88 WS-IC-EXIST                         VALUE 'Y'.        
           05  WS-DT-EXIST-SW          PIC X(01)      VALUE 'N'.        
               88 WS-DT-EXIST                         VALUE 'Y'.        
           05  WS-ROW-EXIST-SW         PIC X(01)      VALUE 'N'.        
               88 WS-ROW-EXIST                         VALUE 'Y'.       
           05  WS-VALID-RATE-SW        PIC X(01)      VALUE 'N'.        
               88 WS-VALID-RATE                        VALUE 'Y'.       
           05  WS-UPDATE-SUCCESSFUL    PIC X(01) VALUE 'N'.             
               88 UPDATE-UNSUCCESSFUL            VALUE 'N'.             
               88 UPDATE-SUCCESSFUL              VALUE 'Y'.             
           05  WS-ROWS-PRESENT         PIC X(01) VALUE 'Y'.             
               88  ROWS-PRESENT                  VALUE 'Y'.             
               88  NO-ROWS-PRESENT               VALUE 'N'.             
                                                                        
       01  WS-MISC.                                                     
           05 WS-TRAN-APPL-NO           PIC S9(4) COMP VALUE 0.         
REARCH*    05 PROGRAM-NAME              PIC X(08)      VALUE 'S476    '.04130000
REARCH     05 PROGRAM-NAME              PIC X(08)      VALUE 'CSR02476'.
REARCH     05 WS-SQLSTATE               PIC X(5)       VALUE SPACES.    
           05 WS-RCVPRM                 PIC X(20)      VALUE SPACES.    
           05 WS-INSERT-TYPE            PIC X(01)      VALUE 'I'.       
           05 WS-DELETE-TYPE            PIC X(01)      VALUE 'D'.       
           05 WS-G                      PIC X(01)      VALUE 'G'.       
           05 WS-65                     PIC X(02)      VALUE '65'.      
           05 WS-UPDATE-TYPE            PIC X(01)      VALUE 'U'.       
           05 WS-RESP-AREA-ID           PIC X(03)      VALUE SPACES.    
           05 WS-MAX-SEQ                PIC 9(04)      VALUE ZEROS.     
           05 WS-TRNSP-SEQ              PIC S9(04) USAGE COMP           
                                                   VALUE ZEROS.         
           05 WS-NULL-SEQ              PIC S9(04) COMP VALUE 0.         
           05 WS-PRIMARY-IC-NO         PIC 9(02) VALUE 0.               
           05 WS-IC-NO                 PIC 9(02) VALUE 0.               
           05 WS-TRNSP-SHRINK-PCT-C    PIC X(04).                       
           05 WS-TRNSP-SHRINK-PCT-N    REDEFINES WS-TRNSP-SHRINK-PCT-C  
                                       PIC 9(02)V99.                    
COB305     05 WS-TRNSP-SHRINK-PCT        PIC S9(02)V99 COMP-3 VALUE 0.          
           05 WS-TRNSP-SHRINK-PCT-X    PIC ZZ.99.                       
           05 WS-TRNSP-MDQ-C           PIC X(07).                       
           05 WS-TRNSP-MDQ-N           REDEFINES WS-TRNSP-MDQ-C         
                                       PIC 9(07)V.                      
COB305     05 WS-TRNSP-MDQ        PIC S9(07)V COMP-3 VALUE 0.              
           05 WS-TRNSP-MDQ-X           PIC ZZZZZZ9.                     
           05 WS-TRANSM-ACCT-NO-C      PIC X(05).                       
           05 WS-TRANSM-ACCT-NO-N      REDEFINES WS-TRANSM-ACCT-NO-C    
                                       PIC 9(05)V.                      
COB305     05 WS-TRANSM-ACCT-NO        PIC S9(05)V COMP-3 VALUE 0.              
           05 WS-TRANSM-ACCT-NO-X      PIC ZZZZ9.                       
                                                                        
COB305     05 WS-TRNSP-SHRINK-PCT-PREV        PIC S9(02)V99 COMP-3 
COB305       VALUE 0.            
COB305     05 WS-TRNSP-MDQ-PREV        PIC S9(07)V COMP-3 VALUE 0.              
COB305     05 WS-TRANSM-ACCT-NO-PREV        PIC S9(05)V COMP-3 VALUE 0.         
           05 WS-FUEL-SHIPPER-CD-PREV  PIC X(1).                        
                                                                        
           05 WS-TRNSP-SHRINK-PCT-PREV-X PIC ZZ.99.                     
           05 WS-TRNSP-MDQ-PREV-X        PIC ZZZZZZ9.                   
           05 WS-TRANSM-ACCT-NO-PREV-X   PIC ZZZZ9.                     
                                                                        
           05 WS-CODE-REVENUE-CLASS      PIC X(3) VALUE SPACES.         
           05 WS-RATE-PLAN-NO            PIC X(3) VALUE SPACES.         
                                                                        
           05 WS-COMMENT-LEN            PIC 9(4) VALUE 0.               
           05  WS-COMMENT-LEN-NUM       PIC S9(4) USAGE COMP VALUE 0.   
           05  WS-COMMENT-TEXT          PIC X(210) VALUE SPACES.        
REARCH*                                                                 04351000
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                 04353000
REARCH 01  PARM-UPDATE-TYPE             PIC X(01).                      
REARCH 01  PARM-USERID                  PIC X(07).                      
REARCH 01  PARM-ACCOUNT-NO              PIC X(13).                      
REARCH 01  PARM-CODE-UTIL-TYPE          PIC X(01).                      
REARCH 01  PARM-PRIMARY-IC-NO           PIC S9(4) COMP.                 
REARCH 01  PARM-CNTRCT-START-DT         PIC X(10).                      
REARCH 01  PARM-TRNSP-SHRINK-PCT        PIC X(04).                      
REARCH 01  PARM-TRNSP-MDQ               PIC X(07).                      
REARCH 01  PARM-TRANSM-ACCT-NO          PIC X(05).                      
REARCH 01  PARM-SHIPPER                 PIC X(01).                      
REARCH 01  PARM-IC-NO                   PIC S9(4) COMP.                 
REARCH 01  PARM-CODE-REVENUE-CLASS      PIC X(03).                      
REARCH 01  PARM-RATE-PLAN-NO            PIC X(03).                      
REARCH 01  PARM-TRAN-COMMENT-LEN        PIC X(04).                      
REARCH 01  PARM-TRAN-COMMENT-TEXT       PIC X(210).                     
REARCH*                                                                 04360000
HPCCDM*EJECT                                                            05340000
      *                                                                 05341000
REARCH*                                                                 05350000
REARCH PROCEDURE DIVISION USING  PARM-UPDATE-TYPE                       
REARCH                          ,PARM-USERID                            
REARCH                          ,PARM-ACCOUNT-NO                        
REARCH                          ,PARM-CODE-UTIL-TYPE                    
REARCH                          ,PARM-PRIMARY-IC-NO                     
REARCH                          ,PARM-CNTRCT-START-DT                   
REARCH                          ,PARM-TRNSP-SHRINK-PCT                  
REARCH                          ,PARM-TRNSP-MDQ                         
REARCH                          ,PARM-TRANSM-ACCT-NO                    
REARCH                          ,PARM-SHIPPER                           
REARCH                          ,PARM-IC-NO                             
REARCH                          ,PARM-CODE-REVENUE-CLASS                
REARCH                          ,PARM-RATE-PLAN-NO                      
REARCH                          ,PARM-TRAN-COMMENT-LEN                  
REARCH                          ,PARM-TRAN-COMMENT-TEXT.                
REARCH*                                                                 05369600
      ******************************************************************05370000
      * 0000-MAINLINE.                                                 *05380000
      *     1. CONTROLS THE MAIN PATH OF THE PROGRAM                   *05390000
      ******************************************************************05400000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05510000
      * 0100-INITIALIZE.                                               *05520000
      *     1. RESET DB2 ERROR HANDLERS                                *05530000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *05540000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *05550000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*05560000
      *                                                                *05570000
      *     CALLED BY: 0000-MAINLINE                                   *05580000
      ******************************************************************05590000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                 05641000
REARCH*                                                                 05643000
REARCH     MOVE 'DECLARE C1 CURSOR'    TO   S-SQL-STATEMENT-V.          
REARCH*                                                                 05645000
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE     AS  RETURN_CODE                   
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     05646000
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        05647000
MFA-TR*        SELECT                                                   05648000
MFA-TR*            :S-RETURN-CODE     AS  RETURN_CODE                   05649000
MFA-TR*        FROM                                                     05649100
MFA-TR*            SYSIBM.SYSDUMMY1                                     05649200
MFA-TR*    END-EXEC.                                                    05649300
REARCH*                                                                 05649400
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK,                              05660000
REARCH*                          GWL-RC,                                05670000
REARCH*                          GWL-INIT-HANDLE.                       05680000
REARCH*                                                                 05690000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC,                              05700000
REARCH*                          GWL-RC,                                05710000
REARCH*                          GWL-INIT-HANDLE,                       05720000
REARCH*                          SNA-CONNECTION-NAME,                   05730000
REARCH*                          SNA-SUBC.                              05740000
REARCH*                                                                 05750000
REARCH*    CALL 'TDRESULT' USING GWL-PROC,                              05760000
REARCH*                          GWL-RC.                                05770000
REARCH*                                                                 05780000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             05790000
REARCH*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        05800000
REARCH*       MOVE '0100'                       TO ACTIVE-PARAGRAPH     05810000
REARCH*       MOVE 'TDRESULT- NO RPC PARM SENT' TO ABEND-FUNCTION       05820000
REARCH*       MOVE 'CICS TRANSACTION'           TO TABLE-1              05830000
REARCH*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE05840000
REARCH*       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          05850000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          05860000
REARCH*    END-IF.                                                      05870000
REARCH*                                                                 05880000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05934000
      * 1000-PROCESS-INPUT.                                            *05940000
      *     1. RECEIVE PARMS FROM THE CLIENT.                          *05950000
      *     2. MOVE NUMERIC PARMS FROM PIC9()'S TO PICS9() COMP'S.     *05960000
      *                                                                *05970000
      *     CALLED BY: 0000-MAINLINE                                   *05980000
      ******************************************************************05990000
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS       THRU 1100-EXIT.             06020000
REARCH     MOVE PARM-ACCOUNT-NO             TO PARM-ACCOUNT-NO-TEMP.    
           MOVE PARM-ACCOUNT-NO-RED         TO PARM-ACCOUNT-NO-NUM.     
           MOVE PARM-TRNSP-SHRINK-PCT       TO WS-TRNSP-SHRINK-PCT-C    
           MOVE WS-TRNSP-SHRINK-PCT-N       TO WS-TRNSP-SHRINK-PCT      
                                               WS-TRNSP-SHRINK-PCT-X.   
           MOVE PARM-TRNSP-MDQ              TO WS-TRNSP-MDQ-C           
           MOVE WS-TRNSP-MDQ-N              TO WS-TRNSP-MDQ             
                                               WS-TRNSP-MDQ-X.          
           MOVE PARM-TRANSM-ACCT-NO         TO WS-TRANSM-ACCT-NO-C      
           MOVE WS-TRANSM-ACCT-NO-N         TO WS-TRANSM-ACCT-NO        
                                               WS-TRANSM-ACCT-NO-X.     
           MOVE PARM-TRAN-COMMENT-LEN       TO WS-COMMENT-LEN.          
           MOVE WS-COMMENT-LEN              TO WS-COMMENT-LEN-NUM.      
           MOVE PARM-TRAN-COMMENT-TEXT      TO WS-COMMENT-TEXT.         
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************06190000
      * 1100-RECEIVE-PARMS.                                            *06200000
      *                                                                *06210000
      *     CALLED BY: 1000-PROCESS-INPUT                              *06220000
      ******************************************************************06230000
REARCH*1100-RECEIVE-PARMS.                                              06240000
REARCH*                                                                 06250000
REARCH*    MOVE 1                          TO PARM-ID1.                 06260000
REARCH*    MOVE LENGTH OF PARM-UPDATE-TYPE TO MAX-LENGTH-PARM.          06270000
REARCH*    MOVE 'UPDATE-TYPE'              TO WS-RCVPRM.                06280000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              06290000
REARCH*                          GWL-RC,                                06300000
REARCH*                          PARM-ID1,                              06310000
REARCH*                          PARM-UPDATE-TYPE,                      06320000
REARCH*                          TDSCHAR,                               06330000
REARCH*                          MAX-LENGTH-PARM,                       06340000
REARCH*                          PARM-L.                                06350000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     06360000
REARCH*                                                                 06500000
REARCH*    ADD  1                          TO PARM-ID1.                 06501000
REARCH*    MOVE LENGTH OF PARM-USERID      TO MAX-LENGTH-PARM.          06502000
REARCH*    MOVE 'USER-ID'                  TO WS-RCVPRM.                06503000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              06504000
REARCH*                          GWL-RC,                                06505000
REARCH*                          PARM-ID1,                              06506000
REARCH*                          PARM-USERID,                           06507000
REARCH*                          TDSCHAR,                               06508000
REARCH*                          MAX-LENGTH-PARM,                       06509000
REARCH*                          PARM-L.                                06509100
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     06509200
REARCH*                                                                 06509300
REARCH*    ADD 1                           TO PARM-ID1.                 06510000
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO  TO MAX-LENGTH-PARM.          06520000
REARCH*    MOVE 'ACCOUNT-NO'               TO WS-RCVPRM.                06530000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              06540000
REARCH*                          GWL-RC,                                06550000
REARCH*                          PARM-ID1,                              06560000
REARCH*                          PARM-ACCOUNT-NO,                       06570000
REARCH*                          TDSCHAR,                               06580000
REARCH*                          MAX-LENGTH-PARM,                       06590000
REARCH*                          PARM-L.                                06600000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     06610000
REARCH*                                                                 07100000
REARCH*    ADD 1                              TO PARM-ID1.              07101000
REARCH*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE TO MAX-LENGTH-PARM.       07102000
REARCH*    MOVE 'CODE-UTIL-TYPE'              TO WS-RCVPRM.             07103000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07104000
REARCH*                          GWL-RC,                                07105000
REARCH*                          PARM-ID1,                              07106000
REARCH*                          PARM-CODE-UTIL-TYPE,                   07107000
REARCH*                          TDSCHAR,                               07108000
REARCH*                          MAX-LENGTH-PARM,                       07109000
REARCH*                          PARM-L.                                07109100
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07109200
REARCH*                                                                 07109300
REARCH*    ADD 1                             TO PARM-ID1.               07110000
REARCH*    MOVE LENGTH OF PARM-PRIMARY-IC-NO TO MAX-LENGTH-PARM.        07120000
REARCH*    MOVE 'PRIMARY-IC-NO'              TO WS-RCVPRM.              07130000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07140000
REARCH*                          GWL-RC,                                07150000
REARCH*                          PARM-ID1,                              07160000
REARCH*                          PARM-PRIMARY-IC-NO,                    07170000
REARCH*                          TDSINT2,                               07180000
REARCH*                          MAX-LENGTH-PARM,                       07190000
REARCH*                          PARM-L.                                07200000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07210000
REARCH*                                                                 07220000
REARCH*    ADD 1                          TO PARM-ID1.                  07220100
REARCH*    MOVE LENGTH OF PARM-CNTRCT-START-DT TO   MAX-LENGTH-PARM.    07220200
REARCH*    MOVE 'CNTRCT-START-DT'         TO WS-RCVPRM.                 07220300
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07220400
REARCH*                          GWL-RC,                                07220500
REARCH*                          PARM-ID1,                              07220600
REARCH*                          PARM-CNTRCT-START-DT,                  07220700
REARCH*                          TDSCHAR,                               07220800
REARCH*                          MAX-LENGTH-PARM,                       07220900
REARCH*                          PARM-L.                                07221000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07221100
REARCH*                                                                 07221200
REARCH*    ADD 1                          TO PARM-ID1.                  07221300
REARCH*    MOVE LENGTH OF PARM-TRNSP-SHRINK-PCT TO   MAX-LENGTH-PARM.   07221400
REARCH*    MOVE 'TRNSP-SHRINK-PCT'         TO WS-RCVPRM.                07221500
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07221600
REARCH*                          GWL-RC,                                07221700
REARCH*                          PARM-ID1,                              07221800
REARCH*                          PARM-TRNSP-SHRINK-PCT,                 07221900
REARCH*                          TDSCHAR,                               07222000
REARCH*                          MAX-LENGTH-PARM,                       07222100
REARCH*                          PARM-L.                                07222200
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07222300
REARCH*                                                                 07222400
REARCH*    ADD 1                          TO PARM-ID1.                  07222500
REARCH*    MOVE LENGTH OF PARM-TRNSP-MDQ        TO   MAX-LENGTH-PARM.   07222600
REARCH*    MOVE 'TRNSP-MDQ'                TO WS-RCVPRM.                07222700
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07222800
REARCH*                          GWL-RC,                                07222900
REARCH*                          PARM-ID1,                              07223000
REARCH*                          PARM-TRNSP-MDQ,                        07223100
REARCH*                          TDSCHAR,                               07223200
REARCH*                          MAX-LENGTH-PARM,                       07223300
REARCH*                          PARM-L.                                07223400
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07223500
REARCH*                                                                 07223600
REARCH*    ADD 1                          TO PARM-ID1.                  07223700
REARCH*    MOVE LENGTH OF PARM-TRANSM-ACCT-NO   TO   MAX-LENGTH-PARM.   07223800
REARCH*    MOVE 'TRANSM-ACCT-NO'           TO WS-RCVPRM.                07223900
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07224000
REARCH*                          GWL-RC,                                07224100
REARCH*                          PARM-ID1,                              07224200
REARCH*                          PARM-TRANSM-ACCT-NO,                   07224300
REARCH*                          TDSCHAR,                               07224400
REARCH*                          MAX-LENGTH-PARM,                       07224500
REARCH*                          PARM-L.                                07224600
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07224700
REARCH*                                                                 07224800
REARCH*    ADD 1                                  TO PARM-ID1.          07224900
REARCH*    MOVE LENGTH OF PARM-SHIPPER            TO MAX-LENGTH-PARM.   07225000
REARCH*    MOVE 'SHIPPER'                         TO WS-RCVPRM.         07225100
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07225200
REARCH*                          GWL-RC,                                07225300
REARCH*                          PARM-ID1,                              07225400
REARCH*                          PARM-SHIPPER,                          07225500
REARCH*                          TDSCHAR,                               07225600
REARCH*                          MAX-LENGTH-PARM,                       07225700
REARCH*                          PARM-L.                                07225800
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07225900
REARCH*                                                                 07226000
REARCH*    ADD 1                           TO PARM-ID1.                 07226100
REARCH*    MOVE LENGTH OF PARM-IC-NO       TO MAX-LENGTH-PARM.          07226200
REARCH*    MOVE 'IC-NO'                    TO WS-RCVPRM.                07226300
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07226400
REARCH*                          GWL-RC,                                07226500
REARCH*                          PARM-ID1,                              07226600
REARCH*                          PARM-IC-NO,                            07227000
REARCH*                          TDSINT2,                               07228000
REARCH*                          MAX-LENGTH-PARM,                       07229000
REARCH*                          PARM-L.                                07229100
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07229200
REARCH*                                                                 07230000
REARCH*    ADD 1                                  TO PARM-ID1.          07480000
REARCH*    MOVE LENGTH OF PARM-CODE-REVENUE-CLASS TO MAX-LENGTH-PARM.   07490000
REARCH*    MOVE 'CODE-REVENUE-CLAS'               TO WS-RCVPRM.         07500000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07510000
REARCH*                          GWL-RC,                                07520000
REARCH*                          PARM-ID1,                              07530000
REARCH*                          PARM-CODE-REVENUE-CLASS,               07540000
REARCH*                          TDSCHAR,                               07550000
REARCH*                          MAX-LENGTH-PARM,                       07560000
REARCH*                          PARM-L.                                07570000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07580000
REARCH*                                                                 07590000
REARCH*    ADD 1                                  TO PARM-ID1.          07600000
REARCH*    MOVE LENGTH OF PARM-RATE-PLAN-NO       TO MAX-LENGTH-PARM.   07610000
REARCH*    MOVE 'RATE-PLAN-NO'                    TO WS-RCVPRM.         07620000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07630000
REARCH*                          GWL-RC,                                07640000
REARCH*                          PARM-ID1,                              07650000
REARCH*                          PARM-RATE-PLAN-NO,                     07660000
REARCH*                          TDSCHAR,                               07670000
REARCH*                          MAX-LENGTH-PARM,                       07680000
REARCH*                          PARM-L.                                07690000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07700000
REARCH*                                                                 07710000
REARCH*    ADD 1                                  TO PARM-ID1.          07720000
REARCH*    MOVE LENGTH OF PARM-TRAN-COMMENT-LEN   TO MAX-LENGTH-PARM.   07730000
REARCH*    MOVE 'TRAN-COMMENT-LEN'                TO WS-RCVPRM.         07740000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07750000
REARCH*                          GWL-RC,                                07760000
REARCH*                          PARM-ID1,                              07770000
REARCH*                          PARM-TRAN-COMMENT-LEN,                 07780000
REARCH*                          TDSCHAR,                               07790000
REARCH*                          MAX-LENGTH-PARM,                       07800000
REARCH*                          PARM-L.                                07810000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07820000
REARCH*                                                                 07830000
REARCH*    ADD 1                                  TO PARM-ID1.          07840000
REARCH*    MOVE LENGTH OF  PARM-TRAN-COMMENT-TEXT TO MAX-LENGTH-PARM.   07850000
REARCH*    MOVE 'TRAN-COMMENT-TEXT'               TO WS-RCVPRM.         07860000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              07870000
REARCH*                          GWL-RC,                                07880000
REARCH*                          PARM-ID1,                              07890000
REARCH*                           PARM-TRAN-COMMENT-TEXT,               07900000
REARCH*                          TDSCHAR,                               07910000
REARCH*                          MAX-LENGTH-PARM,                       07920000
REARCH*                          PARM-L.                                07930000
REARCH*    PERFORM 1150-CHECK-ERROR THRU 1150-EXIT.                     07940000
REARCH*                                                                 07950000
REARCH*                                                                 10360000
REARCH*1100-EXIT.                                                       10370000
REARCH*    EXIT.                                                        10380000
                                                                        
      ******************************************************************10400000
      * 1150-CHECK-ERROR.                                              *10410000
      *     1. CHECK FOR ERROR RECEIVING PARAMETERS.                   *10420000
      *                                                                *10430000
      *     CALLED BY: 1100-RECEIVE-PARMS.                             *10440000
      ******************************************************************10450000
REARCH*1150-CHECK-ERROR.                                                10460000
REARCH*                                                                 10470000
REARCH*    IF GWL-RC NOT = TDS-OK                                       10480000
REARCH*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        10490000
REARCH*       MOVE 'TDRCVPRM - PARAMETER ERROR' TO ABEND-FUNCTION       10500000
REARCH*       MOVE WS-RCVPRM                    TO TABLE-1              10510000
REARCH*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE10520000
REARCH*       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          10530000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          10540000
REARCH*    END-IF.                                                      10550000
REARCH*                                                                 10560000
REARCH*1150-EXIT.                                                       10570000
REARCH*    EXIT.                                                        10580000
                                                                        
      ******************************************************************10600000
      * 2000-PROCESS-OUTPUT                                            *10610000
      *     1. DESCRIBE RESULT SET                                     *10620000
      *     2. RETRIEVE DB2 DATA                                       *10630000
      *     3. BUILD RESULT SET                                        *10640000
      *     4. SEND RESULT SET                                         *10650000
      *                                                                *10660000
      *     CALLED BY: 0000-MAINLINE                                   *10670000
      ******************************************************************10680000
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT         THRU 2100-EXIT.         10710000
           PERFORM 5000-UPDATE                  THRU 5000-EXIT.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE           TO RS-RETURN-CODE.      
           MOVE '2000'                          TO ACTIVE-PARAGRAPH.    
REARCH     PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
REARCH     ADD 1                                TO CTR-ROWS.            
REARCH*    PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         10770000
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************10812100
REARCH* 2000A-MOVE-RESULT                                              *10812200
REARCH******************************************************************10812600
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE  RS-RETURN-CODE          TO  S-RETURN-CODE.             
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                 10819100
      ******************************************************************10820000
      * 2100-DESCRIBE-RESULT                                           *10830000
      *     1.  DESCRIBE EACH COLUMN IN THE RESULT SET.                *10840000
      *                                                                *10850000
      *     CALLED BY: 2000-PROCESS-OUTPUT                             *10860000
      ******************************************************************10870000
REARCH*2100-DESCRIBE-RESULT.                                            10880000
REARCH*    MOVE '2100'                   TO ACTIVE-PARAGRAPH.           10890000
REARCH*                                                                 10900000
REARCH*    MOVE 1                         TO CTR-COLUMN.                10910000
REARCH*    MOVE TDSINT4                   TO DB-HOST-TYPE.              10920000
REARCH*    MOVE TDSINT4                   TO DB-CLIENT-TYPE.            10930000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE  TO WRKLEN1.                   10940000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE  TO WRKLEN2.                   10950000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              10960000
REARCH*                          GWL-RC,                                10970000
REARCH*                          CTR-COLUMN,                            10980000
REARCH*                          DB-HOST-TYPE,                          10990000
REARCH*                          WRKLEN1,                               11000000
REARCH*                          RS-RETURN-CODE,                        11010000
REARCH*                          DB-NULL-INDICATOR,                     11020000
REARCH*                          TDS-FALSE,                             11030000
REARCH*                          DB-CLIENT-TYPE,                        11040000
REARCH*                          WRKLEN1,                               11050000
REARCH*                          CN-RETURN-CODE,                        11060000
REARCH*                          WRKLEN2.                               11070000
REARCH*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                     11080000
REARCH*                                                                 11090000
REARCH*                                                                 11481900
REARCH*2100-EXIT.                                                       11482000
REARCH*    EXIT.                                                        11490000
                                                                        
                                                                        
      ******************************************************************13210000
      * 5000-UPDATE.                                                   *13220000
      *     1. PERFORM UPDATE BASED ON ACTION CODE (INSERT/UPDATE/     *13230000
      *        DELETE).                                                *13240000
      *                                                                *13250000
      *     CALLED BY: 2000-PROCESS-OUTPUT                             *13260000
      ******************************************************************13270000
       5000-UPDATE.                                                     
                                                                        
           PERFORM  7600-SELECT-RESP-AREA-ID    THRU 7600-EXIT.         
                                                                        
                                                                        
           MOVE 1                            TO WS-TRAN-APPL-NO,        
                                                MI-TRAN-APPL-NO.        
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM          TO UT-ACCOUNT-NO,          
                                                AT-ACCOUNT-NO,          
                                                TW-ACCOUNT-NO,          
                                                TZ-ACCOUNT-NO,          
                                                BK-ACCOUNT-NO.          
           MOVE PARM-CODE-UTIL-TYPE         TO  UT-CODE-UTIL-TYPE,      
                                                BK-CODE-UTIL-TYPE.      
           MOVE PARM-IC-NO                   TO UT-IC-NO,               
                                                WS-IC-NO,               
                                                BK-IC-NO.               
           MOVE PARM-PRIMARY-IC-NO           TO WS-PRIMARY-IC-NO.       
           MOVE PARM-CNTRCT-START-DT         TO BK-CNTRCT-START-DT.     
                                                                        
           PERFORM 7000-SELECT-ACCOUNT-DTLS THRU 7000-EXIT.             
                                                                        
           IF PARM-UPDATE-TYPE = WS-INSERT-TYPE                         
              PERFORM 5100-FORMAT-JRNL-HEAD   THRU 5100-EXIT            
              PERFORM 7100-CHECK-VALID-IC     THRU 7100-EXIT            
              IF NOT WS-IC-EXIST                                        
                 MOVE 5000              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7200-CHECK-VALID-DATE   THRU 7200-EXIT            
              IF NOT WS-DT-EXIST                                        
                 MOVE 5100              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7300-CHECK-DATE-EXIST   THRU 7300-EXIT            
              IF WS-ROW-EXIST                                           
                 MOVE 5200              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7400-CHECK-CNTRCT-DEMAND THRU 7400-EXIT           
              IF BK-CONTRACT-DEMAND <= 0                                
                 MOVE 5300               TO WS-ACTIVE-RETURN-CODE       
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7700-CHECK-VALID-RATE    THRU 7700-EXIT           
              IF NOT WS-VALID-RATE                                      
                 MOVE 5400               TO WS-ACTIVE-RETURN-CODE       
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7500-GET-MAX-VOL-SEQ     THRU 7500-EXIT           
              IF WS-NULL-SEQ < 0                                        
                 MOVE 0                           TO WS-MAX-SEQ         
              ELSE                                                      
                 MOVE WS-TRNSP-SEQ                TO WS-MAX-SEQ         
              END-IF                                                    
              IF WS-MAX-SEQ = 0                                         
                 MOVE 1                        TO TZ-TRNSP-SEQ          
                 MOVE 1                        TO WS-MAX-SEQ            
              ELSE                                                      
                 ADD  1                        TO WS-MAX-SEQ            
                 MOVE WS-MAX-SEQ               TO TZ-TRNSP-SEQ          
              END-IF                                                    
              PERFORM 5200-JRNL-UPDATE          THRU 5200-EXIT          
              PERFORM 5300-PROCESS-TRNSP-CNTRCT THRU 5300-EXIT          
           END-IF                                                       
                                                                        
           IF PARM-UPDATE-TYPE = WS-UPDATE-TYPE                         
              PERFORM 5100-FORMAT-JRNL-HEAD   THRU 5100-EXIT            
              PERFORM 7400-CHECK-CNTRCT-DEMAND THRU 7400-EXIT           
              IF BK-CONTRACT-DEMAND <= 0                                
                 MOVE 5000              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7700-CHECK-VALID-RATE    THRU 7700-EXIT           
              IF NOT WS-VALID-RATE                                      
                 MOVE 5400               TO WS-ACTIVE-RETURN-CODE       
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 5500-GET-PREV-TRNSP      THRU 5500-EXIT           
              PERFORM 5600-GET-PREV-TRNSP-VOL  THRU 5600-EXIT           
              PERFORM 5400-UPDATE-TRNSP-CNTRCT THRU 5400-EXIT           
              PERFORM 5200-JRNL-UPDATE         THRU 5200-EXIT           
           END-IF                                                       
                                                                        
           IF PARM-UPDATE-TYPE = WS-DELETE-TYPE                         
              PERFORM 5100-FORMAT-JRNL-HEAD   THRU 5100-EXIT            
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
                 PERFORM 8500-DELETE-TRNSP-VOL-BLK THRU 8500-EXIT       
                 PERFORM 8400-DELETE-TRNSP-CNTRCT  THRU 8400-EXIT       
              ELSE                                                      
                 PERFORM 8600-DELETE-TRNSP-VOL-BLK THRU 8600-EXIT       
              END-IF                                                    
                                                                        
              PERFORM 5200-JRNL-UPDATE         THRU 5200-EXIT           
           END-IF.                                                      
                                                                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14360000
      * 5100-FORMAT-JRNL-HEAD.                                         *14370000
      *     1. MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *14380000
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *14390000
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *14400000
      *                                                                *14410000
      *     CALLED BY: 5000-UPDATE                                     *14420000
      ******************************************************************14430000
       5100-FORMAT-JRNL-HEAD.                                           
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14460000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP,            14461000
MFA-TR*           :MH-DATE-TRANS  = CURRENT DATE                        14462000
MFA-TR*    END-EXEC.                                                    14520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5100'                     TO ACTIVE-PARAGRAPH       
T35434        MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE WS-RESP-AREA-ID               TO MH-RESP-AREA-ID.       
           MOVE PARM-ACCOUNT-NO-NUM           TO MH-ACCOUNT-NO.         
           MOVE AT-CUSTOMER-NO                TO MH-CUSTOMER-NO.        
           MOVE AT-PREMISE-NO                 TO MH-PREMISE-NO.         
           MOVE PARM-USERID                   TO MH-USER-ID.            
           MOVE 'PANEL502'                    TO MH-APPL-PROGRAM-ID.    
           MOVE WS-COMMENT-LEN-NUM            TO MH-TRAN-COMMENT-LEN.   
           MOVE WS-COMMENT-TEXT               TO MH-TRAN-COMMENT-TEXT.  
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14820000
      * 5200-JRNL-UPDATE.                                              *14830000
      *     JOURNAL CSS_TRNSP_CONTRACT CSS_TRNSP_VOL_BLK FIELDS        *14840000
      *     THAT ARE INSERTED / UPDATED / DELETED                      *14841000
      *                                                                *14850000
      *     CALLED BY: 5000-UPDATE                                     *14860000
      ******************************************************************14870000
       5200-JRNL-UPDATE.                                                
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
                                                                        
           IF  PARM-UPDATE-TYPE = WS-INSERT-TYPE                        
      ******FOR PRIMARY-IC-NO *****                                     15672000
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +02                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-PRIMARY-IC-NO     TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'PRIMARY IC NO  '       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR IC-NO *****                                             15960100
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +02                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-IC-NO             TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'IC NO  '            TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CNTRCT-START-DT****                                     15961600
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE PARM-CNTRCT-START-DT TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CNTRCT START DT'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CODE REVENUE CLASS ****                                 15963000
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TZ'                    TO MI-TABLE-ID               
                                                                        
              MOVE +3                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE PARM-CODE-REVENUE-CLASS TO MI-CHG-COLUMN-VALUE-TEXT  
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CODE REV CLS'   TO MI-COLUMN-DESC                   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR RATE PLAN NO  ****                                      15964400
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TZ'                    TO MI-TABLE-ID               
                                                                        
              MOVE +3                      TO MI-CHG-COLUMN-VALUE-LEN   
              MOVE PARM-RATE-PLAN-NO       TO MI-CHG-COLUMN-VALUE-TEXT  
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'RATE PLAN NO'       TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
      ******FOR TRNSP-SHRINK-PCT ****                                   15965900
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +05                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-TRNSP-SHRINK-PCT-X TO MI-CHG-COLUMN-VALUE-TEXT    
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'TRNSP SHRNK PCT'       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR TRNSP-MDQ ****                                          15967300
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +07                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-TRNSP-MDQ-X        TO MI-CHG-COLUMN-VALUE-TEXT    
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'TRNSP MDQ'             TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR TRANSM-ACCT-NO ****                                     15968700
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +05                   TO MI-CHG-COLUMN-VALUE-LEN     
              MOVE WS-TRANSM-ACCT-NO-X   TO MI-CHG-COLUMN-VALUE-TEXT    
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'TRANSM ACCT NO'        TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR FUEL-SHIPER-CD ****                                     15971100
              IF PARM-SHIPPER > ' '                                     
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'TW'                    TO MI-TABLE-ID            
                                                                        
                 MOVE +01                   TO MI-CHG-COLUMN-VALUE-LEN  
                 MOVE PARM-SHIPPER          TO MI-CHG-COLUMN-VALUE-TEXT 
                                                                        
                 MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN   
                 MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT  
                                                                        
                 MOVE 'FUEL SHIPPER CD'       TO MI-COLUMN-DESC         
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
              END-IF                                                    
              END-IF                                                    
                                                                        
      ******FOR TRNSP-SEQ***                                            15972800
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-MAX-SEQ           TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'TRNSP SEQ'          TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CODE-UTIL-TYPE ****                                     15974200
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +01                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE PARM-CODE-UTIL-TYPE  TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CODE UTIL TYPE'     TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
           END-IF.                                                      
                                                                        
           IF  PARM-UPDATE-TYPE = WS-UPDATE-TYPE                        
                                                                        
              IF WS-TRNSP-SHRINK-PCT-PREV NOT = WS-TRNSP-SHRINK-PCT     
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'TW'                    TO MI-TABLE-ID            
                                                                        
                 IF WS-TRNSP-SHRINK-PCT    > ZEROS                      
                  MOVE +05                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-TRNSP-SHRINK-PCT-X TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                                                                        
                 IF WS-TRNSP-SHRINK-PCT-PREV  > ZEROS                   
                   MOVE +05                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE WS-TRNSP-SHRINK-PCT-PREV-X                      
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 MOVE 'TRNSP SHRNK PCT'      TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
              END-IF                                                    
                                                                        
              IF WS-TRNSP-MDQ-PREV NOT = WS-TRNSP-MDQ                   
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'TW'                    TO MI-TABLE-ID            
                                                                        
                 IF WS-TRNSP-MDQ           > ZEROS                      
                  MOVE +07                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-TRNSP-MDQ-X        TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                                                                        
                 IF WS-TRNSP-MDQ-PREV         > ZEROS                   
                   MOVE +07                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE WS-TRNSP-MDQ-PREV-X  TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 MOVE 'TRNSP MDQ'            TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
              END-IF                                                    
                                                                        
              IF WS-TRANSM-ACCT-NO-PREV NOT = WS-TRANSM-ACCT-NO         
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'TW'                    TO MI-TABLE-ID            
                                                                        
                 IF WS-TRANSM-ACCT-NO      > ZEROS                      
                  MOVE +05                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-TRANSM-ACCT-NO-X   TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                                                                        
                 IF WS-TRANSM-ACCT-NO-PREV    > ZEROS                   
                   MOVE +05                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE WS-TRANSM-ACCT-NO-PREV-X                        
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 MOVE 'TRANSM ACCT NO'       TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
             END-IF                                                     
                                                                        
              IF WS-FUEL-SHIPPER-CD-PREV NOT = PARM-SHIPPER             
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'TW'                    TO MI-TABLE-ID            
                                                                        
                 IF PARM-SHIPPER           > ' '                        
                  MOVE +01                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE PARM-SHIPPER          TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                                                                        
                 IF WS-FUEL-SHIPPER-CD-PREV   > ' '                     
                   MOVE +01                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE WS-FUEL-SHIPPER-CD-PREV                         
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 MOVE 'FUEL SHIPPER CD'      TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
             END-IF                                                     
                                                                        
              IF WS-CODE-REVENUE-CLASS  NOT = PARM-CODE-REVENUE-CLASS   
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'TZ'                    TO MI-TABLE-ID            
                                                                        
                 IF PARM-CODE-REVENUE-CLASS > SPACES                    
                  MOVE +03                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE PARM-CODE-REVENUE-CLASS                          
                                             TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                                                                        
                 IF WS-CODE-REVENUE-CLASS     > SPACES                  
                   MOVE +03                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE WS-CODE-REVENUE-CLASS                           
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 MOVE 'CODE REV CLS'        TO MI-COLUMN-DESC           
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
             END-IF                                                     
                                                                        
              IF WS-RATE-PLAN-NO        NOT = PARM-RATE-PLAN-NO         
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'TZ'                    TO MI-TABLE-ID            
                                                                        
                 IF PARM-RATE-PLAN-NO       > SPACES                    
                  MOVE +03                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE PARM-RATE-PLAN-NO     TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                                                                        
                 IF WS-RATE-PLAN-NO           > SPACES                  
                   MOVE +03                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE WS-RATE-PLAN-NO  TO MI-PRV-COLUMN-VALUE-TEXT    
                 ELSE                                                   
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 MOVE 'RATE PLAN NO'         TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF  PARM-UPDATE-TYPE = WS-DELETE-TYPE                        
      ******FOR PRIMARY-IC-NO *****                                     15991600
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE WS-PRIMARY-IC-NO     TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'PRIMARY IC NO  '       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR IC-NO *****                                             15993000
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
                 MOVE +3                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE 'ALL'             TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 MOVE +2                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE WS-IC-NO          TO MI-PRV-COLUMN-VALUE-TEXT     
              END-IF                                                    
                                                                        
              MOVE 'IC NO  '            TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CNTRCT-START-DT****                                     15994900
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE PARM-CNTRCT-START-DT TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CNTRCT START DT'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CODE-REVENUE-CLASS ***                                  15996300
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TZ'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
                 MOVE +3                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE 'ALL'             TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 MOVE +03               TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE PARM-CODE-REVENUE-CLASS                           
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
              END-IF                                                    
                                                                        
              MOVE 'CODE REV CLS'   TO MI-COLUMN-DESC                   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR RATE-PLAN-NO       ***                                  15998300
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TZ'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
                 MOVE +3                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE 'ALL'             TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 MOVE +03               TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE PARM-RATE-PLAN-NO                                 
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
              END-IF                                                    
                                                                        
              MOVE 'RATE PLAN NO'   TO MI-COLUMN-DESC                   
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
      ******FOR TRNSP SHRINK PCT****                                    16000400
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +4                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE WS-TRNSP-SHRINK-PCT-X                                
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'TRNSP SHRINK PCT'   TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR TRNSP MDQ****                                           16001900
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +7                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE WS-TRNSP-MDQ-X       TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'TRNSP MDQ'          TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR TRANSM ACCT NO ****                                     16003300
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +4                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE WS-TRANSM-ACCT-NO-X  TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'TRANSM ACCT NO'     TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
              END-IF                                                    
                                                                        
      ******FOR FUEL-SHIPPER-CD****                                     16004800
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE PARM-SHIPPER         TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'FUEL SHIPPER CD'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CODE-UTIL-TYPE ****                                     16006200
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'TW'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE PARM-CODE-UTIL-TYPE  TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CODE UTIL TYPE'     TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21360000
      * 5300-PROCESS-TRNSP-CNTRCT.                                     *21370000
      *                                                                *21380000
      *    INSERT TRANSPORTAION AGREEMENT DETAILS IN CSS_TRNSP_CONTRACT*21390000
      *    AND CSS_TRNSP_VOL_BLK TABLES.                                21400000
      *                                                                *21410000
      *     CALLED BY: 5000-UPDATE                                     *21420000
      ******************************************************************21430000
       5300-PROCESS-TRNSP-CNTRCT.                                       
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM      TO TW-ACCOUNT-NO               
                                            TZ-ACCOUNT-NO.              
           MOVE PARM-CODE-UTIL-TYPE      TO TW-CODE-UTIL-TYPE           
                                            TZ-CODE-UTIL-TYPE.          
           MOVE PARM-PRIMARY-IC-NO       TO TW-PRIMARY-IC-NO            
                                            TZ-PRIMARY-IC-NO.           
           MOVE PARM-CNTRCT-START-DT     TO TW-CNTRCT-START-DT          
                                            TZ-CNTRCT-START-DT.         
           MOVE WS-TRNSP-SHRINK-PCT      TO TW-TRNSP-SHRINK-PCT.        
           MOVE WS-TRNSP-MDQ             TO TW-TRNSP-MDQ.               
           MOVE WS-TRANSM-ACCT-NO        TO TW-TRANSM-ACCT-NO.          
           MOVE PARM-SHIPPER             TO TW-FUEL-SHIPPER-CD.         
           MOVE PARM-IC-NO               TO TZ-IC-NO.                   
           MOVE PARM-CODE-REVENUE-CLASS  TO TZ-CODE-REVENUE-CLASS.      
           MOVE PARM-RATE-PLAN-NO        TO TZ-RATE-PLAN-NO.            
                                                                        
      * INSERT HOST VARIABLES. *                                        22510000
           IF PARM-PRIMARY-IC-NO = PARM-IC-NO                           
              PERFORM 8000-INSERT-TRNSP-CNTRCT  THRU 8000-EXIT          
              PERFORM 8100-INSERT-TRNSP-VOL-BLK THRU                    
                                                8100-INSERT-EXIT        
           ELSE                                                         
              PERFORM 8100-INSERT-TRNSP-VOL-BLK THRU                    
                                                8100-INSERT-EXIT        
           END-IF.                                                      
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************22831000
      * 5400-UPDATE-TRNSP-CNTRCT                                       *22832000
      *       UPDATES THE FOLLOWING TABLES (IF CHANGES ARE MADE)       *22833000
      *       A) CSS_TRNSP_CONTRACT TW                                 *22833100
      *       A) CSS_TRNSP_VOL_BLK  TZ                                 *22833200
      *                                                                *22834000
      *     CALLED BY: 5000-UPDATE                                     *22835000
      ******************************************************************22836000
       5400-UPDATE-TRNSP-CNTRCT.                                        
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM      TO TW-ACCOUNT-NO               
                                            TZ-ACCOUNT-NO.              
           MOVE PARM-CODE-UTIL-TYPE      TO TW-CODE-UTIL-TYPE           
                                            TZ-CODE-UTIL-TYPE.          
           MOVE PARM-PRIMARY-IC-NO       TO TW-PRIMARY-IC-NO            
                                            TZ-PRIMARY-IC-NO.           
           MOVE PARM-CNTRCT-START-DT     TO TW-CNTRCT-START-DT          
                                            TZ-CNTRCT-START-DT.         
           MOVE WS-TRNSP-SHRINK-PCT      TO TW-TRNSP-SHRINK-PCT.        
           MOVE WS-TRNSP-MDQ             TO TW-TRNSP-MDQ.               
           MOVE WS-TRANSM-ACCT-NO        TO TW-TRANSM-ACCT-NO.          
           MOVE PARM-SHIPPER             TO TW-FUEL-SHIPPER-CD.         
           MOVE PARM-IC-NO               TO TZ-IC-NO.                   
           MOVE PARM-CODE-REVENUE-CLASS  TO TZ-CODE-REVENUE-CLASS.      
           MOVE PARM-RATE-PLAN-NO        TO TZ-RATE-PLAN-NO.            
                                                                        
      * UPDATE HOST VARIABLES. *                                        22840200
           IF ((TW-TRNSP-SHRINK-PCT NOT EQUAL                           
                                       WS-TRNSP-SHRINK-PCT-PREV) OR     
               (TW-TRNSP-MDQ        NOT EQUAL                           
                                       WS-TRNSP-MDQ-PREV)        OR     
               (TW-TRANSM-ACCT-NO   NOT EQUAL                           
                                       WS-TRANSM-ACCT-NO-PREV)   OR     
               (TW-FUEL-SHIPPER-CD  NOT EQUAL                           
                                       WS-FUEL-SHIPPER-CD-PREV))        
               PERFORM 8200-UPDATE-TRNSP-CONTRACT THRU 8200-EXIT        
            END-IF                                                      
                                                                        
           IF ((TZ-CODE-REVENUE-CLASS NOT EQUAL                         
                                         WS-CODE-REVENUE-CLASS) OR      
               (TZ-RATE-PLAN-NO       NOT EQUAL                         
                                         WS-RATE-PLAN-NO))              
               PERFORM 8300-UPDATE-TRNSP-VOL-BLK  THRU 8300-EXIT        
            END-IF.                                                     
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22842400
      * 5500-GET-PREV-TRNSP                                             22842500
      *       GET ALL TRANSP AGRMNT DETAILS FROM CSS_TRNSP_CONTRACT    *22842600
      *       TABLE BEFORE UPDATING WITH THE NEW DETAILS               *22842700
      *                                                                *22842800
      *     CALLED BY: 5000-UPDATE                                     *22842900
      ******************************************************************22843000
       5500-GET-PREV-TRNSP.                                             
                                                                        
           EXEC SQL                                                     
              SELECT TW.TRNSP_SHRINK_PCT,                               
                     TW.TRNSP_MDQ,                                      
                     TW.TRANSM_ACCT_NO,                                 
                     TW.FUEL_SHIPPER_CD                                 
              INTO   :TW-TRNSP-SHRINK-PCT,                              
                     :TW-TRNSP-MDQ,                                     
                     :TW-TRANSM-ACCT-NO,                                
                     :TW-FUEL-SHIPPER-CD                                
              FROM   CSS_TRNSP_CONTRACT TW WITH(READUNCOMMITTED)                
              WHERE  TW.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          
                AND  TW.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          
                AND  TW.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
                AND  TW.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     22843300
MFA-TR*       SELECT TW.TRNSP_SHRINK_PCT,                               22843400
MFA-TR*              TW.TRNSP_MDQ,                                      22843500
MFA-TR*              TW.TRANSM_ACCT_NO,                                 22843600
MFA-TR*              TW.FUEL_SHIPPER_CD                                 22843700
MFA-TR*       INTO   :TW-TRNSP-SHRINK-PCT,                              22843800
MFA-TR*              :TW-TRNSP-MDQ,                                     22843900
MFA-TR*              :TW-TRANSM-ACCT-NO,                                22844000
MFA-TR*              :TW-FUEL-SHIPPER-CD                                22844100
MFA-TR*       FROM   CSS_TRNSP_CONTRACT TW                              22844200
MFA-TR*       WHERE  TW.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          22844300
MFA-TR*         AND  TW.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          22844400
MFA-TR*         AND  TW.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         22844500
MFA-TR*         AND  TW.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           22844600
MFA-TR*         WITH UR                                                 22844700
MFA-TR*    END-EXEC.                                                    22844800

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE TW-TRNSP-SHRINK-PCT   TO WS-TRNSP-SHRINK-PCT-PREV    
              MOVE TW-TRNSP-MDQ          TO WS-TRNSP-MDQ-PREV           
              MOVE TW-TRANSM-ACCT-NO     TO WS-TRANSM-ACCT-NO-PREV      
              MOVE TW-FUEL-SHIPPER-CD    TO WS-FUEL-SHIPPER-CD-PREV     
              MOVE WS-TRNSP-SHRINK-PCT-PREV                             
                                         TO WS-TRNSP-SHRINK-PCT-PREV-X  
              MOVE WS-TRNSP-MDQ-PREV     TO WS-TRNSP-MDQ-PREV-X         
              MOVE WS-TRANSM-ACCT-NO-PREV                               
                                         TO WS-TRANSM-ACCT-NO-PREV-X    
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_TRNSP_CONTRACT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-3             
              MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-3           
              MOVE 'PRIMARU_IC_NO'       TO TABLE-ELEMENT-4             
              MOVE PARM-PRIMARY-IC-NO    TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************30881000
      * 5600-GET-PREV-TRNSP-VOL                                        *30882000
      *       GET ALL TRANSP AGRMNT DETAILS FROM CSS_TRNSP_VOL_BLK     *30882100
      *       TABLE BEFORE UPDATING WITH THE NEW DETAILS               *30882200
      *                                                                *30884000
      *     CALLED BY: 5000-UPDATE                                     *30885000
      ******************************************************************30886000
       5600-GET-PREV-TRNSP-VOL.                                         
                                                                        
           EXEC SQL                                                     
              SELECT TZ.CODE_REVENUE_CLASS,                             
                     TZ.RATE_PLAN_NO                                    
              INTO   :TZ-CODE-REVENUE-CLASS,                            
                     :TZ-RATE-PLAN-NO                                   
              FROM   CSS_TRNSP_VOL_BLK  TZ WITH(READUNCOMMITTED)                
              WHERE  TZ.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          
                AND  TZ.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          
                AND  TZ.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
                AND  TZ.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           
                AND  TZ.IC_NO           = :PARM-IC-NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     30889000
MFA-TR*       SELECT TZ.CODE_REVENUE_CLASS,                             30889100
MFA-TR*              TZ.RATE_PLAN_NO                                    30889200
MFA-TR*       INTO   :TZ-CODE-REVENUE-CLASS,                            30889400
MFA-TR*              :TZ-RATE-PLAN-NO                                   30889500
MFA-TR*       FROM   CSS_TRNSP_VOL_BLK  TZ                              30889700
MFA-TR*       WHERE  TZ.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          30889800
MFA-TR*         AND  TZ.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          30889900
MFA-TR*         AND  TZ.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         30890000
MFA-TR*         AND  TZ.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           30890100
MFA-TR*         AND  TZ.IC_NO           = :PARM-IC-NO                   30890200
MFA-TR*         WITH UR                                                 30890300
MFA-TR*    END-EXEC.                                                    30890400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE TZ-CODE-REVENUE-CLASS TO WS-CODE-REVENUE-CLASS       
              MOVE TZ-RATE-PLAN-NO       TO WS-RATE-PLAN-NO             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_TRNSP_CONTRACT'  TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-3             
              MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-3           
              MOVE 'PRIMARU_IC_NO'       TO TABLE-ELEMENT-4             
              MOVE PARM-PRIMARY-IC-NO    TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************30894000
      *  JOURNALING COPYBOOK.                                          *30900000
      ******************************************************************30910000
           EXEC SQL                                                     30920000
              INCLUDE CPD00067                                          30930000
           END-EXEC.                                                    30940000
                                                                        
HPCCDM*EJECT                                                            30960000
                                                                        
      ******************************************************************30980000
      * 7000-SELECT-ACCOUNT-DTLS.                                      *30990000
      *     1. SELECT CUSTOMER_NO AND  PREMIST_NO FROM CSS_ACCOUNT     *31000000
      *                                                                *31010000
      *     CALLED BY: 5000-UPDATE                                     *31020000
      ******************************************************************31030000
       7000-SELECT-ACCOUNT-DTLS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO,                                    
                     AT.PREMISE_NO                                      
              INTO   :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO                                     
              FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
              WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31060000
MFA-TR*       SELECT AT.CUSTOMER_NO,                                    31070000
MFA-TR*              AT.PREMISE_NO                                      31080000
MFA-TR*       INTO   :AT-CUSTOMER-NO,                                   31250000
MFA-TR*              :AT-PREMISE-NO                                     31260000
MFA-TR*       FROM   CSS_ACCOUNT AT                                     31430000
MFA-TR*       WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    31440000
MFA-TR*       WITH UR                                                   31450000
MFA-TR*    END-EXEC.                                                    31470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31700100
      * 7100-CHECK-VALID-IC.                                           *31700200
      *     CHECK FOR THE IC BEING INSERTED IS A VALID IC NUMBER       *31700300
      *                                                                *31700400
      *     CALLED BY: 5000-UPDATE.                                    *31700500
      ******************************************************************31700600
       7100-CHECK-VALID-IC.                                             
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO   :WS-IC-EXIST-SW                                    
              FROM   CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
                AND  UT.IC_NO          = :UT-IC-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31700900
MFA-TR*       SELECT 'Y'                                                31701000
MFA-TR*       INTO   :WS-IC-EXIST-SW                                    31701100
MFA-TR*       FROM   CSS_UTIL_ENVRNMT UT                                31701200
MFA-TR*       WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 31701300
MFA-TR*         AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             31701400
MFA-TR*         AND  UT.IC_NO          = :UT-IC-NO                      31701500
MFA-TR*         WITH UR                                                 31701600
MFA-TR*    END-EXEC.                                                    31701700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31704100
      * 7200-CHECK-VALID-DATE                                          *31704200
      *     CHECK FOR THE DATE SELECTED  IS A VALID DATE WHICH EXIST IN*31704300
      *     CSS_BILL_CONTRACT                                          *31704400
      *     CALLED BY: 5000-UPDATE.                                    *31705000
      ******************************************************************31706000
       7200-CHECK-VALID-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO   :WS-DT-EXIST-SW                                    
              FROM   CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
              WHERE  BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                
                AND  BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            
                AND  BK.IC_NO           = :BK-IC-NO                     
                AND  BK.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :BK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :BK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:BK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:BK-CNTRCT-START-DT
              ), CONVERT(DATE, :BK-CNTRCT-START-DT) )           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31709000
MFA-TR*       SELECT 'Y'                                                31709100
MFA-TR*       INTO   :WS-DT-EXIST-SW                                    31709300
MFA-TR*       FROM   CSS_BILL_CONTRACT BK                               31709500
MFA-TR*       WHERE  BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                31709600
MFA-TR*         AND  BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            31709700
MFA-TR*         AND  BK.IC_NO           = :BK-IC-NO                     31709800
MFA-TR*         AND  BK.CNTRCT_START_DT = :BK-CNTRCT-START-DT           31709900
MFA-TR*         WITH UR                                                 31710000
MFA-TR*    END-EXEC.                                                    31710100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILL_CONTRACT'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE BK-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE BK-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE BK-IC-NO              TO HOSTVAR-ELEMENT-3           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-4             
              MOVE BK-CNTRCT-START-DT    TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31712700
      * 7300-CHECK-DATE-EXIST.                                         *31712800
      *     MAKE SURE ROW DOESN'T EXIST FOR THE DATE AND IC SELECTED IN*31712900
      *     CSS_TRNSP_VOL_BLK.                                         *31713000
      *     CALLED BY: 5000-UPDATE.                                    *31713100
      ******************************************************************31713200
       7300-CHECK-DATE-EXIST.                                           
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO   :WS-ROW-EXIST-SW                                   
              FROM   CSS_TRNSP_VOL_BLK TZ WITH(READUNCOMMITTED)                 
              WHERE  TZ.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          
                AND  TZ.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          
                AND  TZ.IC_NO           = :PARM-IC-NO                   
                AND  TZ.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
                AND  TZ.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31713500
MFA-TR*       SELECT 'Y'                                                31713600
MFA-TR*       INTO   :WS-ROW-EXIST-SW                                   31713700
MFA-TR*       FROM   CSS_TRNSP_VOL_BLK TZ                               31713800
MFA-TR*       WHERE  TZ.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          31713900
MFA-TR*         AND  TZ.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          31714000
MFA-TR*         AND  TZ.IC_NO           = :PARM-IC-NO                   31714100
MFA-TR*         AND  TZ.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         31714200
MFA-TR*         AND  TZ.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           31714300
MFA-TR*         WITH UR                                                 31714400
MFA-TR*    END-EXEC.                                                    31714500

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_TRNSP_VOL_BLK'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE PARM-IC-NO            TO HOSTVAR-ELEMENT-3           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-4             
              MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-4           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31720800
      * 7400-CHECK-CNTRCT-DEMAND.                                      *31720900
      *     CHECK FOR THE IC BEING INSERTED IS A HAVING CONTRACT DEMAND*31721000
      *     ON CSS_BILL_CONTRACT                                       *31721100
      *                                                                *31721200
      *     CALLED BY: 5000-UPDATE.                                    *31721300
      ******************************************************************31721400
       7400-CHECK-CNTRCT-DEMAND.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CONTRACT_DEMAND                                    
              INTO   :BK-CONTRACT-DEMAND                                
              FROM   CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
              WHERE  BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                
                AND  BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            
                AND  BK.IC_NO           = :BK-IC-NO                     
                AND  BK.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31721700
MFA-TR*       SELECT CONTRACT_DEMAND                                    31721800
MFA-TR*       INTO   :BK-CONTRACT-DEMAND                                31721900
MFA-TR*       FROM   CSS_BILL_CONTRACT BK                               31722000
MFA-TR*       WHERE  BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                31722100
MFA-TR*         AND  BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            31722200
MFA-TR*         AND  BK.IC_NO           = :BK-IC-NO                     31722300
MFA-TR*         AND  BK.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         31722400
MFA-TR*         WITH UR                                                 31722500
MFA-TR*    END-EXEC.                                                    31722600

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                     
                 MOVE ZEROS              TO BK-CONTRACT-DEMAND          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7400'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_BILL_CONTRACT'   TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE BK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
                 MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2            
                 MOVE BK-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2          
                 MOVE 'IC_NO'             TO TABLE-ELEMENT-3            
                 MOVE BK-IC-NO            TO HOSTVAR-ELEMENT-3          
                 MOVE 'CNTRCT_START_DT'   TO TABLE-ELEMENT-3            
                 MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-3        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31725600
      * 7500-GET-MAX-VOL-SEQ.                                          *31725700
      *     GET THE MAX VOL SEQ NO FOR THAT ACCOUNT NUMBER , CODE UTIL *31725800
      *     TYPE AND CONTRACT START DATE                               *31725900
      *                                                                *31726000
      *     CALLED BY: 5000-UPDATE.                                    *31726100
      ******************************************************************31726200
       7500-GET-MAX-VOL-SEQ.                                            
                                                                        
           EXEC SQL                                                     
              SELECT MAX(TRNSP_SEQ)                                     
              INTO   :WS-TRNSP-SEQ :WS-NULL-SEQ                          
              FROM   CSS_TRNSP_VOL_BLK TZ WITH(READUNCOMMITTED)                 
              WHERE  TZ.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          
                AND  TZ.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          
                AND  TZ.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
                AND  TZ.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31726500
MFA-TR*       SELECT MAX(TRNSP_SEQ)                                     31726600
MFA-TR*       INTO   :WS-TRNSP-SEQ:WS-NULL-SEQ                          31726700
MFA-TR*       FROM   CSS_TRNSP_VOL_BLK TZ                               31726800
MFA-TR*       WHERE  TZ.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          31726900
MFA-TR*         AND  TZ.CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE          31727000
MFA-TR*         AND  TZ.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         31727100
MFA-TR*         AND  TZ.PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO           31727200
MFA-TR*         WITH UR                                                 31727300
MFA-TR*    END-EXEC.                                                    31727400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_TRNSP_VOL_BLK'   TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE PARM-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-3             
              MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-3           
              MOVE 'PRIMARY_IC_NO'       TO TABLE-ELEMENT-3             
              MOVE PARM-PRIMARY-IC-NO    TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31730000
      * 7600-SELECT-RESP-AREA-ID.                                      *31730100
      *     1. GET THE USER'S ASSOCIATED AREA ID BASED ON USERID.      *31730200
      *                                                                *31730300
      *     CALLED BY: 5000-UPDATE                                     *31730400
      ******************************************************************31730500
       7600-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PARM-USERID                             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31730800
MFA-TR*       SELECT RESP_AREA_ID                                       31730900
MFA-TR*         INTO :WS-RESP-AREA-ID                                   31731000
MFA-TR*         FROM CSS_USER_PROFILE                                   31731100
MFA-TR*        WHERE USER_ID = :PARM-USERID                             31731200
MFA-TR*        WITH UR                                                  31731300
MFA-TR*    END-EXEC.                                                    31731400

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              MOVE PARM-USERID           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31740100
      * 7700-CHECK-VALID-RATE                                          *31740200
      *      -- THIS MODULE CHECKS THE ACCOUNTS FOR VALID TRANSP RATES *31740300
      ******************************************************************31740400
       7700-CHECK-VALID-RATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT  'Y'                                             
                  INTO :WS-VALID-RATE-SW                                
                  FROM CSS_RATE_COMP_DEF J1 WITH(READUNCOMMITTED)               
                 WHERE J1.RATE_PLAN_NO  = :PARM-RATE-PLAN-NO            
                   AND J1.CMPNT_ID_CD   = :WS-65                        
                   AND J1.CODE_UTIL_TYPE = :WS-G                        
                   AND J1.VERSION_NO_CNTRL IN                           
                       (SELECT MAX(A1.VERSION_NO_CNTRL)                 
                          FROM CSS_RATE_COMP_DEF A1
                           WITH(READUNCOMMITTED)                     
                         WHERE A1.RATE_PLAN_NO  = :PARM-RATE-PLAN-NO    
                           AND A1.CODE_UTIL_TYPE = :WS-G)               
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31740700
MFA-TR*         SELECT  'Y'                                             31740800
MFA-TR*           INTO :WS-VALID-RATE-SW                                31740900
MFA-TR*           FROM CSS_RATE_COMP_DEF J1                             31741000
MFA-TR*          WHERE J1.RATE_PLAN_NO  = :PARM-RATE-PLAN-NO            31741100
MFA-TR*            AND J1.CMPNT_ID_CD   = :WS-65                        31741200
MFA-TR*            AND J1.CODE_UTIL_TYPE = :WS-G                        31741300
MFA-TR*            AND J1.VERSION_NO_CNTRL IN                           31741400
MFA-TR*                (SELECT MAX(A1.VERSION_NO_CNTRL)                 31741500
MFA-TR*                   FROM CSS_RATE_COMP_DEF A1                     31741600
MFA-TR*                  WHERE A1.RATE_PLAN_NO  = :PARM-RATE-PLAN-NO    31741700
MFA-TR*                    AND A1.CODE_UTIL_TYPE = :WS-G)               31741800
MFA-TR*                    WITH UR                                      31741900
MFA-TR*    END-EXEC.                                                    31742000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 31742100
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE '7700'               TO ACTIVE-PARAGRAPH            
               MOVE 'SELECT'             TO ABEND-FUNCTION              
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_RATE_COMP_DEF'  TO TABLE-1                     
               MOVE 'RATE_PLAN_NO'       TO TABLE-ELEMENT-1             
               MOVE PARM-RATE-PLAN-NO    TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
      *                                                                 31743800
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                 31745000
      ****************************************************************  31750000
      ******************************************************************41142000
      * 8000-INSERT-TRNSP-CNTRCT                                       *41150000
      *        INSERT NEW TRANSPORTAION AGREEMENT DETAILS IN           *41160000
      *        CSS_TRNSP_CONTRACT TABLE                                *41161000
      *                                                                *41170000
      *     CALLED BY: 5300-PROCESS-TRNSP-CNTRCT.                      *41180000
      ******************************************************************41190000
       8000-INSERT-TRNSP-CNTRCT.                                        
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_TRNSP_CONTRACT                            
                   ( ACCOUNT_NO,                                        
                     CODE_UTIL_TYPE,                                    
                     PRIMARY_IC_NO,                                     
                     CNTRCT_START_DT,                                   
                     TRNSP_SHRINK_PCT,                                  
                     TRNSP_MDQ,                                         
                     TRANSM_ACCT_NO,                                    
                     FUEL_SHIPPER_CD)                                   
           VALUES ( :TW-ACCOUNT-NO,                                     
                    :TW-CODE-UTIL-TYPE,                                 
                    :TW-PRIMARY-IC-NO,                                  
                    IIF(TRY_CONVERT(DATE, :TW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TW-CNTRCT-START-DT
              ), CONVERT(DATE, :TW-CNTRCT-START-DT) ),                         
                    :TW-TRNSP-SHRINK-PCT,                               
                    :TW-TRNSP-MDQ,                                      
                    :TW-TRANSM-ACCT-NO,                                 
                    :TW-FUEL-SHIPPER-CD)                                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     41220000
MFA-TR*       INSERT INTO CSS_TRNSP_CONTRACT                            41230000
MFA-TR*            ( ACCOUNT_NO,                                        41240000
MFA-TR*              CODE_UTIL_TYPE,                                    41250000
MFA-TR*              PRIMARY_IC_NO,                                     41260000
MFA-TR*              CNTRCT_START_DT,                                   41270000
MFA-TR*              TRNSP_SHRINK_PCT,                                  41280000
MFA-TR*              TRNSP_MDQ,                                         41290000
MFA-TR*              TRANSM_ACCT_NO,                                    41300000
MFA-TR*              FUEL_SHIPPER_CD)                                   41310000
MFA-TR*    VALUES ( :TW-ACCOUNT-NO,                                     41570000
MFA-TR*             :TW-CODE-UTIL-TYPE,                                 41580000
MFA-TR*             :TW-PRIMARY-IC-NO,                                  41590000
MFA-TR*             :TW-CNTRCT-START-DT,                                41600000
MFA-TR*             :TW-TRNSP-SHRINK-PCT,                               41610000
MFA-TR*             :TW-TRNSP-MDQ,                                      41620000
MFA-TR*             :TW-TRANSM-ACCT-NO,                                 41630000
MFA-TR*             :TW-FUEL-SHIPPER-CD)                                41640000
MFA-TR*    END-EXEC.                                                    41900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_TRNSP_CONTRACT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE TW-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE TW-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY_IC_NO'      TO TABLE-ELEMENT-3              
              MOVE TW-PRIMARY-IC-NO     TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE TW-CNTRCT-START-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                 42150100
      ******************************************************************42154100
      * 8100-INSERT-TRNSP-VOL-BLK.                                     *42154200
      *        INSERT NEW TRANSPORTAION AGREEMENT DETAILS IN           *42154300
      *        CSS_TRNSP_VOL_BLK  TABLE                                *42154400
      *                                                                *42155000
      *     CALLED BY: 5300-PROCESS-TRNSP-CNTRCT.                      *42156000
      ******************************************************************42157000
       8100-INSERT-TRNSP-VOL-BLK.                                       
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_TRNSP_VOL_BLK                             
                   ( ACCOUNT_NO,                                        
                     CODE_UTIL_TYPE,                                    
                     PRIMARY_IC_NO,                                     
                     CNTRCT_START_DT,                                   
                     TRNSP_SEQ,                                         
                     IC_NO,                                             
                     CODE_REVENUE_CLASS,                                
                     RATE_PLAN_NO)                                      
           VALUES ( :TZ-ACCOUNT-NO,                                     
                    :TZ-CODE-UTIL-TYPE,                                 
                    :TZ-PRIMARY-IC-NO,                                  
                    IIF(TRY_CONVERT(DATE, :TZ-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TZ-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TZ-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TZ-CNTRCT-START-DT
              ), CONVERT(DATE, :TZ-CNTRCT-START-DT) ),                         
                    :TZ-TRNSP-SEQ,                                      
                    :TZ-IC-NO,                                          
                    :TZ-CODE-REVENUE-CLASS,                             
                    :TZ-RATE-PLAN-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42159100
MFA-TR*       INSERT INTO CSS_TRNSP_VOL_BLK                             42159200
MFA-TR*            ( ACCOUNT_NO,                                        42159300
MFA-TR*              CODE_UTIL_TYPE,                                    42159400
MFA-TR*              PRIMARY_IC_NO,                                     42159500
MFA-TR*              CNTRCT_START_DT,                                   42159600
MFA-TR*              TRNSP_SEQ,                                         42159700
MFA-TR*              IC_NO,                                             42159800
MFA-TR*              CODE_REVENUE_CLASS,                                42159900
MFA-TR*              RATE_PLAN_NO)                                      42160000
MFA-TR*    VALUES ( :TZ-ACCOUNT-NO,                                     42160100
MFA-TR*             :TZ-CODE-UTIL-TYPE,                                 42160200
MFA-TR*             :TZ-PRIMARY-IC-NO,                                  42160300
MFA-TR*             :TZ-CNTRCT-START-DT,                                42160400
MFA-TR*             :TZ-TRNSP-SEQ,                                      42160500
MFA-TR*             :TZ-IC-NO,                                          42160600
MFA-TR*             :TZ-CODE-REVENUE-CLASS,                             42160700
MFA-TR*             :TZ-RATE-PLAN-NO)                                   42160800
MFA-TR*    END-EXEC.                                                    42160900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_TRNSP_VOL_BLK'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE TZ-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE TZ-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY_IC_NO'      TO TABLE-ELEMENT-3              
              MOVE TZ-PRIMARY-IC-NO     TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE TZ-CNTRCT-START-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-INSERT-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************42164000
      * 8200-UPDATE-TRNSP-CONTRACT                                     *42170000
      *        UPDATES TRANSP CONTRACT DETAILS IN CSS_TRNSP_CONTRACT   *42180000
      *        TABLE                                                   *42181000
      *                                                                *42190000
      *     CALLED BY: 5400-UPDATE-TRNSP-CNTRCT*                        42200000
      ******************************************************************42210000
       8200-UPDATE-TRNSP-CONTRACT.                                      
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_TRNSP_CONTRACT                                 
                SET  TRNSP_SHRINK_PCT = :TW-TRNSP-SHRINK-PCT            
                    ,TRNSP_MDQ        = :TW-TRNSP-MDQ                   
                    ,TRANSM_ACCT_NO   = :TW-TRANSM-ACCT-NO              
                    ,FUEL_SHIPPER_CD  = :TW-FUEL-SHIPPER-CD             
                WHERE ACCOUNT_NO      = :TW-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :TW-CODE-UTIL-TYPE              
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :TW-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TW-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TW-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TW-CNTRCT-START-DT
              ), CONVERT(DATE, :TW-CNTRCT-START-DT) )             
                  AND PRIMARY_IC_NO   = :TW-PRIMARY-IC-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42240000
MFA-TR*       UPDATE CSS_TRNSP_CONTRACT                                 42250000
MFA-TR*         SET  TRNSP_SHRINK_PCT = :TW-TRNSP-SHRINK-PCT            42260000
MFA-TR*             ,TRNSP_MDQ        = :TW-TRNSP-MDQ                   42320000
MFA-TR*             ,TRANSM_ACCT_NO   = :TW-TRANSM-ACCT-NO              42321000
MFA-TR*             ,FUEL_SHIPPER_CD  = :TW-FUEL-SHIPPER-CD             42322000
MFA-TR*         WHERE ACCOUNT_NO      = :TW-ACCOUNT-NO                  42330000
MFA-TR*           AND CODE_UTIL_TYPE  = :TW-CODE-UTIL-TYPE              42340000
MFA-TR*           AND CNTRCT_START_DT = :TW-CNTRCT-START-DT             42342000
MFA-TR*           AND PRIMARY_IC_NO   = :TW-PRIMARY-IC-NO               42343000
MFA-TR*    END-EXEC.                                                    42400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_TRNSP_CONTRACT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE PARM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY_IC_NO'      TO TABLE-ELEMENT-3              
              MOVE PARM-PRIMARY-IC-NO   TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE PARM-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************42651000
      * 8300-UPDATE-TRNSP-VOL-BLK                                      *42652000
      *        UPDATES TRANSP VOL BLK  DETAILS IN CSS_TRNSP_VOL_BLK    *42653000
      *        TABLE                                                   *42654000
      *                                                                *42655000
      *     CALLED BY: 5400-UPDATE-TRNSP-CNTRCT                        *42656000
      ******************************************************************42657000
       8300-UPDATE-TRNSP-VOL-BLK.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_TRNSP_VOL_BLK                                  
                SET  CODE_REVENUE_CLASS = :TZ-CODE-REVENUE-CLASS        
                    ,RATE_PLAN_NO       = :TZ-RATE-PLAN-NO              
                WHERE ACCOUNT_NO      = :TZ-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :TZ-CODE-UTIL-TYPE              
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :TZ-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :TZ-CNTRCT-START-DT
              ) <> 0) OR (LEN(:TZ-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:TZ-CNTRCT-START-DT
              ), CONVERT(DATE, :TZ-CNTRCT-START-DT) )             
                  AND PRIMARY_IC_NO   = :TZ-PRIMARY-IC-NO               
                  AND IC_NO           = :TZ-IC-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42659100
MFA-TR*       UPDATE CSS_TRNSP_VOL_BLK                                  42659200
MFA-TR*         SET  CODE_REVENUE_CLASS = :TZ-CODE-REVENUE-CLASS        42659300
MFA-TR*             ,RATE_PLAN_NO       = :TZ-RATE-PLAN-NO              42659400
MFA-TR*         WHERE ACCOUNT_NO      = :TZ-ACCOUNT-NO                  42659600
MFA-TR*           AND CODE_UTIL_TYPE  = :TZ-CODE-UTIL-TYPE              42659700
MFA-TR*           AND CNTRCT_START_DT = :TZ-CNTRCT-START-DT             42659800
MFA-TR*           AND PRIMARY_IC_NO   = :TZ-PRIMARY-IC-NO               42659900
MFA-TR*           AND IC_NO           = :TZ-IC-NO                       42660000
MFA-TR*    END-EXEC.                                                    42660100

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_TRNSP_VOL_BLK'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE PARM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY_IC_NO'      TO TABLE-ELEMENT-3              
              MOVE PARM-PRIMARY-IC-NO   TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE PARM-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************42663000
      * 8400-DELETE-TRNSP-CNTRCT                                       *42670000
      *      DELETES TRANSP CONTRACT DETAILS FROM CSS_TRNSP_CONTRACT   *42680000
      *      FOR THAT ACCOUNT , CODE_UTIL_TYPE ,   CNTRCT_START_DT     *42681000
      *      AND PRIMARY_IC_NO                                         *42682000
      *                                                                *42690000
      *     CALLED BY: 5000-UPDATE.                                    *42700000
      ******************************************************************42710000
       8400-DELETE-TRNSP-CNTRCT.                                        
                                                                        
           EXEC SQL                                                     
              DELETE FROM  CSS_TRNSP_CONTRACT                           
                WHERE ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM            
                  AND CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE            
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )           
                  AND PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42740000
MFA-TR*       DELETE FROM  CSS_TRNSP_CONTRACT                           42750000
MFA-TR*         WHERE ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM            42780000
MFA-TR*           AND CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE            42790000
MFA-TR*           AND CNTRCT_START_DT = :PARM-CNTRCT-START-DT           42810000
MFA-TR*           AND PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO             42820000
MFA-TR*    END-EXEC.                                                    42830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8400'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_TRNSP_CONTRACT' TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE PARM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY-IC-NO'      TO TABLE-ELEMENT-3              
              MOVE PARM-PRIMARY-IC-NO   TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE PARM-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************43090000
      * 8500-DELETE-TRNSP-VOL-BLK                                      *43100000
      *    DELETES ALL TRANS VOL BLOCK DETAILS FROM CSS_TRNSP_VOL_BLK  *43110000
      *     FOR THAT ACCOUNT , CODE_UTIL_TYPE ,CNTRCT_START_DT         *43120000
      *     AND PRIMARY_IC_NO                                          *43121000
      *                                                                *43130000
      *     CALLED BY: 5000-UPDATE.                                    *43140000
      ******************************************************************43150000
       8500-DELETE-TRNSP-VOL-BLK.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM  CSS_TRNSP_VOL_BLK                            
                WHERE ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM            
                  AND CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE            
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )           
                  AND PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     43180000
MFA-TR*       DELETE FROM  CSS_TRNSP_VOL_BLK                            43190000
MFA-TR*         WHERE ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM            43200000
MFA-TR*           AND CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE            43210000
MFA-TR*           AND CNTRCT_START_DT = :PARM-CNTRCT-START-DT           43220000
MFA-TR*           AND PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO             43230000
MFA-TR*    END-EXEC.                                                    43240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8500'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_TRNSP_VOL_BLK'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE PARM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY_IC_NO'      TO TABLE-ELEMENT-3              
              MOVE PARM-PRIMARY-IC-NO   TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE PARM-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************43500000
      * 8600-DELETE-TRNSP-VOL-BLK                                      *43510000
      *    DELETES  TRANS VOL BLOCK DETAILS FROM CSS_TRNSP_VOL_BLK     *43520000
      *     FOR THAT ACCOUNT , CODE_UTIL_TYPE ,CNTRCT_START_DT         *43530000
      *     PRIMARY_IC_NO AND IC_NO                                    *43540000
      *                                                                *43550000
      *     CALLED BY: 5000-UPDATE.                                    *43560000
      ******************************************************************43570000
       8600-DELETE-TRNSP-VOL-BLK.                                       
                                                                        
           EXEC SQL                                                     
              DELETE FROM  CSS_TRNSP_VOL_BLK                            
                WHERE ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM            
                  AND CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE            
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )           
                  AND PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO             
                  AND IC_NO           = :PARM-IC-NO                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     43600000
MFA-TR*       DELETE FROM  CSS_TRNSP_VOL_BLK                            43610000
MFA-TR*         WHERE ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM            43620000
MFA-TR*           AND CODE_UTIL_TYPE  = :PARM-CODE-UTIL-TYPE            43630000
MFA-TR*           AND CNTRCT_START_DT = :PARM-CNTRCT-START-DT           43640000
MFA-TR*           AND PRIMARY_IC_NO   = :PARM-PRIMARY-IC-NO             43650000
MFA-TR*           AND IC_NO           = :PARM-IC-NO                     43660000
MFA-TR*    END-EXEC.                                                    43670000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8600'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_TRNSP_VOL_BLK'  TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE PARM-CODE-UTIL-TYPE  TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY_IC_NO'      TO TABLE-ELEMENT-3              
              MOVE PARM-PRIMARY-IC-NO   TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE PARM-CNTRCT-START-DT TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************52550000
      * 9900- JOURNAL INCLUDE                                          *52560000
      ******************************************************************52570000
REARCH*    EXEC SQL                                                     52580000
REARCH*       INCLUDE CPD00300                                          52590000
REARCH*    END-EXEC.                                                    52600000
                                                                        
REARCH     EXEC SQL                                                     52611000
REARCH        INCLUDE CPDSP300                                          52612000
REARCH     END-EXEC.                                                    52613000
      ******************************************************************52620000
      *       END PROGRAM COPYLIB                                      *52630000
      ******************************************************************52640000
REARCH*    COPY CPD00302.                                               52650000
REARCH*    EXEC SQL                                                     52651000
REARCH*       INCLUDE CPDSP302                                          52652000
REARCH*    END-EXEC.                                                    52653000
      *                                                                 52654000
REARCH     EXEC SQL                                                     52655000
REARCH        INCLUDE CPD00321                                          52656000
REARCH     END-EXEC.                                                    52657000
                                                                        
