       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02473.                                     
COB303 DATE-WRITTEN.      AUG 29, 2002                                  
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      ******************************************************************00160000
      *                                                                *00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  THIS PROGRAM INSERTS / UPDATES / DELETES VOLUME BLOCK DETAILS.*00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  08/29/02   SK88120   RPC ORIGINALLY ADDED.                    *00280000
      *                                                                *00290000
REARCH*  08/03/05   CVNS      RPC CONVERTED TO COBOL SP.               *00300000
REARCH*             CHENNAI                                            *00310000
T35434*  11/01/07   MK92804   REPLACED CSS_MODEL_SQL WITH SET STMTS    *00320001
T35434*                       AND ADDED 'WITH UR' FOR SINGLETON SELECTS*00330001
      ******************************************************************00990000
      *                                                                *01000000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01010000
      *                                                                *01020000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01030000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01040000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01050000
      *  3000 - 4999  NOT USED                                         *01060000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01070000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01080000
      *  7000 - 7999  INPUT MODULES                                    *01090000
      *  8000 - 8999  OUTPUT MODULES                                   *01100000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01110000
      *                                                                *01120000
      ******************************************************************01130000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02473'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02473 STARTS HERE'.                  
                                                                        
      ******************************************************************01220000
      *    DB2 INCLUDES                                                *01230000
      ******************************************************************01240000
                                                                        
           EXEC SQL                                                     01260000
              INCLUDE SQLCA                                             01270000
           END-EXEC.                                                    01280000
                                                                        
      **** CSS_VOL_BLOCK ****                                           01300000
           EXEC SQL                                                     01310000
              INCLUDE TBVOLBLK                                          01320000
           END-EXEC.                                                    01330000
                                                                        
      **** CSS_UTIL_ENVRNMT ****                                        01500000
           EXEC SQL                                                     01510000
              INCLUDE TBUTLENV                                          01520000
           END-EXEC.                                                    01530000
                                                                        
      **** CSS_BILL_CONTRACT ****                                       01550000
           EXEC SQL                                                     01560000
              INCLUDE TBBLCNTR                                          01570000
           END-EXEC.                                                    01580000
                                                                        
      **** CSS_MNT_TRANS_HIST ****                                      01700000
           EXEC SQL                                                     01710000
              INCLUDE TBMNHIST                                          01720000
           END-EXEC.                                                    01730000
                                                                        
      **** CSS_MT_TRN_HST_DET ****                                      01750000
           EXEC SQL                                                     01760000
              INCLUDE TBMNHDT                                           01770000
           END-EXEC.                                                    01780000
                                                                        
      **** CSS_ACCOUNT ****                                             01800000
           EXEC SQL                                                     01830000
              INCLUDE TBACCT                                            01840000
           END-EXEC.                                                    01850000
                                                                        
      **** CSS_USER_PROFILE ***                                         01870000
           EXEC SQL                                                     01880000
              INCLUDE TBUSRPRF                                          01890000
           END-EXEC.                                                    01900000
                                                                        
      ******************************************************************02400000
      *    COBOL WORKING STORAGE COPY BOOKS                            *02410000
      ******************************************************************02420000
                                                                        
REARCH*    COPY SYDBCOB.                                                02450000
           COPY CWS00303.                                               02460000
                                                                        
           COPY CCA00001.                                               02480000
           COPY CWS00027.                                               02490000
                                                                        
REARCH     EXEC SQL                                                     02501000
REARCH          INCLUDE CWSX0010                                        02502000
REARCH     END-EXEC.                                                    02503000
                                                                        
           EXEC SQL                                                     02520000
              INCLUDE CWS00013                                          02530000
           END-EXEC.                                                    02540000
                                                                        
      ******************************************************************02560000
      *    WORK AREAS                                                  *02570000
      ******************************************************************02580000
      *                                                                 02600200
                                                                        
REARCH 01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13)          VALUE SPACES. 
REARCH     05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO-TEMP   
REARCH                                 PIC 9(13).                       
           05  PARM-ACCOUNT-NO-NUM     PIC S9(13)V COMP-3 VALUE 0.      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08) VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18) VALUE SPACES.          
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)  VALUE ' '.             
REARCH     10  S-TABLE-NAME            PIC X(18) VALUE SPACES.          
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02473_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
                                                                        
       01  FLAGS.                                                       
           05  WS-CONT-EXISTS-FLAG     PIC X(03) VALUE 'NO '.           
               88 CONT-EXISTS                    VALUE 'YES'.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-IC-EXIST-SW          PIC X(01)      VALUE 'N'.        
               88 WS-IC-EXIST                         VALUE 'Y'.        
           05  WS-ROW-EXIST-SW          PIC X(01)     VALUE 'N'.        
               88 WS-ROW-EXIST                        VALUE 'Y'.        
           05  WS-UPDATE-SUCCESSFUL    PIC X(01) VALUE 'N'.             
               88 UPDATE-UNSUCCESSFUL            VALUE 'N'.             
               88 UPDATE-SUCCESSFUL              VALUE 'Y'.             
           05  WS-ROWS-PRESENT         PIC X(01) VALUE 'Y'.             
               88  ROWS-PRESENT                  VALUE 'Y'.             
               88  NO-ROWS-PRESENT               VALUE 'N'.             
                                                                        
       01  WS-MISC.                                                     
           05 WS-TRAN-APPL-NO           PIC S9(4) COMP VALUE 0.         
REARCH     05 PROGRAM-NAME              PIC X(08)      VALUE 'CSR02473'.
REARCH     05 WS-SQLSTATE               PIC X(05) VALUE '     '.        
           05 WS-RCVPRM                 PIC X(20)      VALUE SPACES.    
           05 WS-INSERT-TYPE            PIC X(01)      VALUE 'I'.       
           05 WS-DELETE-TYPE            PIC X(01)      VALUE 'D'.       
           05 WS-UPDATE-TYPE            PIC X(01)      VALUE 'U'.       
           05 WS-RESP-AREA-ID           PIC X(03)      VALUE SPACES.    
           05 WS-MAX-SEQ                PIC 9(04)      VALUE ZEROS.     
           05 WS-VOL-SEQ                PIC S9(04) USAGE COMP           
                                                   VALUE ZEROS.         
           05 WS-PREV-VOL-BLOCK        PIC S9(7)V  COMP-3 VALUE 0.      
           05 WS-PREV-VOL-BLOCK-NUM    PIC 9(07) VALUE 0.               
           05 WS-NULL-SEQ              PIC S9(04) COMP VALUE 0.         
           05 WS-PRIMARY-IC-NO         PIC 9(02) VALUE 0.               
           05 WS-IC-NO                 PIC 9(02) VALUE 0.               
           05 WS-VOL-BLOCK-FACTOR-C    PIC X(07).                       
           05 WS-VOL-BLOCK-FACTOR-N    REDEFINES WS-VOL-BLOCK-FACTOR-C  
                                       PIC 9(07)V.                      
COB305     05 WS-VOL-BLOCK-FACTOR        PIC S9(07)V COMP-3 VALUE 0.            
           05 WS-VOL-BLOCK-FACTOR-X    PIC ZZZZZZ9.                     
           05 WS-PREV-VOL-BLOCK-NUM-X  PIC ZZZZZZ9.                     
                                                                        
HPCCDM*EJECT                                                            05340000
REARCH                                                                  
REARCH LINKAGE SECTION.                                                 
      *                                                                 05340300
REARCH 01  PARM-UPDATE-TYPE            PIC X(01).                       
REARCH 01  PARM-USERID                 PIC X(07).                       
REARCH 01  PARM-ACCOUNT-NO             PIC X(13).                       
REARCH 01  PARM-PRIMARY-IC-NO          PIC S9(4) COMP.                  
REARCH 01  PARM-IC-NO                  PIC S9(4) COMP.                  
REARCH 01  PARM-CODE-UTIL-TYPE         PIC X(01).                       
REARCH 01  PARM-CNTRCT-START-DT        PIC X(10).                       
REARCH 01  PARM-VOL-BLOCK-FACTOR       PIC X(07).                       
                                                                        
REARCH PROCEDURE DIVISION USING   PARM-UPDATE-TYPE                      
REARCH                            PARM-USERID                           
REARCH                            PARM-ACCOUNT-NO                       
REARCH                            PARM-PRIMARY-IC-NO                    
REARCH                            PARM-IC-NO                            
REARCH                            PARM-CODE-UTIL-TYPE                   
REARCH                            PARM-CNTRCT-START-DT                  
REARCH                            PARM-VOL-BLOCK-FACTOR.                
                                                                        
      ******************************************************************05370000
      * 0000-MAINLINE.                                                 *05380000
      *     1. CONTROLS THE MAIN PATH OF THE PROGRAM                   *05390000
      ******************************************************************05400000
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05510000
      * 0100-INITIALIZE.                                               *05520000
      *     1. RESET DB2 ERROR HANDLERS                                *05530000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *05540000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *05550000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*05560000
      *                                                                *05570000
      *     CALLED BY: 0000-MAINLINE                                   *05580000
      ******************************************************************05590000
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH                                                                  
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             :S-RETURN-CODE        AS RETURN_CODE                 
REARCH         FROM                                                     
REARCH             CIS.SYSDUMMY1                                     
REARCH                                                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                     05902500
MFA-TR*                                                                 05902600
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        05902700
MFA-TR*        SELECT                                                   05902800
MFA-TR*            :S-RETURN-CODE        AS RETURN_CODE                 05902900
MFA-TR*        FROM                                                     05903100
MFA-TR*            SYSIBM.SYSDUMMY1                                     05903200
MFA-TR*                                                                 05903300
MFA-TR*    END-EXEC.                                                    05903400
REARCH*                                                                 05903500
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************05930000
      * 1000-PROCESS-INPUT.                                            *05940000
      *     1. RECEIVE PARMS FROM THE CLIENT.                          *05950000
      *     2. MOVE NUMERIC PARMS FROM PIC9()'S TO PICS9() COMP'S.     *05960000
      *                                                                *05970000
      *     CALLED BY: 0000-MAINLINE                                   *05980000
      ******************************************************************05990000
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO             TO PARM-ACCOUNT-NO-TEMP.    
           MOVE PARM-ACCOUNT-NO-RED         TO PARM-ACCOUNT-NO-NUM.     
           MOVE PARM-VOL-BLOCK-FACTOR       TO WS-VOL-BLOCK-FACTOR-C    
           MOVE WS-VOL-BLOCK-FACTOR-N      TO WS-VOL-BLOCK-FACTOR.      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************10600000
      * 2000-PROCESS-OUTPUT                                            *10610000
      *     1. DESCRIBE RESULT SET                                     *10620000
      *     2. RETRIEVE DB2 DATA                                       *10630000
      *     3. BUILD RESULT SET                                        *10640000
      *     4. SEND RESULT SET                                         *10650000
      *                                                                *10660000
      *     CALLED BY: 0000-MAINLINE                                   *10670000
      ******************************************************************10680000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 5000-UPDATE                  THRU 5000-EXIT.         
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE           TO RS-RETURN-CODE.      
           MOVE '2000'                          TO ACTIVE-PARAGRAPH.    
REARCH     PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT.        
REARCH     ADD +1                               TO   CTR-ROWS.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH***************************************************************** 10811000
REARCH*                                                               * 10811100
REARCH* 2000A-MOVE-RESULT.                                            * 10812000
REARCH*                                                               * 10812100
REARCH***************************************************************** 10813000
REARCH*                                                                 10814000
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
REARCH*                                                                 10818000
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************13210000
      * 5000-UPDATE.                                                   *13220000
      *     1. PERFORM UPDATE BASED ON ACTION CODE (INSERT/UPDATE/     *13230000
      *        DELETE).                                                *13240000
      *                                                                *13250000
      *     CALLED BY: 2000-PROCESS-OUTPUT                             *13260000
      ******************************************************************13270000
       5000-UPDATE.                                                     
                                                                        
           PERFORM  7400-SELECT-RESP-AREA-ID    THRU 7400-EXIT.         
                                                                        
                                                                        
           MOVE 1                            TO WS-TRAN-APPL-NO,        
                                                MI-TRAN-APPL-NO.        
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM          TO UT-ACCOUNT-NO,          
                                                AT-ACCOUNT-NO,          
                                                UB-ACCOUNT-NO,          
                                                BK-ACCOUNT-NO.          
           MOVE PARM-CODE-UTIL-TYPE         TO UT-CODE-UTIL-TYPE,       
                                                BK-CODE-UTIL-TYPE.      
           MOVE PARM-IC-NO                   TO UT-IC-NO,               
                                                WS-IC-NO,               
                                                BK-IC-NO.               
           MOVE PARM-PRIMARY-IC-NO           TO WS-PRIMARY-IC-NO.       
           MOVE PARM-CNTRCT-START-DT         TO BK-CNTRCT-START-DT.     
                                                                        
           PERFORM 7000-SELECT-ACCOUNT-DTLS THRU 7000-EXIT.             
                                                                        
           IF PARM-UPDATE-TYPE = WS-INSERT-TYPE                         
              PERFORM 5100-FORMAT-JRNL-HEAD   THRU 5100-EXIT            
              PERFORM 7500-CHECK-VALID-ROW    THRU 7500-EXIT            
              IF WS-ROW-EXIST                                           
                 MOVE 5000              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7100-CHECK-VALID-IC     THRU 7100-EXIT            
              IF NOT WS-IC-EXIST                                        
                 MOVE 5100              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7200-CHECK-CNTRCT-DEMAND THRU 7200-EXIT           
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 5300              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              IF BK-CONTRACT-DEMAND <= 0                                
                 MOVE 5200              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7300-GET-MAX-VOL-SEQ     THRU 7300-EXIT           
              IF WS-NULL-SEQ < 0                                        
                 MOVE 0                           TO WS-MAX-SEQ         
              ELSE                                                      
                 MOVE WS-VOL-SEQ                  TO WS-MAX-SEQ         
              END-IF                                                    
              IF WS-MAX-SEQ = 0                                         
                 MOVE 1                        TO UB-VOL-BLOCK-SEQ      
                 MOVE 1                        TO WS-MAX-SEQ            
              ELSE                                                      
                 ADD  1                        TO WS-MAX-SEQ            
                 MOVE WS-MAX-SEQ               TO UB-VOL-BLOCK-SEQ      
              END-IF                                                    
              PERFORM 5200-JRNL-UPDATE         THRU 5200-EXIT           
              PERFORM 5300-PROCESS-VOL-BLOCK   THRU 5300-EXIT           
           END-IF                                                       
                                                                        
           IF PARM-UPDATE-TYPE = WS-UPDATE-TYPE                         
              PERFORM 5100-FORMAT-JRNL-HEAD   THRU 5100-EXIT            
              PERFORM 7100-CHECK-VALID-IC     THRU 7100-EXIT            
              IF NOT WS-IC-EXIST                                        
                 MOVE 5100              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 7200-CHECK-CNTRCT-DEMAND THRU 7200-EXIT           
              IF BK-CONTRACT-DEMAND <= 0                                
                 MOVE 5200              TO WS-ACTIVE-RETURN-CODE        
                 GO TO 5000-EXIT                                        
              END-IF                                                    
              PERFORM 5500-GET-VOL-BLOCK       THRU 5500-EXIT           
              PERFORM 5400-PROCESS-VOL-BLOCK   THRU 5400-EXIT           
              PERFORM 5200-JRNL-UPDATE         THRU 5200-EXIT           
           END-IF                                                       
                                                                        
           IF PARM-UPDATE-TYPE = WS-DELETE-TYPE                         
              PERFORM 5100-FORMAT-JRNL-HEAD   THRU 5100-EXIT            
              MOVE PARM-ACCOUNT-NO-NUM      TO UB-ACCOUNT-NO            
              MOVE PARM-CODE-UTIL-TYPE      TO UB-CODE-UTIL-TYPE        
              MOVE PARM-PRIMARY-IC-NO       TO UB-PRIMARY-IC-NO         
              MOVE PARM-IC-NO               TO UB-IC-NO                 
              MOVE PARM-CNTRCT-START-DT     TO UB-CNTRCT-START-DT       
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
                 PERFORM 8200-DELETE-VOL-BLOCK THRU 8200-EXIT           
              ELSE                                                      
                 PERFORM 8300-DELETE-VOL-BLOCK THRU 8300-EXIT           
              END-IF                                                    
              PERFORM 5200-JRNL-UPDATE         THRU 5200-EXIT           
           END-IF.                                                      
                                                                        
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14360000
      * 5100-FORMAT-JRNL-HEAD.                                         *14370000
      *     1. MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *14380000
      *        THE FIRST TIME THE TRANSACTION DETAILS ROW IS WRITTEN,  *14390000
      *        THIS ROW WILL ALSO BE WRITTEN (SEE CPD00067).           *14400000
      *                                                                *14410000
      *     CALLED BY: 5000-UPDATE                                     *14420000
      ******************************************************************14430000
       5100-FORMAT-JRNL-HEAD.                                           
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     14460000
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP             14470000
MFA-TR*          ,:MH-DATE-TRANS = CURRENT DATE                         14480000
MFA-TR*    END-EXEC.                                                    14520000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '5100'                     TO ACTIVE-PARAGRAPH       
T35434        MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE PARM-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE WS-RESP-AREA-ID               TO MH-RESP-AREA-ID.       
           MOVE PARM-ACCOUNT-NO-NUM           TO MH-ACCOUNT-NO.         
           MOVE AT-CUSTOMER-NO                TO MH-CUSTOMER-NO.        
           MOVE AT-PREMISE-NO                 TO MH-PREMISE-NO.         
           MOVE PARM-USERID                   TO MH-USER-ID.            
           MOVE 'PANEL501'                    TO MH-APPL-PROGRAM-ID.    
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14820000
      * 5200-JRNL-UPDATE.                                              *14830000
      *     1. JOURNAL ICP FIELDS THAT HAVE BEEN CHANGED.              *14840000
      *                                                                *14850000
      *     CALLED BY: 5000-UPDATE                                     *14860000
      ******************************************************************14870000
       5200-JRNL-UPDATE.                                                
                                                                        
           MOVE '5200' TO ACTIVE-PARAGRAPH.                             
           MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO.        
                                                                        
           IF  PARM-UPDATE-TYPE = WS-INSERT-TYPE                        
      ******FOR PRIMARY-IC-NO *****                                     15672000
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +02                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-PRIMARY-IC-NO     TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'PRIMARY IC NO  '       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR IC-NO *****                                             15960100
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +02                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-IC-NO             TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'IC NO  '            TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR VOL-BLOCK-FACTOR***                                     15961500
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
              MOVE WS-VOL-BLOCK-FACTOR     TO WS-VOL-BLOCK-FACTOR-X     
                                                                        
              MOVE +7                     TO MI-CHG-COLUMN-VALUE-LEN    
              MOVE WS-VOL-BLOCK-FACTOR-X  TO MI-CHG-COLUMN-VALUE-TEXT   
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'VOL BLOCK FACTR'       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR VOL-BLOCK-SEQ***                                        15963000
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +4                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE WS-MAX-SEQ           TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'VOL BLOCK SEQ'      TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CODE-UTIL-TYPE ****                                     15964400
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +01                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE PARM-CODE-UTIL-TYPE  TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CODE UTIL TYPE'     TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CNTRCT-START-DT****                                     15965800
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE PARM-CNTRCT-START-DT TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CNTRCT START DT'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
           END-IF.                                                      
                                                                        
           IF  PARM-UPDATE-TYPE = WS-UPDATE-TYPE                        
                                                                        
              IF WS-PREV-VOL-BLOCK      NOT = WS-VOL-BLOCK-FACTOR       
                 MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO        
                 MOVE 'UB'                    TO MI-TABLE-ID            
                                                                        
                 MOVE WS-VOL-BLOCK-FACTOR     TO WS-VOL-BLOCK-FACTOR-X  
                 MOVE WS-PREV-VOL-BLOCK-NUM   TO                        
                                              WS-PREV-VOL-BLOCK-NUM-X   
                                                                        
                 IF WS-VOL-BLOCK-FACTOR    > ZEROS                      
                  MOVE +07                   TO MI-CHG-COLUMN-VALUE-LEN 
                  MOVE WS-VOL-BLOCK-FACTOR-X TO MI-CHG-COLUMN-VALUE-TEXT
                 ELSE                                                   
                  MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN  
                  MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT 
                 END-IF                                                 
                                                                        
                 IF UB-VOL-BLOCK-FACTOR       > ZEROS                   
                   MOVE +07                  TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE WS-PREV-VOL-BLOCK-NUM-X                         
                                             TO MI-PRV-COLUMN-VALUE-TEXT
                 ELSE                                                   
                   MOVE +5                   TO MI-PRV-COLUMN-VALUE-LEN 
                   MOVE '*NEW*'              TO MI-PRV-COLUMN-VALUE-TEXT
                 END-IF                                                 
                                                                        
                 MOVE 'VOL BLK FACTOR'       TO MI-COLUMN-DESC          
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                        TO WS-TRAN-APPL-NO        
             END-IF                                                     
           END-IF.                                                      
                                                                        
           IF  PARM-UPDATE-TYPE = WS-DELETE-TYPE                        
      ******FOR PRIMARY-IC-NO *****                                     15973900
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +2                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE WS-PRIMARY-IC-NO     TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'PRIMARY IC NO  '       TO MI-COLUMN-DESC            
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR IC-NO *****                                             15975300
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
                 MOVE +3                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE 'ALL'             TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 MOVE +2                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE WS-IC-NO          TO MI-PRV-COLUMN-VALUE-TEXT     
              END-IF                                                    
                                                                        
              MOVE 'IC NO  '            TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR VOL-BLOCK-FACTOR***                                     15977200
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE WS-VOL-BLOCK-FACTOR     TO WS-VOL-BLOCK-FACTOR-X     
                                                                        
              IF PARM-PRIMARY-IC-NO = PARM-IC-NO                        
                 MOVE +3                TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE 'ALL'             TO MI-PRV-COLUMN-VALUE-TEXT     
              ELSE                                                      
                 MOVE +08               TO MI-PRV-COLUMN-VALUE-LEN      
                 MOVE WS-VOL-BLOCK-FACTOR-X                             
                                        TO MI-PRV-COLUMN-VALUE-TEXT     
              END-IF                                                    
                                                                        
              MOVE 'VOL BLOCK FACTR'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CODE-UTIL-TYPE ****                                     15979400
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +09                  TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE PARM-CODE-UTIL-TYPE  TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CODE UTIL TYPE'     TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
      ******FOR CNTRCT-START-DT****                                     15980800
              MOVE WS-TRAN-APPL-NO         TO MI-TRAN-APPL-NO           
              MOVE 'UB'                    TO MI-TABLE-ID               
                                                                        
              MOVE +9                   TO MI-CHG-COLUMN-VALUE-LEN      
              MOVE '*DELETED*'          TO MI-CHG-COLUMN-VALUE-TEXT     
                                                                        
              MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN      
              MOVE PARM-CNTRCT-START-DT TO MI-PRV-COLUMN-VALUE-TEXT     
                                                                        
              MOVE 'CNTRCT START DT'    TO MI-COLUMN-DESC               
              PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
              ADD 1                        TO WS-TRAN-APPL-NO           
                                                                        
           END-IF.                                                      
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************21360000
      * 5300-PROCESS-VOL-BLOCK                                         *21370000
      *        INSERT VOLUME BLOCK DETAILS IN CSS_VOL_BLOCK TABLE      *21390000
      *                                                                *21410000
      *     CALLED BY: 5000-UPDATE                                     *21420000
      ******************************************************************21430000
       5300-PROCESS-VOL-BLOCK.                                          
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM      TO UB-ACCOUNT-NO.              
           MOVE PARM-CODE-UTIL-TYPE      TO UB-CODE-UTIL-TYPE.          
           MOVE WS-VOL-BLOCK-FACTOR      TO UB-VOL-BLOCK-FACTOR.        
           MOVE PARM-PRIMARY-IC-NO       TO UB-PRIMARY-IC-NO.           
           MOVE PARM-IC-NO               TO UB-IC-NO.                   
           MOVE PARM-CNTRCT-START-DT     TO UB-CNTRCT-START-DT.         
                                                                        
      * INSERT HOST VARIABLES. *                                        22510000
           PERFORM 8000-INSERT-VOL-BLOCK     THRU 8000-EXIT.            
                                                                        
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************22831000
      * 5400-PROCESS-VOL-BLOCK                                         *22832000
      *       UPDATES VOLUME BLOCK DETAILS IN CSS_VOL_BLOCK TABLE      *22833000
      *                                                                *22834000
      *     CALLED BY: 5000-UPDATE                                     *22835000
      ******************************************************************22836000
       5400-PROCESS-VOL-BLOCK.                                          
                                                                        
           MOVE PARM-ACCOUNT-NO-NUM      TO UB-ACCOUNT-NO.              
           MOVE PARM-CODE-UTIL-TYPE      TO UB-CODE-UTIL-TYPE.          
           MOVE WS-VOL-BLOCK-FACTOR      TO UB-VOL-BLOCK-FACTOR.        
           MOVE PARM-PRIMARY-IC-NO       TO UB-PRIMARY-IC-NO.           
           MOVE PARM-IC-NO               TO UB-IC-NO.                   
           MOVE PARM-CNTRCT-START-DT     TO UB-CNTRCT-START-DT.         
                                                                        
      * UPDATE HOST VARIABLES. *                                        22839700
           PERFORM 8100-UPDATE-VOL-BLOCK     THRU 8100-UPDATE-EXIT.     
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22840400
      * 5500-GET-VOL-BLOCK                                             *22840500
      *       GET ALL VOLUME BLOCK DETAILS  FROM CSS_VOL_BLOCK TABLE   *22840600
      *       BEFORE UPDATING WITH THE NEW DETAILS (VOL-BLOCK-FACTOR)  *22840700
      *                                                                *22840800
      *     CALLED BY: 5000-UPDATE                                     *22840900
      ******************************************************************22841000
       5500-GET-VOL-BLOCK.                                              
                                                                        
           EXEC SQL                                                     
              SELECT UB.IC_NO,                                          
                     UB.VOL_BLOCK_FACTOR                                
              INTO   :UB-IC-NO,                                         
                     :UB-VOL-BLOCK-FACTOR                               
              FROM   CSS_VOL_BLOCK    UB WITH(READUNCOMMITTED)                  
              WHERE  UB.ACCOUNT_NO      = :UT-ACCOUNT-NO                
                AND  UB.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE            
                AND  UB.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
                AND  UB.IC_NO           = :PARM-IC-NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     22841900
MFA-TR*       SELECT UB.IC_NO,                                          22842000
MFA-TR*              UB.VOL_BLOCK_FACTOR                                22842100
MFA-TR*       INTO   :UB-IC-NO,                                         22842300
MFA-TR*              :UB-VOL-BLOCK-FACTOR                               22842400
MFA-TR*       FROM   CSS_VOL_BLOCK    UB                                22842600
MFA-TR*       WHERE  UB.ACCOUNT_NO      = :UT-ACCOUNT-NO                22842700
MFA-TR*         AND  UB.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE            22842800
MFA-TR*         AND  UB.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         22842900
MFA-TR*         AND  UB.IC_NO           = :PARM-IC-NO                   22843000
MFA-TR*       WITH UR                                                   22843101
MFA-TR*    END-EXEC.                                                    22843200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE UB-VOL-BLOCK-FACTOR   TO WS-PREV-VOL-BLOCK           
              MOVE WS-PREV-VOL-BLOCK     TO WS-PREV-VOL-BLOCK-NUM       
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '5500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_VOL_BLOCK'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE UB-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-3             
              MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************30890000
      *  JOURNALING COPYBOOK.                                          *30900000
      ******************************************************************30910000
           EXEC SQL                                                     30920000
              INCLUDE CPD00067                                          30930000
           END-EXEC.                                                    30940000
                                                                        
HPCCDM*EJECT                                                            30960000
                                                                        
      ******************************************************************30980000
      * 7000-SELECT-ACCOUNT-DTLS.                                      *30990000
      *     1. SELECT CUSTOMER_NO AND  PREMIST_NO FROM CSS_ACCOUNT     *31000000
      *                                                                *31010000
      *     CALLED BY: 5000-UPDATE                                     *31020000
      ******************************************************************31030000
       7000-SELECT-ACCOUNT-DTLS.                                        
                                                                        
           EXEC SQL                                                     
              SELECT AT.CUSTOMER_NO,                                    
                     AT.PREMISE_NO                                      
              INTO   :AT-CUSTOMER-NO,                                   
                     :AT-PREMISE-NO                                     
              FROM   CSS_ACCOUNT AT WITH(READUNCOMMITTED)                       
              WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31060000
MFA-TR*       SELECT AT.CUSTOMER_NO,                                    31070000
MFA-TR*              AT.PREMISE_NO                                      31080000
MFA-TR*       INTO   :AT-CUSTOMER-NO,                                   31250000
MFA-TR*              :AT-PREMISE-NO                                     31260000
MFA-TR*       FROM   CSS_ACCOUNT AT                                     31430000
MFA-TR*       WHERE  ACCOUNT_NO     = :AT-ACCOUNT-NO                    31440000
MFA-TR*       WITH UR                                                   31450001
MFA-TR*    END-EXEC.                                                    31470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31701000
      * 7100-CHECK-VALID-IC.                                           *31702000
      *     CHECK FOR THE IC BEING INSERTED IS A VALID IC NUMBER       *31703000
      *                                                                *31704000
      *     CALLED BY: 5000-UPDATE.                                    *31705000
      ******************************************************************31706000
       7100-CHECK-VALID-IC.                                             
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO   :WS-IC-EXIST-SW                                    
              FROM   CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
              WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 
                AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             
                AND  UT.IC_NO          = :UT-IC-NO                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31709000
MFA-TR*       SELECT 'Y'                                                31709100
MFA-TR*       INTO   :WS-IC-EXIST-SW                                    31709300
MFA-TR*       FROM   CSS_UTIL_ENVRNMT UT                                31709500
MFA-TR*       WHERE  UT.ACCOUNT_NO     = :UT-ACCOUNT-NO                 31709600
MFA-TR*         AND  UT.CODE_UTIL_TYPE = :UT-CODE-UTIL-TYPE             31709700
MFA-TR*         AND  UT.IC_NO          = :UT-IC-NO                      31709800
MFA-TR*       WITH UR                                                   31709901
MFA-TR*    END-EXEC.                                                    31710000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE UT-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE UT-IC-NO              TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31712400
      * 7200-CHECK-CNTRCT-DEMAND.                                      *31712500
      *     CHECK FOR THE IC BEING INSERTED IS A HAVING CONTRACT DEMAND*31712600
      *     ON CSS_BILL_CONTRACT                                       *31712700
      *                                                                *31712800
      *     CALLED BY: 5000-UPDATE.                                    *31712900
      ******************************************************************31713000
       7200-CHECK-CNTRCT-DEMAND.                                        
                                                                        
           EXEC SQL                                                     
              SELECT CONTRACT_DEMAND                                    
              INTO   :BK-CONTRACT-DEMAND                                
              FROM   CSS_BILL_CONTRACT BK WITH(READUNCOMMITTED)                 
              WHERE  BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                
                AND  BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            
                AND  BK.IC_NO           = :BK-IC-NO                     
                AND  BK.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31713300
MFA-TR*       SELECT CONTRACT_DEMAND                                    31713400
MFA-TR*       INTO   :BK-CONTRACT-DEMAND                                31713500
MFA-TR*       FROM   CSS_BILL_CONTRACT BK                               31713600
MFA-TR*       WHERE  BK.ACCOUNT_NO      = :BK-ACCOUNT-NO                31713700
MFA-TR*         AND  BK.CODE_UTIL_TYPE  = :BK-CODE-UTIL-TYPE            31713800
MFA-TR*         AND  BK.IC_NO           = :BK-IC-NO                     31713900
MFA-TR*         AND  BK.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         31714000
MFA-TR*       WITH UR                                                   31714101
MFA-TR*    END-EXEC.                                                    31714200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE =  NOT-FOUND                     
                 MOVE ZEROS              TO BK-CONTRACT-DEMAND          
              ELSE                                                      
                 MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
                 MOVE '7200'             TO ACTIVE-PARAGRAPH            
                 MOVE 'SELECT'           TO ABEND-FUNCTION              
                 MOVE 'CSS_BILL_CONTRACT'   TO TABLE-1                  
                 MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1            
                 MOVE BK-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1          
                 MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-2            
                 MOVE BK-CODE-UTIL-TYPE   TO HOSTVAR-ELEMENT-2          
                 MOVE 'IC_NO'             TO TABLE-ELEMENT-3            
                 MOVE BK-IC-NO            TO HOSTVAR-ELEMENT-3          
                 MOVE 'CNTRCT_START_DT'   TO TABLE-ELEMENT-3            
                 MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-3        
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31717200
      * 7300-GET-MAX-VOL-SEQ.                                          *31717300
      *     GET THE MAX VOL SEQ NO FOR THAT ACCOUNT NUMBER , CODE UTIL *31717400
      *     TYPE AND CONTRACT START DATE                               *31717500
      *                                                                *31717600
      *     CALLED BY: 5000-UPDATE.                                    *31717700
      ******************************************************************31717800
       7300-GET-MAX-VOL-SEQ.                                            
                                                                        
           EXEC SQL                                                     
              SELECT MAX(VOL_BLOCK_SEQ)                                 
              INTO   :WS-VOL-SEQ :WS-NULL-SEQ                            
              FROM   CSS_VOL_BLOCK    UB WITH(READUNCOMMITTED)                  
              WHERE  UB.ACCOUNT_NO      = :UT-ACCOUNT-NO                
                AND  UB.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE            
                AND  UB.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31718100
MFA-TR*       SELECT MAX(VOL_BLOCK_SEQ)                                 31718200
MFA-TR*       INTO   :WS-VOL-SEQ:WS-NULL-SEQ                            31718300
MFA-TR*       FROM   CSS_VOL_BLOCK    UB                                31718400
MFA-TR*       WHERE  UB.ACCOUNT_NO      = :UT-ACCOUNT-NO                31718500
MFA-TR*         AND  UB.CODE_UTIL_TYPE  = :UT-CODE-UTIL-TYPE            31718600
MFA-TR*         AND  UB.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         31718700
MFA-TR*       WITH UR                                                   31718801
MFA-TR*    END-EXEC.                                                    31718900

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_VOL_BLOCK'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE UB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
              MOVE UB-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-3             
              MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31721300
      * 7400-SELECT-RESP-AREA-ID.                                      *31721400
      *     1. GET THE USER'S ASSOCIATED AREA ID BASED ON USERID.      *31721500
      *                                                                *31721600
      *     CALLED BY: 5000-UPDATE                                     *31721700
      ******************************************************************31721800
       7400-SELECT-RESP-AREA-ID.                                        
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :WS-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                     
               WHERE USER_ID = :PARM-USERID                             
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     31722100
MFA-TR*       SELECT RESP_AREA_ID                                       31722200
MFA-TR*         INTO :WS-RESP-AREA-ID                                   31722300
MFA-TR*         FROM CSS_USER_PROFILE                                   31722400
MFA-TR*        WHERE USER_ID = :PARM-USERID                             31722500
MFA-TR*        WITH UR                                                  31722601
MFA-TR*    END-EXEC.                                                    31722700

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7400'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              MOVE PARM-USERID           TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************31726000
      * 7500-CHECK-VALID-ROW.                                          *31727000
      *     CHECK FOR VOLUME BLOCK BEING INSERTED IS NOT ALREADY       *31728000
      *     EXIST FOR THAT IC AND CONTRACT START DT                    *31728100
      *                                                                *31729000
      *     CALLED BY: 5000-UPDATE.                                    *31730000
      ******************************************************************31740000
       7500-CHECK-VALID-ROW.                                            
                                                                        
           EXEC SQL                                                     
              SELECT 'Y'                                                
              INTO   :WS-ROW-EXIST-SW                                   
              FROM   CSS_VOL_BLOCK UB WITH(READUNCOMMITTED)                     
              WHERE  UB.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          
                AND  UB.CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                  :PARM-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :PARM-CNTRCT-START-DT
              ) <> 0) OR (LEN(:PARM-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:PARM-CNTRCT-START-DT
              ), CONVERT(DATE, :PARM-CNTRCT-START-DT) )         
                AND  UB.IC_NO           = :PARM-IC-NO                   
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     31770000
MFA-TR*       SELECT 'Y'                                                31780000
MFA-TR*       INTO   :WS-ROW-EXIST-SW                                   31790000
MFA-TR*       FROM   CSS_VOL_BLOCK UB                                   31800000
MFA-TR*       WHERE  UB.ACCOUNT_NO      = :PARM-ACCOUNT-NO-NUM          31810000
MFA-TR*         AND  UB.CNTRCT_START_DT = :PARM-CNTRCT-START-DT         31820000
MFA-TR*         AND  UB.IC_NO           = :PARM-IC-NO                   31830000
MFA-TR*       WITH UR                                                   31831001
MFA-TR*    END-EXEC.                                                    31840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7500'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_VOL_BLOCK'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              MOVE 'CNTRCT_START_DT'     TO TABLE-ELEMENT-2             
              MOVE PARM-CNTRCT-START-DT  TO HOSTVAR-ELEMENT-2           
              MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
              MOVE PARM-IC-NO            TO HOSTVAR-ELEMENT-3           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************41142000
      * 8000-INSERT-VOL-BLOCK.                                         *41150000
      *        INSERT NEW VOL BLOCK DETAILS INTO CSS_VOL_BLOCK TABLE.  *41160000
      *                                                                *41170000
      *     CALLED BY: 5300-PROCESS-VOL-BLOCK.                         *41180000
      ******************************************************************41190000
       8000-INSERT-VOL-BLOCK.                                           
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_VOL_BLOCK                                 
                   ( ACCOUNT_NO,                                        
                     CODE_UTIL_TYPE,                                    
                     IC_NO,                                             
                     CNTRCT_START_DT,                                   
                     PRIMARY_IC_NO,                                     
                     VOL_BLOCK_SEQ,                                     
                     VOL_BLOCK_FACTOR)                                  
           VALUES ( :UB-ACCOUNT-NO,                                     
                    :UB-CODE-UTIL-TYPE,                                 
                    :UB-IC-NO,                                          
                    IIF(TRY_CONVERT(DATE, :UB-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UB-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UB-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UB-CNTRCT-START-DT
              ), CONVERT(DATE, :UB-CNTRCT-START-DT) ),                         
                    :UB-PRIMARY-IC-NO,                                  
                    :UB-VOL-BLOCK-SEQ,                                  
                    :UB-VOL-BLOCK-FACTOR)                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     41220000
MFA-TR*       INSERT INTO CSS_VOL_BLOCK                                 41230000
MFA-TR*            ( ACCOUNT_NO,                                        41240000
MFA-TR*              CODE_UTIL_TYPE,                                    41250000
MFA-TR*              IC_NO,                                             41260000
MFA-TR*              CNTRCT_START_DT,                                   41270000
MFA-TR*              PRIMARY_IC_NO,                                     41280000
MFA-TR*              VOL_BLOCK_SEQ,                                     41290000
MFA-TR*              VOL_BLOCK_FACTOR)                                  41300000
MFA-TR*    VALUES ( :UB-ACCOUNT-NO,                                     41570000
MFA-TR*             :UB-CODE-UTIL-TYPE,                                 41580000
MFA-TR*             :UB-IC-NO,                                          41590000
MFA-TR*             :UB-CNTRCT-START-DT,                                41600000
MFA-TR*             :UB-PRIMARY-IC-NO,                                  41610000
MFA-TR*             :UB-VOL-BLOCK-SEQ,                                  41620000
MFA-TR*             :UB-VOL-BLOCK-FACTOR)                               41630000
MFA-TR*    END-EXEC.                                                    41900000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8000'               TO ACTIVE-PARAGRAPH             
              MOVE 'INSERT'             TO ABEND-FUNCTION               
              MOVE 'CSS_VOL_BLOCK'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE UB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE UB-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE UB-IC-NO             TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE UB-CNTRCT-START-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
      *                                                                 42141000
      ******************************************************************42162000
      * 8100-UPDATE-VOL-BLOCK.                                         *42170000
      *        UPDATES VOL BLOCK DETAILS INTO CSS_VOL_BLOCK TABLE.     *42180000
      *                                                                *42190000
      *     CALLED BY: 5400-PROCESS-VOL-BLOCK.                         *42200000
      ******************************************************************42210000
       8100-UPDATE-VOL-BLOCK.                                           
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_VOL_BLOCK                                      
                SET  IC_NO            = :UB-IC-NO,                      
                     VOL_BLOCK_FACTOR = :UB-VOL-BLOCK-FACTOR            
                WHERE ACCOUNT_NO      = :UB-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE              
                  AND IC_NO           = :UB-IC-NO                       
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :UB-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UB-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UB-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UB-CNTRCT-START-DT
              ), CONVERT(DATE, :UB-CNTRCT-START-DT) )             
                  AND PRIMARY_IC_NO   = :UB-PRIMARY-IC-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42240000
MFA-TR*       UPDATE CSS_VOL_BLOCK                                      42250000
MFA-TR*         SET  IC_NO            = :UB-IC-NO,                      42260000
MFA-TR*              VOL_BLOCK_FACTOR = :UB-VOL-BLOCK-FACTOR            42320000
MFA-TR*         WHERE ACCOUNT_NO      = :UB-ACCOUNT-NO                  42330000
MFA-TR*           AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE              42340000
MFA-TR*           AND IC_NO           = :UB-IC-NO                       42341000
MFA-TR*           AND CNTRCT_START_DT = :UB-CNTRCT-START-DT             42342000
MFA-TR*           AND PRIMARY_IC_NO   = :UB-PRIMARY-IC-NO               42343000
MFA-TR*    END-EXEC.                                                    42400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8100'               TO ACTIVE-PARAGRAPH             
              MOVE 'UPDATE'             TO ABEND-FUNCTION               
              MOVE 'CSS_VOL_BLOCK'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE UB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE UB-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'IC_NO'              TO TABLE-ELEMENT-3              
              MOVE UB-IC-NO             TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE UB-CNTRCT-START-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8100-UPDATE-EXIT.                                                
           EXIT.                                                        
                                                                        
      ******************************************************************42660000
      * 8200-DELETE-VOL-BLOCK.                                         *42670000
      *      DELETES ALL VOL BLOCK DETAILS FROM CSS_VOL_BLOCK          *42680000
      *      FOR THAT ACCOUNT , CODE_UTIL_TYPE AND CNTRCT_START_DT     *42681000
      *                                                                *42690000
      *     CALLED BY: 5000-UPDATE.                                    *42700000
      ******************************************************************42710000
       8200-DELETE-VOL-BLOCK.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM  CSS_VOL_BLOCK                                
                WHERE ACCOUNT_NO      = :UB-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE              
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :UB-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UB-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UB-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UB-CNTRCT-START-DT
              ), CONVERT(DATE, :UB-CNTRCT-START-DT) )             
                  AND PRIMARY_IC_NO   = :UB-PRIMARY-IC-NO               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     42740000
MFA-TR*       DELETE FROM  CSS_VOL_BLOCK                                42750000
MFA-TR*         WHERE ACCOUNT_NO      = :UB-ACCOUNT-NO                  42780000
MFA-TR*           AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE              42790000
MFA-TR*           AND CNTRCT_START_DT = :UB-CNTRCT-START-DT             42810000
MFA-TR*           AND PRIMARY_IC_NO   = :UB-PRIMARY-IC-NO               42820000
MFA-TR*    END-EXEC.                                                    42830000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8200'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_VOL_BLOCK'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE UB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE UB-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'PRIMARY-IC-NO'      TO TABLE-ELEMENT-3              
              MOVE UB-PRIMARY-IC-NO     TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE UB-CNTRCT-START-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************43090000
      * 8300-DELETE-VOL-BLOCK.                                         *43100000
      *     DELETES VOL BLOCK DETAILS FROM CSS_VOL_BLOCK               *43110000
      *     FOR THAT ACCOUNT , CODE_UTIL_TYPE IC_NO AND CNTRCT_START_DT*43120000
      *                                                                *43130000
      *     CALLED BY: 5000-UPDATE.                                    *43140000
      ******************************************************************43150000
       8300-DELETE-VOL-BLOCK.                                           
                                                                        
           EXEC SQL                                                     
              DELETE FROM  CSS_VOL_BLOCK                                
                WHERE ACCOUNT_NO      = :UB-ACCOUNT-NO                  
                  AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE              
                  AND CNTRCT_START_DT = IIF(TRY_CONVERT(DATE, 
                                                    :UB-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :UB-CNTRCT-START-DT
              ) <> 0) OR (LEN(:UB-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:UB-CNTRCT-START-DT
              ), CONVERT(DATE, :UB-CNTRCT-START-DT) )             
                  AND PRIMARY_IC_NO   = :UB-PRIMARY-IC-NO               
                  AND IC_NO           = :UB-IC-NO                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     43180000
MFA-TR*       DELETE FROM  CSS_VOL_BLOCK                                43190000
MFA-TR*         WHERE ACCOUNT_NO      = :UB-ACCOUNT-NO                  43200000
MFA-TR*           AND CODE_UTIL_TYPE  = :UB-CODE-UTIL-TYPE              43210000
MFA-TR*           AND CNTRCT_START_DT = :UB-CNTRCT-START-DT             43220000
MFA-TR*           AND PRIMARY_IC_NO   = :UB-PRIMARY-IC-NO               43230000
MFA-TR*           AND IC_NO           = :UB-IC-NO                       43231000
MFA-TR*    END-EXEC.                                                    43240000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '8300'               TO ACTIVE-PARAGRAPH             
              MOVE 'DELETE'             TO ABEND-FUNCTION               
              MOVE 'CSS_VOL_BLOCK'      TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE UB-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
              MOVE 'CODE_UTIL_TYPE'     TO TABLE-ELEMENT-2              
              MOVE UB-CODE-UTIL-TYPE    TO HOSTVAR-ELEMENT-2            
              MOVE 'IC-NO'              TO TABLE-ELEMENT-3              
              MOVE UB-IC-NO             TO HOSTVAR-ELEMENT-3            
              MOVE 'CNTRCT_START_DT'    TO TABLE-ELEMENT-4              
              MOVE UB-CNTRCT-START-DT   TO HOSTVAR-ELEMENT-4            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************52550000
      * 9900- JOURNAL INCLUDE                                          *52560000
      ******************************************************************52570000
REARCH     EXEC SQL                                                     52601000
REARCH        INCLUDE CPDSP300                                          52602000
REARCH     END-EXEC.                                                    52603000
                                                                        
      ******************************************************************52620000
      *       END PROGRAM COPYLIB                                      *52630000
      ******************************************************************52640000
REARCH     EXEC SQL                                                     52650100
REARCH        INCLUDE CPD00321                                          52651000
REARCH     END-EXEC.                                                    52652000
                                                                        
