       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02455.                                         
COB303 DATE-WRITTEN.     JULY 2001.                                     
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S455 CONVERTED TO DB2 SP CSR02455 ON 11/03/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      ****             SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S455                                           *        
      *  PROGRAM:       S455                                           *        
      *  CALLING SP:    PA_S455                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM UPDATES OR INSERTS THE ALTERNATE SUPPLY TABLE    *        
      *  DETAILS FOR PANEL402.                                         *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
T23631*  07/2001     SR82046  NEW UPDATE RPC FOR PANEL402              *        
C28150*  03/2003     GANESH   CHANGED THE FUEL-SHIPPER-CD TO DEFAULT AS*        
C28150*                      "N" WHEN ALTN-FUEL-SPLY-CD IS NEGOTIATE   *        
REARCH*  11/2005     CVNS     RPC TO DB2 SP CONVERSION                 *        
REARCH*              CHENNAI                                           *        
A05136*  21/2015     MR7E794  FOR TABLE CSS_ALTN_FUEL_SPLY ADDED       *        
A05136*              ACT024   TRANSACTION HISTORY TABLES UPDATE LOGIC  *        
A05136*  14/2015     RS7M249  GET USERID FROM INPUT INSTEAD FROM CURRE *        
A05136*              ACT232   NT SQLID                                 *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02455'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                   PIC X(40) VALUE                   
REARCH     'WORKING STORAGE FOR CSR02455 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
      *                                                                         
      *****************************************************************         
      **      APPLICATION  TABLE DCLGENS                             **         
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
      *    CSS_ALTN_FUEL_SPLY                                                   
      *****************************************************************         
           EXEC SQL                                                             
               INCLUDE TBALTSPY                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_MNT_TRANS_HIST                                          *         
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHIST                                                 
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *   CSS_MT_TRN_HST_DET                                          *         
      ******************************************************************        
           EXEC SQL                                                             
               INCLUDE TBMNHDT                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
      *                                                                         
       01  WS-MISC.                                                     
REARCH     05 PROGRAM-NAME                PIC X(08)  VALUE 'CSR02455'.  
           05  WS-UPDATE                  PIC X(01)  VALUE 'U'.         
           05  WS-INSERT                  PIC X(01)  VALUE 'I'.         
           05  WS-PARM-BREAKUP.                                         
               10  WS-ALTERNATE-SUPPLY    PIC X(01)  VALUE SPACES.      
               10  WS-RATE                PIC X(03)  VALUE SPACES.      
               10  WS-REVENUE-CLASS       PIC X(03)  VALUE SPACES.      
               10  WS-SHIPPER             PIC X(01)  VALUE SPACES.      
               10  WS-ALTERNATE-FUEL      PIC X(01)  VALUE SPACES.      
               10  WS-ACTION-IND          PIC X(01)  VALUE SPACES.      
           05  WS-COUNTER                 PIC 9(02)  VALUE ZEROS.       
ACT024     05  WS-COMMENT-TEXT.                                         
ACT024         10  WS-COM-TXT-IN          PIC X(42)  VALUE              
ACT024            'MAINTENANCE FOR ALT FUEL SUPPLY - CSR02455'.         
ACT024         10  WS-COM-BLNK-IN         PIC X(168) VALUE SPACES.      
      *                                                                         
       01  WS-LITERALS.                                                 
           05 WS-ONE                      PIC 9(01)  VALUE 1.           
           05 WS-TWO                      PIC 9(01)  VALUE 2.           
      *                                                                 00052000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                PIC X(01)  VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW               PIC X(01)  VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
      *                                                                 00052000
HPCCDM*    EJECT                                                        00096000
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                   POINTER.                              
CVT999*    05  GWL-INIT-HANDLE            POINTER.                              
CVT999*    05  GWL-RC                     PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-NR              PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-DONE            PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-COUNT           PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-COMM            PIC S9(9)   COMP.                     
CVT999*    05  GWL-STATUS-RETURN-CODE     PIC S9(9)   COMP.                     
           05  GWL-STATUS-SUBCODE         PIC S9(9)   COMP.             
      *                                                                         
       01  FILLER                         PIC X(11)  VALUE              
                                                    'PARM FIELDS'.      
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                     PIC S9(9)   COMP.                     
CVT999*    05  PARM-ID1                   PIC S9(9)   COMP                      
REARCH*                                              VALUE 1.                   
           05  PARM-ACCOUNT-NO            PIC X(13)  VALUE SPACES.      
           05  PARM-ACCOUNT-NO-RED      REDEFINES PARM-ACCOUNT-NO       
                                          PIC 9(13).                    
           05  PARM-IC-NO                 PIC S9(4)   COMP              
                                                     VALUE 0.           
           05  PARM-CODE-UTIL-TYPE        PIC X(01)  VALUE SPACES.      
           05  PARM-CNTRCT-START-DT       PIC X(10)  VALUE SPACES.      
           05  PARM-ALT-FUEL-DTLS1        PIC X(10)  VALUE SPACES.      
           05  PARM-ALT-FUEL-DTLS2        PIC X(10)  VALUE SPACES.      
ACT232     05  PARM-USER-ID               PIC X(07)  VALUE SPACES.      
ACT024*                                                                         
ACT024 01  WS-PREV-CHNG.                                                
ACT024     05 WS-PREV-ALT-SPLY-RATE-NO     PIC X(3).                    
ACT024     05 WS-PREV-ALT-SPLY-REV-CL-CD   PIC X(3).                    
ACT024     05 WS-PREV-FUEL-SHIPPER-CD      PIC X(1).                    
ACT024     05 WS-PREV-ALTERNATE-FUEL-CD    PIC X(1).                    
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                   PIC S9(9)   COMP.             
CVT999*    05  SNA-CONNECTION-NAME        PIC X(8)   VALUE SPACES.              
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                 PIC S9(9)   COMP                      
CVT999*                                              VALUE 1.                   
           05  CTR-ROWS                   PIC S9(9)   COMP              
                                                     VALUE 0.           
           05  WS-ROW-COUNT               PIC S9(9)   COMP              
                                                     VALUE 0.           
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM            PIC S9(9)   COMP.                     
CVT999*    05  WRKLEN1                    PIC S9(9)   COMP.                     
CVT999*    05  WRKLEN2                    PIC S9(9)   COMP.                     
           05  WRK-DONE-STATUS            PIC S9(9)   COMP.             
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE             PIC S9(9)   COMP              
                                                     VALUE ZEROS.       
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH      05 S-RETURN-CODE              PIC S9(9)   COMP              
REARCH                                               VALUE ZEROS.       
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE            PIC X(11)  VALUE                      
CVT999*                                         'RETURN_CODE'.                  
CVT999*                                                                         
HPCCDM*    EJECT                                                        02620001
      *                                                                         
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
REARCH*01  LINK-ACCOUNT-NO-RED      PIC 9(13)                .                  
CVT000 01  LINK-IC-NO               PIC S9(4)   COMP         .          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-CNTRCT-START-DT     PIC X(10)                .          
CVT000 01  LINK-ALT-FUEL-DTLS1      PIC X(10)                .          
CVT000 01  LINK-ALT-FUEL-DTLS2      PIC X(10)                .          
ACT232 01  LINK-USER-ID             PIC X(07)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-IC-NO                                              
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-CNTRCT-START-DT                                    
CVT000         ,LINK-ALT-FUEL-DTLS1                                     
CVT000         ,LINK-ALT-FUEL-DTLS2                                     
ACT232         ,LINK-USER-ID                                            
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE               THRU 0100-EXIT.        
           PERFORM 1000-PROCESS-INPUT            THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT           THRU 2000-EXIT.        
      *                                                                         
           IF  CTR-ROWS < 1                                             
               INITIALIZE GTT-RETURN-FIELDS                             
               MOVE +100                         TO RS-RETURN-CODE      
REARCH         PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT        
               PERFORM 8100-SEND-RESULT          THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 9999-END-PROGRAM              THRU 9999-EXIT.        
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                           TO ACTIVE-PARAGRAPH.   
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME                  TO ABEND-PROGRAM               
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'            TO TABLE-1                     
CVT999*       MOVE GWL-RC                        TO                             
CVT999*                                           WS-ACTIVE-RETURN-CODE         
CVT999*       PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT                 
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT                 
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH        :S-RETURN-CODE              AS    RETURN_CODE             
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-IC-NO                TO PARM-IC-NO               . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-CNTRCT-START-DT      TO PARM-CNTRCT-START-DT     . 
CVT000     MOVE LINK-ALT-FUEL-DTLS1       TO PARM-ALT-FUEL-DTLS1      . 
CVT000     MOVE LINK-ALT-FUEL-DTLS2       TO PARM-ALT-FUEL-DTLS2      . 
ACT232     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
      *                                                                         
REARCH*    PERFORM 1100-RECEIVE-PARMS          THRU 1100-EXIT.                  
           MOVE PARM-ACCOUNT-NO-RED            TO AK-ACCOUNT-NO.        
           MOVE PARM-CODE-UTIL-TYPE            TO AK-CODE-UTIL-TYPE.    
           MOVE PARM-IC-NO                     TO AK-IC-NO.             
           MOVE PARM-CNTRCT-START-DT           TO AK-CNTRCT-START-DT.   
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
      ***** RECEIVING PARAMETER PREMISE NO                                      
CVT999*    MOVE 1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      ***** RECEIVING PARAMETER IC NO                                           
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-IC-NO             TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-IC-NO,                                    
CVT999*                          TDSINT2,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      **** RECEIVING PARAMETER CODE-UTIL-TYPE                                   
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CODE-UTIL-TYPE    TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CODE-UTIL-TYPE,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
      **** RECEIVING PARAMETER CONTRACT START DATE                              
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-CNTRCT-START-DT   TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-CNTRCT-START-DT,                          
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER ALTERNATE SUPPLY                                 
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ALT-FUEL-DTLS1    TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ALT-FUEL-DTLS1,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      **** RECEIVING PARAMETER RATE                                             
CVT999*    ADD  1                                TO PARM-ID1.                   
CVT999*    MOVE LENGTH OF PARM-ALT-FUEL-DTLS2    TO MAX-LENGTH-PARM.            
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ALT-FUEL-DTLS2                            
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
      *                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT-IM                                 *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
REARCH*    PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT-IM          THRU 2200-EXIT.        
      *                                                                         
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT                                              *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE              TO S-RETURN-CODE.           
REARCH 2000A-EXIT.                                                      
REARCH       EXIT.                                                      
REARCH*                                                                         
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
      *                                                                         
REARCH*    MOVE '2100'                           TO ACTIVE-PARAGRAPH.           
                                                                        
CVT999*    MOVE 1                                TO CTR-COLUMN.                 
CVT999*    MOVE TDSINT4                          TO DB-HOST-TYPE.               
CVT999*    MOVE TDSINT4                          TO DB-CLIENT-TYPE.             
CVT999*    MOVE LENGTH OF RS-RETURN-CODE         TO WRKLEN1.                    
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE        TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR              THRU 9100-EXIT.                
                                                                        
      *                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
      *                                                                         
      ******************************************************************        
      *    2200-BUILD-RESULT-IM                                        *        
      *                                                                *        
      *    CALLED FROM 2000-PROCESS-OUTPUT                             *        
      *                                                                *        
      *                                                                *        
      ******************************************************************        
       2200-BUILD-RESULT-IM.                                            
      *                                                                         
           MOVE '2200'                           TO ACTIVE-PARAGRAPH.   
           MOVE PARM-ALT-FUEL-DTLS1              TO WS-PARM-BREAKUP.    
           PERFORM 2210-UPDATE                 THRU 2210-EXIT           
                   UNTIL WS-COUNTER = WS-TWO.                           
      *                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2210-UPDATE.                                                     
           IF WS-PARM-BREAKUP NOT EQUAL SPACES                          
              MOVE WS-ALTERNATE-SUPPLY         TO AK-ALTN-FUEL-SPLY-CD  
              MOVE WS-RATE                     TO AK-ALT-SPLY-RATE-NO   
              MOVE WS-REVENUE-CLASS            TO AK-ALT-SPLY-REV-CL-CD 
              MOVE WS-SHIPPER                  TO AK-FUEL-SHIPPER-CD    
              MOVE WS-ALTERNATE-FUEL           TO AK-ALTERNATE-FUEL-CD  
              IF AK-ALTN-FUEL-SPLY-CD = 'N'                             
                 MOVE 'N'                      TO AK-FUEL-SHIPPER-CD    
              END-IF                                                    
ACT024        PERFORM 7200-FORMAT-MH           THRU 7200-EXIT           
              EVALUATE WS-ACTION-IND                                    
                  WHEN WS-UPDATE                                        
ACT024                 PERFORM 7500-SELT-BEFORE-UPD-CHNG  THRU 7500-EXIT
                       PERFORM 7000-UPDATE-ALT-FUEL-SPLY  THRU 7000-EXIT
ACT024                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL   
ACT024                 PERFORM 7300-PROCESS-LOAD-UP-TRANS THRU 7300-EXIT
ACT024                 END-IF                                           
                  WHEN WS-INSERT                                        
                       PERFORM 7100-INSERT-ALT-FUEL-SPLY  THRU 7100-EXIT
ACT024                 IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL   
ACT024                 PERFORM 7400-PROCESS-LOAD-IN-TRANS THRU 7400-EXIT
ACT024                 END-IF                                           
              END-EVALUATE                                              
              MOVE SPACES                      TO WS-ACTION-IND         
REARCH        PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT          
              PERFORM 8100-SEND-RESULT         THRU 8100-EXIT           
           END-IF.                                                      
           ADD WS-ONE                          TO WS-COUNTER.           
           MOVE PARM-ALT-FUEL-DTLS2            TO WS-PARM-BREAKUP.      
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************04400001
      *  UPDATES THE DATA IN   ALTERNATE FUEL SUPPLY TABLE             *04420001
      ******************************************************************04450001
       7000-UPDATE-ALT-FUEL-SPLY.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ALTN_FUEL_SPLY                                
                  SET  ALT_SPLY_RATE_NO    = :AK-ALT-SPLY-RATE-NO       
                      ,ALT_SPLY_REV_CL_CD  = :AK-ALT-SPLY-REV-CL-CD     
                      ,FUEL_SHIPPER_CD     = :AK-FUEL-SHIPPER-CD        
                      ,ALTERNATE_FUEL_CD   = :AK-ALTERNATE-FUEL-CD      
               WHERE  ACCOUNT_NO        = :AK-ACCOUNT-NO                
                 AND  CODE_UTIL_TYPE    = :AK-CODE-UTIL-TYPE            
                 AND  IC_NO             = :AK-IC-NO                     
                 AND  CNTRCT_START_DT   = IIF(TRY_CONVERT(DATE, 
                                                    :AK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :AK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:AK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:AK-CNTRCT-START-DT
              ), CONVERT(DATE, :AK-CNTRCT-START-DT) )           
                 AND  ALTN_FUEL_SPLY_CD = :AK-ALTN-FUEL-SPLY-CD         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04460001
MFA-TR*        UPDATE CSS_ALTN_FUEL_SPLY                                        
MFA-TR*           SET  ALT_SPLY_RATE_NO    = :AK-ALT-SPLY-RATE-NO               
MFA-TR*               ,ALT_SPLY_REV_CL_CD  = :AK-ALT-SPLY-REV-CL-CD             
MFA-TR*               ,FUEL_SHIPPER_CD     = :AK-FUEL-SHIPPER-CD                
MFA-TR*               ,ALTERNATE_FUEL_CD   = :AK-ALTERNATE-FUEL-CD              
MFA-TR*        WHERE  ACCOUNT_NO        = :AK-ACCOUNT-NO                        
MFA-TR*          AND  CODE_UTIL_TYPE    = :AK-CODE-UTIL-TYPE                    
MFA-TR*          AND  IC_NO             = :AK-IC-NO                             
MFA-TR*          AND  CNTRCT_START_DT   = :AK-CNTRCT-START-DT                   
MFA-TR*          AND  ALTN_FUEL_SPLY_CD = :AK-ALTN-FUEL-SPLY-CD                 
MFA-TR*    END-EXEC.                                                    04480001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04490001
           MOVE SQLCODE                          TO                     
                                                  WS-ACTIVE-RETURN-CODE 
                                                  RS-RETURN-CODE.       
      *                                                                 04510001
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE '7000'                       TO ACTIVE-PARAGRAPH    
               MOVE 'UPDATE'                     TO ABEND-FUNCTION      
               MOVE 'CSS_ALT_FUEL_SPLY'          TO TABLE-1             
               MOVE 'ACCOUNT-NO'                 TO TABLE-ELEMENT-1     
               MOVE 'CODE_UTIL_TYPE'             TO TABLE-ELEMENT-2     
               MOVE 'IC_NO'                      TO TABLE-ELEMENT-3     
               MOVE 'CNTRCT_START_DT'            TO TABLE-ELEMENT-4     
               MOVE AK-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
               MOVE AK-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
               MOVE AK-IC-NO                     TO HOSTVAR-ELEMENT-3   
               MOVE AK-CNTRCT-START-DT           TO HOSTVAR-ELEMENT-4   
      *                                                                         
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
      ******************************************************************04400001
      *  INSERTS THE DATA IN   ALTERNATE FUEL SUPPLY TABLE             *04420001
      ******************************************************************04450001
       7100-INSERT-ALT-FUEL-SPLY.                                       
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_ALTN_FUEL_SPLY                           
                     ( ACCOUNT_NO                                       
                      ,CODE_UTIL_TYPE                                   
                      ,IC_NO                                            
                      ,CNTRCT_START_DT                                  
                      ,ALTN_FUEL_SPLY_CD                                
                      ,ALT_SPLY_RATE_NO                                 
                      ,ALT_SPLY_REV_CL_CD                               
                      ,FUEL_SHIPPER_CD                                  
                      ,ALTERNATE_FUEL_CD)                               
               VALUES                                                   
                    ( :AK-ACCOUNT-NO                                    
                     ,:AK-CODE-UTIL-TYPE                                
                     ,:AK-IC-NO                                         
                     ,IIF(TRY_CONVERT(DATE, :AK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :AK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:AK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:AK-CNTRCT-START-DT
              ), CONVERT(DATE, :AK-CNTRCT-START-DT) )                          
                     ,:AK-ALTN-FUEL-SPLY-CD                             
                     ,:AK-ALT-SPLY-RATE-NO                              
                     ,:AK-ALT-SPLY-REV-CL-CD                            
                     ,:AK-FUEL-SHIPPER-CD                               
                     ,:AK-ALTERNATE-FUEL-CD)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04460001
MFA-TR*        INSERT INTO CSS_ALTN_FUEL_SPLY                                   
MFA-TR*              ( ACCOUNT_NO                                               
MFA-TR*               ,CODE_UTIL_TYPE                                           
MFA-TR*               ,IC_NO                                                    
MFA-TR*               ,CNTRCT_START_DT                                          
MFA-TR*               ,ALTN_FUEL_SPLY_CD                                        
MFA-TR*               ,ALT_SPLY_RATE_NO                                         
MFA-TR*               ,ALT_SPLY_REV_CL_CD                                       
MFA-TR*               ,FUEL_SHIPPER_CD                                          
MFA-TR*               ,ALTERNATE_FUEL_CD)                                       
MFA-TR*        VALUES                                                           
MFA-TR*             ( :AK-ACCOUNT-NO                                            
MFA-TR*              ,:AK-CODE-UTIL-TYPE                                        
MFA-TR*              ,:AK-IC-NO                                                 
MFA-TR*              ,:AK-CNTRCT-START-DT                                       
MFA-TR*              ,:AK-ALTN-FUEL-SPLY-CD                                     
MFA-TR*              ,:AK-ALT-SPLY-RATE-NO                                      
MFA-TR*              ,:AK-ALT-SPLY-REV-CL-CD                                    
MFA-TR*              ,:AK-FUEL-SHIPPER-CD                                       
MFA-TR*              ,:AK-ALTERNATE-FUEL-CD)                                    
MFA-TR*    END-EXEC.                                                    04480001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 04490001
           MOVE SQLCODE                          TO                     
                                                  WS-ACTIVE-RETURN-CODE 
                                                  RS-RETURN-CODE.       
      *                                                                 04510001
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE '7000'                       TO ACTIVE-PARAGRAPH    
               MOVE 'INSERT'                     TO ABEND-FUNCTION      
               MOVE 'CSS_ALT_FUEL_SPLY'          TO TABLE-1             
               MOVE 'ACCOUNT-NO'                 TO TABLE-ELEMENT-1     
               MOVE 'CODE_UTIL_TYPE'             TO TABLE-ELEMENT-2     
               MOVE 'IC_NO'                      TO TABLE-ELEMENT-3     
               MOVE 'CNTRCT_START_DT'            TO TABLE-ELEMENT-4     
               MOVE AK-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
               MOVE AK-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
               MOVE AK-IC-NO                     TO HOSTVAR-ELEMENT-3   
               MOVE AK-CNTRCT-START-DT           TO HOSTVAR-ELEMENT-4   
      *                                                                         
               PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
               PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
ACT024******************************************************************04400001
ACT024*  FORMAT FOR THE MNT TRANSACTION HISTORY TABLE                  *04420001
ACT024******************************************************************04450001
ACT024 7200-FORMAT-MH.                                                  
ACT024                                                                  
ACT024     EXEC SQL                                                     
ACT024         SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO            
ACT024     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT024                                                                  
ACT024     EXEC SQL                                                     
ACT024         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                        
ACT024     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-DATE-TRANS = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT024                                                                  
ACT024                                                                  
ACT024     MOVE 'F'                       TO MH-CODE-TRAN-TYPE.         
ACT024     MOVE SPACES                    TO MH-RESP-AREA-ID.           
ACT024     MOVE PARM-ACCOUNT-NO-RED       TO MH-ACCOUNT-NO.             
ACT024     MOVE ZEROES                    TO MH-CUSTOMER-NO.            
ACT024     MOVE ZEROES                    TO MH-PREMISE-NO.             
ACT232     MOVE PARM-USER-ID              TO MH-USER-ID.                
ACT024     MOVE 'PANEL402'                TO MH-APPL-PROGRAM-ID.        
ACT024     MOVE WS-COMMENT-TEXT           TO MH-TRAN-COMMENT-TEXT.      
ACT024     MOVE LENGTH OF WS-COMMENT-TEXT TO MH-TRAN-COMMENT-LEN.       
ACT024                                                                  
ACT024 7200-EXIT.                                                       
ACT024     EXIT.                                                        
ACT024*                                                                         
ACT024******************************************************************04400001
ACT024*  LOAD THE DATA IN   MNT TRANSACTION HISTORY & DETAIL TABLE     *04420001
ACT024******************************************************************04450001
ACT024 7300-PROCESS-LOAD-UP-TRANS.                                      
ACT024                                                                  
ACT024*                                                                         
ACT024     MOVE 0                         TO MI-TRAN-APPL-NO.           
ACT024     IF WS-RATE           NOT EQUAL TO WS-PREV-ALT-SPLY-RATE-NO   
ACT024      MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO       
ACT024      MOVE +3                       TO MI-PRV-COLUMN-VALUE-LEN    
ACT024      MOVE +3                       TO MI-CHG-COLUMN-VALUE-LEN    
ACT024      MOVE AK-ALT-SPLY-RATE-NO      TO MI-CHG-COLUMN-VALUE-TEXT   
ACT024      MOVE WS-PREV-ALT-SPLY-RATE-NO TO MI-PRV-COLUMN-VALUE-TEXT   
ACT024      MOVE 'ALT SPLY RATENO'        TO MI-COLUMN-DESC             
ACT024      ADD 1                         TO MI-TRAN-APPL-NO            
ACT024      MOVE SPACES                   TO MI-TABLE-ID                
ACT024      PERFORM 6530-LOAD-MNT-TRANS-HIST    THRU 6530-EXIT          
ACT024     END-IF.                                                      
ACT024*                                                                         
ACT024     IF WS-REVENUE-CLASS NOT EQUAL TO WS-PREV-ALT-SPLY-REV-CL-CD  
ACT024      MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO     
ACT024      MOVE +3                         TO MI-PRV-COLUMN-VALUE-LEN  
ACT024      MOVE +3                         TO MI-CHG-COLUMN-VALUE-LEN  
ACT024      MOVE AK-ALT-SPLY-REV-CL-CD      TO MI-CHG-COLUMN-VALUE-TEXT 
ACT024      MOVE WS-PREV-ALT-SPLY-REV-CL-CD TO MI-PRV-COLUMN-VALUE-TEXT 
ACT024      MOVE 'ALT SPLY REV CL'          TO MI-COLUMN-DESC           
ACT024      ADD 1                           TO MI-TRAN-APPL-NO          
ACT024      MOVE SPACES                     TO MI-TABLE-ID              
ACT024      PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT         
ACT024     END-IF.                                                      
ACT024*                                                                         
ACT024     IF WS-SHIPPER       NOT EQUAL  TO WS-PREV-FUEL-SHIPPER-CD    
ACT024      MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO       
ACT024      MOVE +1                       TO MI-PRV-COLUMN-VALUE-LEN    
ACT024      MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN    
ACT024      MOVE AK-FUEL-SHIPPER-CD       TO MI-CHG-COLUMN-VALUE-TEXT   
ACT024      MOVE WS-PREV-FUEL-SHIPPER-CD  TO MI-PRV-COLUMN-VALUE-TEXT   
ACT024      MOVE 'ALT FUEL SHIPCD'        TO MI-COLUMN-DESC             
ACT024      ADD 1                         TO MI-TRAN-APPL-NO            
ACT024      MOVE SPACES                   TO MI-TABLE-ID                
ACT024      PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT         
ACT024     END-IF.                                                      
ACT024*                                                                         
ACT024     IF WS-ALTERNATE-FUEL NOT EQUAL TO WS-PREV-ALTERNATE-FUEL-CD  
ACT024      MOVE MH-TRANS-HIST-SEQ-NO      TO MI-TRANS-HIST-SEQ-NO      
ACT024      MOVE +3                        TO MI-PRV-COLUMN-VALUE-LEN   
ACT024      MOVE +3                        TO MI-CHG-COLUMN-VALUE-LEN   
ACT024      MOVE AK-ALTERNATE-FUEL-CD      TO MI-CHG-COLUMN-VALUE-TEXT  
ACT024      MOVE WS-PREV-ALTERNATE-FUEL-CD TO MI-PRV-COLUMN-VALUE-TEXT  
ACT024      MOVE 'ALT FUEL CD    '         TO MI-COLUMN-DESC            
ACT024      ADD 1                          TO MI-TRAN-APPL-NO           
ACT024      MOVE SPACES                    TO MI-TABLE-ID               
ACT024      PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT         
ACT024     END-IF.                                                      
ACT024*                                                                         
ACT024 7300-EXIT.                                                       
ACT024      EXIT.                                                       
ACT024*                                                                         
ACT024******************************************************************04400001
ACT024*  LOAD THE DATA IN   MNT TRANSACTION HISTORY & DETAIL TABLE     *04420001
ACT024******************************************************************04450001
ACT024 7400-PROCESS-LOAD-IN-TRANS.                                      
ACT024                                                                  
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE 0                          TO MI-TRAN-APPL-NO.          
ACT024*                                                                         
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +1                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-CODE-UTIL-TYPE          TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'CODE UTIL TYPE '          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +4                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-IC-NO                   TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'IC NO          '          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +10                        TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-CNTRCT-START-DT         TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'CNTRCT START DT'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +1                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-ALTN-FUEL-SPLY-CD       TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT SPLY CD    '          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +3                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-ALT-SPLY-RATE-NO        TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT SPL RATE NO'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +3                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-ALT-SPLY-REV-CL-CD      TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT SPLY REV CL'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +3                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-FUEL-SHIPPER-CD         TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT FUEL SHIPCD'          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO.     
ACT024     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN.  
ACT024     MOVE +3                         TO MI-CHG-COLUMN-VALUE-LEN.  
ACT024     MOVE AK-ALTERNATE-FUEL-CD       TO MI-CHG-COLUMN-VALUE-TEXT. 
ACT024     MOVE '*NEW*'                    TO MI-PRV-COLUMN-VALUE-TEXT. 
ACT024     MOVE 'ALT FUEL CD    '          TO MI-COLUMN-DESC.           
ACT024     ADD 1                           TO MI-TRAN-APPL-NO.          
ACT024     MOVE SPACES                     TO MI-TABLE-ID.              
ACT024     PERFORM 6530-LOAD-MNT-TRANS-HIST     THRU 6530-EXIT.         
ACT024*                                                                         
ACT024 7400-EXIT.                                                       
ACT024      EXIT.                                                       
ACT024*                                                                         
ACT024*                                                                         
ACT024******************************************************************04400001
ACT024*  SELECT THE DATA BEFORE UPDATE IN   ALTERNATE FUEL SUPPLY TABLE*04420001
ACT024******************************************************************04450001
ACT024 7500-SELT-BEFORE-UPD-CHNG.                                       
ACT024                                                                  
ACT024     EXEC SQL                                                     
ACT024         SELECT ALT_SPLY_RATE_NO                                  
ACT024               ,ALT_SPLY_REV_CL_CD                                
ACT024               ,FUEL_SHIPPER_CD                                   
ACT024               ,ALTERNATE_FUEL_CD                                 
ACT024         INTO  :WS-PREV-ALT-SPLY-RATE-NO                          
ACT024              ,:WS-PREV-ALT-SPLY-REV-CL-CD                        
ACT024              ,:WS-PREV-FUEL-SHIPPER-CD                           
ACT024              ,:WS-PREV-ALTERNATE-FUEL-CD                         
ACT024         FROM CSS_ALTN_FUEL_SPLY                                  
ACT024         WHERE  ACCOUNT_NO        = :AK-ACCOUNT-NO                
ACT024           AND  CODE_UTIL_TYPE    = :AK-CODE-UTIL-TYPE            
ACT024           AND  IC_NO             = :AK-IC-NO                     
ACT024           AND  CNTRCT_START_DT   = IIF(TRY_CONVERT(DATE, 
                                                    :AK-CNTRCT-START-DT
              ) IS NULL OR (PATINDEX('%.%', :AK-CNTRCT-START-DT
              ) <> 0) OR (LEN(:AK-CNTRCT-START-DT
              ) <> 10), CIS.CHAR2DATE(:AK-CNTRCT-START-DT
              ), CONVERT(DATE, :AK-CNTRCT-START-DT) )           
ACT024           AND  ALTN_FUEL_SPLY_CD = :AK-ALTN-FUEL-SPLY-CD         
ACT024     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     04460001
MFA-TR*        SELECT ALT_SPLY_RATE_NO                                          
MFA-TR*              ,ALT_SPLY_REV_CL_CD                                        
MFA-TR*              ,FUEL_SHIPPER_CD                                           
MFA-TR*              ,ALTERNATE_FUEL_CD                                         
MFA-TR*        INTO  :WS-PREV-ALT-SPLY-RATE-NO                                  
MFA-TR*             ,:WS-PREV-ALT-SPLY-REV-CL-CD                                
MFA-TR*             ,:WS-PREV-FUEL-SHIPPER-CD                                   
MFA-TR*             ,:WS-PREV-ALTERNATE-FUEL-CD                                 
MFA-TR*        FROM CSS_ALTN_FUEL_SPLY                                          
MFA-TR*        WHERE  ACCOUNT_NO        = :AK-ACCOUNT-NO                        
MFA-TR*          AND  CODE_UTIL_TYPE    = :AK-CODE-UTIL-TYPE                    
MFA-TR*          AND  IC_NO             = :AK-IC-NO                             
MFA-TR*          AND  CNTRCT_START_DT   = :AK-CNTRCT-START-DT                   
MFA-TR*          AND  ALTN_FUEL_SPLY_CD = :AK-ALTN-FUEL-SPLY-CD                 
MFA-TR*    END-EXEC.                                                    04480001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

ACT024*                                                                 04490001
ACT024     MOVE SQLCODE                          TO                     
ACT024                                            WS-ACTIVE-RETURN-CODE 
ACT024                                            RS-RETURN-CODE.       
ACT024*                                                                 04510001
ACT024     IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
ACT024         NEXT SENTENCE                                            
ACT024     ELSE                                                         
ACT024         MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
ACT024         MOVE '7500'                       TO ACTIVE-PARAGRAPH    
ACT024         MOVE 'SELECT'                     TO ABEND-FUNCTION      
ACT024         MOVE 'CSS_ALT_FUEL_SPLY'          TO TABLE-1             
ACT024         MOVE 'ACCOUNT-NO'                 TO TABLE-ELEMENT-1     
ACT024         MOVE 'CODE_UTIL_TYPE'             TO TABLE-ELEMENT-2     
ACT024         MOVE 'IC_NO'                      TO TABLE-ELEMENT-3     
ACT024         MOVE 'CNTRCT_START_DT'            TO TABLE-ELEMENT-4     
ACT024         MOVE AK-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1   
ACT024         MOVE AK-CODE-UTIL-TYPE            TO HOSTVAR-ELEMENT-2   
ACT024         MOVE AK-IC-NO                     TO HOSTVAR-ELEMENT-3   
ACT024         MOVE AK-CNTRCT-START-DT           TO HOSTVAR-ELEMENT-4   
ACT024*                                                                         
ACT024         PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
ACT024         PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
ACT024     END-IF.                                                      
ACT024                                                                  
ACT024 7500-EXIT.                                                       
ACT024      EXIT.                                                       
ACT024*                                                                         
HPCCDM*EJECT                                                                    
ACT024                                                                  
ACT024******************************************************************        
ACT024* 6530-LOAD-MNT-TRANS-HIST.                                      *        
ACT024******************************************************************        
ACT024     EXEC SQL                                                     29920000
ACT024        INCLUDE CPD00067                                          29930000
ACT024     END-EXEC.                                                    29940000
ACT024                                                                  
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
