       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02447.                                         
COB303 DATE-WRITTEN.      FEBRUARY 21, 2000.                            
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S447                                           *00120000
      *  PROGRAM:       S447                                           *00130000
      *  CALLING SP:    PA_S447                                        *00140000
      *  PANEL:         NONE                                           *00150000
      *                                                                *00160000
      ******************************************************************00170000
      *                 P R O G R A M  S U M M A R Y                   *00180000
      *                                                                *00190000
      *  GIVEN A CUSTOMER NUMBER, UPDATES CSS_CUST_STATS WITH EBILL    *00200000
      *  REGISTER IND AS 'Y' IF PRESENT. IF NOT PRESENT INSERTS DETAILS*00210000
      *  INTO CSS_CUST_STATS. ALSO WRITES INTO MAINTENANCE TRANSACTION *00220000
      *  HISTORY TABLES.                                               *00230000
      *                                                                *00240000
      ******************************************************************00250000
      *                                                                *00260000
      *                     PROGRAM MODIFICATION LOG                   *00270000
      *                                                                *00280000
      *    DATE    INITIALS   COMMENTS                                 *00290000
      *  --------  --------   ---------------------------------------  *00300000
      *  02/21/01    AS       PROCEDURE ORIGINALLY CODED.              *00310000
AS    *  03/29/01    AS       INCLUDED A NEW PARAMETER BASED ON WHICH  *00550000
AS    *                       EBILL REGISTER IND WOULD BE Y OR SPACES  *00550000
      *  10/01/07    CVNS     RPC TO DB2 SP CONVERSION                 *        
      *              CHENNAI                                           *        
P00730*  03/11/13   DB18339   ADDED UPDATE TO CSS_SERVICE_PROMO WHERE  *        
P00730*                       RELEVANT.                                *        
A05317*  08/11/15   FMB       CORRECTED DELETE TRANSHIST.              *        
      *                                                                *00550000
      ******************************************************************00550000
      *                                                                *00550000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00560000
      *                                                                *00570000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00580000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00590000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00600000
      *  3000 - 4999  NOT USED                                         *00610000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00620000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00630000
      *  7000 - 7999  INPUT MODULES                                    *00640000
      *  8000 - 8999  OUTPUT MODULES                                   *00650000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00660000
      *                                                                *00670000
      ******************************************************************00680000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02447'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02447 STARTS HERE'.                  
                                                                        
      ******************************************************************00770000
      *    DB2 INCLUDES                                                *00780000
      ******************************************************************00790000
                                                                        
           EXEC SQL                                                     00810000
              INCLUDE SQLCA                                             00820000
           END-EXEC.                                                    00830000
                                                                        
           EXEC SQL                                                     00850000
              INCLUDE TBMODEL                                           00860000
           END-EXEC.                                                    00870000
                                                                        
           EXEC SQL                                                     00890000
              INCLUDE TBCUST                                            00900000
           END-EXEC.                                                    00910000
                                                                        
           EXEC SQL                                                     00912000
              INCLUDE TBCSTSTS                                          00913000
           END-EXEC.                                                    00914000
                                                                        
           EXEC SQL                                                     00912000
              INCLUDE TBMNHDT                                           00913000
           END-EXEC.                                                    00914000
                                                                        
           EXEC SQL                                                     00970000
              INCLUDE TBMNHIST                                          00980000
           END-EXEC.                                                    00990000
                                                                        
           EXEC SQL                                                     01215000
              INCLUDE TBARLOCK                                          01216000
           END-EXEC.                                                    01217000
                                                                        
      ******************************************************************01220000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01230000
      ******************************************************************01240000
                                                                        
           COPY CCA00001.                                               01280000
           COPY CWS00027.                                               01300000
           COPY CWS00303.                                               01310000
                                                                        
      ******************************************************************01330000
      *    WORK AREAS                                                  *01340000
      ******************************************************************01350000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
JS         05  PARM-CUSTOMER-NO        PIC X(10)  VALUE SPACES.         
JS         05  PARM-CUSTOMER-NO-RED    REDEFINES PARM-CUSTOMER-NO       
JS                                     PIC 9(10).                       
COB305     05 PARM-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 
COB305       VALUE 0.        
AS         05  PARM-REG-IND            PIC X(01)  VALUE SPACES.         
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
           05  WS-INSERT-FL            PIC X(01) VALUE 'N'.             
               88 INSERT-TYPE                    VALUE 'Y'.             
           05  WS-UPDATE-FL            PIC X(01) VALUE 'N'.             
               88 UPDATE-TYPE                    VALUE 'Y'.             
                                                                        
       01  WS-MISC.                                                     
           05  WS-RCVPRM               PIC X(20) VALUE SPACES.          
           05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02447'.      
           05  WS-USERID               PIC X(07) VALUE 'WEBTRN1'.       
           05  WS-PROGRAM-ID           PIC X(08) VALUE 'WEBREG'.        
           05  WS-TRAN-COMMENT         PIC X(29) VALUE                  
               'CUSTOMER REGISTERED FOR EBILL'.                         
           05  WS-EBILL-REGISTER-IND   PIC X(01) VALUE SPACES.          
                                                                        
       01  WS-INDICATOR-VARS.                                           
                                                                        
           05  IV-EMPLOYED-DATE        PIC S9(4) COMP VALUE 0.          
           05  IV-DRVR-LIC-ISS-DT      PIC S9(4) COMP VALUE 0.          
           05  IV-DATE-OF-BIRTH        PIC S9(4) COMP VALUE 0.          
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09) COMP VALUE 0.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE           PIC S9(09) COMP VALUE 0.         
                                                                        
           EXEC SQL                                                     
              DECLARE CUST-STAT CURSOR FOR                              
               SELECT CUSTOMER_TYPE,                                    
                      EBILL_REGISTER_IND                                
                 FROM CSS_CUST_STATS                                    
                WHERE CUSTOMER_NO = :CE-CUSTOMER-NO                     
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     00000010
               INCLUDE CWSX0010                                         00000020
           END-EXEC.                                                    00000030
                                                                        
           EXEC SQL                                                     00000050
               INCLUDE CWSSP001                                         00000060
           END-EXEC.                                                    00000070
                                                                        
       LINKAGE SECTION.                                                 
       01  LINK-CUSTOMER-NO         PIC X(10)                .          
       01  LINK-CUSTOMER-NO-RED     PIC 9(10)                .          
COB305 01 LINK-CUSTOMER-NO-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.         
       01  LINK-REG-IND             PIC X(01)                .          
                                                                        
       PROCEDURE DIVISION USING                                         
                LINK-CUSTOMER-NO                                        
               ,LINK-REG-IND                                            
               .                                                        
           EXEC SQL                                                     
               WHENEVER SQLWARNING                                      
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER SQLERROR                                        
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
               WHENEVER NOT FOUND                                       
                   CONTINUE                                             
           END-EXEC.                                                    
                                                                        
      ******************************************************************04870000
      * 0000-MAINLINE                                                  *04880000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *04890000
      ******************************************************************04900000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05020000
      * 0100-INITIALIZE                                                *05030000
      *                                                                *05040000
      *     1. RESET DB2 ERROR HANDLERS                                *05050000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *05060000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *05070000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*05080000
      *                                                                *05090000
      ******************************************************************05100000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL                                                     
             DECLARE C1 CURSOR  FOR                          
             SELECT                                                     
                :S-RETURN-CODE              AS    RETURN_CODE           
                FROM CIS.SYSDUMMY1                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*         :S-RETURN-CODE              AS    RETURN_CODE                   
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
           MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
           MOVE LINK-REG-IND              TO PARM-REG-IND             . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05380000
      * 1000-PROCESS-INPUT                                             *05390000
      *                                                                *05400000
      *     1. RECEIVE PARMS.                                          *05410000
      *                                                                *05420000
      ******************************************************************05430000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1150-ASSIGN-WS-VARS        THRU 1150-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05780000
      * 1150 ASSIGN-WS-VARS                                            *05790000
      *     -- THIS MODULE ASSIGNS DCLGEN VARIABLES.                   *05800000
      ******************************************************************05850000
                                                                        
       1150-ASSIGN-WS-VARS.                                             
                                                                        
JS         MOVE PARM-CUSTOMER-NO-RED     TO PARM-CUSTOMER-NO-NUM        
AS         MOVE PARM-CUSTOMER-NO-NUM     TO CU-CUSTOMER-NO              
                                            CE-CUSTOMER-NO.             
                                                                        
       1150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05960000
      * 2000-PROCESS-OUTPUT.                                           *05970000
      *                                                                *05980000
      *     1. DESCRIBE RESULT SET                                     *05990000
      *     2. GET THE CIS CUSTOMER NUMBER.                            *06000000
      *     3. UPDATE CSS_CUST_STATS.                                  *06010000
      *     4. INSERT INTO CSS_CUST_STATS.                             *06020000
      *     5. SEND RESULT SET                                         *06060000
      *                                                                *06070000
      ******************************************************************06080000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 7000-GET-CUST-DETAILS         THRU 7000-EXIT.        
AS                                                                      
AS         IF  PARM-REG-IND EQUAL 'A' OR 'D'                            
AS             CONTINUE                                                 
AS         ELSE                                                         
AS             MOVE 200                          TO RS-RETURN-CODE      
AS                                                 WS-ACTIVE-RETURN-CODE
AS             PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT         
AS             PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT         
AS         END-IF.                                                      
AS                                                                      
           PERFORM 7100-OPEN-CUST-STAT           THRU 7100-EXIT.        
                                                                        
           MOVE 'N'                              TO WS-UPDATE-FL.       
           PERFORM 7125-FETCH-CUST-STAT          THRU 7125-EXIT.        
           IF  WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               MOVE 'Y'                          TO WS-INSERT-FL        
           ELSE                                                         
               MOVE 'N'                          TO WS-INSERT-FL        
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
               PERFORM 2200-UPDATE-CUST-STATS    THRU 2200-EXIT         
           END-PERFORM.                                                 
                                                                        
           PERFORM 7150-CLOSE-CUST-STAT          THRU 7150-EXIT.        
                                                                        
           IF  INSERT-TYPE                                              
               PERFORM 2300-INSERT-CUST-STATS    THRU 2300-EXIT         
           END-IF.                                                      
                                                                        
           IF  INSERT-TYPE OR UPDATE-TYPE                               
               PERFORM 2400-PROCESS-TRANS-HIST   THRU 2400-EXIT         
P00730         PERFORM 8300-UPDATE-SERVICE-PROMO THRU 8300-EXIT         
           END-IF.                                                      
                                                                        
           PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *2000A-MOVE-RESULT.                                              *        
      ******************************************************************        
                                                                        
       2000A-MOVE-RESULT.                                               
                                                                        
           MOVE RS-RETURN-CODE                 TO S-RETURN-CODE.        
                                                                        
       2000A-EXIT.                                                      
           EXIT.                                                        
                                                                        
      ******************************************************************13610000
      * IF THE CUSTOMER IS ALREADY PRESENT UPDATE EBILL_REGISTER_IND   *13610000
      * WITH 'Y'.                                                               
      ******************************************************************13610000
                                                                        
       2200-UPDATE-CUST-STATS.                                          
                                                                        
A05317     MOVE CE-EBILL-REGISTER-IND TO WS-EBILL-REGISTER-IND.         
AS         IF  PARM-REG-IND = 'A'                                       
AS             IF  CE-EBILL-REGISTER-IND NOT EQUAL 'Y'                  
AS                 MOVE 'Y'                   TO CE-EBILL-REGISTER-IND  
AS                 MOVE 'Y'                   TO WS-UPDATE-FL           
AS                 PERFORM 8000-UPDATE-CUST-STATS                       
AS                                            THRU 8000-EXIT            
AS             END-IF                                                   
AS         ELSE                                                         
AS             IF  CE-EBILL-REGISTER-IND NOT EQUAL SPACES               
AS                 MOVE SPACES                TO CE-EBILL-REGISTER-IND  
AS                 MOVE 'Y'                   TO WS-UPDATE-FL           
AS                 PERFORM 8000-UPDATE-CUST-STATS                       
AS                                            THRU 8000-EXIT            
AS             END-IF                                                   
AS         END-IF.                                                      
                                                                        
           PERFORM 7125-FETCH-CUST-STAT       THRU 7125-EXIT.           
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13610000
      * IF THE CUSTOMER IS NOT PRESENT INSERT DETAILS INTO CSS_CUST_STAT13610000
      * TABLE.                                                                  
      ******************************************************************13610000
                                                                        
       2300-INSERT-CUST-STATS.                                          
                                                                        
           MOVE CU-NAME-ID                    TO CE-NAME-ID.            
           MOVE 'C'                           TO CE-CUSTOMER-TYPE.      
           MOVE SPACES                        TO CE-SSN                 
                                                 CE-CODE-STATE-ID       
                                                 CE-DRIVERS-LICENSE-NO  
                                                 CE-EMPLOYER            
                                                 CE-EMPLOYED-DATE       
                                                 CE-OCCUPATION          
                                                 CE-OTHER-ID-TYPE       
                                                 CE-OTHER-ID            
                                                 CE-DRVR-LIC-ISS-DT     
                                                 CE-DATE-OF-BIRTH       
                                                 CE-EMPLOYEE-NBR        
                                                 CE-INTR-CO-IND.        
           MOVE -1                            TO IV-EMPLOYED-DATE       
                                                 IV-DRVR-LIC-ISS-DT     
                                                 IV-DATE-OF-BIRTH.      
AS         IF  PARM-REG-IND = 'A'                                       
AS             MOVE 'Y'                       TO CE-EBILL-REGISTER-IND  
AS         ELSE                                                         
AS             MOVE SPACES                    TO CE-EBILL-REGISTER-IND  
AS         END-IF.                                                      
                                                                        
           PERFORM 8200-INSERT-CUST-STATS     THRU 8200-EXIT.           
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************13610000
      * POPULATE THE HOST VARIABLES OF CSS_MNT_TRANS_HIST AND CSS_MT_TRN13610000
      * HST_DET TABLES.                                                         
      ******************************************************************13610000
                                                                        
       2400-PROCESS-TRANS-HIST.                                         
                                                                        
           PERFORM 7200-SELECT-DATE-TIMESTAMP THRU 7200-EXIT.           
           MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE SPACES                   TO MH-RESP-AREA-ID.            
           MOVE 0                        TO MH-ACCOUNT-NO.              
           MOVE PARM-CUSTOMER-NO-NUM     TO MH-CUSTOMER-NO.             
           MOVE 0                        TO MH-PREMISE-NO.              
           MOVE WS-USERID                TO MH-USER-ID.                 
           MOVE WS-PROGRAM-ID            TO MH-APPL-PROGRAM-ID.         
           MOVE +29                      TO MH-TRAN-COMMENT-LEN.        
           MOVE WS-TRAN-COMMENT          TO MH-TRAN-COMMENT-TEXT.       
           MOVE SPACES                   TO MH-ENTITY-KEY-DESC.         
           MOVE 1                        TO MI-TRAN-APPL-NO.            
           MOVE 'EBILL REGISTER'         TO MI-COLUMN-DESC.             
AS         MOVE SPACES                   TO MI-TABLE-ID.                
A05317     IF  PARM-REG-IND = 'A'                                       
               MOVE +3                   TO MI-PRV-COLUMN-VALUE-LEN     
               MOVE 'NEW'                TO MI-PRV-COLUMN-VALUE-TEXT    
A05317     ELSE                                                         
A05317         MOVE +1                   TO MI-PRV-COLUMN-VALUE-LEN     
A05317         MOVE WS-EBILL-REGISTER-IND TO                            
A05317              MI-PRV-COLUMN-VALUE-TEXT                            
A05317     END-IF.                                                      
           MOVE +1                       TO MI-CHG-COLUMN-VALUE-LEN     
AS         IF  PARM-REG-IND = 'A'                                       
               MOVE 'Y'                  TO MI-CHG-COLUMN-VALUE-TEXT    
AS         ELSE                                                         
AS             MOVE 'N'                  TO MI-CHG-COLUMN-VALUE-TEXT    
AS         END-IF.                                                      
                                                                        
           PERFORM 6530-LOAD-MNT-TRANS-HIST   THRU 6530-EXIT.           
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************15470000
      *  COPYBOOK THAT INSERTS VALUES INTO MAINTENANCE TRANS HIST TABLES15480000
      ******************************************************************15490000
                                                                        
           EXEC SQL                                                     15500000
              INCLUDE CPD00067                                          15510000
           END-EXEC.                                                    15520000
                                                                        
      ******************************************************************22760000
      * 7000-GET-NAME-ID                                               *22770000
      * OBTAIN THE NAME ID FROM CSS_CUSTOMER FOR THE GIVEN CUSTOMER NO *22780000
      ******************************************************************22790000
                                                                        
       7000-GET-CUST-DETAILS.                                           
                                                                        
           EXEC SQL                                                     
              SELECT NAME_ID                                            
                INTO :CU-NAME-ID                                        
                FROM CSS_CUSTOMER                                       
               WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                      
P00730                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     22820000
MFA-TR*       SELECT NAME_ID                                            22830000
MFA-TR*         INTO :CU-NAME-ID                                                
MFA-TR*         FROM CSS_CUSTOMER                                               
MFA-TR*        WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                              
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                    22840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO RS-RETURN-CODE        
                                                  WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CUSTOMER'             TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22760000
      * 7100-OPEN-CUST-STAT                                            *22770000
      *   OPEN CUST-STAT CURSOR                                        *22780000
      ******************************************************************22790000
                                                                        
       7100-OPEN-CUST-STAT.                                             
                                                                        
           EXEC SQL                                                     
              OPEN CUST-STAT                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO RS-RETURN-CODE        
                                                  WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CUST_STATS'           TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22760000
      * 7125-FETCH-CUST-STAT.                                          *22770000
      *     FETCH CUSTOMER_TYPE AND EBILL_REGISTER_IND                 *22780000
      ******************************************************************22790000
                                                                        
       7125-FETCH-CUST-STAT.                                            
                                                                        
           EXEC SQL                                                     
              FETCH CUST-STAT                                           
               INTO :CE-CUSTOMER-TYPE                                   
                   ,:CE-EBILL-REGISTER-IND                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO RS-RETURN-CODE        
                                                  WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7125'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CUST_STATS'           TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7125-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22760000
      * 7150-CLOSE-CUST-STAT                                           *22770000
      *   CLOSE CUST-STAT CURSOR                                       *22780000
      ******************************************************************22790000
                                                                        
       7150-CLOSE-CUST-STAT.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE CUST-STAT                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO RS-RETURN-CODE        
                                                  WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7150'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CUST_STATS'           TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22760000
      * SELECT CURRENT DATE AND CURRENT TIMESTAMP FROM CSS_MODEL_SQL   *22770000
      ******************************************************************22760000
                                                                        
       7200-SELECT-DATE-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :MH-TRANS-HIST-SEQ-NO,                             
                     :MH-DATE-TRANS                                     
                FROM CSS_MODEL_SQL                                      
P00730                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     08180000
MFA-TR*       SELECT CURRENT TIMESTAMP,                                 08190000
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO,                             08200000
MFA-TR*              :MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                      08210000
MFA-TR*       QUERYNO 7200                                                      
MFA-TR*    END-EXEC.                                                    08220000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO RS-RETURN-CODE        
                                                  WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_MODEL_SQL'            TO TABLE-1               
               MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-1       
               MOVE PARM-CUSTOMER-NO-NUM       TO HOSTVAR-ELEMENT-1     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22760000
      * UPDATE CSS_CUST_STATS WITH EBILL_REGISTER_IND 'Y'              *22780000
      ******************************************************************22790000
                                                                        
       8000-UPDATE-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CUST_STATS                                     
                 SET EBILL_REGISTER_IND = :CE-EBILL-REGISTER-IND        
               WHERE CUSTOMER_NO        = :CE-CUSTOMER-NO               
                 AND CUSTOMER_TYPE      = :CE-CUSTOMER-TYPE             
P00730                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     22820000
MFA-TR*       UPDATE CSS_CUST_STATS                                     22830000
MFA-TR*          SET EBILL_REGISTER_IND = :CE-EBILL-REGISTER-IND                
MFA-TR*        WHERE CUSTOMER_NO        = :CE-CUSTOMER-NO                       
MFA-TR*          AND CUSTOMER_TYPE      = :CE-CUSTOMER-TYPE                     
MFA-TR*       QUERYNO 8000                                                      
MFA-TR*    END-EXEC.                                                    22840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO RS-RETURN-CODE         
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_CUST_STATS'          TO TABLE-1                
               MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1        
               MOVE CE-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************22760000
      * INSERT INTO CSS_CUST_STATS TABLE                               *22780000
      ******************************************************************22790000
                                                                        
       8200-INSERT-CUST-STATS.                                          
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CUST_STATS                                
                   ( CUSTOMER_NO                                        
                    ,CUSTOMER_TYPE                                      
                    ,SSN                                                
                    ,NAME_ID                                            
                    ,CODE_STATE_ID                                      
                    ,DRIVERS_LICENSE_NO                                 
                    ,EMPLOYER                                           
                    ,EMPLOYED_DATE                                      
                    ,OCCUPATION                                         
                    ,OTHER_ID_TYPE                                      
                    ,OTHER_ID                                           
                    ,DRVR_LIC_ISS_DT                                    
                    ,DATE_OF_BIRTH                                      
                    ,EMPLOYEE_NBR                                       
                    ,INTR_CO_IND                                        
                    ,EBILL_REGISTER_IND )                               
           VALUES (  :CE-CUSTOMER-NO                                    
                    ,:CE-CUSTOMER-TYPE                                  
                    ,:CE-SSN                                            
                    ,:CE-NAME-ID                                        
                    ,:CE-CODE-STATE-ID                                  
                    ,:CE-DRIVERS-LICENSE-NO                             
                    ,:CE-EMPLOYER                                       
                    ,IIF(TRY_CONVERT(DATE, :CE-EMPLOYED-DATE 
                                           :IV-EMPLOYED-DATE
              ) IS NULL OR (PATINDEX('%.%', :CE-EMPLOYED-DATE 
                                                      :IV-EMPLOYED-DATE
              ) <> 0) OR (LEN(:CE-EMPLOYED-DATE :IV-EMPLOYED-DATE
              ) <> 10), CIS.CHAR2DATE(:CE-EMPLOYED-DATE 
                                                      :IV-EMPLOYED-DATE
              ), CONVERT(DATE, :CE-EMPLOYED-DATE :IV-EMPLOYED-DATE) )          
                    ,:CE-OCCUPATION                                     
                    ,:CE-OTHER-ID-TYPE                                  
                    ,:CE-OTHER-ID                                       
                    ,IIF(TRY_CONVERT(DATE, :CE-DRVR-LIC-ISS-DT 
                                           :IV-DRVR-LIC-ISS-DT
              ) IS NULL OR (PATINDEX('%.%', :CE-DRVR-LIC-ISS-DT 
                                                    :IV-DRVR-LIC-ISS-DT
              ) <> 0) OR (LEN(:CE-DRVR-LIC-ISS-DT :IV-DRVR-LIC-ISS-DT
              ) <> 10), CIS.CHAR2DATE(:CE-DRVR-LIC-ISS-DT 
                                                    :IV-DRVR-LIC-ISS-DT
              ), CONVERT(DATE, :CE-DRVR-LIC-ISS-DT :IV-DRVR-LIC-ISS-DT
              ) )            
                    ,IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH 
                                           :IV-DATE-OF-BIRTH
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                      :IV-DATE-OF-BIRTH
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :IV-DATE-OF-BIRTH
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH 
                                                      :IV-DATE-OF-BIRTH
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :IV-DATE-OF-BIRTH) )          
                    ,:CE-EMPLOYEE-NBR                                   
                    ,:CE-INTR-CO-IND                                    
                    ,:CE-EBILL-REGISTER-IND )                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     17440000
MFA-TR*       INSERT INTO CSS_CUST_STATS                                17450000
MFA-TR*            ( CUSTOMER_NO                                        17460000
MFA-TR*             ,CUSTOMER_TYPE                                      17470000
MFA-TR*             ,SSN                                                17480000
MFA-TR*             ,NAME_ID                                            17490000
MFA-TR*             ,CODE_STATE_ID                                      17500000
MFA-TR*             ,DRIVERS_LICENSE_NO                                 17510000
MFA-TR*             ,EMPLOYER                                           17520000
MFA-TR*             ,EMPLOYED_DATE                                      17530000
MFA-TR*             ,OCCUPATION                                         17540000
MFA-TR*             ,OTHER_ID_TYPE                                      17550000
MFA-TR*             ,OTHER_ID                                           17560000
MFA-TR*             ,DRVR_LIC_ISS_DT                                    17570000
MFA-TR*             ,DATE_OF_BIRTH                                      17580000
MFA-TR*             ,EMPLOYEE_NBR                                       17590000
MFA-TR*             ,INTR_CO_IND                                        17600000
MFA-TR*             ,EBILL_REGISTER_IND )                               17610000
MFA-TR*    VALUES (  :CE-CUSTOMER-NO                                    17770000
MFA-TR*             ,:CE-CUSTOMER-TYPE                                  17780000
MFA-TR*             ,:CE-SSN                                            17790000
MFA-TR*             ,:CE-NAME-ID                                        17800000
MFA-TR*             ,:CE-CODE-STATE-ID                                  17810000
MFA-TR*             ,:CE-DRIVERS-LICENSE-NO                             17820000
MFA-TR*             ,:CE-EMPLOYER                                       17830000
MFA-TR*             ,:CE-EMPLOYED-DATE :IV-EMPLOYED-DATE                17840000
MFA-TR*             ,:CE-OCCUPATION                                     17850000
MFA-TR*             ,:CE-OTHER-ID-TYPE                                  17860000
MFA-TR*             ,:CE-OTHER-ID                                       17870000
MFA-TR*             ,:CE-DRVR-LIC-ISS-DT :IV-DRVR-LIC-ISS-DT            17880000
MFA-TR*             ,:CE-DATE-OF-BIRTH :IV-DATE-OF-BIRTH                17890000
MFA-TR*             ,:CE-EMPLOYEE-NBR                                   17900000
MFA-TR*             ,:CE-INTR-CO-IND                                    17910000
MFA-TR*             ,:CE-EBILL-REGISTER-IND )                           17920000
MFA-TR*    END-EXEC.                                                    18080000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO RS-RETURN-CODE         
                                                 WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8200'                    TO ACTIVE-PARAGRAPH       
               MOVE 'INSERT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_CUST_STATS'          TO TABLE-1                
               MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1        
               MOVE 'CUSTOMER_TYPE'           TO TABLE-ELEMENT-2        
               MOVE 'NAME_ID'                 TO TABLE-ELEMENT-3        
               MOVE CE-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1      
               MOVE CE-CUSTOMER-TYPE          TO HOSTVAR-ELEMENT-2      
               MOVE CE-NAME-ID                TO HOSTVAR-ELEMENT-3      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00730******************************************************************22760000
P00730* UPDATE CSS_SERVICE_PROMO IF PROMO_REGISTER_FL = 'R'            *22780000
P00730******************************************************************22790000
P00730 8300-UPDATE-SERVICE-PROMO.                                       
P00730                                                                  
P00730     EXEC SQL                                                     
P00730        UPDATE CSS_SERVICE_PROMO                                  
P00730           SET PROMO_REGISTER_FL  = 'Y'                           
P00730         WHERE CUSTOMER_NO        = :CE-CUSTOMER-NO               
P00730           AND PROMO_REGISTER_FL  = 'R'                           
P00730                                                      
P00730     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     22820000
MFA-TR*       UPDATE CSS_SERVICE_PROMO                                  22830000
MFA-TR*          SET PROMO_REGISTER_FL  = 'Y'                           22810000
MFA-TR*        WHERE CUSTOMER_NO        = :CE-CUSTOMER-NO               22810000
MFA-TR*          AND PROMO_REGISTER_FL  = 'R'                           22810000
MFA-TR*       QUERYNO 8300                                              22810000
MFA-TR*    END-EXEC.                                                    22840000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00730                                                                  
P00730     MOVE SQLCODE                       TO RS-RETURN-CODE         
P00730                                           WS-ACTIVE-RETURN-CODE. 
P00730                                                                  
P00730     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
P00730         MOVE 0                         TO RS-RETURN-CODE         
P00730                                           WS-ACTIVE-RETURN-CODE  
P00730     ELSE                                                         
P00730         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
P00730         MOVE '8300'                    TO ACTIVE-PARAGRAPH       
P00730         MOVE 'UPDATE'                  TO ABEND-FUNCTION         
P00730         MOVE SPACES                    TO ABEND-SQL-PREDICATES   
P00730                                           ABEND-TABLES           
P00730         MOVE 'CSS_SERVICE_PROMO'       TO TABLE-1                
P00730         MOVE 'CUSTOMER_NO'             TO TABLE-ELEMENT-1        
P00730         MOVE CE-CUSTOMER-NO            TO HOSTVAR-ELEMENT-1      
P00730         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00730         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00730     END-IF.                                                      
P00730                                                                  
P00730 8300-EXIT.                                                       
P00730     EXIT.                                                        
                                                                        
      ******************************************************************23780100
      * INCLUDE CPD0023C FOR ERROR HANDLING                            *23780200
      ******************************************************************23780300
                                                                        
           EXEC SQL                                                     23781000
              INCLUDE CPD0023C                                          23782000
           END-EXEC.                                                    23783000
                                                                        
      ******************************************************************23790000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *23800000
      ******************************************************************23810000
                                                                        
           EXEC SQL                                                     23820000
              INCLUDE CPDSP300                                          23830000
           END-EXEC.                                                    23840000
                                                                        
       8100-SEND-RESULT.                                                
             ADD 1 TO CTR-ROWS.                                         
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
           EXEC SQL                                                     00000100
               INCLUDE CPD00321                                         00000200
           END-EXEC.                                                    00000300
