       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02446.                                         
COB303 DATE-WRITTEN.     JULY 19, 1994.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S446 CONVERTED TO DB2 SP CSR02446 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S446                                           *        
      *  PROGRAM:       S446                                           *        
      *  CALLING SP:    PA_S446                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES ACCOUNT PROFILE INFORMATION FOR THE    *        
      *  SEB WEB PAGE.                                                 *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  10/09/00    FMB      CREATED.                                 *        
C37649*  10/20/08  COVANSYS   NAME AND ADDRESS FORMATTED               *        
C37649*            CHENNAI    CHANGES                                  *        
A05460*  09/29/16  MR7E794    REMOVED THE MAIN USER TABLE AS PART      *        
      *            ACT282     OF TABLE CHANGE AND GETTING THE SAME     *        
      *                       VALUE FROM CODE VALUE TABLE.             *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02446'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S446 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBADRFMT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNAME                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBZIPCD                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPHN                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBSOCODE                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
CVT999*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'S446    '.      
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-NULL-IND             PIC S9(04) COMP.                 
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-PREMISE-NO           PIC 9(10) VALUE ZERO.            
           05  WS-PREMISE-NO-NUM       PIC S9(10) COMP-3 VALUE ZERO.    
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
C37649*    05  RS-HOUSE-NO             PIC X(05) VALUE SPACE.                   
C37649     05  RS-HOUSE-NO             PIC X(15) VALUE SPACE.           
           05  RS-ADDR-PREFIX-2        PIC X(02) VALUE SPACE.           
C37649*    05  RS-STREET-NAME          PIC X(16) VALUE SPACE.                   
C37649     05  RS-STREET-NAME          PIC X(30) VALUE SPACE.           
           05  RS-STREET-SUFFIX        PIC X(04) VALUE SPACE.           
           05  RS-ADDR-SUFFIX          PIC X(02) VALUE SPACE.           
           05  RS-STREET-LOCATION-1    PIC X(04) VALUE SPACE.           
C37649*    05  RS-STREET-LOCATION-2    PIC X(06) VALUE SPACE.                   
C37649     05  RS-STREET-LOCATION-2    PIC X(11) VALUE SPACE.           
           05  RS-CITY                 PIC X(26) VALUE SPACE.           
           05  RS-STATE                PIC X(02) VALUE SPACE.           
           05  RS-ZIP-CODE             PIC X(09) VALUE SPACE.           
           05  RS-ACCT-TYPE-DESC       PIC X(15) VALUE SPACE.           
           05  RS-FIRST-NAME           PIC X(15) VALUE SPACE.           
           05  RS-MIDDLE-NAME          PIC X(15) VALUE SPACE.           
C37649*    05  RS-LAST-NAME            PIC X(20) VALUE SPACE.                   
C37649     05  RS-LAST-NAME            PIC X(40) VALUE SPACE.           
           05  RS-TITLE-SUFFIX-1       PIC X(03) VALUE SPACE.           
           05  RS-SSN                  PIC X(09) VALUE SPACE.           
C37649*    05  RS-BUSINESS-NAME        PIC X(50) VALUE SPACE.                   
C37649     05  RS-BUSINESS-NAME        PIC X(70) VALUE SPACE.           
           05  RS-CUST-HOME-PHONE      PIC X(10) VALUE SPACE.           
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE        PIC X(11) VALUE 'RETURN_CODE'.            
CVT999*    05  CNS-HOUSE-NO           PIC X(08) VALUE 'HOUSE_NO'.               
CVT999*    05  CNS-ADDR-PREFIX-2      PIC X(13) VALUE 'ADDR_PREFIX_2'.          
CVT999*    05  CNS-STREET-NAME        PIC X(11) VALUE 'STREET_NAME'.            
CVT999*    05  CNS-STREET-SUFFIX      PIC X(13) VALUE 'STREET_SUFFIX'.          
CVT999*    05  CNS-ADDR-SUFFIX        PIC X(11) VALUE 'ADDR_SUFFIX'.            
CVT999*    05  CNS-STREET-LOCATION-1  PIC X(12) VALUE 'STREET_LOC_1'.           
CVT999*    05  CNS-STREET-LOCATION-2  PIC X(12) VALUE 'STREET_LOC_2'.           
CVT999*    05  CNS-CITY               PIC X(04) VALUE 'CITY'.                   
CVT999*    05  CNS-STATE              PIC X(05) VALUE 'STATE'.                  
CVT999*    05  CNS-ZIP-CODE           PIC X(08) VALUE 'ZIP_CODE'.               
CVT999*    05  CNS-ACCT-TYPE-DESC     PIC X(14) VALUE 'ACCT_TYPE_DESC'.         
CVT999*    05  CNS-FIRST-NAME         PIC X(10) VALUE 'FIRST_NAME'.             
CVT999*    05  CNS-MIDDLE-NAME        PIC X(11) VALUE 'MIDDLE_NAME'.            
CVT999*    05  CNS-LAST-NAME          PIC X(09) VALUE 'LAST_NAME'.              
CVT999*    05  CNS-TITLE-SUFFIX-1     PIC X(14) VALUE 'TITLE_SUFFIX_1'.         
CVT999*    05  CNS-SSN                PIC X(03) VALUE 'SSN'.                    
CVT999*    05  CNS-BUSINESS-NAME      PIC X(13) VALUE 'BUSINESS_NAME'.          
CVT999*    05  CNS-CUST-HOME-PHONE    PIC X(15) VALUE 'CUST_HOME_PHONE'.        
CVT999*                                                                         
CVT999*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
                                                                        
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
                                                                        
CVT999*LINKAGE SECTION.                                                         
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-ACCOUNT-NO-RED      PIC 9(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                          
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-HOUSE-NO                 AS    HOUSE_NO               
CVT000       ,:RS-ADDR-PREFIX-2            AS    ADDR_PREFIX_2          
CVT000       ,:RS-STREET-NAME              AS    STREET_NAME            
CVT000       ,:RS-STREET-SUFFIX            AS    STREET_SUFFIX          
CVT000       ,:RS-STREET-LOCATION-1        AS    STREET_LOCATION_1      
CVT000       ,:RS-STREET-LOCATION-2        AS    STREET_LOCATION_2      
CVT000       ,:RS-CITY                     AS    CITY                   
CVT000       ,:RS-STATE                    AS    STATE                  
CVT000       ,:RS-ZIP-CODE                 AS    ZIP_CODE               
CVT000       ,:RS-ACCT-TYPE-DESC           AS    ACCT_TYPE_DESC         
CVT000       ,:RS-FIRST-NAME               AS    FIRST_NAME             
CVT000       ,:RS-MIDDLE-NAME              AS    MIDDLE_NAME            
CVT000       ,:RS-LAST-NAME                AS    LAST_NAME              
CVT000       ,:RS-TITLE-SUFFIX-1           AS    TITLE_SUFFIX_1         
CVT000       ,:RS-SSN                      AS    SSN                    
CVT000       ,:RS-BUSINESS-NAME            AS    BUSINESS_NAME          
CVT000       ,:RS-CUST-HOME-PHONE          AS    CUST_HOME_PHONE        
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-HOUSE-NO                 AS    HOUSE_NO                       
MFA-TR*      ,:RS-ADDR-PREFIX-2            AS    ADDR_PREFIX_2                  
MFA-TR*      ,:RS-STREET-NAME              AS    STREET_NAME                    
MFA-TR*      ,:RS-STREET-SUFFIX            AS    STREET_SUFFIX                  
MFA-TR*      ,:RS-STREET-LOCATION-1        AS    STREET_LOCATION_1              
MFA-TR*      ,:RS-STREET-LOCATION-2        AS    STREET_LOCATION_2              
MFA-TR*      ,:RS-CITY                     AS    CITY                           
MFA-TR*      ,:RS-STATE                    AS    STATE                          
MFA-TR*      ,:RS-ZIP-CODE                 AS    ZIP_CODE                       
MFA-TR*      ,:RS-ACCT-TYPE-DESC           AS    ACCT_TYPE_DESC                 
MFA-TR*      ,:RS-FIRST-NAME               AS    FIRST_NAME                     
MFA-TR*      ,:RS-MIDDLE-NAME              AS    MIDDLE_NAME                    
MFA-TR*      ,:RS-LAST-NAME                AS    LAST_NAME                      
MFA-TR*      ,:RS-TITLE-SUFFIX-1           AS    TITLE_SUFFIX_1                 
MFA-TR*      ,:RS-SSN                      AS    SSN                            
MFA-TR*      ,:RS-BUSINESS-NAME            AS    BUSINESS_NAME                  
MFA-TR*      ,:RS-CUST-HOME-PHONE          AS    CUST_HOME_PHONE                
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
                                                                        
           MOVE PARM-ACCOUNT-NO-RED   TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO         TO WS-ACCOUNT-NO-NUM.             
           MOVE WS-ACCOUNT-NO         TO AT-ACCOUNT-NO.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *                                                                *        
      *     GET ACCOUNT NUMBER FROM THE CLIENT                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                         TO PARM-ID1.                          
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO TO MAX-LENGTH-PARM.                   
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           MOVE '2000'          TO ACTIVE-PARAGRAPH                     
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     DESCRIBE EACH RESULT FIELD TO THE CLIENT                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'          TO ACTIVE-PARAGRAPH                     
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-HOUSE-NO        TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-HOUSE-NO       TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-HOUSE-NO,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-HOUSE-NO,                                  
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-ADDR-PREFIX-2      TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-ADDR-PREFIX-2 TO WRKLEN2.                         
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ADDR-PREFIX-2,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ADDR-PREFIX-2,                             
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                           TO CTR-COLUMN.                       
CVT999*    MOVE TDSCHAR                    TO DB-HOST-TYPE.                     
CVT999*    MOVE TDSCHAR                    TO DB-CLIENT-TYPE.                   
CVT999*    MOVE LENGTH OF RS-STREET-NAME   TO WRKLEN1.                          
CVT999*    MOVE LENGTH OF CNS-STREET-NAME  TO WRKLEN2.                          
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-STREET-NAME,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-STREET-NAME,                               
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-STREET-SUFFIX      TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-STREET-SUFFIX     TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-STREET-SUFFIX,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-STREET-SUFFIX,                             
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-STREET-LOCATION-1 TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-STREET-LOCATION-1 TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-STREET-LOCATION-1,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-STREET-LOCATION-1,                         
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD  1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-STREET-LOCATION-2 TO WRKLEN1.                      
CVT999*    MOVE LENGTH OF CNS-STREET-LOCATION-2 TO WRKLEN2.                     
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-STREET-LOCATION-2,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-STREET-LOCATION-2,                         
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-CITY            TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-CITY           TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CITY,                                       
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CITY,                                      
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-STATE           TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-STATE          TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-STATE,                                      
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-STATE,                                     
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-ZIP-CODE        TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ZIP-CODE       TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ZIP-CODE,                                   
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ZIP-CODE,                                  
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-ACCT-TYPE-DESC  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-ACCT-TYPE-DESC TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCT-TYPE-DESC,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-ACCT-TYPE-DESC,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-FIRST-NAME      TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-FIRST-NAME     TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-FIRST-NAME,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-FIRST-NAME,                                
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-MIDDLE-NAME     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-MIDDLE-NAME    TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-MIDDLE-NAME,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-MIDDLE-NAME,                               
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-LAST-NAME       TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-LAST-NAME      TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LAST-NAME,                                  
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-LAST-NAME,                                 
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-TITLE-SUFFIX-1  TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-TITLE-SUFFIX-1 TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TITLE-SUFFIX-1,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TITLE-SUFFIX-1,                            
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-SSN             TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-SSN            TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SSN,                                        
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SSN,                                       
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-BUSINESS-NAME   TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-BUSINESS-NAME  TO WRKLEN2.                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-BUSINESS-NAME,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-BUSINESS-NAME,                             
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                             TO CTR-COLUMN.                     
CVT999*    MOVE TDSCHAR                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSCHAR                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-CUST-HOME-PHONE TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-CUST-HOME-PHONE TO WRKLEN2.                       
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-HOME-PHONE,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-HOME-PHONE,                           
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
CVT999     .                                                            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
      *  GET ACCOUNT DATA                                                       
                                                                        
           PERFORM 7000-SELECT-ACCOUNT  THRU 7000-EXIT.                 
           PERFORM 7100-SELECT-NAME     THRU 7100-EXIT.                 
           PERFORM 7200-SELECT-ADDRESS  THRU 7200-EXIT.                 
           PERFORM 7300-SELECT-SSN      THRU 7300-EXIT.                 
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE 'H1' TO CB-PHONE-TYPE                               
           ELSE                                                         
               MOVE 'B1' TO CB-PHONE-TYPE
           END-IF.                              
           PERFORM 7400-SELECT-PHONE    THRU 7400-EXIT.                 
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      ******************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT AT.ACCOUNT_TYPE_CODE,                              
ACT282               SW.CODE_LONG_DESC                                  
              INTO  :AT-ACCOUNT-TYPE-CODE,                              
ACT282              :SW-CODE-LONG-DESC                                  
              FROM   CSS_ACCOUNT AT,                                    
ACT282               CSS_SO_CODE_DESC SW                                
              WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
ACT282          AND AT.ACCOUNT_TYPE_CODE = SW.CODE_VALUE                
ACT282          AND SW.TABLE_NA   = 'CSS_ACCOUNT'                       
ACT282          AND SW.COLUMN_NA  = 'ACCOUNT_TYPE_CODE'                 
ACT282          AND SW.PROGRAM_ID = 'ALL'                               
ACT282          AND SW.COMPANY_NO = '01'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
ACT282        MOVE SW-CODE-LONG-DESC    TO RS-ACCT-TYPE-DESC            
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
ACT282        MOVE 'CSS_SO_CODE_DESC'  TO TABLE-2                       
ACT282        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
ACT282        MOVE 'TABLE_NA'          TO TABLE-ELEMENT-2               
ACT282        MOVE 'COLUMN_NA'         TO TABLE-ELEMENT-3               
ACT282        MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-4               
ACT282        MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
ACT282        MOVE 'CSS_ACCOUNT'       TO HOSTVAR-ELEMENT-2             
ACT282        MOVE 'ACCOUNT_TYPE_CODE' TO HOSTVAR-ELEMENT-3             
ACT282        MOVE '01'                TO HOSTVAR-ELEMENT-4             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-NAME                                               *        
      ******************************************************************        
                                                                        
       7100-SELECT-NAME.                                                
                                                                        
           EXEC SQL                                                     
              SELECT DQ.FIRST_NAME,                                     
                     DQ.MIDDLE_NAME,                                    
                     DQ.LAST_NAME,                                      
                     DQ.TITLE_SUFFIX_1,                                 
                     DQ.FULL_NAME,                                      
                     DQ.NAME_FORMAT,                                    
                     HT.CUSTOMER_NO,                                    
                     HT.ADDRESS_ID                                      
                INTO :DQ-FIRST-NAME,                                    
                     :DQ-MIDDLE-NAME,                                   
                     :DQ-LAST-NAME,                                     
                     :DQ-TITLE-SUFFIX-1,                                
                     :DQ-FULL-NAME,                                     
                     :DQ-NAME-FORMAT,                                   
                     :HT-CUSTOMER-NO,                                   
                     :HT-ADDRESS-ID                                     
                FROM CSS_NAME DQ,                                       
                     CSS_NAME_ACCT_XREF HT                              
               WHERE HT.ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                 
                 AND DQ.NAME_TYPE  = 'CN'                               
                 AND HT.CUSTOMER_ROLE_CD = ' '                          
                 AND DQ.NAME_ID    = HT.NAME_ID                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
               IF DQ-NAME-FORMAT = 'I'                                  
                   MOVE DQ-FIRST-NAME     TO RS-FIRST-NAME              
                   MOVE DQ-MIDDLE-NAME    TO RS-MIDDLE-NAME             
                   MOVE DQ-LAST-NAME      TO RS-LAST-NAME               
                   MOVE DQ-TITLE-SUFFIX-1 TO RS-TITLE-SUFFIX-1          
                   MOVE SPACES            TO RS-BUSINESS-NAME           
               ELSE                                                     
                   MOVE SPACES            TO RS-FIRST-NAME              
                                             RS-MIDDLE-NAME             
                                             RS-LAST-NAME               
                                             RS-TITLE-SUFFIX-1          
                   MOVE DQ-FULL-NAME      TO RS-BUSINESS-NAME           
               END-IF                                                   
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
              MOVE 'CSS_NAME'            TO TABLE-2                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO-NUM     TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-SELECT-ADDRESS                                            *        
      ******************************************************************        
                                                                        
       7200-SELECT-ADDRESS.                                             
                                                                        
           EXEC SQL                                                     
              SELECT DY.HOUSE_NO,                                       
                     DY.ADDR_PREFIX_2,                                  
                     DY.STREET_NAME,                                    
                     DY.STREET_SUFFIX,                                  
                     DY.ADDR_SUFFIX,                                    
                     DY.STREET_LOCATION_1,                              
                     DY.STREET_LOCATION_2,                              
                     DY.ZIP_CODE,                                       
                     DY.ZIP_CODE_PLUS_FOUR,                             
                     A4.TOWN,                                           
                     A4.STATE                                           
                INTO :DY-HOUSE-NO,                                      
                     :DY-ADDR-PREFIX-2,                                 
                     :DY-STREET-NAME,                                   
                     :DY-STREET-SUFFIX,                                 
                     :DY-ADDR-SUFFIX,                                   
                     :DY-STREET-LOCATION-1,                             
                     :DY-STREET-LOCATION-2,                             
                     :DY-ZIP-CODE,                                      
                     :DY-ZIP-CODE-PLUS-FOUR,                            
                     :A4-TOWN,                                          
                     :A4-STATE                                          
                FROM CSS_ADDR_FORMATTED DY,                             
                     CSS_ZIP_CODE A4                                    
               WHERE DY.ADDRESS_ID = :HT-ADDRESS-ID                     
                 AND DY.ZIP_CODE   = A4.ZIP_CODE                        
                 AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
               MOVE DY-HOUSE-NO           TO RS-HOUSE-NO                
               MOVE DY-ADDR-PREFIX-2      TO RS-ADDR-PREFIX-2           
               MOVE DY-STREET-NAME        TO RS-STREET-NAME             
               MOVE DY-STREET-SUFFIX      TO RS-STREET-SUFFIX           
               MOVE DY-ADDR-SUFFIX        TO RS-ADDR-SUFFIX             
               MOVE DY-STREET-LOCATION-1  TO RS-STREET-LOCATION-1       
               MOVE DY-STREET-LOCATION-2  TO RS-STREET-LOCATION-2       
               MOVE DY-ZIP-CODE           TO RS-ZIP-CODE(1:5)           
               MOVE DY-ZIP-CODE-PLUS-FOUR TO RS-ZIP-CODE(6:4)           
               MOVE A4-TOWN               TO RS-CITY                    
               MOVE A4-STATE              TO RS-STATE                   
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7200'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_ADDR_FORMATTED'  TO TABLE-1                     
              MOVE 'CSS_ZIP_CODE'        TO TABLE-2                     
              MOVE 'ADDRESS_ID'          TO TABLE-ELEMENT-1             
              MOVE HT-ADDRESS-ID         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-SSN                                                *        
      ******************************************************************        
                                                                        
       7300-SELECT-SSN.                                                 
                                                                        
           EXEC SQL                                                     
              SELECT SSN                                                
                INTO :CE-SSN                                            
                FROM CSS_CUST_STATS                                     
               WHERE CUSTOMER_NO   = :HT-CUSTOMER-NO                    
                 AND CUSTOMER_TYPE = 'C'                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF CE-SSN = '000000000'                              
                       MOVE SPACES            TO RS-SSN                 
                   ELSE                                                 
                       MOVE CE-SSN            TO RS-SSN                 
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   MOVE SPACES                TO RS-SSN                 
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7300'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_STATS' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE HT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-SELECT-PHONE                                              *        
      ******************************************************************        
                                                                        
       7400-SELECT-PHONE.                                               
                                                                        
           EXEC SQL                                                     
              SELECT PHONE_NO                                           
                INTO :CB-PHONE-NO                                       
                FROM CSS_CUST_PHONE                                     
               WHERE CUSTOMER_NO   = :HT-CUSTOMER-NO                    
                 AND CUSTOMER_TYPE = 'C'                                
                 AND PHONE_TYPE    = :CB-PHONE-TYPE                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   MOVE CB-PHONE-NO           TO RS-CUST-HOME-PHONE     
               WHEN NOT-FOUND                                           
                   MOVE SPACES                TO RS-CUST-HOME-PHONE     
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
                   MOVE '7400'           TO ACTIVE-PARAGRAPH            
                   MOVE 'SELECT'         TO ABEND-FUNCTION              
                   MOVE 'CSS_CUST_PHONE' TO TABLE-1                     
                   MOVE 'CUSTOMER_NO'    TO TABLE-ELEMENT-1             
                   MOVE HT-CUSTOMER-NO   TO HOSTVAR-ELEMENT-1           
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
