       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02445.                                         
COB303 DATE-WRITTEN.     JULY 19, 1994.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S445 CONVERTED TO DB2 SP CSR02445 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S445                                           *        
      *  PROGRAM:       S445                                           *        
      *  CALLING SP:    PA_S445                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM UPDATES DIST ACCOUNT NUMBER AND RATE ON          *        
      *  CSS_MKT_XREF_ACCT FOR SEB.                                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/26/00    FMB      CREATED,                                 *        
      *                                                                *        
      *  12/19/00    MLF      ADDED CODE TO MOVE '01' TO               *        
      *                       PARM-DIST-COMPANY-NO IF NOT SUPPLIED.    *        
      *                       THIS IS FOR INSERT ONLY.                 *        
      *                                                                *        
C32043*  07/01/2005  RR       ADD CODE TO UPDATE ORIGINATION CODE='M'  *        
      *                       FOR ALL MKSW                             *        
P00795*  10/02/2015  DB18339  ADDED CHECK FOR REG/DEREG AFF COMPANY NO *        
P00795*                       WHEN INSERTING NEW MKT XREF ROW. USED FOR*        
P00795*                       CIS MOD.                                 *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02445'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S445 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
P00795     EXEC SQL                                                             
P00795        INCLUDE TBACCT                                                    
P00795     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  PROGRAM-NAME            PIC X(08) VALUE 'S445    '.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
           05  PARM-ACTION-CD          PIC X      VALUE SPACES.         
           05  PARM-ACCOUNT-NO         PIC X(13)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
           05  PARM-ORIG-DIST-ACCT-NO  PIC X(20)  VALUE SPACES.         
           05  PARM-DIST-ACCT-NO       PIC X(20)  VALUE SPACES.         
           05  PARM-COMPANY-NO         PIC XX     VALUE SPACES.         
           05  PARM-AFF-COMPANY-NO     PIC XX     VALUE SPACES.         
           05  PARM-DIST-COMPANY-NO    PIC XX     VALUE SPACES.         
           05  PARM-MKT-POOL-GRP       PIC X(3)   VALUE SPACES.         
           05  PARM-RATE-SCHEDULE      PIC X(3)   VALUE SPACES.         
           05  PARM-ORIGINATION-CD     PIC X      VALUE SPACES.         
           05  PARM-SIGN-UP-STATUS-CD  PIC X      VALUE SPACES.         
           05  PARM-LANDLORD-ACCT-NO   PIC X(13)  VALUE SPACES.         
           05  PARM-LL-ACCOUNT-NO-RED  REDEFINES PARM-LANDLORD-ACCT-NO  
                                       PIC 9(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-NULL-IND             PIC S9(04) COMP.                 
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-LL-ACCOUNT-NO        PIC 9(13) VALUE ZERO.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
                                                                        
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
                                                                        
CVT999*LINKAGE SECTION.                                                         
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACTION-CD           PIC X                    .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-ACCOUNT-NO-RED      PIC 9(13)                .          
CVT000 01  LINK-ORIG-DIST-ACCT-NO   PIC X(20)                .          
CVT000 01  LINK-DIST-ACCT-NO        PIC X(20)                .          
CVT000 01  LINK-COMPANY-NO          PIC XX                   .          
CVT000 01  LINK-AFF-COMPANY-NO      PIC XX                   .          
CVT000 01  LINK-DIST-COMPANY-NO     PIC XX                   .          
CVT000 01  LINK-MKT-POOL-GRP        PIC X(3)                 .          
CVT000 01  LINK-RATE-SCHEDULE       PIC X(3)                 .          
CVT000 01  LINK-ORIGINATION-CD      PIC X                    .          
CVT000 01  LINK-SIGN-UP-STATUS-CD   PIC X                    .          
CVT000 01  LINK-LANDLORD-ACCT-NO    PIC X(13)                .          
CVT000 01  LINK-LL-ACCOUNT-NO-RED   PIC 9(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACTION-CD                                          
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-ORIG-DIST-ACCT-NO                                  
CVT000         ,LINK-DIST-ACCT-NO                                       
CVT000         ,LINK-COMPANY-NO                                         
CVT000         ,LINK-AFF-COMPANY-NO                                     
CVT000         ,LINK-DIST-COMPANY-NO                                    
CVT000         ,LINK-MKT-POOL-GRP                                       
CVT000         ,LINK-RATE-SCHEDULE                                      
CVT000         ,LINK-ORIGINATION-CD                                     
CVT000         ,LINK-SIGN-UP-STATUS-CD                                  
CVT000         ,LINK-LANDLORD-ACCT-NO                                   
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACTION-CD            TO PARM-ACTION-CD           . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-ORIG-DIST-ACCT-NO    TO PARM-ORIG-DIST-ACCT-NO   . 
CVT000     MOVE LINK-DIST-ACCT-NO         TO PARM-DIST-ACCT-NO        . 
CVT000     MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
CVT000     MOVE LINK-AFF-COMPANY-NO       TO PARM-AFF-COMPANY-NO      . 
CVT000     MOVE LINK-DIST-COMPANY-NO      TO PARM-DIST-COMPANY-NO     . 
CVT000     MOVE LINK-MKT-POOL-GRP         TO PARM-MKT-POOL-GRP        . 
CVT000     MOVE LINK-RATE-SCHEDULE        TO PARM-RATE-SCHEDULE       . 
CVT000     MOVE LINK-ORIGINATION-CD       TO PARM-ORIGINATION-CD      . 
CVT000     MOVE LINK-SIGN-UP-STATUS-CD    TO PARM-SIGN-UP-STATUS-CD   . 
CVT000     MOVE LINK-LANDLORD-ACCT-NO     TO PARM-LANDLORD-ACCT-NO    . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO-RED      TO WS-ACCOUNT-NO.              
           MOVE PARM-LL-ACCOUNT-NO-RED   TO WS-LL-ACCOUNT-NO.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT  THRU 2100-EXIT.                
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
           MOVE '2000'          TO ACTIVE-PARAGRAPH                     
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     DESCRIBE EACH RESULT FIELD TO THE CLIENT                   *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           EVALUATE PARM-ACTION-CD                                      
               WHEN 'I'                                                 
                   MOVE WS-ACCOUNT-NO TO XM-ACCOUNT-NO                  
                   IF PARM-DIST-COMPANY-NO = SPACES                     
                       MOVE '01' TO PARM-DIST-COMPANY-NO                
                   END-IF                                               
P00795             IF PARM-AFF-COMPANY-NO = '08'                        
P00795                 PERFORM 7500-REG-CHECK THRU 7500-EXIT            
P00795             END-IF                                               
                   PERFORM 7000-INSERT-XREF THRU 7000-EXIT              
               WHEN 'U'                                                 
                   IF PARM-LANDLORD-ACCT-NO <= SPACES                   
                       MOVE WS-ACCOUNT-NO TO XM-ACCOUNT-NO              
                       IF PARM-ORIG-DIST-ACCT-NO <= SPACES              
                           MOVE PARM-RATE-SCHEDULE TO XM-RATE-SCHEDULE  
                           PERFORM 7200-UPDATE-XREF THRU 7200-EXIT      
                       ELSE                                             
                           PERFORM 7300-UPDATE-ORIG THRU 7300-EXIT      
                       END-IF                                           
                   ELSE                                                 
                       MOVE WS-LL-ACCOUNT-NO TO XM-ACCOUNT-NO           
                       PERFORM 7100-SELECT-RATE THRU 7100-EXIT          
                       MOVE WS-ACCOUNT-NO TO XM-ACCOUNT-NO              
                       PERFORM 7200-UPDATE-XREF THRU 7200-EXIT          
                   END-IF                                               
C32043         WHEN 'M'                                                 
C32043             MOVE WS-ACCOUNT-NO TO XM-ACCOUNT-NO                  
C32043             MOVE PARM-ORIGINATION-CD TO XM-ORIGINATION-CD        
C32043             PERFORM 7400-UPDATE-ORIG-CD THRU 7400-EXIT           
               WHEN OTHER                                               
                   MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
                   MOVE '2200'               TO ACTIVE-PARAGRAPH        
                   MOVE 'ERROR '             TO ABEND-FUNCTION          
                   MOVE 'INVALID ACTION CD'  TO TABLE-1                 
                   MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
                   MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1       
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
           END-EVALUATE.                                                
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-INSERT-XREF.                                                
                                                                        
           MOVE '7000' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                INSERT INTO CSS_MKT_XREF_ACCT                           
                       (ACCOUNT_NO,                                     
                        COMPANY_NO,                                     
                        AFF_COMPANY_NO,                                 
                        ORIG_DIST_ACCT_NO,                              
                        DIST_ACCT_NO,                                   
                        DIST_COMPANY_NO,                                
                        MKT_POOL_GRP,                                   
                        RATE_SCHEDULE,                                  
                        ORIGINATION_CD,                                 
                        SIGN_UP_STATUS_CD)                              
                VALUES(:XM-ACCOUNT-NO,                                  
                       :PARM-COMPANY-NO,                                
                       :PARM-AFF-COMPANY-NO,                            
                       :PARM-ORIG-DIST-ACCT-NO,                         
                       :PARM-DIST-ACCT-NO,                              
                       :PARM-DIST-COMPANY-NO,                           
                       :PARM-MKT-POOL-GRP,                              
                       :PARM-RATE-SCHEDULE,                             
                       :PARM-ORIGINATION-CD,                            
                       :PARM-SIGN-UP-STATUS-CD)                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'INSERT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-SELECT-RATE.                                                
                                                                        
           MOVE '7100' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                SELECT RATE_SCHEDULE                                    
                  INTO :XM-RATE-SCHEDULE                                
                  FROM CSS_MKT_XREF_ACCT                                
                 WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE 99                  TO RS-RETURN-CODE                
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7100'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7200-UPDATE-XREF.                                                
                                                                        
           MOVE '7200' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                UPDATE CSS_MKT_XREF_ACCT                                
                   SET RATE_SCHEDULE = :XM-RATE-SCHEDULE,               
                       DIST_ACCT_NO  = :PARM-DIST-ACCT-NO               
                 WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                      
                   AND COMPANY_NO = :PARM-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7200'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-UPDATE-ORIG.                                                
                                                                        
           MOVE '7300' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                UPDATE CSS_MKT_XREF_ACCT                                
                   SET ORIG_DIST_ACCT_NO = :PARM-ORIG-DIST-ACCT-NO      
                 WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                      
                   AND COMPANY_NO = :PARM-COMPANY-NO                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7300'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C32043 7400-UPDATE-ORIG-CD.                                             
                                                                        
           MOVE '7400' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
                UPDATE CSS_MKT_XREF_ACCT                                
                   SET ORIGINATION_CD = :XM-ORIGINATION-CD              
                 WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
                                          RS-RETURN-CODE.               
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7400'              TO ACTIVE-PARAGRAPH              
              MOVE 'UPDATE'            TO ABEND-FUNCTION                
              MOVE 'CSS_MKT_XREF_ACCT' TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00795******************************************************************        
P00795* 7500-REG-CHECK.                                                *        
P00795*                                                                *        
P00795*     LOOK UP NEW ACCT LOCAL OFFICE TO SEE IF REGULATED.         *        
P00795*                                                                *        
P00795******************************************************************        
P00795 7500-REG-CHECK.                                                  
P00795                                                                  
P00795     MOVE '7500' TO ACTIVE-PARAGRAPH.                             
P00795     EXEC SQL                                                     
P00795          SELECT LOCAL_OFFICE                                     
P00795            INTO :AT-LOCAL-OFFICE                                 
P00795          FROM CSS_ACCOUNT                                        
P00795          WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                       
P00795     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00795                                                                  
P00795     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE         
P00795                                    RS-RETURN-CODE.               
P00795                                                                  
P00795     IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL                  
P00795        IF AT-LOCAL-OFFICE(1:1) = '5'                             
P00795           MOVE '15'             TO PARM-AFF-COMPANY-NO           
P00795        END-IF                                                    
P00795     ELSE                                                         
P00795        MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
P00795        MOVE '7500'              TO ACTIVE-PARAGRAPH              
P00795        MOVE 'SELECT'            TO ABEND-FUNCTION                
P00795        MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
P00795        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
P00795        MOVE PARM-ACCOUNT-NO     TO HOSTVAR-ELEMENT-1             
P00795        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00795        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00795     END-IF.                                                      
P00795                                                                  
P00795 7500-EXIT.                                                       
P00795     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
