       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02443.                                         
COB303 DATE-WRITTEN.     JULY 19, 1994.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S443 CONVERTED TO DB2 SP CSR02443 ON 01/10/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S443                                           *        
      *  PROGRAM:       S443                                           *        
      *  CALLING SP:    PA_S443                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES ACCOUNT PROFILE INFORMATION FOR THE    *        
      *  ECUSTOMERSERVICE WEB PAGE.                                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  09/13/00    FMB      CREATED AS A CLONE OF S201.              *        
C26959*  08/02/02    FMB      DO NOT SET WS-DELINQ-LOAD-FL TO 'Y'.     *        
C26959*                       PASS COMPANY NUMBER TO CPD00068.         *        
C28788*  07/07/03    MDJ      GET IVR-EXEMPT-CD FOR CPD00068.          *        
C28137*  10/07/03    SMS      RETRIEVE FINAL-BILL-DT FOR FINAL-BILLED  *        
C28137*                       ACCOUNTS INSTEAD OF DATE-BILL-DUE        *        
T28824*  12/03/04    VD88125  FOR SEB,POPULATED THIRD-PTY-READ-DT FROM *        
T28824*                       CPD00310 ON NEXT-READ-DT(AGL READ DT)    *        
REARCH*  10/01/07    CVNS     RPC TO DB2 SP CONVERSION                 *        
REARCH*              CHENNAI                                           *        
A02951*  11/23/10    SP95538  ADDED DNP DATE AND DNP FLAG TO THE       *        
A02951*                       RESULT SET.                              *        
P00505*  06/14/11    SB93596  TO PASS A NEW FLAG TO WEB TO ALLOW THEM  *        
P00505*                       TO ENABLE/DISABLE LINK FOR THE DIRECT    *        
P00505*                       OPTIONS(THIRD PARTY VENDOR) PORTAL.      *        
A03824*  12/20/11    SP95538  POPULATE ARREARS DUE DATE TO RESULT SET. *        
P00508*  02/03/12    VP43661  TO PASS 2 NEW FLAGS & METER# TO ENABLE OR*        
P00508*                       DISABLE LINK FOR MDM'S ENERGY PRISM AND  *        
P00508*                       RATE COMPARISION MODULES.                *        
P00508*  06/01/12    VP43661  EP Changes for dead head account         *        
A04200*  07/18/12    VP43661  EP Changes for Installed Meters.         *        
P00613*  10/16/13    FMB      ADD JUDGEMENT_IND AND COLLECT_STATUS_CD. *        
P00613*  11/18/13    LG41184  ADD CASH_ONLY AND RETURN_CHECK.          *        
P0613A*  02/18/14    VV94890  ADDED BUDGET BILLING PLAN DETAILS.       *        
A04880*  09/19/14    AS7C117  ADDED CNT_STATUS_CD TO THE RESULT SET    *        
A04880*              ACT259                                            *        
P00726*  10/23/14    AA97148  CREDIT ARRANGEMENTS RELEASE 4.1 CHANGES -*        
P00726*                       IF AN ACCOUNT IN 'ARREARS' CREDIT GROUP  *        
P00726*                       HAS A FORECASTED EXCEPTIONAL FIRST NOTICE,        
P00726*                       CPD00068 RETURNS NORMAL FIRST NOTICE DUE *        
P00726*                       DATE AS BILL DUE. SO WE POPULATES WS-DATE*        
P00726*                       NOTICE-DUE-A IF DUE-DATE IS SPACE.       *        
PRJ914*  09/29/15  SS95855    Openway AMI Metering                     *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02443'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR CSR02443 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
P00505*****************************************************************         
P00505*   CSS_DSM_PGM_ACCT  PN                                        *         
P00505*****************************************************************         
                                                                        
P00505     EXEC SQL                                                             
P00505        INCLUDE TBDSMACT                                                  
P00505     END-EXEC.                                                            
                                                                        
P00508*                                                                         
P00508*****************************************************************         
P00508*   CSS_MTRD_ENVRNMT  MN                                        *         
P00508*****************************************************************         
P00508*                                                                         
P00508     EXEC SQL                                                             
P00508        INCLUDE TBMTRENV                                                  
P00508     END-EXEC.                                                            
P00508*                                                                         
P00508*****************************************************************         
P00508*   CSS_ACCT_ATTRIBUTE  YP                                      *         
P00508*****************************************************************         
P00508*                                                                         
P00508     EXEC SQL                                                             
P00508        INCLUDE TBACTATT                                                  
P00508     END-EXEC.                                                            
P00508*                                                                         
           EXEC SQL                                                             
              INCLUDE TBFINLWO                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLDET                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
A02951*                                                                         
A02951*****************************************************************         
A02951*   CSS_SO_DATA - VO                                            *         
A02951*****************************************************************         
A02951*                                                                         
A02951     EXEC SQL                                                             
A02951         INCLUDE TBSODAT                                                  
A02951     END-EXEC.                                                            
A02951*                                                                         
                                                                        
p00613**  css_CREDIT_PROFILE   - CZ                                             
p00613     EXEC SQL                                                             
p00613         INCLUDE TBCRPROF                                                 
p00613     END-EXEC.                                                            
p00613                                                                  
p00613**  css_AR_CNTL          - AC                                             
p00613     EXEC SQL                                                             
p00613         INCLUDE TBARCNTL                                                 
p00613     END-EXEC.                                                            
p00613                                                                  
p00613**  css_NSF_HIST         - NH                                             
p00613     EXEC SQL                                                             
p00613         INCLUDE TBNSFHST                                                 
p00613     END-EXEC.                                                            
p00613*                                                                         
P0613A**  CSS_BUDGET_PLAN      - BU                                             
P0613A     EXEC SQL                                                             
P0613A        INCLUDE TBBGTPLN                                                  
P0613A     END-EXEC.                                                            
P0613A*                                                                         
A04880**  CSS_CONTRACT         - CT                                             
A04880     EXEC SQL                                                             
A04880        INCLUDE TBCNTRCT                                                  
A04880     END-EXEC.                                                            
A04880*                                                                         
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00027.                                                       
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
           COPY CWS00056.                                                       
           COPY CWS00303.                                                       
           COPY CWS0068L.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02443'.      
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-ACCOUNT-NO         PIC X(13) VALUE SPACES.          
           05  PARM-ACCOUNT-NO-RED     REDEFINES PARM-ACCOUNT-NO        
                                       PIC 9(13).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-DATE-CCYY-MM-DD.                                      
               10  WS-DATE-CCYY       PIC X(04) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-MM         PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE SPACES.           
               10  WS-DATE-DD         PIC X(02) VALUE SPACES.           
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-DD        PIC X(02) VALUE SPACES.           
               10  FILLER             PIC X(01) VALUE '/'.              
               10  WS-DATE2-CCYY      PIC X(04) VALUE SPACES.           
P00613     05  WS-DATE-YEAR-AGO.                                        
P00613         10 WS-YEAR-AGO-YYYY    PIC 9(04).                        
P00613         10 FILLER              PIC X(01) VALUE '-'.              
P00613         10 WS-YEAR-AGO-MM      PIC 9(02).                        
P00613         10 FILLER              PIC X(01) VALUE '-'.              
P00613         10 WS-YEAR-AGO-DD      PIC 9(02).                        
P00613     05  WS-YEAR-AGO-DATE REDEFINES WS-DATE-YEAR-AGO PIC X(10).   
                                                                        
P00613     05  WS-NULL-IND-00          PIC S9(04) COMP   VALUE +0.      
P00613     05  WS-NULL-IND-30          PIC S9(04) COMP   VALUE +0.      
P00613     05  WS-NULL-IND-60          PIC S9(04) COMP   VALUE +0.      
P00613     05  WS-NULL-IND-90          PIC S9(04) COMP   VALUE +0.      
P00613*                                                                         
           05  WS-NULL-IND-3           PIC S9(04) COMP.                 
           05  WS-NULL-IND-CPD         PIC S9(04) COMP.                 
T28824     05  WS-CPD310-NULL-IND      PIC S9(04) COMP.                 
           05  WS-BILL-COUNT           PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-DATE-BILL-00-IND     PIC S9(04)    COMP   VALUE +0.   
           05  WS-DATE-BILL-30-IND     PIC S9(04)    COMP   VALUE +0.   
           05  WS-DATE-BILL-60-IND     PIC S9(04)    COMP   VALUE +0.   
           05  WS-DATE-BILL-90-IND     PIC S9(04)    COMP   VALUE +0.   
           05  WS-LAST-PAYMENT-DATE-IND PIC S9(04)    COMP   VALUE +0.  
           05  WS-EIBRESP              PIC S9(08)                       
                                       COMP SYNC VALUE ZERO.            
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
A02951     05  WS-DATE-CREDIT-D        PIC X(10) VALUE SPACES.          
A02951     05  WS-DATE-CREDIT-G        PIC X(10) VALUE SPACES.          
A02951     05  WS-DATE-CREDIT-H        PIC X(10) VALUE SPACES.          
A02951     05  WS-DATE-CREDIT-I        PIC X(10) VALUE SPACES.          
A02951     05  WS-MIN-DATE             PIC X(10) VALUE SPACES.          
REARCH     05  MCSCB068                PIC X(08) VALUE 'MCSCB068'.      
P0613A     05  WS-REV-MNTH-C           PIC 9(06).                       
P0613A     05  WS-ANNIVERSARY-DATE.                                     
P0613A         10 WS-ANNIVERSARY-DATE-YR  PIC 9(04).                    
P0613A         10 WS-ANNIVERSARY-DATE-MM  PIC 9(02).                    
COB305     05 WS-REV-MTH-LST-NRML        PIC S9(6) COMP-3 VALUE 0.          
P0613A     05  WS-REV-MTH-LST-NRML-NUM    PIC 9(06).                    
P0613A     05  WS-REV-MTH-LST-NRML-YM.                                  
P0613A         10 WS-REV-MTH-LST-NRML-YR  PIC 9(04).                    
P0613A         10 WS-REV-MTH-LST-NRML-MM  PIC 9(02).                    
P0613A     05  WS-AR-BAL-DUE              PIC S9(09)V99 COMP-3 VALUE +0.
P0613A     05  WS-BBP-BAL-DUE             PIC S9(09)V99 COMP-3 VALUE +0.
P0613A     05  WS-TOTAL-BAL-DUE           PIC S9(09)V99 COMP-3 VALUE +0.
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
           05  WS-EXISTS-FLAG          PIC X(01) VALUE 'N'.             
           05  WS-ACTIVE-CODE          PIC X(01) VALUE 'A'.             
           05  WS-PENDING-CODE         PIC X(01) VALUE 'P'.             
A02951     05  WS-DNP-FLAG             PIC X(01) VALUE SPACES.          
A02951     05  WS-PENDING-FLAG         PIC X(01) VALUE SPACES.          
           05  WS-ACCOUNT-NO           PIC 9(13) VALUE ZERO.            
           05  WS-ACCOUNT-NO-NUM       PIC S9(13) COMP-3 VALUE ZERO.    
           05  WS-PREMISE-NO           PIC 9(10) VALUE ZERO.            
           05  WS-PREMISE-NO-NUM       PIC S9(10) COMP-3 VALUE ZERO.    
           05  WS-MULT-ACCOUNT-NO      PIC S9(13) COMP-3 VALUE ZERO.    
P00613     05  WS-NSF-HIST-EXISTS      PIC X(01) VALUE 'N'.             
P00613     05  WS-ACTIVE-RETURN-CHECK  PIC X(01) VALUE 'N'.             
A04880     05  WS-701                  PIC X(03) VALUE '701'.           
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05 RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.           
           05 RS-ACCOUNT-TYPE         PIC X(01) VALUE SPACE.            
           05 RS-ELECTRIC-SUPPLIED    PIC X(01) VALUE SPACE.            
           05 RS-GAS-SUPPLIED         PIC X(01) VALUE SPACE.            
           05 RS-LIGHTING-SUPPLIED    PIC X(01) VALUE SPACE.            
           05 RS-CODE-ACCT-STAT       PIC X(01) VALUE SPACE.            
           05 RS-BILLED-BAL           PIC S9(11)V99 VALUE 0 COMP-3.     
           05 RS-ARREARS              PIC S9(09)V99 VALUE 0 COMP-3.     
           05 RS-NEXT-READ-DATE       PIC X(10) VALUE SPACE.            
           05 RS-LAST-BILL-DATE       PIC X(10) VALUE SPACE.            
           05 RS-LAST-BILL-AMT        PIC S9(09)V99 VALUE 0 COMP-3.     
           05 RS-CURRENT-DUE-DATE     PIC X(10) VALUE SPACE.            
           05 RS-ARREARS-DUE-DATE     PIC X(10) VALUE SPACE.            
           05 RS-LAST-PAYMENT-AMT     PIC S9(09)V99 VALUE 0 COMP-3.     
           05 RS-LAST-PAYMENT-DATE    PIC X(10) VALUE SPACE.            
A02951     05 RS-DNP-FLAG             PIC X(01) VALUE SPACE.            
A02951     05 RS-DNP-DATE             PIC X(10) VALUE SPACE.            
P00505     05 RS-ENERGYWISE-FLAG      PIC X(01) VALUE SPACE.            
P00508     05 RS-LOAD-ANALYSIS-FL     PIC X(01) VALUE SPACE.            
P00508     05 RS-RATE-COMPARE-FL      PIC X(01) VALUE SPACE.            
P00508     05 RS-METER-NO             PIC X(12) VALUE SPACE.            
P00613     05 RS-JUDGEMENT-IND        PIC X(01) VALUE SPACE.            
P00613     05 RS-COLLECT-STATUS-CD    PIC X(01) VALUE SPACE.            
P00613     05 RS-CASH-ONLY            PIC X(01) VALUE SPACE.            
P00613     05 RS-RETURN-CHECK         PIC X(01) VALUE SPACE.            
P0613A     05 RS-CURRENT-BBP-AMOUNT   PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 RS-TOTAL-ACCT-BALANCE   PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 RS-EST-BBP-AMOUNT       PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 RS-ANNIVERSARY-DATE     PIC X(10) VALUE SPACE.            
P0613A     05 RS-BBP-PYMTS-REMAINING  PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 RS-MONTHS-REMAINING     PIC S9(6)    COMP-3 VALUE +0.     
A04880     05 RS-CIAC-CONTRACT-STATUS PIC X(01) VALUE SPACE.            
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05 S-RETURN-CODE           PIC S9(9) COMP VALUE 0.           
REARCH     05 S-ACCOUNT-TYPE          PIC X(01) VALUE SPACE.            
REARCH     05 S-ELECTRIC-SUPPLIED     PIC X(01) VALUE SPACE.            
REARCH     05 S-GAS-SUPPLIED          PIC X(01) VALUE SPACE.            
REARCH     05 S-LIGHTING-SUPPLIED     PIC X(01) VALUE SPACE.            
REARCH     05 S-CODE-ACCT-STAT        PIC X(01) VALUE SPACE.            
REARCH     05 S-BILLED-BAL            PIC S9(11)V99 VALUE 0 COMP-3.     
REARCH     05 S-ARREARS               PIC S9(09)V99 VALUE 0 COMP-3.     
REARCH     05 S-NEXT-READ-DATE        PIC X(10) VALUE SPACE.            
REARCH     05 S-LAST-BILL-DATE        PIC X(10) VALUE SPACE.            
REARCH     05 S-LAST-BILL-AMT         PIC S9(09)V99 VALUE 0 COMP-3.     
REARCH     05 S-CURRENT-DUE-DATE      PIC X(10) VALUE SPACE.            
REARCH     05 S-ARREARS-DUE-DATE      PIC X(10) VALUE SPACE.            
REARCH     05 S-LAST-PAYMENT-AMT      PIC S9(09)V99 VALUE 0 COMP-3.     
REARCH     05 S-LAST-PAYMENT-DATE     PIC X(10) VALUE SPACE.            
A02951     05 S-DNP-FLAG              PIC X(01) VALUE SPACE.            
A02951     05 S-DNP-DATE              PIC X(10) VALUE SPACE.            
P00505     05 S-ENERGYWISE-FLAG       PIC X(01) VALUE SPACE.            
P00508     05 S-LOAD-ANALYSIS-FL      PIC X(01) VALUE SPACE.            
P00508     05 S-RATE-COMPARE-FL       PIC X(01) VALUE SPACE.            
P00508     05 S-METER-NO              PIC X(12) VALUE SPACE.            
P00613     05 S-JUDGEMENT-IND         PIC X(01) VALUE SPACE.            
P00613     05 S-COLLECT-STATUS-CD     PIC X(01) VALUE SPACE.            
P00613     05 S-CASH-ONLY             PIC X(01) VALUE SPACE.            
P00613     05 S-RETURN-CHECK          PIC X(01) VALUE SPACE.            
P0613A     05 S-CURRENT-BBP-AMOUNT    PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 S-TOTAL-ACCT-BALANCE    PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 S-EST-BBP-AMOUNT        PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 S-ANNIVERSARY-DATE      PIC X(10) VALUE SPACE.            
P0613A     05 S-BBP-PYMTS-REMAINING   PIC S9(9)V99 COMP-3 VALUE +0.     
P0613A     05 S-MONTHS-REMAINING      PIC S9(6)    COMP-3 VALUE +0.     
A04880     05 S-CIAC-CONTRACT-STATUS  PIC X(01) VALUE SPACE.            
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
                                                                        
      ******************************************************************        
      *     CURSOR DECLARATIONS                                        *        
      ******************************************************************        
      *                                                                         
P0613A      EXEC SQL                                                    
P0613A        DECLARE  AR_CNTL_CURSOR CURSOR FOR                        
P0613A          SELECT AMT_AR_DAY_00,                                   
P0613A                 AMT_AR_DAY_30,                                   
P0613A                 AMT_AR_DAY_60,                                   
P0613A                 AMT_AR_DAY_90,                                   
P0613A                 AMT_UNUSED_CR,                                   
P0613A                 AMT_TRAN_BALANCE,                                
P0613A                 TOT_SUMM_UNBILLED,                               
P0613A                 PYMT_PRIORITY_LVL,                               
P0613A                 ITEM_ID                                          
P0613A          FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                        
P0613A          WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO                     
P0613A          ORDER BY  PYMT_PRIORITY_LVL ASC,                        
P0613A                    ITEM_ID DESC                                  
P0613A          FOR READ ONLY                                   
P0613A      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*     EXEC SQL                                                            
MFA-TR*       DECLARE  AR_CNTL_CURSOR CURSOR FOR                                
MFA-TR*         SELECT AMT_AR_DAY_00,                                           
MFA-TR*                AMT_AR_DAY_30,                                           
MFA-TR*                AMT_AR_DAY_60,                                           
MFA-TR*                AMT_AR_DAY_90,                                           
MFA-TR*                AMT_UNUSED_CR,                                           
MFA-TR*                AMT_TRAN_BALANCE,                                        
MFA-TR*                TOT_SUMM_UNBILLED,                                       
MFA-TR*                PYMT_PRIORITY_LVL,                                       
MFA-TR*                ITEM_ID                                                  
MFA-TR*         FROM   CSS_AR_CNTL                                              
MFA-TR*         WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO                             
MFA-TR*         ORDER BY  PYMT_PRIORITY_LVL ASC,                                
MFA-TR*                   ITEM_ID DESC                                          
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     END-EXEC.                                                           
P0613A*                                                                         
HPCCDM*EJECT                                                                    
P0613A*                                                                         
           EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-ACCOUNT-NO-RED      PIC 9(13)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
      *                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
      *                                                                         
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
P0613A* WE NEED TO CHANGE THE COLUMN LABEL NAME FROM BBP_FULL_BALANCE  *        
P0613A* TO TOTAL_ACCT_BALANCE AND UI CHANGES AS NEEDED.                *        
      ******************************************************************        
       0100-INITIALIZE.                                                 
                                                                        
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
REARCH        :S-RETURN-CODE              AS RETURN_CODE                
REARCH       ,LTRIM(RTRIM(:S-ACCOUNT-TYPE))      AS ACCOUNT_TYPE               
REARCH       ,LTRIM(RTRIM(:S-ELECTRIC-SUPPLIED)) AS ELECTRIC_SUPPLIED          
REARCH       ,LTRIM(RTRIM(:S-GAS-SUPPLIED))      AS GAS_SUPPLIED               
REARCH       ,LTRIM(RTRIM(:S-LIGHTING-SUPPLIED)) AS LIGHTING_SUPPLIED          
REARCH       ,LTRIM(RTRIM(:S-CODE-ACCT-STAT))    AS CODE_ACCT_STAT             
REARCH       ,:S-BILLED-BAL               AS BILLED_BAL                 
REARCH       ,:S-ARREARS                  AS ARREARS                    
REARCH       ,LTRIM(RTRIM(:S-NEXT-READ-DATE))    AS NEXT_READ_DATE             
REARCH       ,LTRIM(RTRIM(:S-LAST-BILL-DATE))    AS LAST_BILL_DATE             
REARCH       ,:S-LAST-BILL-AMT            AS LAST_BILL_AMT              
REARCH       ,LTRIM(RTRIM(:S-CURRENT-DUE-DATE))  AS CURRENT_DUE_DATE           
REARCH       ,LTRIM(RTRIM(:S-ARREARS-DUE-DATE))  AS ARREARS_DUE_DATE           
REARCH       ,:S-LAST-PAYMENT-AMT         AS LAST_PAYMENT_AMT           
REARCH       ,LTRIM(RTRIM(:S-LAST-PAYMENT-DATE)) AS LAST_PAYMENT_DATE          
A02951       ,:S-DNP-FLAG                 AS DNP_FLAG                   
A02951       ,LTRIM(RTRIM(:S-DNP-DATE))          AS DNP_DATE                   
P00505       ,:S-ENERGYWISE-FLAG          AS ENERGYWISE_FLAG            
P00508       ,:S-LOAD-ANALYSIS-FL         AS ENERGY_PRISM_FL            
P00508       ,:S-RATE-COMPARE-FL          AS RATE_COMPARE_FL            
P00508       ,:S-METER-NO                 AS METER_NO                   
P00613       ,:S-JUDGEMENT-IND            AS JUDGEMENT_IND              
P00613       ,:S-COLLECT-STATUS-CD        AS COLLECT_STATUS_CD          
P00613       ,:S-CASH-ONLY                AS CASH_ONLY                  
P00613       ,:S-RETURN-CHECK             AS RETURN_CHECK               
P0613A       ,:S-CURRENT-BBP-AMOUNT       AS CURRENT_BBP_AMOUNT         
P0613A       ,:S-TOTAL-ACCT-BALANCE       AS BBP_FULL_BALANCE           
P0613A       ,:S-EST-BBP-AMOUNT           AS EST_BBP_AMOUNT             
P0613A       ,:S-ANNIVERSARY-DATE         AS ANNIVERSARY_DATE           
P0613A       ,:S-BBP-PYMTS-REMAINING      AS BBP_PYMTS_REMAINING        
P0613A       ,:S-MONTHS-REMAINING         AS MONTHS_REMAINING           
A04880       ,:S-CIAC-CONTRACT-STATUS     AS CIAC_CONTRACT_STATUS       
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS RETURN_CODE                        
MFA-TR*      ,STRIP(:S-ACCOUNT-TYPE)      AS ACCOUNT_TYPE                       
MFA-TR*      ,STRIP(:S-ELECTRIC-SUPPLIED) AS ELECTRIC_SUPPLIED                  
MFA-TR*      ,STRIP(:S-GAS-SUPPLIED)      AS GAS_SUPPLIED                       
MFA-TR*      ,STRIP(:S-LIGHTING-SUPPLIED) AS LIGHTING_SUPPLIED                  
MFA-TR*      ,STRIP(:S-CODE-ACCT-STAT)    AS CODE_ACCT_STAT                     
MFA-TR*      ,:S-BILLED-BAL               AS BILLED_BAL                         
MFA-TR*      ,:S-ARREARS                  AS ARREARS                            
MFA-TR*      ,STRIP(:S-NEXT-READ-DATE)    AS NEXT_READ_DATE                     
MFA-TR*      ,STRIP(:S-LAST-BILL-DATE)    AS LAST_BILL_DATE                     
MFA-TR*      ,:S-LAST-BILL-AMT            AS LAST_BILL_AMT                      
MFA-TR*      ,STRIP(:S-CURRENT-DUE-DATE)  AS CURRENT_DUE_DATE                   
MFA-TR*      ,STRIP(:S-ARREARS-DUE-DATE)  AS ARREARS_DUE_DATE                   
MFA-TR*      ,:S-LAST-PAYMENT-AMT         AS LAST_PAYMENT_AMT                   
MFA-TR*      ,STRIP(:S-LAST-PAYMENT-DATE) AS LAST_PAYMENT_DATE                  
MFA-TR*      ,:S-DNP-FLAG                 AS DNP_FLAG                           
MFA-TR*      ,STRIP(:S-DNP-DATE)          AS DNP_DATE                           
MFA-TR*      ,:S-ENERGYWISE-FLAG          AS ENERGYWISE_FLAG                    
MFA-TR*      ,:S-LOAD-ANALYSIS-FL         AS ENERGY_PRISM_FL                    
MFA-TR*      ,:S-RATE-COMPARE-FL          AS RATE_COMPARE_FL                    
MFA-TR*      ,:S-METER-NO                 AS METER_NO                           
MFA-TR*      ,:S-JUDGEMENT-IND            AS JUDGEMENT_IND                      
MFA-TR*      ,:S-COLLECT-STATUS-CD        AS COLLECT_STATUS_CD                  
MFA-TR*      ,:S-CASH-ONLY                AS CASH_ONLY                          
MFA-TR*      ,:S-RETURN-CHECK             AS RETURN_CHECK                       
MFA-TR*      ,:S-CURRENT-BBP-AMOUNT       AS CURRENT_BBP_AMOUNT                 
MFA-TR*      ,:S-TOTAL-ACCT-BALANCE       AS BBP_FULL_BALANCE                   
MFA-TR*      ,:S-EST-BBP-AMOUNT           AS EST_BBP_AMOUNT                     
MFA-TR*      ,:S-ANNIVERSARY-DATE         AS ANNIVERSARY_DATE                   
MFA-TR*      ,:S-BBP-PYMTS-REMAINING      AS BBP_PYMTS_REMAINING                
MFA-TR*      ,:S-MONTHS-REMAINING         AS MONTHS_REMAINING                   
MFA-TR*      ,:S-CIAC-CONTRACT-STATUS     AS CIAC_CONTRACT_STATUS               
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO-RED   TO WS-ACCOUNT-NO.                 
           MOVE WS-ACCOUNT-NO         TO WS-ACCOUNT-NO-NUM.             
           MOVE WS-ACCOUNT-NO         TO AT-ACCOUNT-NO.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT     THRU 2200-EXIT.                
REARCH     MOVE '2000'                   TO ACTIVE-PARAGRAPH            
REARCH     PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.               
           PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.                
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT.                                             *        
REARCH*                                                                *        
REARCH******************************************************************        
                                                                        
REARCH 2000A-MOVE-RESULT.                                               
                                                                        
REARCH     MOVE RS-RETURN-CODE                 TO S-RETURN-CODE.        
REARCH     MOVE RS-ACCOUNT-TYPE                TO S-ACCOUNT-TYPE.       
REARCH     MOVE RS-ELECTRIC-SUPPLIED           TO S-ELECTRIC-SUPPLIED.  
REARCH     MOVE RS-GAS-SUPPLIED                TO S-GAS-SUPPLIED.       
REARCH     MOVE RS-LIGHTING-SUPPLIED           TO S-LIGHTING-SUPPLIED.  
REARCH     MOVE RS-CODE-ACCT-STAT              TO S-CODE-ACCT-STAT.     
REARCH     MOVE RS-BILLED-BAL                  TO S-BILLED-BAL.         
REARCH     MOVE RS-ARREARS                     TO S-ARREARS.            
REARCH     MOVE RS-NEXT-READ-DATE              TO S-NEXT-READ-DATE.     
REARCH     MOVE RS-LAST-BILL-DATE              TO S-LAST-BILL-DATE.     
REARCH     MOVE RS-LAST-BILL-AMT               TO S-LAST-BILL-AMT.      
REARCH     MOVE RS-CURRENT-DUE-DATE            TO S-CURRENT-DUE-DATE.   
REARCH     MOVE RS-ARREARS-DUE-DATE            TO S-ARREARS-DUE-DATE.   
REARCH     MOVE RS-LAST-PAYMENT-AMT            TO S-LAST-PAYMENT-AMT.   
REARCH     MOVE RS-LAST-PAYMENT-DATE           TO S-LAST-PAYMENT-DATE.  
A02951     MOVE RS-DNP-FLAG                    TO S-DNP-FLAG.           
A02951     MOVE RS-DNP-DATE                    TO S-DNP-DATE.           
P00505     MOVE RS-ENERGYWISE-FLAG             TO S-ENERGYWISE-FLAG.    
P00508     MOVE RS-LOAD-ANALYSIS-FL            TO S-LOAD-ANALYSIS-FL.   
P00508     MOVE RS-RATE-COMPARE-FL             TO S-RATE-COMPARE-FL.    
P00508     MOVE RS-METER-NO                    TO S-METER-NO.           
P00613     MOVE RS-JUDGEMENT-IND               TO S-JUDGEMENT-IND.      
P00613     MOVE RS-COLLECT-STATUS-CD           TO S-COLLECT-STATUS-CD.  
P00613     MOVE RS-CASH-ONLY                   TO S-CASH-ONLY.          
P00613     MOVE RS-RETURN-CHECK                TO S-RETURN-CHECK.       
P0613A     MOVE RS-CURRENT-BBP-AMOUNT          TO S-CURRENT-BBP-AMOUNT. 
P0613A     MOVE RS-TOTAL-ACCT-BALANCE          TO S-TOTAL-ACCT-BALANCE. 
P0613A     MOVE RS-EST-BBP-AMOUNT              TO S-EST-BBP-AMOUNT.     
P0613A     MOVE RS-ANNIVERSARY-DATE            TO S-ANNIVERSARY-DATE.   
P0613A     MOVE RS-BBP-PYMTS-REMAINING         TO S-BBP-PYMTS-REMAINING.
P0613A     MOVE RS-MONTHS-REMAINING            TO S-MONTHS-REMAINING.   
A04880     MOVE RS-CIAC-CONTRACT-STATUS       TO S-CIAC-CONTRACT-STATUS.
                                                                        
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
      *  GET THE CURRENT DATE FOR CPD00068                                      
      *  GET ACCOUNT DATA                                                       
                                                                        
           PERFORM 7010-GET-CURRENT-DATE THRU 7010-EXIT.                
           PERFORM 7000-SELECT-ACCOUNT THRU 7000-EXIT.                  
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE.             
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE AT-PREMISE-NO            TO PR-PREMISE-NO            
              MOVE AT-CODE-ACCT-STAT        TO RS-CODE-ACCT-STAT        
P00613        IF AT-CODE-ACCT-STAT = 'S' OR 'B' OR 'I' OR 'J'           
P00613            PERFORM 7999-FINAL-BILL-AMT THRU 7999-EXIT            
P00613            MOVE FW-COLLECT-STATUS-CD TO RS-COLLECT-STATUS-CD     
P00613        ELSE                                                      
P00613            MOVE SPACES TO RS-COLLECT-STATUS-CD                   
P00613        END-IF                                                    
              MOVE AT-ACCOUNT-TYPE-CODE     TO RS-ACCOUNT-TYPE          
              MOVE AT-LAST-PYMT-AMOUNT      TO RS-LAST-PAYMENT-AMT      
P00613        MOVE AT-JUDGEMENT-IND         TO RS-JUDGEMENT-IND         
              IF WS-LAST-PAYMENT-DATE-IND < 0                           
                  MOVE LOW-VALUES           TO AT-LAST-PYMT-DATE        
                  MOVE SPACES               TO RS-LAST-PAYMENT-DATE     
              ELSE                                                      
                  MOVE AT-LAST-PYMT-DATE TO RS-LAST-PAYMENT-DATE        
              END-IF                                                    
              MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT       
A02951        IF WS-DATE-BILL-30-IND < ZERO                             
A02951           MOVE LOW-VALUES         TO AT-DATE-BILL-DAY-30         
A02951        END-IF                                                    
A02951        IF WS-DATE-BILL-60-IND < ZERO                             
A02951           MOVE LOW-VALUES         TO AT-DATE-BILL-DAY-60         
A02951        END-IF                                                    
A02951        IF WS-DATE-BILL-90-IND < ZERO                             
A02951           MOVE LOW-VALUES         TO AT-DATE-BILL-DAY-90         
A02951        END-IF                                                    
              IF WS-DATE-BILL-00-IND < ZERO                             
                  MOVE LOW-VALUES           TO AT-DATE-BILL-DAY-00      
                  MOVE SPACES               TO RS-LAST-BILL-DATE        
              ELSE                                                      
                  PERFORM 7950-SELECT-BILL THRU 7950-EXIT               
                  IF WS-BILL-COUNT NOT > 0                              
                     OR WS-ACTIVE-RETURN-CODE = NOT-FOUND               
                     MOVE SPACES            TO RS-LAST-BILL-DATE        
                  ELSE                                                  
                     MOVE AT-DATE-BILL-DAY-00 TO WS-DATE-CCYY-MM-DD     
                     MOVE WS-DATE-CCYY        TO WS-DATE2-CCYY          
                     MOVE WS-DATE-MM          TO WS-DATE2-MM            
                     MOVE WS-DATE-DD          TO WS-DATE2-DD            
                     MOVE WS-DATE-MM-DD-YYYY  TO RS-LAST-BILL-DATE      
                  END-IF                                                
              END-IF                                                    
                                                                        
              MOVE WS-CURRENT-DATE  TO WS-CL-DATE-NOTICE-MAIL           
                                       WS-CL-DATE-NOTICE-DUE            
                                       WS-HOLD-DATE                     
              MOVE 'Y'              TO CALC-ARREARS-SW                  
A02951                                 CALC-BALANCE-SW                  
                                       CALC-PAST-DUE-SW                 
A02951                                 LOAD-DNP-DATE-SW                 
                                       LOAD-DUE-DATES-SW                
A02951                                 LOAD-WS-AMOUNTS-SW
           END-IF.              
                                                                        
              MOVE PROGRAM-NAME                TO                       
                                               WS-CPD00068-CALLING-PGM  
              MOVE SPACES                      TO ABEND-FUNCTION        
              PERFORM 9500-CALL-CPD00068       THRU 9500-EXIT           
              MOVE RS-RETURN-CODE              TO WS-ACTIVE-RETURN-CODE,
                                                  SQLCODE               
              IF ABEND-FUNCTION  > SPACES                               
                 IF ABEND-FUNCTION EQUAL 'BADDATA'                      
                    MOVE -1                    TO RS-RETURN-CODE,       
                                                  WS-ACTIVE-RETURN-CODE 
                 END-IF                                                 
                 PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT           
              END-IF                                                    
A02951        IF WS-DATE-CREDIT-ACTION-D > SPACES                       
A02951           IF WS-DATE-CREDIT-ACTION-D > WS-CURRENT-DATE           
A02951              MOVE WS-DATE-CREDIT-ACTION-D  TO WS-DATE-CREDIT-D   
A02951           END-IF                                                 
A02951        END-IF                                                    
A02951        IF WS-DATE-CREDIT-ACTION-G > SPACES                       
A02951           IF WS-DATE-CREDIT-ACTION-G > WS-CURRENT-DATE           
A02951              MOVE WS-DATE-CREDIT-ACTION-G  TO WS-DATE-CREDIT-G   
A02951           END-IF                                                 
A02951        END-IF                                                    
A02951        IF WS-DATE-CREDIT-ACTION-H > SPACES                       
A02951           IF WS-DATE-CREDIT-ACTION-H > WS-CURRENT-DATE           
A02951              MOVE WS-DATE-CREDIT-ACTION-H  TO WS-DATE-CREDIT-H   
A02951           END-IF                                                 
A02951        END-IF                                                    
A02951        IF WS-DATE-CREDIT-ACTION-I > SPACES                       
A02951           IF WS-DATE-CREDIT-ACTION-I > WS-CURRENT-DATE           
A02951              MOVE WS-DATE-CREDIT-ACTION-I  TO WS-DATE-CREDIT-I   
A02951           END-IF                                                 
A02951        END-IF                                                    
A02951        MOVE SPACES                  TO WS-MIN-DATE               
A02951        IF WS-DATE-CREDIT-D = SPACES                              
A02951          MOVE '2099-01-01'          TO WS-DATE-CREDIT-D          
A02951        END-IF                                                    
A02951        IF WS-DATE-CREDIT-G = SPACES                              
A02951           MOVE '2099-01-01'         TO WS-DATE-CREDIT-G          
A02951        END-IF                                                    
A02951        IF WS-DATE-CREDIT-I = SPACES                              
A02951          MOVE '2099-01-01'          TO WS-DATE-CREDIT-I          
A02951        END-IF                                                    
A02951        IF WS-DATE-CREDIT-H = SPACES                              
A02951           MOVE '2099-01-01'         TO WS-DATE-CREDIT-H          
A02951        END-IF                                                    
A02951        IF WS-DATE-CREDIT-D > WS-DATE-CREDIT-G                    
A02951           MOVE WS-DATE-CREDIT-G     TO WS-MIN-DATE               
A02951        ELSE                                                      
A02951           MOVE WS-DATE-CREDIT-D     TO WS-MIN-DATE               
A02951        END-IF                                                    
A02951        IF WS-MIN-DATE > WS-DATE-CREDIT-H                         
A02951           MOVE WS-DATE-CREDIT-H     TO WS-MIN-DATE               
A02951        END-IF                                                    
A02951        IF WS-MIN-DATE > WS-DATE-CREDIT-I                         
A02951           MOVE WS-DATE-CREDIT-I     TO WS-MIN-DATE               
A02951        END-IF                                                    
A02951        IF WS-MIN-DATE = '2099-01-01'                             
A02951           MOVE SPACES               TO WS-MIN-DATE               
A02951        END-IF                                                    
A02951        MOVE WS-MIN-DATE             TO RS-DNP-DATE               
A02951        PERFORM 2300-PROCESS-DNP-FLAG    THRU 2300-EXIT           
A02951        MOVE WS-DNP-FLAG             TO RS-DNP-FLAG               
                                                                        
P00505        MOVE 'N'                     TO WS-EXISTS-FLAG            
P00505        MOVE WS-ACCOUNT-NO-NUM       TO PN-ACCOUNT-NO,            
P00613                                        CZ-ACCOUNT-NO,            
P00613                                        AC-ACCOUNT-NO             
P00505        MOVE AT-COMPANY-NO           TO PN-COMPANY-NO             
P00613                                                                  
P00613        PERFORM 7350-GET-CREDIT-PROFILE  THRU 7350-EXIT           
P00613        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL AND            
P00613                                   CZ-CASH-ONLY-FL = 'Y'          
P00613           MOVE 'Y'        TO RS-CASH-ONLY                        
P00613        ELSE                                                      
P00613           MOVE 'N'        TO RS-CASH-ONLY                        
P00613        END-IF                                                    
P00613        PERFORM 7400-ARCNTL-RET-CHECK    THRU 7400-EXIT           
P00613        PERFORM 7440-SELECT-NSF-HIST    THRU 7440-EXIT            
P00613        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
P00613           IF RS-RETURN-CHECK = 'Y' AND                           
P00613                         WS-ACTIVE-RETURN-CHECK = 'Y'             
P00613              MOVE 'A'        TO RS-RETURN-CHECK                  
P00613           END-IF                                                 
P00613        ELSE                                                      
P00613           MOVE SPACES     TO RS-RETURN-CHECK                     
P00613        END-IF                                                    
                                                                        
P00505        PERFORM 7080-CHECK-ENERGYWISE-FLAG THRU 7080-EXIT.        
P00505                                                                  
P00505        MOVE WS-EXISTS-FLAG              TO RS-ENERGYWISE-FLAG    
P00508*                                                                         
P00508******************************************************************        
P00508* For all accounts with smart-synch meters                       *        
P00508* - Residential                                                  *        
P00508*   ~ set RS-LOAD-ANALYSIS-FL to 'Y' based on active attribute   *        
P00508*   ~ set RS-RATE-COMPARE-FL to 'Y' based on active attribute    *        
P00508* - Commercial/Industrial                                        *        
P00508*   ~ set RS-LOAD-ANALYSIS-FL always to 'Y'                      *        
P00508*   ~ set RS-RATE-COMPARE-FL based on active attribute           *        
P00508******************************************************************        
P00508*                                                                         
P00508        MOVE 'N'                         TO WS-EXISTS-FLAG        
P00508        MOVE WS-ACCOUNT-NO-NUM           TO MN-ACCOUNT-NO         
P00508                                            YP-ACCOUNT-NO         
P00508        PERFORM 7090-CHK-MDM-FLAGS       THRU 7090-EXIT           
P00508*                                                                         
P00508        EVALUATE AT-ACCOUNT-TYPE-CODE ALSO WS-EXISTS-FLAG         
P00508            WHEN 'D' ALSO 'Y'                                     
P00508                 MOVE 'Y'                TO RS-LOAD-ANALYSIS-FL   
P00508                 MOVE 'Y'                TO RS-RATE-COMPARE-FL    
P00508            WHEN 'C' ALSO 'Y'                                     
P00508            WHEN 'I' ALSO 'Y'                                     
P00508                 MOVE 'Y'                TO RS-LOAD-ANALYSIS-FL   
P00508* Evaluation mode Chnages - Start                                         
P00508                 MOVE 'N'                TO WS-EXISTS-FLAG        
P00508                 MOVE 'MDM_LD_ANALYSIS'  TO YP-ATTRIBUTE-DESC     
P00508                 PERFORM 7100-GET-ACCT-ATTR THRU 7100-EXIT        
P00508                 MOVE WS-EXISTS-FLAG     TO RS-LOAD-ANALYSIS-FL   
P00508* Evaluation mode Chnages - End                                           
P00508                 MOVE 'N'                TO WS-EXISTS-FLAG        
P00508                 MOVE 'MDM_RT_COMPARE'   TO YP-ATTRIBUTE-DESC     
P00508                 PERFORM 7100-GET-ACCT-ATTR THRU 7100-EXIT        
P00508                 MOVE WS-EXISTS-FLAG     TO RS-RATE-COMPARE-FL    
P00508            WHEN 'R' ALSO 'Y'                                     
P00508                 MOVE 'N'                TO WS-EXISTS-FLAG        
P00508                 MOVE 'MDM_LD_ANALYSIS'  TO YP-ATTRIBUTE-DESC     
P00508                 PERFORM 7100-GET-ACCT-ATTR THRU 7100-EXIT        
P00508                 MOVE WS-EXISTS-FLAG     TO RS-LOAD-ANALYSIS-FL   
P00508                 MOVE 'N'                TO WS-EXISTS-FLAG        
P00508                 MOVE 'MDM_RT_COMPARE'   TO YP-ATTRIBUTE-DESC     
P00508                 PERFORM 7100-GET-ACCT-ATTR THRU 7100-EXIT        
P00508                 MOVE WS-EXISTS-FLAG     TO RS-RATE-COMPARE-FL    
P00508            WHEN OTHER                                            
P00508                 MOVE 'N'                TO RS-LOAD-ANALYSIS-FL   
P00508                                            RS-RATE-COMPARE-FL    
P00508        END-EVALUATE.                                             
P00508*                                                                         
P00508        IF MN-METER-NO > SPACES                                   
P00508           STRING '01E' MN-METER-NO DELIMITED BY SIZE             
P00508                                         INTO RS-METER-NO         
P00508        ELSE                                                      
P00508           MOVE SPACES                   TO RS-METER-NO           
P00508        END-IF.                                                   
P00508*                                                                         
                                                                        
              MOVE WS-AMT-ARREARS          TO RS-ARREARS                
C28137        IF AT-CODE-ACCT-STAT = WS-FINAL-BILLED                    
C28137            MOVE WS-DATE-NOTICE-DUE-A    TO RS-CURRENT-DUE-DATE   
C28137        ELSE                                                      
P00726            IF WS-DATE-BILL-DUE > SPACES                          
P00726               MOVE WS-DATE-BILL-DUE     TO RS-CURRENT-DUE-DATE   
P00726            ELSE                                                  
P00726               MOVE WS-DATE-NOTICE-DUE-A TO RS-CURRENT-DUE-DATE   
P00726            END-IF                                                
C28137        END-IF                                                    
A03824        IF WS-DATE-ARREARS-DUE = RS-CURRENT-DUE-DATE              
P00726           IF WS-DATE-NOTICE-DUE-B > SPACES                       
A03824              MOVE WS-DATE-NOTICE-DUE-B  TO RS-ARREARS-DUE-DATE   
P00726           ELSE                                                   
P00726              MOVE WS-DATE-NOTICE-DUE-E  TO RS-ARREARS-DUE-DATE   
P00726           END-IF                                                 
A03824        ELSE                                                      
A03824           MOVE WS-DATE-ARREARS-DUE      TO RS-ARREARS-DUE-DATE   
A03824        END-IF.                                                   
                                                                        
              IF RS-CODE-ACCT-STAT = 'S'                                
                 MOVE WS-WO-BALANCE            TO RS-BILLED-BAL         
              ELSE                                                      
                 MOVE AT-TOTAL-AR-BALANCE      TO RS-BILLED-BAL         
              END-IF                                                    
                                                                        
      *  GET THE NEXT READ DATE                                                 
                                                                        
           PERFORM 5901-NEXT-READ-DATE                                  
              THRU 5901-NEXT-READ-DATE-EXIT.                            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T28824        IF RW-THIRD-PTY-READ-DT > SPACES                          
T28824           MOVE RW-THIRD-PTY-READ-DT TO WS-DATE-CCYY-MM-DD        
T28824        ELSE                                                      
                 MOVE RW-OPTIMUM-READ-DATE TO WS-DATE-CCYY-MM-DD        
T28824        END-IF                                                    
              MOVE WS-DATE-CCYY          TO WS-DATE2-CCYY               
              MOVE WS-DATE-MM            TO WS-DATE2-MM                 
              MOVE WS-DATE-DD            TO WS-DATE2-DD                 
              MOVE WS-DATE-MM-DD-YYYY    TO RS-NEXT-READ-DATE           
           ELSE                                                         
              MOVE SPACES                TO RS-NEXT-READ-DATE
           END-IF.          
                                                                        
      *  GET THE SERVICE DATA FROM THE PREMISE                                  
                                                                        
           PERFORM 7060-SELECT-PREMISE THRU 7060-EXIT.                  
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF PR-GAS-AVAILABLE-IND  = 'A'                            
                 MOVE 'Y' TO RS-GAS-SUPPLIED                            
              ELSE                                                      
                 MOVE 'N' TO RS-GAS-SUPPLIED                            
              END-IF                                                    
              IF PR-ELEC-AVAILABLE-IND  = 'A'                           
                 MOVE 'Y' TO RS-ELECTRIC-SUPPLIED                       
              ELSE                                                      
                 MOVE 'N' TO RS-ELECTRIC-SUPPLIED                       
              END-IF                                                    
              IF PR-LITE-AVAILABLE-IND  = 'A'                           
                 MOVE 'Y' TO RS-LIGHTING-SUPPLIED                       
              ELSE                                                      
                 MOVE 'N' TO RS-LIGHTING-SUPPLIED                       
              END-IF                                                    
           ELSE                                                         
              MOVE 'N'   TO RS-ELECTRIC-SUPPLIED                        
              MOVE 'N'   TO RS-GAS-SUPPLIED                             
              MOVE 'N'   TO RS-LIGHTING-SUPPLIED                        
           END-IF.                                                      
                                                                        
      *  GET THE LAST BILL AMOUNT FROM TRANSACTION HISTORY                      
                                                                        
           IF  (AT-DATE-BILL-DAY-00 > LOW-VALUES)                       
               PERFORM 7070-SELECT-AR-TRANS-HIST THRU 7070-EXIT         
                                                                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  MOVE AR-AMT-BILLED-UNPAID TO RS-LAST-BILL-AMT         
               ELSE                                                     
                  MOVE ZEROES               TO RS-LAST-BILL-AMT         
               END-IF                                                   
           ELSE                                                         
               MOVE ZEROES                  TO RS-LAST-BILL-AMT         
           END-IF.                                                      
P0613A*  GET THE BUDGET BILLING PLAN DETAILS                                    
P0613A     MOVE WS-ACCOUNT-NO-NUM           TO BU-ACCOUNT-NO.           
P0613A     MOVE +1                          TO BU-BP-ITEM-ID.           
P0613A     MOVE +50                         TO BU-PYMT-PRIORITY-LVL.    
P0613A*                                                                         
P0613A     PERFORM 7450-SELECT-BUDGET-PLAN   THRU 7450-EXIT.            
P0613A*                                                                         
P0613A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0613A        PERFORM 5000-BBP-COMPUTE-FIELDS      THRU 5000-EXIT       
P0613A     END-IF.                                                      
P0613A*                                                                         
A04880     PERFORM 7800-SELECT-CONTRACT-STATUS THRU 7800-EXIT.          
A04880*                                                                         
A04880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
A04880        MOVE CT-CNT-STATUS-CD TO RS-CIAC-CONTRACT-STATUS          
A04880     END-IF.                                                      
A04880*                                                                         
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
A02951***************************************************************** *       
A02951* 2300-PROCESS-DNP-FLAG.                                        *         
A02951***************************************************************** *       
A02951*                                                                         
A02951 2300-PROCESS-DNP-FLAG.                                           
A02951*                                                                         
A02951     MOVE 'N' TO WS-DNP-FLAG,                                     
A02951                 WS-PENDING-FLAG.                                 
A02951     MOVE AT-PREMISE-NO         TO VO-PREMISE-NO                  
A02951     PERFORM 7030-CHECK-PEND-FLAG    THRU 7030-EXIT.              
A02951                                                                  
A02951     IF WS-PENDING-FLAG = 'Y' THEN                                
A02951        PERFORM 7040-CHECK-DNP-ACCT-FLAG THRU 7040-EXIT           
A02951        IF WS-DNP-FLAG NOT = 'F' THEN                             
A02951           PERFORM 7050-CHECK-DNP-PREM-FLAG THRU 7050-EXIT        
A02951        END-IF                                                    
A02951     END-IF.                                                      
A02951*                                                                         
A02951 2300-EXIT.                                                       
A02951     EXIT.                                                        
A02951*                                                                         
P0613A******************************************************************        
P0613A* 5000-BBP-COMPUTE-FIELDS.                                       *        
P0613A*    CUSTOMER IS ALREADY SETUP WITH BBP.                         *        
P0613A******************************************************************        
P0613A 5000-BBP-COMPUTE-FIELDS.                                         
P0613A*                                                                         
P0613A     PERFORM 5100-CALC-ACCT-BALANCE    THRU 5100-EXIT             
P0613A     MOVE WS-TOTAL-BAL-DUE        TO RS-TOTAL-ACCT-BALANCE        
P0613A*                                                                         
P0613A     MOVE BU-AMT-MO-PYMT          TO RS-CURRENT-BBP-AMOUNT        
P0613A     MOVE BU-AMT-MO-PYMT-NEW      TO RS-EST-BBP-AMOUNT            
P0613A     MOVE BU-ANNIVERSARY-DATE     TO RS-ANNIVERSARY-DATE          
P0613A*                                                                         
P0613A     STRING BU-ANNIVERSARY-DATE (1:4)                             
P0613A            BU-ANNIVERSARY-DATE (6:2) DELIMITED BY SIZE           
P0613A       INTO WS-REV-MNTH-C                                         
P0613A     MOVE WS-REV-MNTH-C           TO WS-ANNIVERSARY-DATE          
P0613A*                                                                         
P0613A     MOVE AT-REV-MTH-LST-NRML     TO WS-REV-MTH-LST-NRML          
P0613A     MOVE WS-REV-MTH-LST-NRML     TO WS-REV-MTH-LST-NRML-NUM      
P0613A     MOVE WS-REV-MTH-LST-NRML-NUM TO WS-REV-MTH-LST-NRML-YM       
P0613A*                                                                         
P0613A     IF WS-REV-MTH-LST-NRML-MM = 12 AND                           
P0613A        WS-ANNIVERSARY-DATE-YR = WS-REV-MTH-LST-NRML-YR + 2       
P0613A        ADD  1                    TO WS-REV-MTH-LST-NRML-MM       
P0613A     END-IF                                                       
P0613A*                                                                         
P0613A     IF WS-REV-MTH-LST-NRML-MM > 12                               
P0613A      COMPUTE WS-REV-MTH-LST-NRML-MM = WS-REV-MTH-LST-NRML-MM - 12
P0613A      COMPUTE WS-REV-MTH-LST-NRML-YR = WS-REV-MTH-LST-NRML-YR + 1 
P0613A     END-IF                                                       
P0613A*                                                                         
P0613A     IF WS-ANNIVERSARY-DATE-YR > WS-REV-MTH-LST-NRML-YR           
P0613A        ADD +12 TO WS-ANNIVERSARY-DATE-MM                         
P0613A     END-IF                                                       
P0613A*                                                                         
P0613A     COMPUTE RS-MONTHS-REMAINING  = WS-ANNIVERSARY-DATE-MM -      
P0613A                                    WS-REV-MTH-LST-NRML-MM        
P0613A*                                                                         
P0613A     IF RS-MONTHS-REMAINING <= 0 OR RS-MONTHS-REMAINING > 12      
P0613A        MOVE +12 TO RS-MONTHS-REMAINING                           
P0613A     END-IF                                                       
P0613A*                                                                         
P0613A     COMPUTE RS-BBP-PYMTS-REMAINING =                             
P0613A            ( RS-MONTHS-REMAINING * RS-CURRENT-BBP-AMOUNT ).      
P0613A*                                                                         
P0613A 5000-EXIT.                                                       
P0613A     EXIT.                                                        
P0613A*                                                                         
P0613A******************************************************************        
P0613A* 5100-CALC-ACCT-BALANCE.                                        *        
P0613A******************************************************************        
P0613A 5100-CALC-ACCT-BALANCE.                                          
P0613A*                                                                         
P0613A     PERFORM 7500-OPEN-AR-CNTRL-CURSOR    THRU 7500-EXIT          
P0613A     PERFORM 7600-FETCH-AR-CNTRL-CURSOR   THRU 7600-EXIT          
P0613A     PERFORM UNTIL SQLCODE = 100                                  
P0613A     IF (AC-PYMT-PRIORITY-LVL < 50) OR                            
P0613A        (AC-PYMT-PRIORITY-LVL > 50 AND AC-ITEM-ID NOT EQUAL 0)    
P0613A        COMPUTE WS-AR-BAL-DUE = WS-AR-BAL-DUE +                   
P0613A                                AC-AMT-AR-DAY-00 +                
P0613A                                AC-AMT-AR-DAY-30 +                
P0613A                                AC-AMT-AR-DAY-60 +                
P0613A                                AC-AMT-AR-DAY-90 +                
P0613A                                AC-AMT-UNUSED-CR                  
P0613A     ELSE                                                         
P0613A         IF ( AC-PYMT-PRIORITY-LVL EQUAL 50 AND                   
P0613A              AC-ITEM-ID NOT EQUAL 0 )                            
P0613A             COMPUTE WS-BBP-BAL-DUE = WS-BBP-BAL-DUE +            
P0613A                                      AC-AMT-TRAN-BALANCE         
P0613A         END-IF                                                   
P0613A     END-IF                                                       
P0613A*                                                                         
P0613A     PERFORM 7600-FETCH-AR-CNTRL-CURSOR   THRU 7600-EXIT          
P0613A     END-PERFORM                                                  
P0613A*                                                                         
P0613A     PERFORM 7700-CLOSE-AR-CNTRL-CURSOR   THRU 7700-EXIT          
P0613A*                                                                         
P0613A     COMPUTE WS-TOTAL-BAL-DUE = WS-AR-BAL-DUE + WS-BBP-BAL-DUE.   
P0613A*                                                                         
P0613A 5100-EXIT.                                                       
P0613A     EXIT.                                                        
P0613A*                                                                         
      ******************************************************************        
      * 7000-SELECT-ACCOUNT                                            *        
      *  ***************************************************************        
                                                                        
       7000-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CODE_ACCT_STAT,                                    
                     TOTAL_AR_BALANCE,                                  
                     CODES_DATA_PRESENT,                                
                     BILL_CYCLE,                                        
                     DATE_BILL_DAY_00,                                  
                     LAST_PYMT_AMOUNT,                                  
                     LAST_PYMT_DATE,                                    
                     PREMISE_NO,                                        
                     ACCOUNT_TYPE_CODE,                                 
                     CREDIT_GROUP,                                      
C26959               COMPANY_NO,                                        
C28788               IVR_EXEMPT_CD,                                     
A02951              CODE_DISC_OK,                                       
A02951              BANKRUPTCY_IND,                                     
A02951              NOTICE_EXEMPT_CD,                                   
A02951              DATE_BILL_DAY_30,                                   
A02951              DATE_BILL_DAY_60,                                   
A02951              DATE_BILL_DAY_90,                                   
A02951              LOCAL_OFFICE,                                       
P00613              JUDGEMENT_IND,                                      
P0613A              REV_MTH_LST_NRML                                    
              INTO  :AT-CODE-ACCT-STAT,                                 
                    :AT-TOTAL-AR-BALANCE,                               
                    :AT-CODES-DATA-PRESENT,                             
                    :AT-BILL-CYCLE,                                     
                    :AT-DATE-BILL-DAY-00 :WS-DATE-BILL-00-IND,           
                    :AT-LAST-PYMT-AMOUNT,                               
                    :AT-LAST-PYMT-DATE :WS-LAST-PAYMENT-DATE-IND,        
                    :AT-PREMISE-NO,                                     
                    :AT-ACCOUNT-TYPE-CODE,                              
                    :AT-CREDIT-GROUP,                                   
C26959              :AT-COMPANY-NO,                                     
C28788              :AT-IVR-EXEMPT-CD,                                  
A02951              :AT-CODE-DISC-OK,                                   
A02951              :AT-BANKRUPTCY-IND,                                 
A02951              :AT-NOTICE-EXEMPT-CD,                               
A02951              :AT-DATE-BILL-DAY-30 :WS-DATE-BILL-30-IND,           
A02951              :AT-DATE-BILL-DAY-60 :WS-DATE-BILL-60-IND,           
A02951              :AT-DATE-BILL-DAY-90 :WS-DATE-BILL-90-IND,           
A02951              :AT-LOCAL-OFFICE,                                   
P00613              :AT-JUDGEMENT-IND,                                  
P0613A              :AT-REV-MTH-LST-NRML                                
              FROM   CSS_ACCOUNT                                        
              WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-CURRENT-DATE                                          *        
      ******************************************************************        
                                                                        
       7010-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
              SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE =  SUCCESSFUL-CALL OR NOT-FOUND     
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7010'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
              MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
              MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
A02951*                                                                         
A02951***************************************************************** *       
A02951* 7030-CHECK-PEND-FLAG.                                         *         
A02951***************************************************************** *       
A02951*                                                                         
A02951 7030-CHECK-PEND-FLAG.                                            
A02951*                                                                         
A02951     EXEC SQL                                                     
A02951         SELECT TOP(1) 'Y'                                               
A02951           INTO :WS-PENDING-FLAG                                  
A02951           FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
A02951          WHERE PREMISE_NO = :VO-PREMISE-NO                       
A02951            AND ORDER_STATE_CD IN ('A', 'H', 'D', 'B','R')        
A02951                                           
A02951                                                           
A02951                                                      
A02951     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-PENDING-FLAG                                          
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO = :VO-PREMISE-NO                               
MFA-TR*           AND ORDER_STATE_CD IN ('A', 'H', 'D', 'B','R')                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02951                                                                  
A02951     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
A02951                                                                  
A02951     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02951         WHEN SUCCESSFUL-CALL                                     
A02951             CONTINUE                                             
A02951         WHEN NOT-FOUND                                           
A02951             MOVE 'N'                TO WS-PENDING-FLAG           
A02951         WHEN OTHER                                               
A02951              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
A02951              MOVE '7030'             TO ACTIVE-PARAGRAPH         
A02951              MOVE 'SELECT'           TO ABEND-FUNCTION           
A02951              MOVE 'CSS_SO_DATA'      TO TABLE-1                  
A02951              MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1          
A02951              MOVE WS-PREMISE-NO-NUM  TO HOSTVAR-ELEMENT-1        
A02951              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
A02951              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
A02951     END-EVALUATE.                                                
A02951                                                                  
A02951*                                                                         
A02951 7030-EXIT.                                                       
A02951     EXIT.                                                        
A02951*                                                                         
A02951***************************************************************** *       
A02951* 7040-CHECK-DNP-ACCT-FLAG.                                     *         
A02951***************************************************************** *       
A02951*                                                                         
A02951 7040-CHECK-DNP-ACCT-FLAG.                                        
A02951*                                                                         
A02951     EXEC SQL                                                     
A02951          SELECT TOP(1) 'F'                                              
A02951            INTO :WS-DNP-FLAG                                     
A02951            FROM CSS_SO_DATA WITH(READUNCOMMITTED)                        
A02951           WHERE ACCOUNT_NO_PRIOR = :WS-ACCOUNT-NO-NUM            
A02951             AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')       
A02951             AND ORDER_TYPE_CD = 'FM006'                          
A02951                                           
A02951                                                           
A02951                                                      
A02951     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT 'F'                                                      
MFA-TR*           INTO :WS-DNP-FLAG                                             
MFA-TR*           FROM CSS_SO_DATA                                              
MFA-TR*          WHERE ACCOUNT_NO_PRIOR = :WS-ACCOUNT-NO-NUM                    
MFA-TR*            AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')               
MFA-TR*            AND ORDER_TYPE_CD = 'FM006'                                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*         QUERYNO 7040                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02951                                                                  
A02951     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
A02951                                                                  
A02951     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02951          WHEN SUCCESSFUL-CALL                                    
A02951              CONTINUE                                            
A02951          WHEN NOT-FOUND                                          
A02951              MOVE 'N'             TO WS-DNP-FLAG                 
A02951          WHEN OTHER                                              
A02951              MOVE PROGRAM-NAME       TO ABEND-PROGRAM            
A02951              MOVE '7040'             TO ACTIVE-PARAGRAPH         
A02951              MOVE 'SELECT'           TO ABEND-FUNCTION           
A02951              MOVE 'CSS_SO_DATA'      TO TABLE-1                  
A02951              MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1          
A02951              MOVE WS-ACCOUNT-NO-NUM  TO HOSTVAR-ELEMENT-1        
A02951              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
A02951              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
A02951     END-EVALUATE.                                                
A02951*                                                                         
A02951 7040-EXIT.                                                       
A02951     EXIT.                                                        
A02951*                                                                         
A02951***************************************************************** *       
A02951* 7050-CHECK-DNP-PREM-FLAG.                                     *         
A02951***************************************************************** *       
A02951*                                                                         
A02951 7050-CHECK-DNP-PREM-FLAG.                                        
A02951*                                                                         
A02951     EXEC SQL                                                     
A02951         SELECT TOP(1) 'Y'                                               
A02951           INTO :WS-DNP-FLAG                                      
A02951           FROM CSS_SO_DATA WITH(READUNCOMMITTED)                         
A02951          WHERE PREMISE_NO =  :VO-PREMISE-NO                      
A02951            AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')        
A02951            AND ORDER_TYPE_CD = 'DNP01'                           
A02951                                           
A02951                                                           
A02951                                                      
A02951     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :WS-DNP-FLAG                                              
MFA-TR*          FROM CSS_SO_DATA                                               
MFA-TR*         WHERE PREMISE_NO =  :VO-PREMISE-NO                              
MFA-TR*           AND ORDER_STATE_CD IN ('A', 'H', 'B', 'D','R')                
MFA-TR*           AND ORDER_TYPE_CD = 'DNP01'                                   
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7050                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02951                                                                  
A02951     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
A02951                                                                  
A02951     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02951         WHEN SUCCESSFUL-CALL                                     
A02951             CONTINUE                                             
A02951         WHEN NOT-FOUND                                           
A02951             MOVE 'N'             TO WS-DNP-FLAG                  
A02951         WHEN OTHER                                               
A02951             MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
A02951             MOVE '7050'             TO ACTIVE-PARAGRAPH          
A02951             MOVE 'SELECT'           TO ABEND-FUNCTION            
A02951             MOVE 'CSS_SO_DATA'      TO TABLE-1                   
A02951             MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
A02951             MOVE WS-PREMISE-NO-NUM  TO HOSTVAR-ELEMENT-1         
A02951             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A02951             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A02951     END-EVALUATE.                                                
A02951*                                                                         
A02951 7050-EXIT.                                                       
A02951     EXIT.                                                        
A02951*                                                                         
      ******************************************************************        
      * 7060-SELECT-PREMISE                                            *        
      *     DETERMINE IF GAS, ELECTRIC, AND LIGHTING SERVICE IS ACTIVE *        
      ******************************************************************        
                                                                        
       7060-SELECT-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO,                                        
                     SPCL_READ_INSTR,                                   
                     GAS_AVAILABLE_IND,                                 
                     ELEC_AVAILABLE_IND,                                
                     LITE_AVAILABLE_IND,                                
                     CODE_RENTAL_PROP                                   
              INTO  :PR-PREMISE-NO,                                     
                    :PR-SPCL-READ-INSTR,                                
                    :PR-GAS-AVAILABLE-IND,                              
                    :PR-ELEC-AVAILABLE-IND,                             
                    :PR-LITE-AVAILABLE-IND,                             
                    :PR-CODE-RENTAL-PROP                                
              FROM   CSS_PREMISE                                        
              WHERE  PREMISE_NO = :PR-PREMISE-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7060'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_PREMISE'        TO TABLE-1                      
              MOVE 'PREMISE_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
              MOVE PR-PREMISE-NO        TO HOSTVAR-ELEMENT-1            
CBSI          MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7070-SELECT-AR-TRANS-HIST                                      *        
      ******************************************************************        
      *                                                                         
       7070-SELECT-AR-TRANS-HIST.                                       
                                                                        
           EXEC SQL                                                     
              SELECT SUM(AMT_BILLED_UNPAID)                             
              INTO  :AR-AMT-BILLED-UNPAID :WS-NULL-IND-3                 
              FROM   CSS_AR_TRANS_HIST                                  
              WHERE  ACCOUNT_NO   = :WS-ACCOUNT-NO-NUM                  
              AND    DATE_TRANS   = IIF(TRY_CONVERT(DATE, 
                                                   :AT-DATE-BILL-DAY-00
              ) IS NULL OR (PATINDEX('%.%', :AT-DATE-BILL-DAY-00
              ) <> 0) OR (LEN(:AT-DATE-BILL-DAY-00
              ) <> 10), CIS.CHAR2DATE(:AT-DATE-BILL-DAY-00
              ), CONVERT(DATE, :AT-DATE-BILL-DAY-00) )                
              AND    CODE_TRAN_TYPE = 'B'                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_BILLED_UNPAID)                                     
MFA-TR*       INTO  :AR-AMT-BILLED-UNPAID:WS-NULL-IND-3                         
MFA-TR*       FROM   CSS_AR_TRANS_HIST                                          
MFA-TR*       WHERE  ACCOUNT_NO   = :WS-ACCOUNT-NO-NUM                          
MFA-TR*       AND    DATE_TRANS   = :AT-DATE-BILL-DAY-00                        
MFA-TR*       AND    CODE_TRAN_TYPE = 'B'                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              IF WS-NULL-IND-3 < 0                                      
                 MOVE 0 TO AR-AMT-BILLED-UNPAID                         
              END-IF                                                    
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '7070'          TO ACTIVE-PARAGRAPH                  
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_AR_TRANS_HIST'     TO TABLE-1                   
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE 'DATE_TRANS'         TO TABLE-ELEMENT-2              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
CBSI          MOVE AT-DATE-BILL-DAY-00  TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00505******************************************************************        
P00505* 7080-CHECK-ENERGYWISE-FLAG.                                             
P00505******************************************************************        
P00505*                                                                         
P00505 7080-CHECK-ENERGYWISE-FLAG.                                      
P00505                                                                  
P00505     EXEC SQL                                                     
P00505        SELECT TOP(1) 'Y'                                                
P00505          INTO :WS-EXISTS-FLAG                                    
P00505          FROM CSS_DSM_PGM_ACCT PN WITH(READUNCOMMITTED)                  
P00505         WHERE ACCOUNT_NO         = :PN-ACCOUNT-NO                
P00505           AND COMPANY_NO         = :PN-COMPANY-NO                
P00505           AND DSM_ACCT_STATUS_CD = 'A'                           
P00505           AND DSM_PGM_CD         = 'DSM999'                      
P00505                                              
P00505                                                           
P00505                                                      
P00505     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*         INTO :WS-EXISTS-FLAG                                            
MFA-TR*         FROM CSS_DSM_PGM_ACCT PN                                        
MFA-TR*        WHERE ACCOUNT_NO         = :PN-ACCOUNT-NO                        
MFA-TR*          AND COMPANY_NO         = :PN-COMPANY-NO                        
MFA-TR*          AND DSM_ACCT_STATUS_CD = 'A'                                   
MFA-TR*          AND DSM_PGM_CD         = 'DSM999'                              
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7080                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00505                                                                  
P00505     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00505                                                                  
P00505     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00505        CONTINUE                                                  
P00505     ELSE                                                         
P00505        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00505        MOVE '7080'                   TO ACTIVE-PARAGRAPH         
P00505        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00505        MOVE 'CSS_DSM_PGM_ACCT '      TO TABLE-1                  
P00505        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00505        MOVE 'DSM_PGM_CD'             TO TABLE-ELEMENT-2          
P00505        MOVE PN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00505        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P00505        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P00505     END-IF.                                                      
P00505                                                                  
P00505 7080-EXIT.                                                       
P00505     EXIT.                                                        
P00505                                                                  
P00508*                                                                         
P00508******************************************************************        
P00508* 7090-CHK-MDM-FLAGS.                                                     
P00508******************************************************************        
P00508*                                                                         
P00508 7090-CHK-MDM-FLAGS.                                              
P00508*                                                                         
P00508     EXEC SQL                                                     
P00508        SELECT TOP(1) 'Y',
              MN.METER_NO                                        
P00508          INTO :WS-EXISTS-FLAG                                    
P00508              ,:MN-METER-NO                                       
P00508          FROM CSS_MTRD_ENVRNMT MN WITH(READUNCOMMITTED)                  
P00508         WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                
P00508           AND CODE_UTIL_TYPE     = 'E'                           
A04200           AND CODE_METER_STATUS  IN ('A','I')                    
PRJ914           AND MTR_READ_SOURCE_CD IN ('R','M','P')                
P00508         ORDER BY METER_NO                                        
P00508                                              
P00508                                                           
P00508                                                      
P00508     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT 'Y'                                                        
MFA-TR*             ,MN.METER_NO                                                
MFA-TR*         INTO :WS-EXISTS-FLAG                                            
MFA-TR*             ,:MN-METER-NO                                               
MFA-TR*         FROM CSS_MTRD_ENVRNMT MN                                        
MFA-TR*        WHERE ACCOUNT_NO         = :MN-ACCOUNT-NO                        
MFA-TR*          AND CODE_UTIL_TYPE     = 'E'                                   
MFA-TR*          AND CODE_METER_STATUS  IN ('A','I')                            
MFA-TR*          AND MTR_READ_SOURCE_CD IN ('R','M','P')                        
MFA-TR*        ORDER BY METER_NO                                                
MFA-TR*        FETCH FIRST ROW ONLY                                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7090                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00508*                                                                         
P00508     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00508*                                                                         
P00508     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00508        CONTINUE                                                  
P00508     ELSE                                                         
P00508        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00508        MOVE '7090'                   TO ACTIVE-PARAGRAPH         
P00508        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00508        MOVE 'CSS_MTRD_ENVRNMT '      TO TABLE-1                  
P00508        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00508        MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00508        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P00508        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P00508     END-IF.                                                      
P00508*                                                                         
P00508 7090-EXIT.                                                       
P00508     EXIT.                                                        
P00508*                                                                         
P00508******************************************************************        
P00508* 7100-GET-ACCT-ATTR.                                                     
P00508******************************************************************        
P00508*                                                                         
P00508 7100-GET-ACCT-ATTR.                                              
P00508*                                                                         
P00508     EXEC SQL                                                     
P00508       SELECT                                                     
P00508              'Y'                                                 
P00508         INTO                                                     
P00508              :WS-EXISTS-FLAG                                     
P00508         FROM                                                     
P00508              CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
P00508        WHERE                                                     
P00508              ACCOUNT_NO         = :YP-ACCOUNT-NO                 
P00508          AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC             
P00508          AND ATTRIBUTE_VALUE_CD = 'YES'                          
P00508          AND STATUS_CD          = 'A'                            
P00508                                                      
P00508                                                           
P00508     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT                                                             
MFA-TR*             'Y'                                                         
MFA-TR*        INTO                                                             
MFA-TR*             :WS-EXISTS-FLAG                                             
MFA-TR*        FROM                                                             
MFA-TR*             CSS_ACCT_ATTRIBUTE                                          
MFA-TR*       WHERE                                                             
MFA-TR*             ACCOUNT_NO         = :YP-ACCOUNT-NO                         
MFA-TR*         AND ATTRIBUTE_DESC     = :YP-ATTRIBUTE-DESC                     
MFA-TR*         AND ATTRIBUTE_VALUE_CD = 'YES'                                  
MFA-TR*         AND STATUS_CD          = 'A'                                    
MFA-TR*     QUERYNO 7100                                                        
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00508*                                                                         
P00508     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00508*                                                                         
P00508     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00508        CONTINUE                                                  
P00508     ELSE                                                         
P00508        MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
P00508        MOVE '7100'                   TO ACTIVE-PARAGRAPH         
P00508        MOVE 'SELECT'                 TO ABEND-FUNCTION           
P00508        MOVE 'CSS_ACCT_ATTRIBUTE'     TO TABLE-1                  
P00508        MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
P00508        MOVE MN-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
P00508        MOVE 'ATTRIBUTE_DESC'         TO TABLE-ELEMENT-2          
P00508        MOVE YP-ATTRIBUTE-DESC        TO HOSTVAR-ELEMENT-2        
P00508        PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT         
P00508        PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT         
P00508     END-IF.                                                      
P00508*                                                                         
P00508 7100-EXIT.                                                       
P00508     EXIT.                                                        
P00508*                                                                         
P00613******************************************************************        
P00613* 7350-GET-CREDIT-PROFILE.                                       *        
P00613******************************************************************        
P00613 7350-GET-CREDIT-PROFILE.                                         
P00613     EXEC SQL                                                     
P00613        SELECT CASH_ONLY_FL                                       
P00613          INTO :CZ-CASH-ONLY-FL                                   
P00613          FROM CSS_CREDIT_PROFILE WITH(READUNCOMMITTED)                   
P00613         WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                        
P00613                                                           
P00613                                                      
P00613     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CASH_ONLY_FL                                               
MFA-TR*         INTO :CZ-CASH-ONLY-FL                                           
MFA-TR*         FROM CSS_CREDIT_PROFILE                                         
MFA-TR*        WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                                
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7350                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00613                                                                  
P00613     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00613     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00613        CONTINUE                                                  
P00613     ELSE                                                         
P00613        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P00613        MOVE '7350'               TO ACTIVE-PARAGRAPH             
P00613        MOVE 'SELECT'             TO ABEND-FUNCTION               
P00613        MOVE 'CSS_CREDIT_PROFILE' TO TABLE-1                      
P00613        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P00613        MOVE cz-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1            
P00613        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00613        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00613     END-IF.                                                      
P00613 7350-EXIT.                                                       
P00613     EXIT.                                                        
P00613*                                                                         
P00613******************************************************************        
P00613* 7400-ARCNTL-RET-CHECK.                                         *        
P00613******************************************************************        
P00613 7400-ARCNTL-RET-CHECK.                                           
P00613     EXEC SQL                                                     
P00613        SELECT SUM(AMT_AR_DAY_00),                                
P00613               SUM(AMT_AR_DAY_30),                                
P00613               SUM(AMT_AR_DAY_60),                                
P00613               SUM(AMT_AR_DAY_90)                                 
P00613          INTO :AC-AMT-AR-DAY-00 :WS-NULL-IND-00,                 
P00613               :AC-AMT-AR-DAY-30 :WS-NULL-IND-30,                 
P00613               :AC-AMT-AR-DAY-60 :WS-NULL-IND-60,                 
P00613               :AC-AMT-AR-DAY-90 :WS-NULL-IND-90                  
P00613          FROM CSS_AR_CNTL WITH(READUNCOMMITTED)                          
P00613         WHERE ACCOUNT_NO      = :AC-ACCOUNT-NO                   
P00613           AND PYMT_PRIORITY_LVL IN (020, 029)                    
P00613                                                           
P00613                                                      
P00613     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT SUM(AMT_AR_DAY_00),                                        
MFA-TR*              SUM(AMT_AR_DAY_30),                                        
MFA-TR*              SUM(AMT_AR_DAY_60),                                        
MFA-TR*              SUM(AMT_AR_DAY_90)                                         
MFA-TR*         INTO :AC-AMT-AR-DAY-00 :WS-NULL-IND-00,                         
MFA-TR*              :AC-AMT-AR-DAY-30 :WS-NULL-IND-30,                         
MFA-TR*              :AC-AMT-AR-DAY-60 :WS-NULL-IND-60,                         
MFA-TR*              :AC-AMT-AR-DAY-90 :WS-NULL-IND-90                          
MFA-TR*         FROM CSS_AR_CNTL                                                
MFA-TR*        WHERE ACCOUNT_NO      = :AC-ACCOUNT-NO                           
MFA-TR*          AND PYMT_PRIORITY_LVL IN (020, 029)                            
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7400                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00613                                                                  
P00613     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE            
P00613     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00613        WHEN SUCCESSFUL-CALL                                      
P00613           IF WS-NULL-IND-00 < 0                                  
P00613              MOVE 0.00 TO AC-AMT-AR-DAY-00                       
P00613           END-IF                                                 
P00613           IF WS-NULL-IND-30 < 0                                  
P00613              MOVE 0.00 TO AC-AMT-AR-DAY-30                       
P00613           END-IF                                                 
P00613           IF WS-NULL-IND-60 < 0                                  
P00613              MOVE 0.00 TO AC-AMT-AR-DAY-60                       
P00613           END-IF                                                 
P00613           IF WS-NULL-IND-90 < 0                                  
P00613              MOVE 0.00 TO AC-AMT-AR-DAY-90                       
P00613           END-IF                                                 
P00613           IF AC-AMT-AR-DAY-00 > 0 OR AC-AMT-AR-DAY-30 > 0 OR     
P00613                  AC-AMT-AR-DAY-60 > 0 OR AC-AMT-AR-DAY-90 > 0    
P00613              MOVE 'Y'               TO WS-ACTIVE-RETURN-CHECK    
P00613           END-IF                                                 
P00613        WHEN NOT-FOUND                                            
P00613           MOVE 'N'                  TO WS-ACTIVE-RETURN-CHECK    
P00613        WHEN OTHER                                                
P00613           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
P00613           MOVE '7400'               TO ACTIVE-PARAGRAPH          
P00613           MOVE 'SELECT'             TO ABEND-FUNCTION            
P00613           MOVE 'CSS_AR_CNTL'        TO TABLE-1                   
P00613           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
P00613           MOVE AC-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
P00613           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
P00613           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
P00613     END-EVALUATE.                                                
P00613                                                                  
P00613 7400-EXIT.                                                       
P00613     EXIT.                                                        
P00613*                                                                         
P00613******************************************************************        
P00613* 7440-SELECT-NSF-HIST.                                          *        
P00613******************************************************************        
P00613 7440-SELECT-NSF-HIST.                                            
P00613*                                                                         
P00613     EXEC SQL                                                     
P00613        SELECT
              DATEADD( YEAR, -1, IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) ) )
            INTO
              :WS-YEAR-AGO-DATE                                  
P00613     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       VALUES (DATE(:WS-CURRENT-DATE) - 1 YEAR)                          
MFA-TR*         INTO :WS-YEAR-AGO-DATE                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00613*                                                                         
P00613     EXEC SQL                                                     
P00613        SELECT TOP(1) ACCOUNT_NO                                         
P00613          INTO :NH-ACCOUNT-NO                                     
P00613          FROM CSS_NSF_HIST WITH(READUNCOMMITTED)                         
P00613         WHERE ACCOUNT_NO =:WS-ACCOUNT-NO-NUM                     
P00613           AND DATE_TRAN  >IIF(TRY_CONVERT(DATE, :WS-YEAR-AGO-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-YEAR-AGO-DATE
              ) <> 0) OR (LEN(:WS-YEAR-AGO-DATE) <> 10), CIS.CHAR2DATE(
                                                      :WS-YEAR-AGO-DATE
              ), CONVERT(DATE, :WS-YEAR-AGO-DATE) )                      
P00613           AND NSF_STATUS_CD IN ('C','F')                         
P00613                                                           
P00613                                            
P00613                                                      
P00613     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ACCOUNT_NO                                                 
MFA-TR*         INTO :NH-ACCOUNT-NO                                             
MFA-TR*         FROM CSS_NSF_HIST                                               
MFA-TR*        WHERE ACCOUNT_NO =:WS-ACCOUNT-NO-NUM                             
MFA-TR*          AND DATE_TRAN  >:WS-YEAR-AGO-DATE                              
MFA-TR*          AND NSF_STATUS_CD IN ('C','F')                                 
MFA-TR*         WITH UR                                                         
MFA-TR*        FETCH FIRST 1 ROW ONLY                                           
MFA-TR*        QUERYNO 7440                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00613                                                                  
P00613     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00613     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00613        WHEN SUCCESSFUL-CALL                                      
P00613           MOVE 'Y'                  TO RS-RETURN-CHECK           
P00613        WHEN NOT-FOUND                                            
P00613           MOVE 'N'                  TO RS-RETURN-CHECK           
P00613        WHEN OTHER                                                
P00613           MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
P00613           MOVE '7440'               TO ACTIVE-PARAGRAPH          
P00613           MOVE 'SELECT'             TO ABEND-FUNCTION            
P00613           MOVE 'CSS_NSF-HIST'       TO TABLE-1                   
P00613           MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
P00613           MOVE NH-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
P00613           PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
P00613           PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
P00613     END-EVALUATE.                                                
P00613                                                                  
P00613 7440-EXIT.                                                       
P00613     EXIT.                                                        
P00613*                                                                         
P0613A*                                                                         
P0613A******************************************************************        
P0613A* 7450-SELECT-BUDGET-PLAN                                        *        
P0613A* BUDGET BILLING PLAN DETAILS                                    *        
P0613A******************************************************************        
P0613A 7450-SELECT-BUDGET-PLAN.                                         
P0613A*                                                                         
P0613A     EXEC SQL                                                     
P0613A        SELECT AMT_MO_PYMT                 ,                      
P0613A               ANNIVERSARY_DATE            ,                      
P0613A               AMT_MO_PYMT_NEW                                    
P0613A          INTO :BU-AMT-MO-PYMT             ,                      
P0613A               :BU-ANNIVERSARY-DATE        ,                      
P0613A               :BU-AMT-MO-PYMT-NEW                                
P0613A          FROM CSS_BUDGET_PLAN WITH(READUNCOMMITTED)                      
P0613A         WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                 
P0613A           AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL          
P0613A           AND BP_ITEM_ID        = :BU-BP-ITEM-ID                 
P0613A                                                           
P0613A     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_MO_PYMT                 ,                              
MFA-TR*              ANNIVERSARY_DATE            ,                              
MFA-TR*              AMT_MO_PYMT_NEW                                            
MFA-TR*         INTO :BU-AMT-MO-PYMT             ,                              
MFA-TR*              :BU-ANNIVERSARY-DATE        ,                              
MFA-TR*              :BU-AMT-MO-PYMT-NEW                                        
MFA-TR*         FROM CSS_BUDGET_PLAN                                            
MFA-TR*        WHERE ACCOUNT_NO        = :BU-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :BU-PYMT-PRIORITY-LVL                  
MFA-TR*          AND BP_ITEM_ID        = :BU-BP-ITEM-ID                         
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0613A*                                                                         
P0613A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P0613A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P0613A        IF WS-ACTIVE-RETURN-CODE  EQUAL NOT-FOUND                 
P0613A           MOVE ZEROS                TO BU-AMT-MO-PYMT            
P0613A                                        BU-AMT-MO-PYMT-NEW        
P0613A           MOVE SPACES               TO BU-ANNIVERSARY-DATE       
P0613A        END-IF                                                    
P0613A        CONTINUE                                                  
P0613A     ELSE                                                         
P0613A        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
P0613A        MOVE '7450'               TO ACTIVE-PARAGRAPH             
P0613A        MOVE 'SELECT'             TO ABEND-FUNCTION               
P0613A        MOVE 'CSS_BUDGET_PLAN'    TO TABLE-1                      
P0613A        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
P0613A        MOVE 'PYMT_PRIORITY_LVL'  TO TABLE-ELEMENT-2              
P0613A        MOVE 'BP_ITEM_ID'         TO TABLE-ELEMENT-3              
P0613A        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
P0613A        MOVE BU-PYMT-PRIORITY-LVL TO HOSTVAR-ELEMENT-2            
P0613A        MOVE BU-BP-ITEM-ID        TO HOSTVAR-ELEMENT-3            
P0613A        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P0613A        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P0613A     END-IF.                                                      
P0613A*                                                                         
P0613A 7450-EXIT.                                                       
P0613A     EXIT.                                                        
P0613A*                                                                         
P0613A******************************************************************        
P0613A* 7500-OPEN-AR-CNTRL-CURSOR                                      *        
P0613A******************************************************************        
P0613A 7500-OPEN-AR-CNTRL-CURSOR.                                       
P0613A*                                                                         
P0613A     MOVE WS-ACCOUNT-NO-NUM        TO AC-ACCOUNT-NO.              
P0613A*                                                                         
P0613A     EXEC SQL                                                     
P0613A          OPEN AR_CNTL_CURSOR                                     
P0613A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0613A*                                                                         
P0613A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0613A                     RS-RETURN-CODE.                              
P0613A*                                                                         
P0613A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0613A        NEXT SENTENCE                                             
P0613A     ELSE                                                         
P0613A        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P0613A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0613A        MOVE '7500'                TO ACTIVE-PARAGRAPH            
P0613A        MOVE 'OPEN'                TO ABEND-FUNCTION              
P0613A        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P0613A                                      ABEND-TABLES                
P0613A        MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
P0613A        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0613A        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
P0613A        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
P0613A        MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0613A        MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
P0613A        MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
P0613A        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P0613A        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
P0613A*                                                                         
P0613A 7500-EXIT.                                                       
P0613A     EXIT.                                                        
P0613A*                                                                         
P0613A******************************************************************        
P0613A* 7600-FETCH-AR-CNTRL-CURSOR                                     *        
P0613A******************************************************************        
P0613A 7600-FETCH-AR-CNTRL-CURSOR.                                      
P0613A*                                                                         
P0613A     EXEC SQL                                                     
P0613A          FETCH  AR_CNTL_CURSOR                                   
P0613A          INTO  :AC-AMT-AR-DAY-00,                                
P0613A                :AC-AMT-AR-DAY-30,                                
P0613A                :AC-AMT-AR-DAY-60,                                
P0613A                :AC-AMT-AR-DAY-90,                                
P0613A                :AC-AMT-UNUSED-CR,                                
P0613A                :AC-AMT-TRAN-BALANCE,                             
P0613A                :AC-TOT-SUMM-UNBILLED,                            
P0613A                :AC-PYMT-PRIORITY-LVL,                            
P0613A                :AC-ITEM-ID                                       
P0613A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0613A*                                                                         
P0613A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0613A                     RS-RETURN-CODE.                              
P0613A*                                                                         
P0613A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0613A     OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
P0613A        NEXT SENTENCE                                             
P0613A     ELSE                                                         
P0613A        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P0613A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0613A        MOVE '7600'                TO ACTIVE-PARAGRAPH            
P0613A        MOVE 'FETCH'               TO ABEND-FUNCTION              
P0613A        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P0613A                                      ABEND-TABLES                
P0613A        MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
P0613A        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0613A        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
P0613A        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
P0613A        MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0613A        MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
P0613A        MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
P0613A        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P0613A        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
P0613A*                                                                         
P0613A 7600-EXIT.                                                       
P0613A     EXIT.                                                        
P0613A*                                                                         
P0613A******************************************************************        
P0613A* 7700-CLOSE-AR-CNTRL-CURSOR.                                    *        
P0613A******************************************************************        
P0613A 7700-CLOSE-AR-CNTRL-CURSOR.                                      
P0613A*                                                                         
P0613A     EXEC SQL                                                     
P0613A          CLOSE AR_CNTL_CURSOR                                    
P0613A     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P0613A*                                                                         
P0613A     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
P0613A                     RS-RETURN-CODE.                              
P0613A*                                                                         
P0613A     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P0613A        NEXT SENTENCE                                             
P0613A     ELSE                                                         
P0613A        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P0613A        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P0613A        MOVE '7700'                TO ACTIVE-PARAGRAPH            
P0613A        MOVE 'CLOSE'               TO ABEND-FUNCTION              
P0613A        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P0613A                                      ABEND-TABLES                
P0613A        MOVE 'CSS_AR_CNTL'         TO TABLE-1                     
P0613A        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P0613A        MOVE 'PYMT_PRIORITY_LVL'   TO TABLE-ELEMENT-2             
P0613A        MOVE 'ITEM_ID'             TO TABLE-ELEMENT-3             
P0613A        MOVE AC-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P0613A        MOVE AC-PYMT-PRIORITY-LVL  TO HOSTVAR-ELEMENT-2           
P0613A        MOVE AC-ITEM-ID            TO HOSTVAR-ELEMENT-3           
P0613A        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P0613A        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.            
P0613A*                                                                         
P0613A 7700-EXIT.                                                       
P0613A     EXIT.                                                        
P00613*                                                                         
A04880*                                                                         
A04880******************************************************************        
A04880* 7800-SELECT-CONTRACT-STATUS                                    *        
A04880* SELECT CONTRACT STATUS                                         *        
A04880******************************************************************        
A04880 7800-SELECT-CONTRACT-STATUS.                                     
A04880*                                                                         
A04880     EXEC SQL                                                     
A04880        SELECT TOP(1) CNT_STATUS_CD                                      
A04880          INTO :CT-CNT-STATUS-CD                                  
A04880          FROM CSS_CONTRACT CT WITH(READUNCOMMITTED)                      
A04880         WHERE CT.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM          
A04880           AND CT.CNT_NAME_CD       = :WS-701                     
A04880         ORDER BY  DATE_CONTRACT DESC                             
A04800                                           
A04880                                                           
A04880                                                      
A04880     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CNT_STATUS_CD                                              
MFA-TR*         INTO :CT-CNT-STATUS-CD                                          
MFA-TR*         FROM CSS_CONTRACT CT                                            
MFA-TR*        WHERE CT.ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM                  
MFA-TR*          AND CT.CNT_NAME_CD       = :WS-701                             
MFA-TR*        ORDER BY  DATE_CONTRACT DESC                                     
MFA-TR*        FETCH FIRST 1 ROWS ONLY                                          
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7800                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A04880*                                                                         
A04880     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A04880     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A04880        CONTINUE                                                  
A04880     ELSE                                                         
A04880        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
A04880        MOVE '7800'               TO ACTIVE-PARAGRAPH             
A04880        MOVE 'SELECT'             TO ABEND-FUNCTION               
A04880        MOVE 'CSS_CONTRACT'       TO TABLE-1                      
A04880        MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
A04880        MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
A04880        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A04880        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A04880     END-IF.                                                      
A04880*                                                                         
A04880 7800-EXIT.                                                       
A04880     EXIT.                                                        
A04880*                                                                         
      ******************************************************************        
      * 7950-SELECT-BILL                                               *        
      ******************************************************************        
                                                                        
       7950-SELECT-BILL.                                                
                                                                        
           EXEC SQL                                                     
              SELECT COUNT(*)                                           
              INTO  :WS-BILL-COUNT                                      
              FROM   CSS_BILLING_HDR                                    
              WHERE  ACCOUNT_NO  = :WS-ACCOUNT-NO-NUM                   
                AND  DATE_BILLED IS NOT NULL                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
              MOVE '7950'               TO ACTIVE-PARAGRAPH             
              MOVE 'SELECT'             TO ABEND-FUNCTION               
              MOVE 'CSS_BILLING_HDR'    TO TABLE-1                      
              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
              MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7999-FINAL-BILL-AMT                                            *        
      ******************************************************************        
                                                                        
       7999-FINAL-BILL-AMT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT FINAL_BILL_AM,                                     
                     COLLECT_STATUS_CD                                  
              INTO  :FW-FINAL-BILL-AM,                                  
                    :FW-COLLECT-STATUS-CD                               
              FROM   CSS_FINAL_WO                                       
              WHERE  ACCOUNT_NO = :WS-ACCOUNT-NO-NUM                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE 0                    TO FW-FINAL-BILL-AM          
P00613           MOVE SPACES TO FW-COLLECT-STATUS-CD                    
              ELSE                                                      
                 MOVE PROGRAM-NAME         TO ABEND-PROGRAM             
                 MOVE '7999'               TO ACTIVE-PARAGRAPH          
                 MOVE 'SELECT'             TO ABEND-FUNCTION            
                 MOVE 'CSS_FINAL_WO'       TO TABLE-1                   
                 MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1           
                 MOVE WS-ACCOUNT-NO-NUM    TO HOSTVAR-ELEMENT-1         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       7999-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9500-CALL-CPD00068                                             *        
      ******************************************************************        
                                                                        
       9500-CALL-CPD00068.                                              
                                                                        
                                                                        
REARCH          CALL MCSCB068 USING  CWS00068-FIELDS,                   
CVT000                               WS-CODES-DATA-PRESENT,             
CVT000                               DCLCSS-ACCOUNT,                    
CVT000                               ABEND-FILE,                        
CVT000                               RS-RETURN-CODE.                    
REARCH     MOVE RS-RETURN-CODE    TO WS-ACTIVE-RETURN-CODE,             
REARCH                               S-RETURN-CODE.                     
REARCH     IF ABEND-FUNCTION  > SPACES                                  
REARCH         IF ABEND-FUNCTION EQUAL 'BADDATA'                        
REARCH            MOVE -1                  TO WS-ACTIVE-RETURN-CODE,    
REARCH                                        S-RETURN-CODE             
REARCH         END-IF                                                   
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
REARCH         PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT             
REARCH     END-IF.                                                      
                                                                        
       9500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5901-NEXT-READ-DATE                                            *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00310                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700-PROCESS-ABEND                                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
