000100 IDENTIFICATION DIVISION.                                         
000200 PROGRAM-ID. CSR02417.                                            
000210 DATE-WRITTEN. 08/20/99.                                          
000220 DATE-COMPILED.                                                   
000230                                                                  
000240******************************************************************00060000
000250*                                                                *00070000
000260*                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
000270*                                                                *00090000
000280*  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
000290*                                                                *00110000
000300*  TRANID:        S417                                           *00120000
000400*  PROGRAM:       S417                                           *00130000
000500*  CALLING SP:    PA_S417                                        *00140000
000600*                                                                *00150000
000700******************************************************************00160000
000800*                 P R O G R A M  S U M M A R Y                   *00170000
000900*                                                                *00180000
001000*  THIS PROCEDURE IS USED TO SELECT AN ACCOUNT. THE USER ENTERS  *00190000
001100*  A VARIETY OF SEARCH CRITERIA AND MATCHING DATA IS RETURNED.   *00200000
      *    THIS PROGRAM IS CALLED BY THE FOLLOWING:                    *        
      *    PANEL004, PANEL467                                          *        
001200*                                                                *00210000
001300******************************************************************00220000
001400*                                                                *00230000
001500*                     PROGRAM MODIFICATION LOG                   *00240000
001600*                                                                *00250000
001700*    DATE    INITIALS   COMMENTS                                 *00260000
001800*  --------  --------   ---------------------------------------  *00270000
SC5   *  08/17/99     SC      ADD NEW SEARCH FOR GAS CUSTOMERS         *        
T21993* 04/03/2000    SK      UPDATED THE WAY THIS RPC HANDLES LIMITS  *        
T21993*                       AND WRITE OFFS - SIMILAR TO TPR 17173    *        
T21993*                       USED ON S200.  ALSO DELETED UNNEEDED     *        
T21993*                       CODE DEALING W/ ELEC - THIS RPC IS ONLY  *        
T21993*                       FOR GAS ADDRESSES.                       *        
T23617* 04/20/2001    SK      COMPANY LIMIT ADDED FOR GAS ADDR SEARCH. *        
C26959* 08/12/2001    MJG     RETURN GROUP_CD/SENIOR FLAG.*                     
C31811* 01/20/2005    MSR     ADD ACTIVE FILTER FOR GAS ADDRESS OPTION *        
REARCH* 02/24/2006    CVNS    RPC TO DB2 SP CONVERSION                 *        
REARCH*               CHENNAI                                          *        
C35671* 08/02/2007    CVNS    ADDRESS FORMATTED CHANGES                *        
C35671*                                                                *        
T36481* 11/05/2007    AW41078 INCREASE SIZE OF ADD-OVERFLOW-STREET     *        
T36481*                       FROM 16 TO 30                            *        
T35434* 11/05/2007    AW41078 REPLACE CSS_MODEL_SQL WITH SET STMNT     *        
T35434*                       ADD WITH UR AND FETCH ONLY WITH UR       *        
P35332*  11/14/2007  AW41078  COMMENT OUT 7980 PARAGRAPH SO THAT VALUE *        
P35332*                       CODE_CRIT_OUTAGE FROM CSS_ACCOUNT WILL   *        
P35332*                       GET RETURNED IN RESULT SET INSTEAD OF    *        
P35332*                       '' OR 'WC'                               *        
P35979* 09/30/2008    SC41135 ADDING COMPANY_NO TO CSS_SUBDIVISION     *        
A37666* 06/15/2009    FMB     ARCHIVE ACCOUNT PROCESSING.              *        
P00172* 06/15/2009    FMB     MOVE DHR FROM ACCOUNT TO CUSTOMER.       *        
A05460* 09/29/16     MR7E794  REMOVED THE MAIN USER TABLE AS PART      *        
      *              ACT282   OF TABLE CHANGE AND GETTING THE SAME     *        
      *                       VALUE FROM CODE VALUE TABLE.             *        
006122******************************************************************01580000
006123******************************************************************01590000
006124*                                                                *01600000
006125*                ---- BASIC SEQUENCE STRUCTURE ----              *01610000
006126*                                                                *01620000
006127*  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01630000
006128*  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01640000
006129*  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01650000
006130*  3000 - 4999  NOT USED                                         *01660000
006140*  5000 - 5999  COMMON PROGRAM MODULES                           *01670000
006150*  6000 - 6999  COMMON SYSTEM MODULES                            *01680000
006160*  7000 - 7999  INPUT MODULES                                    *01690000
006170*  8000 - 8999  OUTPUT MODULES                                   *01700000
006180*  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01710000
006190*                                                                *01720000
006200******************************************************************01730000
006300                                                                  
006400 ENVIRONMENT DIVISION.                                            
006500 DATA DIVISION.                                                   
006600 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02417'.
MSQ017     COPY MFASQLM.
006700                                                                  
006800     EXEC SQL                                                     01790000
006900        INCLUDE SQLCA                                             01800000
007000     END-EXEC.                                                    01810000
007100                                                                  
007200******************************************************************01830000
007300*    UT - CSS_UTIL_ENVRNMT                                       *01840000
007400******************************************************************01850000
007500     EXEC SQL                                                     01860000
007600        INCLUDE TBUTLENV                                          01870000
007700     END-EXEC.                                                    01880000
007800                                                                  
007900******************************************************************01900000
008000*    DQ - CSS_NAME                                               *01910000
008100******************************************************************01920000
008200     EXEC SQL                                                     01930000
008300        INCLUDE TBNAME                                            01940000
008400     END-EXEC.                                                    01950000
008500                                                                  
008600******************************************************************01970000
008700*    HT - MMS_NAME_ACCT_XREF                                     *01980000
008800******************************************************************01990000
008900     EXEC SQL                                                     02000000
009000        INCLUDE TBNMACTX                                          02010000
009100     END-EXEC.                                                    02020000
009200                                                                  
009300******************************************************************02040000
009400*    AQ - CSS_BILL_ACCT_XREF                                     *02050000
009500******************************************************************02060000
009600     EXEC SQL                                                     02070000
009700        INCLUDE TBBLADRX                                          02080000
009800     END-EXEC.                                                    02090000
009900                                                                  
010000******************************************************************02110000
010100*    DY - CSS_ADDR_FORMATTED                                     *02120000
010200******************************************************************02130000
010300     EXEC SQL                                                     02140000
010400        INCLUDE TBADRFMT                                          02150000
010500     END-EXEC.                                                    02160000
010600                                                                  
010700******************************************************************02180000
010800*    PR - CSS_PREMISE                                            *02190000
010900******************************************************************02200000
011000     EXEC SQL                                                     02210000
011100        INCLUDE TBPREM                                            02220000
011200     END-EXEC.                                                    02230000
011300                                                                  
011400******************************************************************02250000
011500*    AT - CSS_ACCOUNT                                            *02260000
011600******************************************************************02270000
011700     EXEC SQL                                                     02280000
011800        INCLUDE TBACCT                                            02290000
011900     END-EXEC.                                                    02300000
012000                                                                  
012100******************************************************************02320000
012200*    CU - CSS_CUSTOMER                                           *02330000
012300******************************************************************02340000
012400     EXEC SQL                                                     02350000
012500        INCLUDE TBCUST                                            02360000
012600     END-EXEC.                                                    02370000
012700                                                                  
012800******************************************************************02390000
012900*    CE - CSS_CUST_STATS                                         *02400000
013000******************************************************************02410000
013100     EXEC SQL                                                     02420000
013200        INCLUDE TBCSTSTS                                          02430000
013300     END-EXEC.                                                    02440000
013400                                                                  
013500******************************************************************02460000
013600*    MN - CSS_MTRD_ENVRNMT                                       *02470000
013700******************************************************************02480000
013800     EXEC SQL                                                     02490000
013900        INCLUDE TBMTRENV                                          02500000
014000     END-EXEC.                                                    02510000
014100                                                                  
014200******************************************************************02530000
014300*    BS - CSS_BUS_CUST_STATS                                     *02540000
014400******************************************************************02550000
014500     EXEC SQL                                                     02560000
014600        INCLUDE TBBSCSTS                                          02570000
014700     END-EXEC.                                                    02580000
014800                                                                  
014900******************************************************************02600000
015000*    B0 - CSS_SUBDIVISON                                         *02610000
015100******************************************************************02620000
015200     EXEC SQL                                                     02630000
015300        INCLUDE TBSUBDVN                                          02640000
015400     END-EXEC.                                                    02650000
015500                                                                  
015600******************************************************************02670000
015700*    A4 - CSS_ZIP_CD                                             *02680000
015800******************************************************************02690000
015900     EXEC SQL                                                     02700000
016000        INCLUDE TBZIPCD                                           02710000
016100     END-EXEC.                                                    02720000
016200                                                                  
016300******************************************************************02740000
016400*    XR - CSS_XREF_ACCT                                          *02750000
016500******************************************************************02760000
016600     EXEC SQL                                                     02770000
016700        INCLUDE TBXREF                                            02780000
016800     END-EXEC.                                                    02790000
016900                                                                  
017000******************************************************************02810000
017100*    CB - CSS_CUST_PHONE                                         *02820000
017200******************************************************************02830000
017300     EXEC SQL                                                     02840000
017400        INCLUDE TBCSTPHN                                          02850000
017500     END-EXEC.                                                    02860000
017600                                                                  
T5789 ******************************************************************02880000
ACT282*    SW - CSS_SO_CODE_DESC                                       *02890000
T5789 ******************************************************************02900000
T5789      EXEC SQL                                                     02910000
ACT282        INCLUDE TBSOCODE                                          02920000
T5789      END-EXEC.                                                    02930000
T5789                                                                   
T8430 ******************************************************************02950000
T8430 *    WH - CSS_ACCT_WHT_CROSS                                     *02960000
T8430 ******************************************************************02970000
T8430      EXEC SQL                                                     02980000
T8430         INCLUDE TBWCACCT                                          02990000
T8430      END-EXEC.                                                    03000000
T8430                                                                   
C26959******************************************************************02950000
C26959*    C8 - CSS_DELINQUENCY                                        *02960000
C26959******************************************************************02970000
C26959     EXEC SQL                                                     02980000
C26959        INCLUDE TBDELQ                                            02990000
C26959     END-EXEC.                                                    03000000
C26959                                                                  
C26959******************************************************************02950000
C26959*    LR - CSS_REG_PROFILE                                        *02960000
C26959******************************************************************02970000
C26959     EXEC SQL                                                     02980000
C26959        INCLUDE TBREGPRF                                          02990000
C26959     END-EXEC.                                                    03000000
C26959                                                                  
C26959******************************************************************02950000
C26959*         CSS_MODEL_SQL                                          *02960000
C26959******************************************************************02970000
C26959     EXEC SQL                                                     02980000
C26959        INCLUDE TBMODEL                                           02990000
C26959     END-EXEC.                                                    03000000
C26959                                                                  
A37666******************************************************************02950000
A37666*         HST_ACCOUNT                                            *02960000
A37666******************************************************************02970000
A37666     EXEC SQL                                                     02980000
A37666        INCLUDE TBHACCT                                           02990000
A37666     END-EXEC.                                                    03000000
A37666                                                                  
017700******************************************************************03020000
017800*    COMMON COPYLIBS                                             *03030000
017900******************************************************************03040000
018000                                                                  
018300     COPY CCA00001.                                               03080000
018500     COPY CWS00027.                                               03100000
018600     COPY CWS00056.                                               03110000
018700     COPY CWS00303.                                               03120000
018800                                                                  
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
018900******************************************************************03140000
019000*    WORK AREAS                                                  *03150000
019100******************************************************************03160000
019200                                                                  
020300                                                                  
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                       VALUE                      
REARCH                                       'SESSION.CSR02417_R1'.     
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
020400 01  MESSAGE-FIELDS.                                              
020500     05  MSG-TYPE                     PIC S9(9) COMP.             
020600     05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
020700     05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
020800     05  MSG-RPC                      PIC X(4) VALUE 'S200'.      
020900     05  MSG-RPC-L                    PIC S9(9) COMP.             
021000     05  MSG-TEXT                     PIC X(100).                 
021100     05  MSG-TEXT-L                   PIC S9(9) COMP.             
021200     05  MSG-SQL-ERROR.                                           
021300         10  FILLER                   PIC X(10)                   
021400                                      VALUE 'SQLCODE = '.         
021500         10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
021600         10  FILLER                   PIC X(16)                   
021700             VALUE ', ERROR TOKENS: '.                            
021800         10  MSG-SQL-ERROR-K          PIC X(70).                  
021900         10  MSG-SQL-ERROR-K-CHARS                                
022000                                      REDEFINES MSG-SQL-ERROR-K   
022100                                      OCCURS 70 TIMES             
022200                                      PIC X.                      
022300     05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
022400                                                                  
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9) COMP VALUE 0.         
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
022500******************************************************************03500000
022600*    INPUT PARAMETERS                                            *03510000
022700******************************************************************03520000
022800                                                                  
022900 01  PARM-FIELDS.                                                 
023200     05  PARM-LIMITS.                                             
023300         10  PARM-LIMIT-TYPE          PIC X(1).                   
023400             88  LIMIT-NONE           VALUE 'A'.                  
023500             88  LIMIT-LOCAL-OFFICE   VALUE 'L'.                  
023600             88  LIMIT-CITY           VALUE 'C'.                  
023600             88  LIMIT-ACTIVE         VALUE 'I'.                  
T23617             88  LIMIT-COMPANY        VALUE 'B'.                  
023700         10  PARM-WRITE-OFF           PIC X(1).                   
023800             88  FILTER-WRITE-OFF     VALUE 'Y'.                  
023900             88  NO-FILTER-WRITE-OFF  VALUE 'N'.                  
C31811*        10  PARM-JUDGEMENT           PIC X(1).                   03650000
C31811*            88  FILTER-JUDGEMENT     VALUE 'Y'.                  03660000
C31811*            88  NO-FILTER-JUDGEMENT  VALUE 'N'.                  03670000
C31811         10  PARM-ACTIVE-CSR          PIC X(1).                   
C31811             88  FILTER-ACTIVE-CSR    VALUE 'Y'.                  
C31811             88  NO-FILTER-ACTIVE-CSR VALUE 'N'.                  
024300         10  PARM-BANKRUPT            PIC X(1).                   
024400             88  FILTER-BANKRUPT      VALUE 'Y'.                  
024500             88  NO-FILTER-BANKRUPT   VALUE 'N'.                  
024600     05  PARM-OFFICE-CITY             PIC X(26).                  
024700     05  PARM-SELECT-METHOD           PIC X(3).                   
025900         88  SEL-METH-ADD             VALUE 'ADD'.                
SC5            88  SEL-METH-GAS             VALUE 'GAS'.                
TP9950     05  PARM-CRITERIA                PIC X(127).                 
026200                                                                  
026300 77  WS-BLO-LOT-SPACES                PIC X(05) VALUE SPACES.     
026400 01  SNA-FIELDS.                                                  
026500     05  SNA-SUBC                     PIC S9(9) COMP.             
026600     05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      
026700                                                                  
026800 01  COUNTER-FIELDS.                                              
026900     05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
027000     05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
027100                                                                  
027200 01  WS-SUB                           PIC S9(8) COMP VALUE ZERO.  
027300                                                                  
027400 01  WORK-FIELDS.                                                 
027500     05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
027600     05  WRKLEN1                      PIC S9(9) COMP.             
027700     05  WRKLEN2                      PIC S9(9) COMP.             
027800     05  WRK-DONE-STATUS              PIC S9(9) COMP.             
027900                                                                  
028000******************************************************************04050000
028100*    RESULT SET FIELDS                                           *04060000
028200******************************************************************04070000
028300                                                                  
028400 01  TDS-RETURN-FIELDS.                                           
028500     05  RS-RETURN-CODE               PIC S9(9) COMP.             
028600     05  RS-RED-FLAG-INDICATOR        PIC X.                      
C35671     05  RS-ADDRESS                   PIC X(71).                  
028800     05  RS-CITY                      PIC X(26).                  
C35671     05  RS-NAME                      PIC X(76).                  
029000     05  RS-NAME-TYPE                 PIC X(2).                   
029100     05  RS-ACCT-TYPE                 PIC X.                      
029200     05  RS-SERVICE-SUPPLIED.                                     
029300         10  RS-SERV-SUPPLIED-OCC     OCCURS 5 TIMES.             
029400             15  RS-SERV-SUPPLIED     PIC X.                      
029500     05  RS-SUBDIVISION               PIC X(26).                  
029600     05  RS-STATUS                    PIC X.                      
029700     05  RS-ACCOUNT-NO                PIC X(13).                  
029800     05  RS-SERVICE-AVAIL.                                        
029900         10  RS-SERV-AVAIL-OCC        OCCURS 5 TIMES.             
030000             15  RS-SERV-AVAIL        PIC X.                      
030100     05  RS-CUSTOMER-NO               PIC X(10).                  
030200     05  RS-LOCAL-OFFICE              PIC X(3).                   
030300     05  RS-PREMISE-NO                PIC X(10).                  
030400     05  RS-NAME-FORMAT               PIC X.                      
030500     05  RS-BANKRUPT-IND              PIC X.                      
030600     05  RS-CREDIT-GROUP              PIC X(1).                   
030700     05  RS-CREDIT-STATUS             PIC X.                      
030800     05  RS-CODE-ACCT-STAT            PIC X.                      
030900     05  RS-ELEC-RATE                 PIC XXX.                    
031000     05  RS-GAS-RATE                  PIC XXX.                    
031100     05  RS-UNMETER-RATE              PIC XXX.                    
031200     05  RS-ZIP-CODE                  PIC X(5).                   
031300     05  RS-ZIP-CODE-TOKEN            PIC X.                      
031400     05  RS-MST-SUB-ACCT-IND          PIC X(01).                  
031500     05  RS-COMPANY-NO                PIC X(02).                  
C35671     05  RS-CUST-NAME                 PIC X(76).                  
PCR285     05  RS-CODES-DATA-PRESENT        PIC X(32) VALUE SPACES.     
T8430      05  RS-CODE-CRIT-OUTAGE          PIC X(2).                   
T5789      05  RS-ACCT-TYPE-DESC            PIC X(25).                  
SC5        05  RS-METER-NO                  PIC X(9).                   
SC5        05  RS-CODE-METER-STATUS         PIC X(1).                   
SC5        05  RS-CODE-METER-LOC            PIC X(2).                   
SC5        05  RS-METER-READ-SEQ            PIC X(6).                   
SC5        05  RS-READ-CYCLE                PIC X(2).                   
SC5        05  RS-READ-ROUTE                PIC X(4).                   
C16959     05  RS-GROUP-CD                  PIC X(09).                  
A37666     05  RS-ARCHIVE-IND               PIC X(01).                  
031700 01  RS-ERROR-DESC                PIC X(40) VALUE SPACES.         
031800                                                                  
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05   S-RETURN-CODE               PIC S9(9) COMP.             
REARCH     05   S-RED-FLAG-INDICATOR        PIC X.                      
C35671     05   S-ADDRESS                   PIC X(71).                  
REARCH     05   S-CITY                      PIC X(26).                  
C35671     05   S-NAME                      PIC X(56).                  
REARCH     05   S-NAME-TYPE                 PIC X(2).                   
REARCH     05   S-ACCT-TYPE                 PIC X.                      
REARCH     05   S-SERVICE-SUPPLIED          PIC X(05).                  
REARCH     05   S-SUBDIVISION               PIC X(26).                  
REARCH     05   S-STATUS                    PIC X.                      
REARCH     05   S-ACCOUNT-NO                PIC X(13).                  
REARCH     05   S-SERVICE-AVAIL             PIC X(05).                  
REARCH     05   S-CUSTOMER-NO               PIC X(10).                  
REARCH     05   S-LOCAL-OFFICE              PIC X(3).                   
REARCH     05   S-PREMISE-NO                PIC X(10).                  
REARCH     05   S-NAME-FORMAT               PIC X.                      
REARCH     05   S-BANKRUPT-IND              PIC X.                      
REARCH     05   S-CREDIT-GROUP              PIC X(1).                   
REARCH     05   S-CREDIT-STATUS             PIC X.                      
REARCH     05   S-CODE-ACCT-STAT            PIC X.                      
REARCH     05   S-ELEC-RATE                 PIC XXX.                    
REARCH     05   S-GAS-RATE                  PIC XXX.                    
REARCH     05   S-UNMETER-RATE              PIC XXX.                    
REARCH     05   S-ZIP-CODE                  PIC X(5).                   
REARCH     05   S-ZIP-CODE-TOKEN            PIC X.                      
REARCH     05   S-MST-SUB-ACCT-IND          PIC X(01).                  
REARCH     05   S-COMPANY-NO                PIC X(02).                  
C35671     05   S-CUST-NAME                 PIC X(76).                  
REARCH     05   S-CODES-DATA-PRESENT        PIC X(32) VALUE SPACES.     
REARCH     05   S-CODE-CRIT-OUTAGE          PIC X(2).                   
REARCH     05   S-ACCT-TYPE-DESC            PIC X(25).                  
REARCH     05   S-METER-NO                  PIC X(9).                   
REARCH     05   S-CODE-METER-STATUS         PIC X(1).                   
REARCH     05   S-CODE-METER-LOC            PIC X(2).                   
REARCH     05   S-METER-READ-SEQ            PIC X(6).                   
REARCH     05   S-READ-CYCLE                PIC X(2).                   
REARCH     05   S-READ-ROUTE                PIC X(4).                   
REARCH     05   S-GROUP-CD                  PIC X(09).                  
A37666     05   S-ARCHIVE-IND               PIC X(01).                  
REARCH 01  S-ERROR-DESC                PIC X(40) VALUE SPACES.          
037400 01  SWITCHES.                                                    
037500     05  ALL-DONE-SW                  PIC X VALUE 'N'.            
037600         88  NOT-ALL-DONE             VALUE 'N'.                  
037700         88  ALL-DONE                 VALUE 'Y'.                  
037800     05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
037900         88  SEND-DONE-ERROR          VALUE 'N'.                  
038000         88  SEND-DONE-OK             VALUE 'Y'.                  
038100                                                                  
038200******************************************************************05250000
038300*    INPUT PARAMETER SEARCH CRITERIA UNSTRING AREA               *05260000
038400******************************************************************05270000
038500                                                                  
038600 01  WS-PARM-CRITERIA.                                            
038700                                                                  
039200                                                                  
043190     05  WS-ADD-PARM-CRITERIA.                                    
043200         10  ADD-ADDRESS-TYPE         PIC X.                      
043300             88  SERVICE-ADDRESS      VALUE 'S'.                  
043400             88  BILLING-ADDRESS      VALUE 'B'.                  
043500             88  INTERSECTION-ADDRESS VALUE 'I'.                  
C35671         10  ADD-STREET-NBR           PIC X(15).                  
043700         10  ADD-PREFIX-1             PIC X(3).                   
043800         10  ADD-PREFIX-2             PIC X(2).                   
C35671         10  ADD-STREET-NAME          PIC X(30).                  
044000         10  ADD-LOCATION-1           PIC X(4).                   
C35671         10  ADD-LOCATION-2           PIC X(11).                  
044200         10  ADD-CITY                 PIC X(26).                  
044300         10  ADD-OVERFLOW             PIC X(16).                  
044400         10  ADD-BLOCK                PIC X(05).                  
044500         10  ADD-LOT                  PIC X(05).                  
T21993         10  ADD-STATE                PIC X(02).                  
044600                                                                  
045000******************************************************************06020000
045100*    BETWEEN FIELD WORK AREAS                                    *06030000
045200******************************************************************06040000
045300 01  WS-LOW-HIGH-AREA.                                            
045400                                                                  
C35671     05  ADD-STREET-NBR-L             PIC X(15) VALUE LOW-VALUE.  
C35671     05  ADD-STREET-NBR-H             PIC X(15) VALUE HIGH-VALUE. 
C35671     05  ADD-STREET-NBR-B             PIC X(15) VALUE             
C35671        '%%%%%%%%%%%%%%%'.                                        
045635     05  ADD-PREFIX-1-L               PIC X(3)  VALUE LOW-VALUE.  
045636     05  ADD-PREFIX-1-H               PIC X(3)  VALUE HIGH-VALUE. 
045637     05  ADD-PREFIX-1-B               PIC X(3)  VALUE '%%%'.      
045638     05  ADD-PREFIX-2-L               PIC X(2)  VALUE LOW-VALUE.  
045639     05  ADD-PREFIX-2-H               PIC X(2)  VALUE HIGH-VALUE. 
045640     05  ADD-PREFIX-2-B               PIC X(2)  VALUE '%%'.       
C35671     05  ADD-STREET-NAME-L            PIC X(30) VALUE LOW-VALUE.  
C35671     05  ADD-STREET-NAME-H            PIC X(30) VALUE HIGH-VALUE. 
C35671     05  ADD-STREET-NAME-B            PIC X(30) VALUE             
C35671        '%%%%%%%%%%%%%%%%%%%%%%%%%'.                              
045630     05  ADD-STREET-NAME-C            PIC X(16) VALUE             
045631         '%%%%%%%%%%%%%%%%'.                                      
045630     05  ADD-STREET-OVERFLOW          PIC X(35) VALUE             
T9250          '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                   
045645     05  ADD-LOCATION-1-L             PIC X(4)  VALUE LOW-VALUE.  
045646     05  ADD-LOCATION-1-H             PIC X(4)  VALUE HIGH-VALUE. 
045647     05  ADD-LOCATION-1-B             PIC X(4)  VALUE '%%%%'.     
C35671     05  ADD-LOCATION-2-L             PIC X(11) VALUE LOW-VALUE.  
C35671     05  ADD-LOCATION-2-H             PIC X(11) VALUE HIGH-VALUE. 
C35671     05  ADD-LOCATION-2-B             PIC X(11) VALUE             
C35671        '%%%%%%%%%%%'.                                            
045651     05  ADD-CITY-L                   PIC X(26) VALUE LOW-VALUE.  
045652     05  ADD-CITY-H                   PIC X(26) VALUE HIGH-VALUE. 
045653     05  ADD-CITY-B                   PIC X(26) VALUE             
045654         '%%%%%%%%%%%%%%%%%%%%%%%%%%'.                            
045655     05  ADD-OVERFLOW-L               PIC X(35) VALUE LOW-VALUE.  
045656     05  ADD-OVERFLOW-H               PIC X(35) VALUE HIGH-VALUE. 
045657     05  ADD-OVERFLOW-B               PIC X(35) VALUE             
045658         '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                   
045657     05  ADD-OVERFLOW-C               PIC X(35) VALUE             
045658         '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                   
T9250      05  ADD-OVERFLOW-STREET          PIC X(30) VALUE             
045658         '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.                        
045659     05  ADD-BLOCK-L                  PIC X(05) VALUE LOW-VALUE.  
045660     05  ADD-BLOCK-H                  PIC X(05) VALUE HIGH-VALUE. 
045661     05  ADD-BLOCK-B                  PIC X(05) VALUE '%%%%%'.    
045662     05  ADD-LOT-L                    PIC X(05) VALUE LOW-VALUE.  
045663     05  ADD-LOT-H                    PIC X(05) VALUE HIGH-VALUE. 
045664     05  ADD-LOT-B                    PIC X(05) VALUE '%%%%%'.    
045665                                                                  
045679 01  WS-BETWEEN-PARM-AREA.                                        
045680     05  WS-ASTERISK-POS              PIC S9(4).                  
045690     05  WS-LENGTH                    PIC S9(4).                  
045700     05  WS-MAX-SZ                    PIC S9(4).                  
045800     05  WS-NAME-FORMAT               PIC X.                      
045900     05  WS-NAME-I                    PIC X VALUE 'N'.            
046000     05  WS-NAME-B                    PIC X VALUE 'N'.            
046100     05  WS-UNDERSCORE                PIC X(50) VALUE             
046200         '__________________________________________________'.    
046100     05  WS-PERCENT                   PIC X(50) VALUE             
046200         '%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'.    
046300     05  WS-LIKE-VARIABLE.                                        
046400         10  WS-LIKE-X                OCCURS 51 TIMES PIC X.      
046300     05  WS-PERCENT-VARIABLE.                                     
046400         10  WS-PERCENT-X             OCCURS 51 TIMES PIC X.      
046500     05  WS-FROM.                                                 
046600         10  WS-FROM-X                OCCURS 51 TIMES PIC X.      
046700     05  WS-LOW.                                                  
046800         10  WS-LOW-X                 OCCURS 51 TIMES PIC X.      
046900     05  WS-HIGH.                                                 
047000         10  WS-HIGH-X                OCCURS 51 TIMES PIC X.      
T23617     05  COMPANY-B                    PIC X(2) VALUE '%%'.        
047100                                                                  
047200 01  WS-MISC-FIELDS.                                              
REARCH     05  WS-SQLSTATE                  PIC X(05) VALUE SPACES.     
047300     05  WS-UTIL-TYPE                 PIC X(1) VALUE SPACES.      
028800     05  WS-TOWN                      PIC X(26).                  
047400     05  WS-PREV-CUST                 PIC X(10) VALUE LOW-VALUE.  
047500     05  WS-PREV-NAME                 PIC X(56) VALUE LOW-VALUE.  
C35671     05  WS-PREV-ADDRESS              PIC X(71) VALUE LOW-VALUE.  
047700     05  WS-PREV-CITY                 PIC X(26) VALUE LOW-VALUE.  
T16653     05  WS-PREV-PREMISE-NO           PIC X(10) VALUE LOW-VALUE.  
047800     05  PROGRAM-NAME                 PIC X(8) VALUE 'S200'.      
047900     05  WS-NAME-TYPE                 PIC X(2) VALUE SPACES.      
C35671     05  WS-CUST-LAST-NAME            PIC X(40) VALUE SPACES.     
048100     05  WS-CUST-FIRST-NAME           PIC X(15) VALUE SPACES.     
048200     05  WS-CUST-MIDDLE-NAME          PIC X(15) VALUE SPACES.     
C35671     05  WS-CUST-FULL-NAME            PIC X(76) VALUE SPACES.     
048400     05  WS-CUST-NAME-FORMAT          PIC X(01) VALUE SPACES.     
048500     05  WS-CUST-TITLE-SUFFIX-1       PIC X(03) VALUE SPACES.     
048600     05  WS-NEED-ADDRESS              PIC X VALUE 'N'.            
048700         88  NEED-ADDRESS             VALUE 'Y'.                  
048800         88  NEED-ADDRESS-NO          VALUE 'N'.                  
048900     05  WS-NEED-CITY                 PIC X VALUE 'N'.            
049000         88  NEED-CITY                VALUE 'Y'.                  
049100         88  NEED-CITY-NO             VALUE 'N'.                  
049200     05  WS-NEED-NAME                 PIC X VALUE 'N'.            
049300         88  NEED-NAME                VALUE 'Y'.                  
049400         88  NEED-NAME-NO             VALUE 'N'.                  
049500     05  WS-WRITE-OFF-IND             PIC X.                      
049600         88  WRITE-OFF-YES            VALUE 'Y'.                  
049700         88  WRITE-OFF-NO             VALUE 'N'.                  
049800     05  WS-ADDRESS.                                              
C35671         10  WS-ADDRESS-X             OCCURS 80 TIMES             
050000                                      INDEXED BY WS-ADD-SUB.      
050100             15  FILLER               PIC X.                      
           05  WS-LOT-BLOCK                 PIC X(03) VALUE SPACES.     
           05  WS-UNMTR-FOUND               PIC X(01).                  
           05  WS-ELEC-RATE                 PIC X(03).                  
           05  WS-GAS-RATE                  PIC X(03).                  
           05  WS-ELEC-RATE-NULL-IND        PIC S9(04) COMP VALUE 0.    
           05  WS-GAS-RATE-NULL-IND         PIC S9(04) COMP VALUE 0.    
C26959     05  WS-TODAYS-DATE               PIC X(10).                  
C26959     05  WS-ACTIVE-DHR                PIC X(01) VALUE ' '.        
C37666     05  WS-ARCHIVED-ACCOUNT     PIC X(01) VALUE SPACES.          
C37666     05  WS-NULL-PYMT-DATE-HA    PIC S9(04)    COMP   VALUE +0.   
C37666     05  WS-NULL-GROUP-EFF-TS    PIC S9(04)    COMP   VALUE +0.   
                                                                        
T8339  01  WS-NEXT-VARAIBLES.                                           
T8339      05  WS-NEXT-COUNTER              PIC S9(4) COMP VALUE 1.     
T8339      05  WS-MULTIPLIER                PIC X(02) VALUE '00'.       
T8339      05  WS-NEXT-MULTIPLIER           REDEFINES WS-MULTIPLIER     
T8339                                       PIC 9(2).                   
T8339      05  WS-ROWS-PROCESSED            PIC 9(4)  VALUE 1.          
050200                                                                  
050300 01  CN-CONSTANTS.                                                
050400     05  CN-MAX-RETURN-ROWS           PIC S9(4) COMP VALUE 20.    
050500     05  CN-DELIMITER                 PIC X VALUE ';'.            
050600     05  CN-ASTERISK                  PIC X VALUE '*'.            
HPCCDM*    EJECT                                                        07660000
051100                                                                  
050800******************************************************************07680000
SC5900*    B-GAS-CURSOR USED TO SEARCH FOR GAS ADDRESSES.              *07690000
051000******************************************************************07700000
SC5200     EXEC SQL DECLARE B-GAS-CURSOR CURSOR FOR                     
051300         SELECT HT.CUSTOMER_NO,                                   
051400                HT.ACCOUNT_NO,                                    
051500                HT.PREMISE_NO,                                    
051600                HT.ADDRESS_ID,                                    
051700                HT.NAME_ID,                                       
051800                HT.CUSTOMER_ROLE_CD,                              
051900                HT.COMPANY_NO,                                    
052000                DY.STREET_NAME,                                   
052100                DY.HOUSE_NO,                                      
052200                DY.ADDR_PREFIX_1,                                 
052300                DY.ADDR_PREFIX_2,                                 
052400                DY.STREET_LOCATION_1,                             
052500                DY.STREET_LOCATION_2,                             
SC5                   UT.READ_CYCLE,                                    
SC5                   UT.READ_ROUTE,                                    
SC5                   UT.IC_NO                                          
052600           FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
052700                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
SC5                   CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
052900          WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
053000            AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
053100            AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
053200            AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
053300            AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
053400            AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
053700            AND DY.ADDR_USAGE_CD           = 'F'                  
053800            AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
T7968             AND HT.CUSTOMER_ROLE_CD        = ' '                  
SC5               AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO        
SC5               AND UT.CODE_UTIL_TYPE          = 'G'                  
SC5               AND UT.RATE_PLAN_NO            > ' '                  
T23617            AND HT.COMPANY_NO        LIKE    :COMPANY-B           
T7968             AND (EXISTS (SELECT 'X'                               
T7968                            FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
T7968                           WHERE HT.NAME_ID   = DQ.NAME_ID         
T7968                             AND DQ.NAME_TYPE = 'CN')              
T7968                  OR NOT EXISTS                                    
T7968                         (SELECT 'X'                               
T7968                            FROM CSS_NAME DQ2 WITH(READUNCOMMITTED)        
T7968                           WHERE HT.NAME_ID = DQ2.NAME_ID))        
054000       ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
054100                DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
054200                DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
T35434       FOR READ ONLY                                      
054300     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE B-GAS-CURSOR CURSOR FOR                     07710000
MFA-TR*        SELECT HT.CUSTOMER_NO,                                   07720000
MFA-TR*               HT.ACCOUNT_NO,                                    07730000
MFA-TR*               HT.PREMISE_NO,                                    07740000
MFA-TR*               HT.ADDRESS_ID,                                    07750000
MFA-TR*               HT.NAME_ID,                                       07760000
MFA-TR*               HT.CUSTOMER_ROLE_CD,                              07770000
MFA-TR*               HT.COMPANY_NO,                                    07780000
MFA-TR*               DY.STREET_NAME,                                   07790000
MFA-TR*               DY.HOUSE_NO,                                      07800000
MFA-TR*               DY.ADDR_PREFIX_1,                                 07810000
MFA-TR*               DY.ADDR_PREFIX_2,                                 07820000
MFA-TR*               DY.STREET_LOCATION_1,                             07830000
MFA-TR*               DY.STREET_LOCATION_2,                             07840000
MFA-TR*               UT.READ_CYCLE,                                            
MFA-TR*               UT.READ_ROUTE,                                            
MFA-TR*               UT.IC_NO                                                  
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            07850000
MFA-TR*               CSS_NAME_ACCT_XREF HT,                            07860000
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    07870000
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      07880000
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      07890000
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   07900000
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    07910000
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    07920000
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                  07930000
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID        07940000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                  07950000
MFA-TR*           AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO                
MFA-TR*           AND UT.CODE_UTIL_TYPE          = 'G'                          
MFA-TR*           AND UT.RATE_PLAN_NO            > ' '                          
MFA-TR*           AND HT.COMPANY_NO        LIKE    :COMPANY-B                   
MFA-TR*           AND (EXISTS (SELECT 'X'                               07960000
MFA-TR*                          FROM CSS_NAME DQ                       07970000
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID         07980000
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')              07990000
MFA-TR*                OR NOT EXISTS                                    08000000
MFA-TR*                       (SELECT 'X'                               08010000
MFA-TR*                          FROM CSS_NAME DQ2                      08020000
MFA-TR*                         WHERE HT.NAME_ID = DQ2.NAME_ID))        08030000
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      08040000
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               08050000
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        08060000
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    08070000
HPCCDM*    EJECT                                                        08080000
I10500                                                                  
SC5800******************************************************************        
T21993*    B-GAS-CURSOR-L USED TO SEARCH FOR GAS ADDRESSES WITH THE    *        
T21993*                   LOCAL OFFICE LIMIT.                          *        
T21993******************************************************************        
T21993     EXEC SQL DECLARE B-GAS-CURSOR-L CURSOR FOR                   
T21993         SELECT HT.CUSTOMER_NO,                                   
T21993                HT.ACCOUNT_NO,                                    
T21993                HT.PREMISE_NO,                                    
T21993                HT.ADDRESS_ID,                                    
T21993                HT.NAME_ID,                                       
T21993                HT.CUSTOMER_ROLE_CD,                              
T21993                HT.COMPANY_NO,                                    
T21993                DY.STREET_NAME,                                   
T21993                DY.HOUSE_NO,                                      
T21993                DY.ADDR_PREFIX_1,                                 
T21993                DY.ADDR_PREFIX_2,                                 
T21993                DY.STREET_LOCATION_1,                             
T21993                DY.STREET_LOCATION_2,                             
T21993                UT.READ_CYCLE,                                    
T21993                UT.READ_ROUTE,                                    
T21993                UT.IC_NO                                          
T21993           FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
T21993                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
T21993                CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
T21993          WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
T21993            AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
T21993            AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
T21993            AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
T21993            AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
T21993            AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
T21993            AND DY.ADDR_USAGE_CD           = 'F'                  
T21993            AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
T21993            AND HT.CUSTOMER_ROLE_CD        = ' '                  
T21993            AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY    
T21993            AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO        
T21993            AND UT.CODE_UTIL_TYPE          = 'G'                  
T21993            AND UT.RATE_PLAN_NO            > ' '                  
T21993            AND (EXISTS (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
T21993                          WHERE HT.NAME_ID   = DQ.NAME_ID         
T21993                            AND DQ.NAME_TYPE = 'CN')              
T21993                 OR NOT EXISTS                                    
T21993                        (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ2 WITH(READUNCOMMITTED)        
T21993                          WHERE HT.NAME_ID = DQ2.NAME_ID))        
T21993       ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
T21993                DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
T21993                DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
T35434       FOR READ ONLY                                      
T21993     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE B-GAS-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               UT.READ_CYCLE,                                            
MFA-TR*               UT.READ_ROUTE,                                            
MFA-TR*               UT.IC_NO                                                  
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY            
MFA-TR*           AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO                
MFA-TR*           AND UT.CODE_UTIL_TYPE          = 'G'                          
MFA-TR*           AND UT.RATE_PLAN_NO            > ' '                          
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR NOT EXISTS                                            
MFA-TR*                       (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ2                              
MFA-TR*                         WHERE HT.NAME_ID = DQ2.NAME_ID))                
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993*    B-GAS-CURSOR-C USED TO SEARCH FOR GAS ADDRESSES WITH THE    *        
T21993*                   CITY/STATE LIMIT.                            *        
T21993******************************************************************        
T21993     EXEC SQL DECLARE B-GAS-CURSOR-C CURSOR FOR                   
T21993         SELECT HT.CUSTOMER_NO,                                   
T21993                HT.ACCOUNT_NO,                                    
T21993                HT.PREMISE_NO,                                    
T21993                HT.ADDRESS_ID,                                    
T21993                HT.NAME_ID,                                       
T21993                HT.CUSTOMER_ROLE_CD,                              
T21993                HT.COMPANY_NO,                                    
T21993                DY.STREET_NAME,                                   
T21993                DY.HOUSE_NO,                                      
T21993                DY.ADDR_PREFIX_1,                                 
T21993                DY.ADDR_PREFIX_2,                                 
T21993                DY.STREET_LOCATION_1,                             
T21993                DY.STREET_LOCATION_2,                             
T21993                UT.READ_CYCLE,                                    
T21993                UT.READ_ROUTE,                                    
T21993                UT.IC_NO                                          
T21993           FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
T21993                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
T21993                CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
T21993          WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
T21993            AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
T21993            AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
T21993            AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
T21993            AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
T21993            AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
T21993            AND DY.ADDR_USAGE_CD           = 'F'                  
T21993            AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
T21993            AND HT.CUSTOMER_ROLE_CD        = ' '                  
T21993            AND HT.TOWN                    = :PARM-OFFICE-CITY    
T21993            AND HT.STATE                   = :ADD-STATE           
T21993            AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO        
T21993            AND UT.CODE_UTIL_TYPE          = 'G'                  
T21993            AND UT.RATE_PLAN_NO            > ' '                  
T21993            AND (EXISTS (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
T21993                          WHERE HT.NAME_ID   = DQ.NAME_ID         
T21993                            AND DQ.NAME_TYPE = 'CN')              
T21993                 OR NOT EXISTS                                    
T21993                        (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ2 WITH(READUNCOMMITTED)        
T21993                          WHERE HT.NAME_ID = DQ2.NAME_ID))        
T21993       ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
T21993                DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
T21993                DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
T35434       FOR READ ONLY                                      
T21993     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE B-GAS-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               UT.READ_CYCLE,                                            
MFA-TR*               UT.READ_ROUTE,                                            
MFA-TR*               UT.IC_NO                                                  
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.TOWN                    = :PARM-OFFICE-CITY            
MFA-TR*           AND HT.STATE                   = :ADD-STATE                   
MFA-TR*           AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO                
MFA-TR*           AND UT.CODE_UTIL_TYPE          = 'G'                          
MFA-TR*           AND UT.RATE_PLAN_NO            > ' '                          
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR NOT EXISTS                                            
MFA-TR*                       (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ2                              
MFA-TR*                         WHERE HT.NAME_ID = DQ2.NAME_ID))                
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                                
T21993                                                                  
SC5800******************************************************************        
SC5900*    B-MTR-CURSOR USED TO SEARCH FOR GAS ADDRESSES.              *        
SC5000******************************************************************        
SC5200     EXEC SQL DECLARE B-MTR-CURSOR CURSOR FOR                     
SC5300         SELECT METER_NO,                                         
SC5400                CODE_METER_STATUS,                                
SC5                   CODE_METER_LOC,                                   
SC5                   REGISTER_RD_SEQ                                   
SC5600           FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                    
SC5900          WHERE ACCOUNT_NO        = :HT-ACCOUNT-NO                
SC5               AND CODE_UTIL_TYPE    = 'G'                           
SC5               AND IC_NO             = :UT-IC-NO                     
T35434          FOR READ ONLY                                   
SC5        END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE B-MTR-CURSOR CURSOR FOR                             
MFA-TR*        SELECT METER_NO,                                                 
MFA-TR*               CODE_METER_STATUS,                                        
MFA-TR*               CODE_METER_LOC,                                           
MFA-TR*               REGISTER_RD_SEQ                                           
MFA-TR*          FROM CSS_MTRD_ENVRNMT                                          
MFA-TR*         WHERE ACCOUNT_NO        = :HT-ACCOUNT-NO                        
MFA-TR*           AND CODE_UTIL_TYPE    = 'G'                                   
MFA-TR*           AND IC_NO             = :UT-IC-NO                             
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                                
004665                                                                  
054700******************************************************************        
054800*    DY-PR-CURSOR USED TO SEARCH ON LOT AND BLOCK.               *        
054900******************************************************************        
055068                                                                  
055100     EXEC SQL DECLARE DY-PR-CURSOR CURSOR FOR                     
055200         SELECT HT.CUSTOMER_NO,                                   
T8339                 HT.ACCOUNT_NO,                                    
T8339                 HT.PREMISE_NO,                                    
T8339                 HT.ADDRESS_ID,                                    
T8339                 HT.NAME_ID,                                       
T8339                 HT.CUSTOMER_ROLE_CD,                              
T8339                 HT.COMPANY_NO,                                    
T8339                 DY.STREET_NAME,                                   
T8339                 DY.HOUSE_NO,                                      
T8339                 DY.ADDR_PREFIX_1,                                 
T8339                 DY.ADDR_PREFIX_2,                                 
T8339                 DY.STREET_LOCATION_1,                             
T8339                 DY.STREET_LOCATION_2,                             
SC5                   UT.READ_CYCLE,                                    
SC5                   UT.READ_ROUTE,                                    
SC5                   UT.IC_NO                                          
T8339            FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
T8339                 CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
T8339                 CSS_PREMISE PR WITH(READUNCOMMITTED),                     
SC5                   CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
T8339           WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
T8339             AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
T8339             AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
T8339             AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
T8339             AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
T8339             AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
T8339             AND PR.BLOCK             LIKE    :ADD-BLOCK-B         
T8339             AND PR.LOT               LIKE    :ADD-LOT-B           
T8339             AND DY.ADDR_USAGE_CD           = 'F'                  
T8339             AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
T8339             AND PR.PREMISE_NO              = HT.PREMISE_NO        
T7968             AND HT.CUSTOMER_ROLE_CD        = ' '                  
SC5               AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO        
SC5               AND UT.CODE_UTIL_TYPE          = 'G'                  
SC5               AND UT.RATE_PLAN_NO            > ' '                  
T23617            AND HT.COMPANY_NO        LIKE    :COMPANY-B           
T7968             AND (EXISTS (SELECT 'X'                               
T7968                            FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
T7968                           WHERE HT.NAME_ID   = DQ.NAME_ID         
T7968                             AND DQ.NAME_TYPE = 'CN')              
T7968                  OR NOT EXISTS                                    
T7968                         (SELECT 'X'                               
T7968                            FROM CSS_NAME DQ2 WITH(READUNCOMMITTED)        
T7968                           WHERE HT.NAME_ID = DQ2.NAME_ID))        
T8339        ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
T8339                 DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
T8339                 DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
T35434       FOR READ ONLY                                      
T8339      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR CURSOR FOR                     08110000
MFA-TR*        SELECT HT.CUSTOMER_NO,                                   08130000
MFA-TR*               HT.ACCOUNT_NO,                                    08150000
MFA-TR*               HT.PREMISE_NO,                                    08160000
MFA-TR*               HT.ADDRESS_ID,                                    08170000
MFA-TR*               HT.NAME_ID,                                       08180000
MFA-TR*               HT.CUSTOMER_ROLE_CD,                              08190000
MFA-TR*               HT.COMPANY_NO,                                    08200000
MFA-TR*               DY.STREET_NAME,                                   08210000
MFA-TR*               DY.HOUSE_NO,                                      08220000
MFA-TR*               DY.ADDR_PREFIX_1,                                 08230000
MFA-TR*               DY.ADDR_PREFIX_2,                                 08240000
MFA-TR*               DY.STREET_LOCATION_1,                             08250000
MFA-TR*               DY.STREET_LOCATION_2,                             08260000
MFA-TR*               UT.READ_CYCLE,                                            
MFA-TR*               UT.READ_ROUTE,                                            
MFA-TR*               UT.IC_NO                                                  
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                            08270000
MFA-TR*               CSS_NAME_ACCT_XREF HT,                            08280000
MFA-TR*               CSS_PREMISE PR,                                   08290000
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    08300000
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      08310000
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      08320000
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   08330000
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    08340000
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    08350000
MFA-TR*           AND PR.BLOCK             LIKE    :ADD-BLOCK-B         08360000
MFA-TR*           AND PR.LOT               LIKE    :ADD-LOT-B           08370000
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                  08380000
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID        08390000
MFA-TR*           AND PR.PREMISE_NO              = HT.PREMISE_NO        08400000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                  08410000
MFA-TR*           AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO                
MFA-TR*           AND UT.CODE_UTIL_TYPE          = 'G'                          
MFA-TR*           AND UT.RATE_PLAN_NO            > ' '                          
MFA-TR*           AND HT.COMPANY_NO        LIKE    :COMPANY-B                   
MFA-TR*           AND (EXISTS (SELECT 'X'                               08420000
MFA-TR*                          FROM CSS_NAME DQ                       08430000
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID         08440000
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')              08450000
MFA-TR*                OR NOT EXISTS                                    08460000
MFA-TR*                       (SELECT 'X'                               08470000
MFA-TR*                          FROM CSS_NAME DQ2                      08480000
MFA-TR*                         WHERE HT.NAME_ID = DQ2.NAME_ID))        08490000
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      08500000
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               08510000
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        08520000
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                    08530000
HPCCDM*    EJECT                                                        08540000
054800                                                                  
077000******************************************************************11530000
T21993*    DY-PR-CURSOR-L USED TO SEARCH ON LOT AND BLOCK WITH THE     *        
T21993*                   LOCAL OFFICE LIMIT.                          *        
T21993******************************************************************        
T21993                                                                  
T21993     EXEC SQL DECLARE DY-PR-CURSOR-L CURSOR FOR                   
T21993         SELECT HT.CUSTOMER_NO,                                   
T21993                HT.ACCOUNT_NO,                                    
T21993                HT.PREMISE_NO,                                    
T21993                HT.ADDRESS_ID,                                    
T21993                HT.NAME_ID,                                       
T21993                HT.CUSTOMER_ROLE_CD,                              
T21993                HT.COMPANY_NO,                                    
T21993                DY.STREET_NAME,                                   
T21993                DY.HOUSE_NO,                                      
T21993                DY.ADDR_PREFIX_1,                                 
T21993                DY.ADDR_PREFIX_2,                                 
T21993                DY.STREET_LOCATION_1,                             
T21993                DY.STREET_LOCATION_2,                             
T21993                UT.READ_CYCLE,                                    
T21993                UT.READ_ROUTE,                                    
T21993                UT.IC_NO                                          
T21993           FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
T21993                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
T21993                CSS_PREMISE PR WITH(READUNCOMMITTED),                     
T21993                CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
T21993          WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
T21993            AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
T21993            AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
T21993            AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
T21993            AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
T21993            AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
T21993            AND PR.BLOCK             LIKE    :ADD-BLOCK-B         
T21993            AND PR.LOT               LIKE    :ADD-LOT-B           
T21993            AND DY.ADDR_USAGE_CD           = 'F'                  
T21993            AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
T21993            AND PR.PREMISE_NO              = HT.PREMISE_NO        
T21993            AND HT.CUSTOMER_ROLE_CD        = ' '                  
T21993            AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY    
T21993            AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO        
T21993            AND UT.CODE_UTIL_TYPE          = 'G'                  
T21993            AND UT.RATE_PLAN_NO            > ' '                  
T21993            AND (EXISTS (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
T21993                          WHERE HT.NAME_ID   = DQ.NAME_ID         
T21993                            AND DQ.NAME_TYPE = 'CN')              
T21993                 OR NOT EXISTS                                    
T21993                        (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ2 WITH(READUNCOMMITTED)        
T21993                          WHERE HT.NAME_ID = DQ2.NAME_ID))        
T21993       ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
T21993                DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
T21993                DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
T35434       FOR READ ONLY                                      
T21993     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR-L CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               UT.READ_CYCLE,                                            
MFA-TR*               UT.READ_ROUTE,                                            
MFA-TR*               UT.IC_NO                                                  
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND PR.BLOCK             LIKE    :ADD-BLOCK-B                 
MFA-TR*           AND PR.LOT               LIKE    :ADD-LOT-B                   
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND PR.PREMISE_NO              = HT.PREMISE_NO                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.LOCAL_OFFICE            = :PARM-OFFICE-CITY            
MFA-TR*           AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO                
MFA-TR*           AND UT.CODE_UTIL_TYPE          = 'G'                          
MFA-TR*           AND UT.RATE_PLAN_NO            > ' '                          
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR NOT EXISTS                                            
MFA-TR*                       (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ2                              
MFA-TR*                         WHERE HT.NAME_ID = DQ2.NAME_ID))                
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993*    DY-PR-CURSOR-C USED TO SEARCH ON LOT AND BLOCK WITH THE     *        
T21993*                   CITY/STATE LIMIT.                            *        
T21993******************************************************************        
T21993                                                                  
T21993     EXEC SQL DECLARE DY-PR-CURSOR-C CURSOR FOR                   
T21993         SELECT HT.CUSTOMER_NO,                                   
T21993                HT.ACCOUNT_NO,                                    
T21993                HT.PREMISE_NO,                                    
T21993                HT.ADDRESS_ID,                                    
T21993                HT.NAME_ID,                                       
T21993                HT.CUSTOMER_ROLE_CD,                              
T21993                HT.COMPANY_NO,                                    
T21993                DY.STREET_NAME,                                   
T21993                DY.HOUSE_NO,                                      
T21993                DY.ADDR_PREFIX_1,                                 
T21993                DY.ADDR_PREFIX_2,                                 
T21993                DY.STREET_LOCATION_1,                             
T21993                DY.STREET_LOCATION_2,                             
T21993                UT.READ_CYCLE,                                    
T21993                UT.READ_ROUTE,                                    
T21993                UT.IC_NO                                          
T21993           FROM CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED),              
T21993                CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
T21993                CSS_PREMISE PR WITH(READUNCOMMITTED),                     
T21993                CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                 
T21993          WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B    
T21993            AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B      
T21993            AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B      
T21993            AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B   
T21993            AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B    
T21993            AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B    
T21993            AND PR.BLOCK             LIKE    :ADD-BLOCK-B         
T21993            AND PR.LOT               LIKE    :ADD-LOT-B           
T21993            AND DY.ADDR_USAGE_CD           = 'F'                  
T21993            AND DY.ADDRESS_ID              = HT.ADDRESS_ID        
T21993            AND PR.PREMISE_NO              = HT.PREMISE_NO        
T21993            AND HT.CUSTOMER_ROLE_CD        = ' '                  
T21993            AND HT.TOWN                    = :PARM-OFFICE-CITY    
T21993            AND HT.STATE                   = :ADD-STATE           
T21993            AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO        
T21993            AND UT.CODE_UTIL_TYPE          = 'G'                  
T21993            AND UT.RATE_PLAN_NO            > ' '                  
T21993            AND (EXISTS (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ WITH(READUNCOMMITTED)         
T21993                          WHERE HT.NAME_ID   = DQ.NAME_ID         
T21993                            AND DQ.NAME_TYPE = 'CN')              
T21993                 OR NOT EXISTS                                    
T21993                        (SELECT 'X'                               
T21993                           FROM CSS_NAME DQ2 WITH(READUNCOMMITTED)        
T21993                          WHERE HT.NAME_ID = DQ2.NAME_ID))        
T21993       ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                      
T21993                DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,               
T21993                DY.STREET_LOCATION_1, DY.STREET_LOCATION_2        
T35434       FOR READ ONLY                                      
T21993     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL DECLARE DY-PR-CURSOR-C CURSOR FOR                           
MFA-TR*        SELECT HT.CUSTOMER_NO,                                           
MFA-TR*               HT.ACCOUNT_NO,                                            
MFA-TR*               HT.PREMISE_NO,                                            
MFA-TR*               HT.ADDRESS_ID,                                            
MFA-TR*               HT.NAME_ID,                                               
MFA-TR*               HT.CUSTOMER_ROLE_CD,                                      
MFA-TR*               HT.COMPANY_NO,                                            
MFA-TR*               DY.STREET_NAME,                                           
MFA-TR*               DY.HOUSE_NO,                                              
MFA-TR*               DY.ADDR_PREFIX_1,                                         
MFA-TR*               DY.ADDR_PREFIX_2,                                         
MFA-TR*               DY.STREET_LOCATION_1,                                     
MFA-TR*               DY.STREET_LOCATION_2,                                     
MFA-TR*               UT.READ_CYCLE,                                            
MFA-TR*               UT.READ_ROUTE,                                            
MFA-TR*               UT.IC_NO                                                  
MFA-TR*          FROM CSS_ADDR_FORMATTED DY,                                    
MFA-TR*               CSS_NAME_ACCT_XREF HT,                                    
MFA-TR*               CSS_PREMISE PR,                                           
MFA-TR*               CSS_UTIL_ENVRNMT UT                                       
MFA-TR*         WHERE DY.HOUSE_NO          LIKE    :ADD-STREET-NBR-B            
MFA-TR*           AND DY.ADDR_PREFIX_1     LIKE    :ADD-PREFIX-1-B              
MFA-TR*           AND DY.ADDR_PREFIX_2     LIKE    :ADD-PREFIX-2-B              
MFA-TR*           AND DY.STREET_NAME       LIKE    :ADD-STREET-NAME-B           
MFA-TR*           AND DY.STREET_LOCATION_1 LIKE    :ADD-LOCATION-1-B            
MFA-TR*           AND DY.STREET_LOCATION_2 LIKE    :ADD-LOCATION-2-B            
MFA-TR*           AND PR.BLOCK             LIKE    :ADD-BLOCK-B                 
MFA-TR*           AND PR.LOT               LIKE    :ADD-LOT-B                   
MFA-TR*           AND DY.ADDR_USAGE_CD           = 'F'                          
MFA-TR*           AND DY.ADDRESS_ID              = HT.ADDRESS_ID                
MFA-TR*           AND PR.PREMISE_NO              = HT.PREMISE_NO                
MFA-TR*           AND HT.CUSTOMER_ROLE_CD        = ' '                          
MFA-TR*           AND HT.TOWN                    = :PARM-OFFICE-CITY            
MFA-TR*           AND HT.STATE                   = :ADD-STATE                   
MFA-TR*           AND HT.ACCOUNT_NO              = UT.ACCOUNT_NO                
MFA-TR*           AND UT.CODE_UTIL_TYPE          = 'G'                          
MFA-TR*           AND UT.RATE_PLAN_NO            > ' '                          
MFA-TR*           AND (EXISTS (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ                               
MFA-TR*                         WHERE HT.NAME_ID   = DQ.NAME_ID                 
MFA-TR*                           AND DQ.NAME_TYPE = 'CN')                      
MFA-TR*                OR NOT EXISTS                                            
MFA-TR*                       (SELECT 'X'                                       
MFA-TR*                          FROM CSS_NAME DQ2                              
MFA-TR*                         WHERE HT.NAME_ID = DQ2.NAME_ID))                
MFA-TR*      ORDER BY DY.STREET_NAME, DY.HOUSE_NO,                              
MFA-TR*               DY.ADDR_PREFIX_1, DY.ADDR_PREFIX_2,                       
MFA-TR*               DY.STREET_LOCATION_1, DY.STREET_LOCATION_2                
MFA-TR*      FOR FETCH ONLY WITH UR                                             
MFA-TR*    END-EXEC.                                                            
HPCCDM*    EJECT                                                                
T21993                                                                  
054800                                                                  
077000******************************************************************11530000
SC5100*    UT-CURSOR USED TO SEARCH FOR UTILITY.                       *11540000
077200******************************************************************11550000
077400     EXEC SQL                                                     
077500      DECLARE UT-CURSOR CURSOR FOR                                
077600        SELECT CODE_UTIL_TYPE,MAX(RATE_PLAN_NO)                   
077700           FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
077800         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                    
077900         GROUP BY CODE_UTIL_TYPE                                  
SC5000         HAVING CODE_UTIL_TYPE IN ('G')                           
T35434         FOR READ ONLY                                    
078100     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11560000
MFA-TR*     DECLARE UT-CURSOR CURSOR FOR                                11570000
MFA-TR*       SELECT CODE_UTIL_TYPE,MAX(RATE_PLAN_NO)                   11580000
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                  11590000
MFA-TR*        WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                    11600000
MFA-TR*        GROUP BY CODE_UTIL_TYPE                                  11610000
MFA-TR*        HAVING CODE_UTIL_TYPE IN ('G')                           11620000
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    END-EXEC.                                                    11630000
T14567                                                                  
REARCH LINKAGE SECTION.                                                 
REARCH 01 LINK-LIMTS                   PIC X(04).                       
REARCH 01 LINK-OFFICE-CITY             PIC X(26).                       
REARCH 01 LINK-SELECT-METHOD           PIC X(3).                        
REARCH 01 LINK-CRITERIA                PIC X(127).                      
REARCH                                                                  
REARCH PROCEDURE DIVISION USING                                         
REARCH                         LINK-LIMTS                               
REARCH                         LINK-OFFICE-CITY                         
REARCH                         LINK-SELECT-METHOD                       
REARCH                         LINK-CRITERIA.                           
078600******************************************************************11790000
078700* 0000-MAINLINE                                                  *11800000
078800*     CONTROLS THE MAIN PATH OF THE PROGRAM                      *11810000
078900******************************************************************11820000
079000                                                                  
079100 0000-MAINLINE.                                                   
079200                                                                  
079300     PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
079400     PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
079500     PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
079600     PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
079700                                                                  
079800 0000-EXIT.                                                       
079900     EXIT.                                                        
HPCCDM*    EJECT                                                        11930000
080100******************************************************************11940000
080200* 0100-INITIALIZE                                                *11950000
080300*                                                                *11960000
080400*     1. RESET DB2 ERROR HANDLERS                                *11970000
080500*     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *11980000
080600*     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *11990000
080700*     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*12000000
080800*                                                                *12010000
080900******************************************************************12020000
081000                                                                  
081100 0100-INITIALIZE.                                                 
081200                                                                  
081300     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
081400     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
081500     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     PERFORM  0100A-DECLARE-GTT   THRU 0100A-EXIT.                
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(RED_FLAG_INDICATOR)) AS 
           RED_FLAG_INDICATOR      
REARCH            ,LTRIM(RTRIM(ERROR_DESC))         AS ERROR_DESC              
REARCH            ,LTRIM(RTRIM(ADDRESS))            AS ADDRESS                 
REARCH            ,LTRIM(RTRIM(CITY))               AS CITY                    
REARCH            ,LTRIM(RTRIM(NAME))               AS NAME                    
REARCH            ,LTRIM(RTRIM(NAME_TYPE))          AS NAME_TYPE               
REARCH            ,LTRIM(RTRIM(ACCT_TYPE))          AS ACCT_TYPE               
REARCH            ,LTRIM(RTRIM(SERVICE_SUPPLIED))   AS SERVICE_SUPPLIED        
REARCH            ,LTRIM(RTRIM(SUBDIVISION))        AS SUBDIVISION             
REARCH            ,LTRIM(RTRIM(STATUS))             AS STATUS                  
REARCH            ,LTRIM(RTRIM(ACCOUNT_NO))         AS ACCOUNT_NO              
REARCH            ,LTRIM(RTRIM(SERVICE_AVAIL))      AS SERVICE_AVAIL           
REARCH            ,LTRIM(RTRIM(CUSTOMER_NO))        AS CUSTOMER_NO             
REARCH            ,LTRIM(RTRIM(LOCAL_OFFICE))       AS LOCAL_OFFICE            
REARCH            ,LTRIM(RTRIM(PREMISE_NO))         AS PREMISE_NO              
REARCH            ,LTRIM(RTRIM(NAME_FORMAT))        AS NAME_FORMAT             
REARCH            ,LTRIM(RTRIM(BANKRUPT_IND))       AS BANKRUPT_IND            
REARCH            ,LTRIM(RTRIM(CREDIT_GROUP))       AS CREDIT_GROUP            
REARCH            ,LTRIM(RTRIM(CREDIT_STATUS))      AS CREDIT_STATUS           
REARCH            ,LTRIM(RTRIM(CODE_ACCT_STAT))     AS CODE_ACCT_STAT          
REARCH            ,LTRIM(RTRIM(ELEC_RATE))          AS ELEC_RATE               
REARCH            ,LTRIM(RTRIM(GAS_RATE))           AS GAS_RATE                
REARCH            ,LTRIM(RTRIM(UNMETER_RATE))       AS UNMETER_RATE            
REARCH            ,LTRIM(RTRIM(ZIP_CODE))           AS ZIP_CODE                
REARCH            ,LTRIM(RTRIM(ZIP_CODE_TOKEN))     AS ZIP_CODE_TOKEN          
REARCH            ,LTRIM(RTRIM(MST_SUB_ACCT_IND))   AS MST_SUB_ACCT_IND        
REARCH            ,LTRIM(RTRIM(COMPANY_NO))         AS COMPANY_NO              
REARCH            ,LTRIM(RTRIM(CUST_NAME))          AS CUST_NAME               
REARCH            ,RTRIM(CODES_DATA_PRESENT) AS CODES_DATA_PRESENT      
REARCH            ,LTRIM(RTRIM(CODE_CRIT_OUTAGE))   AS CODE_CRIT_OUTAGE        
REARCH            ,LTRIM(RTRIM(ACCT_TYPE_DESC))     AS ACCT_TYPE_DESC          
REARCH            ,LTRIM(RTRIM(GROUP_CD))           AS GROUP_CD                
REARCH            ,LTRIM(RTRIM(METER_NO))           AS METE_NO                 
REARCH            ,LTRIM(RTRIM(CODE_METER_STATUS))  AS METER_STATUS            
REARCH            ,LTRIM(RTRIM(CODE_METER_LOC))     AS METER_LOCATION          
REARCH            ,LTRIM(RTRIM(METER_READ_SEQ))     AS MTR_READ_SEQUENCE       
REARCH            ,LTRIM(RTRIM(READ_CYCLE))         AS READ_CYCLE              
REARCH            ,LTRIM(RTRIM(READ_ROUTE))         AS READ_ROUTE              
A37666            ,LTRIM(RTRIM(ARCHIVE_IND))        AS ARCHIVE_IND             
REARCH         FROM                                                     
REARCH             #CSR02417_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STRIP(RED_FLAG_INDICATOR) AS RED_FLAG_INDICATOR              
MFA-TR*           ,STRIP(ERROR_DESC)         AS ERROR_DESC                      
MFA-TR*           ,STRIP(ADDRESS)            AS ADDRESS                         
MFA-TR*           ,STRIP(CITY)               AS CITY                            
MFA-TR*           ,STRIP(NAME)               AS NAME                            
MFA-TR*           ,STRIP(NAME_TYPE)          AS NAME_TYPE                       
MFA-TR*           ,STRIP(ACCT_TYPE)          AS ACCT_TYPE                       
MFA-TR*           ,STRIP(SERVICE_SUPPLIED)   AS SERVICE_SUPPLIED                
MFA-TR*           ,STRIP(SUBDIVISION)        AS SUBDIVISION                     
MFA-TR*           ,STRIP(STATUS)             AS STATUS                          
MFA-TR*           ,STRIP(ACCOUNT_NO)         AS ACCOUNT_NO                      
MFA-TR*           ,STRIP(SERVICE_AVAIL)      AS SERVICE_AVAIL                   
MFA-TR*           ,STRIP(CUSTOMER_NO)        AS CUSTOMER_NO                     
MFA-TR*           ,STRIP(LOCAL_OFFICE)       AS LOCAL_OFFICE                    
MFA-TR*           ,STRIP(PREMISE_NO)         AS PREMISE_NO                      
MFA-TR*           ,STRIP(NAME_FORMAT)        AS NAME_FORMAT                     
MFA-TR*           ,STRIP(BANKRUPT_IND)       AS BANKRUPT_IND                    
MFA-TR*           ,STRIP(CREDIT_GROUP)       AS CREDIT_GROUP                    
MFA-TR*           ,STRIP(CREDIT_STATUS)      AS CREDIT_STATUS                   
MFA-TR*           ,STRIP(CODE_ACCT_STAT)     AS CODE_ACCT_STAT                  
MFA-TR*           ,STRIP(ELEC_RATE)          AS ELEC_RATE                       
MFA-TR*           ,STRIP(GAS_RATE)           AS GAS_RATE                        
MFA-TR*           ,STRIP(UNMETER_RATE)       AS UNMETER_RATE                    
MFA-TR*           ,STRIP(ZIP_CODE)           AS ZIP_CODE                        
MFA-TR*           ,STRIP(ZIP_CODE_TOKEN)     AS ZIP_CODE_TOKEN                  
MFA-TR*           ,STRIP(MST_SUB_ACCT_IND)   AS MST_SUB_ACCT_IND                
MFA-TR*           ,STRIP(COMPANY_NO)         AS COMPANY_NO                      
MFA-TR*           ,STRIP(CUST_NAME)          AS CUST_NAME                       
MFA-TR*           ,RTRIM(CODES_DATA_PRESENT) AS CODES_DATA_PRESENT              
MFA-TR*           ,STRIP(CODE_CRIT_OUTAGE)   AS CODE_CRIT_OUTAGE                
MFA-TR*           ,STRIP(ACCT_TYPE_DESC)     AS ACCT_TYPE_DESC                  
MFA-TR*           ,STRIP(GROUP_CD)           AS GROUP_CD                        
MFA-TR*           ,STRIP(METER_NO)           AS METE_NO                         
MFA-TR*           ,STRIP(CODE_METER_STATUS)  AS METER_STATUS                    
MFA-TR*           ,STRIP(CODE_METER_LOC)     AS METER_LOCATION                  
MFA-TR*           ,STRIP(METER_READ_SEQ)     AS MTR_READ_SEQUENCE               
MFA-TR*           ,STRIP(READ_CYCLE)         AS READ_CYCLE                      
MFA-TR*           ,STRIP(READ_ROUTE)         AS READ_ROUTE                      
MFA-TR*           ,STRIP(ARCHIVE_IND)        AS ARCHIVE_IND                     
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02417_R1                                          
MFA-TR*    END-EXEC.                                                            
083300 0100-EXIT.                                                       
083400     EXIT.                                                        
HPCCDM*    EJECT                                                        12280000
REARCH                                                                  
REARCH 0100A-DECLARE-GTT.                                               
REARCH                                                                  
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02417_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02417_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02417_R1
              (                                                          
REARCH         RETURN_CODE              INT                         
REARCH        ,RED_FLAG_INDICATOR CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,ERROR_DESC CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2             
C35671        ,ADDRESS CHAR(71)  COLLATE LATIN1_GENERAL_100_BIN2                
REARCH        ,CITY CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2                   
C35671        ,NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2                   
REARCH        ,NAME_TYPE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2               
REARCH        ,ACCT_TYPE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH        ,SERVICE_SUPPLIED CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH        ,SUBDIVISION CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2                 
REARCH        ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
REARCH        ,SERVICE_AVAIL CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH        ,CUSTOMER_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,LOCAL_OFFICE CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,PREMISE_NO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
REARCH        ,NAME_FORMAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,BANKRUPT_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH        ,CREDIT_GROUP CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2            
REARCH        ,CREDIT_STATUS CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH        ,CODE_ACCT_STAT CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH        ,ELEC_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH        ,GAS_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2               
REARCH        ,UNMETER_RATE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH        ,ZIP_CODE CHAR(5)  COLLATE LATIN1_GENERAL_100_BIN2                
REARCH        ,ZIP_CODE_TOKEN CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH        ,MST_SUB_ACCT_IND CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2             
C35671        ,CUST_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH        ,CODES_DATA_PRESENT CHAR(32)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
REARCH        ,CODE_CRIT_OUTAGE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH        ,ACCT_TYPE_DESC CHAR(25)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH        ,GROUP_CD CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2               
REARCH        ,METER_NO CHAR(9)  COLLATE LATIN1_GENERAL_100_BIN2                
REARCH        ,CODE_METER_STATUS CHAR(1)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                         
REARCH        ,CODE_METER_LOC CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH        ,METER_READ_SEQ CHAR(6)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH        ,READ_CYCLE CHAR(2)  COLLATE LATIN1_GENERAL_100_BIN2              
REARCH        ,READ_ROUTE CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2              
A37666        ,ARCHIVE_IND CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2             
REARCH       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLSTATE TO WS-SQLSTATE.                                
REARCH     MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
REARCH                                                                  
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
REARCH            MOVE SQLCODE              TO ABEND-SQLCODE            
REARCH            MOVE SQLSTATE             TO ABEND-SQLSTATE           
REARCH            MOVE '0100A'               TO ACTIVE-PARAGRAPH        
REARCH            MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
REARCH            MOVE SPACES               TO ABEND-SQL-PREDICATES     
REARCH                                         ABEND-TABLES             
REARCH            MOVE 'CSR02417_R1'        TO TABLE-1                  
REARCH            MOVE SPACES               TO TABLE-ELEMENT-1          
REARCH            MOVE SPACES               TO HOSTVAR-ELEMENT-1        
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH 0100A-EXIT.                                                      
REARCH       EXIT.                                                      
REARCH                                                                  
083600******************************************************************12290000
083700* 1000-PROCESS-INPUT                                             *12300000
083800*                                                                *12310000
083900*     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *12320000
084000*     2. SPLIT OUT PARM STRING INFORMATION                       *12330000
084100*                                                                *12340000
084200******************************************************************12350000
084300                                                                  
084400 1000-PROCESS-INPUT.                                              
084500                                                                  
REARCH     MOVE LINK-LIMTS           TO  PARM-LIMITS.                   
REARCH     MOVE LINK-OFFICE-CITY     TO  PARM-OFFICE-CITY.              
REARCH     MOVE LINK-SELECT-METHOD   TO  PARM-SELECT-METHOD.            
REARCH     MOVE LINK-CRITERIA        TO  PARM-CRITERIA.                 
089000     MOVE SPACE TO WS-PARM-CRITERIA.                              
089100                                                                  
090000                                                                  
           EVALUATE TRUE                                                
SC5000         WHEN SEL-METH-GAS                                        
SC5100             UNSTRING PARM-CRITERIA DELIMITED BY CN-DELIMITER     
SC5200                 INTO ADD-ADDRESS-TYPE                            
SC5300                      ADD-STREET-NBR                              
SC5400                      ADD-PREFIX-1                                
SC5500                      ADD-PREFIX-2                                
SC5                         ADD-STREET-NAME                             
SC5                         ADD-LOCATION-1                              
SC5                         ADD-LOCATION-2                              
SC5                         ADD-CITY                                    
SC5                         ADD-OVERFLOW                                
SC5                         ADD-BLOCK                                   
SC5                         ADD-LOT                                     
T21993                      ADD-STATE                                   
SC5                         WS-MULTIPLIER                               
SC5                                                                     
SC5                IF ADD-STREET-NBR NOT = SPACE                        
SC5                    MOVE ADD-STREET-NBR TO WS-FROM                   
SC5                    MOVE LENGTH OF ADD-STREET-NBR TO WS-LENGTH       
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-STREET-NBR-L                  
SC5                    MOVE WS-HIGH TO ADD-STREET-NBR-H                 
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-STREET-NBR-B        
SC5                END-IF                                               
SC5                IF ADD-PREFIX-1 NOT = SPACE                          
SC5                    MOVE ADD-PREFIX-1 TO WS-FROM                     
SC5                    MOVE LENGTH OF ADD-PREFIX-1 TO WS-LENGTH         
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-PREFIX-1-L                    
SC5                    MOVE WS-HIGH TO ADD-PREFIX-1-H                   
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-PREFIX-1-B          
SC5                END-IF                                               
SC5                IF ADD-PREFIX-2 NOT = SPACE                          
SC5                    MOVE ADD-PREFIX-2 TO WS-FROM                     
SC5                    MOVE LENGTH OF ADD-PREFIX-2 TO WS-LENGTH         
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-PREFIX-2-L                    
SC5                    MOVE WS-HIGH TO ADD-PREFIX-2-H                   
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-PREFIX-2-B          
SC5                END-IF                                               
SC5                IF ADD-STREET-NAME NOT = SPACE                       
SC5                    MOVE ADD-STREET-NAME TO WS-FROM                  
SC5                    MOVE LENGTH OF ADD-STREET-NAME TO WS-LENGTH      
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-STREET-NAME-L                 
SC5                    MOVE WS-HIGH TO ADD-STREET-NAME-H                
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-STREET-NAME-B       
SC5                    MOVE WS-PERCENT-VARIABLE TO ADD-STREET-NAME-C    
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-STREET-OVERFLOW     
SC5                END-IF                                               
SC5                IF ADD-LOCATION-1 NOT = SPACE                        
SC5                    MOVE ADD-LOCATION-1 TO WS-FROM                   
SC5                    MOVE LENGTH OF ADD-LOCATION-1 TO WS-LENGTH       
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-LOCATION-1-L                  
SC5                    MOVE WS-HIGH TO ADD-LOCATION-1-H                 
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-LOCATION-1-B        
SC5                END-IF                                               
SC5                IF ADD-LOCATION-2 NOT = SPACE                        
SC5                    MOVE ADD-LOCATION-2 TO WS-FROM                   
SC5                    MOVE LENGTH OF ADD-LOCATION-2 TO WS-LENGTH       
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-LOCATION-2-L                  
SC5                    MOVE WS-HIGH TO ADD-LOCATION-2-H                 
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-LOCATION-2-B        
SC5                END-IF                                               
SC5                IF ADD-CITY NOT = SPACE                              
SC5                    MOVE ADD-CITY TO WS-FROM                         
SC5                    MOVE LENGTH OF ADD-CITY TO WS-LENGTH             
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-CITY-L                        
SC5                    MOVE WS-HIGH TO ADD-CITY-H                       
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-CITY-B              
SC5                END-IF                                               
SC5                IF ADD-OVERFLOW NOT = SPACE                          
SC5                    MOVE ADD-OVERFLOW TO WS-FROM                     
SC5                    MOVE LENGTH OF ADD-OVERFLOW-C TO WS-LENGTH       
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-OVERFLOW-L                    
SC5                    MOVE WS-HIGH TO ADD-OVERFLOW-H                   
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-OVERFLOW-B          
SC5                    MOVE WS-PERCENT-VARIABLE TO ADD-OVERFLOW-C       
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-OVERFLOW-STREET     
SC5                END-IF                                               
SC5                IF ADD-BLOCK NOT = SPACE                             
SC5                    MOVE ADD-BLOCK TO WS-FROM                        
SC5                    MOVE LENGTH OF ADD-BLOCK TO WS-LENGTH            
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-BLOCK-L                       
SC5                    MOVE WS-HIGH TO ADD-BLOCK-H                      
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-BLOCK-B             
SC5                    MOVE 'YES' TO WS-LOT-BLOCK                       
SC5                END-IF                                               
SC5                IF ADD-LOT NOT = SPACE                               
SC5                    MOVE ADD-LOT TO WS-FROM                          
SC5                    MOVE LENGTH OF ADD-LOT TO WS-LENGTH              
SC5                    PERFORM 1110-FORMAT-BETWEEN-PARM THRU 1110-EXIT  
SC5                    MOVE WS-LOW TO ADD-LOT-L                         
SC5                    MOVE WS-HIGH TO ADD-LOT-H                        
SC5                    MOVE WS-LIKE-VARIABLE TO ADD-LOT-B               
SC5                    MOVE 'YES' TO WS-LOT-BLOCK                       
SC5                END-IF                                               
T23617             IF PARM-LIMIT-TYPE = 'B'                             
T23617                 MOVE PARM-OFFICE-CITY TO COMPANY-B               
T23617             END-IF                                               
SC5                                                                     
115200     END-EVALUATE.                                                
T8339                                                                   
T8339 ***************************************************************** 15570000
T8339 ** IF A MULTIPLIER IS SENT UP MULTIPLY IT BY THE MAX ROWS, WHICH  15580000
T8339 ** IS CURRENTLY 20.  THIS WILL TELL THE RPC WHEN TO ACTUALLY      15590000
T8339 ** START SENDING THE RESULT TO THE CLIENT                         15600000
T8339 ***************************************************************** 15610000
T8339                                                                   
T8339                                                                   
T8339      IF WS-NEXT-MULTIPLIER > 0                                    
T8339         COMPUTE WS-NEXT-COUNTER =                                 
T8339              WS-NEXT-MULTIPLIER * CN-MAX-RETURN-ROWS              
T8339         ADD  1  TO WS-NEXT-COUNTER                                
T8339      END-IF.                                                      
                                                                        
C26959     PERFORM 7000-DETERMINE-REGION THRU 7000-EXIT.                
C26959                                                                  
C26959     EXEC SQL                                                     
C35434        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-TODAYS-DATE                        
C26959     END-EXEC.

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-TODAYS-DATE = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL.

                                                    
115300                                                                  
115400 1000-EXIT.                                                       
115500     EXIT.                                                        
HPCCDM*    EJECT                                                        15720000
115700******************************************************************15730000
115800* 1110-FORMAT-BETWEEN-PARM                                       *15740000
115900*                                                                *15750000
116000*     DETERMINE WHERE THE ASTERISK IS IN THE SOURCE FIELD. IF    *15760000
116100*     THE ASTERISK IS THE ONLY CHARACTER, SET LOW AND HIGH       *15770000
116200*     VARIABLES SUCH THAT ALL VALUES WILL PASS THE BETWEEN       *15780000
116300*     PREDICATE. IF NO ASTERISK IS FOUND, MOVE THE SOURCE VALUE  *15790000
116400*     TO BOTH THE LOW AND HIGH RANGE VARIABLES. IF AN ASTERISK   *15800000
116500*     IS FOUND AFTER OTHER CHARACTERS, MOVE THE CHARACTERS UP TO *15810000
116600*     THE ASTERISK LEAVING LOW AND HIGH VALUES AFTER THESE       *15820000
116700*     CHARACTERS.                                                *15830000
116800*                                                                *15840000
116900******************************************************************15850000
117000                                                                  
117100 1110-FORMAT-BETWEEN-PARM.                                        
117200                                                                  
117300     MOVE ZERO TO WS-ASTERISK-POS.                                
117400     INSPECT WS-FROM                                              
117500         TALLYING WS-ASTERISK-POS                                 
117600         FOR CHARACTERS                                           
117700         BEFORE CN-ASTERISK.                                      
117800     IF WS-ASTERISK-POS = ZERO                                    
117900         MOVE WS-UNDERSCORE TO WS-LIKE-VARIABLE                   
117900         MOVE WS-PERCENT    TO WS-PERCENT-VARIABLE                
118000         MOVE LOW-VALUE     TO WS-LOW                             
118100         MOVE HIGH-VALUE    TO WS-HIGH                            
118200     ELSE                                                         
118300         IF WS-ASTERISK-POS > WS-LENGTH                           
118400             MOVE WS-FROM TO WS-LOW                               
118500                             WS-HIGH                              
118600                             WS-LIKE-VARIABLE                     
118600                             WS-PERCENT-VARIABLE                  
118700         ELSE                                                     
118800             MOVE LOW-VALUE     TO WS-LOW                         
118900             MOVE HIGH-VALUE    TO WS-HIGH                        
119000             MOVE WS-UNDERSCORE TO WS-LIKE-VARIABLE               
119000             MOVE WS-PERCENT    TO WS-PERCENT-VARIABLE            
119100             PERFORM                                              
119200                 VARYING WS-SUB FROM 1 BY 1                       
119300                   UNTIL WS-SUB > WS-ASTERISK-POS                 
119400                      OR WS-SUB > WS-LENGTH                       
119500                 MOVE WS-FROM-X (WS-SUB) TO WS-LOW-X (WS-SUB)     
119600                 MOVE WS-FROM-X (WS-SUB) TO WS-HIGH-X (WS-SUB)    
119700                 MOVE WS-FROM-X (WS-SUB) TO WS-LIKE-X (WS-SUB)    
119700                 MOVE WS-FROM-X (WS-SUB) TO WS-PERCENT-X (WS-SUB) 
119800             END-PERFORM                                          
119900         END-IF                                                   
120000     END-IF.                                                      
120100                                                                  
120200 1110-EXIT.                                                       
120300     EXIT.                                                        
HPCCDM*    EJECT                                                        16240000
120500******************************************************************16250000
120600* 2000-PROCESS-OUTPUT                                            *16260000
120700*                                                                *16270000
120800*     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *16280000
120900*     BUILD THE RESULT SET.                                      *16290000
121000*                                                                *16300000
121100******************************************************************16310000
121200                                                                  
121300 2000-PROCESS-OUTPUT.                                             
121400                                                                  
SC5                                                                     
SC5                                                                     
182500     SET NEED-NAME-NO         TO TRUE.                            
182600     SET NEED-ADDRESS-NO      TO TRUE.                            
182700     SET NEED-CITY-NO         TO TRUE.                            
182800                                                                  
182900     EVALUATE TRUE                                                
SC5200         WHEN (SEL-METH-GAS)                                      
T8339              IF WS-LOT-BLOCK = 'YES'                              
T8339                 PERFORM 2211-SEARCH-VIA-DY-PR-CURSOR              
T8339                         THRU 2211-EXIT                            
T8339              ELSE                                                 
SC5300                PERFORM 2216-SEARCH-VIA-B-GAS-CURSOR              
SC5                           THRU 2216-EXIT                            
SC5                END-IF                                               
185400     END-EVALUATE.                                                
185500                                                                  
185600     IF CTR-ROWS = ZERO                                           
185700         MOVE NOT-FOUND TO RS-RETURN-CODE                         
REARCH         PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
185800         PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
185900     END-IF.                                                      
186000                                                                  
186100     IF CTR-ROWS = CN-MAX-RETURN-ROWS                             
186200         MOVE 101 TO RS-RETURN-CODE                               
REARCH         PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
186300         PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
186400     END-IF.                                                      
186500                                                                  
186600 2000-EXIT.                                                       
186700     EXIT.                                                        
HPCCDM*    EJECT                                                        23570000
REARCH******************************************************************23580000
REARCH* 2000A-MOVE-RESULT                                              *23870000
REARCH******************************************************************23920000
REARCH 2000A-MOVE-RESULT.                                               
REARCH       MOVE RS-RETURN-CODE         TO  S-RETURN-CODE.             
REARCH       MOVE RS-RED-FLAG-INDICATOR  TO  S-RED-FLAG-INDICATOR.      
REARCH       MOVE RS-ADDRESS             TO  S-ADDRESS.                 
REARCH       MOVE RS-CITY                TO  S-CITY.                    
REARCH       MOVE RS-NAME                TO  S-NAME.                    
REARCH       MOVE RS-NAME-TYPE           TO  S-NAME-TYPE.               
REARCH       MOVE RS-ACCT-TYPE           TO  S-ACCT-TYPE.               
REARCH       MOVE RS-SERVICE-SUPPLIED    TO  S-SERVICE-SUPPLIED.        
REARCH       MOVE RS-SUBDIVISION         TO  S-SUBDIVISION.             
REARCH       MOVE RS-STATUS              TO  S-STATUS.                  
REARCH       MOVE RS-ACCOUNT-NO          TO  S-ACCOUNT-NO .             
REARCH       MOVE RS-SERVICE-AVAIL       TO  S-SERVICE-AVAIL.           
REARCH       MOVE RS-CUSTOMER-NO         TO  S-CUSTOMER-NO .            
REARCH       MOVE RS-LOCAL-OFFICE        TO  S-LOCAL-OFFICE.            
REARCH       MOVE RS-PREMISE-NO          TO  S-PREMISE-NO.              
REARCH       MOVE RS-NAME-FORMAT         TO  S-NAME-FORMAT.             
REARCH       MOVE RS-BANKRUPT-IND        TO  S-BANKRUPT-IND.            
REARCH       MOVE RS-CREDIT-GROUP        TO  S-CREDIT-GROUP.            
REARCH       MOVE RS-CREDIT-STATUS       TO  S-CREDIT-STATUS.           
REARCH       MOVE RS-CODE-ACCT-STAT      TO  S-CODE-ACCT-STAT.          
REARCH       MOVE RS-ELEC-RATE           TO  S-ELEC-RATE.               
REARCH       MOVE RS-GAS-RATE            TO  S-GAS-RATE.                
REARCH       MOVE RS-UNMETER-RATE        TO  S-UNMETER-RATE.            
REARCH       MOVE RS-ZIP-CODE            TO  S-ZIP-CODE.                
REARCH       MOVE RS-ZIP-CODE-TOKEN      TO  S-ZIP-CODE-TOKEN.          
REARCH       MOVE RS-MST-SUB-ACCT-IND    TO  S-MST-SUB-ACCT-IND .       
REARCH       MOVE RS-COMPANY-NO          TO  S-COMPANY-NO .             
REARCH       MOVE RS-CUST-NAME           TO  S-CUST-NAME.               
REARCH       MOVE RS-CODES-DATA-PRESENT  TO  S-CODES-DATA-PRESENT.      
REARCH       MOVE RS-CODE-CRIT-OUTAGE    TO  S-CODE-CRIT-OUTAGE.        
REARCH       MOVE RS-ACCT-TYPE-DESC      TO  S-ACCT-TYPE-DESC .         
REARCH       MOVE RS-METER-NO            TO  S-METER-NO.                
REARCH       MOVE RS-CODE-METER-STATUS   TO  S-CODE-METER-STATUS.       
REARCH       MOVE RS-CODE-METER-LOC      TO  S-CODE-METER-LOC .         
REARCH       MOVE RS-METER-READ-SEQ      TO  S-METER-READ-SEQ.          
REARCH       MOVE RS-READ-CYCLE          TO  S-READ-CYCLE .             
REARCH       MOVE RS-READ-ROUTE          TO  S-READ-ROUTE .             
REARCH       MOVE RS-GROUP-CD            TO  S-GROUP-CD .               
A37666       MOVE RS-ARCHIVE-IND         TO  S-ARCHIVE-IND.             
REARCH       MOVE RS-ERROR-DESC          TO  S-ERROR-DESC.              
REARCH 2000A-EXIT.                                                      
REARCH       EXIT.                                                      
T8339 ******************************************************************23580000
T8339 * 2211-SEARCH-VIA-DY-PR-CURSOR                                   *23870000
T8339 *                                                                *23880000
T8339 *     SEARCH FOR ADDRESSES VIA THE DY-PR CURSOR. CALL COMMON     *23890000
T8339 *     PARAGRAPH TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.  *23900000
T8339 *                                                                *23910000
T8339 ******************************************************************23920000
T8339                                                                   
T8339  2211-SEARCH-VIA-DY-PR-CURSOR.                                    
T8339                                                                   
T8339      SET NEED-NAME-NO TO TRUE.                                    
T8339      SET NEED-CITY TO TRUE.                                       
T8339                                                                   
T8339      PERFORM 7280-OPEN-DY-PR-CURSOR               THRU 7280-EXIT. 
T8339      PERFORM 7281-FETCH-DY-PR-CURSOR              THRU 7281-EXIT. 
T8339                                                                   
T8339      PERFORM                                                      
T8339          UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
T8339                 CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
T8339          PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
T8339          PERFORM 7281-FETCH-DY-PR-CURSOR          THRU 7281-EXIT  
T8339      END-PERFORM.                                                 
T8339                                                                   
T8339      PERFORM 7282-CLOSE-DY-PR-CURSOR              THRU 7282-EXIT. 
T8339                                                                   
T8339  2211-EXIT.                                                       
T8339      EXIT.                                                        
HPCCDM*    EJECT                                                        24130000
T21993                                                                  
T21993******************************************************************        
T21993* 2212-SEARCH-VIA-DY-PR-CURSOR-L                                 *        
T21993*                                                                *        
T21993*     SEARCH FOR ADDRESSES VIA THE DY-PR-CURSOR-L WITH THE       *        
T21993*     LOCAL OFFICE LIMIT.                                        *        
T21993*     CALL COMMON PARAGRAPH TO RETRIEVE ADDITIONAL DATA.         *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 2212-SEARCH-VIA-DY-PR-CURSOR-L.                                  
T21993                                                                  
T21993     SET NEED-NAME-NO TO TRUE.                                    
T21993     SET NEED-CITY TO TRUE.                                       
T21993                                                                  
T21993     PERFORM 7283-OPEN-DY-PR-CURSOR-L             THRU 7283-EXIT. 
T21993     PERFORM 7284-FETCH-DY-PR-CURSOR-L            THRU 7284-EXIT. 
T21993                                                                  
T21993     PERFORM                                                      
T21993         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
T21993                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
T21993         PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
T21993         PERFORM 7284-FETCH-DY-PR-CURSOR-L        THRU 7284-EXIT  
T21993     END-PERFORM.                                                 
T21993                                                                  
T21993     PERFORM 7285-CLOSE-DY-PR-CURSOR-L            THRU 7285-EXIT. 
T21993                                                                  
T21993 2212-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 2213-SEARCH-VIA-DY-PR-CURSOR-C                                 *        
T21993*                                                                *        
T21993*     SEARCH FOR ADDRESSES VIA THE DY-PR-CURSOR-C WITH THE       *        
T21993*     CITY/STATE LIMIT.                                          *        
T21993*     CALL COMMON PARAGRAPH TO RETRIEVE ADDITIONAL DATA.         *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 2213-SEARCH-VIA-DY-PR-CURSOR-C.                                  
T21993                                                                  
T21993     SET NEED-NAME-NO TO TRUE.                                    
T21993     SET NEED-CITY TO TRUE.                                       
T21993                                                                  
T21993     PERFORM 7286-OPEN-DY-PR-CURSOR-C             THRU 7286-EXIT. 
T21993     PERFORM 7287-FETCH-DY-PR-CURSOR-C            THRU 7287-EXIT. 
T21993                                                                  
T21993     PERFORM                                                      
T21993         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
T21993                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
T21993         PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
T21993         PERFORM 7287-FETCH-DY-PR-CURSOR-C        THRU 7287-EXIT  
T21993     END-PERFORM.                                                 
T21993                                                                  
T21993     PERFORM 7288-CLOSE-DY-PR-CURSOR-C            THRU 7288-EXIT. 
T21993                                                                  
T21993 2213-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 2214-SEARCH-VIA-B-GAS-CURSOR-L                                 *        
T21993*                                                                *        
T21993*     SEARCH FOR GAS ADDRESSES VIA THE B-GAS-CURSOR-L WITH THE   *        
T21993*     LOCAL OFFICE LIMIT.                                        *        
T21993*     CALL COMMON PARAGRAPH TO RETRIEVE ADDTIONAL DATA.          *        
T21993*                                                                *        
T21993******************************************************************        
T21993 2214-SEARCH-VIA-B-GAS-CURSOR-L.                                  
T21993                                                                  
T21993     SET NEED-NAME-NO TO TRUE.                                    
T21993     SET NEED-CITY TO TRUE.                                       
T21993                                                                  
T21993     PERFORM 7221-OPEN-B-GAS-CURSOR-L             THRU 7221-EXIT. 
T21993     PERFORM 7222-FETCH-B-GAS-CURSOR-L            THRU 7222-EXIT. 
T21993                                                                  
T21993     PERFORM                                                      
T21993         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
T21993                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
T21993         PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
T21993         PERFORM 7222-FETCH-B-GAS-CURSOR-L        THRU 7222-EXIT  
T21993     END-PERFORM.                                                 
T21993                                                                  
T21993     PERFORM 7223-CLOSE-B-GAS-CURSOR-L            THRU 7223-EXIT. 
T21993                                                                  
T21993 2214-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 2215-SEARCH-VIA-B-GAS-CURSOR-C                                 *        
T21993*                                                                *        
T21993*     SEARCH FOR GAS ADDRESSES VIA THE B-GAS-CURSOR-C WITH THE   *        
T21993*     CITY/STATE LIMIT.                                          *        
T21993*     CALL COMMON PARAGRAPH TO RETRIEVE ADDTIONAL DATA.          *        
T21993*                                                                *        
T21993******************************************************************        
T21993 2215-SEARCH-VIA-B-GAS-CURSOR-C.                                  
T21993                                                                  
T21993     SET NEED-NAME-NO TO TRUE.                                    
T21993     SET NEED-CITY TO TRUE.                                       
T21993                                                                  
T21993     PERFORM 7224-OPEN-B-GAS-CURSOR-C             THRU 7224-EXIT. 
T21993     PERFORM 7225-FETCH-B-GAS-CURSOR-C            THRU 7225-EXIT. 
T21993                                                                  
T21993     PERFORM                                                      
T21993         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
T21993                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
T21993         PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
T21993         PERFORM 7225-FETCH-B-GAS-CURSOR-C        THRU 7225-EXIT  
T21993     END-PERFORM.                                                 
T21993                                                                  
T21993     PERFORM 7226-CLOSE-B-GAS-CURSOR-C            THRU 7226-EXIT. 
T21993                                                                  
T21993 2215-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
SC5700******************************************************************        
SC5800* 2216-SEARCH-VIA-B-GAS-CURSOR                                   *        
SC5900*                                                                *        
SC5000*     SEARCH FOR GAS ADDRESSES VIA THE B-GAS-CURSOR. CALL COMMON *        
SC5100*     PARAGRAPH TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.  *        
SC5200*                                                                *        
SC5300******************************************************************        
SC5500 2216-SEARCH-VIA-B-GAS-CURSOR.                                    
SC5600                                                                  
SC5900     SET NEED-NAME-NO TO TRUE.                                    
SC5000     SET NEED-CITY TO TRUE.                                       
SC5100                                                                  
SC5200     PERFORM 7227-OPEN-B-GAS-CURSOR               THRU 7227-EXIT. 
SC5300     PERFORM 7228-FETCH-B-GAS-CURSOR              THRU 7228-EXIT. 
SC5400                                                                  
SC5500     PERFORM                                                      
SC5600         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
SC5700                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
SC5800         PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
SC5900         PERFORM 7228-FETCH-B-GAS-CURSOR          THRU 7228-EXIT  
SC5000     END-PERFORM.                                                 
SC5100                                                                  
SC5200     PERFORM 7229-CLOSE-B-GAS-CURSOR              THRU 7229-EXIT. 
SC5                                                                     
SC5500 2216-EXIT.                                                       
SC5600     EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
SC5700******************************************************************        
SC5800* 2218-SEARCH-VIA-B-MTR-CURSOR                                   *        
SC5900*                                                                *        
SC5000*     SEARCH FOR GAS ADDRESSES VIA THE B-MTR-CURSOR. CALL COMMON *        
SC5100*     PARAGRAPH TO RETRIEVE ADDTIONAL DATA AND PERFORM FILTERS.  *        
SC5200*                                                                *        
SC5300******************************************************************        
SC5500 2218-SEARCH-VIA-B-MTR-CURSOR.                                    
SC5600                                                                  
SC5900     SET NEED-NAME-NO TO TRUE.                                    
SC5000     SET NEED-CITY TO TRUE.                                       
SC5100                                                                  
SC5200     PERFORM 7231-OPEN-B-MTR-CURSOR               THRU 7231-EXIT. 
SC5300     PERFORM 7232-FETCH-B-MTR-CURSOR              THRU 7232-EXIT. 
SC5400                                                                  
SC5500     PERFORM                                                      
SC5600         UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND OR              
SC5700                CTR-ROWS >= CN-MAX-RETURN-ROWS)                   
SC5            MOVE MN-METER-NO TO RS-METER-NO                          
SC5            MOVE MN-CODE-METER-STATUS TO RS-CODE-METER-STATUS        
SC5            MOVE MN-CODE-METER-LOC TO RS-CODE-METER-LOC              
SC5            MOVE MN-REGISTER-RD-SEQ TO RS-METER-READ-SEQ             
REARCH         PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
SC5            PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
SC5900         PERFORM 7232-FETCH-B-MTR-CURSOR          THRU 7232-EXIT  
SC5000     END-PERFORM.                                                 
SC5100                                                                  
SC5200     PERFORM 7233-CLOSE-B-MTR-CURSOR              THRU 7233-EXIT. 
SC5                                                                     
SC5500 2218-EXIT.                                                       
SC5600     EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
222700******************************************************************28170000
222800* 2500-PROCESS-ROW                                               *28180000
222900*                                                                *28190000
223000*     GET ANY MISSING DATA NOT FOUND IN THE ORIGINAL CURSORS.    *28200000
223100*     PERFORM FILTERING BASED ON SELECTION CRITERIA. FORMAT      *28210000
223200*     RESULT SET AND SEND DATA.                                  *28220000
223300*                                                                *28230000
223400******************************************************************28240000
223500                                                                  
223600 2500-PROCESS-ROW.                                                
223700                                                                  
223800     INITIALIZE TDS-RETURN-FIELDS.                                
223900                                                                  
T8339 ***************************************************************** 28300000
T8339 ** FOR ALL THE SELECTION MATERIAL EXCEPT MASTER ACCOUNT BYPASS    28310000
T8339 ** THIS SEND ROW LOGIC UNTIL YOU REACH THE SPECIFIED ROW THAT     28320000
T8339 ** YOU WANT TO START RETURNING TO THE CLIENT (1,21,41, ETC)       28330000
T8339 ***************************************************************** 28340000
T8339                                                                   
T17660     IF LIMIT-LOCAL-OFFICE OR LIMIT-CITY OR                       
T17660        FILTER-WRITE-OFF OR                                       
C31811*        FILTER-JUDGEMENT OR                                              
T17660        FILTER-BANKRUPT OR LIMIT-ACTIVE                           
T17660            CONTINUE                                              
T17660     ELSE                                                         
T8339      IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER                       
T8339           ADD  1  TO WS-ROWS-PROCESSED                            
T8339           GO TO 2500-EXIT                                         
T8339      END-IF
           END-IF.                                                      
T8339                                                                   
224100     MOVE HT-COMPANY-NO TO RS-COMPANY-NO.                         
224200                                                                  
224300     IF HT-NAME-ID NOT EQUAL ZERO THEN                            
224400         PERFORM 7930-GET-NAME               THRU 7930-EXIT       
T14069*        IF (HT-CUSTOMER-ROLE-CD > SPACES OR                      28540000
T14069*            DQ-NAME-TYPE NOT = 'CN') AND HT-ACCOUNT-NO > 0       28550000
T14069         IF (HT-CUSTOMER-ROLE-CD > SPACES OR                      
T14069             DQ-NAME-TYPE NOT = 'CN') AND (HT-ACCOUNT-NO > 0      
T14069              OR DQ-NAME-TYPE = 'SN')                             
T14069            IF HT-ACCOUNT-NO > 0                                  
224700               PERFORM 7970-GET-CUST-NAME  THRU 7970-EXIT         
T14069            ELSE                                                  
T14069               PERFORM 7971-GET-CUST-NAME-WCUSNUM                 
T14069                                           THRU 7971-EXIT         
T14069            END-IF                                                
224800            IF WS-CUST-NAME-FORMAT = 'I'                          
224900               MOVE WS-CUST-LAST-NAME TO WS-FROM                  
225000               PERFORM 2510-PROCESS-FROM-STRING                   
225100               MOVE WS-FROM TO WS-CUST-LAST-NAME                  
225200                                                                  
225300               MOVE WS-CUST-FIRST-NAME TO WS-FROM                 
225400               PERFORM 2510-PROCESS-FROM-STRING                   
225500               MOVE WS-FROM TO WS-CUST-FIRST-NAME                 
225600                                                                  
225700               IF WS-CUST-MIDDLE-NAME NOT = SPACE                 
225800                   MOVE WS-CUST-MIDDLE-NAME TO WS-FROM            
225900                   PERFORM 2510-PROCESS-FROM-STRING               
225910                   MOVE WS-FROM TO WS-CUST-MIDDLE-NAME            
225920               END-IF                                             
225930                                                                  
225940               MOVE WS-CUST-TITLE-SUFFIX-1 TO WS-FROM             
225950               PERFORM 2510-PROCESS-FROM-STRING                   
225960               MOVE WS-FROM TO WS-CUST-TITLE-SUFFIX-1             
225970                                                                  
225971               IF WS-CUST-MIDDLE-NAME = SPACE                     
225972                STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER   
225973                 ', ' DELIMITED SIZE                              
225974                 WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER        
225975                 ' ' DELIMITED SIZE                               
225976                 WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER    
225977                 INTO RS-CUST-NAME                                
225978                   END-STRING                                     
225979               ELSE                                               
225980                 STRING WS-CUST-LAST-NAME DELIMITED CN-DELIMITER  
225981                  ', ' DELIMITED SIZE                             
225982                  WS-CUST-FIRST-NAME DELIMITED CN-DELIMITER       
225983                  ' ' DELIMITED SIZE                              
225984                  WS-CUST-MIDDLE-NAME DELIMITED CN-DELIMITER      
225985                  ' ' DELIMITED SIZE                              
225986                  WS-CUST-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER   
225987                  INTO RS-CUST-NAME                               
225988                   END-STRING                                     
225989               END-IF                                             
225990            ELSE                                                  
225991               MOVE WS-CUST-FULL-NAME     TO RS-CUST-NAME         
225992            END-IF                                                
225993                                                                  
225994         END-IF                                                   
225995     END-IF.                                                      
225996                                                                  
                                                                        
226800     IF HT-ACCOUNT-NO NOT EQUAL TO ZERO                           
C37666        MOVE 'N' TO WS-ARCHIVED-ACCOUNT                           
226900        PERFORM 7915-GET-ACCOUNT-DETAILS     THRU 7915-EXIT       
P35332        MOVE AT-CODE-CRIT-OUTAGE TO RS-CODE-CRIT-OUTAGE           
227000     ELSE                                                         
227100        MOVE SPACE TO AT-CODE-ACCT-STAT                           
227200                      AT-ACCOUNT-TYPE-CODE                        
227300                      AT-LOCAL-OFFICE                             
227400                      AT-BANKRUPTCY-IND                           
227500                      AT-MST-SUB-ACCT-IND                         
227600                      AT-CODES-DATA-PRESENT                       
227700                      AT-CREDIT-GROUP                             
227800                      AT-CREDIT-STATUS-CODE                       
T8430                       AT-CODE-CRIT-OUTAGE                         
ACT282                      SW-CODE-LONG-DESC                           
227900     END-IF.                                                      
T8381                                                                   
T8381      IF WS-CODE-RED-FLAG = 'A'                                    
T8381          MOVE 'Y' TO RS-RED-FLAG-INDICATOR                        
T8381      ELSE                                                         
T8381          MOVE 'N' TO RS-RED-FLAG-INDICATOR                        
T8381      END-IF.                                                      
228000                                                                  
231600     IF HT-PREMISE-NO NOT EQUAL TO ZERO                           
231700         PERFORM 7940-GET-PREMISE-DETAILS     THRU 7940-EXIT      
231900     ELSE                                                         
232000         MOVE SPACE  TO B0-SUBDIVISION-DESC                       
232100     END-IF.                                                      
228400                                                                  
228480                                                                  
228600     IF (FILTER-BANKRUPT AND                                      
228700         AT-BANKRUPTCY-IND NOT = 'B')                             
228800     OR (LIMIT-LOCAL-OFFICE AND                                   
228900         AT-LOCAL-OFFICE NOT = PARM-OFFICE-CITY)                  
228800     OR (LIMIT-ACTIVE AND                                         
228900         AT-CODE-ACCT-STAT NOT = 'A')                             
229000     OR (FILTER-WRITE-OFF AND WS-CODE-CHRG-OFF NOT = 'A')         
C31811     OR (FILTER-ACTIVE-CSR AND AT-CODE-ACCT-STAT NOT = 'A')       
229010         GO TO 2500-EXIT                                          
229020     END-IF.                                                      
229030                                                                  
229040     IF HT-ADDRESS-ID NOT EQUAL TO ZERO                           
229050         PERFORM 7920-GET-ADDRESS          THRU 7920-EXIT         
229060         PERFORM 7925-GET-CITY             THRU 7925-EXIT         
229070     ELSE                                                         
229080         MOVE SPACE TO DY-HOUSE-NO                                
229090                       DY-ADDR-PREFIX-1                           
229100                       DY-ADDR-PREFIX-2                           
229200                       DY-STREET-NAME                             
229300                       DY-ADDRESS-OVERFLOW                        
229400                       DY-ADDR-USAGE-CD                           
229500                       DY-STREET-SUFFIX                           
229600                       DY-STREET-LOCATION-1                       
229700                       DY-STREET-LOCATION-2                       
229800                       DY-ZIP-CODE                                
229900                       DY-ZIP-CODE-TOKEN                          
230000                       A4-TOWN                                    
230100     END-IF.                                                      
230200                                                                  
230700     IF LIMIT-CITY AND A4-TOWN NOT = PARM-OFFICE-CITY             
230800         GO TO 2500-EXIT                                          
230900     END-IF.                                                      
231000                                                                  
231500                                                                  
T17660     IF LIMIT-LOCAL-OFFICE OR LIMIT-CITY OR                       
T17660        FILTER-WRITE-OFF OR                                       
C31811*       FILTER-JUDGEMENT OR                                               
T17660        FILTER-BANKRUPT OR LIMIT-ACTIVE                           
T17660           IF WS-ROWS-PROCESSED < WS-NEXT-COUNTER                 
T17660              ADD  1  TO WS-ROWS-PROCESSED                        
T17660              GO TO 2500-EXIT                                     
T17660           END-IF                                                 
T17660     END-IF.                                                      
T8339                                                                   
232200                                                                  
232300     MOVE B0-SUBDIVISION-DESC   TO RS-SUBDIVISION                 
232400     MOVE HT-ACCOUNT-NO         TO RS-ACCOUNT-NO.                 
232500     MOVE DQ-NAME-TYPE          TO RS-NAME-TYPE.                  
232600     MOVE AT-ACCOUNT-TYPE-CODE  TO RS-ACCT-TYPE.                  
ACT282     MOVE SW-CODE-LONG-DESC     TO RS-ACCT-TYPE-DESC.             
232700     MOVE AT-CREDIT-GROUP       TO RS-CREDIT-GROUP.               
232800     MOVE AT-CREDIT-STATUS-CODE TO RS-CREDIT-STATUS.              
232900     MOVE AT-CODE-ACCT-STAT     TO RS-CODE-ACCT-STAT.             
233000     MOVE SPACE                 TO RS-ELEC-RATE.                  
233100     MOVE SPACE                 TO RS-GAS-RATE.                   
233200     MOVE SPACE                 TO RS-UNMETER-RATE.               
233300     MOVE DY-ZIP-CODE           TO RS-ZIP-CODE.                   
233400     MOVE DY-ZIP-CODE-TOKEN     TO RS-ZIP-CODE-TOKEN.             
233500     MOVE AT-MST-SUB-ACCT-IND   TO RS-MST-SUB-ACCT-IND.           
PCR285     MOVE AT-CODES-DATA-PRESENT TO RS-CODES-DATA-PRESENT.         
T18894     INSPECT RS-CODES-DATA-PRESENT REPLACING ALL                  
T18894         LOW-VALUES BY ' '.                                       
P35332*    PERFORM 7980-SELECT-WHITE-CROSS THRU 7980-EXIT.              30290000
233600     PERFORM 7274-OPEN-UT-CURSOR THRU 7274-EXIT.                  
233700     PERFORM 7275-FETCH-UT-CURSOR THRU 7275-EXIT.                 
233800                                                                  
233900     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
234000          EVALUATE UT-CODE-UTIL-TYPE                              
                    WHEN 'G'                                            
                        IF WS-UNMTR-FOUND = 'N'                         
                           MOVE UT-RATE-PLAN-NO   TO RS-GAS-RATE        
                           PERFORM 7730-CHECK-UNMTR-GAS  THRU 7730-EXIT 
                        ELSE                                            
                           PERFORM 7710-GET-GAS-RATE  THRU 7710-EXIT    
                        END-IF                                          
                    WHEN 'U'                                            
                        IF UT-RATE-PLAN-NO > RS-UNMETER-RATE            
                           MOVE UT-RATE-PLAN-NO   TO RS-UNMETER-RATE    
                        END-IF                                          
234250          END-EVALUATE                                            
234260          PERFORM 7275-FETCH-UT-CURSOR      THRU 7275-EXIT        
234270     END-PERFORM.                                                 
234280     PERFORM 7276-CLOSE-UT-CURSOR           THRU 7276-EXIT.       
234300                                                                  
234400     IF DQ-NAME-FORMAT = 'I'                                      
234500         MOVE DQ-LAST-NAME TO WS-FROM                             
234600         PERFORM 2510-PROCESS-FROM-STRING                         
234700         MOVE WS-FROM TO DQ-LAST-NAME                             
234800                                                                  
234900         MOVE DQ-FIRST-NAME TO WS-FROM                            
235000         PERFORM 2510-PROCESS-FROM-STRING                         
235100         MOVE WS-FROM TO DQ-FIRST-NAME                            
235200                                                                  
235300         IF DQ-MIDDLE-NAME NOT = SPACE                            
235400             MOVE DQ-MIDDLE-NAME TO WS-FROM                       
235500             PERFORM 2510-PROCESS-FROM-STRING                     
235600             MOVE WS-FROM TO DQ-MIDDLE-NAME                       
235700         END-IF                                                   
235800                                                                  
235900         MOVE DQ-TITLE-SUFFIX-1 TO WS-FROM                        
236000         PERFORM 2510-PROCESS-FROM-STRING                         
236100         MOVE WS-FROM TO DQ-TITLE-SUFFIX-1                        
236200                                                                  
236300         IF DQ-MIDDLE-NAME = SPACE                                
236400             STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
236500                    ', ' DELIMITED SIZE                           
236600                    DQ-FIRST-NAME DELIMITED CN-DELIMITER          
236700                    ' ' DELIMITED SIZE                            
236800                    DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
236900               INTO RS-NAME                                       
237000             END-STRING                                           
237100         ELSE                                                     
237200             STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
237300                    ', ' DELIMITED SIZE                           
237400                    DQ-FIRST-NAME DELIMITED CN-DELIMITER          
237500                    ' ' DELIMITED SIZE                            
237600                    DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
237700                    ' ' DELIMITED SIZE                            
237800                    DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
237900               INTO RS-NAME                                       
238000             END-STRING                                           
238100         END-IF                                                   
238200     ELSE                                                         
238300         MOVE DQ-FULL-NAME     TO RS-NAME                         
238400     END-IF.                                                      
238500                                                                  
239200     MOVE SPACE TO WS-ADDRESS.                                    
239300     SET WS-ADD-SUB TO 1.                                         
239400                                                                  
239500     IF DY-ADDR-USAGE-CD = 'I'                                    
239600         MOVE DY-STREET-NAME           TO WS-FROM                 
239700         MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ               
239800         PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
239900                                                                  
240000         MOVE '&' TO WS-FROM                                      
240100         MOVE 1   TO WS-MAX-SZ                                    
240200         PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
240300                                                                  
240400         MOVE DY-ADDRESS-OVERFLOW           TO WS-FROM            
240500         MOVE LENGTH OF DY-ADDRESS-OVERFLOW TO WS-MAX-SZ          
240600         PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT      
240700     ELSE                                                         
240800         MOVE SPACE TO WS-ADDRESS                                 
240900         SET WS-ADD-SUB TO 1                                      
241000                                                                  
241100         IF DY-HOUSE-NO NOT = SPACE                               
241200             MOVE DY-HOUSE-NO           TO WS-FROM                
241300             MOVE LENGTH OF DY-HOUSE-NO TO WS-MAX-SZ              
241400             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
241500         END-IF                                                   
241600                                                                  
241700         IF DY-ADDR-PREFIX-1 NOT = SPACE                          
241800             MOVE DY-ADDR-PREFIX-1           TO WS-FROM           
241900             MOVE LENGTH OF DY-ADDR-PREFIX-1 TO WS-MAX-SZ         
242000             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
242100         END-IF                                                   
242200                                                                  
242300         IF DY-ADDR-PREFIX-2 NOT = SPACE                          
242400             MOVE DY-ADDR-PREFIX-2           TO WS-FROM           
242500             MOVE LENGTH OF DY-ADDR-PREFIX-2 TO WS-MAX-SZ         
242600             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
242700         END-IF                                                   
242800                                                                  
242900         IF DY-STREET-NAME NOT = SPACE                            
243000             MOVE DY-STREET-NAME           TO WS-FROM             
243100             MOVE LENGTH OF DY-STREET-NAME TO WS-MAX-SZ           
243200             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
243300         END-IF                                                   
243400                                                                  
243500         IF DY-STREET-SUFFIX NOT = SPACE                          
243600             MOVE DY-STREET-SUFFIX           TO WS-FROM           
243700             MOVE LENGTH OF DY-STREET-SUFFIX TO WS-MAX-SZ         
243800             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
243900         END-IF                                                   
244000                                                                  
244100         IF DY-STREET-LOCATION-1 NOT = SPACE                      
244200             MOVE DY-STREET-LOCATION-1           TO WS-FROM       
244300             MOVE LENGTH OF DY-STREET-LOCATION-1 TO WS-MAX-SZ     
244400             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
244500         END-IF                                                   
244600                                                                  
244700         IF DY-STREET-LOCATION-2 NOT = SPACE                      
244800             MOVE DY-STREET-LOCATION-2           TO WS-FROM       
244900             MOVE LENGTH OF DY-STREET-LOCATION-2 TO WS-MAX-SZ     
245000             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
245100         END-IF                                                   
245300                                                                  
T19906         IF DY-ADDR-SUFFIX NOT = SPACE                            
T19906             MOVE DY-ADDR-SUFFIX                 TO WS-FROM       
T19906             MOVE LENGTH OF DY-ADDR-SUFFIX       TO WS-MAX-SZ     
T19906             PERFORM 2540-ACCUMULATE-ADDRESS      THRU 2540-EXIT  
T19906         END-IF                                                   
245200     END-IF.                                                      
245300                                                                  
245400     MOVE WS-ADDRESS           TO RS-ADDRESS.                     
245500                                                                  
245600     MOVE A4-TOWN              TO RS-CITY.                        
245700     MOVE AT-CODE-ACCT-STAT    TO RS-STATUS.                      
245800     MOVE HT-CUSTOMER-NO       TO RS-CUSTOMER-NO.                 
245900     MOVE AT-LOCAL-OFFICE      TO RS-LOCAL-OFFICE.                
246000     MOVE HT-PREMISE-NO        TO RS-PREMISE-NO.                  
246100     MOVE DQ-NAME-FORMAT       TO RS-NAME-FORMAT.                 
246200     MOVE AT-BANKRUPTCY-IND    TO RS-BANKRUPT-IND.                
246300                                                                  
246400     IF WS-PREV-ADDRESS = RS-ADDRESS                              
246500     AND WS-PREV-CITY = RS-CITY                                   
T16653     AND WS-PREV-PREMISE-NO = RS-PREMISE-NO                       
246600     AND SEL-METH-ADD                                             
246700         MOVE RS-ADDRESS     TO WS-PREV-ADDRESS                   
246800         MOVE RS-CITY        TO WS-PREV-CITY                      
T16653         MOVE RS-PREMISE-NO  TO WS-PREV-PREMISE-NO                
246900         MOVE SPACE          TO RS-ADDRESS                        
247000         MOVE SPACE          TO RS-CITY                           
247100     ELSE                                                         
247200         MOVE RS-ADDRESS     TO WS-PREV-ADDRESS                   
247300         MOVE RS-CITY        TO WS-PREV-CITY                      
T16653         MOVE RS-PREMISE-NO  TO WS-PREV-PREMISE-NO                
247400     END-IF.                                                      
247500                                                                  
248153******************************************************************32040000
248154*  THE FOLLOWING IF STATEMENT IS USED TO DISPLAY THE RELATIONSHIP*32050000
248155*  A PERSON HAS WITH AN ACCOUNT.  THE CUSTOMER_ROLE_CD IN THE    *32060000
248156*  THE CSS_NAME_ACCT_XREF TABLE SAYS WHETHER A PERSON IS A ROOM- *32070000
248157*  MATE OR CO-APPLICANT.  WE ARE GOING TO MOVE THIS TO THE RE-   *32080000
248158*  NAME_TYPE FIELD SO WE CAN SHOW ITS RELATIONSHIP.              *32090000
248159******************************************************************32100000
248160     IF HT-CUSTOMER-ROLE-CD = 'A'                                 
248170        MOVE 'A' TO RS-NAME-TYPE                                  
248180     END-IF.                                                      
248190                                                                  
248200     IF HT-CUSTOMER-ROLE-CD = 'B'                                 
248300        MOVE 'B' TO RS-NAME-TYPE                                  
248400     END-IF.                                                      
248500                                                                  
C26959     IF C8-DELINQ-VALUE = 2                                       
C26959         PERFORM 7750-REG-PROFILE      THRU 7750-EXIT             
C26959         IF LR-REG-GROUP-CD = '200'                               
C26959             PERFORM 7760-ACTIVE-DHR   THRU 7760-EXIT             
C26959         END-IF                                                   
C26959     ELSE                                                         
C26959         MOVE SPACES TO RS-GROUP-CD
           END-IF.                              
C26959                                                                  
SC5000******************************************************************        
SC5001*   PROCESS MULTIPLE METERS.                                     *        
SC5002******************************************************************        
SC5                                                                     
SC5        MOVE UT-READ-CYCLE   TO   RS-READ-CYCLE                      
SC5        MOVE UT-READ-ROUTE   TO   RS-READ-ROUTE                      
SC5                                                                     
SC5        PERFORM 2218-SEARCH-VIA-B-MTR-CURSOR         THRU 2218-EXIT. 
248700                                                                  
248800 2500-EXIT.                                                       
248900     EXIT.                                                        
HPCCDM*    EJECT                                                        32230000
249100******************************************************************32240000
249200* 2510-PROCESS-FROM-STRING                                       *32250000
249300*                                                                *32260000
249400*     DETERMINE LENGTH OF FIELD. PLACE DELIMITER AFTER THE LAST  *32270000
249500*     NON-SPACE CHARACTER TO BE USED LATER IN STRING STATEMENT.  *32280000
249600*                                                                *32290000
249700******************************************************************32300000
249800                                                                  
249900 2510-PROCESS-FROM-STRING.                                        
250000                                                                  
250100     PERFORM                                                      
250200         VARYING WS-SUB FROM 51 BY -1                             
250300           UNTIL WS-SUB < 1                                       
250400              OR WS-FROM-X (WS-SUB) NOT = SPACE                   
250500     END-PERFORM.                                                 
250600     ADD 1             TO WS-SUB.                                 
250700     MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
250800                                                                  
250900 2510-EXIT.                                                       
251000     EXIT.                                                        
HPCCDM*    EJECT                                                        32440000
255200******************************************************************32970000
255300* 2540-ACCUMULATE-ADDRESS                                        *32980000
255400*                                                                *32990000
255500*     DETERMINE LENGTH OF FIELD. MOVE THAT MANY CHARACTERS ON TO *33000000
255600*     THE FORMATTED ADDRESS FIELD.                               *33010000
255700*                                                                *33020000
255800******************************************************************33030000
255900                                                                  
256000 2540-ACCUMULATE-ADDRESS.                                         
256100                                                                  
256200     PERFORM                                                      
256300         VARYING WS-LENGTH FROM WS-MAX-SZ BY -1                   
256400           UNTIL WS-LENGTH < 1                                    
256500              OR WS-FROM-X (WS-LENGTH) NOT = SPACE                
256600     END-PERFORM.                                                 
256700                                                                  
256800     PERFORM                                                      
256900         VARYING WS-SUB FROM 1 BY 1                               
257000           UNTIL WS-SUB > WS-LENGTH                               
257100             MOVE WS-FROM-X (WS-SUB)                              
257200                  TO WS-ADDRESS-X (WS-ADD-SUB)                    
257300             SET WS-ADD-SUB UP BY 1                               
257400     END-PERFORM.                                                 
257500                                                                  
257600     SET WS-ADD-SUB UP BY 1.                                      
257700                                                                  
257800 2540-EXIT.                                                       
257900     EXIT.                                                        
HPCCDM*    EJECT                                                        33250000
                                                                        
C26959 7000-DETERMINE-REGION.                                           
C26959                                                                  
C26959     EXEC SQL                                                     
C26959        SELECT DELINQ_VALUE                                       
C26959          INTO :C8-DELINQ-VALUE                                   
C26959          FROM CSS_DELINQUENCY WITH(READUNCOMMITTED)                      
C26959         WHERE DELINQ_CD = 'DATABASE'                             
C26959           AND COMPANY_NO = '01'                                  
T35434                                                           
C26959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     15040000
MFA-TR*       SELECT DELINQ_VALUE                                       15040000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   15040000
MFA-TR*         FROM CSS_DELINQUENCY                                    15040000
MFA-TR*        WHERE DELINQ_CD = 'DATABASE'                             15040000
MFA-TR*          AND COMPANY_NO = '01'                                  15040000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    15040000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26959                                                                  
C26959     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26959                                                                  
C26959     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C26959         NEXT SENTENCE                                            
C26959     ELSE                                                         
C26959         MOVE 'PARA 7000 REGION'        TO RS-ERROR-DESC          
REARCH                                            S-ERROR-DESC          
C26959         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
C26959         MOVE '7000'                    TO ACTIVE-PARAGRAPH       
C26959         MOVE 'SELECT'                  TO ABEND-FUNCTION         
C26959         MOVE 'CSS_DELINQUENCY'         TO TABLE-1                
C26959         MOVE 'DELINQ_VALUE'            TO TABLE-ELEMENT-1        
C26959         MOVE 'DATABASE'                TO HOSTVAR-ELEMENT-1      
C26959         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
C26959         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
C26959     END-IF.                                                      
C26959                                                                  
C26959 7000-EXIT.                                                       
C26959     EXIT.                                                        
                                                                        
258100******************************************************************33610000
T21993* 7221-OPEN-B-GAS-CURSOR-L                                       *        
258300*                                                                *33630000
T21993*     OPEN B-GAS-CURSOR-L AND CHECK FOR SQL ERROR.               *        
258500*                                                                *33650000
258600******************************************************************33660000
258700                                                                  
T21993 7221-OPEN-B-GAS-CURSOR-L.                                        
258900                                                                  
259000     EXEC SQL                                                     
T21993         OPEN B-GAS-CURSOR-L                                      
259200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

259300                                                                  
259400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
259500                                                                  
259600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
259700         NEXT SENTENCE                                            
259800     ELSE                                                         
T21993         MOVE   'PARA -7221 ,OPEN CURSOR B-GAS-CURSOR-L'          
260000                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
260100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7221'                 TO ACTIVE-PARAGRAPH          
260300         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
260500         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
260600         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
260700     END-IF.                                                      
260800                                                                  
T21993 7221-EXIT.                                                       
261000     EXIT.                                                        
HPCCDM*    EJECT                                                        33910000
T21993                                                                  
261200******************************************************************33920000
T21993* 7222-FETCH-B-GAS-CURSOR-L                                      *        
261400*                                                                *33940000
T21993*     FETCH B-GAS-CURSOR-L AND CHECK FOR SQL ERROR.              *        
261600*                                                                *33960000
261700******************************************************************33970000
261800                                                                  
T21993 7222-FETCH-B-GAS-CURSOR-L.                                       
262000                                                                  
262100     EXEC SQL                                                     
T21993         FETCH B-GAS-CURSOR-L                                     
262300          INTO :HT-CUSTOMER-NO,                                   
262400               :HT-ACCOUNT-NO,                                    
262500               :HT-PREMISE-NO,                                    
262600               :HT-ADDRESS-ID,                                    
262700               :HT-NAME-ID,                                       
262800               :HT-CUSTOMER-ROLE-CD,                              
262900               :HT-COMPANY-NO,                                    
263000               :DY-STREET-NAME,                                   
263100               :DY-HOUSE-NO,                                      
263200               :DY-ADDR-PREFIX-1,                                 
263300               :DY-ADDR-PREFIX-2,                                 
263400               :DY-STREET-LOCATION-1,                             
T21993               :DY-STREET-LOCATION-2,                             
T21993               :UT-READ-CYCLE,                                    
T21993               :UT-READ-ROUTE,                                    
T21993               :UT-IC-NO                                          
263600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

263700                                                                  
263800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
263900                                                                  
264000     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
264100         NEXT SENTENCE                                            
264200     ELSE                                                         
T21993         MOVE   'PARA -7222 ,FETCH CURSOR B-GAS-CURSOR-L'         
264400                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
264500         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7222'                 TO ACTIVE-PARAGRAPH          
264700         MOVE 'FETCH'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
264900         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
265000         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
265100     END-IF.                                                      
265200                                                                  
T21993 7222-EXIT.                                                       
265400     EXIT.                                                        
HPCCDM*    EJECT                                                        34350000
T21993                                                                  
265600******************************************************************34360000
T21993* 7223-CLOSE-B-GAS-CURSOR-L                                      *        
265800*                                                                *34380000
T21993*     CLOSE B-GAS-CURSOR-L AND CHECK FOR SQL ERROR.              *        
266000*                                                                *34400000
266100******************************************************************34410000
266200                                                                  
T21993 7223-CLOSE-B-GAS-CURSOR-L.                                       
266400                                                                  
266500     EXEC SQL                                                     
T21993         CLOSE B-GAS-CURSOR-L                                     
266700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

266800                                                                  
266900     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
267000                                                                  
267100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
267200         NEXT SENTENCE                                            
267300     ELSE                                                         
T21993         MOVE 'PARA -7223 ,CLOSE CURSOR B-GAS-CURSOR-L'           
267500                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
267600         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7223'                 TO ACTIVE-PARAGRAPH          
267800         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
268000         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
268100         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
268200     END-IF.                                                      
268300                                                                  
T21993 7223-EXIT.                                                       
268500     EXIT.                                                        
HPCCDM*    EJECT                                                        34660000
T21993                                                                  
T21993******************************************************************        
T21993* 7224-OPEN-B-GAS-CURSOR-C                                       *        
T21993*                                                                *        
T21993*     OPEN B-GAS-CURSOR-C AND CHECK FOR SQL ERROR.               *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7224-OPEN-B-GAS-CURSOR-C.                                        
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         OPEN B-GAS-CURSOR-C                                      
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE   'PARA -7224 ,OPEN CURSOR B-GAS-CURSOR-C'          
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7224'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_NAME'             TO TABLE-3                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7224-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 7225-FETCH-B-GAS-CURSOR-C                                      *        
T21993*                                                                *        
T21993*     FETCH B-GAS-CURSOR-C AND CHECK FOR SQL ERROR.              *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7225-FETCH-B-GAS-CURSOR-C.                                       
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         FETCH B-GAS-CURSOR-C                                     
T21993          INTO :HT-CUSTOMER-NO,                                   
T21993               :HT-ACCOUNT-NO,                                    
T21993               :HT-PREMISE-NO,                                    
T21993               :HT-ADDRESS-ID,                                    
T21993               :HT-NAME-ID,                                       
T21993               :HT-CUSTOMER-ROLE-CD,                              
T21993               :HT-COMPANY-NO,                                    
T21993               :DY-STREET-NAME,                                   
T21993               :DY-HOUSE-NO,                                      
T21993               :DY-ADDR-PREFIX-1,                                 
T21993               :DY-ADDR-PREFIX-2,                                 
T21993               :DY-STREET-LOCATION-1,                             
T21993               :DY-STREET-LOCATION-2,                             
T21993               :UT-READ-CYCLE,                                    
T21993               :UT-READ-ROUTE,                                    
T21993               :UT-IC-NO                                          
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE   'PARA -7225 ,FETCH CURSOR B-GAS-CURSOR-C'         
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7225'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'FETCH'                TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_NAME'             TO TABLE-3                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7225-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 7226-CLOSE-B-GAS-CURSOR-C                                      *        
T21993*                                                                *        
T21993*     CLOSE B-GAS-CURSOR-C AND CHECK FOR SQL ERROR.              *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7226-CLOSE-B-GAS-CURSOR-C.                                       
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         CLOSE B-GAS-CURSOR-C                                     
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE 'PARA -7226 ,CLOSE CURSOR B-GAS-CURSOR-C'           
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7226'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_NAME'             TO TABLE-3                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7226-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
SC5100******************************************************************        
258200* 7227-OPEN-B-GAS-CURSOR                                         *        
258300*                                                                *        
SC5400*     OPEN B-GAS-CURSOR AND CHECK FOR SQL ERROR.                 *        
258500*                                                                *        
258600******************************************************************        
258700                                                                  
258800 7227-OPEN-B-GAS-CURSOR.                                          
258900                                                                  
259000     EXEC SQL                                                     
259100         OPEN B-GAS-CURSOR                                        
259200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

259300                                                                  
259400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
259500                                                                  
259600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
259700         NEXT SENTENCE                                            
259800     ELSE                                                         
259900         MOVE   'PARA -7227 ,OPEN CURSOR B-GAS-CURSOR'            
260000                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
260100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
260200         MOVE '7227'                 TO ACTIVE-PARAGRAPH          
260300         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
260500         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
260600         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
260700     END-IF.                                                      
260800                                                                  
260900 7227-EXIT.                                                       
261000     EXIT.                                                        
HPCCDM*    EJECT                                                                
261200******************************************************************        
261300* 7228-FETCH-B-GAS-CURSOR                                        *        
261400*                                                                *        
261500*     FETCH B-GAS-CURSOR AND CHECK FOR SQL ERROR.                *        
261600*                                                                *        
261700******************************************************************        
261800                                                                  
261900 7228-FETCH-B-GAS-CURSOR.                                         
262000                                                                  
262100     EXEC SQL                                                     
262200         FETCH B-GAS-CURSOR                                       
262300          INTO :HT-CUSTOMER-NO,                                   
262400               :HT-ACCOUNT-NO,                                    
262500               :HT-PREMISE-NO,                                    
262600               :HT-ADDRESS-ID,                                    
262700               :HT-NAME-ID,                                       
262800               :HT-CUSTOMER-ROLE-CD,                              
262900               :HT-COMPANY-NO,                                    
263000               :DY-STREET-NAME,                                   
263100               :DY-HOUSE-NO,                                      
263200               :DY-ADDR-PREFIX-1,                                 
263300               :DY-ADDR-PREFIX-2,                                 
263400               :DY-STREET-LOCATION-1,                             
263500               :DY-STREET-LOCATION-2,                             
SC5                  :UT-READ-CYCLE,                                    
SC5                  :UT-READ-ROUTE,                                    
SC5                  :UT-IC-NO                                          
263600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

263700                                                                  
263800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
263900                                                                  
264000     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
264100         NEXT SENTENCE                                            
264200     ELSE                                                         
264300         MOVE   'PARA -7228 ,FETCH CURSOR B-GAS-CURSOR'           
                      TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
264500         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
264600         MOVE '7228'                 TO ACTIVE-PARAGRAPH          
264700         MOVE 'FETCH'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
264900         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
265000         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
265100     END-IF.                                                      
265200                                                                  
265300 7228-EXIT.                                                       
265400     EXIT.                                                        
HPCCDM*    EJECT                                                                
265600******************************************************************        
265700* 7229-CLOSE-B-GAS-CURSOR                                        *        
265800*                                                                *        
265900*     CLOSE B-GAS-CURSOR AND CHECK FOR SQL ERROR.                *        
266000*                                                                *        
266100******************************************************************        
266200                                                                  
266300 7229-CLOSE-B-GAS-CURSOR.                                         
266400                                                                  
266500     EXEC SQL                                                     
266600         CLOSE B-GAS-CURSOR                                       
266700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

266800                                                                  
266900     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
267000                                                                  
267100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
267200         NEXT SENTENCE                                            
267300     ELSE                                                         
267400         MOVE 'PARA -7229 ,CLOSE CURSOR B-GAS-CURSOR'             
267500                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
267600         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
267700         MOVE '7229'                 TO ACTIVE-PARAGRAPH          
267800         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
268000         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
268100         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
SC5200     END-IF.                                                      
268300                                                                  
268400 7229-EXIT.                                                       
268500     EXIT.                                                        
HPCCDM*    EJECT                                                                
SC5                                                                     
SC5100******************************************************************        
258200* 7231-OPEN-B-MTR-CURSOR                                         *        
258300*                                                                *        
SC5400*     OPEN B-MTR-CURSOR AND CHECK FOR SQL ERROR.                 *        
258500*                                                                *        
258600******************************************************************        
258700                                                                  
258800 7231-OPEN-B-MTR-CURSOR.                                          
258900                                                                  
259000     EXEC SQL                                                     
259100         OPEN B-MTR-CURSOR                                        
259200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

259300                                                                  
259400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
259500                                                                  
259600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
259700         NEXT SENTENCE                                            
259800     ELSE                                                         
259900         MOVE   'PARA -7231 ,OPEN CURSOR B-MTR-CURSOR'            
260000                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
260100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
260200         MOVE '7231'                 TO ACTIVE-PARAGRAPH          
260300         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
260500         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
260600         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
260700     END-IF.                                                      
260800                                                                  
260900 7231-EXIT.                                                       
261000     EXIT.                                                        
HPCCDM*    EJECT                                                                
261200******************************************************************        
261300* 7232-FETCH-B-MTR-CURSOR                                        *        
261400*                                                                *        
261500*     FETCH B-MTR-CURSOR AND CHECK FOR SQL ERROR.                *        
261600*                                                                *        
261700******************************************************************        
261800                                                                  
261900 7232-FETCH-B-MTR-CURSOR.                                         
262000                                                                  
262100     EXEC SQL                                                     
262200         FETCH B-MTR-CURSOR                                       
262300          INTO :MN-METER-NO,                                      
262400               :MN-CODE-METER-STATUS,                             
262500               :MN-CODE-METER-LOC,                                
262600               :MN-REGISTER-RD-SEQ                                
263600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
263800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
263900                                                                  
264000     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
264100         NEXT SENTENCE                                            
264200     ELSE                                                         
264300         MOVE   'PARA -7232 ,FETCH CURSOR B-MTR-CURSOR'           
264400                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
264500         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
264600         MOVE '7232'                 TO ACTIVE-PARAGRAPH          
264700         MOVE 'FETCH'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
264900         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
265000         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
265100     END-IF.                                                      
265200                                                                  
265300 7232-EXIT.                                                       
265400     EXIT.                                                        
HPCCDM*    EJECT                                                                
265600******************************************************************        
265700* 7233-CLOSE-B-MTR-CURSOR                                        *        
265800*                                                                *        
265900*     CLOSE B-MTR-CURSOR AND CHECK FOR SQL ERROR.                *        
266000*                                                                *        
266100******************************************************************        
266200                                                                  
266300 7233-CLOSE-B-MTR-CURSOR.                                         
263700                                                                  
266500     EXEC SQL                                                     
266600         CLOSE B-MTR-CURSOR                                       
266700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

266800                                                                  
266900     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
267000                                                                  
267100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
267200         NEXT SENTENCE                                            
267300     ELSE                                                         
267400         MOVE 'PARA -7233 ,CLOSE CURSOR B-MTR-CURSOR'             
267500                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
267600         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
267700         MOVE '7233'                 TO ACTIVE-PARAGRAPH          
267800         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-3                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
268000         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
268100         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
SC5200     END-IF.                                                      
268300                                                                  
268400 7233-EXIT.                                                       
268500     EXIT.                                                        
HPCCDM*    EJECT                                                                
SC5                                                                     
352800******************************************************************43810000
352900* 7274-OPEN-UT-CURSOR                                            *43820000
353000*                                                                *43830000
353100*     OPEN UT-CURSOR AND CHECK FOR SQL ERROR.                    *43840000
353200*                                                                *43850000
353300******************************************************************43860000
353400                                                                  
353500 7274-OPEN-UT-CURSOR.                                             
353600                                                                  
353700     EXEC SQL                                                     
353800         OPEN UT-CURSOR                                           
353900     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

354000                                                                  
354100     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
354200                                                                  
354300     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
354400         NEXT SENTENCE                                            
354500     ELSE                                                         
354600         MOVE 'PARA -7274 ,OPEN   CURSOR UT-CURSOR  '             
354700                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
354800         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
354900         MOVE '7274'                 TO ACTIVE-PARAGRAPH          
355000         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T16123         MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
T16123         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
T16123         MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
355200         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
355300         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
355400     END-IF.                                                      
355500                                                                  
355600 7274-EXIT.                                                       
355700     EXIT.                                                        
HPCCDM*    EJECT                                                        44110000
355900******************************************************************44120000
356000* 7275-FETCH-UT-CURSOR                                           *44130000
356100*                                                                *44140000
356200*     FETCH UT-CURSOR AND CHECK FOR SQL ERROR.                   *44150000
356300*                                                                *44160000
356400******************************************************************44170000
356500                                                                  
356600 7275-FETCH-UT-CURSOR.                                            
356700                                                                  
356800     EXEC SQL                                                     
356900         FETCH UT-CURSOR                                          
357000          INTO :UT-CODE-UTIL-TYPE,                                
357100               :UT-RATE-PLAN-NO                                   
357200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

357300                                                                  
357400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
357500                                                                  
357600     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
357700         NEXT SENTENCE                                            
357800     ELSE                                                         
357900         MOVE 'PARA -7275 ,FETCH  CURSOR UT-CURSOR  '             
358000                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
358100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
358200         MOVE '7275'                 TO ACTIVE-PARAGRAPH          
358300         MOVE 'FETCH'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
T16123         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
T16123         MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
358410         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
358420         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
358421     END-IF.                                                      
358422                                                                  
358423 7275-EXIT.                                                       
358424     EXIT.                                                        
HPCCDM*    EJECT                                                        44440000
358426******************************************************************44450000
358427* 7276-CLOSE-UT-CURSOR                                           *44460000
358428*                                                                *44470000
358429*     CLOSE BS-CURSOR AND CHECK FOR SQL ERROR.                   *44480000
358430*                                                                *44490000
358440******************************************************************44500000
358441                                                                  
358442 7276-CLOSE-UT-CURSOR.                                            
358443                                                                  
358444     EXEC SQL                                                     
358445         CLOSE UT-CURSOR                                          
358446     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

358447                                                                  
358448     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
358449                                                                  
358450     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
358451         NEXT SENTENCE                                            
358452     ELSE                                                         
CBSI           MOVE 'PARA -7276 ,CLOSE  CURSOR UT-CURSOR  '             
358454                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
358455         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
CBSI           MOVE '7276'                 TO ACTIVE-PARAGRAPH          
358457         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_UTIL_ENVRNMT'     TO TABLE-1                   
T16123         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
T16123         MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
358459         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
358460         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
358461     END-IF.                                                      
358462                                                                  
358463 7276-EXIT.                                                       
358464     EXIT.                                                        
HPCCDM*    EJECT                                                        44750000
258100******************************************************************44760000
258200* 7280-OPEN-DY-PR-CURSOR                                         *44770000
258300*                                                                *44780000
258400*     OPEN DY-PR-CURSOR AND CHECK FOR SQL ERROR.                 *44790000
258500*                                                                *44800000
258600******************************************************************44810000
258700                                                                  
258800 7280-OPEN-DY-PR-CURSOR.                                          
258900                                                                  
259000     EXEC SQL                                                     
259100         OPEN DY-PR-CURSOR                                        
259200     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

259300                                                                  
259400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
259500                                                                  
259600     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
259700         NEXT SENTENCE                                            
259800     ELSE                                                         
CBSI           MOVE   'PARA -7280 ,OPEN CURSOR DY-PR-CURSOR'            
260000                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
260100         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
260200         MOVE '7280'                 TO ACTIVE-PARAGRAPH          
260300         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T16123         MOVE 'CSS_PREMISE'          TO TABLE-3                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-4                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
260500         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
260600         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
260700     END-IF.                                                      
260800                                                                  
260900 7280-EXIT.                                                       
261000     EXIT.                                                        
HPCCDM*    EJECT                                                        45060000
261200******************************************************************45070000
261300* 7281-FETCH-DY-PR-CURSOR                                        *45080000
261400*                                                                *45090000
261500*     FETCH DY-PR-CURSOR AND CHECK FOR SQL ERROR.                *45100000
261600*                                                                *45110000
261700******************************************************************45120000
261800                                                                  
261900 7281-FETCH-DY-PR-CURSOR.                                         
262000                                                                  
262100     EXEC SQL                                                     
262200         FETCH DY-PR-CURSOR                                       
262300          INTO :HT-CUSTOMER-NO,                                   
262400               :HT-ACCOUNT-NO,                                    
262500               :HT-PREMISE-NO,                                    
262600               :HT-ADDRESS-ID,                                    
262700               :HT-NAME-ID,                                       
262800               :HT-CUSTOMER-ROLE-CD,                              
262900               :HT-COMPANY-NO,                                    
263000               :DY-STREET-NAME,                                   
263100               :DY-HOUSE-NO,                                      
263200               :DY-ADDR-PREFIX-1,                                 
263300               :DY-ADDR-PREFIX-2,                                 
263400               :DY-STREET-LOCATION-1,                             
263500               :DY-STREET-LOCATION-2,                             
SC5                  :UT-READ-CYCLE,                                    
SC5                  :UT-READ-ROUTE,                                    
SC5                  :UT-IC-NO                                          
263600     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

263700                                                                  
263800     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
263900                                                                  
264000     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
264100         NEXT SENTENCE                                            
264200     ELSE                                                         
264300         MOVE   'PARA -7281 ,FETCH CURSOR DY-PR-CURSOR'           
264400                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
264500         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
CBSI           MOVE '7281'                 TO ACTIVE-PARAGRAPH          
264700         MOVE 'FETCH'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T16123         MOVE 'CSS_PREMISE'          TO TABLE-3                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-4                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
264900         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
265000         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
265100     END-IF.                                                      
265200                                                                  
265300 7281-EXIT.                                                       
265400     EXIT.                                                        
HPCCDM*    EJECT                                                        45500000
265600******************************************************************45510000
265700* 7282-CLOSE-DY-PR-CURSOR                                        *45520000
265800*                                                                *45530000
265900*     CLOSE DY-PR-CURSOR AND CHECK FOR SQL ERROR.                *45540000
266000*                                                                *45550000
266100******************************************************************45560000
266200                                                                  
266300 7282-CLOSE-DY-PR-CURSOR.                                         
266400                                                                  
266500     EXEC SQL                                                     
266600         CLOSE DY-PR-CURSOR                                       
266700     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

266800                                                                  
266900     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
267000                                                                  
267100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
267200         NEXT SENTENCE                                            
267300     ELSE                                                         
267400         MOVE 'PARA -7282 ,CLOSE CURSOR DY-PR-CURSOR'             
267500                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
267600         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
267700         MOVE '7282'                 TO ACTIVE-PARAGRAPH          
267800         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T16123         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T16123         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T16123         MOVE 'CSS_PREMISE'          TO TABLE-3                   
CBSI           MOVE 'CSS_NAME'             TO TABLE-4                   
T16123         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T16123         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T16123         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
CBSI           MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
CBSI           MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T16123         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
CBSI           MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
CBSI           MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
268000         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
268100         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
268200     END-IF.                                                      
268300                                                                  
268400 7282-EXIT.                                                       
268500     EXIT.                                                        
HPCCDM*    EJECT                                                        45810000
T21993                                                                  
      ******************************************************************48800000
T21993* 7283-OPEN-DY-PR-CURSOR-L                                       *        
      *                                                                *48820000
T21993*     OPEN DY-PR-CURSOR-L AND CHECK FOR SQL ERROR.               *        
      *                                                                *48830000
      ******************************************************************48840000
                                                                        
T21993 7283-OPEN-DY-PR-CURSOR-L.                                        
T21993                                                                  
           EXEC SQL                                                     
T21993         OPEN DY-PR-CURSOR-L                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
T21993         MOVE   'PARA -7283 ,OPEN CURSOR DY-PR-CURSOR-L'          
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7283'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_PREMISE'          TO TABLE-3                   
T21993         MOVE 'CSS_NAME'             TO TABLE-4                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
T21993 7283-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 7284-FETCH-DY-PR-CURSOR-L                                      *        
T21993*                                                                *        
T21993*     FETCH DY-PR-CURSOR-L AND CHECK FOR SQL ERROR.              *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7284-FETCH-DY-PR-CURSOR-L.                                       
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         FETCH DY-PR-CURSOR                                       
T21993          INTO :HT-CUSTOMER-NO,                                   
T21993               :HT-ACCOUNT-NO,                                    
T21993               :HT-PREMISE-NO,                                    
T21993               :HT-ADDRESS-ID,                                    
T21993               :HT-NAME-ID,                                       
T21993               :HT-CUSTOMER-ROLE-CD,                              
T21993               :HT-COMPANY-NO,                                    
T21993               :DY-STREET-NAME,                                   
T21993               :DY-HOUSE-NO,                                      
T21993               :DY-ADDR-PREFIX-1,                                 
T21993               :DY-ADDR-PREFIX-2,                                 
T21993               :DY-STREET-LOCATION-1,                             
T21993               :DY-STREET-LOCATION-2,                             
T21993               :UT-READ-CYCLE,                                    
T21993               :UT-READ-ROUTE,                                    
T21993               :UT-IC-NO                                          
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE   'PARA -7284 ,FETCH CURSOR DY-PR-CURSOR-L'         
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7284'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'FETCH'                TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_PREMISE'          TO TABLE-3                   
T21993         MOVE 'CSS_NAME'             TO TABLE-4                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7284-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 7285-CLOSE-DY-PR-CURSOR-L                                      *        
T21993*                                                                *        
T21993*     CLOSE DY-PR-CURSOR-L AND CHECK FOR SQL ERROR.              *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7285-CLOSE-DY-PR-CURSOR-L.                                       
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         CLOSE DY-PR-CURSOR-L                                     
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE 'PARA -7285 ,CLOSE CURSOR DY-PR-CURSOR-L'           
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7285'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_PREMISE'          TO TABLE-3                   
T21993         MOVE 'CSS_NAME'             TO TABLE-4                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7285-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 7286-OPEN-DY-PR-CURSOR-C                                       *        
T21993*                                                                *        
T21993*     OPEN DY-PR-CURSOR-C AND CHECK FOR SQL ERROR.               *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7286-OPEN-DY-PR-CURSOR-C.                                        
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         OPEN DY-PR-CURSOR-C                                      
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE   'PARA -7286 ,OPEN CURSOR DY-PR-CURSOR-C'          
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7286'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'OPEN'                 TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_PREMISE'          TO TABLE-3                   
T21993         MOVE 'CSS_NAME'             TO TABLE-4                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7286-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 7287-FETCH-DY-PR-CURSOR-C                                      *        
T21993*                                                                *        
T21993*     FETCH DY-PR-CURSOR-C AND CHECK FOR SQL ERROR.              *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7287-FETCH-DY-PR-CURSOR-C.                                       
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         FETCH DY-PR-CURSOR                                       
T21993          INTO :HT-CUSTOMER-NO,                                   
T21993               :HT-ACCOUNT-NO,                                    
T21993               :HT-PREMISE-NO,                                    
T21993               :HT-ADDRESS-ID,                                    
T21993               :HT-NAME-ID,                                       
T21993               :HT-CUSTOMER-ROLE-CD,                              
T21993               :HT-COMPANY-NO,                                    
T21993               :DY-STREET-NAME,                                   
T21993               :DY-HOUSE-NO,                                      
T21993               :DY-ADDR-PREFIX-1,                                 
T21993               :DY-ADDR-PREFIX-2,                                 
T21993               :DY-STREET-LOCATION-1,                             
T21993               :DY-STREET-LOCATION-2,                             
T21993               :UT-READ-CYCLE,                                    
T21993               :UT-READ-ROUTE,                                    
T21993               :UT-IC-NO                                          
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE   'PARA -7287 ,FETCH CURSOR DY-PR-CURSOR-C'         
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7287'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'FETCH'                TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_PREMISE'          TO TABLE-3                   
T21993         MOVE 'CSS_NAME'             TO TABLE-4                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7287-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
T21993                                                                  
T21993******************************************************************        
T21993* 7288-CLOSE-DY-PR-CURSOR-C                                      *        
T21993*                                                                *        
T21993*     CLOSE DY-PR-CURSOR-C AND CHECK FOR SQL ERROR.              *        
T21993*                                                                *        
T21993******************************************************************        
T21993                                                                  
T21993 7288-CLOSE-DY-PR-CURSOR-C.                                       
T21993                                                                  
T21993     EXEC SQL                                                     
T21993         CLOSE DY-PR-CURSOR-C                                     
T21993     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21993                                                                  
T21993     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21993                                                                  
T21993     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21993         NEXT SENTENCE                                            
T21993     ELSE                                                         
T21993         MOVE 'PARA -7288 ,CLOSE CURSOR DY-PR-CURSOR-C'           
T21993                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T21993         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T21993         MOVE '7288'                 TO ACTIVE-PARAGRAPH          
T21993         MOVE 'CLOSE'                TO ABEND-FUNCTION            
T21993         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
T21993         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T21993         MOVE 'CSS_PREMISE'          TO TABLE-3                   
T21993         MOVE 'CSS_NAME'             TO TABLE-4                   
T21993         MOVE 'HOUSE_NO'             TO TABLE-ELEMENT-1           
T21993         MOVE ADD-STREET-NBR-B       TO HOSTVAR-ELEMENT-1         
T21993         MOVE 'STREET_NAME'          TO TABLE-ELEMENT-2           
T21993         MOVE 'ADDR_PREFIX_1'        TO TABLE-ELEMENT-3           
T21993         MOVE 'STREET_LOCATION_1'    TO TABLE-ELEMENT-4           
T21993         MOVE ADD-STREET-NAME-B      TO HOSTVAR-ELEMENT-2         
T21993         MOVE ADD-PREFIX-1-B         TO HOSTVAR-ELEMENT-3         
T21993         MOVE ADD-LOCATION-1-B       TO HOSTVAR-ELEMENT-4         
T21993         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T21993         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T21993     END-IF.                                                      
T21993                                                                  
T21993 7288-EXIT.                                                       
T21993     EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
                                                                        
      ******************************************************************49230000
      * 7710-GET-GAS-RATE.                                             *49240000
      *                                                                *49250000
      *                                                                *49260000
      ******************************************************************49270000
       7710-GET-GAS-RATE.                                               
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :WS-GAS-RATE :WS-GAS-RATE-NULL-IND                 
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND RATE_PLAN_NO NOT IN ('049','079')                 
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     49300000
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                 49310000
MFA-TR*          INTO :WS-GAS-RATE:WS-GAS-RATE-NULL-IND                 49320000
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                  49330000
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   49340000
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                              49350000
MFA-TR*           AND RATE_PLAN_NO NOT IN ('049','079')                 49360000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    49370000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-GAS-RATE-NULL-IND = 0                              
                  MOVE WS-GAS-RATE            TO RS-GAS-RATE            
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7710 GET GAS RATE'  TO RS-ERROR-DESC          
REARCH                                           S-ERROR-DESC           
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7710'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T15538         MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T15538         MOVE 'G'                       TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7710-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************50060000
      * 7730-CHECK-UNMTR-GAS.                                          *50070000
      *                                                                *50080000
      *                                                                *50090000
      ******************************************************************50100000
       7730-CHECK-UNMTR-GAS.                                            
                                                                        
           EXEC SQL                                                     
               SELECT MAX(RATE_PLAN_NO)                                 
                 INTO :WS-GAS-RATE :WS-GAS-RATE-NULL-IND                 
                 FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                    
                WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   
                  AND CODE_UTIL_TYPE = 'G'                              
                  AND RATE_PLAN_NO IN ('049','079')                     
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50130000
MFA-TR*        SELECT MAX(RATE_PLAN_NO)                                 50140000
MFA-TR*          INTO :WS-GAS-RATE:WS-GAS-RATE-NULL-IND                 50150000
MFA-TR*          FROM CSS_UTIL_ENVRNMT                                  50160000
MFA-TR*         WHERE ACCOUNT_NO     = :HT-ACCOUNT-NO                   50170000
MFA-TR*           AND CODE_UTIL_TYPE = 'G'                              50180000
MFA-TR*           AND RATE_PLAN_NO IN ('049','079')                     50190000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    50200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF WS-GAS-RATE-NULL-IND = 0 AND WS-GAS-RATE >            
                                               RS-UNMETER-RATE          
                  MOVE WS-GAS-RATE            TO RS-UNMETER-RATE        
               END-IF                                                   
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE 'PARA 7730 GET ELEC RATE' TO RS-ERROR-DESC          
REARCH                                           S-ERROR-DESC           
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '7730'                    TO ACTIVE-PARAGRAPH       
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE 'CSS_UTIL_ENVRNMT'        TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
T15538         MOVE 'CODE_UTIL_TYPE'          TO TABLE-ELEMENT-2        
               MOVE HT-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
T15538         MOVE 'G'                       TO HOSTVAR-ELEMENT-2      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF
           END-IF.                                                      
                                                                        
       7730-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************50470000
T16943* 7740-GET-PREM-DETAIL.                                          *50070000
T16943*                                                                *50080000
T16943*                                                                *50090000
T16943******************************************************************50100000
T16943 7740-GET-PREM-DETAIL.                                            
T16943                                                                  
T16943     EXEC SQL                                                     
T16943         SELECT DISTINCT                                          
T16943                PR.LOCAL_OFFICE,                                  
T16943                PR.COMPANY_NO,                                    
T16943                DY.ZIP_CODE,                                      
T16943                DY.ZIP_CODE_TOKEN                                 
T16943           INTO                                                   
T16943                :PR-LOCAL-OFFICE,                                 
T16943                :PR-COMPANY-NO,                                   
T16943                :DY-ZIP-CODE,                                     
T16943                :DY-ZIP-CODE-TOKEN                                
T16943           FROM CSS_PREMISE         PR WITH(READUNCOMMITTED),             
T16943                CSS_ADDR_FORMATTED  DY WITH(READUNCOMMITTED)              
T16943           WHERE PR.PREMISE_NO = :PR-PREMISE-NO                   
T16943            AND DY.ADDRESS_ID  = PR.ADDRESS_ID                    
T35434                                                           
T16943     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50130000
MFA-TR*        SELECT DISTINCT                                          50140000
MFA-TR*               PR.LOCAL_OFFICE,                                          
MFA-TR*               PR.COMPANY_NO,                                            
MFA-TR*               DY.ZIP_CODE,                                              
MFA-TR*               DY.ZIP_CODE_TOKEN                                         
MFA-TR*          INTO                                                           
MFA-TR*               :PR-LOCAL-OFFICE,                                         
MFA-TR*               :PR-COMPANY-NO,                                           
MFA-TR*               :DY-ZIP-CODE,                                             
MFA-TR*               :DY-ZIP-CODE-TOKEN                                        
MFA-TR*          FROM CSS_PREMISE         PR,                                   
MFA-TR*               CSS_ADDR_FORMATTED  DY                                    
MFA-TR*          WHERE PR.PREMISE_NO = :PR-PREMISE-NO                   50170000
MFA-TR*           AND DY.ADDRESS_ID  = PR.ADDRESS_ID                    50180000
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    50200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T16943                                                                  
T16943     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T16943                                                                  
T16943     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T16943         NEXT SENTENCE                                            
T16943     ELSE                                                         
T16943         MOVE 'PARA 7740 GET PREM DET ' TO RS-ERROR-DESC          
REARCH                                           S-ERROR-DESC           
T16943         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
T16943         MOVE '7740'                    TO ACTIVE-PARAGRAPH       
T16943         MOVE 'SELECT'                  TO ABEND-FUNCTION         
T16943         MOVE 'CSS_PREMISE'             TO TABLE-1                
T16943         MOVE 'CSS_ADDR_FORMATTED'      TO TABLE-2                
CBSI           MOVE 'PREMISE_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE PR-PREMISE-NO             TO HOSTVAR-ELEMENT-1      
T16943         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T16943         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T16943     END-IF.                                                      
T16943                                                                  
T16943 7740-EXIT.                                                       
T16943     EXIT.                                                        
T16943                                                                  
C26959 7750-REG-PROFILE.                                                
C26959                                                                  
C26959     EXEC SQL                                                     
C26959         SELECT REG_GROUP_CD,                                     
C26959                SENIOR_FL                                         
C26959           INTO :LR-REG-GROUP-CD,                                 
C26959                :LR-SENIOR-FL                                     
C26959           FROM CSS_REG_PROFILE WITH(READUNCOMMITTED)                     
C26959           WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                      
T35434                                                           
C26959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50130000
MFA-TR*        SELECT REG_GROUP_CD,                                     50140000
MFA-TR*               SENIOR_FL                                                 
MFA-TR*          INTO :LR-REG-GROUP-CD,                                         
MFA-TR*               :LR-SENIOR-FL                                             
MFA-TR*          FROM CSS_REG_PROFILE                                           
MFA-TR*          WHERE ACCOUNT_NO = :HT-ACCOUNT-NO                      50170000
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    50200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26959                                                                  
C26959     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26959                                                                  
C26959     EVALUATE WS-ACTIVE-RETURN-CODE                               
C26959          WHEN SUCCESSFUL-CALL                                    
C26959              MOVE LR-REG-GROUP-CD TO RS-GROUP-CD(1:3)            
C26959              IF LR-SENIOR-FL = 'Y'                               
C26959                  MOVE '-S' TO RS-GROUP-CD(4:2)                   
C26959              ELSE                                                
C26959                  MOVE '  ' TO RS-GROUP-CD(4:2)                   
C26959              END-IF                                              
C26959          WHEN NOT-FOUND                                          
C37666              IF WS-ARCHIVED-ACCOUNT = 'Y'                        
C37666                  MOVE HA-REG-GROUP-CD TO RS-GROUP-CD(1:3)        
C37666                  IF HA-SENIOR-FL = 'Y'                           
C37666                      MOVE '-S' TO RS-GROUP-CD(4:2)               
C37666                  ELSE                                            
C37666                      MOVE '  ' TO RS-GROUP-CD(4:2)               
C37666                  END-IF                                          
C37666              ELSE                                                
C26959                  MOVE 'NA' TO RS-GROUP-CD                        
C37666              END-IF                                              
C26959          WHEN OTHER                                              
C26959              MOVE 'PARA 7750 GET REG PROF ' TO RS-ERROR-DESC     
REARCH                                                S-ERROR-DESC      
C26959              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C26959              MOVE '7750'               TO ACTIVE-PARAGRAPH       
C26959              MOVE 'SELECT'             TO ABEND-FUNCTION         
C26959              MOVE 'CSS_REG_PROFILE'    TO TABLE-1                
C26959              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
C26959              MOVE HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
C26959              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
C26959              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
C26959     END-EVALUATE.                                                
C26959                                                                  
C26959 7750-EXIT.                                                       
C26959     EXIT.                                                        
C26959                                                                  
C26959 7760-ACTIVE-DHR.                                                 
C26959                                                                  
C26959     EXEC SQL                                                     
A00172         SELECT TOP(1) 'Y'                                               
C26959           INTO :WS-ACTIVE-DHR                                    
P00172           FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
P00172           WHERE CUSTOMER_NO       = :HT-CUSTOMER-NO              
P00172             AND DHR_FL            = 'Y'                          
P00172                                           
T35434                                                           
C26959     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     50130000
MFA-TR*        SELECT 'Y'                                               50140000
MFA-TR*          INTO :WS-ACTIVE-DHR                                            
MFA-TR*          FROM CSS_CUSTOMER                                              
MFA-TR*          WHERE CUSTOMER_NO       = :HT-CUSTOMER-NO                      
MFA-TR*            AND DHR_FL            = 'Y'                                  
MFA-TR*          FETCH FIRST 1 ROWS ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                    50200000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26959                                                                  
C26959     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26959                                                                  
C26959     EVALUATE WS-ACTIVE-RETURN-CODE                               
C26959          WHEN SUCCESSFUL-CALL                                    
C26959              IF WS-ACTIVE-DHR = 'Y'                              
C26959                  MOVE '-DHR' TO RS-GROUP-CD(6:4)                 
C26959              ELSE                                                
C26959                  MOVE '    ' TO RS-GROUP-CD(6:4)                 
C26959              END-IF                                              
C26959          WHEN NOT-FOUND                                          
C26959              MOVE '    ' TO RS-GROUP-CD(6:4)                     
C26959          WHEN OTHER                                              
C26959              MOVE 'PARA 7760 ACTIVE DHR' TO RS-ERROR-DESC        
REARCH                                             S-ERROR-DESC         
C26959              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
C26959              MOVE '7760'               TO ACTIVE-PARAGRAPH       
C26959              MOVE 'SELECT'             TO ABEND-FUNCTION         
P00172              MOVE 'CSS_CUSTOMER'       TO TABLE-1                
P00172              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1        
P00172              MOVE HT-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1      
C26959              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT       
C26959              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT       
C26959     END-EVALUATE.                                                
                                                                        
       7760-EXIT.                                                       
           EXIT.                                                        
                                                                        
369600******************************************************************51410000
369700* 7915-GET-ACCOUNT-DETAILS                                       *51420000
369800*                                                                *51430000
369900*     GET COLUMNS FROM ACCOUNT TABLE.                            *51440000
370000*                                                                *51450000
370100******************************************************************51460000
370200                                                                  
370300 7915-GET-ACCOUNT-DETAILS.                                        
370400                                                                  
370500     EXEC SQL                                                     
370600         SELECT AT.CODE_ACCT_STAT,                                
370700                AT.ACCOUNT_TYPE_CODE,                             
370800                AT.LOCAL_OFFICE,                                  
370900                AT.BANKRUPTCY_IND,                                
371000                AT.ADDRESS_ID,                                    
371100                AT.CUSTOMER_NO,                                   
371200                AT.PREMISE_NO,                                    
371300                AT.MST_SUB_ACCT_IND,                              
371400                AT.CODES_DATA_PRESENT,                            
371500                AT.CREDIT_GROUP,                                  
371600                AT.CREDIT_STATUS_CODE,                            
T8430                 AT.CODE_CRIT_OUTAGE,                              
ACT282                SW.CODE_LONG_DESC                                 
371700          INTO :AT-CODE-ACCT-STAT,                                
371800               :AT-ACCOUNT-TYPE-CODE,                             
371900               :AT-LOCAL-OFFICE,                                  
372000               :AT-BANKRUPTCY-IND,                                
372100               :AT-ADDRESS-ID,                                    
372200               :AT-CUSTOMER-NO,                                   
372300               :AT-PREMISE-NO,                                    
372400               :AT-MST-SUB-ACCT-IND,                              
372500               :AT-CODES-DATA-PRESENT,                            
372600               :AT-CREDIT-GROUP,                                  
372700               :AT-CREDIT-STATUS-CODE,                            
T8430                :AT-CODE-CRIT-OUTAGE,                              
ACT282               :SW-CODE-LONG-DESC                                 
372800          FROM CSS_ACCOUNT      AT WITH(READUNCOMMITTED),                 
ACT282               CSS_SO_CODE_DESC SW WITH(READUNCOMMITTED)                  
372900         WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO              
ACT282           AND AT.ACCOUNT_TYPE_CODE = SW.CODE_VALUE               
ACT282           AND SW.TABLE_NA          = 'CSS_ACCOUNT'               
ACT282           AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'         
ACT282           AND SW.PROGRAM_ID        = 'ALL'                       
ACT282           AND SW.COMPANY_NO        = '01'                        
T35434                                                           
373000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     51500000
MFA-TR*        SELECT AT.CODE_ACCT_STAT,                                51510000
MFA-TR*               AT.ACCOUNT_TYPE_CODE,                             51520000
MFA-TR*               AT.LOCAL_OFFICE,                                  51530000
MFA-TR*               AT.BANKRUPTCY_IND,                                51540000
MFA-TR*               AT.ADDRESS_ID,                                    51550000
MFA-TR*               AT.CUSTOMER_NO,                                   51560000
MFA-TR*               AT.PREMISE_NO,                                    51570000
MFA-TR*               AT.MST_SUB_ACCT_IND,                              51580000
MFA-TR*               AT.CODES_DATA_PRESENT,                            51590000
MFA-TR*               AT.CREDIT_GROUP,                                  51600000
MFA-TR*               AT.CREDIT_STATUS_CODE,                            51610000
MFA-TR*               AT.CODE_CRIT_OUTAGE,                              51620000
MFA-TR*               SW.CODE_LONG_DESC                                 51630000
MFA-TR*         INTO :AT-CODE-ACCT-STAT,                                51640000
MFA-TR*              :AT-ACCOUNT-TYPE-CODE,                             51650000
MFA-TR*              :AT-LOCAL-OFFICE,                                  51660000
MFA-TR*              :AT-BANKRUPTCY-IND,                                51670000
MFA-TR*              :AT-ADDRESS-ID,                                    51680000
MFA-TR*              :AT-CUSTOMER-NO,                                   51690000
MFA-TR*              :AT-PREMISE-NO,                                    51700000
MFA-TR*              :AT-MST-SUB-ACCT-IND,                              51710000
MFA-TR*              :AT-CODES-DATA-PRESENT,                            51720000
MFA-TR*              :AT-CREDIT-GROUP,                                  51730000
MFA-TR*              :AT-CREDIT-STATUS-CODE,                            51740000
MFA-TR*              :AT-CODE-CRIT-OUTAGE,                              51750000
MFA-TR*              :SW-CODE-LONG-DESC                                 51760000
MFA-TR*         FROM CSS_ACCOUNT      AT,                               51770000
MFA-TR*              CSS_SO_CODE_DESC SW                                51780000
MFA-TR*        WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO              51790000
MFA-TR*          AND AT.ACCOUNT_TYPE_CODE = SW.CODE_VALUE               51800000
MFA-TR*          AND SW.TABLE_NA          = 'CSS_ACCOUNT'                       
MFA-TR*          AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'                 
MFA-TR*          AND SW.PROGRAM_ID        = 'ALL'                               
MFA-TR*          AND SW.COMPANY_NO        = '01'                                
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    51810000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

373100                                                                  
373200     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
373300                                                                  
373400     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
373500         IF HT-ADDRESS-ID = ZERO                                  
373600             MOVE AT-ADDRESS-ID TO HT-ADDRESS-ID                  
373700         END-IF                                                   
373800         IF HT-PREMISE-NO = ZERO                                  
373900             MOVE AT-PREMISE-NO TO HT-PREMISE-NO                  
374000         END-IF                                                   
374100         IF HT-CUSTOMER-NO = ZERO                                 
374200             MOVE AT-CUSTOMER-NO TO HT-CUSTOMER-NO                
374300         END-IF                                                   
374400         MOVE AT-CODES-DATA-PRESENT                               
374500             TO WS-CODES-DATA-PRESENT                             
374600     ELSE                                                         
374700         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
374800             MOVE SPACE TO AT-CODE-ACCT-STAT                      
374900                           AT-ACCOUNT-TYPE-CODE                   
375000                           AT-LOCAL-OFFICE                        
375100                           AT-BANKRUPTCY-IND                      
375200                           AT-MST-SUB-ACCT-IND                    
375300                           AT-CODES-DATA-PRESENT                  
375400                           AT-CREDIT-GROUP                        
375500                           AT-CREDIT-STATUS-CODE                  
375600                           AT-CODE-ACCT-STAT                      
T8430                            AT-CODE-CRIT-OUTAGE                    
ACT282                           SW-CODE-LONG-DESC                      
C37666             PERFORM 7990-ARCHIVE-ACCOUNT THRU 7990-EXIT          
375700         ELSE                                                     
375800             MOVE 'PARA -7915 ,SELECT CSS_ACCOUNT     '           
375900                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
376000             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
376100             MOVE '7915'                 TO ACTIVE-PARAGRAPH      
376200             MOVE 'SELECT'               TO ABEND-FUNCTION        
ACT282             MOVE 'CSS_ACCOUNT'          TO TABLE-1               
ACT282             MOVE 'CSS_SO_CODE_DESC'     TO TABLE-2               
ACT282             MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1       
ACT282             MOVE 'TABLE_NA'             TO TABLE-ELEMENT-2       
ACT282             MOVE 'COLUMN_NA'            TO TABLE-ELEMENT-3       
ACT282             MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-4       
ACT282             MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1     
ACT282             MOVE 'CSS_ACCOUNT'          TO HOSTVAR-ELEMENT-2     
ACT282             MOVE 'ACCOUNT_TYPE_CODE'    TO HOSTVAR-ELEMENT-3     
ACT282             MOVE '01'                   TO HOSTVAR-ELEMENT-4     
376600             PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
376700             PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
376800         END-IF                                                   
376900     END-IF.                                                      
377000                                                                  
377100 7915-EXIT.                                                       
377200     EXIT.                                                        
377300******************************************************************52260000
377400* 7916-GET-CUSTOMER-LOCOFF                                       *52270000
377500*                                                                *52280000
377600*     GET LOCAL OFFICE IF CUSTOMER DOES NOT HAVE AN ACCOUNT      *52290000
377700*                                                                *52300000
377800******************************************************************52310000
377900                                                                  
378000 7916-GET-CUSTOMER-LOCOFF.                                        
378100                                                                  
378200     EXEC SQL                                                     
378300         SELECT LOCAL_OFFICE_ORIG                                 
378400          INTO :AT-LOCAL-OFFICE                                   
378500          FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                         
378600         WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                      
T35434                                                           
378700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     52350000
MFA-TR*        SELECT LOCAL_OFFICE_ORIG                                 52360000
MFA-TR*         INTO :AT-LOCAL-OFFICE                                   52370000
MFA-TR*         FROM CSS_CUSTOMER                                       52380000
MFA-TR*        WHERE CUSTOMER_NO = :HT-CUSTOMER-NO                      52390000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    52400000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

378800                                                                  
378900     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
379000                                                                  
379100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
379200          NOT-FOUND                                               
379300        NEXT SENTENCE                                             
379400     ELSE                                                         
379500             MOVE 'PARA -7916 ,SELECT CSS_CUSTOMER    '           
379600                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
379700             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
379800             MOVE '7916'                 TO ACTIVE-PARAGRAPH      
379900             MOVE 'SELECT'               TO ABEND-FUNCTION        
380000             MOVE 'CSS_CUSTOMER'         TO TABLE-1               
380100             MOVE 'CUSTOMER_NO'          TO TABLE-ELEMENT-1       
380200             MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1     
380300             PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
380400             PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
380500     END-IF.                                                      
380600                                                                  
380700 7916-EXIT.                                                       
380800     EXIT.                                                        
HPCCDM*    EJECT                                                        52620000
381000******************************************************************52630000
381100* 7917-GET-PREMISE-LOCOFF                                       * 52640000
381200*                                                                *52650000
381300*     GET LOCAL OFFICE IF PREMISE  DOES NOT HAVE AN ACCOUNT      *52660000
381400*                                                                *52670000
381500******************************************************************52680000
381600*                                                                 52690000
381610*7917-GET-PREMISE-LOCOFF.                                         52700000
381620*                                                                 52710000
381621*    EXEC SQL                                                     52720000
381622*        SELECT LOCAL_OFFICE                                      52730000
381623*         INTO :AT-LOCAL-OFFICE                                   52740000
381624*         FROM CSS_PREMISE                                        52750000
381625*        WHERE PREMISE_NO = :HT-PREMISE-NO                        52760000
381626*    END-EXEC.                                                    52770000
381627*                                                                 52780000
381628*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       52790000
381629*                                                                 52800000
381630*    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                52810000
381631*         NOT-FOUND                                               52820000
381632*       NEXT SENTENCE                                             52830000
381633*    ELSE                                                         52840000
381634*            MOVE 'PARA -7917 ,SELECT CSS_CUSTOMER    '           52850000
381635*               TO RS-ERROR-DESC                                  52860000
381636*            MOVE PROGRAM-NAME           TO ABEND-PROGRAM         52870000
381637*            MOVE '7917'                 TO ACTIVE-PARAGRAPH      52880000
381638*            MOVE 'SELECT'               TO ABEND-FUNCTION        52890000
381639*            MOVE 'CSS_PREMISE'          TO TABLE-1               52900000
381640*            MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1       52910000
381641*            MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1     52920000
381642*            PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  52930000
381643*            PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  52940000
381644*    END-IF.                                                      52950000
381645*                                                                 52960000
381646*7917-EXIT.                                                       52970000
381647*    EXIT.                                                        52980000
381648*    EJECT                                                        52990000
381649******************************************************************53000000
381650* 7920-GET-ADDRESS                                               *53010000
381651*                                                                *53020000
381652*     GET COLUMNS FROM FORMATTED ADDRESS TABLE.                  *53030000
381653*                                                                *53040000
381654******************************************************************53050000
381655                                                                  
381656 7920-GET-ADDRESS.                                                
381657                                                                  
381658     EXEC SQL                                                     
381659         SELECT HOUSE_NO,                                         
381660                ADDR_PREFIX_1,                                    
381661                ADDR_PREFIX_2,                                    
381662                STREET_NAME,                                      
381663                ADDRESS_OVERFLOW,                                 
381664                ADDR_USAGE_CD,                                    
381665                STREET_SUFFIX,                                    
381666                STREET_LOCATION_1,                                
381667                STREET_LOCATION_2,                                
381668                ZIP_CODE,                                         
381669                ZIP_CODE_TOKEN,                                   
T19906                ADDR_SUFFIX                                       
381670         INTO   :DY-HOUSE-NO,                                     
381680                :DY-ADDR-PREFIX-1,                                
381690                :DY-ADDR-PREFIX-2,                                
381700                :DY-STREET-NAME,                                  
381800                :DY-ADDRESS-OVERFLOW,                             
381900                :DY-ADDR-USAGE-CD,                                
382000                :DY-STREET-SUFFIX,                                
382100                :DY-STREET-LOCATION-1,                            
382200                :DY-STREET-LOCATION-2,                            
382300                :DY-ZIP-CODE,                                     
382400                :DY-ZIP-CODE-TOKEN,                               
T19906                :DY-ADDR-SUFFIX                                   
382500           FROM CSS_ADDR_FORMATTED WITH(READUNCOMMITTED)                  
382600          WHERE ADDRESS_ID = :HT-ADDRESS-ID                       
T35434                                                           
382700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     53090000
MFA-TR*        SELECT HOUSE_NO,                                         53100000
MFA-TR*               ADDR_PREFIX_1,                                    53110000
MFA-TR*               ADDR_PREFIX_2,                                    53120000
MFA-TR*               STREET_NAME,                                      53130000
MFA-TR*               ADDRESS_OVERFLOW,                                 53140000
MFA-TR*               ADDR_USAGE_CD,                                    53150000
MFA-TR*               STREET_SUFFIX,                                    53160000
MFA-TR*               STREET_LOCATION_1,                                53170000
MFA-TR*               STREET_LOCATION_2,                                53180000
MFA-TR*               ZIP_CODE,                                         53190000
MFA-TR*               ZIP_CODE_TOKEN,                                   53200000
MFA-TR*               ADDR_SUFFIX                                               
MFA-TR*        INTO   :DY-HOUSE-NO,                                     53210000
MFA-TR*               :DY-ADDR-PREFIX-1,                                53220000
MFA-TR*               :DY-ADDR-PREFIX-2,                                53230000
MFA-TR*               :DY-STREET-NAME,                                  53240000
MFA-TR*               :DY-ADDRESS-OVERFLOW,                             53250000
MFA-TR*               :DY-ADDR-USAGE-CD,                                53260000
MFA-TR*               :DY-STREET-SUFFIX,                                53270000
MFA-TR*               :DY-STREET-LOCATION-1,                            53280000
MFA-TR*               :DY-STREET-LOCATION-2,                            53290000
MFA-TR*               :DY-ZIP-CODE,                                     53300000
MFA-TR*               :DY-ZIP-CODE-TOKEN,                               53310000
MFA-TR*               :DY-ADDR-SUFFIX                                           
MFA-TR*          FROM CSS_ADDR_FORMATTED                                53320000
MFA-TR*         WHERE ADDRESS_ID = :HT-ADDRESS-ID                       53330000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    53340000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

382800                                                                  
382900     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
383000                                                                  
383100     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR                
383200        WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
383300         NEXT SENTENCE                                            
383400     ELSE                                                         
383500         MOVE 'PARA -7920 ,SELECT CSS_ADDR_FORMATTED'             
383600            TO RS-ERROR-DESC                                      
REARCH               S-ERROR-DESC                                       
383700         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
383800         MOVE '7920'                 TO ACTIVE-PARAGRAPH          
383900         MOVE 'SELECT'               TO ABEND-FUNCTION            
384000         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
384100         MOVE 'ADDRESS_ID'           TO TABLE-ELEMENT-1           
384200         MOVE HT-ADDRESS-ID          TO HOSTVAR-ELEMENT-1         
384300         PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
384400         PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
384500     END-IF.                                                      
384600                                                                  
384700 7920-EXIT.                                                       
384800     EXIT.                                                        
HPCCDM*    EJECT                                                        53560000
385000******************************************************************53570000
385100* 7925-GET-CITY                                                  *53580000
385200*                                                                *53590000
385300*     GET CITY BASED ON ZIP CODE & TOKEN.                        *53600000
385400*                                                                *53610000
385500******************************************************************53620000
385600                                                                  
385700 7925-GET-CITY.                                                   
385800                                                                  
385900     EXEC SQL                                                     
386000         SELECT TOWN                                              
386100           INTO :A4-TOWN                                          
386200           FROM CSS_ZIP_CODE WITH(READUNCOMMITTED)                        
386300          WHERE ZIP_CODE       = :DY-ZIP-CODE                     
386400            AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               
T35434                                                           
386500     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     53660000
MFA-TR*        SELECT TOWN                                              53670000
MFA-TR*          INTO :A4-TOWN                                          53680000
MFA-TR*          FROM CSS_ZIP_CODE                                      53690000
MFA-TR*         WHERE ZIP_CODE       = :DY-ZIP-CODE                     53700000
MFA-TR*           AND ZIP_CODE_TOKEN = :DY-ZIP-CODE-TOKEN               53710000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    53720000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

386600                                                                  
386700     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
386800                                                                  
386900     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
387000         NEXT SENTENCE                                            
387100     ELSE                                                         
387200         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
387300             MOVE SPACE TO A4-TOWN                                
387400         ELSE                                                     
387500             MOVE 'PARA -7925 ,SELECT CSS_ZIP_CODE      '         
387600                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
387700             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
387800             MOVE '7925'                 TO ACTIVE-PARAGRAPH      
387900             MOVE 'SELECT'               TO ABEND-FUNCTION        
388000             MOVE 'CSS_ZIP_CODE'         TO TABLE-1               
388100             MOVE 'ZIP_CODE'             TO TABLE-ELEMENT-1       
388100             MOVE 'ZIP_CODE_TOKEN'       TO TABLE-ELEMENT-2       
388200             MOVE DY-ZIP-CODE            TO HOSTVAR-ELEMENT-1     
388200             MOVE DY-ZIP-CODE-TOKEN      TO HOSTVAR-ELEMENT-2     
388300             PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
388400             PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
388500         END-IF                                                   
388600     END-IF.                                                      
388700                                                                  
388800 7925-EXIT.                                                       
388900     EXIT.                                                        
HPCCDM*    EJECT                                                        53970000
389100******************************************************************53980000
389200* 7930-GET-NAME                                                  *53990000
389300*                                                                *54000000
389400*     GET CUSTOMER'S NAME.                                       *54010000
389500*                                                                *54020000
389600******************************************************************54030000
389700                                                                  
389800 7930-GET-NAME.                                                   
389900                                                                  
390000     EXEC SQL                                                     
390100         SELECT NAME_TYPE,                                        
390200                NAME_FORMAT,                                      
390300                LAST_NAME,                                        
390400                FIRST_NAME,                                       
390500                MIDDLE_NAME,                                      
390600                TITLE_PREFIX,                                     
390700                TITLE_SUFFIX_1,                                   
390800                TITLE_SUFFIX_2,                                   
390900                FULL_NAME                                         
391000          INTO :DQ-NAME-TYPE,                                     
391100               :DQ-NAME-FORMAT,                                   
391200               :DQ-LAST-NAME,                                     
391300               :DQ-FIRST-NAME,                                    
391400               :DQ-MIDDLE-NAME,                                   
391500               :DQ-TITLE-PREFIX,                                  
391600               :DQ-TITLE-SUFFIX-1,                                
391700               :DQ-TITLE-SUFFIX-2,                                
391800               :DQ-FULL-NAME                                      
391900           FROM CSS_NAME WITH(READUNCOMMITTED)                            
392000          WHERE NAME_ID      = :HT-NAME-ID                        
T35434                                                           
392100     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     54070000
MFA-TR*        SELECT NAME_TYPE,                                        54080000
MFA-TR*               NAME_FORMAT,                                      54090000
MFA-TR*               LAST_NAME,                                        54100000
MFA-TR*               FIRST_NAME,                                       54110000
MFA-TR*               MIDDLE_NAME,                                      54120000
MFA-TR*               TITLE_PREFIX,                                     54130000
MFA-TR*               TITLE_SUFFIX_1,                                   54140000
MFA-TR*               TITLE_SUFFIX_2,                                   54150000
MFA-TR*               FULL_NAME                                         54160000
MFA-TR*         INTO :DQ-NAME-TYPE,                                     54170000
MFA-TR*              :DQ-NAME-FORMAT,                                   54180000
MFA-TR*              :DQ-LAST-NAME,                                     54190000
MFA-TR*              :DQ-FIRST-NAME,                                    54200000
MFA-TR*              :DQ-MIDDLE-NAME,                                   54210000
MFA-TR*              :DQ-TITLE-PREFIX,                                  54220000
MFA-TR*              :DQ-TITLE-SUFFIX-1,                                54230000
MFA-TR*              :DQ-TITLE-SUFFIX-2,                                54240000
MFA-TR*              :DQ-FULL-NAME                                      54250000
MFA-TR*          FROM CSS_NAME                                          54260000
MFA-TR*         WHERE NAME_ID      = :HT-NAME-ID                        54270000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    54280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

392200                                                                  
392300     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
392400                                                                  
392500     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
392600         NEXT SENTENCE                                            
392700     ELSE                                                         
392800         IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
392900             MOVE SPACE TO DQ-NAME-TYPE                           
393000                           DQ-NAME-FORMAT                         
393100                           DQ-LAST-NAME                           
393200                           DQ-FIRST-NAME                          
393300                           DQ-MIDDLE-NAME                         
393400                           DQ-TITLE-PREFIX                        
393500                           DQ-TITLE-SUFFIX-1                      
393600                           DQ-TITLE-SUFFIX-2                      
393700                           DQ-FULL-NAME                           
393800         ELSE                                                     
393900             MOVE 'PARA -7930 ,SELECT CSS_NAME          '         
394000                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
394100             MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
394200             MOVE '7930'                 TO ACTIVE-PARAGRAPH      
394300             MOVE 'SELECT'               TO ABEND-FUNCTION        
394400             MOVE 'CSS_NAME'             TO TABLE-1               
394600             MOVE 'NAME_ID'              TO TABLE-ELEMENT-1       
394700             MOVE HT-NAME-ID             TO HOSTVAR-ELEMENT-1     
394800             PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
394900             PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
395000         END-IF                                                   
395100     END-IF.                                                      
395200                                                                  
395300 7930-EXIT.                                                       
395400     EXIT.                                                        
HPCCDM*    EJECT                                                        54620000
395600******************************************************************54630000
395700* 7940-GET-PREMISE-DETAILS.                                      *54640000
395800*                                                                *54650000
395900*     GET COLUMNS FROM PREMISE TABLE.                            *54660000
396000*                                                                *54670000
396100******************************************************************54680000
396200                                                                  
396300 7940-GET-PREMISE-DETAILS.                                        
396400                                                                  
T5839      EXEC SQL                                                     
T5839          SELECT SUBDIVISION_ID,                                   
T5839                 GAS_AVAILABLE_IND,                                
T5839                 ELEC_AVAILABLE_IND,                               
T5839                 LITE_AVAILABLE_IND,                               
T5839                 WTR_AVAILABLE_IND,                                
T5839                 SWR_AVAILABLE_IND,                                
PERF                  LOCAL_OFFICE,                                     
P35979                COMPANY_NO                                        
T5839           INTO :PR-SUBDIVISION-ID,                                
T5839                :PR-GAS-AVAILABLE-IND,                             
T5839                :PR-ELEC-AVAILABLE-IND,                            
T5839                :PR-LITE-AVAILABLE-IND,                            
T5839                :PR-WTR-AVAILABLE-IND,                             
T5839                :PR-SWR-AVAILABLE-IND,                             
PERF                 :AT-LOCAL-OFFICE,                                  
P35979               :PR-COMPANY-NO                                     
T5839           FROM CSS_PREMISE WITH(READUNCOMMITTED)                          
T5839          WHERE PREMISE_NO = :HT-PREMISE-NO                        
T35434                                                           
T5839      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     54720000
MFA-TR*        SELECT SUBDIVISION_ID,                                   54730000
MFA-TR*               GAS_AVAILABLE_IND,                                54740000
MFA-TR*               ELEC_AVAILABLE_IND,                               54750000
MFA-TR*               LITE_AVAILABLE_IND,                               54760000
MFA-TR*               WTR_AVAILABLE_IND,                                54770000
MFA-TR*               SWR_AVAILABLE_IND,                                54780000
MFA-TR*               LOCAL_OFFICE,                                     54790000
MFA-TR*               COMPANY_NO                                                
MFA-TR*         INTO :PR-SUBDIVISION-ID,                                54800000
MFA-TR*              :PR-GAS-AVAILABLE-IND,                             54810000
MFA-TR*              :PR-ELEC-AVAILABLE-IND,                            54820000
MFA-TR*              :PR-LITE-AVAILABLE-IND,                            54830000
MFA-TR*              :PR-WTR-AVAILABLE-IND,                             54840000
MFA-TR*              :PR-SWR-AVAILABLE-IND,                             54850000
MFA-TR*              :AT-LOCAL-OFFICE,                                  54860000
MFA-TR*              :PR-COMPANY-NO                                             
MFA-TR*         FROM CSS_PREMISE                                        54870000
MFA-TR*        WHERE PREMISE_NO = :HT-PREMISE-NO                        54880000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    54890000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T5839                                                                   
T5839      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T5839                                                                   
T5839      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T5839          NEXT SENTENCE                                            
T5839      ELSE                                                         
T5839          MOVE 'PARA -7940 ,SELECT CSS_PREMISE   '                 
T5839              TO RS-ERROR-DESC                                     
REARCH                S-ERROR-DESC                                      
T5839          MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T5839          MOVE '7940'                 TO ACTIVE-PARAGRAPH          
T5839          MOVE 'SELECT'               TO ABEND-FUNCTION            
T5839          MOVE 'CSS_PREMISE'          TO TABLE-1                   
T5839          MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
T5839          MOVE HT-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
T5839          PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
T5839          PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
T5839      END-IF.                                                      
T5839                                                                   
T5839      EXEC SQL                                                     
T5839          SELECT SUBDIVISION_DESC                                  
T5839            INTO :B0-SUBDIVISION-DESC                              
T5839            FROM CSS_SUBDIVISION WITH(READUNCOMMITTED)                     
T5839           WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID               
P35979            AND COMPANY_NO     = :PR-COMPANY-NO                   
T35434                                                           
T5839      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     55080000
MFA-TR*        SELECT SUBDIVISION_DESC                                  55090000
MFA-TR*          INTO :B0-SUBDIVISION-DESC                              55100000
MFA-TR*          FROM CSS_SUBDIVISION                                   55110000
MFA-TR*         WHERE SUBDIVISION_ID = :PR-SUBDIVISION-ID               55120000
MFA-TR*           AND COMPANY_NO     = :PR-COMPANY-NO                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    55130000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T5839                                                                   
T5839      IF SQLCODE = SUCCESSFUL-CALL                                 
T5839          NEXT SENTENCE                                            
T5839      ELSE                                                         
T5839          IF SQLCODE = NOT-FOUND                                   
T5839              MOVE SPACE TO B0-SUBDIVISION-DESC                    
T5839          ELSE                                                     
T5839              MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE               
T5839              MOVE 'PARA -7940 ,SELECT CSS_SUBDIVISION'            
T5839                  TO RS-ERROR-DESC                                 
REARCH                    S-ERROR-DESC                                  
T5839              MOVE PROGRAM-NAME           TO ABEND-PROGRAM         
T5839              MOVE '7940'                 TO ACTIVE-PARAGRAPH      
T5839              MOVE 'SELECT'               TO ABEND-FUNCTION        
T5839              MOVE 'CSS_SUBDIVISION'      TO TABLE-1               
T5839              MOVE 'SUBDIVISION_ID'       TO TABLE-ELEMENT-1       
T5839              MOVE PR-SUBDIVISION-ID      TO HOSTVAR-ELEMENT-1     
T5839              PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
T5839              PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
T5839          END-IF                                                   
T5839      END-IF.                                                      
400900                                                                  
401000 7940-EXIT.                                                       
401100     EXIT.                                                        
HPCCDM*    EJECT                                                        55370000
TP9748                                                                  
TP9748******************************************************************55390000
TP9748* 7950-GET-BILLING-TOWN.                                          55400000
TP9748*                                                                *55410000
TP9748*     GET THE BILLING TOWN TO FILTER ON.                         *55420000
TP9748*                                                                *55430000
TP9748******************************************************************55440000
TP9748                                                                  
TP9748 7950-GET-BILLING-TOWN.                                           
TP9748                                                                  
TP9748     EXEC SQL                                                     
TP9748         SELECT A4.TOWN                                           
TP9748          INTO :WS-TOWN                                           
TP9748          FROM CSS_ZIP_CODE A4 WITH(READUNCOMMITTED),                     
TP9748               CSS_ADDR_FORMATTED DY WITH(READUNCOMMITTED)                
TP9748         WHERE DY.ADDRESS_ID     = :DY-ADDRESS-ID                 
TP9748           AND DY.ZIP_CODE       = A4.ZIP_CODE                    
TP9748           AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              
T35434                                                           
TP9748     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     55480000
MFA-TR*        SELECT A4.TOWN                                           55490000
MFA-TR*         INTO :WS-TOWN                                           55500000
MFA-TR*         FROM CSS_ZIP_CODE A4,                                   55510000
MFA-TR*              CSS_ADDR_FORMATTED DY                              55520000
MFA-TR*        WHERE DY.ADDRESS_ID     = :DY-ADDRESS-ID                 55530000
MFA-TR*          AND DY.ZIP_CODE       = A4.ZIP_CODE                    55540000
MFA-TR*          AND DY.ZIP_CODE_TOKEN = A4.ZIP_CODE_TOKEN              55550000
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                    55560000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

TP9748                                                                  
TP9748     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
TP9748                                                                  
TP9748     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
TP9748         NEXT SENTENCE                                            
TP9748     ELSE                                                         
TP9748         MOVE 'PARA -7950 ,SELECT BILLING TOWN  '                 
TP9748             TO RS-ERROR-DESC                                     
REARCH                S-ERROR-DESC                                      
TP9748         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
TP9748         MOVE '7950'                 TO ACTIVE-PARAGRAPH          
TP9748         MOVE 'SELECT'               TO ABEND-FUNCTION            
TP9748         MOVE 'CSS_ADDR_FORMATTED'   TO TABLE-1                   
TP9748         MOVE 'CSS_ZIP_CODE'         TO TABLE-2                   
TP9748         MOVE 'ADDRESS_ID'           TO TABLE-ELEMENT-1           
TP9748         MOVE DY-ADDRESS-ID          TO HOSTVAR-ELEMENT-1         
TP9748         PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
TP9748         PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
TP9748     END-IF.                                                      
TP9748                                                                  
TP9748 7950-EXIT.                                                       
TP9748     EXIT.                                                        
TP9748                                                                  
T14567******************************************************************55790007
T14567* 7960-GET-METER                                                 *55800007
T14567*                                                                *55810007
T14567*     FIND THE ACCOUNT NUMBER FOR THE METER NUMBER.              *55820007
T14567*                                                                *55830007
T14567******************************************************************55840007
T14567                                                                  
T14567*7960-GET-METER.                                                  55860007
T14567                                                                  
T14567*    EXEC SQL                                                     55880007
T14567*        SELECT ACCOUNT_NO                                        55890007
T14567*          INTO :HT-ACCOUNT-NO                                    55900007
T14567*          FROM CSS_MTRD_ENVRNMT                                  55910007
T14567*         WHERE CODE_UTIL_TYPE = :MET-CODE-UTIL-TYPE              55920007
T14567*           AND METER_NO       = :MET-NUMBER                      55930007
T14567*    END-EXEC.                                                    55940007
T14567                                                                  
T14567*    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       55960007
T14567                                                                  
T14567*    IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      55980007
T14567*        NEXT SENTENCE                                            55990007
T14567*    ELSE                                                         56000007
T14567*        MOVE 'PARA -7960 ,SELECT CSS_MTRD_ENVRNMT'               56010007
T14567*               TO RS-ERROR-DESC                                  56020007
T14567*        MOVE PROGRAM-NAME           TO ABEND-PROGRAM             56030007
T14567*        MOVE '7960'                 TO ACTIVE-PARAGRAPH          56040007
T14567*        MOVE 'SELECT'               TO ABEND-FUNCTION            56050007
T14567*        MOVE 'CSS_MTRD_ENVRNMT'     TO TABLE-1                   56060007
T14567*        MOVE 'CODE_UTIL_TYPE'       TO TABLE-ELEMENT-1           56070007
T14567*        MOVE 'METER_NO'             TO TABLE-ELEMENT-2           56080007
T14567*        MOVE MET-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-1         56090007
T14567*        MOVE MET-NUMBER             TO HOSTVAR-ELEMENT-2         56100007
T14567*        PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  56110007
T14567*        PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  56120007
T14567*    END-IF.                                                      56130007
T14567                                                                  
T14567*7960-EXIT.                                                       56150007
T14567*    EXIT.                                                        56160007
405100******************************************************************56170000
405200* 7970-GET-CUST-NAME                                             *56180000
405300*                                                                *56190000
405400*     FIND THE CUSTOMER NAME FOR AN ACCOUNT.                     *56200000
405500*                                                                *56210000
405600******************************************************************56220000
405700                                                                  
405800 7970-GET-CUST-NAME.                                              
405900                                                                  
406000     EXEC SQL                                                     
406100         SELECT DQ.FIRST_NAME,                                    
406200                DQ.MIDDLE_NAME,                                   
406210                DQ.LAST_NAME,                                     
406220                DQ.FULL_NAME,                                     
406230                DQ.NAME_FORMAT,                                   
406240                DQ.TITLE_SUFFIX_1                                 
406250           INTO :WS-CUST-FIRST-NAME,                              
406260                :WS-CUST-MIDDLE-NAME,                             
406270                :WS-CUST-LAST-NAME,                               
406280                :WS-CUST-FULL-NAME,                               
406290                :WS-CUST-NAME-FORMAT,                             
406291                :WS-CUST-TITLE-SUFFIX-1                           
406292           FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
406293                CSS_NAME DQ WITH(READUNCOMMITTED)                         
406294          WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
406295            AND HT.NAME_ID    = DQ.NAME_ID                        
406296            AND HT.CUSTOMER_ROLE_CD = ' '                         
406298            AND DQ.NAME_TYPE  = 'CN'                              
T35434                                                           
406299     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     56260000
MFA-TR*        SELECT DQ.FIRST_NAME,                                    56270000
MFA-TR*               DQ.MIDDLE_NAME,                                   56280000
MFA-TR*               DQ.LAST_NAME,                                     56290000
MFA-TR*               DQ.FULL_NAME,                                     56300000
MFA-TR*               DQ.NAME_FORMAT,                                   56310000
MFA-TR*               DQ.TITLE_SUFFIX_1                                 56320000
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                              56330000
MFA-TR*               :WS-CUST-MIDDLE-NAME,                             56340000
MFA-TR*               :WS-CUST-LAST-NAME,                               56350000
MFA-TR*               :WS-CUST-FULL-NAME,                               56360000
MFA-TR*               :WS-CUST-NAME-FORMAT,                             56370000
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                           56380000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                            56390000
MFA-TR*               CSS_NAME DQ                                       56400000
MFA-TR*         WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    56410000
MFA-TR*           AND HT.NAME_ID    = DQ.NAME_ID                        56420000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                         56430000
MFA-TR*           AND DQ.NAME_TYPE  = 'CN'                              56440000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    56450000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

406300                                                                  
406301     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
406302                                                                  
406303     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
406304         NEXT SENTENCE                                            
406305     ELSE                                                         
406306         MOVE 'PARA -7970 ,SELECT CSS_NAME'                       
406307                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
406308         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
406309         MOVE '7970'                 TO ACTIVE-PARAGRAPH          
406310         MOVE 'SELECT'               TO ABEND-FUNCTION            
406311         MOVE 'CSS_NAME'             TO TABLE-1                   
T15538         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
406312         MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
T15538         MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
406313         MOVE HT-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
T15538         MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
406314         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
406315         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
406316     END-IF.                                                      
406317                                                                  
406318 7970-EXIT.                                                       
406319     EXIT.                                                        
T14069******************************************************************56660000
T14069* 7971-GET-CUST-NAME-WCUSNUM                                     *56670000
T14069*                                                                *56680000
T14069*     FIND THE CUSTOMER NAME FOR AN ACCOUNT USING THE CUSTOMER #.*56690000
T14069*                                                                *56700000
T14069******************************************************************56710000
T14069                                                                  
T14069 7971-GET-CUST-NAME-WCUSNUM.                                      
T14069                                                                  
T14069     EXEC SQL                                                     
T14069         SELECT DQ.FIRST_NAME,                                    
T14069                DQ.MIDDLE_NAME,                                   
T14069                DQ.LAST_NAME,                                     
T14069                DQ.FULL_NAME,                                     
T14069                DQ.NAME_FORMAT,                                   
T14069                DQ.TITLE_SUFFIX_1                                 
T14069           INTO :WS-CUST-FIRST-NAME,                              
T14069                :WS-CUST-MIDDLE-NAME,                             
T14069                :WS-CUST-LAST-NAME,                               
T14069                :WS-CUST-FULL-NAME,                               
T14069                :WS-CUST-NAME-FORMAT,                             
T14069                :WS-CUST-TITLE-SUFFIX-1                           
T14069           FROM CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED),              
T14069                CSS_NAME DQ WITH(READUNCOMMITTED)                         
T14069          WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                 
T14069            AND HT.NAME_ID      = DQ.NAME_ID                      
T14069            AND HT.CUSTOMER_ROLE_CD = ' '                         
T14069            AND DQ.NAME_TYPE    = 'CN'                            
T35434                                                           
T14069     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     56750000
MFA-TR*        SELECT DQ.FIRST_NAME,                                    56760000
MFA-TR*               DQ.MIDDLE_NAME,                                   56770000
MFA-TR*               DQ.LAST_NAME,                                     56780000
MFA-TR*               DQ.FULL_NAME,                                     56790000
MFA-TR*               DQ.NAME_FORMAT,                                   56800000
MFA-TR*               DQ.TITLE_SUFFIX_1                                 56810000
MFA-TR*          INTO :WS-CUST-FIRST-NAME,                              56820000
MFA-TR*               :WS-CUST-MIDDLE-NAME,                             56830000
MFA-TR*               :WS-CUST-LAST-NAME,                               56840000
MFA-TR*               :WS-CUST-FULL-NAME,                               56850000
MFA-TR*               :WS-CUST-NAME-FORMAT,                             56860000
MFA-TR*               :WS-CUST-TITLE-SUFFIX-1                           56870000
MFA-TR*          FROM CSS_NAME_ACCT_XREF HT,                            56880000
MFA-TR*               CSS_NAME DQ                                       56890000
MFA-TR*         WHERE HT.CUSTOMER_NO  = :HT-CUSTOMER-NO                 56900000
MFA-TR*           AND HT.NAME_ID      = DQ.NAME_ID                      56910000
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                         56920000
MFA-TR*           AND DQ.NAME_TYPE    = 'CN'                            56930000
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    56940000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T14069                                                                  
T14069     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T14069                                                                  
T14069     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
T14069         NEXT SENTENCE                                            
T14069     ELSE                                                         
T14069         MOVE 'PARA -7971 ,SELECT CSS_NAME'                       
T14069                TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T14069         MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T14069         MOVE '7971'                 TO ACTIVE-PARAGRAPH          
T14069         MOVE 'SELECT'               TO ABEND-FUNCTION            
T14069         MOVE 'CSS_NAME'             TO TABLE-1                   
T15538         MOVE 'CSS_NAME_ACCT_XREF'   TO TABLE-2                   
T14069         MOVE 'CUSTOMER-NO'          TO TABLE-ELEMENT-1           
T15538         MOVE 'NAME_TYPE'            TO TABLE-ELEMENT-2           
T14069         MOVE HT-CUSTOMER-NO         TO HOSTVAR-ELEMENT-1         
T15538         MOVE 'CN'                   TO HOSTVAR-ELEMENT-2         
T14069         PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T14069         PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T14069     END-IF.                                                      
T14069                                                                  
T14069 7971-EXIT.                                                       
T14069     EXIT.                                                        
T14069                                                                  
T8430  7980-SELECT-WHITE-CROSS.                                         
T8430                                                                   
T8430      MOVE SPACES TO RS-CODE-CRIT-OUTAGE.                          
T8430      MOVE HT-ACCOUNT-NO TO WH-ACCOUNT-NO.                         
T8430      MOVE HT-PREMISE-NO TO WH-PREMISE-NO.                         
T8430                                                                   
T8430      EXEC SQL                                                     
T8430         SELECT 'WC'                                               
T8430         INTO   :RS-CODE-CRIT-OUTAGE                               
T8430         FROM   CSS_ACCT_WHT_CROSS WITH(READUNCOMMITTED)                   
T8430         WHERE  ACCOUNT_NO = :WH-ACCOUNT-NO                        
T8430         AND    PREMISE_NO = :WH-PREMISE-NO                        
T35434                                                           
T8430      END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     57220000
MFA-TR*       SELECT 'WC'                                               57230000
MFA-TR*       INTO   :RS-CODE-CRIT-OUTAGE                               57240000
MFA-TR*       FROM   CSS_ACCT_WHT_CROSS                                 57250000
MFA-TR*       WHERE  ACCOUNT_NO = :WH-ACCOUNT-NO                        57260000
MFA-TR*       AND    PREMISE_NO = :WH-PREMISE-NO                        57270000
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    57280000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T8430                                                                   
T8430      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T8430                                                                   
T8430      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
T8430          NEXT SENTENCE                                            
T8430      ELSE                                                         
T8430          MOVE 'PARA -7980 ,SELECT CSS_WHITE_CROSS'                
T8430                 TO RS-ERROR-DESC                                  
REARCH                   S-ERROR-DESC                                   
T8430          MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
T8430          MOVE '7980'                 TO ACTIVE-PARAGRAPH          
T8430          MOVE 'SELECT'               TO ABEND-FUNCTION            
CBSI           MOVE 'CSS_ACCT_WHT_CROSS'   TO TABLE-1                   
T8430          MOVE 'ACCOUNT_NO'           TO TABLE-ELEMENT-1           
T8430          MOVE WH-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1         
T8430          MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-2           
T8430          MOVE WH-PREMISE-NO          TO HOSTVAR-ELEMENT-2         
T8430          PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
T8430          PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
T8430      END-IF.                                                      
T8430                                                                   
T8430  7980-EXIT.                                                       
T8430      EXIT.                                                        
C37666 7990-ARCHIVE-ACCOUNT.                                            
C37666                                                                  
C37666     EXEC SQL                                                     
C37666        SELECT TOP(1) CUSTOMER_NO,
              ACCOUNT_NO,
              PREMISE_NO,
              HA.COMPANY_NO,
              LOCAL_OFFICE,
              ARCHIVED_DT,
              ACCT_CREATE_DT,
              ACCT_FINALED_DT,
              HA.ACCOUNT_TYPE_CODE,
              CODE_ACCT_STAT,
              CODE_STATUS_REASON,
              CREDIT_GROUP,
              ADDRESS_ID,
              ADDRESS_FORMAT,
              LAST_PYMT_DATE,
              LAST_PYMT_AMOUNT,
              ACCT_XFER_FROM_LST,
              ACCT_XFER_TO,
              ACCOUNT_BALANCE_AM,
              REG_GROUP_CD,
              SENIOR_FL,
              DIST_ACCT_NO,
              ORIGINATION_CD,
              REPLACE(REPLACE(CONVERT(CHAR(26), GROUP_EFF_TS, 121), 
           ' ', '-'), ':', '.') GROUP_EFF_TS,
              SW.CODE_LONG_DESC                                  
C37666          INTO :HA-CUSTOMER-NO,                                   
C37666               :HA-ACCOUNT-NO,                                    
C37666               :HA-PREMISE-NO,                                    
C37666               :HA-COMPANY-NO,                                    
C37666               :HA-LOCAL-OFFICE,                                  
C37666               :HA-ARCHIVED-DT,                                   
C37666               :HA-ACCT-CREATE-DT,                                
C37666               :HA-ACCT-FINALED-DT,                               
C37666               :HA-ACCOUNT-TYPE-CODE,                             
C37666               :HA-CODE-ACCT-STAT,                                
C37666               :HA-CODE-STATUS-REASON,                            
C37666               :HA-CREDIT-GROUP,                                  
C37666               :HA-ADDRESS-ID,                                    
C37666               :HA-ADDRESS-FORMAT,                                
C37666               :HA-LAST-PYMT-DATE :WS-NULL-PYMT-DATE-HA,           
C37666               :HA-LAST-PYMT-AMOUNT,                              
C37666               :HA-ACCT-XFER-FROM-LST,                            
C37666               :HA-ACCT-XFER-TO,                                  
C37666               :HA-ACCOUNT-BALANCE-AM,                            
C37666               :HA-REG-GROUP-CD,                                  
C37666               :HA-SENIOR-FL,                                     
C37666               :HA-DIST-ACCT-NO,                                  
C37666               :HA-ORIGINATION-CD,                                
C37666               :HA-GROUP-EFF-TS :WS-NULL-GROUP-EFF-TS,             
ACT282               :SW-CODE-LONG-DESC                                 
C37666          FROM HST_ACCOUNT HA WITH(READUNCOMMITTED),                      
C37666               CSS_SO_CODE_DESC  SW WITH(READUNCOMMITTED)                 
C37666         WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO              
ACT282           AND HA.ACCOUNT_TYPE_CODE = SW.CODE_VALUE               
ACT282           AND SW.TABLE_NA          = 'CSS_ACCOUNT'               
ACT282           AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'         
ACT282           AND SW.PROGRAM_ID        = 'ALL'                       
ACT282           AND SW.COMPANY_NO        = '01'                        
C37666                                           
C37666                                                           
C37666     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CUSTOMER_NO,                                               
MFA-TR*              ACCOUNT_NO,                                                
MFA-TR*              PREMISE_NO,                                                
MFA-TR*              HA.COMPANY_NO,                                             
MFA-TR*              LOCAL_OFFICE,                                              
MFA-TR*              ARCHIVED_DT,                                               
MFA-TR*              ACCT_CREATE_DT,                                            
MFA-TR*              ACCT_FINALED_DT,                                           
MFA-TR*              HA.ACCOUNT_TYPE_CODE,                                      
MFA-TR*              CODE_ACCT_STAT,                                            
MFA-TR*              CODE_STATUS_REASON,                                        
MFA-TR*              CREDIT_GROUP,                                              
MFA-TR*              ADDRESS_ID,                                                
MFA-TR*              ADDRESS_FORMAT,                                            
MFA-TR*              LAST_PYMT_DATE,                                            
MFA-TR*              LAST_PYMT_AMOUNT,                                          
MFA-TR*              ACCT_XFER_FROM_LST,                                        
MFA-TR*              ACCT_XFER_TO,                                              
MFA-TR*              ACCOUNT_BALANCE_AM,                                        
MFA-TR*              REG_GROUP_CD,                                              
MFA-TR*              SENIOR_FL,                                                 
MFA-TR*              DIST_ACCT_NO,                                              
MFA-TR*              ORIGINATION_CD,                                            
MFA-TR*              GROUP_EFF_TS,                                              
MFA-TR*              SW.CODE_LONG_DESC                                          
MFA-TR*         INTO :HA-CUSTOMER-NO,                                           
MFA-TR*              :HA-ACCOUNT-NO,                                            
MFA-TR*              :HA-PREMISE-NO,                                            
MFA-TR*              :HA-COMPANY-NO,                                            
MFA-TR*              :HA-LOCAL-OFFICE,                                          
MFA-TR*              :HA-ARCHIVED-DT,                                           
MFA-TR*              :HA-ACCT-CREATE-DT,                                        
MFA-TR*              :HA-ACCT-FINALED-DT,                                       
MFA-TR*              :HA-ACCOUNT-TYPE-CODE,                                     
MFA-TR*              :HA-CODE-ACCT-STAT,                                        
MFA-TR*              :HA-CODE-STATUS-REASON,                                    
MFA-TR*              :HA-CREDIT-GROUP,                                          
MFA-TR*              :HA-ADDRESS-ID,                                            
MFA-TR*              :HA-ADDRESS-FORMAT,                                        
MFA-TR*              :HA-LAST-PYMT-DATE:WS-NULL-PYMT-DATE-HA,                   
MFA-TR*              :HA-LAST-PYMT-AMOUNT,                                      
MFA-TR*              :HA-ACCT-XFER-FROM-LST,                                    
MFA-TR*              :HA-ACCT-XFER-TO,                                          
MFA-TR*              :HA-ACCOUNT-BALANCE-AM,                                    
MFA-TR*              :HA-REG-GROUP-CD,                                          
MFA-TR*              :HA-SENIOR-FL,                                             
MFA-TR*              :HA-DIST-ACCT-NO,                                          
MFA-TR*              :HA-ORIGINATION-CD,                                        
MFA-TR*              :HA-GROUP-EFF-TS:WS-NULL-GROUP-EFF-TS,                     
MFA-TR*              :SW-CODE-LONG-DESC                                         
MFA-TR*         FROM HST_ACCOUNT HA,                                            
MFA-TR*              CSS_SO_CODE_DESC  SW                                       
MFA-TR*        WHERE ACCOUNT_NO           = :HT-ACCOUNT-NO                      
MFA-TR*          AND HA.ACCOUNT_TYPE_CODE = SW.CODE_VALUE                       
MFA-TR*          AND SW.TABLE_NA          = 'CSS_ACCOUNT'                       
MFA-TR*          AND SW.COLUMN_NA         = 'ACCOUNT_TYPE_CODE'                 
MFA-TR*          AND SW.PROGRAM_ID        = 'ALL'                               
MFA-TR*          AND SW.COMPANY_NO        = '01'                                
MFA-TR*         FETCH FIRST 1 ROWS ONLY                                         
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C37666                                                                  
C37666     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
C37666                                                                  
C37666     EVALUATE WS-ACTIVE-RETURN-CODE                               
C37666         WHEN SUCCESSFUL-CALL                                     
C37666             MOVE 'Y' TO WS-ARCHIVED-ACCOUNT                      
C37666             MOVE WS-ARCHIVED-ACCOUNT TO RS-ARCHIVE-IND           
C37666             IF HT-ADDRESS-ID = ZERO                              
C37666                 MOVE HA-ADDRESS-ID TO HT-ADDRESS-ID              
C37666             END-IF                                               
C37666             IF HT-PREMISE-NO = ZERO                              
C37666                 MOVE HA-PREMISE-NO TO HT-PREMISE-NO              
C37666             END-IF                                               
C37666             IF HT-CUSTOMER-NO = ZERO                             
C37666                 MOVE HA-CUSTOMER-NO TO HT-CUSTOMER-NO            
C37666             END-IF                                               
C37666             MOVE SPACES TO WS-CODES-DATA-PRESENT                 
C37666             MOVE HA-ACCOUNT-NO TO AT-ACCOUNT-NO                  
C37666             MOVE HA-ACCOUNT-TYPE-CODE TO AT-ACCOUNT-TYPE-CODE    
C37666             MOVE HA-CREDIT-GROUP TO AT-CREDIT-GROUP              
C37666             MOVE HA-LOCAL-OFFICE TO AT-LOCAL-OFFICE              
C37666             MOVE HA-CODE-ACCT-STAT TO AT-CODE-ACCT-STAT          
C37666         WHEN NOT-FOUND                                           
C37666             CONTINUE                                             
C37666         WHEN OTHER                                               
C37666             MOVE 'PARA -7990 ,SELECT HST_ACCOUNT     '           
C37666                TO RS-ERROR-DESC                                  
C37666             MOVE PROGRAM-NAME    TO ABEND-PROGRAM                
C37666             MOVE '7990'          TO ACTIVE-PARAGRAPH             
C37666             MOVE 'SELECT'        TO ABEND-FUNCTION               
C37666             MOVE 'HST_ACCOUNT'   TO TABLE-1                      
C37666             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
ACT282             MOVE 'CSS_SO_CODE_DESC'  TO TABLE-2                  
ACT282             MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1          
ACT282             MOVE 'TABLE_NA'          TO TABLE-ELEMENT-2          
ACT282             MOVE 'COLUMN_NA'         TO TABLE-ELEMENT-3          
ACT282             MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-4          
ACT282             MOVE HT-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1        
ACT282             MOVE 'CSS_ACCOUNT'       TO HOSTVAR-ELEMENT-2        
ACT282             MOVE 'ACCOUNT_TYPE_CODE' TO HOSTVAR-ELEMENT-3        
ACT282             MOVE '01'                TO HOSTVAR-ELEMENT-4        
C37666             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
C37666     END-EVALUATE.                                                
C37666                                                                  
C37666 7990-EXIT.                                                       
C37666     EXIT.                                                        
REARCH******************************************************************00000100
REARCH* 8000A-DELETE-GTT-ROWS.                                         *00000200
REARCH******************************************************************00000300
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                 00000500
REARCH     MOVE                                                         
REARCH     'DELETE ROWS'                                                
REARCH         TO S-SQL-STATEMENT-V.                                    
REARCH*                                                                 00000900
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02417_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02417_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                 00001300
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
REARCH*                                                                 00001500
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH          NEXT SENTENCE                                           
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE SQLCODE              TO ABEND-SQLCODE               
REARCH         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'DELETE'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02417_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
REARCH*                                                                 00003100
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH******************************************************************00000100
REARCH* 8100-SEND-RESULT                                               *00000200
REARCH******************************************************************00000300
REARCH 8100-SEND-RESULT.                                                
REARCH     EXEC SQL                                                     
REARCH       INSERT INTO #CSR02417_R1                            
REARCH       (                                                          
REARCH        RETURN_CODE                                               
REARCH       ,RED_FLAG_INDICATOR                                        
REARCH       ,ERROR_DESC                                                
REARCH       ,ADDRESS                                                   
REARCH       ,CITY                                                      
REARCH       ,NAME                                                      
REARCH       ,NAME_TYPE                                                 
REARCH       ,ACCT_TYPE                                                 
REARCH       ,SERVICE_SUPPLIED                                          
REARCH       ,SUBDIVISION                                               
REARCH       ,STATUS                                                    
REARCH       ,ACCOUNT_NO                                                
REARCH       ,SERVICE_AVAIL                                             
REARCH       ,CUSTOMER_NO                                               
REARCH       ,LOCAL_OFFICE                                              
REARCH       ,PREMISE_NO                                                
REARCH       ,NAME_FORMAT                                               
REARCH       ,BANKRUPT_IND                                              
REARCH       ,CREDIT_GROUP                                              
REARCH       ,CREDIT_STATUS                                             
REARCH       ,CODE_ACCT_STAT                                            
REARCH       ,ELEC_RATE                                                 
REARCH       ,GAS_RATE                                                  
REARCH       ,UNMETER_RATE                                              
REARCH       ,ZIP_CODE                                                  
REARCH       ,ZIP_CODE_TOKEN                                            
REARCH       ,MST_SUB_ACCT_IND                                          
REARCH       ,COMPANY_NO                                                
REARCH       ,CUST_NAME                                                 
REARCH       ,CODES_DATA_PRESENT                                        
REARCH       ,CODE_CRIT_OUTAGE                                          
REARCH       ,ACCT_TYPE_DESC                                            
REARCH       ,GROUP_CD                                                  
REARCH       ,METER_NO                                                  
REARCH       ,CODE_METER_STATUS                                         
REARCH       ,CODE_METER_LOC                                            
REARCH       ,METER_READ_SEQ                                            
REARCH       ,READ_CYCLE                                                
REARCH       ,READ_ROUTE                                                
A37666       ,ARCHIVE_IND                                               
REARCH       )                                                          
REARCH       VALUES                                                     
REARCH       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-RED-FLAG-INDICATOR                                     
REARCH       ,:S-ERROR-DESC                                             
REARCH       ,:S-ADDRESS                                                
REARCH       ,:S-CITY                                                   
REARCH       ,:S-NAME                                                   
REARCH       ,:S-NAME-TYPE                                              
REARCH       ,:S-ACCT-TYPE                                              
REARCH       ,:S-SERVICE-SUPPLIED                                       
REARCH       ,:S-SUBDIVISION                                            
REARCH       ,:S-STATUS                                                 
REARCH       ,:S-ACCOUNT-NO                                             
REARCH       ,:S-SERVICE-AVAIL                                          
REARCH       ,:S-CUSTOMER-NO                                            
REARCH       ,:S-LOCAL-OFFICE                                           
REARCH       ,:S-PREMISE-NO                                             
REARCH       ,:S-NAME-FORMAT                                            
REARCH       ,:S-BANKRUPT-IND                                           
REARCH       ,:S-CREDIT-GROUP                                           
REARCH       ,:S-CREDIT-STATUS                                          
REARCH       ,:S-CODE-ACCT-STAT                                         
REARCH       ,:S-ELEC-RATE                                              
REARCH       ,:S-GAS-RATE                                               
REARCH       ,:S-UNMETER-RATE                                           
REARCH       ,:S-ZIP-CODE                                               
REARCH       ,:S-ZIP-CODE-TOKEN                                         
REARCH       ,:S-MST-SUB-ACCT-IND                                       
REARCH       ,:S-COMPANY-NO                                             
REARCH       ,:S-CUST-NAME                                              
REARCH       ,:S-CODES-DATA-PRESENT                                     
REARCH       ,:S-CODE-CRIT-OUTAGE                                       
REARCH       ,:S-ACCT-TYPE-DESC                                         
REARCH       ,:S-GROUP-CD                                               
REARCH       ,:S-METER-NO                                               
REARCH       ,:S-CODE-METER-STATUS                                      
REARCH       ,:S-CODE-METER-LOC                                         
REARCH       ,:S-METER-READ-SEQ                                         
REARCH       ,:S-READ-CYCLE                                             
REARCH       ,:S-READ-ROUTE                                             
A37666       ,:S-ARCHIVE-IND                                            
REARCH       )                                                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02417_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,RED_FLAG_INDICATOR                                                
MFA-TR*      ,ERROR_DESC                                                        
MFA-TR*      ,ADDRESS                                                           
MFA-TR*      ,CITY                                                              
MFA-TR*      ,NAME                                                              
MFA-TR*      ,NAME_TYPE                                                         
MFA-TR*      ,ACCT_TYPE                                                         
MFA-TR*      ,SERVICE_SUPPLIED                                                  
MFA-TR*      ,SUBDIVISION                                                       
MFA-TR*      ,STATUS                                                            
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,SERVICE_AVAIL                                                     
MFA-TR*      ,CUSTOMER_NO                                                       
MFA-TR*      ,LOCAL_OFFICE                                                      
MFA-TR*      ,PREMISE_NO                                                        
MFA-TR*      ,NAME_FORMAT                                                       
MFA-TR*      ,BANKRUPT_IND                                                      
MFA-TR*      ,CREDIT_GROUP                                                      
MFA-TR*      ,CREDIT_STATUS                                                     
MFA-TR*      ,CODE_ACCT_STAT                                                    
MFA-TR*      ,ELEC_RATE                                                         
MFA-TR*      ,GAS_RATE                                                          
MFA-TR*      ,UNMETER_RATE                                                      
MFA-TR*      ,ZIP_CODE                                                          
MFA-TR*      ,ZIP_CODE_TOKEN                                                    
MFA-TR*      ,MST_SUB_ACCT_IND                                                  
MFA-TR*      ,COMPANY_NO                                                        
MFA-TR*      ,CUST_NAME                                                         
MFA-TR*      ,CODES_DATA_PRESENT                                                
MFA-TR*      ,CODE_CRIT_OUTAGE                                                  
MFA-TR*      ,ACCT_TYPE_DESC                                                    
MFA-TR*      ,GROUP_CD                                                          
MFA-TR*      ,METER_NO                                                          
MFA-TR*      ,CODE_METER_STATUS                                                 
MFA-TR*      ,CODE_METER_LOC                                                    
MFA-TR*      ,METER_READ_SEQ                                                    
MFA-TR*      ,READ_CYCLE                                                        
MFA-TR*      ,READ_ROUTE                                                        
MFA-TR*      ,ARCHIVE_IND                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-RED-FLAG-INDICATOR                                             
MFA-TR*      ,:S-ERROR-DESC                                                     
MFA-TR*      ,:S-ADDRESS                                                        
MFA-TR*      ,:S-CITY                                                           
MFA-TR*      ,:S-NAME                                                           
MFA-TR*      ,:S-NAME-TYPE                                                      
MFA-TR*      ,:S-ACCT-TYPE                                                      
MFA-TR*      ,:S-SERVICE-SUPPLIED                                               
MFA-TR*      ,:S-SUBDIVISION                                                    
MFA-TR*      ,:S-STATUS                                                         
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-SERVICE-AVAIL                                                  
MFA-TR*      ,:S-CUSTOMER-NO                                                    
MFA-TR*      ,:S-LOCAL-OFFICE                                                   
MFA-TR*      ,:S-PREMISE-NO                                                     
MFA-TR*      ,:S-NAME-FORMAT                                                    
MFA-TR*      ,:S-BANKRUPT-IND                                                   
MFA-TR*      ,:S-CREDIT-GROUP                                                   
MFA-TR*      ,:S-CREDIT-STATUS                                                  
MFA-TR*      ,:S-CODE-ACCT-STAT                                                 
MFA-TR*      ,:S-ELEC-RATE                                                      
MFA-TR*      ,:S-GAS-RATE                                                       
MFA-TR*      ,:S-UNMETER-RATE                                                   
MFA-TR*      ,:S-ZIP-CODE                                                       
MFA-TR*      ,:S-ZIP-CODE-TOKEN                                                 
MFA-TR*      ,:S-MST-SUB-ACCT-IND                                               
MFA-TR*      ,:S-COMPANY-NO                                                     
MFA-TR*      ,:S-CUST-NAME                                                      
MFA-TR*      ,:S-CODES-DATA-PRESENT                                             
MFA-TR*      ,:S-CODE-CRIT-OUTAGE                                               
MFA-TR*      ,:S-ACCT-TYPE-DESC                                                 
MFA-TR*      ,:S-GROUP-CD                                                       
MFA-TR*      ,:S-METER-NO                                                       
MFA-TR*      ,:S-CODE-METER-STATUS                                              
MFA-TR*      ,:S-CODE-METER-LOC                                                 
MFA-TR*      ,:S-METER-READ-SEQ                                                 
MFA-TR*      ,:S-READ-CYCLE                                                     
MFA-TR*      ,:S-READ-ROUTE                                                     
MFA-TR*      ,:S-ARCHIVE-IND                                                    
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
REARCH                                                                  
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH         MOVE SQLCODE              TO ABEND-SQLCODE               
REARCH         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02417_R1'        TO TABLE-1                      
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH     ADD 1 TO CTR-ROWS.                                           
REARCH     INITIALIZE GTT-RETURN-FIELDS.                                
REARCH*                                                                 00002000
REARCH 8100-EXIT.                                                       
REARCH      EXIT.                                                       
406320******************************************************************57510000
406321* 9900- JOURNALING / ERROR HANDLING INCLUDE *                     57520000
406322******************************************************************57530000
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
HPCCDM*    EJECT                                                        57570000
406327******************************************************************57580000
406328*       END PROGRAM COPYLIB                                      *57590000
406329******************************************************************57600000
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPD00320                                                
REARCH     END-EXEC.                                                            
