       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.  CSR02416.                                           
       AUTHOR.      BASKAR VANNI.                                       
COB303 DATE-WRITTEN. SEP 2009.                                           
       DATE-COMPILED.                                                   
                                                                        
      *----------------------------------------------------------------         
      *--                  SOUTH CAROLINA ELECTRIC & GAS             --         
      *----------------------------------------------------------------         
      *--                   STORED PROCEDURE:  CSR02416              --         
      *----------------------------------------------------------------         
      *--                         S U M M A R Y                      --         
      *--                                                            --         
      *--  CSR02416 :                                                --         
      *--                                                            --         
      *--    #  UPDATES PENDING CREDIT CARD PAYMENT ROWS             --         
      *--    #  BLOCKS OR UNBLOCKS AN ACCOUNT FROM RECURRING CREDIT  --         
      *--    #  CARD ENROLLMENT                                      --         
      *--                                                            --         
      *--    #  INVOKED FROM PANEL 190                               --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                                                            --         
      *--    PARAMETERS                                              --         
      *--                                                            --         
      *--        IN                                                  --         
      *--                                                            --         
      *--              I_ACCOUNT_NO              CHAR(13)            --         
      *--              I_ACTION_FLAG             CHAR(01)            --         
      *--              I_PAYMENT_DATE            CHAR(10)            --         
      *--              I_OLD_PYMT_DATE           CHAR(10)            --         
      *--              I_PAYMENT_AMT             CHAR(13)            --         
      *--              I_PAYMENT_STATUS          CHAR(01)            --         
A02714*--              I_PYMT_CANC_RES           CHAR(02)            --         
      *--              I_COMMENTS                CHAR(210)           --         
A05460*--              I_USER_ID                 CHAR(07)            --         
      *--                                                            --         
      *--        OUT                                                 --         
      *--                                                            --         
      *--              NONE                                          --         
      *--                                                            --         
      *--        INOUT                                               --         
      *--                                                            --         
      *--              NONE                                          --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--    RESULT SET                                              --         
      *--                                                            --         
      *--      1                                                     --         
      *--              RETURN CODE               INTEGER             --         
      *--                                                            --         
      *----------------------------------------------------------------         
      *--                   MODIFICATION LOG                         --         
      *--                                                            --         
      *--   DATE      INITIALS    COMMENTS                           --         
      *-- ----------  --------    -------------------------------------         
      *--                                                            --         
      *-- 09/30/2009  BASKAR V    NEW CODE FOR PROJCSR526            --         
A02714*-- 10/19/2011  AP40911     ADD CREDIT CARD PAYMENT CANCEL     --         
      *--                         REASON.                            --         
A05460*-- 06/27/2016  VENKAT.P    GET USER ID VIA INPUT PARM.        --         
      *----------------------------------------------------------------         
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02416'.
MSQ017     COPY MFASQLM.
                                                                        
      *----------------------------------------------------------------*        
      *    DB2 INCLUDES                                                *        
      *----------------------------------------------------------------*        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      *---CSS_PNDNG_CARD_PMT                                                    
           EXEC SQL                                                             
              INCLUDE TBPNDCRD                                                  
           END-EXEC.                                                            
                                                                        
      *---CSS_ACCT_ATTRIBUTE                                                    
           EXEC SQL                                                             
              INCLUDE TBACTATT                                                  
           END-EXEC.                                                            
                                                                        
      *---CSS_USER_PROFILE                                                      
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      *---CSS_MNT_TRANS_HIST                                                    
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *---CSS_MT_TRN_HST_DET                                                    
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
A02714*---CSS_CC_PMT_CANC_RS                                                    
           EXEC SQL                                                             
              INCLUDE TBCRDCAN                                                  
           END-EXEC.                                                            
                                                                        
      *---COPYBOOK FOR ERROR HANDLING                                           
           EXEC SQL                                                             
               INCLUDE CWSX0010                                                 
           END-EXEC.                                                            
                                                                        
      *---DB2 ERRORS                                                            
            COPY CWS00303.                                                      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           10 S-RETURN-CODE            PIC S9(9)  VALUE 0 COMP.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05 CTR-COLUMN               PIC S9(9)  COMP VALUE 1.         
           05 CTR-ROWS                 PIC S9(9)  COMP VALUE 0.         
                                                                        
       01  WS-CONSTANTS.                                                
           05 WS-SYSTEM                PIC X(07) VALUE 'SYSTEM'.        
           05 PROGRAM-NAME             PIC X(08) VALUE 'CSR02416'.      
                                                                        
       01  WS-MISC-ITEMS.                                               
           05 WS-CURRENT-DATE          PIC X(10) VALUE SPACES.          
           05 WS-CURRENT-USER          PIC X(08) VALUE SPACES.          
           05 WS-CURRENT-TS            PIC X(26) VALUE SPACES.          
           05 WS-ACCOUNT-NO            PIC X(13).                       
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO PIC 9(13).      
           05 WS-PYMT-AMT              PIC X(11).                       
           05 WS-PYMT-AMT-NUM REDEFINES WS-PYMT-AMT PIC 9(9)V99.        
           05 WS-PAYMENT-AMT           PIC S9(09)V99 COMP-3 VALUE +0.   
           05 WS-OLD-AMT               PIC 9(9)V99.                     
           05 WS-OLD-AMT-CHAR REDEFINES WS-OLD-AMT  PIC X(11).          
           05 WS-OLD-STATUS            PIC X(01) VALUE SPACES.          
           05 SEND-DONE-SW             PIC X(01) VALUE 'Y'.             
              88 SEND-DONE-ERROR                 VALUE 'N'.             
              88 SEND-DONE-OK                    VALUE 'Y'.             
           05 WS-UPDATE-REQUIRED       PIC X(01) VALUE 'N'.             
              88 UPDATE-REQUIRED                 VALUE 'Y'.             
              88 UPDATE-NOT-REQUIRED             VALUE 'N'.             
           05 WS-AMT-DEC-Z             PIC -Z(08)9.99 VALUE ZEROES.     
           05 WS-AMT-DEC               PIC -9(09).99  VALUE ZEROES.     
                                                                        
       01  WS-NULL-INDICATORS.                                          
           05 WS-NULL-IND-1            PIC S9(4)  USAGE COMP VALUE +0.  
           05 WS-NULL-IND-2            PIC S9(4)  USAGE COMP VALUE +0.  
           05 WS-NULL-IND-3            PIC S9(4)  USAGE COMP VALUE +0.  
           05 WS-NULL-IND-4            PIC S9(4)  USAGE COMP VALUE +0.  
                                                                        
       LINKAGE SECTION.                                                 
       01  I-ACCOUNT-NO                PIC X(13).                       
       01  I-ACTION-FLAG               PIC X(01).                       
       01  I-PAYMENT-DATE              PIC X(10).                       
       01  I-OLD-PYMT-DATE             PIC X(10).                       
       01  I-PAYMENT-AMT               PIC X(13).                       
       01  I-PAYMENT-STATUS            PIC X(01).                       
A02714 01  I-PYMT-CANC-RES             PIC X(02).                       
       01  I-COMMENTS                  PIC X(210).                      
A05460 01  I-USER-ID                   PIC X(07).                       
                                                                        
       PROCEDURE DIVISION USING I-ACCOUNT-NO                            
                               ,I-ACTION-FLAG                           
                               ,I-PAYMENT-DATE                          
                               ,I-OLD-PYMT-DATE                         
                               ,I-PAYMENT-AMT                           
                               ,I-PAYMENT-STATUS                        
A02714                         ,I-PYMT-CANC-RES                         
                               ,I-COMMENTS                              
A05460                         ,I-USER-ID.                              
                                                                        
      *--------------------------------------------------------------*          
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                    *          
      *--------------------------------------------------------------*          
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE           THRU 0100-EXIT             
                                                                        
           PERFORM 1000-PROCESS-INPUT        THRU 1000-EXIT             
                                                                        
           PERFORM 2000-PROCESS-OUTPUT       THRU 2000-EXIT             
                                                                        
           PERFORM 9999-END-PROGRAM          THRU 9999-EXIT             
                                                                        
           .                                                            
       0000-MAINLINE-EXIT.                                              
           EXIT.                                                        
                                                                        
      *--------------------------------------------------------------*          
      *    SET UP SQL ERROR PROCESSING                               *          
      *    DECLARE ASSOCIATED CURSOR                                 *          
      *--------------------------------------------------------------*          
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC               
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC               
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC               
                                                                        
           EXEC SQL                                                     
            DECLARE C1 CURSOR  FOR                           
             SELECT :S-RETURN-CODE AS RETURN_CODE                       
               FROM CIS.SYSDUMMY1                                    
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE C1 CURSOR WITH RETURN FOR                                   
MFA-TR*      SELECT :S-RETURN-CODE AS RETURN_CODE                               
MFA-TR*        FROM SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC                                                             
                                                                        
           .                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           INITIALIZE GTT-RETURN-FIELDS                                 
           ADD +1 TO CTR-ROWS                                           
                                                                        
           PERFORM 7000-GET-CURRENT-DATE                                
              THRU 7000-EXIT                                            
                                                                        
           MOVE  I-ACCOUNT-NO        TO  WS-ACCOUNT-NO                  
           MOVE  WS-ACCOUNT-NO-NUM   TO  PC-ACCOUNT-NO                  
                                                                        
           MOVE  I-PAYMENT-AMT       TO  WS-PYMT-AMT                    
           MOVE  WS-PYMT-AMT-NUM     TO  WS-PAYMENT-AMT                 
           MOVE  WS-PAYMENT-AMT      TO  PC-PAYMENT-AMT                 
                                                                        
           MOVE  I-PAYMENT-DATE      TO  PC-PAYMENT-DATE                
           MOVE  I-PAYMENT-STATUS    TO  PC-STATUS-CODE                 
A02714     MOVE  I-PYMT-CANC-RES     TO  PC-PMT-CANCEL-REAS-CD          
A05460     MOVE  I-USER-ID           TO  WS-CURRENT-USER                
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DECIDES THE PROGRAM PATH DEPENDING ON THE UPDATE ACTION FLAG   *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           EVALUATE I-ACTION-FLAG                                       
               WHEN 'I'                                                 
                 PERFORM 8100-INSERT-PAYMENT                            
                    THRU 8100-EXIT                                      
               WHEN 'U'                                                 
                 PERFORM 2100-PROCESS-UPDATES                           
                    THRU 2100-EXIT                                      
               WHEN 'D'                                                 
                 MOVE 'X'            TO PC-STATUS-CODE                  
                 MOVE WS-CURRENT-TS  TO PC-CANCELLED-TS                 
                 PERFORM 8300-CANCEL-PAYMENT                            
                    THRU 8300-EXIT                                      
               WHEN 'B'                                                 
                 MOVE PC-ACCOUNT-NO  TO  YP-ACCOUNT-NO                  
                 PERFORM 2200-PROCESS-BLOCK                             
                    THRU 2200-EXIT                                      
               WHEN 'R'                                                 
                 MOVE PC-ACCOUNT-NO  TO  YP-ACCOUNT-NO                  
                 PERFORM 8500-DELETE-ACCT-ATTR                          
                    THRU 8500-EXIT                                      
           END-EVALUATE                                                 
                                                                        
           PERFORM 2500-WRITE-MAINT-HIST                                
              THRU 2500-EXIT                                            
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      *  DECIDES VALUES TO UPDATE THE RECURRING CARD PAYMENT           *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2100-PROCESS-UPDATES.                                            
                                                                        
           IF I-OLD-PYMT-DATE > SPACES                                  
              MOVE I-OLD-PYMT-DATE  TO  PC-PAYMENT-DATE                 
              MOVE 'X'              TO  PC-STATUS-CODE                  
              MOVE WS-CURRENT-TS    TO  PC-CANCELLED-TS                 
              PERFORM 8300-CANCEL-PAYMENT                               
                 THRU 8300-EXIT                                         
                                                                        
              MOVE I-PAYMENT-DATE   TO  PC-PAYMENT-DATE                 
              MOVE I-PAYMENT-STATUS TO  PC-STATUS-CODE                  
              PERFORM 8100-INSERT-PAYMENT                               
                 THRU 8100-EXIT                                         
           END-IF                                                       
                                                                        
           PERFORM 7100-SELECT-PAYMENT                                  
              THRU 7100-EXIT                                            
                                                                        
           MOVE PC-PAYMENT-AMT            TO WS-OLD-AMT                 
           MOVE PC-STATUS-CODE            TO WS-OLD-STATUS              
                                                                        
           IF WS-PAYMENT-AMT NOT EQUAL PC-PAYMENT-AMT                   
              SET UPDATE-REQUIRED         TO TRUE                       
              MOVE WS-PAYMENT-AMT         TO PC-PAYMENT-AMT             
           END-IF                                                       
                                                                        
           IF I-PAYMENT-STATUS NOT EQUAL PC-STATUS-CODE                 
              SET UPDATE-REQUIRED         TO TRUE                       
              MOVE I-PAYMENT-STATUS       TO PC-STATUS-CODE             
              EVALUATE I-PAYMENT-STATUS                                 
                  WHEN 'A'                                              
                    MOVE WS-CURRENT-TS    TO PC-CREATED-TS              
                    MOVE +0               TO WS-NULL-IND-1              
                  WHEN 'E'                                              
                    MOVE WS-CURRENT-TS    TO PC-EXTRACTED-TS            
                    MOVE +0               TO WS-NULL-IND-2              
                  WHEN 'P'                                              
                    MOVE WS-CURRENT-TS    TO PC-PYMT-POSTED-TS          
                    MOVE +0               TO WS-NULL-IND-3              
                  WHEN 'X'                                              
                    MOVE WS-CURRENT-TS    TO PC-CANCELLED-TS            
                    MOVE +0               TO WS-NULL-IND-4              
              END-EVALUATE                                              
           END-IF                                                       
                                                                        
           IF UPDATE-REQUIRED                                           
              SET UPDATE-NOT-REQUIRED     TO TRUE                       
              PERFORM 8200-UPDATE-PAYMENT                               
                 THRU 8200-EXIT                                         
           END-IF                                                       
           .                                                            
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DECIDES VALUES TO BLOCK A CUSTOMER FROM ENROLLING IN RECURRING *        
      * CREDIT CARD PAYMENT                                            *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2200-PROCESS-BLOCK.                                              
                                                                        
           PERFORM 7200-SELECT-ACCT-ATTR                                
              THRU 7200-EXIT                                            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              STRING 'BLOCK_TS='     DELIMITED BY SIZE                  
                     WS-CURRENT-TS   DELIMITED BY SIZE                  
                INTO YP-ATTRIBUTE-VALUE-TX-TEXT                         
              MOVE +35               TO YP-ATTRIBUTE-VALUE-TX-LEN       
              PERFORM 8600-INSERT-ACCT-ATTR                             
                 THRU 8600-EXIT                                         
           ELSE                                                         
              EVALUATE YP-STATUS-CD                                     
                  WHEN 'A'                                              
                     MOVE +1000      TO S-RETURN-CODE                   
                     PERFORM 9999-END-PROGRAM                           
                        THRU 9999-EXIT                                  
                  WHEN 'B'                                              
                     MOVE +2000      TO S-RETURN-CODE                   
                     PERFORM 9999-END-PROGRAM                           
                        THRU 9999-EXIT                                  
                  WHEN 'C'                                              
                    STRING YP-ATTRIBUTE-VALUE-TX-TEXT(1:40)             
                                                      DELIMITED BY SIZE 
                           'BLOCK_TS='                DELIMITED BY SIZE 
                           WS-CURRENT-TS              DELIMITED BY SIZE 
                      INTO YP-ATTRIBUTE-VALUE-TX-TEXT                   
                    MOVE +75         TO YP-ATTRIBUTE-VALUE-TX-LEN       
                    PERFORM 8400-UPDATE-ACCT-ATTR                       
                       THRU 8400-EXIT                                   
              END-EVALUATE                                              
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * WRITES MAINTENANCE TRANSACTION HISTORY                         *        
      *                                                                *        
      *----------------------------------------------------------------*        
       2500-WRITE-MAINT-HIST.                                           
                                                                        
           MOVE WS-CURRENT-USER         TO PF-USER-ID                   
           PERFORM 7300-SELECT-USER-PROF                                
              THRU 7300-EXIT                                            
                                                                        
           MOVE WS-CURRENT-TS           TO MH-TRANS-HIST-SEQ-NO         
                                           MI-TRANS-HIST-SEQ-NO         
           MOVE WS-CURRENT-DATE         TO MH-DATE-TRANS                
           MOVE 'F'                     TO MH-CODE-TRAN-TYPE            
           MOVE PF-RESP-AREA-ID         TO MH-RESP-AREA-ID              
           MOVE PC-ACCOUNT-NO           TO MH-ACCOUNT-NO                
           MOVE ZEROES                  TO MH-CUSTOMER-NO               
                                           MH-PREMISE-NO                
           MOVE WS-CURRENT-USER         TO MH-USER-ID                   
           MOVE PROGRAM-NAME            TO MH-APPL-PROGRAM-ID           
           MOVE LENGTH OF I-COMMENTS    TO MH-TRAN-COMMENT-LEN          
           MOVE I-COMMENTS              TO MH-TRAN-COMMENT-TEXT         
           MOVE SPACES                  TO MI-TABLE-ID                  
           MOVE +20                     TO MH-ENTITY-KEY-DESC-LEN       
           MOVE 'AUTO CARD PAY UPDATE'  TO MH-ENTITY-KEY-DESC-TEXT      
           MOVE 0                       TO MI-TRAN-APPL-NO              
                                                                        
           EVALUATE I-ACTION-FLAG                                       
             WHEN 'I'                                                   
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'PAYMENT AMOUNT'    TO MI-COLUMN-DESC               
               MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE WS-PYMT-AMT-NUM     TO WS-AMT-DEC                   
               MOVE WS-AMT-DEC          TO WS-AMT-DEC-Z                 
               MOVE WS-AMT-DEC-Z        TO MI-CHG-COLUMN-VALUE-TEXT     
               MOVE +13                 TO  MI-CHG-COLUMN-VALUE-LEN     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'PAYMENT DATE'      TO MI-COLUMN-DESC               
               MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +10                 TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE I-PAYMENT-DATE      TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'PC'                TO MI-TABLE-ID                  
               MOVE 'STATUS'            TO MI-COLUMN-DESC               
               MOVE +5                  TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE '*NEW*'             TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +1                  TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE I-PAYMENT-STATUS    TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
             WHEN 'U'                                                   
               IF WS-PAYMENT-AMT NOT EQUAL WS-OLD-AMT                   
                  ADD 1                 TO MI-TRAN-APPL-NO              
                  MOVE 'PAYMENT AMOUNT' TO MI-COLUMN-DESC               
                  MOVE +13              TO MI-PRV-COLUMN-VALUE-LEN      
                  MOVE WS-OLD-AMT       TO WS-AMT-DEC                   
                  MOVE WS-AMT-DEC       TO WS-AMT-DEC-Z                 
                  MOVE WS-AMT-DEC-Z     TO MI-PRV-COLUMN-VALUE-TEXT     
                  MOVE WS-PYMT-AMT-NUM  TO WS-AMT-DEC                   
                  MOVE WS-AMT-DEC       TO WS-AMT-DEC-Z                 
                  MOVE WS-AMT-DEC-Z     TO MI-CHG-COLUMN-VALUE-TEXT     
                  MOVE +13              TO MI-CHG-COLUMN-VALUE-LEN      
                  PERFORM 6530-LOAD-MNT-TRANS-HIST                      
                     THRU 6530-EXIT                                     
               END-IF                                                   
               IF I-OLD-PYMT-DATE > SPACES                              
                  ADD 1                 TO MI-TRAN-APPL-NO              
                  MOVE 'PAYMENT DATE'   TO MI-COLUMN-DESC               
                  MOVE +10              TO MI-PRV-COLUMN-VALUE-LEN      
                  MOVE I-OLD-PYMT-DATE  TO MI-PRV-COLUMN-VALUE-TEXT     
                  MOVE +10              TO MI-CHG-COLUMN-VALUE-LEN      
                  MOVE I-PAYMENT-DATE   TO MI-CHG-COLUMN-VALUE-TEXT     
                  PERFORM 6530-LOAD-MNT-TRANS-HIST                      
                     THRU 6530-EXIT                                     
               END-IF                                                   
               IF I-PAYMENT-STATUS NOT EQUAL WS-OLD-STATUS              
                  ADD 1                 TO MI-TRAN-APPL-NO              
                  MOVE 'PC'             TO MI-TABLE-ID                  
                  MOVE 'STATUS'         TO MI-COLUMN-DESC               
                  MOVE +1               TO MI-PRV-COLUMN-VALUE-LEN      
                  MOVE WS-OLD-STATUS    TO MI-PRV-COLUMN-VALUE-TEXT     
                  MOVE +1               TO MI-CHG-COLUMN-VALUE-LEN      
                  MOVE I-PAYMENT-STATUS TO MI-CHG-COLUMN-VALUE-TEXT     
                  PERFORM 6530-LOAD-MNT-TRANS-HIST                      
                     THRU 6530-EXIT                                     
               END-IF                                                   
                                                                        
             WHEN 'D'                                                   
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'PAYMENT DATE'      TO MI-COLUMN-DESC               
               MOVE +10                 TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE I-PAYMENT-DATE      TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
                                                                        
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'PAYMENT AMOUNT'    TO MI-COLUMN-DESC               
               MOVE WS-PYMT-AMT-NUM     TO WS-AMT-DEC                   
               MOVE WS-AMT-DEC          TO WS-AMT-DEC-Z                 
               MOVE WS-AMT-DEC-Z        TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +13                 TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
                                                                        
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'PC'                TO MI-TABLE-ID                  
               MOVE 'STATUS'            TO MI-COLUMN-DESC               
               MOVE +1                  TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE I-PAYMENT-STATUS    TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +9                  TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE '*DELETED*'         TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
             WHEN 'B'                                                   
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'ACCOUNT BLOCKED'   TO MI-COLUMN-DESC               
               MOVE +2                  TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE 'NO'                TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +3                  TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE 'YES'               TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
                                                                        
             WHEN 'R'                                                   
               ADD  1                   TO MI-TRAN-APPL-NO              
               MOVE 'ACCOUNT BLOCKED'   TO MI-COLUMN-DESC               
               MOVE +3                  TO MI-PRV-COLUMN-VALUE-LEN      
               MOVE 'YES'               TO MI-PRV-COLUMN-VALUE-TEXT     
               MOVE +2                  TO MI-CHG-COLUMN-VALUE-LEN      
               MOVE 'NO'                TO MI-CHG-COLUMN-VALUE-TEXT     
               PERFORM 6530-LOAD-MNT-TRANS-HIST                         
                  THRU 6530-EXIT                                        
                                                                        
           END-EVALUATE                                                 
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *---------------------------------------------------------------*         
      * SELECTS CURRENT DATE, TIMESTAMP AND USER                      *         
      *---------------------------------------------------------------*         
                                                                        
       7000-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE),
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-DATE,
              :WS-CURRENT-TS                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*            ,:WS-CURRENT-TS   = CURRENT TIMESTAMP                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
                                            S-RETURN-CODE               
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE I-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS A RECURRING CREDIT CARD PAYMENT FOR AN ACCOUNT         *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7100-SELECT-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
             SELECT PAYMENT_AMT                                         
                   ,STATUS_CODE                                         
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), CREATED_TS, 121), 
           ' ', '-'), ':', '.') CREATED_TS                                     
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), EXTRACTED_TS
           , 121), ' ', '-'), ':', '.') EXTRACTED_TS                           
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_POSTED_TS
           , 121), ' ', '-'), ':', '.') PYMT_POSTED_TS                         
                   ,REPLACE(REPLACE(CONVERT(CHAR(26), CANCELLED_TS
           , 121), ' ', '-'), ':', '.') CANCELLED_TS                           
               INTO :PC-PAYMENT-AMT                                     
                   ,:PC-STATUS-CODE                                     
                   ,:PC-CREATED-TS :WS-NULL-IND-1                  
                   ,:PC-EXTRACTED-TS :WS-NULL-IND-2                  
                   ,:PC-PYMT-POSTED-TS :WS-NULL-IND-3                  
                   ,:PC-CANCELLED-TS :WS-NULL-IND-4                  
               FROM CSS_PNDNG_CARD_PMT WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO   = :PC-ACCOUNT-NO                       
                AND PAYMENT_DATE = IIF(TRY_CONVERT(DATE, 
                                                       :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )                     
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT PAYMENT_AMT                                                 
MFA-TR*            ,STATUS_CODE                                                 
MFA-TR*            ,CREATED_TS                                                  
MFA-TR*            ,EXTRACTED_TS                                                
MFA-TR*            ,PYMT_POSTED_TS                                              
MFA-TR*            ,CANCELLED_TS                                                
MFA-TR*        INTO :PC-PAYMENT-AMT                                             
MFA-TR*            ,:PC-STATUS-CODE                                             
MFA-TR*            ,:PC-CREATED-TS      :WS-NULL-IND-1                          
MFA-TR*            ,:PC-EXTRACTED-TS    :WS-NULL-IND-2                          
MFA-TR*            ,:PC-PYMT-POSTED-TS  :WS-NULL-IND-3                          
MFA-TR*            ,:PC-CANCELLED-TS    :WS-NULL-IND-4                          
MFA-TR*        FROM CSS_PNDNG_CARD_PMT                                          
MFA-TR*       WHERE ACCOUNT_NO   = :PC-ACCOUNT-NO                               
MFA-TR*         AND PAYMENT_DATE = :PC-PAYMENT-DATE                             
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PNDNG_CARD_PMT'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PAYMENT_DATE'            TO TABLE-ELEMENT-2         
              MOVE PC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE PC-PAYMENT-DATE           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS ACCOUNT ATTRIBUTE FOR RECURRING CREDIT CARD            *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7200-SELECT-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
             SELECT STATUS_CD                                           
                   ,ATTRIBUTE_VALUE_TX                                  
               INTO :YP-STATUS-CD                                       
                   ,:YP-ATTRIBUTE-VALUE-TX                              
               FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                    
              WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                     
                AND ATTRIBUTE_DESC = 'AUTO_CARD_PAY'                    
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT STATUS_CD                                                   
MFA-TR*            ,ATTRIBUTE_VALUE_TX                                          
MFA-TR*        INTO :YP-STATUS-CD                                               
MFA-TR*            ,:YP-ATTRIBUTE-VALUE-TX                                      
MFA-TR*        FROM CSS_ACCT_ATTRIBUTE                                          
MFA-TR*       WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                             
MFA-TR*         AND ATTRIBUTE_DESC = 'AUTO_CARD_PAY'                            
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ATTRIBUTE_DESC'          TO TABLE-ELEMENT-2         
              MOVE YP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'AUTO_CARD_PAY'           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SELECTS RESP AREA                                              *        
      *                                                                *        
      *----------------------------------------------------------------*        
       7300-SELECT-USER-PROF.                                           
                                                                        
           EXEC SQL                                                     
             SELECT RESP_AREA_ID                                        
               INTO :PF-RESP-AREA-ID                                    
               FROM CSS_USER_PROFILE WITH(READUNCOMMITTED)                      
              WHERE USER_ID  = :PF-USER-ID                              
                                                                 
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT RESP_AREA_ID                                                
MFA-TR*        INTO :PF-RESP-AREA-ID                                            
MFA-TR*        FROM CSS_USER_PROFILE                                            
MFA-TR*       WHERE USER_ID  = :PF-USER-ID                                      
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_USER_PROFILE'        TO TABLE-1                 
              MOVE 'USER_ID'                 TO TABLE-ELEMENT-1         
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-2         
              MOVE PF-USER-ID                TO HOSTVAR-ELEMENT-1       
              MOVE I-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * SCHEDULES A NEW PAYMENT FOR A RECURRING CREDIT CARD            *        
      *                                                                *        
      *----------------------------------------------------------------*        
       8100-INSERT-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_PNDNG_CARD_PMT                             
                    (ACCOUNT_NO                                         
                    ,PAYMENT_DATE                                       
                    ,PAYMENT_AMT                                        
                    ,STATUS_CODE                                        
                    ,CREATED_TS                                         
                    ,EXTRACTED_TS                                       
                    ,PYMT_POSTED_TS                                     
                    ,CANCELLED_TS                                       
                    )                                                   
             VALUES                                                     
                    (:PC-ACCOUNT-NO                                     
                    ,IIF(TRY_CONVERT(DATE, :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )                             
                    ,:PC-PAYMENT-AMT                                    
                    ,:PC-STATUS-CODE                                    
                    ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS)                         
                    ,NULL                                               
                    ,NULL                                               
                    ,NULL                                               
                    )                                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_PNDNG_CARD_PMT                                     
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,PAYMENT_DATE                                               
MFA-TR*             ,PAYMENT_AMT                                                
MFA-TR*             ,STATUS_CODE                                                
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,EXTRACTED_TS                                               
MFA-TR*             ,PYMT_POSTED_TS                                             
MFA-TR*             ,CANCELLED_TS                                               
MFA-TR*             )                                                           
MFA-TR*      VALUES                                                             
MFA-TR*             (:PC-ACCOUNT-NO                                             
MFA-TR*             ,:PC-PAYMENT-DATE                                           
MFA-TR*             ,:PC-PAYMENT-AMT                                            
MFA-TR*             ,:PC-STATUS-CODE                                            
MFA-TR*             ,:WS-CURRENT-TS                                             
MFA-TR*             ,NULL                                                       
MFA-TR*             ,NULL                                                       
MFA-TR*             ,NULL                                                       
MFA-TR*             )                                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8100'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PNDNG_CARD_PMT'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PAYMENT_DATE'            TO TABLE-ELEMENT-2         
              MOVE 'PAYMENT_AMT'             TO TABLE-ELEMENT-3         
              MOVE 'STATUS_CODE'             TO TABLE-ELEMENT-4         
              MOVE PC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE PC-PAYMENT-DATE           TO HOSTVAR-ELEMENT-2       
              MOVE I-PAYMENT-AMT             TO HOSTVAR-ELEMENT-3       
              MOVE PC-STATUS-CODE            TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATES THE STATUS, PAYMENT AMT, TIMESTAMPS OF A RECURRING CARD*        
      * PAYMENT                                                        *        
      *----------------------------------------------------------------*        
       8200-UPDATE-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PNDNG_CARD_PMT                                  
                SET STATUS_CODE    = :PC-STATUS-CODE                    
                   ,PAYMENT_AMT    = :PC-PAYMENT-AMT                    
                   ,CREATED_TS     = CIS.CHAR2TIMESTAMP(:PC-CREATED-TS 
                                                        :WS-NULL-IND-1)  
                   ,EXTRACTED_TS   = CIS.CHAR2TIMESTAMP(
                                                      :PC-EXTRACTED-TS 
                                                        :WS-NULL-IND-2)  
                   ,PYMT_POSTED_TS = CIS.CHAR2TIMESTAMP(
                                                    :PC-PYMT-POSTED-TS 
                                                        :WS-NULL-IND-3)  
                   ,CANCELLED_TS   = CIS.CHAR2TIMESTAMP(
                                                      :PC-CANCELLED-TS 
                                                        :WS-NULL-IND-4)  
A02714             ,PMT_CANCEL_REAS_CD = :PC-PMT-CANCEL-REAS-CD         
              WHERE ACCOUNT_NO     = :PC-ACCOUNT-NO                     
                AND PAYMENT_DATE   = IIF(TRY_CONVERT(DATE, 
                                                       :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PNDNG_CARD_PMT                                          
MFA-TR*         SET STATUS_CODE    = :PC-STATUS-CODE                            
MFA-TR*            ,PAYMENT_AMT    = :PC-PAYMENT-AMT                            
MFA-TR*            ,CREATED_TS     = :PC-CREATED-TS     :WS-NULL-IND-1          
MFA-TR*            ,EXTRACTED_TS   = :PC-EXTRACTED-TS   :WS-NULL-IND-2          
MFA-TR*            ,PYMT_POSTED_TS = :PC-PYMT-POSTED-TS :WS-NULL-IND-3          
MFA-TR*            ,CANCELLED_TS   = :PC-CANCELLED-TS   :WS-NULL-IND-4          
MFA-TR*            ,PMT_CANCEL_REAS_CD = :PC-PMT-CANCEL-REAS-CD                 
MFA-TR*       WHERE ACCOUNT_NO     = :PC-ACCOUNT-NO                             
MFA-TR*         AND PAYMENT_DATE   = :PC-PAYMENT-DATE                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8200'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PNDNG_CARD_PMT'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PAYMENT_DATE'            TO TABLE-ELEMENT-2         
              MOVE 'PAYMENT_AMT'             TO TABLE-ELEMENT-3         
              MOVE 'STATUS_CODE'             TO TABLE-ELEMENT-4         
              MOVE PC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE PC-PAYMENT-DATE           TO HOSTVAR-ELEMENT-2       
              MOVE I-PAYMENT-AMT             TO HOSTVAR-ELEMENT-3       
              MOVE PC-STATUS-CODE            TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATES THE STATUS OF A PAYMENT IN PENDING CARD PAYMENT TABLE  *        
      *                                                                *        
      *----------------------------------------------------------------*        
       8300-CANCEL-PAYMENT.                                             
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_PNDNG_CARD_PMT                                  
                SET STATUS_CODE        = :PC-STATUS-CODE                
                   ,CANCELLED_TS       = CIS.CHAR2TIMESTAMP(
                                                         :WS-CURRENT-TS
              )                 
A02714             ,PMT_CANCEL_REAS_CD = :PC-PMT-CANCEL-REAS-CD         
              WHERE ACCOUNT_NO         = :PC-ACCOUNT-NO                 
                AND PAYMENT_DATE       = IIF(TRY_CONVERT(DATE, 
                                                       :PC-PAYMENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PC-PAYMENT-DATE
              ) <> 0) OR (LEN(:PC-PAYMENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :PC-PAYMENT-DATE
              ), CONVERT(DATE, :PC-PAYMENT-DATE) )               
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_PNDNG_CARD_PMT                                          
MFA-TR*         SET STATUS_CODE        = :PC-STATUS-CODE                        
MFA-TR*            ,CANCELLED_TS       = :WS-CURRENT-TS                         
MFA-TR*            ,PMT_CANCEL_REAS_CD = :PC-PMT-CANCEL-REAS-CD                 
MFA-TR*       WHERE ACCOUNT_NO         = :PC-ACCOUNT-NO                         
MFA-TR*         AND PAYMENT_DATE       = :PC-PAYMENT-DATE                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_PNDNG_CARD_PMT'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PAYMENT_DATE'            TO TABLE-ELEMENT-2         
              MOVE PC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE PC-PAYMENT-DATE           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * UPDATES THE ACCOUNT ATTRIBUTE TO BLOCK A CUSTOMER FROM         *        
      * ENROLLING IN RECURRING CREDIT CARD                             *        
      *----------------------------------------------------------------*        
       8400-UPDATE-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_ACCT_ATTRIBUTE                                  
                SET STATUS_CD          = 'B'                            
                   ,ATTRIBUTE_VALUE_DT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )               
                   ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX         
              WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                 
                AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      UPDATE CSS_ACCT_ATTRIBUTE                                          
MFA-TR*         SET STATUS_CD          = 'B'                                    
MFA-TR*            ,ATTRIBUTE_VALUE_DT = :WS-CURRENT-DATE                       
MFA-TR*            ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX                 
MFA-TR*       WHERE ACCOUNT_NO         = :YP-ACCOUNT-NO                         
MFA-TR*         AND ATTRIBUTE_DESC     = 'AUTO_CARD_PAY'                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8400'                    TO ACTIVE-PARAGRAPH        
              MOVE 'UPDATE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ATTRIBUTE_DESC'          TO TABLE-ELEMENT-2         
              MOVE YP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'AUTO_CARD_PAY'           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * DELETING AN ACCOUNT ATTRIBUTE ROW SO THAT THE CUSTOMER CAN     *        
      * ENROLL IN RECURRING CREDIT CARD - REMVOES THE BLOCK            *        
      *----------------------------------------------------------------*        
       8500-DELETE-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
             DELETE FROM CSS_ACCT_ATTRIBUTE                             
              WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                     
                AND ATTRIBUTE_DESC = 'AUTO_CARD_PAY'                    
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8500'                    TO ACTIVE-PARAGRAPH        
              MOVE 'DELETE'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ATTRIBUTE_DESC'          TO TABLE-ELEMENT-2         
              MOVE YP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'AUTO_CARD_PAY'           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * INSERTS A ROW IN CSS_ACCT_ATTRIBUTE TABLE TO BLOCK AN ACCOUNT  *        
      * FROM ENROLLING RECURRING CREDIT CARD                           *        
      *----------------------------------------------------------------*        
       8600-INSERT-ACCT-ATTR.                                           
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_ACCT_ATTRIBUTE                             
                    (ACCOUNT_NO                                         
                    ,ATTRIBUTE_DESC                                     
                    ,ATTRIBUTE_VALUE_CD                                 
                    ,ATTRIBUTE_VALUE_DT                                 
                    ,ATTRIBUTE_VALUE_TX                                 
                    ,CREATED_TS                                         
                    ,STATUS_CD                                          
                    )                                                   
             VALUES                                                     
                    (:YP-ACCOUNT-NO                                     
                    ,'AUTO_CARD_PAY'                                    
                    ,'AUTOC'                                            
                    ,IIF(TRY_CONVERT(DATE, :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                             
                    ,:YP-ATTRIBUTE-VALUE-TX                             
                    ,CIS.CHAR2TIMESTAMP(:WS-CURRENT-TS)                         
                    ,'B'                                                
                    )                                                   
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_ACCT_ATTRIBUTE                                     
MFA-TR*             (ACCOUNT_NO                                                 
MFA-TR*             ,ATTRIBUTE_DESC                                             
MFA-TR*             ,ATTRIBUTE_VALUE_CD                                         
MFA-TR*             ,ATTRIBUTE_VALUE_DT                                         
MFA-TR*             ,ATTRIBUTE_VALUE_TX                                         
MFA-TR*             ,CREATED_TS                                                 
MFA-TR*             ,STATUS_CD                                                  
MFA-TR*             )                                                           
MFA-TR*      VALUES                                                             
MFA-TR*             (:YP-ACCOUNT-NO                                             
MFA-TR*             ,'AUTO_CARD_PAY'                                            
MFA-TR*             ,'AUTOC'                                                    
MFA-TR*             ,:WS-CURRENT-DATE                                           
MFA-TR*             ,:YP-ATTRIBUTE-VALUE-TX                                     
MFA-TR*             ,:WS-CURRENT-TS                                             
MFA-TR*             ,'B'                                                        
MFA-TR*             )                                                           
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                               S-RETURN-CODE            
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8600'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE SPACES                    TO ABEND-SQL-PREDICATES    
                                                ABEND-TABLES            
              MOVE 'CSS_ACCT_ATTRIBUTE'      TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'ATTRIBUTE_DESC'          TO TABLE-ELEMENT-2         
              MOVE YP-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE 'AUTO_CARD_PAY'           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF                                                       
           .                                                            
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *----------------------------------------------------------------*        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *                                                                *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 9900-SQL-ERROR-ROUTINE                                         *        
      *                                                                *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      *----------------------------------------------------------------*        
      * 9000-SEND-ERROR-RESULT                                         *        
      * 8900-SEND-DONE                                                 *        
      * 9999-END-PROGRAM                                               *        
      *----------------------------------------------------------------*        
           EXEC SQL                                                             
              INCLUDE CPD00321                                                  
           END-EXEC.                                                            
                                                                        
