       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID. CSR02412.                                            
       DATE-WRITTEN. OCTOBER 1999.                                      
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S412                                           *00120001
      *  PROGRAM:       S412                                           *00130001
      *  CALLING SP:    PA_S412                                        *00140002
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      * THIS PROGRAM INSERTS A ROW INTO CSS_CSH_DRWR_JRNL TO BOOK AN   *00180000
      * OVERAGE OR SHORTAGE FOR THE CURRENCIES EXISTING IN THE BATCH   *00180000
      * AND UPDATES CSS_CSH_DRWR_CNTL FOR NO_ITEMS_ENTERED.            *00180000
      *                                                                *00180000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  10/29/99  CBSI       ORIGINALLY CODED                         *00240000
T19920*  11/25/99  CBSI       MODIFIED TO CHECK FOR AR LOCKOUT.        *00240000
T19930*  11/25/99  CBSI       MODIFIED TO GET LOCAL OFFICE FROM        *00280000
T19930*                       CSS_CASHIER_OFFICE.                      *00280000
      *  04/09/01  CHANELLE K MCR310 PSNC CHANGES.  CSS_GL_ACCT_NO AND *        
      *                       RECOMPILE FOR CPD00006.                  *        
C25923*  05/30/02  BASKAR     INSERT ROW IN CSS_OVERSHORT_HDR AND      *        
C25923*                       CSS_OVERSHORT_DTL TABLES                 *        
REARCH*  05/27/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
PRDFIX*  08/31/05  BASKAR     FIX PROD TRAN ID PROBLEM                 *        
T35434*  10/24/07  MR97640    REPLACED CSS_MODEL_SQL WITH SET COMMAND  *        
T35434*                       AND ADDED 'WITH UR' FOR SINGLETON SELECTS*        
A00956*  03/26/09  CVNS       REPLACE CPD00006 WITH CPD0006A.          *        
A00956*            CHENNAI                                             *        
P00586*  10/19/16  VENKAT.P   OFFSET REVERSAL CHANGES, DELETE COMMENTED*        
P00586*                       CODE                                     *        
      ******************************************************************00320000
                                                                        
      ******************************************************************00330000
      *                                                                *00340000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350000
      *                                                                *00360000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390000
      *  3000 - 4999  NOT USED                                         *00400000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420000
      *  7000 - 7999  INPUT MODULES                                    *00430000
      *  8000 - 8999  OUTPUT MODULES                                   *00440000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450000
      *                                                                *00460000
      ******************************************************************00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02412'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02412 STARTS HERE'.                  
                                                                        
      ******************************************************************01080000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090000
      ******************************************************************01100000
                                                                        
REARCH*   COPY SYGWCOB.                                                 01120000
REARCH*   COPY SYDBCOB.                                                 01130000
REARCH*   COPY CWS00010.                                                01150000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
REARCH*                                                                         
          COPY CWS00303.                                                01170000
          COPY CJF00101.                                                01170000
                                                                        
      ******************************************************************01240000
      *    WORK AREAS                                                  *01250000
      ******************************************************************01260000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02412_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
       01  FILLER                       PIC X(11)      VALUE            
                                                       'PARM FIELDS'.   
                                                                        
C25923 01  WS-OVSH-ARRAY.                                               
C25923     05  WS-OVSH-ARRAY-DETAIL OCCURS 25 TIMES.                    
C25923         10  WS-OFST-COMPANY      PIC X(02).                      
C25923         10  WS-OFST-LOC-OFCE     PIC X(03).                      
C25923         10  WS-OFST-REPT-DATE    PIC X(10).                      
C25923         10  WS-OFST-DRWR         PIC X(04).                      
C25923         10  WS-OFST-DRWR-ID REDEFINES WS-OFST-DRWR               
C25923                                  PIC S9(04).                     
C25923         10  WS-OFST-OVSH         PIC X(04).                      
C25923         10  WS-OFST-OVSH-ID REDEFINES WS-OFST-OVSH               
C25923                                  PIC S9(04).                     
C25923         10  WS-OVSH-ACCOUNT-NO   PIC X(13).                      
C25923         10  WS-OFST-OVSH-AMOUNT  PIC X(13).                      
C25923         10  WS-OFST-OVSH-AMT REDEFINES WS-OFST-OVSH-AMOUNT       
C25923                                  PIC S9(11)V9(2).                
C25923         10  WS-OFST-DR-CR        PIC X(01).                      
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9)      COMP.            
           05  SNA-CONNECTION-NAME      PIC X(8)       VALUE SPACES.    
                                                                        
       01  COUNTER-FLAG.                                                
           05  CTR-COLUMN               PIC S9(9)      COMP             
                                                       VALUE 1.         
           05  CTR-ROWS                 PIC S9(9)      COMP             
                                                       VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9)      COMP.            
           05  WRKLEN1                  PIC S9(9)      COMP.            
           05  WRKLEN2                  PIC S9(9)      COMP.            
           05  WRK-DONE-STATUS          PIC S9(9)      COMP.            
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(08)      VALUE 'CSR02412'.
REARCH     05  WS-SQLSTATE              PIC X(05)      VALUE SPACES.    
           05  ALL-DONE-SW              PIC X(01)      VALUE 'N'.       
               88 NOT-ALL-DONE                         VALUE 'N'.       
               88 ALL-DONE                             VALUE 'Y'.       
           05  SEND-DONE-SW             PIC X(01)      VALUE 'Y'.       
               88 SEND-DONE-ERROR                      VALUE 'N'.       
               88 SEND-DONE-OK                         VALUE 'Y'.       
           05  WS-CR-DR-SW              PIC X(01)      VALUE 'C'.       
               88 CREDIT-TRUE                          VALUE 'C'.       
               88 DEBIT-TRUE                           VALUE 'D'.       
                                                                        
       01  WS-WORK-FIELDS.                                              
           05  WS-GL-ACCT-NO            PIC X(07).                      
           05  WS-GL-ACCT-NUM REDEFINES WS-GL-ACCT-NO                   
                                        PIC 9(03)V9(04).                
                                                                        
           05  WS-UPDATE-TYPE           PIC X(01).                      
           05  WS-TRAN-COMMENT-LEN      PIC S9(09)     COMP.            
           05  WS-TRAN-COMMENT-TEXT     PIC X(210).                     
           05  WS-CLR-CASH              PIC X(10)      VALUE 'CLR-CASH'.
           05  WS-CURRENT-DATE          PIC X(10).                      
C25923     05  WS-NULL-INDICATOR-1      PIC S9(4) COMP VALUE +0.        
C25923     05  WS-NULL-INDICATOR-2      PIC S9(4) COMP VALUE +0.        
C25923     05  WS-ACCOUNT-NO            PIC X(13).                      
C25923     05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
C25923                                  PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13) COMP-3 VALUE 0.             
C25923     05  WS-OVSH-COUNT            PIC S9(04) COMP VALUE +0.       
C25923     05  WS-SUB                   PIC S9(04) COMP VALUE +0.       
C25923     05  WS-DRAWER-ID             PIC S9(04) COMP VALUE +0.       
C25923     05  WS-OVERSHORT-ID          PIC S9(04) COMP VALUE +0.       
C25923     05  WS-OVERSHORT-AMT         PIC S9(11)V99 COMP-3 VALUE +0.  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-N                     PIC X(01)      VALUE 'N'.       
T19920     05  WS-Y                     PIC X(01)      VALUE 'Y'.       
           05  WS-A                     PIC X(01)      VALUE 'A'.       
           05  WS-C                     PIC X(01)      VALUE 'C'.       
           05  WS-D                     PIC X(01)      VALUE 'D'.       
           05  WS-O                     PIC X(01)      VALUE 'O'.       
           05  WS-P                     PIC X(01)      VALUE 'P'.       
P00586     05  WS-R                     PIC X(01)      VALUE 'R'.       
C25923     05  WS-S                     PIC X(01)      VALUE 'S'.       
C25923     05  WS-05                    PIC X(02)      VALUE '05'.      
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9)      COMP             
                                                       VALUE 0.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9)      COMP VALUE 0.    
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
                                                                        
           EXEC SQL                                                     00600000
                INCLUDE SQLCA                                           00610000
           END-EXEC.                                                    00620000
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_CNTL                                      *             
      *************************************************************             
                                                                        
           EXEC SQL                                                     00840000
                INCLUDE TBCDCNTL                                        00850000
           END-EXEC.                                                    00860000
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_JRNL                                      *             
      *************************************************************             
                                                                        
           EXEC SQL                                                     04420000
                INCLUDE TBCDJRNL                                        04430000
           END-EXEC.                                                    04440000
                                                                        
      *************************************************************             
      *    CSS_USER_PROFILE                                       *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
                INCLUDE TBUSRPRF                                                
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_GL_ACCT_NO                                         *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
                INCLUDE TBGLATNO                                                
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_MISC_JRNL                                          *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
                INCLUDE TBMSJRNL                                                
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_BATCH_JRNL                                         *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBTJRNL                                                
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_BCH_JRNL_CNTL                                      *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
                INCLUDE TBBJCNTL                                                
           END-EXEC.                                                            
                                                                        
C25923* OH - CSS_OVERSHORT_HDR                                                  
                                                                        
           EXEC SQL                                                             
              INCLUDE TBOVSHHD                                                  
           END-EXEC.                                                            
                                                                        
      * OH - CSS_OVERSHORT_DET                                                  
                                                                        
           EXEC SQL                                                             
              INCLUDE TBOVSHDT                                                  
C25923     END-EXEC.                                                            
                                                                        
T19920                                                                  
T19920*************************************************************             
T19920*    CSS_AR_LOCKOUT                                         *             
T19920*************************************************************             
T19920                                                                  
T19920     EXEC SQL                                                             
T19920          INCLUDE TBARLOCK                                                
T19920     END-EXEC.                                                            
T19930                                                                  
T19930*************************************************************             
T19930*    CSS_CASHIER_OFFICE                                     *             
T19930*************************************************************             
T19930                                                                  
T19930     EXEC SQL                                                             
T19930          INCLUDE  TBCSHOFF                                               
T19930     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     25690000
                INCLUDE CWS00017                                        25700000
           END-EXEC.                                                    25710000
                                                                        
           EXEC SQL                                                     25690000
A00956          INCLUDE CWS0013B                                        25700000
           END-EXEC.                                                    25710000
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-UPDATE-TYPE             PIC X(01).                      
REARCH 01  PARM-GL-ACCT-NO              PIC X(07).                      
COB305 01 PARM-AMT-ENTERED        PIC 9(09)V99 COMP-3 VALUE 0.          
REARCH 01  PARM-CURRENCY-TYPE           PIC X(01).                      
REARCH 01  PARM-TRAN-COMMENT-LEN        PIC S9(04)     COMP.            
REARCH 01  PARM-TRAN-COMMENT-TEXT       PIC X(210).                     
REARCH 01  PARM-USER-ID                 PIC X(07).                      
REARCH 01  PARM-PANEL-NO                PIC X(09).                      
REARCH 01  PARM-DATE-CASH-REPORT        PIC X(10).                      
REARCH 01  PARM-CASH-COMPANY-NO         PIC X(02).                      
REARCH 01  PARM-CASH-LOCAL-OFFICE       PIC X(03).                      
REARCH 01  PARM-CASH-DRAWER-ID          PIC S9(04)     COMP.            
REARCH 01  PARM-CSR-PC-ID               PIC X(04).                      
REARCH 01  PARM-OVSH-TYPE-CD            PIC X(02).                      
REARCH 01  PARM-OVSH-SOLTN-FL           PIC X(01).                      
REARCH 01  PARM-OVSH-ARRAY-1            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-2            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-3            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-4            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-5            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-6            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-7            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-8            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-9            PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-10           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-11           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-12           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-13           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-14           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-15           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-16           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-17           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-18           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-19           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-20           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-21           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-22           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-23           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-24           PIC X(50).                      
REARCH 01  PARM-OVSH-ARRAY-25           PIC X(50).                      
REARCH*                                                                         
REARCH PROCEDURE DIVISION  USING PARM-UPDATE-TYPE                       
REARCH                           PARM-GL-ACCT-NO                        
REARCH                           PARM-AMT-ENTERED                       
REARCH                           PARM-CURRENCY-TYPE                     
REARCH                           PARM-TRAN-COMMENT-LEN                  
REARCH                           PARM-TRAN-COMMENT-TEXT                 
REARCH                           PARM-USER-ID                           
REARCH                           PARM-PANEL-NO                          
REARCH                           PARM-DATE-CASH-REPORT                  
REARCH                           PARM-CASH-COMPANY-NO                   
REARCH                           PARM-CASH-LOCAL-OFFICE                 
REARCH                           PARM-CASH-DRAWER-ID                    
REARCH                           PARM-CSR-PC-ID                         
REARCH                           PARM-OVSH-TYPE-CD                      
REARCH                           PARM-OVSH-SOLTN-FL                     
REARCH                           PARM-OVSH-ARRAY-1                      
REARCH                           PARM-OVSH-ARRAY-2                      
REARCH                           PARM-OVSH-ARRAY-3                      
REARCH                           PARM-OVSH-ARRAY-4                      
REARCH                           PARM-OVSH-ARRAY-5                      
REARCH                           PARM-OVSH-ARRAY-6                      
REARCH                           PARM-OVSH-ARRAY-7                      
REARCH                           PARM-OVSH-ARRAY-8                      
REARCH                           PARM-OVSH-ARRAY-9                      
REARCH                           PARM-OVSH-ARRAY-10                     
REARCH                           PARM-OVSH-ARRAY-11                     
REARCH                           PARM-OVSH-ARRAY-12                     
REARCH                           PARM-OVSH-ARRAY-13                     
REARCH                           PARM-OVSH-ARRAY-14                     
REARCH                           PARM-OVSH-ARRAY-15                     
REARCH                           PARM-OVSH-ARRAY-16                     
REARCH                           PARM-OVSH-ARRAY-17                     
REARCH                           PARM-OVSH-ARRAY-18                     
REARCH                           PARM-OVSH-ARRAY-19                     
REARCH                           PARM-OVSH-ARRAY-20                     
REARCH                           PARM-OVSH-ARRAY-21                     
REARCH                           PARM-OVSH-ARRAY-22                     
REARCH                           PARM-OVSH-ARRAY-23                     
REARCH                           PARM-OVSH-ARRAY-24                     
REARCH                           PARM-OVSH-ARRAY-25.                    
                                                                        
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE          THRU 0100-EXIT              
           PERFORM 1000-PROCESS-INPUT       THRU 1000-EXIT              
           PERFORM 2000-PROCESS-OUTPUT      THRU 2000-EXIT              
           PERFORM 9999-END-PROGRAM         THRU 9999-EXIT              
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      *                                                                *02310000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02330000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02340000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02350000
      *                                                                *02360000
      ******************************************************************02370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC               
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC               
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC               
                                                                        
           INITIALIZE TDS-RETURN-FIELDS                                 
           .                                                            
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               :S-RETURN-CODE         AS RETURN_CODE              
REARCH          FROM                                                    
REARCH               CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02650000
      * 1000-PROCESS-INPUT                                             *02660000
      *                                                                *        
      *        RECEIVE PARMS.                                          *02680000
      *                                                                *        
      ******************************************************************02700000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                      TO ACTIVE-PARAGRAPH         
           MOVE PARM-GL-ACCT-NO             TO WS-GL-ACCT-NO            
           MOVE PARM-TRAN-COMMENT-LEN       TO WS-TRAN-COMMENT-LEN      
           MOVE PARM-TRAN-COMMENT-TEXT      TO WS-TRAN-COMMENT-TEXT     
           MOVE PARM-UPDATE-TYPE            TO WS-UPDATE-TYPE           
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      *                                                                *05130000
      *     1. DESCRIBE RESULT SET                                     *05130000
      *     2. BUILD THE RESULT SET                                    *05150000
      *     3. SEND RESULT SET                                         *05170000
      *                                                                *05180000
      ******************************************************************05190000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH         
T19920     PERFORM 7999-SELECT-AL           THRU 7999-SELECT-AL-EXIT    
T19920                                                                  
T19920     IF  AL-AR-LOCKOUT-IND = WS-Y                                 
T19920         MOVE 5000                     TO RS-RETURN-CODE          
REARCH         PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT            
REARCH         ADD +1                        TO CTR-ROWS                
T19920         PERFORM 9999-END-PROGRAM      THRU 9999-EXIT             
T19920     END-IF                                                       
T19920                                                                  
           PERFORM 2200-PROCESS-DETAIL      THRU 2200-EXIT              
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH***************************************************************** 05040000
REARCH*2000A-MOVE-RESULT                                              * 05040000
REARCH***************************************************************** 05040000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-PROCESS-DETAIL                                            *        
      *                                                                *        
      *   GET THE CURRENT DATE.                                        *        
      *   GET THE CLEAR CASH GL-ACCOUNT-NO                             *        
      *   CHECK FOR OVERAGE/SHORTAGE TRANSACTION                       *        
      *   CHECK BATCH-STATUS                                           *        
      *   INSERT INTO CSS_CSH_DRWR_JRNL                                *        
      *   UPDATE  CSS_CSH_DRWR_CNTL                                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-DETAIL.                                             
                                                                        
           MOVE '2200'                      TO ACTIVE-PARAGRAPH.        
           PERFORM 7100-GET-CURRENT-DATE    THRU 7100-EXIT              
           MOVE PARM-CASH-COMPANY-NO        TO WS-100-COMPANY-NO,       
T19930                                         Y2-CASH-COMPANY-NO       
T19930     MOVE PARM-CASH-LOCAL-OFFICE      TO Y2-CASH-LOCAL-OFFICE     
T19930     PERFORM 7300-GET-GL-LOC-OFF      THRU 7300-EXIT              
           MOVE 9                           TO WS-TRAN-OPER-LEVEL       
           MOVE 1                           TO WS-TRAN-OCAP-FIELD       
           MOVE 1                           TO WS-TRAN-OCAP-VALUE       
           MOVE WS-C                        TO WS-TRAN-JRNL-TYPE        
           MOVE WS-N                        TO WS-TRAN-HOLD-EXEMPT-FLAG 
           MOVE PARM-USER-ID                TO WS-JRNL-OL-TEMP-ID       
           MOVE WS-JRNL-CK-OPER-ID          TO WS-JRNL-OPERATION-RQST   
           MOVE PROGRAM-NAME                TO WS-100-CODE-TERMINAL-TRAN
           MOVE PARM-PANEL-NO               TO WS-PAR-APPL-PROG-ID      
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
                                                                        
           MOVE PARM-CASH-COMPANY-NO        TO WS-JRNL-OL-COMPANY       
           MOVE PARM-CASH-LOCAL-OFFICE      TO WS-JRNL-OL-LOC-OFF,      
                                               WS-JRNL-OL-REPORT-NO     
           MOVE PARM-DATE-CASH-REPORT       TO WS-JRNL-OL-REPORT-DT     
           MOVE PARM-CASH-DRAWER-ID         TO WS-JRNL-OL-CASH-DRWR     
           MOVE PARM-CSR-PC-ID              TO WS-JRNL-OL-CSR-PC-ID     
           MOVE WS-JRNL-OL-OPR-LOC          TO WS-JRNL-OL-TERM-LOC      
                                               WS-JRNL-OL-CASH-LOC      
           MOVE WS-JRNL-VALIDATE-OPER       TO WS-JRNL-OPERATION-RQST   
           MOVE WS-C                        TO WS-JRNL-SOURCE-CODE      
           MOVE WS-JRNL-CASH-UPDATE         TO WS-JRNL-OL-AUTH-TYPE     
                                                                        
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT              
                                                                        
           IF  WS-JRNL-DB2-RETURN = NOT-FOUND                           
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           ELSE                                                         
               IF  CS-CODE-CSH-DRWR-STAT = WS-A                         
                   MOVE WS-A                TO WS-100-JRNL-SORT-ID      
                   MOVE ZEROES              TO WS-100-ACCT-NO           
                   MOVE ZEROES              TO WS-100-CUSTOMER-NO       
                   MOVE ZEROES              TO WS-100-PREMISE-NO        
                   ADD 1                    TO WS-100-JRNL-TRAN-APPL-NO 
                   MOVE WS-CURRENT-DATE     TO WS-100-DATE-LAST-ACTION  
                   MOVE WS-C                TO WS-100-CODE-ENTRY-SOURCE 
T19930             MOVE Y2-LOCAL-OFFICE     TO WS-100-LOCAL-OFFICE-CD   
                   MOVE WS-JRNL-OL-COMPANY  TO WS-PAR-COMPANY-NO        
                   MOVE WS-JRNL-OL-LOC-OFF  TO WS-PAR-LOCAL-OFFICE      
                   MOVE WS-JRNL-OL-REPORT-NO                            
                                            TO WS-PAR-REPORT-NO         
                   MOVE WS-JRNL-OL-REPORT-DT                            
                                            TO WS-PAR-REPORT-DATE       
                   MOVE WS-JRNL-OL-CASH-DRWR                            
                                            TO WS-PAR-CASH-DRAWER       
                   MOVE WS-TERM-LOC         TO WS-PAR-ACCESS-LOC        
                   MOVE PARM-USER-ID        TO WS-PAR-OPERATOR-ID       
                   MOVE PF-RESP-AREA-ID     TO WS-PAR-RESP-AREA         
                   MOVE WS-TRAN-COMMENT-LEN TO WS-JRNL-TRAN-COMMENT-LEN 
                   MOVE WS-TRAN-COMMENT-TEXT                            
                                            TO WS-JRNL-TRAN-COMMENT-TEXT
                   INITIALIZE CJF00101                                  
                   MOVE PARM-CURRENCY-TYPE  TO WS-JRNL-CURRENCY-TYPE    
                   MOVE PARM-AMT-ENTERED    TO WS-101-AMT-POSTED        
                                               WS-PAYMENT-AMOUNT        
                   PERFORM 2210-MOVE-TRAN-DATA-VALUES                   
                                            THRU 2210-EXIT              
                   MOVE WS-CLR-CASH         TO GO-GL-ACCT-NAME          
                   PERFORM 7200-GL-ACCT-NO  THRU 7200-EXIT              
                                                                        
                   IF WS-UPDATE-TYPE = WS-O                             
                       MOVE 'O412'          TO WS-100-CODE-TERMINAL-TRAN
                       MOVE GO-GL-ACCT-NO   TO WS-101-ACCT-GEN-LED-DR   
                       MOVE WS-GL-ACCT-NUM  TO WS-101-ACCT-GEN-LED-CR   
                   ELSE                                                 
PRDFIX*                MOVE 'CSR02412'      TO WS-100-CODE-TERMINAL-TRAN        
PRDFIX                 MOVE 'S412'          TO WS-100-CODE-TERMINAL-TRAN
                       MOVE GO-GL-ACCT-NO   TO WS-101-ACCT-GEN-LED-CR   
                       MOVE WS-GL-ACCT-NUM  TO WS-101-ACCT-GEN-LED-DR   
                   END-IF                                               
                                                                        
C25923             IF PARM-OVSH-TYPE-CD = WS-05                         
C25923                MOVE 'F412'           TO WS-100-CODE-TERMINAL-TRAN
C25923             END-IF                                               
                                                                        
                   MOVE CJF00101            TO WS-100-USER-DEFINED-AREA 
                   MOVE WS-JRNL-ONLY        TO WS-JRNL-OPERATION-RQST   
                                                                        
                   PERFORM 6400-ONLINE-JRNL-ROUTINE                     
                                            THRU 6400-EXIT              
                   MOVE WS-JRNL-CNTRL-ONLY  TO WS-JRNL-OPERATION-RQST   
                   PERFORM 6400-ONLINE-JRNL-ROUTINE                     
                                            THRU 6400-EXIT              
C25923             PERFORM 2300-WRITE-OVSH  THRU 2300-EXIT              
               ELSE                                                     
                   MOVE 1000                TO RS-RETURN-CODE           
               END-IF                                                   
REARCH         PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT             
REARCH         ADD +1                       TO CTR-ROWS                 
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
      * 2300-WRITE-OVSH                                                *        
      *                                                                *        
      *   WRITE OVERAGE/SHORTAGE IN OVERAGE SHORTAGE TABLE             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2300-WRITE-OVSH.                                                 
           MOVE PARM-CASH-COMPANY-NO        TO OH-CASH-COMPANY-NO       
                                               OD-CASH-COMPANY-NO       
           MOVE PARM-CASH-LOCAL-OFFICE      TO OH-CASH-LOCAL-OFFICE     
                                               OD-CASH-LOCAL-OFFICE     
           MOVE PARM-DATE-CASH-REPORT       TO OH-DATE-CASH-REPORT      
                                               OD-DATE-CASH-REPORT      
           MOVE PARM-CASH-DRAWER-ID         TO OH-CASH-DRAWER-ID        
                                               OD-CASH-DRAWER-ID        
           MOVE PARM-USER-ID                TO OH-USER-ID               
           MOVE PARM-TRAN-COMMENT-LEN       TO OH-TRAN-COMMENT-LEN      
           MOVE PARM-TRAN-COMMENT-TEXT      TO OH-TRAN-COMMENT-TEXT     
           MOVE WS-GL-ACCT-NUM              TO OH-GL-ACCT-NO            
           MOVE PARM-OVSH-SOLTN-FL          TO OH-OVERSHORT-SOLTN-FL    
           MOVE PARM-OVSH-TYPE-CD           TO OH-OVERSHORT-TYPE-CD     
P00586     IF PARM-OVSH-SOLTN-FL = WS-P OR WS-R                         
              PERFORM 7400-GET-OVSH-ID      THRU 7400-EXIT              
              ADD  1                        TO OH-OVERSHORT-ID          
              MOVE PARM-AMT-ENTERED         TO OH-OVERSHORT-AMT         
              MOVE ZERO                     TO OH-OFST-OVERSHORT-AMT    
              MOVE ZERO                     TO OH-ACCOUNT-NO            
              MOVE SPACES                   TO OH-OFST-DR-CR            
              IF PARM-UPDATE-TYPE = WS-O                                
                 MOVE WS-C                  TO OH-OVERSHORT-DR-CR       
              ELSE                                                      
                 MOVE WS-D                  TO OH-OVERSHORT-DR-CR       
              END-IF                                                    
P00586        IF PARM-OVSH-SOLTN-FL = WS-R                              
P00586           MOVE OH-OVERSHORT-AMT      TO OH-OFST-OVERSHORT-AMT    
P00586           IF PARM-UPDATE-TYPE = WS-O                             
P00586              MOVE 'D'                TO OH-OFST-DR-CR            
P00586           ELSE                                                   
P00586              MOVE 'C'                TO OH-OFST-DR-CR            
P00586           END-IF                                                 
P00586        END-IF                                                    
              PERFORM 8150-INSERT-OVSH-HDR  THRU 8150-EXIT              
           ELSE                                                         
              INITIALIZE WS-OVSH-ARRAY                                  
              PERFORM 2400-PROCESS-ARRAY    THRU 2400-EXIT              
              PERFORM VARYING WS-SUB FROM 1 BY 1                        
                UNTIL  WS-SUB >  WS-OVSH-COUNT                          
                PERFORM 7400-GET-OVSH-ID    THRU 7400-EXIT              
                ADD  1                      TO OH-OVERSHORT-ID          
                MOVE WS-OFST-COMPANY(WS-SUB) TO OD-OFST-COMPANY-NO      
                MOVE WS-OFST-LOC-OFCE(WS-SUB) TO OD-OFST-LOC-OFCE       
                MOVE WS-OFST-REPT-DATE(WS-SUB) TO OD-OFST-CASH-REPT-DT  
                MOVE WS-OFST-DRWR-ID(WS-SUB) TO WS-DRAWER-ID            
                MOVE WS-DRAWER-ID            TO OD-OFST-CASH-DRWR-ID    
                MOVE WS-OFST-OVSH-ID(WS-SUB) TO WS-OVERSHORT-ID         
                MOVE WS-OVERSHORT-ID         TO OD-OFST-OVERSHORT-ID    
                MOVE WS-OVSH-ACCOUNT-NO(WS-SUB) TO WS-ACCOUNT-NO        
                MOVE WS-ACCOUNT-NO-NUM       TO WS-ACCOUNT-NO-COMP3     
                MOVE WS-ACCOUNT-NO-COMP3     TO OH-ACCOUNT-NO           
                MOVE WS-OFST-OVSH-AMT(WS-SUB) TO WS-OVERSHORT-AMT       
                MOVE WS-OVERSHORT-AMT         TO OH-OFST-OVERSHORT-AMT  
                                                 OD-OFST-OVERSHORT-AMT  
                                                 OH-OVERSHORT-AMT       
                MOVE WS-OFST-DR-CR(WS-SUB)   TO  WS-CR-DR-SW            
                IF CREDIT-TRUE                                          
                   MOVE WS-C                 TO  OH-OVERSHORT-DR-CR     
                                                 OD-OFST-DR-CR          
                   MOVE WS-D                 TO  OH-OFST-DR-CR          
                ELSE                                                    
                   MOVE WS-D                 TO  OH-OVERSHORT-DR-CR     
                                                 OD-OFST-DR-CR          
                   MOVE WS-C                 TO  OH-OFST-DR-CR          
                END-IF                                                  
                                                                        
                PERFORM 8150-INSERT-OVSH-HDR THRU 8150-EXIT             
                MOVE OH-OVERSHORT-ID         TO OD-OVERSHORT-ID         
                PERFORM 7500-GET-OVSH-SEQ-NO THRU 7500-EXIT             
                ADD 1                        TO OD-OVERSHORT-SEQ-NO     
                IF PARM-OVSH-TYPE-CD = WS-05                            
                   PERFORM 2500-FRO-OVSH-HDR THRU 2500-EXIT             
                   MOVE OH-OVERSHORT-ID      TO OD-OFST-OVERSHORT-ID    
                   PERFORM 8200-INSERT-OVSH-DET THRU 8200-EXIT          
                ELSE                                                    
                   PERFORM 8200-INSERT-OVSH-DET THRU 8200-EXIT          
                   PERFORM 8300-SELECT-OVSH-HDR THRU 8300-EXIT          
                   IF OH-OFST-DR-CR = OD-OFST-DR-CR                     
                      ADD WS-OVERSHORT-AMT TO OH-OFST-OVERSHORT-AMT     
                   ELSE                                                 
                      IF WS-OVERSHORT-AMT > OH-OFST-OVERSHORT-AMT       
                         MOVE OD-OFST-DR-CR      TO OH-OFST-DR-CR       
                         COMPUTE OH-OFST-OVERSHORT-AMT =                
                           WS-OVERSHORT-AMT - OH-OFST-OVERSHORT-AMT     
                      ELSE                                              
                         COMPUTE OH-OFST-OVERSHORT-AMT =                
                        OH-OFST-OVERSHORT-AMT - WS-OVERSHORT-AMT        
                      END-IF                                            
                   END-IF                                               
                   PERFORM 8400-UPDATE-OVSH-HDR THRU 8400-EXIT          
                END-IF                                                  
              END-PERFORM                                               
           END-IF                                                       
           .                                                            
       2300-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2210-MOVE-TRAN-DATE-VALUES.                                    *        
      *                                                                *        
      *   MOVE THE VALUES TO TH COPYBOOK VARIABLES.                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2210-MOVE-TRAN-DATA-VALUES.                                      
                                                                        
           MOVE 101                         TO WS-101-JRNL-FORMAT-NO    
           MOVE WS-PAYMENT-AMOUNT           TO WS-101-AMOUNT-ENTERED    
           MOVE SPACES                      TO                          
                                            WS-101-AR-AGE               
                                            WS-101-CASH-DRAWER-USED     
                                            WS-101-DATE-AR-BILLED       
                                            WS-101-FCS-DEP-BANK-CD      
                                            WS-101-FCS-DEP-BANK-ST-CD   
                                            WS-101-FUNCTION-CODE        
                                            WS-101-CODE-REVENUE-DISTRICT
                                            WS-101-CODE-EMPL-ACCT       
                                            WS-101-CODE-COMPANY-ACCT    
                                            WS-101-CODE-ACCOUNT-STATUS  
                                            WS-101-CODE-PREMISE-STATUS  
           MOVE ZERO                        TO                          
                                            WS-101-ITEM-DETAIL-DATA     
                                            WS-101-ITEM-ID-NO           
                                            WS-101-DETAIL-END-BAL       
                                            WS-101-DETAIL-END-AR-BAL    
                                            WS-101-ACCT-END-AR-BAL      
                                            WS-101-REVENUE-MONTH        
           .                                                            
       2210-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-PROCESS-ARRAY.                                            *        
      *                                                                *        
      *   ASSIGN THE ARRAY VALUES                                      *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2400-PROCESS-ARRAY.                                              
           IF PARM-OVSH-ARRAY-1 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-1        TO WS-OVSH-ARRAY-DETAIL(1)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-2 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-2        TO WS-OVSH-ARRAY-DETAIL(2)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-3 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-3        TO WS-OVSH-ARRAY-DETAIL(3)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-4 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-4        TO WS-OVSH-ARRAY-DETAIL(4)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-5 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-5        TO WS-OVSH-ARRAY-DETAIL(5)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-6 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-6        TO WS-OVSH-ARRAY-DETAIL(6)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-7 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-7        TO WS-OVSH-ARRAY-DETAIL(7)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-8 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-8        TO WS-OVSH-ARRAY-DETAIL(8)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-9 EQUAL SPACES                            
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-9        TO WS-OVSH-ARRAY-DETAIL(9)  
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-10 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-10       TO WS-OVSH-ARRAY-DETAIL(10) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-11 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-11       TO WS-OVSH-ARRAY-DETAIL(11) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-12 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-12       TO WS-OVSH-ARRAY-DETAIL(12) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-13 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-13       TO WS-OVSH-ARRAY-DETAIL(13) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-14 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-14       TO WS-OVSH-ARRAY-DETAIL(14) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-15 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-15       TO WS-OVSH-ARRAY-DETAIL(15) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-16 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-16       TO WS-OVSH-ARRAY-DETAIL(16) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-17 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-17       TO WS-OVSH-ARRAY-DETAIL(17) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-18 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-18       TO WS-OVSH-ARRAY-DETAIL(18) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-19 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-19       TO WS-OVSH-ARRAY-DETAIL(19) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-20 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-20       TO WS-OVSH-ARRAY-DETAIL(20) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-21 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-21       TO WS-OVSH-ARRAY-DETAIL(21) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-22 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-22       TO WS-OVSH-ARRAY-DETAIL(22) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-23 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-23       TO WS-OVSH-ARRAY-DETAIL(23) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-24 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-24       TO WS-OVSH-ARRAY-DETAIL(24) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           IF PARM-OVSH-ARRAY-25 EQUAL SPACES                           
              CONTINUE                                                  
           ELSE                                                         
              MOVE PARM-OVSH-ARRAY-25       TO WS-OVSH-ARRAY-DETAIL(25) 
              ADD  1                        TO WS-OVSH-COUNT            
           END-IF                                                       
                                                                        
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2500-FRO-OVSH-HDR.                                               
           MOVE OD-OFST-COMPANY-NO          TO OH-CASH-COMPANY-NO       
           MOVE OD-OFST-LOC-OFCE            TO OH-CASH-LOCAL-OFFICE     
           MOVE OD-OFST-CASH-REPT-DT        TO OH-DATE-CASH-REPORT      
           MOVE OD-OFST-CASH-DRWR-ID        TO OH-CASH-DRAWER-ID        
           MOVE PARM-USER-ID                TO OH-USER-ID               
           MOVE PARM-TRAN-COMMENT-LEN       TO OH-TRAN-COMMENT-LEN      
           MOVE PARM-TRAN-COMMENT-TEXT      TO OH-TRAN-COMMENT-TEXT     
           MOVE WS-GL-ACCT-NUM              TO OH-GL-ACCT-NO            
           MOVE WS-P                        TO OH-OVERSHORT-SOLTN-FL    
           MOVE PARM-OVSH-TYPE-CD           TO OH-OVERSHORT-TYPE-CD     
           PERFORM 7400-GET-OVSH-ID         THRU 7400-EXIT              
           ADD  1                           TO OH-OVERSHORT-ID          
           MOVE PARM-AMT-ENTERED            TO OH-OVERSHORT-AMT         
           MOVE ZERO                        TO OH-OFST-OVERSHORT-AMT    
           MOVE ZERO                        TO OH-ACCOUNT-NO            
           MOVE SPACES                      TO OH-OFST-DR-CR            
                                            OH-OVERSHORT-DR-CR          
           PERFORM 8150-INSERT-OVSH-HDR  THRU 8150-EXIT                 
                                                                        
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-CURRENT-DATE.                                         *        
      *                                                                *        
      *   GET THE CURRENT DATE                                         *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-GET-CURRENT-DATE.                                           
                                                                        
           EXEC SQL                                                     
T35434        SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                       
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-CURRENT-DATE = CURRENT DATE                               
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '7100'                  TO ACTIVE-PARAGRAPH         
               MOVE SPACES                  TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
T35434         MOVE 'SET'                   TO ABEND-FUNCTION           
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-GL-ACCT-NO                                                *        
      *                                                                *        
      *   GET THE CLEAR CASH GL ACCOUNT NO                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-GL-ACCT-NO.                                                 
                                                                        
           MOVE CS-CASH-COMPANY-NO          TO GO-COMPANY-NO            
                                                                        
           EXEC SQL                                                     
               SELECT GL_ACCT_NO                                        
                 INTO :GO-GL-ACCT-NO                                    
                 FROM CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                      
MCR310          WHERE COMPANY_NO   = '01'                               
                  AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                   
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT GL_ACCT_NO                                                
MFA-TR*          INTO :GO-GL-ACCT-NO                                            
MFA-TR*          FROM CSS_GL_ACCT_NO                                            
MFA-TR*         WHERE COMPANY_NO   = '01'                                       
MFA-TR*           AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                           
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE '7200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_GL_ACCT_NO'        TO TABLE-1                  
               MOVE 'COMPANY_NO'            TO TABLE-ELEMENT-1          
               MOVE 'GL ACCT NAME'          TO TABLE-ELEMENT-2          
               MOVE '01'                    TO HOSTVAR-ELEMENT-1        
               MOVE GO-GL-ACCT-NAME         TO HOSTVAR-ELEMENT-2        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-GET-OVSH-ID                                               *        
      *                                                                *        
      *   GET OVERAGE SHORTAGE ID                                      *        
      *                                                                *        
      ******************************************************************        
C25923                                                                  
C25923 7400-GET-OVSH-ID.                                                
                                                                        
           EXEC SQL                                                     
             SELECT MAX(OVERSHORT_ID)                                   
               INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1               
               FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID              
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(OVERSHORT_ID)                                           
MFA-TR*        INTO :OH-OVERSHORT-ID :WS-NULL-INDICATOR-1                       
MFA-TR*        FROM CSS_OVERSHORT_HDR                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
               IF WS-NULL-INDICATOR-1 EQUAL -1                          
                  MOVE ZERO                 TO OH-OVERSHORT-ID          
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '7400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_OVERSHORT_HDR'     TO TABLE-1                  
               MOVE 'CASH_COMPANY_NO'       TO TABLE-ELEMENT-1          
               MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-2          
               MOVE 'DATE_CASH-REPORT'      TO TABLE-ELEMENT-3          
               MOVE 'CASH_DRAWER_ID'        TO TABLE-ELEMENT-4          
               MOVE OH-CASH-COMPANY-NO      TO HOSTVAR-ELEMENT-1        
               MOVE OH-CASH-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-2        
               MOVE OH-DATE-CASH-REPORT     TO HOSTVAR-ELEMENT-3        
               MOVE OH-CASH-DRAWER-ID       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-GET-OVSH-SEQ-NO                                           *        
      *                                                                *        
      *   GET OVERAGE SHORTAGE SEQUENCE NO                             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7500-GET-OVSH-SEQ-NO.                                            
                                                                        
           EXEC SQL                                                     
             SELECT MAX(OVERSHORT_SEQ_NO)                               
               INTO :OD-OVERSHORT-SEQ-NO :WS-NULL-INDICATOR-2           
               FROM CSS_OVERSHORT_DET WITH(READUNCOMMITTED)                     
              WHERE CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE           
                AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )            
                AND CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID              
                AND OVERSHORT_ID      = :OD-OVERSHORT-ID                
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(OVERSHORT_SEQ_NO)                                       
MFA-TR*        INTO :OD-OVERSHORT-SEQ-NO :WS-NULL-INDICATOR-2                   
MFA-TR*        FROM CSS_OVERSHORT_DET                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :OD-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :OD-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :OD-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :OD-CASH-DRAWER-ID                      
MFA-TR*         AND OVERSHORT_ID      = :OD-OVERSHORT-ID                        
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL  OR NOT-FOUND     
               IF WS-NULL-INDICATOR-2 EQUAL -1                          
                  MOVE ZERO                 TO OD-OVERSHORT-SEQ-NO      
               END-IF                                                   
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '7500'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_OVERSHORT_DET'     TO TABLE-1                  
               MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-1          
               MOVE 'DATE_CASH-REPORT'      TO TABLE-ELEMENT-2          
               MOVE 'OVERSHORT_ID'          TO TABLE-ELEMENT-3          
               MOVE 'CASH_DRAWER_ID'        TO TABLE-ELEMENT-4          
               MOVE OD-CASH-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-1        
               MOVE OD-DATE-CASH-REPORT     TO HOSTVAR-ELEMENT-2        
               MOVE OD-OVERSHORT-ID         TO HOSTVAR-ELEMENT-3        
               MOVE OD-CASH-DRAWER-ID       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8150-INSERT-OVSH-HDR                                           *        
      *                                                                *        
      *   INSERT INTO OVERAGE SHORTAGE HEADER TABLE                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       8150-INSERT-OVSH-HDR.                                            
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_HDR                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,USER_ID                                         
                       ,OVERSHORT_ID                                    
                       ,TRAN_TS                                         
                       ,OVERSHORT_AMT                                   
                       ,OVERSHORT_DR_CR                                 
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,GL_ACCT_NO                                      
                       ,LAST_UPDATE_TS                                  
                       ,OVERSHORT_TYPE_CD                               
                       ,OVERSHORT_SOLTN_FL                              
                       ,TRAN_COMMENT                                    
                       ,ACCOUNT_NO                                      
                       )                                                
                VALUES                                                  
                       (                                                
                        :OH-CASH-COMPANY-NO                             
                       ,:OH-CASH-LOCAL-OFFICE                           
                       ,IIF(TRY_CONVERT(DATE, :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )                         
                       ,:OH-CASH-DRAWER-ID                              
                       ,:OH-USER-ID                                     
                       ,:OH-OVERSHORT-ID                                
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-AMT                               
                       ,:OH-OVERSHORT-DR-CR                             
                       ,:OH-OFST-OVERSHORT-AMT                          
                       ,:OH-OFST-DR-CR                                  
                       ,:OH-GL-ACCT-NO                                  
                       ,CIS.CURRENT$TIMESTAMP()                               
                       ,:OH-OVERSHORT-TYPE-CD                           
                       ,:OH-OVERSHORT-SOLTN-FL                          
                       ,:OH-TRAN-COMMENT                                
                       ,:OH-ACCOUNT-NO                                  
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OVERSHORT_HDR                                   
MFA-TR*                (                                                        
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,USER_ID                                                 
MFA-TR*                ,OVERSHORT_ID                                            
MFA-TR*                ,TRAN_TS                                                 
MFA-TR*                ,OVERSHORT_AMT                                           
MFA-TR*                ,OVERSHORT_DR_CR                                         
MFA-TR*                ,OFST_OVERSHORT_AMT                                      
MFA-TR*                ,OFST_DR_CR                                              
MFA-TR*                ,GL_ACCT_NO                                              
MFA-TR*                ,LAST_UPDATE_TS                                          
MFA-TR*                ,OVERSHORT_TYPE_CD                                       
MFA-TR*                ,OVERSHORT_SOLTN_FL                                      
MFA-TR*                ,TRAN_COMMENT                                            
MFA-TR*                ,ACCOUNT_NO                                              
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :OH-CASH-COMPANY-NO                                     
MFA-TR*                ,:OH-CASH-LOCAL-OFFICE                                   
MFA-TR*                ,:OH-DATE-CASH-REPORT                                    
MFA-TR*                ,:OH-CASH-DRAWER-ID                                      
MFA-TR*                ,:OH-USER-ID                                             
MFA-TR*                ,:OH-OVERSHORT-ID                                        
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-AMT                                       
MFA-TR*                ,:OH-OVERSHORT-DR-CR                                     
MFA-TR*                ,:OH-OFST-OVERSHORT-AMT                                  
MFA-TR*                ,:OH-OFST-DR-CR                                          
MFA-TR*                ,:OH-GL-ACCT-NO                                          
MFA-TR*                ,CURRENT TIMESTAMP                                       
MFA-TR*                ,:OH-OVERSHORT-TYPE-CD                                   
MFA-TR*                ,:OH-OVERSHORT-SOLTN-FL                                  
MFA-TR*                ,:OH-TRAN-COMMENT                                        
MFA-TR*                ,:OH-ACCOUNT-NO                                          
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '8150'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_OVERSHORT_HDR'     TO TABLE-1                  
               MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-1          
               MOVE 'DATE_CASH-REPORT'      TO TABLE-ELEMENT-2          
               MOVE 'USER_ID'               TO TABLE-ELEMENT-3          
               MOVE 'CASH_DRAWER_ID'        TO TABLE-ELEMENT-4          
               MOVE OH-CASH-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-1        
               MOVE OH-DATE-CASH-REPORT     TO HOSTVAR-ELEMENT-2        
               MOVE OH-USER-ID              TO HOSTVAR-ELEMENT-3        
               MOVE OH-CASH-DRAWER-ID       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
       8150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8200-INSERT-OVSH-DET                                           *        
      *                                                                *        
      *   INSERT INTO OVERAGE SHORTAGE DETAIL TABLE                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       8200-INSERT-OVSH-DET.                                            
                                                                        
           EXEC SQL                                                     
                INSERT INTO CSS_OVERSHORT_DET                           
                       (                                                
                        CASH_COMPANY_NO                                 
                       ,CASH_LOCAL_OFFICE                               
                       ,DATE_CASH_REPORT                                
                       ,CASH_DRAWER_ID                                  
                       ,OVERSHORT_ID                                    
                       ,OVERSHORT_SEQ_NO                                
                       ,OFST_OVERSHORT_AMT                              
                       ,OFST_DR_CR                                      
                       ,OFST_COMPANY_NO                                 
                       ,OFST_LOC_OFCE                                   
                       ,OFST_CASH_REPT_DT                               
                       ,OFST_CASH_DRWR_ID                               
                       ,OFST_OVERSHORT_ID                               
                       )                                                
                VALUES                                                  
                       (                                                
                        :OD-CASH-COMPANY-NO                             
                       ,:OD-CASH-LOCAL-OFFICE                           
                       ,IIF(TRY_CONVERT(DATE, :OD-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OD-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OD-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OD-DATE-CASH-REPORT
              ), CONVERT(DATE, :OD-DATE-CASH-REPORT) )                         
                       ,:OD-CASH-DRAWER-ID                              
                       ,:OD-OVERSHORT-ID                                
                       ,:OD-OVERSHORT-SEQ-NO                            
                       ,:OD-OFST-OVERSHORT-AMT                          
                       ,:OD-OFST-DR-CR                                  
                       ,:OD-OFST-COMPANY-NO                             
                       ,:OD-OFST-LOC-OFCE                               
                       ,IIF(TRY_CONVERT(DATE, :OD-OFST-CASH-REPT-DT
              ) IS NULL OR (PATINDEX('%.%', :OD-OFST-CASH-REPT-DT
              ) <> 0) OR (LEN(:OD-OFST-CASH-REPT-DT
              ) <> 10), CIS.CHAR2DATE(:OD-OFST-CASH-REPT-DT
              ), CONVERT(DATE, :OD-OFST-CASH-REPT-DT) )                        
                       ,:OD-OFST-CASH-DRWR-ID                           
                       ,:OD-OFST-OVERSHORT-ID                           
                       )                                                
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_OVERSHORT_DET                                   
MFA-TR*                (                                                        
MFA-TR*                 CASH_COMPANY_NO                                         
MFA-TR*                ,CASH_LOCAL_OFFICE                                       
MFA-TR*                ,DATE_CASH_REPORT                                        
MFA-TR*                ,CASH_DRAWER_ID                                          
MFA-TR*                ,OVERSHORT_ID                                            
MFA-TR*                ,OVERSHORT_SEQ_NO                                        
MFA-TR*                ,OFST_OVERSHORT_AMT                                      
MFA-TR*                ,OFST_DR_CR                                              
MFA-TR*                ,OFST_COMPANY_NO                                         
MFA-TR*                ,OFST_LOC_OFCE                                           
MFA-TR*                ,OFST_CASH_REPT_DT                                       
MFA-TR*                ,OFST_CASH_DRWR_ID                                       
MFA-TR*                ,OFST_OVERSHORT_ID                                       
MFA-TR*                )                                                        
MFA-TR*         VALUES                                                          
MFA-TR*                (                                                        
MFA-TR*                 :OD-CASH-COMPANY-NO                                     
MFA-TR*                ,:OD-CASH-LOCAL-OFFICE                                   
MFA-TR*                ,:OD-DATE-CASH-REPORT                                    
MFA-TR*                ,:OD-CASH-DRAWER-ID                                      
MFA-TR*                ,:OD-OVERSHORT-ID                                        
MFA-TR*                ,:OD-OVERSHORT-SEQ-NO                                    
MFA-TR*                ,:OD-OFST-OVERSHORT-AMT                                  
MFA-TR*                ,:OD-OFST-DR-CR                                          
MFA-TR*                ,:OD-OFST-COMPANY-NO                                     
MFA-TR*                ,:OD-OFST-LOC-OFCE                                       
MFA-TR*                ,:OD-OFST-CASH-REPT-DT                                   
MFA-TR*                ,:OD-OFST-CASH-DRWR-ID                                   
MFA-TR*                ,:OD-OFST-OVERSHORT-ID                                   
MFA-TR*                )                                                        
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '8200'                  TO ACTIVE-PARAGRAPH         
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_OVERSHORT_DET'     TO TABLE-1                  
               MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-1          
               MOVE 'DATE_CASH-REPORT'      TO TABLE-ELEMENT-2          
               MOVE 'OVERSHORT_ID'          TO TABLE-ELEMENT-3          
               MOVE 'CASH_DRAWER_ID'        TO TABLE-ELEMENT-4          
               MOVE OD-CASH-LOCAL-OFFICE    TO HOSTVAR-ELEMENT-1        
               MOVE OD-DATE-CASH-REPORT     TO HOSTVAR-ELEMENT-2        
               MOVE OD-OVERSHORT-ID         TO HOSTVAR-ELEMENT-3        
               MOVE OD-CASH-DRAWER-ID       TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
       8200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8300-SELECT-OVSH-HDR                                           *        
      *                                                                *        
      *   SELECT OFFSET AMT FROM CSS_OVERSHORT_HDR                     *        
      *                                                                *        
      ******************************************************************        
                                                                        
       8300-SELECT-OVSH-HDR.                                            
                                                                        
           EXEC SQL                                                     
              SELECT OFST_OVERSHORT_AMT                                 
                     ,OFST_DR_CR                                        
                INTO :OH-OFST-OVERSHORT-AMT                             
                     ,:OH-OFST-DR-CR                                    
                FROM CSS_OVERSHORT_HDR WITH(READUNCOMMITTED)                    
               WHERE CASH_COMPANY_NO    = :OD-OFST-COMPANY-NO           
                 AND CASH_LOCAL_OFFICE  = :OD-OFST-LOC-OFCE             
                 AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                  :OD-OFST-CASH-REPT-DT
              ) IS NULL OR (PATINDEX('%.%', :OD-OFST-CASH-REPT-DT
              ) <> 0) OR (LEN(:OD-OFST-CASH-REPT-DT
              ) <> 10), CIS.CHAR2DATE(:OD-OFST-CASH-REPT-DT
              ), CONVERT(DATE, :OD-OFST-CASH-REPT-DT) )         
                 AND CASH_DRAWER_ID     = :OD-OFST-CASH-DRWR-ID         
                 AND OVERSHORT_ID       = :OD-OFST-OVERSHORT-ID         
T35434                                                           
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT OFST_OVERSHORT_AMT                                         
MFA-TR*              ,OFST_DR_CR                                                
MFA-TR*         INTO :OH-OFST-OVERSHORT-AMT                                     
MFA-TR*              ,:OH-OFST-DR-CR                                            
MFA-TR*         FROM CSS_OVERSHORT_HDR                                          
MFA-TR*        WHERE CASH_COMPANY_NO    = :OD-OFST-COMPANY-NO                   
MFA-TR*          AND CASH_LOCAL_OFFICE  = :OD-OFST-LOC-OFCE                     
MFA-TR*          AND DATE_CASH_REPORT   = :OD-OFST-CASH-REPT-DT                 
MFA-TR*          AND CASH_DRAWER_ID     = :OD-OFST-CASH-DRWR-ID                 
MFA-TR*          AND OVERSHORT_ID       = :OD-OFST-OVERSHORT-ID                 
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '8300'                  TO ACTIVE-PARAGRAPH         
               MOVE 'SELECT'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_OVERSHORT_HDR'     TO TABLE-1                  
               MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-1          
               MOVE 'DATE_CASH-REPORT'      TO TABLE-ELEMENT-2          
               MOVE 'OVERSHORT_ID'          TO TABLE-ELEMENT-3          
               MOVE 'CASH_DRAWER_ID'        TO TABLE-ELEMENT-4          
               MOVE OD-OFST-LOC-OFCE        TO HOSTVAR-ELEMENT-1        
               MOVE OD-OFST-CASH-REPT-DT    TO HOSTVAR-ELEMENT-2        
               MOVE OD-OFST-OVERSHORT-ID    TO HOSTVAR-ELEMENT-3        
               MOVE OD-OFST-CASH-DRWR-ID    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
       8300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8400-UPDATE-OVSH-HDR                                           *        
      *                                                                *        
      *   UPDATE OFFSET AMT OF CSS_OVERSHORT_HDR                       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       8400-UPDATE-OVSH-HDR.                                            
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_OVERSHORT_HDR                                  
                 SET OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT        
                     ,OFST_DR_CR        = :OH-OFST-DR-CR                
                     ,LAST_UPDATE_TS    = CIS.CURRENT$TIMESTAMP()             
               WHERE CASH_COMPANY_NO    = :OD-OFST-COMPANY-NO           
                 AND CASH_LOCAL_OFFICE  = :OD-OFST-LOC-OFCE             
                 AND DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                  :OD-OFST-CASH-REPT-DT
              ) IS NULL OR (PATINDEX('%.%', :OD-OFST-CASH-REPT-DT
              ) <> 0) OR (LEN(:OD-OFST-CASH-REPT-DT
              ) <> 10), CIS.CHAR2DATE(:OD-OFST-CASH-REPT-DT
              ), CONVERT(DATE, :OD-OFST-CASH-REPT-DT) )         
                 AND CASH_DRAWER_ID     = :OD-OFST-CASH-DRWR-ID         
                 AND OVERSHORT_ID       = :OD-OFST-OVERSHORT-ID         
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_OVERSHORT_HDR                                          
MFA-TR*          SET OFST_OVERSHORT_AMT = :OH-OFST-OVERSHORT-AMT                
MFA-TR*              ,OFST_DR_CR        = :OH-OFST-DR-CR                        
MFA-TR*              ,LAST_UPDATE_TS    = CURRENT TIMESTAMP                     
MFA-TR*        WHERE CASH_COMPANY_NO    = :OD-OFST-COMPANY-NO                   
MFA-TR*          AND CASH_LOCAL_OFFICE  = :OD-OFST-LOC-OFCE                     
MFA-TR*          AND DATE_CASH_REPORT   = :OD-OFST-CASH-REPT-DT                 
MFA-TR*          AND CASH_DRAWER_ID     = :OD-OFST-CASH-DRWR-ID                 
MFA-TR*          AND OVERSHORT_ID       = :OD-OFST-OVERSHORT-ID                 
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE    
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE           
               MOVE '8400'                  TO ACTIVE-PARAGRAPH         
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_OVERSHORT_HDR'     TO TABLE-1                  
               MOVE 'CASH_LOCAL_OFFICE'     TO TABLE-ELEMENT-1          
               MOVE 'DATE_CASH-REPORT'      TO TABLE-ELEMENT-2          
               MOVE 'OVERSHORT_ID'          TO TABLE-ELEMENT-3          
               MOVE 'CASH_DRAWER_ID'        TO TABLE-ELEMENT-4          
               MOVE OD-OFST-LOC-OFCE        TO HOSTVAR-ELEMENT-1        
               MOVE OD-OFST-CASH-REPT-DT    TO HOSTVAR-ELEMENT-2        
               MOVE OD-OFST-OVERSHORT-ID    TO HOSTVAR-ELEMENT-3        
               MOVE OD-OFST-CASH-DRWR-ID    TO HOSTVAR-ELEMENT-4        
               PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT              
           END-IF                                                       
           .                                                            
C25923 8400-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
T19930                                                                  
T19930******************************************************************        
T19930* 7300-GET-GL-LOC-OFF                                            *        
T19930*                                                                *        
T19930*    TO GET THE GL LOCAL OFFICE                                  *        
T19930*                                                                *        
T19930******************************************************************        
T19930                                                                  
T19930 7300-GET-GL-LOC-OFF.                                             
T19930                                                                  
T19930     EXEC SQL                                                     
T19930          SELECT LOCAL_OFFICE                                     
T19930            INTO :Y2-LOCAL-OFFICE                                 
T19930            FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                 
T19930           WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO          
T19930             AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE        
T35434                                                           
T19930     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT LOCAL_OFFICE                                             
MFA-TR*           INTO :Y2-LOCAL-OFFICE                                         
MFA-TR*           FROM CSS_CASHIER_OFFICE                                       
MFA-TR*          WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO                  
MFA-TR*            AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19930                                                                  
T19930     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
T19930                                                                  
T19930     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
T19930         NEXT SENTENCE                                            
T19930     ELSE                                                         
T19930         MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
T19930         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
T19930         MOVE '7300'                     TO ACTIVE-PARAGRAPH      
T19930         MOVE 'SELECT'                   TO ABEND-FUNCTION        
T19930         MOVE SPACES                     TO ABEND-SQL-PREDICATES  
T19930                                            ABEND-TABLES          
T19930         MOVE 'CSS_CASHIER_OFFICE'       TO TABLE-1               
T19930         MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
T19930         MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
T19930         MOVE Y2-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
T19930         MOVE Y2-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
T19930         PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
T19930     END-IF.                                                      
T19930                                                                  
T19930 7300-EXIT.                                                       
T19930     EXIT.                                                        
                                                                        
           EXEC SQL                                                     25690000
A00956          INCLUDE CPD0006A                                        25700000
           END-EXEC.                                                    25710000
T19920                                                                  
T19920******************************************************************        
T19920* 7999-SELECT-AL                                                 *        
T19920******************************************************************        
T19920     EXEC SQL                                                             
T19920          INCLUDE CPD00075                                                
T19920     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9700 -  ABEND HANDLING ROUTINE                                 *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
                INCLUDE CPD0023C                                                
           END-EXEC.                                                            
                                                                        
      ******************************************************************16263003
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *16265003
      ******************************************************************16267003
REARCH*    EXEC SQL                                                     16269003
REARCH*         INCLUDE CPD00300                                        16270003
REARCH*    END-EXEC.                                                    16280003
                                                                        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
      ******************************************************************16310003
      *       END PROGRAM COPYLIB                                      *16330003
      ******************************************************************16360003
REARCH*    COPY CPD00302.                                               16361003
REARCH     EXEC SQL                                                     16360000
REARCH          INCLUDE CPD00321                                        16360000
REARCH     END-EXEC.                                                    16360000
