       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.        CSR02411.                                     
COB303 DATE-WRITTEN.  JUNE 2002.                                        
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S411                                           *00120001
      *  PROGRAM:       S411                                           *00130001
      *  CALLING SP:    PA_S411                                        *00140002
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      * THIS PROGRAM IS USED TO RETRIEVE OVERAGE AND SHORTAGE DETAILS  *00180000
      * FROM CSS_OV_SH_HDR AND CSS_OV_SH_DET TABLES.                   *00180000
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  06/03/02   BASKAR    NEW RPC                                  *00240000
      *  08/20/02   BASKAR    COMMENTED SOLUTION TO PROBLEM MAPPING    *00240000
REARCH*  02/23/06   CVNS      RPC TO COBOL DB2 SP CONVERSION.          *00240000
REARCH*             CHENNAI                                            *00240000
      ******************************************************************00320000
                                                                        
      ******************************************************************00330000
      *                                                                *00340000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350000
      *                                                                *00360000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390000
      *  3000 - 4999  NOT USED                                         *00400000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420000
      *  7000 - 7999  INPUT MODULES                                    *00430000
      *  8000 - 8999  OUTPUT MODULES                                   *00440000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450000
      *                                                                *00460000
      ******************************************************************00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02411'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02411 STARTS HERE'.                  
                                                                        
      ******************************************************************01080000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090000
      ******************************************************************01100000
                                                                        
REARCH*   COPY SYGWCOB.                                                 01120000
REARCH*   COPY SYDBCOB.                                                 01130000
REARCH*   COPY CWS00010.                                                01150000
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CWSX0010                                                  
REARCH     END-EXEC.                                                            
          COPY CWS00303.                                                01170000
          COPY CJF00101.                                                01170000
                                                                        
      ******************************************************************01240000
      *    WORK AREAS                                                  *01250000
      ******************************************************************01260000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          01270000
REARCH*    05  GWL-PROC                 POINTER.                        01270000
REARCH*    05  GWL-INIT-HANDLE          POINTER.                        01270000
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                 01270000
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                 01270000
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                 01270000
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                 01270000
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                 01270000
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                 01270000
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                 01270000
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH      05  GTT-NAME                PIC X(26)                       
REARCH                                  VALUE 'SESSION.CSR02411_R1'.    
REARCH      05  GTT-ROW.                                                
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH      05  GTT-SQLCODE             PIC S9(9) COMP.                 
REARCH      05  WS-SQLSTATE             PIC X(5).                       
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
REARCH*01  PARM-FIELDS.                                                 01650000
REARCH*    05  PARM-L                   PIC S9(09) COMP.                        
REARCH*    05  PARM-ID1                 PIC S9(09) COMP VALUE 1.                
REARCH*    05  PARM-CASH-COMPANY-NO     PIC  X(02).                             
REARCH*    05  PARM-CASH-LOCAL-OFFICE   PIC  X(03).                             
REARCH*    05  PARM-DATE-CASH-REPORT    PIC  X(10).                             
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9) COMP.                 
           05  SNA-CONNECTION-NAME      PIC X(8)  VALUE SPACES.         
                                                                        
       01  COUNTER-FLAG.                                                
           05  WS-HDR-COUNT-FLAG        PIC X(01) VALUE 'N'.            
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
           05  WS-BATCH-COUNT           PIC S9(4) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9) COMP.                 
           05  WRKLEN1                  PIC S9(9) COMP.                 
           05  WRKLEN2                  PIC S9(9) COMP.                 
           05  WRK-DONE-STATUS          PIC S9(9) COMP.                 
           05  WS-BATCH-NO              PIC S9(4) COMP VALUE +0.        
           05  WS-STRING-LENGTH         PIC S9(4) COMP.                 
           05  WS-POS-LAST-NAME         PIC S9(4) COMP.                 
                                                                        
       01  WS-CONSTANTS.                                                
REARCH     05  PROGRAM-NAME             PIC X(8)  VALUE 'CSR02411'.     
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
           05  WS-S                     PIC X(01) VALUE 'S'.            
           05  WS-C                     PIC X(01) VALUE 'C'.            
           05  WS-D                     PIC X(01) VALUE 'D'.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-CASH-LOCAL-OFFICE     PIC X(03).                      
           05  RS-DATE-CASH-REPORT      PIC X(10).                      
           05  RS-CASH-DRAWER-ID        PIC S9(4) COMP VALUE 0.         
COB305     05 RS-GL-ACCOUNT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.    
           05  RS-OVERSHORT-ID          PIC S9(4) COMP VALUE 0.         
COB305     05 RS-OFST-OV-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.         
COB305     05 RS-OFST-SH-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.         
COB305     05 RS-OVERAGE-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.         
COB305     05 RS-SHORTAGE-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.         
           05  RS-ACCOUNT-NO            PIC X(13).                      
           05  RS-OVSH-SOLTN-FL         PIC X(1).                       
           05  RS-OVSH-TYPE-CD          PIC X(02).                      
           05  RS-TRAN-COMMENT          PIC X(210).                     
           05  RS-USER-ID               PIC X(07).                      
           05  RS-TRAN-TS               PIC X(20).                      
           05  RS-LAST-UPDATE-TS        PIC X(20).                      
           05  RS-OVSH-SEQ-NO           PIC S9(4) COMP VALUE 0.         
COB305     05 RS-OFST-OVER-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.         
COB305     05 RS-OFST-SHORT-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.         
           05  RS-OFST-CASH-OFF         PIC X(03).                      
           05  RS-OFST-CSH-RPT-DT       PIC X(10).                      
           05  RS-OFST-CSH-DRWR         PIC S9(4) COMP VALUE 0.         
           05  RS-OFST-OVSH-ID          PIC S9(4) COMP VALUE 0.         
           05  RS-MULTI-BATCH-IND       PIC X(01).                      
           05  RS-FULL-NAME             PIC X(40).                      
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-CASH-LOCAL-OFFICE     PIC X(03).                       
REARCH     05  S-DATE-CASH-REPORT      PIC X(10).                       
REARCH     05  S-CASH-DRAWER-ID        PIC S9(4) COMP VALUE 0.          
COB305     05 S-GL-ACCOUNT-NO        PIC S9(3)V9(4) USAGE COMP-3 
COB305       VALUE 0.     
REARCH     05  S-OVERSHORT-ID          PIC S9(4) COMP VALUE 0.          
COB305     05 S-OFST-OV-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.          
COB305     05 S-OFST-SH-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.          
COB305     05 S-OVERAGE-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.          
COB305     05 S-SHORTAGE-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.          
REARCH     05  S-ACCOUNT-NO            PIC X(13).                       
REARCH     05  S-OVSH-SOLTN-FL         PIC X(1).                        
REARCH     05  S-OVSH-TYPE-CD          PIC X(02).                       
REARCH     05  S-TRAN-COMMENT          PIC X(210).                      
REARCH     05  S-USER-ID               PIC X(07).                       
REARCH     05  S-TRAN-TS               PIC X(20).                       
REARCH     05  S-LAST-UPDATE-TS        PIC X(20).                       
REARCH     05  S-OVSH-SEQ-NO           PIC S9(4) COMP VALUE 0.          
COB305     05 S-OFST-OVER-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.          
COB305     05 S-OFST-SHORT-AMT        PIC S9(11)V9(2) COMP-3 VALUE 0.          
REARCH     05  S-OFST-CASH-OFF         PIC X(03).                       
REARCH     05  S-OFST-CSH-RPT-DT       PIC X(10).                       
REARCH     05  S-OFST-CSH-DRWR         PIC S9(4) COMP VALUE 0.          
REARCH     05  S-OFST-OVSH-ID          PIC S9(4) COMP VALUE 0.          
REARCH     05  S-MULTI-BATCH-IND       PIC X(01).                       
REARCH     05  S-FULL-NAME             PIC X(40).                       
REARCH*01  CNS-COLUMN-NAMES.                                            02060000
REARCH*    05  CNS-RETURN-CODE          PIC X(11) VALUE                 02060000
REARCH*                                        'RETURN_CODE'.           02060000
REARCH*    05  CNS-CASH-LOCAL-OFFICE    PIC X(17) VALUE                         
REARCH*                                        'CASH_LOCAL_OFFICE'.             
REARCH*    05  CNS-DATE-CASH-REPORT     PIC X(16) VALUE                         
REARCH*                                        'DATE_CASH_REPORT'.              
REARCH*    05  CNS-CASH-DRAWER-ID       PIC X(14) VALUE                         
REARCH*                                        'CASH_DRAWER_ID'.                
REARCH*    05  CNS-USER-ID              PIC X(07) VALUE                         
REARCH*                                        'USER_ID'.                       
REARCH*    05  CNS-OVERSHORT-ID         PIC X(12) VALUE                 02060000
REARCH*                                        'OVERSHORT_ID'.          02060000
REARCH*    05  CNS-TRAN-TS              PIC X(07) VALUE                 02060000
REARCH*                                        'TRAN_TS'.               02060000
REARCH*    05  CNS-OVERAGE-AMT          PIC X(11) VALUE                 02060000
REARCH*                                        'OVERAGE_AMT'.           02060000
REARCH*    05  CNS-SHORTAGE-AMT         PIC X(12) VALUE                 02060000
REARCH*                                        'SHORTAGE_AMT'.          02060000
REARCH*    05  CNS-OFST-OV-AMT          PIC X(13) VALUE                 02060000
REARCH*                                        'OFFSET_OV_AMT'.         02060000
REARCH*    05  CNS-OFST-SH-AMT          PIC X(13) VALUE                 02060000
REARCH*                                        'OFFSET_SH_AMT'.         02060000
REARCH*    05  CNS-GL-ACCOUNT-NO        PIC X(13) VALUE                 02060000
REARCH*                                        'GL_ACCOUNT_NO'.         02060000
REARCH*    05  CNS-LAST-UPDATE-TS       PIC X(14) VALUE                 02060000
REARCH*                                        'LAST_UPDATE_TS'.        02060000
REARCH*    05  CNS-OVSH-TYPE-CD         PIC X(14) VALUE                 02060000
REARCH*                                        'OVERSHORT_TYPE'.        02060000
REARCH*    05  CNS-OVSH-SOLTN-FL        PIC X(18) VALUE                 02060000
REARCH*                                        'OVERSHORT_SOLUTION'.    02060000
REARCH*    05  CNS-TRAN-COMMENT         PIC X(12) VALUE                 02060000
REARCH*                                        'TRAN_COMMENT'.          02060000
REARCH*    05  CNS-ACCOUNT-NO           PIC X(10) VALUE                 02060000
REARCH*                                        'ACCOUNT_NO'.            02060000
REARCH*    05  CNS-OVSH-SEQ-NO          PIC X(13) VALUE                 02060000
REARCH*                                        'OVERSHORT_SEQ'.         02060000
REARCH*    05  CNS-OFST-OVER-AMT        PIC X(13) VALUE                 02060000
REARCH*                                        'OFST_OVER_AMT'.         02060000
REARCH*    05  CNS-OFST-SHORT-AMT       PIC X(14) VALUE                 02060000
REARCH*                                        'OFST_SHORT_AMT'.        02060000
REARCH*    05  CNS-OFST-CASH-OFF        PIC X(16) VALUE                 02060000
REARCH*                                        'OFST_CASHIER_OFF'.      02060000
REARCH*    05  CNS-OFST-CSH-RPT-DT      PIC X(16) VALUE                 02060000
REARCH*                                        'OFST_REPORT_DATE'.      02060000
REARCH*    05  CNS-OFST-CSH-DRWR        PIC X(14) VALUE                 02060000
REARCH*                                        'OFST_CASH_DRWR'.        02060000
REARCH*    05  CNS-OFST-OVSH-ID         PIC X(17) VALUE                 02060000
REARCH*                                        'OFST_OVERSHORT_ID'.     02060000
REARCH*    05  CNS-MULTI-BATCH-IND      PIC X(15) VALUE                 02060000
REARCH*                                        'MULTI_BATCH_IND'.       02060000
REARCH*    05  CNS-FULL-NAME            PIC X(09) VALUE                 02060000
REARCH*                                        'FULL_NAME'.             02060000
REARCH 01  CSRERLOG-P.                                                  
REARCH      10  S-SP-NAME               PIC X(18)      VALUE SPACES.    
REARCH      10  S-SQLCODE               PIC S9(9)      COMP VALUE 0.    
REARCH      10  S-SQLSTATE              PIC X(5)       VALUE ' '.       
REARCH      10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.    
REARCH      10  S-HOST-VARIABLES.                                       
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4)      USAGE COMP.      
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH      10  S-SQL-STATEMENT.                                        
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH      10  S-SQL-DESCRIPTION.                                      
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4)      USAGE COMP.      
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  OVSH-TRAN-SW             PIC X(01) VALUE 'N'.            
               88 OVSH-TRAN-FOUND                 VALUE 'Y'.            
               88 OVSH-NOT-FOUND                  VALUE 'N'.            
                                                                        
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
                                                                        
           EXEC SQL                                                     00600000
              INCLUDE SQLCA                                             00610000
           END-EXEC.                                                    00620000
                                                                        
      * OH - CSS_OVERSHORT_HDR                                                  
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBOVSHHD                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      * OH - CSS_OVERSHORT_DET                                                  
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBOVSHDT                                          00850000
           END-EXEC.                                                    00860000
                                                                        
      * PF - CSS_USER_PROFILE                                                   
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBUSRPRF                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     25690000
             INCLUDE CWS00017                                           25700000
           END-EXEC.                                                    25710000
                                                                        
           EXEC SQL                                                     25690000
             INCLUDE CWS00013                                           25700000
           END-EXEC.                                                    25710000
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_OVERSHORT_HDR                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
            DECLARE OV_SH_CURSOR CURSOR FOR                             
             SELECT OH.CASH_LOCAL_OFFICE                                
                    ,OH.DATE_CASH_REPORT                                
                    ,OH.CASH_DRAWER_ID                                  
                    ,OH.USER_ID                                         
                    ,OH.OVERSHORT_ID                                    
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), OH.TRAN_TS
           , 121), ' ', '-'), ':', '.') TRAN_TS                                
                    ,OH.OVERSHORT_AMT                                   
                    ,OH.OVERSHORT_DR_CR                                 
                    ,OH.OFST_OVERSHORT_AMT                              
                    ,OH.OFST_DR_CR                                      
                    ,OH.GL_ACCT_NO                                      
                    ,REPLACE(REPLACE(CONVERT(CHAR(26), OH.LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
                    ,OH.OVERSHORT_TYPE_CD                               
                    ,OH.OVERSHORT_SOLTN_FL                              
                    ,OH.TRAN_COMMENT                                    
                    ,OH.ACCOUNT_NO                                      
                    ,PF.FIRST_NAME                                      
                    ,PF.LAST_NAME                                       
                    ,PF.MIDDLE_NAME                                     
               FROM CSS_OVERSHORT_HDR   OH                              
                    ,CSS_USER_PROFILE   PF                              
              WHERE OH.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO          
                AND OH.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE        
                AND OH.DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                AND OH.CASH_DRAWER_ID    > 0                            
                AND OH.USER_ID           > ' '                          
                AND OH.USER_ID           =  PF.USER_ID                  
              ORDER BY OH.USER_ID ASC,                                  
                       OH.CASH_DRAWER_ID ASC,                           
                       OH.OVERSHORT_ID ASC                              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*     DECLARE OV_SH_CURSOR CURSOR FOR                             06930000
MFA-TR*      SELECT OH.CASH_LOCAL_OFFICE                                06940000
MFA-TR*             ,OH.DATE_CASH_REPORT                                        
MFA-TR*             ,OH.CASH_DRAWER_ID                                          
MFA-TR*             ,OH.USER_ID                                                 
MFA-TR*             ,OH.OVERSHORT_ID                                    06940000
MFA-TR*             ,OH.TRAN_TS                                                 
MFA-TR*             ,OH.OVERSHORT_AMT                                           
MFA-TR*             ,OH.OVERSHORT_DR_CR                                         
MFA-TR*             ,OH.OFST_OVERSHORT_AMT                                      
MFA-TR*             ,OH.OFST_DR_CR                                              
MFA-TR*             ,OH.GL_ACCT_NO                                              
MFA-TR*             ,OH.LAST_UPDATE_TS                                          
MFA-TR*             ,OH.OVERSHORT_TYPE_CD                                       
MFA-TR*             ,OH.OVERSHORT_SOLTN_FL                                      
MFA-TR*             ,OH.TRAN_COMMENT                                            
MFA-TR*             ,OH.ACCOUNT_NO                                              
MFA-TR*             ,PF.FIRST_NAME                                              
MFA-TR*             ,PF.LAST_NAME                                               
MFA-TR*             ,PF.MIDDLE_NAME                                             
MFA-TR*        FROM CSS_OVERSHORT_HDR   OH                                      
MFA-TR*             ,CSS_USER_PROFILE   PF                                      
MFA-TR*       WHERE OH.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                  
MFA-TR*         AND OH.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                
MFA-TR*         AND OH.DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                 
MFA-TR*         AND OH.CASH_DRAWER_ID    > 0                                    
MFA-TR*         AND OH.USER_ID           > ' '                                  
MFA-TR*         AND OH.USER_ID           =  PF.USER_ID                          
MFA-TR*       ORDER BY OH.USER_ID ASC,                                          
MFA-TR*                OH.CASH_DRAWER_ID ASC,                                   
MFA-TR*                OH.OVERSHORT_ID ASC                                      
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_OVERSHORT_DET                          *06910000
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE OV_SH_DET CURSOR FOR                                
             SELECT OD.OVERSHORT_SEQ_NO                                 
                    ,OD.OFST_OVERSHORT_AMT                              
                    ,OD.OFST_DR_CR                                      
                    ,OD.OFST_COMPANY_NO                                 
                    ,OD.OFST_LOC_OFCE                                   
                    ,OD.OFST_CASH_REPT_DT                               
                    ,OD.OFST_CASH_DRWR_ID                               
                    ,OD.OFST_OVERSHORT_ID                               
               FROM CSS_OVERSHORT_DET   OD                              
              WHERE OD.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO          
                AND OD.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE        
                AND OD.DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                AND OD.CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID           
                AND OD.OVERSHORT_ID      = :OH-OVERSHORT-ID             
              ORDER BY OD.OVERSHORT_SEQ_NO ASC                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*     DECLARE OV_SH_DET CURSOR FOR                                06930000
MFA-TR*      SELECT OD.OVERSHORT_SEQ_NO                                 06940000
MFA-TR*             ,OD.OFST_OVERSHORT_AMT                                      
MFA-TR*             ,OD.OFST_DR_CR                                              
MFA-TR*             ,OD.OFST_COMPANY_NO                                         
MFA-TR*             ,OD.OFST_LOC_OFCE                                   06940000
MFA-TR*             ,OD.OFST_CASH_REPT_DT                                       
MFA-TR*             ,OD.OFST_CASH_DRWR_ID                                       
MFA-TR*             ,OD.OFST_OVERSHORT_ID                                       
MFA-TR*        FROM CSS_OVERSHORT_DET   OD                                      
MFA-TR*       WHERE OD.CASH_COMPANY_NO   = :OH-CASH-COMPANY-NO                  
MFA-TR*         AND OD.CASH_LOCAL_OFFICE = :OH-CASH-LOCAL-OFFICE                
MFA-TR*         AND OD.DATE_CASH_REPORT  = :OH-DATE-CASH-REPORT                 
MFA-TR*         AND OD.CASH_DRAWER_ID    = :OH-CASH-DRAWER-ID                   
MFA-TR*         AND OD.OVERSHORT_ID      = :OH-OVERSHORT-ID                     
MFA-TR*       ORDER BY OD.OVERSHORT_SEQ_NO ASC                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************06900000
      *      2ND CURSOR FOR CSS_OVERSHORT_DET                          *06910000
      ******************************************************************        
           EXEC SQL                                                     
            DECLARE OV_SH_SOL CURSOR FOR                                
             SELECT OD.CASH_COMPANY_NO                                  
                    ,OD.CASH_LOCAL_OFFICE                               
                    ,OD.DATE_CASH_REPORT                                
                    ,OD.CASH_DRAWER_ID                                  
                    ,OD.OVERSHORT_ID                                    
                    ,OD.OVERSHORT_SEQ_NO                                
                    ,OD.OFST_OVERSHORT_AMT                              
                    ,OD.OFST_DR_CR                                      
               FROM CSS_OVERSHORT_DET   OD                              
              WHERE OD.OFST_COMPANY_NO   = :OH-CASH-COMPANY-NO          
                AND OD.OFST_LOC_OFCE     = :OH-CASH-LOCAL-OFFICE        
                AND OD.OFST_CASH_REPT_DT = IIF(TRY_CONVERT(DATE, 
                                                   :OH-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :OH-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:OH-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:OH-DATE-CASH-REPORT
              ), CONVERT(DATE, :OH-DATE-CASH-REPORT) )         
                AND OD.OFST_CASH_DRWR_ID = :OH-CASH-DRAWER-ID           
                AND OD.OFST_OVERSHORT_ID = :OH-OVERSHORT-ID             
              ORDER BY OD.OVERSHORT_SEQ_NO ASC                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*     DECLARE OV_SH_SOL CURSOR FOR                                06930000
MFA-TR*      SELECT OD.CASH_COMPANY_NO                                          
MFA-TR*             ,OD.CASH_LOCAL_OFFICE                                       
MFA-TR*             ,OD.DATE_CASH_REPORT                                        
MFA-TR*             ,OD.CASH_DRAWER_ID                                          
MFA-TR*             ,OD.OVERSHORT_ID                                            
MFA-TR*             ,OD.OVERSHORT_SEQ_NO                                06940000
MFA-TR*             ,OD.OFST_OVERSHORT_AMT                                      
MFA-TR*             ,OD.OFST_DR_CR                                              
MFA-TR*        FROM CSS_OVERSHORT_DET   OD                                      
MFA-TR*       WHERE OD.OFST_COMPANY_NO   = :OH-CASH-COMPANY-NO                  
MFA-TR*         AND OD.OFST_LOC_OFCE     = :OH-CASH-LOCAL-OFFICE                
MFA-TR*         AND OD.OFST_CASH_REPT_DT = :OH-DATE-CASH-REPORT                 
MFA-TR*         AND OD.OFST_CASH_DRWR_ID = :OH-CASH-DRAWER-ID                   
MFA-TR*         AND OD.OFST_OVERSHORT_ID = :OH-OVERSHORT-ID                     
MFA-TR*       ORDER BY OD.OVERSHORT_SEQ_NO ASC                                  
MFA-TR*    END-EXEC.                                                            
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-CASH-COMPANY-NO     PIC  X(02).                         
REARCH 01  PARM-CASH-LOCAL-OFFICE   PIC  X(03).                         
REARCH 01  PARM-DATE-CASH-REPORT    PIC  X(10).                         
HPCCDM*EJECT                                                            02110000
REARCH PROCEDURE DIVISION USING PARM-CASH-COMPANY-NO                    
REARCH                          PARM-CASH-LOCAL-OFFICE                  
REARCH                          PARM-DATE-CASH-REPORT.                  
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT          
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT          
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT          
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT          
           .                                                            
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      *                                                                *02310000
      *     1. RESET DB2 ERROR HANDLERS                                *02320000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02330000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02340000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02350000
      *                                                                *02360000
      ******************************************************************02370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC               
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC               
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC               
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE       2450000
REARCH*                                                                  2460000
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,      2470000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC           2480000
REARCH*                                                                  2490000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC                        2500000
REARCH*                                                                  2510000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                              2520000
REARCH*       MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        2530000 
REARCH*       MOVE '0100'                       TO ACTIVE-PARAGRAPH     2540000 
REARCH*       MOVE 'TDRESULT-NO RPC PARM SENT'  TO ABEND-FUNCTION       2550000 
REARCH*       MOVE 'CICS TRANSACTION'           TO TABLE-1              2560000 
REARCH*       MOVE GWL-RC                       TO WS-ACTIVE-RETURN-CODE2570000 
REARCH*       PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          2580000 
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          2590000 
REARCH*    END-IF                                                       2600000 
REARCH*    .                                                            02610000
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH            RETURN_CODE                                           
REARCH           ,LTRIM(RTRIM(CASH_LOCAL_OFFICE))     AS 
           CASH_LOCAL_OFFICE     
REARCH           ,LTRIM(RTRIM(DATE_CASH_REPORT))      AS 
           DATE_CASH_REPORT      
REARCH           ,CASH_DRAWER_ID                                        
REARCH           ,GL_ACCOUNT_NO                                         
REARCH           ,OVERSHORT_ID                                          
REARCH           ,OFST_OV_AMT                  AS OFFSET_OV_AMT         
REARCH           ,OFST_SH_AMT                  AS OFFSET_SH_AMT         
REARCH           ,OVERAGE_AMT                                           
REARCH           ,SHORTAGE_AMT                                          
REARCH           ,LTRIM(RTRIM(ACCOUNT_NO))            AS ACCOUNT_NO            
REARCH           ,LTRIM(RTRIM(OVSH_SOLTN_FL))         AS 
           OVERSHORT_SOLUTION    
REARCH           ,LTRIM(RTRIM(OVSH_TYPE_CD))          AS OVERSHORT_TYPE        
REARCH           ,LTRIM(RTRIM(TRAN_COMMENT))          AS TRAN_COMMENT          
REARCH           ,LTRIM(RTRIM(USER_ID))               AS USER_ID               
REARCH           ,LTRIM(RTRIM(TRAN_TS))               AS TRAN_TS               
REARCH           ,LTRIM(RTRIM(LAST_UPDATE_TS))        AS LAST_UPDATE_TS        
REARCH           ,OVSH_SEQ_NO                  AS OVERSHORT_SEQ         
REARCH           ,OFST_OVER_AMT                                         
REARCH           ,OFST_SHORT_AMT                                        
REARCH           ,LTRIM(RTRIM(OFST_CASH_OFF))         AS 
           OFST_CASHIER_OFF      
REARCH           ,LTRIM(RTRIM(OFST_CSH_RPT_DT))       AS 
           OFST_REPORT_DATE      
REARCH           ,OFST_CSH_DRWR                AS OFST_CASH_DRWR        
REARCH           ,OFST_OVSH_ID                 AS OFST_OVERSHORT_ID     
REARCH           ,LTRIM(RTRIM(MULTI_BATCH_IND))       AS MULTI_BATCH_IND       
REARCH           ,LTRIM(RTRIM(FULL_NAME))             AS FULL_NAME             
REARCH         FROM                                                     
REARCH             #CSR02411_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*           RETURN_CODE                                                   
MFA-TR*          ,STRIP(CASH_LOCAL_OFFICE)     AS CASH_LOCAL_OFFICE             
MFA-TR*          ,STRIP(DATE_CASH_REPORT)      AS DATE_CASH_REPORT              
MFA-TR*          ,CASH_DRAWER_ID                                                
MFA-TR*          ,GL_ACCOUNT_NO                                                 
MFA-TR*          ,OVERSHORT_ID                                                  
MFA-TR*          ,OFST_OV_AMT                  AS OFFSET_OV_AMT                 
MFA-TR*          ,OFST_SH_AMT                  AS OFFSET_SH_AMT                 
MFA-TR*          ,OVERAGE_AMT                                                   
MFA-TR*          ,SHORTAGE_AMT                                                  
MFA-TR*          ,STRIP(ACCOUNT_NO)            AS ACCOUNT_NO                    
MFA-TR*          ,STRIP(OVSH_SOLTN_FL)         AS OVERSHORT_SOLUTION            
MFA-TR*          ,STRIP(OVSH_TYPE_CD)          AS OVERSHORT_TYPE                
MFA-TR*          ,STRIP(TRAN_COMMENT)          AS TRAN_COMMENT                  
MFA-TR*          ,STRIP(USER_ID)               AS USER_ID                       
MFA-TR*          ,STRIP(TRAN_TS)               AS TRAN_TS                       
MFA-TR*          ,STRIP(LAST_UPDATE_TS)        AS LAST_UPDATE_TS                
MFA-TR*          ,OVSH_SEQ_NO                  AS OVERSHORT_SEQ                 
MFA-TR*          ,OFST_OVER_AMT                                                 
MFA-TR*          ,OFST_SHORT_AMT                                                
MFA-TR*          ,STRIP(OFST_CASH_OFF)         AS OFST_CASHIER_OFF              
MFA-TR*          ,STRIP(OFST_CSH_RPT_DT)       AS OFST_REPORT_DATE              
MFA-TR*          ,OFST_CSH_DRWR                AS OFST_CASH_DRWR                
MFA-TR*          ,OFST_OVSH_ID                 AS OFST_OVERSHORT_ID             
MFA-TR*          ,STRIP(MULTI_BATCH_IND)       AS MULTI_BATCH_IND               
MFA-TR*          ,STRIP(FULL_NAME)             AS FULL_NAME                     
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02411_R1                                          
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT************************************************        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH      MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02411_R1'           
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH      EXEC SQL
              CALL CIS.DROP_TEMP_TABLE('#CSR02411_R1')
            END-EXEC
            EXEC SQL
              CREATE TABLE #CSR02411_R1
               (                                                       
REARCH              RETURN_CODE        INT                          
REARCH             ,CASH_LOCAL_OFFICE CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,DATE_CASH_REPORT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,CASH_DRAWER_ID     SMALLINT                         
REARCH             ,GL_ACCOUNT_NO      DECIMAL(7,4)                     
REARCH             ,OVERSHORT_ID       SMALLINT                         
REARCH             ,OFST_OV_AMT        DECIMAL(13,2)                    
REARCH             ,OFST_SH_AMT        DECIMAL(13,2)                    
REARCH             ,OVERAGE_AMT        DECIMAL(13,2)                    
REARCH             ,SHORTAGE_AMT       DECIMAL(13,2)                    
REARCH             ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,OVSH_SOLTN_FL CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,OVSH_TYPE_CD CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,TRAN_COMMENT CHAR(210)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,USER_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,TRAN_TS CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,LAST_UPDATE_TS CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,OVSH_SEQ_NO        SMALLINT                         
REARCH             ,OFST_OVER_AMT      DECIMAL(13,2)                    
REARCH             ,OFST_SHORT_AMT     DECIMAL(13,2)                    
REARCH             ,OFST_CASH_OFF CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,OFST_CSH_RPT_DT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,OFST_CSH_DRWR      SMALLINT                         
REARCH             ,OFST_OVSH_ID       SMALLINT                         
REARCH             ,MULTI_BATCH_IND CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                      
REARCH             ,FULL_NAME CHAR(40)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH          )
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLSTATE                 TO WS-SQLSTATE.               
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-SQLSTATE = '42710'                                    
REARCH         PERFORM 8000A-DELETE-GTT-ROWS                            
REARCH                                    THRU 8000A-EXIT               
REARCH      ELSE                                                        
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02411_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
      ******************************************************************02650000
      * 1000-PROCESS-INPUT                                             *02660000
      *     1. RECEIVE PARMS.                                          *02680000
      ******************************************************************02700000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                   TO ACTIVE-PARAGRAPH            
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS    THRU 1100-EXIT                 02740000
                                                                        
           MOVE PARM-CASH-COMPANY-NO     TO OH-CASH-COMPANY-NO          
           MOVE PARM-CASH-LOCAL-OFFICE   TO OH-CASH-LOCAL-OFFICE        
           MOVE PARM-DATE-CASH-REPORT    TO OH-DATE-CASH-REPORT         
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02790000
      * 1100-RECEIVE-PARMS                                             *02800000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *02820000
      ******************************************************************02840000
                                                                        
REARCH*1100-RECEIVE-PARMS.                                              02860000
REARCH*                                                                 02870000
REARCH*    MOVE '1100'                        TO ACTIVE-PARAGRAPH       02730000
REARCH*                                                                 06270000
REARCH*      MOVE 1                           TO PARM-ID1               06680000
REARCH*      MOVE LENGTH OF PARM-CASH-COMPANY-NO    TO MAX-LENGTH-PARM  09890000
REARCH*      CALL 'TDRCVPRM' USING GWL-PROC,                            09900000
REARCH*                            GWL-RC,                              09910000
REARCH*                            PARM-ID1,                            09920000
REARCH*                            PARM-CASH-COMPANY-NO,                09930000
REARCH*                            TDSCHAR,                             09940000
REARCH*                            MAX-LENGTH-PARM,                     09950000
REARCH*                            PARM-L.                              09960000
REARCH*                                                                 09970000
REARCH*      ADD  1                                 TO PARM-ID1         09980000
REARCH*      MOVE LENGTH OF PARM-CASH-LOCAL-OFFICE  TO MAX-LENGTH-PARM  09990000
REARCH*      CALL 'TDRCVPRM' USING GWL-PROC,                            10000000
REARCH*                            GWL-RC,                              10010000
REARCH*                            PARM-ID1,                            10020000
REARCH*                            PARM-CASH-LOCAL-OFFICE,              10030000
REARCH*                            TDSCHAR,                             10040000
REARCH*                            MAX-LENGTH-PARM,                     10050000
REARCH*                            PARM-L.                              10060000
REARCH*                                                                 09570000
REARCH*      ADD  1                                 TO PARM-ID1         09780000
REARCH*      MOVE LENGTH OF PARM-DATE-CASH-REPORT   TO MAX-LENGTH-PARM  09790000
REARCH*      CALL 'TDRCVPRM' USING GWL-PROC,                            09800000
REARCH*                            GWL-RC,                              09810000
REARCH*                            PARM-ID1,                            09820000
REARCH*                            PARM-DATE-CASH-REPORT,               09830000
REARCH*                            TDSCHAR,                             09840000
REARCH*                            MAX-LENGTH-PARM,                     09850000
REARCH*                            PARM-L.                              09860000
REARCH*                                                                 10070000
REARCH*                                                                 10270000
REARCH*1100-EXIT.                                                       05080000
REARCH*    EXIT.                                                        05090000
                                                                        
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      *     1. DESCRIBE RESULT SET                                     *05130000
      *     2. BUILD THE RESULT SET                                    *05150000
      *     3. SEND RESULT SET                                         *05170000
      ******************************************************************05190000
      *                                                                 05200000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                          TO ACTIVE-PARAGRAPH     
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT         THRU 2100-EXIT          05230000
                                                                        
           PERFORM 2200-PROCESS-HEADER          THRU 2200-EXIT          
           .                                                            
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT                                               *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH     MOVE RS-CASH-LOCAL-OFFICE  TO S-CASH-LOCAL-OFFICE.           
REARCH     MOVE RS-DATE-CASH-REPORT   TO S-DATE-CASH-REPORT.            
REARCH     MOVE RS-CASH-DRAWER-ID     TO S-CASH-DRAWER-ID.              
REARCH     MOVE RS-GL-ACCOUNT-NO      TO S-GL-ACCOUNT-NO.               
REARCH     MOVE RS-OVERSHORT-ID       TO S-OVERSHORT-ID.                
REARCH     MOVE RS-OFST-OV-AMT        TO S-OFST-OV-AMT.                 
REARCH     MOVE RS-OFST-SH-AMT        TO S-OFST-SH-AMT.                 
REARCH     MOVE RS-OVERAGE-AMT        TO S-OVERAGE-AMT.                 
REARCH     MOVE RS-SHORTAGE-AMT       TO S-SHORTAGE-AMT.                
REARCH     MOVE RS-ACCOUNT-NO         TO S-ACCOUNT-NO.                  
REARCH     MOVE RS-OVSH-SOLTN-FL      TO S-OVSH-SOLTN-FL.               
REARCH     MOVE RS-OVSH-TYPE-CD       TO S-OVSH-TYPE-CD.                
REARCH     MOVE RS-TRAN-COMMENT       TO S-TRAN-COMMENT.                
REARCH     MOVE RS-USER-ID            TO S-USER-ID.                     
REARCH     MOVE RS-TRAN-TS            TO S-TRAN-TS.                     
REARCH     MOVE RS-LAST-UPDATE-TS     TO S-LAST-UPDATE-TS.              
REARCH     MOVE RS-OVSH-SEQ-NO        TO S-OVSH-SEQ-NO.                 
REARCH     MOVE RS-OFST-OVER-AMT      TO S-OFST-OVER-AMT.               
REARCH     MOVE RS-OFST-SHORT-AMT     TO S-OFST-SHORT-AMT.              
REARCH     MOVE RS-OFST-CASH-OFF      TO S-OFST-CASH-OFF.               
REARCH     MOVE RS-OFST-CSH-RPT-DT    TO S-OFST-CSH-RPT-DT.             
REARCH     MOVE RS-OFST-CSH-DRWR      TO S-OFST-CSH-DRWR.               
REARCH     MOVE RS-OFST-OVSH-ID       TO S-OFST-OVSH-ID.                
REARCH     MOVE RS-MULTI-BATCH-IND    TO S-MULTI-BATCH-IND.             
REARCH     MOVE RS-FULL-NAME          TO S-FULL-NAME.                   
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ***************************************************************           
      * DESCRIBE THE RESULT SET                                     *           
      ***************************************************************           
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                 05640000
REARCH*    MOVE '2100'                          TO ACTIVE-PARAGRAPH     05640000
REARCH*                                                                 05640000
REARCH*    MOVE 1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSINT4                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSINT4                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE        TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-RETURN-CODE       TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-RETURN-CODE,                        05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-RETURN-CODE,                       05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-CASH-LOCAL-OFFICE  TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-CASH-LOCAL-OFFICE TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-CASH-LOCAL-OFFICE,                  05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-CASH-LOCAL-OFFICE,                 05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-DATE-CASH-REPORT   TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-DATE-CASH-REPORT  TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-DATE-CASH-REPORT,                   05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-DATE-CASH-REPORT,                  05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSINT2                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSINT2                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-CASH-DRAWER-ID     TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-CASH-DRAWER-ID    TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-CASH-DRAWER-ID,                     05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-CASH-DRAWER-ID,                    05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-GL-ACCOUNT-NO      TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-GL-ACCOUNT-NO     TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-GL-ACCOUNT-NO,                      05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-GL-ACCOUNT-NO,                     05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    MOVE +4 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSINT2                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSINT2                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OVERSHORT-ID       TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OVERSHORT-ID      TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OVERSHORT-ID,                       05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OVERSHORT-ID,                      05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-OV-AMT        TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-OV-AMT       TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-OV-AMT,                        05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-OV-AMT,                       05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-SH-AMT        TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-SH-AMT       TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-SH-AMT,                        05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-SH-AMT,                       05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OVERAGE-AMT        TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OVERAGE-AMT       TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OVERAGE-AMT,                        05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OVERAGE-AMT,                       05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-SHORTAGE-AMT       TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-SHORTAGE-AMT      TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-SHORTAGE-AMT,                       05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-SHORTAGE-AMT,                      05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*                                                                 05640000
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-ACCOUNT-NO         TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-ACCOUNT-NO        TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-ACCOUNT-NO,                         05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-ACCOUNT-NO,                        05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OVSH-SOLTN-FL      TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OVSH-SOLTN-FL     TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OVSH-SOLTN-FL,                      05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OVSH-SOLTN-FL,                     05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OVSH-TYPE-CD       TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OVSH-TYPE-CD      TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OVSH-TYPE-CD,                       05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OVSH-TYPE-CD,                      05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-TRAN-COMMENT       TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-TRAN-COMMENT      TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-TRAN-COMMENT,                       05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-TRAN-COMMENT,                      05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-USER-ID            TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-USER-ID           TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-USER-ID,                            05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-USER-ID,                           05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-TRAN-TS            TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-TRAN-TS           TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-TRAN-TS,                            05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-TRAN-TS,                           05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-LAST-UPDATE-TS     TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-LAST-UPDATE-TS    TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-LAST-UPDATE-TS,                     05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-LAST-UPDATE-TS,                    05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*   MOVE TDSINT2                         TO DB-HOST-TYPE.         05640000
REARCH*   MOVE TDSINT2                         TO DB-CLIENT-TYPE.       05640000
REARCH*   MOVE LENGTH OF RS-OVSH-SEQ-NO        TO WRKLEN1.              05640000
REARCH*   MOVE LENGTH OF CNS-OVSH-SEQ-NO       TO WRKLEN2.              05640000
REARCH*                                                                 05640000
REARCH*   CALL 'TDESCRIB' USING GWL-PROC,                               05640000
REARCH*                         GWL-RC,                                 05640000
REARCH*                         CTR-COLUMN,                             05640000
REARCH*                         DB-HOST-TYPE,                           05640000
REARCH*                         WRKLEN1,                                05640000
REARCH*                         RS-OVSH-SEQ-NO,                         05640000
REARCH*                         DB-NULL-INDICATOR,                      05640000
REARCH*                         TDS-FALSE,                              05640000
REARCH*                         DB-CLIENT-TYPE,                         05640000
REARCH*                         WRKLEN1,                                05640000
REARCH*                         CNS-OVSH-SEQ-NO,                        05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-OVER-AMT      TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-OVER-AMT     TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-OVER-AMT,                      05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-OVER-AMT,                     05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSDECIMAL                      TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSFLT8                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-SHORT-AMT     TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-SHORT-AMT    TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-SHORT-AMT,                     05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-SHORT-AMT,                    05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    MOVE +2 TO WRKLEN2.                                                  
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-CASH-OFF      TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-CASH-OFF     TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-CASH-OFF,                      05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-CASH-OFF,                     05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-CSH-RPT-DT    TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-CSH-RPT-DT   TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-CSH-RPT-DT,                    05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-CSH-RPT-DT,                   05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSINT2                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSINT2                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-CSH-DRWR      TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-CSH-DRWR     TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-CSH-DRWR,                      05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-CSH-DRWR,                     05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                 05640000
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSINT2                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSINT2                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-OFST-OVSH-ID       TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-OFST-OVSH-ID      TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-OFST-OVSH-ID,                       05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-OFST-OVSH-ID,                      05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT          05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-MULTI-BATCH-IND    TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-MULTI-BATCH-IND   TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-MULTI-BATCH-IND,                    05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-MULTI-BATCH-IND,                   05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*                                                                         
REARCH*    ADD  1                               TO CTR-COLUMN.          05640000
REARCH*    MOVE TDSCHAR                         TO DB-HOST-TYPE.        05640000
REARCH*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.      05640000
REARCH*    MOVE LENGTH OF RS-FULL-NAME          TO WRKLEN1.             05640000
REARCH*    MOVE LENGTH OF CNS-FULL-NAME         TO WRKLEN2.             05640000
REARCH*                                                                 05640000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              05640000
REARCH*                          GWL-RC,                                05640000
REARCH*                          CTR-COLUMN,                            05640000
REARCH*                          DB-HOST-TYPE,                          05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          RS-FULL-NAME,                          05640000
REARCH*                          DB-NULL-INDICATOR,                     05640000
REARCH*                          TDS-FALSE,                             05640000
REARCH*                          DB-CLIENT-TYPE,                        05640000
REARCH*                          WRKLEN1,                               05640000
REARCH*                          CNS-FULL-NAME,                         05640000
REARCH*                          WRKLEN2.                               05640000
REARCH*                                                                 05640000
REARCH*    PERFORM 9100-CHECK-ERROR             THRU 9100-EXIT.         05640000
REARCH*    .                                                            05640000
REARCH*2100-EXIT.                                                       05640000
REARCH*    EXIT.                                                        05640000
                                                                        
       2200-PROCESS-HEADER.                                             
                                                                        
           INITIALIZE TDS-RETURN-FIELDS                                 
                                                                        
           PERFORM 7100-OPEN-OVSH-CURSOR        THRU 7100-EXIT          
           PERFORM 7200-FETCH-OVSH-CURSOR       THRU 7200-EXIT          
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              SET OVSH-TRAN-FOUND               TO TRUE                 
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND       
                 MOVE OH-CASH-LOCAL-OFFICE      TO RS-CASH-LOCAL-OFFICE 
                 MOVE OH-DATE-CASH-REPORT       TO RS-DATE-CASH-REPORT  
                 MOVE OH-CASH-DRAWER-ID         TO RS-CASH-DRAWER-ID    
                 IF WS-BATCH-NO NOT EQUAL OH-CASH-DRAWER-ID             
                    ADD 1                       TO WS-BATCH-COUNT       
                    MOVE OH-CASH-DRAWER-ID      TO WS-BATCH-NO          
                 END-IF                                                 
                 MOVE OH-USER-ID                TO RS-USER-ID           
                 MOVE SPACES                    TO RS-FULL-NAME         
                 IF PF-FIRST-NAME GREATER THAN SPACES AND               
                    PF-LAST-NAME GREATER THAN SPACES                    
                    PERFORM 2400-COMPUTE-NAME   THRU 2400-EXIT          
                 ELSE                                                   
                    IF PF-LAST-NAME GREATER THAN SPACES                 
                        MOVE PF-LAST-NAME       TO RS-FULL-NAME         
                    ELSE                                                
                       MOVE PF-FIRST-NAME       TO RS-FULL-NAME         
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 MOVE OH-OVERSHORT-ID           TO RS-OVERSHORT-ID      
                 MOVE OH-TRAN-TS                TO RS-TRAN-TS           
                 MOVE OH-GL-ACCT-NO             TO RS-GL-ACCOUNT-NO     
                 MOVE OH-LAST-UPDATE-TS         TO RS-LAST-UPDATE-TS    
                 MOVE OH-OVERSHORT-TYPE-CD      TO RS-OVSH-TYPE-CD      
                 MOVE OH-OVERSHORT-SOLTN-FL     TO RS-OVSH-SOLTN-FL     
                 MOVE OH-TRAN-COMMENT-TEXT      TO RS-TRAN-COMMENT      
                 MOVE OH-ACCOUNT-NO             TO RS-ACCOUNT-NO        
                 IF WS-BATCH-COUNT > 1                                  
                    MOVE WS-Y                   TO RS-MULTI-BATCH-IND   
                 ELSE                                                   
                    MOVE SPACES                 TO RS-MULTI-BATCH-IND   
                 END-IF                                                 
                 INITIALIZE OH-TRAN-COMMENT                             
                 IF OH-OVERSHORT-DR-CR = WS-C                           
                    MOVE OH-OVERSHORT-AMT       TO RS-OVERAGE-AMT       
                    MOVE ZERO                   TO RS-SHORTAGE-AMT      
                 ELSE                                                   
                    MOVE ZERO                   TO RS-OVERAGE-AMT       
                    MOVE OH-OVERSHORT-AMT       TO RS-SHORTAGE-AMT      
                 END-IF                                                 
                 IF OH-OFST-DR-CR = WS-C                                
                    MOVE OH-OFST-OVERSHORT-AMT  TO RS-OFST-OV-AMT       
                    MOVE ZERO                   TO RS-OFST-SH-AMT       
                 ELSE                                                   
                    MOVE ZERO                   TO RS-OFST-OV-AMT       
                    MOVE OH-OFST-OVERSHORT-AMT  TO RS-OFST-SH-AMT       
                 END-IF                                                 
                 IF OH-OVERSHORT-SOLTN-FL = WS-S                        
                    PERFORM 2300-PROCESS-DETAIL THRU 2300-EXIT          
                 ELSE                                                   
BASKAR*             IF OH-OFST-OVERSHORT-AMT > 0                                
BASKAR*                PERFORM 2500-PROCESS-SOLUTION THRU 2500-EXIT             
BASKAR*             ELSE                                                        
                       INITIALIZE  RS-OVSH-SEQ-NO                       
                                   RS-OFST-OVER-AMT                     
                                   RS-OFST-SHORT-AMT                    
                                   RS-OFST-CASH-OFF                     
                                   RS-OFST-CSH-RPT-DT                   
                                   RS-OFST-CSH-DRWR                     
                                   RS-OFST-OVSH-ID                      
REARCH                 PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT      
                       PERFORM 8100-SEND-RESULT    THRU 8100-EXIT       
BASKAR*             END-IF                                                      
                 END-IF                                                 
                 PERFORM 7200-FETCH-OVSH-CURSOR THRU 7200-EXIT          
              END-PERFORM                                               
           ELSE                                                         
              IF OVSH-NOT-FOUND                                         
                 MOVE 2000                      TO RS-RETURN-CODE       
              END-IF                                                    
REARCH        PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT         
              PERFORM 8100-SEND-RESULT          THRU 8100-EXIT          
           END-IF                                                       
           PERFORM 7300-CLOSE-OVSH-CURSOR       THRU 7300-EXIT          
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2300-PROCESS-DETAIL.                                             
                                                                        
           PERFORM 7400-OPEN-DET-CURSOR         THRU 7400-EXIT          
           PERFORM 7500-FETCH-DET-CURSOR        THRU 7500-EXIT          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              INITIALIZE  RS-OVSH-SEQ-NO                                
                          RS-OFST-OVER-AMT                              
                          RS-OFST-SHORT-AMT                             
                          RS-OFST-CASH-OFF                              
                          RS-OFST-CSH-RPT-DT                            
                          RS-OFST-CSH-DRWR                              
                          RS-OFST-OVSH-ID                               
REARCH        PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
           ELSE                                                         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE OD-OVERSHORT-SEQ-NO       TO RS-OVSH-SEQ-NO       
                 MOVE OD-OFST-LOC-OFCE          TO RS-OFST-CASH-OFF     
                 MOVE OD-OFST-CASH-REPT-DT      TO RS-OFST-CSH-RPT-DT   
                 MOVE OD-OFST-CASH-DRWR-ID      TO RS-OFST-CSH-DRWR     
                 MOVE OD-OFST-OVERSHORT-ID      TO RS-OFST-OVSH-ID      
                                                                        
                 IF OD-OFST-DR-CR = WS-C                                
                   MOVE OD-OFST-OVERSHORT-AMT   TO RS-OFST-OVER-AMT     
                   MOVE ZERO                    TO RS-OFST-SHORT-AMT    
                 ELSE                                                   
                   MOVE ZERO                    TO RS-OFST-OVER-AMT     
                   MOVE OD-OFST-OVERSHORT-AMT   TO RS-OFST-SHORT-AMT    
                 END-IF                                                 
REARCH           PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
                 PERFORM 7500-FETCH-DET-CURSOR  THRU 7500-EXIT          
              END-PERFORM                                               
           END-IF                                                       
           PERFORM 7600-CLOSE-DET-CURSOR        THRU 7600-EXIT          
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2400-COMPUTE-NAME                                           *        
      *       COMPUTE THE FULL NAME                                    *        
      ******************************************************************        
                                                                        
       2400-COMPUTE-NAME.                                               
                                                                        
           MOVE LENGTH OF PF-LAST-NAME          TO WS-STRING-LENGTH     
           PERFORM UNTIL PF-LAST-NAME(WS-STRING-LENGTH:1) NOT EQUAL     
              SPACES                                                    
               SUBTRACT 1 FROM WS-STRING-LENGTH                         
           END-PERFORM                                                  
           MOVE WS-STRING-LENGTH                TO WS-POS-LAST-NAME     
                                                                        
           MOVE LENGTH OF PF-FIRST-NAME         TO WS-STRING-LENGTH     
           PERFORM UNTIL PF-FIRST-NAME(WS-STRING-LENGTH:1) NOT EQUAL    
              SPACES                                                    
               SUBTRACT 1 FROM WS-STRING-LENGTH                         
           END-PERFORM                                                  
                                                                        
           STRING                                                       
               PF-LAST-NAME(1:WS-POS-LAST-NAME) DELIMITED BY SIZE       
               ', ' DELIMITED BY SIZE                                   
               PF-FIRST-NAME(1:WS-STRING-LENGTH) DELIMITED BY SIZE      
               ' ' DELIMITED BY SIZE                                    
               PF-MIDDLE-NAME DELIMITED BY SIZE                         
               INTO RS-FULL-NAME                                        
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2500-PROCESS-SOLUTION.                                      *        
      *       GET SOLUTION DETAILS.                                    *        
      ******************************************************************        
                                                                        
       2500-PROCESS-SOLUTION.                                           
                                                                        
           PERFORM 7700-OPEN-SOL-CURSOR         THRU 7700-EXIT          
           PERFORM 7800-FETCH-SOL-CURSOR        THRU 7800-EXIT          
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
              INITIALIZE  RS-OVSH-SEQ-NO                                
                          RS-OFST-OVER-AMT                              
                          RS-OFST-SHORT-AMT                             
                          RS-OFST-CASH-OFF                              
                          RS-OFST-CSH-RPT-DT                            
                          RS-OFST-CSH-DRWR                              
                          RS-OFST-OVSH-ID                               
REARCH        PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
              PERFORM 8100-SEND-RESULT    THRU 8100-EXIT                
           ELSE                                                         
              PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND           
                 MOVE OD-OVERSHORT-SEQ-NO       TO RS-OVSH-SEQ-NO       
                 MOVE OD-CASH-LOCAL-OFFICE      TO RS-OFST-CASH-OFF     
                 MOVE OD-DATE-CASH-REPORT       TO RS-OFST-CSH-RPT-DT   
                 MOVE OD-CASH-DRAWER-ID         TO RS-OFST-CSH-DRWR     
                 MOVE OD-OVERSHORT-ID           TO RS-OFST-OVSH-ID      
                                                                        
                 IF OD-OFST-DR-CR = WS-C                                
                   MOVE OD-OFST-OVERSHORT-AMT   TO RS-OFST-OVER-AMT     
                   MOVE ZERO                    TO RS-OFST-SHORT-AMT    
                 ELSE                                                   
                   MOVE ZERO                    TO RS-OFST-OVER-AMT     
                   MOVE OD-OFST-OVERSHORT-AMT   TO RS-OFST-SHORT-AMT    
                 END-IF                                                 
REARCH           PERFORM 2000A-MOVE-RESULT      THRU 2000A-EXIT         
                 PERFORM 8100-SEND-RESULT       THRU 8100-EXIT          
                 PERFORM 7800-FETCH-SOL-CURSOR  THRU 7800-EXIT          
              END-PERFORM                                               
           END-IF                                                       
           PERFORM 7900-CLOSE-SOL-CURSOR        THRU 7900-EXIT          
           .                                                            
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7100-OPEN-OVSH-CURSSOR                                      *        
      *       OPEN THE OV_SH_CURSOR                                    *        
      ******************************************************************        
                                                                        
       7100-OPEN-OVSH-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN OV_SH_CURSOR                                       
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  RS-RETURN-CODE        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_OVERSHORT_HDR'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE OH-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7200-FETCH-OVSH-CURSOR                                      *        
      *       FETCH THE OV_SH_CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7200-FETCH-OVSH-CURSOR.                                          
           EXEC SQL                                                     
                FETCH OV_SH_CURSOR                                      
                 INTO :OH-CASH-LOCAL-OFFICE                             
                      ,:OH-DATE-CASH-REPORT                             
                      ,:OH-CASH-DRAWER-ID                               
                      ,:OH-USER-ID                                      
                      ,:OH-OVERSHORT-ID                                 
                      ,:OH-TRAN-TS                                      
                      ,:OH-OVERSHORT-AMT                                
                      ,:OH-OVERSHORT-DR-CR                              
                      ,:OH-OFST-OVERSHORT-AMT                           
                      ,:OH-OFST-DR-CR                                   
                      ,:OH-GL-ACCT-NO                                   
                      ,:OH-LAST-UPDATE-TS                               
                      ,:OH-OVERSHORT-TYPE-CD                            
                      ,:OH-OVERSHORT-SOLTN-FL                           
                      ,:OH-TRAN-COMMENT                                 
                      ,:OH-ACCOUNT-NO                                   
                      ,:PF-FIRST-NAME                                   
                      ,:PF-LAST-NAME                                    
                      ,:PF-MIDDLE-NAME                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  RS-RETURN-CODE        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_OVERSHORT_HDR'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE OH-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7300-CLOSE-OVSH-CURSOR                                      *        
      *       CLOSE THE OV_SH_CURSOR                                   *        
      ******************************************************************        
       7300-CLOSE-OVSH-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE OV_SH_CURSOR                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                  RS-RETURN-CODE        
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_OVERSHORT_HDR'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE OH-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7400-OPEN-DET-CURSOR                                        *        
      *       OPEN OV_SH_DET CURSOR                                    *        
      ******************************************************************        
       7400-OPEN-DET-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
                OPEN OV_SH_DET                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_OVERSHORT_DET'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE 'OVERSHORT_ID'             TO TABLE-ELEMENT-4       
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE OH-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE OH-OVERSHORT-ID            TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7500-FETCH-DET-CURSOR                                       *        
      *       FETCH OV_SH_DET CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7500-FETCH-DET-CURSOR.                                           
           EXEC SQL                                                     
                FETCH OV_SH_DET                                         
                 INTO :OD-OVERSHORT-SEQ-NO                              
                      ,:OD-OFST-OVERSHORT-AMT                           
                      ,:OD-OFST-DR-CR                                   
                      ,:OD-OFST-COMPANY-NO                              
                      ,:OD-OFST-LOC-OFCE                                
                      ,:OD-OFST-CASH-REPT-DT                            
                      ,:OD-OFST-CASH-DRWR-ID                            
                      ,:OD-OFST-OVERSHORT-ID                            
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7500'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_OVERSHORT_DET'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE 'OVERSHORT_ID'             TO TABLE-ELEMENT-4       
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE OH-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE OH-OVERSHORT-ID            TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7600-CLOSE-DET-CURSOR                                       *        
      *       CLOSE THE OV_SH_DET CURSOR                               *        
      ******************************************************************        
       7600-CLOSE-DET-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                CLOSE OV_SH_DET                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7600'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_OVERSHORT_HDR'        TO TABLE-1               
               MOVE 'CSS_OVERSHORT_DET'        TO TABLE-1               
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-1       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-2       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE 'OVERSHORT_ID'             TO TABLE-ELEMENT-4       
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE OH-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE OH-OVERSHORT-ID            TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7700-OPEN-SOL-CURSOR                                        *        
      *       OPEN OV_SH_SOL CURSOR                                    *        
      ******************************************************************        
       7700-OPEN-SOL-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
                OPEN OV_SH_SOL                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7700'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_OVERSHORT_DET'        TO TABLE-1               
               MOVE 'OFST_LOC_OFCE'            TO TABLE-ELEMENT-1       
               MOVE 'OFST_CASH_REPT_DT'        TO TABLE-ELEMENT-2       
               MOVE 'OFST_CASH_DRWR_ID'        TO TABLE-ELEMENT-3       
               MOVE 'OFST_OVERSHORT_ID'        TO TABLE-ELEMENT-4       
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE OH-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE OH-OVERSHORT-ID            TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7800-FETCH-SOL-CURSOR                                       *        
      *       FETCH OV_SH_SOL CURSOR                                   *        
      *                                                                *        
      ******************************************************************        
       7800-FETCH-SOL-CURSOR.                                           
           EXEC SQL                                                     
                FETCH OV_SH_SOL                                         
                 INTO :OD-CASH-COMPANY-NO                               
                      ,:OD-CASH-LOCAL-OFFICE                            
                      ,:OD-DATE-CASH-REPORT                             
                      ,:OD-CASH-DRAWER-ID                               
                      ,:OD-OVERSHORT-ID                                 
                      ,:OD-OVERSHORT-SEQ-NO                             
                      ,:OD-OFST-OVERSHORT-AMT                           
                      ,:OD-OFST-DR-CR                                   
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7800'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_OVERSHORT_DET'        TO TABLE-1               
               MOVE 'OFST_LOC_OFCE'            TO TABLE-ELEMENT-1       
               MOVE 'OFST_CASH_REPT_DT'        TO TABLE-ELEMENT-2       
               MOVE 'OFST_CASH_DRWR_ID'        TO TABLE-ELEMENT-3       
               MOVE 'OFST_OVERSHORT_ID'        TO TABLE-ELEMENT-4       
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE OH-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE OH-OVERSHORT-ID            TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7900-CLOSE-SOL-CURSOR                                       *        
      *       CLOSE THE OV_SH_SOL CURSOR                               *        
      ******************************************************************        
       7900-CLOSE-SOL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                CLOSE OV_SH_SOL                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7900'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_OVERSHORT_DET'        TO TABLE-1               
               MOVE 'OFST_LOC_OFCE'            TO TABLE-ELEMENT-1       
               MOVE 'OFST_CASH_REPT_DT'        TO TABLE-ELEMENT-2       
               MOVE 'OFST_CASH_DRWR_ID'        TO TABLE-ELEMENT-3       
               MOVE 'OFST_OVERSHORT_ID'        TO TABLE-ELEMENT-4       
               MOVE OH-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1     
               MOVE OH-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2     
               MOVE OH-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE OH-OVERSHORT-ID            TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF                                                       
           .                                                            
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS                                           *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH      MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH      EXEC SQL                                                    
REARCH          DELETE FROM #CSR02411_R1                         
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*         DELETE FROM SESSION.CSR02411_R1                                 
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.     
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         NEXT SENTENCE                                            
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME          TO  ABEND-PROGRAM             
REARCH         MOVE '8000A'               TO  ACTIVE-PARAGRAPH          
REARCH         MOVE 'DELETE'              TO  ABEND-FUNCTION            
REARCH         MOVE SQLCODE               TO  ABEND-SQLCODE             
REARCH         MOVE SPACES                TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH         MOVE 'CSR02411_R1'         TO  TABLE-1                   
REARCH         MOVE SPACES                TO  TABLE-ELEMENT-1           
REARCH         MOVE SPACES                TO  HOSTVAR-ELEMENT-1         
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH      END-IF.                                                     
REARCH*                                                                         
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT                                                *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH      EXEC SQL                                                    
REARCH           INSERT INTO #CSR02411_R1                        
REARCH           (                                                      
REARCH                RETURN_CODE                                       
REARCH               ,CASH_LOCAL_OFFICE                                 
REARCH               ,DATE_CASH_REPORT                                  
REARCH               ,CASH_DRAWER_ID                                    
REARCH               ,GL_ACCOUNT_NO                                     
REARCH               ,OVERSHORT_ID                                      
REARCH               ,OFST_OV_AMT                                       
REARCH               ,OFST_SH_AMT                                       
REARCH               ,OVERAGE_AMT                                       
REARCH               ,SHORTAGE_AMT                                      
REARCH               ,ACCOUNT_NO                                        
REARCH               ,OVSH_SOLTN_FL                                     
REARCH               ,OVSH_TYPE_CD                                      
REARCH               ,TRAN_COMMENT                                      
REARCH               ,USER_ID                                           
REARCH               ,TRAN_TS                                           
REARCH               ,LAST_UPDATE_TS                                    
REARCH               ,OVSH_SEQ_NO                                       
REARCH               ,OFST_OVER_AMT                                     
REARCH               ,OFST_SHORT_AMT                                    
REARCH               ,OFST_CASH_OFF                                     
REARCH               ,OFST_CSH_RPT_DT                                   
REARCH               ,OFST_CSH_DRWR                                     
REARCH               ,OFST_OVSH_ID                                      
REARCH               ,MULTI_BATCH_IND                                   
REARCH               ,FULL_NAME                                         
REARCH           )                                                      
REARCH           VALUES                                                 
REARCH           (                                                      
REARCH                 :S-RETURN-CODE                                   
REARCH                ,:S-CASH-LOCAL-OFFICE                             
REARCH                ,:S-DATE-CASH-REPORT                              
REARCH                ,:S-CASH-DRAWER-ID                                
REARCH                ,:S-GL-ACCOUNT-NO                                 
REARCH                ,:S-OVERSHORT-ID                                  
REARCH                ,:S-OFST-OV-AMT                                   
REARCH                ,:S-OFST-SH-AMT                                   
REARCH                ,:S-OVERAGE-AMT                                   
REARCH                ,:S-SHORTAGE-AMT                                  
REARCH                ,:S-ACCOUNT-NO                                    
REARCH                ,:S-OVSH-SOLTN-FL                                 
REARCH                ,:S-OVSH-TYPE-CD                                  
REARCH                ,:S-TRAN-COMMENT                                  
REARCH                ,:S-USER-ID                                       
REARCH                ,:S-TRAN-TS                                       
REARCH                ,:S-LAST-UPDATE-TS                                
REARCH                ,:S-OVSH-SEQ-NO                                   
REARCH                ,:S-OFST-OVER-AMT                                 
REARCH                ,:S-OFST-SHORT-AMT                                
REARCH                ,:S-OFST-CASH-OFF                                 
REARCH                ,:S-OFST-CSH-RPT-DT                               
REARCH                ,:S-OFST-CSH-DRWR                                 
REARCH                ,:S-OFST-OVSH-ID                                  
REARCH                ,:S-MULTI-BATCH-IND                               
REARCH                ,:S-FULL-NAME                                     
REARCH           )                                                      
REARCH       END-EXEC.                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                            
MFA-TR*          INSERT INTO SESSION.CSR02411_R1                                
MFA-TR*          (                                                              
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,CASH_LOCAL_OFFICE                                         
MFA-TR*              ,DATE_CASH_REPORT                                          
MFA-TR*              ,CASH_DRAWER_ID                                            
MFA-TR*              ,GL_ACCOUNT_NO                                             
MFA-TR*              ,OVERSHORT_ID                                              
MFA-TR*              ,OFST_OV_AMT                                               
MFA-TR*              ,OFST_SH_AMT                                               
MFA-TR*              ,OVERAGE_AMT                                               
MFA-TR*              ,SHORTAGE_AMT                                              
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*              ,OVSH_SOLTN_FL                                             
MFA-TR*              ,OVSH_TYPE_CD                                              
MFA-TR*              ,TRAN_COMMENT                                              
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,TRAN_TS                                                   
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,OVSH_SEQ_NO                                               
MFA-TR*              ,OFST_OVER_AMT                                             
MFA-TR*              ,OFST_SHORT_AMT                                            
MFA-TR*              ,OFST_CASH_OFF                                             
MFA-TR*              ,OFST_CSH_RPT_DT                                           
MFA-TR*              ,OFST_CSH_DRWR                                             
MFA-TR*              ,OFST_OVSH_ID                                              
MFA-TR*              ,MULTI_BATCH_IND                                           
MFA-TR*              ,FULL_NAME                                                 
MFA-TR*          )                                                              
MFA-TR*          VALUES                                                         
MFA-TR*          (                                                              
MFA-TR*                :S-RETURN-CODE                                           
MFA-TR*               ,:S-CASH-LOCAL-OFFICE                                     
MFA-TR*               ,:S-DATE-CASH-REPORT                                      
MFA-TR*               ,:S-CASH-DRAWER-ID                                        
MFA-TR*               ,:S-GL-ACCOUNT-NO                                         
MFA-TR*               ,:S-OVERSHORT-ID                                          
MFA-TR*               ,:S-OFST-OV-AMT                                           
MFA-TR*               ,:S-OFST-SH-AMT                                           
MFA-TR*               ,:S-OVERAGE-AMT                                           
MFA-TR*               ,:S-SHORTAGE-AMT                                          
MFA-TR*               ,:S-ACCOUNT-NO                                            
MFA-TR*               ,:S-OVSH-SOLTN-FL                                         
MFA-TR*               ,:S-OVSH-TYPE-CD                                          
MFA-TR*               ,:S-TRAN-COMMENT                                          
MFA-TR*               ,:S-USER-ID                                               
MFA-TR*               ,:S-TRAN-TS                                               
MFA-TR*               ,:S-LAST-UPDATE-TS                                        
MFA-TR*               ,:S-OVSH-SEQ-NO                                           
MFA-TR*               ,:S-OFST-OVER-AMT                                         
MFA-TR*               ,:S-OFST-SHORT-AMT                                        
MFA-TR*               ,:S-OFST-CASH-OFF                                         
MFA-TR*               ,:S-OFST-CSH-RPT-DT                                       
MFA-TR*               ,:S-OFST-CSH-DRWR                                         
MFA-TR*               ,:S-OFST-OVSH-ID                                          
MFA-TR*               ,:S-MULTI-BATCH-IND                                       
MFA-TR*               ,:S-FULL-NAME                                             
MFA-TR*          )                                                              
MFA-TR*      END-EXEC.                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH       MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                     
REARCH*                                                                         
REARCH       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
REARCH          ADD +1                    TO  CTR-ROWS                  
REARCH       ELSE                                                       
REARCH          MOVE PROGRAM-NAME         TO  ABEND-PROGRAM             
REARCH          MOVE '8100'               TO  ACTIVE-PARAGRAPH          
REARCH          MOVE 'INSERT'             TO  ABEND-FUNCTION            
REARCH          MOVE SQLCODE              TO  ABEND-SQLCODE             
REARCH          MOVE SPACES               TO  ABEND-SQL-PREDICATES      
REARCH                                        ABEND-TABLES              
REARCH          MOVE 'CSR02411_R1'        TO  TABLE-1                   
REARCH          MOVE SPACES               TO  TABLE-ELEMENT-1           
REARCH          MOVE SPACES               TO  HOSTVAR-ELEMENT-1         
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH       END-IF.                                                    
REARCH*                                                                         
REARCH  8100-EXIT.                                                      
REARCH      EXIT.                                                       
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************16263003
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *16265003
      ******************************************************************16267003
REARCH*    EXEC SQL                                                     16269003
REARCH*       INCLUDE CPD00300                                          16270003
REARCH*    END-EXEC.                                                    16280003
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ******************************************************************16310003
      *       END PROGRAM COPYLIB                                      *16330003
      ******************************************************************16360003
                                                                        
REARCH*COPY CPD00302.                                                   16361003
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
      *                                                                         
