       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02399.                                         
COB303 DATE-WRITTEN.      SEPTEMBER 20, 1999.                           
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S399 CONVERTED TO DB2 SP CSR02399 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S399                                           *        
      *  PROGRAM:       S399                                           *        
      *  CALLING SP:    PA_S399                                        *        
      *  PANEL NO:      005                                            *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.  THE PROGRAM UPDATES  *        
      *  THE CUSTOMER NUMBER FOR AN ACCOUNT THAT HAS MORE THAN ONE     *        
      *  CUSTOMER NUMBER.                                              *        
      *                                                                *        
      *  THIS PROGRAM UPDATES CSS_CSH_DRWR_JRNL                        *        
      *                       CSS_CUST_COMM_MF                         *        
      *                       CSS_WQ_ITEMS_MF                          *        
      *                       CSS_MNT_TRANS_HIST                       *        
      *                       CSS_NAME_ACCT_XREF                       *        
      *                       CSS_OFF_CYCL_ACCT                        *        
      *                       CSS_BANK_EFT                             *        
      *                       CSS_BILLING_HDR                          *        
      *                       CSS_CUST_PREM_HIST                       *        
      *                       CSS_BATCH_JRNL                           *        
      *                       CSS_MISC_JRNL                            *        
      *                       CSS_ACCOUNT                              *        
      *                       CSS_CUST_STATS                           *        
      *                       CSS_BILL_ADDR_XREF                       *        
      *                       CSS_LANDLORD                             *        
T28358*                       CSS_COLL_ACCT_INFO                       *        
REARCH*                       CSS_WQ_ITEMS                             *        
T30585*                       CSS_COAPPLICANT                          *        
T30585*                       CSS_IVR_NOTICE                           *        
T30585*                       CSS_REG_PROFILE                          *        
T30585*                       CSS_ROOMMATE                             *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *     DATE    INITIALS   COMMENTS                                *        
      *  ----------  ------   ---------------------------------------  *        
      *  09/20/1999    SK     CREATED.                                 *        
T21688*  02/22/2000    SK     ADDED DETAIL ROW TO CUST TRANS HIST      *        
T21759*  03/02/2000    SK     SPOUSE RECORD FOR OLD CUSTOMER IS        *        
T21759*                       DELETED AFTER IT IS INSERTED FOR NEW     *        
T21759*                       CUSTOMER IN CSS_CUST_STATS               *        
T22880*  12/08/2000    SK     CHANGED APPL_PROGRAM_ID IN MAINT TRANS   *        
T22880*                       HIST FROM 'CUST NBR CONS' TO 'PANEL005'  *        
T23455*  01/16/2001    SK     NO CHANGES MADE TO CODE, BUT AN INDEX    *        
T23455*                       FOR ACCOUNT_NO WAS ADDED TO              *        
T23455*                       CSS_CSH_DRWR_JRNL FOR RESPONSE TIME.     *        
T23539*  04/26/2001    SK     REMOVED HARD-CODED COMPANY NUMBER OF 01  *        
T23539*                       AND NOW USE THE ACCOUNT'S COMPANY #      *        
T25687*  12/26/2001    DD     ADDED UPDATE PARAGRAPH FOR               *        
T25687*                       CSS_BILL_ADDR_XREF TO ALLOW CUSTOMER     *        
T25687*                       RECORDS WITH BILLING ADDRESS INFO TO BE  *        
T25687*                       DELETED                                  *        
C25965*  04/08/02      RR     UPDATE CUSTOMER_NO ON CSS_LANDLORD       *        
T26305*  08/16/02      RR     CHANGE 2030- PARAGRAPH TO UPDATE         *        
T26305*                       CSS_COMM_DATA                            *        
T28358*  02/12/03      DD     UPDATE CUSTOMER_NO ON CSS_COLL_ACCT_INFO *        
      *                                                                *        
REARCH*  07/10/03    SK88120  CHANGES WERE MADE TO UPDATE CSS_WQ_ITEMS *        
      *                                                                *        
T30585*  03/26/04    DD19702  ADDED UPDATES TO CUSTOMER_NO IN          *        
T30585*                   CSS_ROOMMATE, CSS_IVR_NOTICE, CSS_REG_PROFILE*        
T30585*                   AND CSS_COAPPLICANT                          *        
C29943*  05/12/04      FMB    ADDED UPDATE OF CUSTOMER_NO FOR          *        
C29943*                       CSS_SEB_MIA_XREF                         *        
C31606*  05/05/05  PD80186 EPAY/DRAFT CUSTOMER CHANGES                          
PERFOR*  03/28/07  VIJAY   PERFORMANCE CHANGES                                  
C35344*  02/08/08  SC41135 CHANGES TO HANDLE SPOUSE RECORDS PROPERLY   *        
A00998*  04/13/09  MSR     COPY CREDIT INFORMATION TO THE NEW CUSTOMER.*        
A01255*  06/08/09  FMB     ADDED UPDATE OF CUSTOMER_NO FOR             *        
A01255*                    CSS_PREM_GAS_LINE                           *        
A02665*  09/02/10  FMB     CONSOLIDATE SPOUSE PHONE NUMBER.            *        
P00594*  04/08/13  FMB     TWO NEW COLUMNS ON CSS_NAME_ACCT_XREF       *        
P00740*  12/05/13  BD09555 CHANGE CUSTOMER NUMBER ON CSS_CORRESP_HDR   *        
P00740*                    CSS_CORR_MAIL_STAT, AND CSS_ACCESS_HISTORY  *        
P00740*                    TABLES                                      *        
A04860*  03/05/15  MR7E794 REMOVE THE TABLE CSS_WQ_ITEMS_MF            *        
A04860*            ACT070                                              *        
A05317*  11/17/15  FMB     UPDATE CUSTOMER_NO ON CSS_CUST_ADDR_XREF    *        
I02073*  12/02/15  VV      ADVANCED ENERGY PLUS CHANGES TO ADD NEW FIELD        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02399'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S399 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBLLHDR                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBNKEFT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCOAPP                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBOFFCYL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
T23605        INCLUDE TBCOMDAT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBNMACTX                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCUST                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTPRM                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBCSTSTS                                                  
           END-EXEC.                                                            
                                                                        
T25687     EXEC SQL                                                             
T25687        INCLUDE TBBLADRX                                                  
T25687     END-EXEC.                                                            
                                                                        
C25965     EXEC SQL                                                             
C25965        INCLUDE TBLNDLRD                                                  
C25965     END-EXEC.                                                            
                                                                        
T28358     EXEC SQL                                                             
T28358        INCLUDE TBACCINF                                                  
T28358     END-EXEC.                                                            
                                                                        
C29943     EXEC SQL                                                             
C29943        INCLUDE TBMIAXRF                                                  
C29943     END-EXEC.                                                            
                                                                        
A01255     EXEC SQL                                                             
A01255        INCLUDE TBPREMLN                                                  
A01255     END-EXEC.                                                            
                                                                        
PD186      EXEC SQL                                                             
              INCLUDE TBPDBKDF                                                  
           END-EXEC.                                                            
                                                                        
C35344     EXEC SQL                                                             
C35344        INCLUDE TBNAME                                                    
C35344     END-EXEC.                                                            
                                                                        
A00998     EXEC SQL                                                             
A00998        INCLUDE TBCRHIST                                                  
A00998     END-EXEC.                                                            
A00998                                                                  
A00998     EXEC SQL                                                             
A00998        INCLUDE TBCRITPA                                                  
A00998     END-EXEC.                                                            
A00998                                                                  
           EXEC SQL                                                             
              INCLUDE TBCSTBNK                                                  
PD186      END-EXEC.                                                            
                                                                        
A05317     EXEC SQL                                                             
A05317        INCLUDE TBCSADRX                                                  
A05317     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                     
             DECLARE HT_CURSOR CURSOR FOR                               
               SELECT CUSTOMER_NO, NAME_ID                              
               FROM CSS_NAME_ACCT_XREF                                  
               WHERE ACCOUNT_NO =:HT-ACCOUNT-NO                         
               FOR UPDATE OF CUSTOMER_NO, NAME_ID                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE HT_CURSOR CURSOR FOR                                       
MFA-TR*        SELECT CUSTOMER_NO, NAME_ID                                      
MFA-TR*        FROM CSS_NAME_ACCT_XREF                                          
MFA-TR*        WHERE ACCOUNT_NO =:HT-ACCOUNT-NO                                 
MFA-TR*        FOR UPDATE OF CUSTOMER_NO, NAME_ID                               
MFA-TR*        QUERYNO 2060                                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
A00998     EXEC SQL                                                     
A00998       DECLARE CR_CURSOR CURSOR FOR                               
A00998         SELECT CUSTOMER_NO                                       
A00998               ,CR_HIST_TRAN_DT                                   
A00998               ,REPLACE(CONVERT(CHAR(8), CR_HIST_TRAN_TM, 108), 
           ':', '.') CR_HIST_TRAN_TM                                   
A00998               ,USER_ID_CR_INIT_BY                                
A00998               ,BEACON_SCORE                                      
A00998               ,CR_RQST_REASON_CD                                 
A00998               ,CR_BUREAU_CD                                      
A00998               ,CR_ACTION_FL                                      
A00998               ,CR_COMMENTS                                       
A00998               ,VENDOR_COMMENTS                                   
A00998               ,ADV_CREDIT_LTR                                    
A00998               ,REG_GROUP_CD                                      
A00998               ,ADV_CREDIT_LTR_DT                                 
A00998               ,CUST_NAME_FIRST                                   
A00998               ,CUST_NAME_LAST                                    
A00998               ,CUST_NAME_MID                                     
A00998               ,CUST_NAME_SFX                                     
A00998               ,ITPA_EXISTS_CD                                    
A00998               ,CR_CHK_COMPANY_NO                                 
A00998               ,ACCT_REVIEW_ACT_CD                                
A00998               ,ACCT_REVIEW_RET_DT                                
A00998               ,ADDR_DISCREP_FL                                   
A00998               ,SENIOR_FL                                         
A00998               ,APPL_STATUS_CD                                    
A00998               ,CB_HIT_CD                                         
A00998               ,CB_MATCH_CD                                       
A00998               ,CB_SAFESCAN_CD                                    
A00998               ,CB_FORMAT_ERR_CD                                  
A00998               ,CB_PROCESS_ERR_CD                                 
A00998               ,CB_VALIDITY_ERR_CD                                
A00998               ,DRIVERS_LIC_ST_CD                                 
A00998               ,DRIVERS_LICENSE_NO                                
A00998               ,FIRST_NAME                                        
A00998               ,MIDDLE_NAME                                       
A00998               ,LAST_NAME                                         
A00998               ,TITLE_SUFFIX_1                                    
A00998               ,DATE_OF_BIRTH                                     
A00998               ,SSN                                               
A00998               ,CB_SSN                                            
A00998               ,CB_SSN_BIRTH_DT                                   
A00998               ,CB_SSN_AGE                                        
A00998               ,CB_SSN_ISSUE_DT                                   
A00998               ,CB_SSN_ISSUE_ST_CD                                
A00998               ,CB_SSN_VERIFIED_FL                                
A00998               ,CB_SSN_INQUIRY                                    
A00998               ,CB_SSN_DEATH_DT                                   
A00998               ,CB_SSN_DEATH_ST_CD                                
A00998               ,CB_EMPLOYER                                       
A00998               ,CB_EMPLOYER_CITY                                  
A00998               ,CB_BEACON_REJ_CD                                  
A00998               ,CB_BEACON_AA1_CD                                  
A00998               ,CB_BEACON_AA2_CD                                  
A00998               ,CB_BEACON_AA3_CD                                  
A00998               ,CB_BEACON_AA4_CD                                  
A00998               ,CR_SCORE_UPDATE_FL                                
A00998               ,CR_SCORE_TYPE_CD                                  
A00998               ,CR_SCORE_CD                                       
I02073               ,ADDL_CRED_SCORE                                   
I02073               ,SCORE_MODEL_CD                                    
I02073               ,ACCOUNT_NO                                        
A00998         FROM CSS_CREDIT_HIST                                     
A00998        WHERE CUSTOMER_NO = :CK-CUSTOMER-NO                       
                                                            
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE CR_CURSOR CURSOR FOR                                       
MFA-TR*        SELECT CUSTOMER_NO                                               
MFA-TR*              ,CR_HIST_TRAN_DT                                           
MFA-TR*              ,CR_HIST_TRAN_TM                                           
MFA-TR*              ,USER_ID_CR_INIT_BY                                        
MFA-TR*              ,BEACON_SCORE                                              
MFA-TR*              ,CR_RQST_REASON_CD                                         
MFA-TR*              ,CR_BUREAU_CD                                              
MFA-TR*              ,CR_ACTION_FL                                              
MFA-TR*              ,CR_COMMENTS                                               
MFA-TR*              ,VENDOR_COMMENTS                                           
MFA-TR*              ,ADV_CREDIT_LTR                                            
MFA-TR*              ,REG_GROUP_CD                                              
MFA-TR*              ,ADV_CREDIT_LTR_DT                                         
MFA-TR*              ,CUST_NAME_FIRST                                           
MFA-TR*              ,CUST_NAME_LAST                                            
MFA-TR*              ,CUST_NAME_MID                                             
MFA-TR*              ,CUST_NAME_SFX                                             
MFA-TR*              ,ITPA_EXISTS_CD                                            
MFA-TR*              ,CR_CHK_COMPANY_NO                                         
MFA-TR*              ,ACCT_REVIEW_ACT_CD                                        
MFA-TR*              ,ACCT_REVIEW_RET_DT                                        
MFA-TR*              ,ADDR_DISCREP_FL                                           
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*              ,APPL_STATUS_CD                                            
MFA-TR*              ,CB_HIT_CD                                                 
MFA-TR*              ,CB_MATCH_CD                                               
MFA-TR*              ,CB_SAFESCAN_CD                                            
MFA-TR*              ,CB_FORMAT_ERR_CD                                          
MFA-TR*              ,CB_PROCESS_ERR_CD                                         
MFA-TR*              ,CB_VALIDITY_ERR_CD                                        
MFA-TR*              ,DRIVERS_LIC_ST_CD                                         
MFA-TR*              ,DRIVERS_LICENSE_NO                                        
MFA-TR*              ,FIRST_NAME                                                
MFA-TR*              ,MIDDLE_NAME                                               
MFA-TR*              ,LAST_NAME                                                 
MFA-TR*              ,TITLE_SUFFIX_1                                            
MFA-TR*              ,DATE_OF_BIRTH                                             
MFA-TR*              ,SSN                                                       
MFA-TR*              ,CB_SSN                                                    
MFA-TR*              ,CB_SSN_BIRTH_DT                                           
MFA-TR*              ,CB_SSN_AGE                                                
MFA-TR*              ,CB_SSN_ISSUE_DT                                           
MFA-TR*              ,CB_SSN_ISSUE_ST_CD                                        
MFA-TR*              ,CB_SSN_VERIFIED_FL                                        
MFA-TR*              ,CB_SSN_INQUIRY                                            
MFA-TR*              ,CB_SSN_DEATH_DT                                           
MFA-TR*              ,CB_SSN_DEATH_ST_CD                                        
MFA-TR*              ,CB_EMPLOYER                                               
MFA-TR*              ,CB_EMPLOYER_CITY                                          
MFA-TR*              ,CB_BEACON_REJ_CD                                          
MFA-TR*              ,CB_BEACON_AA1_CD                                          
MFA-TR*              ,CB_BEACON_AA2_CD                                          
MFA-TR*              ,CB_BEACON_AA3_CD                                          
MFA-TR*              ,CB_BEACON_AA4_CD                                          
MFA-TR*              ,CR_SCORE_UPDATE_FL                                        
MFA-TR*              ,CR_SCORE_TYPE_CD                                          
MFA-TR*              ,CR_SCORE_CD                                               
MFA-TR*              ,ADDL_CRED_SCORE                                           
MFA-TR*              ,SCORE_MODEL_CD                                            
MFA-TR*              ,ACCOUNT_NO                                                
MFA-TR*        FROM CSS_CREDIT_HIST                                             
MFA-TR*       WHERE CUSTOMER_NO = :CK-CUSTOMER-NO                               
MFA-TR*        QUERYNO 7170                                                     
MFA-TR*    END-EXEC.                                                            
A00998                                                                  
A00998     EXEC SQL                                                     
A00998       DECLARE ITPA_CUR CURSOR FOR                                
A00998         SELECT ALERT_TYPE_CD                                     
A00998               ,CONTACT_INFO_FL                                   
A00998               ,CR_HIST_TRAN_DT                                   
A00998               ,REPLACE(CONVERT(CHAR(8), CR_HIST_TRAN_TM, 108), 
           ':', '.') CR_HIST_TRAN_TM                                   
A00998               ,CUSTOMER_NO                                       
A00998               ,ITPA_ADDTNL_INFO                                  
A00998               ,ITPA_EFFECTIVE_DT                                 
A00998               ,ITPA_REPORT_DT                                    
A00998               ,ITPA_RSLT_CURR_CD                                 
A00998               ,ITPA_RSLT_ORIG_CD                                 
A00998               ,REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
A00998               ,LAST_UPDATE_USERID                                
A00998               ,LETTER_MAILED_DT                                  
A00998               ,LETTER_NOTIFY_CD                                  
A00998               ,RESOLUTION_DT                                     
A00998         FROM CSS_CRED_ITPA_HIST                                  
A00998        WHERE CUSTOMER_NO = :LF-CUSTOMER-NO                       
                                                            
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ITPA_CUR CURSOR FOR                                        
MFA-TR*        SELECT ALERT_TYPE_CD                                             
MFA-TR*              ,CONTACT_INFO_FL                                           
MFA-TR*              ,CR_HIST_TRAN_DT                                           
MFA-TR*              ,CR_HIST_TRAN_TM                                           
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,ITPA_ADDTNL_INFO                                          
MFA-TR*              ,ITPA_EFFECTIVE_DT                                         
MFA-TR*              ,ITPA_REPORT_DT                                            
MFA-TR*              ,ITPA_RSLT_CURR_CD                                         
MFA-TR*              ,ITPA_RSLT_ORIG_CD                                         
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,LETTER_MAILED_DT                                          
MFA-TR*              ,LETTER_NOTIFY_CD                                          
MFA-TR*              ,RESOLUTION_DT                                             
MFA-TR*        FROM CSS_CRED_ITPA_HIST                                          
MFA-TR*       WHERE CUSTOMER_NO = :LF-CUSTOMER-NO                               
MFA-TR*        QUERYNO 7210                                                     
MFA-TR*    END-EXEC.                                                            
A00998                                                                  
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
           COPY CCA00001.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9)  USAGE COMP.           
           05  PARM-USER-ID            PIC X(07)  VALUE SPACES.         
           05  PARM-ACCOUNT-NO         PIC X(13).                       
           05  PARM-CUSTOMER-NO        PIC X(10).                       
           05  PARM-NEW-CUST-NO        PIC X(10).                       
           05  PARM-OLD-CUST-NAME      PIC X(75).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME            PIC X(08) VALUE 'S399    '.      
           05  WS-ACCOUNT-NO           PIC X(13).                       
           05  WS-ACCOUNT-DEC REDEFINES WS-ACCOUNT-NO PIC 9(13).        
COB305     05 WS-ACCOUNT-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-NEW-CUST-NO          PIC X(10).                       
           05  WS-NEW-CUST-DEC REDEFINES WS-NEW-CUST-NO  PIC 9(10).     
COB305     05 WS-NEW-CUST-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-CUSTOMER-NO          PIC X(10).                       
           05  WS-CUSTOMER-DEC REDEFINES WS-CUSTOMER-NO PIC 9(10).      
COB305     05 WS-CUSTOMER-NUM        PIC S9(10)V USAGE COMP-3 VALUE 0.        
           05  WS-USERID               PIC X(7).                        
COB305     05 WS-OLD-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-NEW-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-OLD-SP-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
COB305     05 WS-NEW-SP-NAME-ID        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-NULL-IND1            PIC S9(04) COMP.                 
           05  WS-NULL-IND2            PIC S9(04) COMP.                 
           05  WS-NULL-IND3            PIC S9(04) COMP.                 
A00998     05  WS-NULL-IND4            PIC S9(04) COMP.                 
A00998     05  WS-NULL-IND5            PIC S9(04) COMP.                 
A00998     05  WS-NULL-IND6            PIC S9(04) COMP.                 
A00998     05  WS-NULL-IND7            PIC S9(04) COMP.                 
A00998     05  WS-NULL-IND8            PIC S9(04) COMP.                 
A00998     05  WS-NULL-IND9            PIC S9(04) COMP.                 
A00998     05  WS-NULL-IND10           PIC S9(04) COMP.                 
           05  MULTIPLE-ROWS-SELECTED  PIC S9(09) VALUE -811 COMP.      
           05  WS-OLD-SSN              PIC X(09).                       
T23539     05  WS-COMPANY-NO           PIC X(02).                       
      *    05  WS-OLD-CODE-ST-ID       PIC X(02).                               
      *    05  WS-OLD-DRVR-LIC-NO      PIC X(19).                               
      *    05  WS-OLD-DRVR-LIC-DT      PIC X(10) VALUE SPACES.                  
      *    05  WS-CHECK-DR-LIC-NO      PIC X(01) VALUE 'Y'.                     
      *    05  WS-CUST-TYPE-NEW        PIC X(01) VALUE SPACES.                  
      *    05  WS-CUST-TYPE-OLD        PIC X(01) VALUE SPACES.                  
      *    05  WS-OLD-DATE-BIRTH       PIC X(08) VALUE SPACES.                  
      *    05  WS-NEW-DATE-BIRTH       PIC X(08) VALUE SPACES.                  
      *    05  WS-OLD-EMPL-DATE        PIC X(08) VALUE SPACES.                  
      *    05  WS-NEW-EMPL-DATE        PIC X(08) VALUE SPACES.                  
      *    05  WS-OLD-EMPLOYER         PIC X(23) VALUE SPACES.                  
      *    05  WS-OLD-OCCUPATION       PIC X(15) VALUE SPACES.                  
      *    05  WS-OLD-OTHER-ID         PIC X(16) VALUE SPACES.                  
      *    05  WS-OLD-ID-TYPE          PIC X(12) VALUE SPACES.                  
PD186+     05  WS-CUST-BANK-SEQ-NO     PIC S9(9) USAGE COMP.            
           05  WS-NEW-CUST-BANK-SEQ    PIC S9(9) USAGE COMP.            
           05  WS-NEW-CUST-BANK-SEQ-CH PIC 9(9).                        
           05  WS-NEW-CUST-BANK-SEQ-01 PIC X(02).                       
           05  WS-UNDERSCORE           PIC X(01) VALUE '_'.             
           05  WS-IS-PEND-PAY          PIC X(01) VALUE '0'.             
           05  WS-NEW-ACCT-NICKNAME.                                    
               10 WS-NEW-ACCT-NICKNAME-LEN  PIC S9(4) USAGE COMP.       
PD186-         10 WS-NEW-ACCT-NICKNAME-TEXT PIC X(50).                  
      *                                                                         
      *01  WS-SELECT-DATE-FORM.                                                 
      *    10  WS-SELECT-YEAR          PIC X(04) VALUE SPACES.                  
      *    10  FILLER                  PIC X(01) VALUE SPACES.                  
      *    10  WS-SELECT-MONTH         PIC X(02) VALUE SPACES.                  
      *    10  FILLER                  PIC X(01) VALUE SPACES.                  
      *    10  WS-SELECT-DAY           PIC X(02) VALUE SPACES.                  
      *                                                                         
      *01  WS-RETURN-DATE-FORM.                                                 
      *    10  WS-RETURN-MONTH         PIC X(02) VALUE SPACES.                  
      *    10  WS-RETURN-DAY           PIC X(02) VALUE SPACES.                  
      *    10  WS-RETURN-YEAR          PIC X(04) VALUE SPACES.                  
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X(01) VALUE 'Y'.             
           05  WS-NO                   PIC X(01) VALUE 'N'.             
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05   S-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WS-MNT-TRANS-DET.                                            
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
A00998     05  WS-DEL-CRED-HIST        PIC X(01) VALUE 'N'.             
A00998         88 DEL-CRED-HIST                  VALUE 'Y'.             
A00998     05  WS-DEL-ITPA-HIST        PIC X(01) VALUE 'N'.             
A00998         88 DEL-ITPA-HIST                  VALUE 'Y'.             
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  RS-RETURN-CODE             PIC S9(9) COMP VALUE 0.       
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-USER-ID             PIC X(07)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-CUSTOMER-NO         PIC X(10)                .          
CVT000 01  LINK-NEW-CUST-NO         PIC X(10)                .          
CVT000 01  LINK-OLD-CUST-NAME       PIC X(75)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-USER-ID                                            
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-CUSTOMER-NO                                        
CVT000         ,LINK-NEW-CUST-NO                                        
CVT000         ,LINK-OLD-CUST-NAME                                      
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE         THRU 0100-EXIT.              
           PERFORM 1000-PROCESS-INPUT      THRU 1000-EXIT.              
PD186+     PERFORM 2000-PROCESS-OUTPUT-NEW THRU 2000-EXIT.              
           PERFORM 9999-END-PROGRAM        THRU 9999-EXIT.              
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :S-RETURN-CODE              AS    RETURN_CODE             
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :S-RETURN-CODE              AS    RETURN_CODE                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-USER-ID              TO PARM-USER-ID             . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-CUSTOMER-NO          TO PARM-CUSTOMER-NO         . 
CVT000     MOVE LINK-NEW-CUST-NO          TO PARM-NEW-CUST-NO         . 
CVT000     MOVE LINK-OLD-CUST-NAME        TO PARM-OLD-CUST-NAME       . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACCOUNT-NO           TO WS-ACCOUNT-NO.             
           MOVE WS-ACCOUNT-DEC            TO WS-ACCOUNT-NUM.            
           MOVE PARM-CUSTOMER-NO          TO WS-CUSTOMER-NO.            
           MOVE WS-CUSTOMER-DEC           TO WS-CUSTOMER-NUM.           
           MOVE PARM-NEW-CUST-NO          TO WS-NEW-CUST-NO.            
           MOVE WS-NEW-CUST-DEC           TO WS-NEW-CUST-NUM.           
           MOVE PARM-USER-ID              TO WS-USERID.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C31606******************************************************************        
C31606* 2000-PROCESS-OUTPUT-NEW.                                       *        
C31606******************************************************************        
                                                                        
C31606 2000-PROCESS-OUTPUT-NEW.                                         
                                                                        
C31606     MOVE '2000' TO ACTIVE-PARAGRAPH.                             
C31606     PERFORM 7161-SELECT-PNDNG-BNK-DRFT     THRU 7161-EXIT.       
C31606     IF WS-IS-PEND-PAY = '1'                                      
C31606        MOVE 1200 TO RS-RETURN-CODE                               
C35344                     S-RETURN-CODE                                
C31606        ADD 1 TO CTR-ROWS                                         
C31606        PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
C31606        PERFORM 9999-END-PROGRAM           THRU 9999-EXIT         
C31606     ELSE                                                         
C31606         CONTINUE                                                 
C31606     END-IF.                                                      
C31606     PERFORM 7162-GET-CUST-BANK-SEQ-NO      THRU 7162-EXIT.       
C31606     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C31606       PERFORM 7163-GET-BANK-INFO             THRU 7163-EXIT      
C31606       IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
C31606          PERFORM 7164-SELECT-NEW-CUST-RECORD    THRU 7164-EXIT   
C31606       END-IF                                                     
C31606     END-IF.                                                      
C31606     PERFORM 2001-PROCESS-OUTPUT    THRU 2001-EXIT.               
C31606 2000-EXIT.                                                       
C31605     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2001-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2001-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2001' TO ACTIVE-PARAGRAPH.                             
           PERFORM 2010-VALIDATE-NEW-CUSTOMER     THRU 2010-EXIT.       
           PERFORM 2011-CHECK-SSN                 THRU 2011-EXIT.       
      *    PERFORM 2012-CHECK-DRVR-LIC-NO         THRU 2012-EXIT.               
      *    PERFORM 2013-CHECK-OTHER-CUST-STATS    THRU 2013-EXIT.               
           PERFORM 2020-UPDATE-CSS-CSH-DRWR-JRNL  THRU 2020-EXIT.       
T26305     PERFORM 2030-UPDATE-CSS-COMM-DATA      THRU 2030-EXIT.       
REARCH     PERFORM 2045-UPDATE-CSS-WQ-ITEMS       THRU 2045-EXIT.       
           PERFORM 2050-UPDATE-CSS-MNT-TRANS-HIST THRU 2050-EXIT.       
           PERFORM 2060-UPDATE-CSS-NAME-ACCT-XREF THRU 2060-EXIT.       
           PERFORM 2070-UPDATE-CSS-OFF-CYCL-ACCT  THRU 2070-EXIT.       
           PERFORM 2080-SELECT-CSS-NAME-ACCT-XREF THRU 2080-EXIT.       
           PERFORM 2090-UPDATE-CSS-BANK-EFT       THRU 2090-EXIT.       
           PERFORM 2100-UPDATE-CSS-BILLING-HDR    THRU 2100-EXIT.       
T25687     PERFORM 2105-UPDATE-CSS-BILL-ADDR-XREF THRU 2105-EXIT.       
           PERFORM 2110-UPDATE-CSS-CUST-PREM-HIST THRU 2110-EXIT.       
           PERFORM 2120-UPDATE-CSS-BATCH-JRNL     THRU 2120-EXIT.       
           PERFORM 2130-UPDATE-CSS-MISC-JRNL      THRU 2130-EXIT.       
           PERFORM 2140-UPDATE-CSS-ACCOUNT        THRU 2140-EXIT.       
C25965     PERFORM 2145-UPDATE-CSS-LANDLORD       THRU 2145-EXIT.       
T28358     PERFORM 2146-UPDATE-CSS-COLL-ACCT-INFO THRU 2146-EXIT.       
T30585     PERFORM 2147-UPDATE-CSS-ROOMMATE       THRU 2147-EXIT.       
T30585     PERFORM 2148-UPDATE-CSS-IVR-NOTICE     THRU 2148-EXIT.       
T30585     PERFORM 2149-UPDATE-CSS-REG-PROFILE    THRU 2149-EXIT.       
T30585     PERFORM 2151-UPDATE-CSS-COAPPLICANT    THRU 2151-EXIT.       
C29943     PERFORM 2152-UPDATE-CSS-SEB-MIA-XREF   THRU 2152-EXIT.       
T30585     PERFORM 2153-UPDATE-CSS-NAME-ACCT-XREF THRU 2153-EXIT.       
A00998     PERFORM 2154-UPDATE-CREDIT-TABLES      THRU 2154-EXIT.       
A01255     PERFORM 2156-UPDATE-CSS-PREM-GAS-LINE  THRU 2156-EXIT.       
A05317     PERFORM 2157-UPDATE-CSS-CUST-ADDR-XREF THRU 2157-EXIT.       
           PERFORM 2150-SELECT-CSS-CUST-STATS     THRU 2150-EXIT.       
           PERFORM 2200-DELETE-CSS-NAME-ACCT-XREF THRU 2200-EXIT.       
C35344     PERFORM 2210-GET-SP-NAME-ACCT-XREF     THRU 2210-EXIT.       
C35344     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C35344        PERFORM 2220-SELECT-CSS-CUST-STATS     THRU 2220-EXIT     
C35344     END-IF.                                                      
           PERFORM 5000-MOVE-TRAN-HEAD            THRU 5000-EXIT.       
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
           PERFORM 8100-SEND-RESULT              THRU 8100-EXIT.        
                                                                        
       2001-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  VALIDATE THAT THE NEW CUSTOMER NUMBER DOES EXIST             *         
      *****************************************************************         
                                                                        
       2010-VALIDATE-NEW-CUSTOMER.                                      
                                                                        
           IF WS-NEW-CUST-NUM = WS-CUSTOMER-NUM                         
               MOVE 332 TO WS-ACTIVE-RETURN-CODE                        
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'IF'                  TO ABEND-FUNCTION             
               MOVE '2010'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'OLD CUST NUM'        TO TABLE-ELEMENT-1            
               MOVE 'NEW CUST NUM'        TO TABLE-ELEMENT-2            
               MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE WS-NEW-CUST-NUM TO CU-CUSTOMER-NO.                      
           EXEC SQL                                                     
               SELECT NAME_ID                                           
                 INTO :WS-NEW-NAME-ID                                   
                 FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
                 WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                    
PERFOR                                                           
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NAME_ID                                                   
MFA-TR*          INTO :WS-NEW-NAME-ID                                           
MFA-TR*          FROM CSS_CUSTOMER                                              
MFA-TR*          WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 20101                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE '2010'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                          ABEND-TABLES                  
               MOVE 'CSS_CUSTOMER'        TO TABLE-1                    
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
               MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE WS-CUSTOMER-NUM TO CU-CUSTOMER-NO.                      
           EXEC SQL                                                     
               SELECT NAME_ID                                           
                 INTO :WS-OLD-NAME-ID                                   
                 FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                        
                 WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                    
PERFOR                                                           
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NAME_ID                                                   
MFA-TR*          INTO :WS-OLD-NAME-ID                                           
MFA-TR*          FROM CSS_CUSTOMER                                              
MFA-TR*          WHERE CUSTOMER_NO = :CU-CUSTOMER-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*        QUERYNO 20102                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE '2010'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                          ABEND-TABLES                  
               MOVE 'CSS_CUSTOMER'        TO TABLE-1                    
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
               MOVE CU-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * CHECK SSN OF BOTH CUSTOMER NUMBERS TO MAKE SURE THEY MATCH.   *         
      *****************************************************************         
                                                                        
       2011-CHECK-SSN.                                                  
                                                                        
           EXEC SQL                                                     
               SELECT SSN                                               
               INTO   :CE-SSN                                           
               FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                      
               WHERE  CUSTOMER_NO = :WS-CUSTOMER-NUM                    
               AND    CUSTOMER_TYPE = 'C'                               
PERFOR                                                           
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN                                                       
MFA-TR*        INTO   :CE-SSN                                                   
MFA-TR*        FROM   CSS_CUST_STATS                                            
MFA-TR*        WHERE  CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        AND    CUSTOMER_TYPE = 'C'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 20111                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE '2011'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_CUST_STATS'      TO TABLE-1                    
               MOVE 'SSN'                 TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE CE-SSN                TO HOSTVAR-ELEMENT-1          
               MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE CE-SSN TO WS-OLD-SSN.                                   
C35344     MOVE SPACES TO CE-SSN                                        
           EXEC SQL                                                     
               SELECT SSN                                               
               INTO   :CE-SSN                                           
               FROM   CSS_CUST_STATS WITH(READUNCOMMITTED)                      
               WHERE  CUSTOMER_NO = :WS-NEW-CUST-NUM                    
               AND    CUSTOMER_TYPE = 'C'                               
PERFOR                                                           
                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT SSN                                                       
MFA-TR*        INTO   :CE-SSN                                                   
MFA-TR*        FROM   CSS_CUST_STATS                                            
MFA-TR*        WHERE  CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*        AND    CUSTOMER_TYPE = 'C'                                       
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 20112                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE '2011'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                          ABEND-TABLES                  
               MOVE 'CSS_CUST_STATS'      TO TABLE-1                    
               MOVE 'SSN'                 TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE CE-SSN                TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
C35344     IF CE-SSN NOT EQUAL SPACES                                   
           EVALUATE WS-OLD-SSN                                          
               WHEN CE-SSN                                              
                   CONTINUE                                             
               WHEN SPACES                                              
                   CONTINUE                                             
               WHEN LOW-VALUES                                          
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE 333 TO WS-ACTIVE-RETURN-CODE                    
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE '2011'                TO ACTIVE-PARAGRAPH       
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                   MOVE 'CSS_CUST_STATS'      TO TABLE-1                
                   MOVE 'SSN'                 TO TABLE-ELEMENT-1        
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2        
                   MOVE CE-SSN                TO HOSTVAR-ELEMENT-1      
                   MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE                                                 
           END-IF.                                                      
                                                                        
       2011-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      *  CHECK DRVR LIC #S FOR BOTH CUSTOMER #S TO MAKE SURE THEY    *          
      *  MATCH. IF NOT, USE THE CUSTOMER'S LIC # W/THE MOST RECENT   *          
      *  ISSUE DATE.                                                 *          
      ****************************************************************          
      *                                                                         
      *2012-CHECK-DRVR-LIC-NO.                                                  
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT CODE_STATE_ID,                                            
      *               DRIVERS_LICENSE_NO,                                       
      *               DRVR_LIC_ISS_DT                                           
      *        INTO   :CE-CODE-STATE-ID,                                        
      *               :CE-DRIVERS-LICENSE-NO,                                   
      *               :CE-DRVR-LIC-ISS-DT :WS-NULL-IND2                         
      *        FROM   CSS_CUST_STATS                                            
      *        WHERE  CUSTOMER_NO = :WS-CUSTOMER-NUM                            
      *        AND    CUSTOMER_TYPE = 'C'                                       
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *        IF WS-NULL-IND2 = -1                                             
      *           MOVE SPACES               TO WS-OLD-DRVR-LIC-DT               
      *           MOVE 0                    TO WS-NULL-IND2                     
      *        ELSE                                                             
      *           MOVE CE-DRVR-LIC-ISS-DT   TO WS-OLD-DRVR-LIC-DT               
      *        END-IF                                                           
      *    ELSE                                                                 
      *        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                     
      *        MOVE PROGRAM-NAME          TO ABEND-PROGRAM                      
      *        MOVE 'SELECT'              TO ABEND-FUNCTION                     
      *        MOVE '2012'                TO ACTIVE-PARAGRAPH                   
      *        MOVE SPACES                TO ABEND-SQL-PREDICATES               
      *                                      ABEND-TABLES                       
      *        MOVE 'CSS_CUST_STATS'      TO TABLE-1                            
      *        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                    
      *        MOVE 'CODE_STATE_ID'       TO TABLE-ELEMENT-2                    
      *        MOVE 'DRIVERS_LICENSE_NO'  TO TABLE-ELEMENT-3                    
      *        MOVE 'DRVR_LIC_ISS_DT'     TO TABLE-ELEMENT-4                    
      *        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1                  
      *        MOVE CE-CODE-STATE-ID      TO HOSTVAR-ELEMENT-2                  
      *        MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-3                  
      *        MOVE CE-DRVR-LIC-ISS-DT    TO HOSTVAR-ELEMENT-4                  
      *        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                   
      *        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                   
      *    END-IF.                                                              
      *                                                                         
      *    MOVE CE-CODE-STATE-ID      TO WS-OLD-CODE-ST-ID.                     
      *    MOVE CE-DRIVERS-LICENSE-NO TO WS-OLD-DRVR-LIC-NO.                    
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT CODE_STATE_ID,                                            
      *               DRIVERS_LICENSE_NO,                                       
      *               DRVR_LIC_ISS_DT                                           
      *        INTO   :CE-CODE-STATE-ID,                                        
      *               :CE-DRIVERS-LICENSE-NO,                                   
      *               :CE-DRVR-LIC-ISS-DT :WS-NULL-IND2                         
      *        FROM   CSS_CUST_STATS                                            
      *        WHERE  CUSTOMER_NO = :WS-NEW-CUST-NUM                            
      *        AND    CUSTOMER_TYPE = 'C'                                       
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                               
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *         IF WS-NULL-IND2 = -1                                            
      *            MOVE SPACES               TO CE-DRVR-LIC-ISS-DT              
      *            MOVE 0                    TO WS-NULL-IND2                    
      *         END-IF                                                          
      *    ELSE                                                                 
      *        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                     
      *        MOVE PROGRAM-NAME          TO ABEND-PROGRAM                      
      *        MOVE 'SELECT'              TO ABEND-FUNCTION                     
      *        MOVE '2012'                TO ACTIVE-PARAGRAPH                   
      *        MOVE SPACES                TO ABEND-SQL-PREDICATES               
      *                                   ABEND-TABLES                          
      *        MOVE 'CSS_CUST_STATS'      TO TABLE-1                            
      *        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                    
      *        MOVE 'CODE_STATE_ID'       TO TABLE-ELEMENT-2                    
      *        MOVE 'DRIVERS_LICENSE_NO'  TO TABLE-ELEMENT-3                    
      *        MOVE 'DRVR_LIC_ISS_DT'     TO TABLE-ELEMENT-4                    
      *        MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                  
      *        MOVE CE-CODE-STATE-ID      TO HOSTVAR-ELEMENT-2                  
      *        MOVE CE-DRIVERS-LICENSE-NO TO HOSTVAR-ELEMENT-3                  
      *        MOVE CE-DRVR-LIC-ISS-DT    TO HOSTVAR-ELEMENT-4                  
      *        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                   
      *        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                   
      *    END-IF.                                                              
      *                                                                         
      *    EVALUATE WS-OLD-DRVR-LIC-NO                                          
      *        WHEN CE-DRIVERS-LICENSE-NO                                       
      *            CONTINUE                                                     
      *        WHEN SPACES                                                      
      *            CONTINUE                                                     
      *        WHEN LOW-VALUES                                                  
      *            CONTINUE                                                     
      *        WHEN OTHER                                                       
      *            MOVE 'Y' TO WS-CHECK-DR-LIC-NO                               
      *    END-EVALUATE.                                                        
      *                                                                         
      *    IF WS-CHECK-DR-LIC-NO = 'Y'                                          
      *        IF WS-OLD-DRVR-LIC-DT > CE-DRVR-LIC-ISS-DT                       
      *            EXEC SQL                                                     
      *                UPDATE CSS_CUST_STATS                                    
      *                  SET CODE_STATE_ID =      :WS-OLD-CODE-ST-ID,           
      *                      DRIVERS_LICENSE_NO = :WS-OLD-DRVR-LIC-NO,          
      *                      DRVR_LIC_ISS_DT =    :WS-OLD-DRVR-LIC-DT           
      *                  WHERE CUSTOMER_NO = :WS-NEW-CUST-NUM                   
      *                  AND   CUSTOMER_TYPE = 'C'                              
      *            END-EXEC                                                     
      *                                                                         
      *            MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
      *            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
      *                                       OR NOT-FOUND                      
      *              NEXT SENTENCE                                              
      *            ELSE                                                         
      *              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE               
      *              MOVE PROGRAM-NAME          TO ABEND-PROGRAM                
      *              MOVE 'UPDATE'              TO ABEND-FUNCTION               
      *              MOVE '2012'                TO ACTIVE-PARAGRAPH             
      *              MOVE SPACES                TO ABEND-SQL-PREDICATES         
      *                                         ABEND-TABLES                    
      *              MOVE 'CSS_CUST_STATS'      TO TABLE-1                      
      *              MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1              
      *              MOVE 'CODE_STATE_ID'       TO TABLE-ELEMENT-2              
      *              MOVE 'DRIVERS_LICENSE_NO'  TO TABLE-ELEMENT-3              
      *              MOVE 'DRVR_LIC_ISS_DT'     TO TABLE-ELEMENT-4              
      *              MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1            
      *              MOVE WS-OLD-CODE-ST-ID     TO HOSTVAR-ELEMENT-2            
      *              MOVE WS-OLD-DRVR-LIC-NO    TO HOSTVAR-ELEMENT-3            
      *              MOVE WS-OLD-DRVR-LIC-DT    TO HOSTVAR-ELEMENT-4            
      *              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
      *              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
      *            END-IF                                                       
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *2012-EXIT.                                                               
      *    EXIT.                                                                
      *                                                                         
      ****************************************************************          
      *  CHECK DATE_OF_BIRTH, EMPLOYED_DATE, EMPLOYER, OCCUPATION,   *          
      *  OTHER_ID, AND OTHER_ID_TYPE ON NEW CUSTOMER #.              *          
      *  IF BLANK, UPDATE WITH OLD CUSTOMER # FIELDS.                *          
      ****************************************************************          
      *                                                                         
      *2013-CHECK-OTHER-CUST-STATS.                                             
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT DATE_OF_BIRTH,                                            
      *               EMPLOYED_DATE,                                            
      *               EMPLOYER,                                                 
      *               OCCUPATION,                                               
      *               OTHER_ID,                                                 
      *               OTHER_ID_TYPE                                             
      *        INTO   :CE-DATE-OF-BIRTH :WS-NULL-IND1,                          
      *               :CE-EMPLOYED-DATE :WS-NULL-IND3,                          
      *               :CE-EMPLOYER,                                             
      *               :CE-OCCUPATION,                                           
      *               :CE-OTHER-ID,                                             
      *               :CE-OTHER-ID-TYPE                                         
      *        FROM   CSS_CUST_STATS                                            
      *        WHERE  CUSTOMER_NO = :WS-CUSTOMER-NUM                            
      *        AND    CUSTOMER_TYPE = 'C'                                       
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                                
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *        IF WS-NULL-IND1 = -1                                             
      *           MOVE SPACES               TO WS-OLD-DATE-BIRTH                
      *           MOVE 0                    TO WS-NULL-IND1                     
      *        ELSE                                                             
      *           MOVE CE-DATE-OF-BIRTH     TO WS-OLD-DATE-BIRTH                
      *           MOVE CE-DATE-OF-BIRTH     TO WS-SELECT-DATE-FORM              
      *           MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR                   
      *           MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH                  
      *           MOVE WS-SELECT-DAY        TO WS-RETURN-DAY                    
      *           MOVE WS-RETURN-DATE-FORM  TO WS-OLD-DATE-BIRTH                
      *        END-IF                                                           
      *        IF WS-NULL-IND3 = -1                                             
      *           MOVE SPACES               TO WS-OLD-EMPL-DATE                 
      *           MOVE 0                    TO WS-NULL-IND3                     
      *        ELSE                                                             
      *           MOVE CE-EMPLOYED-DATE     TO WS-SELECT-DATE-FORM              
      *           MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR                   
      *           MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH                  
      *           MOVE WS-SELECT-DAY        TO WS-RETURN-DAY                    
      *           MOVE WS-RETURN-DATE-FORM  TO WS-OLD-EMPL-DATE                 
      *        END-IF                                                           
      *    ELSE                                                                 
      *      MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                       
      *      MOVE PROGRAM-NAME          TO ABEND-PROGRAM                        
      *      MOVE 'SELECT'              TO ABEND-FUNCTION                       
      *      MOVE '2013'                TO ACTIVE-PARAGRAPH                     
      *      MOVE SPACES                TO ABEND-SQL-PREDICATES                 
      *                                 ABEND-TABLES                            
      *      MOVE 'CSS_CUST_STATS'      TO TABLE-1                              
      *      MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                      
      *      MOVE 'OTHER_ID'            TO TABLE-ELEMENT-2                      
      *      MOVE 'EMPLOYER'            TO TABLE-ELEMENT-3                      
      *      MOVE 'DATE_OF_BIRTH'       TO TABLE-ELEMENT-4                      
      *      MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1                    
      *      MOVE CE-OTHER-ID           TO HOSTVAR-ELEMENT-2                    
      *      MOVE CE-EMPLOYER           TO HOSTVAR-ELEMENT-3                    
      *      MOVE CE-DATE-OF-BIRTH      TO HOSTVAR-ELEMENT-4                    
      *      PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                     
      *      PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *    MOVE CE-EMPLOYER      TO WS-OLD-EMPLOYER.                            
      *    MOVE CE-OCCUPATION    TO WS-OLD-OCCUPATION.                          
      *    MOVE CE-OTHER-ID      TO WS-OLD-OTHER-ID.                            
      *    MOVE CE-OTHER-ID-TYPE TO WS-OLD-ID-TYPE.                             
      *                                                                         
      *    EXEC SQL                                                             
      *        SELECT DATE_OF_BIRTH,                                            
      *               EMPLOYED_DATE,                                            
      *               EMPLOYER,                                                 
      *               OCCUPATION,                                               
      *               OTHER_ID,                                                 
      *               OTHER_ID_TYPE                                             
      *        INTO   :CE-DATE-OF-BIRTH :WS-NULL-IND1,                          
      *               :CE-EMPLOYED-DATE :WS-NULL-IND3,                          
      *               :CE-EMPLOYER,                                             
      *               :CE-OCCUPATION,                                           
      *               :CE-OTHER-ID,                                             
      *               :CE-OTHER-ID-TYPE                                         
      *        FROM   CSS_CUST_STATS                                            
      *        WHERE  CUSTOMER_NO = :WS-NEW-CUST-NUM                            
      *        AND    CUSTOMER_TYPE = 'C'                                       
      *    END-EXEC.                                                            
      *                                                                         
      *    MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                                
      *    IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND              
      *         IF WS-NULL-IND1 = -1                                            
      *            MOVE SPACES               TO WS-NEW-DATE-BIRTH               
      *            MOVE 0                    TO WS-NULL-IND1                    
      *         ELSE                                                            
      *            MOVE CE-DATE-OF-BIRTH     TO WS-SELECT-DATE-FORM             
      *            MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR                  
      *            MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH                 
      *            MOVE WS-SELECT-DAY        TO WS-RETURN-DAY                   
      *            MOVE WS-RETURN-DATE-FORM  TO WS-NEW-DATE-BIRTH               
      *         END-IF                                                          
      *         IF WS-NULL-IND3 = -1                                            
      *            MOVE SPACES               TO WS-NEW-EMPL-DATE                
      *            MOVE 0                    TO WS-NULL-IND3                    
      *         ELSE                                                            
      *            MOVE CE-EMPLOYED-DATE     TO WS-SELECT-DATE-FORM             
      *            MOVE WS-SELECT-YEAR       TO WS-RETURN-YEAR                  
      *            MOVE WS-SELECT-MONTH      TO WS-RETURN-MONTH                 
      *            MOVE WS-SELECT-DAY        TO WS-RETURN-DAY                   
      *            MOVE WS-RETURN-DATE-FORM  TO WS-NEW-EMPL-DATE                
      *         END-IF                                                          
      *    ELSE                                                                 
      *      MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                       
      *      MOVE PROGRAM-NAME          TO ABEND-PROGRAM                        
      *      MOVE 'SELECT'              TO ABEND-FUNCTION                       
      *      MOVE '2013'                TO ACTIVE-PARAGRAPH                     
      *      MOVE SPACES                TO ABEND-SQL-PREDICATES                 
      *                                 ABEND-TABLES                            
      *      MOVE 'CSS_CUST_STATS'      TO TABLE-1                              
      *      MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                      
      *      MOVE 'OTHER_ID'            TO TABLE-ELEMENT-2                      
      *      MOVE 'EMPLOYER'            TO TABLE-ELEMENT-3                      
      *      MOVE 'DATE_OF_BIRTH'       TO TABLE-ELEMENT-4                      
      *      MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                    
      *      MOVE CE-OTHER-ID           TO HOSTVAR-ELEMENT-2                    
      *      MOVE CE-EMPLOYER           TO HOSTVAR-ELEMENT-3                    
      *      MOVE CE-DATE-OF-BIRTH      TO HOSTVAR-ELEMENT-4                    
      *      PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                     
      *      PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                     
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-NEW-DATE-BIRTH = SPACES                                        
      *        EXEC SQL                                                         
      *            UPDATE CSS_CUST_STATS                                        
      *               SET DATE_OF_BIRTH =:WS-OLD-DATE-BIRTH                     
      *             WHERE CUSTOMER_NO   =:WS-NEW-CUST-NUM                       
      *             AND   CUSTOMER_TYPE = 'C'                                   
      *        END-EXEC                                                         
      *                                                                         
      *        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                            
      *        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                       
      *          NEXT SENTENCE                                                  
      *        ELSE                                                             
      *          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                   
      *          MOVE PROGRAM-NAME          TO ABEND-PROGRAM                    
      *          MOVE 'UPDATE'              TO ABEND-FUNCTION                   
      *          MOVE '2013'                TO ACTIVE-PARAGRAPH                 
      *          MOVE SPACES                TO ABEND-SQL-PREDICATES             
      *                                     ABEND-TABLES                        
      *          MOVE 'CSS_CUST_STATS'      TO TABLE-1                          
      *          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                  
      *          MOVE 'DATE_OF_BIRTH'       TO TABLE-ELEMENT-2                  
      *          MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                
      *          MOVE CE-DATE-OF-BIRTH      TO HOSTVAR-ELEMENT-2                
      *          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                 
      *          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    IF WS-NEW-EMPL-DATE = SPACES                                         
      *        EXEC SQL                                                         
      *            UPDATE CSS_CUST_STATS                                        
      *               SET EMPLOYED_DATE =:WS-OLD-EMPL-DATE                      
      *             WHERE CUSTOMER_NO   =:WS-NEW-CUST-NUM                       
      *             AND   CUSTOMER_TYPE = 'C'                                   
      *        END-EXEC                                                         
      *                                                                         
      *        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                            
      *        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                       
      *          NEXT SENTENCE                                                  
      *        ELSE                                                             
      *          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                   
      *          MOVE PROGRAM-NAME          TO ABEND-PROGRAM                    
      *          MOVE 'UPDATE'              TO ABEND-FUNCTION                   
      *          MOVE '2013'                TO ACTIVE-PARAGRAPH                 
      *          MOVE SPACES                TO ABEND-SQL-PREDICATES             
      *                                     ABEND-TABLES                        
      *          MOVE 'CSS_CUST_STATS'      TO TABLE-1                          
      *          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                  
      *          MOVE 'EMPLOYED_DATE'       TO TABLE-ELEMENT-2                  
      *          MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                
      *          MOVE CE-EMPLOYED-DATE      TO HOSTVAR-ELEMENT-2                
      *          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                 
      *          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    IF CE-EMPLOYER = SPACES                                              
      *        EXEC SQL                                                         
      *            UPDATE CSS_CUST_STATS                                        
      *               SET EMPLOYER      =:WS-OLD-EMPLOYER                       
      *             WHERE CUSTOMER_NO   =:WS-NEW-CUST-NUM                       
      *             AND   CUSTOMER_TYPE = 'C'                                   
      *        END-EXEC                                                         
      *                                                                         
      *        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                            
      *        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                       
      *          NEXT SENTENCE                                                  
      *        ELSE                                                             
      *          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                   
      *          MOVE PROGRAM-NAME          TO ABEND-PROGRAM                    
      *          MOVE 'UPDATE'              TO ABEND-FUNCTION                   
      *          MOVE '2013'                TO ACTIVE-PARAGRAPH                 
      *          MOVE SPACES                TO ABEND-SQL-PREDICATES             
      *                                     ABEND-TABLES                        
      *          MOVE 'CSS_CUST_STATS'      TO TABLE-1                          
      *          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                  
      *          MOVE 'EMPLOYER'            TO TABLE-ELEMENT-2                  
      *          MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                
      *          MOVE CE-EMPLOYER           TO HOSTVAR-ELEMENT-2                
      *          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                 
      *          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    IF CE-OCCUPATION = SPACES                                            
      *        EXEC SQL                                                         
      *            UPDATE CSS_CUST_STATS                                        
      *               SET OCCUPATION    =:WS-OLD-OCCUPATION                     
      *             WHERE CUSTOMER_NO   =:WS-NEW-CUST-NUM                       
      *             AND   CUSTOMER_TYPE = 'C'                                   
      *        END-EXEC                                                         
      *                                                                         
      *        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                            
      *        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                       
      *          NEXT SENTENCE                                                  
      *        ELSE                                                             
      *          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                   
      *          MOVE PROGRAM-NAME          TO ABEND-PROGRAM                    
      *          MOVE 'UPDATE'              TO ABEND-FUNCTION                   
      *          MOVE '2013'                TO ACTIVE-PARAGRAPH                 
      *          MOVE SPACES                TO ABEND-SQL-PREDICATES             
      *                                     ABEND-TABLES                        
      *          MOVE 'CSS_CUST_STATS'      TO TABLE-1                          
      *          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                  
      *          MOVE 'OCCUPATION'          TO TABLE-ELEMENT-2                  
      *          MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                
      *          MOVE CE-OCCUPATION         TO HOSTVAR-ELEMENT-2                
      *          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                 
      *          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    IF CE-OTHER-ID = SPACES                                              
      *        EXEC SQL                                                         
      *            UPDATE CSS_CUST_STATS                                        
      *               SET OTHER_ID      =:WS-OLD-OTHER-ID                       
      *             WHERE CUSTOMER_NO   =:WS-NEW-CUST-NUM                       
      *             AND   CUSTOMER_TYPE = 'C'                                   
      *        END-EXEC                                                         
      *                                                                         
      *        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                            
      *        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                       
      *          NEXT SENTENCE                                                  
      *        ELSE                                                             
      *          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                   
      *          MOVE PROGRAM-NAME          TO ABEND-PROGRAM                    
      *          MOVE 'UPDATE'              TO ABEND-FUNCTION                   
      *          MOVE '2013'                TO ACTIVE-PARAGRAPH                 
      *          MOVE SPACES                TO ABEND-SQL-PREDICATES             
      *                                     ABEND-TABLES                        
      *          MOVE 'CSS_CUST_STATS'      TO TABLE-1                          
      *          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                  
      *          MOVE 'OTHER_ID'            TO TABLE-ELEMENT-2                  
      *          MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                
      *          MOVE CE-OTHER-ID           TO HOSTVAR-ELEMENT-2                
      *          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                 
      *          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *    IF CE-OTHER-ID-TYPE = SPACES                                         
      *        EXEC SQL                                                         
      *            UPDATE CSS_CUST_STATS                                        
      *               SET OTHER_ID_TYPE =:WS-OLD-ID-TYPE                        
      *             WHERE CUSTOMER_NO   =:WS-NEW-CUST-NUM                       
      *             AND   CUSTOMER_TYPE = 'C'                                   
      *        END-EXEC                                                         
      *                                                                         
      *        MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                            
      *        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                       
      *          NEXT SENTENCE                                                  
      *        ELSE                                                             
      *          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE                   
      *          MOVE PROGRAM-NAME          TO ABEND-PROGRAM                    
      *          MOVE 'UPDATE'              TO ABEND-FUNCTION                   
      *          MOVE '2013'                TO ACTIVE-PARAGRAPH                 
      *          MOVE SPACES                TO ABEND-SQL-PREDICATES             
      *                                     ABEND-TABLES                        
      *          MOVE 'CSS_CUST_STATS'      TO TABLE-1                          
      *          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1                  
      *          MOVE 'OTHER_ID_TYPE'       TO TABLE-ELEMENT-2                  
      *          MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1                
      *          MOVE CE-OTHER-ID-TYPE      TO HOSTVAR-ELEMENT-2                
      *          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                 
      *          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                 
      *        END-IF                                                           
      *    END-IF.                                                              
      *                                                                         
      *2013-EXIT.                                                               
      *    EXIT.                                                                
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_CSH_DRWR_JRNL                  *         
      *****************************************************************         
                                                                        
       2020-UPDATE-CSS-CSH-DRWR-JRNL.                                   
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CSH_DRWR_JRNL                                 
                  SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CSH_DRWR_JRNL                                         
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                              
MFA-TR*        QUERYNO 2020                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2020'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_CSH_DRWR_JRNL'   TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2020-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_CUST_COMM_MF                   *         
      *****************************************************************         
                                                                        
       2030-UPDATE-CSS-COMM-DATA.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_COMM_DATA                                     
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                      
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COMM_DATA                                             
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                              
MFA-TR*        QUERYNO 2030                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2030'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_COMM_DATA'       TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2030-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH*  UPDATE CUSTOMER NUMBER IN CSS_WQ_ITEMS                       *         
REARCH*****************************************************************         
REARCH                                                                  
REARCH 2045-UPDATE-CSS-WQ-ITEMS.                                        
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         UPDATE CSS_WQ_ITEMS                                      
REARCH            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
REARCH          WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                      
                                                            
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_WQ_ITEMS                                              
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                              
MFA-TR*        QUERYNO 2045                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
REARCH         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
REARCH         MOVE 'UPDATE'              TO ABEND-FUNCTION             
REARCH         MOVE '2045'                TO ACTIVE-PARAGRAPH           
REARCH         MOVE SPACES                TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH         MOVE 'CSS_WQ_ITEMS'        TO TABLE-1                    
REARCH         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
REARCH         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
REARCH         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
REARCH         MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
REARCH         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 2045-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_MNT_TRANS_HIST                 *         
      *****************************************************************         
                                                                        
       2050-UPDATE-CSS-MNT-TRANS-HIST.                                  
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MNT_TRANS_HIST                                
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MNT_TRANS_HIST                                        
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2050                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE '2050'               TO ACTIVE-PARAGRAPH            
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_MNT_TRANS_HIST' TO TABLE-1                     
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_NAME_ACCT_XREF                 *         
      *****************************************************************         
                                                                        
       2060-UPDATE-CSS-NAME-ACCT-XREF.                                  
                                                                        
           MOVE WS-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           EXEC SQL                                                     
             OPEN HT_CURSOR                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'OPEN'                TO ABEND-FUNCTION             
               MOVE '2060'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           PERFORM 2065-FETCH-HT THRU 2065-EXIT.                        
                                                                        
           EXEC SQL                                                     
             CLOSE HT_CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'CLOSE'               TO ABEND-FUNCTION             
               MOVE '2060'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2060-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2065-FETCH-HT.                                                   
                                                                        
           EXEC SQL                                                     
             FETCH HT_CURSOR                                            
             INTO :HT-CUSTOMER-NO,                                      
                  :HT-NAME-ID                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
             WHEN SUCCESSFUL-CALL                                       
               CONTINUE                                                 
             WHEN NOT-FOUND                                             
               GO TO 2065-EXIT                                          
             WHEN OTHER                                                 
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'FETCH'               TO ABEND-FUNCTION             
               MOVE '2065'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT.          
                                                                        
           IF HT-NAME-ID = WS-OLD-NAME-ID                               
               MOVE WS-NEW-NAME-ID TO HT-NAME-ID                        
C35344     ELSE                                                         
C35344         PERFORM 2210-GET-SP-NAME-ACCT-XREF  THRU 2210-EXIT       
C35344         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
C35344          PERFORM 2230-MOVE-SP-NAME-ACCT-XREF THRU 2230-EXIT      
C35344         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
C35344            IF HT-NAME-ID = WS-OLD-SP-NAME-ID                     
C35344              MOVE WS-NEW-SP-NAME-ID TO HT-NAME-ID                
C35344            END-IF                                                
C35344         END-IF                                                   
C35344     END-IF                                                       
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
             UPDATE CSS_NAME_ACCT_XREF                                  
               SET CUSTOMER_NO =:WS-NEW-CUST-NUM,                       
                   NAME_ID =:HT-NAME-ID                                 
               WHERE CURRENT OF HT_CURSOR                               
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2065'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           GO TO 2065-FETCH-HT.                                         
                                                                        
       2065-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_OFF_CYCL_ACCT                  *         
      *****************************************************************         
                                                                        
       2070-UPDATE-CSS-OFF-CYCL-ACCT.                                   
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_OFF_CYCL_ACCT                                 
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_OFF_CYCL_ACCT                                         
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2070                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2070'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_OFF_CYCL_ACCT'   TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2070-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      *  CHECK IF OLD CUSTOMER # IS IN CSS_NAME_ACCT_XREF              *        
      ******************************************************************        
                                                                        
       2080-SELECT-CSS-NAME-ACCT-XREF.                                  
                                                                        
           EXEC SQL                                                     
               SELECT NAME_ID                                           
               INTO :HT-NAME-ID                                         
               FROM CSS_NAME_ACCT_XREF WITH(READUNCOMMITTED)                    
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                     
PERFOR                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT NAME_ID                                                   
MFA-TR*        INTO :HT-NAME-ID                                                 
MFA-TR*        FROM CSS_NAME_ACCT_XREF                                          
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                             
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 2080                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                    CONTINUE                                            
               WHEN MULTIPLE-ROWS-SELECTED                              
                    CONTINUE                                            
               WHEN NOT-FOUND                                           
T23539             PERFORM 2084-SELECT-ACCT-COMPANY-NO THRU 2084-EXIT   
                   PERFORM 2085-INSERT-CSS-NAME-ACCT-XREF THRU 2085-EXIT
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE '2080'                TO ACTIVE-PARAGRAPH       
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                   MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                
                   MOVE 'NAME_ID'             TO TABLE-ELEMENT-1        
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2        
                   MOVE HT-NAME-ID            TO HOSTVAR-ELEMENT-1      
                   MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       2080-EXIT.                                                       
           EXIT.                                                        
                                                                        
T23539*****************************************************************         
T23539*  SELECT COMPANY_NO FROM CSS_ACCOUNT.                          *         
T23539*****************************************************************         
T23539                                                                  
T23539 2084-SELECT-ACCT-COMPANY-NO.                                     
T23539                                                                  
T23539     EXEC SQL                                                     
T23539         SELECT COMPANY_NO                                        
T23539           INTO :WS-COMPANY-NO                                    
T23539           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
T23539          WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                      
PERFOR                                                           
                                                            
T23539     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COMPANY_NO                                                
MFA-TR*          INTO :WS-COMPANY-NO                                            
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                              
MFA-TR*         WITH UR                                                         
MFA-TR*        QUERYNO 2084                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23539                                                                  
T23539     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T23539     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23539         NEXT SENTENCE                                            
T23539     ELSE                                                         
T23539         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T23539         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
T23539         MOVE 'SELECT'              TO ABEND-FUNCTION             
T23539         MOVE '2084'                TO ACTIVE-PARAGRAPH           
T23539         MOVE SPACES                TO ABEND-SQL-PREDICATES       
T23539                                       ABEND-TABLES               
T23539         MOVE 'CSS_ACCOUNT'         TO TABLE-1                    
T23539         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
T23539         MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1          
T23539         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T23539         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T23539     END-IF.                                                      
T23539                                                                  
T23539 2084-EXIT.                                                       
T23539     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  INSERT INTO CSS_NAME_ACCT_XREF                               *         
      *****************************************************************         
                                                                        
       2085-INSERT-CSS-NAME-ACCT-XREF.                                  
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_NAME_ACCT_XREF                           
                   (ACCOUNT_NO,                                         
                    ADDRESS_ID,                                         
                    COMPANY_NO,                                         
                    CONTACT_ID,                                         
                    CUSTOMER_NO,                                        
                    CUSTOMER_ROLE_CD,                                   
                    NAME_ID,                                            
                    PREMISE_NO)                                         
               VALUES                                                   
                   (0,                                                  
                    0,                                                  
T23539              :WS-COMPANY-NO,                                     
                    0,                                                  
                    :WS-CUSTOMER-NUM,                                   
                    ' ',                                                
                    :WS-OLD-NAME-ID,                                    
                    0)                                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'INSERT'              TO ABEND-FUNCTION             
               MOVE '2085'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                    
               MOVE 'NAME_ID'             TO TABLE-ELEMENT-1            
               MOVE WS-OLD-NAME-ID        TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2085-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_BANK_EFT                       *         
      *****************************************************************         
                                                                        
       2090-UPDATE-CSS-BANK-EFT.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BANK_EFT                                      
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BANK_EFT                                              
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
               MOVE 'UPDATE'             TO ABEND-FUNCTION              
               MOVE '2090'               TO ACTIVE-PARAGRAPH            
               MOVE SPACES               TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
               MOVE 'CSS_BANK_EFT'       TO TABLE-1                     
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2090-EXIT.                                                       
            EXIT.                                                       
                                                                        
      *****************************************************************         
      * UPDATE CUSTOMER NUMBER IN CSS_BILLING_HDR                     *         
      *****************************************************************         
                                                                        
       2100-UPDATE-CSS-BILLING-HDR.                                     
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BILLING_HDR                                   
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILLING_HDR                                           
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2100                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE '2100'                    TO ACTIVE-PARAGRAPH       
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_BILLING_HDR'         TO TABLE-1                
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
T25687******************************************************************        
T25687* UPDATE NAME ID IN CSS-BILL-ADDR-XREF                           *        
T25687******************************************************************        
T25687                                                                  
T25687                                                                  
T25687 2105-UPDATE-CSS-BILL-ADDR-XREF.                                  
T25687                                                                  
T25687     EXEC SQL                                                     
T25687         UPDATE CSS_BILL_ADDR_XREF                                
T25687            SET NAME_ID = :WS-NEW-NAME-ID                         
T25687           WHERE NAME_ID = :WS-OLD-NAME-ID                        
                                                            
T25687     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BILL_ADDR_XREF                                        
MFA-TR*           SET NAME_ID = :WS-NEW-NAME-ID                                 
MFA-TR*          WHERE NAME_ID = :WS-OLD-NAME-ID                                
MFA-TR*        QUERYNO 2105                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T25687     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T25687     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T25687         NEXT SENTENCE                                            
T25687     ELSE                                                         
T25687         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T25687         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
T25687         MOVE 'UPDATE'                TO ABEND-FUNCTION           
T25687         MOVE '2105'                  TO ACTIVE-PARAGRAPH         
T25687         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
T25687                                         ABEND-TABLES             
T25687         MOVE 'CSS_BILL_ADDR_XREF'    TO TABLE-1                  
T25687         MOVE 'NAME_ID'        TO TABLE-ELEMENT-1                 
T25687         MOVE WS-OLD-NAME-ID          TO HOSTVAR-ELEMENT-1        
T25687         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T25687         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T25687     END-IF.                                                      
T25687                                                                  
T25687 2105-EXIT.                                                       
T25687     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_CUST_PREM_HIST                 *         
      *****************************************************************         
                                                                        
       2110-UPDATE-CSS-CUST-PREM-HIST.                                  
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_CUST_PREM_HIST                                
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PREM_HIST                                        
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2110                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME                 TO ABEND-PROGRAM       
               MOVE 'UPDATE'                     TO ABEND-FUNCTION      
               MOVE '2110'                       TO ACTIVE-PARAGRAPH    
               MOVE SPACES                       TO ABEND-SQL-PREDICATES
                                                    ABEND-TABLES        
               MOVE 'CSS_CUST_PREM_HIST'         TO TABLE-1             
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2110-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_BATCH_JRNL                     *         
      *****************************************************************         
                                                                        
       2120-UPDATE-CSS-BATCH-JRNL.                                      
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_BATCH_JRNL                                    
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BATCH_JRNL                                            
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2120                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2120'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_BATCH_JRNL'      TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_MISC_JRNL                      *         
      *****************************************************************         
                                                                        
       2130-UPDATE-CSS-MISC-JRNL.                                       
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MISC_JRNL                                     
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_MISC_JRNL                                             
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2130                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2130'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_MISC_JRNL'       TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2130-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_ACCOUNT                        *         
      *****************************************************************         
                                                                        
       2140-UPDATE-CSS-ACCOUNT.                                         
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
                WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 2140                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE '2140'                  TO ACTIVE-PARAGRAPH         
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_ACCOUNT'           TO TABLE-1                  
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2140-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_LANDLORD                       *         
      *****************************************************************         
                                                                        
       2145-UPDATE-CSS-LANDLORD.                                        
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_LANDLORD                                      
                  SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
                WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_LANDLORD                                              
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 2145                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'UPDATE'                TO ABEND-FUNCTION           
               MOVE '2145'                  TO ACTIVE-PARAGRAPH         
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_LANDLORD'          TO TABLE-1                  
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
               MOVE WS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2145-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_COLL_ACCT_INFO                 *         
      *****************************************************************         
                                                                        
T28358 2146-UPDATE-CSS-COLL-ACCT-INFO.                                  
                                                                        
T28358     EXEC SQL                                                     
T28358         UPDATE CSS_COLL_ACCT_INFO                                
T28358            SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
T28358          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
                                                            
T28358     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COLL_ACCT_INFO                                        
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 2146                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T28358     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T28358     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T28358         NEXT SENTENCE                                            
T28358     ELSE                                                         
T28358         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T28358         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
T28358         MOVE 'UPDATE'                TO ABEND-FUNCTION           
T28358         MOVE '2146'                  TO ACTIVE-PARAGRAPH         
T28358         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
T28358                                         ABEND-TABLES             
T28358         MOVE 'CSS_COLL_ACCT_INFO'    TO TABLE-1                  
T28358         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
T28358         MOVE WS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
T28358         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T28358         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T28358     END-IF.                                                      
T28358                                                                  
T28358 2146-EXIT.                                                       
T28358     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_ROOMMATE                       *         
      *****************************************************************         
                                                                        
T30585 2147-UPDATE-CSS-ROOMMATE.                                        
                                                                        
T30585     EXEC SQL                                                     
T30585         UPDATE CSS_ROOMMATE                                      
T30585            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
T30585          WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                    
                                                            
T30585     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ROOMMATE                                              
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 2147                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2147'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_ROOMMATE'        TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T30585 2147-EXIT.                                                       
T30585     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_IVR_NOTICE                     *         
      *****************************************************************         
                                                                        
T30585 2148-UPDATE-CSS-IVR-NOTICE.                                      
T30585                                                                  
T30585     EXEC SQL                                                     
T30585         UPDATE CSS_IVR_NOTICE                                    
T30585            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
T30585          WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                      
                                                            
T30585     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_IVR_NOTICE                                            
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                              
MFA-TR*        QUERYNO 2148                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2148'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_IVR_NOTICE'      TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T30585 2148-EXIT.                                                       
T30585     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_REG_PROFILE                    *         
      *****************************************************************         
                                                                        
T30585 2149-UPDATE-CSS-REG-PROFILE.                                     
                                                                        
T30585     EXEC SQL                                                     
T30585         UPDATE CSS_REG_PROFILE                                   
T30585            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
T30585          WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                      
                                                            
T30585     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_REG_PROFILE                                           
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE ACCOUNT_NO  =:WS-ACCOUNT-NUM                              
MFA-TR*        QUERYNO 2149                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2149'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_REG_PROFILE'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T30585 2149-EXIT.                                                       
T30585     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  SELECT FROM CSS_CUST_STATS IF THE CUSTOMER HAS A SPOUSE.     *         
      *****************************************************************         
                                                                        
       2150-SELECT-CSS-CUST-STATS.                                      
                                                                        
           EXEC SQL                                                     
               SELECT CODE_STATE_ID,                                    
                      CUSTOMER_NO,                                      
                      CUSTOMER_TYPE,                                    
                      DATE_OF_BIRTH,                                    
                      DRIVERS_LICENSE_NO,                               
                      DRVR_LIC_ISS_DT,                                  
                      EMPLOYED_DATE,                                    
                      EMPLOYEE_NBR,                                     
                      EMPLOYER,                                         
                      INTR_CO_IND,                                      
                      NAME_ID,                                          
                      OCCUPATION,                                       
                      OTHER_ID,                                         
                      OTHER_ID_TYPE,                                    
                      SSN                                               
               INTO :CE-CODE-STATE-ID,                                  
                    :CE-CUSTOMER-NO,                                    
                    :CE-CUSTOMER-TYPE,                                  
                    :CE-DATE-OF-BIRTH :WS-NULL-IND1,                    
                    :CE-DRIVERS-LICENSE-NO,                             
                    :CE-DRVR-LIC-ISS-DT :WS-NULL-IND2,                  
                    :CE-EMPLOYED-DATE :WS-NULL-IND3,                    
                    :CE-EMPLOYEE-NBR,                                   
                    :CE-EMPLOYER,                                       
                    :CE-INTR-CO-IND,                                    
                    :CE-NAME-ID,                                        
                    :CE-OCCUPATION,                                     
                    :CE-OTHER-ID,                                       
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-SSN                                             
               FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                        
               WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                     
               AND   CUSTOMER_TYPE = 'S'                                
PERFOR                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_STATE_ID,                                            
MFA-TR*               CUSTOMER_NO,                                              
MFA-TR*               CUSTOMER_TYPE,                                            
MFA-TR*               DATE_OF_BIRTH,                                            
MFA-TR*               DRIVERS_LICENSE_NO,                                       
MFA-TR*               DRVR_LIC_ISS_DT,                                          
MFA-TR*               EMPLOYED_DATE,                                            
MFA-TR*               EMPLOYEE_NBR,                                             
MFA-TR*               EMPLOYER,                                                 
MFA-TR*               INTR_CO_IND,                                              
MFA-TR*               NAME_ID,                                                  
MFA-TR*               OCCUPATION,                                               
MFA-TR*               OTHER_ID,                                                 
MFA-TR*               OTHER_ID_TYPE,                                            
MFA-TR*               SSN                                                       
MFA-TR*        INTO :CE-CODE-STATE-ID,                                          
MFA-TR*             :CE-CUSTOMER-NO,                                            
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-DATE-OF-BIRTH :WS-NULL-IND1,                            
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                                     
MFA-TR*             :CE-DRVR-LIC-ISS-DT :WS-NULL-IND2,                          
MFA-TR*             :CE-EMPLOYED-DATE :WS-NULL-IND3,                            
MFA-TR*             :CE-EMPLOYEE-NBR,                                           
MFA-TR*             :CE-EMPLOYER,                                               
MFA-TR*             :CE-INTR-CO-IND,                                            
MFA-TR*             :CE-NAME-ID,                                                
MFA-TR*             :CE-OCCUPATION,                                             
MFA-TR*             :CE-OTHER-ID,                                               
MFA-TR*             :CE-OTHER-ID-TYPE,                                          
MFA-TR*             :CE-SSN                                                     
MFA-TR*        FROM CSS_CUST_STATS                                              
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                             
MFA-TR*        AND   CUSTOMER_TYPE = 'S'                                        
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 2150                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 2155-INSERT-IN-CSS-CUST-STATS THRU 2155-EXIT 
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'SELECT'              TO ABEND-FUNCTION         
                   MOVE '2150'                TO ACTIVE-PARAGRAPH       
                   MOVE SPACES                TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
                   MOVE 'CSS_CUST_STATS'      TO TABLE-1                
                   MOVE 'CUSTOMER_TYPE'       TO TABLE-ELEMENT-1        
                   MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2        
                   MOVE CE-CUSTOMER-TYPE      TO HOSTVAR-ELEMENT-1      
                   MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-2      
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
           END-EVALUATE.                                                
                                                                        
       2150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CUSTOMER NUMBER IN CSS_COAPPLICANT                    *         
      *****************************************************************         
                                                                        
T30585 2151-UPDATE-CSS-COAPPLICANT.                                     
                                                                        
T30585     EXEC SQL                                                     
T30585         UPDATE CSS_COAPPLICANT                                   
T30585            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
T30585          WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                    
                                                            
T30585     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_COAPPLICANT                                           
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 2151                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE 'UPDATE'              TO ABEND-FUNCTION             
               MOVE '2151'                TO ACTIVE-PARAGRAPH           
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_COAPPLICANT'     TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T30585 2151-EXIT.                                                       
T30585     EXIT.                                                        
                                                                        
C29943 2152-UPDATE-CSS-SEB-MIA-XREF.                                    
C29943                                                                  
C29943     EXEC SQL                                                     
C29943         UPDATE CSS_SEB_MIA_XREF                                  
C29943            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
C29943          WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                    
                                                            
C29943     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_SEB_MIA_XREF                                          
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 2152                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29943                                                                  
C29943     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29943     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29943         NEXT SENTENCE                                            
C29943     ELSE                                                         
C29943         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
C29943         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
C29943         MOVE 'UPDATE'              TO ABEND-FUNCTION             
C29943         MOVE '2152'                TO ACTIVE-PARAGRAPH           
C29943         MOVE SPACES                TO ABEND-SQL-PREDICATES       
C29943                                       ABEND-TABLES               
C29943         MOVE 'CSS_SEB_MIA_XREF'    TO TABLE-1                    
C29943         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
C29943         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
C29943         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
C29943         MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
C29943         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C29943         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C29943     END-IF.                                                      
C29943                                                                  
C29943 2152-EXIT.                                                       
C29943     EXIT.                                                        
                                                                        
      *****************************************************************         
      *  UPDATE CSS_NAME_ACCT_XREF                                    *         
      *****************************************************************         
                                                                        
T30585 2153-UPDATE-CSS-NAME-ACCT-XREF.                                  
T30585                                                                  
T30585     EXEC SQL                                                     
T30585         UPDATE CSS_NAME_ACCT_XREF                                
T30585            SET NAME_ID = :WS-NEW-NAME-ID                         
T30585           WHERE NAME_ID = :WS-OLD-NAME-ID                        
T30585             AND CUSTOMER_ROLE_CD IN ('A', 'B')                   
                                                            
T30585     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_NAME_ACCT_XREF                                        
MFA-TR*           SET NAME_ID = :WS-NEW-NAME-ID                                 
MFA-TR*          WHERE NAME_ID = :WS-OLD-NAME-ID                                
MFA-TR*            AND CUSTOMER_ROLE_CD IN ('A', 'B')                           
MFA-TR*        QUERYNO 2153                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T30585     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T30585     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T30585         NEXT SENTENCE                                            
T30585     ELSE                                                         
T30585         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T30585         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
T30585         MOVE 'UPDATE'                TO ABEND-FUNCTION           
T30585         MOVE '2153'                  TO ACTIVE-PARAGRAPH         
T30585         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
T30585                                         ABEND-TABLES             
T30585         MOVE 'CSS_NAME_ACCT_XREF'    TO TABLE-1                  
T30585         MOVE 'NAME_ID'        TO TABLE-ELEMENT-1                 
T30585         MOVE WS-OLD-NAME-ID          TO HOSTVAR-ELEMENT-1        
T30585         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T30585         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T30585     END-IF.                                                      
T30585                                                                  
T30585 2153-EXIT.                                                       
T30585     EXIT.                                                        
                                                                        
A00998*****************************************************************         
A00998*  UPDATE CREDIT TABLES                                         *         
A00998*****************************************************************         
A00998                                                                  
A00998 2154-UPDATE-CREDIT-TABLES.                                       
A00998                                                                  
A00998     MOVE ZEROS                         TO WS-NULL-IND1           
A00998                                           WS-NULL-IND2           
A00998                                           WS-NULL-IND3           
A00998                                           WS-NULL-IND4           
A00998                                           WS-NULL-IND5           
A00998                                           WS-NULL-IND6           
A00998                                           WS-NULL-IND7           
A00998                                           WS-NULL-IND9           
A00998                                           WS-NULL-IND8           
A00998                                           WS-NULL-IND10.         
A00998     MOVE WS-CUSTOMER-NUM               TO CK-CUSTOMER-NO.        
A00998     MOVE WS-CUSTOMER-NUM               TO LF-CUSTOMER-NO.        
A00998     PERFORM 7170-OPEN-CR-CURSOR        THRU 7170-EXIT.           
A00998     PERFORM 7180-FETCH-CR-CURSOR       THRU 7180-EXIT.           
A00998     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A00998       SET DEL-CRED-HIST                TO TRUE                   
A00998       PERFORM 7200-INSERT-CREDIT-HIST  THRU 7200-EXIT            
A00998       PERFORM 7180-FETCH-CR-CURSOR     THRU 7180-EXIT            
A00998     END-PERFORM.                                                 
A00998     PERFORM 7190-CLOSE-CR-CURSOR       THRU 7190-EXIT.           
A00998     MOVE ZEROS                         TO WS-NULL-IND1           
A00998                                           WS-NULL-IND2           
A00998                                           WS-NULL-IND3           
A00998                                           WS-NULL-IND4           
A00998                                           WS-NULL-IND5           
A00998                                           WS-NULL-IND6           
A00998                                           WS-NULL-IND7           
A00998                                           WS-NULL-IND8           
A00998                                           WS-NULL-IND9           
A00998                                           WS-NULL-IND10.         
A00998     PERFORM 7210-OPEN-ITPA-CURSOR      THRU 7210-EXIT.           
A00998     PERFORM 7215-FETCH-ITPA-CURSOR     THRU 7215-EXIT.           
A00998     PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
A00998       SET DEL-ITPA-HIST                TO TRUE                   
A00998       PERFORM 7218-INSERT-ITPA-HIST    THRU 7218-EXIT            
A00998       PERFORM 7215-FETCH-ITPA-CURSOR   THRU 7215-EXIT            
A00998     END-PERFORM.                                                 
A00998     PERFORM 7219-CLOSE-ITPA-CURSOR     THRU 7219-EXIT.           
A00998     PERFORM 7225-UPDATE-ITPA-PHONE     THRU 7225-EXIT.           
A00998     PERFORM 7220-UPDATE-CRED-HIST-ADDR THRU 7220-EXIT.           
A00998     PERFORM 7230-UPDATE-CRED-HIST-ACCT THRU 7230-EXIT.           
P00740     PERFORM 7250-UPDATE-CORRESP-HDR    THRU 7250-EXIT.           
P00740     PERFORM 7260-UPDATE-CORR-MAIL-STAT THRU 7260-EXIT.           
P00740     PERFORM 7270-UPDATE-ACCESS-HISTORY THRU 7270-EXIT.           
A00998     IF DEL-CRED-HIST                                             
A00998        PERFORM 7240-DELETE-CREDIT-HIST THRU 7240-EXIT            
A00998     END-IF.                                                      
A00998     IF DEL-ITPA-HIST                                             
A00998        PERFORM 7235-DELETE-CRED-ITPA-HIST THRU 7235-EXIT         
A00998     END-IF.                                                      
A00998                                                                  
A00998 2154-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
      *****************************************************************         
      *  INSERT INTO CSS_CUST_STATS                                   *         
      *****************************************************************         
                                                                        
       2155-INSERT-IN-CSS-CUST-STATS.                                   
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CUST_STATS                               
                   (CODE_STATE_ID,                                      
                    CUSTOMER_NO,                                        
                    CUSTOMER_TYPE,                                      
                    DATE_OF_BIRTH,                                      
                    DRIVERS_LICENSE_NO,                                 
                    DRVR_LIC_ISS_DT,                                    
                    EMPLOYED_DATE,                                      
                    EMPLOYEE_NBR,                                       
                    EMPLOYER,                                           
                    INTR_CO_IND,                                        
                    NAME_ID,                                            
                    OCCUPATION,                                         
                    OTHER_ID,                                           
                    OTHER_ID_TYPE,                                      
                    SSN)                                                
               VALUES                                                   
                   (:CE-CODE-STATE-ID,                                  
                    :WS-NEW-CUST-NUM,                                   
                    :CE-CUSTOMER-TYPE,                                  
                    IIF(TRY_CONVERT(DATE, :CE-DATE-OF-BIRTH 
                                          :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :CE-DATE-OF-BIRTH 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:CE-DATE-OF-BIRTH :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:CE-DATE-OF-BIRTH :WS-NULL-IND1
              ), CONVERT(DATE, :CE-DATE-OF-BIRTH :WS-NULL-IND1) ),             
                    :CE-DRIVERS-LICENSE-NO,                             
                    IIF(TRY_CONVERT(DATE, :CE-DRVR-LIC-ISS-DT 
                                          :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :CE-DRVR-LIC-ISS-DT 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:CE-DRVR-LIC-ISS-DT :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:CE-DRVR-LIC-ISS-DT :WS-NULL-IND2
              ), CONVERT(DATE, :CE-DRVR-LIC-ISS-DT :WS-NULL-IND2) ),           
                    IIF(TRY_CONVERT(DATE, :CE-EMPLOYED-DATE 
                                          :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :CE-EMPLOYED-DATE 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:CE-EMPLOYED-DATE :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:CE-EMPLOYED-DATE :WS-NULL-IND3
              ), CONVERT(DATE, :CE-EMPLOYED-DATE :WS-NULL-IND3) ),             
                    :CE-EMPLOYEE-NBR,                                   
                    :CE-EMPLOYER,                                       
                    :CE-INTR-CO-IND,                                    
                    :CE-NAME-ID,                                        
                    :CE-OCCUPATION,                                     
                    :CE-OTHER-ID,                                       
                    :CE-OTHER-ID-TYPE,                                  
                    :CE-SSN)                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CUST_STATS                                       
MFA-TR*            (CODE_STATE_ID,                                              
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             CUSTOMER_TYPE,                                              
MFA-TR*             DATE_OF_BIRTH,                                              
MFA-TR*             DRIVERS_LICENSE_NO,                                         
MFA-TR*             DRVR_LIC_ISS_DT,                                            
MFA-TR*             EMPLOYED_DATE,                                              
MFA-TR*             EMPLOYEE_NBR,                                               
MFA-TR*             EMPLOYER,                                                   
MFA-TR*             INTR_CO_IND,                                                
MFA-TR*             NAME_ID,                                                    
MFA-TR*             OCCUPATION,                                                 
MFA-TR*             OTHER_ID,                                                   
MFA-TR*             OTHER_ID_TYPE,                                              
MFA-TR*             SSN)                                                        
MFA-TR*        VALUES                                                           
MFA-TR*            (:CE-CODE-STATE-ID,                                          
MFA-TR*             :WS-NEW-CUST-NUM,                                           
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-DATE-OF-BIRTH :WS-NULL-IND1,                            
MFA-TR*             :CE-DRIVERS-LICENSE-NO,                                     
MFA-TR*             :CE-DRVR-LIC-ISS-DT :WS-NULL-IND2,                          
MFA-TR*             :CE-EMPLOYED-DATE :WS-NULL-IND3,                            
MFA-TR*             :CE-EMPLOYEE-NBR,                                           
MFA-TR*             :CE-EMPLOYER,                                               
MFA-TR*             :CE-INTR-CO-IND,                                            
MFA-TR*             :CE-NAME-ID,                                                
MFA-TR*             :CE-OCCUPATION,                                             
MFA-TR*             :CE-OTHER-ID,                                               
MFA-TR*             :CE-OTHER-ID-TYPE,                                          
MFA-TR*             :CE-SSN)                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR ALREADY-EXISTS 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'INSERT'                TO ABEND-FUNCTION           
               MOVE '2155'                  TO ACTIVE-PARAGRAPH         
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_CUST_STATS'        TO TABLE-1                  
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
               MOVE 'CUSTOMER_TYPE'         TO TABLE-ELEMENT-2          
               MOVE WS-NEW-CUST-NUM         TO HOSTVAR-ELEMENT-1        
               MOVE CE-CUSTOMER-TYPE        TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
T21759     PERFORM 2160-DELETE-CSS-CUST-STATS THRU 2160-EXIT.           
A02665     PERFORM 2161-UPDATE-SPOUSE-PHONE THRU 2161-EXIT.             
                                                                        
       2155-EXIT.                                                       
           EXIT.                                                        
                                                                        
A01255 2156-UPDATE-CSS-PREM-GAS-LINE.                                   
A01255                                                                  
A01255     EXEC SQL                                                     
A01255         UPDATE CSS_PREM_GAS_LINE                                 
A01255            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
A01255          WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                    
                                                            
A01255     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_PREM_GAS_LINE                                         
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 2156                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01255                                                                  
A01255     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A01255     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A01255         NEXT SENTENCE                                            
A01255     ELSE                                                         
A01255         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A01255         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A01255         MOVE 'UPDATE'              TO ABEND-FUNCTION             
A01255         MOVE '2156'                TO ACTIVE-PARAGRAPH           
A01255         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A01255                                       ABEND-TABLES               
A01255         MOVE 'CSS_PREM_GAS_LINE'   TO TABLE-1                    
A01255         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
A01255         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
A01255         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
A01255         MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
A01255         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A01255         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A01255     END-IF.                                                      
A01255                                                                  
A01255 2156-EXIT.                                                       
A01255     EXIT.                                                        
                                                                        
A05317 2157-UPDATE-CSS-CUST-ADDR-XREF.                                  
A05317                                                                  
A05317     EXEC SQL                                                     
A05317         UPDATE CSS_CUST_ADDR_XREF                                
A05317            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
A05317          WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                    
A05317                                                      
A05317     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_ADDR_XREF                                        
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 2157                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A05317                                                                  
A05317     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A05317     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
A05317        ALREADY-EXISTS                                            
A05317            NEXT SENTENCE                                         
A05317     ELSE                                                         
A05317         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A05317         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A05317         MOVE 'UPDATE'              TO ABEND-FUNCTION             
A05317         MOVE '2157'                TO ACTIVE-PARAGRAPH           
A05317         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A05317                                       ABEND-TABLES               
A05317         MOVE 'CSS_CUST_ADDR_XREF'  TO TABLE-1                    
A05317         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
A05317         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
A05317         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
A05317         MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
A05317         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A05317         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A05317     END-IF.                                                      
A05317                                                                  
A05317 2157-EXIT.                                                       
A05317     EXIT.                                                        
                                                                        
T21759******************************************************************        
T21759* DELETE FROM CSS_CUST_STATS AND CSS_NAME_ACCT_XREF OF           *        
T21759* OLD CUSTOMER AFTER SPOUSE INFO IS INSERTED FOR NEW CUSTOMER    *        
T21759******************************************************************        
T21759                                                                  
T21759 2160-DELETE-CSS-CUST-STATS.                                      
T21759                                                                  
T21759     EXEC SQL                                                     
T21759         DELETE FROM CSS_CUST_STATS                               
T21759           WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                   
T21759           AND CUSTOMER_TYPE = 'S'                                
                                                           
T21759     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CUST_STATS                                       
MFA-TR*          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                           
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*        QUERYNO 21601                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21759                                                                  
T21759     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21759     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T21759         NEXT SENTENCE                                            
T21759     ELSE                                                         
T21759         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21759         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
T21759         MOVE 'DELETE'                TO ABEND-FUNCTION           
T21759         MOVE '2160'                  TO ACTIVE-PARAGRAPH         
T21759         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
T21759                                         ABEND-TABLES             
T21759         MOVE 'CSS_CUST_STATS'        TO TABLE-1                  
T21759         MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
T21759         MOVE 'CUSTOMER_TYPE'         TO TABLE-ELEMENT-2          
T21759         MOVE WS-CUSTOMER-NUM         TO HOSTVAR-ELEMENT-1        
T21759         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21759         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21759     END-IF.                                                      
T21759                                                                  
T21759     EXEC SQL                                                     
T21759         DELETE FROM CSS_NAME_ACCT_XREF                           
T21759           WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                   
T21759           AND NAME_ID = :CE-NAME-ID                              
                                                           
T21759     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_NAME_ACCT_XREF                                   
MFA-TR*          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                           
MFA-TR*          AND NAME_ID = :CE-NAME-ID                                      
MFA-TR*        QUERYNO 21602                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21759                                                                  
T21759     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T21759     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T21759         NEXT SENTENCE                                            
T21759     ELSE                                                         
T21759         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
T21759         MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
T21759         MOVE 'DELETE'                TO ABEND-FUNCTION           
T21759         MOVE '2160'                  TO ACTIVE-PARAGRAPH         
T21759         MOVE SPACES                  TO ABEND-SQL-PREDICATES     
T21759                                         ABEND-TABLES             
T21759         MOVE 'CSS_NAME_ACCT_XREF'    TO TABLE-1                  
T21759         MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-1          
T21759         MOVE 'NAME_ID'               TO TABLE-ELEMENT-2          
T21759         MOVE WS-CUSTOMER-NUM         TO HOSTVAR-ELEMENT-1        
T21759         MOVE CE-NAME-ID              TO HOSTVAR-ELEMENT-2        
T21759         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21759         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21759     END-IF.                                                      
T21759                                                                  
T21759 2160-EXIT.                                                       
           EXIT.                                                        
                                                                        
A02665 2161-UPDATE-SPOUSE-PHONE.                                        
A02665                                                                  
A02665     EXEC SQL                                                     
A02665         UPDATE CSS_CUST_PHONE                                    
A02665            SET CUSTOMER_NO =:WS-NEW-CUST-NUM                     
A02665          WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                    
A02665            AND CUSTOMER_TYPE = 'S'                               
                                                           
A02665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CUST_PHONE                                            
MFA-TR*           SET CUSTOMER_NO =:WS-NEW-CUST-NUM                             
MFA-TR*         WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                            
MFA-TR*           AND CUSTOMER_TYPE = 'S'                                       
MFA-TR*        QUERYNO 21611                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02665                                                                  
A02665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02665     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND OR   
A02665                                ALREADY-EXISTS                    
A02665         NEXT SENTENCE                                            
A02665     ELSE                                                         
A02665         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A02665         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A02665         MOVE 'UPDATE'              TO ABEND-FUNCTION             
A02665         MOVE '2161'                TO ACTIVE-PARAGRAPH           
A02665         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A02665                                       ABEND-TABLES               
A02665         MOVE 'CSS_CUST_PHONE'      TO TABLE-1                    
A02665         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A02665         MOVE WS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
A02665         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
A02665         MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
A02665         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A02665         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A02665     END-IF.                                                      
A02665                                                                  
A02665*  DELETE PHONE ROW FOR OLD CUSTOMER IF PHONE ROW EXISTS                  
A02665*  FOR NEW CUSTOMER ALREADY                                               
A02665                                                                  
A02665     EXEC SQL                                                     
A02665         DELETE FROM CSS_CUST_PHONE                               
A02665          WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                    
A02665            AND CUSTOMER_TYPE = 'S'                               
                                                           
A02665     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CUST_PHONE                                       
MFA-TR*         WHERE CUSTOMER_NO  =:WS-CUSTOMER-NUM                            
MFA-TR*           AND CUSTOMER_TYPE = 'S'                                       
MFA-TR*        QUERYNO 21612                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02665                                                                  
A02665     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A02665     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A02665         NEXT SENTENCE                                            
A02665     ELSE                                                         
A02665         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A02665         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A02665         MOVE 'DELETE'              TO ABEND-FUNCTION             
A02665         MOVE '2161'                TO ACTIVE-PARAGRAPH           
A02665         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A02665                                       ABEND-TABLES               
A02665         MOVE 'CSS_CUST_PHONE'      TO TABLE-1                    
A02665         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A02665         MOVE WS-CUSTOMER-NO        TO HOSTVAR-ELEMENT-1          
A02665         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A02665         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A02665     END-IF.                                                      
A02665                                                                  
A02665 2161-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
C31606******************************************************************        
C31606* INSERT BANK INFO FOR NEW CUSTOMER                            *          
C31606******************************************************************        
C31606                                                                  
C31606 2165-INSERT-BANK-INFO.                                           
C31606                                                                  
C31606     PERFORM 7166-GET-NEW-CUST-BANK-SEQ     THRU 7166-EXIT.       
C31606     PERFORM 2167-CREATE-NEW-NICKNM         THRU 2167-EXIT.       
C31606     PERFORM 8168-INSERT-CSS-CUSTOMER-BANK  THRU 8168-EXIT.       
C31606                                                                  
C31606 2165-EXIT.                                                       
C31606     EXIT.                                                        
C31606                                                                  
C31606*****************************************************************         
C31606*  CREATE NEW BANK_ACCT_NICKNAME                                *         
C31606*****************************************************************         
C31606                                                                  
C31606 2167-CREATE-NEW-NICKNM.                                          
C31606     MOVE WS-NEW-CUST-BANK-SEQ TO WS-NEW-CUST-BANK-SEQ-CH         
C31606     MOVE WS-NEW-CUST-BANK-SEQ-CH(8:2) TO                         
C31606          WS-NEW-CUST-BANK-SEQ-01                                 
C31606                                                                  
C31606     STRING JF-BANK-ACCT-NICKNAME-TEXT DELIMITED BY SPACES        
C31606            WS-UNDERSCORE              DELIMITED BY SIZE          
C31606            WS-NEW-CUST-BANK-SEQ-01    DELIMITED BY SIZE          
C31606       INTO WS-NEW-ACCT-NICKNAME-TEXT.                            
C31606     MOVE 50  TO WS-NEW-ACCT-NICKNAME-LEN.                        
C31606     MOVE WS-NEW-ACCT-NICKNAME TO JF-BANK-ACCT-NICKNAME.          
C31606                                                                  
C31606 2167-EXIT.                                                       
C31606     EXIT.                                                        
                                                                        
      *****************************************************************         
      * DELETE FROM CSS_NAME_ACCT_XREF                                 *        
      ******************************************************************        
                                                                        
       2200-DELETE-CSS-NAME-ACCT-XREF.                                  
                                                                        
           EXEC SQL                                                     
               DELETE FROM CSS_NAME_ACCT_XREF                           
                 WHERE CUSTOMER_NO = :WS-NEW-CUST-NUM                   
                 AND ACCOUNT_NO = 0                                     
                 AND ADDRESS_ID = 0                                     
                 AND PREMISE_NO = 0                                     
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_NAME_ACCT_XREF                                   
MFA-TR*          WHERE CUSTOMER_NO = :WS-NEW-CUST-NUM                           
MFA-TR*          AND ACCOUNT_NO = 0                                             
MFA-TR*          AND ADDRESS_ID = 0                                             
MFA-TR*          AND PREMISE_NO = 0                                             
MFA-TR*        QUERYNO 2200                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE PROGRAM-NAME            TO ABEND-PROGRAM            
               MOVE 'DELETE'                TO ABEND-FUNCTION           
               MOVE '2200'                  TO ACTIVE-PARAGRAPH         
               MOVE SPACES                  TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
               MOVE 'CSS_NAME_ACCT_XREF'    TO TABLE-1                  
               MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1          
               MOVE 'CUSTOMER_NO'           TO TABLE-ELEMENT-2          
               MOVE 'ADDRESS_ID'            TO TABLE-ELEMENT-3          
               MOVE 'PREMISE_NO'            TO TABLE-ELEMENT-4          
               MOVE WS-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1        
               MOVE WS-NEW-CUST-NO          TO HOSTVAR-ELEMENT-2        
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C35344****************************************************************          
C35344*  GET SPOUSE NAME_ID IN CSS_NAME_ACCT_XREF                 *             
C35344*****************************************************************         
                                                                        
C35344 2210-GET-SP-NAME-ACCT-XREF.                                      
                                                                        
C35344     MOVE '2210' TO ACTIVE-PARAGRAPH.                             
                                                                        
C35344     EXEC SQL                                                     
C35344       SELECT CN.NAME_ID                                          
C35344         INTO :WS-OLD-SP-NAME-ID                                  
C35344      FROM CSS_NAME_ACCT_XREF CN, CSS_NAME NM                     
C35344       WHERE CN.ACCOUNT_NO =:HT-ACCOUNT-NO                        
C35344            AND CN.NAME_ID = NM.NAME_ID                           
C35344           AND NM.NAME_TYPE = 'SN'                                
                                                            
C35344     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CN.NAME_ID                                                  
MFA-TR*        INTO :WS-OLD-SP-NAME-ID                                          
MFA-TR*     FROM CSS_NAME_ACCT_XREF CN, CSS_NAME NM                             
MFA-TR*      WHERE CN.ACCOUNT_NO =:HT-ACCOUNT-NO                                
MFA-TR*           AND CN.NAME_ID = NM.NAME_ID                                   
MFA-TR*          AND NM.NAME_TYPE = 'SN'                                        
MFA-TR*        QUERYNO 2210                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C35344     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C35344     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C35344          NEXT SENTENCE                                           
C35344      ELSE                                                        
C35344          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE            
C35344          MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
C35344          MOVE 'SELECT'              TO ABEND-FUNCTION            
C35344          MOVE '2210'                TO ACTIVE-PARAGRAPH          
C35344          MOVE SPACES                TO ABEND-SQL-PREDICATES      
C35344                                       ABEND-TABLES               
C35344          MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                   
C35344          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1           
C35344          MOVE HT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
C35344          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
C35344          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
C35344     END-IF.                                                      
                                                                        
C35344 2210-EXIT.                                                       
C35344     EXIT.                                                        
                                                                        
C35344*****************************************************************         
C35344* SELECT FROM CSS_CUST_STATS IF THE CUSTOMER HAS A SPOUSE.                
C35344*****************************************************************         
C35344 2220-SELECT-CSS-CUST-STATS.                                      
                                                                        
C35344     MOVE '2220'       TO ACTIVE-PARAGRAPH.                       
                                                                        
C35344     EXEC SQL                                                     
C35344       SELECT CUSTOMER_NO,                                        
C35344              CUSTOMER_TYPE,                                      
C35344              NAME_ID                                             
C35344         INTO :CE-CUSTOMER-NO,                                    
C35344              :CE-CUSTOMER-TYPE,                                  
C35344              :CE-NAME-ID                                         
C35344         FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                        
C35344         WHERE CUSTOMER_NO = :WS-NEW-CUST-NUM                     
C35344           AND CUSTOMER_TYPE = 'S'                                
C35344                                                           
                                                            
C35344      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CUSTOMER_NO,                                                
MFA-TR*             CUSTOMER_TYPE,                                              
MFA-TR*             NAME_ID                                                     
MFA-TR*        INTO :CE-CUSTOMER-NO,                                            
MFA-TR*             :CE-CUSTOMER-TYPE,                                          
MFA-TR*             :CE-NAME-ID                                                 
MFA-TR*        FROM CSS_CUST_STATS                                              
MFA-TR*        WHERE CUSTOMER_NO = :WS-NEW-CUST-NUM                             
MFA-TR*          AND CUSTOMER_TYPE = 'S'                                        
MFA-TR*       WITH UR                                                           
MFA-TR*        QUERYNO 2220                                                     
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C35344      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
C35344      EVALUATE WS-ACTIVE-RETURN-CODE                              
C35344        WHEN SUCCESSFUL-CALL                                      
C35344            MOVE CE-NAME-ID        TO   WS-NEW-SP-NAME-ID         
C35344            PERFORM 2240-INSERT-SP-NAME-ACCT-XREF  THRU 2240-EXIT 
C35344        WHEN NOT-FOUND                                            
C35344            CONTINUE                                              
C35344        WHEN OTHER                                                
C35344            MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
C35344            MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
C35344            MOVE 'SELECT'              TO ABEND-FUNCTION          
C35344            MOVE '2220'                TO ACTIVE-PARAGRAPH        
C35344            MOVE SPACES                TO ABEND-SQL-PREDICATES    
C35344                                         ABEND-TABLES             
C35344            MOVE 'CSS_CUST_STATS'      TO TABLE-1                 
C35344            MOVE 'CUSTOMER_TYPE'       TO TABLE-ELEMENT-1         
C35344            MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2         
C35344            MOVE CE-CUSTOMER-TYPE      TO HOSTVAR-ELEMENT-1       
C35344            MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-2       
C35344            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
C35344            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
C35344     END-EVALUATE.                                                
                                                                        
C35344  2220-EXIT.                                                      
C35344      EXIT.                                                       
C35344***************************************************************           
C35344*  2230-MOVE SPOUSE NAME_ID TO UPDATE CSS_NAME_ACCT_XREF                  
C35344***************************************************************           
                                                                        
C35344 2230-MOVE-SP-NAME-ACCT-XREF.                                     
                                                                        
C35344     MOVE '2230' TO ACTIVE-PARAGRAPH.                             
                                                                        
C35344     EXEC SQL                                                     
C35344       SELECT TOP(1) CN.NAME_ID                                          
C35344          INTO :WS-NEW-SP-NAME-ID                                 
C35344        FROM CSS_NAME_ACCT_XREF CN,                               
C35344             CSS_NAME NM                                          
C35344       WHERE CN.CUSTOMER_NO = :WS-NEW-CUST-NUM                    
C35344            AND CN.NAME_ID = NM.NAME_ID                           
C35344            AND NM.NAME_TYPE = 'SN'                               
C35344                                           
                                                            
C35344     END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CN.NAME_ID                                                  
MFA-TR*         INTO :WS-NEW-SP-NAME-ID                                         
MFA-TR*       FROM CSS_NAME_ACCT_XREF CN,                                       
MFA-TR*            CSS_NAME NM                                                  
MFA-TR*      WHERE CN.CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*           AND CN.NAME_ID = NM.NAME_ID                                   
MFA-TR*           AND NM.NAME_TYPE = 'SN'                                       
MFA-TR*       FETCH FIRST 1 ROWS ONLY                                           
MFA-TR*        QUERYNO 2230                                                     
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C35344     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C35344     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C35344         NEXT SENTENCE                                            
C35344     ELSE                                                         
C35344         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
C35344         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
C35344         MOVE 'UPDATE'              TO ABEND-FUNCTION             
C35344         MOVE '2230'                TO ACTIVE-PARAGRAPH           
C35344         MOVE SPACES                TO ABEND-SQL-PREDICATES       
C35344                                       ABEND-TABLES               
C35344         MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                    
C35344         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
C35344         MOVE WS-NEW-CUST-NUM      TO HOSTVAR-ELEMENT-1           
C35344         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C35344         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C35344     END-IF.                                                      
                                                                        
C35344 2230-EXIT.                                                       
C35344     EXIT.                                                        
                                                                        
C35344******************************************************************        
C35344*  INSERT INTO CSS_NAME_ACCT_XREF FOR SPOUSE                    *         
C35344*****************************************************************         
                                                                        
C35344 2240-INSERT-SP-NAME-ACCT-XREF.                                   
                                                                        
C35344      MOVE '2240'     TO ACTIVE-PARAGRAPH.                        
                                                                        
C35344     EXEC SQL                                                     
C35344        SELECT NM.NAME_ID,                                        
C35344               NM.ACCOUNT_NO,                                     
C35344               NM.ADDRESS_ID,                                     
C35344               NM.COMPANY_NO,                                     
C35344               NM.CUSTOMER_NO,                                    
C35344               NM.PREMISE_NO,                                     
C35344               NM.STATE,                                          
C35344               NM.TOWN,                                           
C35344               NM.LOCAL_OFFICE,                                   
P00594               NM.ACCOUNT_TYPE_CODE,                              
P00594               NM.CODE_ACCT_STAT                                  
C35344           INTO :HT-NAME-ID,                                      
C35344                :HT-ACCOUNT-NO,                                   
C35344                :HT-ADDRESS-ID,                                   
C35344                :HT-COMPANY-NO,                                   
C35344                :HT-CUSTOMER-NO,                                  
C35344                :HT-PREMISE-NO,                                   
C35344                :HT-STATE,                                        
C35344                :HT-TOWN,                                         
C35344                :HT-LOCAL-OFFICE,                                 
P00594                :HT-ACCOUNT-TYPE-CODE,                            
P00594                :HT-CODE-ACCT-STAT                                
C35344           FROM CSS_NAME_ACCT_XREF NM,                            
C35344                CSS_NAME NA                                       
C35344           WHERE NM.CUSTOMER_NO = :WS-NEW-CUST-NUM                
C35344               AND NM.ACCOUNT_NO = :HT-ACCOUNT-NO                 
C35344               AND NM.NAME_ID = NA.NAME_ID                        
C35344               AND NA.NAME_TYPE = 'CN'                            
C35344               AND CUSTOMER_ROLE_CD = ''                          
                                                            
C35344        END-EXEC                                                  

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT NM.NAME_ID,                                                
MFA-TR*              NM.ACCOUNT_NO,                                             
MFA-TR*              NM.ADDRESS_ID,                                             
MFA-TR*              NM.COMPANY_NO,                                             
MFA-TR*              NM.CUSTOMER_NO,                                            
MFA-TR*              NM.PREMISE_NO,                                             
MFA-TR*              NM.STATE,                                                  
MFA-TR*              NM.TOWN,                                                   
MFA-TR*              NM.LOCAL_OFFICE,                                           
MFA-TR*              NM.ACCOUNT_TYPE_CODE,                                      
MFA-TR*              NM.CODE_ACCT_STAT                                          
MFA-TR*          INTO :HT-NAME-ID,                                              
MFA-TR*               :HT-ACCOUNT-NO,                                           
MFA-TR*               :HT-ADDRESS-ID,                                           
MFA-TR*               :HT-COMPANY-NO,                                           
MFA-TR*               :HT-CUSTOMER-NO,                                          
MFA-TR*               :HT-PREMISE-NO,                                           
MFA-TR*               :HT-STATE,                                                
MFA-TR*               :HT-TOWN,                                                 
MFA-TR*               :HT-LOCAL-OFFICE,                                         
MFA-TR*               :HT-ACCOUNT-TYPE-CODE,                                    
MFA-TR*               :HT-CODE-ACCT-STAT                                        
MFA-TR*          FROM CSS_NAME_ACCT_XREF NM,                                    
MFA-TR*               CSS_NAME NA                                               
MFA-TR*          WHERE NM.CUSTOMER_NO = :WS-NEW-CUST-NUM                        
MFA-TR*              AND NM.ACCOUNT_NO = :HT-ACCOUNT-NO                         
MFA-TR*              AND NM.NAME_ID = NA.NAME_ID                                
MFA-TR*              AND NA.NAME_TYPE = 'CN'                                    
MFA-TR*              AND CUSTOMER_ROLE_CD = ''                                  
MFA-TR*        QUERYNO 2240                                                     
MFA-TR*       END-EXEC                                                          

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C35344     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
C35344     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C35344         NEXT SENTENCE                                            
C35344      ELSE                                                        
C35344          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE            
C35344          MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
C35344          MOVE 'SELECT'              TO ABEND-FUNCTION            
C35344          MOVE '2240'                TO ACTIVE-PARAGRAPH          
C35344          MOVE SPACES                TO ABEND-SQL-PREDICATES      
C35344                                        ABEND-TABLES              
C35344          MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                   
C35344          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1           
C35344          MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2           
C35344          MOVE  HT-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1         
C35344          MOVE  WS-NEW-CUST-NUM    TO HOSTVAR-ELEMENT-2           
C35344          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
C35344          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
C35344      END-IF.                                                     
C35344                                                                  
C35344      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C35344        MOVE CE-NAME-ID TO HT-NAME-ID                             
C35344      EXEC SQL                                                    
C35344          INSERT INTO CSS_NAME_ACCT_XREF                          
C35344              (NAME_ID,                                           
C35344               ACCOUNT_NO,                                        
C35344               ADDRESS_ID,                                        
C35344               COMPANY_NO,                                        
C35344               CUSTOMER_NO,                                       
C35344               PREMISE_NO,                                        
C35344               STATE,                                             
C35344               TOWN,                                              
C35344               LOCAL_OFFICE,                                      
P00594               ACCOUNT_TYPE_CODE,                                 
P00594               CODE_ACCT_STAT)                                    
C35344        VALUES  (:HT-NAME-ID,                                     
C35344                :HT-ACCOUNT-NO,                                   
C35344                :HT-ADDRESS-ID,                                   
C35344                :HT-COMPANY-NO,                                   
C35344                :HT-CUSTOMER-NO,                                  
C35344                :HT-PREMISE-NO,                                   
C35344                :HT-STATE,                                        
C35344                :HT-TOWN,                                         
C35344                :HT-LOCAL-OFFICE,                                 
P00594                :HT-ACCOUNT-TYPE-CODE,                            
P00594                :HT-CODE-ACCT-STAT)                               
C35344       END-EXEC                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C35344      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                       
                                                                        
C35344      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C35344          NEXT SENTENCE                                           
C35344      ELSE                                                        
C35344          MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE            
C35344          MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
C35344          MOVE 'INSERT'              TO ABEND-FUNCTION            
C35344          MOVE '2240'                TO ACTIVE-PARAGRAPH          
C35344          MOVE SPACES                TO ABEND-SQL-PREDICATES      
C35344                                        ABEND-TABLES              
C35344          MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                   
C35344          MOVE 'NAME_ID'             TO TABLE-ELEMENT-1           
C35344          MOVE HT-NAME-ID            TO HOSTVAR-ELEMENT-1         
C35344          PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT          
C35344          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
C35344     END-IF                                                       
C35344     END-IF.                                                      
                                                                        
C35344  2240-EXIT.                                                      
C35344      EXIT.                                                       
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
                                                                        
       5000-MOVE-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     03840095
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                    03860095

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5000'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SELECT'        TO ABEND-FUNCTION                   
               MOVE  SPACES         TO ABEND-SQL-PREDICATES             
                                       ABEND-TABLES                     
               MOVE 'SET '          TO TABLE-1                          
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE WS-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           EXEC SQL                                                     
               SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-DATE-TRANS                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SET :MH-DATE-TRANS = CURRENT DATE                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5000'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SELECT'        TO ABEND-FUNCTION                   
               MOVE  SPACES         TO ABEND-SQL-PREDICATES             
                                       ABEND-TABLES                     
               MOVE 'SET '          TO TABLE-1                          
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE WS-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE 'F'                TO MH-CODE-TRAN-TYPE.                
           MOVE 437                TO MH-RESP-AREA-ID.                  
           MOVE 0                  TO MH-PREMISE-NO.                    
           MOVE WS-NEW-CUST-NUM    TO MH-CUSTOMER-NO.                   
           MOVE WS-ACCOUNT-NUM     TO MH-ACCOUNT-NO.                    
           MOVE PARM-USER-ID       TO MH-USER-ID.                       
T22880     MOVE 'PANEL005'         TO MH-APPL-PROGRAM-ID.               
           MOVE 'CUSTOMER NUMBER CHANGE' TO MH-TRAN-COMMENT-TEXT.       
           MOVE +22                TO MH-TRAN-COMMENT-LEN.              
                                                                        
           PERFORM 5200-ACCT-TRAN-DET THRU 5200-EXIT.                   
                                                                        
           EXEC SQL                                                     
              SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :MH-TRANS-HIST-SEQ-NO             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME    TO ABEND-PROGRAM                    
               MOVE '5000'          TO ACTIVE-PARAGRAPH                 
               MOVE 'SELECT'        TO ABEND-FUNCTION                   
               MOVE  SPACES         TO ABEND-SQL-PREDICATES             
                                       ABEND-TABLES                     
               MOVE 'SET '          TO TABLE-1                          
               MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-1                  
               MOVE WS-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
           MOVE 'F'                TO MH-CODE-TRAN-TYPE.                
           MOVE 437                TO MH-RESP-AREA-ID.                  
           MOVE 0                  TO MH-PREMISE-NO.                    
           MOVE WS-CUSTOMER-NUM    TO MH-CUSTOMER-NO.                   
           MOVE 0                  TO MH-ACCOUNT-NO.                    
           MOVE PARM-USER-ID       TO MH-USER-ID.                       
T22880     MOVE 'PANEL005'         TO MH-APPL-PROGRAM-ID.               
           MOVE 'CUSTOMER NUMBER CHANGE' TO MH-TRAN-COMMENT-TEXT.       
           MOVE +22                TO MH-TRAN-COMMENT-LEN.              
                                                                        
           PERFORM 5210-CUST-TRAN-DET THRU 5210-EXIT.                   
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5200-ACCT-TRAN-DET.                                              
                                                                        
           MOVE '5200'               TO ACTIVE-PARAGRAPH.               
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE 1                    TO WS-TRAN-APPL-NO.                
                                                                        
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE PARM-NEW-CUST-NO     TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE PARM-CUSTOMER-NO     TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE 'CUSTOMER NUMBER'    TO MI-COLUMN-DESC.                 
           MOVE ' '                  TO MI-TABLE-ID.                    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                     TO WS-TRAN-APPL-NO.                
                                                                        
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           MOVE +25                  TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE +1                   TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE ' '                  TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE PARM-OLD-CUST-NAME   TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE 'PREV CUST NAME'     TO MI-COLUMN-DESC.                 
           MOVE ' '                  TO MI-TABLE-ID.                    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           MOVE 0                    TO WS-TRAN-APPL-NO.                
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       5210-CUST-TRAN-DET.                                              
                                                                        
           MOVE '5210'               TO ACTIVE-PARAGRAPH.               
           MOVE MH-TRANS-HIST-SEQ-NO TO MI-TRANS-HIST-SEQ-NO.           
           MOVE 1                    TO WS-TRAN-APPL-NO.                
                                                                        
           MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
           MOVE +13                  TO MI-PRV-COLUMN-VALUE-LEN.        
           MOVE +14                  TO MI-CHG-COLUMN-VALUE-LEN.        
           MOVE 'HAS BEEN MOVED'     TO MI-CHG-COLUMN-VALUE-TEXT.       
           MOVE WS-ACCOUNT-NUM       TO MI-PRV-COLUMN-VALUE-TEXT.       
           MOVE 'ACCOUNT NUMBER'     TO MI-COLUMN-DESC.                 
           MOVE ' '                  TO MI-TABLE-ID.                    
           PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           ADD 1                     TO WS-TRAN-APPL-NO.                
                                                                        
T21688     MOVE WS-TRAN-APPL-NO      TO MI-TRAN-APPL-NO.                
T21688     MOVE +10                  TO MI-PRV-COLUMN-VALUE-LEN.        
T21688     MOVE +10                  TO MI-CHG-COLUMN-VALUE-LEN.        
T21688     MOVE PARM-NEW-CUST-NO     TO MI-CHG-COLUMN-VALUE-TEXT.       
T21688     MOVE PARM-CUSTOMER-NO     TO MI-PRV-COLUMN-VALUE-TEXT.       
T21688     MOVE 'CUSTOMER NUMBER'    TO MI-COLUMN-DESC.                 
T21688     MOVE ' '                  TO MI-TABLE-ID.                    
T21688     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
           MOVE 0                    TO WS-TRAN-APPL-NO.                
                                                                        
       5210-EXIT.                                                       
           EXIT.                                                        
                                                                        
C31606*****************************************************************         
C31606*  SELECT FROM CSS_PNDNG_BNK_DRAFT IF ANY PENDING EPAY/DRAFT    *         
C31606*****************************************************************         
C31606                                                                  
C31606 7161-SELECT-PNDNG-BNK-DRFT.                                      
C31606                                                                  
C31606     EXEC SQL                                                     
C31606     SELECT     ACCOUNT_NO,                                       
C31606                DRAFT_DATE,                                       
C31606                DRAFT_AMT,                                        
C31606                TRANSACTION_CD,                                   
C31606                CODE_SOURCE_ID,                                   
C31606                CUST_BANK_SEQ_NO,                                 
C31606                PYMT_POSTED_FL,                                   
C31606                REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_TRANS_TS
           , 121), ' ', '-'), ':', '.') PYMT_TRANS_TS                          
C31606         INTO :PB-ACCOUNT-NO,                                     
C31606              :PB-DRAFT-DATE,                                     
C31606              :PB-DRAFT-AMT,                                      
C31606              :PB-TRANSACTION-CD,                                 
C31606              :PB-CODE-SOURCE-ID,                                 
C31606              :PB-CUST-BANK-SEQ-NO,                               
C31606              :PB-PYMT-POSTED-FL,                                 
C31606              :PB-PYMT-TRANS-TS                                   
C31606         FROM CSS_PNDNG_BNK_DRFT WITH(READUNCOMMITTED)                    
C31606         WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                       
PERFOR                                                           
                                                            
C31606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*    SELECT     ACCOUNT_NO,                                               
MFA-TR*               DRAFT_DATE,                                               
MFA-TR*               DRAFT_AMT,                                                
MFA-TR*               TRANSACTION_CD,                                           
MFA-TR*               CODE_SOURCE_ID,                                           
MFA-TR*               CUST_BANK_SEQ_NO,                                         
MFA-TR*               PYMT_POSTED_FL,                                           
MFA-TR*               PYMT_TRANS_TS                                             
MFA-TR*        INTO :PB-ACCOUNT-NO,                                             
MFA-TR*             :PB-DRAFT-DATE,                                             
MFA-TR*             :PB-DRAFT-AMT,                                              
MFA-TR*             :PB-TRANSACTION-CD,                                         
MFA-TR*             :PB-CODE-SOURCE-ID,                                         
MFA-TR*             :PB-CUST-BANK-SEQ-NO,                                       
MFA-TR*             :PB-PYMT-POSTED-FL,                                         
MFA-TR*             :PB-PYMT-TRANS-TS                                           
MFA-TR*        FROM CSS_PNDNG_BNK_DRFT                                          
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7161                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31606                                                                  
C31606     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31606     EVALUATE WS-ACTIVE-RETURN-CODE                               
C31606         WHEN SUCCESSFUL-CALL                                     
C31606         WHEN -811                                                
C31606             MOVE 1 TO WS-IS-PEND-PAY                             
C31606         WHEN NOT-FOUND                                           
C31606             CONTINUE                                             
C31606         WHEN OTHER                                               
C31606             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
C31606             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C31606             MOVE 'SELECT'              TO ABEND-FUNCTION         
C31606             MOVE '7161'                TO ACTIVE-PARAGRAPH       
C31606             MOVE SPACES                TO ABEND-SQL-PREDICATES   
C31606                                           ABEND-TABLES           
C31606             MOVE 'CSS_PNDNG_BNK_DRFT'  TO TABLE-1                
C31606             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
C31606             MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1      
C31606             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
C31606             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
C31606     END-EVALUATE.                                                
C31606                                                                  
C31606 7161-EXIT.                                                       
C31606     EXIT.                                                        
C31606                                                                  
C31606*****************************************************************         
C31606*  RETRIEVE CUST_BANK_SEQ_NO FOR THE ACCOUNT_NO                 *         
C31606*****************************************************************         
C31606                                                                  
C31606 7162-GET-CUST-BANK-SEQ-NO.                                       
C31606                                                                  
C31606     EXEC SQL                                                     
C31606         SELECT CUST_BANK_SEQ_NO                                  
C31606         INTO :BE-CUST-BANK-SEQ-NO                                
C31606         FROM CSS_BANK_EFT WITH(READUNCOMMITTED)                          
C31606         WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                       
PERFOR                                                           
                                                            
C31606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUST_BANK_SEQ_NO                                          
MFA-TR*        INTO :BE-CUST-BANK-SEQ-NO                                        
MFA-TR*        FROM CSS_BANK_EFT                                                
MFA-TR*        WHERE ACCOUNT_NO = :WS-ACCOUNT-NUM                               
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7162                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31606                                                                  
C31606     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31606     EVALUATE WS-ACTIVE-RETURN-CODE                               
C31606         WHEN SUCCESSFUL-CALL                                     
C31606         WHEN NOT-FOUND                                           
C31606             CONTINUE                                             
C31606         WHEN OTHER                                               
C31606             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
C31606             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C31606             MOVE 'SELECT'              TO ABEND-FUNCTION         
C31606             MOVE '7162'                TO ACTIVE-PARAGRAPH       
C31606             MOVE SPACES                TO ABEND-SQL-PREDICATES   
C31606                                           ABEND-TABLES           
C31606             MOVE 'CSS_BANK_EFT'        TO TABLE-1                
C31606             MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
C31606             MOVE WS-ACCOUNT-NUM        TO HOSTVAR-ELEMENT-1      
C31606             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
C31606             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
C31606     END-EVALUATE.                                                
C31606                                                                  
C31606 7162-EXIT.                                                       
C31606     EXIT.                                                        
C31606                                                                  
C31606*****************************************************************         
C31606*  RETRIEVE PRIMARY BANK INFO FROM CSS_CUSTOMER_BANK            *         
C31606*****************************************************************         
C31606                                                                  
C31606 7163-GET-BANK-INFO.                                              
C31606                                                                  
C31606     EXEC SQL                                                     
C31606         SELECT BANK_ACCOUNT_NAME,                                
C31606                BANK_ACCT_NO,                                     
C31606                BANK_ACCT_STAT_CD,                                
C31606                BANK_ACCT_TYPE_CD,                                
C31606                BANK_ID,                                          
C31606                LAST_UPDATE_USERID,                               
C31606                BANK_ACCT_NICKNAME                                
C31606         INTO :JF-BANK-ACCOUNT-NAME,                              
C31606              :JF-BANK-ACCT-NO,                                   
C31606              :JF-BANK-ACCT-STAT-CD,                              
C31606              :JF-BANK-ACCT-TYPE-CD,                              
C31606              :JF-BANK-ID,                                        
C31606              :JF-LAST-UPDATE-USERID,                             
C31606              :JF-BANK-ACCT-NICKNAME                              
C31606         FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                     
C31606         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                     
C31606          AND  CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO            
PERFOR                                                           
                                                            
C31606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT BANK_ACCOUNT_NAME,                                        
MFA-TR*               BANK_ACCT_NO,                                             
MFA-TR*               BANK_ACCT_STAT_CD,                                        
MFA-TR*               BANK_ACCT_TYPE_CD,                                        
MFA-TR*               BANK_ID,                                                  
MFA-TR*               LAST_UPDATE_USERID,                                       
MFA-TR*               BANK_ACCT_NICKNAME                                        
MFA-TR*        INTO :JF-BANK-ACCOUNT-NAME,                                      
MFA-TR*             :JF-BANK-ACCT-NO,                                           
MFA-TR*             :JF-BANK-ACCT-STAT-CD,                                      
MFA-TR*             :JF-BANK-ACCT-TYPE-CD,                                      
MFA-TR*             :JF-BANK-ID,                                                
MFA-TR*             :JF-LAST-UPDATE-USERID,                                     
MFA-TR*             :JF-BANK-ACCT-NICKNAME                                      
MFA-TR*        FROM CSS_CUSTOMER_BANK                                           
MFA-TR*        WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                             
MFA-TR*         AND  CUST_BANK_SEQ_NO = :BE-CUST-BANK-SEQ-NO                    
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7163                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C31606     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31606     EVALUATE WS-ACTIVE-RETURN-CODE                               
C31606         WHEN SUCCESSFUL-CALL                                     
C31606             CONTINUE                                             
C31606         WHEN OTHER                                               
C31606             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
C31606             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C31606             MOVE 'SELECT'              TO ABEND-FUNCTION         
C31606             MOVE '7163'                TO ACTIVE-PARAGRAPH       
C31606             MOVE SPACES                TO ABEND-SQL-PREDICATES   
C31606                                           ABEND-TABLES           
C31606             MOVE 'CSS_CUSTOMER_BANK'   TO TABLE-1                
C31606             MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
C31606             MOVE 'CUST_BANK_SEQ_NO'    TO TABLE-ELEMENT-2        
C31606             MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1      
C31606             MOVE BE-CUST-BANK-SEQ-NO   TO HOSTVAR-ELEMENT-2      
C31606             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
C31606             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
C31606     END-EVALUATE.                                                
C31606                                                                  
C31606 7163-EXIT.                                                       
C31606     EXIT.                                                        
C31606                                                                  
C31606*****************************************************************         
C31606*  SELECT NEW CUSTOMER RECORD, IF PRESENT                       *         
C31606*****************************************************************         
C31606                                                                  
C31606 7164-SELECT-NEW-CUST-RECORD.                                     
C31606                                                                  
C31606     EXEC SQL                                                     
C31606         SELECT CUST_BANK_SEQ_NO                                  
C31606         INTO :JF-CUST-BANK-SEQ-NO                                
C31606         FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                     
C31606         WHERE CUSTOMER_NO        = :WS-NEW-CUST-NUM              
C31606          AND  BANK_ACCT_NO       = :JF-BANK-ACCT-NO              
C31606          AND  BANK_ACCT_STAT_CD  = :JF-BANK-ACCT-STAT-CD         
C31606          AND  BANK_ACCT_TYPE_CD  = :JF-BANK-ACCT-TYPE-CD         
C31606          AND  BANK_ID            = :JF-BANK-ID                   
C31606          AND  BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME        
PERFOR                                                           
                                                            
C31606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CUST_BANK_SEQ_NO                                          
MFA-TR*        INTO :JF-CUST-BANK-SEQ-NO                                        
MFA-TR*        FROM CSS_CUSTOMER_BANK                                           
MFA-TR*        WHERE CUSTOMER_NO        = :WS-NEW-CUST-NUM                      
MFA-TR*         AND  BANK_ACCT_NO       = :JF-BANK-ACCT-NO                      
MFA-TR*         AND  BANK_ACCT_STAT_CD  = :JF-BANK-ACCT-STAT-CD                 
MFA-TR*         AND  BANK_ACCT_TYPE_CD  = :JF-BANK-ACCT-TYPE-CD                 
MFA-TR*         AND  BANK_ID            = :JF-BANK-ID                           
MFA-TR*         AND  BANK_ACCT_NICKNAME = :JF-BANK-ACCT-NICKNAME                
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7164                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31606                                                                  
C31606     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31606     EVALUATE WS-ACTIVE-RETURN-CODE                               
C31606         WHEN SUCCESSFUL-CALL                                     
C31606             MOVE JF-CUST-BANK-SEQ-NO TO WS-CUST-BANK-SEQ-NO      
C31606             PERFORM 8090-UPDATE-CSS-BANK-EFT THRU 8090-EXIT      
C31606         WHEN NOT-FOUND                                           
C31606             PERFORM 2165-INSERT-BANK-INFO THRU 2165-EXIT         
C31606             PERFORM 8090-UPDATE-CSS-BANK-EFT THRU 8090-EXIT      
C31606         WHEN OTHER                                               
C31606             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
C31606             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C31606             MOVE 'SELECT'              TO ABEND-FUNCTION         
C31606             MOVE '7164'                TO ACTIVE-PARAGRAPH       
C31606             MOVE SPACES                TO ABEND-SQL-PREDICATES   
C31606                                           ABEND-TABLES           
C31606             MOVE 'CSS_CUSTOMER_BANK'   TO TABLE-1                
C31606             MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
C31606             MOVE 'BANK_ACCT_NO'        TO TABLE-ELEMENT-2        
C31606             MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1      
C31606             MOVE JF-BANK-ACCT-NO       TO HOSTVAR-ELEMENT-2      
C31606             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
C31606             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
C31606     END-EVALUATE.                                                
C31606                                                                  
C31606 7164-EXIT.                                                       
C31606     EXIT.                                                        
C31606                                                                  
C31606*****************************************************************         
C31606*  GET NEW CUST_BANK_SEQ_NO FOR THE NEW_CUSTOMER_NO             *         
C31606*****************************************************************         
C31606                                                                  
C31606 7166-GET-NEW-CUST-BANK-SEQ.                                      
C31606                                                                  
C31606     EXEC SQL                                                     
C31606         SELECT MAX(CUST_BANK_SEQ_NO)                             
C31606         INTO :JF-CUST-BANK-SEQ-NO :WS-NULL-IND1                  
C31606         FROM CSS_CUSTOMER_BANK WITH(READUNCOMMITTED)                     
C31606         WHERE CUSTOMER_NO        = :WS-NEW-CUST-NUM              
PERFOR                                                           
                                                            
C31606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT MAX(CUST_BANK_SEQ_NO)                                     
MFA-TR*        INTO :JF-CUST-BANK-SEQ-NO :WS-NULL-IND1                          
MFA-TR*        FROM CSS_CUSTOMER_BANK                                           
MFA-TR*        WHERE CUSTOMER_NO        = :WS-NEW-CUST-NUM                      
MFA-TR*        WITH UR                                                          
MFA-TR*        QUERYNO 7166                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31606                                                                  
C31606     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31606     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C31606            IF WS-NULL-IND1 = 0                                   
C31606               MOVE JF-CUST-BANK-SEQ-NO  TO WS-NEW-CUST-BANK-SEQ  
C31606               ADD  1                    TO WS-NEW-CUST-BANK-SEQ  
C31606            ELSE                                                  
C31606               MOVE 1                    TO WS-NEW-CUST-BANK-SEQ  
C31606            END-IF                                                
C31606            MOVE WS-NEW-CUST-BANK-SEQ TO WS-CUST-BANK-SEQ-NO      
C31606     ELSE                                                         
C31606             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
C31606             MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
C31606             MOVE 'SELECT'              TO ABEND-FUNCTION         
C31606             MOVE '7166'                TO ACTIVE-PARAGRAPH       
C31606             MOVE SPACES                TO ABEND-SQL-PREDICATES   
C31606                                          ABEND-TABLES            
C31606             MOVE 'CSS_CUSTOMER_BANK'   TO TABLE-1                
C31606             MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1        
C31606             MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1      
C31606             PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
C31606             PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
C31606     END-IF.                                                      
C31606                                                                  
C31606 7166-EXIT.                                                       
C31606     EXIT.                                                        
C31606                                                                  
A00998*****************************************************************         
A00998*  OPEN CREDIT HIST CURSOR                                      *         
A00998*****************************************************************         
A00998                                                                  
A00998 7170-OPEN-CR-CURSOR.                                             
A00998                                                                  
A00998     EXEC SQL                                                     
A00998       OPEN CR_CURSOR                                             
A00998     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998         NEXT SENTENCE                                            
A00998     ELSE                                                         
A00998         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A00998         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A00998         MOVE 'OPEN'                TO ABEND-FUNCTION             
A00998         MOVE '7170'                TO ACTIVE-PARAGRAPH           
A00998         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A00998                                       ABEND-TABLES               
A00998         MOVE 'CSS_CREDIT_HIST'     TO TABLE-1                    
A00998         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A00998         MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1          
A00998         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A00998         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A00998     END-IF.                                                      
A00998                                                                  
A00998 7170-EXIT.                                                       
A00998     EXIT.                                                        
A00998*****************************************************************         
A00998*  OPEN CREDIT HIST CURSOR                                      *         
A00998*****************************************************************         
A00998                                                                  
A00998 7180-FETCH-CR-CURSOR.                                            
A00998                                                                  
A00998     EXEC SQL                                                     
A00998       FETCH CR_CURSOR                                            
A00998       INTO :CK-CUSTOMER-NO                                       
A00998           ,:CK-CR-HIST-TRAN-DT                                   
A00998           ,:CK-CR-HIST-TRAN-TM                                   
A00998           ,:CK-USER-ID-CR-INIT-BY                                
A00998           ,:CK-BEACON-SCORE                                      
A00998           ,:CK-CR-RQST-REASON-CD                                 
A00998           ,:CK-CR-BUREAU-CD                                      
A00998           ,:CK-CR-ACTION-FL                                      
A00998           ,:CK-CR-COMMENTS                                       
A00998           ,:CK-VENDOR-COMMENTS                                   
A00998           ,:CK-ADV-CREDIT-LTR                                    
A00998           ,:CK-REG-GROUP-CD                                      
A00998           ,:CK-ADV-CREDIT-LTR-DT :WS-NULL-IND1                    
A00998           ,:CK-CUST-NAME-FIRST :WS-NULL-IND7                      
A00998           ,:CK-CUST-NAME-LAST :WS-NULL-IND8                       
A00998           ,:CK-CUST-NAME-MID :WS-NULL-IND9                        
A00998           ,:CK-CUST-NAME-SFX :WS-NULL-IND10                       
A00998           ,:CK-ITPA-EXISTS-CD                                    
A00998           ,:CK-CR-CHK-COMPANY-NO                                 
A00998           ,:CK-ACCT-REVIEW-ACT-CD                                
A00998           ,:CK-ACCT-REVIEW-RET-DT :WS-NULL-IND2                   
A00998           ,:CK-ADDR-DISCREP-FL                                   
A00998           ,:CK-SENIOR-FL                                         
A00998           ,:CK-APPL-STATUS-CD                                    
A00998           ,:CK-CB-HIT-CD                                         
A00998           ,:CK-CB-MATCH-CD                                       
A00998           ,:CK-CB-SAFESCAN-CD                                    
A00998           ,:CK-CB-FORMAT-ERR-CD                                  
A00998           ,:CK-CB-PROCESS-ERR-CD                                 
A00998           ,:CK-CB-VALIDITY-ERR-CD                                
A00998           ,:CK-DRIVERS-LIC-ST-CD                                 
A00998           ,:CK-DRIVERS-LICENSE-NO                                
A00998           ,:CK-FIRST-NAME                                        
A00998           ,:CK-MIDDLE-NAME                                       
A00998           ,:CK-LAST-NAME                                         
A00998           ,:CK-TITLE-SUFFIX-1                                    
A00998           ,:CK-DATE-OF-BIRTH :WS-NULL-IND3                        
A00998           ,:CK-SSN                                               
A00998           ,:CK-CB-SSN                                            
A00998           ,:CK-CB-SSN-BIRTH-DT :WS-NULL-IND4                      
A00998           ,:CK-CB-SSN-AGE                                        
A00998           ,:CK-CB-SSN-ISSUE-DT :WS-NULL-IND5                      
A00998           ,:CK-CB-SSN-ISSUE-ST-CD                                
A00998           ,:CK-CB-SSN-VERIFIED-FL                                
A00998           ,:CK-CB-SSN-INQUIRY                                    
A00998           ,:CK-CB-SSN-DEATH-DT :WS-NULL-IND6                      
A00998           ,:CK-CB-SSN-DEATH-ST-CD                                
A00998           ,:CK-CB-EMPLOYER                                       
A00998           ,:CK-CB-EMPLOYER-CITY                                  
A00998           ,:CK-CB-BEACON-REJ-CD                                  
A00998           ,:CK-CB-BEACON-AA1-CD                                  
A00998           ,:CK-CB-BEACON-AA2-CD                                  
A00998           ,:CK-CB-BEACON-AA3-CD                                  
A00998           ,:CK-CB-BEACON-AA4-CD                                  
A00998           ,:CK-CR-SCORE-UPDATE-FL                                
A00998           ,:CK-CR-SCORE-TYPE-CD                                  
A00998           ,:CK-CR-SCORE-CD                                       
I02073           ,:CK-ADDL-CRED-SCORE                                   
I02073           ,:CK-SCORE-MODEL-CD                                    
I02073           ,:CK-ACCOUNT-NO                                        
A00998     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998         NEXT SENTENCE                                            
A00998     ELSE                                                         
A00998         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A00998         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A00998         MOVE 'FETCH'               TO ABEND-FUNCTION             
A00998         MOVE '7180'                TO ACTIVE-PARAGRAPH           
A00998         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A00998                                       ABEND-TABLES               
A00998         MOVE 'CSS_CREDIT_HIST'     TO TABLE-1                    
A00998         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A00998         MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1          
A00998         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A00998         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A00998     END-IF.                                                      
A00998                                                                  
A00998 7180-EXIT.                                                       
A00998     EXIT.                                                        
A00998*****************************************************************         
A00998*  CLOSE CREDIT HIST CURSOR                                     *         
A00998*****************************************************************         
A00998                                                                  
A00998 7190-CLOSE-CR-CURSOR.                                            
A00998                                                                  
A00998     EXEC SQL                                                     
A00998       CLOSE CR_CURSOR                                            
A00998     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998         NEXT SENTENCE                                            
A00998     ELSE                                                         
A00998         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A00998         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A00998         MOVE 'CLOSE'               TO ABEND-FUNCTION             
A00998         MOVE '7190'                TO ACTIVE-PARAGRAPH           
A00998         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A00998                                       ABEND-TABLES               
A00998         MOVE 'CSS_CREDIT_HIST'     TO TABLE-1                    
A00998         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A00998         MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1          
A00998         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A00998         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A00998     END-IF.                                                      
A00998                                                                  
A00998 7190-EXIT.                                                       
A00998     EXIT.                                                        
A00998*****************************************************************         
A00998*  INSERT CSS_CREDIT_HIST.                                      *         
A00998*****************************************************************         
A00998                                                                  
A00998 7200-INSERT-CREDIT-HIST.                                         
A00998                                                                  
A00998     MOVE WS-NEW-CUST-NUM          TO CK-CUSTOMER-NO.             
A00998     EXEC SQL                                                     
A00998         INSERT INTO CSS_CREDIT_HIST                              
A00998               (CUSTOMER_NO                                       
A00998               ,CR_HIST_TRAN_DT                                   
A00998               ,CR_HIST_TRAN_TM                                   
A00998               ,USER_ID_CR_INIT_BY                                
A00998               ,BEACON_SCORE                                      
A00998               ,CR_RQST_REASON_CD                                 
A00998               ,CR_BUREAU_CD                                      
A00998               ,CR_ACTION_FL                                      
A00998               ,CR_COMMENTS                                       
A00998               ,VENDOR_COMMENTS                                   
A00998               ,ADV_CREDIT_LTR                                    
A00998               ,REG_GROUP_CD                                      
A00998               ,ADV_CREDIT_LTR_DT                                 
A00998               ,CUST_NAME_FIRST                                   
A00998               ,CUST_NAME_LAST                                    
A00998               ,CUST_NAME_MID                                     
A00998               ,CUST_NAME_SFX                                     
A00998               ,ITPA_EXISTS_CD                                    
A00998               ,CR_CHK_COMPANY_NO                                 
A00998               ,ACCT_REVIEW_ACT_CD                                
A00998               ,ACCT_REVIEW_RET_DT                                
A00998               ,ADDR_DISCREP_FL                                   
A00998               ,SENIOR_FL                                         
A00998               ,APPL_STATUS_CD                                    
A00998               ,CB_HIT_CD                                         
A00998               ,CB_MATCH_CD                                       
A00998               ,CB_SAFESCAN_CD                                    
A00998               ,CB_FORMAT_ERR_CD                                  
A00998               ,CB_PROCESS_ERR_CD                                 
A00998               ,CB_VALIDITY_ERR_CD                                
A00998               ,DRIVERS_LIC_ST_CD                                 
A00998               ,DRIVERS_LICENSE_NO                                
A00998               ,FIRST_NAME                                        
A00998               ,MIDDLE_NAME                                       
A00998               ,LAST_NAME                                         
A00998               ,TITLE_SUFFIX_1                                    
A00998               ,DATE_OF_BIRTH                                     
A00998               ,SSN                                               
A00998               ,CB_SSN                                            
A00998               ,CB_SSN_BIRTH_DT                                   
A00998               ,CB_SSN_AGE                                        
A00998               ,CB_SSN_ISSUE_DT                                   
A00998               ,CB_SSN_ISSUE_ST_CD                                
A00998               ,CB_SSN_VERIFIED_FL                                
A00998               ,CB_SSN_INQUIRY                                    
A00998               ,CB_SSN_DEATH_DT                                   
A00998               ,CB_SSN_DEATH_ST_CD                                
A00998               ,CB_EMPLOYER                                       
A00998               ,CB_EMPLOYER_CITY                                  
A00998               ,CB_BEACON_REJ_CD                                  
A00998               ,CB_BEACON_AA1_CD                                  
A00998               ,CB_BEACON_AA2_CD                                  
A00998               ,CB_BEACON_AA3_CD                                  
A00998               ,CB_BEACON_AA4_CD                                  
A00998               ,CR_SCORE_UPDATE_FL                                
A00998               ,CR_SCORE_TYPE_CD                                  
A00998               ,CR_SCORE_CD                                       
I02073               ,ADDL_CRED_SCORE                                   
I02073               ,SCORE_MODEL_CD                                    
I02073               ,ACCOUNT_NO )                                      
A00998         VALUES(:CK-CUSTOMER-NO                                   
A00998               ,IIF(TRY_CONVERT(DATE, :CK-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :CK-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:CK-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:CK-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :CK-CR-HIST-TRAN-DT) )                          
A00998               ,CIS.CHAR2TIME(:CK-CR-HIST-TRAN-TM)                        
A00998               ,:CK-USER-ID-CR-INIT-BY                            
A00998               ,:CK-BEACON-SCORE                                  
A00998               ,:CK-CR-RQST-REASON-CD                             
A00998               ,:CK-CR-BUREAU-CD                                  
A00998               ,:CK-CR-ACTION-FL                                  
A00998               ,:CK-CR-COMMENTS                                   
A00998               ,:CK-VENDOR-COMMENTS                               
A00998               ,:CK-ADV-CREDIT-LTR                                
A00998               ,:CK-REG-GROUP-CD                                  
A00998               ,IIF(TRY_CONVERT(DATE, :CK-ADV-CREDIT-LTR-DT 
                                            :WS-NULL-IND1
              ) IS NULL OR (PATINDEX('%.%', :CK-ADV-CREDIT-LTR-DT 
                                                          :WS-NULL-IND1
              ) <> 0) OR (LEN(:CK-ADV-CREDIT-LTR-DT :WS-NULL-IND1
              ) <> 10), CIS.CHAR2DATE(:CK-ADV-CREDIT-LTR-DT 
                                                          :WS-NULL-IND1
              ), CONVERT(DATE, :CK-ADV-CREDIT-LTR-DT :WS-NULL-IND1) )          
A00998               ,:CK-CUST-NAME-FIRST :WS-NULL-IND7                  
A00998               ,:CK-CUST-NAME-LAST :WS-NULL-IND8                   
A00998               ,:CK-CUST-NAME-MID :WS-NULL-IND9                    
A00998               ,:CK-CUST-NAME-SFX :WS-NULL-IND10                   
A00998               ,:CK-ITPA-EXISTS-CD                                
A00998               ,:CK-CR-CHK-COMPANY-NO                             
A00998               ,:CK-ACCT-REVIEW-ACT-CD                            
A00998               ,IIF(TRY_CONVERT(DATE, :CK-ACCT-REVIEW-RET-DT 
                                            :WS-NULL-IND2
              ) IS NULL OR (PATINDEX('%.%', :CK-ACCT-REVIEW-RET-DT 
                                                          :WS-NULL-IND2
              ) <> 0) OR (LEN(:CK-ACCT-REVIEW-RET-DT :WS-NULL-IND2
              ) <> 10), CIS.CHAR2DATE(:CK-ACCT-REVIEW-RET-DT 
                                                          :WS-NULL-IND2
              ), CONVERT(DATE, :CK-ACCT-REVIEW-RET-DT :WS-NULL-IND2) )         
A00998               ,:CK-ADDR-DISCREP-FL                               
A00998               ,:CK-SENIOR-FL                                     
A00998               ,:CK-APPL-STATUS-CD                                
A00998               ,:CK-CB-HIT-CD                                     
A00998               ,:CK-CB-MATCH-CD                                   
A00998               ,:CK-CB-SAFESCAN-CD                                
A00998               ,:CK-CB-FORMAT-ERR-CD                              
A00998               ,:CK-CB-PROCESS-ERR-CD                             
A00998               ,:CK-CB-VALIDITY-ERR-CD                            
A00998               ,:CK-DRIVERS-LIC-ST-CD                             
A00998               ,:CK-DRIVERS-LICENSE-NO                            
A00998               ,:CK-FIRST-NAME                                    
A00998               ,:CK-MIDDLE-NAME                                   
A00998               ,:CK-LAST-NAME                                     
A00998               ,:CK-TITLE-SUFFIX-1                                
A00998               ,IIF(TRY_CONVERT(DATE, :CK-DATE-OF-BIRTH 
                                            :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :CK-DATE-OF-BIRTH 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:CK-DATE-OF-BIRTH :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:CK-DATE-OF-BIRTH :WS-NULL-IND3
              ), CONVERT(DATE, :CK-DATE-OF-BIRTH :WS-NULL-IND3) )              
A00998               ,:CK-SSN                                           
A00998               ,:CK-CB-SSN                                        
A00998               ,IIF(TRY_CONVERT(DATE, :CK-CB-SSN-BIRTH-DT 
                                            :WS-NULL-IND4
              ) IS NULL OR (PATINDEX('%.%', :CK-CB-SSN-BIRTH-DT 
                                                          :WS-NULL-IND4
              ) <> 0) OR (LEN(:CK-CB-SSN-BIRTH-DT :WS-NULL-IND4
              ) <> 10), CIS.CHAR2DATE(:CK-CB-SSN-BIRTH-DT :WS-NULL-IND4
              ), CONVERT(DATE, :CK-CB-SSN-BIRTH-DT :WS-NULL-IND4) )            
A00998               ,:CK-CB-SSN-AGE                                    
A00998               ,IIF(TRY_CONVERT(DATE, :CK-CB-SSN-ISSUE-DT 
                                            :WS-NULL-IND5
              ) IS NULL OR (PATINDEX('%.%', :CK-CB-SSN-ISSUE-DT 
                                                          :WS-NULL-IND5
              ) <> 0) OR (LEN(:CK-CB-SSN-ISSUE-DT :WS-NULL-IND5
              ) <> 10), CIS.CHAR2DATE(:CK-CB-SSN-ISSUE-DT :WS-NULL-IND5
              ), CONVERT(DATE, :CK-CB-SSN-ISSUE-DT :WS-NULL-IND5) )            
A00998               ,:CK-CB-SSN-ISSUE-ST-CD                            
A00998               ,:CK-CB-SSN-VERIFIED-FL                            
A00998               ,:CK-CB-SSN-INQUIRY                                
A00998               ,IIF(TRY_CONVERT(DATE, :CK-CB-SSN-DEATH-DT 
                                            :WS-NULL-IND6
              ) IS NULL OR (PATINDEX('%.%', :CK-CB-SSN-DEATH-DT 
                                                          :WS-NULL-IND6
              ) <> 0) OR (LEN(:CK-CB-SSN-DEATH-DT :WS-NULL-IND6
              ) <> 10), CIS.CHAR2DATE(:CK-CB-SSN-DEATH-DT :WS-NULL-IND6
              ), CONVERT(DATE, :CK-CB-SSN-DEATH-DT :WS-NULL-IND6) )            
A00998               ,:CK-CB-SSN-DEATH-ST-CD                            
A00998               ,:CK-CB-EMPLOYER                                   
A00998               ,:CK-CB-EMPLOYER-CITY                              
A00998               ,:CK-CB-BEACON-REJ-CD                              
A00998               ,:CK-CB-BEACON-AA1-CD                              
A00998               ,:CK-CB-BEACON-AA2-CD                              
A00998               ,:CK-CB-BEACON-AA3-CD                              
A00998               ,:CK-CB-BEACON-AA4-CD                              
A00998               ,:CK-CR-SCORE-UPDATE-FL                            
A00998               ,:CK-CR-SCORE-TYPE-CD                              
A00998               ,:CK-CR-SCORE-CD                                   
I02073               ,:CK-ADDL-CRED-SCORE                               
I02073               ,:CK-SCORE-MODEL-CD                                
I02073               ,:CK-ACCOUNT-NO)                                   
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CREDIT_HIST                                      
MFA-TR*              (CUSTOMER_NO                                               
MFA-TR*              ,CR_HIST_TRAN_DT                                           
MFA-TR*              ,CR_HIST_TRAN_TM                                           
MFA-TR*              ,USER_ID_CR_INIT_BY                                        
MFA-TR*              ,BEACON_SCORE                                              
MFA-TR*              ,CR_RQST_REASON_CD                                         
MFA-TR*              ,CR_BUREAU_CD                                              
MFA-TR*              ,CR_ACTION_FL                                              
MFA-TR*              ,CR_COMMENTS                                               
MFA-TR*              ,VENDOR_COMMENTS                                           
MFA-TR*              ,ADV_CREDIT_LTR                                            
MFA-TR*              ,REG_GROUP_CD                                              
MFA-TR*              ,ADV_CREDIT_LTR_DT                                         
MFA-TR*              ,CUST_NAME_FIRST                                           
MFA-TR*              ,CUST_NAME_LAST                                            
MFA-TR*              ,CUST_NAME_MID                                             
MFA-TR*              ,CUST_NAME_SFX                                             
MFA-TR*              ,ITPA_EXISTS_CD                                            
MFA-TR*              ,CR_CHK_COMPANY_NO                                         
MFA-TR*              ,ACCT_REVIEW_ACT_CD                                        
MFA-TR*              ,ACCT_REVIEW_RET_DT                                        
MFA-TR*              ,ADDR_DISCREP_FL                                           
MFA-TR*              ,SENIOR_FL                                                 
MFA-TR*              ,APPL_STATUS_CD                                            
MFA-TR*              ,CB_HIT_CD                                                 
MFA-TR*              ,CB_MATCH_CD                                               
MFA-TR*              ,CB_SAFESCAN_CD                                            
MFA-TR*              ,CB_FORMAT_ERR_CD                                          
MFA-TR*              ,CB_PROCESS_ERR_CD                                         
MFA-TR*              ,CB_VALIDITY_ERR_CD                                        
MFA-TR*              ,DRIVERS_LIC_ST_CD                                         
MFA-TR*              ,DRIVERS_LICENSE_NO                                        
MFA-TR*              ,FIRST_NAME                                                
MFA-TR*              ,MIDDLE_NAME                                               
MFA-TR*              ,LAST_NAME                                                 
MFA-TR*              ,TITLE_SUFFIX_1                                            
MFA-TR*              ,DATE_OF_BIRTH                                             
MFA-TR*              ,SSN                                                       
MFA-TR*              ,CB_SSN                                                    
MFA-TR*              ,CB_SSN_BIRTH_DT                                           
MFA-TR*              ,CB_SSN_AGE                                                
MFA-TR*              ,CB_SSN_ISSUE_DT                                           
MFA-TR*              ,CB_SSN_ISSUE_ST_CD                                        
MFA-TR*              ,CB_SSN_VERIFIED_FL                                        
MFA-TR*              ,CB_SSN_INQUIRY                                            
MFA-TR*              ,CB_SSN_DEATH_DT                                           
MFA-TR*              ,CB_SSN_DEATH_ST_CD                                        
MFA-TR*              ,CB_EMPLOYER                                               
MFA-TR*              ,CB_EMPLOYER_CITY                                          
MFA-TR*              ,CB_BEACON_REJ_CD                                          
MFA-TR*              ,CB_BEACON_AA1_CD                                          
MFA-TR*              ,CB_BEACON_AA2_CD                                          
MFA-TR*              ,CB_BEACON_AA3_CD                                          
MFA-TR*              ,CB_BEACON_AA4_CD                                          
MFA-TR*              ,CR_SCORE_UPDATE_FL                                        
MFA-TR*              ,CR_SCORE_TYPE_CD                                          
MFA-TR*              ,CR_SCORE_CD                                               
MFA-TR*              ,ADDL_CRED_SCORE                                           
MFA-TR*              ,SCORE_MODEL_CD                                            
MFA-TR*              ,ACCOUNT_NO )                                              
MFA-TR*        VALUES(:CK-CUSTOMER-NO                                           
MFA-TR*              ,:CK-CR-HIST-TRAN-DT                                       
MFA-TR*              ,:CK-CR-HIST-TRAN-TM                                       
MFA-TR*              ,:CK-USER-ID-CR-INIT-BY                                    
MFA-TR*              ,:CK-BEACON-SCORE                                          
MFA-TR*              ,:CK-CR-RQST-REASON-CD                                     
MFA-TR*              ,:CK-CR-BUREAU-CD                                          
MFA-TR*              ,:CK-CR-ACTION-FL                                          
MFA-TR*              ,:CK-CR-COMMENTS                                           
MFA-TR*              ,:CK-VENDOR-COMMENTS                                       
MFA-TR*              ,:CK-ADV-CREDIT-LTR                                        
MFA-TR*              ,:CK-REG-GROUP-CD                                          
MFA-TR*              ,:CK-ADV-CREDIT-LTR-DT:WS-NULL-IND1                        
MFA-TR*              ,:CK-CUST-NAME-FIRST:WS-NULL-IND7                          
MFA-TR*              ,:CK-CUST-NAME-LAST:WS-NULL-IND8                           
MFA-TR*              ,:CK-CUST-NAME-MID:WS-NULL-IND9                            
MFA-TR*              ,:CK-CUST-NAME-SFX:WS-NULL-IND10                           
MFA-TR*              ,:CK-ITPA-EXISTS-CD                                        
MFA-TR*              ,:CK-CR-CHK-COMPANY-NO                                     
MFA-TR*              ,:CK-ACCT-REVIEW-ACT-CD                                    
MFA-TR*              ,:CK-ACCT-REVIEW-RET-DT:WS-NULL-IND2                       
MFA-TR*              ,:CK-ADDR-DISCREP-FL                                       
MFA-TR*              ,:CK-SENIOR-FL                                             
MFA-TR*              ,:CK-APPL-STATUS-CD                                        
MFA-TR*              ,:CK-CB-HIT-CD                                             
MFA-TR*              ,:CK-CB-MATCH-CD                                           
MFA-TR*              ,:CK-CB-SAFESCAN-CD                                        
MFA-TR*              ,:CK-CB-FORMAT-ERR-CD                                      
MFA-TR*              ,:CK-CB-PROCESS-ERR-CD                                     
MFA-TR*              ,:CK-CB-VALIDITY-ERR-CD                                    
MFA-TR*              ,:CK-DRIVERS-LIC-ST-CD                                     
MFA-TR*              ,:CK-DRIVERS-LICENSE-NO                                    
MFA-TR*              ,:CK-FIRST-NAME                                            
MFA-TR*              ,:CK-MIDDLE-NAME                                           
MFA-TR*              ,:CK-LAST-NAME                                             
MFA-TR*              ,:CK-TITLE-SUFFIX-1                                        
MFA-TR*              ,:CK-DATE-OF-BIRTH:WS-NULL-IND3                            
MFA-TR*              ,:CK-SSN                                                   
MFA-TR*              ,:CK-CB-SSN                                                
MFA-TR*              ,:CK-CB-SSN-BIRTH-DT:WS-NULL-IND4                          
MFA-TR*              ,:CK-CB-SSN-AGE                                            
MFA-TR*              ,:CK-CB-SSN-ISSUE-DT:WS-NULL-IND5                          
MFA-TR*              ,:CK-CB-SSN-ISSUE-ST-CD                                    
MFA-TR*              ,:CK-CB-SSN-VERIFIED-FL                                    
MFA-TR*              ,:CK-CB-SSN-INQUIRY                                        
MFA-TR*              ,:CK-CB-SSN-DEATH-DT:WS-NULL-IND6                          
MFA-TR*              ,:CK-CB-SSN-DEATH-ST-CD                                    
MFA-TR*              ,:CK-CB-EMPLOYER                                           
MFA-TR*              ,:CK-CB-EMPLOYER-CITY                                      
MFA-TR*              ,:CK-CB-BEACON-REJ-CD                                      
MFA-TR*              ,:CK-CB-BEACON-AA1-CD                                      
MFA-TR*              ,:CK-CB-BEACON-AA2-CD                                      
MFA-TR*              ,:CK-CB-BEACON-AA3-CD                                      
MFA-TR*              ,:CK-CB-BEACON-AA4-CD                                      
MFA-TR*              ,:CK-CR-SCORE-UPDATE-FL                                    
MFA-TR*              ,:CK-CR-SCORE-TYPE-CD                                      
MFA-TR*              ,:CK-CR-SCORE-CD                                           
MFA-TR*              ,:CK-ADDL-CRED-SCORE                                       
MFA-TR*              ,:CK-SCORE-MODEL-CD                                        
MFA-TR*              ,:CK-ACCOUNT-NO)                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998                                                                  
A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998        NEXT SENTENCE                                             
A00998     ELSE                                                         
A00998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00998        MOVE 'INSERT'              TO ABEND-FUNCTION              
A00998        MOVE '7200'                TO ACTIVE-PARAGRAPH            
A00998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00998                                      ABEND-TABLES                
A00998        MOVE 'CSS_CREDIT_HIST'     TO TABLE-1                     
A00998        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A00998        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
A00998        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00998        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00998     END-IF.                                                      
A00998                                                                  
A00998 7200-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
A00998*****************************************************************         
A00998*  OPEN ITPA_HIST CUROSR                                        *         
A00998*****************************************************************         
A00998                                                                  
A00998 7210-OPEN-ITPA-CURSOR.                                           
A00998                                                                  
A00998     EXEC SQL                                                     
A00998       OPEN ITPA_CUR                                              
A00998     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998         NEXT SENTENCE                                            
A00998     ELSE                                                         
A00998         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A00998         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A00998         MOVE 'OPEN'                TO ABEND-FUNCTION             
A00998         MOVE '7210'                TO ACTIVE-PARAGRAPH           
A00998         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A00998                                       ABEND-TABLES               
A00998         MOVE 'CSS_CRED_ITPA_HIST'  TO TABLE-1                    
A00998         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A00998         MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1          
A00998         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A00998         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A00998     END-IF.                                                      
A00998                                                                  
A00998 7210-EXIT.                                                       
A00998     EXIT.                                                        
A00998*****************************************************************         
A00998*  FETCH ITPA_HIST CURSOR                                       *         
A00998*****************************************************************         
A00998                                                                  
A00998 7215-FETCH-ITPA-CURSOR.                                          
A00998                                                                  
A00998     EXEC SQL                                                     
A00998       FETCH ITPA_CUR                                             
A00998       INTO :LF-ALERT-TYPE-CD :WS-NULL-IND1                        
A00998           ,:LF-CONTACT-INFO-FL                                   
A00998           ,:LF-CR-HIST-TRAN-DT                                   
A00998           ,:LF-CR-HIST-TRAN-TM                                   
A00998           ,:LF-CUSTOMER-NO                                       
A00998           ,:LF-ITPA-ADDTNL-INFO :WS-NULL-IND2                     
A00998           ,:LF-ITPA-EFFECTIVE-DT :WS-NULL-IND3                    
A00998           ,:LF-ITPA-REPORT-DT :WS-NULL-IND4                       
A00998           ,:LF-ITPA-RSLT-CURR-CD                                 
A00998           ,:LF-ITPA-RSLT-ORIG-CD                                 
A00998           ,:LF-LAST-UPDATE-TS                                    
A00998           ,:LF-LAST-UPDATE-USERID                                
A00998           ,:LF-LETTER-MAILED-DT :WS-NULL-IND5                     
A00998           ,:LF-LETTER-NOTIFY-CD :WS-NULL-IND6                     
A00998           ,:LF-RESOLUTION-DT :WS-NULL-IND7                        
A00998     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998         NEXT SENTENCE                                            
A00998     ELSE                                                         
A00998         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A00998         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A00998         MOVE 'FETCH'               TO ABEND-FUNCTION             
A00998         MOVE '7215'                TO ACTIVE-PARAGRAPH           
A00998         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A00998                                       ABEND-TABLES               
A00998         MOVE 'CSS_CRED_ITPA_HIST'  TO TABLE-1                    
A00998         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A00998         MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1          
A00998         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A00998         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A00998     END-IF.                                                      
A00998                                                                  
A00998 7215-EXIT.                                                       
A00998     EXIT.                                                        
A00998*****************************************************************         
A00998*  CLOSE ITPA_HIST CURSOR                                       *         
A00998*****************************************************************         
A00998                                                                  
A00998 7219-CLOSE-ITPA-CURSOR.                                          
A00998                                                                  
A00998     EXEC SQL                                                     
A00998       CLOSE ITPA_CUR                                             
A00998     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998         NEXT SENTENCE                                            
A00998     ELSE                                                         
A00998         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
A00998         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
A00998         MOVE 'CLOSE'               TO ABEND-FUNCTION             
A00998         MOVE '7219'                TO ACTIVE-PARAGRAPH           
A00998         MOVE SPACES                TO ABEND-SQL-PREDICATES       
A00998                                       ABEND-TABLES               
A00998         MOVE 'CSS_CRED_ITPA_HIST'  TO TABLE-1                    
A00998         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
A00998         MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1          
A00998         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
A00998         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
A00998     END-IF.                                                      
A00998                                                                  
A00998 7219-EXIT.                                                       
A00998     EXIT.                                                        
A00998*****************************************************************         
A00998*  INSERT CSS_CRED_ITPA_HIST                                    *         
A00998*****************************************************************         
A00998                                                                  
A00998 7218-INSERT-ITPA-HIST.                                           
A00998                                                                  
A00998     MOVE WS-NEW-CUST-NUM          TO LF-CUSTOMER-NO.             
A00998     EXEC SQL                                                     
A00998         INSERT INTO CSS_CRED_ITPA_HIST                           
A00998               (ALERT_TYPE_CD                                     
A00998               ,CONTACT_INFO_FL                                   
A00998               ,CR_HIST_TRAN_DT                                   
A00998               ,CR_HIST_TRAN_TM                                   
A00998               ,CUSTOMER_NO                                       
A00998               ,ITPA_ADDTNL_INFO                                  
A00998               ,ITPA_EFFECTIVE_DT                                 
A00998               ,ITPA_REPORT_DT                                    
A00998               ,ITPA_RSLT_CURR_CD                                 
A00998               ,ITPA_RSLT_ORIG_CD                                 
A00998               ,LAST_UPDATE_TS                                    
A00998               ,LAST_UPDATE_USERID                                
A00998               ,LETTER_MAILED_DT                                  
A00998               ,LETTER_NOTIFY_CD                                  
A00998               ,RESOLUTION_DT)                                    
A00998         VALUES(:LF-ALERT-TYPE-CD :WS-NULL-IND1                    
A00998               ,:LF-CONTACT-INFO-FL                               
A00998               ,IIF(TRY_CONVERT(DATE, :LF-CR-HIST-TRAN-DT
              ) IS NULL OR (PATINDEX('%.%', :LF-CR-HIST-TRAN-DT
              ) <> 0) OR (LEN(:LF-CR-HIST-TRAN-DT
              ) <> 10), CIS.CHAR2DATE(:LF-CR-HIST-TRAN-DT
              ), CONVERT(DATE, :LF-CR-HIST-TRAN-DT) )                          
A00998               ,CIS.CHAR2TIME(:LF-CR-HIST-TRAN-TM)                        
A00998               ,:LF-CUSTOMER-NO                                   
A00998               ,:LF-ITPA-ADDTNL-INFO :WS-NULL-IND2                 
A00998               ,IIF(TRY_CONVERT(DATE, :LF-ITPA-EFFECTIVE-DT 
                                            :WS-NULL-IND3
              ) IS NULL OR (PATINDEX('%.%', :LF-ITPA-EFFECTIVE-DT 
                                                          :WS-NULL-IND3
              ) <> 0) OR (LEN(:LF-ITPA-EFFECTIVE-DT :WS-NULL-IND3
              ) <> 10), CIS.CHAR2DATE(:LF-ITPA-EFFECTIVE-DT 
                                                          :WS-NULL-IND3
              ), CONVERT(DATE, :LF-ITPA-EFFECTIVE-DT :WS-NULL-IND3) )          
A00998               ,IIF(TRY_CONVERT(DATE, :LF-ITPA-REPORT-DT 
                                            :WS-NULL-IND4
              ) IS NULL OR (PATINDEX('%.%', :LF-ITPA-REPORT-DT 
                                                          :WS-NULL-IND4
              ) <> 0) OR (LEN(:LF-ITPA-REPORT-DT :WS-NULL-IND4
              ) <> 10), CIS.CHAR2DATE(:LF-ITPA-REPORT-DT :WS-NULL-IND4
              ), CONVERT(DATE, :LF-ITPA-REPORT-DT :WS-NULL-IND4) )             
A00998               ,:LF-ITPA-RSLT-CURR-CD                             
A00998               ,:LF-ITPA-RSLT-ORIG-CD                             
A00998               ,CIS.CHAR2TIMESTAMP(:LF-LAST-UPDATE-TS)                    
A00998               ,:LF-LAST-UPDATE-USERID                            
A00998               ,IIF(TRY_CONVERT(DATE, :LF-LETTER-MAILED-DT 
                                            :WS-NULL-IND5
              ) IS NULL OR (PATINDEX('%.%', :LF-LETTER-MAILED-DT 
                                                          :WS-NULL-IND5
              ) <> 0) OR (LEN(:LF-LETTER-MAILED-DT :WS-NULL-IND5
              ) <> 10), CIS.CHAR2DATE(:LF-LETTER-MAILED-DT 
                                                          :WS-NULL-IND5
              ), CONVERT(DATE, :LF-LETTER-MAILED-DT :WS-NULL-IND5) )           
A00998               ,:LF-LETTER-NOTIFY-CD :WS-NULL-IND6                 
A00998               ,IIF(TRY_CONVERT(DATE, :LF-RESOLUTION-DT 
                                            :WS-NULL-IND7
              ) IS NULL OR (PATINDEX('%.%', :LF-RESOLUTION-DT 
                                                          :WS-NULL-IND7
              ) <> 0) OR (LEN(:LF-RESOLUTION-DT :WS-NULL-IND7
              ) <> 10), CIS.CHAR2DATE(:LF-RESOLUTION-DT :WS-NULL-IND7
              ), CONVERT(DATE, :LF-RESOLUTION-DT :WS-NULL-IND7) ))             
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CRED_ITPA_HIST                                   
MFA-TR*              (ALERT_TYPE_CD                                             
MFA-TR*              ,CONTACT_INFO_FL                                           
MFA-TR*              ,CR_HIST_TRAN_DT                                           
MFA-TR*              ,CR_HIST_TRAN_TM                                           
MFA-TR*              ,CUSTOMER_NO                                               
MFA-TR*              ,ITPA_ADDTNL_INFO                                          
MFA-TR*              ,ITPA_EFFECTIVE_DT                                         
MFA-TR*              ,ITPA_REPORT_DT                                            
MFA-TR*              ,ITPA_RSLT_CURR_CD                                         
MFA-TR*              ,ITPA_RSLT_ORIG_CD                                         
MFA-TR*              ,LAST_UPDATE_TS                                            
MFA-TR*              ,LAST_UPDATE_USERID                                        
MFA-TR*              ,LETTER_MAILED_DT                                          
MFA-TR*              ,LETTER_NOTIFY_CD                                          
MFA-TR*              ,RESOLUTION_DT)                                            
MFA-TR*        VALUES(:LF-ALERT-TYPE-CD:WS-NULL-IND1                            
MFA-TR*              ,:LF-CONTACT-INFO-FL                                       
MFA-TR*              ,:LF-CR-HIST-TRAN-DT                                       
MFA-TR*              ,:LF-CR-HIST-TRAN-TM                                       
MFA-TR*              ,:LF-CUSTOMER-NO                                           
MFA-TR*              ,:LF-ITPA-ADDTNL-INFO:WS-NULL-IND2                         
MFA-TR*              ,:LF-ITPA-EFFECTIVE-DT:WS-NULL-IND3                        
MFA-TR*              ,:LF-ITPA-REPORT-DT:WS-NULL-IND4                           
MFA-TR*              ,:LF-ITPA-RSLT-CURR-CD                                     
MFA-TR*              ,:LF-ITPA-RSLT-ORIG-CD                                     
MFA-TR*              ,:LF-LAST-UPDATE-TS                                        
MFA-TR*              ,:LF-LAST-UPDATE-USERID                                    
MFA-TR*              ,:LF-LETTER-MAILED-DT:WS-NULL-IND5                         
MFA-TR*              ,:LF-LETTER-NOTIFY-CD:WS-NULL-IND6                         
MFA-TR*              ,:LF-RESOLUTION-DT:WS-NULL-IND7)                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998                                                                  
A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998        NEXT SENTENCE                                             
A00998     ELSE                                                         
A00998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00998        MOVE 'INSERT'              TO ABEND-FUNCTION              
A00998        MOVE '7218'                TO ACTIVE-PARAGRAPH            
A00998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00998                                      ABEND-TABLES                
A00998        MOVE 'CSS_CRED_ITPA_HIST'  TO TABLE-1                     
A00998        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A00998        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
A00998        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00998        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00998     END-IF.                                                      
A00998                                                                  
A00998 7218-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
A00998*****************************************************************         
A00998*  UPDATE CSS_CRED_HIST_ADDR                                    *         
A00998*****************************************************************         
A00998                                                                  
A00998 7220-UPDATE-CRED-HIST-ADDR.                                      
A00998                                                                  
A00998     EXEC SQL                                                     
A00998         UPDATE CSS_CRED_HIST_ADDR                                
A00998            SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
A00998          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
                                                            
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CRED_HIST_ADDR                                        
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7220                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998                                                                  
A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998        NEXT SENTENCE                                             
A00998     ELSE                                                         
A00998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00998        MOVE 'UPDATE'              TO ABEND-FUNCTION              
A00998        MOVE '7220'                TO ACTIVE-PARAGRAPH            
A00998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00998                                      ABEND-TABLES                
A00998        MOVE 'CSS_CRED_HIST_ADDR'  TO TABLE-1                     
A00998        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A00998        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
A00998        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00998        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00998     END-IF.                                                      
A00998                                                                  
A00998 7220-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
A00998*****************************************************************         
A00998*  UPDATE CSS_ITPA_PHONE                                        *         
A00998*****************************************************************         
A00998                                                                  
A00998 7225-UPDATE-ITPA-PHONE.                                          
A00998                                                                  
A00998     EXEC SQL                                                     
A00998         UPDATE CSS_ITPA_PHONE                                    
A00998            SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
A00998          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
                                                            
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ITPA_PHONE                                            
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7225                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998                                                                  
A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998        NEXT SENTENCE                                             
A00998     ELSE                                                         
A00998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00998        MOVE 'UPDATE'              TO ABEND-FUNCTION              
A00998        MOVE '7215'                TO ACTIVE-PARAGRAPH            
A00998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00998                                      ABEND-TABLES                
A00998        MOVE 'CSS_ITPA_PHONE'      TO TABLE-1                     
A00998        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A00998        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
A00998        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00998        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00998     END-IF.                                                      
A00998                                                                  
A00998 7225-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
A00998*****************************************************************         
A00998*  UPDATE CSS_CRED_HIST_ACCT                                    *         
A00998*****************************************************************         
A00998                                                                  
A00998 7230-UPDATE-CRED-HIST-ACCT.                                      
A00998                                                                  
A00998     EXEC SQL                                                     
A00998         UPDATE CSS_CRED_HIST_ACCT                                
A00998            SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
A00998          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
                                                            
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CRED_HIST_ACCT                                        
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7230                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998                                                                  
A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998        NEXT SENTENCE                                             
A00998     ELSE                                                         
A00998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00998        MOVE 'UPDATE'              TO ABEND-FUNCTION              
A00998        MOVE '7230'                TO ACTIVE-PARAGRAPH            
A00998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00998                                      ABEND-TABLES                
A00998        MOVE 'CSS_CRED_HIST_ACCT'  TO TABLE-1                     
A00998        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A00998        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
A00998        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00998        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00998     END-IF.                                                      
A00998                                                                  
A00998 7230-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
A00998*****************************************************************         
A00998*  DELETE CSS_CRED_ITPA_HIST                                    *         
A00998*****************************************************************         
A00998                                                                  
A00998 7235-DELETE-CRED-ITPA-HIST.                                      
A00998                                                                  
A00998     EXEC SQL                                                     
A00998         DELETE FROM CSS_CRED_ITPA_HIST                           
A00998          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
                                                            
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CRED_ITPA_HIST                                   
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7235                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998                                                                  
A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998        NEXT SENTENCE                                             
A00998     ELSE                                                         
A00998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00998        MOVE 'DELETE'              TO ABEND-FUNCTION              
A00998        MOVE '7235'                TO ACTIVE-PARAGRAPH            
A00998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00998                                      ABEND-TABLES                
A00998        MOVE 'CSS_CRED_ITPA_HIST'  TO TABLE-1                     
A00998        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A00998        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
A00998        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00998        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00998     END-IF.                                                      
A00998                                                                  
A00998 7235-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
A00998*****************************************************************         
A00998*  DELETE CSS_CREDIT_HIST                                       *         
A00998*****************************************************************         
A00998                                                                  
A00998 7240-DELETE-CREDIT-HIST.                                         
A00998                                                                  
A00998     EXEC SQL                                                     
A00998         DELETE FROM CSS_CREDIT_HIST                              
A00998          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
                                                            
A00998     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_CREDIT_HIST                                      
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7240                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00998                                                                  
A00998     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00998     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00998        NEXT SENTENCE                                             
A00998     ELSE                                                         
A00998        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
A00998        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00998        MOVE 'DELETE'              TO ABEND-FUNCTION              
A00998        MOVE '7240'                TO ACTIVE-PARAGRAPH            
A00998        MOVE SPACES                TO ABEND-SQL-PREDICATES        
A00998                                      ABEND-TABLES                
A00998        MOVE 'CSS_CRED_HIST_ACCT'  TO TABLE-1                     
A00998        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
A00998        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
A00998        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
A00998        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A00998     END-IF.                                                      
A00998                                                                  
A00998 7240-EXIT.                                                       
A00998     EXIT.                                                        
A00998                                                                  
P00740*****************************************************************         
P00740*  UPDATE CSS_CORRESP_HDR                                       *         
P00740*****************************************************************         
P00740                                                                  
P00740 7250-UPDATE-CORRESP-HDR.                                         
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         UPDATE CSS_CORRESP_HDR                                   
P00740            SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
P00740          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CORRESP_HDR                                           
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7250                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00740        NEXT SENTENCE                                             
P00740     ELSE                                                         
P00740        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00740        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00740        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P00740        MOVE '7250'                TO ACTIVE-PARAGRAPH            
P00740        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740        MOVE 'CSS_CORRESP_HDR'     TO TABLE-1                     
P00740        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
P00740        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
P00740        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00740        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00740     END-IF.                                                      
P00740                                                                  
P00740 7250-EXIT.                                                       
P00740     EXIT.                                                        
P00740                                                                  
P00740*****************************************************************         
P00740*  UPDATE CSS_CORR_MAIL_STAT                                    *         
P00740*****************************************************************         
P00740                                                                  
P00740 7260-UPDATE-CORR-MAIL-STAT.                                      
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         UPDATE CSS_CORR_MAIL_STAT                                
P00740            SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
P00740          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_CORR_MAIL_STAT                                        
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7260                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00740        NEXT SENTENCE                                             
P00740     ELSE                                                         
P00740        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00740        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00740        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P00740        MOVE '7260'                TO ACTIVE-PARAGRAPH            
P00740        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740        MOVE 'CSS_CORR_MAIL_STAT'  TO TABLE-1                     
P00740        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
P00740        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
P00740        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00740        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00740     END-IF.                                                      
P00740                                                                  
P00740 7260-EXIT.                                                       
P00740     EXIT.                                                        
P00740                                                                  
P00740 7270-UPDATE-ACCESS-HISTORY.                                      
P00740                                                                  
P00740     EXEC SQL                                                     
P00740         UPDATE CSS_ACCESS_HISTORY                                
P00740            SET CUSTOMER_NO = :WS-NEW-CUST-NUM                    
P00740          WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                    
P00740                                                      
P00740     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCESS_HISTORY                                        
MFA-TR*           SET CUSTOMER_NO = :WS-NEW-CUST-NUM                            
MFA-TR*         WHERE CUSTOMER_NO = :WS-CUSTOMER-NUM                            
MFA-TR*        QUERYNO 7270                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00740                                                                  
P00740     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00740     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00740        NEXT SENTENCE                                             
P00740     ELSE                                                         
P00740        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
P00740        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00740        MOVE 'UPDATE'              TO ABEND-FUNCTION              
P00740        MOVE '7270'                TO ACTIVE-PARAGRAPH            
P00740        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00740                                      ABEND-TABLES                
P00740        MOVE 'CSS_ACCESS_HISTORY'  TO TABLE-1                     
P00740        MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1             
P00740        MOVE WS-CUSTOMER-NUM       TO HOSTVAR-ELEMENT-1           
P00740        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
P00740        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
P00740     END-IF.                                                      
P00740                                                                  
P00740 7270-EXIT.                                                       
P00740     EXIT.                                                        
P00740                                                                  
C31606*****************************************************************         
C31606*  UPDATE CUSTOMER NUMBER, BANK_SEQ_NO IN CSS_BANK_EFT          *         
C31606*****************************************************************         
C31606                                                                  
C31606 8090-UPDATE-CSS-BANK-EFT.                                        
C31606                                                                  
C31606     EXEC SQL                                                     
C31606         UPDATE CSS_BANK_EFT                                      
C31606            SET CUSTOMER_NO      =:WS-NEW-CUST-NUM,               
C31606                CUST_BANK_SEQ_NO =:WS-CUST-BANK-SEQ-NO            
C31606          WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                       
                                                            
C31606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_BANK_EFT                                              
MFA-TR*           SET CUSTOMER_NO      =:WS-NEW-CUST-NUM,                       
MFA-TR*               CUST_BANK_SEQ_NO =:WS-CUST-BANK-SEQ-NO                    
MFA-TR*         WHERE ACCOUNT_NO =:WS-ACCOUNT-NUM                               
MFA-TR*        QUERYNO 8090                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31606                                                                  
C31606     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31606     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C31606         NEXT SENTENCE                                            
C31606     ELSE                                                         
C31606         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
C31606         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C31606         MOVE 'UPDATE'             TO ABEND-FUNCTION              
C31606         MOVE '8090'               TO ACTIVE-PARAGRAPH            
C31606         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C31606                                      ABEND-TABLES                
C31606         MOVE 'CSS_BANK_EFT'       TO TABLE-1                     
C31606         MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
C31606         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-2            
C31606         MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
C31606         MOVE WS-NEW-CUST-NO        TO HOSTVAR-ELEMENT-2          
C31606         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C31606         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C31606     END-IF.                                                      
C31606                                                                  
C31606 8090-EXIT.                                                       
C31606      EXIT.                                                       
C31606                                                                  
C31606*****************************************************************         
C31606*  INSERT INTO CSS_CUSTOMER_BANK                                *         
C31606*****************************************************************         
C31606                                                                  
C31606 8168-INSERT-CSS-CUSTOMER-BANK.                                   
C31606                                                                  
C31606     EXEC SQL                                                     
C31606         INSERT INTO CSS_CUSTOMER_BANK                            
C31606             (BANK_ACCOUNT_NAME                                   
C31606             ,BANK_ACCT_NO                                        
C31606             ,BANK_ACCT_STAT_CD                                   
C31606             ,BANK_ACCT_TYPE_CD                                   
C31606             ,BANK_ID                                             
C31606             ,CUST_BANK_SEQ_NO                                    
C31606             ,CUSTOMER_NO                                         
C31606             ,LAST_UPDATE_TS                                      
C31606             ,LAST_UPDATE_USERID                                  
C31606             ,BANK_ACCT_NICKNAME)                                 
C31606         VALUES                                                   
C31606             (:JF-BANK-ACCOUNT-NAME                               
C31606             ,:JF-BANK-ACCT-NO                                    
C31606             ,:JF-BANK-ACCT-STAT-CD                               
C31606             ,:JF-BANK-ACCT-TYPE-CD                               
C31606             ,:JF-BANK-ID                                         
C31606**********   ,:JF-CUST-BANK-SEQ-NO                                        
C31606*********    ,:JF-CUSTOMER-NO                                             
C31606*********    ,:JF-LAST-UPDATE-TS                                          
C31606*********    ,:JF-LAST-UPDATE-USERID                                      
C31606             ,:WS-NEW-CUST-BANK-SEQ                               
C31606             ,:WS-NEW-CUST-NUM                                    
C31606             ,CIS.CURRENT$TIMESTAMP()                                   
C31606             ,:WS-USERID                                          
C31606**********   ,:WS-NEW-ACCT-NICKNAME)                                      
C31606             ,:JF-BANK-ACCT-NICKNAME)                             
C31606     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_CUSTOMER_BANK                                    
MFA-TR*            (BANK_ACCOUNT_NAME                                           
MFA-TR*            ,BANK_ACCT_NO                                                
MFA-TR*            ,BANK_ACCT_STAT_CD                                           
MFA-TR*            ,BANK_ACCT_TYPE_CD                                           
MFA-TR*            ,BANK_ID                                                     
MFA-TR*            ,CUST_BANK_SEQ_NO                                            
MFA-TR*            ,CUSTOMER_NO                                                 
MFA-TR*            ,LAST_UPDATE_TS                                              
MFA-TR*            ,LAST_UPDATE_USERID                                          
MFA-TR*            ,BANK_ACCT_NICKNAME)                                         
MFA-TR*        VALUES                                                           
MFA-TR*            (:JF-BANK-ACCOUNT-NAME                                       
MFA-TR*            ,:JF-BANK-ACCT-NO                                            
MFA-TR*            ,:JF-BANK-ACCT-STAT-CD                                       
MFA-TR*            ,:JF-BANK-ACCT-TYPE-CD                                       
MFA-TR*            ,:JF-BANK-ID                                                 
MFA-TR**********   ,:JF-CUST-BANK-SEQ-NO                                        
MFA-TR*********    ,:JF-CUSTOMER-NO                                             
MFA-TR*********    ,:JF-LAST-UPDATE-TS                                          
MFA-TR*********    ,:JF-LAST-UPDATE-USERID                                      
MFA-TR*            ,:WS-NEW-CUST-BANK-SEQ                                       
MFA-TR*            ,:WS-NEW-CUST-NUM                                            
MFA-TR*            ,CURRENT TIMESTAMP                                           
MFA-TR*            ,:WS-USERID                                                  
MFA-TR**********   ,:WS-NEW-ACCT-NICKNAME)                                      
MFA-TR*            ,:JF-BANK-ACCT-NICKNAME)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31606                                                                  
C31606     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31606     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C31606         NEXT SENTENCE                                            
C31606     ELSE                                                         
C31606         MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
C31606         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
C31606         MOVE 'INSERT'              TO ABEND-FUNCTION             
C31606         MOVE '8168'                TO ACTIVE-PARAGRAPH           
C31606         MOVE SPACES                TO ABEND-SQL-PREDICATES       
C31606                                       ABEND-TABLES               
C31606         MOVE 'CSS_CUSTOMER_BANK'   TO TABLE-1                    
C31606         MOVE 'CUSTOMER_NO'         TO TABLE-ELEMENT-1            
C31606         MOVE WS-NEW-CUST-NUM       TO HOSTVAR-ELEMENT-1          
C31606         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C31606         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C31606     END-IF.                                                      
C31606                                                                  
C31606 8168-EXIT.                                                       
C31606     EXIT.                                                        
                                                                        
      ****************************************************************  16263003
      * 6530- MAINTENANCE TRANSACTION JOURNALING INCLUDE             *  16265003
      ****************************************************************  16267003
           EXEC SQL                                                     04126399
              INCLUDE CPD00067                                                  
           END-EXEC.                                                    12340000
                                                                        
                                                                        
      ****************************************M*************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
