       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02397.                                         
COB303 DATE-WRITTEN.  SEPTEMBER 13, 1999.                               
       DATE-COMPILED.                                                   
      *                                                                 00050003
      ******************************************************************00060003
      *                                                                *00070003
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080003
      *                                                                *00090003
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100003
      *                                                                *00110003
      *  TRANID:        S397                                           *00120009
      *  PROGRAM:       S397                                           *00130009
      *  CALLING SP:    PA_S397                                        *00140009
      *                                                                *00150003
      ******************************************************************00160003
      *                 P R O G R A M  S U M M A R Y                   *00170003
      ******************************************************************00180086
      * THIS PROCEDURE CALCULATES THE LOCAL OFFICE TOTAL FROM THE      *00190086
      * CSS_CSH_DRWR-JRNL AND ALSO CALCULATE THE ENTIRE COMPANY TOTAL  *00200086
      * FOR THE REPORT DATE.                                           *00210086
      ******************************************************************00220003
      *                     PROGRAM MODIFICATION LOG                   *00230003
      *                                                                *00240003
      *    DATE    INITIALS   COMMENTS                                 *00250003
      *  --------  --------   ---------------------------------------  *00260003
      *  09/02/99   RAJESH    PROCEDURE ORIGINALLY CODED.              *00270003
T19902*  11/23/99   CBSI      CHANGED TO RETRIEVE BATCHES WITH NO      *        
T19902*                       TRANSACTIONS ALSO.                       *        
T19924*  11/26/99   CBSI      CHANGED TO SKIP THE TRANSACTIONS WHICH   *        
T19924*                       ARE NEITHER LIHEAP NOR CLEAR CASH.       *        
REARCH*  06/27/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
T36246*  09/05/07  LG41184    PERFORMANCE CHANGES.                     *        
      ******************************************************************00280003
      ******************************************************************00290003
      *                                                                *00300003
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00310003
      *                                                                *00320003
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00330003
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00340003
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00350003
      *  3000 - 4999  NOT USED                                         *00360003
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00370003
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00380003
      *  7000 - 7999  INPUT MODULES                                    *00390003
      *  8000 - 8999  OUTPUT MODULES                                   *00400003
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00410003
      *                                                                *00420003
      ******************************************************************00430003
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02397'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                     PIC X(40) VALUE                 
REARCH     'WORKING STORAGE FOR CSR02397 STARTS HERE'.                  
                                                                        
      ******************************************************************00520003
      *    COBOL WORKING STORAGE COPY BOOKS                            *00530003
      ******************************************************************00540003
                                                                        
          COPY CWS00303.                                                00590003
          COPY CJF00101.                                                00600006
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************00620003
      *    WORK AREAS                                                  *00630003
      ******************************************************************00640003
                                                                        
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  COUNTER-FLAG.                                                
           05  WS-HDR-COUNT-FLAG        PIC X(01) VALUE 'N'.            
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9) COMP.                 
           05  WRKLEN1                  PIC S9(9) COMP.                 
           05  WRKLEN2                  PIC S9(9) COMP.                 
           05  WRK-DONE-STATUS          PIC S9(9) COMP.                 
                                                                        
       01  WS-CASHIER-NAME.                                             
           05 WS-LAST-NAME              PIC X(12).                      
           05 WS-FIRST-NAME             PIC X(15).                      
                                                                        
       01  WS-DRWR-CLOSED-CASHIER-NAME.                                 
           05 WS-DRWR-CLOSED-LAST-NAME  PIC X(12).                      
           05 WS-DRWR-CLOSED-FIRST-NAME PIC X(15).                      
                                                                        
       01  WS-RPT-CLOSED-CASHIER-NAME.                                  
           05 WS-RPT-CLOSED-LAST-NAME   PIC X(12).                      
           05 WS-RPT-CLOSED-FIRST-NAME  PIC X(15).                      
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(8)  VALUE 'CSR02397'.     
REARCH     05  WS-SQLSTATE              PIC X(05) VALUE SPACES.         
           05  WS-HDR-STATUS            PIC X(01).                      
           05  WS-NULL-IND1             PIC S9(04) COMP VALUE 0.        
           05  WS-NULL-IND2             PIC S9(04) COMP VALUE 0.        
                                                                        
       01  WS-DATE-VARIABLES.                                           
           05  WS-CURRENT-TIMESTAMP     PIC X(26).                      
                                                                        
       01  WS-WORK-FIELDS.                                              
           05 WS-PREV-CASH-DRAWER-ID    PIC S9(09) COMP.                
COB305     05 WS-GEN-LED-AMT        PIC S9(11)V99 COMP-3 VALUE 0.          
           05 WS-GL-ACCT-NO-ED          PIC 9(3).9(4).                  
T36246*    05 WS-CASH-CLEAR             PIC X(08) VALUE 'CLR-CASH'.     01310037
COB305     05 WS-TOTAL-AMOUNT        PIC S9(11)V99 COMP-3 VALUE 0.          
COB305     05 WS-COMP-TOTAL-AMT        PIC S9(11)V99 COMP-3 VALUE 0.          
           05 WS-CURRENCY-TYPE          PIC X.                          
              88 CASH                             VALUE 'A'.            
              88 CHECK                            VALUE 'C'.            
              88 MONEY-ORDER                      VALUE 'M'.            
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-ONE                   PIC S9(9) COMP VALUE 1.         
           05  WS-ACTIVE-CODE           PIC X(01) VALUE 'A'.            
           05  WS-INACTIVE-CODE         PIC X(01) VALUE 'C'.            
           05  WS-GL-ACCT-FLAG          PIC X(01) VALUE 'N'.            
           05  WS-811                   PIC S9(9) VALUE -811 COMP.      
                                                                        
       01  FILLER                       PIC X(32) VALUE                 
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
           05  RS-USER-ID               PIC  X(27) VALUE SPACE.         
           05  RS-BATCH-NO              PIC S9(04) COMP.                
           05  RS-BATCH-STATUS          PIC  X(06) VALUE SPACE.         
           05  RS-BATCH-TOTAL           PIC S9(11)V99 COMP-3 VALUE +0.  
           05  RS-RPT-CLOSED-DATETIME   PIC  X(26) VALUE SPACE.         
           05  RS-DRWR-CLOSED-DATETIME  PIC  X(26) VALUE SPACE.         
           05  RS-DRWR-CLOSED-BY        PIC  X(27) VALUE SPACE.         
           05  RS-RPT-CLOSED-BY         PIC  X(27) VALUE SPACE.         
           05  RS-LOCOFF-TOTAL          PIC S9(11)V99 COMP-3 VALUE +0.  
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH     05  S-USER-ID                PIC  X(27) VALUE SPACE.         
REARCH     05  S-BATCH-NO               PIC S9(04) COMP.                
REARCH     05  S-BATCH-STATUS           PIC  X(06) VALUE SPACE.         
REARCH     05  S-BATCH-TOTAL            PIC S9(11)V99 COMP-3 VALUE +0.  
REARCH     05  S-RPT-CLOSED-DATETIME    PIC  X(26) VALUE SPACE.         
REARCH     05  S-DRWR-CLOSED-DATETIME   PIC  X(26) VALUE SPACE.         
REARCH     05  S-DRWR-CLOSED-BY         PIC  X(27) VALUE SPACE.         
REARCH     05  S-RPT-CLOSED-BY          PIC  X(27) VALUE SPACE.         
REARCH     05  S-LOCOFF-TOTAL           PIC S9(11)V99 COMP-3 VALUE +0.  
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  GL-ACCOUNT-STATUS        PIC  X(01).                     
               88  CLEARING-ACCOUNT               VALUE 'C'.            
               88  LIHEAP-PAYMENT                 VALUE 'L'.            
               88  LIHEAP-REVERSAL                VALUE 'R'.            
           05  WS-CSH-DRWR-STATUS       PIC  X(06).                     
               88  CSH-DRWR-STAT-CLOSED           VALUE 'CLOSED'.       
               88  CSH-DRWR-STAT-ACTIVE           VALUE 'ACTIVE'.       
                                                                        
           05  WS-NO-MORE-DATA          PIC  X(01) VALUE 'N'.           
               88  NO-MORE-JRNL-DATA               VALUES 'Y'.          
               88  MORE-JRNL-DATA                  VALUES 'N'.          
T19902                                                                  
T19902     05  WS-NO-MORE-CNTL-DATA     PIC  X(01) VALUE 'N'.           
T19902         88  NO-MORE-CNTL-DATA               VALUES 'Y'.          
T19902         88  MORE-CNTL-DATA                  VALUES 'N'.          
                                                                        
           05  WS-NO-COMP-DATA          PIC  X(01) VALUE 'N'.           
               88  NO-MORE-COMP-DATA               VALUES 'Y'.          
               88  MORE-COMP-DATA                  VALUES 'N'.          
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
      ******************************************************************02010037
      *    DB2 INCLUDES                                                *02020037
      ******************************************************************02030037
                                                                        
           EXEC SQL                                                     02050037
              INCLUDE SQLCA                                             02060037
           END-EXEC.                                                    02070037
      *************************************************************     02080037
      *    CSS_CSH_DRWR_JRNL                                            02090037
      *************************************************************     02100037
            EXEC SQL                                                    02110037
                INCLUDE TBCDJRNL                                        02120037
            END-EXEC.                                                   02130037
                                                                        
      *************************************************************     02150037
      *    CSS_CSH_DRWR_CNTL                                            02160037
      *************************************************************     02170037
            EXEC SQL                                                    02180037
               INCLUDE  TBCDCNTL                                        02190037
            END-EXEC.                                                   02200037
                                                                        
      *************************************************************     02220037
                                                                        
      *    CSS_LIEAP_AGENCY                                             02240037
      *************************************************************     02250037
           EXEC SQL                                                     02260037
              INCLUDE  TBLIAGCY                                         02270037
           END-EXEC.                                                    02280037
                                                                        
      *************************************************************     02370037
      *    CSS_GL_ACCT_NO                                               02380037
      *************************************************************     02390037
           EXEC SQL                                                     02400037
              INCLUDE TBGLATNO                                          02410037
           END-EXEC.                                                    02420037
      *************************************************************     02430037
      *    CSS_CSH_REPORT_HDR                                           02440037
      *************************************************************     02450037
           EXEC SQL                                                     02460037
              INCLUDE TBCSRPHD                                          02470037
           END-EXEC.                                                    02480037
      ******************************************************************02490037
                                                                        
      *************************************************************     02510050
      *    CSS_USER_PROFILE                                             02520050
      *************************************************************     02530050
           EXEC SQL                                                     02540050
              INCLUDE TBUSRPRF                                          02550050
           END-EXEC.                                                    02560050
      ******************************************************************02570050
                                                                        
T19902**********************************************************        02590037
T19902*         CURSOR FOR CSS_CSH_DRWR_CNTL                            02600037
T19902**********************************************************        02610037
T19902     EXEC SQL                                                     
T19902          DECLARE  CNTL_CURSOR  CURSOR FOR                        
T19902          SELECT                                                  
T19902                 CASH_DRAWER_ID,                                  
T19902                 USER_ID,                                         
T19902                 CODE_CSH_DRWR_STAT,                              
T19902                 REPLACE(REPLACE(CONVERT(CHAR(26), BALANCED_TS
           , 121), ' ', '-'), ':', '.') BALANCED_TS,                           
T19902                 BALANCED_BY                                      
T19902          FROM                                                    
T19902            CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                       
T19902          WHERE    CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO       
T19902            AND    CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE     
T19902            AND    DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )      
T19902            ORDER BY                                              
T19902                   CASH_DRAWER_ID                                 
T36246          FOR READ ONLY                                   
T19902     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     02620037
MFA-TR*         DECLARE  CNTL_CURSOR  CURSOR FOR                        02630037
MFA-TR*         SELECT                                                  02640037
MFA-TR*                CASH_DRAWER_ID,                                  02650037
MFA-TR*                USER_ID,                                                 
MFA-TR*                CODE_CSH_DRWR_STAT,                              02660037
MFA-TR*                BALANCED_TS,                                     02670037
MFA-TR*                BALANCED_BY                                      02680037
MFA-TR*         FROM                                                    02730037
MFA-TR*           CSS_CSH_DRWR_CNTL                                     02740037
MFA-TR*         WHERE    CASH_COMPANY_NO    = :CS-CASH-COMPANY-NO       02750037
MFA-TR*           AND    CASH_LOCAL_OFFICE  = :CS-CASH-LOCAL-OFFICE     02760037
MFA-TR*           AND    DATE_CASH_REPORT   = :CS-DATE-CASH-REPORT      02770037
MFA-TR*           ORDER BY                                              02780037
MFA-TR*                  CASH_DRAWER_ID                                 02790037
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    02810056
HPCCDM*EJECT                                                            02820037
      **********************************************************        02590037
      *         CURSOR FOR CSS_CSH_DRWR_JRNL                            02600037
      **********************************************************        02610037
           EXEC SQL                                                     
T19902          DECLARE  JRNL_CURSOR  CURSOR FOR                        
                SELECT                                                  
                       CASH_COMPANY_NO,                                 
                       CASH_LOCAL_OFFICE,                               
                       DATE_CASH_REPORT,                                
                       ENTRY_NO,                                        
                       CURRENCY_TYPE,                                   
                       TRAN_DATA                                        
                FROM                                                    
                  CSS_CSH_DRWR_JRNL WITH(READUNCOMMITTED)                       
                WHERE    CASH_COMPANY_NO    = :CJ-CASH-COMPANY-NO       
                  AND    CASH_LOCAL_OFFICE  = :CJ-CASH-LOCAL-OFFICE     
                  AND    DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
T19902            AND    CASH_DRAWER_ID     = :CJ-CASH-DRAWER-ID        
T36246          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02620037
MFA-TR*         DECLARE  JRNL_CURSOR  CURSOR FOR                        02630037
MFA-TR*         SELECT                                                  02640037
MFA-TR*                CASH_COMPANY_NO,                                 02650037
MFA-TR*                CASH_LOCAL_OFFICE,                               02660037
MFA-TR*                DATE_CASH_REPORT,                                02670037
MFA-TR*                ENTRY_NO,                                        02690037
MFA-TR*                CURRENCY_TYPE,                                   02710037
MFA-TR*                TRAN_DATA                                        02720037
MFA-TR*         FROM                                                    02730037
MFA-TR*           CSS_CSH_DRWR_JRNL                                     02740037
MFA-TR*         WHERE    CASH_COMPANY_NO    = :CJ-CASH-COMPANY-NO       02750037
MFA-TR*           AND    CASH_LOCAL_OFFICE  = :CJ-CASH-LOCAL-OFFICE     02760037
MFA-TR*           AND    DATE_CASH_REPORT   = :CJ-DATE-CASH-REPORT      02770037
MFA-TR*           AND    CASH_DRAWER_ID     = :CJ-CASH-DRAWER-ID                
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    02810056
HPCCDM*EJECT                                                            02820037
      **********************************************************        02830073
      *         CURSOR FOR COMPANY TOTAL CSS_CSH_DRWR_JRNL              02840073
      **********************************************************        02850073
           EXEC SQL                                                     
                DECLARE  COMPANY_TOT_CURSOR CURSOR FOR                  
                SELECT                                                  
                       CASH_COMPANY_NO,                                 
                       CASH_LOCAL_OFFICE,                               
                       DATE_CASH_REPORT,                                
                       CASH_DRAWER_ID,                                  
                       ENTRY_NO,                                        
                       USER_ID,                                         
                       CURRENCY_TYPE,                                   
                       TRAN_DATA                                        
                FROM                                                    
                  CSS_CSH_DRWR_JRNL WITH(READUNCOMMITTED)                       
                WHERE    CASH_COMPANY_NO    = :CJ-CASH-COMPANY-NO       
                  AND    DATE_CASH_REPORT   = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )      
T36246*           ORDER BY                                              03010073
T36246*                  CASH_DRAWER_ID,                                03020073
T36246*                  CASH_LOCAL_OFFICE,                             03030073
T36246*                  USER_ID                                        03040073
T36246          FOR READ ONLY                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     02860073
MFA-TR*         DECLARE  COMPANY_TOT_CURSOR CURSOR FOR                  02870073
MFA-TR*         SELECT                                                  02880073
MFA-TR*                CASH_COMPANY_NO,                                 02890073
MFA-TR*                CASH_LOCAL_OFFICE,                               02900073
MFA-TR*                DATE_CASH_REPORT,                                02910073
MFA-TR*                CASH_DRAWER_ID,                                  02920073
MFA-TR*                ENTRY_NO,                                        02930073
MFA-TR*                USER_ID,                                         02940073
MFA-TR*                CURRENCY_TYPE,                                   02950073
MFA-TR*                TRAN_DATA                                        02960073
MFA-TR*         FROM                                                    02970073
MFA-TR*           CSS_CSH_DRWR_JRNL                                     02980073
MFA-TR*         WHERE    CASH_COMPANY_NO    = :CJ-CASH-COMPANY-NO       02990073
MFA-TR*           AND    DATE_CASH_REPORT   = :CJ-DATE-CASH-REPORT      03000073
MFA-TR*           ORDER BY                                              03010073
MFA-TR*                  CASH_DRAWER_ID,                                03020073
MFA-TR*                  CASH_LOCAL_OFFICE,                             03030073
MFA-TR*                  USER_ID                                        03040073
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*    END-EXEC.                                                    03050073
HPCCDM*EJECT                                                            03060073
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-COMPANY-NO          PIC X(2).                           
REARCH 01  PARM-CASH-LOCAL-OFFICE   PIC X(3).                           
REARCH 01  PARM-CASH-REPORT-DATE    PIC X(10).                          
REARCH 01  PARM-FLAG                PIC X(1).                           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING  PARM-COMPANY-NO                        
REARCH                           PARM-CASH-LOCAL-OFFICE                 
REARCH                           PARM-CASH-REPORT-DATE                  
REARCH                           PARM-FLAG.                             
                                                                        
      ******************************************************************03090037
      * 0000-MAINLINE                                                  *03100037
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *03110037
      ******************************************************************03120037
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03240037
      * 0100-INITIALIZE                                                *03250037
      *                                                                *03260037
      *     1. RESET DB2 ERROR HANDLERS                                *03270037
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *03280037
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *03290037
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*03300037
      *                                                                *03310037
      ******************************************************************03320037
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               RETURN_CODE                                        
REARCH              ,LTRIM(RTRIM(USER_ID))              AS  USER_ID            
REARCH              ,BATCH_NO                                           
REARCH              ,LTRIM(RTRIM(BATCH_STATUS))         AS  BATCH_STATUS       
REARCH              ,BATCH_TOTAL                                        
REARCH              ,LTRIM(RTRIM(RPT_CLOSED_DTETIME))   AS  
           RPT_CLOSED_DTETIME 
REARCH              ,LTRIM(RTRIM(DRWR_CLOSED_DTETME))   AS  
           DRWR_CLOSED_DTETME 
REARCH              ,LTRIM(RTRIM(DRWR_CLOSED_BY))       AS  
           DRWR_CLOSED_BY     
REARCH              ,LTRIM(RTRIM(RPT_CLOSED_BY))        AS  
           RPT_CLOSED_BY      
REARCH              ,LOCOFF_TOTAL                                       
REARCH          FROM                                                    
REARCH              #CSR02397_R1                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,STRIP(USER_ID)              AS  USER_ID                    
MFA-TR*             ,BATCH_NO                                                   
MFA-TR*             ,STRIP(BATCH_STATUS)         AS  BATCH_STATUS               
MFA-TR*             ,BATCH_TOTAL                                                
MFA-TR*             ,STRIP(RPT_CLOSED_DTETIME)   AS  RPT_CLOSED_DTETIME         
MFA-TR*             ,STRIP(DRWR_CLOSED_DTETME)   AS  DRWR_CLOSED_DTETME         
MFA-TR*             ,STRIP(DRWR_CLOSED_BY)       AS  DRWR_CLOSED_BY             
MFA-TR*             ,STRIP(RPT_CLOSED_BY)        AS  RPT_CLOSED_BY              
MFA-TR*             ,LOCOFF_TOTAL                                               
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR02397_R1                                         
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************02530000
REARCH* 0100A-DECLARE-GTT                                              *02540000
REARCH******************************************************************02610000
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02397_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02397_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02397_R1
              (                                                       
REARCH               RETURN_CODE            INT                     
REARCH              ,USER_ID CHAR(27)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,BATCH_NO               SMALLINT                    
REARCH              ,BATCH_STATUS CHAR(06)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,BATCH_TOTAL            DECIMAL(13,2)               
REARCH              ,RPT_CLOSED_DTETIME CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DRWR_CLOSED_DTETME CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,DRWR_CLOSED_BY CHAR(27)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,RPT_CLOSED_BY CHAR(27)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,LOCOFF_TOTAL           DECIMAL(13,2)               
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLSTATE            TO WS-SQLSTATE.                     
REARCH     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
REARCH     ELSE                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH               NEXT SENTENCE                                      
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02397_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
      ******************************************************************03600037
      * 1000-PROCESS-INPUT                                             *03610037
      *     1. RECEIVE PARMS.                                          *03620037
      ******************************************************************03630037
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                          TO ACTIVE-PARAGRAPH     
                                                                        
T19902     MOVE PARM-CASH-REPORT-DATE           TO CS-DATE-CASH-REPORT, 
T19902                                             CJ-DATE-CASH-REPORT  
                                                                        
T19902     MOVE PARM-COMPANY-NO                 TO CS-CASH-COMPANY-NO,  
T19902                                             CJ-CASH-COMPANY-NO   
                                                                        
T19902     MOVE PARM-CASH-LOCAL-OFFICE          TO CS-CASH-LOCAL-OFFICE,
T19902                                             CJ-CASH-LOCAL-OFFICE 
           .                                                            
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************04330037
      * 2000-PROCESS-OUTPUT.                                           *04340037
      *                                                                *04350037
      *     1. DESCRIBE RESULT SET                                     *04360037
      *     2. UPDATE DB2 DATA                                         *04370037
      *     3. SEND RESULT SET                                         *04380037
      *                                                                *04390037
      ******************************************************************04400037
      *                                                                 04410037
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 2200-BUILD-RESULT            THRU 2200-EXIT.         
      *                                                                 04480037
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************03490000
REARCH* 2000A-MOVE-RESULT.                                             *03500000
REARCH******************************************************************03570000
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO  S-RETURN-CODE.            
REARCH     MOVE  RS-USER-ID               TO  S-USER-ID.                
REARCH     MOVE  RS-BATCH-NO              TO  S-BATCH-NO.               
REARCH     MOVE  RS-BATCH-STATUS          TO  S-BATCH-STATUS.           
REARCH     MOVE  RS-BATCH-TOTAL           TO  S-BATCH-TOTAL.            
REARCH     MOVE  RS-RPT-CLOSED-DATETIME   TO  S-RPT-CLOSED-DATETIME.    
REARCH     MOVE  RS-DRWR-CLOSED-DATETIME  TO  S-DRWR-CLOSED-DATETIME.   
REARCH     MOVE  RS-DRWR-CLOSED-BY        TO  S-DRWR-CLOSED-BY.         
REARCH     MOVE  RS-RPT-CLOSED-BY         TO  S-RPT-CLOSED-BY.          
REARCH     MOVE  RS-LOCOFF-TOTAL          TO  S-LOCOFF-TOTAL.           
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                 03680000
      ***************************************************************   06680037
      * 2200-BUILD-RESULT                                           *   06690037
      *     BUILD THE RESULT SET                                    *   06700037
      ***************************************************************   06710037
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                          TO ACTIVE-PARAGRAPH.    
           INITIALIZE WS-TOTAL-AMOUNT,WS-CSH-DRWR-STATUS                
                      WS-COMP-TOTAL-AMT                                 
           PERFORM 7000-GET-CLR-ACCT-NUMBER   THRU 7000-EXIT            
           IF PARM-FLAG = 'Y'                                           
              PERFORM 7800-OPEN-COMPANY-TOTAL-CSR THRU 7800-EXIT        
              PERFORM 7900-FETCH-COMPANY-TOTAL-CSR THRU 7900-EXIT       
              PERFORM 2600-GET-COMPANY-TOTAL          THRU 2600-EXIT    
           ELSE                                                         
T19902        PERFORM 7020-OPEN-CNTL-CURSOR      THRU 7020-EXIT         
T19902        PERFORM 7050-FETCH-CNTL-CURSOR     THRU 7050-EXIT         
T19902        IF NO-MORE-CNTL-DATA                                      
T19902           MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE      
REARCH           PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT        
T19902           PERFORM 8100-SEND-RESULT        THRU 8100-EXIT         
T19902        ELSE                                                      
T19902           PERFORM 2250-DETAIL-PROCESSING  THRU 2250-EXIT         
T19902        END-IF                                                    
T19902        PERFORM 7070-CLOSE-CNTL-CURSOR     THRU 7070-EXIT         
           END-IF                                                       
           .                                                            
       2200-EXIT.                                                       
           EXIT.                                                        
T19902                                                                  
T19902***************************************************************   06950086
T19902* 2250-DETAIL-PROCESSING                                      *   06960086
T19902* PROCESS THE CASH-DRAWER-ID'S IN THE CNTL TABLE AND SENDS    *   06970086
T19902* RESULTS.                                                    *   06980086
T19902***************************************************************   06990086
T19902 2250-DETAIL-PROCESSING.                                          
T19902      PERFORM UNTIL NO-MORE-CNTL-DATA                             
T19902          MOVE CS-CASH-DRAWER-ID           TO CJ-CASH-DRAWER-ID,  
T19902                                              RS-BATCH-NO         
T19902          IF CS-CODE-CSH-DRWR-STAT = 'A'                          
T19902             SET CSH-DRWR-STAT-ACTIVE TO TRUE                     
T19902          ELSE                                                    
T19902             SET CSH-DRWR-STAT-CLOSED TO TRUE                     
T19902          END-IF                                                  
T19902          MOVE CS-USER-ID                  TO PF-USER-ID          
T19902          IF PF-USER-ID = SPACES                                  
T19902             MOVE SPACES                   TO WS-FIRST-NAME       
T19902             MOVE SPACES                   TO WS-LAST-NAME        
T19902          ELSE                                                    
T19902             PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT         
T19902             MOVE PF-FIRST-NAME            TO WS-FIRST-NAME       
T19902             MOVE PF-LAST-NAME             TO WS-LAST-NAME        
T19902          END-IF                                                  
T19902          MOVE WS-CASHIER-NAME             TO RS-USER-ID          
T19902          PERFORM 7100-OPEN-JRNL-CURSOR    THRU 7100-EXIT         
T19902          PERFORM 7200-FETCH-JRNL-CURSOR   THRU 7200-EXIT         
T19902          IF NO-MORE-JRNL-DATA                                    
T19902             PERFORM 2500-SELECT-LOCOFF-STATUS                    
T19902                                           THRU 2500-EXIT         
T19902             MOVE WS-CSH-DRWR-STATUS       TO RS-BATCH-STATUS     
T19902             MOVE CS-BALANCED-TS           TO                     
T19902                                           RS-DRWR-CLOSED-DATETIME
T19902             MOVE CS-BALANCED-BY           TO PF-USER-ID          
T19902             IF PF-USER-ID = SPACES                               
T19902                MOVE SPACES TO WS-DRWR-CLOSED-FIRST-NAME          
T19902                MOVE SPACES TO WS-DRWR-CLOSED-LAST-NAME           
T19902             ELSE                                                 
T19902                PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT      
T19902                MOVE PF-FIRST-NAME TO WS-DRWR-CLOSED-FIRST-NAME   
T19902                MOVE PF-LAST-NAME  TO WS-DRWR-CLOSED-LAST-NAME    
T19902             END-IF                                               
T19902             MOVE WS-DRWR-CLOSED-CASHIER-NAME TO                  
T19902                                       RS-DRWR-CLOSED-BY          
REARCH             PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT            
T19902             PERFORM 8100-SEND-RESULT  THRU 8100-EXIT             
T19902             INITIALIZE WS-TOTAL-AMOUNT,WS-CSH-DRWR-STATUS        
T19902                        TDS-RETURN-FIELDS                         
T19902          ELSE                                                    
T19902             PERFORM 2300-DETAIL-PROCESSING   THRU 2300-EXIT      
T19902          END-IF                                                  
T19902          PERFORM 7300-CLOSE-JRNL-CURSOR      THRU 7300-EXIT      
T19902          PERFORM 7050-FETCH-CNTL-CURSOR      THRU 7050-EXIT      
T19902          SET MORE-JRNL-DATA                  TO TRUE             
T19902      END-PERFORM                                                 
T19902      .                                                           
T19902 2250-EXIT.                                                       
T19902     EXIT.                                                        
                                                                        
      ***************************************************************   06950086
      * 2300-DETAIL-PROCESSING                                      *   06960086
      * PROCESS THE JRNL TABLE DETAIL AND SENDS THE RESULTS TO      *   06970086
      * OUTPUT VARIABLES.                                           *   06980086
      ***************************************************************   06990086
       2300-DETAIL-PROCESSING.                                          
            PERFORM UNTIL NO-MORE-JRNL-DATA                             
                PERFORM 2400-PROCESS-DATA-LINE THRU 2400-EXIT           
T19902          PERFORM 7200-FETCH-JRNL-CURSOR     THRU 7200-EXIT       
                IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
T19902             CONTINUE                                             
                ELSE                                                    
                   MOVE SPACES            TO RS-DRWR-CLOSED-DATETIME    
                   MOVE WS-TOTAL-AMOUNT       TO RS-BATCH-TOTAL         
T19902             PERFORM 2500-SELECT-LOCOFF-STATUS THRU 2500-EXIT     
                   MOVE WS-CSH-DRWR-STATUS TO RS-BATCH-STATUS           
                   MOVE CS-BALANCED-TS     TO RS-DRWR-CLOSED-DATETIME   
                   MOVE CS-BALANCED-BY           TO PF-USER-ID          
                   IF PF-USER-ID = SPACES                               
                      MOVE SPACES TO WS-DRWR-CLOSED-FIRST-NAME          
                      MOVE SPACES TO WS-DRWR-CLOSED-LAST-NAME           
                   ELSE                                                 
                      PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT      
                      MOVE PF-FIRST-NAME TO WS-DRWR-CLOSED-FIRST-NAME   
                      MOVE PF-LAST-NAME  TO WS-DRWR-CLOSED-LAST-NAME    
                   END-IF                                               
                   MOVE WS-DRWR-CLOSED-CASHIER-NAME TO RS-DRWR-CLOSED-BY
REARCH             PERFORM 2000A-MOVE-RESULT    THRU 2000A-EXIT         
                   PERFORM 8100-SEND-RESULT     THRU 8100-EXIT          
                   INITIALIZE WS-TOTAL-AMOUNT,WS-CSH-DRWR-STATUS        
                              TDS-RETURN-FIELDS                         
                END-IF                                                  
            END-PERFORM                                                 
           .                                                            
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************   07450086
      * 2400-PROCESS-DATA-LINE.                                         07460086
      ***************************************************************   07470086
       2400-PROCESS-DATA-LINE.                                          
T19902      MOVE WS-NO                       TO WS-GL-ACCT-FLAG         
T19924      MOVE SPACES                      TO GL-ACCOUNT-STATUS       
            MOVE CJ-TRAN-DATA                   TO CJF00101.            
            IF WS-101-ACCT-GEN-LED-DR  = WS-101-ACCT-GEN-LED-CR         
               GO TO 2400-EXIT                                          
            ELSE                                                        
               IF (WS-101-ACCT-GEN-LED-DR  = GO-GL-ACCT-NO)  OR         
                  (WS-101-ACCT-GEN-LED-CR  = GO-GL-ACCT-NO)             
                  SET CLEARING-ACCOUNT          TO TRUE                 
               END-IF                                                   
               MOVE WS-101-ACCT-GEN-LED-DR   TO I5-GL-ACCT-NO           
               PERFORM 7400-CHECK-GL-ACCT-NO     THRU 7400-EXIT         
               IF WS-GL-ACCT-FLAG = WS-YES                              
                  SET LIHEAP-PAYMENT         TO TRUE                    
               ELSE                                                     
                  MOVE WS-101-ACCT-GEN-LED-CR TO I5-GL-ACCT-NO          
                                                                        
                  PERFORM 7400-CHECK-GL-ACCT-NO  THRU  7400-EXIT        
                  IF WS-GL-ACCT-FLAG = WS-YES                           
                     IF WS-101-ACCT-GEN-LED-DR = GO-GL-ACCT-NO          
                        SET CLEARING-ACCOUNT          TO TRUE           
                     ELSE                                               
                        SET LIHEAP-REVERSAL     TO TRUE                 
                     END-IF                                             
                  END-IF                                                
               END-IF                                                   
            END-IF                                                      
            IF (CLEARING-ACCOUNT OR LIHEAP-PAYMENT OR LIHEAP-REVERSAL)  
               MOVE WS-101-AMT-POSTED      TO WS-GEN-LED-AMT            
               IF (WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO OR            
                  LIHEAP-REVERSAL)                                      
                  COMPUTE WS-GEN-LED-AMT = WS-GEN-LED-AMT * -1          
               END-IF                                                   
                                                                        
               ADD WS-GEN-LED-AMT            TO WS-TOTAL-AMOUNT         
            END-IF                                                      
           .                                                            
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19902***************************************************************   07880086
T19902* 2500-SELECT-LOCOFF-STATUS                                   *   07890086
T19902* THIS PARA FETCHES THE LOCAL OFFICE STATUS                   *   07900086
T19902***************************************************************   07910086
T19902 2500-SELECT-LOCOFF-STATUS.                                       
T19902     PERFORM 7600-SELECT-LOCOFF-STATUS THRU 7600-EXIT             
T19902     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T19902        MOVE YR-USER-ID                TO PF-USER-ID              
T19902        IF PF-USER-ID = SPACES                                    
T19902           MOVE SPACES                 TO WS-RPT-CLOSED-FIRST-NAME
T19902           MOVE SPACES                 TO WS-RPT-CLOSED-LAST-NAME 
T19902        ELSE                                                      
T19902           PERFORM 7700-GET-USER-PROFILE THRU 7700-EXIT           
T19902           MOVE PF-FIRST-NAME          TO WS-RPT-CLOSED-FIRST-NAME
T19902           MOVE PF-LAST-NAME           TO WS-RPT-CLOSED-LAST-NAME 
T19902        END-IF                                                    
T19902        MOVE WS-RPT-CLOSED-CASHIER-NAME TO RS-RPT-CLOSED-BY       
T19902        MOVE YR-CLOSED-TS               TO RS-RPT-CLOSED-DATETIME 
T19902     ELSE                                                         
T19902        MOVE  SPACES TO RS-RPT-CLOSED-DATETIME                    
T19902     END-IF                                                       
T19902     .                                                            
T19902 2500-EXIT.                                                       
T19902     EXIT.                                                        
                                                                        
      ***********************************************************       08180072
      * THIS PARA CALCULATE THE COMPANY TOTAL FOR THE DAY.              08190072
      ***********************************************************       08200072
       2600-GET-COMPANY-TOTAL.                                          
            PERFORM UNTIL NO-MORE-COMP-DATA                             
              MOVE CJ-CASH-DRAWER-ID           TO WS-PREV-CASH-DRAWER-ID
              MOVE CJ-TRAN-DATA                   TO CJF00101           
T19902        MOVE WS-NO                       TO WS-GL-ACCT-FLAG       
              IF WS-101-ACCT-GEN-LED-DR = WS-101-ACCT-GEN-LED-CR        
                 CONTINUE                                               
              ELSE                                                      
                 IF (WS-101-ACCT-GEN-LED-DR  = GO-GL-ACCT-NO)  OR       
                    (WS-101-ACCT-GEN-LED-CR  = GO-GL-ACCT-NO)           
                    SET CLEARING-ACCOUNT          TO TRUE               
                 END-IF                                                 
                 MOVE WS-101-ACCT-GEN-LED-DR   TO I5-GL-ACCT-NO         
                 PERFORM 7400-CHECK-GL-ACCT-NO     THRU 7400-EXIT       
                 IF WS-GL-ACCT-FLAG = WS-YES                            
                    SET LIHEAP-PAYMENT         TO TRUE                  
                 ELSE                                                   
                    MOVE WS-101-ACCT-GEN-LED-CR TO I5-GL-ACCT-NO        
                                                                        
                    PERFORM 7400-CHECK-GL-ACCT-NO  THRU  7400-EXIT      
                    IF WS-GL-ACCT-FLAG = WS-YES                         
                       IF WS-101-ACCT-GEN-LED-DR = GO-GL-ACCT-NO        
                          SET CLEARING-ACCOUNT          TO TRUE         
                       ELSE                                             
                          SET LIHEAP-REVERSAL     TO TRUE               
                       END-IF                                           
                    END-IF                                              
                 END-IF                                                 
                                                                        
                 IF (CLEARING-ACCOUNT OR LIHEAP-PAYMENT                 
                                      OR LIHEAP-REVERSAL)               
                    MOVE WS-101-AMT-POSTED      TO WS-GEN-LED-AMT       
                    IF (WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO OR       
                        LIHEAP-REVERSAL)                                
                        COMPUTE WS-GEN-LED-AMT = WS-GEN-LED-AMT * -1    
                    END-IF                                              
                    ADD WS-GEN-LED-AMT            TO WS-COMP-TOTAL-AMT  
                 END-IF                                                 
              END-IF                                                    
              PERFORM 7900-FETCH-COMPANY-TOTAL-CSR THRU 7900-EXIT       
            END-PERFORM                                                 
              PERFORM 7950-CLOSE-COMPANY-TOTAL-CSR THRU 7950-EXIT       
              MOVE WS-COMP-TOTAL-AMT       TO RS-LOCOFF-TOTAL           
REARCH        PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                 
              PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                  
              INITIALIZE WS-COMP-TOTAL-AMT                              
                         TDS-RETURN-FIELDS                              
           .                                                            
       2600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************08610037
      *    THIS PARA IS TO GET THE CASH CLEAR ACCOUNT NUMBER            08620037
      ******************************************************************08630037
       7000-GET-CLR-ACCT-NUMBER.                                        
           EXEC SQL                                                     
                SELECT GL_ACCT_NO                                       
                INTO   :GO-GL-ACCT-NO                                   
                FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                     
                WHERE  COMPANY_NO   = :CJ-CASH-COMPANY-NO               
T36246          AND    GL_ACCT_NAME = 'CLR-CASH'                        
T36246                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     08650037
MFA-TR*         SELECT GL_ACCT_NO                                       08660037
MFA-TR*         INTO   :GO-GL-ACCT-NO                                   08670037
MFA-TR*         FROM   CSS_GL_ACCT_NO                                   08680037
MFA-TR*         WHERE  COMPANY_NO   = :CJ-CASH-COMPANY-NO               08690037
MFA-TR*         AND    GL_ACCT_NAME = 'CLR-CASH'                        08700037
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    08710037

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7000'                      TO ACTIVE-PARAGRAPH      
              MOVE 'SELECT'                    TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_GL_ACCT_NO'            TO TABLE-1               
              MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-1       
              MOVE  GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-2       
              MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-2     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-3       
              MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE_CASH-REPORT'          TO TABLE-ELEMENT-4       
              MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
      *                                                                 08950037
       7000-EXIT.                                                       
           EXIT.                                                        
T19902                                                                  
T19902******************************************************************08980037
T19902*    THIS PARA IS TO OPEN THE CNTL_CURSOR                        *08990037
T19902******************************************************************09000037
T19902 7020-OPEN-CNTL-CURSOR.                                           
T19902                                                                  
T19902     EXEC SQL                                                     
T19902          OPEN CNTL_CURSOR                                        
T19902     END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19902                                                                  
T19902     MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
T19902                                                                  
T19902     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T19902        NEXT SENTENCE                                             
T19902     ELSE                                                         
T19902        MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
T19902        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
T19902        MOVE '7020'                      TO ACTIVE-PARAGRAPH      
T19902        MOVE 'OPEN'                      TO ABEND-FUNCTION        
T19902        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
T19902                                            ABEND-TABLES          
T19902        MOVE 'CSS_CASH_DRWR_CNTL'        TO TABLE-1               
T19902        MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
T19902        MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
T19902        MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
T19902        MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
T19902        MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3       
T19902        MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3     
T19902        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
T19902     END-IF                                                       
T19902     .                                                            
T19902 7020-EXIT.                                                       
T19902     EXIT.                                                        
T19902                                                                  
T19902******************************************************************09330037
T19902*    THIS PARA IS TO FETCH THE CNTL_CURSOR                       *09340037
T19902******************************************************************09350037
T19902 7050-FETCH-CNTL-CURSOR.                                          
T19902      EXEC SQL                                                    
T19902           FETCH CNTL_CURSOR                                      
T19902           INTO  :CS-CASH-DRAWER-ID,                              
T19902                 :CS-USER-ID,                                     
T19902                 :CS-CODE-CSH-DRWR-STAT,                          
T19902                 :CS-BALANCED-TS :WS-NULL-IND1,                    
T19902                 :CS-BALANCED-BY :WS-NULL-IND2                     
T19902      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19902                                                                  
T19902      MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
T19902                                                                  
T19902      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
T19902         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
T19902            IF WS-NULL-IND1 < ZERO                                
T19902               MOVE SPACES TO CS-BALANCED-TS                      
T19902            END-IF                                                
T19902            IF WS-NULL-IND2 < ZERO                                
T19902               MOVE SPACES TO CS-BALANCED-BY                      
T19902            END-IF                                                
T19902         ELSE                                                     
T19902            SET NO-MORE-CNTL-DATA TO TRUE                         
T19902         END-IF                                                   
T19902      ELSE                                                        
T19902         MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
T19902         MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
T19902         MOVE '7050'                      TO ACTIVE-PARAGRAPH     
T19902         MOVE 'FETCH'                     TO ABEND-FUNCTION       
T19902         MOVE SPACES                      TO ABEND-SQL-PREDICATES 
T19902                                             ABEND-TABLES         
T19902         MOVE 'CSS_CASH_DRWR_CNTL'        TO TABLE-1              
T19902         MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
T19902         MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
T19902         MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
T19902         MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
T19902         MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
T19902         MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
T19902         PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
T19902      END-IF                                                      
T19902     .                                                            
T19902 7050-EXIT.                                                       
T19902     EXIT.                                                        
T19902                                                                  
T19902************************************************************      09780037
T19902*    THIS PARA IS TO CLOSE THE CNTL_CURSOR                        09790037
T19902************************************************************      09800037
T19902 7070-CLOSE-CNTL-CURSOR.                                          
T19902      EXEC SQL                                                    
T19902           CLOSE CNTL_CURSOR                                      
T19902      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T19902                                                                  
T19902      MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
T19902                                                                  
T19902     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T19902        NEXT SENTENCE                                             
T19902     ELSE                                                         
T19902        MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
T19902        MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
T19902        MOVE '7070'                      TO ACTIVE-PARAGRAPH      
T19902        MOVE 'CLOSE'                     TO ABEND-FUNCTION        
T19902        MOVE SPACES                      TO ABEND-SQL-PREDICATES  
T19902                                            ABEND-TABLES          
T19902        MOVE 'CSS_CASH_DRWR_CNTL'        TO TABLE-1               
T19902        MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
T19902        MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
T19902        MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
T19902        MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
T19902        MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3       
T19902        MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3     
T19902        PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
T19902     END-IF                                                       
T19902     .                                                            
T19902 7070-EXIT.                                                       
T19902     EXIT.                                                        
                                                                        
      ******************************************************************08980037
T19902**   THIS PARA IS TO OPEN  THE ALL_DRWR_CURSOR                   *08990037
T19902*    THIS PARA IS TO OPEN  JRNL_CURSOR                           *08990037
      ******************************************************************09000037
T19902 7100-OPEN-JRNL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
T19902          OPEN JRNL_CURSOR                                        
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7100'                      TO ACTIVE-PARAGRAPH      
              MOVE 'OPEN'                      TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CJ-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
              MOVE CJ-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
              MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3       
              MOVE CJ-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE-CASH_REPORT'          TO TABLE-ELEMENT-4       
              MOVE CJ-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF                                                       
           .                                                            
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09330037
T19902*    THIS PARA IS TO FETCH THE JRNL_CURSOR                        09340037
      ************************************************************      09350037
T19902 7200-FETCH-JRNL-CURSOR.                                          
            EXEC SQL                                                    
                 FETCH JRNL_CURSOR                                      
                 INTO  :CJ-CASH-COMPANY-NO,                             
                       :CJ-CASH-LOCAL-OFFICE,                           
                       :CJ-DATE-CASH-REPORT,                            
                       :CJ-ENTRY-NO,                                    
                       :CJ-CURRENCY-TYPE,                               
                       :CJ-TRAN-DATA                                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7200'                      TO ACTIVE-PARAGRAPH     
               MOVE 'FETCH'                     TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
               MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
T19902         MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3      
T19902         MOVE CJ-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3    
               MOVE 'DATE-CASH_REPORT'          TO TABLE-ELEMENT-4      
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
            END-IF.                                                     
            IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               SET NO-MORE-JRNL-DATA TO TRUE                            
            END-IF                                                      
           .                                                            
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      09780037
T19902*    THIS PARA IS TO CLOSE THE JRNL_CURSOR                        09790037
      ************************************************************      09800037
T19902 7300-CLOSE-JRNL-CURSOR.                                          
            EXEC SQL                                                    
T19902           CLOSE JRNL_CURSOR                                      
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7300'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CJ-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2       
              MOVE CJ-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
T19902        MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3       
T19902        MOVE CJ-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-4       
              MOVE CJ-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-CHECK-GL-ACCT-NO.                                           
           EXEC SQL                                                     
T36246          SELECT 'Y'                                              
                INTO   :WS-GL-ACCT-FLAG                                 
                FROM   CSS_LIEAP_AGENCY WITH(READUNCOMMITTED)                   
                WHERE  GL_ACCT_NO = :I5-GL-ACCT-NO                      
T36246                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     10120037
MFA-TR*         SELECT 'Y'                                              10130037
MFA-TR*         INTO   :WS-GL-ACCT-FLAG                                 10140037
MFA-TR*         FROM   CSS_LIEAP_AGENCY                                 10150037
MFA-TR*         WHERE  GL_ACCT_NO = :I5-GL-ACCT-NO                      10160037
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    10170037

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF (WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL)  OR             
              (WS-ACTIVE-RETURN-CODE = NOT-FOUND)        OR             
              (WS-ACTIVE-RETURN-CODE = WS-811)                          
              NEXT SENTENCE                                             
           ELSE                                                         
                MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
                MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
                MOVE '7100'                    TO ACTIVE-PARAGRAPH      
                MOVE 'SELECT'                  TO ABEND-FUNCTION        
                MOVE SPACES                    TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
                MOVE 'CSS_LIEAP_AGENCY'        TO TABLE-1               
                MOVE 'GL_ACCT_NO'              TO TABLE-ELEMENT-1       
                MOVE I5-GL-ACCT-NO             TO WS-GL-ACCT-NO-ED      
                MOVE WS-GL-ACCT-NO-ED          TO HOSTVAR-ELEMENT-1     
                MOVE 'CASH_LOCAL_OFFICE'       TO TABLE-ELEMENT-2       
                MOVE CJ-CASH-LOCAL-OFFICE      TO HOSTVAR-ELEMENT-2     
                MOVE 'USER_ID'                 TO TABLE-ELEMENT-3       
T19902          MOVE CS-USER-ID                TO HOSTVAR-ELEMENT-3     
                MOVE 'DATE-CASH_REPORT'        TO TABLE-ELEMENT-4       
                MOVE CJ-DATE-CASH-REPORT       TO HOSTVAR-ELEMENT-4     
                PERFORM 9700-PROCESS-ABEND     THRU 9700-EXIT           
           END-IF.                                                      
           .                                                            
       7400-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************10910087
      *    THIS PARA IS TO GET THE STATUS OF THE REPORTS  *             10920087
      ******************************************************************10930087
       7600-SELECT-LOCOFF-STATUS.                                       
           EXEC SQL                                                     
                SELECT                                                  
                       USER_ID,                                         
                       STATUS,                                          
                       REPLACE(REPLACE(CONVERT(CHAR(26), CLOSED_TS
           , 121), ' ', '-'), ':', '.') CLOSED_TS                              
                INTO   :YR-USER-ID,                                     
                       :YR-STATUS,                                      
                       :YR-CLOSED-TS                                    
                FROM  CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                  
                WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO           
                AND   CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE         
                AND   DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
                AND   STATUS            = 'C'                           
T36246                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     10950037
MFA-TR*         SELECT                                                  10960037
MFA-TR*                USER_ID,                                         10970060
MFA-TR*                STATUS,                                          10980037
MFA-TR*                CLOSED_TS                                        10990037
MFA-TR*         INTO   :YR-USER-ID,                                     11000061
MFA-TR*                :YR-STATUS,                                      11010060
MFA-TR*                :YR-CLOSED-TS                                    11020037
MFA-TR*         FROM  CSS_CSH_REPORT_HDR                                11030037
MFA-TR*         WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO           11040037
MFA-TR*         AND   CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE         11050037
MFA-TR*         AND   DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT          11060037
MFA-TR*         AND   STATUS            = 'C'                           11070037
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    11080037

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7600'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-1       
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-1     
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE 'DATE_CASH-REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11340087
      *    THIS PARA IS TO GET THE USER PROFILE SUCH AS FULL NAME       11350087
      ******************************************************************11360087
       7700-GET-USER-PROFILE.                                           
           EXEC SQL                                                     
                SELECT                                                  
                       FIRST_NAME,                                      
                       LAST_NAME                                        
                INTO   :PF-FIRST-NAME,                                  
                       :PF-LAST-NAME                                    
                FROM  CSS_USER_PROFILE WITH(READUNCOMMITTED)                    
                WHERE USER_ID = :PF-USER-ID                             
T36246                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11380050
MFA-TR*         SELECT                                                  11390050
MFA-TR*                FIRST_NAME,                                      11400050
MFA-TR*                LAST_NAME                                        11410050
MFA-TR*         INTO   :PF-FIRST-NAME,                                  11420051
MFA-TR*                :PF-LAST-NAME                                    11430050
MFA-TR*         FROM  CSS_USER_PROFILE                                  11440050
MFA-TR*         WHERE USER_ID = :PF-USER-ID                             11450051
MFA-TR*         WITH UR                                                         
MFA-TR*    END-EXEC.                                                    11460050

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7700'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_USER_PROFILE'         TO TABLE-1               
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-1       
               MOVE PF-USER-ID                 TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
           .                                                            
       7700-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************11660072
      *    THIS PARA IS TO OPEN  THE COMPANY_TOT_CURSOR                *11670072
      ******************************************************************11680072
       7800-OPEN-COMPANY-TOTAL-CSR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN COMPANY_TOT_CURSOR                                 
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7800'                      TO ACTIVE-PARAGRAPH      
              MOVE 'OPEN'                      TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CJ-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'USER_ID'                   TO TABLE-ELEMENT-3       
              MOVE CJ-USER-ID                  TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE-CASH_REPORT'          TO TABLE-ELEMENT-4       
              MOVE CJ-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF                                                       
           .                                                            
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      11990072
      *    THIS PARA IS TO FETCH THE COMPANY_TOT_CURSOR                 12000072
      ************************************************************      12010072
       7900-FETCH-COMPANY-TOTAL-CSR.                                    
            EXEC SQL                                                    
                 FETCH COMPANY_TOT_CURSOR                               
                 INTO  :CJ-CASH-COMPANY-NO,                             
                       :CJ-CASH-LOCAL-OFFICE,                           
                       :CJ-DATE-CASH-REPORT,                            
                       :CJ-CASH-DRAWER-ID,                              
                       :CJ-ENTRY-NO,                                    
                       :CJ-USER-ID,                                     
                       :CJ-CURRENCY-TYPE,                               
                       :CJ-TRAN-DATA                                    
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
            ELSE                                                        
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE '7900'                      TO ACTIVE-PARAGRAPH     
               MOVE 'FETCH'                     TO ABEND-FUNCTION       
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
                                                   ABEND-TABLES         
               MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE 'USER_ID'                   TO TABLE-ELEMENT-3      
               MOVE CJ-USER-ID                  TO HOSTVAR-ELEMENT-3    
               MOVE 'DATE-CASH_REPORT'          TO TABLE-ELEMENT-4      
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4    
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
            END-IF.                                                     
            IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               SET NO-MORE-COMP-DATA TO TRUE                            
            END-IF                                                      
           .                                                            
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ************************************************************      12420072
      *    THIS PARA IS TO CLOSE THE COMPANY_TOT_CURSOR.         *      12430072
      ************************************************************      12440072
       7950-CLOSE-COMPANY-TOTAL-CSR.                                    
            EXEC SQL                                                    
                 CLOSE COMPANY_TOT_CURSOR                               
            END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
            MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE        
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE '7950'                      TO ACTIVE-PARAGRAPH      
              MOVE 'CLOSE'                     TO ABEND-FUNCTION        
              MOVE SPACES                      TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
              MOVE 'CSS_CASH_DRWR_JRNL'        TO TABLE-1               
              MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1       
              MOVE CJ-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'USER_ID'                   TO TABLE-ELEMENT-3       
              MOVE CJ-USER-ID                  TO HOSTVAR-ELEMENT-3     
              MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-4       
              MOVE CJ-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4     
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT           
           END-IF.                                                      
       7950-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************02530000
REARCH*8000A-DELETE-GTT-ROWS                                           *02540000
REARCH******************************************************************02610000
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DELETE FROM #CSR02397_R1                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR02397_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02397_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************02530000
REARCH* 8100-SEND-RESULT                                               *02540000
REARCH******************************************************************02610000
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02397_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,USER_ID                                            
REARCH              ,BATCH_NO                                           
REARCH              ,BATCH_STATUS                                       
REARCH              ,BATCH_TOTAL                                        
REARCH              ,RPT_CLOSED_DTETIME                                 
REARCH              ,DRWR_CLOSED_DTETME                                 
REARCH              ,DRWR_CLOSED_BY                                     
REARCH              ,RPT_CLOSED_BY                                      
REARCH              ,LOCOFF_TOTAL                                       
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-USER-ID                                         
REARCH              ,:S-BATCH-NO                                        
REARCH              ,:S-BATCH-STATUS                                    
REARCH              ,:S-BATCH-TOTAL                                     
REARCH              ,:S-RPT-CLOSED-DATETIME                             
REARCH              ,:S-DRWR-CLOSED-DATETIME                            
REARCH              ,:S-DRWR-CLOSED-BY                                  
REARCH              ,:S-RPT-CLOSED-BY                                   
REARCH              ,:S-LOCOFF-TOTAL                                    
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02397_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,USER_ID                                                    
MFA-TR*             ,BATCH_NO                                                   
MFA-TR*             ,BATCH_STATUS                                               
MFA-TR*             ,BATCH_TOTAL                                                
MFA-TR*             ,RPT_CLOSED_DTETIME                                         
MFA-TR*             ,DRWR_CLOSED_DTETME                                         
MFA-TR*             ,DRWR_CLOSED_BY                                             
MFA-TR*             ,RPT_CLOSED_BY                                              
MFA-TR*             ,LOCOFF_TOTAL                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-USER-ID                                                 
MFA-TR*             ,:S-BATCH-NO                                                
MFA-TR*             ,:S-BATCH-STATUS                                            
MFA-TR*             ,:S-BATCH-TOTAL                                             
MFA-TR*             ,:S-RPT-CLOSED-DATETIME                                     
MFA-TR*             ,:S-DRWR-CLOSED-DATETIME                                    
MFA-TR*             ,:S-DRWR-CLOSED-BY                                          
MFA-TR*             ,:S-RPT-CLOSED-BY                                           
MFA-TR*             ,:S-LOCOFF-TOTAL                                            
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        ADD +1                    TO CTR-ROWS                     
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH        MOVE 'CSR02397_R1'        TO TABLE-1                      
REARCH        MOVE SPACES               TO TABLE-ELEMENT-1              
REARCH        MOVE SPACES               TO HOSTVAR-ELEMENT-1            
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
      *                                                                 12730050
      ******************************************************************12740037
      * 9700 -  ABEND HANDLING ROUTINE                                 *12750037
      ******************************************************************12760037
           EXEC SQL                                                     12770037
              INCLUDE CPD0023C                                          12780037
           END-EXEC.                                                    12790037
      ************************************************************      12800037
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                      12810037
      ************************************************************      12820037
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ************************************************************      12870037
      * 8100-SEND-RESULT                                                12880037
      ************************************************************      12890037
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                    12700000
      *************************END OF RPC*******************************12910037
