       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02392.                                         
COB303 DATE-WRITTEN.  SEPTEMBER 14, 1999.                               
       DATE-COMPILED.                                                   
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *          SOUTH CAROLINA ELECTRIC & GAS                         *        
      *                                                                *        
      * THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).    *        
      *                                                                *        
      *  TRANID:        S392                                           *        
      *  PROGRAM:       S392                                           *        
      *  CALLING SP:    PA_S392                                        *        
      *                                                                *        
      ******************************************************************        
      *                       P R O G R A M  S U M M A R Y             *        
      *                                                                *        
      *  THIS RPC WILL EITHER INSERT A BANK DEPOSIT TRANSFER OR        *        
      *  BANK DEPOSIT TRANSFER FOR A SPEIFIED DATE.  THE PARAMETER     *        
      *  ACTION-CODE WILL BE USED TO DETERMINE WHICH ACTION TO TAKE.   *        
      *  IF THE ACTION-CODE = 'R' THEN RETRIEVE ALL BANK DEPOSIT       *        
      *  TRANSFER THAT MATCH THE CRITERIA.  IF THE ACTION-CODE = 'I'   *        
      *  THEN INSERT THE BANK DEPOSIT TRANSFER INFORMATION INTO THE    *        
      *  CSS_BANK_TRANSFER TABLE.  A WASH JOURNAL WILL BE WRITTEN EACH *        
      *  TIME A BANK DEPOSIT TRANSFER IS EXECUTED.                     *        
      *                                                                *        
      *  PARAMETERS:                                                   *        
      *    ACTION-CODE                                                 *        
      *    CASH-COMPANY-NO                                             *        
      *    CASH-LOCAL-OFFICE                                           *        
      *    DATE-CASH-REPORT                                            *        
      *    CASH-DRAWER-ID                                              *        
      *    BANK-ID                                                     *        
      *    CURRENCY-TYPE1                                              *        
      *    CODE-DR-CR1                                                 *        
      *    TRANSFER-AMT1                                               *        
      *    CURRENCY-TYPE2                                              *        
      *    CODE-DR-CR2                                                 *        
      *    TRANSFER-AMT2                                               *        
      *    USER-ID                                                     *        
      *                                                                *        
      *  RETURNS:                                                      *        
      *    RETURN-CODE  (SUCCESS INDICATOR)                            *        
      *    USER-ID                                                     *        
      *    CASH-COMPANY-NO                                             *        
      *    CASH-LOCAL-OFFICE                                           *        
      *    DATE-CASH-REPORT                                            *        
      *    TRANSFER-TS                                                 *        
      *    BANK-ID                                                     *        
      *    CURRENCY-TYPE                                               *        
      *    TRANSFER-AMT                                                *        
      *    CASH-DRAWER-ID                                              *        
      *    CODE-CSH-DRWR-STAT                                          *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *  DATE      INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------- *        
      *  09/14/99  JH82212    NEW CODE                                 *        
T19922*  12/01/99  CBSI       AR-LOCKOUT CHECK INCLUDED.               *        
T23284*  03/23/00  SK87428    RETURNS ONE ROW PER TRANSFER INSTEAD OF  *        
      *                       TWO (ONE FOR CASH AND ONE FOR CHECK).             
      *  05/20/01  CHANELLE   TPR 23748. MCR310 PSNC. USE COMPANY '01' *        
      *                       FOR ALL GL REFERENCES.                   *        
T22767*  07/27/01  JS83520    FOR A MANUAL TRANSFER MOVE CASH_GL_OFFSET*        
      *                       FROM CSS_CASHIER_OFFICE                  *        
T22767*  09/11/01  VB81095    CHANGES TO DISPLAY NEGATIVE BANK TRANSFER*        
C25923*  02/27/02  BASKAR     ADD DRAFT IN THE CURRENCY TYPE           *        
C25923*  05/01/02  BASKAR     UPDATE BANK POST DT IN BANK TRANSFER TBL *        
C25923*  05/01/02  BASKAR     UPDATE WITH SINGLE TIMESTAMP WHILE       *        
C25923*                       MULTI CURRENCY BANK TRANSFER             *        
REARCH*  07/04/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
T35434*  10/31/07  MK92804    REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *        
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGLETON *        
T35434*                       SELECTS.                                 *        
A00956*  03/26/09  CVNS       REPLACE CPD00006 WITH CPD0006A.          *        
D11762*  10/18/16  LG41184    CHANGES TO NOT CONTINUE WITH BANK        *        
D11762*                       TRANSFER WHEN THERE IS NO OPEN BATCH.    *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      ******************************************************************        
                                                                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02392'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
REARCH     'WORKING STORAGE FOR CSR02392 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * PF - CSS_USER_PROFILE                                                   
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
      * BC - CSS_BCH_JRNL_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
      * BJ - CSS_BATCH_JRNL                                                     
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * MJ - CSS_MISC_JRNL                                                      
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * GO - CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      * I5 - CSS_LIEAP_AGENCY                                                   
           EXEC SQL                                                             
              INCLUDE TBLIAGCY                                                  
           END-EXEC.                                                            
                                                                        
      * CS - CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      * Y2 - CSS_CASHIER_OFFICE                                                 
           EXEC SQL                                                             
              INCLUDE TBCSHOFF                                                  
           END-EXEC.                                                            
                                                                        
      * CJ - CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * YB - CSS_BANK_TRANSFER                                                  
           EXEC SQL                                                             
              INCLUDE TBBNKXFR                                                  
           END-EXEC.                                                            
                                                                        
      * J8 - CSS_HOLIDAY                                                        
           EXEC SQL                                                             
               INCLUDE TBHLDAY                                                  
           END-EXEC.                                                            
                                                                        
T19922* AL - CSS_AR_LOCKOUT                                                     
T19922     EXEC SQL                                                             
T19922        INCLUDE TBARLOCK                                                  
T19922     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * COBOL WORKING STORAGE COPY BOOKS                               *        
      ******************************************************************        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           COPY CJF00101.                                                       
                                                                        
           EXEC SQL                                                             
A00956        INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORKING STORAGE FOR COPYBOOK CPD0315B                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CWS00315                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * WORK AREA                                                      *        
      ******************************************************************        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME              PIC X(08) VALUE 'CSR02392'.    
REARCH     05  EIBTRNID                  PIC X(04) VALUE 'S392'.        
REARCH     05  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                  POINTER.                               
REARCH*    05  GWL-INIT-HANDLE           POINTER.                               
REARCH*    05  GWL-RC                    PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-NR             PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-DONE           PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-COUNT          PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-COMM           PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-RETURN-CODE    PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-SUBCODE        PIC S9(09) COMP.                       
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02392_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
REARCH*01  PARM-FIELDS.                                                         
REARCH*    05  PARM-L                    PIC S9(09) COMP.                       
REARCH*    05  PARM-ID1                  PIC S9(09) COMP VALUE 1.               
REARCH*    05  PARM-ACTION-CODE          PIC X(01) VALUE SPACES.                
REARCH*    05  PARM-CASH-COMPANY-NO      PIC X(02) VALUE SPACES.                
REARCH*    05  PARM-CASH-LOCAL-OFFICE    PIC X(03) VALUE SPACES.                
REARCH*    05  PARM-DATE-CASH-REPORT     PIC X(10) VALUE SPACES.                
REARCH*    05  PARM-CASH-DRAWER-ID       PIC S9(09) COMP VALUE ZEROES.          
REARCH*    05  PARM-BANK-ID              PIC S9(09) COMP VALUE ZEROES.          
REARCH*    05  PARM-CURRENCY-TYPE1       PIC X(01) VALUE SPACES.                
REARCH*    05  PARM-CODE-DR-CR1          PIC X(01) VALUE SPACES.                
REARCH*    05  PARM-TRANSFER-AMT1        PIC X(11) VALUE SPACES.                
REARCH*    05  PARM-CURRENCY-TYPE2       PIC X(01) VALUE SPACES.                
REARCH*    05  PARM-CODE-DR-CR2          PIC X(01) VALUE SPACES.                
REARCH*    05  PARM-TRANSFER-AMT2        PIC X(11) VALUE SPACES.                
REARCH*    05  PARM-USER-ID              PIC X(07) VALUE SPACES.                
REARCH*    05  PARM-PC-ID                PIC X(04) VALUE SPACES.                
REARCH*    05  PARM-FCS-DEP-BANK-CD      PIC X(05) VALUE SPACES.                
REARCH*    05  PARM-FCS-DEP-BANK-ST-CD   PIC X(02) VALUE SPACES.                
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(09) COMP.               
           05  SNA-CONNECTION-NAME       PIC X(08)  VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(09) COMP VALUE 1.       
           05  CTR-ROWS                  PIC S9(09) COMP VALUE 0.       
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(09) COMP.               
           05  WRKLEN1                   PIC S9(09) COMP.               
           05  WRKLEN2                   PIC S9(09) COMP.               
           05  WRK-DONE-STATUS           PIC S9(09) COMP.               
           05  WS-TRANSFER-AMT           PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-TRANSFER-AMT-HOLD      PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-TOTAL-TRANSFER         PIC S9(11)V99 COMP-3 VALUE +0. 
T19922     05  WS-YES                    PIC X(01) VALUE 'Y'.           
T22767     05  WS-C                      PIC X(01) VALUE 'C'.           
D11762     05  WS-A                      PIC X(01) VALUE 'A'.           
           05  WS-ACTION-CODE            PIC X(01) VALUE 'R'.           
               88 PERFORM-RETRIEVE                 VALUE 'R'.           
               88 PERFORM-INSERT                   VALUE 'I'.           
           05  WS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
           05  WS-TRANSFER-TIME          PIC X(08) VALUE SPACES.        
C25923     05  WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.        
           05  WS-PREV-ENTRY-NO          PIC S9(9) USAGE COMP.          
           05  WS-CURRENCY-TYPE          PIC X(01).                     
               88 CASH                             VALUE 'A'.           
               88 CHECK                            VALUE 'C'.           
               88 MONEY-ORDER                      VALUE 'M'.           
               88 DRAFT                            VALUE 'D'.           
                                                                        
       01  FILLER                        PIC X(32) VALUE                
           'THIS IS THE ROW RETURN AREA.'.                              
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
           05  RS-USER-ID                PIC X(07) VALUE SPACES.        
           05  RS-CASH-COMPANY-NO        PIC X(02) VALUE SPACES.        
           05  RS-CASH-LOCAL-OFFICE      PIC X(03) VALUE SPACES.        
           05  RS-DATE-CASH-REPORT       PIC X(10) VALUE SPACES.        
           05  RS-TRANSFER-TS            PIC X(20) VALUE SPACES.        
           05  RS-BANK-ID                PIC S9(09) COMP VALUE 0.       
T23284     05  RS-CASH-AMT               PIC S9(09)V99 COMP-3 VALUE +0. 
T23284     05  RS-CHECK-MO-AMT           PIC S9(09)V99 COMP-3 VALUE +0. 
           05  RS-CASH-DRAWER-ID         PIC S9(09) COMP VALUE 0.       
           05  RS-CODE-CSH-DRWR-STAT     PIC X(01) VALUE SPACES.        
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05 S-RETURN-CODE              PIC S9(09) COMP VALUE 0.       
REARCH     05 S-USER-ID                  PIC X(07) VALUE SPACES.        
REARCH     05 S-CASH-COMPANY-NO          PIC X(02) VALUE SPACES.        
REARCH     05 S-CASH-LOCAL-OFFICE        PIC X(03) VALUE SPACES.        
REARCH     05 S-DATE-CASH-REPORT         PIC X(10) VALUE SPACES.        
REARCH     05 S-TRANSFER-TS              PIC X(20) VALUE SPACES.        
REARCH     05 S-BANK-ID                  PIC S9(09) COMP VALUE 0.       
REARCH     05 S-CASH-AMT                 PIC S9(09)V99 COMP-3 VALUE +0. 
REARCH     05 S-CHECK-MO-AMT             PIC S9(09)V99 COMP-3 VALUE +0. 
REARCH     05 S-CASH-DRAWER-ID           PIC S9(09) COMP VALUE 0.       
REARCH     05 S-CODE-CSH-DRWR-STAT       PIC X(01) VALUE SPACES.        
REARCH*01  CN-COLUMN-NAMES.                                                     
REARCH*    05  CN-RETURN-CODE            PIC X(11) VALUE 'RETURN_CODE'.         
REARCH*    05  CN-USER-ID                PIC X(07) VALUE 'USER_ID'.             
REARCH*    05  CN-CASH-COMPANY-NO        PIC X(15) VALUE                        
REARCH*        'CASH_COMPANY_NO'.                                               
REARCH*    05  CN-CASH-LOCAL-OFFICE      PIC X(17) VALUE                        
REARCH*        'CASH_LOCAL_OFFICE'.                                             
REARCH*    05  CN-DATE-CASH-REPORT       PIC X(16) VALUE                        
REARCH*        'DATE_CASH_REPORT'.                                              
REARCH*    05  CN-TRANSFER-TS            PIC X(11) VALUE 'TRANSFER_TS'.         
REARCH*    05  CN-BANK-ID                PIC X(07) VALUE 'BANK_ID'.             
T23284*    05  CN-CASH-AMT               PIC X(11) VALUE 'CASH_AMT'.            
T23284*    05  CN-CHECK-MO-AMT           PIC X(15) VALUE 'CHECK_MO_AMT'.        
REARCH*    05  CN-CASH-DRAWER-ID         PIC X(14) VALUE                        
REARCH*        'CASH_DRAWER_ID'.                                                
REARCH*    05  CN-CODE-CSH-DRWR-STAT     PIC X(18) VALUE                        
REARCH*        'CODE_CSH_DRWR_STAT'.                                            
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
                                                                        
      ******************************************************************        
      * CURSOR DECLARATIONS                                            *        
      ******************************************************************        
      *                                                                         
                                                                        
           EXEC SQL                                                     
              DECLARE RETRIEVE-CURSOR CURSOR FOR                        
              SELECT 0,                                                 
                     YB.USER_ID,                                        
                     YB.CASH_COMPANY_NO,                                
                     YB.CASH_LOCAL_OFFICE,                              
                     YB.DATE_CASH_REPORT,                               
                     REPLACE(REPLACE(CONVERT(CHAR(26), YB.TRANSFER_TS
           , 121), ' ', '-'), ':', '.') TRANSFER_TS,                           
                     YB.BANK_ID,                                        
                     YB.CURRENCY_TYPE,                                  
                     YB.TRANSFER_AMT,                                   
T22767               YB.CODE_DR_CR,                                     
                     YB.CASH_DRAWER_ID,                                 
                     CS.CODE_CSH_DRWR_STAT                              
              FROM   CSS_BANK_TRANSFER YB WITH(READUNCOMMITTED),                
                     CSS_CSH_DRWR_CNTL CS WITH(READUNCOMMITTED)                 
              WHERE  YB.CASH_COMPANY_NO = :YB-CASH-COMPANY-NO           
              AND    YB.CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE       
              AND    YB.DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )         
              AND    YB.CASH_COMPANY_NO = CS.CASH_COMPANY_NO            
              AND    YB.CASH_LOCAL_OFFICE = CS.CASH_LOCAL_OFFICE        
              AND    YB.DATE_CASH_REPORT = CS.DATE_CASH_REPORT          
              AND    YB.CASH_DRAWER_ID = CS.CASH_DRAWER_ID              
              AND    CS.USER_ID = :CS-USER-ID                           
              UNION                                                     
              SELECT 99,                                                
                     CS.USER_ID,                                        
                     CS.CASH_COMPANY_NO,                                
                     CS.CASH_LOCAL_OFFICE,                              
                     CS.DATE_CASH_REPORT,                               
                     REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     0,                                                 
                     ' ',                                               
                     0,                                                 
T22767               ' ',                                               
                     CS.CASH_DRAWER_ID,                                 
                     CS.CODE_CSH_DRWR_STAT                              
              FROM   CSS_CSH_DRWR_CNTL CS WITH(READUNCOMMITTED)                 
              WHERE  CS.DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )         
              AND    CS.USER_ID = :CS-USER-ID                           
              AND    CS.CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE       
              ORDER BY 1, 10 DESC                                       
T35434        FOR READ ONLY                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE RETRIEVE-CURSOR CURSOR FOR                                
MFA-TR*       SELECT 0,                                                         
MFA-TR*              YB.USER_ID,                                                
MFA-TR*              YB.CASH_COMPANY_NO,                                        
MFA-TR*              YB.CASH_LOCAL_OFFICE,                                      
MFA-TR*              YB.DATE_CASH_REPORT,                                       
MFA-TR*              YB.TRANSFER_TS,                                            
MFA-TR*              YB.BANK_ID,                                                
MFA-TR*              YB.CURRENCY_TYPE,                                          
MFA-TR*              YB.TRANSFER_AMT,                                           
MFA-TR*              YB.CODE_DR_CR,                                             
MFA-TR*              YB.CASH_DRAWER_ID,                                         
MFA-TR*              CS.CODE_CSH_DRWR_STAT                                      
MFA-TR*       FROM   CSS_BANK_TRANSFER YB,                                      
MFA-TR*              CSS_CSH_DRWR_CNTL CS                                       
MFA-TR*       WHERE  YB.CASH_COMPANY_NO = :YB-CASH-COMPANY-NO                   
MFA-TR*       AND    YB.CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE               
MFA-TR*       AND    YB.DATE_CASH_REPORT = :YB-DATE-CASH-REPORT                 
MFA-TR*       AND    YB.CASH_COMPANY_NO = CS.CASH_COMPANY_NO                    
MFA-TR*       AND    YB.CASH_LOCAL_OFFICE = CS.CASH_LOCAL_OFFICE                
MFA-TR*       AND    YB.DATE_CASH_REPORT = CS.DATE_CASH_REPORT                  
MFA-TR*       AND    YB.CASH_DRAWER_ID = CS.CASH_DRAWER_ID                      
MFA-TR*       AND    CS.USER_ID = :CS-USER-ID                                   
MFA-TR*       UNION                                                             
MFA-TR*       SELECT 99,                                                        
MFA-TR*              CS.USER_ID,                                                
MFA-TR*              CS.CASH_COMPANY_NO,                                        
MFA-TR*              CS.CASH_LOCAL_OFFICE,                                      
MFA-TR*              CS.DATE_CASH_REPORT,                                       
MFA-TR*              CURRENT TIMESTAMP,                                         
MFA-TR*              0,                                                         
MFA-TR*              ' ',                                                       
MFA-TR*              0,                                                         
MFA-TR*              ' ',                                                       
MFA-TR*              CS.CASH_DRAWER_ID,                                         
MFA-TR*              CS.CODE_CSH_DRWR_STAT                                      
MFA-TR*       FROM   CSS_CSH_DRWR_CNTL CS                                       
MFA-TR*       WHERE  CS.DATE_CASH_REPORT = :CS-DATE-CASH-REPORT                 
MFA-TR*       AND    CS.USER_ID = :CS-USER-ID                                   
MFA-TR*       AND    CS.CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE               
MFA-TR*       ORDER BY 1, 10 DESC                                               
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACTION-CODE          PIC X(01).                         
REARCH 01  PARM-CASH-COMPANY-NO      PIC X(02).                         
REARCH 01  PARM-CASH-LOCAL-OFFICE    PIC X(03).                         
REARCH 01  PARM-DATE-CASH-REPORT     PIC X(10).                         
REARCH 01  PARM-CASH-DRAWER-ID       PIC S9(09) COMP.                   
REARCH 01  PARM-BANK-ID              PIC S9(09) COMP.                   
REARCH 01  PARM-CURRENCY-TYPE1       PIC X(01).                         
REARCH 01  PARM-CODE-DR-CR1          PIC X(01).                         
REARCH 01  PARM-TRANSFER-AMT1        PIC X(11).                         
REARCH 01  PARM-CURRENCY-TYPE2       PIC X(01).                         
REARCH 01  PARM-CODE-DR-CR2          PIC X(01).                         
REARCH 01  PARM-TRANSFER-AMT2        PIC X(11).                         
REARCH 01  PARM-USER-ID              PIC X(07).                         
REARCH 01  PARM-PC-ID                PIC X(04).                         
REARCH 01  PARM-FCS-DEP-BANK-CD      PIC X(05).                         
REARCH 01  PARM-FCS-DEP-BANK-ST-CD   PIC X(02).                         
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACTION-CODE                        
REARCH                          PARM-CASH-COMPANY-NO                    
REARCH                          PARM-CASH-LOCAL-OFFICE                  
REARCH                          PARM-DATE-CASH-REPORT                   
REARCH                          PARM-CASH-DRAWER-ID                     
REARCH                          PARM-BANK-ID                            
REARCH                          PARM-CURRENCY-TYPE1                     
REARCH                          PARM-CODE-DR-CR1                        
REARCH                          PARM-TRANSFER-AMT1                      
REARCH                          PARM-CURRENCY-TYPE2                     
REARCH                          PARM-CODE-DR-CR2                        
REARCH                          PARM-TRANSFER-AMT2                      
REARCH                          PARM-USER-ID                            
REARCH                          PARM-PC-ID                              
REARCH                          PARM-FCS-DEP-BANK-CD                    
REARCH                          PARM-FCS-DEP-BANK-ST-CD.                
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                       THRU 0100-EXIT.
           PERFORM 1000-PROCESS-INPUT                    THRU 1000-EXIT.
           PERFORM 2000-PROCESS-OUTPUT                   THRU 2000-EXIT.
           PERFORM 9999-END-PROGRAM                      THRU 9999-EXIT.
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      * 1. RESET DB2 ERROR HANDLERS                                    *        
      * 2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                      *        
      * 3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)       *        
      * 4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)    *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH        DECLARE C1 CURSOR  FOR                         
REARCH        SELECT                                                    
REARCH            *                                                     
REARCH        FROM                                                      
REARCH            #CSR02392_R1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*           *                                                             
MFA-TR*       FROM                                                              
MFA-TR*           SESSION.CSR02392_R1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT.                                              *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02392_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02392_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02392_R1
              (                                                       
REARCH               RETURN_CODE               INT                  
REARCH              ,USER_ID CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH              ,CASH_COMPANY_NO CHAR(02)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,CASH_LOCAL_OFFICE CHAR(03)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,DATE_CASH_REPORT CHAR(10)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,TRANSFER_TS CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH              ,BANK_ID                   INT                  
REARCH              ,CASH_AMT                  DECIMAL(11,2)            
REARCH              ,CHECK_MO_AMT              DECIMAL(11,2)            
REARCH              ,CASH_DRAWER_ID            INT                  
REARCH              ,CODE_CSH_DRWR_STAT CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                 
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE               TO WS-SQLSTATE.                  
REARCH     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS                             
REARCH                                   THRU 8000A-EXIT                
REARCH     ELSE                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH           NEXT SENTENCE                                          
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02392_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
      ******************************************************************        
      * 1000-PROCESS-IPUT                                              *        
      *                                                                *        
      * 1. RECEIVE PARMS.                                              *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE PARM-ACTION-CODE              TO WS-ACTION-CODE.        
           MOVE PARM-CASH-COMPANY-NO          TO YB-CASH-COMPANY-NO     
                                                 CS-CASH-COMPANY-NO.    
           MOVE PARM-CASH-LOCAL-OFFICE        TO YB-CASH-LOCAL-OFFICE   
                                                 CS-CASH-LOCAL-OFFICE.  
           MOVE PARM-DATE-CASH-REPORT         TO YB-DATE-CASH-REPORT    
                                                 CS-DATE-CASH-REPORT.   
           MOVE PARM-CASH-DRAWER-ID           TO YB-CASH-DRAWER-ID,     
D11762                                           CS-CASH-DRAWER-ID.     
           MOVE PARM-USER-ID                  TO CS-USER-ID             
                                                 YB-USER-ID.            
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
T19922     IF  PERFORM-INSERT                                           
T19922         PERFORM 7999-SELECT-AL                    THRU           
T19922                                               7999-SELECT-AL-EXIT
T19922         IF  AL-AR-LOCKOUT-IND = WS-YES                           
T19922             MOVE 5000 TO RS-RETURN-CODE                          
REARCH             PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT
T19922             PERFORM 8100-SEND-RESULT              THRU 8100-EXIT 
T19922             PERFORM 9999-END-PROGRAM              THRU 9999-EXIT 
T19922         END-IF                                                   
T23284     END-IF.                                                      
           PERFORM 2200-BUILD-RESULT                 THRU 2200-EXIT.    
                                                                        
T23284 2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE.              
REARCH     MOVE RS-USER-ID               TO S-USER-ID.                  
REARCH     MOVE RS-CASH-COMPANY-NO       TO S-CASH-COMPANY-NO.          
REARCH     MOVE RS-CASH-LOCAL-OFFICE     TO S-CASH-LOCAL-OFFICE.        
REARCH     MOVE RS-DATE-CASH-REPORT      TO S-DATE-CASH-REPORT.         
REARCH     MOVE RS-TRANSFER-TS           TO S-TRANSFER-TS.              
REARCH     MOVE RS-BANK-ID               TO S-BANK-ID.                  
REARCH     MOVE RS-CASH-AMT              TO S-CASH-AMT.                 
REARCH     MOVE RS-CHECK-MO-AMT          TO S-CHECK-MO-AMT.             
REARCH     MOVE RS-CASH-DRAWER-ID        TO S-CASH-DRAWER-ID.           
REARCH     MOVE RS-CODE-CSH-DRWR-STAT    TO S-CODE-CSH-DRWR-STAT.       
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
T23284******************************************************************        
T23284* 2200-BUILD-RESULT                                              *        
T23284*******************************************************************       
T23284                                                                  
T23284 2200-BUILD-RESULT.                                               
                                                                        
           IF PERFORM-RETRIEVE THEN                                     
               PERFORM 7100-OPEN-RETRIEVE-CURSOR         THRU 7100-EXIT 
               PERFORM 7150-FETCH-RETRIEVE-CURSOR        THRU 7150-EXIT 
                                                                        
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND      
                   IF WS-RETURN-CODE NOT EQUAL ZERO THEN                
                       MOVE WS-RETURN-CODE    TO RS-RETURN-CODE         
                   END-IF                                               
                                                                        
                   MOVE YB-USER-ID            TO RS-USER-ID             
                   MOVE YB-TRANSFER-TS        TO RS-TRANSFER-TS         
                   MOVE YB-BANK-ID            TO RS-BANK-ID             
                   MOVE CS-CODE-CSH-DRWR-STAT TO RS-CODE-CSH-DRWR-STAT  
                   MOVE YB-CURRENCY-TYPE      TO WS-CURRENCY-TYPE       
C25923*            IF CHECK OR MONEY-ORDER                                      
C25923             IF CHECK OR MONEY-ORDER OR DRAFT                     
                       MOVE 0                   TO RS-CASH-AMT          
                       MOVE YB-TRANSFER-AMT     TO RS-CHECK-MO-AMT      
T22767                 IF YB-CODE-DR-CR = WS-C                          
T22767                    COMPUTE RS-CHECK-MO-AMT =                     
T22767                            RS-CHECK-MO-AMT * -1                  
T22767                 END-IF                                           
                   ELSE                                                 
                       IF CASH                                          
                           MOVE 0               TO RS-CHECK-MO-AMT      
                           MOVE YB-TRANSFER-AMT TO RS-CASH-AMT          
T22767                     IF YB-CODE-DR-CR = WS-C                      
T22767                        COMPUTE RS-CASH-AMT =                     
T22767                                RS-CASH-AMT * -1                  
T22767                     END-IF                                       
                       END-IF                                           
                   END-IF                                               
                                                                        
REARCH             PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT
                   PERFORM 8100-SEND-RESULT              THRU 8100-EXIT 
                                                                        
                   PERFORM 7150-FETCH-RETRIEVE-CURSOR    THRU 7150-EXIT 
               END-PERFORM                                              
                                                                        
               PERFORM 7175-CLOSE-RETRIEVE-CURSOR        THRU 7175-EXIT 
           ELSE                                                         
              IF PERFORM-INSERT THEN                                    
D11762            PERFORM 7600-GET-OPEN-DRWR             THRU 7600-EXIT 
                  MOVE PARM-BANK-ID                 TO YB-BANK-ID       
                  MOVE PARM-CURRENCY-TYPE1          TO YB-CURRENCY-TYPE 
                  MOVE PARM-CODE-DR-CR1             TO YB-CODE-DR-CR    
                                                                        
                  MOVE PARM-TRANSFER-AMT1           TO WS-TRANSFER-AMT  
                  DIVIDE 100 INTO WS-TRANSFER-AMT GIVING                
                  WS-TRANSFER-AMT ROUNDED                               
                  MOVE WS-TRANSFER-AMT              TO YB-TRANSFER-AMT  
                                                  WS-TRANSFER-AMT-HOLD  
                  ADD WS-TRANSFER-AMT               TO WS-TOTAL-TRANSFER
C25923            PERFORM 2300-GET-POST-DATE        THRU 2300-EXIT      
C25923            PERFORM 7250-GET-TIMESTAMP        THRU 7250-EXIT      
                  PERFORM 7200-INSERT-TRNSFR        THRU 7200-EXIT      
                                                                        
                  IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND    
                  PARM-CURRENCY-TYPE2 NOT EQUAL SPACES THEN             
                      MOVE PARM-CURRENCY-TYPE2      TO YB-CURRENCY-TYPE 
                      MOVE PARM-CODE-DR-CR2         TO YB-CODE-DR-CR    
                                                                        
                      MOVE PARM-TRANSFER-AMT2       TO WS-TRANSFER-AMT  
                      DIVIDE 100 INTO WS-TRANSFER-AMT GIVING            
                      WS-TRANSFER-AMT ROUNDED                           
                      MOVE WS-TRANSFER-AMT          TO YB-TRANSFER-AMT  
                      ADD WS-TRANSFER-AMT           TO WS-TOTAL-TRANSFER
                                                                        
                      PERFORM 7200-INSERT-TRNSFR    THRU 7200-EXIT      
                  END-IF                                                
                                                                        
                  PERFORM 5000-WASH-JOURNAL         THRU 5000-EXIT      
              ELSE                                                      
                 MOVE 100                           TO                  
                      WS-ACTIVE-RETURN-CODE                             
              END-IF                                                    
                                                                        
REARCH        PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT     
              PERFORM 8100-SEND-RESULT              THRU 8100-EXIT      
T23284     END-IF.                                                      
                                                                        
T23284 2200-EXIT.                                                       
T23284     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2300-GET-POST-DATE                                             *        
      *                                                                *        
      ******************************************************************        
C25923 2300-GET-POST-DATE.                                              
           MOVE PARM-CASH-COMPANY-NO          TO Y2-CASH-COMPANY-NO     
           MOVE PARM-CASH-LOCAL-OFFICE        TO Y2-CASH-LOCAL-OFFICE   
           MOVE PARM-DATE-CASH-REPORT         TO WS-NEW-BUSINESS-DAY    
           PERFORM 7360-SELECT-CASHIER-OFFICE THRU 7360-EXIT            
           PERFORM Y2-PYMT-TO-POST-DAYS TIMES                           
              MOVE 'N'                        TO WS-NEXT-BUSINESS-DAY   
              MOVE 'Y'                        TO WS-HOLIDAY-EXISTS      
              PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
                 THRU 6500-NEXT-BUSINESS-DAY-EXIT                       
                UNTIL NEXT-BUSINESS-DAY-FOUND                           
           END-PERFORM                                                  
           MOVE WS-NEW-BUSINESS-DAY           TO YB-BANK-POST-DT        
           .                                                            
C25923 2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2400-FORMAT-CJF00101                                           *        
      *                                                                *        
      ******************************************************************        
       2400-FORMAT-CJF00101.                                            
                                                                        
           MOVE PARM-FCS-DEP-BANK-CD          TO WS-101-FCS-DEP-BANK-CD.
           MOVE PARM-FCS-DEP-BANK-ST-CD       TO                        
           WS-101-FCS-DEP-BANK-ST-CD.                                   
           MOVE SPACES                        TO WS-101-CODE-EMPL-ACCT  
                                                 WS-101-FUNCTION-CODE   
                                                 WS-101-DATE-AR-BILLED  
                                                 WS-101-CASH-DRAWER-USED
           WS-101-CODE-COMPANY-ACCT                                     
           WS-101-CODE-REVENUE-DISTRICT                                 
           WS-101-CODE-PREMISE-STATUS                                   
           WS-101-CODE-ACCOUNT-STATUS.                                  
                                                                        
           MOVE 101                           TO WS-101-JRNL-FORMAT-NO. 
           MOVE WS-TOTAL-TRANSFER             TO WS-101-AMOUNT-ENTERED. 
                                                                        
           MOVE ZERO                          TO WS-101-AR-AGE          
                                                 WS-101-AMT-POSTED      
                                                 WS-101-ITEM-ID-NO      
                                                 WS-101-REVENUE-MONTH   
                                                 WS-101-DETAIL-END-BAL  
           WS-101-ACCT-END-AR-BAL                                       
           WS-101-DETAIL-END-AR-BAL.                                    
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5000-WASH-JOURNAL                                              *        
      ******************************************************************        
                                                                        
       5000-WASH-JOURNAL.                                               
                                                                        
           MOVE ZEROES                        TO WS-100-ACCT-NO         
                                                 WS-100-PREMISE-NO      
                                                 WS-100-CUSTOMER-NO.    
           MOVE 'A'                           TO WS-100-JRNL-SORT-ID.   
           MOVE 'C'                           TO                        
           WS-100-CODE-ENTRY-SOURCE.                                    
           MOVE WS-JRNL-CASH-UPDATE           TO WS-JRNL-OL-AUTH-TYPE.  
           MOVE EIBTRNID                      TO                        
           WS-100-CODE-TERMINAL-TRAN.                                   
           MOVE PARM-PC-ID                    TO WS-JRNL-OL-CSR-PC-ID.  
           MOVE PARM-USER-ID                  TO WS-JRNL-OL-TEMP-ID.    
           MOVE 'CLR-CASH'                    TO GO-GL-ACCT-NAME.       
           MOVE PARM-CASH-COMPANY-NO          TO WS-JRNL-OL-COMPANY     
                                                 GO-COMPANY-NO          
C25923*                                          Y2-CASH-COMPANY-NO             
                                                 WS-100-COMPANY-NO.     
           MOVE PARM-CASH-LOCAL-OFFICE        TO WS-JRNL-OL-LOC-OFF     
C25923*                                          Y2-CASH-LOCAL-OFFICE           
                                                 WS-JRNL-OL-REPORT-NO.  
           MOVE PARM-DATE-CASH-REPORT         TO WS-JRNL-OL-REPORT-DT.  
           MOVE PARM-CASH-DRAWER-ID           TO WS-JRNL-OL-CASH-DRWR.  
                                                                        
C25923*    PERFORM 7300-SELECT-CASHOFFICE                THRU 7300-EXIT.        
           MOVE Y2-LOCAL-OFFICE               TO WS-100-LOCAL-OFFICE-CD.
           MOVE WS-CURRENT-DATE               TO                        
           WS-100-DATE-LAST-ACTION.                                     
                                                                        
           PERFORM 7350-SELECT-CLRCASH                   THRU 7350-EXIT.
           MOVE GO-GL-ACCT-NO                 TO WS-101-ACCT-GEN-LED-CR 
                                                 WS-101-ACCT-GEN-LED-DR.
C25923*    PERFORM 7360-SELECT-CASHIER-OFFICE            THRU 7360-EXIT.        
           IF Y2-DEP-XFER-METHOD = 'M'                                  
              MOVE Y2-DEP-CASH-GL-OFFSET      TO WS-101-ACCT-GEN-LED-DR 
           END-IF                                                       
                                                                        
           MOVE WS-JRNL-CK-OPER-ID            TO WS-JRNL-OPERATION-RQST.
           PERFORM 6400-ONLINE-JRNL-ROUTINE              THRU 6400-EXIT.
                                                                        
           MOVE WS-JRNL-VALIDATE-OPER         TO WS-JRNL-OPERATION-RQST.
           PERFORM 6400-ONLINE-JRNL-ROUTINE              THRU 6400-EXIT.
                                                                        
           PERFORM 2400-FORMAT-CJF00101                  THRU 2400-EXIT.
                                                                        
           MOVE PARM-CURRENCY-TYPE1           TO WS-JRNL-CURRENCY-TYPE. 
           MOVE WS-TRANSFER-AMT-HOLD          TO WS-101-AMT-POSTED.     
           MOVE CJF00101                      TO                        
           WS-100-USER-DEFINED-AREA.                                    
           MOVE WS-JRNL-ONLY                  TO WS-JRNL-OPERATION-RQST.
           PERFORM 6400-ONLINE-JRNL-ROUTINE              THRU 6400-EXIT.
                                                                        
           IF PARM-CURRENCY-TYPE2 GREATER THAN SPACES THEN              
               MOVE PARM-CURRENCY-TYPE2       TO WS-JRNL-CURRENCY-TYPE  
               MOVE YB-TRANSFER-AMT           TO WS-101-AMT-POSTED      
               MOVE CJF00101                  TO                        
               WS-100-USER-DEFINED-AREA                                 
                                                                        
               PERFORM 6400-ONLINE-JRNL-ROUTINE          THRU 6400-EXIT 
           END-IF.                                                      
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY            TO WS-JRNL-OPERATION-RQST.
           PERFORM 6400-ONLINE-JRNL-ROUTINE              THRU 6400-EXIT.
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      **   6500-GET-NEXT-BUSINESS-DAY                                **         
      **   COPYBOOK CPD0315B CONTAINS THE LOGIC FOR FINDING          **         
      **   THE NEXT BUSINESS DAY.                                    **         
      *****************************************************************         
      *                                                                         
           EXEC SQL                                                             
               INCLUDE CPD0315B                                                 
           END-EXEC.                                                            
      *                                                                         
                                                                        
      ******************************************************************        
      * 7100-OPEN-RETRIEVE-CURSOR                                      *        
      ******************************************************************        
                                                                        
       7100-OPEN-RETRIEVE-CURSOR.                                       
                                                                        
           EXEC SQL                                                     
              OPEN RETRIEVE-CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7100'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'OPEN CURSOR'               TO ABEND-FUNCTION         
             MOVE 'RETRIEVE-CURSOR'           TO TABLE-1                
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7150-FETCH-RETRIEVE-CURSOR                                     *        
      ******************************************************************        
                                                                        
       7150-FETCH-RETRIEVE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              FETCH RETRIEVE-CURSOR                                     
               INTO :WS-RETURN-CODE,                                    
                    :YB-USER-ID,                                        
                    :RS-CASH-COMPANY-NO,                                
                    :RS-CASH-LOCAL-OFFICE,                              
                    :RS-DATE-CASH-REPORT,                               
                    :YB-TRANSFER-TS,                                    
                    :YB-BANK-ID,                                        
                    :YB-CURRENCY-TYPE,                                  
                    :YB-TRANSFER-AMT,                                   
T22767              :YB-CODE-DR-CR,                                     
                    :RS-CASH-DRAWER-ID,                                 
                    :CS-CODE-CSH-DRWR-STAT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
      *        OR CTR-ROWS GREATER THAN 0 THEN                                  
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7150'                      TO ACTIVE-PARAGRAPH      
              MOVE PROGRAM-NAME                TO ABEND-PROGRAM         
              MOVE 'FETCH CURSOR'              TO ABEND-FUNCTION        
              MOVE 'RETRIEVE-CURSOR'           TO TABLE-1               
              MOVE 'CASH-COMPANY-NO'           TO TABLE-ELEMENT-1       
              MOVE YB-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1     
              MOVE 'CASH-LOCAL-OFFICE'         TO TABLE-ELEMENT-2       
              MOVE YB-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2     
              MOVE 'DATE-CASH-REPORT'          TO TABLE-ELEMENT-3       
              MOVE YB-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3     
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7175-CLOSE-RETRIEVE-CURSOR                                     *        
      ******************************************************************        
                                                                        
       7175-CLOSE-RETRIEVE-CURSOR.                                      
                                                                        
           EXEC SQL                                                     
              CLOSE RETRIEVE-CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7175'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'CLOSE CURSOR'              TO ABEND-FUNCTION         
             MOVE 'RETRIEVE-CURSOR'           TO TABLE-1                
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7175-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-INSERT-TRNSFR                                             *        
      ******************************************************************        
       7200-INSERT-TRNSFR.                                              
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_BANK_TRANSFER                             
              (CASH_COMPANY_NO,                                         
              CASH_LOCAL_OFFICE,                                        
              DATE_CASH_REPORT,                                         
              CASH_DRAWER_ID,                                           
              BANK_ID,                                                  
              TRANSFER_TS,                                              
              CURRENCY_TYPE,                                            
              CODE_DR_CR,                                               
              TRANSFER_AMT,                                             
              USER_ID,                                                  
C25923        BANK_POST_DT)                                             
              VALUES                                                    
              (:YB-CASH-COMPANY-NO,                                     
              :YB-CASH-LOCAL-OFFICE,                                    
              IIF(TRY_CONVERT(DATE, :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) ),                        
              :YB-CASH-DRAWER-ID,                                       
              :YB-BANK-ID,                                              
C25923*       CURRENT TIMESTAMP,                                                
C25923        CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP),                        
              :YB-CURRENCY-TYPE,                                        
              :YB-CODE-DR-CR,                                           
              :YB-TRANSFER-AMT,                                         
              :YB-USER-ID,                                              
C25923        IIF(TRY_CONVERT(DATE, :YB-BANK-POST-DT
              ) IS NULL OR (PATINDEX('%.%', :YB-BANK-POST-DT
              ) <> 0) OR (LEN(:YB-BANK-POST-DT) <> 10), CIS.CHAR2DATE(
                                                       :YB-BANK-POST-DT
              ), CONVERT(DATE, :YB-BANK-POST-DT) ))                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_BANK_TRANSFER                                     
MFA-TR*       (CASH_COMPANY_NO,                                                 
MFA-TR*       CASH_LOCAL_OFFICE,                                                
MFA-TR*       DATE_CASH_REPORT,                                                 
MFA-TR*       CASH_DRAWER_ID,                                                   
MFA-TR*       BANK_ID,                                                          
MFA-TR*       TRANSFER_TS,                                                      
MFA-TR*       CURRENCY_TYPE,                                                    
MFA-TR*       CODE_DR_CR,                                                       
MFA-TR*       TRANSFER_AMT,                                                     
MFA-TR*       USER_ID,                                                          
MFA-TR*       BANK_POST_DT)                                                     
MFA-TR*       VALUES                                                            
MFA-TR*       (:YB-CASH-COMPANY-NO,                                             
MFA-TR*       :YB-CASH-LOCAL-OFFICE,                                            
MFA-TR*       :YB-DATE-CASH-REPORT,                                             
MFA-TR*       :YB-CASH-DRAWER-ID,                                               
MFA-TR*       :YB-BANK-ID,                                                      
MFA-TR*       CURRENT TIMESTAMP,                                                
MFA-TR*       :WS-CURRENT-TIMESTAMP,                                            
MFA-TR*       :YB-CURRENCY-TYPE,                                                
MFA-TR*       :YB-CODE-DR-CR,                                                   
MFA-TR*       :YB-TRANSFER-AMT,                                                 
MFA-TR*       :YB-USER-ID,                                                      
MFA-TR*       :YB-BANK-POST-DT)                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7200'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'INSERT'                    TO ABEND-FUNCTION         
             MOVE 'CSS_BANK_TRANSFER'         TO TABLE-1                
             MOVE 'CASH-LOCAL-OFFICE'         TO TABLE-ELEMENT-1        
             MOVE YB-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-1      
             MOVE 'DATE-CASH-REPORT'          TO TABLE-ELEMENT-2        
             MOVE YB-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-2      
             MOVE 'CASH-DRAWER-ID'            TO TABLE-ELEMENT-3        
             MOVE YB-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923* 7250-GET-TIMESTAMP                                             *        
      ******************************************************************        
                                                                        
       7250-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP              
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7250'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
T35434       MOVE 'SET'                       TO ABEND-FUNCTION         
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
C25923 7250-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-CASHOFFICE                                         *        
      ******************************************************************        
                                                                        
       7300-SELECT-CASHOFFICE.                                          
                                                                        
           EXEC SQL                                                     
              SELECT LOCAL_OFFICE,                                      
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
              INTO   :Y2-LOCAL-OFFICE,                                  
                     :WS-CURRENT-DATE                                   
              FROM   CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                   
              WHERE  CASH_COMPANY_NO = :Y2-CASH-COMPANY-NO              
              AND    CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE          
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT LOCAL_OFFICE,                                              
MFA-TR*              CURRENT DATE                                               
MFA-TR*       INTO   :Y2-LOCAL-OFFICE,                                          
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*       FROM   CSS_CASHIER_OFFICE                                         
MFA-TR*       WHERE  CASH_COMPANY_NO = :Y2-CASH-COMPANY-NO                      
MFA-TR*       AND    CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                  
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7300'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS_CASHIER_OFFICE'        TO TABLE-1                
             MOVE 'CASH-LOCAL-OFFICE'         TO TABLE-ELEMENT-1        
             MOVE Y2-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-1      
             MOVE 'CASH-COMPANY-NO'           TO TABLE-ELEMENT-2        
             MOVE Y2-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-2      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7350-SELECT-CLRCASH                                            *        
      ******************************************************************        
                                                                        
       7350-SELECT-CLRCASH.                                             
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
              INTO   :GO-GL-ACCT-NO                                     
              FROM   CSS_GL_ACCT_NO WITH(READUNCOMMITTED)                       
              WHERE  GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
MCR310*       AND    COMPANY_NO = :GO-COMPANY-NO                                
MCR310        AND    COMPANY_NO = '01'                                  
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT GL_ACCT_NO                                                 
MFA-TR*       INTO   :GO-GL-ACCT-NO                                             
MFA-TR*       FROM   CSS_GL_ACCT_NO                                             
MFA-TR*       WHERE  GL_ACCT_NAME = :GO-GL-ACCT-NAME                            
MFA-TR*       AND    COMPANY_NO = :GO-COMPANY-NO                                
MFA-TR*       AND    COMPANY_NO = '01'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7350'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-GL-ACCT-NO'            TO TABLE-1                
             MOVE 'COMPANY-NO'                TO TABLE-ELEMENT-1        
             MOVE '01'                        TO HOSTVAR-ELEMENT-1      
             MOVE 'GL-ACCT-NAME'              TO TABLE-ELEMENT-2        
             MOVE GO-GL-ACCT-NAME             TO HOSTVAR-ELEMENT-2      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7360-SELECT-CASHIER-OFFICE                                     *        
      ******************************************************************        
                                                                        
       7360-SELECT-CASHIER-OFFICE.                                      
                                                                        
           EXEC SQL                                                     
             SELECT DEP_CASH_GL_OFFSET,                                 
                    DEP_XFER_METHOD,                                    
C25923              LOCAL_OFFICE,                                       
C25923              PYMT_TO_POST_DAYS,                                  
C25923              CAST(SYSDATETIMEOFFSET() AS DATE)                           
               INTO :Y2-DEP-CASH-GL-OFFSET,                             
                    :Y2-DEP-XFER-METHOD,                                
C25923              :Y2-LOCAL-OFFICE,                                   
C25923              :Y2-PYMT-TO-POST-DAYS,                              
C25923              :WS-CURRENT-DATE                                    
               FROM CSS_CASHIER_OFFICE WITH(READUNCOMMITTED)                    
              WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO             
                AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE           
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT DEP_CASH_GL_OFFSET,                                         
MFA-TR*             DEP_XFER_METHOD,                                            
MFA-TR*             LOCAL_OFFICE,                                               
MFA-TR*             PYMT_TO_POST_DAYS,                                          
MFA-TR*             CURRENT DATE                                                
MFA-TR*        INTO :Y2-DEP-CASH-GL-OFFSET,                                     
MFA-TR*             :Y2-DEP-XFER-METHOD,                                        
MFA-TR*             :Y2-LOCAL-OFFICE,                                           
MFA-TR*             :Y2-PYMT-TO-POST-DAYS,                                      
MFA-TR*             :WS-CURRENT-DATE                                            
MFA-TR*        FROM CSS_CASHIER_OFFICE                                          
MFA-TR*       WHERE CASH_COMPANY_NO   = :Y2-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :Y2-CASH-LOCAL-OFFICE                   
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7360'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS_CASHIER_OFFICE'        TO TABLE-1                
             MOVE 'CASH-LOCAL-OFFICE'         TO TABLE-ELEMENT-1        
             MOVE Y2-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-1      
             MOVE 'CASH-COMPANY-NO'           TO TABLE-ELEMENT-2        
             MOVE Y2-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-2      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7360-EXIT.                                                       
           EXIT.                                                        
                                                                        
D11762******************************************************************        
D11762*7600-GET-OPEN-DRWR.                                                      
D11762******************************************************************        
D11762 7600-GET-OPEN-DRWR.                                              
           EXEC SQL                                                     
             SELECT CS.CODE_CSH_DRWR_STAT                               
               INTO :CS-CODE-CSH-DRWR-STAT                              
               FROM CSS_CSH_DRWR_CNTL CS WITH(READUNCOMMITTED)                  
              WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO          
                AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE        
                AND  DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )         
                AND  CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID           
                AND  USER_ID             = :CS-USER-ID                  
                                                                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CS.CODE_CSH_DRWR_STAT                                       
MFA-TR*        INTO :CS-CODE-CSH-DRWR-STAT                                      
MFA-TR*        FROM CSS_CSH_DRWR_CNTL CS                                        
MFA-TR*       WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO                  
MFA-TR*         AND  CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE                
MFA-TR*         AND  DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT                 
MFA-TR*         AND  CASH_DRAWER_ID      = :CS-CASH-DRAWER-ID                   
MFA-TR*         AND  USER_ID             = :CS-USER-ID                          
MFA-TR*        WITH UR                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
              IF CS-CODE-CSH-DRWR-STAT NOT = WS-A                       
                 MOVE 1000 TO RS-RETURN-CODE                            
                 PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT    
                 PERFORM 8100-SEND-RESULT            THRU 8100-EXIT     
                 PERFORM 9999-END-PROGRAM            THRU 9999-EXIT     
              END-IF                                                    
           ELSE                                                         
             MOVE '7600'                      TO ACTIVE-PARAGRAPH       
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS_CSH_DRWR_CNTL'         TO TABLE-1                
             MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-1        
             MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-1      
             MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-2        
             MOVE CS-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-2      
             MOVE 'USER_ID'                   TO TABLE-ELEMENT-3        
             MOVE CS-USER-ID                  TO HOSTVAR-ELEMENT-3      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
D11762 7600-EXIT.                                                       
D11762     EXIT.                                                        
                                                                        
T19922******************************************************************        
T19922* 7999-SELECT-AL                                                 *        
T19922******************************************************************        
T19922        EXEC SQL                                                          
T19922           INCLUDE CPD00075                                               
T19922        END-EXEC.                                                         
T19922                                                                  
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS.                                          *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DELETE FROM #CSR02392_R1                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR02392_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02392_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*  8100-SEND-RESULT.                                             *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02392_R1                         
REARCH          (                                                       
REARCH                RETURN_CODE                                       
REARCH               ,USER_ID                                           
REARCH               ,CASH_COMPANY_NO                                   
REARCH               ,CASH_LOCAL_OFFICE                                 
REARCH               ,DATE_CASH_REPORT                                  
REARCH               ,TRANSFER_TS                                       
REARCH               ,BANK_ID                                           
REARCH               ,CASH_AMT                                          
REARCH               ,CHECK_MO_AMT                                      
REARCH               ,CASH_DRAWER_ID                                    
REARCH               ,CODE_CSH_DRWR_STAT                                
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH                :S-RETURN-CODE                                    
REARCH               ,:S-USER-ID                                        
REARCH               ,:S-CASH-COMPANY-NO                                
REARCH               ,:S-CASH-LOCAL-OFFICE                              
REARCH               ,:S-DATE-CASH-REPORT                               
REARCH               ,:S-TRANSFER-TS                                    
REARCH               ,:S-BANK-ID                                        
REARCH               ,:S-CASH-AMT                                       
REARCH               ,:S-CHECK-MO-AMT                                   
REARCH               ,:S-CASH-DRAWER-ID                                 
REARCH               ,:S-CODE-CSH-DRWR-STAT                             
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02392_R1                                 
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                               
MFA-TR*              ,USER_ID                                                   
MFA-TR*              ,CASH_COMPANY_NO                                           
MFA-TR*              ,CASH_LOCAL_OFFICE                                         
MFA-TR*              ,DATE_CASH_REPORT                                          
MFA-TR*              ,TRANSFER_TS                                               
MFA-TR*              ,BANK_ID                                                   
MFA-TR*              ,CASH_AMT                                                  
MFA-TR*              ,CHECK_MO_AMT                                              
MFA-TR*              ,CASH_DRAWER_ID                                            
MFA-TR*              ,CODE_CSH_DRWR_STAT                                        
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*              ,:S-USER-ID                                                
MFA-TR*              ,:S-CASH-COMPANY-NO                                        
MFA-TR*              ,:S-CASH-LOCAL-OFFICE                                      
MFA-TR*              ,:S-DATE-CASH-REPORT                                       
MFA-TR*              ,:S-TRANSFER-TS                                            
MFA-TR*              ,:S-BANK-ID                                                
MFA-TR*              ,:S-CASH-AMT                                               
MFA-TR*              ,:S-CHECK-MO-AMT                                           
MFA-TR*              ,:S-CASH-DRAWER-ID                                         
MFA-TR*              ,:S-CODE-CSH-DRWR-STAT                                     
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
REARCH         ADD +1                    TO CTR-ROWS                    
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SQLCODE              TO ABEND-SQLCODE               
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02392_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 9900-JOURNALING / ERROR HANDLING INCLUDE                       *        
      ******************************************************************        
                                                                        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
A00956        INCLUDE CPD0006A                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *      END PROGRAM COPYLIB                                       *        
      ******************************************************************        
REARCH*COPY CPD00302.                                                           
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
