       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02391.                                         
COB303 DATE-WRITTEN.  SEPTEMBER 14, 1999.                               
       DATE-COMPILED.                                                   
                                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      *          SOUTH CAROLINA ELECTRIC & GAS                         *        
      *                                                                *        
      * THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).    *        
      *                                                                *        
      *  TRANID:        S391                                           *        
      *  PROGRAM:       S391                                           *        
      *  CALLING SP:    PA_S391                                        *        
      *                                                                *        
      ******************************************************************        
      *                       P R O G R A M  S U M M A R Y             *        
      *                                                                *        
      *  THIS RPC WILL RETRIEVE THE DOLLARS AVAILABLE FOR TRANSFER FOR *        
      *  A CASH BATCH.  DOLLARS THAT CAN BE TRANSFERRED ARE CASH, AND  *        
      *  CHECK AND MONEY ORDER.  THE LATTER ARE TRANSFERRED TOGETHER.  *        
      *  OTHER RECEIPTS ARE SUMMED, BUT CANNOT BE TRANSFERRED ON       *        
      *  PANEL174.                                                     *        
      *                                                                *        
      *  PARAMETERS:                                                   *        
      *    CASH-COMPANY-NO                                             *        
      *    CASH-LOCAL-OFFICE                                           *        
      *    DATE-CASH-REPORT                                            *        
      *    CASH-DRAWER-ID                                              *        
      *                                                                *        
      *  RETURNS:                                                      *        
      *    RETURN-CODE  (SUCCESS INDICATOR)                            *        
      *    CASH-AVL (CASH AVAILABLE FOR TRANSFER)                      *        
      *    CHECK-MO-AVL (CHECK + MONEY ORDER AVAILABLE FOR TRANSFER)   *        
      *    OTHER-REC-AVL (OTHER RECEIPTS AVAILABLE FOR TRANSFER)       *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *  DATE      INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------- *        
      *  09/14/99  JH82212    NEW CODE                                 *        
T19923*  12/02/99  CBSI       CHANGES FOR TPR 19923                    *        
C25923*  03/01/02  BASKAR     CHANGES FOR SELECTING BANK TRANSFER AMT  *        
REARCH*  07/01/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      ******************************************************************        
                                                                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02391'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
REARCH     'WORKING STORAGE FOR CSR02391 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      * GO - CSS_GL_ACCT_NO                                                     
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
      * I5 - CSS_LIEAP_AGENCY                                                   
           EXEC SQL                                                             
              INCLUDE TBLIAGCY                                                  
           END-EXEC.                                                            
                                                                        
      * CS - CSS_CSH_DRWR_CNTL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDCNTL                                                  
           END-EXEC.                                                            
                                                                        
      * CJ - CSS_CSH_DRWR_JRNL                                                  
           EXEC SQL                                                             
              INCLUDE TBCDJRNL                                                  
           END-EXEC.                                                            
                                                                        
      * Y7 - CSS_CURRENCY                                                       
           EXEC SQL                                                             
              INCLUDE TBCURRCY                                                  
           END-EXEC.                                                            
                                                                        
      * YB - CSS_BANK_TRANSFER                                                  
           EXEC SQL                                                             
              INCLUDE TBBNKXFR                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * COBOL WORKING STORAGE COPY BOOKS                               *        
      ******************************************************************        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
           COPY CWS00303.                                                       
           COPY CJF00101.                                                       
                                                                        
      ******************************************************************        
      * WORK AREA                                                      *        
      ******************************************************************        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME              PIC X(08) VALUE 'CSR02391'.    
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                  POINTER.                               
REARCH*    05  GWL-INIT-HANDLE           POINTER.                               
REARCH*    05  GWL-RC                    PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-NR             PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-DONE           PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-COUNT          PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-COMM           PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-RETURN-CODE    PIC S9(09) COMP.                       
REARCH*    05  GWL-STATUS-SUBCODE        PIC S9(09) COMP.                       
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02391_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
REARCH*01  PARM-FIELDS.                                                         
REARCH*    05  PARM-L                    PIC S9(09) COMP.                       
REARCH*    05  PARM-ID1                  PIC S9(09) COMP VALUE 1.               
REARCH*    05  PARM-CASH-COMPANY-NO      PIC X(02) VALUE SPACES.                
REARCH*    05  PARM-CASH-LOCAL-OFFICE    PIC X(03) VALUE SPACES.                
REARCH*    05  PARM-DATE-CASH-REPORT     PIC X(10) VALUE SPACES.                
REARCH*    05  PARM-CASH-DRAWER-ID       PIC S9(04) COMP VALUE ZEROES.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(09) COMP.               
           05  SNA-CONNECTION-NAME       PIC X(08)  VALUE SPACES.       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                PIC S9(09) COMP VALUE 1.       
           05  CTR-ROWS                  PIC S9(09) COMP VALUE 0.       
           05  CURSOR-CTR-ROWS           PIC S9(09) COMP VALUE 0.       
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM           PIC S9(09) COMP.               
           05  WRKLEN1                   PIC S9(09) COMP.               
           05  WRKLEN2                   PIC S9(09) COMP.               
           05  WRK-DONE-STATUS           PIC S9(09) COMP.               
           05  WS-GL-ACCT-NO OCCURS 500 TIMES INDEXED BY WS-GLX         
                                         PIC S9(03)V9(04) COMP-3 VALUE  
                                         +0.                            
           05  WS-CASH-AVL               PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-CHECK-MO-AVL           PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-OTHER-REC-AVL          PIC S9(11)V99 COMP-3 VALUE +0. 
           05  WS-C                      PIC X(01) VALUE 'C'.           
           05  WS-PROCESS-FLAG           PIC X(01) VALUE 'N'.           
               88 WS-DEBIT                         VALUE 'D'.           
               88 WS-CREDIT                        VALUE 'C'.           
               88 WS-NOTHING                       VALUE 'N'.           
           05  WS-NULL-IND               PIC S9(04) COMP.               
C25923     05 WS-BANK-TRANS              PIC S9(11)V99 COMP-3 VALUE +0. 
C25923     05 WS-BANK-TRANS-TOTAL        PIC S9(11)V99 COMP-3 VALUE +0. 
                                                                        
       01  WS-CURRENCY-TYPE.                                            
           05  WS-CASH                   PIC X(01) VALUE 'A'.           
           05  WS-CHECK                  PIC X(01) VALUE 'C'.           
           05  WS-MONEY-ORDER            PIC X(01) VALUE 'M'.           
           05  WS-LIHEAP                 PIC X(01) VALUE 'L'.           
           05  WS-DRAFT                  PIC X(01) VALUE 'D'.           
                                                                        
       01  FILLER                        PIC X(32) VALUE                
           'THIS IS THE ROW RETURN AREA.'.                              
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
           05  RS-CASH-AVL               PIC S9(11)V99 COMP-3 VALUE +0. 
           05  RS-CHECK-MO-AVL           PIC S9(11)V99 COMP-3 VALUE +0. 
           05  RS-OTHER-REC-AVL          PIC S9(11)V99 COMP-3 VALUE +0. 
REARCH*                                                                         
       01  GTT-RETURN-FIELDS.                                           
           05  S-RETURN-CODE             PIC S9(09) COMP VALUE 0.       
           05  S-CASH-AVL                PIC S9(11)V99 COMP-3 VALUE +0. 
           05  S-CHECK-MO-AVL            PIC S9(11)V99 COMP-3 VALUE +0. 
           05  S-OTHER-REC-AVL           PIC S9(11)V99 COMP-3 VALUE +0. 
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
                                                                        
REARCH*01  CN-COLUMN-NAMES.                                                     
REARCH*    05  CN-RETURN-CODE            PIC X(11) VALUE 'RETURN_CODE'.         
REARCH*    05  CN-CASH-AVL               PIC X(08) VALUE 'CASH_AVL'.            
REARCH*    05  CN-CHECK-MO-AVL           PIC X(12) VALUE 'CHECK_MO_AVL'.        
REARCH*    05  CN-OTHER-REC-AVL          PIC X(13) VALUE                        
REARCH*        'OTHER_REC_AVL'.                                                 
                                                                        
                                                                        
      ******************************************************************        
      * CURSOR DECLARATIONS                                            *        
      ******************************************************************        
      * CSS_LIEAP_AGENCY CURSOR                                                 
           EXEC SQL                                                     
              DECLARE I5-CURSOR CURSOR FOR                              
              SELECT DISTINCT                                           
                     GL_ACCT_NO                                         
              FROM   CSS_LIEAP_AGENCY                                   
              WHERE  COMPANY_NO = :I5-COMPANY-NO                        
              ORDER BY GL_ACCT_NO                                       
           END-EXEC.                                                    
                                                                        
      * CSS_CSH_DRWR_JRNL CURSOR                                                
           EXEC SQL                                                     
              DECLARE CJ-CURSOR CURSOR FOR                              
              SELECT TRAN_DATA,                                         
                     CJ.CURRENCY_TYPE                                   
              FROM   CSS_CSH_DRWR_JRNL CJ,                              
                     CSS_CURRENCY Y7                                    
              WHERE  CASH_COMPANY_NO = :CJ-CASH-COMPANY-NO              
              AND    CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE          
              AND    CASH_DRAWER_ID = :CJ-CASH-DRAWER-ID                
              AND    DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )            
              AND    CJ.CURRENCY_TYPE = Y7.CURRENCY_TYPE                
      *       AND    DEPOSIT_FL = 'Y'                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CJ-CURSOR CURSOR FOR                                      
MFA-TR*       SELECT TRAN_DATA,                                                 
MFA-TR*              CJ.CURRENCY_TYPE                                           
MFA-TR*       FROM   CSS_CSH_DRWR_JRNL CJ,                                      
MFA-TR*              CSS_CURRENCY Y7                                            
MFA-TR*       WHERE  CASH_COMPANY_NO = :CJ-CASH-COMPANY-NO                      
MFA-TR*       AND    CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE                  
MFA-TR*       AND    CASH_DRAWER_ID = :CJ-CASH-DRAWER-ID                        
MFA-TR*       AND    DATE_CASH_REPORT = :CJ-DATE-CASH-REPORT                    
MFA-TR*       AND    CJ.CURRENCY_TYPE = Y7.CURRENCY_TYPE                        
MFA-TR*       AND    DEPOSIT_FL = 'Y'                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
C25923******************************************************************        
C25923*        CURSOR FOR CSS_BANK_TRANSFER                            *        
C25923******************************************************************        
C25923                                                                  
C25923     EXEC SQL                                                     
C25923      DECLARE BXFER_CURSOR CURSOR FOR                             
C25923       SELECT SUM(TRANSFER_AMT)                                   
C25923              ,CODE_DR_CR                                         
C25923         FROM CSS_BANK_TRANSFER                                   
C25923        WHERE CASH_COMPANY_NO   = :YB-CASH-COMPANY-NO             
C25923          AND CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE           
C25923          AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )            
C25923          AND CASH_DRAWER_ID    = :YB-CASH-DRAWER-ID              
C25923          AND CURRENCY_TYPE     = :YB-CURRENCY-TYPE               
C25923        GROUP BY CODE_DR_CR                                       
C25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BXFER_CURSOR CURSOR FOR                                     
MFA-TR*      SELECT SUM(TRANSFER_AMT)                                           
MFA-TR*             ,CODE_DR_CR                                                 
MFA-TR*        FROM CSS_BANK_TRANSFER                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :YB-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :YB-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :YB-CASH-DRAWER-ID                      
MFA-TR*         AND CURRENCY_TYPE     = :YB-CURRENCY-TYPE                       
MFA-TR*       GROUP BY CODE_DR_CR                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
C25923******************************************************************        
C25923*        CURSOR FOR CSS_BANK_TRANSFER                            *        
C25923******************************************************************        
C25923                                                                  
C25923     EXEC SQL                                                     
C25923      DECLARE BXFER2_CURSOR CURSOR FOR                            
C25923       SELECT SUM(TRANSFER_AMT)                                   
C25923              ,CODE_DR_CR                                         
C25923         FROM CSS_BANK_TRANSFER                                   
C25923        WHERE CASH_COMPANY_NO   = :YB-CASH-COMPANY-NO             
C25923          AND CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE           
C25923          AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :YB-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YB-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YB-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YB-DATE-CASH-REPORT
              ), CONVERT(DATE, :YB-DATE-CASH-REPORT) )            
C25923          AND CASH_DRAWER_ID    = :YB-CASH-DRAWER-ID              
C25923          AND CURRENCY_TYPE  NOT IN ('A','C','M','D')             
C25923        GROUP BY CODE_DR_CR                                       
C25923     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*     DECLARE BXFER2_CURSOR CURSOR FOR                                    
MFA-TR*      SELECT SUM(TRANSFER_AMT)                                           
MFA-TR*             ,CODE_DR_CR                                                 
MFA-TR*        FROM CSS_BANK_TRANSFER                                           
MFA-TR*       WHERE CASH_COMPANY_NO   = :YB-CASH-COMPANY-NO                     
MFA-TR*         AND CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE                   
MFA-TR*         AND DATE_CASH_REPORT  = :YB-DATE-CASH-REPORT                    
MFA-TR*         AND CASH_DRAWER_ID    = :YB-CASH-DRAWER-ID                      
MFA-TR*         AND CURRENCY_TYPE  NOT IN ('A','C','M','D')                     
MFA-TR*       GROUP BY CODE_DR_CR                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
HPCCDM*EJECT                                                                    
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-CASH-COMPANY-NO      PIC X(02).                          
REARCH 01 PARM-CASH-LOCAL-OFFICE    PIC X(03).                          
REARCH 01 PARM-DATE-CASH-REPORT     PIC X(10).                          
REARCH 01 PARM-CASH-DRAWER-ID       PIC S9(04) COMP.                    
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-CASH-COMPANY-NO                    
REARCH                          PARM-CASH-LOCAL-OFFICE                  
REARCH                          PARM-DATE-CASH-REPORT                   
REARCH                          PARM-CASH-DRAWER-ID.                    
                                                                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                       THRU 0100-EXIT.
REARCH*    PERFORM 1000-PROCESS-INPUT                    THRU 1000-EXIT.        
           PERFORM 2000-PROCESS-OUTPUT                   THRU 2000-EXIT.
           PERFORM 9999-END-PROGRAM                      THRU 9999-EXIT.
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      * 1. RESET DB2 ERROR HANDLERS                                    *        
      * 2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                      *        
      * 3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)       *        
      * 4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)    *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT EQUAL TDS-PARM-PRESENT                                 
REARCH*       MOVE PROGRAM-NAME               TO ABEND-PROGRAM                  
REARCH*       MOVE '0100'                     TO ACTIVE-PARAGRAPH               
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT'                                
REARCH*                                       TO ABEND-FUNCTION                 
REARCH*       MOVE 'CICS TRANSACTION'         TO TABLE-1                        
REARCH*       MOVE GWL-RC                     TO WS-ACTIVE-RETURN-CODE          
REARCH*                                                                         
REARCH*       PERFORM 9000-SEND-ERROR-RESULT             THRU 9000-EXIT         
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE             THRU 9900-EXIT         
REARCH*    END-IF.                                                              
REARCH     EXEC SQL                                                     
REARCH        DECLARE C1 CURSOR  FOR                         
REARCH        SELECT                                                    
REARCH          :S-RETURN-CODE      AS RETURN_CODE                      
REARCH         ,:S-CASH-AVL         AS CASH_AVL                         
REARCH         ,:S-CHECK-MO-AVL     AS CHECK_MO_AVL                     
REARCH         ,:S-OTHER-REC-AVL    AS OTHER_REC_AVL                    
REARCH        FROM                                                      
REARCH            CIS.SYSDUMMY1                                      
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE C1 CURSOR WITH RETURN FOR                                 
MFA-TR*       SELECT                                                            
MFA-TR*         :S-RETURN-CODE      AS RETURN_CODE                              
MFA-TR*        ,:S-CASH-AVL         AS CASH_AVL                                 
MFA-TR*        ,:S-CHECK-MO-AVL     AS CHECK_MO_AVL                             
MFA-TR*        ,:S-OTHER-REC-AVL    AS OTHER_REC_AVL                            
MFA-TR*       FROM                                                              
MFA-TR*           SYSIBM.SYSDUMMY1                                              
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-IPUT                                              *        
      *                                                                *        
      * 1. RECEIVE PARMS.                                              *        
      ******************************************************************        
                                                                        
REARCH*1000-PROCESS-INPUT.                                                      
                                                                        
REARCH*    PERFORM 1100-RECEIVE-PARMS                    THRU 1100-EXIT.        
                                                                        
REARCH*1000-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *                                                                *        
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE           *        
      ******************************************************************        
                                                                        
REARCH*1100-RECEIVE-PARMS.                                                      
REARCH*                                                                         
REARCH*    MOVE 1                             TO PARM-ID1.                      
REARCH*    MOVE LENGTH OF PARM-CASH-COMPANY-NO                                  
REARCH*                                       TO MAX-LENGTH-PARM.               
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-CASH-COMPANY-NO,                          
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                             TO PARM-ID1.                      
REARCH*    MOVE LENGTH OF PARM-CASH-LOCAL-OFFICE                                
REARCH*                                       TO MAX-LENGTH-PARM.               
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-CASH-LOCAL-OFFICE,                        
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                             TO PARM-ID1.                      
REARCH*    MOVE LENGTH OF PARM-DATE-CASH-REPORT                                 
REARCH*                                       TO MAX-LENGTH-PARM.               
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-DATE-CASH-REPORT,                         
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                             TO PARM-ID1.                      
REARCH*    MOVE LENGTH OF PARM-CASH-DRAWER-ID TO MAX-LENGTH-PARM                
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-CASH-DRAWER-ID,                           
REARCH*                          TDSINT2,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*1100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT                  THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT                     THRU 2200-EXIT.
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 2000A-MOVE-RESULT                                              *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH     MOVE RS-CASH-AVL           TO S-CASH-AVL.                    
REARCH     MOVE RS-CHECK-MO-AVL       TO S-CHECK-MO-AVL.                
REARCH     MOVE RS-OTHER-REC-AVL      TO S-OTHER-REC-AVL.               
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE 1                             TO CTR-COLUMN.                    
REARCH*    MOVE TDSINT4                       TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSINT4                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CN-RETURN-CODE      TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-RETURN-CODE,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR                      THRU 9100-EXIT.        
REARCH*                                                                         
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-CASH-AVL         TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CN-CASH-AVL         TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CASH-AVL,                                   
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-CASH-AVL,                                   
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    MOVE +2                            TO WRKLEN2.                       
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR                      THRU 9100-EXIT.        
REARCH*                                                                         
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-CHECK-MO-AVL     TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CN-CHECK-MO-AVL     TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-CHECK-MO-AVL,                               
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-CHECK-MO-AVL,                               
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    MOVE +2                            TO WRKLEN2.                       
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR                      THRU 9100-EXIT.        
REARCH*                                                                         
REARCH*    ADD 1                              TO CTR-COLUMN.                    
REARCH*    MOVE TDSDECIMAL                    TO DB-HOST-TYPE.                  
REARCH*    MOVE TDSFLT8                       TO DB-CLIENT-TYPE.                
REARCH*    MOVE LENGTH OF RS-OTHER-REC-AVL    TO WRKLEN1.                       
REARCH*    MOVE LENGTH OF CN-OTHER-REC-AVL    TO WRKLEN2.                       
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-OTHER-REC-AVL,                              
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-OTHER-REC-AVL,                              
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    MOVE +2                            TO WRKLEN2.                       
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          TDS-OBJECT-COL,                                
REARCH*                          CTR-COLUMN,                                    
REARCH*                          WRKLEN1,                                       
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR                      THRU 9100-EXIT.        
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE PARM-CASH-COMPANY-NO          TO I5-COMPANY-NO          
                                                 CJ-CASH-COMPANY-NO     
                                                 YB-CASH-COMPANY-NO     
                                                 CS-CASH-COMPANY-NO     
                                                 GO-COMPANY-NO.         
                                                                        
           MOVE PARM-CASH-LOCAL-OFFICE        TO CJ-CASH-LOCAL-OFFICE   
                                                 CS-CASH-LOCAL-OFFICE   
                                                 YB-CASH-LOCAL-OFFICE.  
                                                                        
           MOVE PARM-CASH-DRAWER-ID           TO CJ-CASH-DRAWER-ID      
                                                 CS-CASH-DRAWER-ID      
                                                 YB-CASH-DRAWER-ID.     
                                                                        
           MOVE PARM-DATE-CASH-REPORT         TO CJ-DATE-CASH-REPORT    
                                                 CS-DATE-CASH-REPORT    
                                                 YB-DATE-CASH-REPORT.   
                                                                        
           MOVE 'CLR-CASH'                    TO GO-GL-ACCT-NAME.       
           PERFORM 7000-SELECT-CLRCASH                   THRU 7000-EXIT.
                                                                        
           PERFORM 7100-OPEN-I5CURSOR                    THRU 7100-EXIT.
           PERFORM 7150-FETCH-I5CURSOR                   THRU 7150-EXIT.
                                                                        
           PERFORM                                                      
               VARYING WS-GLX FROM 1 BY 1                               
               UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND              
               MOVE I5-GL-ACCT-NO             TO WS-GL-ACCT-NO(WS-GLX)  
                                                                        
               PERFORM 7150-FETCH-I5CURSOR               THRU 7150-EXIT 
           END-PERFORM.                                                 
                                                                        
           PERFORM 7175-CLOSE-I5CURSOR                   THRU 7175-EXIT.
                                                                        
      *    PERFORM 7300-SELECT-BEGBAL                    THRU 7300-EXIT.        
      *    MOVE CS-AMT-CASH-BEGIN-BAL         TO WS-CASH-AVL.                   
                                                                        
           PERFORM 5000-PROCESS-JRNL                     THRU 5000-EXIT.
                                                                        
           IF CURSOR-CTR-ROWS GREATER THAN ZERO THEN                    
               PERFORM 5100-PROCESS-TRNSFRS              THRU 5100-EXIT 
           END-IF.                                                      
                                                                        
           MOVE WS-CASH-AVL                   TO RS-CASH-AVL.           
           MOVE WS-CHECK-MO-AVL               TO RS-CHECK-MO-AVL.       
           MOVE WS-OTHER-REC-AVL              TO RS-OTHER-REC-AVL.      
                                                                        
REARCH     PERFORM 2000A-MOVE-RESULT                    THRU 2000A-EXIT.
REARCH     ADD +1                                       TO CTR-ROWS.    
REARCH*    PERFORM 8100-SEND-RESULT                      THRU 8100-EXIT.        
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5000-PROCESS-JRNL                                              *        
      ******************************************************************        
       5000-PROCESS-JRNL.                                               
                                                                        
           PERFORM 7200-OPEN-CJCURSOR                    THRU 7200-EXIT.
           PERFORM 7250-FETCH-CJCURSOR                   THRU 7250-EXIT.
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
T19923         MOVE 'N'                       TO WS-PROCESS-FLAG        
               MOVE CJ-TRAN-DATA              TO CJF00101               
                                                                        
               IF WS-101-ACCT-GEN-LED-DR EQUAL WS-101-ACCT-GEN-LED-CR   
                   MOVE 'N'                   TO WS-PROCESS-FLAG        
               ELSE                                                     
                  IF WS-101-ACCT-GEN-LED-DR EQUAL GO-GL-ACCT-NO THEN    
                      MOVE 'D'                TO WS-PROCESS-FLAG        
                  ELSE                                                  
                     IF WS-101-ACCT-GEN-LED-CR EQUAL GO-GL-ACCT-NO THEN 
                         MOVE 'C'             TO WS-PROCESS-FLAG        
                     END-IF                                             
                  END-IF                                                
                                                                        
                  IF WS-NOTHING THEN                                    
                      SET WS-GLX              TO 1                      
                                                                        
                      SEARCH WS-GL-ACCT-NO                              
                          WHEN WS-101-ACCT-GEN-LED-DR EQUAL             
                          WS-GL-ACCT-NO(WS-GLX)                         
                              MOVE 'D'        TO WS-PROCESS-FLAG        
                      END-SEARCH                                        
                                                                        
                      SET WS-GLX              TO 1                      
                                                                        
                      SEARCH WS-GL-ACCT-NO                              
                          WHEN WS-101-ACCT-GEN-LED-CR EQUAL             
                          WS-GL-ACCT-NO(WS-GLX)                         
                              IF WS-DEBIT THEN                          
                                  MOVE 'N'    TO WS-PROCESS-FLAG        
                              ELSE                                      
                                 MOVE 'C'     TO WS-PROCESS-FLAG        
                              END-IF                                    
                      END-SEARCH                                        
                  END-IF                                                
               END-IF                                                   
                                                                        
               IF WS-DEBIT THEN                                         
                   IF CJ-CURRENCY-TYPE EQUAL WS-CASH THEN               
                       ADD WS-101-AMT-POSTED                            
                                           TO WS-CASH-AVL               
                   ELSE                                                 
                      IF CJ-CURRENCY-TYPE EQUAL WS-CHECK OR             
C25923*               WS-MONEY-ORDER THEN                                       
C25923                WS-MONEY-ORDER OR WS-DRAFT THEN                   
                          ADD WS-101-AMT-POSTED                         
                                           TO WS-CHECK-MO-AVL           
                      ELSE                                              
                         ADD WS-101-AMT-POSTED                          
                                           TO WS-OTHER-REC-AVL          
                      END-IF                                            
                   END-IF                                               
               ELSE                                                     
                  IF WS-CREDIT THEN                                     
                      IF CJ-CURRENCY-TYPE EQUAL WS-CASH THEN            
                          SUBTRACT WS-101-AMT-POSTED                    
                                              FROM WS-CASH-AVL          
                      ELSE                                              
                         IF CJ-CURRENCY-TYPE EQUAL WS-CHECK OR          
C25923*                  WS-MONEY-ORDER THEN                                    
C25923                   WS-MONEY-ORDER OR WS-DRAFT THEN                
                             SUBTRACT WS-101-AMT-POSTED                 
                                              FROM WS-CHECK-MO-AVL      
                         ELSE                                           
                            SUBTRACT WS-101-AMT-POSTED                  
                                              FROM WS-OTHER-REC-AVL     
                         END-IF                                         
                      END-IF                                            
                  END-IF                                                
               END-IF                                                   
                                                                        
               PERFORM 7250-FETCH-CJCURSOR               THRU 7250-EXIT 
           END-PERFORM.                                                 
                                                                        
           PERFORM 7275-CLOSE-CJCURSOR                   THRU 7275-EXIT.
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 5100-PROCESS-TRNSFRS                                           *        
      ******************************************************************        
       5100-PROCESS-TRNSFRS.                                            
                                                                        
C25923     MOVE WS-CASH                       TO YB-CURRENCY-TYPE.      
C25923     MOVE ZERO                          TO WS-BANK-TRANS.         
C25923     MOVE ZERO                          TO WS-BANK-TRANS-TOTAL.   
C25923     PERFORM 5150-SUM-TRNSFRS           THRU 5150-EXIT.           
C25923     SUBTRACT WS-BANK-TRANS-TOTAL  FROM WS-CASH-AVL.              
C25923                                                                  
C25923     MOVE WS-CHECK                      TO YB-CURRENCY-TYPE.      
C25923     MOVE ZERO                          TO WS-BANK-TRANS.         
C25923     MOVE ZERO                          TO WS-BANK-TRANS-TOTAL.   
C25923     PERFORM 5150-SUM-TRNSFRS           THRU 5150-EXIT.           
C25923     SUBTRACT WS-BANK-TRANS-TOTAL  FROM WS-CHECK-MO-AVL.          
C25923                                                                  
C25923     MOVE WS-MONEY-ORDER                TO YB-CURRENCY-TYPE.      
C25923     MOVE ZERO                          TO WS-BANK-TRANS.         
C25923     MOVE ZERO                          TO WS-BANK-TRANS-TOTAL.   
C25923     PERFORM 5150-SUM-TRNSFRS           THRU 5150-EXIT.           
C25923     SUBTRACT WS-BANK-TRANS-TOTAL  FROM WS-CHECK-MO-AVL.          
C25923                                                                  
C25923     MOVE WS-DRAFT                      TO YB-CURRENCY-TYPE.      
C25923     MOVE ZERO                          TO WS-BANK-TRANS.         
C25923     MOVE ZERO                          TO WS-BANK-TRANS-TOTAL.   
C25923     PERFORM 5150-SUM-TRNSFRS           THRU 5150-EXIT.           
C25923     SUBTRACT WS-BANK-TRANS-TOTAL  FROM WS-CHECK-MO-AVL.          
C25923                                                                  
C25923     MOVE ZERO                          TO WS-BANK-TRANS.         
C25923     MOVE ZERO                          TO WS-BANK-TRANS-TOTAL.   
C25923     PERFORM 5175-SUM-OTHER             THRU 5175-EXIT.           
C25923     SUBTRACT WS-BANK-TRANS-TOTAL  FROM WS-OTHER-REC-AVL.         
C25923                                                                  
C25923*    MOVE WS-CASH                       TO YB-CURRENCY-TYPE.              
C25923*    PERFORM 5150-SUM-TRNSFRS                      THRU 5150-EXIT.        
C25923*                                                                         
C25923*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND                   
C25923*    WS-NULL-IND EQUAL ZERO THEN                                          
C25923*        SUBTRACT YB-TRANSFER-AMT       FROM WS-CASH-AVL                  
C25923*    END-IF.                                                              
C25923*                                                                         
C25923*    MOVE WS-CHECK                      TO YB-CURRENCY-TYPE.              
C25923*    PERFORM 5150-SUM-TRNSFRS                      THRU 5150-EXIT.        
C25923*                                                                         
C25923*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND                   
C25923*    WS-NULL-IND EQUAL ZERO THEN                                          
C25923*        SUBTRACT YB-TRANSFER-AMT       FROM WS-CHECK-MO-AVL              
C25923*    END-IF.                                                              
C25923*                                                                         
C25923*    MOVE WS-MONEY-ORDER                TO YB-CURRENCY-TYPE.              
C25923*    PERFORM 5150-SUM-TRNSFRS                      THRU 5150-EXIT.        
C25923*                                                                         
C25923*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND                   
C25923*    WS-NULL-IND EQUAL ZERO THEN                                          
C25923*        SUBTRACT YB-TRANSFER-AMT       FROM WS-CHECK-MO-AVL              
C25923*    END-IF.                                                              
C25923*                                                                         
C25923*    PERFORM 5175-SUM-OTHER                        THRU 5175-EXIT.        
C25923*                                                                         
C25923*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL AND                   
C25923*    WS-NULL-IND EQUAL ZERO THEN                                          
C25923*        SUBTRACT YB-TRANSFER-AMT       FROM WS-OTHER-REC-AVL             
C25923*    END-IF.                                                              
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5150-SUM-TRNSFRS                                               *        
      ******************************************************************        
       5150-SUM-TRNSFRS.                                                
                                                                        
C25923     PERFORM 7010-OPEN-BXFER-CURSOR      THRU 7010-EXIT.          
C25923     PERFORM 7020-FETCH-BXFER-CURSOR     THRU 7020-EXIT           
C25923             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C25923     PERFORM 7030-CLOSE-BXFER-CURSOR     THRU 7030-EXIT.          
                                                                        
C25923*    EXEC SQL                                                             
C25923*       SELECT SUM(TRANSFER_AMT)                                          
C25923*       INTO   :YB-TRANSFER-AMT:WS-NULL-IND                               
C25923*       FROM   CSS_BANK_TRANSFER                                          
C25923*       WHERE  CURRENCY_TYPE = :YB-CURRENCY-TYPE                          
C25923*       AND    CASH_DRAWER_ID = :YB-CASH-DRAWER-ID                        
C25923*       AND    DATE_CASH_REPORT = :YB-DATE-CASH-REPORT                    
C25923*       AND    CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE                  
C25923*       AND    CASH_COMPANY_NO = :YB-CASH-COMPANY-NO                      
C25923*    END-EXEC.                                                            
C25923*                                                                         
C25923*    MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.         
C25923*                                                                         
C25923*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN                  
C25923*        NEXT SENTENCE                                                    
C25923*    ELSE                                                                 
C25923*       MOVE '5150'                     TO ACTIVE-PARAGRAPH               
C25923*       MOVE PROGRAM-NAME               TO ABEND-PROGRAM                  
C25923*       MOVE 'SELECT'                   TO ABEND-FUNCTION                 
C25923*       MOVE 'CSS-BANK-TRANSFER'        TO TABLE-1                        
C25923*       MOVE 'CASH-LOCAL-OFFICE'        TO TABLE-ELEMENT-1                
C25923*       MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1              
C25923*       MOVE 'DATE-CASH-REPORT'         TO TABLE-ELEMENT-2                
C25923*       MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2              
C25923*       MOVE 'CASH-DRAWER-ID'           TO TABLE-ELEMENT-3                
C25923*       MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3              
C25923*                                                                         
C25923*       PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT        
C25923*       PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT        
C25923*    END-IF.                                                              
                                                                        
       5150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5175-SUM-OTHER                                                 *        
      ******************************************************************        
       5175-SUM-OTHER.                                                  
                                                                        
C25923     PERFORM 7040-OPEN-BXFER2-CURSOR     THRU 7040-EXIT.          
C25923     PERFORM 7050-FETCH-BXFER2-CURSOR    THRU 7050-EXIT           
C25923             UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
C25923     PERFORM 7060-CLOSE-BXFER2-CURSOR    THRU 7060-EXIT.          
                                                                        
C25923*    EXEC SQL                                                             
C25923*       SELECT SUM(TRANSFER_AMT)                                          
C25923*       INTO   :YB-TRANSFER-AMT:WS-NULL-IND                               
C25923*       FROM   CSS_BANK_TRANSFER                                          
C25923*       WHERE  CURRENCY_TYPE <> :WS-CHECK                                 
C25923*       AND    CURRENCY_TYPE <> :WS-CASH                                  
C25923*       AND    CURRENCY_TYPE <> :WS-MONEY-ORDER                           
C25923*       AND    CASH_DRAWER_ID = :YB-CASH-DRAWER-ID                        
C25923*       AND    DATE_CASH_REPORT = :YB-DATE-CASH-REPORT                    
C25923*       AND    CASH_LOCAL_OFFICE = :YB-CASH-LOCAL-OFFICE                  
C25923*       AND    CASH_COMPANY_NO = :YB-CASH-COMPANY-NO                      
C25923*    END-EXEC.                                                            
C25923*                                                                         
C25923*    MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE.         
C25923*                                                                         
C25923*    IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN                  
C25923*        NEXT SENTENCE                                                    
C25923*    ELSE                                                                 
C25923*       MOVE '5175'                     TO ACTIVE-PARAGRAPH               
C25923*       MOVE PROGRAM-NAME               TO ABEND-PROGRAM                  
C25923*       MOVE 'SELECT'                   TO ABEND-FUNCTION                 
C25923*       MOVE 'CSS-BANK-TRANSFER'        TO TABLE-1                        
C25923*       MOVE 'CASH-LOCAL-OFFICE'        TO TABLE-ELEMENT-1                
C25923*       MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1              
C25923*       MOVE 'DATE-CASH-REPORT'         TO TABLE-ELEMENT-2                
C25923*       MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2              
C25923*       MOVE 'CASH-DRAWER-ID'           TO TABLE-ELEMENT-3                
C25923*       MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3              
C25923*                                                                         
C25923*       PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT        
C25923*       PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT        
C25923*    END-IF.                                                              
                                                                        
       5175-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7000-SELECT-CLRCASH                                            *        
      ******************************************************************        
       7000-SELECT-CLRCASH.                                             
                                                                        
           EXEC SQL                                                     
              SELECT GL_ACCT_NO                                         
              INTO   :GO-GL-ACCT-NO                                     
              FROM   CSS_GL_ACCT_NO                                     
              WHERE  GL_ACCT_NAME = :GO-GL-ACCT-NAME                    
              AND    COMPANY_NO = :GO-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS-GL-ACCT-NO'           TO TABLE-1                
              MOVE 'COMPANY-NO'               TO TABLE-ELEMENT-1        
              MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
              MOVE 'GL-ACCT-NAME'             TO TABLE-ELEMENT-2        
              MOVE GO-GL-ACCT-NAME            TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
C25923******************************************************************        
C25923*    7010-OPEN-BXFER-CURSOR                                      *        
      *    TO OPEN THE BXFER_CURSOR                                    *        
      ******************************************************************        
       7010-OPEN-BXFER-CURSOR.                                          
           EXEC SQL                                                     
                OPEN  BXFER_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7010'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE YB-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7020-FETCH-BXFER-CURSOR                                     *        
      *    TO FETCH THE BXFER_CURSOR                                   *        
      ******************************************************************        
       7020-FETCH-BXFER-CURSOR.                                         
           EXEC SQL                                                     
              FETCH BXFER_CURSOR                                        
               INTO :WS-BANK-TRANS :WS-NULL-IND                         
                    ,:YB-CODE-DR-CR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF WS-NULL-IND < ZERO                                 
                     MOVE 0                    TO WS-BANK-TRANS         
                  ELSE                                                  
                     IF YB-CODE-DR-CR = WS-C                            
                        MULTIPLY -1 BY WS-BANK-TRANS                    
                     END-IF                                             
                  END-IF                                                
                  ADD WS-BANK-TRANS            TO WS-BANK-TRANS-TOTAL   
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7020'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE YB-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7030-CLOSE-BXFER-CURSOR                                     *        
      *    TO CLOSE THE BXFER_CURSOR                                   *        
      ******************************************************************        
       7030-CLOSE-BXFER-CURSOR.                                         
           EXEC SQL                                                     
                CLOSE  BXFER_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7030'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE YB-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7040-OPEN-BXFER2-CURSOR                                     *        
      *    TO OPEN THE BXFER2_CURSOR                                   *        
      ******************************************************************        
       7040-OPEN-BXFER2-CURSOR.                                         
           EXEC SQL                                                     
                OPEN  BXFER2_CURSOR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7040'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE YB-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7050-FETCH-BXFER2-CURSOR                                    *        
      *    TO FETCH THE BXFER2_CURSOR                                  *        
      ******************************************************************        
       7050-FETCH-BXFER2-CURSOR.                                        
           EXEC SQL                                                     
              FETCH BXFER2_CURSOR                                       
               INTO :WS-BANK-TRANS :WS-NULL-IND                         
                    ,:YB-CODE-DR-CR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR               
               WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                  IF WS-NULL-IND < ZERO                                 
                     MOVE 0                    TO WS-BANK-TRANS         
                  ELSE                                                  
                     IF YB-CODE-DR-CR = WS-C                            
                        MULTIPLY -1 BY WS-BANK-TRANS                    
                     END-IF                                             
                  END-IF                                                
                  ADD WS-BANK-TRANS            TO WS-BANK-TRANS-TOTAL   
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                   ABEND-TABLES         
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE YB-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7060-CLOSE-BXFER2-CURSOR                                    *        
      *    TO CLOSE THE BXFER2_CURSOR                                  *        
      ******************************************************************        
       7060-CLOSE-BXFER2-CURSOR.                                        
           EXEC SQL                                                     
                CLOSE  BXFER2_CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7060'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_BANK_TRANSFER'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-4       
               MOVE YB-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE YB-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE YB-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               MOVE YB-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-4     
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
           END-IF.                                                      
                                                                        
C25923 7060-EXIT.                                                       
C25923     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-OPEN-I5CURSOR                                             *        
      ******************************************************************        
       7100-OPEN-I5CURSOR.                                              
                                                                        
           EXEC SQL                                                     
              OPEN I5-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN CURSOR'              TO ABEND-FUNCTION         
              MOVE 'IT-CURSOR'                TO TABLE-1                
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7150-FETCH-I5CURSOR                                            *        
      ******************************************************************        
       7150-FETCH-I5CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH I5-CURSOR                                           
              INTO  :I5-GL-ACCT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND THEN                                            
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7150'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH CURSOR'             TO ABEND-FUNCTION         
              MOVE 'I5-CURSOR'                TO TABLE-1                
              MOVE 'COMPANY-NO'               TO TABLE-ELEMENT-1        
              MOVE I5-COMPANY-NO              TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7150-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7175-CLOSE-I5CURSOR                                            *        
      ******************************************************************        
       7175-CLOSE-I5CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE I5-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7175'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE CURSOR'             TO ABEND-FUNCTION         
              MOVE 'I5-CURSOR'                TO TABLE-1                
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7175-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-OPEN-CJCURSOR                                             *        
      ******************************************************************        
       7200-OPEN-CJCURSOR.                                              
                                                                        
           EXEC SQL                                                     
              OPEN CJ-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7200'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'OPEN CURSOR'              TO ABEND-FUNCTION         
              MOVE 'CJ-CURSOR'                TO TABLE-1                
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7250-FETCH-CJCURSOR                                            *        
      ******************************************************************        
       7250-FETCH-CJCURSOR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH CJ-CURSOR                                           
              INTO  :CJ-TRAN-DATA,                                      
                    :CJ-CURRENCY-TYPE                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
           OR NOT-FOUND THEN                                            
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN      
                   ADD 1                      TO CURSOR-CTR-ROWS        
               END-IF                                                   
           ELSE                                                         
              MOVE '7250'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'FETCH CURSOR'             TO ABEND-FUNCTION         
              MOVE 'CJ-CURSOR'                TO TABLE-1                
              MOVE 'CASH-LOCAL-OFFICE'        TO TABLE-ELEMENT-1        
              MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE-CASH-REPORT'         TO TABLE-ELEMENT-2        
              MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2      
              MOVE 'CASH-DRAWER-ID'           TO TABLE-ELEMENT-3        
              MOVE CJ-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7250-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7275-CLOSE-CJCURSOR                                            *        
      ******************************************************************        
       7275-CLOSE-CJCURSOR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE CJ-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7275'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'CLOSE CURSOR'             TO ABEND-FUNCTION         
              MOVE 'CJ-CURSOR'                TO TABLE-1                
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7275-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-BEGBAL                                             *        
      ******************************************************************        
       7300-SELECT-BEGBAL.                                              
                                                                        
           EXEC SQL                                                     
              SELECT AMT_CASH_BEGIN_BAL                                 
              INTO   :CS-AMT-CASH-BEGIN-BAL                             
              FROM   CSS_CSH_DRWR_CNTL                                  
              WHERE  CASH_COMPANY_NO = :CS-CASH-COMPANY-NO              
              AND    CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE          
              AND    DATE_CASH_REPORT = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )            
              AND    CASH_DRAWER_ID = :CS-CASH-DRAWER-ID                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT AMT_CASH_BEGIN_BAL                                         
MFA-TR*       INTO   :CS-AMT-CASH-BEGIN-BAL                                     
MFA-TR*       FROM   CSS_CSH_DRWR_CNTL                                          
MFA-TR*       WHERE  CASH_COMPANY_NO = :CS-CASH-COMPANY-NO                      
MFA-TR*       AND    CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                  
MFA-TR*       AND    DATE_CASH_REPORT = :CS-DATE-CASH-REPORT                    
MFA-TR*       AND    CASH_DRAWER_ID = :CS-CASH-DRAWER-ID                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS-CSH-DRWR-CNTL'        TO TABLE-1                
              MOVE 'CASH-LOCAL-OFFICE'        TO TABLE-ELEMENT-1        
              MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-1      
              MOVE 'DATE-CASH-REPORT'         TO TABLE-ELEMENT-2        
              MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-2      
              MOVE 'CASH-DRAWER-ID'           TO TABLE-ELEMENT-2        
              MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3      
                                                                        
              PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT
              PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900-JOURNALING / ERROR HANDLING INCLUDE                       *        
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *      END PROGRAM COPYLIB                                       *        
      ******************************************************************        
REARCH*COPY CPD00302.                                                           
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
