       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02389.                                         
COB303 DATE-WRITTEN.  SEPTEMBER 02, 1999.                               
       DATE-COMPILED.                                                   
      *                                                                 00050000
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S389                                           *00120001
      *  PROGRAM:       S389                                           *00130001
      *  CALLING SP:    PA_S389                                        *00140002
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE CREATES A NEW BATCH IN THE CASH DRAWER CONTROL *00190002
      *  TABLE AND ALSO OPENS A CASH REPORT IF NOT ALREADY OPENED FOR  *        
      *  THE REPORT DATE.                                              *00190002
      *  ALSO UPDATES THE CASH DRAWER CONTROL TABLE FOR A CHANGE IN    *        
      *  CASHIER CODE.                                                 *        
      ******************************************************************00210000
      *                                                                *00220000
      *                     PROGRAM MODIFICATION LOG                   *00230000
      *                                                                *00240000
      *    DATE    INITIALS   COMMENTS                                 *00250000
      *  --------  --------   ---------------------------------------  *00260000
      *  09/02/99    CBSI     PROCEDURE ORIGINALLY CODED.              *00270002
      *              MDRS.                                             *00270002
T19917*  11/26/99    CBSI     PROCEDURE CHANGED TO CHECK FOR           *        
T19917*              MDRS.    FOR AR-LOCKOUT-IND.                      *        
T21911*  05/03/00    DPS      ADDED CHECK FOR CHANGE IN LOCAL OFFICE   *        
T21911*                       AFTER OPENING BATCH PANEL.                        
REARCH*  06/20/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
T35434*  10/30/07   MK92804   REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED 'WITH UR' FOR SINGLETON SELECTS*        
P00552*  07/10/12  BASKAR V   CHANGES MADE FOR THIRD PARTY/EPAY        *        
P00552*                       CORRECTIONS MODIFICATION PROJECT         *        
P00586*  06/17/13  AP40911    PC-ID FIELD LENGTH INCREASED.            *        
      ******************************************************************00290000
      ******************************************************************00320000
      ******************************************************************00330000
      *                                                                *00340000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00350000
      *                                                                *00360000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00370000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00380000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00390000
      *  3000 - 4999  NOT USED                                         *00400000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00410000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00420000
      *  7000 - 7999  INPUT MODULES                                    *00430000
      *  8000 - 8999  OUTPUT MODULES                                   *00440000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00450000
      *                                                                *00460000
      ******************************************************************00470000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02389'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02389 STARTS HERE'.                  
                                                                        
      ******************************************************************01080000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01090000
      ******************************************************************01100000
                                                                        
          COPY CCA00001.                                                01150000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
          COPY CWS00011.                                                01150000
          COPY CWS00027.                                                01160000
          COPY CWS00303.                                                01170000
                                                                        
      ******************************************************************01240000
      *    WORK AREAS                                                  *01250000
      ******************************************************************01260000
                                                                        
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                 PIC X(26)                       
REARCH                                      VALUE 'SESSION.CSR02389_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH          49 GTT-ROW-LEN          PIC S9(04) COMP.                
REARCH          49 GTT-ROW-CHAR         PIC X(1024).                    
REARCH     05  GTT-SQLCODE              PIC S9(9) COMP.                 
REARCH*                                                                         
       01  FILLER                       PIC X(11) VALUE 'PARM FIELDS'.  
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                 PIC S9(9) COMP.                 
           05  SNA-CONNECTION-NAME      PIC X(8)  VALUE SPACES.         
                                                                        
       01  COUNTER-FLAG.                                                
           05  WS-CSH-RPT-HDR-FLAG      PIC X(01) VALUE 'N'.            
           05  CTR-COLUMN               PIC S9(9) COMP VALUE 1.         
           05  CTR-ROWS                 PIC S9(9) COMP VALUE 0.         
      *    05  WS-INACTIVE-COUNT-FLAG   PIC X(01) VALUE 'N'.            01940000
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM          PIC S9(9) COMP.                 
           05  WRKLEN1                  PIC S9(9) COMP.                 
           05  WRKLEN2                  PIC S9(9) COMP.                 
           05  WRK-DONE-STATUS          PIC S9(9) COMP.                 
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME             PIC X(8)  VALUE 'CSR02389'.     
REARCH     05  WS-SQLSTATE              PIC X(05)  VALUE  SPACES.       
           05  WS-INSERT-BATCH-FLAG     PIC X(01) VALUE 'Y'.            
           05  WS-CSH-RPT-HDR-STATUS    PIC X(01).                      
           05  WS-USER-ID               PIC X(07).                      
                                                                        
       01  WS-NULL-INDICATOR.                                           
           05 WS-NULL-INDICATOR1        PIC S9(04) COMP VALUE +0.       
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                   PIC X(01) VALUE 'Y'.            
           05  WS-NO                    PIC X(01) VALUE 'N'.            
           05  WS-ONE                   PIC S9    COMP VALUE 1.         
           05  WS-MAX-BATCH-COUNT       PIC S9(4) COMP VALUE 1000.      
           05  WS-ACTIVE-CODE           PIC X(01) VALUE 'A'.            
           05  WS-INACTIVE-CODE         PIC X(01) VALUE 'C'.            
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05   S-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                PIC X(18)      VALUE SPACES.    
REARCH     10  S-SQLCODE                PIC S9(9) COMP VALUE 0.         
REARCH     10  S-SQLSTATE               PIC X(5)       VALUE ' '.       
REARCH     10  S-TABLE-NAME             PIC X(18)      VALUE SPACES.    
REARCH     10  S-HOST-VARIABLES.                                        
REARCH          49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.           
REARCH          49  S-HOST-VARIABLES-V  PIC X(255).                     
REARCH     10  S-SQL-STATEMENT.                                         
REARCH          49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-STATEMENT-V   PIC X(255).                     
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH          49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.           
REARCH          49  S-SQL-DESCRIPTION-V PIC X(255).                     
REARCH*                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************00560000
      *    DB2 INCLUDES                                                *00570000
      ******************************************************************00580000
                                                                        
           EXEC SQL                                                     00600000
              INCLUDE SQLCA                                             00610000
           END-EXEC.                                                    00620000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBCDCNTL                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBCSRPHD                                          00850000
           END-EXEC.                                                    00860000
                                                                        
           EXEC SQL                                                     00840000
              INCLUDE TBCSPCID                                          00850000
           END-EXEC.                                                    00860000
                                                                        
T19917     EXEC SQL                                                             
T19917        INCLUDE TBARLOCK                                                  
T19917     END-EXEC.                                                            
                                                                        
T21911     EXEC SQL                                                             
T21911         INCLUDE TBCSHIER                                                 
T21911     END-EXEC.                                                            
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-USER-ID             PIC X(7).                            
COB305 01 PARM-WORKING-FUNDS        PIC S9(13)V9(2) USAGE COMP-3 
COB305       VALUE 0.        
REARCH 01 PARM-CASHIER-CODE        PIC X(2).                            
REARCH 01 PARM-NEW-CASHIER-CODE    PIC X(2).                            
REARCH 01 PARM-REPORT-DATE         PIC X(10).                           
REARCH 01 PARM-CHANGE-CODE-FLAG    PIC X(01).                           
REARCH 01 PARM-OPEN-BATCH-FLAG     PIC X(01).                           
REARCH 01 PARM-COMPANY-NO          PIC X(2).                            
REARCH 01 PARM-LOCAL-OFFICE        PIC X(3).                            
REARCH 01 PARM-REPORT-NO           PIC X(3).                            
P00586 01 PARM-PC-ID               PIC X(15).                           
REARCH*                                                                         
HPCCDM*EJECT                                                                    
REARCH PROCEDURE DIVISION USING     PARM-USER-ID                        
REARCH                              PARM-WORKING-FUNDS                  
REARCH                              PARM-CASHIER-CODE                   
REARCH                              PARM-NEW-CASHIER-CODE               
REARCH                              PARM-REPORT-DATE                    
REARCH                              PARM-CHANGE-CODE-FLAG               
REARCH                              PARM-OPEN-BATCH-FLAG                
REARCH                              PARM-COMPANY-NO                     
REARCH                              PARM-LOCAL-OFFICE                   
REARCH                              PARM-REPORT-NO                      
REARCH                              PARM-PC-ID.                         
                                                                        
      ******************************************************************02140000
      * 0000-MAINLINE                                                  *02150000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02160000
      ******************************************************************02170000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE              THRU 0100-EXIT.         
           PERFORM 1000-PROCESS-INPUT           THRU 1000-EXIT.         
           PERFORM 2000-PROCESS-OUTPUT          THRU 2000-EXIT.         
           PERFORM 9999-END-PROGRAM             THRU 9999-EXIT.         
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02290000
      * 0100-INITIALIZE                                                *02300000
      *                                                                *02310000
      *     1. RESET DB2 ERROR HANDLERS                                *02320000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02330000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02340000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02350000
      *                                                                *02360000
      ******************************************************************02370000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH              RETURN_CODE                                         
REARCH          FROM                                                    
REARCH              #CSR02389_R1                                 
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*             RETURN_CODE                                                 
MFA-TR*         FROM                                                            
MFA-TR*             SESSION.CSR02389_R1                                         
MFA-TR*    END-EXEC.                                                            
REARCH                                                                  
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************02530000
REARCH* 0100A-DECLARE-GTT.                                             *02540000
REARCH******************************************************************02890000
REARCH 0100A-DECLARE-GTT.                                               
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02389_R1'            
REARCH                                 TO S-SQL-STATEMENT-V.            
REARCH*                                                                         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02389_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02389_R1
              (                                                       
REARCH             RETURN_CODE              INT                     
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                     TO WS-SQLSTATE.            
REARCH     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH            PERFORM 8000A-DELETE-GTT-ROWS                         
REARCH                                       THRU 8000A-EXIT            
REARCH     ELSE                                                         
REARCH            IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL            
REARCH               NEXT SENTENCE                                      
REARCH            ELSE                                                  
REARCH               MOVE PROGRAM-NAME       TO ABEND-PROGRAM           
REARCH               MOVE SQLCODE            TO ABEND-SQLCODE           
REARCH               MOVE SQLSTATE           TO ABEND-SQLSTATE          
REARCH               MOVE '0100A'            TO ACTIVE-PARAGRAPH        
REARCH               MOVE 'DECLARE GTT'      TO ABEND-FUNCTION          
REARCH               MOVE SPACES             TO ABEND-SQL-PREDICATES    
REARCH                                          ABEND-TABLES            
REARCH               MOVE 'CSR02389_R1'      TO TABLE-1                 
REARCH               MOVE SPACES             TO TABLE-ELEMENT-1         
REARCH               MOVE SPACES             TO HOSTVAR-ELEMENT-1       
REARCH               PERFORM 9900-SQL-ERROR-ROUTINE                     
REARCH                                              THRU  9900-EXIT     
REARCH            END-IF                                                
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH   0100A-EXIT.                                                    
REARCH        EXIT.                                                     
REARCH*                                                                         
      ******************************************************************02650000
      * 1000-PROCESS-INPUT                                             *02660000
      *     1. RECEIVE PARMS.                                          *02680000
      ******************************************************************02700000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           MOVE WS-ACTIVE-CODE                  TO CS-CODE-CSH-DRWR-STAT
           MOVE PARM-USER-ID                    TO CS-USER-ID,          
                                                   YR-USER-ID           
           MOVE PARM-WORKING-FUNDS              TO CS-AMT-BASIC-WORK,   
                                                   CS-AMT-CASH-BEGIN-BAL
           MOVE PARM-CASHIER-CODE               TO CS-CASHIER-CODE      
           MOVE PARM-REPORT-DATE                TO CS-DATE-CASH-REPORT, 
                                                   YR-DATE-CASH-REPORT, 
                                                   CS-DATE-LAST-ACTIVITY
           MOVE PARM-COMPANY-NO                 TO CS-CASH-COMPANY-NO,  
                                                   YR-CASH-COMPANY-NO,  
                                                   Y3-CASH-COMPANY-NO   
           MOVE PARM-LOCAL-OFFICE               TO CS-CASH-LOCAL-OFFICE,
                                                   YR-CASH-LOCAL-OFFICE,
                                                   Y3-CASH-LOCAL-OFFICE 
           MOVE PARM-REPORT-NO                  TO CS-CASH-REPORT-NO.   
           MOVE PARM-PC-ID                      TO Y3-CASH-PC-ID.       
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05110000
      * 2000-PROCESS-OUTPUT.                                           *05120000
      *                                                                *05130000
      *     1. DESCRIBE RESULT SET                                     *05130000
      *     2. BUILD THE RESULT SET                                    *05150000
      *     3. SEND RESULT SET                                         *05170000
      *                                                                *05180000
      ******************************************************************05190000
      *                                                                 05200000
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                          TO ACTIVE-PARAGRAPH.    
                                                                        
T19917     PERFORM 7999-SELECT-AL               THRU                    
T19917                                          7999-SELECT-AL-EXIT.    
T19917     IF  AL-AR-LOCKOUT-IND = WS-YES                               
T19917         MOVE 5000                        TO   RS-RETURN-CODE     
REARCH         PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT         
T19917         PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
T19917         PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
T19917     END-IF.                                                      
T21911     PERFORM 7800-SELECT-CASHIER          THRU 7800-EXIT.         
T21911     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
T21911         MOVE 2000                        TO RS-RETURN-CODE       
REARCH         PERFORM 2000A-MOVE-RESULT        THRU 2000A-EXIT         
T21911         PERFORM 8100-SEND-RESULT         THRU 8100-EXIT          
T21911         PERFORM 9999-END-PROGRAM         THRU 9999-EXIT          
T21911     ELSE                                                         
T21911         NEXT SENTENCE                                            
T21911     END-IF.                                                      
           PERFORM 2200-BUILD-RESULT            THRU 2200-EXIT.         
REARCH     PERFORM 2000A-MOVE-RESULT            THRU 2000A-EXIT         
           PERFORM 8100-SEND-RESULT             THRU 8100-EXIT.         
      *                                                                 05270000
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE              TO S-RETURN-CODE.           
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ***************************************************************           
      * 2200-BUILD-RESULT                                           *           
      *     BUILD THE RESULT SET                                    *           
      *         CHECK IF BATCH IS TO BE OPENED                      *           
      *              CHECK CASH REPORT HEADER STATUS                *           
      *              RETURN 1000 IF CASH REPORT HEADER IS CLOSED    *           
      *              IF CASH REPORT HEADER NOT FOUND INSERT ONE     *           
      *              INITIALIZE THE HOST VARIABLES FOR INSERTING    *           
      *                 INTO CASH DRAWER CNTL.                      *           
      *              INSERT NEW ROW INTO CASH DRAWER CNTL           *           
      *         CHECK IF CASHIER-CODE IS CHANGED                    *           
      *              UPDATE BATCHES IN CASH DRAWER CNTL WITH        *           
      *                 NEW CASHIER CODE                            *           
      *         RETURN                                              *           
      *                                                             *           
      ***************************************************************           
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           IF PARM-OPEN-BATCH-FLAG = WS-YES                             
               PERFORM 7100-SELECT-STATUS       THRU 7100-EXIT          
                                                                        
               IF WS-CSH-RPT-HDR-FLAG = WS-NO                           
                   PERFORM 2250-INITIALIZE-HOST THRU 2250-EXIT          
                   PERFORM 7200-INSERT-CASHREPORT                       
                                                THRU 7200-EXIT          
               ELSE                                                     
                   IF WS-CSH-RPT-HDR-STATUS = WS-INACTIVE-CODE          
                       MOVE 1000                TO RS-RETURN-CODE       
                       MOVE WS-NO               TO WS-INSERT-BATCH-FLAG 
                   END-IF                                               
               END-IF                                                   
                                                                        
               IF WS-INSERT-BATCH-FLAG = WS-YES                         
                   PERFORM 2300-INITIALIZE-HOST-VARIABLES               
                                                THRU 2300-EXIT          
                                                                        
                   PERFORM 7500-INSERT-CASHDRWR THRU 7500-EXIT          
               END-IF                                                   
           END-IF.                                                      
                                                                        
           IF PARM-CHANGE-CODE-FLAG = WS-YES                            
               PERFORM 7600-UPDATE-CASHDRWR      THRU 7600-EXIT         
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INITIALIZE HOST VARIABLES.                                  *           
      ***************************************************************           
                                                                        
       2250-INITIALIZE-HOST.                                            
                                                                        
           MOVE '2250'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           MOVE    WS-ACTIVE-CODE               TO YR-STATUS.           
           PERFORM 7700-GET-CURRENT-TIMESTAMP   THRU 7700-EXIT.         
                                                                        
       2250-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INITIALIZE HOST VARIABLES.                                  *           
      ***************************************************************           
                                                                        
       2300-INITIALIZE-HOST-VARIABLES.                                  
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
           INITIALIZE CS-CASH-DRAWER-ID.                                
                                                                        
           PERFORM 7300-SELECT-CASHDRAWERID     THRU 7300-EXIT.         
           ADD  WS-ONE                          TO CS-CASH-DRAWER-ID.   
                                                                        
           INITIALIZE CS-CODE-PYMT-FACILITY                             
           PERFORM 7400-SELECT-PYMTFACLTY       THRU 7400-EXIT          
                                                                        
           MOVE WS-NO                           TO CS-CODE-FCS-EXTRACTED
                                                                        
           INITIALIZE  CS-AMT-CASH-DEBIT,                               
                       CS-AMT-CASH-CREDIT,                              
                       CS-AMT-AR-DEBIT,                                 
                       CS-AMT-AR-CREDIT,                                
                       CS-AMT-CK-ISS-DEBIT,                             
                       CS-AMT-CK-ISS-CREDIT,                            
                       CS-AMT-GL-DEBIT,                                 
                       CS-AMT-GL-CREDIT,                                
                       CS-NO-ITEMS-ENTERED.                             
                                                                        
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * SELECT THE COUNT OF CSS_CSH_REPORT_HDR FOR REPORT DATE      *           
      ***************************************************************           
                                                                        
       7100-SELECT-STATUS.                                              
                                                                        
           MOVE '7100'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             SELECT :WS-YES,                                            
                    STATUS                                              
             INTO   :WS-CSH-RPT-HDR-FLAG,                               
                    :WS-CSH-RPT-HDR-STATUS                              
             FROM   CSS_CSH_REPORT_HDR WITH(READUNCOMMITTED)                    
             WHERE  CASH_COMPANY_NO      = :YR-CASH-COMPANY-NO          
             AND    CASH_LOCAL_OFFICE    = :YR-CASH-LOCAL-OFFICE        
             AND    DATE_CASH_REPORT     = IIF(TRY_CONVERT(DATE, 
                                                   :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) )         
P00552                                                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT :WS-YES,                                                    
MFA-TR*             STATUS                                                      
MFA-TR*      INTO   :WS-CSH-RPT-HDR-FLAG,                                       
MFA-TR*             :WS-CSH-RPT-HDR-STATUS                                      
MFA-TR*      FROM   CSS_CSH_REPORT_HDR                                  70000   
MFA-TR*      WHERE  CASH_COMPANY_NO      = :YR-CASH-COMPANY-NO                  
MFA-TR*      AND    CASH_LOCAL_OFFICE    = :YR-CASH-LOCAL-OFFICE                
MFA-TR*      AND    DATE_CASH_REPORT     = :YR-DATE-CASH-REPORT                 
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_REPORT_HDR'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE YR-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YR-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YR-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
                                                                        
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT INTO CSS_CSH_REPORT_HDR                              *           
      ***************************************************************           
                                                                        
       7200-INSERT-CASHREPORT.                                          
                                                                        
           MOVE '7200'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_CSH_REPORT_HDR                            
                (                                                       
                          CASH_COMPANY_NO,                              
                          CASH_LOCAL_OFFICE,                            
                          DATE_CASH_REPORT,                             
                          USER_ID,                                      
                          STATUS,                                       
                          CLOSED_TS                                     
                )                                                       
              VALUES                                                    
                (                                                       
                          :YR-CASH-COMPANY-NO,                          
                          :YR-CASH-LOCAL-OFFICE,                        
                          IIF(TRY_CONVERT(DATE, :YR-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :YR-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:YR-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:YR-DATE-CASH-REPORT
              ), CONVERT(DATE, :YR-DATE-CASH-REPORT) ),                        
                          :YR-USER-ID,                                  
                          :YR-STATUS,                                   
                          CIS.CHAR2TIMESTAMP(:YR-CLOSED-TS)                     
                )                                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_CSH_REPORT_HDR                                    
MFA-TR*         (                                                               
MFA-TR*                   CASH_COMPANY_NO,                                      
MFA-TR*                   CASH_LOCAL_OFFICE,                                    
MFA-TR*                   DATE_CASH_REPORT,                                     
MFA-TR*                   USER_ID,                                              
MFA-TR*                   STATUS,                                               
MFA-TR*                   CLOSED_TS                                             
MFA-TR*         )                                                               
MFA-TR*       VALUES                                                            
MFA-TR*         (                                                               
MFA-TR*                   :YR-CASH-COMPANY-NO,                                  
MFA-TR*                   :YR-CASH-LOCAL-OFFICE,                                
MFA-TR*                   :YR-DATE-CASH-REPORT,                                 
MFA-TR*                   :YR-USER-ID,                                          
MFA-TR*                   :YR-STATUS,                                           
MFA-TR*                   :YR-CLOSED-TS                                         
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'INSERT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_REPORT_HDR'        TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE 'USER_ID'                   TO TABLE-ELEMENT-4      
               MOVE YR-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE YR-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE YR-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
               MOVE YR-USER-ID                  TO HOSTVAR-ELEMENT-4    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * DETERMINE BATCH NUMBER.                                     *           
      ***************************************************************           
                                                                        
       7300-SELECT-CASHDRAWERID.                                        
                                                                        
           MOVE '7300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             SELECT MAX(CASH_DRAWER_ID)                                 
             INTO   :CS-CASH-DRAWER-ID :WS-NULL-INDICATOR1               
             FROM   CSS_CSH_DRWR_CNTL WITH(READUNCOMMITTED)                     
             WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO           
             AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE         
             AND    DATE_CASH_REPORT    = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )          
P00552       AND    CASH_DRAWER_ID      < 9000                          
P00552                                                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT MAX(CASH_DRAWER_ID)                                         
MFA-TR*      INTO   :CS-CASH-DRAWER-ID:WS-NULL-INDICATOR1                       
MFA-TR*      FROM   CSS_CSH_DRWR_CNTL                                   70000   
MFA-TR*      WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO                   
MFA-TR*      AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE                 
MFA-TR*      AND    DATE_CASH_REPORT    = :CS-DATE-CASH-REPORT                  
MFA-TR*      AND    CASH_DRAWER_ID      < 9000                                  
MFA-TR*      QUERYNO 7300                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               IF  WS-NULL-INDICATOR1 < ZERO                            
                   MOVE 0                       TO CS-CASH-DRAWER-ID    
               END-IF                                                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_DRWR_CNTL'         TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-3      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-3    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * GET CODE PAYMENT FACILITY FROM CASH PC ID TABLE             *           
      ***************************************************************           
                                                                        
       7400-SELECT-PYMTFACLTY.                                          
                                                                        
           MOVE '7400'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
                                                                        
             SELECT CODE_PYMT_FACILITY                                  
             INTO   :CS-CODE-PYMT-FACILITY                              
             FROM   CSS_CASH_PC_ID WITH(READUNCOMMITTED)                        
             WHERE  CASH_COMPANY_NO     = :Y3-CASH-COMPANY-NO           
             AND    CASH_LOCAL_OFFICE   = :Y3-CASH-LOCAL-OFFICE         
             AND    CASH_PC_ID          = :Y3-CASH-PC-ID                
P00552                                                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*      SELECT CODE_PYMT_FACILITY                                          
MFA-TR*      INTO   :CS-CODE-PYMT-FACILITY                                      
MFA-TR*      FROM   CSS_CASH_PC_ID                                              
MFA-TR*      WHERE  CASH_COMPANY_NO     = :Y3-CASH-COMPANY-NO                   
MFA-TR*      AND    CASH_LOCAL_OFFICE   = :Y3-CASH-LOCAL-OFFICE                 
MFA-TR*      AND    CASH_PC_ID          = :Y3-CASH-PC-ID                        
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*      WITH UR                                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT CODE_PYMT'          TO ABEND-FUNCTION       
               MOVE 'CSS_CASH_PC_ID'            TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'CASH_PC_ID'                TO TABLE-ELEMENT-3      
               MOVE Y3-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE Y3-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE Y3-CASH-PC-ID               TO HOSTVAR-ELEMENT-3    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * INSERT NEW BATCH INTO CASH DRAWER CNTL.                     *           
      ***************************************************************           
                                                                        
       7500-INSERT-CASHDRWR.                                            
                                                                        
           MOVE '7500'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
             INSERT INTO CSS_CSH_DRWR_CNTL(                             
                         CASH_COMPANY_NO,                               
                         CASH_LOCAL_OFFICE,                             
                         CASH_REPORT_NO,                                
                         DATE_CASH_REPORT,                              
                         CASH_DRAWER_ID,                                
                         AMT_CASH_DEBIT,                                
                         AMT_CASH_CREDIT,                               
                         AMT_AR_DEBIT,                                  
                         AMT_AR_CREDIT,                                 
                         AMT_CK_ISS_DEBIT,                              
                         AMT_CK_ISS_CREDIT,                             
                         AMT_GL_DEBIT,                                  
                         AMT_GL_CREDIT,                                 
                         AMT_CASH_BEGIN_BAL,                            
                         AMT_BASIC_WORK,                                
                         USER_ID,                                       
                         CASHIER_CODE,                                  
                         CODE_PYMT_FACILITY,                            
                         CODE_FCS_EXTRACTED,                            
                         CODE_CSH_DRWR_STAT,                            
                         DATE_LAST_ACTIVITY,                            
                         NO_ITEMS_ENTERED)                              
             VALUES(                                                    
                         :CS-CASH-COMPANY-NO,                           
                         :CS-CASH-LOCAL-OFFICE,                         
                         :CS-CASH-REPORT-NO,                            
                         IIF(TRY_CONVERT(DATE, :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) ),                        
                         :CS-CASH-DRAWER-ID,                            
                         :CS-AMT-CASH-DEBIT,                            
                         :CS-AMT-CASH-CREDIT,                           
                         :CS-AMT-AR-DEBIT,                              
                         :CS-AMT-AR-CREDIT,                             
                         :CS-AMT-CK-ISS-DEBIT,                          
                         :CS-AMT-CK-ISS-CREDIT,                         
                         :CS-AMT-GL-DEBIT,                              
                         :CS-AMT-GL-CREDIT,                             
                         :CS-AMT-CASH-BEGIN-BAL,                        
                         :CS-AMT-BASIC-WORK,                            
                         :CS-USER-ID,                                   
                         :CS-CASHIER-CODE,                              
                         :CS-CODE-PYMT-FACILITY,                        
                         :CS-CODE-FCS-EXTRACTED,                        
                         :CS-CODE-CSH-DRWR-STAT,                        
                         IIF(TRY_CONVERT(DATE, :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) ),                      
                         :CS-NO-ITEMS-ENTERED)                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO CSS_CSH_DRWR_CNTL(                                     
MFA-TR*                  CASH_COMPANY_NO,                                       
MFA-TR*                  CASH_LOCAL_OFFICE,                                     
MFA-TR*                  CASH_REPORT_NO,                                        
MFA-TR*                  DATE_CASH_REPORT,                                      
MFA-TR*                  CASH_DRAWER_ID,                                        
MFA-TR*                  AMT_CASH_DEBIT,                                        
MFA-TR*                  AMT_CASH_CREDIT,                                       
MFA-TR*                  AMT_AR_DEBIT,                                          
MFA-TR*                  AMT_AR_CREDIT,                                         
MFA-TR*                  AMT_CK_ISS_DEBIT,                                      
MFA-TR*                  AMT_CK_ISS_CREDIT,                                     
MFA-TR*                  AMT_GL_DEBIT,                                          
MFA-TR*                  AMT_GL_CREDIT,                                         
MFA-TR*                  AMT_CASH_BEGIN_BAL,                                    
MFA-TR*                  AMT_BASIC_WORK,                                        
MFA-TR*                  USER_ID,                                               
MFA-TR*                  CASHIER_CODE,                                          
MFA-TR*                  CODE_PYMT_FACILITY,                                    
MFA-TR*                  CODE_FCS_EXTRACTED,                                    
MFA-TR*                  CODE_CSH_DRWR_STAT,                                    
MFA-TR*                  DATE_LAST_ACTIVITY,                                    
MFA-TR*                  NO_ITEMS_ENTERED)                                      
MFA-TR*      VALUES(                                                            
MFA-TR*                  :CS-CASH-COMPANY-NO,                                   
MFA-TR*                  :CS-CASH-LOCAL-OFFICE,                                 
MFA-TR*                  :CS-CASH-REPORT-NO,                                    
MFA-TR*                  :CS-DATE-CASH-REPORT,                                  
MFA-TR*                  :CS-CASH-DRAWER-ID,                                    
MFA-TR*                  :CS-AMT-CASH-DEBIT,                                    
MFA-TR*                  :CS-AMT-CASH-CREDIT,                                   
MFA-TR*                  :CS-AMT-AR-DEBIT,                                      
MFA-TR*                  :CS-AMT-AR-CREDIT,                                     
MFA-TR*                  :CS-AMT-CK-ISS-DEBIT,                                  
MFA-TR*                  :CS-AMT-CK-ISS-CREDIT,                                 
MFA-TR*                  :CS-AMT-GL-DEBIT,                                      
MFA-TR*                  :CS-AMT-GL-CREDIT,                                     
MFA-TR*                  :CS-AMT-CASH-BEGIN-BAL,                                
MFA-TR*                  :CS-AMT-BASIC-WORK,                                    
MFA-TR*                  :CS-USER-ID,                                           
MFA-TR*                  :CS-CASHIER-CODE,                                      
MFA-TR*                  :CS-CODE-PYMT-FACILITY,                                
MFA-TR*                  :CS-CODE-FCS-EXTRACTED,                                
MFA-TR*                  :CS-CODE-CSH-DRWR-STAT,                                
MFA-TR*                  :CS-DATE-LAST-ACTIVITY,                                
MFA-TR*                  :CS-NO-ITEMS-ENTERED)                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'INSERT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_DRWR_CNTL'         TO TABLE-1              
               MOVE 'CASH_COMPANY_NO'           TO TABLE-ELEMENT-1      
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-2      
               MOVE 'CASH_DRAWER_ID'            TO TABLE-ELEMENT-3      
               MOVE 'DATE_CASH_REPORT'          TO TABLE-ELEMENT-4      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE CS-CASH-LOCAL-OFFICE        TO HOSTVAR-ELEMENT-2    
               MOVE CS-CASH-DRAWER-ID           TO HOSTVAR-ELEMENT-3    
               MOVE CS-DATE-CASH-REPORT         TO HOSTVAR-ELEMENT-4    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************           
      * UPDATE ALL BATCHES FOR REPORT DATE WITH NEW CASHIER CODE    *           
      ***************************************************************           
                                                                        
       7600-UPDATE-CASHDRWR.                                            
                                                                        
           MOVE '7600'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_CSH_DRWR_CNTL                                  
              SET    CASHIER_CODE        = :PARM-NEW-CASHIER-CODE,      
                     DATE_LAST_ACTIVITY  = IIF(TRY_CONVERT(DATE, 
                                                 :CS-DATE-LAST-ACTIVITY
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-LAST-ACTIVITY
              ) <> 0) OR (LEN(:CS-DATE-LAST-ACTIVITY
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-LAST-ACTIVITY
              ), CONVERT(DATE, :CS-DATE-LAST-ACTIVITY) )       
              WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO          
              AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE        
              AND    USER_ID             = :CS-USER-ID                  
              AND    CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT       
P00552                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_CSH_DRWR_CNTL                                          
MFA-TR*       SET    CASHIER_CODE        = :PARM-NEW-CASHIER-CODE,              
MFA-TR*              DATE_LAST_ACTIVITY  = :CS-DATE-LAST-ACTIVITY               
MFA-TR*       WHERE  CASH_COMPANY_NO     = :CS-CASH-COMPANY-NO                  
MFA-TR*       AND    CASH_LOCAL_OFFICE   = :CS-CASH-LOCAL-OFFICE                
MFA-TR*       AND    USER_ID             = :CS-USER-ID                          
MFA-TR*       AND    CODE_CSH_DRWR_STAT  = :CS-CODE-CSH-DRWR-STAT               
MFA-TR*       QUERYNO 7600                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR           
               WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                    
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'UPDATE'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CSH_DRWR_CNTL'         TO TABLE-1              
               MOVE 'CASH_LOCAL_OFFICE'         TO TABLE-ELEMENT-1      
               MOVE 'USER_ID'                   TO TABLE-ELEMENT-2      
               MOVE 'CODE_CSH_DRWR_STAT'        TO TABLE-ELEMENT-3      
               MOVE 'CASHIER_CODE'              TO TABLE-ELEMENT-4      
               MOVE CS-CASH-COMPANY-NO          TO HOSTVAR-ELEMENT-1    
               MOVE CS-USER-ID                  TO HOSTVAR-ELEMENT-2    
               MOVE CS-CODE-CSH-DRWR-STAT       TO HOSTVAR-ELEMENT-3    
               MOVE PARM-NEW-CASHIER-CODE       TO HOSTVAR-ELEMENT-4    
                                                                        
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7700-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
T35434        SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :YR-CLOSED-TS                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :YR-CLOSED-TS = CURRENT TIMESTAMP                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                         TO WS-ACTIVE-RETURN-CODE
           IF  WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL              
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE '7700'                      TO ACTIVE-PARAGRAPH     
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
T35434         MOVE 'SET'                       TO ABEND-FUNCTION       
               PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT          
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
              EXEC SQL                                                          
                 INCLUDE CPD0023C                                               
              END-EXEC.                                                         
                                                                        
T21911***************************************************************           
T21911* CHECK LOCAL OFFICE FOR CHANGE SINCE PANEL OPENED            *           
T21911***************************************************************           
                                                                        
       7800-SELECT-CASHIER.                                             
           MOVE '7800' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT USER_ID                                            
              INTO  :WS-USER-ID                                         
              FROM CSS_CASHIER WITH(READUNCOMMITTED)                            
              WHERE USER_ID = :CS-USER-ID                               
               AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE           
P00552                                                      
T35434                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     04950000
MFA-TR*       SELECT USER_ID                                            04950000
MFA-TR*       INTO  :WS-USER-ID                                                 
MFA-TR*       FROM CSS_CASHIER                                          04950000
MFA-TR*       WHERE USER_ID = :CS-USER-ID                               04950000
MFA-TR*        AND  CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                   
MFA-TR*       QUERYNO 7800                                                      
MFA-TR*       WITH UR                                                           
MFA-TR*    END-EXEC.                                                    04950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
            OR WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE       TO RS-RETURN-CODE       
               MOVE SPACES                      TO ABEND-TABLES         
               MOVE SPACES                      TO ABEND-SQL-PREDICATES 
               MOVE '7800'                      TO ACTIVE-PARAGRAPH     
               MOVE PROGRAM-NAME                TO ABEND-PROGRAM        
               MOVE 'SELECT'                    TO ABEND-FUNCTION       
               MOVE 'CSS_CASHIER'               TO TABLE-1              
              PERFORM 9700-PROCESS-ABEND       THRU 9700-EXIT
           END-IF.          
        7800-EXIT.                                                      
             EXIT.                                                      
                                                                        
T19917******************************************************************        
T19917* 7999-SELECT-AL                                                 *        
T19917******************************************************************        
T19917        EXEC SQL                                                          
T19917           INCLUDE CPD00075                                               
T19917        END-EXEC.                                                         
T19917                                                                  
REARCH****************************************************************  12310000
REARCH* 8000A-DELETE-GTT-ROWS.                                       *  12320000
REARCH****************************************************************  12330000
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH                                                                  
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          DELETE FROM #CSR02389_R1                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02389_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH                                                                  
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH         MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
REARCH         MOVE SQLCODE               TO ABEND-SQLCODE              
REARCH         MOVE '8000A'               TO ACTIVE-PARAGRAPH           
REARCH         MOVE 'DELETE'              TO ABEND-FUNCTION             
REARCH         MOVE SPACES                TO ABEND-SQL-PREDICATES       
REARCH                                          ABEND-TABLES            
REARCH         MOVE 'CSR02389_R1'         TO TABLE-1                    
REARCH         MOVE SPACES                TO TABLE-ELEMENT-1            
REARCH         MOVE SPACES                TO HOSTVAR-ELEMENT-1          
REARCH         PERFORM 9000-SEND-ERROR-RESULT                           
REARCH                                    THRU 9000-EXIT                
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                    THRU 9900-EXIT                
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 8000A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
REARCH****************************************************************  12310000
REARCH* 8100-SEND-RESULT.                                            *  12320000
REARCH****************************************************************  12330000
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02389_R1                         
REARCH          (                                                       
REARCH                RETURN_CODE                                       
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH                :S-RETURN-CODE                                    
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02389_R1                                 
MFA-TR*         (                                                               
MFA-TR*               RETURN_CODE                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*               :S-RETURN-CODE                                            
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH          ADD +1                    TO CTR-ROWS                   
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
REARCH          MOVE SQLCODE              TO ABEND-SQLCODE              
REARCH          MOVE '8100'               TO ACTIVE-PARAGRAPH           
REARCH          MOVE 'INSERT'             TO ABEND-FUNCTION             
REARCH          MOVE SPACES               TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH          MOVE 'CSR02389_R1'        TO TABLE-1                    
REARCH          MOVE SPACES               TO TABLE-ELEMENT-1            
REARCH          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH     END-IF.                                                      
REARCH                                                                  
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
      ****************************************************************  16263003
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     16265003
      ****************************************************************  16267003
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
      ****************************************************************  16310003
      *       END PROGRAM COPYLIB                                       16330003
      ****************************************************************  16360003
REARCH*COPY CPD00302.                                                   16361003
                                                                        
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00320                                                 
REARCH     END-EXEC.                                                            
