       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02385.                                         
COB303 DATE-WRITTEN.      JULY 13, 1995                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S385 CONVERTED TO DB2 SP CSR02385 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S385                                           *        
      *  PROGRAM:       S385                                           *        
      *  CALLING SP:    PA_S385                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM CREATES A IS CALLED AS EITHER A RETRIEVE OR AN   *        
      *  UPDATE.  WHEN CALLED AS A RETRIEVE, THE RPC RETURNS ALL OF    *        
      *  THE ACCT NUMBERS OF THE SUB ACCTS ASSOCIATED WITH THE MASTER. *        
      *  WHEN CALLED AS AN UPDATE, IT UPDATES THE RATE SCHEDULE IN     *        
      *  CSS_MKT_XREF_ACCT FOR THE MASTER AND ALL SUB ACCTS.           *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  07/13/99    AMG      PROCEDURE ORIGINALLY CODED.              *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02385'.
MSQ017     COPY MFASQLM.
       01  WS-START                           PIC X(40) VALUE           
           'WORKING STORAGE FOR RPC S385 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      * INCLUDE CSS_MKT_XREF_ACCOUNT, XM                                        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_MSTSUB_ACCT, MU                                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBMSTSUB                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE CSS_ACCOUNT, AT                                                 
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * INCLUDE FOR SQLCA                                                       
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
CVT999*    COPY CWS00010.                                                       
           COPY CWS00303.                                                       
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'S385    '.     
           05  WS-RETRIEVE              PIC X(01) VALUE 'R'.            
           05  WS-UPDATE                PIC X(01) VALUE 'U'.            
           05  WS-MASTER                PIC X(01) VALUE 'M'.            
           05  WS-SUB                   PIC X(01) VALUE 'S'.            
           05  WS-MST-ACCT-NO           PIC X(13) VALUE SPACES.         
           05  WS-SUB-ACCT-NO           PIC X(13) VALUE SPACES.         
           05  WS-ACCT-NO-DISP          PIC X(13) VALUE SPACES.         
           05  WS-ACTIVE                PIC X(01) VALUE 'A'.            
           05  WS-PENDING               PIC X(01) VALUE 'P'.            
                                                                        
       01  WS-LITERALS.                                                 
           05  WS-Y                     PIC X(01) VALUE 'Y'.            
           05  WS-N                     PIC X(01) VALUE 'N'.            
                                                                        
       01  WS-SWITCHES.                                                 
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
           05  SW-RESULTS               PIC X(01) VALUE 'Y'.            
               88 NO-MORE-RESULTS                 VALUE 'N'.            
               88 MORE-RESULTS                    VALUE 'Y'.            
           05  SW-FETCH                 PIC X(01) VALUE 'Y'.            
               88 NO-MORE-ROWS                    VALUE 'N'.            
               88 MORE-ROWS                       VALUE 'Y'.            
           05  SUB-ACCT-SW              PIC X(01) VALUE 'Y'.            
               88 NO-MORE-SUBS                    VALUE 'N'.            
               88 MORE-SUBS                       VALUE 'Y'.            
      *                                                                         
       01  CS-LIB-MISC-FIELDS.                                          
           05  WS-CSL-CMD-HANDLE       pIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CON-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CTX-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-RC               PIC S9(9) COMP.                  
           05  WS-CSL-RESTYPE          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-ITEM-NUM             PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED-NULL          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR            PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR-NULL       PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-NUMROWS              PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-RC               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-SUCCESS          PIC S9(9) COMP SYNC VALUE +0.    
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                     POINTER.                            
CVT999*    05  GWL-INIT-HANDLE              PIC S9(9) COMP VALUE +0.            
CVT999*    05  GWL-RC                       PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-NR                PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-DONE              PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-COUNT             PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-COMM              PIC S9(9) COMP.                     
CVT999*    05  GWL-STATUS-RETURN-CODE       PIC S9(9) COMP.                     
           05  GWL-STATUS-SUBCODE           PIC S9(9) COMP.             
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                   PIC S9(9) COMP.                 
CVT999*    05  PARM-ID1                 PIC S9(9) COMP VALUE 1.                 
           05  PARM-EXEC-MODE           PIC X(01) VALUE SPACES.         
           05  PARM-MST-SUB-IND         PIC X(01) VALUE SPACES.         
           05  PARM-ACCOUNT-NO          PIC X(13) VALUE SPACES.         
           05  PARM-NEW-RATE-SCHED      PIC X(03) VALUE SPACES.         
                                                                        
       01  WS-DATAFMT.                                                  
           05 WS-NM-PARM               PIC X(132).                      
           05 WS-NMLEM-PARM            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-PARM            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-PARM        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-PARM            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-PARM         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-PARM           PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-DATAFMT-BIND.                                             
           05 WS-NM-BIND               PIC X(132).                      
           05 WS-NMLEM-BIND            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-BIND            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-BIND        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-BIND            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-BIND         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-BIND           PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-SERVER-MSG.                                               
           05 WS-SM-MSGNO              PIC S9(9) COMP SYNC.             
           05 WS-SM-STATE              PIC S9(9) COMP SYNC.             
           05 WS-SM-SEVERITY           PIC S9(9) COMP SYNC.             
           05 WS-SM-TEXT               PIC X(256).                      
           05 WS-SM-TEXT-LEN           PIC S9(9) COMP SYNC.             
           05 WS-SM-SVRNAME            PIC X(256).                      
           05 WS-SM-SVRNAME-LEN        PIC S9(9) COMP SYNC.             
           05 WS-SM-PROC               PIC X(256).                      
           05 WS-SM-PROC-LEN           PIC S9(9) COMP SYNC.             
           05 WS-SM-LINE               PIC S9(9) COMP SYNC.             
           05 WS-SM-STATUS             PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-CLIENT-MSG.                                               
           05 WS-CM-SEVERITY           PIC S9(9) COMP SYNC.             
           05 WS-CM-OC-MSGNO           PIC S9(9) COMP SYNC.             
           05 WS-CM-OC-MSGTEXT         PIC X(256).                      
           05 WS-SM-OC-MSGTEXT-LEN     PIC S9(9) COMP SYNC.             
           05 WS-CM-OS-MSGNO           PIC S9(9) COMP SYNC.             
           05 WS-CM-OS-MSGTEXT         PIC X(256).                      
           05 WS-CM-OS-MSGTEXT-LEN     PIC S9(9) COMP SYNC.             
           05 WS-CM-STATUS             PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-MSGNO                    PIC S9(9) COMP VALUE +1.         
       01  WS-DATALEN                  PIC S9(9) COMP SYNC VALUE +0.    
       01  WS-INDIC                    PIC S9(9) COMP SYNC VALUE +0.    
       01  WS-RETURN-STATUS            PIC S9(4) COMP VALUE +0.         
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP VALUE 0.     
           05  RS-ACCOUNT-NO                PIC X(13) VALUE SPACES.     
           05  RS-ACTIVE-IND                PIC X(01) VALUE SPACES.     
                                                                        
       01  CN-COLUMN-NAMES-380.                                         
           05  CN-RETURN-CODE               PIC X(11) VALUE             
                                                   'RETURN_CODE'.       
           05  CN-ACCOUNT-NO                PIC X(10) VALUE             
                                                   'ACCOUNT_NO'.        
           05  CN-ACTIVE-IND                PIC X(10) VALUE             
                                                   'ACTIVE-IND'.        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
CVT999*    05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACES.             
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.             
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM              PIC S9(9) COMP.                     
CVT999*    05  WRKLEN1                      PIC S9(9) COMP.                     
CVT999*    05  WRKLEN2                      PIC S9(9) COMP.                     
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
      *                                                                         
HPCCDM*EJECT                                                                    
      *                                                                         
      ******************************************************************        
      *    DECLARE MU-MASTER-CURSOR FOR CSS_MSTSUB_ACCT TABLE          *        
      ******************************************************************        
           EXEC SQL DECLARE MU-MASTER-CURSOR CURSOR FOR                 
               SELECT MU.SUB_ACCT_NO,                                   
                      AT.CODE_ACCT_STAT                                 
                 FROM CSS_MSTSUB_ACCT    MU,                            
                      CSS_ACCOUNT        AT                             
                WHERE MU.MST_ACCT_NO     = :MU-MST-ACCT-NO              
                  AND MU.SUB_ACCT_NO     = AT.ACCOUNT_NO                
                  AND AT.CODE_ACCT_STAT  IN (:WS-ACTIVE, :WS-PENDING)   
           END-EXEC.                                                    
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-EXEC-MODE           PIC X(01)                .          
CVT000 01  LINK-MST-SUB-IND         PIC X(01)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-NEW-RATE-SCHED      PIC X(03)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-EXEC-MODE                                          
CVT000         ,LINK-MST-SUB-IND                                        
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-NEW-RATE-SCHED                                     
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE            THRU 0100-EXIT.           
           PERFORM 1000-PROCESS-INPUT         THRU 1000-EXIT.           
           PERFORM 2000-PROCESS-OUTPUT        THRU 2000-EXIT.           
           PERFORM 9999-END-PROGRAM           THRU 9999-EXIT.           
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND   CONTINUE END-EXEC.                     
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*      MOVE PROGRAM-NAME                  TO ABEND-PROGRAM                
CVT999*      MOVE '0100'                        TO ACTIVE-PARAGRAPH             
CVT999*      MOVE 'CICS TRANSACTION'            TO TABLE-1                      
CVT999*      MOVE 'TDRESULT - NO RPC PARM SENT' TO TABLE-2                      
CVT999*      MOVE GWL-RC                        TO WS-ACTIVE-RETURN-CODE        
CVT999*      PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT                  
CVT999*      PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT                  
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-ACCOUNT-NO               AS    ACCOUNT_NO             
CVT000       ,:RS-ACTIVE-IND               AS    ACTIVE_IND             
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-ACCOUNT-NO               AS    ACCOUNT_NO                     
MFA-TR*      ,:RS-ACTIVE-IND               AS    ACTIVE_IND                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-EXEC-MODE            TO PARM-EXEC-MODE           . 
CVT000     MOVE LINK-MST-SUB-IND          TO PARM-MST-SUB-IND         . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-NEW-RATE-SCHED       TO PARM-NEW-RATE-SCHED      . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT.                                            *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 1100-RECEIVE-PARMS         THRU 1100-EXIT.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 1100-RECEIVE-PARMS                                            *         
      *                                                               *         
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE          *         
      *                                                               *         
      *****************************************************************         
       1100-RECEIVE-PARMS.                                              
                                                                        
           MOVE '1100'                        TO ACTIVE-PARAGRAPH.      
                                                                        
CVT999*    MOVE 1                             TO PARM-ID1.                      
CVT999*    MOVE LENGTH OF PARM-EXEC-MODE      TO MAX-LENGTH-PARM,               
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-EXEC-MODE,                                
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                             TO PARM-ID1.                      
CVT999*    MOVE LENGTH OF PARM-MST-SUB-IND    TO MAX-LENGTH-PARM,               
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-MST-SUB-IND,                              
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                             TO PARM-ID1.                      
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO     TO MAX-LENGTH-PARM,               
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
CVT999*    ADD  1                             TO PARM-ID1.                      
CVT999*    MOVE LENGTH OF PARM-NEW-RATE-SCHED TO MAX-LENGTH-PARM,               
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-NEW-RATE-SCHED,                           
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. BUILD RESULT SET                                        *        
      *     4. SEND RESULT SET                                         *        
      *                                                                *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 2100-DESCRIBE-RESULT       THRU 2100-EXIT.           
           PERFORM 2200-BUILD-RESULT          THRU 2200-EXIT.           
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *        
      *                                                                *        
      ******************************************************************        
       2100-DESCRIBE-RESULT.                                            
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CN-RETURN-CODE     TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-RETURN-CODE,                                
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ACCOUNT-NO     TO WRKLEN1.                         
CVT999*    MOVE LENGTH OF CN-ACCOUNT-NO     TO WRKLEN2.                         
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACCOUNT-NO,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ACCOUNT-NO,                                 
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                          
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-ACTIVE-IND     TO WRKLEN1.                         
CVT999*    MOVE LENGTH OF CN-ACTIVE-IND     TO WRKLEN2.                         
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-ACTIVE-IND,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CN-ACTIVE-IND,                                 
CVT999*                          WRKLEN2.                                       
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      *  2200-BUILD-RESULT                                            *         
      *                                                               *         
      *****************************************************************         
       2200-BUILD-RESULT.                                               
                                                                        
      *****************************************************************         
      *    CHECK TO SEE IF THE ACCOUNT THAT WAS GIVEN IS A MASTER               
      *    ACCOUNT OR A SUB ACCOUNT.  IF IT IS A MASTER, THEN PROCEED           
      *    FORWARD.  IF IT IS A SUB, FIRST GET THE ASSOCIATED MASTER            
      *    ACCOUNT NUMBER, AND THEN PROCEED FORWARD.                            
      *****************************************************************         
           IF PARM-MST-SUB-IND                   = WS-MASTER            
              MOVE PARM-ACCOUNT-NO               TO WS-MST-ACCT-NO      
           ELSE                                                         
              IF PARM-MST-SUB-IND                = WS-SUB               
                 MOVE PARM-ACCOUNT-NO            TO MU-SUB-ACCT-NO      
                 PERFORM 8515-GET-MST-ACCT-NO    THRU 8515-EXIT         
                 MOVE MU-MST-ACCT-NO             TO WS-MST-ACCT-NO      
              END-IF                                                    
           END-IF.                                                      
                                                                        
      *****************************************************************         
      *    OPEN THE CURSOR FOR CSS_MSTSUB_ACCT                                  
      *    NOTE:  THIS IS DONE BEFORE 5000 FOR ERROR PROCESSING                 
      *    SO THAT 8525 WILL NOT TRY TO CLOSE THE CURSOR WHEN IT                
      *    MIGHT NOT YET BE OPEN.  (8525 IS CALLED FROM 5000 AND 5010)          
      *****************************************************************         
           MOVE WS-MST-ACCT-NO                   TO MU-MST-ACCT-NO      
           PERFORM 7100-OPEN-MST-CURSOR          THRU 7100-EXIT         
                                                                        
      *****************************************************************         
      *    1ST PROCESS THE MASTER ACCOUNT...                                    
      *****************************************************************         
           PERFORM 5000-PROCESS-MST-ACCT         THRU 5000-EXIT         
                                                                        
      *****************************************************************         
      *    ...2ND PROCESS THE SUB ACCOUNTS                                      
      *****************************************************************         
           PERFORM 7200-FETCH-MST-CURSOR         THRU 7200-EXIT         
           IF WS-ACTIVE-RETURN-CODE              = NOT-FOUND            
              NEXT SENTENCE                                             
           ELSE                                                         
              PERFORM 5010-PROCESS-SUB-ACCTS     THRU 5010-EXIT         
                 UNTIL NO-MORE-SUBS                                     
           END-IF.                                                      
                                                                        
           PERFORM 7300-CLOSE-MST-CURSOR         THRU 7300-EXIT         
                                                                        
      *****************************************************************         
      *    IF THIS WAS AN UPDATE, SEND ONLY ONE ROW BACK WHICH INCLUDES         
      *    THE MASTER ACCOUNT NUMBER AS PART OF THE RESULT SET.                 
      *****************************************************************         
           IF PARM-EXEC-MODE                     = WS-UPDATE            
              MOVE WS-MST-ACCT-NO                TO RS-ACCOUNT-NO       
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5000-PROCESS-MST-ACCT                                          *        
      *                                                                *        
      ******************************************************************        
       5000-PROCESS-MST-ACCT.                                           
                                                                        
           IF PARM-EXEC-MODE                     = WS-UPDATE            
              MOVE PARM-NEW-RATE-SCHED           TO XM-RATE-SCHEDULE    
              MOVE WS-MST-ACCT-NO                TO XM-ACCOUNT-NO       
              PERFORM 8525-UPDATE-RATE-SCHEDULE  THRU 8525-EXIT         
           ELSE                                                         
              MOVE WS-MST-ACCT-NO                TO RS-ACCOUNT-NO       
              PERFORM 8100-SEND-RESULT           THRU 8100-EXIT         
           END-IF.                                                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5010-PROCESS-SUB-ACCTS                                         *        
      *                                                                *        
      ******************************************************************        
       5010-PROCESS-SUB-ACCTS.                                          
                                                                        
           IF PARM-EXEC-MODE                        = WS-UPDATE         
              MOVE WS-SUB-ACCT-NO                   TO XM-ACCOUNT-NO    
              PERFORM 8525-UPDATE-RATE-SCHEDULE     THRU 8525-EXIT      
           ELSE                                                         
              IF AT-CODE-ACCT-STAT                  = WS-ACTIVE         
                 MOVE WS-Y                          TO RS-ACTIVE-IND    
              ELSE                                                      
                 MOVE WS-N                          TO RS-ACTIVE-IND    
              END-IF                                                    
              MOVE WS-SUB-ACCT-NO                   TO RS-ACCOUNT-NO    
              PERFORM 8100-SEND-RESULT              THRU 8100-EXIT      
           END-IF.                                                      
                                                                        
           PERFORM 7200-FETCH-MST-CURSOR            THRU 7200-EXIT.     
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7100-OPEN-MST-CURSOR                                           *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-OPEN-MST-CURSOR.                                            
                                                                        
           MOVE '7100'                     TO ACTIVE-PARAGRAPH          
                                                                        
           EXEC SQL                                                     
               OPEN MU-MASTER-CURSOR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_MSTSUB_ACCT'      TO TABLE-1                   
               MOVE 'MST_ACCT_NO'          TO TABLE-ELEMENT-1           
               MOVE WS-MST-ACCT-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7200-FETCH-MST-CURSOR                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-FETCH-MST-CURSOR.                                           
                                                                        
           MOVE '7200'                     TO ACTIVE-PARAGRAPH          
                                                                        
           EXEC SQL                                                     
              FETCH  MU-MASTER-CURSOR                                   
               INTO  :MU-SUB-ACCT-NO,                                   
                     :AT-CODE-ACCT-STAT                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE MU-SUB-ACCT-NO            TO WS-SUB-ACCT-NO          
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE       = NOT-FOUND                
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME           TO ABEND-PROGRAM           
                 MOVE 'FETCH'                TO ABEND-FUNCTION          
                 MOVE 'CSS_MSTSUB_ACCT'      TO TABLE-1                 
                 MOVE 'MST_ACCT_NO'          TO TABLE-ELEMENT-1         
                 MOVE WS-MST-ACCT-NO         TO HOSTVAR-ELEMENT-1       
                 PERFORM 7300-CLOSE-MST-CURSOR            THRU 7300-EXIT
                 PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT
                 PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT
              END-IF                                                    
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE        = NOT-FOUND                  
               MOVE WS-N                   TO SUB-ACCT-SW               
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 7300-CLOSE-MST-CURSOR                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7300-CLOSE-MST-CURSOR.                                           
                                                                        
           MOVE '7300'                     TO ACTIVE-PARAGRAPH          
                                                                        
           EXEC SQL                                                     
               CLOSE MU-MASTER-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_MSTSUB_ACCT'      TO TABLE-1                   
               MOVE 'MST_ACCT_NO'          TO TABLE-ELEMENT-1           
               MOVE WS-MST-ACCT-NO         TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8515-GET-MST-ACCT-NO                                           *        
      *                                                                *        
      ******************************************************************        
       8515-GET-MST-ACCT-NO.                                            
                                                                        
           MOVE '8515'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              SELECT  MST_ACCT_NO                                       
                INTO  :MU-MST-ACCT-NO                                   
                FROM  CSS_MSTSUB_ACCT                                   
               WHERE  SUB_ACCT_NO = :MU-SUB-ACCT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'SELECT'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_MSTSUB_ACCT'         TO TABLE-1                
               MOVE 'SUB_ACCT_NO'             TO TABLE-ELEMENT-1        
               MOVE PARM-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8515-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 8525-UPDATE-RATE-SCHEDULE                                      *        
      *                                                                *        
      ******************************************************************        
       8525-UPDATE-RATE-SCHEDULE.                                       
                                                                        
           MOVE '8525'                        TO ACTIVE-PARAGRAPH.      
           MOVE XM-ACCOUNT-NO                 TO WS-ACCT-NO-DISP.       
                                                                        
           EXEC SQL                                                     
              UPDATE  CSS_MKT_XREF_ACCT                                 
                 SET  RATE_SCHEDULE         = :XM-RATE-SCHEDULE         
               WHERE  ACCOUNT_NO            = :XM-ACCOUNT-NO            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
                                                 ABEND-TABLES           
               MOVE 'CSS_MKT_XREF_ACCT'       TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
               MOVE WS-ACCT-NO-DISP           TO HOSTVAR-ELEMENT-1      
               PERFORM 7300-CLOSE-MST-CURSOR  THRU 7300-EXIT            
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8525-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
