       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02381.                                         
COB303 DATE-WRITTEN.     MAR  31, 1998.                                 
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S381 CONVERTED TO DB2 SP CSR02381 ON 03/06/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S381                                           *        
      *  PROGRAM:       S381                                           *        
      *  CALLING SP:    PA_S381                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM RETRIEVES THE DATA DISPLAYED BY THE CTI SERVE    *        
      *  APPLICATION                                                   *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/25/99  RTO        PROCEDURE ORIGINALLY CODED               *        
      *  06/29/99  RTO        FIXED COMPANY CODE AND NULL-IND PROBLEM  *        
      *  02/02/00  DHR        ADDED LAST-UPDATED-BY COLUMN                      
      *  06/06/13  MC95456    REMOVED UNUSED COPYBOOK CWS00056         *        
      *                                                                *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02381'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S381 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMODEL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBMRKOMF                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
CVT999*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
CVT999*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
CVT999*    COPY CWS00010.                                                       
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9) COMP.                  
CVT999*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
           05  PARM-STATUS             PIC  X(1) VALUE SPACES.          
                                                                        
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
CVT999*    05  CTR-ROWS                PIC S9(9) COMP VALUE 0.                  
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
CVT000     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME             PIC X(08) VALUE 'S381    '.     
           05  WS-STATUS                PIC X(01) VALUE SPACES.         
           05  WS-SEB-ACCT-NO           PIC S9(13) VALUE 0.             
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  GTT-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE           PIC S9(9) COMP  VALUE 0.        
            05  S-RETURN-CODE           PIC S9(9) COMP  VALUE 0.        
            05 RS-TRANS-ID-CD           PIC X(4) VALUE SPACES.          
            05 RS-TRANS-PRIORITY        PIC S9(4) COMP VALUE 0.         
            05 RS-RECEIVED-TS           PIC X(26) VALUE SPACES.         
            05 RS-TRANS-SEQ-NO          PIC S9(4) COMP VALUE 0.         
            05 RS-TRANS-STATUS-CD       PIC X(1) VALUE SPACES.          
            05 RS-TRANS-OCCURS-TS       PIC X(26) VALUE SPACES.         
            05 RS-DIST-ACCT-NO          PIC X(20) VALUE SPACES.         
            05 RS-SERV-ADDR-ST-NO       PIC X(15) VALUE SPACES.         
            05 RS-SERV-ADDR-ST-CARD     PIC X(01) VALUE SPACES.         
            05 RS-SERV-ADDR-ST-NAME     PIC X(23) VALUE  SPACES.        
            05 RS-SERV-ADDR-ST-THOR     PIC X(04) VALUE  SPACES.        
            05 RS-SERV-ADDR-ST-DIR      PIC X(02) VALUE  SPACES.        
            05 RS-SERV-ADDR-STRUCT      PIC X(15) VALUE  SPACES.        
            05 RS-SERV-ADDR-CITY        PIC X(19) VALUE  SPACES.        
            05 RS-SERV-ADDR-STATE       PIC X(02) VALUE  SPACES.        
            05 RS-SERV-ADDR-ZIP-CD      PIC X(05) VALUE  SPACES.        
            05 RS-CUST-NAME-IND         PIC X(01) VALUE  SPACES.        
            05 RS-CUST-NAME-FIRST       PIC X(15) VALUE  SPACES.        
            05 RS-CUST-NAME-MID         PIC X(15) VALUE  SPACES.        
            05 RS-CUST-NAME-LAST        PIC X(56) VALUE  SPACES.        
            05 RS-CUST-NAME-SFX         PIC X(04) VALUE  SPACES.        
            05 RS-CUST-SSN-NO           PIC X(09) VALUE  SPACES.        
            05 RS-CUST-AREA-CD          PIC X(3) VALUE SPACES.          
            05 RS-CUST-PHONE-NO         PIC X(8) VALUE SPACES.          
            05 RS-CUST-EXT-NO           PIC X(04) VALUE SPACES.         
            05 RS-TRAN-DATA1            PIC X(254) VALUE SPACES.        
            05 RS-TRAN-DATA2            PIC X(254) VALUE SPACES.        
            05 RS-TRAN-DATA3            PIC X(254) VALUE SPACES.        
            05 RS-TRAN-DATA4            PIC X(254) VALUE SPACES.        
            05 RS-SEB-ACCT-NO           PIC X(13) VALUE SPACES.         
            05 RS-SEB-COMPANY-NO        PIC X(02) VALUE SPACES.         
            05 RS-LAST-UPDATED-BY       PIC X(07) VALUE SPACES.         
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*     05 CNS-RETURN-CODE          PIC X(11) VALUE 'RETURN_CODE'.          
CVT999*     05 CNS-TRANS-ID-CD          PIC X(19) VALUE                         
CVT999*                                        'TRANSACTION_ID_CODE'.           
CVT999*     05 CNS-TRANS-PRIORITY       PIC X(14) VALUE                         
CVT999*                                        'TRANS_PRIORITY'.                
CVT999*     05 CNS-RECEIVED-TS          PIC X(18) VALUE                         
CVT999*                                        'RECEIVED_TIMESTAMP'.            
CVT999*     05 CNS-TRANS-SEQ-NO         PIC X(17) VALUE                         
CVT999*                                        'TRANS_SEQUENCE_NO'.             
CVT999*     05 CNS-TRANS-STATUS-CD      PIC X(17) VALUE                         
CVT999*                                        'TRANS_STATUS_CODE'.             
CVT999*     05 CNS-TRANS-OCCURS-TS      PIC X(22) VALUE                         
CVT999*                                      'TRANS_OCCURS_TIMESTAMP'.          
CVT999*     05 CNS-DIST-ACCT-NO         PIC X(19) VALUE                         
CVT999*                                        'DISTRIBUTED_ACCT_NO'.           
CVT999*     05 CNS-SERV-ADDR-ST-NO      PIC X(19) VALUE                         
CVT999*                                        'SERV_ADDR_STREET_NO'.           
CVT999*     05 CNS-SERV-ADDR-ST-CARD    PIC X(17) VALUE                         
CVT999*                                        'SERV_ADDR_ST_CARD'.             
CVT999*     05 CNS-SERV-ADDR-ST-NAME    PIC X(17) VALUE                         
CVT999*                                        'SERV_ADDR_ST_NAME'.             
CVT999*     05 CNS-SERV-ADDR-ST-THOR    PIC X(17) VALUE                         
CVT999*                                        'SERV_ADDR_ST_THOR'.             
CVT999*     05 CNS-SERV-ADDR-ST-DIR     PIC X(16) VALUE                         
CVT999*                                        'SERV_ADDR_ST_DIR'.              
CVT999*     05 CNS-SERV-ADDR-STRUCT     PIC X(19) VALUE                         
CVT999*                                        'SERV_ADDR_STRUCTURE'.           
CVT999*     05 CNS-SERV-ADDR-CITY       PIC X(14) VALUE                         
CVT999*                                        'SERV_ADDR_CITY'.                
CVT999*     05 CNS-SERV-ADDR-STATE      PIC X(15) VALUE                         
CVT999*                                        'SERV_ADDR_STATE'.               
CVT999*     05 CNS-SERV-ADDR-ZIP-CD     PIC X(18) VALUE                         
CVT999*                                        'SERV_ADDR_ZIP_CODE'.            
CVT999*     05 CNS-CUST-NAME-IND        PIC X(19) VALUE                         
CVT999*                                        'CUST_NAME_INDICATOR'.           
CVT999*     05 CNS-CUST-NAME-FIRST      PIC X(15) VALUE                         
CVT999*                                        'CUST_NAME_FIRST'.               
CVT999*     05 CNS-CUST-NAME-MID        PIC X(16) VALUE                         
CVT999*                                        'CUST_NAME_MIDDLE'.              
CVT999*     05 CNS-CUST-NAME-LAST       PIC X(14) VALUE                         
CVT999*                                        'CUST_NAME_LAST'.                
CVT999*     05 CNS-CUST-NAME-SFX        PIC X(16) VALUE                         
CVT999*                                        'CUST_NAME_SUFFIX'.              
CVT999*     05 CNS-CUST-SSN-NO          PIC X(11) VALUE                         
CVT999*                                        'CUST_SSN_NO'.                   
CVT999*     05 CNS-CUST-AREA-CD         PIC X(14) VALUE                         
CVT999*                                        'CUST_AREA_CODE'.                
CVT999*     05 CNS-CUST-PHONE-NO        PIC X(13) VALUE                         
CVT999*                                        'CUST_PHONE_NO'.                 
CVT999*     05 CNS-CUST-EXT-NO          PIC X(17) VALUE                         
CVT999*                                        'CUST_EXTENSION_NO'.             
CVT999*     05 CNS-TRAN-DATA1           PIC X(10) VALUE                         
CVT999*                                        'TRAN_DATA1'.                    
CVT999*     05 CNS-TRAN-DATA2           PIC X(10) VALUE                         
CVT999*                                        'TRAN_DATA2'.                    
CVT999*     05 CNS-TRAN-DATA3           PIC X(10) VALUE                         
CVT999*                                        'TRAN_DATA3'.                    
CVT999*     05 CNS-TRAN-DATA4           PIC X(10) VALUE                         
CVT999*                                        'TRAN_DATA4'.                    
CVT999*     05 CNS-SEB-ACCT-NO          PIC X(14) VALUE                         
CVT999*                                        'SEB_ACCOUNT_NO'.                
CVT999*     05 CNS-SEB-COMPANY-NO       PIC X(14) VALUE                         
CVT999*                                        'SEB_COMPANY_NO'.                
CVT999*     05 CNS-LAST-UPDATED-BY      PIC X(15) VALUE                         
CVT999*                                        'LAST_UPDATED_BY'.               
CVT999******************************************************************        
CVT999*    CURSOR DECLARATIONS                                         *        
CVT999******************************************************************        
           EXEC SQL DECLARE TJ-TRANOUT-CURSOR CURSOR FOR                
               SELECT TRANS_ID_CD,                                      
                      TRANS_PRIORITY,                                   
                      REPLACE(REPLACE(CONVERT(CHAR(26), RECEIVED_TS
           , 121), ' ', '-'), ':', '.') RECEIVED_TS,                           
                      TRANS_SEQ_NO,                                     
                      TRANS_STATUS_CD,                                  
                      REPLACE(REPLACE(CONVERT(CHAR(26), TRANS_OCCURS_TS
           , 121), ' ', '-'), ':', '.') TRANS_OCCURS_TS,                       
                      DIST_ACCT_NO,                                     
                      SERV_ADDR_ST_NO,                                  
                      SERV_ADDR_ST_CARD,                                
                      SERV_ADDR_ST_NAME,                                
                      SERV_ADDR_ST_THOR,                                
                      SERV_ADDR_ST_DIR,                                 
                      SERV_ADDR_STRUCT,                                 
                      SERV_ADDR_CITY,                                   
                      SERV_ADDR_STATE,                                  
                      SERV_ADDR_ZIP_CD,                                 
                      CUST_NAME_IND,                                    
                      CUST_NAME_FIRST,                                  
                      CUST_NAME_MID,                                    
                      CUST_NAME_LAST,                                   
                      CUST_NAME_SFX,                                    
                      CUST_SSN_NO,                                      
                      CUST_AREA_CD,                                     
                      CUST_PHONE_NO,                                    
                      CUST_EXT_NO,                                      
                      TRAN_DATA1,                                       
                      TRAN_DATA2,                                       
                      TRAN_DATA3,                                       
                      TRAN_DATA4,                                       
                      SEB_ACCT_NO,                                      
                      SEB_COMPANY_NO,                                   
                      LAST_UPDATED_BY                                   
                FROM CSS_MKT_TRAN_OUTMF                                 
                WHERE TRANS_STATUS_CD = :WS-STATUS                      
                ORDER BY TRANS_PRIORITY,                                
                         TRANS_ID_CD,                                   
                         TRANS_SEQ_NO                                   
                                                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL DECLARE TJ-TRANOUT-CURSOR CURSOR FOR                        
MFA-TR*        SELECT TRANS_ID_CD,                                              
MFA-TR*               TRANS_PRIORITY,                                           
MFA-TR*               RECEIVED_TS,                                              
MFA-TR*               TRANS_SEQ_NO,                                             
MFA-TR*               TRANS_STATUS_CD,                                          
MFA-TR*               TRANS_OCCURS_TS,                                          
MFA-TR*               DIST_ACCT_NO,                                             
MFA-TR*               SERV_ADDR_ST_NO,                                          
MFA-TR*               SERV_ADDR_ST_CARD,                                        
MFA-TR*               SERV_ADDR_ST_NAME,                                        
MFA-TR*               SERV_ADDR_ST_THOR,                                        
MFA-TR*               SERV_ADDR_ST_DIR,                                         
MFA-TR*               SERV_ADDR_STRUCT,                                         
MFA-TR*               SERV_ADDR_CITY,                                           
MFA-TR*               SERV_ADDR_STATE,                                          
MFA-TR*               SERV_ADDR_ZIP_CD,                                         
MFA-TR*               CUST_NAME_IND,                                            
MFA-TR*               CUST_NAME_FIRST,                                          
MFA-TR*               CUST_NAME_MID,                                            
MFA-TR*               CUST_NAME_LAST,                                           
MFA-TR*               CUST_NAME_SFX,                                            
MFA-TR*               CUST_SSN_NO,                                              
MFA-TR*               CUST_AREA_CD,                                             
MFA-TR*               CUST_PHONE_NO,                                            
MFA-TR*               CUST_EXT_NO,                                              
MFA-TR*               TRAN_DATA1,                                               
MFA-TR*               TRAN_DATA2,                                               
MFA-TR*               TRAN_DATA3,                                               
MFA-TR*               TRAN_DATA4,                                               
MFA-TR*               SEB_ACCT_NO,                                              
MFA-TR*               SEB_COMPANY_NO,                                           
MFA-TR*               LAST_UPDATED_BY                                           
MFA-TR*         FROM CSS_MKT_TRAN_OUTMF                                         
MFA-TR*         WHERE TRANS_STATUS_CD = :WS-STATUS                              
MFA-TR*         ORDER BY TRANS_PRIORITY,                                        
MFA-TR*                  TRANS_ID_CD,                                           
MFA-TR*                  TRANS_SEQ_NO                                           
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         DECLARE C1 CURSOR  FOR                        
CVT000         SELECT *                                                 
CVT000         FROM #CSR02381_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                        00000300
MFA-TR*        SELECT *                                                 00000400
MFA-TR*        FROM SESSION.CSR02381_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-STATUS              PIC  X(1)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-STATUS                                             
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      ******************************************************************        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
                                                                        
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                        
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     MOVE LINK-STATUS               TO PARM-STATUS              . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02381_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02381_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,TRANS_ID_CD CHAR(4)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,TRANS_PRIORITY           SMALLINT                        
CVT000        ,RECEIVED_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,TRANS_SEQ_NO             SMALLINT                        
CVT000        ,TRANS_STATUS_CD CHAR(1)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,TRANS_OCCURS_TS CHAR(26)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,DIST_ACCT_NO CHAR(20)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,SERV_ADDR_ST_NO CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,SERV_ADDR_ST_CARD CHAR(01)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,SERV_ADDR_ST_NAME CHAR(23)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,SERV_ADDR_ST_THOR CHAR(04)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,SERV_ADDR_ST_DIR CHAR(02)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,SERV_ADDR_STRUCT CHAR(15)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,SERV_ADDR_CITY CHAR(19)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,SERV_ADDR_STATE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,SERV_ADDR_ZIP_CD CHAR(05)  COLLATE 
                            LATIN1_GENERAL_100_BIN2                        
CVT000        ,CUST_NAME_IND CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,CUST_NAME_FIRST CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000        ,CUST_NAME_MID CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,CUST_NAME_LAST CHAR(56)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,CUST_NAME_SFX CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,CUST_SSN_NO CHAR(09)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CUST_AREA_CD CHAR(3)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,CUST_PHONE_NO CHAR(8)  COLLATE LATIN1_GENERAL_100_BIN2           
CVT000        ,CUST_EXT_NO CHAR(04)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,TRAN_DATA1 CHAR(254)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,TRAN_DATA2 CHAR(254)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,TRAN_DATA3 CHAR(254)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,TRAN_DATA4 CHAR(254)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,SEB_ACCT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000        ,SEB_COMPANY_NO CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2         
CVT000        ,LAST_UPDATED_BY CHAR(07)  COLLATE LATIN1_GENERAL_100_BIN2        
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
                  MOVE 'CSR03501_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *     CALLS 1100-RECEIVE-PARMS                                   *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
           PERFORM 1100-RECEIVE-PARMS THRU 1100-EXIT.                   
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1100-RECEIVE-PARMS                                             *        
      *     CALLS TDRCVPRM                                             *        
      *                                                                *        
      *     CALLED FROM 1000-PROCESS-INPUT                             *        
      *                                                                *        
      *     GET THE PASSED PARMS FROM THE CLIENT                       *        
      ******************************************************************        
                                                                        
       1100-RECEIVE-PARMS.                                              
CVT999*    MOVE 1                          TO PARM-ID1.                         
CVT999*    MOVE LENGTH OF PARM-STATUS      TO MAX-LENGTH-PARM,                  
CVT999*                                                                         
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          PARM-ID1,                                      
CVT999*                          PARM-STATUS,                                   
CVT999*                          TDSCHAR,                                       
CVT999*                          MAX-LENGTH-PARM,                               
CVT999*                          PARM-L.                                        
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           2200-BUILD-RESULT                                    *        
      *     CALLED FROM 0000-MAINLINE                                 *         
      *                                                                *        
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
      *      AND SENDS THEM BACK                                       *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2100-DESCRIBE-RESULT          THRU 2100-EXIT.        
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                          *         
      *                                                               *         
      *     CALLS 2110-DESC-RET-CODE                                  *         
      *           2140-DESC-CD-DATA                                   *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           *         
      *                                                               *         
      *      DESCRIBE EACH RESULT FIELD TO THE CLIENT                 *         
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
                                                                        
           MOVE '2110'                             TO ACTIVE-PARAGRAPH. 
                                                                        
CVT999*    MOVE 1                            TO CTR-COLUMN.                     
CVT999*    MOVE TDSINT4                      TO DB-HOST-TYPE.                   
CVT999*    MOVE TDSINT4                      TO DB-CLIENT-TYPE.                 
CVT999*    MOVE LENGTH OF RS-RETURN-CODE     TO WRKLEN1.                        
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE    TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                   TO CTR-COLUMN.               
CVT999*    MOVE TDSCHAR                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSCHAR                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-TRANS-ID-CD           TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-TRANS-ID-CD          TO WRKLEN2.                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRANS-ID-CD,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRANS-ID-CD,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                   TO CTR-COLUMN.               
CVT999*    MOVE TDSINT2                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSINT2                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-TRANS-PRIORITY        TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-TRANS-PRIORITY       TO WRKLEN2.                  
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRANS-PRIORITY                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRANS-PRIORITY,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                   TO CTR-COLUMN.               
CVT999*    MOVE TDSCHAR                            TO DB-HOST-TYPE.             
CVT999*    MOVE TDSCHAR                            TO DB-CLIENT-TYPE.           
CVT999*    MOVE LENGTH OF RS-RECEIVED-TS           TO WRKLEN1.                  
CVT999*    MOVE LENGTH OF CNS-RECEIVED-TS           TO WRKLEN2.                 
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RECEIVED-TS                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RECEIVED-TS,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSINT2                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSINT2                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TRANS-SEQ-NO       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TRANS-SEQ-NO      TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRANS-SEQ-NO,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRANS-SEQ-NO,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TRANS-STATUS-CD    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TRANS-STATUS-CD   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRANS-STATUS-CD,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRANS-STATUS-CD,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TRANS-OCCURS-TS    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TRANS-OCCURS-TS   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRANS-OCCURS-TS,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRANS-OCCURS-TS,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-DIST-ACCT-NO       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-DIST-ACCT-NO      TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-DIST-ACCT-NO,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-DIST-ACCT-NO,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-ST-NO    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-ST-NO   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-ST-NO,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-ST-NO,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-ST-CARD  TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-ST-CARD TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-ST-CARD,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-ST-CARD,                         
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-ST-NAME  TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-ST-NAME TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-ST-NAME,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-ST-NAME,                         
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-ST-THOR  TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-ST-THOR TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-ST-THOR,                          
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-ST-THOR,                         
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-ST-DIR   TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-ST-DIR  TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-ST-DIR,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-ST-DIR,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-STRUCT   TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-STRUCT  TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-STRUCT,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-STRUCT,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-CITY     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-CITY    TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-CITY,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-CITY,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-STATE    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-STATE   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-STATE,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-STATE,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SERV-ADDR-ZIP-CD   TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SERV-ADDR-ZIP-CD  TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SERV-ADDR-ZIP-CD,                           
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SERV-ADDR-ZIP-CD,                          
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-NAME-IND      TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CUST-NAME-IND     TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-NAME-IND,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-NAME-IND,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-NAME-FIRST    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CUST-NAME-FIRST   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-NAME-FIRST,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-NAME-FIRST,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-NAME-MID      TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CUST-NAME-MID     TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-NAME-MID,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-NAME-MID,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-NAME-LAST     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CUST-NAME-LAST    TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-NAME-LAST,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-NAME-LAST,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-NAME-SFX      TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CUST-NAME-SFX     TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-NAME-SFX,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-NAME-SFX,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-SSN-NO        TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CUST-SSN-NO       TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-SSN-NO,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-SSN-NO,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-AREA-CD       TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-CUST-AREA-CD       TO WRKLEN2.                    
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-AREA-CD,                               
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-AREA-CD,                              
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-PHONE-NO  TO WRKLEN1.                         
CVT999*    MOVE LENGTH OF CNS-CUST-PHONE-NO  TO WRKLEN2.                        
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-PHONE-NO,                              
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-PHONE-NO,                             
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-CUST-EXT-NO  TO WRKLEN1.                           
CVT999*    MOVE LENGTH OF CNS-CUST-EXT-NO  TO WRKLEN2.                          
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-CUST-EXT-NO,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-CUST-EXT-NO,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TRAN-DATA1         TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TRAN-DATA1        TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRAN-DATA1,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRAN-DATA1,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TRAN-DATA2         TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TRAN-DATA2        TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRAN-DATA2,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRAN-DATA2,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TRAN-DATA3         TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TRAN-DATA3        TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRAN-DATA3,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRAN-DATA3,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-TRAN-DATA4         TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-TRAN-DATA4        TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-TRAN-DATA4,                                 
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-TRAN-DATA4,                                
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SEB-ACCT-NO        TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SEB-ACCT-NO       TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SEB-ACCT-NO,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SEB-ACCT-NO,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-SEB-COMPANY-NO     TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-SEB-COMPANY-NO    TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-SEB-COMPANY-NO,                             
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-SEB-COMPANY-NO,                            
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
                                                                        
CVT999*    ADD 1                                TO CTR-COLUMN.                  
CVT999*    MOVE TDSCHAR                         TO DB-HOST-TYPE.                
CVT999*    MOVE TDSCHAR                         TO DB-CLIENT-TYPE.              
CVT999*    MOVE LENGTH OF RS-LAST-UPDATED-BY    TO WRKLEN1.                     
CVT999*    MOVE LENGTH OF CNS-LAST-UPDATED-BY   TO WRKLEN2.                     
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-LAST-UPDATED-BY,                            
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-LAST-UPDATED-BY,                           
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                             
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE '2200'               TO ACTIVE-PARAGRAPH.               
           MOVE PARM-STATUS TO WS-STATUS.                               
           PERFORM 7000-OPEN-TJ-TRANOUT-CURSOR THRU 7000-EXIT.          
           PERFORM 7100-FETCH-TJ-TRANOUT-CURSOR THRU 7100-EXIT.         
           PERFORM                                                      
               UNTIL (WS-ACTIVE-RETURN-CODE = NOT-FOUND)                
               PERFORM 2500-PROCESS-ROW                 THRU 2500-EXIT  
               PERFORM 7100-FETCH-TJ-TRANOUT-CURSOR THRU 7100-EXIT      
           END-PERFORM.                                                 
           PERFORM 7200-CLOSE-TJ-TRANOUT-CURSOR THRU 7200-EXIT.         
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
       2200-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
      * 2500-PROCESS-ROW                                               *        
      *                                                                *        
      *     GET DATA FROM CURSOR AND PUT INTO INTO RETURN FIELDS       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2500-PROCESS-ROW.                                                
                                                                        
           MOVE WS-ACTIVE-RETURN-CODE             TO RS-RETURN-CODE.    
           MOVE TJ-TRANS-ID-CD                 TO RS-TRANS-ID-CD.       
           MOVE TJ-TRANS-PRIORITY              TO RS-TRANS-PRIORITY.    
           MOVE TJ-RECEIVED-TS                 TO RS-RECEIVED-TS.       
           MOVE TJ-TRANS-SEQ-NO                TO RS-TRANS-SEQ-NO.      
           MOVE TJ-TRANS-STATUS-CD             TO RS-TRANS-STATUS-CD.   
           MOVE TJ-TRANS-OCCURS-TS             TO RS-TRANS-OCCURS-TS.   
           MOVE TJ-DIST-ACCT-NO                TO RS-DIST-ACCT-NO.      
           MOVE TJ-SERV-ADDR-ST-NO             TO RS-SERV-ADDR-ST-NO.   
           MOVE TJ-SERV-ADDR-ST-CARD           TO RS-SERV-ADDR-ST-CARD. 
           MOVE TJ-SERV-ADDR-ST-NAME           TO RS-SERV-ADDR-ST-NAME. 
           MOVE TJ-SERV-ADDR-ST-THOR           TO RS-SERV-ADDR-ST-THOR. 
           MOVE TJ-SERV-ADDR-ST-DIR            TO RS-SERV-ADDR-ST-DIR.  
           MOVE TJ-SERV-ADDR-STRUCT            TO RS-SERV-ADDR-STRUCT.  
           MOVE TJ-SERV-ADDR-CITY              TO RS-SERV-ADDR-CITY.    
           MOVE TJ-SERV-ADDR-STATE             TO RS-SERV-ADDR-STATE.   
           MOVE TJ-SERV-ADDR-ZIP-CD            TO RS-SERV-ADDR-ZIP-CD.  
           MOVE TJ-CUST-NAME-IND               TO RS-CUST-NAME-IND.     
           MOVE TJ-CUST-NAME-FIRST             TO RS-CUST-NAME-FIRST.   
           MOVE TJ-CUST-NAME-MID               TO RS-CUST-NAME-MID.     
           MOVE TJ-CUST-NAME-LAST              TO RS-CUST-NAME-LAST.    
           MOVE TJ-CUST-NAME-SFX               TO RS-CUST-NAME-SFX.     
           MOVE TJ-CUST-SSN-NO                 TO RS-CUST-SSN-NO.       
           MOVE TJ-CUST-AREA-CD                TO RS-CUST-AREA-CD.      
           MOVE TJ-CUST-PHONE-NO               TO RS-CUST-PHONE-NO.     
           MOVE TJ-CUST-EXT-NO                 TO RS-CUST-EXT-NO.       
           MOVE TJ-TRAN-DATA1-TEXT             TO RS-TRAN-DATA1.        
           MOVE TJ-TRAN-DATA2-TEXT             TO RS-TRAN-DATA2.        
           MOVE TJ-TRAN-DATA3-TEXT             TO RS-TRAN-DATA3.        
           MOVE TJ-TRAN-DATA4-TEXT             TO RS-TRAN-DATA4.        
           MOVE TJ-SEB-ACCT-NO                 TO WS-SEB-ACCT-NO.       
           MOVE WS-SEB-ACCT-NO                 TO RS-SEB-ACCT-NO.       
           MOVE TJ-SEB-COMPANY-NO              TO RS-SEB-COMPANY-NO.    
           MOVE TJ-LAST-UPDATED-BY             TO RS-LAST-UPDATED-BY.   
           PERFORM 8100-SEND-RESULT                     THRU 8100-EXIT. 
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 7000-OPEN-TJ-TRANOUT-CURSOR.                                   *        
      *                                                                *        
      *     OPEN TJ-TRANOUT-CURSOR                                              
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-OPEN-TJ-TRANOUT-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
               OPEN TJ-TRANOUT-CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7000'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'TJ-TRANOUT-CURSOR'    TO TABLE-1                   
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
                                                                        
      ******************************************************************        
      * 7100-FETCH-TJ-TRANOUT-CURSOR                                   *        
      *                                                                *        
      *     FETCH TJ-TRANOUT-CURSOR        CHECK FOR SQL ERROR.        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-FETCH-TJ-TRANOUT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               FETCH TJ-TRANOUT-CURSOR                                  
                INTO :TJ-TRANS-ID-CD,                                   
                     :TJ-TRANS-PRIORITY,                                
                     :TJ-RECEIVED-TS,                                   
                     :TJ-TRANS-SEQ-NO,                                  
                     :TJ-TRANS-STATUS-CD,                               
                     :TJ-TRANS-OCCURS-TS,                               
                     :TJ-DIST-ACCT-NO,                                  
                     :TJ-SERV-ADDR-ST-NO,                               
                     :TJ-SERV-ADDR-ST-CARD,                             
                     :TJ-SERV-ADDR-ST-NAME,                             
                     :TJ-SERV-ADDR-ST-THOR,                             
                     :TJ-SERV-ADDR-ST-DIR,                              
                     :TJ-SERV-ADDR-STRUCT,                              
                     :TJ-SERV-ADDR-CITY,                                
                     :TJ-SERV-ADDR-STATE,                               
                     :TJ-SERV-ADDR-ZIP-CD,                              
                     :TJ-CUST-NAME-IND,                                 
                     :TJ-CUST-NAME-FIRST,                               
                     :TJ-CUST-NAME-MID,                                 
                     :TJ-CUST-NAME-LAST,                                
                     :TJ-CUST-NAME-SFX,                                 
                     :TJ-CUST-SSN-NO,                                   
                     :TJ-CUST-AREA-CD,                                  
                     :TJ-CUST-PHONE-NO,                                 
                     :TJ-CUST-EXT-NO,                                   
                     :TJ-TRAN-DATA1,                                    
                     :TJ-TRAN-DATA2,                                    
                     :TJ-TRAN-DATA3,                                    
                     :TJ-TRAN-DATA4,                                    
                     :TJ-SEB-ACCT-NO,                                   
                     :TJ-SEB-COMPANY-NO,                                
                     :TJ-LAST-UPDATED-BY                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7100'                 TO ACTIVE-PARAGRAPH          
               MOVE 'FETCH'                TO ABEND-FUNCTION            
               MOVE 'TJ-TRANOUT-CURSOR'    TO TABLE-1                   
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
                                                                        
      ******************************************************************        
      * 7200-TJ-TRANOUT-CURSOR                                         *        
      *                                                                *        
      *     CLOSE TJ-TRANOUT-CURSOR CHECK FOR SQL ERROR.            *           
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-CLOSE-TJ-TRANOUT-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
               CLOSE TJ-TRANOUT-CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7200'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'TJ-TRANOUT-CURSOR'    TO TABLE-1                   
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
       7200-EXIT.                                                       
            EXIT.                                                       
                                                                        
HPCCDM*EJECT                                                                    
      *****************************************************************         
      *9900- JOURNALING / ERROR HANDLING INCLUDE *                              
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02381_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,TRANS_ID_CD                                               
CVT000       ,TRANS_PRIORITY                                            
CVT000       ,RECEIVED_TS                                               
CVT000       ,TRANS_SEQ_NO                                              
CVT000       ,TRANS_STATUS_CD                                           
CVT000       ,TRANS_OCCURS_TS                                           
CVT000       ,DIST_ACCT_NO                                              
CVT000       ,SERV_ADDR_ST_NO                                           
CVT000       ,SERV_ADDR_ST_CARD                                         
CVT000       ,SERV_ADDR_ST_NAME                                         
CVT000       ,SERV_ADDR_ST_THOR                                         
CVT000       ,SERV_ADDR_ST_DIR                                          
CVT000       ,SERV_ADDR_STRUCT                                          
CVT000       ,SERV_ADDR_CITY                                            
CVT000       ,SERV_ADDR_STATE                                           
CVT000       ,SERV_ADDR_ZIP_CD                                          
CVT000       ,CUST_NAME_IND                                             
CVT000       ,CUST_NAME_FIRST                                           
CVT000       ,CUST_NAME_MID                                             
CVT000       ,CUST_NAME_LAST                                            
CVT000       ,CUST_NAME_SFX                                             
CVT000       ,CUST_SSN_NO                                               
CVT000       ,CUST_AREA_CD                                              
CVT000       ,CUST_PHONE_NO                                             
CVT000       ,CUST_EXT_NO                                               
CVT000       ,TRAN_DATA1                                                
CVT000       ,TRAN_DATA2                                                
CVT000       ,TRAN_DATA3                                                
CVT000       ,TRAN_DATA4                                                
CVT000       ,SEB_ACCT_NO                                               
CVT000       ,SEB_COMPANY_NO                                            
CVT000       ,LAST_UPDATED_BY                                           
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
CVT000        :RS-RETURN-CODE                                           
CVT000       ,:RS-TRANS-ID-CD                                           
CVT000       ,:RS-TRANS-PRIORITY                                        
CVT000       ,:RS-RECEIVED-TS                                           
CVT000       ,:RS-TRANS-SEQ-NO                                          
CVT000       ,:RS-TRANS-STATUS-CD                                       
CVT000       ,:RS-TRANS-OCCURS-TS                                       
CVT000       ,:RS-DIST-ACCT-NO                                          
CVT000       ,:RS-SERV-ADDR-ST-NO                                       
CVT000       ,:RS-SERV-ADDR-ST-CARD                                     
CVT000       ,:RS-SERV-ADDR-ST-NAME                                     
CVT000       ,:RS-SERV-ADDR-ST-THOR                                     
CVT000       ,:RS-SERV-ADDR-ST-DIR                                      
CVT000       ,:RS-SERV-ADDR-STRUCT                                      
CVT000       ,:RS-SERV-ADDR-CITY                                        
CVT000       ,:RS-SERV-ADDR-STATE                                       
CVT000       ,:RS-SERV-ADDR-ZIP-CD                                      
CVT000       ,:RS-CUST-NAME-IND                                         
CVT000       ,:RS-CUST-NAME-FIRST                                       
CVT000       ,:RS-CUST-NAME-MID                                         
CVT000       ,:RS-CUST-NAME-LAST                                        
CVT000       ,:RS-CUST-NAME-SFX                                         
CVT000       ,:RS-CUST-SSN-NO                                           
CVT000       ,:RS-CUST-AREA-CD                                          
CVT000       ,:RS-CUST-PHONE-NO                                         
CVT000       ,:RS-CUST-EXT-NO                                           
CVT000       ,:RS-TRAN-DATA1                                            
CVT000       ,:RS-TRAN-DATA2                                            
CVT000       ,:RS-TRAN-DATA3                                            
CVT000       ,:RS-TRAN-DATA4                                            
CVT000       ,:RS-SEB-ACCT-NO                                           
CVT000       ,:RS-SEB-COMPANY-NO                                        
CVT000       ,:RS-LAST-UPDATED-BY                                       
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02381_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,TRANS_ID_CD                                                       
MFA-TR*      ,TRANS_PRIORITY                                                    
MFA-TR*      ,RECEIVED_TS                                                       
MFA-TR*      ,TRANS_SEQ_NO                                                      
MFA-TR*      ,TRANS_STATUS_CD                                                   
MFA-TR*      ,TRANS_OCCURS_TS                                                   
MFA-TR*      ,DIST_ACCT_NO                                                      
MFA-TR*      ,SERV_ADDR_ST_NO                                                   
MFA-TR*      ,SERV_ADDR_ST_CARD                                                 
MFA-TR*      ,SERV_ADDR_ST_NAME                                                 
MFA-TR*      ,SERV_ADDR_ST_THOR                                                 
MFA-TR*      ,SERV_ADDR_ST_DIR                                                  
MFA-TR*      ,SERV_ADDR_STRUCT                                                  
MFA-TR*      ,SERV_ADDR_CITY                                                    
MFA-TR*      ,SERV_ADDR_STATE                                                   
MFA-TR*      ,SERV_ADDR_ZIP_CD                                                  
MFA-TR*      ,CUST_NAME_IND                                                     
MFA-TR*      ,CUST_NAME_FIRST                                                   
MFA-TR*      ,CUST_NAME_MID                                                     
MFA-TR*      ,CUST_NAME_LAST                                                    
MFA-TR*      ,CUST_NAME_SFX                                                     
MFA-TR*      ,CUST_SSN_NO                                                       
MFA-TR*      ,CUST_AREA_CD                                                      
MFA-TR*      ,CUST_PHONE_NO                                                     
MFA-TR*      ,CUST_EXT_NO                                                       
MFA-TR*      ,TRAN_DATA1                                                        
MFA-TR*      ,TRAN_DATA2                                                        
MFA-TR*      ,TRAN_DATA3                                                        
MFA-TR*      ,TRAN_DATA4                                                        
MFA-TR*      ,SEB_ACCT_NO                                                       
MFA-TR*      ,SEB_COMPANY_NO                                                    
MFA-TR*      ,LAST_UPDATED_BY                                                   
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :RS-RETURN-CODE                                                   
MFA-TR*      ,:RS-TRANS-ID-CD                                                   
MFA-TR*      ,:RS-TRANS-PRIORITY                                                
MFA-TR*      ,:RS-RECEIVED-TS                                                   
MFA-TR*      ,:RS-TRANS-SEQ-NO                                                  
MFA-TR*      ,:RS-TRANS-STATUS-CD                                               
MFA-TR*      ,:RS-TRANS-OCCURS-TS                                               
MFA-TR*      ,:RS-DIST-ACCT-NO                                                  
MFA-TR*      ,:RS-SERV-ADDR-ST-NO                                               
MFA-TR*      ,:RS-SERV-ADDR-ST-CARD                                             
MFA-TR*      ,:RS-SERV-ADDR-ST-NAME                                             
MFA-TR*      ,:RS-SERV-ADDR-ST-THOR                                             
MFA-TR*      ,:RS-SERV-ADDR-ST-DIR                                              
MFA-TR*      ,:RS-SERV-ADDR-STRUCT                                              
MFA-TR*      ,:RS-SERV-ADDR-CITY                                                
MFA-TR*      ,:RS-SERV-ADDR-STATE                                               
MFA-TR*      ,:RS-SERV-ADDR-ZIP-CD                                              
MFA-TR*      ,:RS-CUST-NAME-IND                                                 
MFA-TR*      ,:RS-CUST-NAME-FIRST                                               
MFA-TR*      ,:RS-CUST-NAME-MID                                                 
MFA-TR*      ,:RS-CUST-NAME-LAST                                                
MFA-TR*      ,:RS-CUST-NAME-SFX                                                 
MFA-TR*      ,:RS-CUST-SSN-NO                                                   
MFA-TR*      ,:RS-CUST-AREA-CD                                                  
MFA-TR*      ,:RS-CUST-PHONE-NO                                                 
MFA-TR*      ,:RS-CUST-EXT-NO                                                   
MFA-TR*      ,:RS-TRAN-DATA1                                                    
MFA-TR*      ,:RS-TRAN-DATA2                                                    
MFA-TR*      ,:RS-TRAN-DATA3                                                    
MFA-TR*      ,:RS-TRAN-DATA4                                                    
MFA-TR*      ,:RS-SEB-ACCT-NO                                                   
MFA-TR*      ,:RS-SEB-COMPANY-NO                                                
MFA-TR*      ,:RS-LAST-UPDATED-BY                                               
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000        MOVE '8900'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
CVT000        MOVE 'CSR0TEST_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02381_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02381_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02381_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
