       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02378.                                         
COB303 DATE-WRITTEN.      MARCH 22, 1999.                               
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S378 CONVERTED TO DB2 SP CSR02378 ON 06/14/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      ******************************************************************        
      *                        SCANA ENERGY                            *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S378                                           *        
      *  PROGRAM:       S378                                           *        
      *  CALLING SP:    PA_S378                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *                                                                *        
      *  THIS PROGRAM INSERTS, DELETES, OR UPDATES THE                 *        
      *  CSS_FIXED_FCTR BASED ON THE ACTION PARAMETER                  *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  03/22/99    ANH      CREATED.                                 *        
      *  07/27/99    JVH      TPR 19864 - USE 2 DECIMAL PLACES FOR DDC *        
      *                       INSTEAD OF 4.                            *        
      *  07/29/99    JVH      SEB - MODIFY THE PROGRAM TO ALSO INSERT  *        
      *                       THE AGLMCF FACTOR.  ADDED THE FACTOR-ID  *        
      *                       PARM TO DETERMINE WHICH FACTOR IS BEING  *        
      *                       INSERTED/UPDATE.                         *        
      *  08/09/99    JVH      SEB - MODIFY THE PROGRAM TO ALSO INSERT  *        
      *                       THE FAMILY UNITS (FAMUNITS) FACTOR.      *        
      *  08/12/99    JVH      RETURN 99 IF ACCOUNT IS NOT ACTIVE.      *        
      *                       RETURN 50 IF NOT CHANGE IN FACTOR.       *        
      *  08/24/99    AMG      MODIFIED 5300 TO RESET WS-TRAN-APPL-NO   *        
      *                       WHEN A NEW TIMESTAMP IS SELECTED.        *        
      *  09/13/99    WMG      MODIFIED TO ADD/INSERT OR SUBTRACT/DELETE*        
      *                       A FACTOR WHEN PROCESSING A TRANSACTION   *        
      *                       THAT UPDATES THE METER MULTIPLIER        *        
      *                       (CONSTANT).  (I.E., MTMA TRANSACTIONS).  *        
T22243*  07/27/00    CBSI     CHANGES MADE TO IMPLEMENT MULTI-COMPANY  *        
T22243*              MADRAS   IN METER INVENTORY TABLES                *        
DDCT1 *  09/05/00    MF18988  ADDED CODE TO INSERT NEW ROW INTO        *        
      *                       CSS_FIXED_FCTR FOR NEW DDC SO THAT THE   *        
      *                       OLD VALUE WILL NOT GET UPDATED.          *        
DDC2  *  09/20/00    MF18988  ADDED TO CODE TO GENERATE EFF_FROM DATE  *        
      *                       FOR NEW FACTORS AND EFF_TO DATE FOR THE  *        
      *                       PREVIOUS FACTOR.  ALSO CHANGED CODE TO   *        
      *                       INSERT NEW FACTOR IF FACTOR EQUAL        *        
      *                       PREVIOUS FACTOR.  ALSO CHANGED CODE TO   *        
      *                       INSERT NEW FACTOR IF THE STATUS CODE     *        
      *                       FROM CSS_ACCOUNT IS NOT SPACES.          *        
      *                       ADDED CODE TO INSERT DDAY IF MORE THAN   *        
      *                       ONE COMES WITHIN THE SAME BILL WINDOW.   *        
      *                       THE PREVIOUS DDAY FOR THE SAME BILL MONTH*        
      *                       WILL HAVE AN EFFECTIVED FROM AND TO DATE *        
      *                       THAT WILL BE THE LAST DAY OF THE MONTH   *        
      *                       PRIOR TO BILL MONTH.                     *        
      *                                                                *        
      *  09/2001     MF18988  ADDED TO CODE TO RECEIVE EFFECTIVE DATE  *        
      *                       AS INPUT.                                *        
      *                                                                *        
      *  10/2001     MF18988  CHANGE CODE TO ROUND TO 3RD DECIMAL      *        
      *                       INSTEAD OF 2ND.                          *        
      *                                                                *        
      *  11/2001     MF18988  CHANGE CODE TO GET MAX EFF_DATE_TO       *        
      *                       INSTEAD OF SEQ_NO WHEN FINDING THE       *        
      *                       PREVIOUS FACTOR.                         *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02378'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
           'WORKING STORAGE FOR RPC S378 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      * CSS_SPCL_FCTR                                                           
           EXEC SQL                                                             
              INCLUDE TBSPLFTR                                                  
           END-EXEC.                                                            
                                                                        
      * CSS_ACCOUNT                                                             
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFXHST                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBFXDFCT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMRKXR                                                   
           END-EXEC.                                                            
                                                                        
      * ADDED TABLE INCLUDES FOR JOURNALING                                     
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBRSAREA                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUTLENV                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
CVT999*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
      *---------------------------------------------------------------*         
      *    COPY CJF00112.                                             *         
      *---------------------------------------------------------------*         
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00013                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                POINTER.                                 
CVT999*    05  GWL-INIT-HANDLE         POINTER.                                 
CVT999*    05  GWL-RC                  PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-NR           PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-DONE         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COUNT        PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-COMM         PIC S9(9) COMP.                          
CVT999*    05  GWL-STATUS-RETURN-CODE  PIC S9(9) COMP.                          
           05  GWL-STATUS-SUBCODE      PIC S9(9) COMP.                  
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
       01  PARM-FIELDS.                                                 
           05  PARM-L                  PIC S9(9)  USAGE COMP.           
CVT999*    05  PARM-ID1                PIC S9(9)  USAGE COMP VALUE 1.           
           05  PARM-ACCOUNT-NO         PIC X(20).                       
           05  PARM-FACTOR             PIC X(07).                       
           05  PARM-FACTOR-ID          PIC X(09).                       
           05  PARM-METER-NO           PIC X(09).                       
           05  PARM-EFF-DT             PIC X(10).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
CVT999*    05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.                  
                                                                        
       01  COUNTER-FIELDS.                                              
CVT999*    05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.                  
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  IND-VARIABLES.                                               
           05  IND-DATE-TO             PIC S9(4) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM         PIC S9(9) COMP.                          
CVT999*    05  WRKLEN1                 PIC S9(9) COMP.                          
CVT999*    05  WRKLEN2                 PIC S9(9) COMP.                          
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  WS-MISC.                                                     
           05  WS-CURRENT-DATE         PIC X(10) VALUE SPACES.          
           05  WS-HOLD-RETCODE         PIC S9(9) COMP VALUE 0.          
           05  WS-DATE-TO              PIC X(10) VALUE                  
               '2999-12-31'.                                            
           05  WS-DATE-FROM            PIC X(10) VALUE                  
               '1990-01-01'.                                            
           05  WS-NEW-DATE-TO          PIC X(10) VALUE SPACES.          
           05  WS-NEW-DATE-FROM.                                        
               10  WS-NEW-DT-FRM-Y     PIC X(04) VALUE SPACES.          
               10  WS-DT-FRM-DASH1     PIC X(01) VALUE '-'.             
               10  WS-NEW-DT-FRM-M     PIC X(02) VALUE SPACES.          
               10  WS-DT-FRM-DASH2     PIC X(01) VALUE '-'.             
               10  WS-NEW-DT-FRM-D     PIC X(02) VALUE SPACES.          
           05  WS-NEW-DT-FRM           REDEFINES WS-NEW-DATE-FROM       
                                       PIC X(10).                       
           05  WS-DT-FRM-PLUS1         PIC X(10) VALUE SPACES.          
           05  WS-DT-TO-MINUS1         PIC X(10) VALUE SPACES.          
           05  WS-PREV-FCTR-DT-TO  PIC X(10) VALUE SPACES.              
           05  WS-DATE-FROM-I          PIC X(10) VALUE SPACES.          
           05  WS-DATE-TO-I            PIC X(10) VALUE SPACES.          
           05  WS-OLD-EFF-DATE-FROM    PIC X(10) VALUE SPACES.          
           05  WS-MAX-EFF-DATE-TO      PIC X(10) VALUE SPACES.          
           05  WS-MAX-FCTR-SEQ-NO      PIC S9(10) COMP-3 VALUE 0.       
           05  WS-FAC-CHRG-BASE-AM     PIC S9(1) COMP-3 VALUE 0.        
           05  WS-FACTOR-IN            PIC X(07).                       
           05  WS-FACTOR-COMP          REDEFINES WS-FACTOR-IN           
                                       PIC 9(07).                       
COB305     05 WS-OLD-FACTOR        PIC S9(09)V9999 USAGE COMP-3 VALUE 0.    
COB305     05 WS-FACTOR-DIV-COMP        PIC S9(09)V9(3) COMP-3 VALUE 0.         
           05  WS-FACTOR-TEMP          PIC 9(09)V9999.                  
           05  WS-CURSOR-RETURN-CODE   PIC S9(09) VALUE +000 COMP.      
           05  WS-UPDATE-RETURN-CODE   PIC S9(09) VALUE +000 COMP.      
           05  WS-MAX-SEQ-NO           PIC S9(10) COMP-3 VALUE 0.       
           05  WS-FACTOR-TYP-CD        PIC X(02) VALUE '00'.            
           05  WS-FACTOR-ID            PIC X(09) VALUE SPACES.          
           05  WS-FACTOR-ID-DDC        PIC X(09) VALUE 'DDC'.           
           05  WS-FACTOR-ID-AGLMCF     PIC X(09) VALUE 'AGLMCF'.        
           05  WS-FACTOR-ID-FAMUNITS   PIC X(09) VALUE 'FAMUNITS'.      
           05  WS-FACTOR-ID-ADD        PIC X(09) VALUE 'ADD'.           
           05  WS-FACTOR-ID-SUB        PIC X(09) VALUE 'SUB'.           
           05  WS-MTMA-PROCESSING      PIC X(01) VALUE 'N'.             
           05  WS-DEKA-CONV-TEST       PIC 9(6)V999  VALUE 1.025.       
           05  IV-IC-NO                PIC S9(04) COMP.                 
           05  WS-GAS-UTIL-TYPE        PIC X(01) VALUE 'G'.             
           05  PROGRAM-NAME            PIC X(08) VALUE SPACE.           
           05  TRAN-ID                 PIC X(10) VALUE 'S378'.          
           05  WS-HOLD-FACT-VAL        PIC X(13) VALUE SPACES.          
           05  WS-HOLD-FACT-VAL-RED    REDEFINES WS-HOLD-FACT-VAL       
                                       PIC 999999999V9999.              
           05  WS-HOLD-BASE-AMT        PIC X(09) VALUE SPACES.          
           05  WS-HOLD-BASE-AMT-RED    REDEFINES WS-HOLD-BASE-AMT       
                                       PIC 9999999V99.                  
COB305     05 WS-ACCOUNT-NO-NUM        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-DIST-ACCOUNT-NO      PIC X(20).                       
           05  WS-UPDATE-SUCCESSFUL    PIC X(01).                       
               88 UPDATE-SUCCESSFUL    VALUE 'Y'.                       
           05  WS-NULL-IND             PIC S9(04) COMP   VALUE 0.       
           05  WS-BASE-AMT-TEXT        PIC 9(7).9(2).                   
           05  WS-FACTOR-TEXT          PIC 9(9).9(4).                   
           05  WS-PROCESSED            PIC X(01).                       
               88 WS-NO-CHANGE         VALUE 'N'.                       
               88 WS-CHANGED           VALUE 'Y'.                       
           05  WS-REV-MTH-LST-NRML     PIC 9(6).                        
           05  WS-REV-MTH-LST-NRML-RED REDEFINES                        
               WS-REV-MTH-LST-NRML.                                     
               10  WS-REV-MTH-LST-CCYY PIC 9(4).                        
               10  WS-REV-MTH-LST-MTH  PIC 9(2).                        
           05  WS-EFF-DT-IN            PIC X(10).                       
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
CVT999*01  CNS-COLUMN-NAMES.                                                    
CVT999*    05  CNS-RETURN-CODE         PIC X(11) VALUE                          
CVT999*                                        'RETURN_CODE'.                   
       01  WS-MNT-TRANS-DET.                                            
           05  WS-TRAN-APPL-NO           PIC S9(02) VALUE +1.           
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
                                                                        
      ******************************************************************        
      * CURSOR FOR GETTING IC_NO FROM CSS_UTIL_ENVRNMT                 *        
      ******************************************************************        
           EXEC SQL                                                     
               DECLARE UTIL_ENV CURSOR WITH HOLD FOR                    
                SELECT IC_NO                                            
                  FROM CSS_UTIL_ENVRNMT                                 
                 WHERE ACCOUNT_NO       = :AT-ACCOUNT-NO                
                   AND CODE_UTIL_TYPE   = :WS-GAS-UTIL-TYPE             
           END-EXEC.                                                    
                                                                        
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACCOUNT-NO          PIC X(20)                .          
CVT000 01  LINK-FACTOR              PIC X(07)                .          
CVT000 01  LINK-FACTOR-ID           PIC X(09)                .          
CVT000 01  LINK-METER-NO            PIC X(09)                .          
CVT000 01  LINK-EFF-DT              PIC X(10)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACCOUNT-NO                                         
CVT000         ,LINK-FACTOR                                             
CVT000         ,LINK-FACTOR-ID                                          
CVT000         ,LINK-METER-NO                                           
CVT000         ,LINK-EFF-DT                                             
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.                      
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.                      
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
CVT999*       MOVE TRAN-ID                    TO ABEND-PROGRAM                  
CVT999*       MOVE '0100'                     TO ACTIVE-PARAGRAPH               
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
CVT999*       MOVE 'CICS TRANSACTION'         TO TABLE-1                        
CVT999*       MOVE GWL-RC                     TO WS-ACTIVE-RETURN-CODE          
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT                    
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT                    
CVT999*    END-IF.                                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-FACTOR               TO PARM-FACTOR              . 
CVT000     MOVE LINK-FACTOR-ID            TO PARM-FACTOR-ID           . 
CVT000     MOVE LINK-METER-NO             TO PARM-METER-NO            . 
CVT000     MOVE LINK-EFF-DT               TO PARM-EFF-DT              . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      *                                                                *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           PERFORM 1100-RECEIVE-PARMS     THRU 1100-EXIT.               
                                                                        
           MOVE PARM-FACTOR               TO WS-FACTOR-IN.              
           MOVE PARM-ACCOUNT-NO           TO WS-DIST-ACCOUNT-NO.        
           MOVE PARM-FACTOR-ID            TO WS-FACTOR-ID.              
           MOVE PARM-EFF-DT               TO WS-EFF-DT-IN.              
                                                                        
           IF WS-FACTOR-ID = WS-FACTOR-ID-ADD OR                        
                             WS-FACTOR-ID-SUB                           
              MOVE 'Y'                    TO WS-MTMA-PROCESSING         
           END-IF.                                                      
                                                                        
      ******************************************************************        
      * CONVERT THE DDC FACTOR TO DEKATHERMS FROM MCFS.                *        
      ******************************************************************        
           COMPUTE WS-FACTOR-TEMP =                                     
                        (WS-FACTOR-COMP / 1000 ).                       
                                                                        
           IF PARM-FACTOR-ID EQUAL WS-FACTOR-ID-DDC THEN                
T19864         COMPUTE WS-FACTOR-DIV-COMP ROUNDED =                     
                        (WS-FACTOR-TEMP * WS-DEKA-CONV-TEST)            
           ELSE                                                         
              MOVE WS-FACTOR-TEMP  TO WS-FACTOR-DIV-COMP                
           END-IF.                                                      
                                                                        
T19864*    COMPUTE WS-DDAY-TEMP ROUNDED =                                       
T19864*                 (WS-DDAY-TEMP * WS-DEKA-CONV-TEST).                     
                                                                        
T19864*    MOVE WS-DDAY-TEMP       TO WS-DDAY-FACTOR-DIV-COMP.                  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       1100-RECEIVE-PARMS.                                              
                                                                        
CVT999*    MOVE 1                            TO PARM-ID1.               02660001
CVT999*    MOVE LENGTH OF PARM-ACCOUNT-NO    TO MAX-LENGTH-PARM.        02670001
                                                                        
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02690001
CVT999*                          GWL-RC,                                02700001
CVT999*                          PARM-ID1,                              02710001
CVT999*                          PARM-ACCOUNT-NO,                               
CVT999*                          TDSCHAR,                               02730001
CVT999*                          MAX-LENGTH-PARM,                       02740001
CVT999*                          PARM-L.                                02750001
                                                                        
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02660001
CVT999*    MOVE LENGTH OF PARM-FACTOR        TO MAX-LENGTH-PARM,        02670001
CVT999*                                                                 02680001
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02690001
CVT999*                          GWL-RC,                                02700001
CVT999*                          PARM-ID1,                              02710001
CVT999*                          PARM-FACTOR,                           02720001
CVT999*                          TDSCHAR,                               02730001
CVT999*                          MAX-LENGTH-PARM,                       02740001
CVT999*                          PARM-L.                                02750001
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02660001
CVT999*    MOVE LENGTH OF PARM-FACTOR-ID     TO MAX-LENGTH-PARM,        02670001
CVT999*                                                                 02680001
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02690001
CVT999*                          GWL-RC,                                02700001
CVT999*                          PARM-ID1,                              02710001
CVT999*                          PARM-FACTOR-ID,                        02720001
CVT999*                          TDSCHAR,                               02730001
CVT999*                          MAX-LENGTH-PARM,                       02740001
CVT999*                          PARM-L.                                02750001
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02660001
CVT999*    MOVE LENGTH OF PARM-METER-NO      TO MAX-LENGTH-PARM,        02670001
CVT999*                                                                 02680001
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02690001
CVT999*                          GWL-RC,                                02700001
CVT999*                          PARM-ID1,                              02710001
CVT999*                          PARM-METER-NO,                         02720001
CVT999*                          TDSCHAR,                               02730001
CVT999*                          MAX-LENGTH-PARM,                       02740001
CVT999*                          PARM-L.                                02750001
                                                                        
CVT999*    ADD 1                             TO PARM-ID1.               02660001
CVT999*    MOVE LENGTH OF PARM-EFF-DT        TO MAX-LENGTH-PARM,        02670001
CVT999*                                                                 02680001
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              02690001
CVT999*                          GWL-RC,                                02700001
CVT999*                          PARM-ID1,                              02710001
CVT999*                          PARM-EFF-DT,                           02720001
CVT999*                          TDSCHAR,                               02730001
CVT999*                          MAX-LENGTH-PARM,                       02740001
CVT999*                          PARM-L.                                02750001
                                                                        
       1100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2100-DESCRIBE-RESULT THRU 2100-EXIT.                 
           PERFORM 7200-GET-CURRENT-TIMESTAMP THRU 7200-EXIT.           
           PERFORM 7300-SELECT-ACCOUNT-NO THRU 7300-EXIT.               
T22243     MOVE AT-COMPANY-NO                 TO MC-COMPANY-NO.         
           MOVE AT-REV-MTH-LST-NRML           TO WS-REV-MTH-LST-NRML.   
                                                                        
      * IF ACCOUNT IS FOUND ON CSS_ACCOUNT,                                     
      * INSERT NEW RATE...                                                      
DDC2       IF AT-CODE-ACCT-STAT EQUAL SPACES THEN                       
               MOVE 99                    TO WS-ACTIVE-RETURN-CODE      
           ELSE                                                         
      ******************************************************************        
      * UPDATE ALL RECORDS IN THE CSS_FIXED_FCTR TABLE WHERE           *        
      * ACCOUNT NUMBER EQUALS THE ONE PASSED IN FROM AGL,              *        
      * FIXED FACTOR TYPE OF DDAY ('02').  THE COLUMN UPDATE IS THE    *        
      * DATE_TO FIELD TO EQUAL TO CURRENT DATE.                        *        
      ******************************************************************        
              PERFORM 5000-UPDATE-INSERT      THRU 5000-EXIT            
                                                                        
              MOVE '5000'                     TO ACTIVE-PARAGRAPH       
                                                                        
              IF WS-NO-CHANGE THEN                                      
                 MOVE 50                      TO WS-ACTIVE-RETURN-CODE  
              ELSE IF WS-MTMA-PROCESSING = 'Y'                          
                 IF PARM-FACTOR-ID = WS-FACTOR-ID-ADD                   
                    MOVE 10                   TO MC-CONSTANT            
                 ELSE                                                   
                    MOVE 1                    TO MC-CONSTANT            
                 END-IF                                                 
                 MOVE PARM-METER-NO           TO MC-METER-NO            
                                                                        
                 PERFORM 8000-UPDATE-MTR-CAP  THRU 8000-EXIT            
              END-IF                                                    
           END-IF
           END-IF.                                                      
                                                                        
           IF WS-HOLD-RETCODE > 0                                       
               MOVE WS-HOLD-RETCODE TO RS-RETURN-CODE                   
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE
           END-IF.            
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      ******************************************************************        
                                                                        
       2100-DESCRIBE-RESULT.                                            
           MOVE '2100' TO ACTIVE-PARAGRAPH.                             
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                          
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
CVT999*    MOVE LENGTH OF RS-RETURN-CODE      TO WRKLEN1.                       
CVT999*    MOVE LENGTH OF CNS-RETURN-CODE     TO WRKLEN2.                       
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                                      
CVT999*                          GWL-RC,                                        
CVT999*                          CTR-COLUMN,                                    
CVT999*                          DB-HOST-TYPE,                                  
CVT999*                          WRKLEN1,                                       
CVT999*                          RS-RETURN-CODE,                                
CVT999*                          DB-NULL-INDICATOR,                             
CVT999*                          TDS-FALSE,                                     
CVT999*                          DB-CLIENT-TYPE,                                
CVT999*                          WRKLEN1,                                       
CVT999*                          CNS-RETURN-CODE,                               
CVT999*                          WRKLEN2.                                       
                                                                        
CVT999*     PERFORM 9100-CHECK-ERROR THRU 9100-EXIT.                            
                                                                        
       2100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************           
      * 5000-UPDATE-INSERT                                          *           
      ***************************************************************           
       5000-UPDATE-INSERT.                                              
                                                                        
            PERFORM 7050-OPEN-UTIL-ENV-CURSOR  THRU 7050-EXIT.          
            PERFORM 7060-FETCH-UTIL-ENV-CURSOR THRU 7060-EXIT.          
                                                                        
            PERFORM UNTIL (WS-CURSOR-RETURN-CODE = NOT-FOUND)           
                PERFORM 5300-PROCESS-UTIL-ENV-CURSOR THRU 5300-EXIT     
            END-PERFORM.                                                
                                                                        
            PERFORM 7070-CLOSE-UTIL-ENV-CURSOR THRU 7070-EXIT.          
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
                                                                        
       5100-MOVE-TRAN-HEAD.                                             
                                                                        
           EXEC SQL                                                     
              SELECT CAST(SYSDATETIMEOFFSET() AS DATE)                          
              INTO :MH-DATE-TRANS                                       
              FROM CSS_MODEL_SQL                                        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT DATE                                               
MFA-TR*       INTO :MH-DATE-TRANS                                               
MFA-TR*       FROM CSS_MODEL_SQL                                                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES                    TO ABEND-TABLES           
               MOVE '5100'                    TO ACTIVE-PARAGRAPH       
               MOVE SPACES                    TO ABEND-SQL-PREDICATES   
               MOVE TRAN-ID                   TO ABEND-PROGRAM          
               MOVE 'CSS_MODEL_SQL'           TO TABLE-1                
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
           MOVE 'F'                           TO MH-CODE-TRAN-TYPE.     
           MOVE SPACES                        TO MH-RESP-AREA-ID.       
           MOVE WS-ACCOUNT-NO-NUM             TO MH-ACCOUNT-NO.         
           MOVE ZEROS                         TO MH-CUSTOMER-NO         
                                                 MH-PREMISE-NO.         
           MOVE 'SYSTEM'                      TO MH-USER-ID.            
           MOVE TRAN-ID                       TO MH-APPL-PROGRAM-ID.    
           MOVE 20                            TO MH-TRAN-COMMENT-LEN.   
                                                                        
           PERFORM 5150-SELECT-COMMENT-TEXT   THRU 5150-EXIT.           
           MOVE SF-FACTOR-TEXT                TO MH-TRAN-COMMENT-TEXT.  
                                                                        
       5100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ***************************************************************           
      * 5150-SELECT-COMMENT-TEXT                                    *           
      ***************************************************************           
       5150-SELECT-COMMENT-TEXT.                                        
           EXEC SQL                                                     
               SELECT FACTOR_TEXT                                       
                 INTO :SF-FACTOR-TEXT                                   
                 FROM CSS_SPCL_FCTR                                     
                WHERE FACTOR_ID = :WS-FACTOR-ID                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE TRAN-ID                    TO ABEND-PROGRAM          
              MOVE '5150'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_SPCF_FCTR'            TO TABLE-1                
              MOVE 'FACTOR_ID'                TO TABLE-ELEMENT-1        
              MOVE WS-FACTOR-ID               TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5150-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ***************************************************************           
      * MOVE FIELDS TO THE MAINTENANCE TRANSACTION DETAIL AND       *           
      * CALL COMMON PARAGRAPH FOR WRITING A ROW.                    *           
      ***************************************************************           
       5200-MOVE-INS-TRAN-DET.                                          
             MOVE '5200'                      TO ACTIVE-PARAGRAPH.      
             MOVE MH-TRANS-HIST-SEQ-NO        TO MI-TRANS-HIST-SEQ-NO.  
             MOVE WS-TRAN-APPL-NO             TO MI-TRAN-APPL-NO.       
             MOVE +14                       TO MI-PRV-COLUMN-VALUE-LEN. 
             MOVE +14                       TO MI-CHG-COLUMN-VALUE-LEN. 
             MOVE WS-FACTOR-DIV-COMP          TO WS-HOLD-FACT-VAL-RED.  
             MOVE WS-HOLD-FACT-VAL-RED        TO WS-FACTOR-TEXT.        
             MOVE WS-FACTOR-TEXT            TO MI-CHG-COLUMN-VALUE-TEXT.
             MOVE 'FACTOR-VALUE   '           TO MI-COLUMN-DESC.        
             PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.           
                                                                        
             IF WS-FACTOR-ID EQUAL WS-FACTOR-ID-DDC                     
             OR WS-FACTOR-ID EQUAL WS-FACTOR-ID-FAMUNITS THEN           
                 ADD 1 TO WS-TRAN-APPL-NO                               
                                                                        
                 MOVE MH-TRANS-HIST-SEQ-NO   TO MI-TRANS-HIST-SEQ-NO    
                 MOVE WS-TRAN-APPL-NO        TO MI-TRAN-APPL-NO         
                 MOVE +14                    TO MI-PRV-COLUMN-VALUE-LEN 
                                                MI-CHG-COLUMN-VALUE-LEN 
                 MOVE WS-FACTOR-TEMP         TO WS-HOLD-FACT-VAL-RED    
                 MOVE WS-HOLD-FACT-VAL-RED   TO WS-FACTOR-TEXT          
                 MOVE WS-FACTOR-TEXT         TO MI-CHG-COLUMN-VALUE-TEXT
                 MOVE '**************'       TO MI-PRV-COLUMN-VALUE-TEXT
                 MOVE 'BASE AMOUNT    '      TO MI-COLUMN-DESC          
                                                                        
                 PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT        
                 ADD 1                       TO WS-TRAN-APPL-NO         
             END-IF.                                                    
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 5300-PROCESS-UTIL-ENV-CURSOR                                   *        
      ******************************************************************        
       5300-PROCESS-UTIL-ENV-CURSOR.                                    
                                                                        
           IF WS-MTMA-PROCESSING = 'Y'                                  
              MOVE WS-FACTOR-ID-AGLMCF    TO WS-FACTOR-ID               
           END-IF.                                                      
                                                                        
           PERFORM 5400-SELECT-FIXED-FCTR THRU 5400-EXIT.               
                                                                        
           IF WS-MTMA-PROCESSING = 'Y'                                  
              MOVE PARM-FACTOR-ID         TO WS-FACTOR-ID               
           END-IF.                                                      
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
              IF WS-EFF-DT-IN < WS-OLD-EFF-DATE-FROM                    
                  MOVE 98                  TO WS-HOLD-RETCODE           
                  MOVE NOT-FOUND           TO WS-CURSOR-RETURN-CODE     
                  GO TO 5300-EXIT                                       
              END-IF                                                    
                                                                        
              IF PARM-FACTOR-ID = WS-FACTOR-ID-ADD                      
                  COMPUTE WS-FACTOR-DIV-COMP = WS-OLD-FACTOR +          
                                               WS-FACTOR-DIV-COMP       
              END-IF                                                    
              IF PARM-FACTOR-ID = WS-FACTOR-ID-SUB                      
                  COMPUTE WS-FACTOR-DIV-COMP = WS-OLD-FACTOR -          
                                               WS-FACTOR-DIV-COMP       
              END-IF                                                    
                                                                        
DDC2  * IF OLD AND NEW FACTOR EQUAL, INSERT ANYWAY                              
DDC2  ****    IF WS-OLD-FACTOR NOT EQUAL WS-FACTOR-DIV-COMP THEN                
DDC2  *                                                                         
              IF PARM-FACTOR-ID     = WS-FACTOR-ID-SUB AND              
                 WS-FACTOR-DIV-COMP = ZERO                              
                 IF WS-MTMA-PROCESSING = 'Y'                            
                    MOVE WS-FACTOR-ID-AGLMCF TO WS-FACTOR-ID            
                 END-IF                                                 
                 PERFORM 8700-DELETE-FACTOR  THRU 8700-EXIT             
              ELSE                                                      
                 IF WS-MTMA-PROCESSING = 'Y'                            
                    MOVE WS-FACTOR-ID-AGLMCF TO WS-FACTOR-ID            
                 END-IF                                                 
                                                                        
DDC2             PERFORM 5315-GENERATE-DATES THRU 5315-EXIT             
                                                                        
DDC2             IF WS-OLD-EFF-DATE-FROM = WS-EFF-DT-IN                 
DDC2                 PERFORM 8510-UPDATE-DATES THRU 8510-EXIT           
DDC2             ELSE                                                   
      *                                                                         
      *              UPDATE PREVIOUS FACTOS'S EFF-DATE-TO                       
      *                                                                         
DDCT1                PERFORM 8500-UPDATE-EFF-DT-TO THRU 8500-EXIT       
                                                                        
                 END-IF                                                 
      *                                                                         
      *          INSERT NEW FACTOR                                              
      *                                                                         
                 PERFORM 5310-BUILD-INSERT-VAR THRU 5310-EXIT           
                                                                        
DDCT1            COMPUTE WS-MAX-SEQ-NO = WS-MAX-SEQ-NO + 1              
DDCT1            MOVE WS-EFF-DT-IN           TO WS-DATE-FROM-I          
DDCT1            MOVE WS-DATE-TO             TO WS-DATE-TO-I            
DDCT1            PERFORM 8600-INSERT-FACTOR  THRU 8600-EXIT             
DDCT1         END-IF                                                    
                                                                        
      ******************************************************************        
      ******************************************************************        
              MOVE 'Y'                    TO WS-PROCESSED               
              MOVE WS-OLD-FACTOR          TO WS-HOLD-FACT-VAL-RED       
              MOVE WS-HOLD-FACT-VAL-RED   TO WS-FACTOR-TEXT             
              MOVE WS-FACTOR-TEXT         TO                            
                                            MI-PRV-COLUMN-VALUE-TEXT    
              PERFORM 5100-MOVE-TRAN-HEAD             THRU 5100-EXIT    
              PERFORM 5200-MOVE-INS-TRAN-DET          THRU 5200-EXIT    
**************ELSE                                                              
*****************MOVE 'N'                     TO WS-PROCESSED                   
**************END-IF                                                            
           ELSE                                                         
              IF PARM-FACTOR-ID = WS-FACTOR-ID-SUB                      
                 MOVE 100                       TO SQLCODE              
                 MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE
                 MOVE TRAN-ID                   TO ABEND-PROGRAM        
                 MOVE '5400'                    TO ACTIVE-PARAGRAPH     
                 MOVE 'SELECT'                  TO ABEND-FUNCTION       
                 MOVE 'CSS_FIXED_FCTR'          TO TABLE-1              
                 MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1      
                 MOVE 'FACTOR_ID'               TO TABLE-ELEMENT-2      
                 MOVE WS-ACCOUNT-NO-NUM         TO HOSTVAR-ELEMENT-1    
                 MOVE WS-FACTOR-ID              TO HOSTVAR-ELEMENT-2    
                 PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT          
                 PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT          
              END-IF                                                    
              IF PARM-FACTOR-ID = WS-FACTOR-ID-ADD                      
                 MOVE WS-FACTOR-ID-AGLMCF       TO WS-FACTOR-ID         
              END-IF                                                    
                                                                        
              PERFORM 5310-BUILD-INSERT-VAR               THRU 5310-EXIT
                                                                        
      ******************************************************************        
      * SELECT THE MAX SEQENCE NUMBER FROM CSS_FIXED_FCTR IN           *        
      * ORDER TO SELECT DATA ACCORDING TO FIXED FACTOR SEQUENCE        *        
      * NUMBER                                                         *        
      ******************************************************************        
                                                                        
              COMPUTE WS-MAX-SEQ-NO = WS-MAX-SEQ-NO + 1                 
              MOVE WS-DATE-FROM TO WS-DATE-FROM-I                       
              MOVE WS-DATE-TO   TO WS-DATE-TO-I                         
              PERFORM 8600-INSERT-FACTOR                  THRU 8600-EXIT
              PERFORM 7200-GET-CURRENT-TIMESTAMP          THRU 7200-EXIT
AMG           MOVE +1 TO WS-TRAN-APPL-NO                                
           END-IF.                                                      
                                                                        
                                                                        
      ******************************************************************        
      * FETCH FOR A NEW IC NUMBER BASED ON THE                         *        
      * ACCOUNT NUMBER RECEIVED FROM AGL.                              *        
      ******************************************************************        
                                                                        
           PERFORM 7060-FETCH-UTIL-ENV-CURSOR THRU 7060-EXIT.           
                                                                        
       5300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  5310-BUILD-INSERT-VAR                                       **        
      ******************************************************************        
      *                                                                         
       5310-BUILD-INSERT-VAR.                                           
                                                                        
           PERFORM 5100-MOVE-TRAN-HEAD THRU 5100-EXIT.                  
           MOVE '**INSERTED**' TO MI-PRV-COLUMN-VALUE-TEXT.             
           MOVE WS-FACTOR-ID TO FF-FACTOR-ID.                           
           MOVE 0 TO FF-CODE-TIME-PERIOD.                               
           MOVE 0 TO FF-FIXED-FCTR-SEQ-NO.                              
           MOVE 0 TO WS-MAX-SEQ-NO.                                     
           MOVE 'R' TO FF-INSTR-USE-TYPE-CD.                            
           MOVE 'B' TO FF-CODE-SEASON.                                  
           MOVE '10' TO FF-CMPNT-ID-CD.                                 
DDCT1      PERFORM 7100-SELECT-MAX-SEQ-NO THRU 7100-EXIT.               
                                                                        
       5310-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  5315-GENERATE-DATES                                         **        
      ******************************************************************        
      *                                                                         
DDC2   5315-GENERATE-DATES.                                             
                                                                        
      * SUBTRACT 1 DAY FROM WSS-EFF-DATE-IN                                     
           MOVE SPACES TO WS-PREV-FCTR-DT-TO.                           
           EXEC SQL                                                     
               SELECT DATEADD( DAY, -1, IIF(TRY_CONVERT(DATE, 
                                                          :WS-EFF-DT-IN
              ) IS NULL OR (PATINDEX('%.%', :WS-EFF-DT-IN
              ) <> 0) OR (LEN(:WS-EFF-DT-IN) <> 10), CIS.CHAR2DATE(
                                                          :WS-EFF-DT-IN
              ), CONVERT(DATE, :WS-EFF-DT-IN) ) )                      
                 INTO :WS-PREV-FCTR-DT-TO                               
                 FROM CSS_MODEL_SQL                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DATE (:WS-EFF-DT-IN) - 1 DAY                              
MFA-TR*          INTO :WS-PREV-FCTR-DT-TO                                       
MFA-TR*          FROM CSS_MODEL_SQL                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE TRAN-ID                    TO ABEND-PROGRAM          
T22243        MOVE '5315'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT DATE - 1'          TO ABEND-FUNCTION         
              MOVE 'CSS_MODEL-SQL'            TO TABLE-1                
              MOVE 'DIST_ACCT_NO'             TO TABLE-ELEMENT-1        
              MOVE WS-DIST-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
              MOVE WS-EFF-DT-IN               TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       5315-EXIT.                                                       
DDC2       EXIT.                                                        
                                                                        
      *****************************************************************         
      **  5400-SELECT-FIXED-FCTR                                      **        
      ******************************************************************        
      *                                                                         
       5400-SELECT-FIXED-FCTR.                                          
                                                                        
DDCT1 *****PERFORM 5410-GET-MAX-FCTR-SEQ-NO THRU 5410-EXIT.                     
                                                                        
DDCT1 *****IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN                  
DDCT1 *****    NEXT SENTENCE                                                    
DDCT1 *****ELSE                                                                 
DDCT1 *****    GO TO 5400-EXIT.                                                 
                                                                        
DDCT1      PERFORM 5420-GET-MAX-EFF-DT-TO THRU 5420-EXIT.               
                                                                        
DDCT1      IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
DDCT1          NEXT SENTENCE                                            
DDCT1      ELSE                                                         
DDCT1          GO TO 5400-EXIT
           END-IF.                                         
                                                                        
           MOVE SPACES TO WS-OLD-EFF-DATE-FROM.                         
                                                                        
           EXEC SQL                                                     
              SELECT EFF_DATE_FROM, FACTOR                              
                INTO :WS-OLD-EFF-DATE-FROM,                             
                     :WS-OLD-FACTOR                                     
                FROM CSS_FIXED_FCTR                                     
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            
                 AND IC_NO              = :UT-IC-NO                     
                 AND CODE_UTIL_TYPE     = :WS-GAS-UTIL-TYPE             
                 AND FACTOR_ID          = :WS-FACTOR-ID                 
                 AND EFF_DATE_TO        = IIF(TRY_CONVERT(DATE, 
                                                    :WS-MAX-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-EFF-DATE-TO
              ) <> 0) OR (LEN(:WS-MAX-EFF-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:WS-MAX-EFF-DATE-TO
              ), CONVERT(DATE, :WS-MAX-EFF-DATE-TO) )           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT EFF_DATE_FROM, FACTOR                                      
MFA-TR*         INTO :WS-OLD-EFF-DATE-FROM,                                     
MFA-TR*              :WS-OLD-FACTOR                                             
MFA-TR*         FROM CSS_FIXED_FCTR                                             
MFA-TR*        WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM                    
MFA-TR*          AND IC_NO              = :UT-IC-NO                             
MFA-TR*          AND CODE_UTIL_TYPE     = :WS-GAS-UTIL-TYPE                     
MFA-TR*          AND FACTOR_ID          = :WS-FACTOR-ID                         
MFA-TR*          AND EFF_DATE_TO        = :WS-MAX-EFF-DATE-TO                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND THEN             
                  MOVE ZEROES TO WS-OLD-FACTOR                          
              ELSE                                                      
                 MOVE TRAN-ID                 TO ABEND-PROGRAM          
                 MOVE '5400'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE 'CSS_FIXED_FCTR'        TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-2        
                 MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1      
                 MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT
                 PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  5410-GET-MAX-FCTR-SEQ-NO**                                            
      ******************************************************************        
      *                                                                         
DDCT1  5410-GET-MAX-FCTR-SEQ-NO.                                        
                                                                        
           MOVE 0 TO IND-DATE-TO.                                       
                                                                        
           EXEC SQL                                                     
               SELECT MAX(FIXED_FCTR_SEQ_NO)                            
                 INTO :WS-MAX-FCTR-SEQ-NO :IND-DATE-TO                   
                 FROM CSS_FIXED_FCTR                                    
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            
                 AND IC_NO              = :UT-IC-NO                     
                 AND CODE_UTIL_TYPE     = :WS-GAS-UTIL-TYPE             
                 AND FACTOR_ID          = :WS-FACTOR-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               IF IND-DATE-TO < 0 THEN                                  
                   MOVE +100 TO WS-ACTIVE-RETURN-CODE                   
                   MOVE ZEROES TO WS-OLD-FACTOR                         
               END-IF                                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND THEN             
                  MOVE ZEROES TO WS-OLD-FACTOR                          
                  MOVE ZEROES TO WS-MAX-FCTR-SEQ-NO                     
              ELSE                                                      
                 MOVE TRAN-ID                 TO ABEND-PROGRAM          
                 MOVE '5410'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE 'CSS_FIXED_FCTR'        TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-2        
                 MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1      
                 MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT
                 PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5410-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  5420-GET-MAX-EFF-DATE-TO                                    **        
      ******************************************************************        
      *                                                                         
DDCT1  5420-GET-MAX-EFF-DT-TO.                                          
                                                                        
           MOVE 0 TO IND-DATE-TO.                                       
                                                                        
           EXEC SQL                                                     
               SELECT MAX(EFF_DATE_TO)                                  
                 INTO :WS-MAX-EFF-DATE-TO :IND-DATE-TO                   
                 FROM CSS_FIXED_FCTR                                    
               WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM            
                 AND IC_NO              = :UT-IC-NO                     
                 AND CODE_UTIL_TYPE     = :WS-GAS-UTIL-TYPE             
                 AND FACTOR_ID          = :WS-FACTOR-ID                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               IF IND-DATE-TO < 0 THEN                                  
                   MOVE +100 TO WS-ACTIVE-RETURN-CODE                   
                   MOVE ZEROES TO WS-OLD-FACTOR                         
               END-IF                                                   
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND THEN             
                  MOVE ZEROES TO WS-OLD-FACTOR                          
                  MOVE ZEROES TO WS-MAX-FCTR-SEQ-NO                     
              ELSE                                                      
                 MOVE TRAN-ID                 TO ABEND-PROGRAM          
                 MOVE '5420'                  TO ACTIVE-PARAGRAPH       
                 MOVE 'SELECT'                TO ABEND-FUNCTION         
                 MOVE 'CSS_FIXED_FCTR'        TO TABLE-1                
                 MOVE 'ACCOUNT_NO'            TO TABLE-ELEMENT-1        
                 MOVE 'FACTOR_ID'             TO TABLE-ELEMENT-2        
                 MOVE WS-ACCOUNT-NO-NUM       TO HOSTVAR-ELEMENT-1      
                 MOVE WS-FACTOR-ID            TO HOSTVAR-ELEMENT-2      
                 PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT
                 PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT
              END-IF                                                    
           END-IF.                                                      
                                                                        
       5420-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **  6530-TRANS HISTORY COPYBOOK                                 **        
      ******************************************************************        
      *                                                                         
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      **  OPENS UTIL-ENV CURSOR TO GET THE IC_NO                      **        
      ******************************************************************        
       7050-OPEN-UTIL-ENV-CURSOR.                                       
      *                                                                         
           EXEC SQL                                                     
              OPEN UTIL_ENV                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CURSOR-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE TRAN-ID                    TO ABEND-PROGRAM          
              MOVE 'OPEN UTIL_ENV'            TO ABEND-FUNCTION         
              MOVE SPACES                     TO ABEND-TABLES           
              MOVE '7050'                     TO ACTIVE-PARAGRAPH       
              MOVE WS-CURSOR-RETURN-CODE      TO ABEND-SQL-PREDICATES   
              MOVE 'OPEN UTIL_ENV CURSOR'     TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE-UTIL-TYPE'           TO TABLE-ELEMENT-2        
              MOVE WS-ACCOUNT-NO-NUM          TO HOSTVAR-ELEMENT-1      
              MOVE WS-GAS-UTIL-TYPE           TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **  FETCHES IC_NO FROM THE UTIL_ENVRNMT TABLE.                  **        
      ******************************************************************        
       7060-FETCH-UTIL-ENV-CURSOR.                                      
                                                                        
           MOVE '7060'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           EXEC SQL                                                     
              FETCH UTIL_ENV                                            
               INTO :UT-IC-NO :IV-IC-NO                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 WS-CURSOR-RETURN-CODE. 
                                                                        
           IF WS-CURSOR-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE TRAN-ID                    TO ABEND-PROGRAM          
              MOVE 'CURSOR UTIL_ENV'          TO ABEND-TABLES           
              MOVE 'EETCH'                    TO ABEND-FUNCTION         
              MOVE '7060'                     TO ACTIVE-PARAGRAPH       
              MOVE WS-CURSOR-RETURN-CODE      TO ABEND-SQL-PREDICATES   
              MOVE 'FETCH UTIL_ENV CURSOR'    TO TABLE-1                
              MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
              MOVE 'CODE_UTIL_TYPE'           TO TABLE-ELEMENT-2        
              MOVE WS-ACCOUNT-NO-NUM          TO HOSTVAR-ELEMENT-1      
              MOVE WS-GAS-UTIL-TYPE           TO HOSTVAR-ELEMENT-2      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7060-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **  CLOSE UTIL-ENV CURSOR TO GET THE IC_NO                      **        
      ******************************************************************        
       7070-CLOSE-UTIL-ENV-CURSOR.                                      
      *                                                                         
           EXEC SQL                                                     
              CLOSE UTIL_ENV                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE SPACES                     TO ABEND-TABLES           
              MOVE '7070'                     TO ACTIVE-PARAGRAPH       
              MOVE SPACES                     TO ABEND-SQL-PREDICATES   
              MOVE 'CLOSE UTIL_ENV CURSOR'    TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7070-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-SELECT-MAX-SEQ-NO                                         *        
      ******************************************************************        
       7100-SELECT-MAX-SEQ-NO.                                          
                                                                        
           EXEC SQL                                                     
              SELECT MAX(FIXED_FCTR_SEQ_NO)                             
                INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND                  
                FROM CSS_FIXED_FCTR                                     
               WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM             
                 AND CODE_UTIL_TYPE    = :WS-GAS-UTIL-TYPE              
                 AND IC_NO             = :UT-IC-NO                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE FF-FIXED-FCTR-SEQ-NO TO WS-MAX-SEQ-NO.                  
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              MOVE FF-FIXED-FCTR-SEQ-NO TO WS-MAX-SEQ-NO                
           ELSE                                                         
              MOVE TRAN-ID                    TO ABEND-PROGRAM          
              MOVE '7100'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT MAX SEQ NO'        TO ABEND-FUNCTION         
              MOVE 'CSS_FIXED_FCTR'           TO TABLE-1                
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-GET-CURRENT-TIMESTAMP                                     *        
      ******************************************************************        
       7200-GET-CURRENT-TIMESTAMP.                                      
                                                                        
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.')                 
                INTO :MH-TRANS-HIST-SEQ-NO                              
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP                                          
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO                                      
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE SPACES  TO ABEND-TABLES                             
T22243         MOVE '7200'  TO ACTIVE-PARAGRAPH                         
               MOVE SPACES  TO ABEND-SQL-PREDICATES                     
               MOVE 'CSS_MODEL_SQL' TO TABLE-1                          
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-ACCOUNT-NO                                         *        
      ******************************************************************        
       7300-SELECT-ACCOUNT-NO.                                          
                                                                        
           EXEC SQL                                                     
              SELECT XM.ACCOUNT_NO,                                     
                     AT.CODE_ACCT_STAT,                                 
T22243               AT.COMPANY_NO,                                     
                     AT.REV_MTH_LST_NRML                                
                INTO :WS-ACCOUNT-NO-NUM,                                
                     :AT-CODE-ACCT-STAT,                                
T22243               :AT-COMPANY-NO,                                    
                     :AT-REV-MTH-LST-NRML                               
                FROM CSS_MKT_XREF_ACCT XM,                              
                     CSS_ACCOUNT AT                                     
               WHERE AT.ACCOUNT_NO   = XM.ACCOUNT_NO                    
                 AND XM.DIST_ACCT_NO = :WS-DIST-ACCOUNT-NO              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
              MOVE WS-ACCOUNT-NO-NUM TO AT-ACCOUNT-NO                   
           ELSE                                                         
              MOVE TRAN-ID                    TO ABEND-PROGRAM          
T22243        MOVE '7300'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT ACCOUNT NO'        TO ABEND-FUNCTION         
              MOVE 'CSS_MKT_XREF_ACCT'        TO TABLE-1                
              MOVE 'CSS_ACCOUNT'              TO TABLE-2                
              MOVE 'DIST_ACCT_NO'             TO TABLE-ELEMENT-1        
              MOVE WS-DIST-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8000-UPDATE-MTR-CAP                                            *        
      ******************************************************************        
       8000-UPDATE-MTR-CAP.                                             
                                                                        
               EXEC SQL                                                 
                UPDATE CSS_MTR_CAP                                      
                    SET CONSTANT = :MC-CONSTANT                         
T22243            WHERE COMPANY_NO     = :MC-COMPANY-NO                 
                    AND CODE_UTIL_TYPE = :WS-GAS-UTIL-TYPE              
                    AND METER_NO       = :MC-METER-NO                   
                    AND REG_ID_NO      = 1                              
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE. 
                                                                        
               IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL           
                  NEXT SENTENCE                                         
               ELSE                                                     
                  MOVE TRAN-ID             TO ABEND-PROGRAM             
                  MOVE '8000'              TO ACTIVE-PARAGRAPH          
                  MOVE 'UPDATE'            TO ABEND-FUNCTION            
                  MOVE 'CSS_MTR_CAP'       TO TABLE-1                   
                  MOVE 'CODE_UTIL_TYPE'    TO TABLE-ELEMENT-1           
                  MOVE 'METER_NO'          TO TABLE-ELEMENT-2           
                  MOVE 'REG_ID_NO'         TO TABLE-ELEMENT-3           
T22243            MOVE 'COMPANY_NO'        TO TABLE-ELEMENT-4           
                  MOVE WS-GAS-UTIL-TYPE    TO HOSTVAR-ELEMENT-1         
                  MOVE MC-METER-NO         TO HOSTVAR-ELEMENT-2         
                  MOVE '1'                 TO HOSTVAR-ELEMENT-3         
T22243            MOVE MC-COMPANY-NO       TO HOSTVAR-ELEMENT-4         
                  PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
               END-IF.                                                  
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8500-UPDATE-EFF-DT-TO                                                   
      ******************************************************************        
       8500-UPDATE-EFF-DT-TO.                                           
                                                                        
               EXEC SQL                                                 
                UPDATE CSS_FIXED_FCTR                                   
DDCT1               SET EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                    :WS-PREV-FCTR-DT-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-FCTR-DT-TO
              ) <> 0) OR (LEN(:WS-PREV-FCTR-DT-TO
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-FCTR-DT-TO
              ), CONVERT(DATE, :WS-PREV-FCTR-DT-TO) ),        
                        LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )       
                  WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM          
                    AND IC_NO             = :UT-IC-NO                   
                    AND CODE_UTIL_TYPE    = :WS-GAS-UTIL-TYPE           
                    AND FACTOR_ID         = :WS-FACTOR-ID               
DDCT1               AND EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                    :WS-MAX-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-EFF-DATE-TO
              ) <> 0) OR (LEN(:WS-MAX-EFF-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:WS-MAX-EFF-DATE-TO
              ), CONVERT(DATE, :WS-MAX-EFF-DATE-TO) )         
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                         
MFA-TR*         UPDATE CSS_FIXED_FCTR                                           
MFA-TR*             SET EFF_DATE_TO       = :WS-PREV-FCTR-DT-TO,                
MFA-TR*                 LAST_UPDATE_TS    = :MH-TRANS-HIST-SEQ-NO               
MFA-TR*           WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM                  
MFA-TR*             AND IC_NO             = :UT-IC-NO                           
MFA-TR*             AND CODE_UTIL_TYPE    = :WS-GAS-UTIL-TYPE                   
MFA-TR*             AND FACTOR_ID         = :WS-FACTOR-ID                       
MFA-TR*             AND EFF_DATE_TO       = :WS-MAX-EFF-DATE-TO                 
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                               WS-UPDATE-RETURN-CODE.                   
                                                                        
               EVALUATE SQLCODE                                         
                  WHEN 0                                                
                     MOVE 'Y'  TO WS-UPDATE-SUCCESSFUL                  
                  WHEN 100                                              
                     MOVE 'Y'  TO WS-UPDATE-SUCCESSFUL                  
                  WHEN OTHER                                            
                     MOVE TRAN-ID             TO ABEND-PROGRAM          
                     MOVE '8500'              TO ACTIVE-PARAGRAPH       
                     MOVE 'UPDATE'            TO ABEND-FUNCTION         
                     MOVE 'CSS_FIXED_FCTR'    TO TABLE-1                
                     MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1        
                     MOVE 'FACTOR_ID'         TO TABLE-ELEMENT-2        
                     MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1      
                     MOVE WS-FACTOR-TYP-CD    TO HOSTVAR-ELEMENT-2      
                     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT     
                     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT     
                  END-EVALUATE.                                         
                                                                        
       8500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8510-UPDATE-DATES                                                       
      ******************************************************************        
       8510-UPDATE-DATES.                                               
                                                                        
               EXEC SQL                                                 
                UPDATE CSS_FIXED_FCTR                                   
DDCT1               SET EFF_DATE_FROM     = IIF(TRY_CONVERT(DATE, 
                                                    :WS-PREV-FCTR-DT-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-FCTR-DT-TO
              ) <> 0) OR (LEN(:WS-PREV-FCTR-DT-TO
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-FCTR-DT-TO
              ), CONVERT(DATE, :WS-PREV-FCTR-DT-TO) ),        
DDCT1                   EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                    :WS-PREV-FCTR-DT-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-PREV-FCTR-DT-TO
              ) <> 0) OR (LEN(:WS-PREV-FCTR-DT-TO
              ) <> 10), CIS.CHAR2DATE(:WS-PREV-FCTR-DT-TO
              ), CONVERT(DATE, :WS-PREV-FCTR-DT-TO) ),        
                        LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :MH-TRANS-HIST-SEQ-NO
              )       
                  WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM          
                    AND IC_NO             = :UT-IC-NO                   
                    AND CODE_UTIL_TYPE    = :WS-GAS-UTIL-TYPE           
                    AND FACTOR_ID         = :WS-FACTOR-ID               
DDCT1               AND EFF_DATE_TO       = IIF(TRY_CONVERT(DATE, 
                                                    :WS-MAX-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :WS-MAX-EFF-DATE-TO
              ) <> 0) OR (LEN(:WS-MAX-EFF-DATE-TO
              ) <> 10), CIS.CHAR2DATE(:WS-MAX-EFF-DATE-TO
              ), CONVERT(DATE, :WS-MAX-EFF-DATE-TO) )         
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                         
MFA-TR*         UPDATE CSS_FIXED_FCTR                                           
MFA-TR*             SET EFF_DATE_FROM     = :WS-PREV-FCTR-DT-TO,                
MFA-TR*                 EFF_DATE_TO       = :WS-PREV-FCTR-DT-TO,                
MFA-TR*                 LAST_UPDATE_TS    = :MH-TRANS-HIST-SEQ-NO               
MFA-TR*           WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO-NUM                  
MFA-TR*             AND IC_NO             = :UT-IC-NO                           
MFA-TR*             AND CODE_UTIL_TYPE    = :WS-GAS-UTIL-TYPE                   
MFA-TR*             AND FACTOR_ID         = :WS-FACTOR-ID                       
MFA-TR*             AND EFF_DATE_TO       = :WS-MAX-EFF-DATE-TO                 
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                               WS-UPDATE-RETURN-CODE.                   
                                                                        
               EVALUATE SQLCODE                                         
                  WHEN 0                                                
                     MOVE 'Y'  TO WS-UPDATE-SUCCESSFUL                  
                  WHEN 100                                              
                     MOVE 'Y'  TO WS-UPDATE-SUCCESSFUL                  
                  WHEN OTHER                                            
                     MOVE TRAN-ID             TO ABEND-PROGRAM          
                     MOVE '8500'              TO ACTIVE-PARAGRAPH       
                     MOVE 'UPDATE'            TO ABEND-FUNCTION         
                     MOVE 'CSS_FIXED_FCTR'    TO TABLE-1                
                     MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1        
                     MOVE 'FACTOR_ID'         TO TABLE-ELEMENT-2        
                     MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1      
                     MOVE WS-FACTOR-TYP-CD    TO HOSTVAR-ELEMENT-2      
                     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT     
                     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT     
                  END-EVALUATE.                                         
                                                                        
       8510-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8600-INSERT-FACTOR                                             *        
      ******************************************************************        
       8600-INSERT-FACTOR.                                              
                                                                        
               EXEC SQL                                                 
                  INSERT INTO CSS_FIXED_FCTR                            
                        ( ACCOUNT_NO                                    
                        , CODE_UTIL_TYPE                                
                        , IC_NO                                         
                        , FIXED_FCTR_SEQ_NO                             
                        , FACTOR_ID                                     
                        , EFF_DATE_FROM                                 
                        , CMPNT_ID_CD                                   
                        , CODE_SEASON                                   
                        , INSTR_USE_TYPE_CD                             
                        , CODE_TIME_PERIOD                              
                        , EFF_DATE_TO                                   
                        , FIXED_FCTR_TYP_CD                             
                        , FACTOR                                        
                        , FAC_CHRG_BASE_AM                              
                        , LAST_UPDATE_TS)                               
                  VALUES (:WS-ACCOUNT-NO-NUM                            
                        , :WS-GAS-UTIL-TYPE                             
                        , :UT-IC-NO                                     
                        , :WS-MAX-SEQ-NO                                
                        , :FF-FACTOR-ID                                 
                        , IIF(TRY_CONVERT(DATE, :WS-DATE-FROM-I
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-FROM-I
              ) <> 0) OR (LEN(:WS-DATE-FROM-I) <> 10), CIS.CHAR2DATE(
                                                        :WS-DATE-FROM-I
              ), CONVERT(DATE, :WS-DATE-FROM-I) )                              
                        , :FF-CMPNT-ID-CD                               
                        , :FF-CODE-SEASON                               
                        , :FF-INSTR-USE-TYPE-CD                         
                        , :FF-CODE-TIME-PERIOD                          
                        , IIF(TRY_CONVERT(DATE, :WS-DATE-TO-I
              ) IS NULL OR (PATINDEX('%.%', :WS-DATE-TO-I
              ) <> 0) OR (LEN(:WS-DATE-TO-I) <> 10), CIS.CHAR2DATE(
                                                          :WS-DATE-TO-I
              ), CONVERT(DATE, :WS-DATE-TO-I) )                                
                        , :WS-FACTOR-TYP-CD                             
                        , :WS-FACTOR-DIV-COMP                           
                        , :WS-FAC-CHRG-BASE-AM                          
                        , CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO))            
               END-EXEC.                                                

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*        EXEC SQL                                                         
MFA-TR*           INSERT INTO CSS_FIXED_FCTR                                    
MFA-TR*                 ( ACCOUNT_NO                                            
MFA-TR*                 , CODE_UTIL_TYPE                                        
MFA-TR*                 , IC_NO                                                 
MFA-TR*                 , FIXED_FCTR_SEQ_NO                                     
MFA-TR*                 , FACTOR_ID                                             
MFA-TR*                 , EFF_DATE_FROM                                         
MFA-TR*                 , CMPNT_ID_CD                                           
MFA-TR*                 , CODE_SEASON                                           
MFA-TR*                 , INSTR_USE_TYPE_CD                                     
MFA-TR*                 , CODE_TIME_PERIOD                                      
MFA-TR*                 , EFF_DATE_TO                                           
MFA-TR*                 , FIXED_FCTR_TYP_CD                                     
MFA-TR*                 , FACTOR                                                
MFA-TR*                 , FAC_CHRG_BASE_AM                                      
MFA-TR*                 , LAST_UPDATE_TS)                                       
MFA-TR*           VALUES (:WS-ACCOUNT-NO-NUM                                    
MFA-TR*                 , :WS-GAS-UTIL-TYPE                                     
MFA-TR*                 , :UT-IC-NO                                             
MFA-TR*                 , :WS-MAX-SEQ-NO                                        
MFA-TR*                 , :FF-FACTOR-ID                                         
MFA-TR*                 , :WS-DATE-FROM-I                                       
MFA-TR*                 , :FF-CMPNT-ID-CD                                       
MFA-TR*                 , :FF-CODE-SEASON                                       
MFA-TR*                 , :FF-INSTR-USE-TYPE-CD                                 
MFA-TR*                 , :FF-CODE-TIME-PERIOD                                  
MFA-TR*                 , :WS-DATE-TO-I                                         
MFA-TR*                 , :WS-FACTOR-TYP-CD                                     
MFA-TR*                 , :WS-FACTOR-DIV-COMP                                   
MFA-TR*                 , :WS-FAC-CHRG-BASE-AM                                  
MFA-TR*                 , :MH-TRANS-HIST-SEQ-NO)                                
MFA-TR*        END-EXEC.                                                        

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                   
                                                                        
               EVALUATE SQLCODE                                         
                  WHEN 0                                                
                     PERFORM 5200-MOVE-INS-TRAN-DET  THRU 5200-EXIT     
                  WHEN OTHER                                            
                     MOVE TRAN-ID             TO ABEND-PROGRAM          
                     MOVE '8600'              TO ACTIVE-PARAGRAPH       
                     MOVE 'INSERT'            TO ABEND-FUNCTION         
                     MOVE 'CSS_FIXED_FCTR'    TO TABLE-1                
                     MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1        
                     MOVE 'FACTOR_ID'         TO TABLE-ELEMENT-2        
                     MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1      
                     MOVE FF-FACTOR-ID        TO HOSTVAR-ELEMENT-2      
                     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT     
                     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT     
                  END-EVALUATE.                                         
                                                                        
       8600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 8700-DELETE-FACTOR                                                      
      ******************************************************************        
       8700-DELETE-FACTOR.                                              
                                                                        
               EXEC SQL                                                 
                DELETE FROM CSS_FIXED_FCTR                              
                  WHERE ACCOUNT_NO         = :WS-ACCOUNT-NO-NUM         
                    AND IC_NO              = :UT-IC-NO                  
                    AND CODE_UTIL_TYPE     = :WS-GAS-UTIL-TYPE          
                    AND FACTOR_ID          = :WS-FACTOR-ID              
                    AND FIXED_FCTR_SEQ_NO  = :WS-MAX-FCTR-SEQ-NO        
               END-EXEC.                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
               MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                    
                               WS-UPDATE-RETURN-CODE.                   
                                                                        
               EVALUATE SQLCODE                                         
                  WHEN 0                                                
                     MOVE 'Y'  TO WS-UPDATE-SUCCESSFUL                  
                  WHEN 100                                              
                     MOVE 'N'  TO WS-UPDATE-SUCCESSFUL                  
                  WHEN OTHER                                            
                     MOVE TRAN-ID             TO ABEND-PROGRAM          
T22243               MOVE '8700'              TO ACTIVE-PARAGRAPH       
                     MOVE 'UPDATE'            TO ABEND-FUNCTION         
                     MOVE 'CSS_FIXED_FCTR'    TO TABLE-1                
                     MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1        
                     MOVE 'FACTOR_ID'         TO TABLE-ELEMENT-2        
                     MOVE WS-ACCOUNT-NO-NUM   TO HOSTVAR-ELEMENT-1      
                     MOVE WS-FACTOR-TYP-CD    TO HOSTVAR-ELEMENT-2      
                     PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT     
                     PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT     
               END-EVALUATE.                                            
                                                                        
       8700-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
CVT999*    COPY CPD00302.                                                       
                                                                        
                                                                        
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
