       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02377.                                         
COB303 DATE-WRITTEN.  SEPTEMBER 29, 1999.                               
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00080000
      *                                                                *00090000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00100000
      *                                                                *00110000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00120000
      *                                                                *00130000
      *  TRANID:        S377.                                          *00140000
      *  PROGRAM:       S377.                                          *00150000
      *  CALLING SP:    PA_S377.                                       *00160000
      *                                                                *00170000
      ******************************************************************00180000
      *                 P R O G R A M  S U M M A R Y                   *00190000
      *                                                                *00200000
      * THIS PROGRAM RETRIEVES OVERAGE/SHORTAGE AND NET CURRENCY AMOUNT*00210000
      * FOR EACH CURRENCY TYPE, FOR A CASHIER AND DATE.                *00220000
      *                                                                *        
      ******************************************************************00230000
      *                                                                *00240000
      *                     PROGRAM MODIFICATION LOG                   *00250000
      *                                                                *00260000
      *    DATE    INITIALS   COMMENTS                                 *00270000
      *  --------  --------   ---------------------------------------  *00280000
      *  09/29/99  CBSI       ORIGINALLY CODED                         *00280000
REARCH*  05/27/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
C33001*  10/01/07  LG41184    TO FIX 'SELECT FAILED WITH 100' DUE TO   *        
C33001*                       REMOVAL OF LIHEAP TYPE FROM CSS_CURRENCY *        
C33001*                       USER TABLE.                              *        
      ******************************************************************01310000
      ******************************************************************01320000
      *                                                                *01330000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *01340000
      *                                                                *01350000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *01360000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *01370000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *01380000
      *  3000 - 4999  NOT USED                                         *01390000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *01400000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *01410000
      *  7000 - 7999  INPUT MODULES                                    *01420000
      *  8000 - 8999  OUTPUT MODULES                                   *01430000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *01440000
      *                                                                *01450000
      ******************************************************************01460000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02377'.
MSQ017     COPY MFASQLM.
       01  WS-START                    PIC X(40)       VALUE            
REARCH     'WORKING STORAGE FOR CSR02377 STARTS HERE'.                  
                                                                        
      ******************************************************************01550000
      *    COBOL WORKING STORAGE COPY BOOKS                            *01560000
      ******************************************************************01570000
                                                                        
REARCH*    COPY SYGWCOB.                                                01590000
REARCH*    COPY SYDBCOB.                                                01600000
REARCH*    COPY CWS00010.                                               01650000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
REARCH*                                                                         
           COPY CWS00303.                                               01700000
           COPY CJF00101.                                               01700000
                                                                        
      ******************************************************************01760000
      *    WORK AREAS                                                  *01770000
      ******************************************************************01780000
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                          03480000
REARCH*    05  GWL-PROC                POINTER.                         03490000
REARCH*    05  GWL-INIT-HANDLE         POINTER.                         03500000
REARCH*    05  GWL-RC                  PIC S9(9)       COMP.            03510000
REARCH*    05  GWL-STATUS-NR           PIC S9(9)       COMP.            03520000
REARCH*    05  GWL-STATUS-DONE         PIC S9(9)       COMP.            03530000
REARCH*    05  GWL-STATUS-COUNT        PIC S9(9)       COMP.            03540000
REARCH*    05  GWL-STATUS-COMM         PIC S9(9)       COMP.            03550000
REARCH*    05  GWL-STATUS-RETURN-CODE  PIC S9(9)       COMP.            03560000
REARCH*    05  GWL-STATUS-SUBCODE      PIC S9(9)       COMP.            03570000
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02377_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
       01  FILLER                      PIC X(11)       VALUE            
                                                       'PARM FIELDS'.   
REARCH*01  PARM-FIELDS.                                                 03600000
REARCH*    05  PARM-L                  PIC S9(09)      COMP.            03610000
REARCH*    05  PARM-ID1                PIC S9(09)      COMP             03620000
REARCH*                                                VALUE 1.                 
REARCH*    05  PARM-COMPANY-NO         PIC X(02).                       03630000
REARCH*    05  PARM-CASH-LOCAL-OFFICE  PIC X(03).                       03630000
REARCH*    05  PARM-USER-ID            PIC X(07).                       03630000
REARCH*    05  PARM-DATE-CASH-REPORT   PIC X(10).                       03630000
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9)       COMP.            
           05  SNA-CONNECTION-NAME     PIC X(8)        VALUE SPACES.    
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9)       COMP             
                                                       VALUE 1.         
           05  CTR-ROWS                PIC S9(9)       COMP             
                                                       VALUE 0.         
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9)       COMP.            
           05  WRKLEN1                 PIC S9(9)       COMP.            
           05  WRKLEN2                 PIC S9(9)       COMP.            
           05  WRK-DONE-STATUS         PIC S9(9)       COMP.            
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08)       VALUE 'CSR02377'.
REARCH     05  WS-SQLSTATE             PIC X(05)       VALUE SPACES.    
           05  ALL-DONE-SW             PIC X(01)       VALUE 'N'.       
               88 NOT-ALL-DONE                         VALUE 'N'.       
               88 ALL-DONE                             VALUE 'Y'.       
           05  SEND-DONE-SW            PIC X(01)       VALUE 'Y'.       
               88 SEND-DONE-ERROR                      VALUE 'N'.       
               88 SEND-DONE-OK                         VALUE 'Y'.       
                                                                        
       01  WS-WORK-FIELDS.                                              
           05  WS-RETURN-CODE          PIC S9(09)      VALUE +000 COMP. 
           05  WS-PREV-CURRENCY        PIC X(01).                       
           05  WS-CURRENCY-CASH-DESC   PIC X(20)       VALUE 'CASH'.    
           05  WS-CURRENCY-CHEQUE-DESC PIC X(20)       VALUE 'CHECK'.   
           05  WS-CURRENCY-CASH-TYPE   PIC X(01)       VALUE 'A'.       
           05  WS-CURRENCY-CHEQUE-TYPE PIC X(01)       VALUE 'C'.       
           05  WS-TRANID-OVERAGE       PIC X(04)       VALUE 'O412'.    
           05  WS-TRANID-SHORTAGE      PIC X(04)       VALUE 'S412'.    
           05  WS-CLEAR-CASH           PIC X(08)       VALUE            
                                                      'CLR-CASH'.       
COB305     05 WS-CLR-CASH-ACCT-NO        PIC S9(03)V9(04) COMP-3 
COB305       VALUE 0.          
COB305     05 WS-GL-ACCT-NO        PIC S9(03)V9(04) COMP-3 VALUE 0.          
           05  WS-CASH-GL-NUM          PIC X(01)       VALUE 'N'.       
           05  WS-LIHEAP-PMT           PIC X(01)       VALUE 'N'.       
           05  WS-LIHEAP-RVSL          PIC X(01)       VALUE 'N'.       
           05  WS-GL-ACCT-NO-ED        PIC 9(03).9(04).                 
                                                                        
       01  WS-FLAG-VALUES.                                              
           05  WS-YES                  PIC X           VALUE 'Y'.       
           05  WS-NO                   PIC X           VALUE 'N'.       
           05  WS-CASH-FLAG            PIC X           VALUE 'N'.       
           05  WS-CHEQUE-FLAG          PIC X           VALUE 'N'.       
           05  WS-CHECK-FLAG           PIC X           VALUE 'Y'.       
           05  WS-GL-ACCT-FLAG         PIC X           VALUE 'N'.       
                                                                        
       01  FILLER                      PIC X(32)       VALUE            
                'THIS IS THE ROW RETURN AREA.'.                         
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(09)      COMP             
                                                       VALUE 0.         
           05  RS-CURRENCY-TYPE        PIC X(01).                       
           05  RS-CURRENCY-DESC        PIC X(20).                       
COB305     05 RS-TOTAL-AMOUNT-OVERAGE        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.          
COB305     05 RS-TOTAL-AMOUNT-SHORTAGE        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.          
COB305     05 RS-TOTAL-ADJUSTMENTS        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.          
COB305     05 RS-NET-CURRENCY-TOTAL        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.          
           05  RS-REPORT-STATUS        PIC X(01).                       
           05  RS-BATCH-STATUS         PIC X(01).                       
           05  RS-BATCH-NUMBER         PIC S9(04)      COMP.            
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE          PIC S9(09)      COMP              
REARCH                                                VALUE 0.          
REARCH     05  S-CURRENCY-TYPE        PIC X(01).                        
REARCH     05  S-CURRENCY-DESC        PIC X(20).                        
COB305     05 S-TOTAL-AMOUNT-OVERAGE        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.           
COB305     05 S-TOTAL-AMOUNT-SHORTAGE        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.           
COB305     05 S-TOTAL-ADJUSTMENTS        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.           
COB305     05 S-NET-CURRENCY-TOTAL        PIC S9(11)V9(02) COMP-3 
COB305       VALUE 0.           
REARCH     05  S-REPORT-STATUS        PIC X(01).                        
REARCH     05  S-BATCH-STATUS         PIC X(01).                        
REARCH     05  S-BATCH-NUMBER         PIC S9(04)      COMP.             
                                                                        
REARCH*01  CN-COLUMN-NAMES.                                             04530000
REARCH*    05  CN-RETURN-CODE          PIC X(11)       VALUE                    
REARCH*                               'RETURN_CODE'.                            
REARCH*    05  CN-CURRENCY-TYPE        PIC X(13)       VALUE                    
REARCH*                               'CURRENCY_TYPE'.                  05740000
REARCH*    05  CN-CURRENCY-DESC        PIC X(13)       VALUE                    
REARCH*                               'CURRENCY_DESC'.                  05740000
REARCH*    05  CN-TOTAL-AMOUNT-OVERAGE PIC X(20)       VALUE                    
REARCH*                               'TOTAL_AMOUNT_OVERAGE'.           05740000
REARCH*    05  CN-TOTAL-AMOUNT-SHORTAGE                                         
REARCH*                                PIC X(21)       VALUE                    
REARCH*                               'TOTAL_AMOUNT_SHORTAGE'.          05740000
REARCH*    05  CN-TOTAL-ADJUSTMENTS    PIC X(17)       VALUE                    
REARCH*                               'TOTAL_ADJUSTMENTS'.                      
REARCH*    05  CN-NET-CURRENCY-TOTAL   PIC X(18)       VALUE                    
REARCH*                               'NET_CURRENCY_TOTAL'.             05740000
REARCH*    05  CN-REPORT-STATUS        PIC X(13)       VALUE                    
REARCH*                               'REPORT_STATUS'.                  05740000
REARCH*    05  CN-BATCH-STATUS         PIC X(12)       VALUE                    
REARCH*                               'BATCH_STATUS'.                   05740000
REARCH*    05  CN-BATCH-NUMBER         PIC X(12)       VALUE                    
REARCH*                               'BATCH_NUMBER'.                   05740000
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
      *                                                                         
           EXEC SQL                                                             
                INCLUDE  SQLCA                                          05750000
           END-EXEC.                                                    05760000
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_JRNL                                      *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBCDJRNL                                               
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_CSH_DRWR_CNTL                                      *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBCDCNTL                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_CSS_GL_ACCT_NO                                     *             
      *************************************************************             
           EXEC SQL                                                             
                INCLUDE  TBGLATNO                                               
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_LIEAP_AGENCY                                       *             
      *************************************************************             
                                                                        
           EXEC SQL                                                             
                INCLUDE  TBLIAGCY                                               
           END-EXEC.                                                            
                                                                        
      *************************************************************             
      *    CSS_CSH_REPORT_HDR                                     *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBCSRPHD                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      *************************************************************             
      *    CSS_CURRENCY                                           *             
      *************************************************************             
           EXEC SQL                                                     05860000
                INCLUDE  TBCURRCY                                       05870000
           END-EXEC.                                                    05880000
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_CSH_DRWR_CNTL                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE DRWR_CNTL_CURSOR CURSOR FOR                     
                 SELECT CASH_DRAWER_ID,                                 
                        CODE_CSH_DRWR_STAT                              
                   FROM CSS_CSH_DRWR_CNTL                               
                  WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO         
                    AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE       
                    AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )        
                    AND USER_ID           = :CS-USER-ID                 
               ORDER BY CASH_DRAWER_ID DESC                             
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE DRWR_CNTL_CURSOR CURSOR FOR                             
MFA-TR*          SELECT CASH_DRAWER_ID,                                         
MFA-TR*                 CODE_CSH_DRWR_STAT                                      
MFA-TR*            FROM CSS_CSH_DRWR_CNTL                                       
MFA-TR*           WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                 
MFA-TR*             AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE               
MFA-TR*             AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                
MFA-TR*             AND USER_ID           = :CS-USER-ID                         
MFA-TR*        ORDER BY CASH_DRAWER_ID DESC                                     
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************06900000
      *          CURSOR FOR CSS_CSH_DRWR_JRNL                          *06910000
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE JRNL_TRANS_CURSOR CURSOR FOR                    
                 SELECT CURRENCY_TYPE,                                  
                        TRAN_ID,                                        
                        TRAN_DATA                                       
                   FROM CSS_CSH_DRWR_JRNL                               
                  WHERE CASH_COMPANY_NO   = :CJ-CASH-COMPANY-NO         
                    AND CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE       
                    AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CJ-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CJ-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CJ-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CJ-DATE-CASH-REPORT
              ), CONVERT(DATE, :CJ-DATE-CASH-REPORT) )        
                    AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID          
               ORDER BY CURRENCY_TYPE ASC                               
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06920000
MFA-TR*         DECLARE JRNL_TRANS_CURSOR CURSOR FOR                    06930000
MFA-TR*          SELECT CURRENCY_TYPE,                                  06940000
MFA-TR*                 TRAN_ID,                                        06950000
MFA-TR*                 TRAN_DATA                                               
MFA-TR*            FROM CSS_CSH_DRWR_JRNL                                       
MFA-TR*           WHERE CASH_COMPANY_NO   = :CJ-CASH-COMPANY-NO                 
MFA-TR*             AND CASH_LOCAL_OFFICE = :CJ-CASH-LOCAL-OFFICE               
MFA-TR*             AND DATE_CASH_REPORT  = :CJ-DATE-CASH-REPORT                
MFA-TR*             AND CASH_DRAWER_ID    = :CS-CASH-DRAWER-ID                  
MFA-TR*        ORDER BY CURRENCY_TYPE ASC                                       
MFA-TR*    END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *        CURSOR FOR CSS_LIEAP_AGENCY                             *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                DECLARE LIEAP_CURSOR CURSOR FOR                         
                 SELECT :WS-YES                                         
                   FROM CSS_LIEAP_AGENCY                                
                  WHERE GL_ACCT_NO  = :I5-GL-ACCT-NO                    
               OPTION(FAST 1)                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ021
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE LIEAP_CURSOR CURSOR FOR                                 
MFA-TR*          SELECT :WS-YES                                                 
MFA-TR*            FROM CSS_LIEAP_AGENCY                                        
MFA-TR*           WHERE GL_ACCT_NO  = :I5-GL-ACCT-NO                            
MFA-TR*        OPTIMIZE FOR 1 ROW                                               
MFA-TR*    END-EXEC.                                                            
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-COMPANY-NO         PIC X(02).                           
REARCH 01  PARM-CASH-LOCAL-OFFICE  PIC X(03).                           
REARCH 01  PARM-USER-ID            PIC X(07).                           
REARCH 01  PARM-DATE-CASH-REPORT   PIC X(10).                           
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-COMPANY-NO                         
REARCH                          PARM-CASH-LOCAL-OFFICE                  
REARCH                          PARM-USER-ID                            
REARCH                          PARM-DATE-CASH-REPORT.                  
REARCH*                                                                         
      ******************************************************************07600000
      * 0000-MAINLINE                                                  *07610000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *07620000
      ******************************************************************07630000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE             THRU 0100-EXIT.          
           PERFORM 1000-PROCESS-INPUT          THRU 1000-EXIT.          
           PERFORM 2000-PROCESS-OUTPUT         THRU 2000-EXIT.          
           PERFORM 9999-END-PROGRAM            THRU 9999-EXIT.          
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07730000
      * 0100-INITIALIZE                                                *07740000
      *                                                                *07750000
      *     1. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *07760000
      *     2. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *07770000
      *     3. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*07780000
      *                                                                *07790000
      ******************************************************************07800000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                         TO ACTIVE-PARAGRAPH.     
           EXEC SQL                                                     
                WHENEVER SQLWARNING CONTINUE                            
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER SQLERROR CONTINUE                              
           END-EXEC.                                                    
                                                                        
           EXEC SQL                                                     
                WHENEVER NOT FOUND CONTINUE                             
           END-EXEC.                                                    
REARCH*                                                                         
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     07870000
                                                                        
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     07890000
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.         07900000
REARCH*                                                                 07910000
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      07920000
REARCH*                                                                 07930000
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                             07940000
REARCH*       MOVE PROGRAM-NAME                TO ABEND-PROGRAM         07950000
REARCH*       MOVE '0100'                      TO ACTIVE-PARAGRAPH      07960000
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT'                        07970000
REARCH*                                        TO ABEND-FUNCTION                
REARCH*       MOVE 'CICS TRANSACTION'          TO TABLE-1               07980000
REARCH*       MOVE GWL-RC                      TO                       07990000
REARCH*            WS-ACTIVE-RETURN-CODE                                        
REARCH*       PERFORM 9000-SEND-ERROR-RESULT   THRU 9000-EXIT           08000000
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE   THRU 9900-EXIT           08000000
REARCH*    END-IF.                                                      08010000
REARCH*                                                                         
           INITIALIZE TDS-RETURN-FIELDS.                                
REARCH*                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT     THRU 0100A-EXIT.               
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               RETURN_CODE                                        
REARCH              ,CURRENCY_TYPE                                      
REARCH              ,LTRIM(RTRIM(CURRENCY_DESC))     AS CURRENCY_DESC          
REARCH              ,TOTAL_AMOUNT_OVER                                  
REARCH              ,TOTAL_AMOUNT_SHRT                                  
REARCH              ,TOTAL_ADJUSTMENTS                                  
REARCH              ,NET_CURRENCY_TOTAL                                 
REARCH              ,REPORT_STATUS                                      
REARCH              ,BATCH_STATUS                                       
REARCH              ,BATCH_NUMBER                                       
REARCH          FROM                                                    
REARCH               #CSR02377_R1                                
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,CURRENCY_TYPE                                              
MFA-TR*             ,STRIP(CURRENCY_DESC)     AS CURRENCY_DESC                  
MFA-TR*             ,TOTAL_AMOUNT_OVER                                          
MFA-TR*             ,TOTAL_AMOUNT_SHRT                                          
MFA-TR*             ,TOTAL_ADJUSTMENTS                                          
MFA-TR*             ,NET_CURRENCY_TOTAL                                         
MFA-TR*             ,REPORT_STATUS                                              
MFA-TR*             ,BATCH_STATUS                                               
MFA-TR*             ,BATCH_NUMBER                                               
MFA-TR*         FROM                                                            
MFA-TR*              SESSION.CSR02377_R1                                        
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*0100A-DECLARE-GTT                                               *        
REARCH******************************************************************        
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02377_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02377_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02377_R1
              (                                                       
REARCH               RETURN_CODE            INT                     
REARCH              ,CURRENCY_TYPE CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,CURRENCY_DESC CHAR(20)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,TOTAL_AMOUNT_OVER      DECIMAL(13,2)               
REARCH              ,TOTAL_AMOUNT_SHRT      DECIMAL(13,2)               
REARCH              ,TOTAL_ADJUSTMENTS      DECIMAL(13,2)               
REARCH              ,NET_CURRENCY_TOTAL     DECIMAL(13,2)               
REARCH              ,REPORT_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,BATCH_STATUS CHAR(01)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                    
REARCH              ,BATCH_NUMBER           SMALLINT                    
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH         PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT            
REARCH     ELSE                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH                NEXT SENTENCE                                     
REARCH         ELSE                                                     
REARCH            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
REARCH            MOVE SQLCODE            TO ABEND-SQLCODE              
REARCH            MOVE SQLSTATE           TO ABEND-SQLSTATE             
REARCH            MOVE '0100A'            TO ACTIVE-PARAGRAPH           
REARCH            MOVE 'DECLARE GTT'      TO ABEND-FUNCTION             
REARCH            MOVE SPACES             TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH            MOVE 'CSR02377_R1'      TO TABLE-1                    
REARCH            MOVE SPACES             TO TABLE-ELEMENT-1            
REARCH            MOVE SPACES             TO HOSTVAR-ELEMENT-1          
REARCH            PERFORM 9900-SQL-ERROR-ROUTINE                        
REARCH                                    THRU  9900-EXIT               
REARCH         END-IF                                                   
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************08040000
      * 1000-PROCESS-INPUT.                                            *08050000
      *                                                                *08060000
      *        RECEIVE PARMS.                                          *08070000
      *                                                                *08080000
      ******************************************************************08090000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                         TO ACTIVE-PARAGRAPH.     
REARCH*    PERFORM 1100-RECEIVE-PARMS          THRU 1100-EXIT.          08130000
           MOVE PARM-COMPANY-NO                TO CS-CASH-COMPANY-NO,   
                                                  CJ-CASH-COMPANY-NO,   
                                                  GO-COMPANY-NO.        
           MOVE PARM-CASH-LOCAL-OFFICE         TO CS-CASH-LOCAL-OFFICE, 
                                                  CJ-CASH-LOCAL-OFFICE. 
           MOVE PARM-USER-ID                   TO CS-USER-ID,           
                                                  CJ-USER-ID.           
           MOVE PARM-DATE-CASH-REPORT          TO CS-DATE-CASH-REPORT,  
                                                  CJ-DATE-CASH-REPORT.  
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 08170000
      * 1100-RECEIVE-PARMS                                            * 08180000
      *                                                               * 08190000
      *     RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE          * 08200000
      *                                                               * 08210000
      ***************************************************************** 08220000
REARCH*                                                                 08230000
REARCH*1100-RECEIVE-PARMS.                                              08240000
REARCH*                                                                 08230000
REARCH*    MOVE '1100'                         TO ACTIVE-PARAGRAPH.     08250000
REARCH*    MOVE 1                              TO PARM-ID1.             08260000
REARCH*    MOVE LENGTH OF PARM-COMPANY-NO      TO MAX-LENGTH-PARM.      08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08230000
REARCH*                          GWL-RC,                                08230000
REARCH*                          PARM-ID1,                              08230000
REARCH*                          PARM-COMPANY-NO,                       08230000
REARCH*                          TDSCHAR,                               08230000
REARCH*                          MAX-LENGTH-PARM,                       08230000
REARCH*                          PARM-L.                                08230000
REARCH*    ADD 1                               TO PARM-ID1.             08230000
REARCH*                                                                 08230000
REARCH*    MOVE LENGTH OF PARM-CASH-LOCAL-OFFICE                        08360000
REARCH*                                        TO MAX-LENGTH-PARM.      08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-CASH-LOCAL-OFFICE,                08400000
REARCH*                          TDSCHAR,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*    ADD 1                               TO PARM-ID1.             08350000
REARCH*                                                                 08230000
REARCH*    MOVE LENGTH OF PARM-USER-ID         TO MAX-LENGTH-PARM.      08360000
REARCH*                                                                 08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-USER-ID,                          08400000
REARCH*                          TDSCHAR,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*                                                                 08230000
REARCH*    ADD 1                               TO PARM-ID1.             08350000
REARCH*                                                                 08230000
REARCH*    MOVE LENGTH OF PARM-DATE-CASH-REPORT                         08360000
REARCH*                                        TO MAX-LENGTH-PARM.      08230000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08370000
REARCH*                          GWL-RC,                                08380000
REARCH*                          PARM-ID1,                              08390000
REARCH*                          PARM-DATE-CASH-REPORT,                 08400000
REARCH*                          TDSCHAR,                               08410000
REARCH*                          MAX-LENGTH-PARM,                       08420000
REARCH*                          PARM-L.                                08430000
REARCH*                                                                 08230000
REARCH*1100-EXIT.                                                       08440000
REARCH*    EXIT.                                                        08450000
                                                                        
      ******************************************************************08470000
      * 2000-PROCESS-OUTPUT.                                           *08480000
      *                                                                *08490000
      *     1. DESCRIBE RESULT SET                                     *08500000
      *     2. BUILD RESULT SET                                        *08520000
      *     3. SEND RESULT SET                                         *08530000
      *                                                                *08540000
      ******************************************************************08550000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                         TO ACTIVE-PARAGRAPH.     
REARCH*    PERFORM 2100-DESCRIBE-RESULT        THRU 2100-EXIT.          08590000
           PERFORM 2200-PROCESS-DETAIL         THRU 2200-EXIT.          
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH***************************************************************** 05040000
REARCH*2000A-MOVE-RESULT                                              * 05040000
REARCH***************************************************************** 05040000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE             TO  S-RETURN-CODE.          
REARCH     MOVE  RS-CURRENCY-TYPE           TO  S-CURRENCY-TYPE.        
REARCH     MOVE  RS-CURRENCY-DESC           TO  S-CURRENCY-DESC.        
REARCH     MOVE  RS-TOTAL-AMOUNT-OVERAGE    TO  S-TOTAL-AMOUNT-OVERAGE. 
REARCH     MOVE  RS-TOTAL-AMOUNT-SHORTAGE   TO  S-TOTAL-AMOUNT-SHORTAGE.
REARCH     MOVE  RS-TOTAL-ADJUSTMENTS       TO  S-TOTAL-ADJUSTMENTS.    
REARCH     MOVE  RS-NET-CURRENCY-TOTAL      TO  S-NET-CURRENCY-TOTAL.   
REARCH     MOVE  RS-REPORT-STATUS           TO  S-REPORT-STATUS.        
REARCH     MOVE  RS-BATCH-STATUS            TO  S-BATCH-STATUS.         
REARCH     MOVE  RS-BATCH-NUMBER            TO  S-BATCH-NUMBER.         
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************08640000
      * 2100-DESCRIBE-RESULT                                           *08650000
      *                                                                *08660000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *08670000
      *                                                                *08680000
      ******************************************************************08690000
                                                                        
REARCH*2100-DESCRIBE-RESULT.                                            08710000
REARCH*                                                                 08700000
REARCH*    MOVE '2100'                         TO ACTIVE-PARAGRAPH.     02850011
REARCH*                                                                 02860000
REARCH*    MOVE 1                              TO CTR-COLUMN.           02870000
REARCH*    MOVE TDSINT4                        TO DB-HOST-TYPE.         02880000
REARCH*    MOVE TDSINT4                        TO DB-CLIENT-TYPE.       02890000
REARCH*    MOVE LENGTH OF RS-RETURN-CODE       TO WRKLEN1.              02900000
REARCH*    MOVE LENGTH OF CN-RETURN-CODE       TO WRKLEN2.              02910000
REARCH*                                                                 02920000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02930000
REARCH*                          GWL-RC,                                02940000
REARCH*                          CTR-COLUMN,                            02950000
REARCH*                          DB-HOST-TYPE,                          02960000
REARCH*                          WRKLEN1,                               02970000
REARCH*                          RS-RETURN-CODE,                        02980000
REARCH*                          DB-NULL-INDICATOR,                     02990000
REARCH*                          TDS-FALSE,                             03000000
REARCH*                          DB-CLIENT-TYPE,                        03010000
REARCH*                          WRKLEN1,                               03020000
REARCH*                          CN-RETURN-CODE,                        03030000
REARCH*                          WRKLEN2.                               03040000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          03060000
REARCH*                                                                 03070000
REARCH*    ADD  1                              TO CTR-COLUMN.           08740000
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         08950000
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       08960000
REARCH*    MOVE LENGTH OF RS-CURRENCY-TYPE     TO WRKLEN1.              08970000
REARCH*    MOVE LENGTH OF CN-CURRENCY-TYPE     TO WRKLEN2.              08980000
REARCH*                                                                 08990000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              09000000
REARCH*                          GWL-RC,                                09010000
REARCH*                          CTR-COLUMN,                            09020000
REARCH*                          DB-HOST-TYPE,                          09030000
REARCH*                          WRKLEN1,                               09040000
REARCH*                          RS-CURRENCY-TYPE,                      09050000
REARCH*                          DB-NULL-INDICATOR,                     09060000
REARCH*                          TDS-FALSE,                             09070000
REARCH*                          DB-CLIENT-TYPE,                        09080000
REARCH*                          WRKLEN1,                               09090000
REARCH*                          CN-CURRENCY-TYPE,                      09100000
REARCH*                          WRKLEN2.                               09110000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          09120000
REARCH*                                                                 09130000
REARCH*    ADD  1                              TO CTR-COLUMN.           08740000
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         08950000
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       08960000
REARCH*    MOVE LENGTH OF RS-CURRENCY-DESC     TO WRKLEN1.              08970000
REARCH*    MOVE LENGTH OF CN-CURRENCY-DESC     TO WRKLEN2.              08980000
REARCH*                                                                 08990000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              09000000
REARCH*                          GWL-RC,                                09010000
REARCH*                          CTR-COLUMN,                            09020000
REARCH*                          DB-HOST-TYPE,                          09030000
REARCH*                          WRKLEN1,                               09040000
REARCH*                          RS-CURRENCY-DESC,                      09050000
REARCH*                          DB-NULL-INDICATOR,                     09060000
REARCH*                          TDS-FALSE,                             09070000
REARCH*                          DB-CLIENT-TYPE,                        09080000
REARCH*                          WRKLEN1,                               09090000
REARCH*                          CN-CURRENCY-DESC,                      09100000
REARCH*                          WRKLEN2.                               09110000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          09120000
REARCH*                                                                 08700000
REARCH*    ADD 1                               TO CTR-COLUMN.           10420000
REARCH*    MOVE TDSDECIMAL                     TO DB-HOST-TYPE.         10430000
REARCH*    MOVE TDSFLT8                        TO DB-CLIENT-TYPE.       10440000
REARCH*    MOVE LENGTH OF RS-TOTAL-AMOUNT-OVERAGE                       08700000
REARCH*                                        TO WRKLEN1.              10450000
REARCH*    MOVE LENGTH OF CN-TOTAL-AMOUNT-OVERAGE                       10460000
REARCH*                                        TO WRKLEN2.              10470000
REARCH*                                                                 08700000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              10480000
REARCH*                          GWL-RC,                                10490000
REARCH*                          CTR-COLUMN,                            10500000
REARCH*                          DB-HOST-TYPE,                          10510000
REARCH*                          WRKLEN1,                               10520000
REARCH*                          RS-TOTAL-AMOUNT-OVERAGE,               10530000
REARCH*                          DB-NULL-INDICATOR,                     10540000
REARCH*                          TDS-FALSE,                             10550000
REARCH*                          DB-CLIENT-TYPE,                        10560000
REARCH*                          WRKLEN1,                               10570000
REARCH*                          CN-TOTAL-AMOUNT-OVERAGE,               10580000
REARCH*                          WRKLEN2.                               10590000
REARCH*                                                                 10320000
REARCH*    MOVE +2                             TO WRKLEN2.              10330000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              10340000
REARCH*                          GWL-RC,                                10350000
REARCH*                          TDS-OBJECT-COL,                        10360000
REARCH*                          CTR-COLUMN,                            10370000
REARCH*                          WRKLEN1,                               10380000
REARCH*                          WRKLEN2.                               10390000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          10600000
REARCH*                                                                 10610000
REARCH*    ADD 1                               TO CTR-COLUMN.           10420000
REARCH*    MOVE TDSDECIMAL                     TO DB-HOST-TYPE.         10430000
REARCH*    MOVE TDSFLT8                        TO DB-CLIENT-TYPE.       10440000
REARCH*    MOVE LENGTH OF RS-TOTAL-AMOUNT-SHORTAGE                      08700000
REARCH*                                        TO WRKLEN1.              10450000
REARCH*    MOVE LENGTH OF CN-TOTAL-AMOUNT-SHORTAGE                      10460000
REARCH*                                        TO WRKLEN2.              10470000
REARCH*                                                                 08700000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              10480000
REARCH*                          GWL-RC,                                10490000
REARCH*                          CTR-COLUMN,                            10500000
REARCH*                          DB-HOST-TYPE,                          10510000
REARCH*                          WRKLEN1,                               10520000
REARCH*                          RS-TOTAL-AMOUNT-SHORTAGE,              10530000
REARCH*                          DB-NULL-INDICATOR,                     10540000
REARCH*                          TDS-FALSE,                             10550000
REARCH*                          DB-CLIENT-TYPE,                        10560000
REARCH*                          WRKLEN1,                               10570000
REARCH*                          CN-TOTAL-AMOUNT-SHORTAGE,              10580000
REARCH*                          WRKLEN2.                               10590000
REARCH*                                                                 10320000
REARCH*    MOVE +2                             TO WRKLEN2.              10330000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              10340000
REARCH*                          GWL-RC,                                10350000
REARCH*                          TDS-OBJECT-COL,                        10360000
REARCH*                          CTR-COLUMN,                            10370000
REARCH*                          WRKLEN1,                               10380000
REARCH*                          WRKLEN2.                               10390000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          10600000
REARCH*                                                                 08700000
REARCH*    ADD 1                               TO CTR-COLUMN.           10420000
REARCH*    MOVE TDSDECIMAL                     TO DB-HOST-TYPE.         10430000
REARCH*    MOVE TDSFLT8                        TO DB-CLIENT-TYPE.       10440000
REARCH*    MOVE LENGTH OF RS-TOTAL-ADJUSTMENTS TO WRKLEN1.              08700000
REARCH*    MOVE LENGTH OF CN-TOTAL-ADJUSTMENTS TO WRKLEN2.              10460000
REARCH*                                                                 10470000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              10480000
REARCH*                          GWL-RC,                                10490000
REARCH*                          CTR-COLUMN,                            10500000
REARCH*                          DB-HOST-TYPE,                          10510000
REARCH*                          WRKLEN1,                               10520000
REARCH*                          RS-TOTAL-ADJUSTMENTS,                  10530000
REARCH*                          DB-NULL-INDICATOR,                     10540000
REARCH*                          TDS-FALSE,                             10550000
REARCH*                          DB-CLIENT-TYPE,                        10560000
REARCH*                          WRKLEN1,                               10570000
REARCH*                          CN-TOTAL-ADJUSTMENTS,                  10580000
REARCH*                          WRKLEN2.                               10590000
REARCH*                                                                 10320000
REARCH*    MOVE +2                             TO WRKLEN2.              10330000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              10340000
REARCH*                          GWL-RC,                                10350000
REARCH*                          TDS-OBJECT-COL,                        10360000
REARCH*                          CTR-COLUMN,                            10370000
REARCH*                          WRKLEN1,                               10380000
REARCH*                          WRKLEN2.                               10390000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          10600000
REARCH*                                                                 08700000
REARCH*    ADD 1                               TO CTR-COLUMN.           10620000
REARCH*    MOVE TDSDECIMAL                     TO DB-HOST-TYPE.         10630000
REARCH*    MOVE TDSFLT8                        TO DB-CLIENT-TYPE.       10640000
REARCH*    MOVE LENGTH OF RS-NET-CURRENCY-TOTAL                         10650000
REARCH*                                        TO WRKLEN1.              08700000
REARCH*    MOVE LENGTH OF CN-NET-CURRENCY-TOTAL                         10660000
REARCH*                                        TO WRKLEN2.              10670000
REARCH*                                                                 08700000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              10680000
REARCH*                          GWL-RC,                                10690000
REARCH*                          CTR-COLUMN,                            10700000
REARCH*                          DB-HOST-TYPE,                          10710000
REARCH*                          WRKLEN1,                               10720000
REARCH*                          RS-NET-CURRENCY-TOTAL,                 10730000
REARCH*                          DB-NULL-INDICATOR,                     10740000
REARCH*                          TDS-FALSE,                             10750000
REARCH*                          DB-CLIENT-TYPE,                        10760000
REARCH*                          WRKLEN1,                               10770000
REARCH*                          CN-NET-CURRENCY-TOTAL,                 10780000
REARCH*                          WRKLEN2.                               10790000
REARCH*                                                                 10800000
REARCH*    MOVE +2                             TO WRKLEN2.              10810000
REARCH*    CALL 'TDSETBCD' USING GWL-PROC,                              10820000
REARCH*                          GWL-RC,                                10830000
REARCH*                          TDS-OBJECT-COL,                        10840000
REARCH*                          CTR-COLUMN,                            10850000
REARCH*                          WRKLEN1,                               10860000
REARCH*                          WRKLEN2.                               10870000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          10880000
REARCH*                                                                 10890000
REARCH*    ADD 1                               TO CTR-COLUMN.           12500000
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         12510000
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       12520000
REARCH*    MOVE LENGTH OF RS-REPORT-STATUS     TO WRKLEN1.              12530000
REARCH*    MOVE LENGTH OF CN-REPORT-STATUS     TO WRKLEN2.              12540000
REARCH*                                                                 12550000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              12560000
REARCH*                          GWL-RC,                                12570000
REARCH*                          CTR-COLUMN,                            12580000
REARCH*                          DB-HOST-TYPE,                          12590000
REARCH*                          WRKLEN1,                               12600000
REARCH*                          RS-REPORT-STATUS,                      12610000
REARCH*                          DB-NULL-INDICATOR,                     12620000
REARCH*                          TDS-FALSE,                             12630000
REARCH*                          DB-CLIENT-TYPE,                        12640000
REARCH*                          WRKLEN1,                               12650000
REARCH*                          CN-REPORT-STATUS,                      12660000
REARCH*                          WRKLEN2.                               12670000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          12680000
REARCH*                                                                 12490000
REARCH*    ADD 1                               TO CTR-COLUMN.           12500000
REARCH*    MOVE TDSCHAR                        TO DB-HOST-TYPE.         12510000
REARCH*    MOVE TDSCHAR                        TO DB-CLIENT-TYPE.       12520000
REARCH*    MOVE LENGTH OF RS-BATCH-STATUS      TO WRKLEN1.              12530000
REARCH*    MOVE LENGTH OF CN-BATCH-STATUS      TO WRKLEN2.              12540000
REARCH*                                                                 12550000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              12560000
REARCH*                          GWL-RC,                                12570000
REARCH*                          CTR-COLUMN,                            12580000
REARCH*                          DB-HOST-TYPE,                          12590000
REARCH*                          WRKLEN1,                               12600000
REARCH*                          RS-BATCH-STATUS,                       12610000
REARCH*                          DB-NULL-INDICATOR,                     12620000
REARCH*                          TDS-FALSE,                             12630000
REARCH*                          DB-CLIENT-TYPE,                        12640000
REARCH*                          WRKLEN1,                               12650000
REARCH*                          CN-BATCH-STATUS,                       12660000
REARCH*                          WRKLEN2.                               12670000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          12680000
REARCH*                                                                 21952100
REARCH*    ADD  1                              TO CTR-COLUMN.           02870000
REARCH*    MOVE TDSINT2                        TO DB-HOST-TYPE.         02880000
REARCH*    MOVE TDSINT2                        TO DB-CLIENT-TYPE.       02890000
REARCH*    MOVE LENGTH OF RS-BATCH-NUMBER      TO WRKLEN1.              02900000
REARCH*    MOVE LENGTH OF CN-BATCH-NUMBER      TO WRKLEN2.              02910000
REARCH*                                                                 02920000
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                              02930000
REARCH*                          GWL-RC,                                02940000
REARCH*                          CTR-COLUMN,                            02950000
REARCH*                          DB-HOST-TYPE,                          02960000
REARCH*                          WRKLEN1,                               02970000
REARCH*                          RS-BATCH-NUMBER,                       02980000
REARCH*                          DB-NULL-INDICATOR,                     02990000
REARCH*                          TDS-FALSE,                             03000000
REARCH*                          DB-CLIENT-TYPE,                        03010000
REARCH*                          WRKLEN1,                               03020000
REARCH*                          CN-BATCH-NUMBER,                       03030000
REARCH*                          WRKLEN2.                               03040000
REARCH*    PERFORM 9100-CHECK-ERROR            THRU 9100-EXIT.          03060000
REARCH*                                                                 08700000
REARCH*2100-EXIT.                                                       21953000
REARCH*    EXIT.                                                        21960000
                                                                        
      ******************************************************************        
      *    2200-PROCESS-DETAIL                                         *        
      *                                                                *        
      *    1. GET THE CLEAR CASH GL-ACCOUNT-NO                         *        
      *    2. GET THE REPORT-STATUS                                    *        
      *    3. GET THE BATCHES FOR THE DAY AND USER.                    *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2200-PROCESS-DETAIL.                                             
                                                                        
           MOVE '2200'                         TO ACTIVE-PARAGRAPH.     
           MOVE WS-CLEAR-CASH                  TO GO-GL-ACCT-NAME.      
           PERFORM 7000-GET-ACCT-NUMBER        THRU 7000-EXIT.          
           MOVE GO-GL-ACCT-NO                  TO WS-CLR-CASH-ACCT-NO.  
           PERFORM 7050-GET-REPORT-STATUS      THRU 7050-EXIT.          
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE 1000                       TO RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           ELSE                                                         
               PERFORM 7100-OPEN-CNTL-CURSOR   THRU 7100-EXIT           
               PERFORM 7120-FETCH-CNTL-CURSOR  THRU 7120-EXIT           
                                                                        
               IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE 2000                   TO RS-RETURN-CODE        
                   MOVE YR-STATUS              TO RS-REPORT-STATUS      
REARCH             PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT          
                   PERFORM 8100-SEND-RESULT    THRU 8100-EXIT           
               END-IF                                                   
                                                                        
               PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND          
                   PERFORM 2300-PROCESS-JRNL-TRANS                      
                                               THRU 2300-EXIT           
                   PERFORM 7120-FETCH-CNTL-CURSOR                       
                                               THRU 7120-EXIT           
               END-PERFORM                                              
                                                                        
               PERFORM 7140-CLOSE-CNTL-CURSOR  THRU 7140-EXIT           
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    2300-PROCESS-JRNL-TRANS                                     *        
      *                                                                *        
      *       GET ALL TRANSACTIONS FOR THE BATCH                       *        
      *                                                                *        
      ******************************************************************        
                                                                        
       2300-PROCESS-JRNL-TRANS.                                         
                                                                        
           MOVE '2300'                         TO ACTIVE-PARAGRAPH.     
           INITIALIZE TDS-RETURN-FIELDS.                                
           MOVE WS-NO                          TO WS-CASH-FLAG,         
                                                  WS-CHEQUE-FLAG.       
           MOVE WS-YES                         TO WS-CHECK-FLAG.        
           MOVE YR-STATUS                      TO RS-REPORT-STATUS.     
           MOVE CS-CODE-CSH-DRWR-STAT          TO RS-BATCH-STATUS.      
           MOVE CS-CASH-DRAWER-ID              TO RS-BATCH-NUMBER.      
           PERFORM 7200-OPEN-JRNL-TRANS-CURSOR THRU 7200-EXIT.          
           PERFORM 7220-FETCH-JRNL-TRANS-CURSOR                         
                                               THRU 7220-EXIT.          
           IF  WS-ACTIVE-RETURN-CODE = NOT-FOUND                        
               MOVE 3000                       TO RS-RETURN-CODE        
               MOVE WS-NO                      TO WS-CHECK-FLAG         
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           ELSE                                                         
               MOVE CJ-CURRENCY-TYPE           TO WS-PREV-CURRENCY      
           END-IF.                                                      
                                                                        
           PERFORM UNTIL WS-RETURN-CODE = NOT-FOUND                     
               PERFORM 2400-ACCUMULATE-TOTALS  THRU 2400-EXIT           
               PERFORM 7220-FETCH-JRNL-TRANS-CURSOR                     
                                               THRU 7220-EXIT           
                                                                        
               IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL              
                   IF  CJ-CURRENCY-TYPE = WS-PREV-CURRENCY              
                       CONTINUE                                         
                   ELSE                                                 
                       IF  (RS-TOTAL-AMOUNT-OVERAGE = 0)  AND           
                           (RS-TOTAL-AMOUNT-SHORTAGE = 0) AND           
                           (RS-NET-CURRENCY-TOTAL = 0)                  
                           CONTINUE                                     
                       ELSE                                             
                           PERFORM 2500-SEND-PROCESS                    
                                               THRU 2500-EXIT           
                       END-IF                                           
                       INITIALIZE  RS-CURRENCY-DESC                     
                                   RS-CURRENCY-TYPE                     
                                   RS-TOTAL-AMOUNT-OVERAGE              
                                   RS-TOTAL-AMOUNT-SHORTAGE             
                                   RS-TOTAL-ADJUSTMENTS                 
                                   RS-NET-CURRENCY-TOTAL                
                       MOVE CJ-CURRENCY-TYPE   TO WS-PREV-CURRENCY      
                   END-IF                                               
               ELSE                                                     
                   IF  (RS-TOTAL-AMOUNT-OVERAGE = 0)  AND               
                       (RS-TOTAL-AMOUNT-SHORTAGE = 0) AND               
                       (RS-NET-CURRENCY-TOTAL = 0)                      
                        CONTINUE                                        
                   ELSE                                                 
                       PERFORM 2500-SEND-PROCESS                        
                                               THRU 2500-EXIT           
                   END-IF                                               
               END-IF                                                   
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7240-CLOSE-JRNL-TRANS-CURSOR                         
                                               THRU 7240-EXIT.          
           IF  WS-CHECK-FLAG = WS-YES                                   
               PERFORM 2550-CHECK-CASH-CHEQUE  THRU 2550-EXIT           
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 24730000
      *   2400-ACCUMULATE-TOTALS.                                     *         
      *                                                               *         
      *   ACCUMULATE TOTAL FOR OVERAGE/SHORTAGE AND CURRENCY AMT FOR  *         
      *   A CURRENCY TYPE.                                            *         
      *                                                               *         
      *****************************************************************         
                                                                        
       2400-ACCUMULATE-TOTALS.                                          
                                                                        
           MOVE CJ-TRAN-DATA                   TO CJF00101.             
                                                                        
           IF  WS-101-ACCT-GEN-LED-CR = WS-101-ACCT-GEN-LED-DR          
               NEXT SENTENCE                                            
           ELSE                                                         
               IF  CJ-TRAN-ID = WS-TRANID-OVERAGE OR WS-TRANID-SHORTAGE 
                                                                        
                   IF  WS-101-ACCT-GEN-LED-DR = WS-CLR-CASH-ACCT-NO     
                       ADD WS-101-AMT-POSTED   TO                       
                                               RS-TOTAL-AMOUNT-OVERAGE  
                   ELSE                                                 
                       ADD WS-101-AMT-POSTED   TO                       
                                               RS-TOTAL-AMOUNT-SHORTAGE 
                       MULTIPLY -1 BY WS-101-AMT-POSTED                 
                   END-IF                                               
                                                                        
                   ADD WS-101-AMT-POSTED       TO RS-NET-CURRENCY-TOTAL 
               ELSE                                                     
                   MOVE WS-NO                  TO WS-CASH-GL-NUM,       
                                                  WS-LIHEAP-RVSL,       
                                                  WS-LIHEAP-PMT,        
                                                  WS-GL-ACCT-FLAG       
                   IF  WS-101-ACCT-GEN-LED-DR  = GO-GL-ACCT-NO  OR      
                       WS-101-ACCT-GEN-LED-CR  = GO-GL-ACCT-NO          
                       MOVE WS-YES             TO WS-CASH-GL-NUM        
                   ELSE                                                 
                       MOVE WS-101-ACCT-GEN-LED-DR                      
                                               TO I5-GL-ACCT-NO         
                       PERFORM 2450-CHECK-GL-NUM                        
                                               THRU 2450-EXIT           
                       IF  WS-GL-ACCT-FLAG  = WS-YES                    
                           MOVE WS-YES         TO WS-LIHEAP-PMT         
                       ELSE                                             
                           MOVE WS-101-ACCT-GEN-LED-CR                  
                                               TO I5-GL-ACCT-NO         
                           PERFORM 2450-CHECK-GL-NUM                    
                                               THRU 2450-EXIT           
                                                                        
                           IF  WS-GL-ACCT-FLAG = WS-YES                 
                               MOVE WS-YES         TO WS-LIHEAP-RVSL    
                           END-IF                                       
                       END-IF                                           
                   END-IF                                               
                                                                        
                   IF  WS-CASH-GL-NUM = WS-YES  OR                      
                       WS-LIHEAP-PMT  = WS-YES  OR                      
                       WS-LIHEAP-RVSL = WS-YES                          
                                                                        
                       IF  WS-101-ACCT-GEN-LED-CR = GO-GL-ACCT-NO  OR   
                           WS-LIHEAP-RVSL = WS-YES                      
                           MULTIPLY -1 BY WS-101-AMT-POSTED             
                       END-IF                                           
                                                                        
                       ADD WS-101-AMT-POSTED   TO RS-NET-CURRENCY-TOTAL 
                   END-IF                                               
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *  2450-CHECK-GL-NUM                                                      
      *                                                                         
      *    TO CHECK WHETHER GL_ACCT_NO IS IN THE CSS_LIEAP_AGENCY               
      *                                                                         
      ******************************************************************        
                                                                        
       2450-CHECK-GL-NUM.                                               
                                                                        
           MOVE '2450'                         TO ACTIVE-PARAGRAPH.     
           PERFORM 7300-OPEN-LIEAP-CURSOR      THRU 7300-EXIT.          
           PERFORM 7320-FETCH-LIEAP-CURSOR     THRU 7320-EXIT.          
           PERFORM 7340-CLOSE-LIEAP-CURSOR     THRU 7340-EXIT.          
                                                                        
       2450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 24730000
      *   2500-SEND-PROCESS                                           *         
      *                                                               *         
      *   BEFORE SENDING RESULT GET THE CURRENCY DESCRIPTION AND THE  *         
      *   TOTAL ADJUSTMENTS.                                          *         
      *                                                               *         
      *****************************************************************         
                                                                        
       2500-SEND-PROCESS.                                               
                                                                        
           MOVE WS-PREV-CURRENCY               TO Y7-CURRENCY-TYPE.     
C33001     IF Y7-CURRENCY-TYPE = 'L'                                    
C33001        MOVE 'LIHEAP'                    TO Y7-CURRENCY-DESC      
C33001     ELSE                                                         
              PERFORM 7400-GET-CURRENCY-DESC   THRU 7400-EXIT           
C33001     END-IF.                                                      
           MOVE Y7-CURRENCY-DESC               TO RS-CURRENCY-DESC.     
           MOVE Y7-CURRENCY-TYPE               TO RS-CURRENCY-TYPE.     
           SUBTRACT RS-TOTAL-AMOUNT-SHORTAGE   FROM                     
                                               RS-TOTAL-AMOUNT-OVERAGE  
                                               GIVING                   
                                               RS-TOTAL-ADJUSTMENTS.    
REARCH     PERFORM 2000A-MOVE-RESULT           THRU 2000A-EXIT.         
           PERFORM 8100-SEND-RESULT            THRU 8100-EXIT.          
           IF  RS-CURRENCY-TYPE = WS-CURRENCY-CASH-TYPE                 
               MOVE WS-YES                     TO WS-CASH-FLAG          
           ELSE                                                         
               IF  RS-CURRENCY-TYPE = WS-CURRENCY-CHEQUE-TYPE           
                   MOVE WS-YES                 TO WS-CHEQUE-FLAG        
               END-IF                                                   
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ***************************************************************** 24730000
      *   2550-CHECK-CASH-CHEQUE.                                     *         
      *                                                               *         
      *   CHECKING FOR THE CURRENCY TYPES CASH AND CHEQUE EXISTS IN   *         
      *   THE BATCH.                                                  *         
      *                                                               *         
      *****************************************************************         
                                                                        
       2550-CHECK-CASH-CHEQUE.                                          
                                                                        
           IF  WS-CASH-FLAG = WS-YES                                    
               NEXT SENTENCE                                            
           ELSE                                                         
               INITIALIZE  RS-CURRENCY-DESC                             
                           RS-CURRENCY-TYPE                             
                           RS-TOTAL-AMOUNT-OVERAGE                      
                           RS-TOTAL-AMOUNT-SHORTAGE                     
                           RS-TOTAL-ADJUSTMENTS                         
                           RS-NET-CURRENCY-TOTAL                        
               MOVE WS-CURRENCY-CASH-DESC      TO RS-CURRENCY-DESC      
               MOVE WS-CURRENCY-CASH-TYPE      TO RS-CURRENCY-TYPE      
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
           IF  WS-CHEQUE-FLAG = WS-YES                                  
               NEXT SENTENCE                                            
           ELSE                                                         
               INITIALIZE  RS-CURRENCY-DESC                             
                           RS-CURRENCY-TYPE                             
                           RS-TOTAL-AMOUNT-OVERAGE                      
                           RS-TOTAL-AMOUNT-SHORTAGE                     
                           RS-TOTAL-ADJUSTMENTS                         
                           RS-NET-CURRENCY-TOTAL                        
               MOVE WS-CURRENCY-CHEQUE-DESC    TO RS-CURRENCY-DESC      
               MOVE WS-CURRENCY-CHEQUE-TYPE    TO RS-CURRENCY-TYPE      
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
               PERFORM 8100-SEND-RESULT        THRU 8100-EXIT           
           END-IF.                                                      
                                                                        
       2550-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7000-GET-ACCT-NUMBER                                        *        
      *                                                                *        
      *    TO GET THE CLEAR CASH ACCOUNT NUMBER                        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7000-GET-ACCT-NUMBER.                                            
                                                                        
           EXEC SQL                                                     
                SELECT GL_ACCT_NO                                       
                  INTO :GO-GL-ACCT-NO                                   
                  FROM CSS_GL_ACCT_NO                                   
                 WHERE COMPANY_NO   = :GO-COMPANY-NO                    
                   AND GL_ACCT_NAME = :GO-GL-ACCT-NAME                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7000'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_GL_ACCT_NO'           TO TABLE-1               
               MOVE 'COMPANY_NO'               TO TABLE-ELEMENT-1       
               MOVE 'GL_ACCT_NAME'             TO TABLE-ELEMENT-2       
               MOVE GO-COMPANY-NO              TO HOSTVAR-ELEMENT-1     
               MOVE GO-GL-ACCT-NAME            TO HOSTVAR-ELEMENT-2     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7050-GET-REPORT-STATUS                                      *        
      *                                                                *        
      *    GETTING THE REPORT STATUS.                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7050-GET-REPORT-STATUS.                                          
                                                                        
           EXEC SQL                                                     
                SELECT STATUS                                           
                  INTO :YR-STATUS                                       
                  FROM CSS_CSH_REPORT_HDR                               
                 WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO          
                   AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE        
                   AND DATE_CASH_REPORT  = IIF(TRY_CONVERT(DATE, 
                                                   :CS-DATE-CASH-REPORT
              ) IS NULL OR (PATINDEX('%.%', :CS-DATE-CASH-REPORT
              ) <> 0) OR (LEN(:CS-DATE-CASH-REPORT
              ) <> 10), CIS.CHAR2DATE(:CS-DATE-CASH-REPORT
              ), CONVERT(DATE, :CS-DATE-CASH-REPORT) )         
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT STATUS                                                   
MFA-TR*           INTO :YR-STATUS                                               
MFA-TR*           FROM CSS_CSH_REPORT_HDR                                       
MFA-TR*          WHERE CASH_COMPANY_NO   = :CS-CASH-COMPANY-NO                  
MFA-TR*            AND CASH_LOCAL_OFFICE = :CS-CASH-LOCAL-OFFICE                
MFA-TR*            AND DATE_CASH_REPORT  = :CS-DATE-CASH-REPORT                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7050'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_REPORT_HDR'       TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-3       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-3     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7100-OPEN-CNTL-CURSOR                                       *        
      *                                                                *        
      *    TO OPEN THE DRWR_CNTL_CURSOR                                *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7100-OPEN-CNTL-CURSOR.                                           
                                                                        
           EXEC SQL                                                     
                OPEN DRWR_CNTL_CURSOR                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7100'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7120-FETCH-CNTL-CURSOR                                               
      *                                                                         
      *    THIS PARA IS TO FETCH THE DRWR_CNTL_CURSOR                           
      ******************************************************************        
                                                                        
       7120-FETCH-CNTL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                FETCH DRWR_CNTL_CURSOR                                  
                 INTO :CS-CASH-DRAWER-ID,                               
                      :CS-CODE-CSH-DRWR-STAT                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7120'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7140-CLOSE-CNTL-CURSOR                                      *        
      *                                                                *        
      *    TO CLOSE THE DRWR_CNTL_CURSOR                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7140-CLOSE-CNTL-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                CLOSE DRWR_CNTL_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7140'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_CNTL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'USER_ID'                  TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CS-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CS-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-USER-ID                 TO HOSTVAR-ELEMENT-3     
               MOVE CS-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7140-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *    7200-OPEN-JRNL-TRANS-CURSOR                                 *        
      *                                                                *        
      *    TO OPEN THE JRNL_TRANS_CURSOR                               *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7200-OPEN-JRNL-TRANS-CURSOR.                                     
                                                                        
           EXEC SQL                                                     
                OPEN JRNL_TRANS_CURSOR                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7200'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7220-FETCH-JRNL-TRANS-CURSOR                                *        
      *                                                                *        
      *    TO FETCH THE JRNL_TRANS_CURSOR                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7220-FETCH-JRNL-TRANS-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
                FETCH JRNL_TRANS_CURSOR                                 
                 INTO :CJ-CURRENCY-TYPE,                                
                      :CJ-TRAN-ID,                                      
                      :CJ-TRAN-DATA                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE,
                                                  WS-RETURN-CODE.       
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7220'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7220-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7240-CLOSE-JRNL-TRANS-CURSOR                                *        
      *                                                                *        
      *    TO CLOSE THE JRNL_TRANS_CURSOR                              *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7240-CLOSE-JRNL-TRANS-CURSOR.                                    
                                                                        
           EXEC SQL                                                     
                CLOSE JRNL_TRANS_CURSOR                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7240'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CSH_DRWR_JRNL'        TO TABLE-1               
               MOVE 'CASH_COMPANY_NO'          TO TABLE-ELEMENT-1       
               MOVE 'CASH_LOCAL_OFFICE'        TO TABLE-ELEMENT-2       
               MOVE 'CASH_DRAWER_ID'           TO TABLE-ELEMENT-3       
               MOVE 'DATE_CASH_REPORT'         TO TABLE-ELEMENT-4       
               MOVE CJ-CASH-COMPANY-NO         TO HOSTVAR-ELEMENT-1     
               MOVE CJ-CASH-LOCAL-OFFICE       TO HOSTVAR-ELEMENT-2     
               MOVE CS-CASH-DRAWER-ID          TO HOSTVAR-ELEMENT-3     
               MOVE CJ-DATE-CASH-REPORT        TO HOSTVAR-ELEMENT-4     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7240-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                         
      *    7300-OPEN-LIEAP-CURSOR                                               
      *                                                                         
      *    TO OPEN THE LIEAP_CURSOR                                             
      *                                                                         
      ******************************************************************        
                                                                        
       7300-OPEN-LIEAP-CURSOR.                                          
                                                                        
           EXEC SQL                                                     
                OPEN LIEAP_CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7300'                     TO ACTIVE-PARAGRAPH      
               MOVE 'OPEN'                     TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                         
      *    7320-FETCH-LIEAP-CURSOR                                              
      *                                                                         
      *    TO FETCH THE LIEAP_CURSOR                                            
      *                                                                         
      ******************************************************************        
                                                                        
       7320-FETCH-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                FETCH LIEAP_CURSOR                                      
                 INTO :WS-GL-ACCT-FLAG                                  
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7320'                     TO ACTIVE-PARAGRAPH      
               MOVE 'FETCH'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                         
      *    7340-CLOSE-LIEAP-CURSOR                                              
      *                                                                         
      *    TO CLOSE THE LIEAP_CURSOR                                            
      *                                                                         
      ******************************************************************        
                                                                        
       7340-CLOSE-LIEAP-CURSOR.                                         
                                                                        
           EXEC SQL                                                     
                CLOSE LIEAP_CURSOR                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7340'                     TO ACTIVE-PARAGRAPH      
               MOVE 'CLOSE'                    TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_LIEAP_AGENCY'         TO TABLE-1               
               MOVE 'GL_ACCT_NO'               TO TABLE-ELEMENT-1       
               MOVE I5-GL-ACCT-NO              TO WS-GL-ACCT-NO-ED      
               MOVE WS-GL-ACCT-NO-ED           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *    7400-GET-CURRENCY-DESC.                                     *        
      *                                                                *        
      *    GET THE CURRENCY DESCRIPTION FOR THAT CURRENCY TYPE.        *        
      *                                                                *        
      ******************************************************************        
                                                                        
       7400-GET-CURRENCY-DESC.                                          
                                                                        
           EXEC SQL                                                     
                SELECT CURRENCY_DESC                                    
                  INTO :Y7-CURRENCY-DESC                                
                  FROM CSS_CURRENCY                                     
                 WHERE CURRENCY_TYPE = :Y7-CURRENCY-TYPE                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE.
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE        
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7400'                     TO ACTIVE-PARAGRAPH      
               MOVE 'SELECT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_CURRENCY'             TO TABLE-1               
               MOVE 'CURRENCY_TYPE'            TO TABLE-ELEMENT-1       
               MOVE CJ-CURRENCY-TYPE           TO HOSTVAR-ELEMENT-1     
               PERFORM 9700-PROCESS-ABEND      THRU 9700-EXIT           
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8000A-DELETE-GTT-ROWS                                           *        
REARCH******************************************************************        
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DELETE FROM #CSR02377_R1                         
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DELETE FROM SESSION.CSR02377_R1                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02377_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH*8100-SEND-RESULT                                                *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02377_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,CURRENCY_TYPE                                      
REARCH              ,CURRENCY_DESC                                      
REARCH              ,TOTAL_AMOUNT_OVER                                  
REARCH              ,TOTAL_AMOUNT_SHRT                                  
REARCH              ,TOTAL_ADJUSTMENTS                                  
REARCH              ,NET_CURRENCY_TOTAL                                 
REARCH              ,REPORT_STATUS                                      
REARCH              ,BATCH_STATUS                                       
REARCH              ,BATCH_NUMBER                                       
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-CURRENCY-TYPE                                   
REARCH              ,:S-CURRENCY-DESC                                   
REARCH              ,:S-TOTAL-AMOUNT-OVERAGE                            
REARCH              ,:S-TOTAL-AMOUNT-SHORTAGE                           
REARCH              ,:S-TOTAL-ADJUSTMENTS                               
REARCH              ,:S-NET-CURRENCY-TOTAL                              
REARCH              ,:S-REPORT-STATUS                                   
REARCH              ,:S-BATCH-STATUS                                    
REARCH              ,:S-BATCH-NUMBER                                    
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02377_R1                                 
MFA-TR*         (                                                       01670000
MFA-TR*              RETURN_CODE                                        01670000
MFA-TR*             ,CURRENCY_TYPE                                              
MFA-TR*             ,CURRENCY_DESC                                              
MFA-TR*             ,TOTAL_AMOUNT_OVER                                          
MFA-TR*             ,TOTAL_AMOUNT_SHRT                                          
MFA-TR*             ,TOTAL_ADJUSTMENTS                                          
MFA-TR*             ,NET_CURRENCY_TOTAL                                         
MFA-TR*             ,REPORT_STATUS                                              
MFA-TR*             ,BATCH_STATUS                                               
MFA-TR*             ,BATCH_NUMBER                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                       01670000
MFA-TR*              :S-RETURN-CODE                                     01670000
MFA-TR*             ,:S-CURRENCY-TYPE                                           
MFA-TR*             ,:S-CURRENCY-DESC                                           
MFA-TR*             ,:S-TOTAL-AMOUNT-OVERAGE                                    
MFA-TR*             ,:S-TOTAL-AMOUNT-SHORTAGE                                   
MFA-TR*             ,:S-TOTAL-ADJUSTMENTS                                       
MFA-TR*             ,:S-NET-CURRENCY-TOTAL                                      
MFA-TR*             ,:S-REPORT-STATUS                                           
MFA-TR*             ,:S-BATCH-STATUS                                            
MFA-TR*             ,:S-BATCH-NUMBER                                            
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH          ADD +1                    TO CTR-ROWS                   
REARCH     ELSE                                                         
REARCH          MOVE PROGRAM-NAME         TO ABEND-PROGRAM              
REARCH          MOVE SQLCODE              TO ABEND-SQLCODE              
REARCH          MOVE '8100'               TO ACTIVE-PARAGRAPH           
REARCH          MOVE 'INSERT'             TO ABEND-FUNCTION             
REARCH          MOVE SPACES               TO ABEND-SQL-PREDICATES       
REARCH                                       ABEND-TABLES               
REARCH          MOVE 'CSR02377_R1'        TO TABLE-1                    
REARCH          MOVE SPACES               TO TABLE-ELEMENT-1            
REARCH          MOVE SPACES               TO HOSTVAR-ELEMENT-1          
REARCH          PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT          
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************42800000
      * 9700 -  ABEND HANDLING ROUTINE                                 *42810000
      ******************************************************************42820000
           EXEC SQL                                                     01720000
              INCLUDE CPD0023C                                          01730000
           END-EXEC.                                                    01740000
      ******************************************************************42800000
      * 9900 - JOURNALING / ERROR HANDLING ROUTINE                     *42810000
      ******************************************************************42820000
REARCH*    EXEC SQL                                                     42830000
REARCH*       INCLUDE CPD00300                                          42840000
REARCH*    END-EXEC.                                                    42850000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************42870000
      *       END PROGRAM COPYLIB                                      *42880000
      ******************************************************************42890000
REARCH*    COPY CPD00302.                                               42900000
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPD00320                                                
REARCH     END-EXEC.                                                            
