       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02376.                                         
COB303 DATE-WRITTEN.  MARCH 22, 1999.                                   
       DATE-COMPILED.                                                   
                                                                        
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S376 CONVERTED TO DB2 SP CSR02376 ON 02/09/2007        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************        
      *                                                                *        
      *          SOUTH CAROLINA ELECTRIC & GAS                         *        
      *                                                                *        
      * THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).    *        
      *                                                                *        
      *  TRANID:        S376                                           *        
      *  PROGRAM:       S376                                           *        
      *  CALLING SP:    PA_S376                                        *        
      *                                                                *        
      ******************************************************************        
      *                       P R O G R A M  S U M M A R Y             *        
      *                                                                *        
      *  INSERT THE INCOMING METER INFORMATION FROM ORIS TRANSACTION   *        
      *  AND RETRIEVE THE MARKETER AND CIS METER NUMBER RELATIONSHIPS  *        
      *  BASED ON THE ACCOUNT NUMBER.  FOR ORIS12, UPDATE THE LOCAL    *        
      *  OFFICE AND REVENUE DISTRICT CODE FOR THE ACCOUNT AND PREMISE. *        
      *                                                                *        
      *  PARAMETERS:                                                   *        
      *    ACTION-CODE                                                 *        
      *    ACCOUNT-NO                                                  *        
      *    METER-NO-1                                                  *        
      *    NO-OF-DIALS-1                                               *        
      *    METER-NO-2                                                  *        
      *    NO-OF-DIALS-2                                               *        
      *    METER-NO-3                                                  *        
      *    NO-OF-DIALS-3                                               *        
      *    METER-NO-4                                                  *        
      *    NO-OF-DIALS-4                                               *        
      *    METER-NO-5                                                  *        
      *    NO-OF-DIALS-5                                               *        
      *    LOCAL-OFFICE                                                *        
      *    REV-DISTRICT-CD                                             *        
      *    MTR-STORAGE-FAC-CD                                          *        
      *                                                                *        
      *  RETURNS:                                                      *        
      *    RETURN-CODE  (SUCCESS INDICATOR)                            *        
      *    MKT-METER-NO (THE AGL METER NO) - DIST-METER-NO             *        
      *    METER-NO     (THE CIS METER NO)                             *        
      *    PREMISE-NO  (4/29/99 DO NOT RETURN ANYMORE)                 *        
      *    MESSAGE-TX                                                  *        
      *                                                                *        
      ******************************************************************        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *  DATE      INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------- *        
      *  03/22/99  JVH        NEW CODE                                 *        
      *  05/99     JVH        UPDATE THE REV DISTRICT CD ONLY IF ONE IS*        
      *                       BEING PASSED UP.  THIS WILL ONLY OCCUR   *        
      *                       FOR SETM TRANSACTIONS.                   *        
      *  08/18/99  JVH        NEW ORIS 12 PROCESSING:  ADDED 7750-XM-  *        
      *                       SELECT TO RETRIEVE THE CURRENT DIST-ACCT-*        
      *                       NO FROM CSS-MKT-XREF-ACCT.  ERROR OUT IF *        
      *                       THE DIST-ACCT-NO IS NOT EQUAL TO SPACES  *        
      *                       AND NOT EQUAL TO THE PARM-DIST-ACCT-NO.  *        
      *  09/09/99  WMG        MODIFIED TO INSERT A ROW INTO            *        
      *                       CSS_DIST_XREF_MTR FOR MTMA TRANSACTIONS  *        
MTCH  *  10/04/99  AMG        ADDED CODE TO INACTIVATE METERS IN THE   *        
MTCH  *                       CSS_DIST_XREF_MTR TABLE FOR DIFFERENT    *        
MTCH  *                       TRANSACTION TYPES.                       *        
AMG   *  11/04/99  AMG        -  ALL METER INFORMATION IS RETURNED AT  *        
AMG   *                       ONCE INSTEAD OF ONE METER AT A TIME.     *        
AMG   *                       -  ONLY RETURN INFORMATION ABOUT ACTIVE  *        
AMG   *                          METERS.                               *        
T21290*  12/08/99  PRA        DO NOT UPDATE AT-LOCAL-OFFICE HERE       *        
T22243*  07/25/00  CBSI       CHANGES MADE TO IMPLEMENT MULTI-COMPANY  *        
T22243*            MADRAS     IN METER INVENTORY TABLES.               *        
C23811*  09/24/01  GSR        CHANGES MADE TO HANDLE COMPANY_NO ON     *        
C23811*                       CSS_GAS_METER_SIZE TABLE.                *        
C26373*  08/19/02  GSR        CHANGES MADE TO HANDLE PROGRAM_ID ON GM  *        
T31920*  01/21/05  RR         CORRECT MTMA PROCESSING                  *        
A04527*  06/06/13  MC95456    REMOVED UNUSED COPY BOOK CWS00056        *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      ******************************************************************        
                                                                        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
                                                                        
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02376'.
MSQ017     COPY MFASQLM.
       01  WS-START                      PIC X(40) VALUE                
           'WORKING STORAGE FOR RPC S376 STARTS HERE'.                  
                                                                        
                                                                        
      ******************************************************************        
      * DB2 INCLUDES                                                   *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      * EQ - CSS_EQUIPMENT                                                      
           EXEC SQL                                                             
              INCLUDE TBEQUIP                                                   
           END-EXEC.                                                            
                                                                        
      *    - CSS_DIST_XREF_MTR                                                  
           EXEC SQL                                                             
              INCLUDE TBMRKXMT                                                  
           END-EXEC.                                                            
                                                                        
      * GM - CSS_GAS_METER                                                      
           EXEC SQL                                                             
              INCLUDE TBGASMTR                                                  
           END-EXEC.                                                            
                                                                        
      * M5 - CSS_GAS_METER_SIZE                                                 
           EXEC SQL                                                             
              INCLUDE TBGASMSZ                                                  
           END-EXEC.                                                            
                                                                        
      * MC - CSS_MTR_CAP                                                        
           EXEC SQL                                                             
              INCLUDE TBMTRCAP                                                  
           END-EXEC.                                                            
                                                                        
      * PR - CSS_PREMISE                                                        
           EXEC SQL                                                             
               INCLUDE TBPREM                                                   
           END-EXEC.                                                            
                                                                        
      * AT - CSS_ACCOUNT                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
      * XM - CSS_MKT_XREF_ACCT                                                  
           EXEC SQL                                                             
               INCLUDE TBMRKXR                                                  
           END-EXEC.                                                            
                                                                        
      * ML - CSS_METER_NO_CNTL                                                  
           EXEC SQL                                                             
               INCLUDE TBMTRCTL                                                 
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      * COBOL WORKING STORAGE COPY BOOKS                               *        
      ******************************************************************        
CVT999*    COPY SYGWCOB.                                                        
CVT999*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
CVT999*    COPY CWS00010.                                                       
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
           COPY CJF00113.                                                       
                                                                        
           EXEC SQL                                                             
              INCLUDE CWS00107                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * WORK AREA                                                      *        
      ******************************************************************        
       01  WS-MISC.                                                     
           05  PROGRAM-NAME              PIC X(08) VALUE 'S376'.        
           05  WS-INSERT                 PIC X(01) VALUE 'I'.           
MTCH       05  WS-INACTIVE               PIC X(01) VALUE 'I'.           
MTCH       05  WS-ACTIVE                 PIC X(01) VALUE 'A'.           
           05  WS-ORIS12                 PIC X(01) VALUE 'B'.           
           05  WS-MTMA                   PIC X(01) VALUE 'U'.           
MTCH       05  WS-MTCH                   PIC X(01) VALUE 'M'.           
           05  WS-LETTER-A               PIC X(01) VALUE 'A'.           
           05  WS-LETTER-M               PIC X(01) VALUE 'M'.           
           05  WS-SYSTEM                 PIC X(06) VALUE 'SYSTEM'.      
           05  WS-CURRENT-TIMESTAMP      PIC X(26) VALUE SPACES.        
           05  WS-CURRENT-DATE           PIC X(10) VALUE SPACES.        
           05  WS-UNKNOWN                PIC X(07) VALUE 'UNKNOWN'.     
           05  WS-LETTER-XX              PIC X(02) VALUE 'XX'.          
           05  WS-LETTER-Y               PIC X(01) VALUE 'Y'.           
           05  WS-LETTER-N               PIC X(01) VALUE 'N'.           
           05  WS-LETTERS-DU             PIC X(02) VALUE 'DU'.          
COB305     05 WS-CONSTANT-DEC        PIC S9(09)V9(03) COMP-3 VALUE 0.       
T31920     05  WS-MC-CONSTANT-NUM        PIC 9(09).                     
T31920     05  WS-MC-CONSTANT REDEFINES WS-MC-CONSTANT-NUM              
                                         PIC X(09).                     
T31920     05  WS-NEW-CONSTANT-NUM       PIC 9(09).                     
T31920     05  WS-NEW-CONSTANT REDEFINES WS-NEW-CONSTANT-NUM            
                                         PIC X(09).                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.            
           05  WS-NO-OF-METERS           PIC S9(04) COMP VALUE ZEROES.  
                                                                        
       01  WS-MKT-METERS.                                               
           05  WS-MKT-METERS-LIST                                       
               OCCURS 5 TIMES INDEXED BY WS-MTRX.                       
               10 WS-MKT-METER-NO        PIC X(09).                     
               10 WS-MKT-NO-OF-DIALS     PIC X(04).                     
COB305         10 WS-CONSTANT        PIC S9(05)V9(03) COMP-3 VALUE 0.       
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
               88 NOT-ALL-DONE                     VALUE 'N'.           
               88 ALL-DONE                         VALUE 'Y'.           
           05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
               88 SEND-DONE-ERROR                  VALUE 'N'.           
               88 SEND-DONE-OK                     VALUE 'Y'.           
           05  CONSTANT-CHG-SW           PIC X(01) VALUE 'N'.           
               88 NEW-CONSTANT                     VALUE 'Y'.           
               88 SAME-CONSTANT                    VALUE 'N'.           
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
           05  GWL-STATUS-SUBCODE        PIC S9(09) COMP.               
           05  METER-INFO                OCCURS 6 TIMES                 
                                         INDEXED BY MTR-INDEX.          
               10  RS-CODE-UTIL-TYPE     PIC X(01) VALUE SPACES.        
               10  RS-DIST-METER-NO      PIC X(09) VALUE SPACES.        
               10  RS-METER-NO           PIC X(09) VALUE SPACES.        
MTCH           10  RS-STATUS-CD          PIC X(01) VALUE SPACES.        
                                                                        
       01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
                                                                        
       01  PARM-FIELDS.                                                 
           05  PARM-L                    PIC S9(09) COMP.               
           05  PARM-ACTION-CODE          PIC X(01) VALUE SPACES.        
           05  PARM-CODE-UTIL-TYPE       PIC X(01) VALUE SPACES.        
           05  PARM-COMPANY-NO           PIC X(02) VALUE SPACES.        
           05  PARM-ACCOUNT-NO           PIC X(13) VALUE SPACES.        
           05  PARM-ACCOUNT-NO-RED REDEFINES PARM-ACCOUNT-NO            
                                         PIC 9(13).                     
           05  PARM-DIST-COMPANY-NO      PIC X(03) VALUE SPACES.        
           05  PARM-DIST-ACCT-NO         PIC X(20) VALUE SPACES.        
           05  PARM-METER-NO-1           PIC X(09) VALUE SPACES.        
           05  PARM-NO-OF-DIALS-1        PIC X(04) VALUE SPACES.        
           05  PARM-CONSTANT-1           PIC X(09) VALUE '000000000'.   
           05  PARM-METER-NO-2           PIC X(09) VALUE SPACES.        
           05  PARM-NO-OF-DIALS-2        PIC X(04) VALUE SPACES.        
           05  PARM-CONSTANT-2           PIC X(09) VALUE '000000000'.   
           05  PARM-METER-NO-3           PIC X(09) VALUE SPACES.        
           05  PARM-NO-OF-DIALS-3        PIC X(04) VALUE SPACES.        
           05  PARM-CONSTANT-3           PIC X(09) VALUE '000000000'.   
           05  PARM-METER-NO-4           PIC X(09) VALUE SPACES.        
           05  PARM-NO-OF-DIALS-4        PIC X(04) VALUE SPACES.        
           05  PARM-CONSTANT-4           PIC X(09) VALUE '000000000'.   
           05  PARM-METER-NO-5           PIC X(09) VALUE SPACES.        
           05  PARM-NO-OF-DIALS-5        PIC X(04) VALUE SPACES.        
           05  PARM-CONSTANT-5           PIC X(09) VALUE '000000000'.   
           05  PARM-LOCAL-OFFICE         PIC X(03) VALUE SPACES.        
           05  PARM-REV-DISTRICT-CD      PIC X(03) VALUE SPACES.        
           05  PARM-MTR-STORAGE-FAC-CD   PIC X(03) VALUE SPACES.        
                                                                        
           05  PARM-NO-OF-DIALS          PIC 9(04) VALUE ZEROES.        
           05  WS-NO-OF-DIALS-DEC        PIC S9(4) USAGE COMP.          
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                  PIC S9(09) COMP.               
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS           PIC S9(09) COMP.               
                                                                        
       01  NULL-INDICATOR-FIELDS.                                       
           05  WS-NULL-IND               PIC S9(04) COMP VALUE -1.      
                                                                        
       01  FILLER                        PIC X(32) VALUE                
           'THIS IS THE ROW RETURN AREA.'.                              
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
CVT000     05   S-RETURN-CODE            PIC S9(09) COMP VALUE 0.       
           05  RS-MESSAGE-TX             PIC X(100) VALUE SPACES.       
           05  RS-CODE-UTIL-TYPE1        PIC X(01) VALUE SPACES.        
           05  RS-DIST-METER-NO1         PIC X(09) VALUE SPACES.        
           05  RS-METER-NO1              PIC X(09) VALUE SPACES.        
MTCH       05  RS-STATUS-CD1             PIC X(01) VALUE SPACES.        
           05  RS-CODE-UTIL-TYPE2        PIC X(01) VALUE SPACES.        
           05  RS-DIST-METER-NO2         PIC X(09) VALUE SPACES.        
           05  RS-METER-NO2              PIC X(09) VALUE SPACES.        
MTCH       05  RS-STATUS-CD2             PIC X(01) VALUE SPACES.        
           05  RS-CODE-UTIL-TYPE3        PIC X(01) VALUE SPACES.        
           05  RS-DIST-METER-NO3         PIC X(09) VALUE SPACES.        
           05  RS-METER-NO3              PIC X(09) VALUE SPACES.        
MTCH       05  RS-STATUS-CD3             PIC X(01) VALUE SPACES.        
           05  RS-CODE-UTIL-TYPE4        PIC X(01) VALUE SPACES.        
           05  RS-DIST-METER-NO4         PIC X(09) VALUE SPACES.        
           05  RS-METER-NO4              PIC X(09) VALUE SPACES.        
MTCH       05  RS-STATUS-CD4             PIC X(01) VALUE SPACES.        
           05  RS-CODE-UTIL-TYPE5        PIC X(01) VALUE SPACES.        
           05  RS-DIST-METER-NO5         PIC X(09) VALUE SPACES.        
           05  RS-METER-NO5              PIC X(09) VALUE SPACES.        
MTCH       05  RS-STATUS-CD5             PIC X(01) VALUE SPACES.        
           05  RS-CODE-UTIL-TYPE6        PIC X(01) VALUE SPACES.        
           05  RS-DIST-METER-NO6         PIC X(09) VALUE SPACES.        
           05  RS-METER-NO6              PIC X(09) VALUE SPACES.        
MTCH       05  RS-STATUS-CD6             PIC X(01) VALUE SPACES.        
                                                                        
CVT999******************************************************************        
CVT999* CURSOR DECLARATIONS                                            *        
CVT999******************************************************************        
CVT999* METER-ACCT-XREF CURSOR                                                  
           EXEC SQL                                                     
              DECLARE TM-CURSOR CURSOR FOR                              
              SELECT CODE_UTIL_TYPE,                                    
                     DIST_METER_NO,                                     
                     METER_NO,                                          
MTCH                 STATUS_CD                                          
                FROM CSS_DIST_XREF_MTR                                  
               WHERE DIST_ACCOUNT_NO = :TM-DIST-ACCOUNT-NO              
               AND   DIST_COMPANY_NO = :TM-DIST-COMPANY-NO              
AMG            AND   (STATUS_CD      = :WS-ACTIVE                       
AMG             OR   DIST_METER_NO   = :TM-DIST-METER-NO)               
MTCH  *     ORDER BY STATUS_CD                                                  
           END-EXEC.                                                    
                                                                        
HPCCDM*EJECT                                                                    
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000     EXEC SQL                                                     00000050
CVT000         INCLUDE CWSSP001                                         00000060
CVT000     END-EXEC.                                                    00000070
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
CVT000 01  LINK-ACTION-CODE         PIC X(01)                .          
CVT000 01  LINK-CODE-UTIL-TYPE      PIC X(01)                .          
CVT000 01  LINK-COMPANY-NO          PIC X(02)                .          
CVT000 01  LINK-ACCOUNT-NO          PIC X(13)                .          
CVT000 01  LINK-DIST-COMPANY-NO     PIC X(03)                .          
CVT000 01  LINK-DIST-ACCT-NO        PIC X(20)                .          
CVT000 01  LINK-METER-NO-1          PIC X(09)                .          
CVT000 01  LINK-NO-OF-DIALS-1       PIC X(04)                .          
CVT000 01  LINK-CONSTANT-1          PIC X(09)                .          
CVT000 01  LINK-METER-NO-2          PIC X(09)                .          
CVT000 01  LINK-NO-OF-DIALS-2       PIC X(04)                .          
CVT000 01  LINK-CONSTANT-2          PIC X(09)                .          
CVT000 01  LINK-METER-NO-3          PIC X(09)                .          
CVT000 01  LINK-NO-OF-DIALS-3       PIC X(04)                .          
CVT000 01  LINK-CONSTANT-3          PIC X(09)                .          
CVT000 01  LINK-METER-NO-4          PIC X(09)                .          
CVT000 01  LINK-NO-OF-DIALS-4       PIC X(04)                .          
CVT000 01  LINK-CONSTANT-4          PIC X(09)                .          
CVT000 01  LINK-METER-NO-5          PIC X(09)                .          
CVT000 01  LINK-NO-OF-DIALS-5       PIC X(04)                .          
CVT000 01  LINK-CONSTANT-5          PIC X(09)                .          
CVT000 01  LINK-LOCAL-OFFICE        PIC X(03)                .          
CVT000 01  LINK-REV-DISTRICT-CD     PIC X(03)                .          
CVT000 01  LINK-MTR-STORAGE-FAC-CD  PIC X(03)                .          
CVT000 01  LINK-NO-OF-DIALS         PIC 9(04)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-ACTION-CODE                                        
CVT000         ,LINK-CODE-UTIL-TYPE                                     
CVT000         ,LINK-COMPANY-NO                                         
CVT000         ,LINK-ACCOUNT-NO                                         
CVT000         ,LINK-DIST-COMPANY-NO                                    
CVT000         ,LINK-DIST-ACCT-NO                                       
CVT000         ,LINK-METER-NO-1                                         
CVT000         ,LINK-NO-OF-DIALS-1                                      
CVT000         ,LINK-CONSTANT-1                                         
CVT000         ,LINK-METER-NO-2                                         
CVT000         ,LINK-NO-OF-DIALS-2                                      
CVT000         ,LINK-CONSTANT-2                                         
CVT000         ,LINK-METER-NO-3                                         
CVT000         ,LINK-NO-OF-DIALS-3                                      
CVT000         ,LINK-CONSTANT-3                                         
CVT000         ,LINK-METER-NO-4                                         
CVT000         ,LINK-NO-OF-DIALS-4                                      
CVT000         ,LINK-CONSTANT-4                                         
CVT000         ,LINK-METER-NO-5                                         
CVT000         ,LINK-NO-OF-DIALS-5                                      
CVT000         ,LINK-CONSTANT-5                                         
CVT000         ,LINK-LOCAL-OFFICE                                       
CVT000         ,LINK-REV-DISTRICT-CD                                    
CVT000         ,LINK-MTR-STORAGE-FAC-CD                                 
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      * CONTROLS THE MAIN PATH OF THE PROGRAM                          *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                       THRU 0100-EXIT.
           PERFORM 2000-PROCESS-OUTPUT                   THRU 2000-EXIT.
           PERFORM 9999-END-PROGRAM                      THRU 9999-EXIT.
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      * 1. RESET DB2 ERROR HANDLERS                                    *        
      * 2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                      *        
      * 3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)       *        
      * 4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)    *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000       ,:RS-MESSAGE-TX               AS    MESSAGE_TX             
CVT000       ,:RS-CODE-UTIL-TYPE1          AS    CODE_UTIL_TYPE1        
CVT000       ,:RS-DIST-METER-NO1           AS    DIST_METER_NO1         
CVT000       ,:RS-METER-NO1                AS    METER_NO1              
CVT000       ,:RS-STATUS-CD1               AS    STATUS_CD1             
CVT000       ,:RS-CODE-UTIL-TYPE2          AS    CODE_UTIL_TYPE2        
CVT000       ,:RS-DIST-METER-NO2           AS    DIST_METER_NO2         
CVT000       ,:RS-METER-NO2                AS    METER_NO2              
CVT000       ,:RS-STATUS-CD2               AS    STATUS_CD2             
CVT000       ,:RS-CODE-UTIL-TYPE3          AS    CODE_UTIL_TYPE3        
CVT000       ,:RS-DIST-METER-NO3           AS    DIST_METER_NO3         
CVT000       ,:RS-METER-NO3                AS    METER_NO3              
CVT000       ,:RS-STATUS-CD3               AS    STATUS_CD3             
CVT000       ,:RS-CODE-UTIL-TYPE4          AS    CODE_UTIL_TYPE4        
CVT000       ,:RS-DIST-METER-NO4           AS    DIST_METER_NO4         
CVT000       ,:RS-METER-NO4                AS    METER_NO4              
CVT000       ,:RS-STATUS-CD4               AS    STATUS_CD4             
CVT000       ,:RS-CODE-UTIL-TYPE5          AS    CODE_UTIL_TYPE5        
CVT000       ,:RS-DIST-METER-NO5           AS    DIST_METER_NO5         
CVT000       ,:RS-METER-NO5                AS    METER_NO5              
CVT000       ,:RS-STATUS-CD5               AS    STATUS_CD5             
CVT000       ,:RS-CODE-UTIL-TYPE6          AS    CODE_UTIL_TYPE6        
CVT000       ,:RS-DIST-METER-NO6           AS    DIST_METER_NO6         
CVT000       ,:RS-METER-NO6                AS    METER_NO6              
CVT000       ,:RS-STATUS-CD6               AS    STATUS_CD6             
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*      ,:RS-MESSAGE-TX               AS    MESSAGE_TX                     
MFA-TR*      ,:RS-CODE-UTIL-TYPE1          AS    CODE_UTIL_TYPE1                
MFA-TR*      ,:RS-DIST-METER-NO1           AS    DIST_METER_NO1                 
MFA-TR*      ,:RS-METER-NO1                AS    METER_NO1                      
MFA-TR*      ,:RS-STATUS-CD1               AS    STATUS_CD1                     
MFA-TR*      ,:RS-CODE-UTIL-TYPE2          AS    CODE_UTIL_TYPE2                
MFA-TR*      ,:RS-DIST-METER-NO2           AS    DIST_METER_NO2                 
MFA-TR*      ,:RS-METER-NO2                AS    METER_NO2                      
MFA-TR*      ,:RS-STATUS-CD2               AS    STATUS_CD2                     
MFA-TR*      ,:RS-CODE-UTIL-TYPE3          AS    CODE_UTIL_TYPE3                
MFA-TR*      ,:RS-DIST-METER-NO3           AS    DIST_METER_NO3                 
MFA-TR*      ,:RS-METER-NO3                AS    METER_NO3                      
MFA-TR*      ,:RS-STATUS-CD3               AS    STATUS_CD3                     
MFA-TR*      ,:RS-CODE-UTIL-TYPE4          AS    CODE_UTIL_TYPE4                
MFA-TR*      ,:RS-DIST-METER-NO4           AS    DIST_METER_NO4                 
MFA-TR*      ,:RS-METER-NO4                AS    METER_NO4                      
MFA-TR*      ,:RS-STATUS-CD4               AS    STATUS_CD4                     
MFA-TR*      ,:RS-CODE-UTIL-TYPE5          AS    CODE_UTIL_TYPE5                
MFA-TR*      ,:RS-DIST-METER-NO5           AS    DIST_METER_NO5                 
MFA-TR*      ,:RS-METER-NO5                AS    METER_NO5                      
MFA-TR*      ,:RS-STATUS-CD5               AS    STATUS_CD5                     
MFA-TR*      ,:RS-CODE-UTIL-TYPE6          AS    CODE_UTIL_TYPE6                
MFA-TR*      ,:RS-DIST-METER-NO6           AS    DIST_METER_NO6                 
MFA-TR*      ,:RS-METER-NO6                AS    METER_NO6                      
MFA-TR*      ,:RS-STATUS-CD6               AS    STATUS_CD6                     
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
CVT000     MOVE LINK-ACTION-CODE          TO PARM-ACTION-CODE         . 
CVT000     MOVE LINK-CODE-UTIL-TYPE       TO PARM-CODE-UTIL-TYPE      . 
CVT000     MOVE LINK-COMPANY-NO           TO PARM-COMPANY-NO          . 
CVT000     MOVE LINK-ACCOUNT-NO           TO PARM-ACCOUNT-NO          . 
CVT000     MOVE LINK-DIST-COMPANY-NO      TO PARM-DIST-COMPANY-NO     . 
CVT000     MOVE LINK-DIST-ACCT-NO         TO PARM-DIST-ACCT-NO        . 
CVT000     MOVE LINK-METER-NO-1           TO PARM-METER-NO-1          . 
CVT000     MOVE LINK-NO-OF-DIALS-1        TO PARM-NO-OF-DIALS-1       . 
CVT000     MOVE LINK-CONSTANT-1           TO PARM-CONSTANT-1          . 
CVT000     MOVE LINK-METER-NO-2           TO PARM-METER-NO-2          . 
CVT000     MOVE LINK-NO-OF-DIALS-2        TO PARM-NO-OF-DIALS-2       . 
CVT000     MOVE LINK-CONSTANT-2           TO PARM-CONSTANT-2          . 
CVT000     MOVE LINK-METER-NO-3           TO PARM-METER-NO-3          . 
CVT000     MOVE LINK-NO-OF-DIALS-3        TO PARM-NO-OF-DIALS-3       . 
CVT000     MOVE LINK-CONSTANT-3           TO PARM-CONSTANT-3          . 
CVT000     MOVE LINK-METER-NO-4           TO PARM-METER-NO-4          . 
CVT000     MOVE LINK-NO-OF-DIALS-4        TO PARM-NO-OF-DIALS-4       . 
CVT000     MOVE LINK-CONSTANT-4           TO PARM-CONSTANT-4          . 
CVT000     MOVE LINK-METER-NO-5           TO PARM-METER-NO-5          . 
CVT000     MOVE LINK-NO-OF-DIALS-5        TO PARM-NO-OF-DIALS-5       . 
CVT000     MOVE LINK-CONSTANT-5           TO PARM-CONSTANT-5          . 
CVT000     MOVE LINK-LOCAL-OFFICE         TO PARM-LOCAL-OFFICE        . 
CVT000     MOVE LINK-REV-DISTRICT-CD      TO PARM-REV-DISTRICT-CD     . 
CVT000     MOVE LINK-MTR-STORAGE-FAC-CD   TO PARM-MTR-STORAGE-FAC-CD  . 
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     1. BUILD RESULT SET                                        *        
      *     2. SEND RESULT SET                                         *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2200-BUILD-RESULT                     THRU 2200-EXIT.
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
           MOVE PARM-COMPANY-NO               TO XM-COMPANY-NO          
T22243                                           MC-COMPANY-NO          
T22243                                           GM-COMPANY-NO.         
           MOVE PARM-ACCOUNT-NO-RED           TO WS-ACCOUNT-NO.         
           MOVE WS-ACCOUNT-NO                 TO XM-ACCOUNT-NO          
                                                 AT-ACCOUNT-NO.         
           MOVE PARM-DIST-ACCT-NO             TO TM-DIST-ACCOUNT-NO.    
           MOVE PARM-DIST-COMPANY-NO          TO TM-DIST-COMPANY-NO.    
                                                                        
      * FOR ORIS12 - VERIFY THAT THE INCOMING DIST-ACCT-NO IS VALID             
           IF PARM-ACTION-CODE EQUAL WS-ORIS12 THEN                     
               PERFORM 7750-XM-SELECT                    THRU 7750-EXIT 
                                                                        
               IF XM-DIST-ACCT-NO NOT EQUAL SPACES AND                  
                  XM-DIST-ACCT-NO NOT EQUAL PARM-DIST-ACCT-NO THEN      
                   MOVE 100                   TO WS-ACTIVE-RETURN-CODE  
AMG                MOVE 100                   TO SQLCODE                
                                                                        
                   MOVE 'INCOMING DIST-ACCT-NO IS INVALID. (S376)'      
                                              TO RS-MESSAGE-TX          
                   MOVE '2200'                TO ACTIVE-PARAGRAPH       
                   MOVE PROGRAM-NAME          TO ABEND-PROGRAM          
                   MOVE 'VALIDATE'            TO ABEND-FUNCTION         
                   MOVE 'CSS-MKT-XREF-ACCT'   TO TABLE-1                
                   MOVE 'ACCOUNT-NO'          TO TABLE-ELEMENT-1        
                   MOVE XM-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
                   MOVE 'CURRENT-DIST-ACCT-NO'                          
                                              TO TABLE-ELEMENT-2        
                   MOVE XM-DIST-ACCT-NO       TO HOSTVAR-ELEMENT-2      
                   MOVE 'INCOMING-DIST-ACCTNO'                          
                                              TO TABLE-ELEMENT-3        
                   MOVE PARM-DIST-ACCT-NO     TO HOSTVAR-ELEMENT-3      
                                                                        
                   PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT 
                   PERFORM 9900-SQL-ERROR-ROUTINE        THRU 9900-EXIT 
               END-IF                                                   
           END-IF.                                                      
                                                                        
MTMA       IF PARM-ACTION-CODE = WS-MTMA                                
MTMA           MOVE PARM-CODE-UTIL-TYPE       TO TM-CODE-UTIL-TYPE      
MTMA           MOVE PARM-METER-NO-2           TO TM-DIST-METER-NO       
MTCH           MOVE WS-ACTIVE                 TO TM-STATUS-CD           
MTMA                                                                    
MTMA           PERFORM 7000-SELECT-METER-XREF THRU 7000-EXIT            
                                                                        
MTCH  * TO MAKE THE METER INACTIVE, INSERT A NEW RECORD WITH                    
MTCH  * STATUS_CD = 'I' AND DELETE THE OLD RECORD WITH STATUS_CD ='A'           
T31920         IF PARM-METER-NO-1 NOT EQUAL PARM-METER-NO-2             
MTCH               PERFORM 7950-DELETE-METER-XREF THRU 7950-EXIT        
MTCH               MOVE WS-INACTIVE               TO TM-STATUS-CD       
MTCH               PERFORM 7100-INSERT-METER-XREF THRU 7100-EXIT        
MTCH               MOVE WS-ACTIVE                 TO TM-STATUS-CD       
MTMA               MOVE PARM-METER-NO-1           TO TM-DIST-METER-NO   
MTMA               PERFORM 7100-INSERT-METER-XREF THRU 7100-EXIT        
T31920         END-IF                                                   
MTMA           MOVE PARM-NO-OF-DIALS-1        TO PARM-NO-OF-DIALS       
MTMA           MOVE PARM-NO-OF-DIALS          TO WS-NO-OF-DIALS-DEC     
MTMA           MOVE PARM-CONSTANT-1           TO WS-CONSTANT-DEC        
MTMA           DIVIDE 10000 INTO WS-CONSTANT-DEC GIVING                 
MTMA                                          WS-CONSTANT-DEC ROUNDED   
MTMA                                                                    
MTMA           PERFORM 7450-SELECT-MTR-CAP    THRU 7450-EXIT            
MTMA                                                                    
MTMA           IF (WS-NO-OF-DIALS-DEC NOT EQUAL MC-NO-DIALS) OR         
MTMA              (WS-CONSTANT-DEC    NOT EQUAL MC-CONSTANT)            
T31920            IF WS-CONSTANT-DEC  NOT EQUAL MC-CONSTANT             
T31920               MOVE MC-CONSTANT         TO WS-MC-CONSTANT-NUM     
T31920               MOVE WS-CONSTANT-DEC     TO WS-NEW-CONSTANT-NUM    
T31920               MOVE 'Y'                 TO CONSTANT-CHG-SW        
T31920            END-IF                                                
MTMA              MOVE WS-NO-OF-DIALS-DEC     TO MC-NO-DIALS            
MTMA                                             MC-NO-READ-DIALS       
MTMA              MOVE WS-CONSTANT-DEC        TO MC-CONSTANT            
MTMA                                                                    
MTMA              PERFORM 7475-UPDATE-MTR-CAP THRU 7475-EXIT            
                                                                        
T31920****   BUILD STRING TO CREATE WQ IN PBTRANSINDRIVER   ****                
T31920            IF NEW-CONSTANT                                       
T31920               STRING 'CONSTANT CHANGE FOR METER '                
T31920                    TM-METER-NO                                   
T31920                    ' CURRENT CONSTANT = '                        
T31920                    WS-MC-CONSTANT                                
T31920                    ' NEW CONSTANT = '                            
T31920                    WS-NEW-CONSTANT DELIMITED BY 'SPACE SPACE'    
T31920                    INTO RS-MESSAGE-TX                            
T31920            END-IF                                                
MTMA           END-IF                                                   
MTMA       END-IF.                                                      
                                                                        
MTCH       IF PARM-ACTION-CODE EQUAL WS-MTCH THEN                       
MTCH           PERFORM 7010-GET-TIMESTAMP                THRU 7010-EXIT 
MTCH                                                                    
MTCH           MOVE PARM-CODE-UTIL-TYPE       TO TM-CODE-UTIL-TYPE      
MTCH                                             EQ-CODE-UTIL-TYPE      
MTCH                                             GM-CODE-UTIL-TYPE      
MTCH                                             MC-CODE-UTIL-TYPE      
MTCH           MOVE PARM-COMPANY-NO           TO EQ-COMPANY-NO          
MTCH           MOVE PARM-MTR-STORAGE-FAC-CD   TO EQ-LOCAL-OFFICE        
MTCH           MOVE PARM-LOCAL-OFFICE         TO XM-MKT-POOL-GRP        
MTCH           MOVE PARM-DIST-ACCT-NO         TO XM-DIST-ACCT-NO        
MTCH           MOVE WS-LETTER-M               TO EQ-EQUIP-TYPE-CD       
MTCH                                             GM-DEVICE-TYPE-CD      
MTCH           MOVE WS-LETTER-A               TO EQ-CODE-CRNT-LOC       
MTCH                                             GM-CODE-CASE-TYPE      
MTCH                                             MC-CODE-CAP-TYPE       
MTCH           MOVE WS-LETTER-Y               TO GM-CODE-CAP-CFF        
MTCH           MOVE WS-LETTER-XX              TO GM-DIGTL-MTR-TYPE      
C26373         MOVE '01'                      TO GM-PROGRAM-ID          
MTCH           MOVE WS-LETTER-N               TO GM-CODE-CAP-UCG        
MTCH                                             GM-CODE-CAP-GAL        
MTCH           MOVE 0                         TO EQ-CRNT-LOC-NO         
MTCH                                             GM-CASE-PRESSURE       
MTCH                                             GM-MCF-CAP-PER-HR      
MTCH                                             GM-CODE-TIME-PERIOD    
MTCH                                             GM-NUMBER-OF-DRIVE     
MTCH                                             MC-FULL-SCALE          
MTCH           MOVE WS-SYSTEM                 TO EQ-INSTALL-EMP-ID      
MTCH           MOVE SPACES                    TO EQ-PALETTE-NO          
MTCH                                             EQ-SERIAL-NO           
MTCH                                             EQ-UPGRADES-TX         
MTCH                                             EQ-HAZARD-MATERIAL-CD  
MTCH                                             GM-CODE-ATTACHMENTS    
MTCH                                             MC-REG-MEASURES-CD     
MTCH                                             MC-CODE-HIGH-LOW-DIAL  
MTCH                                             MC-DEMAND-TYPE         
MTCH           MOVE WS-LETTERS-DU             TO EQ-CODE-MAKE           
MTCH                                                                    
MTCH           MOVE PARM-CONSTANT-1           TO WS-CONSTANT-DEC        
MTCH           DIVIDE 10000 INTO WS-CONSTANT-DEC GIVING                 
MTCH                                             WS-CONSTANT-DEC ROUNDED
MTCH                                                                    
MTCH           IF PARM-METER-NO-1 EQUAL SPACES OR                       
MTCH              PARM-METER-NO-2 EQUAL SPACES                          
MTCH               MOVE 'ERROR ON NUMBER OF METERS SENT. (S376)'        
MTCH                                          TO RS-MESSAGE-TX          
MTCH               MOVE NOT-FOUND             TO WS-ACTIVE-RETURN-CODE  
MTCH                                                                    
MTCH               PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT 
MTCH           END-IF                                                   
MTCH                                                                    
MTCH  * USE CHECK DIGIT COPYBOOKS TO GET THE NEW CSR METER NUMBER               
MTCH           MOVE WS-CURRENT-DATE       TO WS-107-CURRENT-DATE        
MTCH           MOVE WS-CURRENT-TIMESTAMP  TO                            
MTCH                                      WS-107-CURRENT-TIMESTAMP      
MTCH           MOVE WS-SYSTEM             TO WS-107-USERID              
MTCH           MOVE 'NEW METER NO CREATED'                              
MTCH                                      TO WS-107-TRANS-COMMENTS      
MTCH           MOVE 20                    TO                            
MTCH                                      WS-107-TRANS-COMMENTS-LEN     
MTCH                                                                    
MTCH           PERFORM 6202-GET-NEW-METER-NO         THRU 6202-EXIT     
MTCH                                                                    
MTCH  * FIRST UPDATE THE OLD METER NUMBER TO INACTIVE ON XREF METER TBL         
MTCH  * (MUST INSERT INACTIVE RECORD AND DELETE ACTIVE RECORD)                  
MTCH           MOVE WS-ACTIVE             TO TM-STATUS-CD               
MTCH           MOVE PARM-METER-NO-2       TO TM-DIST-METER-NO           
MTCH           PERFORM 7000-SELECT-METER-XREF THRU 7000-EXIT            
MTCH           PERFORM 7950-DELETE-METER-XREF        THRU 7950-EXIT     
MTCH           MOVE WS-INACTIVE           TO TM-STATUS-CD               
MTCH           PERFORM 7100-INSERT-METER-XREF        THRU 7100-EXIT     
MTCH                                                                    
MTCH           MOVE WS-ACTIVE             TO TM-STATUS-CD               
MTCH                                                                    
MTCH           MOVE PARM-METER-NO-1       TO TM-DIST-METER-NO           
MTCH           MOVE WS-107-NEW-METER-NO   TO TM-METER-NO                
MTCH                                         EQ-DEVICE-NO               
MTCH                                         GM-METER-NO                
MTCH                                         MC-METER-NO                
MTCH                                                                    
MTCH           PERFORM 7100-INSERT-METER-XREF        THRU 7100-EXIT     
MTCH                                                                    
MTCH           PERFORM 7200-INSERT-EQUIPMENT         THRU 7200-EXIT     
MTCH                                                                    
C23811         MOVE PARM-COMPANY-NO       TO M5-COMPANY-NO              
MTCH           MOVE WS-UNKNOWN            TO M5-METER-SIZE-ID           
MTCH                                             GM-METER-SIZE-ID       
MTCH           PERFORM 7350-GET-GAS-METER-SIZE       THRU 7350-EXIT     
MTCH                                                                    
MTCH           MOVE M5-CODE-METER-TYPE    TO GM-CODE-METER-TYPE         
MTCH           MOVE M5-CCF-CAP-PER-HR     TO GM-CCF-CAP-PER-HR          
MTCH           MOVE M5-CODE-CO-SIZE       TO GM-CODE-CO-SIZE            
MTCH           MOVE M5-ALLOW-CONSTANT-FL  TO GM-ALLOW-CONSTANT-FL       
MTCH           MOVE M5-MODEL-CD           TO GM-MODEL-CD                
MTCH           MOVE M5-CONNECTION-TYPE-CD TO GM-CONNECTION-TYPE-CD      
MTCH           MOVE M5-TEST-SCHED-CD      TO GM-TEST-SCHED-CD           
MTCH                                                                    
MTCH           PERFORM 7300-INSERT-GAS-METER         THRU 7300-EXIT     
MTCH                                                                    
MTCH           MOVE 1                     TO MC-REG-ID-NO               
MTCH           MOVE WS-CONSTANT-DEC       TO MC-CONSTANT                
MTCH                                                                    
MTCH           MOVE PARM-NO-OF-DIALS-1    TO PARM-NO-OF-DIALS           
MTCH           MOVE PARM-NO-OF-DIALS      TO MC-NO-READ-DIALS           
MTCH                                         MC-NO-DIALS                
MTCH                                                                    
MTCH           PERFORM 7400-INSERT-MTR-CAP           THRU 7400-EXIT     
MTCH                                                                    
MTCH       END-IF.                                                      
                                                                        
           IF PARM-ACTION-CODE EQUAL WS-INSERT OR WS-ORIS12 THEN        
               PERFORM 7010-GET-TIMESTAMP                THRU 7010-EXIT 
                                                                        
               MOVE PARM-CODE-UTIL-TYPE       TO TM-CODE-UTIL-TYPE      
                                                 EQ-CODE-UTIL-TYPE      
                                                 GM-CODE-UTIL-TYPE      
                                                 MC-CODE-UTIL-TYPE      
               MOVE PARM-COMPANY-NO           TO EQ-COMPANY-NO          
               MOVE PARM-MTR-STORAGE-FAC-CD   TO EQ-LOCAL-OFFICE        
               MOVE PARM-LOCAL-OFFICE         TO XM-MKT-POOL-GRP        
               MOVE PARM-DIST-ACCT-NO         TO XM-DIST-ACCT-NO        
               MOVE WS-LETTER-M               TO EQ-EQUIP-TYPE-CD       
                                                 GM-DEVICE-TYPE-CD      
               MOVE WS-LETTER-A               TO EQ-CODE-CRNT-LOC       
                                                 GM-CODE-CASE-TYPE      
                                                 MC-CODE-CAP-TYPE       
               MOVE WS-LETTER-Y               TO GM-CODE-CAP-CFF        
               MOVE WS-LETTER-XX              TO GM-DIGTL-MTR-TYPE      
C26373         MOVE '01'                      TO GM-PROGRAM-ID          
               MOVE WS-LETTER-N               TO GM-CODE-CAP-UCG        
                                                 GM-CODE-CAP-GAL        
               MOVE 0                         TO EQ-CRNT-LOC-NO         
                                                 GM-CASE-PRESSURE       
                                                 GM-MCF-CAP-PER-HR      
                                                 GM-CODE-TIME-PERIOD    
                                                 GM-NUMBER-OF-DRIVE     
                                                 MC-FULL-SCALE          
               MOVE WS-SYSTEM                 TO EQ-INSTALL-EMP-ID      
               MOVE SPACES                    TO EQ-PALETTE-NO          
                                                 EQ-SERIAL-NO           
                                                 EQ-UPGRADES-TX         
                                                 EQ-HAZARD-MATERIAL-CD  
                                                 GM-CODE-ATTACHMENTS    
                                                 MC-REG-MEASURES-CD     
                                                 MC-CODE-HIGH-LOW-DIAL  
                                                 MC-DEMAND-TYPE         
               MOVE WS-LETTERS-DU             TO EQ-CODE-MAKE           
                                                                        
               SET WS-MTRX                    TO 1                      
                                                                        
               IF PARM-METER-NO-1 GREATER THAN SPACES THEN              
                   MOVE PARM-METER-NO-1       TO                        
                                              WS-MKT-METER-NO(WS-MTRX)  
                   MOVE PARM-NO-OF-DIALS-1    TO                        
                                             WS-MKT-NO-OF-DIALS(WS-MTRX)
                   MOVE PARM-CONSTANT-1       TO WS-CONSTANT-DEC        
                   DIVIDE 10000 INTO WS-CONSTANT-DEC GIVING             
                                                 WS-CONSTANT-DEC ROUNDED
                   MOVE WS-CONSTANT-DEC       TO WS-CONSTANT(WS-MTRX)   
                                                                        
                   SET WS-MTRX UP BY 1                                  
                   ADD 1                      TO WS-NO-OF-METERS        
               END-IF                                                   
                                                                        
               IF PARM-METER-NO-2 GREATER THAN SPACES THEN              
                   MOVE PARM-METER-NO-2       TO                        
                                              WS-MKT-METER-NO(WS-MTRX)  
                   MOVE PARM-NO-OF-DIALS-2    TO                        
                                             WS-MKT-NO-OF-DIALS(WS-MTRX)
                                                                        
                   MOVE PARM-CONSTANT-2       TO WS-CONSTANT-DEC        
                   DIVIDE 10000 INTO WS-CONSTANT-DEC GIVING             
                                                 WS-CONSTANT-DEC ROUNDED
                   MOVE WS-CONSTANT-DEC       TO WS-CONSTANT(WS-MTRX)   
                                                                        
                   SET WS-MTRX UP BY 1                                  
                   ADD 1                      TO WS-NO-OF-METERS        
               END-IF                                                   
                                                                        
               IF PARM-METER-NO-3 GREATER THAN SPACES THEN              
                   MOVE PARM-METER-NO-3       TO                        
                                              WS-MKT-METER-NO(WS-MTRX)  
                   MOVE PARM-NO-OF-DIALS-3    TO                        
                                             WS-MKT-NO-OF-DIALS(WS-MTRX)
                   MOVE PARM-CONSTANT-3       TO WS-CONSTANT-DEC        
                   DIVIDE 10000 INTO WS-CONSTANT-DEC GIVING             
                                                 WS-CONSTANT-DEC ROUNDED
                   MOVE WS-CONSTANT-DEC       TO WS-CONSTANT(WS-MTRX)   
                                                                        
                   SET WS-MTRX UP BY 1                                  
                   ADD 1                      TO WS-NO-OF-METERS        
               END-IF                                                   
                                                                        
               IF PARM-METER-NO-4 GREATER THAN SPACES THEN              
                   MOVE PARM-METER-NO-4       TO                        
                                              WS-MKT-METER-NO(WS-MTRX)  
                   MOVE PARM-NO-OF-DIALS-4    TO                        
                                             WS-MKT-NO-OF-DIALS(WS-MTRX)
                   MOVE PARM-CONSTANT-4       TO WS-CONSTANT-DEC        
                   DIVIDE 10000 INTO WS-CONSTANT-DEC GIVING             
                                                 WS-CONSTANT-DEC ROUNDED
                   MOVE WS-CONSTANT-DEC       TO WS-CONSTANT(WS-MTRX)   
                                                                        
                   SET WS-MTRX UP BY 1                                  
                   ADD 1                      TO WS-NO-OF-METERS        
               END-IF                                                   
                                                                        
               IF PARM-METER-NO-5 GREATER THAN SPACES THEN              
                   MOVE PARM-METER-NO-5       TO                        
                                              WS-MKT-METER-NO(WS-MTRX)  
                   MOVE PARM-NO-OF-DIALS-5    TO                        
                                             WS-MKT-NO-OF-DIALS(WS-MTRX)
                   MOVE PARM-CONSTANT-5       TO WS-CONSTANT-DEC        
                   DIVIDE 10000 INTO WS-CONSTANT-DEC GIVING             
                                                 WS-CONSTANT-DEC ROUNDED
                   MOVE WS-CONSTANT-DEC       TO WS-CONSTANT(WS-MTRX)   
                                                                        
                   ADD 1                      TO WS-NO-OF-METERS        
               END-IF                                                   
                                                                        
               IF WS-NO-OF-METERS EQUAL 0 THEN                          
                   MOVE 'ERROR ON NUMBER OF METERS SENT. (S376)'        
                                              TO RS-MESSAGE-TX          
                   MOVE NOT-FOUND             TO WS-ACTIVE-RETURN-CODE  
                                                                        
                   PERFORM 9000-SEND-ERROR-RESULT        THRU 9000-EXIT 
               END-IF                                                   
                                                                        
               SET WS-MTRX                    TO 1                      
                                                                        
MTCH           MOVE WS-ACTIVE                 TO TM-STATUS-CD           
                                                                        
               PERFORM UNTIL WS-MTRX > WS-NO-OF-METERS                  
      * USE CHECK DIGIT COPYBOOKS TO GET THE NEW CSR METER NUMBER               
                   MOVE WS-CURRENT-DATE       TO WS-107-CURRENT-DATE    
                   MOVE WS-CURRENT-TIMESTAMP  TO                        
                                              WS-107-CURRENT-TIMESTAMP  
                   MOVE WS-SYSTEM             TO WS-107-USERID          
                   MOVE 'NEW METER NO CREATED'                          
                                              TO WS-107-TRANS-COMMENTS  
                   MOVE 20                    TO                        
                                              WS-107-TRANS-COMMENTS-LEN 
                                                                        
                   PERFORM 6202-GET-NEW-METER-NO         THRU 6202-EXIT 
                                                                        
                   MOVE WS-MKT-METER-NO(WS-MTRX)                        
                                              TO TM-DIST-METER-NO       
                   MOVE WS-107-NEW-METER-NO   TO TM-METER-NO            
                                                 EQ-DEVICE-NO           
                                                 GM-METER-NO            
                                                 MC-METER-NO            
                                                                        
                   PERFORM 7100-INSERT-METER-XREF        THRU 7100-EXIT 
                                                                        
                   PERFORM 7200-INSERT-EQUIPMENT         THRU 7200-EXIT 
                                                                        
C23811             MOVE PARM-COMPANY-NO       TO M5-COMPANY-NO          
                   MOVE WS-UNKNOWN            TO M5-METER-SIZE-ID       
                                                 GM-METER-SIZE-ID       
                   PERFORM 7350-GET-GAS-METER-SIZE       THRU 7350-EXIT 
                                                                        
                   MOVE M5-CODE-METER-TYPE    TO GM-CODE-METER-TYPE     
                   MOVE M5-CCF-CAP-PER-HR     TO GM-CCF-CAP-PER-HR      
                   MOVE M5-CODE-CO-SIZE       TO GM-CODE-CO-SIZE        
                   MOVE M5-ALLOW-CONSTANT-FL  TO GM-ALLOW-CONSTANT-FL   
                   MOVE M5-MODEL-CD           TO GM-MODEL-CD            
                   MOVE M5-CONNECTION-TYPE-CD TO GM-CONNECTION-TYPE-CD  
                   MOVE M5-TEST-SCHED-CD      TO GM-TEST-SCHED-CD       
                                                                        
                   PERFORM 7300-INSERT-GAS-METER         THRU 7300-EXIT 
                                                                        
                   MOVE 1                     TO MC-REG-ID-NO           
                   MOVE WS-CONSTANT(WS-MTRX)  TO MC-CONSTANT            
                                                                        
                   MOVE WS-MKT-NO-OF-DIALS(WS-MTRX)                     
                                              TO PARM-NO-OF-DIALS       
                   MOVE PARM-NO-OF-DIALS      TO MC-NO-READ-DIALS       
                                                 MC-NO-DIALS            
                                                                        
                   PERFORM 7400-INSERT-MTR-CAP           THRU 7400-EXIT 
                                                                        
                   SET WS-MTRX UP BY 1                                  
               END-PERFORM                                              
                                                                        
               IF PARM-ACTION-CODE EQUAL WS-ORIS12 THEN                 
                                                                        
                    PERFORM 7700-UPDATE-MKT-ACCT-XREF    THRU 7700-EXIT 
               END-IF                                                   
           END-IF.                                                      
                                                                        
      * UPDATE THE REV-DISTRICT-CD ONLY IF ONE IS PASSED                        
      * CURRENTLY, ONLY SETM TRANSACTIONS WILL PASS UP A REV-DISTRICT-CD        
           IF PARM-REV-DISTRICT-CD GREATER THAN SPACES THEN             
               PERFORM 7650-SELECT-ACCOUNT               THRU 7650-EXIT 
                                                                        
               MOVE AT-PREMISE-NO             TO PR-PREMISE-NO          
               MOVE PARM-REV-DISTRICT-CD      TO PR-REV-DISTRICT-CD     
                                                                        
               PERFORM 7500-UPDATE-PREMISE               THRU 7500-EXIT 
           END-IF.                                                      
                                                                        
AMG        IF PARM-ACTION-CODE EQUAL WS-MTCH THEN                       
AMG           MOVE PARM-METER-NO-2            TO TM-DIST-METER-NO       
AMG        ELSE                                                         
AMG           MOVE SPACES                     TO TM-DIST-METER-NO       
AMG        END-IF.                                                      
                                                                        
           PERFORM 7800-OPEN-TM-CURSOR                   THRU 7800-EXIT.
           PERFORM 7850-FETCH-TM-CURSOR                  THRU 7850-EXIT.
AMG        MOVE ZEROES                                   TO CTR-ROWS.   
                                                                        
AMG        PERFORM VARYING MTR-INDEX FROM 1 BY 1                        
AMG                UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND          
AMG            MOVE TM-CODE-UTIL-TYPE  TO RS-CODE-UTIL-TYPE (MTR-INDEX) 
AMG            MOVE TM-DIST-METER-NO   TO RS-DIST-METER-NO (MTR-INDEX)  
AMG            MOVE TM-METER-NO        TO RS-METER-NO (MTR-INDEX)       
AMG            MOVE TM-STATUS-CD       TO RS-STATUS-CD (MTR-INDEX)      
AMG            ADD 1                   TO CTR-ROWS                      
                                                                        
               PERFORM 7850-FETCH-TM-CURSOR              THRU 7850-EXIT 
           END-PERFORM.                                                 
REARCH     MOVE RS-CODE-UTIL-TYPE(1)  TO RS-CODE-UTIL-TYPE1             
REARCH     MOVE RS-DIST-METER-NO(1)   TO RS-DIST-METER-NO1              
REARCH     MOVE RS-METER-NO(1)        TO RS-METER-NO1                   
REARCH     MOVE RS-STATUS-CD(1)       TO RS-STATUS-CD1                  
REARCH     MOVE RS-CODE-UTIL-TYPE(2)  TO RS-CODE-UTIL-TYPE2             
REARCH     MOVE RS-DIST-METER-NO(2)   TO RS-DIST-METER-NO2              
REARCH     MOVE RS-METER-NO(2)        TO RS-METER-NO2                   
REARCH     MOVE RS-STATUS-CD(2)       TO RS-STATUS-CD2                  
REARCH     MOVE RS-CODE-UTIL-TYPE(3)  TO RS-CODE-UTIL-TYPE3             
REARCH     MOVE RS-DIST-METER-NO(3)   TO RS-DIST-METER-NO3              
REARCH     MOVE RS-METER-NO(3)        TO RS-METER-NO3                   
REARCH     MOVE RS-STATUS-CD(3)       TO RS-STATUS-CD3                  
REARCH     MOVE RS-CODE-UTIL-TYPE(4)  TO RS-CODE-UTIL-TYPE4             
REARCH     MOVE RS-DIST-METER-NO(4)   TO RS-DIST-METER-NO4              
REARCH     MOVE RS-METER-NO(4)        TO RS-METER-NO4                   
REARCH     MOVE RS-STATUS-CD(4)       TO RS-STATUS-CD4                  
REARCH     MOVE RS-CODE-UTIL-TYPE(5)  TO RS-CODE-UTIL-TYPE5             
REARCH     MOVE RS-DIST-METER-NO(5)   TO RS-DIST-METER-NO5              
REARCH     MOVE RS-METER-NO(5)        TO RS-METER-NO5                   
REARCH     MOVE RS-STATUS-CD(5)       TO RS-STATUS-CD5                  
REARCH     MOVE RS-CODE-UTIL-TYPE(6)  TO RS-CODE-UTIL-TYPE6             
REARCH     MOVE RS-DIST-METER-NO(6)   TO RS-DIST-METER-NO6              
REARCH     MOVE RS-METER-NO(6)        TO RS-METER-NO6                   
REARCH     MOVE RS-STATUS-CD(6)       TO RS-STATUS-CD6                  
                                                                        
           PERFORM 7900-CLOSE-TM-CURSOR                  THRU 7900-EXIT.
AMG        PERFORM 8100-SEND-RESULT                      THRU 8100-EXIT.
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * COPYBOOKS USED TO CALCULATE THE CHECK DIGIT IN ORDER TO CREATE          
      * A NEW METER NO                                                          
           EXEC SQL                                                             
              INCLUDE CPD00107                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00108                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-METER-XREF.                                        *        
      ******************************************************************        
       7000-SELECT-METER-XREF.                                          
                                                                        
           EXEC SQL                                                     
              SELECT METER_NO                                           
                INTO :TM-METER-NO                                       
                FROM CSS_DIST_XREF_MTR                                  
               WHERE DIST_ACCOUNT_NO = :TM-DIST-ACCOUNT-NO              
                 AND DIST_COMPANY_NO = :TM-DIST-COMPANY-NO              
                 AND DIST_METER_NO   = :TM-DIST-METER-NO                
MTCH             AND STATUS_CD       = :TM-STATUS-CD                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7000'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON SELECT METER_NO. (S376)'                    
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS_DIST_XREF_ACCT'        TO TABLE-1                
             MOVE 'DIST_ACCOUNT_NO'           TO TABLE-ELEMENT-1        
             MOVE TM-DIST-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
             MOVE 'DIST_COMPANY_NO'           TO TABLE-ELEMENT-2        
             MOVE TM-DIST-COMPANY-NO          TO HOSTVAR-ELEMENT-2      
             MOVE 'DIST_METER_NO'             TO TABLE-ELEMENT-3        
             MOVE TM-DIST-METER-NO            TO HOSTVAR-ELEMENT-3      
MTCH         MOVE 'STATUS_CD'                 TO TABLE-ELEMENT-4        
MTCH         MOVE TM-STATUS-CD                TO HOSTVAR-ELEMENT-4      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7010-GET-TIMESTAMP.                                            *        
      ******************************************************************        
                                                                        
       7010-GET-TIMESTAMP.                                              
           EXEC SQL                                                     
              SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
                INTO :WS-CURRENT-TIMESTAMP,                             
                     :WS-CURRENT-DATE                                   
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :WS-CURRENT-TIMESTAMP,                                     
MFA-TR*              :WS-CURRENT-DATE                                           
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7010'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON SELECT CURRENT TIMESTAMP AND DATE. (S376)'  
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-MODEL-SQL'             TO TABLE-1                
             MOVE 'CURRENT DATE'              TO TABLE-ELEMENT-1        
             MOVE WS-CURRENT-DATE             TO HOSTVAR-ELEMENT-1      
             MOVE 'CURRENT TIMESTAMP'         TO TABLE-ELEMENT-2        
             MOVE WS-CURRENT-TIMESTAMP        TO HOSTVAR-ELEMENT-2      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7100-INSERT-METER-XREF                                         *        
      ******************************************************************        
                                                                        
       7100-INSERT-METER-XREF.                                          
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_DIST_XREF_MTR                            
                    ( DIST_ACCOUNT_NO,                                  
                      CODE_UTIL_TYPE,                                   
                      DIST_COMPANY_NO,                                  
                      METER_NO,                                         
                      DIST_METER_NO,                                    
MTCH                  STATUS_CD )                                       
                VALUES                                                  
                    ( :TM-DIST-ACCOUNT-NO,                              
                      :TM-CODE-UTIL-TYPE,                               
                      :TM-DIST-COMPANY-NO,                              
                      :TM-METER-NO,                                     
                      :TM-DIST-METER-NO,                                
MTCH                  :TM-STATUS-CD )                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7100'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON INSERT INTO CSS-DIST-XREF-MTR. (S376)'      
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'INSERT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-DIST-XREF-MTR'         TO TABLE-1                
             MOVE 'METER-NO'                  TO TABLE-ELEMENT-1        
             MOVE TM-METER-NO                 TO HOSTVAR-ELEMENT-1      
             MOVE 'DIST-METER-NO'             TO TABLE-ELEMENT-2        
             MOVE TM-DIST-METER-NO            TO HOSTVAR-ELEMENT-2      
             MOVE 'DIST-ACCOUNT-NO'           TO TABLE-ELEMENT-3        
             MOVE TM-DIST-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
MTCH         MOVE 'STATUS-CD'                 TO TABLE-ELEMENT-4        
MTCH         MOVE TM-STATUS-CD                TO HOSTVAR-ELEMENT-4      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7200-INSERT-EQUIPMENT                                          *        
      ******************************************************************        
                                                                        
       7200-INSERT-EQUIPMENT.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_EQUIPMENT                                
                    ( CODE_UTIL_TYPE,                                   
                      DEVICE_NO,                                        
                      EQUIP_TYPE_CD,                                    
                      PALETTE_NO,                                       
                      SERIAL_NO,                                        
                      DATE_PURCHASED,                                   
                      DATE_DISPOSED_OF,                                 
                      WARRANTY_EXP_DT,                                  
                      INSTALL_EMP_ID,                                   
                      INSTALL_DT,                                       
                      CODE_CRNT_LOC,                                    
                      CRNT_LOC_NO,                                      
                      DATE_LAST_TRAN,                                   
                      DATE_LAST_MOVE,                                   
                      LOCAL_OFFICE,                                     
                      MFR_DT,                                           
                      CODE_MAKE,                                        
                      DATE_OBSOLETE,                                    
                      UPGRADES_TX,                                      
                      HAZARD_MATERIAL_CD,                               
                      COMPANY_NO )                                      
                 VALUES                                                 
                    ( :EQ-CODE-UTIL-TYPE,                               
                      :EQ-DEVICE-NO,                                    
                      :EQ-EQUIP-TYPE-CD,                                
                      :EQ-PALETTE-NO,                                   
                      :EQ-SERIAL-NO,                                    
                      IIF(TRY_CONVERT(DATE, :EQ-DATE-PURCHASED 
                                            :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-PURCHASED 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-PURCHASED :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-PURCHASED :WS-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-PURCHASED :WS-NULL-IND) ),             
                      IIF(TRY_CONVERT(DATE, :EQ-DATE-DISPOSED-OF 
                                            :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-DISPOSED-OF 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-DISPOSED-OF :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-DISPOSED-OF :WS-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-DISPOSED-OF :WS-NULL-IND) ),           
                      IIF(TRY_CONVERT(DATE, :EQ-WARRANTY-EXP-DT 
                                            :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-WARRANTY-EXP-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:EQ-WARRANTY-EXP-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-WARRANTY-EXP-DT :WS-NULL-IND
              ), CONVERT(DATE, :EQ-WARRANTY-EXP-DT :WS-NULL-IND) ),            
                      :EQ-INSTALL-EMP-ID,                               
                      IIF(TRY_CONVERT(DATE, :EQ-INSTALL-DT :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-INSTALL-DT :WS-NULL-IND
              ) <> 0) OR (LEN(:EQ-INSTALL-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-INSTALL-DT :WS-NULL-IND
              ), CONVERT(DATE, :EQ-INSTALL-DT :WS-NULL-IND) ),                 
                      :EQ-CODE-CRNT-LOC,                                
                      :EQ-CRNT-LOC-NO,                                  
                      CAST(SYSDATETIMEOFFSET() AS DATE),                        
                      CAST(SYSDATETIMEOFFSET() AS DATE),                        
                      :EQ-LOCAL-OFFICE,                                 
                      IIF(TRY_CONVERT(DATE, :EQ-MFR-DT :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-MFR-DT :WS-NULL-IND
              ) <> 0) OR (LEN(:EQ-MFR-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-MFR-DT :WS-NULL-IND
              ), CONVERT(DATE, :EQ-MFR-DT :WS-NULL-IND) ),                     
                      :EQ-CODE-MAKE,                                    
                      IIF(TRY_CONVERT(DATE, :EQ-DATE-OBSOLETE 
                                            :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :EQ-DATE-OBSOLETE 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:EQ-DATE-OBSOLETE :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:EQ-DATE-OBSOLETE :WS-NULL-IND
              ), CONVERT(DATE, :EQ-DATE-OBSOLETE :WS-NULL-IND) ),              
                      :EQ-UPGRADES-TX,                                  
                      :EQ-HAZARD-MATERIAL-CD,                           
                      :EQ-COMPANY-NO )                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_EQUIPMENT                                        
MFA-TR*             ( CODE_UTIL_TYPE,                                           
MFA-TR*               DEVICE_NO,                                                
MFA-TR*               EQUIP_TYPE_CD,                                            
MFA-TR*               PALETTE_NO,                                               
MFA-TR*               SERIAL_NO,                                                
MFA-TR*               DATE_PURCHASED,                                           
MFA-TR*               DATE_DISPOSED_OF,                                         
MFA-TR*               WARRANTY_EXP_DT,                                          
MFA-TR*               INSTALL_EMP_ID,                                           
MFA-TR*               INSTALL_DT,                                               
MFA-TR*               CODE_CRNT_LOC,                                            
MFA-TR*               CRNT_LOC_NO,                                              
MFA-TR*               DATE_LAST_TRAN,                                           
MFA-TR*               DATE_LAST_MOVE,                                           
MFA-TR*               LOCAL_OFFICE,                                             
MFA-TR*               MFR_DT,                                                   
MFA-TR*               CODE_MAKE,                                                
MFA-TR*               DATE_OBSOLETE,                                            
MFA-TR*               UPGRADES_TX,                                              
MFA-TR*               HAZARD_MATERIAL_CD,                                       
MFA-TR*               COMPANY_NO )                                              
MFA-TR*          VALUES                                                         
MFA-TR*             ( :EQ-CODE-UTIL-TYPE,                                       
MFA-TR*               :EQ-DEVICE-NO,                                            
MFA-TR*               :EQ-EQUIP-TYPE-CD,                                        
MFA-TR*               :EQ-PALETTE-NO,                                           
MFA-TR*               :EQ-SERIAL-NO,                                            
MFA-TR*               :EQ-DATE-PURCHASED:WS-NULL-IND,                           
MFA-TR*               :EQ-DATE-DISPOSED-OF:WS-NULL-IND,                         
MFA-TR*               :EQ-WARRANTY-EXP-DT:WS-NULL-IND,                          
MFA-TR*               :EQ-INSTALL-EMP-ID,                                       
MFA-TR*               :EQ-INSTALL-DT:WS-NULL-IND,                               
MFA-TR*               :EQ-CODE-CRNT-LOC,                                        
MFA-TR*               :EQ-CRNT-LOC-NO,                                          
MFA-TR*               CURRENT DATE,                                             
MFA-TR*               CURRENT DATE,                                             
MFA-TR*               :EQ-LOCAL-OFFICE,                                         
MFA-TR*               :EQ-MFR-DT:WS-NULL-IND,                                   
MFA-TR*               :EQ-CODE-MAKE,                                            
MFA-TR*               :EQ-DATE-OBSOLETE:WS-NULL-IND,                            
MFA-TR*               :EQ-UPGRADES-TX,                                          
MFA-TR*               :EQ-HAZARD-MATERIAL-CD,                                   
MFA-TR*               :EQ-COMPANY-NO )                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7200'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON INSERT INTO CSS-EQUIPMENT. (S376)'          
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'INSERT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-EQUIPMENT'             TO TABLE-1                
             MOVE 'DEVICE-NO'                 TO TABLE-ELEMENT-1        
             MOVE EQ-DEVICE-NO                TO HOSTVAR-ELEMENT-1      
             MOVE 'DIST-METER-NO'             TO TABLE-ELEMENT-2        
             MOVE TM-DIST-METER-NO            TO HOSTVAR-ELEMENT-2      
             MOVE 'LOCAL-OFFICE'              TO TABLE-ELEMENT-3        
             MOVE EQ-LOCAL-OFFICE             TO HOSTVAR-ELEMENT-3      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-INSERT-GAS-METER.                                         *        
      ******************************************************************        
                                                                        
       7300-INSERT-GAS-METER.                                           
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_GAS_METER                                
                 ( CODE_UTIL_TYPE,                                      
                   METER_NO,                                            
                   CODE_METER_TYPE,                                     
                   CODE_CASE_TYPE,                                      
                   CASE_PRESSURE,                                       
                   CCF_CAP_PER_HR,                                      
                   MCF_CAP_PER_HR,                                      
                   CODE_ATTACHMENTS,                                    
                   DATE_LAST_TESTED,                                    
                   METER_SIZE_ID,                                       
                   CODE_CO_SIZE,                                        
                   ALLOW_CONSTANT_FL,                                   
                   DEVICE_TYPE_CD,                                      
                   CODE_TIME_PERIOD,                                    
                   CODE_CAP_CFF,                                        
                   CODE_CAP_UCG,                                        
                   CODE_CAP_GAL,                                        
                   MODEL_CD,                                            
                   CONNECTION_TYPE_CD,                                  
                   TEST_SCHED_CD,                                       
                   DIGTL_MTR_TYPE,                                      
C26373             PROGRAM_ID,                                          
                   NUMBER_OF_DRIVE,                                     
                   LAST_TEST_SEL_DT,                                    
                   LAST_TEST_SEL_CD,                                    
T22243             COMPANY_NO )                                         
                 VALUES                                                 
                 ( :GM-CODE-UTIL-TYPE,                                  
                   :GM-METER-NO,                                        
                   :GM-CODE-METER-TYPE,                                 
                   :GM-CODE-CASE-TYPE,                                  
                   :GM-CASE-PRESSURE,                                   
                   :GM-CCF-CAP-PER-HR,                                  
                   :GM-MCF-CAP-PER-HR,                                  
                   :GM-CODE-ATTACHMENTS,                                
                   IIF(TRY_CONVERT(DATE, :GM-DATE-LAST-TESTED 
                                         :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :GM-DATE-LAST-TESTED 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:GM-DATE-LAST-TESTED :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:GM-DATE-LAST-TESTED :WS-NULL-IND
              ), CONVERT(DATE, :GM-DATE-LAST-TESTED :WS-NULL-IND) ),           
                   :GM-METER-SIZE-ID,                                   
                   :GM-CODE-CO-SIZE,                                    
                   :GM-ALLOW-CONSTANT-FL,                               
                   :GM-DEVICE-TYPE-CD,                                  
                   :GM-CODE-TIME-PERIOD,                                
                   :GM-CODE-CAP-CFF,                                    
                   :GM-CODE-CAP-UCG,                                    
                   :GM-CODE-CAP-GAL,                                    
                   :GM-MODEL-CD,                                        
                   :GM-CONNECTION-TYPE-CD,                              
                   :GM-TEST-SCHED-CD,                                   
                   :GM-DIGTL-MTR-TYPE,                                  
C26373             :GM-PROGRAM-ID,                                      
                   :GM-NUMBER-OF-DRIVE,                                 
                   IIF(TRY_CONVERT(DATE, :GM-LAST-TEST-SEL-DT 
                                         :WS-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :GM-LAST-TEST-SEL-DT 
                                                           :WS-NULL-IND
              ) <> 0) OR (LEN(:GM-LAST-TEST-SEL-DT :WS-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:GM-LAST-TEST-SEL-DT :WS-NULL-IND
              ), CONVERT(DATE, :GM-LAST-TEST-SEL-DT :WS-NULL-IND) ),           
                   :GM-LAST-TEST-SEL-CD,                                
T22243             :GM-COMPANY-NO )                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_GAS_METER                                        
MFA-TR*          ( CODE_UTIL_TYPE,                                              
MFA-TR*            METER_NO,                                                    
MFA-TR*            CODE_METER_TYPE,                                             
MFA-TR*            CODE_CASE_TYPE,                                              
MFA-TR*            CASE_PRESSURE,                                               
MFA-TR*            CCF_CAP_PER_HR,                                              
MFA-TR*            MCF_CAP_PER_HR,                                              
MFA-TR*            CODE_ATTACHMENTS,                                            
MFA-TR*            DATE_LAST_TESTED,                                            
MFA-TR*            METER_SIZE_ID,                                               
MFA-TR*            CODE_CO_SIZE,                                                
MFA-TR*            ALLOW_CONSTANT_FL,                                           
MFA-TR*            DEVICE_TYPE_CD,                                              
MFA-TR*            CODE_TIME_PERIOD,                                            
MFA-TR*            CODE_CAP_CFF,                                                
MFA-TR*            CODE_CAP_UCG,                                                
MFA-TR*            CODE_CAP_GAL,                                                
MFA-TR*            MODEL_CD,                                                    
MFA-TR*            CONNECTION_TYPE_CD,                                          
MFA-TR*            TEST_SCHED_CD,                                               
MFA-TR*            DIGTL_MTR_TYPE,                                              
MFA-TR*            PROGRAM_ID,                                                  
MFA-TR*            NUMBER_OF_DRIVE,                                             
MFA-TR*            LAST_TEST_SEL_DT,                                            
MFA-TR*            LAST_TEST_SEL_CD,                                            
MFA-TR*            COMPANY_NO )                                                 
MFA-TR*          VALUES                                                         
MFA-TR*          ( :GM-CODE-UTIL-TYPE,                                          
MFA-TR*            :GM-METER-NO,                                                
MFA-TR*            :GM-CODE-METER-TYPE,                                         
MFA-TR*            :GM-CODE-CASE-TYPE,                                          
MFA-TR*            :GM-CASE-PRESSURE,                                           
MFA-TR*            :GM-CCF-CAP-PER-HR,                                          
MFA-TR*            :GM-MCF-CAP-PER-HR,                                          
MFA-TR*            :GM-CODE-ATTACHMENTS,                                        
MFA-TR*            :GM-DATE-LAST-TESTED:WS-NULL-IND,                            
MFA-TR*            :GM-METER-SIZE-ID,                                           
MFA-TR*            :GM-CODE-CO-SIZE,                                            
MFA-TR*            :GM-ALLOW-CONSTANT-FL,                                       
MFA-TR*            :GM-DEVICE-TYPE-CD,                                          
MFA-TR*            :GM-CODE-TIME-PERIOD,                                        
MFA-TR*            :GM-CODE-CAP-CFF,                                            
MFA-TR*            :GM-CODE-CAP-UCG,                                            
MFA-TR*            :GM-CODE-CAP-GAL,                                            
MFA-TR*            :GM-MODEL-CD,                                                
MFA-TR*            :GM-CONNECTION-TYPE-CD,                                      
MFA-TR*            :GM-TEST-SCHED-CD,                                           
MFA-TR*            :GM-DIGTL-MTR-TYPE,                                          
MFA-TR*            :GM-PROGRAM-ID,                                              
MFA-TR*            :GM-NUMBER-OF-DRIVE,                                         
MFA-TR*            :GM-LAST-TEST-SEL-DT:WS-NULL-IND,                            
MFA-TR*            :GM-LAST-TEST-SEL-CD,                                        
MFA-TR*            :GM-COMPANY-NO )                                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7300'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON INSERT INTO CSS-GAS-METER. (S376)'          
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'INSERT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-GAS-METER'             TO TABLE-1                
             MOVE 'METER-NO'                  TO TABLE-ELEMENT-1        
             MOVE GM-METER-NO                 TO HOSTVAR-ELEMENT-1      
             MOVE 'DIST-METER-NO'             TO TABLE-ELEMENT-2        
             MOVE TM-DIST-METER-NO            TO HOSTVAR-ELEMENT-2      
             MOVE 'DIST-ACCOUNT-NO'           TO TABLE-ELEMENT-3        
             MOVE TM-DIST-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
T22243       MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-4        
T22243       MOVE GM-COMPANY-NO               TO HOSTVAR-ELEMENT-4      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7350-GET-GAS-METER-SIZE                                        *        
      ******************************************************************        
                                                                        
       7350-GET-GAS-METER-SIZE.                                         
                                                                        
           EXEC SQL                                                     
              SELECT CODE_METER_TYPE,                                   
                    CCF_CAP_PER_HR,                                     
                    CODE_CO_SIZE,                                       
                    ALLOW_CONSTANT_FL,                                  
                    MODEL_CD,                                           
                    CONNECTION_TYPE_CD,                                 
                    TEST_SCHED_CD                                       
               INTO :M5-CODE-METER-TYPE,                                
                    :M5-CCF-CAP-PER-HR,                                 
                    :M5-CODE-CO-SIZE,                                   
                    :M5-ALLOW-CONSTANT-FL,                              
                    :M5-MODEL-CD,                                       
                    :M5-CONNECTION-TYPE-CD,                             
                    :M5-TEST-SCHED-CD                                   
                FROM CSS_GAS_METER_SIZE                                 
               WHERE METER_SIZE_ID = :M5-METER-SIZE-ID                  
C23811           AND COMPANY_NO    = :M5-COMPANY-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7350'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON SELECT FROM CSS-GAS-METER-SIZE. (S376)'     
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-GAS-METER-SIZE'        TO TABLE-1                
             MOVE 'METER-SIZE-ID'             TO TABLE-ELEMENT-1        
             MOVE M5-METER-SIZE-ID            TO HOSTVAR-ELEMENT-1      
C23811       MOVE 'COMPANY-NO'                TO TABLE-ELEMENT-2        
C23811       MOVE M5-COMPANY-NO               TO HOSTVAR-ELEMENT-2      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7400-INSERT-MTR-CAP.                                           *        
      ******************************************************************        
                                                                        
       7400-INSERT-MTR-CAP.                                             
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_MTR_CAP                                  
                 ( CODE_UTIL_TYPE,                                      
                   METER_NO,                                            
                   REG_ID_NO,                                           
                   CODE_CAP_TYPE,                                       
                   CONSTANT,                                            
                   NO_READ_DIALS,                                       
                   NO_DIALS,                                            
                   K_Q_LEAD_LAG_IND,                                    
                   DEMAND_TYPE,                                         
                   FULL_SCALE,                                          
                   CODE_HIGH_LOW_DIAL,                                  
                   REG_MEASURES_CD,                                     
T22243             COMPANY_NO )                                         
                VALUES                                                  
                 ( :MC-CODE-UTIL-TYPE,                                  
                   :MC-METER-NO,                                        
                   :MC-REG-ID-NO,                                       
                   :MC-CODE-CAP-TYPE,                                   
                   :MC-CONSTANT,                                        
                   :MC-NO-READ-DIALS,                                   
                   :MC-NO-DIALS,                                        
                   :MC-K-Q-LEAD-LAG-IND,                                
                   :MC-DEMAND-TYPE,                                     
                   :MC-FULL-SCALE,                                      
                   :MC-CODE-HIGH-LOW-DIAL,                              
                   :MC-REG-MEASURES-CD,                                 
T22243             :MC-COMPANY-NO )                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7400'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON INSERT INTO CSS-MTR-CAP. (S376)'            
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'INSERT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-MTR-CAP'               TO TABLE-1                
             MOVE 'METER-NO'                  TO TABLE-ELEMENT-1        
             MOVE MC-METER-NO                 TO HOSTVAR-ELEMENT-1      
             MOVE 'DIST-METER-NO'             TO TABLE-ELEMENT-2        
             MOVE TM-DIST-METER-NO            TO HOSTVAR-ELEMENT-2      
             MOVE 'DIST-ACCOUNT-NO'           TO TABLE-ELEMENT-3        
             MOVE TM-DIST-ACCOUNT-NO          TO HOSTVAR-ELEMENT-3      
T22243       MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-4        
T22243       MOVE MC-COMPANY-NO               TO HOSTVAR-ELEMENT-4      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7450-SELECT-MTR-CAP.                                           *        
      ******************************************************************        
                                                                        
       7450-SELECT-MTR-CAP.                                             
                                                                        
           EXEC SQL                                                     
               SELECT CONSTANT,                                         
                      NO_DIALS                                          
                 INTO :MC-CONSTANT,                                     
                      :MC-NO-DIALS                                      
                 FROM CSS_MTR_CAP                                       
T22243          WHERE COMPANY_NO     = :MC-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :TM-CODE-UTIL-TYPE               
                  AND METER_NO       = :TM-METER-NO                     
                  AND REG_ID_NO      = 1                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7450'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON SELECT FROM CSS-MTR-CAP. (S376)'            
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-MTR-CAP'               TO TABLE-1                
             MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-1        
             MOVE TM-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-1      
             MOVE 'METER_NO'                  TO TABLE-ELEMENT-2        
             MOVE TM-METER-NO                 TO HOSTVAR-ELEMENT-2      
             MOVE 'REG_ID_NO'                 TO TABLE-ELEMENT-3        
             MOVE '1'                         TO HOSTVAR-ELEMENT-3      
T22243       MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-4        
T22243       MOVE MC-COMPANY-NO               TO HOSTVAR-ELEMENT-4      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7450-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7475-UPDATE-MTR-CAP.                                           *        
      ******************************************************************        
                                                                        
       7475-UPDATE-MTR-CAP.                                             
                                                                        
           EXEC SQL                                                     
               UPDATE CSS_MTR_CAP                                       
                  SET NO_DIALS      = :MC-NO-DIALS     ,                
                      NO_READ_DIALS = :MC-NO-READ-DIALS,                
                      CONSTANT      = :MC-CONSTANT                      
T22243          WHERE COMPANY_NO     = :MC-COMPANY-NO                   
                  AND CODE_UTIL_TYPE = :TM-CODE-UTIL-TYPE               
                  AND METER_NO       = :TM-METER-NO                     
                  AND REG_ID_NO      = 1                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7475'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON UPDATE TO CSS_MTR_CAP. (S376)'              
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'UPDATE'                    TO ABEND-FUNCTION         
             MOVE 'CSS_MTR_CAP'               TO TABLE-1                
             MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-1        
             MOVE TM-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-1      
             MOVE 'METER_NO'                  TO TABLE-ELEMENT-2        
             MOVE TM-METER-NO                 TO HOSTVAR-ELEMENT-2      
             MOVE 'REG_ID_NO'                 TO TABLE-ELEMENT-3        
             MOVE '1'                         TO HOSTVAR-ELEMENT-3      
T22243       MOVE 'COMPANY_NO'                TO TABLE-ELEMENT-4        
T22243       MOVE  MC-COMPANY-NO              TO HOSTVAR-ELEMENT-4      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7475-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7500-UPDATE-PREMISE.                                           *        
      ******************************************************************        
                                                                        
       7500-UPDATE-PREMISE.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_PREMISE                                        
                 SET REV_DISTRICT_CD = :PR-REV-DISTRICT-CD              
               WHERE PREMISE_NO = :PR-PREMISE-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7500'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON UPDATE OF CSS-PREMISE. (S376)'              
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'UPDATE'                    TO ABEND-FUNCTION         
             MOVE 'CSS-PREMISE'               TO TABLE-1                
             MOVE 'PREMISE-NO'                TO TABLE-ELEMENT-1        
             MOVE PR-PREMISE-NO               TO HOSTVAR-ELEMENT-1      
             MOVE 'LOCAL-OFFICE'              TO TABLE-ELEMENT-2        
             MOVE PR-LOCAL-OFFICE             TO HOSTVAR-ELEMENT-2      
             MOVE 'REV-DISTRICT-CD'           TO TABLE-ELEMENT-3        
             MOVE PR-REV-DISTRICT-CD          TO HOSTVAR-ELEMENT-3      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
T21290* IT IS NOT NECESSARY TO UPDATE THIS ACCT INFO HERE              *        
      * CALL HAS BEEN COMMENTED OUT IN 2200-                           *        
      * 7600-UPDATE-ACCOUNT.                                           *        
      ******************************************************************        
                                                                        
       7600-UPDATE-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                SET LOCAL_OFFICE = :AT-LOCAL-OFFICE                     
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7600'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON UPDATE OF CSS-ACCOUNT. (S376)'              
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'UPDATE'                    TO ABEND-FUNCTION         
             MOVE 'CSS-ACCOUNT'               TO TABLE-1                
             MOVE 'ACCOUNT-NO'                TO TABLE-ELEMENT-1        
             MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1      
             MOVE 'AT-LOCAL-OFFICE'           TO TABLE-ELEMENT-2        
             MOVE AT-LOCAL-OFFICE             TO HOSTVAR-ELEMENT-2      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7650-SELECT-ACCOUNT.                                           *        
      ******************************************************************        
                                                                        
       7650-SELECT-ACCOUNT.                                             
                                                                        
           EXEC SQL                                                     
              SELECT PREMISE_NO                                         
                INTO :AT-PREMISE-NO                                     
               FROM CSS_ACCOUNT                                         
               WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7650'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON SELECT FROM CSS-ACCOUNT. (S376)'            
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'SELECT'                    TO ABEND-FUNCTION         
             MOVE 'CSS-ACCOUNT'               TO TABLE-1                
             MOVE 'ACCOUNT-NO'                TO TABLE-ELEMENT-1        
             MOVE AT-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7650-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7700-UPDATE-MKT-ACCT-XREF                                      *        
      ******************************************************************        
                                                                        
       7700-UPDATE-MKT-ACCT-XREF.                                       
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_MKT_XREF_ACCT                                  
                SET MKT_POOL_GRP = :XM-MKT-POOL-GRP,                    
                    DIST_ACCT_NO = :XM-DIST-ACCT-NO                     
               WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                        
                 AND COMPANY_NO = :XM-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7700'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON UPDATE OF CSS-MKT-ACCT-XREF. (S376)'        
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'UPDATE'                    TO ABEND-FUNCTION         
             MOVE 'CSS-MKT-ACCT-XREF'         TO TABLE-1                
             MOVE 'ACCOUNT-NO'                TO TABLE-ELEMENT-1        
             MOVE XM-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1      
             MOVE 'XM-MKT-POOL-GRP'           TO TABLE-ELEMENT-2        
             MOVE XM-MKT-POOL-GRP             TO HOSTVAR-ELEMENT-2      
             MOVE 'XM-DIST-ACCT-NO'           TO TABLE-ELEMENT-3        
             MOVE XM-DIST-ACCT-NO             TO HOSTVAR-ELEMENT-3      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7700-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7750-XM-SELECT                                                 *        
      ******************************************************************        
                                                                        
       7750-XM-SELECT.                                                  
                                                                        
           EXEC SQL                                                     
              SELECT DIST_ACCT_NO                                       
                INTO :XM-DIST-ACCT-NO                                   
                FROM CSS_MKT_XREF_ACCT                                  
               WHERE ACCOUNT_NO = :XM-ACCOUNT-NO                        
                 AND COMPANY_NO = :XM-COMPANY-NO                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7750'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON SELECT FROM CSS-MKT-ACCT-XREF. (S376)'      
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'UPDATE'                    TO ABEND-FUNCTION         
             MOVE 'CSS-MKT-ACCT-XREF'         TO TABLE-1                
             MOVE 'ACCOUNT-NO'                TO TABLE-ELEMENT-1        
             MOVE XM-ACCOUNT-NO               TO HOSTVAR-ELEMENT-1      
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7750-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7800-OPEN-TM-CURSOR                                            *        
      ******************************************************************        
                                                                        
       7800-OPEN-TM-CURSOR.                                             
                                                                        
           EXEC SQL                                                     
              OPEN TM-CURSOR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7800'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON OPEN OF TM-CURSOR. (S376)'                  
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'OPEN CURSOR'               TO ABEND-FUNCTION         
             MOVE 'TM-CURSOR'                 TO TABLE-1                
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7800-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7850-FETCH-TM-CURSOR                                           *        
      ******************************************************************        
                                                                        
       7850-FETCH-TM-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              FETCH TM-CURSOR                                           
               INTO :TM-CODE-UTIL-TYPE,                                 
                    :TM-DIST-METER-NO,                                  
                    :TM-METER-NO,                                       
MTCH                :TM-STATUS-CD                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND AND CTR-ROWS      
               GREATER THAN 0 THEN                                      
                 NEXT SENTENCE                                          
             ELSE                                                       
               MOVE '7850'                    TO ACTIVE-PARAGRAPH       
               MOVE 'ERROR ON FETCH OF TM-CURSOR. (S376)'               
                                              TO RS-MESSAGE-TX          
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE 'FETCH CURSOR'            TO ABEND-FUNCTION         
               MOVE 'TM-CURSOR'               TO TABLE-1                
               MOVE 'ACCOUNT-NO'              TO TABLE-ELEMENT-1        
               MOVE TM-DIST-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
                                                                        
               PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT 
               PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT 
             END-IF                                                     
           END-IF.                                                      
                                                                        
       7850-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7900-CLOSE-TM-CURSOR                                           *        
      ******************************************************************        
                                                                        
       7900-CLOSE-TM-CURSOR.                                            
                                                                        
           EXEC SQL                                                     
              CLOSE TM-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL THEN          
               NEXT SENTENCE                                            
           ELSE                                                         
             MOVE '7850'                      TO ACTIVE-PARAGRAPH       
             MOVE 'ERROR ON CLOSE OF TM-CURSOR. (S376)'                 
                                              TO RS-MESSAGE-TX          
             MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
             MOVE 'CLOSE CURSOR'              TO ABEND-FUNCTION         
             MOVE 'TM-CURSOR'                 TO TABLE-1                
                                                                        
             PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
             PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
           END-IF.                                                      
                                                                        
       7900-EXIT.                                                       
           EXIT.                                                        
                                                                        
MTCH  ******************************************************************        
MTCH  * 7950-DELETE-METER-XREF                                         *        
MTCH  ******************************************************************        
MTCH                                                                    
MTCH   7950-DELETE-METER-XREF.                                          
MTCH       EXEC SQL                                                     
MTCH          DELETE FROM CSS_DIST_XREF_MTR                             
MTCH           WHERE DIST_ACCOUNT_NO = :TM-DIST-ACCOUNT-NO              
MTCH             AND DIST_METER_NO   = :TM-DIST-METER-NO                
MTCH             AND CODE_UTIL_TYPE  = :TM-CODE-UTIL-TYPE               
MTCH             AND STATUS_CD       = :TM-STATUS-CD                    
MTCH       END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MTCH                                                                    
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
MTCH                                                                    
MTCH       IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
MTCH           NEXT SENTENCE                                            
MTCH       ELSE                                                         
MTCH         MOVE '7950'                      TO ACTIVE-PARAGRAPH       
MTCH         MOVE 'ERROR ON DELETE FROM CSS-DIST-XREF-MTR. (S376)'      
MTCH                                          TO RS-MESSAGE-TX          
MTCH         MOVE PROGRAM-NAME                TO ABEND-PROGRAM          
MTCH         MOVE 'DELETE'                    TO ABEND-FUNCTION         
MTCH         MOVE 'CSS-DIST-XREF-MTR'         TO TABLE-1                
MTCH         MOVE 'DIST_ACCOUNT_NO'           TO TABLE-ELEMENT-1        
MTCH         MOVE TM-DIST-ACCOUNT-NO          TO HOSTVAR-ELEMENT-1      
MTCH         MOVE 'DIST_METER_NO'             TO TABLE-ELEMENT-2        
MTCH         MOVE TM-DIST-METER-NO            TO HOSTVAR-ELEMENT-2      
MTCH         MOVE 'CODE_UTIL_TYPE'            TO TABLE-ELEMENT-3        
MTCH         MOVE TM-CODE-UTIL-TYPE           TO HOSTVAR-ELEMENT-3      
MTCH         MOVE 'STATUS_CD'                 TO TABLE-ELEMENT-4        
MTCH         MOVE TM-STATUS-CD                TO HOSTVAR-ELEMENT-4      
MTCH                                                                    
MTCH         PERFORM 9000-SEND-ERROR-RESULT              THRU 9000-EXIT 
MTCH         PERFORM 9900-SQL-ERROR-ROUTINE              THRU 9900-EXIT 
MTCH       END-IF.                                                      
MTCH                                                                    
MTCH   7950-EXIT.                                                       
MTCH       EXIT.                                                        
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *      END PROGRAM COPYLIB                                       *        
      ******************************************************************        
CVT999*COPY CPD00302.                                                           
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
