       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02373.                                         
COB303 DATE-WRITTEN.  NOV 11 1995.                                      
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S373                                           *        
      *  PROGRAM:       S373                                           *        
      *  CALLING SP:    PA_S373                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE UPDATES CSS_AR_TRANS_HIST AND WRITES INTO      *        
      *  MAINTENANCE TRANSACTION HISTORY                               *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  11/11/98    CBSI     PROCEDURE ORIGINALLY CODED.              *        
CBSI  *  01/05/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
REARCH*  12/08/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02373'.
MSQ017     COPY MFASQLM.
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBPGMDSC                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBARHIST                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
REARCH*    COPY SYGWCOB.                                                        
REARCH*    COPY SYDBCOB.                                                        
           COPY CCA00001.                                                       
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
REARCH*                                                                         
           COPY CWS00027.                                                       
           COPY CWS00303.                                                       
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME              PIC X(8)  VALUE 'CSR02373'.    
           05  ALL-DONE-SW               PIC X(1) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
           05  SEND-DONE-SW             PIC X(1) VALUE 'Y'.             
               88  SEND-DONE-ERROR       VALUE 'N'.                     
               88  SEND-DONE-OK          VALUE 'Y'.                     
           05  WS-ROW-COUNT             PIC S9(09) COMP.                
COB305     05 WS-ACCOUNT-NO        PIC S9(13)V COMP-3 VALUE 0.             
           05  WS-USER-ID               PIC X(7)   VALUE SPACES.        
           05  WS-APPL-PROG1            PIC X(09)  VALUE 'PANEL156A'.   
           05  WS-APPL-PROG2            PIC X(09)  VALUE 'PANEL156B'.   
           05  WS-COMMENTS-TEXT         PIC X(210).                     
           05  WS-TRAN-COMMENT-LEN      PIC 9(04) COMP.                 
           05  WS-INDEX1                PIC 9(04) COMP.                 
           05  WS-SPACE                 PIC X(01) VALUE SPACE.          
           05  WS-DATE                  PIC X(10).                      
           05  WS-TIME                  PIC X(08).                      
           05  WS-DATE-TIME-CODE.                                       
               10  WS-DATE-2            PIC X(10).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  WS-TIME-2            PIC X(08).                      
               10  FILLER               PIC X(01) VALUE SPACES.         
               10  WS-CODE-TRAN-ABBR    PIC X(03) VALUE SPACES.         
                                                                        
REARCH*01  GW-LIB-MISC-FIELDS.                                                  
REARCH*    05  GWL-PROC                 POINTER.                                
REARCH*    05  GWL-INIT-HANDLE          POINTER.                                
REARCH*    05  GWL-RC                   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-NR            PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-DONE          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COUNT         PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-COMM          PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-RETURN-CODE   PIC S9(9) COMP.                         
REARCH*    05  GWL-STATUS-SUBCODE       PIC S9(9) COMP.                         
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                       'SESSION.CSR02373_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
REARCH 01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                  PIC S9(9) COMP.                          
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.                  
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13).                               
REARCH*    05  PARM-ACCOUNT-NO-NUM     REDEFINES PARM-ACCOUNT-NO                
REARCH*                                PIC 9(13).                               
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
REARCH     05  PARM-ACCOUNT-NO-NUM     REDEFINES PARM-ACCOUNT-NO-TEMP   
REARCH                                 PIC 9(13).                       
REARCH*    05  PARM-TRANS-HIST-SEQ-NO  PIC X(26).                               
REARCH*    05  PARM-RECORD-ONLY-FLAG   PIC X(01).                               
REARCH*    05  PARM-USER-ID            PIC X(7).                                
REARCH*    05  PARM-COMMENTS-LEN       PIC S9(4) COMP.                          
REARCH*    05  PARM-COMMENTS-TEXT      PIC X(210).                              
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE            PIC S9(9) COMP VALUE 0.         
REARCH*                                                                         
REARCH*01  CN-COLUMN-NAMES.                                                     
REARCH*    05  CN-RETURN-CODE           PIC X(11) VALUE 'RETURN_CODE'.          
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
HPCCDM*EJECT                                                                    
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO         PIC X(13).                           
REARCH 01  PARM-TRANS-HIST-SEQ-NO  PIC X(26).                           
REARCH 01  PARM-RECORD-ONLY-FLAG   PIC X(01).                           
REARCH 01  PARM-USER-ID            PIC X(7).                            
REARCH 01  PARM-COMMENTS-LEN       PIC S9(4) COMP.                      
REARCH 01  PARM-COMMENTS-TEXT      PIC X(210).                          
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                          PARM-TRANS-HIST-SEQ-NO                  
REARCH                          PARM-RECORD-ONLY-FLAG                   
REARCH                          PARM-USER-ID                            
REARCH                          PARM-COMMENTS-LEN                       
REARCH                          PARM-COMMENTS-TEXT.                     
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CALLS 0100-INITIALIZE                                      *        
      *           1000-PROCESS-INPUT                                   *        
      *           2000-PROCESS-OUTPUT                                  *        
      *           9999-END-PROGRAM                                     *        
      *                                                                *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE                      THRU 0100-EXIT. 
           PERFORM 1000-PROCESS-INPUT                   THRU 1000-EXIT. 
           PERFORM 2000-PROCESS-OUTPUT                  THRU 2000-EXIT. 
           PERFORM 9999-END-PROGRAM                     THRU 9999-EXIT. 
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *     CALLS 9000-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.             
REARCH*                                                                         
REARCH*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,             
REARCH*                          SNA-CONNECTION-NAME, SNA-SUBC.                 
REARCH*                                                                         
REARCH*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                              
REARCH*                                                                         
REARCH*    IF GWL-RC NOT = TDS-PARM-PRESENT                                     
REARCH*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                             
REARCH*       MOVE '0100'       TO ACTIVE-PARAGRAPH                             
REARCH*       MOVE 'TDRESULT - NO RPC PARM SENT' TO ABEND-FUNCTION              
REARCH*       MOVE 'CICS TRANSACTION'   TO TABLE-1                              
REARCH*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE                
REARCH*       PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT          
REARCH*       PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT          
REARCH*    END-IF.                                                              
REARCH*                                                                         
REARCH*    INITIALIZE TDS-RETURN-FIELDS.                                        
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               :S-RETURN-CODE         AS RETURN_CODE              
REARCH          FROM                                                    
REARCH               CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                 02610000
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RECEIVE PARMS.                                          *        
      ******************************************************************        
                                                                        
REARCH 1000-PROCESS-INPUT.                                              
REARCH*                                                                         
REARCH*    MOVE 1                                TO PARM-ID1.                   
REARCH*    MOVE LENGTH OF PARM-ACCOUNT-NO        TO MAX-LENGTH-PARM.            
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-ACCOUNT-NO,                               
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH     MOVE PARM-ACCOUNT-NO                TO PARM-ACCOUNT-NO-TEMP  
           MOVE PARM-ACCOUNT-NO-NUM            TO WS-ACCOUNT-NO.        
REARCH*                                                                         
REARCH*    ADD  1                                TO PARM-ID1.                   
REARCH*    MOVE LENGTH OF PARM-TRANS-HIST-SEQ-NO TO MAX-LENGTH-PARM.            
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-TRANS-HIST-SEQ-NO,                        
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*                                                                         
REARCH*    ADD  1                                TO PARM-ID1.                   
REARCH*    MOVE LENGTH OF PARM-RECORD-ONLY-FLAG  TO MAX-LENGTH-PARM.            
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-RECORD-ONLY-FLAG,                         
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                                TO PARM-ID1.                   
REARCH*    MOVE LENGTH OF PARM-USER-ID           TO MAX-LENGTH-PARM.            
REARCH*                                                                         
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          PARM-ID1,                                      
REARCH*                          PARM-USER-ID,                                  
REARCH*                          TDSCHAR,                                       
REARCH*                          MAX-LENGTH-PARM,                               
REARCH*                          PARM-L.                                        
REARCH*                                                                         
REARCH*    ADD  1                               TO PARM-ID1.            08230000
REARCH*    MOVE LENGTH OF PARM-COMMENTS-LEN     TO MAX-LENGTH-PARM.     08240000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08250000
REARCH*                          GWL-RC,                                08260000
REARCH*                          PARM-ID1,                              08270000
REARCH*                          PARM-COMMENTS-LEN,                     08280000
REARCH*                          TDSINT2,                               08290000
REARCH*                          MAX-LENGTH-PARM,                       08300000
REARCH*                          PARM-L.                                08310000
REARCH*                                                                         
REARCH*    ADD  1                           TO PARM-ID1.                08330000
REARCH*    MOVE LENGTH OF PARM-COMMENTS-TEXT TO MAX-LENGTH-PARM.        08340000
REARCH*    CALL 'TDRCVPRM' USING GWL-PROC,                              08350000
REARCH*                          GWL-RC,                                08360000
REARCH*                          PARM-ID1,                              08370000
REARCH*                          PARM-COMMENTS-TEXT,                    08380000
REARCH*                          TDSCHAR,                               08390000
REARCH*                          MAX-LENGTH-PARM,                       08400000
REARCH*                          PARM-L.                                08410000
REARCH*                                                                 08420000
REARCH*                                                                         
REARCH 1000-EXIT.                                                       
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      *     CALLS 2100-DESCRIBE-RESULT                                 *        
      *           5000-UPDATE                                          *        
      *           8100-SEND-RESULT                                     *        
      *                                                                *        
      *      CALLED FROM 0000-MAINLINE                                 *        
      *                                                                *        
      *     1. DESCRIBE RESULT SET                                     *        
      *     2. UPDATE DB2 DATA                                         *        
      *     3. SEND RESULT SET                                         *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
REARCH*    PERFORM 2100-DESCRIBE-RESULT                 THRU 2100-EXIT.         
           PERFORM 5000-UPDATE                        THRU 5000-EXIT.   
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
REARCH     ADD +1                                     TO   CTR-ROWS.    
REARCH*    PERFORM 8100-SEND-RESULT                     THRU 8100-EXIT.         
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH***************************************************************** 05040000
REARCH*2000A-MOVE-RESULT                                              * 05040000
REARCH***************************************************************** 05040000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE         TO S-RETURN-CODE.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 2100-DESCRIBE-RESULT                                           *        
      *     CALLS 9100-CHECK-ERROR                                     *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *                                                                *        
      *     DESCRIBE EACH COLUMN IN THE RESULT SET. HERE IT IS THE     *        
      *     RETURN CODE AND ????                                       *        
      ******************************************************************        
REARCH*                                                                         
REARCH*2100-DESCRIBE-RESULT.                                                    
REARCH*                                                                         
REARCH*    MOVE 1       TO CTR-COLUMN.                                          
REARCH*    MOVE TDSINT4 TO DB-HOST-TYPE.                                        
REARCH*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                                      
REARCH*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                            
REARCH*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                            
REARCH*                                                                         
REARCH*    CALL 'TDESCRIB' USING GWL-PROC,                                      
REARCH*                          GWL-RC,                                        
REARCH*                          CTR-COLUMN,                                    
REARCH*                          DB-HOST-TYPE,                                  
REARCH*                          WRKLEN1,                                       
REARCH*                          RS-RETURN-CODE,                                
REARCH*                          DB-NULL-INDICATOR,                             
REARCH*                          TDS-FALSE,                                     
REARCH*                          DB-CLIENT-TYPE,                                
REARCH*                          WRKLEN1,                                       
REARCH*                          CN-RETURN-CODE,                                
REARCH*                          WRKLEN2.                                       
REARCH*                                                                         
REARCH*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT.         
REARCH*                                                                         
REARCH*2100-EXIT.                                                               
REARCH*    EXIT.                                                                
                                                                        
      ******************************************************************        
      * 5000-UPDATE                                                    *        
      *     CALLS 5100-WRITE-MAINT-TRANS                               *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *        
      *     UPDATE AR_TRANS_HIST FOR THE RECORD_ONLY_FLAG              *        
      *     MAINTENANCE TRANSACTION ALSO TO BE WRITTEN                 *        
      ******************************************************************        
                                                                        
       5000-UPDATE.                                                     
           MOVE  PARM-TRANS-HIST-SEQ-NO        TO  AR-TRANS-HIST-SEQ-NO 
           MOVE  WS-ACCOUNT-NO                 TO  AR-ACCOUNT-NO        
           PERFORM 7200-SELECT-AR-TRANS-HIST   THRU 7200-EXIT.          
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               IF PARM-RECORD-ONLY-FLAG = 'Y'                           
                  MOVE 'N'                 TO  AR-RECORD-ONLY-FL        
               ELSE                                                     
                  MOVE 'Y'                 TO  AR-RECORD-ONLY-FL        
               END-IF                                                   
               PERFORM 7300-UPDATE-FRO-FLAG    THRU 7300-EXIT           
           END-IF.                                                      
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               PERFORM 5100-WRITE-MAINT-TRANS THRU 5100-EXIT            
           END-IF.                                                      
       5000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      *   5100-WRITE-MAINT-TRANS                                       *        
      *        MOVE FIELDS TO THE MAINTENANCE TRANSACTION HEADER.      *        
      *        THIS ROW WILL ALSO BE WRITTEN.                          *        
      ******************************************************************        
       5100-WRITE-MAINT-TRANS.                                          
                                                                        
           PERFORM 7000-SELECT-TIMESTAMP                THRU 7000-EXIT. 
           PERFORM 7100-SELECT-RESP-AREA                THRU 7100-EXIT. 
           PERFORM 5150-BUILD-COMMENTS-TEXT             THRU 5150-EXIT. 
                                                                        
           MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE AR-ACCOUNT-NO            TO MH-ACCOUNT-NO.              
           MOVE ZERO                     TO MH-CUSTOMER-NO.             
           MOVE ZERO                     TO MH-PREMISE-NO.              
           MOVE PARM-USER-ID             TO MH-USER-ID.                 
           IF  AR-RECORD-ONLY-FL = 'Y'                                  
               MOVE WS-APPL-PROG1        TO MH-APPL-PROGRAM-ID          
           ELSE                                                         
               MOVE WS-APPL-PROG2        TO MH-APPL-PROGRAM-ID          
           END-IF                                                       
           MOVE 210                      TO MH-TRAN-COMMENT-LEN.        
***********MOVE PARM-COMMENTS-TEXT       TO MH-TRAN-COMMENT-TEXT.               
           PERFORM 7350-INSERT-MAINT-TRANS-HIST                         
                                         THRU 7350-EXIT.                
       5100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *   5150-BUILD-COMMENTS-TEXT.                                    *        
      *                                                                *        
      *       FORM COMMENTS FOR MAINTENANCE TRANSACTION HISTORY.       *        
      ******************************************************************        
       5150-BUILD-COMMENTS-TEXT.                                        
           PERFORM 5200-GET-TRAN-CODE-ABBR     THRU 5200-EXIT.          
           MOVE AR-APPL-PROGRAM-ID    TO K9-APPL-PROGRAM-ID             
           PERFORM 7400-SELECT-APPL-PGM-DESC THRU 7400-EXIT             
***********MOVE 210                            TO  WS-INDEX1.                   
***********PERFORM UNTIL WS-INDEX1 < 1 OR                                       
************             AR-TRAN-COMMENT(WS-INDEX1 : 1) IS NOT = SPACES         
************   SUBTRACT 1 FROM WS-INDEX1                                        
***********END-PERFORM                                                          
           MOVE  WS-INDEX1  TO  WS-TRAN-COMMENT-LEN.                    
           STRING  WS-DATE-TIME-CODE,                                   
                   WS-SPACE,                                            
                   K9-APPL-PROGRAM-DESC,                                
                   WS-SPACE,                                            
                   PARM-COMMENTS-TEXT DELIMITED BY SIZE                 
           INTO    WS-COMMENTS-TEXT.                                    
           MOVE WS-COMMENTS-TEXT               TO MH-TRAN-COMMENT-TEXT. 
       5150-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   5200-GET-TRAN-CODE-ABBR .                                    *        
      *                                                                *        
      *       GET TRAN CODE ABBR FOR POPULATING THE COMMENT            *        
      ******************************************************************        
       5200-GET-TRAN-CODE-ABBR.                                         
           EVALUATE AR-CODE-TRAN-TYPE                                   
               WHEN 'A'                                                 
                    MOVE 'ADJ'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'B'                                                 
                    MOVE 'BIL'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'C'                                                 
                    MOVE 'COR'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'P'                                                 
                    MOVE 'PMT'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'S'                                                 
                    MOVE 'CHG'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'T'                                                 
                    MOVE 'XFR'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'D'                                                 
                    MOVE 'ARG'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'E'                                                 
                    MOVE 'CNT'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'F'                                                 
                    MOVE 'MNT'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'H'                                                 
                    MOVE 'NOT'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'R'                                                 
                    MOVE 'REF'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'W'                                                 
                    MOVE 'W/O'   TO  WS-CODE-TRAN-ABBR                  
               WHEN 'I'                                                 
                    MOVE 'CRT'   TO  WS-CODE-TRAN-ABBR                  
               WHEN OTHER                                               
                    MOVE SPACES  TO  WS-CODE-TRAN-ABBR                  
           END-EVALUATE.                                                
       5200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      *   6010-REDUCE-EMBEDDED-SPACES.                                 *        
      ******************************************************************        
      ******************************************************************        
      *   7000-SELECT-TIMESTAMP.                                       *        
      *                                                                *        
      *       GET CURRENT DATE AND TIMESTAMP.                          *        
      ******************************************************************        
       7000-SELECT-TIMESTAMP.                                           
                                                                        
           EXEC SQL                                                     
                SELECT CIS.CHAR2$DATE(CAST(SYSDATETIMEOFFSET() 
           AS DATE), 'USA'),                         
                       CIS.CHAR2$TIME(CIS.CURRENT$TIME(), 'USA'),               
                       REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                       CAST(SYSDATETIMEOFFSET() AS DATE)                        
                INTO :WS-DATE,                                          
                     :WS-TIME,                                          
                     :MH-TRANS-HIST-SEQ-NO,                             
                     :MH-DATE-TRANS                                     
                FROM CSS_MODEL_SQL                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ029
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CHAR(CURRENT DATE, USA),                                 
MFA-TR*                CHAR(CURRENT TIME, USA),                                 
MFA-TR*                CURRENT TIMESTAMP,                                       
MFA-TR*                CURRENT DATE                                             
MFA-TR*         INTO :WS-DATE,                                                  
MFA-TR*              :WS-TIME,                                                  
MFA-TR*              :MH-TRANS-HIST-SEQ-NO,                                     
MFA-TR*              :MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7000'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT  
              PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      *   7100-SELECT-RESP-AREA.                                       *        
      *                                                                *        
      *       GET RESPONSIBLE AREA FOR THE USER.                       *        
      ******************************************************************        
                                                                        
       7100-SELECT-RESP-AREA.                                           
                                                                        
           EXEC SQL                                                     
              SELECT RESP_AREA_ID                                       
                INTO :MH-RESP-AREA-ID                                   
                FROM CSS_USER_PROFILE                                   
               WHERE USER_ID = :PARM-USER-ID                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_USER_PROFILE'    TO TABLE-1                     
              MOVE 'USER_ID'             TO TABLE-ELEMENT-1             
              MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
              MOVE PARM-USER-ID          TO HOSTVAR-ELEMENT-1           
              MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT            THRU 9000-EXIT  
              PERFORM 9900-SQL-ERROR-ROUTINE            THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *****************************************************************         
      * 7200-SELECT-AR-TRANS_HIST                                     *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *     SELECTS AR_TRANS_HIST                                     *         
      *****************************************************************         
       7200-SELECT-AR-TRANS-HIST.                                       
                                                                        
           EXEC SQL                                                     
                SELECT CODE_TRAN_TYPE,                                  
                       TRAN_COMMENT,                                    
                       APPL_PROGRAM_ID,                                 
                       CIS.CHAR2$DATE(CAST(TRANS_HIST_SEQ_NO
            AS DATE),'USA'),               
                       CIS.CHAR2$TIME(DATEADD(NANOSECOND,
            -DATEPART(NANOSECOND, CAST(TRANS_HIST_SEQ_NO AS TIME)), 
           CAST(TRANS_HIST_SEQ_NO AS TIME)),'USA'),               
                       RECORD_ONLY_FL                                   
                INTO  :AR-CODE-TRAN-TYPE,                               
                      :AR-TRAN-COMMENT,                                 
                      :AR-APPL-PROGRAM-ID,                              
                      :WS-DATE-2,                                       
                      :WS-TIME-2,                                       
                      :AR-RECORD-ONLY-FL                                
                FROM   CSS_AR_TRANS_HIST                                
                WHERE  ACCOUNT_NO        = :AR-ACCOUNT-NO               
                AND    TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT CODE_TRAN_TYPE,                                          
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                CHAR(DATE(TRANS_HIST_SEQ_NO),USA),                       
MFA-TR*                CHAR(TIME(TRANS_HIST_SEQ_NO),USA),                       
MFA-TR*                RECORD_ONLY_FL                                           
MFA-TR*         INTO  :AR-CODE-TRAN-TYPE,                                       
MFA-TR*               :AR-TRAN-COMMENT,                                         
MFA-TR*               :AR-APPL-PROGRAM-ID,                                      
MFA-TR*               :WS-DATE-2,                                               
MFA-TR*               :WS-TIME-2,                                               
MFA-TR*               :AR-RECORD-ONLY-FL                                        
MFA-TR*         FROM   CSS_AR_TRANS_HIST                                        
MFA-TR*         WHERE  ACCOUNT_NO        = :AR-ACCOUNT-NO                       
MFA-TR*         AND    TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7200'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-2            
               MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE AR-TRANS-HIST-SEQ-NO                                
                                          TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
HPCCDM*    EJECT                                                                
      *****************************************************************         
      * 7300-UPDATE-FRO-FLAG                                          *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5000-UPDATE                                   *         
      *                                                               *         
      *****************************************************************         
        7300-UPDATE-FRO-FLAG.                                           
            EXEC SQL                                                    
                UPDATE CSS_AR_TRANS_HIST                                
                    SET RECORD_ONLY_FL  = :AR-RECORD-ONLY-FL            
                WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                
                AND   TRANS_HIST_SEQ_NO = CIS.CHAR2TIMESTAMP(
                                                  :AR-TRANS-HIST-SEQ-NO
              )         
            END-EXEC                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*     EXEC SQL                                                            
MFA-TR*         UPDATE CSS_AR_TRANS_HIST                                        
MFA-TR*             SET RECORD_ONLY_FL  = :AR-RECORD-ONLY-FL                    
MFA-TR*         WHERE ACCOUNT_NO        = :AR-ACCOUNT-NO                        
MFA-TR*         AND   TRANS_HIST_SEQ_NO = :AR-TRANS-HIST-SEQ-NO                 
MFA-TR*     END-EXEC                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CBSI        MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.    
            IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                 
               NEXT SENTENCE                                            
            ELSE                                                        
                MOVE PROGRAM-NAME          TO ABEND-PROGRAM             
                MOVE '7300'                TO ACTIVE-PARAGRAPH          
                MOVE 'UPDATE'              TO ABEND-FUNCTION            
                MOVE SPACES                TO ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
                MOVE 'CSS_AR_TRANS_HIST'   TO TABLE-1                   
                MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1           
                MOVE 'TRANS_HIST_SEQ_NO'   TO TABLE-ELEMENT-2           
                MOVE 'RECORD_ONLY_FL'      TO TABLE-ELEMENT-3           
                MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1         
                MOVE AR-TRANS-HIST-SEQ-NO                               
                                           TO HOSTVAR-ELEMENT-2         
                MOVE AR-RECORD-ONLY-FL     TO HOSTVAR-ELEMENT-3         
                PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT     
                PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT     
           END-IF.                                                      
        7300-EXIT.                                                      
            EXIT.                                                       
      *****************************************************************         
      * 7300-INSERT-MAINT-TRANS-HIST                                  *         
      *     CALLS 9000-SEND-ERROR-RESULT                              *         
      *           9900-SQL-ERROR-ROUTINE                              *         
      *                                                               *         
      *     CALLED FROM 5100-WRITE-MAINT-TRANS-HIST                   *         
      *                                                               *         
      *****************************************************************         
       7350-INSERT-MAINT-TRANS-HIST.                                    
                                                                        
           EXEC SQL                                                     
              INSERT INTO CSS_MNT_TRANS_HIST                            
                  ( TRANS_HIST_SEQ_NO,                                  
                    DATE_TRANS,                                         
                    CODE_TRAN_TYPE,                                     
                    RESP_AREA_ID,                                       
                    ACCOUNT_NO,                                         
                    CUSTOMER_NO,                                        
                    PREMISE_NO,                                         
                    USER_ID,                                            
                    APPL_PROGRAM_ID,                                    
                    TRAN_COMMENT )                                      
              VALUES                                                    
                  ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),                  
                    IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
                    :MH-CODE-TRAN-TYPE,                                 
                    :MH-RESP-AREA-ID,                                   
                    :MH-ACCOUNT-NO,                                     
                    :MH-CUSTOMER-NO,                                    
                    :MH-PREMISE-NO,                                     
                    :MH-USER-ID,                                        
                    :MH-APPL-PROGRAM-ID,                                
                    :MH-TRAN-COMMENT )                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       INSERT INTO CSS_MNT_TRANS_HIST                                    
MFA-TR*           ( TRANS_HIST_SEQ_NO,                                          
MFA-TR*             DATE_TRANS,                                                 
MFA-TR*             CODE_TRAN_TYPE,                                             
MFA-TR*             RESP_AREA_ID,                                               
MFA-TR*             ACCOUNT_NO,                                                 
MFA-TR*             CUSTOMER_NO,                                                
MFA-TR*             PREMISE_NO,                                                 
MFA-TR*             USER_ID,                                                    
MFA-TR*             APPL_PROGRAM_ID,                                            
MFA-TR*             TRAN_COMMENT )                                              
MFA-TR*       VALUES                                                            
MFA-TR*           ( :MH-TRANS-HIST-SEQ-NO,                                      
MFA-TR*             :MH-DATE-TRANS,                                             
MFA-TR*             :MH-CODE-TRAN-TYPE,                                         
MFA-TR*             :MH-RESP-AREA-ID,                                           
MFA-TR*             :MH-ACCOUNT-NO,                                             
MFA-TR*             :MH-CUSTOMER-NO,                                            
MFA-TR*             :MH-PREMISE-NO,                                             
MFA-TR*             :MH-USER-ID,                                                
MFA-TR*             :MH-APPL-PROGRAM-ID,                                        
MFA-TR*             :MH-TRAN-COMMENT )                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
               MOVE '7350'                     TO ACTIVE-PARAGRAPH      
               MOVE 'INSERT'                   TO ABEND-FUNCTION        
               MOVE SPACES                     TO ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
               MOVE 'CSS_MNT_TRANS_HIST'        TO TABLE-1              
               MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
               MOVE 'TRANS_HIST_SEQ_NO'        TO TABLE-ELEMENT-2       
CBSI           MOVE 'CUSTOMER_NO'              TO TABLE-ELEMENT-3       
CBSI           MOVE 'PREMISE_NO'               TO TABLE-ELEMENT-4       
               MOVE MH-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
               MOVE MH-TRANS-HIST-SEQ-NO       TO HOSTVAR-ELEMENT-2     
CBSI           MOVE MH-CUSTOMER-NO             TO HOSTVAR-ELEMENT-3     
CBSI           MOVE MH-PREMISE-NO              TO HOSTVAR-ELEMENT-4     
                                                                        
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ****************************************************************          
      **    7400-SELECT-APPL-PGM-DESC                               **          
      ** THIS PROCEDURE WILL SEARCH THE DATABASE TABLE              **          
      ** CSS_APPL_PGM_DESC TO GET PROGRAM DESCRIPTION.              **          
      ****************************************************************          
                                                                        
       7400-SELECT-APPL-PGM-DESC.                                       
                                                                        
                                                                        
           EXEC SQL                                                     
           SELECT APPL_PROGRAM_DESC                                     
             INTO :K9-APPL-PROGRAM-DESC                                 
             FROM CSS_APPL_PGM_DESC                                     
            WHERE APPL_PROGRAM_ID    = :K9-APPL-PROGRAM-ID              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
           IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME          TO ABEND-PROGRAM              
               MOVE '7400'                TO ACTIVE-PARAGRAPH           
               MOVE 'SELECT'              TO ABEND-FUNCTION             
               MOVE SPACES                TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
               MOVE 'CSS_APPL_PGM_DESC'   TO TABLE-1                    
               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1            
               MOVE 'APPL_PROGRAM_ID'     TO TABLE-ELEMENT-2            
               MOVE AR-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1          
               MOVE K9-APPL-PROGRAM-ID                                  
                                          TO HOSTVAR-ELEMENT-2          
               PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT      
               PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT      
           END-IF.                                                      
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
REARCH*    EXEC SQL                                                             
REARCH*       INCLUDE CPD00300                                                  
REARCH*    END-EXEC.                                                            
REARCH*                                                                         
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CPDSP300                                                
REARCH     END-EXEC.                                                            
REARCH*                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH*    COPY CPD00302.                                                       
REARCH     EXEC SQL                                                     16360000
REARCH          INCLUDE CPD00321                                        16360000
REARCH     END-EXEC.                                                    16360000
