       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02371.                                         
COB303 DATE-WRITTEN.  SEPT   1, 1998                                    
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S371 CONVERTED TO DB2 SP CSR02371 ON 11/20/2006        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      *****************************************************************         
      *                                                               *         
      *                SOUTH CAROLINA ELECTRIC & GAS                  *         
      *                                                               *         
      *  PROGRAM:  S371                                               *         
      *                                                               *         
      *****************************************************************         
      *                 PROGRAM SUMMARY                               *         
      *                                                               *         
      * THIS PROGRAM IS CALLED BY RPC S371. IT IS USED TO UPDATE      *         
      * SO DNP DATA.                                                  *         
      *                                                               *         
      *****************************************************************         
      *                     PROGRAM MODIFICATION LOG                  *         
      *                                                               *         
      *    DATE    INITIALS   COMMENTS                                *         
      *  --------  --------   -------------------------------------   *         
      *  09/01/98    AMG      PROCEDURE ORIGINALLY CODED.             *         
      *  11/19/98    MDJ      ADDED INCLUDE TBCSTALT FOR CUST_ALERT FOR         
      *                       CPD00068 CHANGES.                       *         
CBSI  *  12/30/98    KP       MC05 ABEND LOG CORRECTIONS              *         
T20165*  06/22/99    SHF      RETRIEVED AT-LOCAL-OFFICE FOR CPD00068. *         
T21150*  11/11/99    CSTRECH  CHANGED COMMIT TO SYNCPOINT.            *         
T19557*  03/01/00    CBSI     COPYBOOK CDP00068 CHANGED TO SUB PROGRAM*         
T19557*              MADRAS   SCSCO068.                               *         
T22359*  06/21/00    MDJ      MADE CHANGES TO KEEP IDENTITY OF PROGRAM *        
      *                       CALLING SCSCO068 OR SCSCB068.  THERE IS  *        
      *                       SPECIFIC LOGIC IN CPD00068 FOR CERTAIN   *        
      *                       PROGRAMS WHICH WAS NOT BEING EXECUTED    *        
      *                       PROPERLY BECAUSE THE PROGRAM NAME WAS    *        
      *                       ALWAYS SCSCO068 OR SCSCB068.             *        
C25610*  11/27/01    LEF      ADDED CODE-ACCT-STAT TO CSS_ACCOUNT      *        
C25610*                       RETRIEVE FOR CPD00068 - STA DNP CALC     *        
      *  04/10/03    DD       ADDED BANKRUPTCY_IND TO SELECT-ACCOUNT   *        
C28693*  05/16/03    LHO      INITIALIZE CWS00068-FIELDS.              *        
C28788*  07/07/03    MDJ      GET IVR-EXEMPT-CD FOR CPD00068.          *        
REARCH*  11/20/06    PA94870  REARCH CONVERSION FROM SYBASE TO DB2     *        
A01016** 01/29/09    RC41079  ADDED CODE TO GET ARREARS CODE FROM FIRST*        
A01016**                      CHARACTER OF ARREARS_HIST.               *        
A02036** 11/23/10    db41297  stop -502 sqlcodes                       *        
A02036**             by replacing-9000-SEND-ERROR-RESULT and           *        
A02036**             9900-SQL-ERROR-ROUTINE with routine               *        
A02036**             9700-PROCESS-ABEND                                *        
ACT106** 05/20/15    RS7M249  Delete unused copybook(s)                *        
      *****************************************************************         
      *                                                               *         
      *                ---- BASIC SEQUENCE STRUCTURE ----             *         
      *                                                               *         
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION            *         
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                   *         
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                  *         
      *  3000 - 4999  NOT USED                                        *         
      *  5000 - 5999  COMMON PROGRAM MODULES                          *         
      *  6000 - 6999  COMMON SYSTEM MODULES                           *         
      *  7000 - 7999  INPUT MODULES                                   *         
      *  8000 - 8999  OUTPUT MODULES                                  *         
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES            *         
      *                                                               *         
      *****************************************************************         
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ001     EXEC SQL
MSQ001      INCLUDE SQLDA
MSQ001     END-EXEC
MSQ001 01 MSQ001-SQLCABACK PIC X(136).
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02371'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                    PIC X(40)                        
           VALUE 'WORKING STORAGE FOR S371 STARTS HERE'.                
                                                                        
      * WORK AREAS                                                    *         
      *****************************************************************         
                                                                        
       01  PROGRAM-NAME                 PIC X(08) VALUE 'S371'.         
       01  MCSCB068                     PIC X(08) VALUE 'MCSCB068'.     
                                                                        
       01  CS-LIB-MISC-FIELDS.                                          
           05  WS-CSL-CMD-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CON-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-CTX-HANDLE       PIC S9(9) COMP VALUE +0.         
           05  WS-CSL-RC               PIC S9(9) COMP.                  
           05  WS-CSL-RESTYPE          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-ITEM-NUM             PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-COPIED-NULL          PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR            PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-INDICATOR-NULL       PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-NUMROWS              PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-RC               PIC S9(9) COMP SYNC VALUE +0.    
           05  WS-RPC-SUCCESS          PIC S9(9) COMP SYNC VALUE +0.    
                                                                        
       01  CS-PROPERTY-FIELDS.                                          
           05  WS-UPDATE-RPC         PIC X(23)                          
                VALUE 'csrddat.dbo.pd_D0000428'.                        
           05  WS-RPC-LEN              PIC S9(9) COMP VALUE +23.        
           05  WS-OUTLEN               PIC S9(9) COMP VALUE +0.         
           05  WS-STRLEN               PIC S9(9) COMP VALUE +0.         
           05  WS-MSGLIMIT             PIC S9(9) COMP VALUE +5.         
                                                                        
       01  WS-DATAFMT.                                                  
           05 WS-NM-PARM               PIC X(132).                      
           05 WS-NMLEM-PARM            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-PARM            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-PARM        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-PARM            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-PARM        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-PARM         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-PARM         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-PARM           PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-DATAFMT-BIND.                                             
           05 WS-NM-BIND               PIC X(132).                      
           05 WS-NMLEM-BIND            PIC S9(9) COMP SYNC.             
           05 WS-DATATYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-FORMT-BIND            PIC S9(9) COMP SYNC.             
           05 WS-MAXLENGTH-BIND        PIC S9(9) COMP SYNC.             
           05 WS-SCALE-BIND            PIC S9(9) COMP SYNC.             
           05 WS-PRECISION-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FNTSTATUS-BIND        PIC S9(9) COMP SYNC.             
           05 WS-FMTCOUNT-BIND         PIC S9(9) COMP SYNC.             
           05 WS-USERTYPE-BIND         PIC S9(9) COMP SYNC.             
           05 WS-LOCALE-BIND           PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-SERVER-MSG.                                               
           05 WS-SM-MSGNO              PIC S9(9) COMP SYNC.             
           05 WS-SM-STATE              PIC S9(9) COMP SYNC.             
           05 WS-SM-SEVERITY           PIC S9(9) COMP SYNC.             
           05 WS-SM-TEXT               PIC X(256).                      
           05 WS-SM-TEXT-LEN           PIC S9(9) COMP SYNC.             
           05 WS-SM-SVRNAME            PIC X(256).                      
           05 WS-SM-SVRNAME-LEN        PIC S9(9) COMP SYNC.             
           05 WS-SM-PROC               PIC X(256).                      
           05 WS-SM-PROC-LEN           PIC S9(9) COMP SYNC.             
           05 WS-SM-LINE               PIC S9(9) COMP SYNC.             
           05 WS-SM-STATUS             PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-CLIENT-MSG.                                               
           05 WS-CM-SEVERITY           PIC S9(9) COMP SYNC.             
           05 WS-CM-OC-MSGNO           PIC S9(9) COMP SYNC.             
           05 WS-CM-OC-MSGTEXT         PIC X(256).                      
           05 WS-SM-OC-MSGTEXT-LEN     PIC S9(9) COMP SYNC.             
           05 WS-CM-OS-MSGNO           PIC S9(9) COMP SYNC.             
           05 WS-CM-OS-MSGTEXT         PIC X(256).                      
           05 WS-CM-OS-MSGTEXT-LEN     PIC S9(9) COMP SYNC.             
           05 WS-CM-STATUS             PIC S9(9) COMP SYNC.             
                                                                        
       01  WS-MSGNO                    PIC S9(9) COMP VALUE +1.         
       01  WS-DATALEN                  PIC S9(9) COMP SYNC VALUE +0.    
       01  WS-INDIC                    PIC S9(9) COMP SYNC VALUE +0.    
       01  WS-RETURN-STATUS PIC S9(4) COMP VALUE +0.                    
       01  WS-VARS-FOR-FETCH.                                           
           10  WS-ACCOUNT-NO               PIC X(13).                   
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
       01  GTT-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE           PIC S9(9) COMP VALUE 0.         
                                                                        
REARCH                                                                  
REARCH*01  LOC1            USAGE IS SQL TYPE IS                         
REARCH*                    RESULT-SET-LOCATOR VARYING.                  
       01  WS-WORK-AREA.                                                
           05  WS-USER-ID                  PIC X(07) VALUE SPACES.      
           05  WS-PASSWORD             PIC X(15) VALUE SPACES.          
           05  WS-SERVER               PIC X(17) VALUE SPACES.          
           05  ALL-DONE-SW                 PIC X(01) VALUE 'N'.         
               88 NOT-ALL-DONE                       VALUE 'N'.         
               88 ALL-DONE                           VALUE 'Y'.         
           05  SEND-DONE-SW                PIC X(01) VALUE 'Y'.         
               88 SEND-DONE-ERROR                    VALUE 'N'.         
               88 SEND-DONE-OK                       VALUE 'Y'.         
           05  SW-RESULTS                  PIC X(01) VALUE 'Y'.         
               88 NO-MORE-RESULTS                    VALUE 'N'.         
               88 MORE-RESULTS                       VALUE 'Y'.         
           05  SW-FETCH                    PIC X(01) VALUE 'Y'.         
               88 NO-MORE-ROWS                       VALUE 'N'.         
               88 MORE-ROWS                          VALUE 'Y'.         
           05  WS-ZERO                     PIC S9(09) COMP VALUE ZERO.  
           05  WS-U                        PIC X(01)  VALUE 'U'.        
           05  WS-YES                      PIC X(01)  VALUE 'Y'.        
           05  WS-A                        PIC X(01)  VALUE 'A'.        
           05  WS-B                        PIC X(01)  VALUE 'B'.        
           05  WS-DATE-85-DAYS-AGO         PIC X(10).                   
           05  WS-DATE-55-DAYS-AGO         PIC X(10).                   
           05  WS-DATE-25-DAYS-AGO         PIC X(10).                   
           05  WS-NULL-INDICATOR           PIC S9(04) COMP VALUE ZEROES.
           05  WS-NULL-INDICATOR2          PIC S9(04) COMP VALUE ZEROES.
           05  WS-NULL-INDICATOR3          PIC S9(04) COMP VALUE ZEROES.
           05  WS-NULL-INDICATOR4          PIC S9(04) COMP VALUE ZEROES.
           05  WS-NULL-DT-IND1             PIC S9(04) COMP VALUE ZEROES.
           05  WS-NULL-DT-IND2             PIC S9(04) COMP VALUE ZEROES.
           05  WS-NULL-DT-IND3             PIC S9(04) COMP VALUE ZEROES.
           05  WS-NULL-DT-IND4             PIC S9(04) COMP VALUE ZEROES.
           05  WS-AMT-00                PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-30                PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-60                PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-90                PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-BOND              PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-IRR-LTR           PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-GUARANTEED        PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-DEP-ON-HAND       PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-SEC-BAL           PIC S9(09)V99 COMP-3 VALUE +0.  
           05  WS-AMT-SEC-BAL-N         PIC 9(09).99.                   
           05  WS-AMT-SEC-BAL-C         PIC X(12)     VALUE SPACES.     
           05  WS-AMT-DNP-BAL-N         PIC 9(09).99.                   
           05  WS-AMT-DNP-BAL-C         PIC X(12)     VALUE SPACES.     
           05  WS-CODE-ARREARS          PIC X(1)      VALUE SPACES.     
           05  WS-TABLE-ID              PIC X(20)     VALUE SPACES.     
T19557     05  WS-EIBRESP               PIC S9(8)                       
T19557                                      COMP SYNC VALUE ZERO.       
REARCH     05  WS-RETURN-CD             PIC S9(04) COMP.                
A01016     05  WS-ARREARS-HIST          PIC X(24)    VALUE SPACES.      
                                                                        
       01  WS-END                       PIC X(40)                       
           VALUE 'WORKING STORAGE FOR S371 ENDS HERE  '.                
                                                                        
      *****************************************************************         
      * DB2 INCLUDES                                                  *         
      *****************************************************************         
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_ACCOUNT       >                                     
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
      *                                                                         
C28788     EXEC SQL                                                             
C28788        INCLUDE TBUTLENV                                                  
C28788     END-EXEC.                                                            
      *                                                                         
      *-------< INCLUDE CSS_SURETY_BOND   >                                     
           EXEC SQL                                                             
              INCLUDE TBSTYBND                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_GUARANTOR     >                                     
           EXEC SQL                                                             
              INCLUDE TBGTNTR                                                   
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_CREDIT_PROFILE>                                     
           EXEC SQL                                                             
              INCLUDE TBCRPROF                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_DEP_ON_HAND   >                                     
           EXEC SQL                                                             
              INCLUDE TBDEPHND                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CSS_SO_DNP_CANCEL    >                                  
           EXEC SQL                                                             
              INCLUDE TBSODNPC                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CWS00068     >                                          
           EXEC SQL                                                             
              INCLUDE CWS00068                                                  
           END-EXEC.                                                            
                                                                        
      *-------< INCLUDE CWS00056           >                                    
           EXEC SQL                                                             
              INCLUDE CWS00056                                                  
           END-EXEC.                                                            
                                                                        
                                                                        
      *****************************************************************         
      * COBOL WORKING STORAGE COPY BOOKS                              *         
      *****************************************************************         
      * ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS                          
           COPY CWS00027.                                                       
      * SUPPORTS DB2 AND SQL ERROR CHECKING                                     
           COPY CWS00303.                                                       
T19557* LINKAGE SECTION VARIABLES FOR SCSCO068                                  
T19557     COPY CWS0068L.                                               01680000
                                                                        
      ******************************************************************        
      **   DB2 CURSOR DECLARATIONS                                    **        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
             DECLARE  ACCT-CSR CURSOR WITH HOLD FOR                     
              SELECT  ACCOUNT_NO                                        
                FROM  CSS_SO_DNP_CANCEL                                 
               WHERE  SO_UPDT_ACTION_FL = :WS-U                         
           END-EXEC.                                                    
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
CVT000     10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.
MSQ001        EXEC SQL
MSQ001          DECLARE C2 CURSOR
MSQ001          FOR CALL CSR00428                                       
REARCH                 ( :WS-ACCOUNT-NO
                  , :WS-AMT-DNP-BAL-C
                  , :WS-AMT-SEC-BAL-C
                  , :AT-DATE-BILL-DAY-00
                  , :AT-CREDIT-GROUP
                  , :WS-CODE-ARREARS
                  )
MSQ001        END-EXEC.
        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000 LINKAGE SECTION.                                                 
                                                                        
CVT000 PROCEDURE DIVISION.                                              
                                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                                      
      ******************************************************************        
      **                                                              **        
      **    0000-MAINLINE                                             **        
      **                                                              **        
      **    CONTROLS THE MAIN PATH OF THE PROGRAM                     **        
      **                                                              **        
      ******************************************************************        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INIT-SERVER    THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INIT-SERVER                                               *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
                                                                        
       0100-INIT-SERVER.                                                
                                                                        
           MOVE '0100'   TO ACTIVE-PARAGRAPH.                           
                                                                        
CVT000     EXEC SQL                                                     
CVT000       DECLARE C1 CURSOR  FOR                          
CVT000       SELECT                                                     
CVT000        :RS-RETURN-CODE              AS    RETURN_CODE            
CVT000          FROM CIS.SYSDUMMY1                                   
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE C1 CURSOR WITH RETURN FOR                                  
MFA-TR*      SELECT                                                             
MFA-TR*       :RS-RETURN-CODE              AS    RETURN_CODE                    
MFA-TR*         FROM SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0200-INIT-CLIENT                                               *        
      *     CALLS 9998-SEND-ERROR-RESULT                               *        
      *           9900-SQL-ERROR-ROUTINE                               *        
      *                                                                *        
      *     CALLED FROM 0000-MAINLINE                                  *        
      *                                                                *        
      ******************************************************************        
                                                                        
       0200-INIT-CLIENT.                                                
                                                                        
           MOVE '0200'   TO ACTIVE-PARAGRAPH.                           
                                                                        
           MOVE ZEROES TO WS-DATAFMT-BIND.                              
           MOVE LOW-VALUES TO WS-DATAFMT.                               
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      **                                                              **        
      **    1000-PROCESS-INPUT                                        **        
      **                                                              **        
      ******************************************************************        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 1200-LOAD-WORK-AREAS THRU 1200-EXIT.                 
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    1200-LOAD-WORK-AREAS                                      **        
      **                                                              **        
      ******************************************************************        
       1200-LOAD-WORK-AREAS.                                            
                                                                        
           MOVE '1200' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE LOW-VALUES TO WS-DATAFMT WS-DATAFMT-BIND.               
                                                                        
       1200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    2000-PROCESS-OUTPUT                                       **        
      **                                                              **        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000' TO ACTIVE-PARAGRAPH.                             
           PERFORM 0200-INIT-CLIENT     THRU 0200-EXIT.                 
           PERFORM 5000-PROCESS-ACCTS   THRU 5000-EXIT.                 
           PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3100-CALCULATE-DNP-BAL                                         *        
      *     CALLS 7400-SUM-UTL-CHARGE                                           
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       3100-CALCULATE-DNP-BAL.                                          
                                                                        
      *--CALLING CPD00068 TO GET DISCONNECT BALANCE FOR DNP -->                 
           MOVE WS-YES                     TO CALC-DNP-BAL-SW           
                                              CALC-ARREARS-SW           
                                              CALC-BALANCE-SW.          
T22359     MOVE PROGRAM-NAME               TO WS-CPD00068-CALLING-PGM.  
T19557     MOVE SPACES                     TO ABEND-FUNCTION .          
T19557     PERFORM 9500-CALL-CPD00068      THRU 9500-EXIT.              
T19557     MOVE RS-RETURN-CODE             TO  WS-ACTIVE-RETURN-CODE,   
T19557                                        SQLCODE.                  
T19557     IF ABEND-FUNCTION  > SPACES                                  
T19557        PERFORM 9700-PROCESS-ABEND   THRU 9700-EXIT               
T19557     END-IF.                                                      
                                                                        
       3100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 3300-CALC-SECURITY                                             *        
      *     CALLS 7600-SUM-SURETY-BOND                                          
      *           7605-SUM-IRR-LETTER                                  *        
      *           7610-SUM-GUARANTOR                                   *        
      *           7620-SUM-DEP-ON-HAND                                 *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       3300-CALC-SECURITY.                                              
                                                                        
           MOVE AT-ACCOUNT-NO TO SB-ACCOUNT-NO.                         
           MOVE WS-A          TO SB-CODE-BOND-TYPE.                     
           MOVE ZEROES        TO WS-AMT-BOND.                           
           PERFORM 7600-SUM-SURETY-BOND THRU 7600-EXIT.                 
                                                                        
           MOVE WS-B          TO SB-CODE-BOND-TYPE.                     
           MOVE ZEROES        TO WS-AMT-IRR-LTR.                        
           PERFORM 7605-SUM-IRR-LETTER THRU 7605-EXIT.                  
                                                                        
           MOVE AT-ACCOUNT-NO TO GU-ACCOUNT-NO.                         
           MOVE ZEROES        TO WS-AMT-GUARANTEED.                     
           PERFORM 7610-SUM-GUARANTOR THRU 7610-EXIT.                   
                                                                        
           MOVE AT-ACCOUNT-NO TO DO-ACCOUNT-NO.                         
           MOVE ZEROES        TO WS-AMT-DEP-ON-HAND.                    
           PERFORM 7620-SUM-DEP-ON-HAND THRU 7620-EXIT.                 
                                                                        
           COMPUTE WS-AMT-SEC-BAL = WS-AMT-BOND                         
                                  + WS-AMT-IRR-LTR                      
                                  + WS-AMT-GUARANTEED                   
                                  + WS-AMT-DEP-ON-HAND.                 
                                                                        
           MOVE WS-AMT-SEC-BAL          TO WS-AMT-SEC-BAL-N.            
           MOVE WS-AMT-SEC-BAL-N        TO WS-AMT-SEC-BAL-C.            
                                                                        
       3300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 3400-DETERMINE-AGING                                           *        
      *                                                                         
      *     CALLS 7200-ARREARS-CODE                                    *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *        
      ******************************************************************        
       3400-DETERMINE-AGING.                                            
                                                                        
           MOVE AT-ACCOUNT-NO TO                                        
                                 CZ-ACCOUNT-NO.                         
A01016     PERFORM 7200-ARREARS-CODE THRU 7200-EXIT.                    
A01016     MOVE WS-ARREARS-HIST(1:1) TO WS-CODE-ARREARS.                
                                                                        
       3400-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      **                                                              **        
      **    5000-PROCESS-ACCTS                                        **        
      **                                                              **        
      ******************************************************************        
       5000-PROCESS-ACCTS.                                              
                                                                        
           MOVE '5000' TO ACTIVE-PARAGRAPH.                             
                                                                        
           PERFORM 7000-OPEN-ACCT-CSR     THRU 7000-EXIT.               
           PERFORM 7025-FETCH-ACCT-CSR    THRU 7025-EXIT.               
           IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND THEN                
              PERFORM 7050-CLOSE-ACCT-CSR THRU 7050-EXIT                
A02036*       PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT                    
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
              PERFORM 9999-END-PROGRAM        THRU 9999-EXIT            
           END-IF.                                                      
                                                                        
           PERFORM 5010-REFRESH-AMT       THRU 5010-EXIT                
                   UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.         
                                                                        
           PERFORM 7050-CLOSE-ACCT-CSR THRU 7050-EXIT.                  
           MOVE 0             TO RS-RETURN-CODE.                        
           MOVE 'DONE'        TO ACTIVE-PARAGRAPH.                      
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      *                                                                *        
      * 5010-REFRESH-AMT                                               *        
      ******************************************************************        
                                                                        
       5010-REFRESH-AMT.                                                
                                                                        
           MOVE '5010'                     TO ACTIVE-PARAGRAPH.         
                                                                        
      ******************************************************************        
      * BEGINNING OF T28693 TO FIX 0 DNP BALANCE ON PARTIAL PAYMENTS   *        
      ******************************************************************        
           INITIALIZE    WS-DT-25-DAYS-AGO                              
                         WS-DT-45-DAYS-AGO                              
                         WS-HOLD-DATE                                   
                         WS-DATE-BILL-DUE                               
                         WS-DATE-ARREARS-DUE                            
                         WS-DATE-CREDIT-ACTION-M                        
                         WS-DATE-NOTICE-DUE-M                           
                         WS-DATE-NOTICE-MAIL-M                          
                         WS-DATE-BILL-M                                 
                         WS-AMT-60-90-DAY                               
                         WS-AMT-DNP-BAL                                 
                         WS-TOTAL-DISCONNECT-BAL                        
                         WS-AMT-NSF-DNP                                 
                         WS-AMT-DNP-TOTAL                               
                         WS-AMT-DNP-RET-CHECK                           
                         WS-AMT-00-DAY-DPP                              
                         WS-ITEM-ID-A                                   
                         WS-ITEM-ID-B                                   
                         WS-ITEM-ID-C                                   
                         WS-ITEM-ID-D                                   
                         WS-ITEM-ID-E                                   
                         WS-ITEM-ID-F                                   
                         WS-ITEM-ID-G                                   
                         WS-ITEM-ID-H                                   
                         WS-ITEM-ID-I                                   
                         WS-ITEM-ID-K                                   
                         WS-ITEM-ID-L                                   
                         WS-ITEM-ID-M                                   
                         WS-ITEM-ID-N                                   
                         WS-ITEM-ID-O                                   
                         WS-ITEM-ID-P                                   
                         WS-ITEM-ID-Q                                   
                         WS-ITEM-ID-R                                   
                         WS-ITEM-ID-S                                   
                         WS-ITEM-ID-T                                   
                         WS-ITEM-ID-U                                   
                         WS-ITEM-ID-V                                   
                         WS-ITEM-ID-W                                   
                         WS-ITEM-ID-X                                   
                         WS-HOLD-DNP-TYPE                               
                         WS-CODE-FRCST-CR-GRP-A                         
                         WS-CODE-FRCST-CR-GRP-B                         
                         WS-CODE-FRCST-CR-GRP-C                         
                         WS-CODE-FRCST-CR-GRP-D                         
                         WS-CODE-FRCST-CR-GRP-E                         
                         WS-CODE-FRCST-CR-GRP-F                         
                         WS-CODE-FRCST-CR-GRP-G                         
                         WS-CODE-FRCST-CR-GRP-H                         
                         WS-CODE-FRCST-CR-GRP-I                         
                         WS-CODE-FRCST-CR-GRP-K                         
                         WS-CODE-FRCST-CR-GRP-L                         
                         WS-CODE-FRCST-CR-GRP-M                         
                         WS-CODE-FRCST-CR-GRP-N                         
                         WS-CODE-FRCST-CR-GRP-O                         
                         WS-CODE-FRCST-CR-GRP-P                         
                         WS-CODE-FRCST-CR-GRP-Q                         
                         WS-CODE-FRCST-CR-GRP-R                         
                         WS-CODE-FRCST-CR-GRP-S                         
                         WS-CODE-FRCST-CR-GRP-T                         
                         WS-CODE-FRCST-CR-GRP-U                         
                         WS-CODE-FRCST-CR-GRP-V                         
                         WS-CODE-FRCST-CR-GRP-W                         
                         WS-CODE-FRCST-CR-GRP-X.                        
                                                                        
      ******************************************************************        
      * END OF T28693 TO FIX 0 DNP BALANCE ON PARTIAL PAYMENTS         *        
      ******************************************************************        
                                                                        
           MOVE XK-ACCOUNT-NO              TO WS-ACCOUNT-NO             
                                              AT-ACCOUNT-NO.            
                                                                        
           PERFORM 7300-SELECT-ACCOUNT     THRU 7300-EXIT.              
           MOVE AT-CODES-DATA-PRESENT      TO WS-CODES-DATA-PRESENT.    
           PERFORM 7100-GET-DAYS-AGO       THRU 7100-EXIT.              
           PERFORM 3100-CALCULATE-DNP-BAL  THRU 3100-EXIT.              
           MOVE WS-AMT-DNP-BAL             TO WS-AMT-DNP-BAL-N.         
           MOVE WS-AMT-DNP-BAL-N           TO WS-AMT-DNP-BAL-C.         
           PERFORM 3300-CALC-SECURITY      THRU 3300-EXIT.              
           PERFORM 3400-DETERMINE-AGING    THRU 3400-EXIT.              
                                                                        
           PERFORM 5200-UPDATE-TABLES      THRU 5200-EXIT.              
           IF WS-RPC-RC EQUAL WS-RPC-SUCCESS THEN                       
              PERFORM 8000-DELETE-ACCT     THRU 8000-EXIT               
           END-IF.                                                      
                                                                        
           PERFORM 7025-FETCH-ACCT-CSR     THRU 7025-EXIT.              
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************14880074
      *                                                                *        
      * 5200-UPDATE-TABLES                                             *14890074
      *                                                                *        
      ******************************************************************14900074
                                                                        
       5200-UPDATE-TABLES.                                              
                                                                        
           MOVE '5200'        TO ACTIVE-PARAGRAPH.                      
REARCH*                                                                         
REARCH******************************************************************        
REARCH*   PROCESS THE RESULTS                                          *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH     MOVE 'Y'  TO SW-RESULTS.                                     
REARCH*    EXEC SQL CALL CSR00428                                       
REARCH*                ( :WS-ACCOUNT-NO                                 
REARCH*                 ,:WS-AMT-DNP-BAL-C                              
REARCH*                 ,:WS-AMT-SEC-BAL-C                              
REARCH*                 ,:AT-DATE-BILL-DAY-00                           
REARCH*                 ,:AT-CREDIT-GROUP                               
REARCH*                 ,:WS-CODE-ARREARS                               
REARCH*                )                                                
REARCH*    END-EXEC.                                                    

MSQ001        EXEC SQL
MSQ001          CLOSE C2
MSQ001        END-EXEC
MSQ001        EXEC SQL
MSQ001          OPEN C2
MSQ001        END-EXEC
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

MSQ001        MOVE SQLCA TO MSQ001-SQLCABACK
MSQ001        MOVE 0 TO SQLD
MSQ001        EXEC SQL
MSQ001          DESCRIBE CURSOR C2 INTO :SQLDA
MSQ001        END-EXEC
MSQ001        MOVE MSQ001-SQLCABACK TO SQLCA
MSQ001        IF SQLD > 0 AND SQLCODE = 0 THEN
MSQ001          MOVE 466 TO SQLCODE
MSQ001        END-IF
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE       
REARCH     IF  WS-ACTIVE-RETURN-CODE = +466                             
REARCH*       EXEC SQL ASSOCIATE LOCATORS(:LOC1) WITH PROCEDURE         
REARCH*         CSR00428                                                
REARCH*       END-EXEC                                                  
REARCH*       EXEC SQL ALLOCATE C2  CURSOR FOR RESULT SET :LOC1         
REARCH*       END-EXEC                                                  
REARCH        EXEC SQL                                                  
REARCH        FETCH C2  INTO                                            
REARCH                 :WS-RETURN-CD                                    
REARCH        END-EXEC                                                  

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH        MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE    
REARCH        IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH            CONTINUE                                              
REARCH          ELSE                                                    
REARCH              MOVE '5200'               TO ACTIVE-PARAGRAPH       
REARCH              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
REARCH              MOVE 'FETCH'              TO ABEND-FUNCTION         
REARCH              MOVE 'CSR00428'           TO TABLE-1                
REARCH              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
REARCH              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
REARCH              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
REARCH          END-IF                                                  
REARCH          EXEC SQL                                                
REARCH            CLOSE C2                                              
REARCH          END-EXEC                                                

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH          MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE  
REARCH          IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL             
REARCH              CONTINUE                                            
REARCH          ELSE                                                    
REARCH              MOVE '5200'               TO ACTIVE-PARAGRAPH       
REARCH              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
REARCH              MOVE 'CLOSE'              TO ABEND-FUNCTION         
REARCH              MOVE 'CSR00428'           TO TABLE-1                
REARCH              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
REARCH              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
REARCH              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
REARCH          END-IF                                                  
REARCH      ELSE                                                        
REARCH              MOVE '5200'               TO ACTIVE-PARAGRAPH       
REARCH              MOVE PROGRAM-NAME         TO ABEND-PROGRAM          
REARCH              MOVE 'CALLSP'             TO ABEND-FUNCTION         
REARCH              MOVE 'CSR00428'           TO TABLE-1                
REARCH              MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1      
REARCH              MOVE 'SQLCODE '           TO TABLE-ELEMENT-1        
REARCH              MOVE WS-ACTIVE-RETURN-CODE TO HOSTVAR-ELEMENT-1     
REARCH              PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT           
REARCH      END-IF.                                                     
                                                                        
       5200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************05050000
      * 7000-OPEN-ACCT-CSR                                             *05060003
      ******************************************************************05070000
       7000-OPEN-ACCT-CSR.                                              
                                                                        
           EXEC SQL                                                     
                 OPEN ACCT-CSR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE '7000'                     TO ACTIVE-PARAGRAPH       
              MOVE 'OPEN'                     TO ABEND-FUNCTION         
              MOVE 'CSS_SO_DNP_CANCEL'        TO TABLE-1                
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7025-FETCH-ACCT-CSR                                            *        
      ******************************************************************        
       7025-FETCH-ACCT-CSR.                                             
                                                                        
           EXEC SQL                                                     
              FETCH ACCT-CSR                                            
              INTO  :XK-ACCOUNT-NO                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7025'                   TO ACTIVE-PARAGRAPH         
              MOVE 'FETCH'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DNP_CANCEL'      TO TABLE-1                  
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7025-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7050-CLOSE-ACCT-CSR                                            *        
      ******************************************************************        
       7050-CLOSE-ACCT-CSR.                                             
                                                                        
           EXEC SQL                                                     
              CLOSE ACCT-CSR                                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '7050'                   TO ACTIVE-PARAGRAPH         
              MOVE 'CLOSE'                  TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DNP_CANCEL'      TO TABLE-1                  
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7100-GET-DAYS-AGO.                                             *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     SELECT DATE FROM TODAY USING CSS_MODEL_SQL                 *        
      ******************************************************************        
       7100-GET-DAYS-AGO.                                               
                                                                        
           EXEC SQL                                                     
               SELECT DATEADD( DAY, -25, CAST(SYSDATETIMEOFFSET() 
           AS DATE) ),                           
                      DATEADD( DAY, -55, CAST(SYSDATETIMEOFFSET() 
           AS DATE) ),                           
                      DATEADD( DAY, -85, CAST(SYSDATETIMEOFFSET() 
           AS DATE) )                            
                 INTO :WS-DATE-25-DAYS-AGO,                             
                      :WS-DATE-55-DAYS-AGO,                             
                      :WS-DATE-85-DAYS-AGO                              
               FROM CSS_MODEL_SQL                                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CURRENT DATE - 25 DAYS,                                   
MFA-TR*               CURRENT DATE - 55 DAYS,                                   
MFA-TR*               CURRENT DATE - 85 DAYS                                    
MFA-TR*          INTO :WS-DATE-25-DAYS-AGO,                                     
MFA-TR*               :WS-DATE-55-DAYS-AGO,                                     
MFA-TR*               :WS-DATE-85-DAYS-AGO                                      
MFA-TR*        FROM CSS_MODEL_SQL                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7100'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_MODEL_SQL'       TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7200-ARREARS-CODE                                              *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     SELECT FROM CSS_CREDIT_PROFILE                             *        
      ******************************************************************        
A01016 7200-ARREARS-CODE.                                               
A01016     EXEC SQL                                                     
A01016         SELECT ARREARS_HIST                                      
A01016           INTO :WS-ARREARS-HIST                                  
A01016           FROM CSS_CREDIT_PROFILE                                
A01016          WHERE ACCOUNT_NO = :CZ-ACCOUNT-NO                       
A01016      END-EXEC.                                                   

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A01016      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE RS-RETURN-CODE.       
A01016                                                                  
A01016      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
A01016         NEXT SENTENCE                                            
A01016      ELSE                                                        
A01016         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
A01016         MOVE '7200'                     TO ACTIVE-PARAGRAPH      
A01016         MOVE 'SELECT ARREARS HIST'      TO TABLE-1               
A01016         MOVE 'CSS_CREDIT_PROFILE'       TO TABLE-2               
A01016         MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1       
A01016         MOVE CZ-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1     
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
A01016      END-IF.                                                     
A01016 7200-EXIT.                                                       
A01016     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7300-SELECT-ACCOUNT                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     SELECT FROM CSS_ACCOUNT                                    *        
      ******************************************************************        
       7300-SELECT-ACCOUNT.                                             
           EXEC SQL                                                     
                SELECT ACCOUNT_NO,                                      
                       CREDIT_GROUP,                                    
                       CODES_DATA_PRESENT,                              
                       DATE_BILL_DAY_00,       DATE_BILL_DAY_30,        
                       DATE_BILL_DAY_60,       DATE_BILL_DAY_90,        
T10857                 NOTICE_EXEMPT_CD,                                
T10857                 CODE_DISC_OK,                                    
T10857                 COMPANY_NO,                                      
T20165                 LOCAL_OFFICE,                                    
C25610                 CODE_ACCT_STAT,                                  
                       BANKRUPTCY_IND,                                  
C28788                 IVR_EXEMPT_CD                                    
                INTO   :AT-ACCOUNT-NO,                                  
                       :AT-CREDIT-GROUP,                                
                       :AT-CODES-DATA-PRESENT,                          
                       :AT-DATE-BILL-DAY-00 :WS-NULL-DT-IND1,            
                       :AT-DATE-BILL-DAY-30 :WS-NULL-DT-IND2,            
                       :AT-DATE-BILL-DAY-60 :WS-NULL-DT-IND3,            
                       :AT-DATE-BILL-DAY-90 :WS-NULL-DT-IND4,            
                       :AT-NOTICE-EXEMPT-CD,                            
                       :AT-CODE-DISC-OK,                                
                       :AT-COMPANY-NO,                                  
T20165                 :AT-LOCAL-OFFICE,                                
C25610                 :AT-CODE-ACCT-STAT,                              
                       :AT-BANKRUPTCY-IND,                              
C28788                 :AT-IVR-EXEMPT-CD                                
                FROM CSS_ACCOUNT                                        
                WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'CSS_ACCOUNT'         TO WS-TABLE-ID                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
                                                                        
      ******************************************************************        
      * 7600-SUM-SURETY-BOND                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      *     FETCH AMT-DISC_BAL AND SECURITY, CODE_ARREARS AND          *        
      *     DNP_TYPE FROM CSS_DNP                                      *        
      ******************************************************************        
       7600-SUM-SURETY-BOND.                                            
           EXEC SQL                                                     
              SELECT SUM(AMT_BOND)                                      
                INTO :WS-AMT-BOND :WS-NULL-INDICATOR                     
              FROM CSS_SURETY_BOND                                      
              WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                         
                AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                 
                AND CODE_STATUS IN ('A','P')                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'CSS_SURETY_BOND'     TO WS-TABLE-ID                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7600'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SURETY_BOND'     TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2             
              MOVE SB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE SB-CODE-BOND-TYPE     TO HOSTVAR-ELEMENT-2           
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7605-SUM-IRR-LETTER                                            *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      ******************************************************************        
       7605-SUM-IRR-LETTER.                                             
           EXEC SQL                                                     
              SELECT SUM(AMT_BOND)                                      
                INTO :WS-AMT-IRR-LTR :WS-NULL-INDICATOR                  
              FROM CSS_SURETY_BOND                                      
              WHERE ACCOUNT_NO = :SB-ACCOUNT-NO                         
                AND CODE_BOND_TYPE = :SB-CODE-BOND-TYPE                 
                AND CODE_STATUS IN ('A','P')                            
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'CSS_SURETY_BOND'     TO WS-TABLE-ID                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7605'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_SURETY_BOND'     TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE 'CODE_BOND_TYPE'      TO TABLE-ELEMENT-2             
              MOVE SB-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              MOVE SB-CODE-BOND-TYPE     TO HOSTVAR-ELEMENT-2           
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
       7605-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7610-SUM-GUARANTOR                                             *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      ******************************************************************        
       7610-SUM-GUARANTOR.                                              
           EXEC SQL                                                     
              SELECT SUM(AMOUNT_GUARANTEED)                             
                INTO :WS-AMT-GUARANTEED :WS-NULL-INDICATOR               
              FROM CSS_GUARANTOR                                        
              WHERE ACCOUNT_NO = :GU-ACCOUNT-NO                         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'CSS_GUARANTOR'       TO WS-TABLE-ID                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7610'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_GUARANTOR'       TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE GU-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
       7610-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7620-SUM-DEP-ON-HAND                                           *        
      *     CALLS       9000-SEND-ERROR-RESULT                         *        
      *                 9900-SQL-ERROR-ROUTINE                         *        
      *                                                                *        
      ******************************************************************        
       7620-SUM-DEP-ON-HAND.                                            
           EXEC SQL                                                     
              SELECT SUM(AMT_DEPOSIT)                                   
                INTO :WS-AMT-DEP-ON-HAND :WS-NULL-INDICATOR              
              FROM CSS_DEP_ON_HAND                                      
              WHERE ACCOUNT_NO = :DO-ACCOUNT-NO                         
                AND (DEPOSIT_STATUS_CD = 'A'                            
                 OR  DEPOSIT_STATUS_CD = 'P')                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE 'CSS_DEP_ON_HAND'     TO WS-TABLE-ID                    
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7620'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_DEP_ON_HAND'     TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE DO-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT
           END-IF.                
       7620-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 8000-DELETE-ACCT                                                        
      *      DELETE THE LAST ITEM FETCHED FROM THE CURSOR.                      
      *      COMMIT TRANSACTION AFTER SUCCESSFUL DELETE.                        
      ******************************************************************        
       8000-DELETE-ACCT.                                                
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_SO_DNP_CANCEL                             
              WHERE  CURRENT OF ACCT-CSR                                
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
                           RS-RETURN-CODE.                              
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME             TO ABEND-PROGRAM            
              MOVE '8000'                   TO ACTIVE-PARAGRAPH         
              MOVE 'DELETE'                 TO ABEND-FUNCTION           
              MOVE 'CSS_SO_DNP_CANCEL'      TO TABLE-1                  
CBSI          MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
CBSI          MOVE AT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
A02036*       PERFORM 9998-SEND-ERROR-RESULT  THRU 9998-EXIT                    
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
A02036        PERFORM 9700-PROCESS-ABEND THRU 9700-EXIT                 
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
T19557 9500-CALL-CPD00068.                                              
                                                                        
CVT000         CALL  MCSCB068  USING CWS00068-FIELDS,                   
CVT000                               WS-CODES-DATA-PRESENT,             
CVT000                               DCLCSS-ACCOUNT,                    
CVT000                               ABEND-FILE,                        
CVT000                               RS-RETURN-CODE.                    
T19557                                                                  
T19557 9500-EXIT.                                                       
T19557     EXIT.                                                        
                                                                        
      ***************************************************************** 48740074
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     48740074
      ******************************************************************48740074
           EXEC SQL                                                     48740074
              INCLUDE CPDSP300                                          48740074
           END-EXEC.                                                    48740074
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
      ******************************************************************48740074
      *  9000-SEND-ERROR-RESULT IS NOT BEING USED SINCE IT INITIALISES *        
      *  GTT-RETURN-FIELDS. ALL RETURN FIELDS ARE REQUIRED TO SEND     *        
      *  BACK ERROR MESSAGES                                           *        
      ******************************************************************48740074
       9998-SEND-ERROR-RESULT.                                          
                                                                        
             MOVE 'N'           TO SEND-DONE-SW.                        
      *      INITIALIZE GTT-RETURN-FIELDS.                                      
             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.              
             PERFORM 8100-SEND-RESULT      THRU 8100-EXIT.              
             PERFORM 8900-SEND-DONE        THRU 8900-EXIT.              
                                                                        
       9998-EXIT.                                                       
             EXIT.                                                      
      ******************************************************************48740074
      *       END PROGRAM COPYLIB                                      *48740074
      ******************************************************************48740074
CVT000 8100-SEND-RESULT.                                                
CVT000       ADD 1 TO CTR-ROWS.                                         
CVT000 8100-EXIT.                                                       
CVT000        EXIT.                                                     
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00321                                         00000200
CVT000     END-EXEC.                                                    00000300
