       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02369.                                         
       DATE-WRITTEN. 08/26/98.                                          
       DATE-COMPILED.                                                   
                                                                        
CVT000******************************************************************00000100
CVT000*     - - - - - >   R P C   C O N V E R S I O N   < - - - - -    *00000200
CVT000*         S369 CONVERTED TO DB2 SP CSR02369 ON 10/12/2005        *00000300
CVT000*             -NOTE: AUTOMATED CONVERSION PROGRAM USED           *00000400
CVT000*                                                                *00000500
CVT000*                    CVT000 - CONVERTED CODE                     *00000501
CVT000*                    CVT004 - NEEDED REVIEW                      *00000502
CVT000*                    CVT999 - COMMENTED OUT CODE THAT CAN        *00000503
CVT000*                             POTENTIALLY BE DELETED             *00000510
CVT000*                                                                *00000520
CVT000******************************************************************00000600
      ******************************************************************00060000
      *                                                                *00070000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00080000
      *                                                                *00090000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00100000
      *                                                                *00110000
      *  TRANID:        S369                                           *00120000
      *  PROGRAM:       S369                                           *00130000
      *  CALLING SP:    PA_S369                                        *00140000
      *                                                                *00150000
      ******************************************************************00160000
      *                 P R O G R A M  S U M M A R Y                   *00170000
      *                                                                *00180000
      *  THIS PROCEDURE IS USED TO SELECT ALL PREMISE HISTORY FOR A    *00190000
      *  SUPPLIED PREMISE.                                             *00200000
      *                                                                *00210000
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  08/26/98    FB       PROCEDURE ORIGINALLY CODED.              *00280000
CBSI  *  01/04/99   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T19958*  05/20/99    FB       CHECK NULL INDICATOR.                    *00280000
T20149*  06/16/99    FB       CHECK CUSTOMER ROLE CODE IN SELECT.      *00280000
C23874*  01/22/02    FB       CHANGED SORT ORDER IN SELECT.            *00280000
REARCH*  10/12/05   CVNS      RPC TO COBOL SP CONVERSION               *        
REARCH*             CHENNAI                                            *        
C35671*  11/09/07   MH94819   ADDRESS FORMAT CHANGES                   *        
A37342*  03/14/09   SV95326   IMPROVE PERFORMANCE - ADDING ROWSET      *        
A37342*                       POSITIONING FOR GLOBAL TEMP TABLES  &    *        
A37342*                       WITH UR CHANGES TO CURSORS.              *        
A04527*  06/06/13   MC95456   REMOVED UNUSED COPYBOOK CWS00056         *        
P00574*  03/15/14   HA7A338   ADD ADITIONAL COLUMN TO KNOW WHETHER     *        
P00574*                       IS ARCHIEVED OR NOT.                     *        
      ******************************************************************00220000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02369'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                     01790000
              INCLUDE SQLCA                                             01800000
           END-EXEC.                                                    01810000
                                                                        
           EXEC SQL                                                     02980000
              INCLUDE TBCSTPRM                                          02990000
           END-EXEC.                                                    03000000
                                                                        
           EXEC SQL                                                     02980000
              INCLUDE TBNMACTX                                          02990000
           END-EXEC.                                                    03000000
                                                                        
           EXEC SQL                                                     02980000
              INCLUDE TBNAME                                            02990000
           END-EXEC.                                                    03000000
                                                                        
P00574     EXEC SQL                                                     02980000
P00574        INCLUDE TBHACCT                                           02990000
P00574     END-EXEC.                                                    03000000
                                                                        
      ******************************************************************03140000
      *    COMMON COPYBOOKS                                            *03150000
      ******************************************************************03160000
                                                                        
CVT999*    COPY SYGWCOB.                                                03060000
CVT999*    COPY SYDBCOB.                                                03070000
           COPY CCA00001.                                               03080000
CVT999*    COPY CWS00010.                                               03090000
           COPY CWS00027.                                               03100000
           COPY CWS00303.                                               03120000
                                                                        
      ******************************************************************03140000
      *    WORK AREAS                                                  *03150000
      ******************************************************************03160000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
CVT999*    05  GWL-PROC                     POINTER.                    03190000
CVT999*    05  GWL-INIT-HANDLE              POINTER.                    03200000
CVT999*    05  GWL-RC                       PIC S9(9) COMP.             03210000
CVT999*    05  GWL-STATUS-NR                PIC S9(9) COMP.             03220000
CVT999*    05  GWL-STATUS-DONE              PIC S9(9) COMP.             03230000
CVT999*    05  GWL-STATUS-COUNT             PIC S9(9) COMP.             03240000
CVT999*    05  GWL-STATUS-COMM              PIC S9(9) COMP.             03250000
CVT999*    05  GWL-STATUS-RETURN-CODE       PIC S9(9) COMP.             03260000
           05  GWL-STATUS-SUBCODE           PIC S9(9) COMP.             
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(4) VALUE 'S369'.      
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
                                                                        
      ******************************************************************03500000
      *    INPUT PARAMETERS                                            *03510000
      ******************************************************************03520000
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                       PIC S9(9) COMP.             03550000
CVT999*    05  PARM-ID1                     PIC S9(9) COMP VALUE 1.     03560000
           05  PARM-PREMISE                 PIC 9(10).                  
                                                                        
       77  WS-BLO-LOT-SPACES                PIC X(05) VALUE SPACES.     
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
CVT999*    05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACE.      03910000
                                                                        
       01  WORK-FIELDS.                                                 
CVT999*    05  MAX-LENGTH-PARM              PIC S9(9) COMP.             04000000
CVT999*    05  WRKLEN1                      PIC S9(9) COMP.             04010000
CVT999*    05  WRKLEN2                      PIC S9(9) COMP.             04020000
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
       01  MISC.                                                        
REARCH     05  PROGRAM-NAME                 PIC X(8) VALUE 'CSR02369'.  
           05  WS-NULL-IND                  PIC S9(4) COMP VALUE 0.     
CVT999*    05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     03940000
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
           05  WS-SUB                       PIC S9(8) COMP VALUE ZERO.  
           05  WS-FROM.                                                 
*******        10  WS-FROM-X                OCCURS 51 TIMES PIC X.              
C35671         10  WS-FROM-X                OCCURS 76 TIMES PIC X.      
           05  CN-DELIMITER                 PIC X VALUE ';'.            
           05  WS-DATE-IN.                                              
               10  WS-YY-IN                 PIC X(4).                   
               10  F                        PIC X.                      
               10  WS-MM-IN                 PIC XX.                     
               10  F                        PIC X.                      
               10  WS-DD-IN                 PIC XX.                     
           05  WS-DATE-OUT.                                             
               10  WS-MM-OUT                PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-DD-OUT                PIC XX.                     
               10  F                        PIC X VALUE '/'.            
               10  WS-YY-OUT                PIC X(4).                   
                                                                        
      ******************************************************************04050000
      *    RESULT SET FIELDS                                           *04060000
      ******************************************************************04070000
                                                                        
REARCH 01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP.             
           05  RS-ACCOUNT-NO                PIC X(13).                  
           05  RS-START-DATE                PIC X(10).                  
           05  RS-END-DATE                  PIC X(10).                  
*******    05  RS-CUSTOMER-NAME             PIC X(50).                  04120000
C35671     05  RS-CUSTOMER-NAME             PIC X(76).                  
P00574     05  RS-ACCT-ARCHVD-FLG           PIC X(01) VALUE SPACES.     
       01  RS-ERROR-DESC                PIC X(40) VALUE SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE                PIC S9(9) COMP.             
REARCH     05  S-ACCOUNT-NO                 PIC X(13).                  
REARCH     05  S-START-DATE                 PIC X(10).                  
REARCH     05  S-END-DATE                   PIC X(10).                  
*******    05  S-CUSTOMER-NAME              PIC X(50).                  04120000
C35671     05  S-CUSTOMER-NAME              PIC X(76).                  
P00574     05  S-ACCT-ARCHVD-FLG            PIC X(01).                  
REARCH*                                                                         
      ******************************************************************04470000
      *    RESULT SET COLUMN NAMES                                     *04480000
      ******************************************************************04490000
                                                                        
CVT999*01  CN-COLUMN-NAMES.                                             04510000
CVT999*    05  CN-RETURN-CODE               PIC X(11)                   04520000
CVT999*                                     VALUE 'RETURN_CODE'.        04530000
CVT999*    05  CN-ACCOUNT-NO                PIC X(10)                   04540000
CVT999*                                     VALUE 'ACCOUNT_NO'.         04550000
CVT999*    05  CN-START-DATE                PIC X(10)                   04580000
CVT999*                                     VALUE 'START_DATE'.         04590000
CVT999*    05  CN-END-DATE                  PIC X(8)                    04600000
CVT999*                                     VALUE 'END_DATE'.           04610000
CVT999*    05  CN-CUSTOMER-NAME             PIC X(13)                   04560000
CVT999*                                     VALUE 'CUSTOMER_NAME'.      04570000
CVT999*                                                                 05160000
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
                                                                        
           EXEC SQL                                                     
               DECLARE CH-CURSOR CURSOR FOR                             
                   SELECT ACCOUNT_NO,                                   
                          CUSTOMER_NO,                                  
                          DATE_UTIL_SVC_STRT,                           
                          DATE_UTIL_SVC_END                             
                     FROM CSS_CUST_PREM_HIST WITH(READUNCOMMITTED)              
                    WHERE PREMISE_NO     = :CH-PREMISE-NO               
                 ORDER BY DATE_UTIL_SVC_STRT DESC,                      
C23874                    DATE_UTIL_SVC_END  DESC                       
A37342           FOR READ ONLY                                  
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     11560000
MFA-TR*        DECLARE CH-CURSOR CURSOR FOR                             11570000
MFA-TR*            SELECT ACCOUNT_NO,                                   11580000
MFA-TR*                   CUSTOMER_NO,                                          
MFA-TR*                   DATE_UTIL_SVC_STRT,                                   
MFA-TR*                   DATE_UTIL_SVC_END                                     
MFA-TR*              FROM CSS_CUST_PREM_HIST                            11590000
MFA-TR*             WHERE PREMISE_NO     = :CH-PREMISE-NO               11600000
MFA-TR*          ORDER BY DATE_UTIL_SVC_STRT DESC,                              
MFA-TR*                   DATE_UTIL_SVC_END  DESC                               
MFA-TR*          FOR FETCH ONLY WITH UR                                         
MFA-TR*    END-EXEC.                                                    11630000
                                                                        
CVT000     EXEC SQL                                                     00000010
CVT000         INCLUDE CWSX0010                                         00000020
CVT000     END-EXEC.                                                    00000030
CVT000                                                                  
CVT000 01  CSRERLOG-P.                                                  
CVT000     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
CVT000     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
CVT000     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
CVT000     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
CVT000     10  S-HOST-VARIABLES.                                        
CVT000         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
CVT000         49  S-HOST-VARIABLES-V    PIC X(255).                    
CVT000     10  S-SQL-STATEMENT.                                         
CVT000         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-STATEMENT-V     PIC X(255).                    
CVT000     10  S-SQL-DESCRIPTION.                                       
CVT000         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
CVT000         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
CVT000     10  WS-ABEND-SQLERRMC.                                       
CVT000         49  WS-ABEND-SQLERRMC-L   PIC S9(4) USAGE COMP.          
CVT000         49  WS-ABEND-SQLERRMC-V   PIC X(255).                    
REARCH*    10  S-RETURN-CODE             PIC S9(9) COMP VALUE 0.        00001701
CVT000     10  WS-SQLSTATE               PIC X(05) VALUE SPACES.        
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000                                                                  
CVT000     EXEC SQL                                                     
A37342         DECLARE C1 CURSOR                             
A37342                           WITH ROWSET POSITIONING FOR            
REARCH         SELECT                                                   
REARCH             RETURN_CODE                                          
REARCH            ,LTRIM(RTRIM(ACCOUNT_NO))       AS ACCOUNT_NO                
REARCH            ,LTRIM(RTRIM(START_DATE))       AS START_DATE                
REARCH            ,LTRIM(RTRIM(END_DATE))         AS END_DATE                  
REARCH            ,LTRIM(RTRIM(CUSTOMER_NAME))    AS CUSTOMER_NAME             
P00574            ,LTRIM(RTRIM(ACCT_ARCHVD))      AS ACCT_ARCHVD               
CVT000         FROM #CSR02369_R1                                 
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                     00000100
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                            00000300
MFA-TR*                          WITH ROWSET POSITIONING FOR                    
MFA-TR*        SELECT                                                   00000400
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,STRIP(ACCOUNT_NO)       AS ACCOUNT_NO                        
MFA-TR*           ,STRIP(START_DATE)       AS START_DATE                        
MFA-TR*           ,STRIP(END_DATE)         AS END_DATE                          
MFA-TR*           ,STRIP(CUSTOMER_NAME)    AS CUSTOMER_NAME                     
MFA-TR*           ,STRIP(ACCT_ARCHVD)      AS ACCT_ARCHVD                       
MFA-TR*        FROM SESSION.CSR02369_R1                                 00000500
MFA-TR*    END-EXEC.                                                    00000700
CVT000                                                                  
                                                                        
CVT000 LINKAGE SECTION.                                                 
REARCH 01  LINK-PREMISE             PIC X(10)                .          
                                                                        
CVT000 PROCEDURE DIVISION USING                                         
CVT000          LINK-PREMISE                                            
CVT000         .                                                        
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLWARNING                                      
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER SQLERROR                                        
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT000                                                                  
CVT000     EXEC SQL                                                     
CVT000         WHENEVER NOT FOUND                                       
CVT000             CONTINUE                                             
CVT000     END-EXEC.                                                    
CVT999*PROCEDURE DIVISION.                                              11770000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************11940000
      * 0100-INITIALIZE                                                *11950000
      *                                                                *11960000
      *     1. RESET DB2 ERROR HANDLERS                                *11970000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *11980000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *11990000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*12000000
      *                                                                *12010000
      ******************************************************************12020000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
CVT999*    EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              12060000
CVT999*    EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              12070000
CVT999*    EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              12080000
CVT999*    CALL 'TDINIT'   USING DFHEIBLK, GWL-RC, GWL-INIT-HANDLE.     12090000
                                                                        
CVT999*    CALL 'TDACCEPT' USING GWL-PROC, GWL-RC, GWL-INIT-HANDLE,     12110000
CVT999*                          SNA-CONNECTION-NAME, SNA-SUBC.         12120000
                                                                        
CVT999*    CALL 'TDRESULT' USING GWL-PROC, GWL-RC.                      12140000
                                                                        
CVT999*    IF GWL-RC NOT = TDS-PARM-PRESENT                             12160000
CVT999*       MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     12170000
CVT999*       MOVE '0100'          TO ACTIVE-PARAGRAPH                  12180000
CVT999*       MOVE 'TDRESULT - NO RPC PARM SENT' TO TABLE-2             12190000
CVT999*       MOVE 'CICS TRANSACTION'   TO TABLE-1                      12200000
CVT999*       MOVE GWL-RC               TO WS-ACTIVE-RETURN-CODE        12210000
CVT999*       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            12220000
CVT999*       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9999-EXIT            12230000
CVT999*    END-IF.                                                      12240000
                                                                        
CVT000     MOVE LINK-PREMISE              TO PARM-PREMISE             . 
CVT000     PERFORM 0100A-DECLARE-GTT                                    
CVT000       THRU 0100A-EXIT.                                           
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
CVT000 0100A-DECLARE-GTT.                                               
CVT000     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02369_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02369_R1
              (                                                          
CVT000         RETURN_CODE              INT                         
CVT000        ,ACCOUNT_NO CHAR(13)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,START_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2             
CVT000        ,END_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2               
CVT000        ,CUSTOMER_NAME CHAR(76)  COLLATE LATIN1_GENERAL_100_BIN2          
CVT000        ,ACCT_ARCHVD CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2            
CVT000       )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

           MOVE SQLSTATE TO WS-SQLSTATE.                                
           MOVE SQLCODE  TO WS-ACTIVE-RETURN-CODE.                      
                                                                        
           IF WS-SQLSTATE = '42710'                                     
              PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
           ELSE                                                         
               IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
                   NEXT SENTENCE                                        
               ELSE                                                     
                  MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
                  MOVE SQLCODE              TO ABEND-SQLCODE            
                  MOVE SQLSTATE             TO ABEND-SQLSTATE           
                  MOVE '0100A'               TO ACTIVE-PARAGRAPH        
                  MOVE 'DECLARE GTT'        TO ABEND-FUNCTION           
                  MOVE SPACES               TO ABEND-SQL-PREDICATES     
                                               ABEND-TABLES             
REARCH            MOVE 'CSR02369_R1'        TO TABLE-1                  
                  MOVE SPACES               TO TABLE-ELEMENT-1          
                  MOVE SPACES               TO HOSTVAR-ELEMENT-1        
                  PERFORM 9900-SQL-ERROR-ROUTINE  THRU  9900-EXIT       
               END-IF                                                   
           END-IF.                                                      
CVT000 0100A-EXIT.                                                      
CVT000         EXIT.                                                    
                                                                        
                                                                        
      ******************************************************************12290000
      * 1000-PROCESS-INPUT                                             *12300000
      *                                                                *12310000
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *12320000
      *     2. SPLIT OUT PARM STRING INFORMATION                       *12330000
      *                                                                *12340000
      ******************************************************************12350000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
CVT999*    MOVE 1                          TO PARM-ID1.                 12390000
CVT999*    MOVE LENGTH OF PARM-PREMISE     TO MAX-LENGTH-PARM,          12400000
CVT999*                                                                 12410000
CVT999*    CALL 'TDRCVPRM' USING GWL-PROC,                              12420000
CVT999*                          GWL-RC,                                12430000
CVT999*                          PARM-ID1,                              12440000
CVT999*                          PARM-PREMISE,                          12450000
CVT999*                          TDSCHAR,                               12460000
CVT999*                          MAX-LENGTH-PARM,                       12470000
CVT999*                          PARM-L.                                12480000
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************16250000
      * 2000-PROCESS-OUTPUT                                            *16260000
      *                                                                *16270000
      *     DESCRIBE EACH COLUMN IN THE RESULT SET.                    *16280000
      *     BUILD THE RESULT SET.                                      *16290000
      *                                                                *16300000
      ******************************************************************16310000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
CVT999*    MOVE 1       TO CTR-COLUMN.                                  16350000
CVT999*    MOVE TDSINT4 TO DB-HOST-TYPE.                                16360000
CVT999*    MOVE TDSINT4 TO DB-CLIENT-TYPE.                              16370000
CVT999*    MOVE LENGTH OF RS-RETURN-CODE TO WRKLEN1.                    16380000
CVT999*    MOVE LENGTH OF CN-RETURN-CODE TO WRKLEN2.                    16390000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              16410000
CVT999*                          GWL-RC,                                16420000
CVT999*                          CTR-COLUMN,                            16430000
CVT999*                          DB-HOST-TYPE,                          16440000
CVT999*                          WRKLEN1,                               16450000
CVT999*                          RS-RETURN-CODE,                        16460000
CVT999*                          DB-NULL-INDICATOR,                     16470000
CVT999*                          TDS-FALSE,                             16480000
CVT999*                          DB-CLIENT-TYPE,                        16490000
CVT999*                          WRKLEN1,                               16500000
CVT999*                          CN-RETURN-CODE,                        16510000
CVT999*                          WRKLEN2.                               16520000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT. 16540000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  16560000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                16570000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              16580000
CVT999*    MOVE LENGTH OF RS-ACCOUNT-NO TO WRKLEN1.                     16590000
CVT999*    MOVE LENGTH OF CN-ACCOUNT-NO TO WRKLEN2.                     16600000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              16620000
CVT999*                          GWL-RC,                                16630000
CVT999*                          CTR-COLUMN,                            16640000
CVT999*                          DB-HOST-TYPE,                          16650000
CVT999*                          WRKLEN1,                               16660000
CVT999*                          RS-ACCOUNT-NO,                         16670000
CVT999*                          DB-NULL-INDICATOR,                     16680000
CVT999*                          TDS-FALSE,                             16690000
CVT999*                          DB-CLIENT-TYPE,                        16700000
CVT999*                          WRKLEN1,                               16710000
CVT999*                          CN-ACCOUNT-NO,                         16720000
CVT999*                          WRKLEN2.                               16730000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT. 16750000
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  16980000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                16990000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              17000000
CVT999*    MOVE LENGTH OF RS-START-DATE TO WRKLEN1.                     17010000
CVT999*    MOVE LENGTH OF CN-START-DATE TO WRKLEN2.                     17020000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              17040000
CVT999*                          GWL-RC,                                17050000
CVT999*                          CTR-COLUMN,                            17060000
CVT999*                          DB-HOST-TYPE,                          17070000
CVT999*                          WRKLEN1,                               17080000
CVT999*                          RS-START-DATE,                         17090000
CVT999*                          DB-NULL-INDICATOR,                     17100000
CVT999*                          TDS-FALSE,                             17110000
CVT999*                          DB-CLIENT-TYPE,                        17120000
CVT999*                          WRKLEN1,                               17130000
CVT999*                          CN-START-DATE,                         17140000
CVT999*                          WRKLEN2.                               17150000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT. 17170000
                                                                        
CVT999*    ADD 1        TO CTR-COLUMN.                                  17190000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                17200000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              17210000
CVT999*    MOVE LENGTH OF RS-END-DATE TO WRKLEN1.                       17220000
CVT999*    MOVE LENGTH OF CN-END-DATE TO WRKLEN2.                       17230000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              17250000
CVT999*                          GWL-RC,                                17260000
CVT999*                          CTR-COLUMN,                            17270000
CVT999*                          DB-HOST-TYPE,                          17280000
CVT999*                          WRKLEN1,                               17290000
CVT999*                          RS-END-DATE,                           17300000
CVT999*                          DB-NULL-INDICATOR,                     17310000
CVT999*                          TDS-FALSE,                             17320000
CVT999*                          DB-CLIENT-TYPE,                        17330000
CVT999*                          WRKLEN1,                               17340000
CVT999*                          CN-END-DATE,                           17350000
CVT999*                          WRKLEN2.                               17360000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT. 17380000
                                                                        
CVT999*    ADD  1       TO CTR-COLUMN.                                  16770000
CVT999*    MOVE TDSCHAR TO DB-HOST-TYPE.                                16780000
CVT999*    MOVE TDSCHAR TO DB-CLIENT-TYPE.                              16790000
CVT999*    MOVE LENGTH OF RS-CUSTOMER-NAME TO WRKLEN1.                  16800000
CVT999*    MOVE LENGTH OF CN-CUSTOMER-NAME TO WRKLEN2.                  16810000
                                                                        
CVT999*    CALL 'TDESCRIB' USING GWL-PROC,                              16830000
CVT999*                          GWL-RC,                                16840000
CVT999*                          CTR-COLUMN,                            16850000
CVT999*                          DB-HOST-TYPE,                          16860000
CVT999*                          WRKLEN1,                               16870000
CVT999*                          RS-CUSTOMER-NAME,                      16880000
CVT999*                          DB-NULL-INDICATOR,                     16890000
CVT999*                          TDS-FALSE,                             16900000
CVT999*                          DB-CLIENT-TYPE,                        16910000
CVT999*                          WRKLEN1,                               16920000
CVT999*                          CN-CUSTOMER-NAME,                      16930000
CVT999*                          WRKLEN2.                               16940000
                                                                        
CVT999*    PERFORM 9100-CHECK-ERROR                     THRU 9100-EXIT. 16960000
                                                                        
           MOVE PARM-PREMISE TO CH-PREMISE-NO.                          
           PERFORM 7000-OPEN-CURSOR THRU 7000-EXIT.                     
           PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT.                    
                                                                        
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
               PERFORM 2500-PROCESS-ROW THRU 2500-EXIT                  
               PERFORM 7010-FETCH-CURSOR THRU 7010-EXIT                 
           END-PERFORM.                                                 
                                                                        
           PERFORM 7020-CLOSE-CURSOR THRU 7020-EXIT.                    
                                                                        
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND TO RS-RETURN-CODE                         
REARCH         PERFORM 2000A-MOVE-RESULT                THRU 2000A-EXIT 
               PERFORM 8100-SEND-RESULT                 THRU 8100-EXIT  
           END-IF.                                                      
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH*****************************************************************         
REARCH*2000A-MOVE-RESULT.                                              *        
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH     MOVE RS-RETURN-CODE              TO S-RETURN-CODE.           
REARCH     MOVE RS-ACCOUNT-NO               TO S-ACCOUNT-NO.            
REARCH     MOVE RS-START-DATE               TO S-START-DATE.            
REARCH     MOVE RS-END-DATE                 TO S-END-DATE.              
REARCH     MOVE RS-CUSTOMER-NAME            TO S-CUSTOMER-NAME.         
REARCH     MOVE RS-ACCT-ARCHVD-FLG          TO S-ACCT-ARCHVD-FLG.       
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
       2500-PROCESS-ROW.                                                
                                                                        
           INITIALIZE GTT-RETURN-FIELDS.                                
                                                                        
           MOVE 0 TO RS-RETURN-CODE.                                    
           MOVE CH-ACCOUNT-NO TO RS-ACCOUNT-NO.                         
           IF CH-DATE-UTIL-SVC-STRT > SPACES                            
               MOVE CH-DATE-UTIL-SVC-STRT TO WS-DATE-IN                 
               MOVE WS-MM-IN TO WS-MM-OUT                               
               MOVE WS-DD-IN TO WS-DD-OUT                               
               MOVE WS-YY-IN TO WS-YY-OUT                               
               MOVE WS-DATE-OUT TO RS-START-DATE                        
           ELSE                                                         
               MOVE SPACES TO RS-START-DATE
           END-IF.                            
           IF CH-DATE-UTIL-SVC-END > SPACES                             
               MOVE CH-DATE-UTIL-SVC-END TO WS-DATE-IN                  
               MOVE WS-MM-IN TO WS-MM-OUT                               
               MOVE WS-DD-IN TO WS-DD-OUT                               
               MOVE WS-YY-IN TO WS-YY-OUT                               
               MOVE WS-DATE-OUT TO RS-END-DATE                          
           ELSE                                                         
               MOVE SPACES TO RS-END-DATE
           END-IF.                              
                                                                        
           PERFORM 7100-GET-CUSTOMER-NAME THRU 7100-EXIT.               
                                                                        
P00574     PERFORM 7200-CHK-ACCT-ARCHVD   THRU 7200-EXIT.               
P00574                                                                  
REARCH     PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT.                   
           PERFORM 8100-SEND-RESULT THRU 8100-EXIT.                     
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2600-FORMAT-CUSTOMER-NAME.                                       
                                                                        
           IF DQ-NAME-FORMAT = 'I'                                      
               MOVE DQ-LAST-NAME TO WS-FROM                             
               PERFORM 2610-PROCESS-FROM-STRING THRU 2610-EXIT          
               MOVE WS-FROM TO DQ-LAST-NAME                             
                                                                        
               MOVE DQ-FIRST-NAME TO WS-FROM                            
               PERFORM 2610-PROCESS-FROM-STRING THRU 2610-EXIT          
               MOVE WS-FROM TO DQ-FIRST-NAME                            
                                                                        
               IF DQ-MIDDLE-NAME NOT = SPACE                            
                   MOVE DQ-MIDDLE-NAME TO WS-FROM                       
                   PERFORM 2610-PROCESS-FROM-STRING THRU 2610-EXIT      
                   MOVE WS-FROM TO DQ-MIDDLE-NAME                       
               END-IF                                                   
                                                                        
               IF DQ-MIDDLE-NAME = SPACE                                
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-CUSTOMER-NAME                              
                   END-STRING                                           
               ELSE                                                     
                   STRING DQ-LAST-NAME DELIMITED CN-DELIMITER           
                          ', ' DELIMITED SIZE                           
                          DQ-FIRST-NAME DELIMITED CN-DELIMITER          
                          ' ' DELIMITED SIZE                            
                          DQ-MIDDLE-NAME DELIMITED CN-DELIMITER         
                          ' ' DELIMITED SIZE                            
                          DQ-TITLE-SUFFIX-1 DELIMITED CN-DELIMITER      
                     INTO RS-CUSTOMER-NAME                              
                   END-STRING                                           
               END-IF                                                   
           ELSE                                                         
               MOVE DQ-FULL-NAME TO RS-CUSTOMER-NAME
           END-IF.                   
                                                                        
       2600-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2610-PROCESS-FROM-STRING.                                        
                                                                        
           PERFORM                                                      
*******        VARYING WS-SUB FROM 51 BY -1                                     
C35671         VARYING WS-SUB FROM 76 BY -1                             
                 UNTIL WS-SUB < 1                                       
                    OR WS-FROM-X (WS-SUB) NOT = SPACE                   
           END-PERFORM.                                                 
           ADD 1            TO WS-SUB.                                  
           MOVE CN-DELIMITER TO WS-FROM-X (WS-SUB).                     
                                                                        
       2610-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7000-OPEN-CURSOR.                                                
                                                                        
           EXEC SQL                                                     
               OPEN CH-CURSOR                                           
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE 'PARA -7000 ,OPEN CURSOR CH-CURSOR'                 
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7000'                 TO ACTIVE-PARAGRAPH          
               MOVE 'OPEN'                 TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PREM_HIST'   TO TABLE-1                   
               MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
               MOVE CH-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7010-FETCH-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               FETCH CH-CURSOR                                          
                INTO :CH-ACCOUNT-NO,                                    
                     :CH-CUSTOMER-NO,                                   
                     :CH-DATE-UTIL-SVC-STRT,                            
                     :CH-DATE-UTIL-SVC-END :WS-NULL-IND                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   IF WS-NULL-IND < 0                                   
                       MOVE SPACES TO CH-DATE-UTIL-SVC-END              
                   END-IF                                               
               WHEN NOT-FOUND                                           
                   CONTINUE                                             
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE 'PARA -7010 ,FETCH CURSOR CH-CURSOR'            
                          TO RS-ERROR-DESC                              
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7010'             TO ACTIVE-PARAGRAPH          
                   MOVE 'FETCH'            TO ABEND-FUNCTION            
                   MOVE 'CSS_CUST_PREM_HIST' TO TABLE-1                 
                   MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-1           
                   MOVE CH-PREMISE-NO      TO HOSTVAR-ELEMENT-1         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7020-CLOSE-CURSOR.                                               
                                                                        
           EXEC SQL                                                     
               CLOSE CH-CURSOR                                          
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
               MOVE 'PARA -7020 ,CLOSE CURSOR CH-CURSOR'                
                      TO RS-ERROR-DESC                                  
               MOVE PROGRAM-NAME           TO ABEND-PROGRAM             
               MOVE '7020'                 TO ACTIVE-PARAGRAPH          
               MOVE 'CLOSE'                TO ABEND-FUNCTION            
               MOVE 'CSS_CUST_PREM_HIST'   TO TABLE-1                   
               MOVE 'PREMISE_NO'           TO TABLE-ELEMENT-1           
               MOVE CH-PREMISE-NO          TO HOSTVAR-ELEMENT-1         
               PERFORM 9000-SEND-ERROR-RESULT           THRU 9000-EXIT  
               PERFORM 9900-SQL-ERROR-ROUTINE           THRU 9900-EXIT  
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7100-GET-CUSTOMER-NAME.                                          
                                                                        
           MOVE CH-ACCOUNT-NO TO HT-ACCOUNT-NO.                         
           MOVE CH-CUSTOMER-NO TO HT-CUSTOMER-NO.                       
           EXEC SQL                                                     
               SELECT DQ.FIRST_NAME,                                    
                      DQ.MIDDLE_NAME,                                   
                      DQ.LAST_NAME,                                     
                      DQ.FULL_NAME,                                     
                      DQ.NAME_FORMAT                                    
                 INTO :DQ-FIRST-NAME,                                   
                      :DQ-MIDDLE-NAME,                                  
                      :DQ-LAST-NAME,                                    
                      :DQ-FULL-NAME,                                    
                      :DQ-NAME-FORMAT                                   
                 FROM CSS_NAME DQ WITH(READUNCOMMITTED),                        
                      CSS_NAME_ACCT_XREF HT WITH(READUNCOMMITTED)               
                WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                    
                  AND HT.CUSTOMER_NO = :HT-CUSTOMER-NO                  
T20149            AND HT.CUSTOMER_ROLE_CD = ' '                         
                  AND DQ.NAME_TYPE = 'CN'                               
                  AND DQ.NAME_ID = HT.NAME_ID                           
A37342                                                           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT DQ.FIRST_NAME,                                            
MFA-TR*               DQ.MIDDLE_NAME,                                           
MFA-TR*               DQ.LAST_NAME,                                             
MFA-TR*               DQ.FULL_NAME,                                             
MFA-TR*               DQ.NAME_FORMAT                                            
MFA-TR*          INTO :DQ-FIRST-NAME,                                           
MFA-TR*               :DQ-MIDDLE-NAME,                                          
MFA-TR*               :DQ-LAST-NAME,                                            
MFA-TR*               :DQ-FULL-NAME,                                            
MFA-TR*               :DQ-NAME-FORMAT                                           
MFA-TR*          FROM CSS_NAME DQ,                                              
MFA-TR*               CSS_NAME_ACCT_XREF HT                                     
MFA-TR*         WHERE HT.ACCOUNT_NO = :HT-ACCOUNT-NO                            
MFA-TR*           AND HT.CUSTOMER_NO = :HT-CUSTOMER-NO                          
MFA-TR*           AND HT.CUSTOMER_ROLE_CD = ' '                                 
MFA-TR*           AND DQ.NAME_TYPE = 'CN'                                       
MFA-TR*           AND DQ.NAME_ID = HT.NAME_ID                                   
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           EVALUATE WS-ACTIVE-RETURN-CODE                               
               WHEN SUCCESSFUL-CALL                                     
                   PERFORM 2600-FORMAT-CUSTOMER-NAME THRU 2600-EXIT     
               WHEN NOT-FOUND                                           
                   MOVE SPACES TO RS-CUSTOMER-NAME                      
               WHEN OTHER                                               
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE 'PARA -7100 ,SELECT'                            
                          TO RS-ERROR-DESC                              
                   MOVE PROGRAM-NAME       TO ABEND-PROGRAM             
                   MOVE '7100'             TO ACTIVE-PARAGRAPH          
                   MOVE 'SELECT'           TO ABEND-FUNCTION            
                   MOVE 'CSS_NAME_ACCT_XREF' TO TABLE-1                 
                   MOVE 'CSS_NAME'         TO TABLE-2                   
                   MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1           
CBSI               MOVE HT-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1         
                   MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-2           
                   MOVE HT-CUSTOMER-NO     TO HOSTVAR-ELEMENT-2         
                   PERFORM 9000-SEND-ERROR-RESULT       THRU 9000-EXIT  
                   PERFORM 9900-SQL-ERROR-ROUTINE       THRU 9900-EXIT  
           END-EVALUATE.                                                
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
                                                                        
P00574******************************************************************57510000
P00574* 7200-CHK-ACCT-ARCHVD.                                           57520000
P00574* CHECK WHETHER THE ACCOUNT IS ARCHIEVED.                         57520000
P00574******************************************************************57530000
P00574 7200-CHK-ACCT-ARCHVD.                                            
P00574                                                                  
P00574     MOVE CH-ACCOUNT-NO                TO HA-ACCOUNT-NO.          
P00574                                                                  
P00574     EXEC SQL                                                     
P00574         SELECT 'Y'                                               
P00574           INTO :RS-ACCT-ARCHVD-FLG                               
P00574           FROM HST_ACCOUNT HA WITH(READUNCOMMITTED)                      
P00574          WHERE HA.ACCOUNT_NO = :HA-ACCOUNT-NO                    
P00574                                                           
P00574     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT 'Y'                                                       
MFA-TR*          INTO :RS-ACCT-ARCHVD-FLG                                       
MFA-TR*          FROM HST_ACCOUNT HA                                            
MFA-TR*         WHERE HA.ACCOUNT_NO = :HA-ACCOUNT-NO                            
MFA-TR*          WITH UR                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00574                                                                  
P00574     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00574                                                                  
P00574     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00574         WHEN SUCCESSFUL-CALL                                     
P00574             CONTINUE                                             
P00574         WHEN NOT-FOUND                                           
P00574             MOVE 'N'                  TO RS-ACCT-ARCHVD-FLG      
P00574         WHEN OTHER                                               
P00574             MOVE WS-ACTIVE-RETURN-CODE                           
P00574                                       TO RS-RETURN-CODE          
P00574             MOVE 'PARA -7200 ,SELECT' TO RS-ERROR-DESC           
P00574             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
P00574             MOVE '7200'               TO ACTIVE-PARAGRAPH        
P00574             MOVE 'SELECT'             TO ABEND-FUNCTION          
P00574             MOVE 'HST_ACCOUNT'        TO TABLE-1                 
P00574             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
P00574             MOVE HA-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
P00574             PERFORM 9000-SEND-ERROR-RESULT                       
P00574                                        THRU 9000-EXIT            
P00574             PERFORM 9900-SQL-ERROR-ROUTINE                       
P00574                                        THRU 9900-EXIT            
P00574     END-EVALUATE.                                                
P00574                                                                  
P00574 7200-EXIT.                                                       
P00574     EXIT.                                                        
P00574                                                                  
      ******************************************************************57510000
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     57520000
      ******************************************************************57530000
           EXEC SQL                                                     57540000
              INCLUDE CPDSP300                                          57550000
           END-EXEC.                                                    57560000
                                                                        
      ******************************************************************57580000
      *       END PROGRAM COPYLIB                                      *57590000
      ******************************************************************57600000
CVT999*    COPY CPD00302.                                               57610000
CVT000 8100-SEND-RESULT.                                                
CVT000     EXEC SQL                                                     
CVT000       INSERT INTO #CSR02369_R1                            
CVT000       (                                                          
CVT000        RETURN_CODE                                               
CVT000       ,ACCOUNT_NO                                                
CVT000       ,START_DATE                                                
CVT000       ,END_DATE                                                  
CVT000       ,CUSTOMER_NAME                                             
P00574       ,ACCT_ARCHVD                                               
CVT000       )                                                          
CVT000       VALUES                                                     
CVT000       (                                                          
REARCH        :S-RETURN-CODE                                            
REARCH       ,:S-ACCOUNT-NO                                             
REARCH       ,:S-START-DATE                                             
REARCH       ,:S-END-DATE                                               
REARCH       ,:S-CUSTOMER-NAME                                          
P00574       ,:S-ACCT-ARCHVD-FLG                                        
CVT000       )                                                          
CVT000     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*      INSERT INTO SESSION.CSR02369_R1                                    
MFA-TR*      (                                                                  
MFA-TR*       RETURN_CODE                                                       
MFA-TR*      ,ACCOUNT_NO                                                        
MFA-TR*      ,START_DATE                                                        
MFA-TR*      ,END_DATE                                                          
MFA-TR*      ,CUSTOMER_NAME                                                     
MFA-TR*      ,ACCT_ARCHVD                                                       
MFA-TR*      )                                                                  
MFA-TR*      VALUES                                                             
MFA-TR*      (                                                                  
MFA-TR*       :S-RETURN-CODE                                                    
MFA-TR*      ,:S-ACCOUNT-NO                                                     
MFA-TR*      ,:S-START-DATE                                                     
MFA-TR*      ,:S-END-DATE                                                       
MFA-TR*      ,:S-CUSTOMER-NAME                                                  
MFA-TR*      ,:S-ACCT-ARCHVD-FLG                                                
MFA-TR*      )                                                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000     MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.       
CVT000                                                                  
CVT000     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
CVT000        NEXT SENTENCE                                             
CVT000     ELSE                                                         
CVT000        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
CVT000        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE 'CSR02369_R1'        TO TABLE-1                      
CVT000        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
CVT000     END-IF.                                                      
CVT000                                                                  
CVT000     ADD 1 TO CTR-ROWS.                                           
CVT000*    INITIALIZE GTT-RETURN-FIELDS.                                00001900
CVT000*                                                                 00002000
CVT000 8100-EXIT.                                                       
CVT000      EXIT.                                                       
CVT000******************************************************************00000100
CVT000* 8000A-DELETE-GTT-ROWS.                                         *00000200
CVT000******************************************************************00000300
CVT000 8000A-DELETE-GTT-ROWS.                                           
CVT000*                                                                 00000500
CVT000     MOVE                                                         
CVT000     'DELETE ROWS'                                                
CVT000         TO S-SQL-STATEMENT-V.                                    
CVT000*                                                                 00000900
CVT000      EXEC SQL                                                    
CVT000          DELETE FROM #CSR02369_R1                         
CVT000      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*     EXEC SQL                                                    00001000
MFA-TR*         DELETE FROM SESSION.CSR02369_R1                         00001100
MFA-TR*     END-EXEC.                                                   00001200

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CVT000*                                                                 00001300
CVT000      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
CVT000*                                                                 00001500
CVT000      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
CVT000          NEXT SENTENCE                                           
CVT000      ELSE                                                        
CVT000         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
CVT000         MOVE SQLCODE              TO ABEND-SQLCODE               
CVT000         MOVE SQLSTATE             TO ABEND-SQLSTATE              
CVT000         MOVE '8000A'              TO ACTIVE-PARAGRAPH            
CVT000         MOVE 'DELETE'             TO ABEND-FUNCTION              
CVT000         MOVE SPACES               TO ABEND-SQL-PREDICATES        
CVT000                                      ABEND-TABLES                
CVT000         MOVE 'CSR02369_R1'        TO TABLE-1                     
CVT000         MOVE SPACES               TO TABLE-ELEMENT-1             
CVT000         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
CVT000         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
CVT000     END-IF.                                                      
CVT000*                                                                 00003100
CVT000 8000A-EXIT.                                                      
CVT000     EXIT.                                                        
CVT000*                                                                 00003400
CVT000     EXEC SQL                                                     00000100
CVT000         INCLUDE CPD00320                                         00000200
CVT000     END-EXEC.                                                    00000300
