       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02364.                                         
       DATE-WRITTEN.  05/07/98.                                         
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                                                                *        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROCEDURE IS USED TO RETRIEVE THE WORKSCHEDULE FOR       *        
      *   PANEL274 AND PANEL300.                                       *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
PCR635*  05/07/98    EMS      PROCEDURE ORIGINALLY CODED.              *        
CBSI  *  01/04/99   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T19371*  03/10/99    SHF      MODIFIED PARA 7000 TO SEND +100 SQLCODE  *        
      *                       TO MC05 WHEN REVENUE_MONTH IS NOT FOUND. *        
T21340*  01/04/00    SFH      CHANGED WS-MAX-BILL-CYCLE-NO TO HAVE 21  *        
      *                       BILL CYCLES FOR SEB AND 20 FOR SCEG.     *        
T21530*  02/02/00    SFH      PARA 2200 CHANGED SO THAT SEB ACCOUNTS   *        
      *                       WITH AN "ARREARS" CREDIT GROUP WILL      *        
      *                       DISPLAY THE "NEW" WORK SCHEDULE.  THEN   *        
      *                       LOGIC FOR GETTING THE "NEW" WORK SCHEDULE*        
      *                       IN PARA 2400 WAS CHANGED FOR SEB FOR THE *        
      *                       DNP DATE AND SECOND NOTICE MAIL DATE.    *        
      *                       ALSO, MODIFIED INCORRECT LOGIC IN PARA   *        
      *                       2400 AND PARA 2600.  DELINQUENCY VALUES  *        
      *                       WERE BEING ADDED TO THE BILL CYCLE CLOSE *        
      *                       DATE INSTEAD OF SUBTRACTED FROM THE DNP  *        
      *                       DATE TO DETERMINE THE SECOND NOTICE MAIL *        
      *                       DATE.                                    *        
T23513*  01/20/01   AS        CHANGES MADE TO DISTINGUISH DATABASES SEB*        
T23513*                       AND NON SEB TO INCORPORATE PSNC IN NON   *        
T23513*                       SEB                                      *        
T23501*  02/15/01   SS82048   CHANGES TO RECEIVE COMPANY-NO AS PARM    *        
      *                       FOR DELINQUENCY TABLE CHANGES TO SUPPORT *        
      *                       MULTI-COMPANY AND PSNC CONVERSION        *        
T23235** 05/22/01   VIJAY     FOLLOWING VALUES:                        *        
      **                          WS-A-TOTAL-DUE - 'DAY-ATOTALDUE'     *        
      **                          WS-B-TOTAL-DUE - 'DAY-BTOTALDUE'     *        
      **                          WS-C-TOTAL-DUE - 'DAY-CTOTALDUE'     *        
      **                          WS-N-TOTAL-DUE - 'DAY-NTOTALDUE'     *        
      **                          WS-DAY-NU-DUE - 'DAY-NU-DUE'         *        
      **                          REPLACED WITH 'DAY-TOTAL-DUE' -      *        
      **                                        WS-DAY-TOTAL-DUE       *        
      **                      FOLLOWING VALUES:                        *        
      **                          WS-N-DNP - 'DAY-NDNP'                *        
      **                          WS-B-DNP-EXCEPT - 'DAY-BDNPEXC'      *        
      **                          REPLACED WITH 'DAY-DNP'  -           *        
      **                                         WS-DAY-DNP            *        
      **                      FOLLOWING VALUES:                        *        
      **                          WS-A-SECOND - 'DAY-ASECOND'          *        
      **                          WS-B-SECOND - 'DAY-BSECOND'          *        
      **                          WS-D-SECOND - 'DAY-DSECOND'          *        
      **                          WS-N-SECOND - 'DAY-NSECOND'          *        
      **                          WS-B-SECOND-EXCEPT - 'DAY-BSECONDEXC'*        
      **                          REPLACED WITH 'DAY-SECOND-MAIL'      *        
      **                                      WS-DAY-SECOND-MAIL -     *        
      **                      THE NEW DELINQUENCY CODES AND VALUES     *        
      **                      ARE:                                     *        
      **                         'DAY-TOTAL-DUE'                       *        
      **                         'DAY-DUE'                             *        
      **                         'DAY-DNP'                             *        
      **                         'DAY-SECOND-MAIL'                     *        
      **                         'DAY-SECOND-FIELD'                    *        
T26954** 07/30/02   VD88125   ADDED NEW WORK SCHEDULE BALANCE CREDIT   *        
T26954**                      GROUP FOR SEBR.                          *        
      *                                                                *        
REARCH*  06/27/03   MR90712    RPC CONVERTED TO COBOL SP               *        
T28824*  12/01/04   VD88125    ADD NEW COLUMN TO DISPLAY 3RD-PRTY-RD-DT*        
T28824*                        ON WORKSCHEDULE PANEL FOR ALL CREDITGRPS*        
C32545*  11/19/05   DP19151    DISPLAY IVR DATE FOR SCEG NORM CREDIT   *        
C32545*                        ACTION AND ADDED A COLUMN TO SHOW IVR   *        
C32545*                        DATE FOR SCEG EXCEPT CREDIT ACTION      *        
T34822*  09/22/06   COVANSYS   INTRODUCE A NEW TABLE TO STORE DUE DATES*        
T34822*             CHENNAI/   AND CREDIT ACTION DATES FOR SCANA ENERGY*        
T34822*             SS82048    ACCOUNTS WHICH ARE IN  BALANCE          *        
T34822*                        CREDIT-GROUP(AT-CREDIT-GROUP='B').      *        
T34822*  11/07/06   SS82048    FIX ISSUE WITH SETTING RANGE-INDX AFTER *        
      *                        SECOND FETCH.                           *        
T34097*  16/02/07   COVANSYS   SQL PERFORMANCE TUNING                  *        
T34097*             CHENNAI                                            *        
T34097*   10/30/08  SS42021    ADDED ROWSET POSITIONING FOR RETURN CURS*        
P00399*   07/19/10  VV94890    CALCULATE DNP DATE FOR NEW/ARREARS AS   *        
      *                        BILL CLOSE + EXISTING DELINQ VALUES.    *        
P00453*   31/01/11  SV95326    CHANGE CM-CRED-FORECAST-CD VALUE BASED  *        
P00453*                        ON CREDIT GROUP FOR REG & DEREG ACCOUNT *        
P00453*                        IN SEB REGION.                          *        
P00453*                        CREDIT GROUP : F - BALANCE REG          *        
P00453*                                       G - BALANCE DEREG.       *        
P00599*   10/05/12  SP95538    INCREASED RANGE-INDX VALUE FROM 100 TO  *        
P00599*                        250 AS PART OF CREDIT SIMPLIFICATION PROJ        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ012      EXEC SQL INCLUDE MFADIAG END-EXEC
MSQ008  01 MSQ008-HOLIDAY-CURSOR  PIC S9(9) COMP-5.
MSQ008  01 MSQ008-CRED-FCAST-CSR  PIC S9(9) COMP-5.
MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02364'.
MSQ017     COPY MFASQLM.
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *    CL - CSS_CRED_COLL                                          *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBCRCOLL                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    RW - CSS_READ_WINDOW                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBRDWNDW                                                  
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    C8 - CSS_DELINQUENCY                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBDELQ                                                    
           END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *    BN - CSS_BILL_WINDOW                                        *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE TBBILWDW                                                  
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
P00399*    CSS_COMPANY C7                                                       
      *****************************************************************         
           EXEC SQL                                                             
             INCLUDE TBCOMPNY                                                   
           END-EXEC.                                                            
      *                                                                         
      *****************************************************************         
P00399*    CSS_HOLIDAY J8                                                       
      *****************************************************************         
           EXEC SQL                                                             
              INCLUDE TBHLDAY                                                   
           END-EXEC.                                                            
                                                                        
T34822******************************************************************        
T34822*    CM - CSS_CRED_FORECAST                                               
T34822******************************************************************        
T34822*                                                                         
T34822     EXEC SQL                                                             
T34822          INCLUDE TBCRFCST                                                
T34822     END-EXEC.                                                            
T34822*                                                                         
P00399***************************************************************** 00010000
P00399*  CWSX0010            WS ABEND WORK AREA                       * 00020000
P00399***************************************************************** 00080000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
P00399*****************************************************************         
P00399*  THIS COPYBOOK IS USED FOR DB2 AND CICS ERROR PROCESSING.     *         
P00399*****************************************************************         
           COPY CWS00303.                                                       
      *                                                                         
      ******************************************************************        
      *    WORK AREAS                                                  *        
      ******************************************************************        
                                                                        
                                                                        
       01  MESSAGE-FIELDS.                                              
           05  MSG-TYPE                     PIC S9(9) COMP.             
           05  MSG-SEVERITY                 PIC S9(9) COMP VALUE 11.    
           05  MSG-NR                       PIC S9(9) COMP VALUE  2.    
           05  MSG-RPC                      PIC X(8)  VALUE 'CSR02364'. 
           05  MSG-RPC-L                    PIC S9(9) COMP.             
           05  MSG-TEXT                     PIC X(100).                 
           05  MSG-TEXT-L                   PIC S9(9) COMP.             
           05  MSG-SQL-ERROR.                                           
               10  FILLER                   PIC X(10)                   
                                            VALUE 'SQLCODE = '.         
               10  MSG-SQL-ERROR-C          PIC -9(3) DISPLAY.          
               10  FILLER                   PIC X(16)                   
                   VALUE ', ERROR TOKENS: '.                            
               10  MSG-SQL-ERROR-K          PIC X(70).                  
               10  MSG-SQL-ERROR-K-CHARS                                
                                            REDEFINES MSG-SQL-ERROR-K   
                                            OCCURS 70 TIMES             
                                            PIC X.                      
           05  MSG-SQL-ERROR-SS             PIC S9(4) COMP.             
      *                                                                         
      ******************************************************************        
      *    INPUT PARAMETERS                                            *        
      ******************************************************************        
      *                                                                         
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-REV-MONTH-TEMP          PIC X(06).                  
REARCH     05  PARM-REV-MONTH-NO            REDEFINES                   
REARCH               PARM-REV-MONTH-TEMP    PIC 9(06).                  
      *                                                                         
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                     PIC S9(9) COMP.             
           05  SNA-CONNECTION-NAME          PIC X(8)  VALUE SPACES.     
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN                   PIC S9(9) COMP VALUE 1.     
           05  CTR-ROWS                     PIC S9(9) COMP VALUE 0.     
      *                                                                         
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM              PIC S9(9) COMP.             
           05  WRKLEN1                      PIC S9(9) COMP.             
           05  WRKLEN2                      PIC S9(9) COMP.             
           05  WRK-DONE-STATUS              PIC S9(9) COMP.             
                                                                        
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                 PIC X(07) VALUE 'ROWICMS'.       
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02364_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
      ******************************************************************        
      *    RESULT SET FIELDS                                           *        
      ******************************************************************        
      *                                                                         
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE               PIC S9(9) COMP VALUE +0.    
           05  RS-BILL-CYCLE                PIC X(02) VALUE SPACES.     
           05  RS-READ-DATE                 PIC X(10) VALUE SPACES.     
           05  RS-BILL-FROM                 PIC X(10) VALUE SPACES.     
           05  RS-BILL-TO                   PIC X(10) VALUE SPACES.     
           05  RS-MAIL-DATE                 PIC X(10) VALUE SPACES.     
           05  RS-BILL-DUE-DATE             PIC X(10) VALUE SPACES.     
           05  RS-AVOID-LPC-DATE            PIC X(10) VALUE SPACES.     
           05  RS-FIRST-NOTICE-DATE         PIC X(10) VALUE SPACES.     
           05  RS-SECOND-NOTICE-DATE        PIC X(10) VALUE SPACES.     
           05  RS-DNP-DATE                  PIC X(10) VALUE SPACES.     
           05  RS-DUE-EXCEPT                PIC X(10) VALUE SPACES.     
           05  RS-SECOND-EXCEPT             PIC X(10) VALUE SPACES.     
           05  RS-DNP-EXCEPT                PIC X(10) VALUE SPACES.     
T23235     05  RS-SECOND-FIELD-DATE         PIC X(10) VALUE SPACES.     
T28824     05  RS-THIRD-PTY-READ-DT         PIC X(10) VALUE SPACES.     
C32545     05  RS-EXCEPT-IVR-DT             PIC X(10) VALUE SPACES.     
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE                PIC S9(9) COMP VALUE +0.    
REARCH     05  S-BILL-CYCLE                 PIC X(02) VALUE SPACES.     
REARCH     05  S-READ-DATE                  PIC X(10) VALUE SPACES.     
REARCH     05  S-BILL-FROM                  PIC X(10) VALUE SPACES.     
REARCH     05  S-BILL-TO                    PIC X(10) VALUE SPACES.     
REARCH     05  S-MAIL-DATE                  PIC X(10) VALUE SPACES.     
REARCH     05  S-BILL-DUE-DATE              PIC X(10) VALUE SPACES.     
REARCH     05  S-AVOID-LPC-DATE             PIC X(10) VALUE SPACES.     
REARCH     05  S-FIRST-NOTICE-DATE          PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-NOTICE-DATE         PIC X(10) VALUE SPACES.     
REARCH     05  S-DNP-DATE                   PIC X(10) VALUE SPACES.     
REARCH     05  S-DUE-EXCEPT                 PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-EXCEPT              PIC X(10) VALUE SPACES.     
REARCH     05  S-DNP-EXCEPT                 PIC X(10) VALUE SPACES.     
REARCH     05  S-SECOND-FIELD-DATE          PIC X(10) VALUE SPACES.     
T28824     05  S-THIRD-PTY-READ-DT          PIC X(10) VALUE SPACES.     
C32545     05  S-EXCEPT-IVR-DT              PIC X(10) VALUE SPACES.     
      *                                                                         
       01  SWITCHES.                                                    
           05  ALL-DONE-SW                  PIC X VALUE 'N'.            
               88  NOT-ALL-DONE             VALUE 'N'.                  
               88  ALL-DONE                 VALUE 'Y'.                  
           05  SEND-DONE-SW                 PIC X VALUE 'Y'.            
               88  SEND-DONE-ERROR          VALUE 'N'.                  
               88  SEND-DONE-OK             VALUE 'Y'.                  
T23513     05  WS-DATABASE                  PIC 9(01) VALUE ZERO.       
T23513         88  CSR-DATABASE             VALUE 1.                    
T23513         88  SEB-DATABASE             VALUE 2.                    
      *                                                                         
       01  WS-MISC-FIELDS.                                              
REARCH     05  PROGRAM-NAME                 PIC X(8)   VALUE 'CSR02364'.
REARCH     05  WS-SQLSTATE                  PIC X(5)   VALUE SPACES.    
           05  WS-REV-MONTH                 PIC S9(6)  COMP-3 VALUE +0. 
           05  WS-REV-MONTH-NO              PIC 9(6).                   
           05  WS-NEXT-REV-MO               PIC S9(6)  COMP-3 VALUE +0. 
           05  WS-NEXT-NEXT-REV-MO          PIC S9(6)  COMP-3 VALUE +0. 
           05  WS-BILL-CYCLE                PIC X(02)  VALUE SPACES.    
           05  WS-BILL-CYCLE-NO             REDEFINES  WS-BILL-CYCLE    
                                            PIC 9(02).                  
           05  WS-MAX-BILL-CYCLE            PIC X(02).                  
           05  WS-MAX-BILL-CYCLE-NO         REDEFINES WS-MAX-BILL-CYCLE 
                                            PIC 9(02).                  
           05  WS-CREDIT-GROUP              PIC X(01)  VALUE SPACES.    
T23501     05  WS-COMPANY-NO                PIC X(02)  VALUE SPACES.    
           05  WS-MIN-DATE-EXTRACT          PIC X(10)  VALUE SPACES.    
           05  WS-MAX-DATE-EXTRACT          PIC X(10)  VALUE SPACES.    
           05  WS-TARGET-DATE               PIC X(10)  VALUE SPACES.    
T34822     05  WS-NUM-COND                  PIC S9(04) COMP   VALUE +0. 
T34822     05  WS-CFCAST-ROW-COUNT          PIC S9(04) COMP   VALUE +0. 
T34822     05  WS-INDEX                     PIC S9(04) COMP-3 VALUE +0. 
           05  WS-NULL-1                    PIC S9(4)  COMP.            
           05  WS-NULL-2                    PIC S9(4)  COMP.            
T28824     05  WS-NULL-3                    PIC S9(4)  COMP.            
           05  WS-YEAR-MONTH.                                           
               10  WS-YEAR                  PIC 9(04).                  
               10  WS-MONTH                 PIC 9(02).                  
           05  WS-ADJ-DAY                   PIC S9(9)  COMP.            
           05  WS-WORK-DATE                 PIC X(10).                  
T34097     05  WS-HOLIDAY-FL                PIC X(01)  VALUE 'N'.       
T34097     05  WS-HOLIDAY-CNT               PIC S9(04) COMP VALUE 0.    
           05  WS-HOLD-DATE                 PIC X(10).                  
           05  WS-DELINQ-CODE               PIC X(20).                  
COB305     05 WS-DELINQ-VALUE        PIC S9(09) COMP-3 VALUE 0.          
T34097     05  WS-WEEK-DAY                  PIC S9(04) COMP VALUE 0.    
T34097     05  WS-INDX                      PIC S9(04) COMP.            
T34097     05  WS-SEARCH-DATE               PIC X(10)  VALUE SPACES.    
T34097     05  WS-HOLIDAY-TABLE.                                        
T34097         10  WS-HOLIDAY-DT            PIC X(10)                   
T34097              OCCURS 200 TIMES                                    
T34097              INDEXED BY WS-HOLIDAY-INDX.                         
           05  WS-DATE-YYYY-MM-DD.                                      
               10  WS-DATE-YYYY             PIC X(04) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  WS-DATE-MM               PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE SPACES.     
               10  WS-DATE-DD               PIC X(02) VALUE SPACES.     
           05  WS-DATE-MM-DD-YYYY.                                      
               10  WS-DATE2-MM              PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE '/'.        
               10  WS-DATE2-DD              PIC X(02) VALUE SPACES.     
               10  FILLER                   PIC X(01) VALUE '/'.        
               10  WS-DATE2-YYYY            PIC X(04) VALUE SPACES.     
      *                                                                         
       01  WS-DELINQUENCY-WS USAGE COMP-3.                              
T23235     05  WS-DAY-TOTAL-DUE          PIC S9(5) COMP-3 VALUE +0.     
T23235     05  WS-DAY-DUE                PIC S9(5) COMP-3 VALUE +0.     
T23235     05  WS-DAY-DNP                PIC S9(5) COMP-3 VALUE +0.     
T23235     05  WS-DAY-SECOND-MAIL        PIC S9(5) COMP-3 VALUE +0.     
T23235     05  WS-DAY-SECOND-FIELD       PIC S9(5) COMP-3 VALUE +0.     
C32545     05  WS-DAY-EXC-IVR-DATE       PIC S9(5) COMP-3 VALUE +0.     
T26954     05  WS-DAY-BTOTALDUE          PIC S9(5) COMP-3 VALUE +0.     
      *                                                                         
T34822 01  WS-MISC-HOST-VARIABLES.                                      
T34822     05 WS-REVENUE-MONTH1              PIC S9(6)V USAGE COMP-3    
T34822                                       OCCURS 63  TIMES VALUE 0.  
T34822     05 WS-BILL-CYCLE2                 PIC X(02) OCCURS 63 TIMES  
C34822                                                  VALUE SPACES.   
T34822     05 WS-CRED-FORECAST-CD1           PIC X(02) OCCURS 63 TIMES  
C34822                                                  VALUE SPACES.   
T34822     05 WS-CURR-CHG-DUE-DT1            PIC X(10) OCCURS 63 TIMES  
C34822                                                  VALUE SPACES.   
C34822     05 WS-BILL-DT1                    PIC X(10) OCCURS 63 TIMES  
C34822                                                  VALUE SPACES.   
C34822     05 WS-DNP-NOTICE-MAIL-DT1         PIC X(10) OCCURS 63 TIMES  
C34822                                                  VALUE SPACES.   
T34822     05 WS-DNP-DT1                     PIC X(10) OCCURS 63 TIMES  
C34822                                                  VALUE SPACES.   
T34822     05 WS-AVOID-LPC-DT1               PIC X(10) OCCURS 63 TIMES  
C34822                                                  VALUE SPACES.   
                                                                        
T34822 01  WS-CRED-FORECAST-DATA.                                       
T34822     03  WS-CRED-FORECAST                                         
P00599            OCCURS 250 TIMES                                      
T34822            ASCENDING KEY WS-BILL-CYCLE1, WS-BILL-DT              
T34822            INDEXED BY RANGE-INDX.                                
T34822         05  WS-REVENUE-MONTH          PIC S9(6)V USAGE COMP-3    
C34822                                       VALUE 0.                   
C34822         05  WS-BILL-DT                PIC X(10) VALUE SPACES.    
T34822         05  WS-BILL-CYCLE1            PIC X(02) VALUE SPACES.    
T34822         05  WS-CRED-FORECAST-CD       PIC X(02) VALUE SPACES.    
T34822         05  WS-CURR-CHG-DUE-DT        PIC X(10) VALUE SPACES.    
C34822         05  WS-DNP-NOTICE-MAIL-DT     PIC X(10) VALUE SPACES.    
T34822         05  WS-DNP-DT                 PIC X(10) VALUE SPACES.    
T34822         05  WS-AVOID-LPC-DT           PIC X(10) VALUE SPACES.    
                                                                        
       01  WS-WORK-DAY-TABLE.                                           
           05  WS-WORK-DAY-LIST                                         
                  OCCURS 120 TIMES                                      
                  ASCENDING KEY WS-WORK-DAY                             
                  INDEXED BY WD-INDX.                                   
               10  WS-WORK-DAY              PIC X(10).                  
      *                                                                         
       01  LITERALS.                                                    
           05  WS-ARREARS              PIC X(1)  VALUE 'A'.             
           05  WS-BALANCE              PIC X(1)  VALUE 'B'.             
P00453     05  WS-BALANCE-REG          PIC X(1)  VALUE 'F'.             
P00453     05  WS-BALANCE-DEREG        PIC X(1)  VALUE 'G'.             
           05  WS-EXEMPT               PIC X(1)  VALUE 'C'.             
           05  WS-NON-UTILITY          PIC X(1)  VALUE 'D'.             
           05  WS-NEW                  PIC X(1)  VALUE 'N'.             
T23235     05  WS-SCEG                 PIC X(2)  VALUE '01'.            
T23235     05  WS-PSNC                 PIC X(2)  VALUE '26'.            
T34822     05  WS-1                    PIC 9(1)  VALUE 1.               
      *                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-REV-MONTH               PIC X(06).                      
REARCH 01  PARM-BILL-CYCLE              PIC X(02).                      
REARCH 01  PARM-CR-GROUP                PIC X(01).                      
REARCH 01  PARM-COMPANY-NO              PIC X(02).                      
      *                                                                         
           EXEC SQL                                                     
              DECLARE DELINQUENCY_CSR CURSOR FOR                        
                SELECT                                                  
                    DELINQ_CD,                                          
                    DELINQ_VALUE                                        
                FROM                                                    
                    CSS_DELINQUENCY WITH(READUNCOMMITTED)                       
T23501          WHERE COMPANY_NO = :WS-COMPANY-NO                       
T34097          FOR READ ONLY                                          
T34097                                                           
P00399                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE DELINQUENCY_CSR CURSOR FOR                                
MFA-TR*         SELECT                                                          
MFA-TR*             DELINQ_CD,                                                  
MFA-TR*             DELINQ_VALUE                                                
MFA-TR*         FROM                                                            
MFA-TR*             CSS_DELINQUENCY                                             
MFA-TR*         WHERE COMPANY_NO = :WS-COMPANY-NO                               
MFA-TR*         FOR FETCH ONLY                                                  
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7005                                                    
MFA-TR*    END-EXEC.                                                            
      *                                                                         
T34822     EXEC SQL                                                     
T34822        DECLARE CRED-FCAST-CSR CURSOR WITH ROWSET POSITIONING FOR 
T34822          SELECT                                                  
T34822              REVENUE_MONTH                                       
C34822             ,CIS.CHAR2$DATE(BILL_DT,'USA')                               
T34822             ,BILL_CYCLE                                          
T34822             ,CRED_FORECAST_CD                                    
T34822             ,COALESCE(CIS.CHAR2$DATE(CURR_CHG_DUE_DT,'USA'),' ')         
C34822             ,COALESCE(CIS.CHAR2$DATE(
           DNP_NOTICE_MAIL_DT,'USA'),' ')            
T34822             ,COALESCE(CIS.CHAR2$DATE(DNP_DT,'USA'),' ')                  
T34822             ,COALESCE(CIS.CHAR2$DATE(AVOID_LPC_DT,'USA'),' ')            
T34822          FROM                                                    
T34822              CSS_CRED_FORECAST WITH(READUNCOMMITTED)                     
T34822          WHERE REVENUE_MONTH    = :CM-REVENUE-MONTH              
T34822            AND CRED_FORECAST_CD = :CM-CRED-FORECAST-CD           
C34822            AND COMPANY_NO       = :CM-COMPANY-NO                 
T34822           ORDER BY BILL_CYCLE, BILL_DT                           
T34822          FOR READ ONLY                                   
P00399                                                      
T34822     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE CRED-FCAST-CSR CURSOR WITH ROWSET POSITIONING FOR         
MFA-TR*         SELECT                                                          
MFA-TR*             REVENUE_MONTH                                               
MFA-TR*            ,CHAR(BILL_DT,USA)                                           
MFA-TR*            ,BILL_CYCLE                                                  
MFA-TR*            ,CRED_FORECAST_CD                                            
MFA-TR*            ,IFNULL(CHAR(CURR_CHG_DUE_DT,USA),' ')                       
MFA-TR*            ,IFNULL(CHAR(DNP_NOTICE_MAIL_DT,USA),' ')                    
MFA-TR*            ,IFNULL(CHAR(DNP_DT,USA),' ')                                
MFA-TR*            ,IFNULL(CHAR(AVOID_LPC_DT,USA),' ')                          
MFA-TR*         FROM                                                            
MFA-TR*             CSS_CRED_FORECAST                                           
MFA-TR*         WHERE REVENUE_MONTH    = :CM-REVENUE-MONTH                      
MFA-TR*           AND CRED_FORECAST_CD = :CM-CRED-FORECAST-CD                   
MFA-TR*           AND COMPANY_NO       = :CM-COMPANY-NO                         
MFA-TR*          ORDER BY BILL_CYCLE, BILL_DT                                   
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*         QUERYNO 7030                                                    
MFA-TR*    END-EXEC.                                                            
                                                                        
      ***************************************************************   03890000
      *  DECLARATION OF CURSOR TO RETRIEVE HOLIDAY DATES FROM       *   03900000
      *  CSS_HOLIDAY.                                               *   03910000
      ***************************************************************   03920000
      *                                                                 03921000
T34097     EXEC SQL                                                     
T34097        DECLARE HOLIDAY_CURSOR CURSOR WITH ROWSET POSITIONING FOR 
T34097        SELECT J8.HOLIDAY_DT                                      
T34097          FROM CSS_HOLIDAY J8 WITH(READUNCOMMITTED)                       
T34097         FOR READ ONLY                                    
P00399                                                      
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DECLARE HOLIDAY_CURSOR CURSOR WITH ROWSET POSITIONING FOR 03940000
MFA-TR*       SELECT J8.HOLIDAY_DT                                              
MFA-TR*         FROM CSS_HOLIDAY J8                                             
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*        QUERYNO 7061                                                     
MFA-TR*    END-EXEC.                                                            
      *                                                                         
HPCCDM*EJECT                                                                    
REARCH PROCEDURE DIVISION USING PARM-REV-MONTH                          
REARCH                         ,PARM-BILL-CYCLE                         
REARCH                         ,PARM-CR-GROUP                           
REARCH                         ,PARM-COMPANY-NO.                        
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
      *                                                                         
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2200-PROCESS-OUTPUT THRU 2200-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
      *                                                                         
       0000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      *                                                                *        
      *     1. RESET DB2 ERROR HANDLERS                                *        
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       0100-INITIALIZE.                                                 
      *                                                                         
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
      *                                                                         
REARCH     PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
      *                                                                         
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR                             
T34097         WITH ROWSET POSITIONING FOR                              
REARCH         SELECT                                                   
REARCH             *                                                    
REARCH         FROM                                                     
REARCH             #CSR02364_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN                                    
MFA-TR*        WITH ROWSET POSITIONING FOR                                      
MFA-TR*        SELECT                                                           
MFA-TR*            *                                                            
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02364_R1                                          
MFA-TR*    END-EXEC.                                                            
C34822     INITIALIZE WS-MISC-HOST-VARIABLES                            
C34822                WS-CRED-FORECAST-DATA.                            
                                                                        
T34097     PERFORM 0115-LOAD-HOLIDAY-TABLE    THRU 0115-EXIT.           
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH*                                                                *        
REARCH*     DECLARING GLOBAL TEMPORARY TABLE AND CHECKING TO DELETE    *        
REARCH*     GTT ROWS IF IT EXISTS.                                     *        
REARCH*                                                                *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE                                                         
REARCH     'DECLARE GLOBAL TEMPORARY TABLE CSR02364_R1'                 
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH*                                                                         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02364_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02364_R1
              (                                                        
REARCH              RETURN_CODE               INT                   
REARCH             ,BILL_CYCLE CHAR(02)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,READ_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,BILL_FROM CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,BILL_TO CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2           
REARCH             ,MAIL_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH             ,BILL_DUE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH             ,AVOID_LPC_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH             ,FIRST_NOTICE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH             ,SECOND_NOTICE_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH             ,DNP_DATE CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH             ,DUE_EXCEPT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,SECOND_EXCEPT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH             ,DNP_EXCEPT CHAR(10)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH             ,SECOND_FIELD_DATE CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
T28824             ,THIRD_PTY_READ_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
C32545             ,EXCEPT_IVR_DT CHAR(10)  COLLATE 
                                 LATIN1_GENERAL_100_BIN2                  
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH         IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL               
REARCH         OR WS-SQLSTATE = '42710'                                 
REARCH             NEXT SENTENCE                                        
REARCH         ELSE                                                     
REARCH             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
REARCH             MOVE '0100A'          TO ACTIVE-PARAGRAPH            
REARCH             MOVE 'DECLARE GTT'    TO ABEND-FUNCTION              
REARCH             MOVE SPACES           TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH             MOVE SQLCODE          TO ABEND-SQLCODE               
REARCH             MOVE SQLSTATE         TO ABEND-SQLSTATE              
REARCH             MOVE 'CSR02364_R1'    TO TABLE-1                     
REARCH             MOVE SPACES           TO TABLE-ELEMENT-1             
REARCH             MOVE SPACES           TO HOSTVAR-ELEMENT-1           
REARCH             PERFORM 9900-SQL-ERROR-ROUTINE                       
REARCH                                   THRU  9900-EXIT                
REARCH         END-IF.                                                  
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH*                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      *****************************************************************         
      *0115-LOAD-HOLIDAY-TABLE.                                       *         
      *POPULATE HOLIDAY TEMP TABLE (WS-HOLIDAY-TABLE)                 * 08982000
      *                                                               *         
      *****************************************************************         
T34097 0115-LOAD-HOLIDAY-TABLE.                                         
T34097*                                                                         
T34097     INITIALIZE  WS-HOLIDAY-TABLE.                                
T34097     MOVE '01' TO J8-COMPANY-NO                                   
T34097     PERFORM     7061-OPEN-HOLIDAY-CURSOR    THRU 7061-EXIT.      
T34097     SET         WS-HOLIDAY-INDX             TO   1.              
T34097     PERFORM     7062-FETCH-HOLIDAY-CURSOR   THRU 7062-EXIT.      
T34097     PERFORM     7063-CLOSE-HOLIDAY-CURSOR   THRU 7063-EXIT.      
T34097*                                                                         
T34097 0115-EXIT.                                                       
T34097     EXIT.                                                        
      *                                                                         
T34097***************************************************************** 08921000
T34097* 0145-CHECK-HOLIDAY-TABLE.                                     * 08923000
T34097* INPUT : WS-SEARCH-DATE, WS-WEEK-DAY                           * 08923100
T34097* CHECKS IF WS-SEARCH-DATE IS A HOLIDAY AND SETS WS-HOLIDAY-FL  * 08924000
T34097* OUTPUT: WS-HOLIDAY-FL                                         * 08924000
T34097***************************************************************** 08925000
T34097 0145-CHECK-HOLIDAY-TABLE.                                        
T34097     IF  WS-WEEK-DAY >= 1 AND WS-WEEK-DAY <= 5                    
T34097        SET WS-HOLIDAY-INDX     TO 1                              
T34097        SEARCH WS-HOLIDAY-DT VARYING WS-HOLIDAY-INDX              
T34097           AT END                                                 
T34097                MOVE 'N'        TO WS-HOLIDAY-FL                  
T34097           WHEN WS-HOLIDAY-DT(WS-HOLIDAY-INDX) = WS-SEARCH-DATE   
T34097                MOVE 'Y'        TO WS-HOLIDAY-FL                  
T34097        END-SEARCH                                                
T34097     ELSE                                                         
T34097         MOVE 'Y'               TO WS-HOLIDAY-FL                  
T34097     END-IF.                                                      
T34097 0145-EXIT.                                                       
T34097     EXIT.                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      *                                                                *        
      *     1. RECEIVE EACH PARAMETER FROM THE REMOTE PROCEDURE        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       1000-PROCESS-INPUT.                                              
      *                                                                         
REARCH     MOVE PARM-REV-MONTH             TO PARM-REV-MONTH-TEMP.      
           MOVE PARM-REV-MONTH-NO          TO WS-REV-MONTH              
                                              WS-REV-MONTH-NO.          
           MOVE PARM-BILL-CYCLE            TO WS-BILL-CYCLE.            
           MOVE PARM-CR-GROUP              TO WS-CREDIT-GROUP.          
           MOVE PARM-COMPANY-NO            TO WS-COMPANY-NO.            
      *                                                                         
       1000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE           TO S-RETURN-CODE.             
REARCH     MOVE  RS-BILL-CYCLE            TO S-BILL-CYCLE.              
REARCH     MOVE  RS-READ-DATE             TO S-READ-DATE.               
REARCH     MOVE  RS-BILL-FROM             TO S-BILL-FROM.               
REARCH     MOVE  RS-BILL-TO               TO S-BILL-TO.                 
REARCH     MOVE  RS-MAIL-DATE             TO S-MAIL-DATE.               
REARCH     MOVE  RS-BILL-DUE-DATE         TO S-BILL-DUE-DATE.           
REARCH     MOVE  RS-AVOID-LPC-DATE        TO S-AVOID-LPC-DATE.          
REARCH     MOVE  RS-FIRST-NOTICE-DATE     TO S-FIRST-NOTICE-DATE.       
REARCH     MOVE  RS-SECOND-NOTICE-DATE    TO S-SECOND-NOTICE-DATE.      
REARCH     MOVE  RS-DNP-DATE              TO S-DNP-DATE.                
REARCH     MOVE  RS-DUE-EXCEPT            TO S-DUE-EXCEPT.              
REARCH     MOVE  RS-SECOND-EXCEPT         TO S-SECOND-EXCEPT.           
REARCH     MOVE  RS-DNP-EXCEPT            TO S-DNP-EXCEPT.              
REARCH     MOVE  RS-SECOND-FIELD-DATE     TO S-SECOND-FIELD-DATE.       
T28824     MOVE  RS-THIRD-PTY-READ-DT     TO S-THIRD-PTY-READ-DT.       
C32545     MOVE  RS-EXCEPT-IVR-DT         TO S-EXCEPT-IVR-DT.           
REARCH*                                                                         
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * 2200-PROCESS-OUTPUT                                            *        
      *                                                                *        
      *     PROCESS THE RESULTS                                        *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       2200-PROCESS-OUTPUT.                                             
      *                                                                         
           MOVE WS-REV-MONTH          TO BN-REVENUE-MONTH               
                                         RW-REVENUE-MONTH.              
      *                                                                         
           PERFORM 2205-LOAD-DELINQ-VALUES            THRU 2205-EXIT.   
      *                                                                         
T23235     PERFORM 2206-VERIFY-DELINQ-VALUES THRU 2206-EXIT.            
      *                                                                         
           PERFORM 2210-LOAD-WORK-DAYS                THRU 2210-EXIT.   
      *                                                                         
           IF WS-BILL-CYCLE = '00'                                      
              PERFORM 7015-SELECT-BILL-CYCLES         THRU 7015-EXIT    
T23513        IF SEB-DATABASE                                           
T21340           IF WS-MAX-BILL-CYCLE-NO > 21                           
T21340               MOVE '21'           TO WS-MAX-BILL-CYCLE           
T21340           END-IF                                                 
T21340        ELSE                                                      
T21340           IF WS-MAX-BILL-CYCLE-NO > 20                           
T21340               MOVE '20'           TO WS-MAX-BILL-CYCLE           
T21340           END-IF                                                 
              END-IF                                                    
           ELSE                                                         
              MOVE WS-BILL-CYCLE      TO WS-MAX-BILL-CYCLE              
           END-IF.                                                      
      *                                                                         
           EVALUATE TRUE                                                
             WHEN WS-CREDIT-GROUP = WS-NEW                              
P00399       WHEN WS-CREDIT-GROUP = WS-ARREARS                          
                 PERFORM 2400-FORECASTING-NEW-ARR  THRU 2400-EXIT       
                  UNTIL (WS-BILL-CYCLE-NO > WS-MAX-BILL-CYCLE-NO)       
      *                                                                         
             WHEN WS-CREDIT-GROUP = WS-EXEMPT                           
                 PERFORM 2500-FORECASTING-EXEMPT      THRU 2500-EXIT    
                  UNTIL (WS-BILL-CYCLE-NO > WS-MAX-BILL-CYCLE-NO)       
      *                                                                         
P00453       WHEN WS-CREDIT-GROUP = WS-BALANCE OR WS-BALANCE-REG OR     
P00453                              WS-BALANCE-DEREG                    
T26954           IF SEB-DATABASE                                        
T34822              MOVE  PARM-REV-MONTH   TO CM-REVENUE-MONTH          
P00453              IF WS-CREDIT-GROUP = WS-BALANCE-REG OR WS-BALANCE   
P00453                 MOVE   'A'          TO CM-CRED-FORECAST-CD       
P00453              ELSE                                                
P00453                 MOVE   'B'          TO CM-CRED-FORECAST-CD       
P00453              END-IF                                              
C34822              MOVE  WS-COMPANY-NO    TO CM-COMPANY-NO             
C34822              IF PARM-BILL-CYCLE = '00'                           
T34822                 SET RANGE-INDX      TO 1                         
T34822                 MOVE 1              TO WS-INDEX                  
T34822                 PERFORM 2640-LOAD-CRED-FORECAST THRU 2640-EXIT   
C34822              ELSE                                                
C34822                 MOVE WS-BILL-CYCLE   TO CM-BILL-CYCLE            
C34822                 PERFORM 7050-SELECT-CRED-FORECAST                
C34822                                                 THRU 7050-EXIT   
C34822              END-IF                                              
T26954              PERFORM 2650-FORECAST-BALANCE-SEBR THRU 2650-EXIT   
T26954               UNTIL (WS-BILL-CYCLE-NO > WS-MAX-BILL-CYCLE-NO)    
T26954           ELSE                                                   
                    PERFORM 2600-FORECASTING-BALANCE     THRU 2600-EXIT 
                     UNTIL (WS-BILL-CYCLE-NO > WS-MAX-BILL-CYCLE-NO)    
T26954           END-IF                                                 
      *                                                                         
             WHEN WS-CREDIT-GROUP = WS-NON-UTILITY                      
                 PERFORM 2700-FORECASTING-NON-UTIL    THRU 2700-EXIT    
                  UNTIL (WS-BILL-CYCLE-NO > WS-MAX-BILL-CYCLE-NO)       
      *                                                                         
           END-EVALUATE.                                                
      *                                                                         
           MOVE ZERO                  TO RS-RETURN-CODE.                
      *                                                                         
           IF CTR-ROWS = ZERO                                           
               MOVE NOT-FOUND         TO RS-RETURN-CODE                 
REARCH         PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT   
               PERFORM 8100-SEND-RESULT               THRU 8100-EXIT    
           END-IF.                                                      
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      *************************************************************             
      *                                                           *             
      *      2205-LOAD-DELINQ-VALUES                              *             
      *                                                           *             
      *                                                           *             
      *************************************************************             
      *                                                                         
       2205-LOAD-DELINQ-VALUES.                                         
      *                                                                         
           PERFORM 7005-OPEN-DELINQ-CSR               THRU 7005-EXIT.   
           PERFORM 7006-FETCH-DELINQ-CSR              THRU 7006-EXIT.   
      *                                                                         
T23235     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T23235        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
T23235        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
T23235        MOVE '7006'                 TO ACTIVE-PARAGRAPH           
T23235        MOVE 'FETCH'                TO ABEND-FUNCTION             
T23235        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
T23235                                       ABEND-TABLES               
T23235        MOVE 'CSS_DELINQUENCY'      TO TABLE-1                    
T23235        MOVE 'WS-COMPANY-NO'        TO TABLE-ELEMENT-1            
T23235        MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
T23235        PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
T23235        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
T23235     END-IF.                                                      
      *                                                                         
           PERFORM UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND              
              MOVE C8-DELINQ-CD    TO WS-DELINQ-CODE                    
              MOVE C8-DELINQ-VALUE TO WS-DELINQ-VALUE                   
                                                                        
              EVALUATE WS-DELINQ-CODE                                   
T23235          WHEN 'DAY-SECOND-MAIL'                                  
T23235             MOVE WS-DELINQ-VALUE TO WS-DAY-SECOND-MAIL           
T23235          WHEN 'DAY-SECOND-FIELD'                                 
T23235             MOVE WS-DELINQ-VALUE TO WS-DAY-SECOND-FIELD          
C32545          WHEN 'DAY-BSECIVREXC'                                   
C32545             MOVE WS-DELINQ-VALUE TO WS-DAY-EXC-IVR-DATE          
T23235          WHEN 'DAY-TOTAL-DUE'                                    
T23235             MOVE WS-DELINQ-VALUE TO WS-DAY-TOTAL-DUE             
T23235          WHEN 'DAY-DNP'                                          
T23235             MOVE WS-DELINQ-VALUE TO WS-DAY-DNP                   
T23235          WHEN 'DAY-DUE'                                          
T23235             MOVE WS-DELINQ-VALUE TO WS-DAY-DUE                   
T23513          WHEN 'DATABASE'                                         
T23513             MOVE WS-DELINQ-VALUE TO WS-DATABASE                  
T26954          WHEN 'DAY-BTOTALDUE'                                    
T26954             MOVE WS-DELINQ-VALUE TO WS-DAY-BTOTALDUE             
               END-EVALUATE                                             
      *                                                                         
               PERFORM 7006-FETCH-DELINQ-CSR          THRU 7006-EXIT    
           END-PERFORM.                                                 
      *                                                                         
           PERFORM 7007-CLOSE-DELINQ-CSR              THRU 7007-EXIT.   
      *                                                                         
       2205-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *************************************************************             
      *      2206-VERIFY-DELINQ-VALUES                            *             
      *************************************************************             
T23235 2206-VERIFY-DELINQ-VALUES.                                       
T23235     IF        WS-DAY-DUE                       > ZERO            
T23235           AND WS-DAY-DNP                       > ZERO            
T23235           AND WS-DAY-SECOND-MAIL               > ZERO            
T23235        NEXT SENTENCE                                             
T23235     ELSE                                                         
T23235        MOVE '12'                   TO WS-ACTIVE-RETURN-CODE      
T23235                                       SQLCODE                    
T23235        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
T23235        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
T23235        MOVE '2206'                 TO ACTIVE-PARAGRAPH           
T23235        MOVE 'DELINQER'             TO ABEND-FUNCTION             
T23235        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
T23235                                       ABEND-TABLES               
T23235        MOVE 'WS-COMPANY-NO'        TO TABLE-ELEMENT-1            
T23235        MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
T23235        PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
T23235        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
T23235     END-IF.                                                      
T23235 2206-EXIT.                                                       
T23235      EXIT.                                                       
      *                                                                         
      *************************************************************             
      *                                                           *             
      *      2210-LOAD-WORK-DAYS                                  *             
      *                                                           *             
      * LOAD NEXT 4 MONTHS WORK DAYS INTO TABLE FROM FIRST DATE   *             
      * OF REVENUE MONTH.  NEEDED FOR FORECASTING. ENTRY 001 IS   *             
      * THE OPEN DAY OF THE REVENUE MONTH.  1 THROUGH 120 ENTRIES *             
      * WILL EXIST.                                               *             
      *                                                           *             
      *************************************************************             
      *                                                                         
       2210-LOAD-WORK-DAYS.                                             
      *                                                                         
           PERFORM 7000-SELECT-MIN-DT-EXTRACT         THRU 7000-EXIT.   
      *                                                                         
           SET WD-INDX TO 1.                                            
           MOVE WS-MIN-DATE-EXTRACT  TO WS-DATE-YYYY-MM-DD.             
      *                                                                         
           MOVE WS-DATE-YYYY         TO WS-DATE2-YYYY.                  
           MOVE WS-DATE-MM           TO WS-DATE2-MM.                    
           MOVE WS-DATE-DD           TO WS-DATE2-DD.                    
      *                                                                         
           MOVE WS-DATE-MM-DD-YYYY   TO WS-WORK-DAY (WD-INDX).          
      *                                                                         
           SET WD-INDX               TO 2.                              
           MOVE 1                    TO WS-ADJ-DAY.                     
      *                                                                         
           PERFORM UNTIL WD-INDX > 120                                  
              OR WS-ADJ-DAY > 365                                       
      *                                                                         
              PERFORM 7010-GET-NEXT-WORK-DAY    THRU   7010-EXIT        
              MOVE    WS-WORK-DATE          TO WS-SEARCH-DATE           
T34097        PERFORM 0145-CHECK-HOLIDAY-TABLE  THRU   0145-EXIT        
      *                                                                         
T34097        IF  WS-HOLIDAY-FL  = 'N'                                  
T34097            MOVE WS-WORK-DATE         TO WS-DATE-YYYY-MM-DD       
      *                                                                         
T34097            MOVE WS-DATE-YYYY         TO WS-DATE2-YYYY            
T34097            MOVE WS-DATE-MM           TO WS-DATE2-MM              
T34097            MOVE WS-DATE-DD           TO WS-DATE2-DD              
      *                                                                         
T34097            MOVE WS-DATE-MM-DD-YYYY   TO WS-WORK-DAY (WD-INDX)    
T34097            SET  WD-INDX UP BY 1                                  
T34097        END-IF                                                    
T34097        ADD  1                    TO WS-ADJ-DAY                   
T34097     END-PERFORM.                                                 
      *                                                                         
           MOVE WS-REV-MONTH-NO      TO WS-YEAR-MONTH.                  
      *                                                                         
           ADD 1                     TO WS-MONTH.                       
           IF WS-MONTH = 13                                             
               MOVE 1                TO WS-MONTH                        
               ADD  1                TO WS-YEAR                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-YEAR-MONTH        TO WS-REV-MONTH-NO.                
           MOVE WS-REV-MONTH-NO      TO WS-NEXT-REV-MO.                 
      *                                                                         
           ADD 1                     TO WS-MONTH.                       
           IF WS-MONTH = 13                                             
               MOVE 1                TO WS-MONTH                        
               ADD  1                TO WS-YEAR                         
           END-IF.                                                      
      *                                                                         
           MOVE WS-YEAR-MONTH        TO WS-REV-MONTH-NO.                
           MOVE WS-REV-MONTH-NO      TO WS-NEXT-NEXT-REV-MO.            
      *                                                                         
       2210-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
P00399* 2400-FORECASTING-NEW-ARR                                                
      *                                                                         
      * FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
P00399* WITH CREDIT GROUP EQUAL TO NEW OR ARREARS.                              
      *                                                                         
      ******************************************************************        
      *                                                                         
P00399 2400-FORECASTING-NEW-ARR.                                        
      *                                                                         
           MOVE WS-BILL-CYCLE         TO RS-BILL-CYCLE.                 
      *                                                                         
           MOVE WS-REV-MONTH          TO BN-REVENUE-MONTH               
                                         RW-REVENUE-MONTH.              
      *                                                                         
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
           MOVE WS-MIN-DATE-EXTRACT   TO RS-BILL-FROM.                  
           MOVE WS-MAX-DATE-EXTRACT   TO RS-BILL-TO.                    
      *                                                                         
           MOVE WS-MAX-DATE-EXTRACT   TO WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-DUE.                                
           MOVE WS-WORK-DAY (WD-INDX) TO RS-MAIL-DATE.                  
      *                                                                         
           PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
           MOVE RW-OPTIMUM-READ-DATE  TO RS-READ-DATE.                  
T28824     MOVE RW-THIRD-PTY-READ-DT  TO RS-THIRD-PTY-READ-DT.          
      *                                                                         
           MOVE WS-NEXT-REV-MO        TO BN-REVENUE-MONTH.              
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
      *                                                                         
           MOVE WS-MIN-DATE-EXTRACT   TO RS-AVOID-LPC-DATE.             
      *                                                                         
           MOVE WS-MAX-DATE-EXTRACT   TO WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-DUE.                                
           MOVE WS-WORK-DAY (WD-INDX) TO RS-FIRST-NOTICE-DATE.          
P00399     PERFORM 2900-GET-BILL-CLOSE-DATE THRU 2900-EXIT.             
P00399     SET WD-INDX UP BY WS-DAY-DNP.                                
P00399     MOVE WS-WORK-DAY(WD-INDX) TO RS-DNP-DATE.                    
T23235                                                                  
P00399     IF CSR-DATABASE                                              
T23235        SET WD-INDX DOWN BY WS-DAY-SECOND-FIELD                   
T23235        MOVE WS-WORK-DAY(WD-INDX) TO RS-SECOND-FIELD-DATE         
T23235        SET WD-INDX UP BY WS-DAY-SECOND-FIELD                     
P00399     END-IF.                                                      
T23235                                                                  
P00399     SET WD-INDX DOWN BY WS-DAY-SECOND-MAIL.                      
P00399     MOVE WS-WORK-DAY (WD-INDX) TO RS-SECOND-NOTICE-DATE.         
           MOVE WS-NEXT-REV-MO        TO RW-REVENUE-MONTH.              
           PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
      *                                                                         
           MOVE RW-OPTIMUM-READ-DATE  TO WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     IF WS-COMPANY-NO = WS-PSNC                                   
T23235        MOVE RW-OPTIMUM-READ-DATE TO RS-BILL-DUE-DATE             
T23235     ELSE                                                         
T23235        SET WD-INDX DOWN BY WS-DAY-TOTAL-DUE                      
              MOVE WS-WORK-DAY (WD-INDX) TO RS-BILL-DUE-DATE            
T23235        SET WD-INDX UP BY WS-DAY-TOTAL-DUE                        
T23235     END-IF.                                                      
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
           PERFORM 8100-SEND-RESULT                   THRU 8100-EXIT.   
      *                                                                         
           ADD 1                        TO WS-BILL-CYCLE-NO.            
           MOVE WS-BILL-CYCLE-NO        TO WS-BILL-CYCLE.               
      *                                                                         
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      * 2500-FORECASTING-EXEMPT                                                 
      *                                                                         
      * FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
      * WITH CREDIT GROUP EQUAL TO NEW.                                         
      *                                                                         
      ******************************************************************        
      *                                                                         
       2500-FORECASTING-EXEMPT.                                         
      *                                                                         
           MOVE WS-BILL-CYCLE         TO RS-BILL-CYCLE.                 
      *                                                                         
           MOVE WS-REV-MONTH          TO BN-REVENUE-MONTH               
                                         RW-REVENUE-MONTH.              
      *                                                                         
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
           MOVE WS-MIN-DATE-EXTRACT   TO RS-BILL-FROM.                  
           MOVE WS-MAX-DATE-EXTRACT   TO RS-BILL-TO.                    
      *                                                                         
           MOVE WS-MAX-DATE-EXTRACT   TO WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-DUE.                                
           MOVE WS-WORK-DAY (WD-INDX) TO RS-MAIL-DATE.                  
      *                                                                         
           PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
           MOVE RW-OPTIMUM-READ-DATE  TO RS-READ-DATE.                  
T28824     MOVE RW-THIRD-PTY-READ-DT  TO RS-THIRD-PTY-READ-DT.          
      *                                                                         
           MOVE WS-NEXT-REV-MO        TO BN-REVENUE-MONTH.              
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
      *                                                                         
           MOVE WS-MIN-DATE-EXTRACT   TO RS-AVOID-LPC-DATE              
      *                                                                         
           MOVE WS-NEXT-REV-MO        TO RW-REVENUE-MONTH.              
           PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
      *                                                                         
           MOVE RW-OPTIMUM-READ-DATE  TO WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     IF WS-COMPANY-NO = WS-PSNC                                   
T23235        MOVE RW-OPTIMUM-READ-DATE TO RS-BILL-DUE-DATE             
T23235     ELSE                                                         
T23235        SET WD-INDX DOWN BY WS-DAY-TOTAL-DUE                      
              MOVE WS-WORK-DAY (WD-INDX) TO RS-BILL-DUE-DATE            
T23235     END-IF.                                                      
      *                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
           PERFORM 8100-SEND-RESULT                   THRU 8100-EXIT.   
      *                                                                         
           ADD 1                        TO WS-BILL-CYCLE-NO.            
           MOVE WS-BILL-CYCLE-NO        TO WS-BILL-CYCLE.               
      *                                                                         
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      *                                                                         
      * 2600-FORECASTING-BALANCE                                                
      *                                                                         
      * FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
      * WITH CREDIT GROUP EQUAL TO NEW.                                         
      *                                                                         
      ******************************************************************        
      *                                                                         
       2600-FORECASTING-BALANCE.                                        
      *                                                                         
           MOVE WS-BILL-CYCLE         TO RS-BILL-CYCLE.                 
      *                                                                         
           MOVE WS-REV-MONTH          TO BN-REVENUE-MONTH               
                                         RW-REVENUE-MONTH.              
      *                                                                         
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
           MOVE WS-MIN-DATE-EXTRACT   TO RS-BILL-FROM.                  
           MOVE WS-MAX-DATE-EXTRACT   TO RS-BILL-TO.                    
      *                                                                         
           MOVE WS-MAX-DATE-EXTRACT   TO WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-DUE.                                
           MOVE WS-WORK-DAY (WD-INDX) TO RS-FIRST-NOTICE-DATE           
                                         RS-MAIL-DATE.                  
      *                                                                         
           PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
           MOVE RW-OPTIMUM-READ-DATE  TO RS-READ-DATE.                  
T28824     MOVE RW-THIRD-PTY-READ-DT  TO RS-THIRD-PTY-READ-DT.          
      *                                                                         
           MOVE WS-NEXT-REV-MO        TO RW-REVENUE-MONTH.              
           PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
      *                                                                         
           MOVE RW-OPTIMUM-READ-DATE  TO RS-DNP-DATE                    
                                         WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
C32545     IF CSR-DATABASE AND WS-COMPANY-NO = WS-SCEG                  
C32545        SET WD-INDX DOWN BY WS-DAY-SECOND-FIELD                   
C32545        MOVE WS-WORK-DAY(WD-INDX) TO RS-SECOND-FIELD-DATE         
C32545        SET WD-INDX UP BY WS-DAY-SECOND-FIELD                     
C32545     END-IF.                                                      
      *                                                                         
T23235     SET WD-INDX DOWN BY WS-DAY-TOTAL-DUE.                        
           MOVE WS-WORK-DAY (WD-INDX) TO RS-BILL-DUE-DATE.              
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-TOTAL-DUE.                          
T23235     SET WD-INDX DOWN BY WS-DAY-SECOND-MAIL.                      
           MOVE WS-WORK-DAY (WD-INDX) TO RS-SECOND-NOTICE-DATE.         
      *                                                                         
           MOVE WS-NEXT-REV-MO   TO BN-REVENUE-MONTH.                   
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
      *                                                                         
           MOVE WS-MAX-DATE-EXTRACT   TO WS-TARGET-DATE.                
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-DNP.                                
           MOVE WS-WORK-DAY (WD-INDX) TO RS-DNP-EXCEPT.                 
      *                                                                         
C32545     IF CSR-DATABASE AND WS-COMPANY-NO = WS-SCEG                  
C32545        SET WD-INDX DOWN BY WS-DAY-EXC-IVR-DATE                   
C32545        MOVE WS-WORK-DAY(WD-INDX) TO RS-EXCEPT-IVR-DT             
C32545        SET WD-INDX UP BY WS-DAY-EXC-IVR-DATE                     
C32545     END-IF                                                       
      *                                                                         
T23235     SET WD-INDX DOWN BY WS-DAY-SECOND-MAIL.                      
           MOVE WS-WORK-DAY (WD-INDX) TO RS-SECOND-EXCEPT.              
      *                                                                         
T23235     SET WD-INDX DOWN BY WS-DAY-DUE.                              
           MOVE WS-WORK-DAY (WD-INDX) TO RS-DUE-EXCEPT.                 
      *                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
           PERFORM 8100-SEND-RESULT                   THRU 8100-EXIT.   
      *                                                                         
           ADD 1                        TO WS-BILL-CYCLE-NO.            
           MOVE WS-BILL-CYCLE-NO        TO WS-BILL-CYCLE.               
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T34822*************************************************************             
T34822*                                                           *             
T34822*      2640-LOAD-CRED-FORECAST                              *             
T34822*                                                           *             
T34822*                                                           *             
T34822*************************************************************             
T34822*                                                                         
T34822 2640-LOAD-CRED-FORECAST.                                         
T34822*                                                                         
T34822     PERFORM 7030-OPEN-CRED-FORECAST-CSR        THRU 7030-EXIT.   
T34822     PERFORM 7035-FETCH-CRED-FORECAST-CSR       THRU 7035-EXIT.   
T34822     MOVE   1               TO WS-INDEX                           
T34822     PERFORM 2950-LOAD-CURR-CRED-FCAST-TBL      THRU 2950-EXIT    
C34822       UNTIL WS-INDEX > WS-CFCAST-ROW-COUNT                       
C34822          OR WS-REVENUE-MONTH1 (WS-INDEX) = 0                     
C34822     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
C34822         INITIALIZE WS-MISC-HOST-VARIABLES                        
T34822         PERFORM 7035-FETCH-CRED-FORECAST-CSR   THRU 7035-EXIT    
T34822         MOVE   1           TO WS-INDEX                           
T34822         PERFORM 2950-LOAD-CURR-CRED-FCAST-TBL  THRU 2950-EXIT    
C34822           UNTIL WS-INDEX > WS-CFCAST-ROW-COUNT                   
C34822              OR WS-REVENUE-MONTH1 (WS-INDEX) = 0                 
C34822     END-IF.                                                      
T34822     PERFORM 7040-CLOSE-CRED-FORECAST-CSR       THRU 7040-EXIT.   
T34822*                                                                         
T34822 2640-EXIT.                                                       
T34822     EXIT.                                                        
T34822*                                                                         
T26954******************************************************************        
T26954*                                                                         
T26954* 2650-FORECAST-BALANCE-SEBR                                              
T26954*                                                                         
T26954* FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
T26954* WITH CREDIT GROUP EQUAL TO BALANCE                                      
T26954*                                                                         
T26954******************************************************************        
T26954*                                                                         
T26954 2650-FORECAST-BALANCE-SEBR.                                      
T26954*                                                                         
T26954     MOVE WS-BILL-CYCLE         TO RS-BILL-CYCLE.                 
T26954*                                                                         
T26954     MOVE WS-REV-MONTH          TO BN-REVENUE-MONTH               
T26954                                   RW-REVENUE-MONTH.              
T26954*                                                                         
T26954     PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
T26954     MOVE WS-MIN-DATE-EXTRACT   TO RS-BILL-FROM.                  
T26954     MOVE WS-MAX-DATE-EXTRACT   TO RS-BILL-TO.                    
T26954*                                                                         
T26954     MOVE WS-MAX-DATE-EXTRACT   TO WS-TARGET-DATE.                
T26954     PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
T26954*                                                                         
T26954     SET WD-INDX UP BY WS-DAY-DUE.                                
T26954     MOVE WS-WORK-DAY (WD-INDX) TO RS-MAIL-DATE                   
T26954                                   RS-FIRST-NOTICE-DATE.          
T26954*                                                                         
T26954     PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
T26954     MOVE RW-OPTIMUM-READ-DATE  TO RS-READ-DATE.                  
T28824     MOVE RW-THIRD-PTY-READ-DT  TO RS-THIRD-PTY-READ-DT.          
C34822* WHEN CALLED FROM STA PANEL300 AT-BILL-CYCLE IS PASSED                   
C34822     IF PARM-BILL-CYCLE = '00'                                    
T34822        PERFORM 2850-SEARCH-FOR-BILL-CYCLE THRU 2850-EXIT         
T34822        VARYING RANGE-INDX FROM 1 BY 1                            
P00599          UNTIL RANGE-INDX > 250                                  
C34822             OR WS-BILL-CYCLE1 (RANGE-INDX) > WS-BILL-CYCLE       
C34822             OR WS-REVENUE-MONTH (RANGE-INDX) = 0                 
T34822        SET RANGE-INDX TO 1                                       
C34822     ELSE                                                         
C34822        MOVE CM-BILL-DT            TO RS-MAIL-DATE                
C34822        MOVE CM-CURR-CHG-DUE-DT    TO RS-BILL-DUE-DATE            
C34822        MOVE CM-DNP-NOTICE-MAIL-DT TO RS-SECOND-NOTICE-DATE       
C34822        MOVE CM-DNP-DT             TO RS-DNP-DATE                 
C34822        MOVE CM-AVOID-LPC-DT       TO RS-AVOID-LPC-DATE           
C34822        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
C34822        PERFORM 8100-SEND-RESULT   THRU 8100-EXIT                 
C34822     END-IF.                                                      
T26954     ADD 1                        TO WS-BILL-CYCLE-NO.            
T26954     MOVE WS-BILL-CYCLE-NO        TO WS-BILL-CYCLE.               
T26954*                                                                         
T26954 2650-EXIT.                                                       
T26954     EXIT.                                                        
T26954*                                                                         
      ******************************************************************        
      *                                                                         
      * 2700-FORECASTING-NON-UTIL                                               
      *                                                                         
      * FORECASTS THE BILLING AND COLLECTION INFORMATION FOR ACCOUNTS           
      * WITH CREDIT GROUP EQUAL TO NEW.                                         
      *                                                                         
      ******************************************************************        
      *                                                                         
       2700-FORECASTING-NON-UTIL.                                       
      *                                                                         
           MOVE WS-BILL-CYCLE           TO RS-BILL-CYCLE.               
      *                                                                         
           MOVE WS-REV-MONTH          TO BN-REVENUE-MONTH               
                                         RW-REVENUE-MONTH.              
      *                                                                         
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
           MOVE WS-MIN-DATE-EXTRACT     TO RS-BILL-FROM                 
                                           WS-TARGET-DATE.              
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-DUE.                                
           MOVE WS-WORK-DAY (WD-INDX)   TO RS-MAIL-DATE.                
      *                                                                         
           MOVE WS-NEXT-REV-MO          TO BN-REVENUE-MONTH.            
           PERFORM 7020-SELECT-BILL-CYCLE-DT          THRU 7020-EXIT.   
      *                                                                         
           MOVE WS-MIN-DATE-EXTRACT     TO RS-AVOID-LPC-DATE            
                                           WS-TARGET-DATE.              
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     SET WD-INDX UP BY WS-DAY-DUE.                                
           MOVE WS-WORK-DAY (WD-INDX)    TO RS-FIRST-NOTICE-DATE.       
      *                                                                         
           MOVE WS-NEXT-REV-MO           TO RW-REVENUE-MONTH.           
           PERFORM 7025-SELECT-OPTIMUM-RD-DT          THRU 7025-EXIT.   
      *                                                                         
           MOVE RW-OPTIMUM-READ-DATE     TO WS-TARGET-DATE.             
           PERFORM 2800-SEARCH-FOR-DATE               THRU 2800-EXIT.   
      *                                                                         
T23235     IF WS-COMPANY-NO = WS-PSNC                                   
T23235        MOVE RW-OPTIMUM-READ-DATE TO RS-BILL-DUE-DATE             
T23235     ELSE                                                         
T23235        SET WD-INDX DOWN BY WS-DAY-TOTAL-DUE                      
              MOVE WS-WORK-DAY(WD-INDX)     TO RS-BILL-DUE-DATE         
T23235     END-IF.                                                      
      *                                                                         
REARCH     PERFORM 2000A-MOVE-RESULT                  THRU 2000A-EXIT.  
           PERFORM 8100-SEND-RESULT                   THRU 8100-EXIT.   
      *                                                                         
           ADD 1                         TO WS-BILL-CYCLE-NO.           
           MOVE WS-BILL-CYCLE-NO         TO WS-BILL-CYCLE.              
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM* EJECT                                                                   
      *                                                                         
      ******************************************************************        
      * 2800-SEARCH-FOR-DATE.                                                   
      ******************************************************************        
      *                                                                         
       2800-SEARCH-FOR-DATE.                                            
      *                                                                         
           SET WD-INDX TO 1.                                            
      *                                                                         
           SEARCH WS-WORK-DAY-LIST                                      
              AT END                                                    
                MOVE NOT-FOUND         TO RS-RETURN-CODE                
REARCH          PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT  
                PERFORM 8100-SEND-RESULT               THRU 8100-EXIT   
                PERFORM 9999-END-PROGRAM               THRU 9999-EXIT   
      *                                                                         
              WHEN WS-WORK-DAY (WD-INDX) = WS-TARGET-DATE               
                CONTINUE                                                
      *                                                                         
           END-SEARCH.                                                  
      *                                                                         
       2800-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T34822******************************************************************        
T34822* 2850-SEARCH-FOR-BILL-CYCLE.                                             
T34822*****************************************************************         
T34822*                                                                         
T34822 2850-SEARCH-FOR-BILL-CYCLE.                                      
T34822*                                                                         
T34822        SEARCH WS-CRED-FORECAST                                   
T34822           AT END                                                 
C34822             CONTINUE                                             
T34822        WHEN WS-BILL-CYCLE1(RANGE-INDX)                           
C34822                               = WS-BILL-CYCLE                    
T34822*                                                                         
C34822*  BILL DATE IS PASSED AS MAIL DATE FOR SEB BALANCE ACCOUNTS              
C34822             MOVE WS-BILL-DT(RANGE-INDX)                          
C34822                              TO RS-MAIL-DATE                     
T34822             MOVE WS-CURR-CHG-DUE-DT(RANGE-INDX)                  
T34822                              TO RS-BILL-DUE-DATE                 
C34822             MOVE WS-DNP-NOTICE-MAIL-DT(RANGE-INDX)               
T34822                              TO  RS-SECOND-NOTICE-DATE           
T34822             MOVE WS-DNP-DT(RANGE-INDX)                           
T34822                              TO RS-DNP-DATE                      
T34822             MOVE WS-AVOID-LPC-DT(RANGE-INDX)                     
T34822                              TO RS-AVOID-LPC-DATE                
T34822             PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT   
T34822             PERFORM 8100-SEND-RESULT           THRU 8100-EXIT    
T34822*                                                                         
T34822     END-SEARCH.                                                  
T34822*                                                                         
T34822 2850-EXIT.                                                       
T34822     EXIT.                                                        
T34822*                                                                         
T23235******************************************************************        
T23235* 2900-GET-BILL-CLOSE-DATE.                                               
T23235******************************************************************        
T23235*                                                                         
T23235 2900-GET-BILL-CLOSE-DATE.                                        
T23235*                                                                         
T23235     MOVE WS-BILL-CYCLE TO BN-BILL-CYCLE.                         
T23235     PERFORM 7001-GET-BILL-CLOSE-DATE THRU 7001-EXIT.             
T23235*                                                                         
T23235     SET WD-INDX TO 1.                                            
T23235     SEARCH WS-WORK-DAY-LIST                                      
T23235        AT END                                                    
T23235          MOVE NOT-FOUND         TO RS-RETURN-CODE                
REARCH          PERFORM 2000A-MOVE-RESULT              THRU 2000A-EXIT  
T23235          PERFORM 8100-SEND-RESULT               THRU 8100-EXIT   
T23235          PERFORM 9999-END-PROGRAM               THRU 9999-EXIT   
T23235*                                                                         
T23235        WHEN WS-WORK-DAY (WD-INDX) = BN-DATE-EXTRACT              
T23235          CONTINUE                                                
T23235*                                                                         
T23235     END-SEARCH.                                                  
T23235*                                                                         
T23235 2900-EXIT.                                                       
T23235     EXIT.                                                        
T34822************************************************************      00109710
T34822*  2950-LOAD-CURR-CRED-FCAST-TBL.                          *              
T34822*     LOAD WS CREDIT FORECAST TABLE.                       *      00109720
T34822************************************************************      00109730
T34822 2950-LOAD-CURR-CRED-FCAST-TBL.                                   
T34822*                                                                         
T34822     MOVE WS-REVENUE-MONTH1(WS-INDEX) TO                          
T34822                                  WS-REVENUE-MONTH(RANGE-INDX)    
T34822     MOVE WS-BILL-CYCLE2(WS-INDEX)    TO                          
T34822                                  WS-BILL-CYCLE1(RANGE-INDX)      
T34822     MOVE WS-CRED-FORECAST-CD1(WS-INDEX)                          
T34822                                      TO                          
T34822                                  WS-CRED-FORECAST-CD(RANGE-INDX) 
C34822     MOVE WS-BILL-DT1(WS-INDEX)                                   
C34822                                      TO                          
C34822                                  WS-BILL-DT(RANGE-INDX)          
T34822     MOVE WS-CURR-CHG-DUE-DT1(WS-INDEX)                           
T34822                                      TO                          
T34822                                  WS-CURR-CHG-DUE-DT(RANGE-INDX)  
C34822     MOVE WS-DNP-NOTICE-MAIL-DT1(WS-INDEX)                        
T34822                                      TO                          
C34822                               WS-DNP-NOTICE-MAIL-DT(RANGE-INDX)  
T34822     MOVE WS-DNP-DT1(WS-INDEX)        TO                          
T34822                                  WS-DNP-DT(RANGE-INDX)           
T34822     MOVE WS-AVOID-LPC-DT1(WS-INDEX)  TO                          
T34822                                  WS-AVOID-LPC-DT(RANGE-INDX)     
T34822                                                                  
T34822     SET RANGE-INDX UP BY 1.                                      
T34822     ADD 1           TO WS-INDEX.                                 
T34822                                                                  
T34822 2950-EXIT.                                                       
T34822     EXIT.                                                        
T34822                                                                  
      *                                                                         
      ******************************************************************        
      *                                                                *        
      * 7000-SELECT-MIN-DT-EXTRACT.                                    *        
      *                                                                *        
      ******************************************************************        
      *                                                                         
       7000-SELECT-MIN-DT-EXTRACT.                                      
                                                                        
           MOVE '7000'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL                                                     
              SELECT                                                    
                 MIN(DATE_EXTRACT)                                      
              INTO                                                      
                 :WS-MIN-DATE-EXTRACT :WS-NULL-1                        
              FROM                                                      
                 CSS_BILL_WINDOW WITH(READUNCOMMITTED)                          
              WHERE                                                     
                 REVENUE_MONTH   = :BN-REVENUE-MONTH                    
T34097                                                           
P00399                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          MIN(DATE_EXTRACT)                                              
MFA-TR*       INTO                                                              
MFA-TR*          :WS-MIN-DATE-EXTRACT :WS-NULL-1                                
MFA-TR*       FROM                                                              
MFA-TR*          CSS_BILL_WINDOW                                                
MFA-TR*       WHERE                                                             
MFA-TR*          REVENUE_MONTH   = :BN-REVENUE-MONTH                            
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7000                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-1 < 0                                          
                  MOVE -100                   TO RS-RETURN-CODE         
                                                 WS-ACTIVE-RETURN-CODE  
T19371            MOVE +100                   TO SQLCODE                
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
CBSI              MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                
                  MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1        
                  MOVE  BN-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1      
                                                                        
                  PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT
              END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-1        
              MOVE  BN-REVENUE-MONTH          TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T23235******************************************************************        
T23235*                                                                *        
T23235* 7001-GET-BILL-CLOSE-DATE.                                      *        
T23235*                                                                *        
T23235******************************************************************        
T23235*                                                                         
T23235 7001-GET-BILL-CLOSE-DATE.                                        
T23235                                                                  
T23235     MOVE '7001'          TO ACTIVE-PARAGRAPH.                    
T23235                                                                  
T23235     EXEC SQL                                                     
T23235        SELECT                                                    
T23235           MIN(DATE_EXTRACT)                                      
T23235        INTO                                                      
T23235           :BN-DATE-EXTRACT :WS-NULL-1                            
T23235        FROM                                                      
T23235           CSS_BILL_WINDOW WITH(READUNCOMMITTED)                          
T23235        WHERE BILL_CYCLE     = :BN-BILL-CYCLE                     
T23235          AND CODE_BILL_COND = 'C'                                
T23235          AND REVENUE_MONTH   = :BN-REVENUE-MONTH                 
T34097                                                           
P00399                                                      
T23235     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          MIN(DATE_EXTRACT)                                              
MFA-TR*       INTO                                                              
MFA-TR*          :BN-DATE-EXTRACT :WS-NULL-1                                    
MFA-TR*       FROM                                                              
MFA-TR*          CSS_BILL_WINDOW                                                
MFA-TR*       WHERE BILL_CYCLE     = :BN-BILL-CYCLE                             
MFA-TR*         AND CODE_BILL_COND = 'C'                                        
MFA-TR*         AND REVENUE_MONTH   = :BN-REVENUE-MONTH                         
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7001                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T23235                                                                  
T23235     MOVE SQLCODE               TO WS-ACTIVE-RETURN-CODE.         
T23235                                                                  
T23235     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T23235        IF WS-NULL-1 < 0                                          
T23235            MOVE -100                   TO RS-RETURN-CODE         
T23235                                           WS-ACTIVE-RETURN-CODE  
T19371            MOVE +100                   TO SQLCODE                
T23235            MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
CBSI35            MOVE 'SELECT'               TO ABEND-FUNCTION         
T23235            MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                
T23235            MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-1        
T23235            MOVE  BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-1      
T23235                                                                  
T23235            PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT
T23235        END-IF                                                    
              MOVE BN-DATE-EXTRACT       TO WS-DATE-YYYY-MM-DD          
              MOVE WS-DATE-YYYY          TO WS-DATE2-YYYY               
              MOVE WS-DATE-MM            TO WS-DATE2-MM                 
              MOVE WS-DATE-DD            TO WS-DATE2-DD                 
              MOVE WS-DATE-MM-DD-YYYY    TO BN-DATE-EXTRACT             
T23235     ELSE                                                         
T23235        MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
T23235        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
T23235        MOVE 'SELECT'                   TO ABEND-FUNCTION         
T23235        MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
T23235        MOVE 'BILL_CYCLE'               TO TABLE-ELEMENT-1        
T23235        MOVE  BN-BILL-CYCLE             TO HOSTVAR-ELEMENT-1      
T23235                                                                  
T23235        PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
T23235     END-IF.                                                      
T23235                                                                  
T23235 7001-EXIT.                                                       
T23235     EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7005-OPEN-DELINQ-CSR                                                    
      * CURSOR TO EXTRACT NEEDED DELIQNUENCY VALUES                             
      *****************************************************************         
      *                                                                         
       7005-OPEN-DELINQ-CSR.                                            
      *                                                                         
           EXEC SQL                                                     
               OPEN DELINQUENCY_CSR                                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7005'                 TO ACTIVE-PARAGRAPH           
              MOVE 'OPEN'                 TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DELINQUENCY'      TO TABLE-1                    
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7005-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * FETCH DELINQUENCY_CSR                                                   
      *****************************************************************         
      *                                                                         
       7006-FETCH-DELINQ-CSR.                                           
      *                                                                         
           EXEC SQL                                                     
               FETCH                                                    
                  DELINQUENCY_CSR                                       
               INTO                                                     
                  :C8-DELINQ-CD,                                        
                  :C8-DELINQ-VALUE                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7006'                 TO ACTIVE-PARAGRAPH           
              MOVE 'FETCH'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DELINQUENCY'      TO TABLE-1                    
T23235        MOVE 'WS-COMPANY-NO'        TO TABLE-ELEMENT-1            
T23235        MOVE  WS-COMPANY-NO         TO HOSTVAR-ELEMENT-1          
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7006-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * CLOSE BILL_CYCLE_ALL  -- USED FOR PANEL274                              
      *****************************************************************         
      *                                                                         
       7007-CLOSE-DELINQ-CSR.                                           
      *                                                                         
           EXEC SQL                                                     
               CLOSE DELINQUENCY_CSR                                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
              MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
              MOVE '7007'                 TO ACTIVE-PARAGRAPH           
              MOVE 'CLOSE'                TO ABEND-FUNCTION             
              MOVE SPACES                 TO ABEND-SQL-PREDICATES       
                                             ABEND-TABLES               
              MOVE 'CSS_DELIQUENCY'       TO TABLE-1                    
      *                                                                         
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
              PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
           END-IF.                                                      
      *                                                                         
       7007-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7010-GET-NEXT-WORK-DAY                                        *         
      * INPUT: WS-MIN-DATE-EXTRACT, WS-ADJ-DAY                        *         
      * THIS PARA ADDS THE TWO INPUT DAYS, AND GETS DAY OF THE WEEK   *         
      * OUTPUT: WS-WORK-DATE, WS-WEEK-DAY                             *         
      *****************************************************************         
       7010-GET-NEXT-WORK-DAY.                                          
      *                                                                         
           EXEC SQL                                                     
              SELECT
              DATEADD( DAY, :WS-ADJ-DAY, IIF(TRY_CONVERT(DATE, 
                                                   :WS-MIN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-MIN-DATE-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:WS-MIN-DATE-EXTRACT
              ), CONVERT(DATE, :WS-MIN-DATE-EXTRACT) ) ),
              CIS.DAYS (DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-MIN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-MIN-DATE-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:WS-MIN-DATE-EXTRACT
              ), CONVERT(DATE, :WS-MIN-DATE-EXTRACT) ) )) -                    
T34097              (CIS.DAYS(DATEADD( DAY, :WS-ADJ-DAY, 
              IIF(TRY_CONVERT(DATE, :WS-MIN-DATE-EXTRACT
              ) IS NULL OR (PATINDEX('%.%', :WS-MIN-DATE-EXTRACT
              ) <> 0) OR (LEN(:WS-MIN-DATE-EXTRACT
              ) <> 10), CIS.CHAR2DATE(:WS-MIN-DATE-EXTRACT
              ), CONVERT(DATE, :WS-MIN-DATE-EXTRACT) ) ))/7 * 7)
            INTO
              :WS-WORK-DATE,
              :WS-WEEK-DAY                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ029
MFA-TR* MSQ044
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SET :WS-WORK-DATE =                                               
MFA-TR*                 DATE(:WS-MIN-DATE-EXTRACT) + :WS-ADJ-DAY DAYS,          
MFA-TR*            :WS-WEEK-DAY = DAYS (DATE(:WS-MIN-DATE-EXTRACT)              
MFA-TR*                + :WS-ADJ-DAY DAYS) -                                    
MFA-TR*             (INTEGER(DAYS(DATE(:WS-MIN-DATE-EXTRACT)                    
MFA-TR*                + :WS-ADJ-DAY DAYS)/7) * 7)                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE   EQUAL  SUCCESSFUL-CALL            
                  CONTINUE                                              
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7010'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SET'                      TO ABEND-FUNCTION         
              MOVE SPACES                     TO TABLE-1                
CBSI          MOVE SPACES                     TO TABLE-2                
              MOVE 'WS-MIN-DATE-EXTRACT'      TO TABLE-ELEMENT-1        
              MOVE WS-MIN-DATE-EXTRACT        TO HOSTVAR-ELEMENT-1      
              PERFORM 9700-PROCESS-ABEND    THRU 9700-EXIT              
           END-IF.                                                      
      *                                                                         
       7010-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * SELECT ALL CYCLES FOR A REVENUE MONTH                                   
      * NEEDED FOR THE FORECAST PANEL                                           
      *****************************************************************         
      *                                                                         
       7015-SELECT-BILL-CYCLES.                                         
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                 MIN(BILL_CYCLE),                                       
                 MAX(BILL_CYCLE)                                        
              INTO                                                      
                 :WS-BILL-CYCLE,                                        
                 :WS-MAX-BILL-CYCLE                                     
              FROM                                                      
                 CSS_BILL_WINDOW WITH(READUNCOMMITTED)                          
              WHERE                                                     
                 REVENUE_MONTH = :BN-REVENUE-MONTH                      
T34097                                                           
P00399                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*          MIN(BILL_CYCLE),                                               
MFA-TR*          MAX(BILL_CYCLE)                                                
MFA-TR*       INTO                                                              
MFA-TR*          :WS-BILL-CYCLE,                                                
MFA-TR*          :WS-MAX-BILL-CYCLE                                             
MFA-TR*       FROM                                                              
MFA-TR*          CSS_BILL_WINDOW                                                
MFA-TR*       WHERE                                                             
MFA-TR*          REVENUE_MONTH = :BN-REVENUE-MONTH                              
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7015                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              CONTINUE                                                  
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE '7015'                     TO ACTIVE-PARAGRAPH       
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_BILL_WINDOW'          TO TABLE-1                
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-1        
              MOVE  BN-REVENUE-MONTH          TO HOSTVAR-ELEMENT-1      
                                                                        
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
      *                                                                         
           END-IF.                                                      
      *                                                                         
       7015-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 3020-SELECT-BILL-CYCLE-DT                                               
      * SELECT EXTRACT DATES FOR PARTICULAR CYCLE                               
      * IN SPECIFIED REVENUE MONTH                                              
      *****************************************************************         
      *                                                                         
       7020-SELECT-BILL-CYCLE-DT.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  MIN(DATE_EXTRACT),                                    
                  MAX(DATE_EXTRACT)                                     
              INTO                                                      
                  :WS-MIN-DATE-EXTRACT :WS-NULL-1,                      
                  :WS-MAX-DATE-EXTRACT :WS-NULL-2                       
              FROM                                                      
                  CSS_BILL_WINDOW WITH(READUNCOMMITTED)                         
              WHERE                                                     
                  REVENUE_MONTH = :BN-REVENUE-MONTH                     
              AND BILL_CYCLE    = :WS-BILL-CYCLE                        
T34097                                                           
P00399                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           MIN(DATE_EXTRACT),                                            
MFA-TR*           MAX(DATE_EXTRACT)                                             
MFA-TR*       INTO                                                              
MFA-TR*           :WS-MIN-DATE-EXTRACT :WS-NULL-1,                              
MFA-TR*           :WS-MAX-DATE-EXTRACT :WS-NULL-2                               
MFA-TR*       FROM                                                              
MFA-TR*           CSS_BILL_WINDOW                                               
MFA-TR*       WHERE                                                             
MFA-TR*           REVENUE_MONTH = :BN-REVENUE-MONTH                             
MFA-TR*       AND BILL_CYCLE    = :WS-BILL-CYCLE                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7020                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
      *                                                                         
              IF WS-NULL-1 < 0 OR WS-NULL-2 < 0                         
                  MOVE -100                   TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE         
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
CBSI              MOVE '7020'                 TO ACTIVE-PARAGRAPH       
CBSI              MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_BILL_WINDOW'      TO TABLE-1                
                  MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1        
                  MOVE  BN-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1      
                  MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2        
                  MOVE  WS-BILL-CYCLE         TO HOSTVAR-ELEMENT-2      
                  PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT
              END-IF                                                    
      *                                                                         
              MOVE WS-MIN-DATE-EXTRACT   TO WS-DATE-YYYY-MM-DD          
              MOVE WS-DATE-YYYY          TO WS-DATE2-YYYY               
              MOVE WS-DATE-MM            TO WS-DATE2-MM                 
              MOVE WS-DATE-DD            TO WS-DATE2-DD                 
              MOVE WS-DATE-MM-DD-YYYY    TO WS-MIN-DATE-EXTRACT         
      *                                                                         
              MOVE WS-MAX-DATE-EXTRACT   TO WS-DATE-YYYY-MM-DD          
              MOVE WS-DATE-YYYY          TO WS-DATE2-YYYY               
              MOVE WS-DATE-MM            TO WS-DATE2-MM                 
              MOVE WS-DATE-DD            TO WS-DATE2-DD                 
              MOVE WS-DATE-MM-DD-YYYY    TO WS-MAX-DATE-EXTRACT         
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
CBSI          MOVE '7020'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
              MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1             
              MOVE  BN-REVENUE-MONTH     TO HOSTVAR-ELEMENT-1           
              MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-2             
              MOVE  WS-BILL-CYCLE        TO HOSTVAR-ELEMENT-2           
                                                                        
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           END-IF.                                                      
      *                                                                         
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      *****************************************************************         
      * 7025-SELECT-OPTIMUM-RD-DT                                               
      * SELECT OPTIMUM READ DATE FOR PARTICULAR CYCLE                           
      * IN SPECIFIED REVENUE MONTH                                              
      *****************************************************************         
      *                                                                         
       7025-SELECT-OPTIMUM-RD-DT.                                       
      *                                                                         
           EXEC SQL                                                     
              SELECT                                                    
                  CIS.CHAR2$DATE(OPTIMUM_READ_DATE,'USA')                       
T28824           ,CIS.CHAR2$DATE(THIRD_PTY_READ_DT,'USA')                       
              INTO                                                      
                  :RW-OPTIMUM-READ-DATE :WS-NULL-1                      
T28824           ,:RW-THIRD-PTY-READ-DT :WS-NULL-3                      
              FROM                                                      
                  CSS_READ_WINDOW WITH(READUNCOMMITTED)                         
              WHERE                                                     
                  REVENUE_MONTH = :RW-REVENUE-MONTH                     
              AND READ_CYCLE    = :WS-BILL-CYCLE                        
T34097                                                           
P00399                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT                                                            
MFA-TR*           CHAR(OPTIMUM_READ_DATE,USA)                                   
MFA-TR*          ,CHAR(THIRD_PTY_READ_DT,USA)                                   
MFA-TR*       INTO                                                              
MFA-TR*           :RW-OPTIMUM-READ-DATE :WS-NULL-1                              
MFA-TR*          ,:RW-THIRD-PTY-READ-DT :WS-NULL-3                              
MFA-TR*       FROM                                                              
MFA-TR*           CSS_READ_WINDOW                                               
MFA-TR*       WHERE                                                             
MFA-TR*           REVENUE_MONTH = :RW-REVENUE-MONTH                             
MFA-TR*       AND READ_CYCLE    = :WS-BILL-CYCLE                                
MFA-TR*       WITH UR                                                           
MFA-TR*       QUERYNO 7025                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-NULL-1 < 0                                          
                  MOVE -100                   TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE         
                  MOVE PROGRAM-NAME           TO ABEND-PROGRAM          
CBSI              MOVE '7025'                 TO ACTIVE-PARAGRAPH       
CBSI              MOVE 'SELECT'               TO ABEND-FUNCTION         
                  MOVE 'CSS_READ_WINDOW'      TO TABLE-1                
                  MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1        
T23235            MOVE  RW-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1      
                  MOVE 'READ_CYCLE'           TO TABLE-ELEMENT-2        
                  MOVE  WS-BILL-CYCLE         TO HOSTVAR-ELEMENT-2      
                                                                        
                  PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT
              END-IF                                                    
T28824        IF WS-NULL-3 < 0                                          
T28824           MOVE SPACES                  TO RW-THIRD-PTY-READ-DT   
T28824        END-IF                                                    
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE      TO RS-RETURN-CODE         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
              MOVE 'SELECT'                   TO ABEND-FUNCTION         
              MOVE 'CSS_READ_WINDOW'          TO TABLE-1                
              MOVE 'REVENUE_MONTH'            TO TABLE-ELEMENT-1        
T23235        MOVE  RW-REVENUE-MONTH          TO HOSTVAR-ELEMENT-1      
              MOVE 'READ_CYCLE'               TO TABLE-ELEMENT-2        
              MOVE  WS-BILL-CYCLE             TO HOSTVAR-ELEMENT-2      
                                                                        
              PERFORM 9700-PROCESS-ABEND              THRU 9700-EXIT    
           END-IF.                                                      
      *                                                                         
       7025-EXIT.                                                       
           EXIT.                                                        
T34822*****************************************************************         
T34822* 7030-OPEN-CRED-FORECAST-CSR                                             
T34822* CURSOR TO EXTRACT NEEDED CREDIT FORECST VALUES.                         
T34822*****************************************************************         
T34822*                                                                         
T34822 7030-OPEN-CRED-FORECAST-CSR.                                     
T34822*                                                                         
T34822     EXEC SQL                                                     
T34822         OPEN CRED-FCAST-CSR                                      
T34822     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T34822     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
T34822     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34822        NEXT SENTENCE                                             
T34822     ELSE                                                         
T34822        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
T34822        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
T34822        MOVE '7030'                 TO ACTIVE-PARAGRAPH           
T34822        MOVE 'OPEN'                 TO ABEND-FUNCTION             
T34822        MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
T34822        MOVE  CM-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1          
C34822        MOVE 'CRED_FORECAST_CD'     TO TABLE-ELEMENT-2            
C34822        MOVE CM-CRED-FORECAST-CD    TO HOSTVAR-ELEMENT-2          
C34822        MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3            
C34822        MOVE CM-COMPANY-NO          TO HOSTVAR-ELEMENT-3          
T34822        MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
T34822*                                                                         
T34822        PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
T34822        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
T34822     END-IF.                                                      
T34822*                                                                         
T34822 7030-EXIT.                                                       
T34822     EXIT.                                                        
T34822*                                                                         
T34822*****************************************************************         
T34822* 7035-FETCH-CRED-FORECAST-CSR                                            
T34822*    FETCH CREDIT FORECAST CURSOR.                                        
T34822*****************************************************************         
T34822*                                                                         
T34822 7035-FETCH-CRED-FORECAST-CSR.                                    

MSQ008     MOVE 63 TO MSQ008-CRED-FCAST-CSR
T34822*                                                                         
T34822     EXEC SQL                                                     
C34822         FOR :MSQ008-CRED-FCAST-CSR
              FETCH 
              FROM CRED-FCAST-CSR         
T34822          INTO :WS-REVENUE-MONTH1                                 
C34822              ,:WS-BILL-DT1                                       
T34822              ,:WS-BILL-CYCLE2                                    
T34822              ,:WS-CRED-FORECAST-CD1                              
T34822              ,:WS-CURR-CHG-DUE-DT1                               
C34822              ,:WS-DNP-NOTICE-MAIL-DT1                            
T34822              ,:WS-DNP-DT1                                        
T34822              ,:WS-AVOID-LPC-DT1                                  
T34822     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                             
MFA-TR*        FETCH NEXT ROWSET FROM CRED-FCAST-CSR FOR 63 ROWS                
MFA-TR*         INTO :WS-REVENUE-MONTH1                                         
MFA-TR*             ,:WS-BILL-DT1                                               
MFA-TR*             ,:WS-BILL-CYCLE2                                            
MFA-TR*             ,:WS-CRED-FORECAST-CD1                                      
MFA-TR*             ,:WS-CURR-CHG-DUE-DT1                                       
MFA-TR*             ,:WS-DNP-NOTICE-MAIL-DT1                                    
MFA-TR*             ,:WS-DNP-DT1                                                
MFA-TR*             ,:WS-AVOID-LPC-DT1                                          
MFA-TR*    END-EXEC.                                                            

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-CRED-FCAST-CSR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T34822     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T34822     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C34822        IF  SQLERRD(3) >= 21 OR WS-CFCAST-ROW-COUNT > 0           
T34822            MOVE SQLERRD (3)        TO WS-CFCAST-ROW-COUNT        
T34822        ELSE                                                      
T34822            MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
T34822            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
T34822            MOVE '7035'             TO ACTIVE-PARAGRAPH           
T34822            MOVE 'FETCH'            TO ABEND-FUNCTION             
T34822            MOVE 'REVENUE_MONTH'    TO TABLE-ELEMENT-1            
T34822            MOVE  CM-REVENUE-MONTH  TO HOSTVAR-ELEMENT-1          
T34822            MOVE 'ROWCOUNT '        TO TABLE-ELEMENT-2            
T34822            MOVE SQLERRD(3)         TO HOSTVAR-ELEMENT-2          
T34822            MOVE 'CSS_CRED_FORECAST'   TO TABLE-1                 
T34822*                                                                         
T34822            PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT    
T34822            PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT    
T34822        END-IF                                                    
T34822     ELSE                                                         
T34822        IF WS-ACTIVE-RETURN-CODE = +354                           
T34822            EXEC SQL                                              
MSQ012                GET DIAGNOSTICS :MFA-GD-ROW-COUNT =            
T34822                       ROW_COUNT                                  
MSQ012                      ,:MFA-GD-NUMBER = NUMBER                      
T34822            END-EXEC                                              

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ012
MFA-TR*           EXEC SQL                                                      
MFA-TR*               GET DIAGNOSTICS :WS-CFCAST-ROW-COUNT =                    
MFA-TR*                      ROW_COUNT                                          
MFA-TR*                     ,:WS-NUM-COND = NUMBER                              
MFA-TR*           END-EXEC                                                      
MSQ012            MOVE MFA-GD-ROW-COUNT TO WS-CFCAST-ROW-COUNT
MSQ012            MOVE MFA-GD-NUMBER TO WS-NUM-COND
T34822            MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
T34822            MOVE PROGRAM-NAME       TO ABEND-PROGRAM              
T34822            MOVE '7035'             TO ACTIVE-PARAGRAPH           
T34822            MOVE 'FETCH'            TO ABEND-FUNCTION             
T34822            MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1         
T34822            MOVE  CM-REVENUE-MONTH     TO HOSTVAR-ELEMENT-1       
T34822            MOVE 'ROWCOUNT '           TO TABLE-ELEMENT-2         
T34822            MOVE WS-CFCAST-ROW-COUNT   TO HOSTVAR-ELEMENT-2       
T34822            MOVE 'NUM_COND '           TO TABLE-ELEMENT-3         
T34822            MOVE  WS-NUM-COND          TO HOSTVAR-ELEMENT-3       
T34822            MOVE 'CSS_CRED_FORECAST'   TO TABLE-1                 
T34822*                                                                         
T34822            PERFORM 9000-SEND-ERROR-RESULT      THRU 9000-EXIT    
T34822            PERFORM 9900-SQL-ERROR-ROUTINE      THRU 9900-EXIT    
T34822        ELSE                                                      
T34822            MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE          
T34822            MOVE PROGRAM-NAME          TO ABEND-PROGRAM           
T34822            MOVE '7035'                TO ACTIVE-PARAGRAPH        
T34822            MOVE 'FETCH'               TO ABEND-FUNCTION          
T34822            MOVE SPACES                TO ABEND-SQL-PREDICATES    
T34822                                           ABEND-TABLES           
T34822            MOVE 'CSS_CRED_FORECAST'   TO TABLE-1                 
C34822            MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-1         
C34822            MOVE CM-REVENUE-MONTH      TO HOSTVAR-ELEMENT-1       
C34822            MOVE 'CRED_FORECAST_CD'    TO TABLE-ELEMENT-2         
C34822            MOVE CM-CRED-FORECAST-CD   TO HOSTVAR-ELEMENT-2       
C34822            MOVE 'COMPANY_NO'          TO TABLE-ELEMENT-3         
C34822            MOVE CM-COMPANY-NO         TO HOSTVAR-ELEMENT-3       
T34822            PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT        
T34822            PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT        
T34822        END-IF                                                    
T34822     END-IF.                                                      
T34822*                                                                         
T34822 7035-EXIT.                                                       
T34822     EXIT.                                                        
T34822*                                                                         
T34822*****************************************************************         
T34822* 7040-CLOSE-CRED-FORECAST-CSR                                            
T34822*    CLOSE CREDIT FORECAST CURSOR.                                        
T34822*****************************************************************         
T34822*                                                                         
T34822 7040-CLOSE-CRED-FORECAST-CSR.                                    
T34822*                                                                         
T34822     EXEC SQL                                                     
T34822         CLOSE CRED-FCAST-CSR                                     
T34822     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T34822     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
T34822     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T34822        CONTINUE                                                  
T34822     ELSE                                                         
T34822        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
T34822        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
T34822        MOVE '7040'                 TO ACTIVE-PARAGRAPH           
T34822        MOVE 'CLOSE'                TO ABEND-FUNCTION             
T34822        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
T34822                                       ABEND-TABLES               
T34822        MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
C34822        MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
C34822        MOVE CM-REVENUE-MONTH       TO HOSTVAR-ELEMENT-1          
C34822        MOVE 'CRED_FORECAST_CD'     TO TABLE-ELEMENT-2            
C34822        MOVE CM-CRED-FORECAST-CD    TO HOSTVAR-ELEMENT-2          
C34822        MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-3            
C34822        MOVE CM-COMPANY-NO          TO HOSTVAR-ELEMENT-3          
T34822*                                                                         
T34822        PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
T34822        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
T34822     END-IF.                                                      
T34822*                                                                         
T34822 7040-EXIT.                                                       
T34822     EXIT.                                                        
      *                                                                         
C34822*                                                                         
C34822*****************************************************************         
C34822* 7050-SELECT-CRED-FORECAST-CSR                                           
C34822*    SELECT DATES FROM CSS_CRED_FORECAST.                                 
C34822*****************************************************************         
C34822*                                                                         
C34822 7050-SELECT-CRED-FORECAST.                                       
C34822*                                                                         
C34822     EXEC SQL                                                     
C34822         SELECT TOP(1) CIS.CHAR2$DATE(BILL_DT,'USA'),
              COALESCE(CIS.CHAR2$DATE(CURR_CHG_DUE_DT,'USA'),' '),
              COALESCE(CIS.CHAR2$DATE(DNP_NOTICE_MAIL_DT,'USA'),' '),
              COALESCE(CIS.CHAR2$DATE(DNP_DT,'USA'),' '),
              COALESCE(CIS.CHAR2$DATE(AVOID_LPC_DT,'USA'),' ')                
C34822           INTO :CM-BILL-DT                                       
C34822               ,:CM-CURR-CHG-DUE-DT                               
C34822               ,:CM-DNP-NOTICE-MAIL-DT                            
C34822               ,:CM-DNP-DT                                        
C34822               ,:CM-AVOID-LPC-DT                                  
T34822           FROM CSS_CRED_FORECAST WITH(READUNCOMMITTED)                   
T34822           WHERE REVENUE_MONTH    = :CM-REVENUE-MONTH             
T34822             AND BILL_CYCLE       = :CM-BILL-CYCLE                
T34822             AND CRED_FORECAST_CD = :CM-CRED-FORECAST-CD          
C34822             AND COMPANY_NO       = :CM-COMPANY-NO                
T34822            ORDER BY BILL_DT                                      
C34822                                            
T34097                                                           
P00399                                                      
C34822     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CHAR(BILL_DT,USA)                                         
MFA-TR*              ,IFNULL(CHAR(CURR_CHG_DUE_DT,USA),' ')                     
MFA-TR*              ,IFNULL(CHAR(DNP_NOTICE_MAIL_DT,USA),' ')                  
MFA-TR*              ,IFNULL(CHAR(DNP_DT,USA),' ')                              
MFA-TR*              ,IFNULL(CHAR(AVOID_LPC_DT,USA),' ')                        
MFA-TR*          INTO :CM-BILL-DT                                               
MFA-TR*              ,:CM-CURR-CHG-DUE-DT                                       
MFA-TR*              ,:CM-DNP-NOTICE-MAIL-DT                                    
MFA-TR*              ,:CM-DNP-DT                                                
MFA-TR*              ,:CM-AVOID-LPC-DT                                          
MFA-TR*          FROM CSS_CRED_FORECAST                                         
MFA-TR*          WHERE REVENUE_MONTH    = :CM-REVENUE-MONTH                     
MFA-TR*            AND BILL_CYCLE       = :CM-BILL-CYCLE                        
MFA-TR*            AND CRED_FORECAST_CD = :CM-CRED-FORECAST-CD                  
MFA-TR*            AND COMPANY_NO       = :CM-COMPANY-NO                        
MFA-TR*           ORDER BY BILL_DT                                              
MFA-TR*           FETCH FIRST 1 ROW ONLY                                        
MFA-TR*          WITH UR                                                        
MFA-TR*          QUERYNO 7050                                                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
C34822     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
C34822     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C34822        CONTINUE                                                  
C34822     ELSE                                                         
C34822        MOVE WS-ACTIVE-RETURN-CODE  TO RS-RETURN-CODE             
C34822        MOVE PROGRAM-NAME           TO ABEND-PROGRAM              
C34822        MOVE '7050'                 TO ACTIVE-PARAGRAPH           
C34822        MOVE 'SELECT'               TO ABEND-FUNCTION             
C34822        MOVE SPACES                 TO ABEND-SQL-PREDICATES       
C34822                                       ABEND-TABLES               
C34822        MOVE 'CSS_CRED_FORECAST'    TO TABLE-1                    
C34822        MOVE 'REVENUE_MONTH'        TO TABLE-ELEMENT-1            
C34822        MOVE CM-REVENUE-MONTH       TO HOSTVAR-ELEMENT-1          
C34822        MOVE 'BILL_CYCLE'           TO TABLE-ELEMENT-2            
C34822        MOVE CM-BILL-CYCLE          TO HOSTVAR-ELEMENT-2          
C34822        MOVE 'CRED_FORECAST_CD'     TO TABLE-ELEMENT-3            
C34822        MOVE CM-CRED-FORECAST-CD    TO HOSTVAR-ELEMENT-3          
C34822        MOVE 'COMPANY_NO'           TO TABLE-ELEMENT-4            
C34822        MOVE CM-COMPANY-NO          TO HOSTVAR-ELEMENT-4          
C34822*                                                                         
C34822        PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
C34822        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
C34822     END-IF.                                                      
C34822*                                                                         
C34822 7050-EXIT.                                                       
C34822     EXIT.                                                        
      *                                                                         
T34097***************************************************************** 07598500
T34097* 7061-OPEN-HOLIDAY-CURSOR                                      * 07598700
T34097* OPEN HOLIDAY CURSOR                                           * 07598800
T34097*                                                               * 07598900
T34097***************************************************************** 07599000
T34097*                                                                 07599100
T34097 7061-OPEN-HOLIDAY-CURSOR.                                        
T34097*                                                                 07620000
T34097     MOVE '7061' TO ACTIVE-PARAGRAPH.                             
T34097*                                                                 07622000
T34097     EXEC SQL                                                     
T34097        OPEN HOLIDAY_CURSOR                                       
T34097     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34097*                                                                 07660000
T34097     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
T34097*                                                                 07680000
T34097     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T34097        NEXT SENTENCE                                             
T34097     ELSE                                                         
T34097        MOVE 'OPEN' TO ABEND-FUNCTION                             
T34097        MOVE 'CSS_HOLIDAY' TO TABLE-1                             
T34097        PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
T23235        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
T34097     END-IF.                                                      
T34097*                                                                 07790000
T34097 7061-EXIT.                                                       
T34097     EXIT.                                                        
T34097*                                                                 07820000
T34097***************************************************************** 07821000
T34097* 7062-FETCH-HOLIDAY-CURSOR                                     * 07823000
T34097*                                                               * 07823100
T34097***************************************************************** 07825000
T34097*                                                                 07826000
T34097 7062-FETCH-HOLIDAY-CURSOR.                                       
T34097*                                                                 07880000
T34097     MOVE '7062' TO ACTIVE-PARAGRAPH.                             

MSQ008     MOVE 200 TO MSQ008-HOLIDAY-CURSOR
T34097*                                                                 07882000
T34097     EXEC SQL                                                     
T34097        FOR :MSQ008-HOLIDAY-CURSOR
              FETCH 
              FROM HOLIDAY_CURSOR         
T34097         INTO :WS-HOLIDAY-DT                                      
T34097     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ008
MFA-TR*    EXEC SQL                                                     07890000
MFA-TR*       FETCH NEXT ROWSET FROM HOLIDAY_CURSOR FOR 200 ROWS        07900000
MFA-TR*        INTO :WS-HOLIDAY-DT                                      07910000
MFA-TR*    END-EXEC.                                                    08100000

MSQ008      IF SQLCODE EQUAL ZERO AND
MSQ008        SQLERRD(3) < MSQ008-HOLIDAY-CURSOR
MSQ008         MOVE 100        TO SQLCODE
MSQ008         MOVE 2000       TO SQLSTATE
MSQ008      END-IF.
MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34097*                                                                 08110000
T34097     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
T34097*                                                                 08130000
T34097     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T34097        MOVE SQLERRD(3)        TO WS-HOLIDAY-CNT                  
T34097     ELSE                                                         
T34097        MOVE 'FETCH' TO ABEND-FUNCTION                            
T34097        MOVE 'CSS_HOLIDAY' TO TABLE-1                             
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
T23235        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
T34097     END-IF.                                                      
T34097*                                                                 08280000
T34097 7062-EXIT.                                                       
T34097     EXIT.                                                        
T34097*                                                                 08310000
T34097***************************************************************** 08311000
T34097*   7063-CLOSE-HOLIDAY-CURSOR                                   * 08313000
T34097*   CLOSE HOLIDAY CURSOR                                        * 08313100
T34097*                                                               * 08314000
T34097***************************************************************** 08315000
T34097*                                                                 08316000
T34097 7063-CLOSE-HOLIDAY-CURSOR.                                       
T34097*                                                                 08370000
T34097     MOVE '7063' TO ACTIVE-PARAGRAPH.                             
T34097*                                                                 08372000
T34097     EXEC SQL                                                     
T34097        CLOSE HOLIDAY_CURSOR                                      
T34097     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T34097*                                                                 08410000
T34097     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
T34097*                                                                 08430000
T34097     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T34097        NEXT SENTENCE                                             
T34097     ELSE                                                         
T34097        MOVE 'CLOSE' TO ABEND-FUNCTION                            
T34097        MOVE 'CSS_HOLIDAY' TO TABLE-1                             
              PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT    
T23235        PERFORM 9900-SQL-ERROR-ROUTINE          THRU 9900-EXIT    
T34097     END-IF.                                                      
T34097*                                                                 08540000
T34097 7063-EXIT.                                                       
T34097     EXIT.                                                        
T34097*                                                                         
      ******************************************************************        
      * 8100-SEND-RESULT                                               *        
      ******************************************************************        
       8100-SEND-RESULT.                                                
     *                                                                  
           EXEC SQL                                                     
REARCH         INSERT INTO #CSR02364_R1                          
REARCH             (RETURN_CODE                                         
REARCH             ,BILL_CYCLE                                          
REARCH             ,READ_DATE                                           
REARCH             ,BILL_FROM                                           
REARCH             ,BILL_TO                                             
REARCH             ,MAIL_DATE                                           
REARCH             ,BILL_DUE_DATE                                       
REARCH             ,AVOID_LPC_DATE                                      
REARCH             ,FIRST_NOTICE_DATE                                   
REARCH             ,SECOND_NOTICE_DATE                                  
REARCH             ,DNP_DATE                                            
REARCH             ,DUE_EXCEPT                                          
REARCH             ,SECOND_EXCEPT                                       
REARCH             ,DNP_EXCEPT                                          
REARCH             ,SECOND_FIELD_DATE                                   
T28824             ,THIRD_PTY_READ_DT                                   
C32545             ,EXCEPT_IVR_DT)                                      
REARCH         VALUES                                                   
REARCH         (   :S-RETURN-CODE                                       
REARCH            ,:S-BILL-CYCLE                                        
REARCH            ,:S-READ-DATE                                         
REARCH            ,:S-BILL-FROM                                         
REARCH            ,:S-BILL-TO                                           
REARCH            ,:S-MAIL-DATE                                         
REARCH            ,:S-BILL-DUE-DATE                                     
REARCH            ,:S-AVOID-LPC-DATE                                    
REARCH            ,:S-FIRST-NOTICE-DATE                                 
REARCH            ,:S-SECOND-NOTICE-DATE                                
REARCH            ,:S-DNP-DATE                                          
REARCH            ,:S-DUE-EXCEPT                                        
REARCH            ,:S-SECOND-EXCEPT                                     
REARCH            ,:S-DNP-EXCEPT                                        
REARCH            ,:S-SECOND-FIELD-DATE                                 
T28824            ,:S-THIRD-PTY-READ-DT                                 
T28824            ,:S-EXCEPT-IVR-DT                                     
REARCH         )                                                        
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02364_R1                                  
MFA-TR*            (RETURN_CODE                                                 
MFA-TR*            ,BILL_CYCLE                                                  
MFA-TR*            ,READ_DATE                                                   
MFA-TR*            ,BILL_FROM                                                   
MFA-TR*            ,BILL_TO                                                     
MFA-TR*            ,MAIL_DATE                                                   
MFA-TR*            ,BILL_DUE_DATE                                               
MFA-TR*            ,AVOID_LPC_DATE                                              
MFA-TR*            ,FIRST_NOTICE_DATE                                           
MFA-TR*            ,SECOND_NOTICE_DATE                                          
MFA-TR*            ,DNP_DATE                                                    
MFA-TR*            ,DUE_EXCEPT                                                  
MFA-TR*            ,SECOND_EXCEPT                                               
MFA-TR*            ,DNP_EXCEPT                                                  
MFA-TR*            ,SECOND_FIELD_DATE                                           
MFA-TR*            ,THIRD_PTY_READ_DT                                           
MFA-TR*            ,EXCEPT_IVR_DT)                                              
MFA-TR*        VALUES                                                           
MFA-TR*        (   :S-RETURN-CODE                                               
MFA-TR*           ,:S-BILL-CYCLE                                                
MFA-TR*           ,:S-READ-DATE                                                 
MFA-TR*           ,:S-BILL-FROM                                                 
MFA-TR*           ,:S-BILL-TO                                                   
MFA-TR*           ,:S-MAIL-DATE                                                 
MFA-TR*           ,:S-BILL-DUE-DATE                                             
MFA-TR*           ,:S-AVOID-LPC-DATE                                            
MFA-TR*           ,:S-FIRST-NOTICE-DATE                                         
MFA-TR*           ,:S-SECOND-NOTICE-DATE                                        
MFA-TR*           ,:S-DNP-DATE                                                  
MFA-TR*           ,:S-DUE-EXCEPT                                                
MFA-TR*           ,:S-SECOND-EXCEPT                                             
MFA-TR*           ,:S-DNP-EXCEPT                                                
MFA-TR*           ,:S-SECOND-FIELD-DATE                                         
MFA-TR*           ,:S-THIRD-PTY-READ-DT                                         
MFA-TR*           ,:S-EXCEPT-IVR-DT                                             
MFA-TR*        )                                                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
REARCH      MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                      
      *                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
               ADD +1 TO CTR-ROWS                                       
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02364_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
               PERFORM 9000-SEND-ERROR-RESULT          THRU 9000-EXIT   
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
REARCH     END-IF.                                                      
      *                                                                         
       8100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 9700-PROCESS-ABEND - COMBINED ERROR HANDLING INCLUDE           *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD0023C                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE                      *        
      ******************************************************************        
           EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
           END-EXEC.                                                            
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
