000100 IDENTIFICATION DIVISION.                                         
REARCH PROGRAM-ID.  CSR02357.                                           
000300 DATE-WRITTEN. MAR 02, 1998.                                      
000400 DATE-COMPILED.                                                   
000500                                                                  
000600******************************************************************        
000700*                SOUTH CAROLINA ELECTRIC & GAS                   *        
000800*                                                                *        
000900*  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
001000*                                                                *        
001100*  TRANID:        S357                                           *        
001200*  PROGRAM:       S357                                           *        
001300*  CALLING SP:    PN_S357                                        *        
001400*                                                                *        
001500******************************************************************        
001600*                 P R O G R A M  S U M M A R Y                   *        
001700*                                                                *        
001800*  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
001900*  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
002000*                                                                *        
002100*  THIS PROGRAM UPDATES THE DRAFT AMOUNT IN CSS_PNDNG_BNK_DRFT   *        
002300*  BY USING THE ACCOUNT NO.                                      *        
002400*                                                                *        
002500*  INFORMATION WILL BE RETRIEVED FROM THE FOLLOWING TABLES       *        
002600*                                                                *        
002700*  TABLE                  TABLE ID     DCLGEN                    *        
002800*  -----                  --------     ------                    *        
002900*  CSS_PNDNG_BNK_DRFT        PB        TBPDBKDF                  *        
003100******************************************************************        
003200*                                                                *        
003300*                     PROGRAM MODIFICATION LOG                   *        
003400*                                                                *        
003500*    DATE    INITIALS   COMMENTS                                 *        
003600*  --------  --------   -----------------                        *        
003700*  02/29/98    VB       CREATED.                                 *        
003800*                                                                *        
CBSI  *  01/08/99    KP       MC05 ABEND LOG CORRECTIONS               *        
T20563*  04/06/00    DPS      ADD PENDING DRAFT INSERTION REVISIONS    *        
23549**  02/16/01    DPS      ADD EPAY FUNCTIONALITY, ADDED UPDATE    *         
23549 *                       TYPES-'S' FOR BANKDRAFT, 'E' FOR WEB     *        
23549 *                       'U' FOR EPAY UPDATE NON-WEB              *        
25964 *  08/08/02    DPS      ADD EDRAFT REVISIONS                              
T29529*  05/07/04    VV90387  CHANGES DUE TO IMPROVED EPAY PROCESS     *        
REARCH*  06/02/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
C33861*  12/10/07  CB18344    ACTIVITY 3 - MADE CHANGE TO PUT CORRECT  *        
C33861*                       RESP AREA IN TRANS HIST WHEN SCHEDULING  *        
C33861*                       AN EPAYMENT.                             *        
P00613*  02/11/14  LG41184    TO UPDATE USER_ID IN PNDNG_BNK_DRFT TABLE*        
003900******************************************************************        
004000******************************************************************        
004100*                                                                *        
004200*                -- BASIC SEQUENCE STRUCTURE --                  *        
004300*                                                                *        
004400*  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
004500*  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
004600*  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
004700*  3000 - 4999  NOT USED                                         *        
004800*  5000 - 5999  COMMON PROGRAM MODULES                           *        
004900*  6000 - 6999  COMMON SYSTEM MODULES                            *        
005000*  7000 - 7999  INPUT MODULES                                    *        
005100*  8000 - 8999  OUTPUT MODULES                                   *        
005200*  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
005300*                                                                *        
005400******************************************************************        
005500                                                                  
005600 ENVIRONMENT DIVISION.                                            
005700 DATA DIVISION.                                                   
005800 WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02357'.
MSQ017     COPY MFASQLM.
005900                                                                  
006000 01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02357 STARTS HERE'.                  
006200                                                                  
006300******************************************************************        
006400*    DB2 INCLUDES                                                *        
006500******************************************************************        
006600                                                                  
006700     EXEC SQL                                                             
006800        INCLUDE SQLCA                                                     
006900     END-EXEC.                                                            
007000                                                                  
007100     EXEC SQL                                                             
007200        INCLUDE TBINTACT                                                  
007300     END-EXEC.                                                            
007400                                                                  
007500     EXEC SQL                                                             
007600        INCLUDE TBMODEL                                                   
007700     END-EXEC.                                                            
008300                                                                  
008400*----< CSS_PNDNG_BNK_DRFT >                                               
008500     EXEC SQL                                                             
008600        INCLUDE TBPDBKDF                                                  
008700     END-EXEC.                                                            
                                                                        
003300     EXEC SQL                                                             
003400        INCLUDE TBMNHIST                                                  
003500     END-EXEC.                                                            
003600                                                                  
003700     EXEC SQL                                                             
003800        INCLUDE TBMNHDT                                                   
003900     END-EXEC.                                                            
                                                                        
004100     EXEC SQL                                                             
004200        INCLUDE TBUSRPRF                                                  
004300     END-EXEC.                                                            
C29529                                                                  
C29529     EXEC SQL                                                             
C29529        INCLUDE TBBNKEFT                                                  
C29529     END-EXEC.                                                            
C29529                                                                  
C29529     EXEC SQL                                                             
C29529        INCLUDE TBCSTBNK                                                  
C29529     END-EXEC.                                                            
008800                                                                  
008900******************************************************************        
009000*    COBOL WORKING STORAGE COPY BOOKS                            *        
009100******************************************************************        
009200                                                                  
009800*----<COMMON SYSTEM AREA >                                                
009900     COPY CCA00001.                                                       
010200*----< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >                   
010300     COPY CWS00027.                                                       
010400*----< SUPPORTS DB2 AND SQL ERROR CHECKING >                              
010500     COPY CWS00303.                                                       
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
010600                                                                  
010700******************************************************************        
010800*    WORK AREAS                                                  *        
010900******************************************************************        
011000                                                                  
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                      VALUE 'SESSION.CSR02357_R1'.
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
012300 01  FILLER                        PIC X(11) VALUE 'PARM FIELDS'. 
012400                                                                  
013200 01  MISC-FIELDS.                                                 
013300     05  WS-ACCOUNT-NO            PIC X(13).                      
013400     05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
013500                                  PIC 9(13).                      
COB305     05 WS-ACCOUNT-NO-COMP3        PIC S9(13)V COMP-3 VALUE 0.            
013700                                                                  
013800     05  WS-DRAFT-AMT             PIC  X(11).                     
013900     05  WS-DRAFT-AMT-NUM REDEFINES WS-DRAFT-AMT                  
014000                                  PIC  9(09)V99.                  
014100     05  WS-DRAFT-AMT-COMP3       PIC S9(09)V99 COMP-3 VALUE +0.  
014100     05  WS-DRAFT-AMT-COMP3-OLD   PIC S9(09)V99 COMP-3 VALUE +0.  
014100     05  WS-DRAFT-AMT-NEW         PIC $(08)9.99.                  
014100     05  WS-DRAFT-AMT-OLD         PIC $(08)9.99.                  
T29529     05  WS-BANK-SEQ-NUM          PIC X(09).                      
T29529     05  WS-BANK-SEQ-NO           REDEFINES WS-BANK-SEQ-NUM       
T29529                                  PIC 9(09).                      
T29529     05  WS-BANK-SEQ-NO-COMP      PIC S9(09) COMP.                
T29529     05  WS-CURR-TS               PIC X(26).                      
014200                                                                  
23549      05  WS-EPAY-USER             PIC X(07) VALUE 'WEBTRN1'.      
23549      05  WS-UPDATE-TRAN           PIC X(01) VALUE SPACE.          
23549          88 EPAY-TRAN    VALUE 'E'.                               
23549          88 DRAFT-TRAN   VALUE 'S'.                               
23549          88 EPAY-NONWEB-TRAN VALUE 'U'.                           
25964          88 EDRAFT-TRAN  VALUE 'I'.                               
23549      05  WS-NEW-TXT              PIC X(5) VALUE '*NEW*'.          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02357'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE SPACES.          
REARCH*                                                                         
014300 01  SNA-FIELDS.                                                  
014400     05  SNA-SUBC                  PIC S9(9)   COMP.              
014500     05  SNA-CONNECTION-NAME       PIC X(8)    VALUE SPACES.      
014600                                                                  
014700 01  COUNTER-FIELDS.                                              
014800     05  CTR-COLUMN                PIC S9(9)   COMP VALUE 1.      
014900     05  CTR-ROWS                  PIC S9(9)   COMP VALUE 0.      
015000     05  WS-ROW-COUNT              PIC S9(9)   COMP VALUE 0.      
015100                                                                  
015200 01  WORK-FIELDS.                                                 
015300     05  MAX-LENGTH-PARM           PIC S9(9)   COMP.              
015400     05  WRKLEN1                   PIC S9(9)   COMP.              
015500     05  WRKLEN2                   PIC S9(9)   COMP.              
015600     05  WRK-DONE-STATUS           PIC S9(9)   COMP.              
015700                                                                  
015800 01  WS-FLAG-VALUES.                                              
015900     05  WS-YES                    PIC X(01)   VALUE 'Y'.         
016000     05  WS-NO                     PIC X(01)   VALUE 'N'.         
016100     05  WS-ACTIVE-CODE            PIC X(01)   VALUE 'A'.         
016200 01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
016300                                                                  
016400 01  TDS-RETURN-FIELDS.                                           
016500     05  RS-RETURN-CODE            PIC S9(09)  COMP VALUE 0.      
T29529     05  RS-PYMT-TRAN-TS           PIC X(26).                     
016900                                                                  
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-PYMT-TRAN-TS          PIC X(26).                       
                                                                        
018000 01  SWITCHES.                                                    
018100     05  ALL-DONE-SW               PIC X(01) VALUE 'N'.           
018200         88 NOT-ALL-DONE                     VALUE 'N'.           
018300         88 ALL-DONE                         VALUE 'Y'.           
018100     05  DRAFTS-DELETE-SW          PIC X(01) VALUE 'N'.           
018300         88 ALL-DRAFTS-DELETED               VALUE 'Y'.           
018400     05  SEND-DONE-SW              PIC X(01) VALUE 'Y'.           
018500         88 SEND-DONE-ERROR                  VALUE 'N'.           
018600         88 SEND-DONE-OK                     VALUE 'Y'.           
018700                                                                  
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME               PIC X(18)      VALUE SPACES.     
REARCH     10  S-SQLCODE               PIC S9(9) COMP VALUE 0.          
REARCH     10  S-SQLSTATE              PIC X(5)       VALUE ' '.        
REARCH     10  S-TABLE-NAME            PIC X(18)      VALUE SPACES.     
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L  PIC S9(4) USAGE COMP.            
REARCH         49  S-HOST-VARIABLES-V  PIC X(255).                      
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L   PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-STATEMENT-V   PIC X(255).                      
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L PIC S9(4) USAGE COMP.            
REARCH         49  S-SQL-DESCRIPTION-V PIC X(255).                      
REARCH*                                                                         
      ***************************************************************** 01910000
      * CURSOR FOR FETCHING FROM CSS_PNDNG_BNK_DRFT.                  * 01920000
      ***************************************************************** 01930000
      *                                                                         
           EXEC SQL                                                     
              DECLARE  CSS_DRAFT CURSOR FOR                             
               SELECT ACCOUNT_NO                                        
                      ,DRAFT_DATE                                       
                      ,DRAFT_AMT                                        
                      ,TRANSACTION_CD                                   
                      ,CODE_SOURCE_ID                                   
T29529                ,CUST_BANK_SEQ_NO                                 
T29529                ,PYMT_POSTED_FL                                   
T29529                ,REPLACE(REPLACE(CONVERT(CHAR(26), PYMT_TRANS_TS
           , 121), ' ', '-'), ':', '.') PYMT_TRANS_TS                          
                 FROM CSS_PNDNG_BNK_DRFT                                
                WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                       
T29529            AND CODE_SOURCE_ID IN ('S', 'I')                      
                FOR UPDATE OF ACCOUNT_NO                                
                              ,DRAFT_DATE                               
                              ,DRAFT_AMT                                
                              ,TRANSACTION_CD                           
                              ,CODE_SOURCE_ID                           
T29529                        ,CUST_BANK_SEQ_NO                         
T29529                        ,PYMT_POSTED_FL                           
T29529                        ,PYMT_TRANS_TS                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     01940000
MFA-TR*       DECLARE  CSS_DRAFT CURSOR FOR                             01950000
MFA-TR*        SELECT ACCOUNT_NO                                        01960000
MFA-TR*               ,DRAFT_DATE                                       01970000
MFA-TR*               ,DRAFT_AMT                                        01980000
MFA-TR*               ,TRANSACTION_CD                                   01990000
MFA-TR*               ,CODE_SOURCE_ID                                   02000000
MFA-TR*               ,CUST_BANK_SEQ_NO                                         
MFA-TR*               ,PYMT_POSTED_FL                                           
MFA-TR*               ,PYMT_TRANS_TS                                            
MFA-TR*          FROM CSS_PNDNG_BNK_DRFT                                02010000
MFA-TR*         WHERE ACCOUNT_NO = :PB-ACCOUNT-NO                       02020000
MFA-TR*           AND CODE_SOURCE_ID IN ('S', 'I')                              
MFA-TR*         FOR UPDATE OF ACCOUNT_NO                                02030008
MFA-TR*                       ,DRAFT_DATE                               02040008
MFA-TR*                       ,DRAFT_AMT                                02050008
MFA-TR*                       ,TRANSACTION_CD                           02060008
MFA-TR*                       ,CODE_SOURCE_ID                           02070008
MFA-TR*                       ,CUST_BANK_SEQ_NO                                 
MFA-TR*                       ,PYMT_POSTED_FL                                   
MFA-TR*                       ,PYMT_TRANS_TS                                    
MFA-TR*    END-EXEC.                                                    02080000
REARCH*                                                                         
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO           PIC X(13).                         
REARCH 01  PARM-DRAFT-AMT            PIC X(11).                         
REARCH 01  PARM-USERID               PIC X(08).                         
REARCH 01  PARM-COMMENTS             PIC X(210).                        
REARCH 01  PARM-DRAFT-DATE           PIC X(10).                         
REARCH 01  PARM-ACCT-TYPE-CD         PIC X(01).                         
REARCH 01  PARM-ORIGINAL-DATE        PIC X(10).                         
REARCH 01  PARM-UPDATE-TYPE          PIC X(01).                         
REARCH 01  PARM-INIT-TYPE-CD         PIC X(02).                         
REARCH 01  PARM-BANK-SEQ-NO          PIC X(09).                         
REARCH 01  PARM-PYMT-TRANS-TS        PIC X(26).                         
REARCH*                                                                 02090000
HPCCDM*EJECT                                                                    
REARCH*                                                                 02090000
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO                         
REARCH                          PARM-DRAFT-AMT                          
REARCH                          PARM-USERID                             
REARCH                          PARM-COMMENTS                           
REARCH                          PARM-DRAFT-DATE                         
REARCH                          PARM-ACCT-TYPE-CD                       
REARCH                          PARM-ORIGINAL-DATE                      
REARCH                          PARM-UPDATE-TYPE                        
REARCH                          PARM-INIT-TYPE-CD                       
REARCH                          PARM-BANK-SEQ-NO                        
REARCH                          PARM-PYMT-TRANS-TS.                     
019000                                                                  
019100******************************************************************        
019200* 0000-MAINLINE                                                  *        
019300*     CALLS 0100-INITIALIZE                                      *        
019400*           1000-PROCESS-INPUT                                   *        
019500*           2000-PROCESS-OUTPUT                                  *        
019600*           9999-END-PROGRAM                                     *        
019700*                                                                *        
019800*     CONTROLS THE MAIN PNBM OF THE PROGRAM                      *        
019900******************************************************************        
020000                                                                  
020100 0000-MAINLINE.                                                   
020200                                                                  
020300     PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
020400     PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
020500     PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
020600     PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
020700                                                                  
020800 0000-EXIT.                                                       
020900     EXIT.                                                        
021000                                                                  
021100******************************************************************        
021200* 0100-INITIALIZE                                                *        
021300*     CALLS 9000-SEND-ERROR-RESULT                               *        
021400*           9900-SQL-ERROR-ROUTINE                               *        
021500*                                                                *        
021600*     CALLED FROM 0000-MAINLINE                                  *        
021700*                                                                *        
021800*     1. RESET DB2 ERROR HANDLERS                                *        
021900*     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *        
022000*     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *        
022100*     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*        
022200*                                                                *        
022300******************************************************************        
022400                                                                  
022500 0100-INITIALIZE.                                                 
022600                                                                  
022700     MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
022800                                                                  
022900     EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
023000     EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
023100     EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
REARCH     PERFORM 0100A-DECLARE-GTT   THRU 0100A-EXIT.                 
                                                                        
REARCH     EXEC SQL                                                     
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH           *                                                      
REARCH         FROM                                                     
REARCH             #CSR02357_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*          *                                                      01670000
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02357_R1                                          
MFA-TR*    END-EXEC.                                                    02850000
024800 0100-EXIT.                                                       
024900     EXIT.                                                        
025000                                                                  
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02357_R1'            
REARCH                                    TO S-SQL-STATEMENT-V.         
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02357_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02357_R1
              (                                                       
REARCH               RETURN_CODE           INT                      
REARCH              ,PYMT_TRAN_TS CHAR(26)  COLLATE 
                                  LATIN1_GENERAL_100_BIN2                     
REARCH          )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH     MOVE SQLSTATE            TO WS-SQLSTATE.                     
REARCH     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
REARCH*                                                                         
REARCH     IF WS-SQLSTATE = '42710'                                     
REARCH        PERFORM 8000A-DELETE-GTT-ROWS THRU 8000A-EXIT             
REARCH     ELSE                                                         
REARCH        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
REARCH               NEXT SENTENCE                                      
REARCH        ELSE                                                      
REARCH           MOVE PROGRAM-NAME       TO ABEND-PROGRAM               
REARCH           MOVE SQLCODE            TO ABEND-SQLCODE               
REARCH           MOVE SQLSTATE           TO ABEND-SQLSTATE              
REARCH           MOVE '0100A'            TO ACTIVE-PARAGRAPH            
REARCH           MOVE 'DECLARE GTT'      TO ABEND-FUNCTION              
REARCH           MOVE SPACES             TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH           MOVE 'CSR02357_R1'      TO TABLE-1                     
REARCH           MOVE SPACES             TO TABLE-ELEMENT-1             
REARCH           MOVE SPACES             TO HOSTVAR-ELEMENT-1           
REARCH           PERFORM 9900-SQL-ERROR-ROUTINE                         
REARCH                                   THRU  9900-EXIT                
REARCH        END-IF                                                    
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH      EXIT.                                                       
REARCH*                                                                         
025100******************************************************************        
025200* 1000-PROCESS-INPUT                                             *        
025300*     CALLS 1100-RECEIVE-PARMS                                   *        
025400*                                                                *        
025500*     CALLED FROM 0000-MAINLINE                                  *        
025600*                                                                *        
025700*     1. RECEIVE PARMS.                                          *        
025800******************************************************************        
025900                                                                  
026000 1000-PROCESS-INPUT.                                              
026100                                                                  
026300                                                                  
026400     MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
026500     MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.             
026600     MOVE WS-ACCOUNT-NO-COMP3 TO PB-ACCOUNT-NO.                   
T20563     IF PARM-ORIGINAL-DATE NOT = SPACES                           
T20563        MOVE PARM-ORIGINAL-DATE TO PB-DRAFT-DATE                  
T20563     ELSE                                                         
026600        MOVE PARM-DRAFT-DATE     TO PB-DRAFT-DATE
           END-IF.                
23549      MOVE PARM-UPDATE-TYPE TO WS-UPDATE-TRAN.                     
25964      IF DRAFT-TRAN AND PARM-INIT-TYPE-CD = '02'                   
25964         MOVE 'I' TO WS-UPDATE-TRAN
           END-IF.                               
027200 1000-EXIT.                                                       
027300     EXIT.                                                        
027400                                                                  
032400******************************************************************        
032500* 2000-PROCESS-OUTPUT.                                           *        
032600*     CALLS 2101-DESC-RET-CODE                                   *        
23549 *           2500-PROCESS-DRAFT-EPAY                              *        
032800*           8100-SEND-RESULT                                     *        
032900*                                                                *        
033000*      CALLED FROM 0000-MAINLINE                                 *        
033100*                                                                *        
033200*      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *        
033300*      AND SENDS THEM BACK                                       *        
033400******************************************************************        
033500                                                                  
033600 2000-PROCESS-OUTPUT.                                             
033700                                                                  
033800     MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
033900                                                                  
23549      PERFORM 2500-PROCESS-DRAFT-EPAY       THRU 2500-EXIT.        
034200                                                                  
034300 2000-EXIT.                                                       
034400     EXIT.                                                        
034500                                                                  
REARCH******************************************************************03490000
REARCH* 2000A-MOVE-RESULT.                                             *03500000
REARCH******************************************************************03570000
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE  RS-RETURN-CODE       TO S-RETURN-CODE.                 
REARCH     MOVE  RS-PYMT-TRAN-TS      TO S-PYMT-TRAN-TS.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH      EXIT.                                                       
056500                                                                  
056600******************************************************************        
23549 * 2500-PROCESS-DRAFT-EPAY                                        *        
056800*                                                                *        
056900*     CALLS  2525-PROCESS-DRAFT WHICH PROCESSES                  *        
25964 *             DRAFTS,EDRAFTS OR EPAY FROM THE PANEL 092                   
23549 *         OR 2550-PROCESS-EPAY WHICH IS CALLED                            
23549 *             FROM THE WEB. 2550 ONLY INSERTS.                            
23549 *                                                                         
23549 *            7100-SELECT-PNDNG-DRFT                                       
057100*            7200-UPDATE-PNDNG-DRFT                              *        
057200*            8100-SEND-RESULT                                    *        
PCR285*            7800-SELECT-TIMESTAMP-DATE                          *        
PCR285*            7802-SELECT-RESP-AREA                               *        
065432*            6530-LOAD-MNT-TRANS-HIST                            *        
057300*                                                                *        
057400*     CALLED FROM 2000-PROCESS-OUTPUT                            *        
057500*                                                                *        
057600*     PROCESS THE UPDATE.                                        *        
057700******************************************************************        
057800                                                                  
23549  2500-PROCESS-DRAFT-EPAY.                                         
058000                                                                  
058100     MOVE '2500'                          TO ACTIVE-PARAGRAPH.    
PCR285     PERFORM 7800-SELECT-TIMESTAMP-DATE   THRU 7800-EXIT.         
T29529     MOVE MH-TRANS-HIST-SEQ-NO            TO WS-CURR-TS           
T29529                                             RS-PYMT-TRAN-TS.     
NEWNEW     INITIALIZE MI-TRAN-APPL-NO.                                  
C33861     MOVE PARM-USERID                     TO PF-USER-ID,          
P00613                                             PB-USER-ID.          
25964      IF EPAY-TRAN                                                 
25964         PERFORM 2550-PROCESS-EPAY THRU 2550-EXIT                  
25964      ELSE                                                         
25964         PERFORM 2525-PROCESS-DRAFT THRU 2525-EXIT
           END-IF.                
C33861     PERFORM 7802-SELECT-RESP-AREA        THRU 7802-EXIT.         
065318     MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE LENGTH OF PARM-COMMENTS  TO MH-TRAN-COMMENT-LEN.        
           MOVE PARM-COMMENTS            TO MH-TRAN-COMMENT-TEXT.       
25964      EVALUATE TRUE                                                
25964      WHEN EPAY-TRAN                                               
25964*       MOVE SPACES TO MH-RESP-AREA-ID                             
25964        MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID           
25964        MOVE 'PANELWEBE'              TO MH-APPL-PROGRAM-ID        
T29529     WHEN DRAFT-TRAN OR EPAY-NONWEB-TRAN                          
25964        MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID           
25964        MOVE 'PANEL092'               TO MH-APPL-PROGRAM-ID        
25964      WHEN EDRAFT-TRAN                                             
25964        MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID           
25964        MOVE 'PANEL092E'              TO MH-APPL-PROGRAM-ID        
25964      END-EVALUATE.                                                
000000     MOVE WS-ACCOUNT-NO-COMP3      TO MH-ACCOUNT-NO.              
000000     MOVE 0                        TO MH-CUSTOMER-NO.             
000000     MOVE 0                        TO MH-PREMISE-NO.              
000000     MOVE PF-USER-ID               TO MH-USER-ID.                 
000000     MOVE MH-TRANS-HIST-SEQ-NO     TO MI-TRANS-HIST-SEQ-NO.       
065412     MOVE +12                      TO MI-CHG-COLUMN-VALUE-LEN.    
065414     MOVE WS-DRAFT-AMT-COMP3       TO WS-DRAFT-AMT-NEW.           
065414     MOVE WS-DRAFT-AMT-NEW         TO MI-CHG-COLUMN-VALUE-TEXT.   
23549      IF WS-DRAFT-AMT-COMP3-OLD > 0                                
065424       MOVE WS-DRAFT-AMT-COMP3-OLD   TO WS-DRAFT-AMT-OLD          
065424       MOVE WS-DRAFT-AMT-OLD         TO MI-PRV-COLUMN-VALUE-TEXT  
065422       MOVE +12                      TO MI-PRV-COLUMN-VALUE-LEN   
23549      ELSE                                                         
23549        MOVE WS-NEW-TXT               TO MI-PRV-COLUMN-VALUE-TEXT  
23549        MOVE +05                      TO MI-PRV-COLUMN-VALUE-LEN   
23549      END-IF.                                                      
065431     MOVE 'DRAFT AMOUNT   '        TO MI-COLUMN-DESC.             
T20563     IF WS-DRAFT-AMT-OLD = WS-DRAFT-AMT-NEW                       
T20563       NEXT SENTENCE                                              
T20563     ELSE                                                         
NEWNEW       EVALUATE MI-TRAN-APPL-NO                                   
NEWNEW         WHEN 0            MOVE 1 TO MI-TRAN-APPL-NO              
NEWNEW         WHEN OTHER        ADD 1 TO MI-TRAN-APPL-NO               
NEWNEW       END-EVALUATE                                               
065432       PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT           
T20563     END-IF.                                                      
T20563     IF PARM-DRAFT-DATE NOT = PARM-ORIGINAL-DATE                  
T20563        EVALUATE MI-TRAN-APPL-NO                                  
T20563         WHEN 0            MOVE 1 TO MI-TRAN-APPL-NO              
T20563         WHEN OTHER        ADD 1 TO MI-TRAN-APPL-NO               
T20563        END-EVALUATE                                              
T20563        MOVE MH-TRANS-HIST-SEQ-NO  TO MI-TRANS-HIST-SEQ-NO        
T20563        MOVE +10                   TO MI-CHG-COLUMN-VALUE-LEN     
T20563        MOVE PARM-DRAFT-DATE       TO MI-CHG-COLUMN-VALUE-TEXT    
23549         IF PARM-ORIGINAL-DATE = SPACES                            
23549           MOVE WS-NEW-TXT         TO MI-PRV-COLUMN-VALUE-TEXT     
23549           MOVE +5                 TO MI-PRV-COLUMN-VALUE-LEN      
23549         ELSE                                                      
23549           MOVE PARM-ORIGINAL-DATE    TO MI-PRV-COLUMN-VALUE-TEXT  
23549           MOVE +10                   TO MI-PRV-COLUMN-VALUE-LEN   
23549         END-IF                                                    
T20563        MOVE 'DRAFT DATE   '       TO MI-COLUMN-DESC              
T20563        PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT           
T20563     ELSE                                                         
T20563        NEXT SENTENCE                                             
T20563     END-IF.                                                      
REARCH     PERFORM 2000A-MOVE-RESULT         THRU 2000A-EXIT.           
060300     PERFORM 8100-SEND-RESULT          THRU 8100-EXIT.            
060400 2500-EXIT.                                                       
060500     EXIT.                                                        
23549                                                                   
23549  2525-PROCESS-DRAFT.                                              
25964      EVALUATE TRUE                                                
25964      WHEN EPAY-NONWEB-TRAN                                        
23549        MOVE 'E' TO PB-CODE-SOURCE-ID                              
23549      WHEN DRAFT-TRAN                                              
23549        MOVE 'S' TO PB-CODE-SOURCE-ID                              
25964      WHEN EDRAFT-TRAN                                             
25964        MOVE 'I' TO PB-CODE-SOURCE-ID                              
23549      END-EVALUATE.                                                
T29529     MOVE PARM-PYMT-TRANS-TS            TO PB-PYMT-TRANS-TS.      
23549      PERFORM 7100-SELECT-PNDNG-DRFT       THRU 7100-EXIT.         
23549      IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
23549        OR PARM-ORIGINAL-DATE NOT = PARM-DRAFT-DATE                
23549         PERFORM 7600-OPEN-DRAFT-CURSR     THRU 7600-EXIT          
23549         PERFORM 2600-PROCESS-OLD-DRAFTS   THRU 2600-EXIT          
23549           UNTIL ALL-DRAFTS-DELETED                                
23549         PERFORM 7700-CLOSE-DRAFT-CURSR    THRU 7700-EXIT          
23549       MOVE PARM-DRAFT-AMT               TO WS-DRAFT-AMT           
23549       MOVE WS-DRAFT-AMT-NUM             TO WS-DRAFT-AMT-COMP3     
23549       MOVE WS-DRAFT-AMT-COMP3           TO PB-DRAFT-AMT           
23549       MOVE PARM-DRAFT-DATE              TO PB-DRAFT-DATE          
23549       EVALUATE PARM-ACCT-TYPE-CD                                  
23549        WHEN 'C'   MOVE  '27' TO PB-TRANSACTION-CD                 
23549        WHEN 'S'   MOVE  '37' TO PB-TRANSACTION-CD                 
23549       END-EVALUATE                                                
25964       EVALUATE TRUE                                               
25964        WHEN EPAY-NONWEB-TRAN                                      
23549          MOVE 'E' TO PB-CODE-SOURCE-ID                            
23549        WHEN DRAFT-TRAN                                            
23549          MOVE 'S' TO PB-CODE-SOURCE-ID                            
25964        WHEN EDRAFT-TRAN                                           
25964          MOVE 'I' TO PB-CODE-SOURCE-ID                            
23549       END-EVALUATE                                                
T29529      MOVE PARM-BANK-SEQ-NO              TO WS-BANK-SEQ-NUM       
T29529      MOVE WS-BANK-SEQ-NO                TO WS-BANK-SEQ-NO-COMP   
T29529      MOVE WS-BANK-SEQ-NO-COMP           TO PB-CUST-BANK-SEQ-NO   
TEMP        IF PB-CUST-BANK-SEQ-NO EQUAL ZEROES                         
TEMP           MOVE PB-ACCOUNT-NO              TO BE-ACCOUNT-NO         
TEMP           PERFORM 7910-GET-PMY-BNK-SEQ-NO THRU 7910-EXIT           
TEMP           MOVE BE-CUST-BANK-SEQ-NO        TO PB-CUST-BANK-SEQ-NO   
TEMP        END-IF                                                      
T29529      MOVE WS-NO                         TO PB-PYMT-POSTED-FL     
T29529      MOVE WS-CURR-TS                    TO PB-PYMT-TRANS-TS      
23549       PERFORM 7500-INSERT-PNDNG-DRFT    THRU 7500-EXIT            
23549      ELSE                                                         
23549        MOVE PARM-DRAFT-AMT               TO WS-DRAFT-AMT          
23549        MOVE WS-DRAFT-AMT-NUM             TO WS-DRAFT-AMT-COMP3    
23549        MOVE WS-DRAFT-AMT-COMP3           TO PB-DRAFT-AMT          
23549        MOVE PARM-DRAFT-DATE              TO PB-DRAFT-DATE         
T29529       MOVE PARM-BANK-SEQ-NO             TO WS-BANK-SEQ-NUM       
T29529       MOVE WS-BANK-SEQ-NO               TO WS-BANK-SEQ-NO-COMP   
T29529       MOVE WS-BANK-SEQ-NO-COMP          TO PB-CUST-BANK-SEQ-NO   
25964        EVALUATE TRUE                                              
25964         WHEN EPAY-NONWEB-TRAN                                     
23549           MOVE 'E' TO PB-CODE-SOURCE-ID                           
23549         WHEN DRAFT-TRAN                                           
23549           MOVE 'S' TO PB-CODE-SOURCE-ID                           
25964         WHEN EDRAFT-TRAN                                          
25964           MOVE 'I' TO PB-CODE-SOURCE-ID                           
23549        END-EVALUATE                                               
T29529       MOVE PARM-PYMT-TRANS-TS           TO PB-PYMT-TRANS-TS      
23549        PERFORM 7200-UPDATE-PNDNG-DRFT    THRU 7200-EXIT           
23549      END-IF.                                                      
23549  2525-EXIT.                                                       
23549                                                                   
23549  2550-PROCESS-EPAY.                                               
23549      MOVE PARM-DRAFT-AMT               TO WS-DRAFT-AMT.           
23549      MOVE WS-DRAFT-AMT-NUM             TO WS-DRAFT-AMT-COMP3.     
23549      MOVE WS-DRAFT-AMT-COMP3           TO PB-DRAFT-AMT.           
23549      MOVE PARM-DRAFT-DATE              TO PB-DRAFT-DATE.          
23549      EVALUATE PARM-ACCT-TYPE-CD                                   
23549       WHEN 'C'   MOVE  '27' TO PB-TRANSACTION-CD                  
23549       WHEN 'S'   MOVE  '37' TO PB-TRANSACTION-CD                  
23549      END-EVALUATE.                                                
23549      MOVE 'E'                          TO PB-CODE-SOURCE-ID.      
T29529     MOVE PARM-BANK-SEQ-NO             TO WS-BANK-SEQ-NUM.        
T29529     MOVE WS-BANK-SEQ-NO               TO WS-BANK-SEQ-NO-COMP.    
T29529     MOVE WS-BANK-SEQ-NO-COMP          TO PB-CUST-BANK-SEQ-NO.    
T29529     MOVE WS-NO                        TO PB-PYMT-POSTED-FL.      
T29529     MOVE WS-CURR-TS                   TO PB-PYMT-TRANS-TS.       
23549      PERFORM 7500-INSERT-PNDNG-DRFT    THRU 7500-EXIT.            
065318     MOVE 'F'                      TO MH-CODE-TRAN-TYPE.          
           MOVE LENGTH OF PARM-COMMENTS  TO MH-TRAN-COMMENT-LEN.        
           MOVE PARM-COMMENTS            TO MH-TRAN-COMMENT-TEXT.       
25964      EVALUATE TRUE                                                
25964      WHEN EPAY-TRAN                                               
25964*       MOVE SPACES TO MH-RESP-AREA-ID                             
C33861*      MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID                   
25964        MOVE 'PANELWEBE'              TO MH-APPL-PROGRAM-ID        
T29529     WHEN DRAFT-TRAN OR EPAY-NONWEB-TRAN                          
25964        MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID           
25964        MOVE 'PANEL092'               TO MH-APPL-PROGRAM-ID        
25964      WHEN EDRAFT-TRAN                                             
25964        MOVE PF-RESP-AREA-ID          TO MH-RESP-AREA-ID           
25964        MOVE 'PANEL092E'              TO MH-APPL-PROGRAM-ID        
25964      END-EVALUATE.                                                
000000     MOVE WS-ACCOUNT-NO-COMP3      TO MH-ACCOUNT-NO.              
000000     MOVE 0                        TO MH-CUSTOMER-NO.             
000000     MOVE 0                        TO MH-PREMISE-NO.              
000000     MOVE PF-USER-ID               TO MH-USER-ID.                 
C29529     EVALUATE MI-TRAN-APPL-NO                                     
C29529        WHEN 0      MOVE 1 TO MI-TRAN-APPL-NO                     
C29529        WHEN OTHER  ADD 1 TO MI-TRAN-APPL-NO                      
C29529     END-EVALUATE                                                 
C29529     MOVE MH-TRANS-HIST-SEQ-NO    TO MI-TRANS-HIST-SEQ-NO         
C29529     MOVE +9                      TO MI-CHG-COLUMN-VALUE-LEN      
C29529     MOVE PARM-BANK-SEQ-NO        TO MI-CHG-COLUMN-VALUE-TEXT     
C29529     MOVE WS-NEW-TXT              TO MI-PRV-COLUMN-VALUE-TEXT     
C29529     MOVE +5                      TO MI-PRV-COLUMN-VALUE-LEN      
C29529     MOVE 'BANK SEQ NO  '         TO MI-COLUMN-DESC               
C29529     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
C29529     MOVE PB-ACCOUNT-NO           TO BE-ACCOUNT-NO                
C29529     MOVE PB-CUST-BANK-SEQ-NO     TO JF-CUST-BANK-SEQ-NO          
C29529     PERFORM 7900-GET-BANK-NICKNAME   THRU 7900-EXIT.             
C29529     EVALUATE MI-TRAN-APPL-NO                                     
C29529        WHEN 0      MOVE 1 TO MI-TRAN-APPL-NO                     
C29529        WHEN OTHER  ADD 1 TO MI-TRAN-APPL-NO                      
C29529     END-EVALUATE                                                 
C29529     MOVE MH-TRANS-HIST-SEQ-NO       TO MI-TRANS-HIST-SEQ-NO      
C29529     MOVE +50                        TO MI-CHG-COLUMN-VALUE-LEN   
C29529     MOVE JF-BANK-ACCT-NICKNAME-TEXT TO MI-CHG-COLUMN-VALUE-TEXT  
C29529     MOVE WS-NEW-TXT                 TO MI-PRV-COLUMN-VALUE-TEXT  
C29529     MOVE +5                         TO MI-PRV-COLUMN-VALUE-LEN   
C29529     MOVE 'BANK NICKNAME'            TO MI-COLUMN-DESC            
C29529     PERFORM 6530-LOAD-MNT-TRANS-HIST THRU 6530-EXIT.             
23549  2550-EXIT.                                                       
       2600-PROCESS-OLD-DRAFTS.                                         
           PERFORM 7300-FETCH-ALL-DRAFTS     THRU 7300-EXIT             
063200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7400-DELETE-DRAFTS     THRU 7400-EXIT             
           ELSE                                                         
              SET ALL-DRAFTS-DELETED         TO TRUE                    
           END-IF.                                                      
060400 2600-EXIT.                                                       
060500     EXIT.                                                        
060700******************************************************************        
060800* 7100-SELECT-PNDNG-DRFT                                         *        
      *                                                                *        
T29529* COMMENTED THE FOLLOWING SELECT AS PART OF T29529               *        
060900*                                                                *        
061000*     CALLS 9000-SEND-ERROR-RESULT                               *        
061100*           9900-SQL-ERROR-ROUTINE                               *        
061200*                                                                *        
23549 *     CALLED FROM 2525-PROCESS-DRAFT                             *        
061400*                                                                *        
061500*     RETRIEVES DRAFT AMOUNT FROM CSS_PNDNG_BNK_DRFT.            *        
061600******************************************************************        
061700                                                                  
061800 7100-SELECT-PNDNG-DRFT.                                          
061900*                                                                         
062000     MOVE '7100' TO ACTIVE-PARAGRAPH.                             
062100*                                                                         
062200     EXEC SQL                                                     
062300        SELECT  DRAFT_AMT                                         
062400        INTO    :WS-DRAFT-AMT-COMP3-OLD                           
062500        FROM    CSS_PNDNG_BNK_DRFT                                
062600        WHERE   ACCOUNT_NO = :PB-ACCOUNT-NO                       
                AND   DRAFT_DATE = IIF(TRY_CONVERT(DATE, :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) )                       
23549           AND   CODE_SOURCE_ID = :PB-CODE-SOURCE-ID               
062700     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT  DRAFT_AMT                                                 
MFA-TR*       INTO    :WS-DRAFT-AMT-COMP3-OLD                                   
MFA-TR*       FROM    CSS_PNDNG_BNK_DRFT                                        
MFA-TR*       WHERE   ACCOUNT_NO = :PB-ACCOUNT-NO                               
MFA-TR*         AND   DRAFT_DATE = :PB-DRAFT-DATE                               
MFA-TR*         AND   CODE_SOURCE_ID = :PB-CODE-SOURCE-ID                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

062800*                                                                         
062900     MOVE SQLCODE    TO WS-ACTIVE-RETURN-CODE                     
063000                        RS-RETURN-CODE.                           
063100*                                                                         
063200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
063400        NEXT SENTENCE                                             
063500     ELSE                                                         
063600        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'SELECT'                     TO ABEND-FUNCTION       
063800        MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'DRAFT_DATE'                 TO TABLE-ELEMENT-2      
064000        MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
064000        MOVE PB-DRAFT-DATE                TO HOSTVAR-ELEMENT-2    
064100        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
064200        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
064300     END-IF.                                                      
064400                                                                  
064500 7100-EXIT.                                                       
064600     EXIT.                                                        
069200*                                                                         
069300******************************************************************        
069400* 7200-UPDATE-PNDNG-DRFT                                         *        
069500*                                                                *        
069600*     CALLS 9000-SEND-ERROR-RESULT                               *        
069700*           9900-SQL-ERROR-ROUTINE                               *        
069800*                                                                *        
23549 *     CALLED FROM 2525-PROCESS-DRAFT                             *        
070000*                                                                *        
070100*     UPDATES DRAFT AMOUNT IN CSS_PNDNG_DRFT                     *        
070000*                                                                *        
T29529*     EDRAFTS CAN HAVE ONE-TIME EPAYMENTS WITH CODE-SOURCE-ID 'E'*        
T29529*     AS WELL AS DRAFT PAYMENTS WITH CODE-SOURCE-ID = 'S'        *        
T29529*     AND SO THE CODE-SOURCE-ID CANNOT BE USED FOR UPDATE."      *        
070000*                                                                *        
070200******************************************************************        
070300                                                                  
070400 7200-UPDATE-PNDNG-DRFT.                                          
070500                                                                  
070600     MOVE '7200' TO ACTIVE-PARAGRAPH.                             
070700                                                                  
070800     EXEC SQL                                                     
070900        UPDATE  CSS_PNDNG_BNK_DRFT                                
071000        SET     DRAFT_AMT        = :PB-DRAFT-AMT,                 
T29529                DRAFT_DATE       = IIF(TRY_CONVERT(DATE, 
                                                         :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) ),                
T29529                CUST_BANK_SEQ_NO = :PB-CUST-BANK-SEQ-NO           
071100        WHERE   ACCOUNT_NO = :PB-ACCOUNT-NO                       
T29529          AND   PYMT_TRANS_TS = CIS.CHAR2TIMESTAMP(
                                                      :PB-PYMT-TRANS-TS
              )                 
071200     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE  CSS_PNDNG_BNK_DRFT                                        
MFA-TR*       SET     DRAFT_AMT        = :PB-DRAFT-AMT,                         
MFA-TR*               DRAFT_DATE       = :PB-DRAFT-DATE,                        
MFA-TR*               CUST_BANK_SEQ_NO = :PB-CUST-BANK-SEQ-NO                   
MFA-TR*       WHERE   ACCOUNT_NO = :PB-ACCOUNT-NO                               
MFA-TR*         AND   PYMT_TRANS_TS = :PB-PYMT-TRANS-TS                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

071300                                                                  
071400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
071500                     RS-RETURN-CODE.                              
071600                                                                  
T29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
071900        NEXT SENTENCE                                             
072000     ELSE                                                         
072100        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'UPDATE'                     TO ABEND-FUNCTION       
072300        MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'DRAFT_DATE'                 TO TABLE-ELEMENT-2      
CBSI          MOVE 'DRAFT_AMT'                  TO TABLE-ELEMENT-3      
072500        MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
072500        MOVE PB-DRAFT-DATE                TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-DRAFT-AMT               TO HOSTVAR-ELEMENT-3    
072600        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
072700        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
072800     END-IF.                                                      
072900                                                                  
073000 7200-EXIT.                                                       
073100     EXIT.                                                        
073200                                                                  
060700******************************************************************05880000
060800* 7300-FETCH-ALL-DRAFTS                                          *05890000
060900*                                                                *05900000
060900*     COMMENTED AS PART OF T29529                                *05900000
060900*                                                                *05900000
061000*     CALLS 9000-SEND-ERROR-RESULT                               *05910000
061100*           9900-SQL-ERROR-ROUTINE                               *05920000
061200*                                                                *05930000
061300*     CALLED FROM 2600-PROCESS-OLD-DRAFTS                        *05940000
061400*                                                                *05950000
061500*   SELECTS ALL ROWS FROM CSS_PNDNG_BNK_DRFT FOR THE ACCOUNT_NO  *05960000
061600******************************************************************05970000
061700*                                                                 05980000
061800 7300-FETCH-ALL-DRAFTS.                                           
061900*                                                                 06000000
062000     MOVE '7300' TO ACTIVE-PARAGRAPH.                             
062100*                                                                 06020000
           EXEC SQL                                                     
               FETCH  CSS_DRAFT                                         
                INTO  :PB-ACCOUNT-NO                                    
                     ,:PB-DRAFT-DATE                                    
                     ,:PB-DRAFT-AMT                                     
                     ,:PB-TRANSACTION-CD                                
                     ,:PB-CODE-SOURCE-ID                                
T29529               ,:PB-CUST-BANK-SEQ-NO                              
T29529               ,:PB-PYMT-POSTED-FL                                
T29529               ,:PB-PYMT-TRANS-TS                                 
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

062800*                                                                 06110007
071400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
062800*                                                                 06130000
063200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
063400        NEXT SENTENCE                                             
063500     ELSE                                                         
063600        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'FETCH'                      TO ABEND-FUNCTION       
063800        MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
064000        MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
064100        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
064200        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
064300     END-IF.                                                      
064400*                                                                 06250000
064500 7300-EXIT.                                                       
064600     EXIT.                                                        
069200*                                                                 06280000
060700******************************************************************06290001
060800* 7400-DELETE-DRAFTS                                             *06300001
060900*                                                                *06310001
060900*     COMMENTED AS PART T29529                                   *06310001
060900*                                                                *06310001
061000*     CALLS 9000-SEND-ERROR-RESULT                               *06320001
061100*           9900-SQL-ERROR-ROUTINE                               *06330001
061200*                                                                *06340001
061300*     CALLED FROM 2600-PROCESS-OLD-DRAFTS                        *06350001
061400*                                                                *06360001
061500*   DELETES THE SELECTED ROW IN CSS_PNDNG_BNK_DRFT               *06370001
061600******************************************************************06380001
061700*                                                                 06390001
061800 7400-DELETE-DRAFTS.                                              
061900*                                                                 06410001
062000     MOVE '7400' TO ACTIVE-PARAGRAPH.                             
062100*                                                                 06430001
           EXEC SQL                                                     
               DELETE FROM CSS_PNDNG_BNK_DRFT                           
                WHERE CURRENT OF CSS_DRAFT                              
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

062800*                                                                 06480007
071400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
062800*                                                                 06500001
063200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
063400        NEXT SENTENCE                                             
063500     ELSE                                                         
063600        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'DELETE'                     TO ABEND-FUNCTION       
063800        MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'DRAFT_DATE'                 TO TABLE-ELEMENT-2      
064000        MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
064000        MOVE PB-DRAFT-DATE                TO HOSTVAR-ELEMENT-2    
064100        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
064200        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
064300     END-IF.                                                      
064400*                                                                 06640001
064500 7400-EXIT.                                                       
064600     EXIT.                                                        
069200*                                                                 06670001
060700******************************************************************06680001
060800* 7500-INSERT-PNDNG-DRFT                                         *06690001
060900*                                                                *06700001
061000*     CALLS 9000-SEND-ERROR-RESULT                               *06710001
061100*           9900-SQL-ERROR-ROUTINE                               *06720001
061200*                                                                *06730001
23549 *     CALLED FROM 2525-PROCESS-DRAFT                             *06740001
23549 *                 2550-PROCESS-EPAY                              *06750001
061500*     INSERTS A ROW IN CSS_PNDNG_BNK_DRFT                        *06760001
061600******************************************************************06770001
061700                                                                  
061800 7500-INSERT-PNDNG-DRFT.                                          
061900                                                                  
062000     MOVE '7500' TO ACTIVE-PARAGRAPH.                             
062100                                                                  
           EXEC SQL                                                     
               INSERT INTO CSS_PNDNG_BNK_DRFT                           
                      (ACCOUNT_NO,                                      
                       DRAFT_DATE,                                      
                       DRAFT_AMT,                                       
                       TRANSACTION_CD,                                  
                       CODE_SOURCE_ID,                                  
T29529                 CUST_BANK_SEQ_NO,                                
T29529                 PYMT_POSTED_FL,                                  
T29529                 PYMT_TRANS_TS,                                   
P00613                 USER_ID)                                         
               VALUES (:PB-ACCOUNT-NO,                                  
                       IIF(TRY_CONVERT(DATE, :PB-DRAFT-DATE
              ) IS NULL OR (PATINDEX('%.%', :PB-DRAFT-DATE
              ) <> 0) OR (LEN(:PB-DRAFT-DATE) <> 10), CIS.CHAR2DATE(
                                                         :PB-DRAFT-DATE
              ), CONVERT(DATE, :PB-DRAFT-DATE) ),                              
                       :PB-DRAFT-AMT,                                   
                       :PB-TRANSACTION-CD,                              
                       :PB-CODE-SOURCE-ID,                              
T29529                 :PB-CUST-BANK-SEQ-NO,                            
T29529                 :PB-PYMT-POSTED-FL,                              
T29529                 CIS.CHAR2TIMESTAMP(:PB-PYMT-TRANS-TS),                   
P00613                 :PB-USER-ID)                                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     06830001
MFA-TR*        INSERT INTO CSS_PNDNG_BNK_DRFT                           06840001
MFA-TR*               (ACCOUNT_NO,                                      06850001
MFA-TR*                DRAFT_DATE,                                      06860001
MFA-TR*                DRAFT_AMT,                                       06870001
MFA-TR*                TRANSACTION_CD,                                  06880002
MFA-TR*                CODE_SOURCE_ID,                                  06890001
MFA-TR*                CUST_BANK_SEQ_NO,                                        
MFA-TR*                PYMT_POSTED_FL,                                          
MFA-TR*                PYMT_TRANS_TS,                                           
MFA-TR*                USER_ID)                                                 
MFA-TR*        VALUES (:PB-ACCOUNT-NO,                                  06900001
MFA-TR*                :PB-DRAFT-DATE,                                  06910001
MFA-TR*                :PB-DRAFT-AMT,                                   06920001
MFA-TR*                :PB-TRANSACTION-CD,                              06930001
MFA-TR*                :PB-CODE-SOURCE-ID,                              06940001
MFA-TR*                :PB-CUST-BANK-SEQ-NO,                                    
MFA-TR*                :PB-PYMT-POSTED-FL,                                      
MFA-TR*                :PB-PYMT-TRANS-TS,                                       
MFA-TR*                :PB-USER-ID)                                             
MFA-TR*    END-EXEC.                                                    06950001

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

062800                                                                  
071400     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE                        
071500                     RS-RETURN-CODE.                              
062800                                                                  
063200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
063400        NEXT SENTENCE                                             
063500     ELSE                                                         
063600        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'INSERT'                     TO ABEND-FUNCTION       
063800        MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
CBSI          MOVE 'DRAFT_DATE'                 TO TABLE-ELEMENT-2      
CBSI          MOVE 'DRAFT_AMT'                  TO TABLE-ELEMENT-3      
CBSI          MOVE 'TRANSACTION_CD'             TO TABLE-ELEMENT-4      
064000        MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
064000        MOVE PB-DRAFT-DATE                TO HOSTVAR-ELEMENT-2    
CBSI          MOVE PARM-DRAFT-AMT               TO HOSTVAR-ELEMENT-3    
CBSI          MOVE PB-TRANSACTION-CD            TO HOSTVAR-ELEMENT-4    
064100        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
064200        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
064300     END-IF.                                                      
064400                                                                  
064500 7500-EXIT.                                                       
064600     EXIT.                                                        
064400                                                                  
060700******************************************************************07170000
060800* 7600-OPEN-DRAFT-CURSR.                                         *07180000
060900*                                                                *07190000
T29529*     COMMENTED AS PART OF T29529                                *07190000
060900*                                                                *07190000
061000*     CALLS 9000-SEND-ERROR-RESULT                               *07200000
061100*           9900-SQL-ERROR-ROUTINE                               *07210000
061200*                                                                *07220000
23549 *     CALLED FROM 2500-PROCESS-PNDNG-DRAFT                       *07230000
061400*                                                                *07240000
061400*    OPENING CSS_DRAFT CURSOR ON  CSS_PNDNG_BNK_DRFT TABLE       *07250000
061600******************************************************************07260000
061700*                                                                 07270000
061800 7600-OPEN-DRAFT-CURSR.                                           
061900*                                                                 07290000
062000     MOVE '7600' TO ACTIVE-PARAGRAPH.                             
062100*                                                                 07310000
           EXEC SQL                                                     
               OPEN  CSS_DRAFT                                          
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07350000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
062800*                                                                 07370000
063200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
063400        NEXT SENTENCE                                             
063500     ELSE                                                         
063600        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'OPEN'                       TO ABEND-FUNCTION       
063800        MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
064000        MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
064100        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
064200        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
064300     END-IF.                                                      
064400*                                                                 07490000
064500 7600-EXIT.                                                       
064600     EXIT.                                                        
069200*                                                                 07520000
060700******************************************************************07530000
060800* 7700-CLOSE-DRAFT-CURSR.                                        *07540000
060900*                                                                *07550000
T29529*     COMMENTED AS PART OF T29529                                *07550000
060900*                                                                *07550000
061000*     CALLS 9000-SEND-ERROR-RESULT                               *07560000
061100*           9900-SQL-ERROR-ROUTINE                               *07570000
061200*                                                                *07580000
061300*     CALLED FROM 2500-PROCESS-DRAFT-EPAY                        *07590000
061400*                                                                *07600000
061400*    CLOSING CSS_DRAFT CURSOR ON  CSS_PNDNG_BNK_DRFT TABLE       *07610000
061600******************************************************************07620000
061700*                                                                 07630000
061800 7700-CLOSE-DRAFT-CURSR.                                          
061900*                                                                 07650000
062000     MOVE '7700' TO ACTIVE-PARAGRAPH.                             
062100*                                                                 07670000
           EXEC SQL                                                     
               CLOSE  CSS_DRAFT                                         
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                 07710000
           MOVE SQLCODE                        TO WS-ACTIVE-RETURN-CODE 
062800*                                                                 07730000
063200     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
063400        NEXT SENTENCE                                             
063500     ELSE                                                         
063600        MOVE PROGRAM-NAME                 TO ABEND-PROGRAM        
CBSI          MOVE 'CLOSE'                      TO ABEND-FUNCTION       
063800        MOVE 'CSS_PNDNG_BNK_DRFT'         TO TABLE-1              
CBSI          MOVE 'ACCOUNT_NO'                 TO TABLE-ELEMENT-1      
064000        MOVE PB-ACCOUNT-NO                TO HOSTVAR-ELEMENT-1    
064100        PERFORM 9000-SEND-ERROR-RESULT    THRU 9000-EXIT          
064200        PERFORM 9900-SQL-ERROR-ROUTINE    THRU 9900-EXIT          
064300     END-IF.                                                      
064400*                                                                 07850000
064500 7700-EXIT.                                                       
064600     EXIT.                                                        
069200*                                                                 07880000
068800*****************************************************************         
068802* 7800-SELECT-TIMESTAMP-DATE                                    *         
      *                                                               *         
068803*     CALLS 9000-SEND-ERROR-RESULT                              *         
068804*           9900-SQL-ERROR-ROUTINE                              *         
068805*     CALLED FROM 2500-PROCESS-DRAFT-EPAY                       *         
068806*     SELECTS CSS_MODEL_SQL                                     *         
068807*****************************************************************         
068809 7800-SELECT-TIMESTAMP-DATE.                                      
068810                                                                  
068811     EXEC SQL                                                     
068812        SELECT REPLACE(REPLACE(CONVERT(CHAR(26), 
           CIS.CURRENT$TIMESTAMP(), 121), ' ', '-'), ':', '.'),                
                     CAST(SYSDATETIMEOFFSET() AS DATE)                          
068813          INTO :MH-TRANS-HIST-SEQ-NO,                             
                     :MH-DATE-TRANS                                     
068814          FROM CSS_MODEL_SQL                                      
068815     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT CURRENT TIMESTAMP,                                         
MFA-TR*              CURRENT DATE                                               
MFA-TR*         INTO :MH-TRANS-HIST-SEQ-NO,                                     
MFA-TR*              :MH-DATE-TRANS                                             
MFA-TR*         FROM CSS_MODEL_SQL                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

068816                                                                  
068817     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
068816                                                                  
068818     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
068819        NEXT SENTENCE                                             
068820     ELSE                                                         
068821        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
068822        MOVE '7800'                     TO ACTIVE-PARAGRAPH       
068823        MOVE 'SELECT'                   TO ABEND-FUNCTION         
068824        MOVE 'CSS_MODEL_SQL'            TO TABLE-1                
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
CBSI          MOVE PB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
068825        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
068826        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
068827     END-IF.                                                      
068828                                                                  
068829 7800-EXIT.                                                       
068830     EXIT.                                                        
068831                                                                  
068862*****************************************************************         
068864* 7802-SELECT-RESP-AREA                                         *         
068865*     CALLS 9000-SEND-ERROR-RESULT                              *         
068866*           9900-SQL-ERROR-ROUTINE                              *         
23549 *     CALLED FROM 2500-PROCESS-DRAFT-EPAY                       *         
068868*     SELECTS CSS_USER_PROFILE                                  *         
068869*****************************************************************         
068870 7802-SELECT-RESP-AREA.                                           
068871                                                                  
068875     EXEC SQL                                                     
068876        SELECT RESP_AREA_ID                                       
PCR285          INTO :PF-RESP-AREA-ID                                   
068878          FROM CSS_USER_PROFILE                                   
068879         WHERE USER_ID = :PF-USER-ID                              
068880     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

068881                                                                  
068882     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
068883                                                                  
068884     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
068885        NEXT SENTENCE                                             
068886     ELSE                                                         
068872        MOVE '7802'                     TO ACTIVE-PARAGRAPH       
068887        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
068889        MOVE 'SELECT'                   TO ABEND-FUNCTION         
068890        MOVE 'CSS_USER_PROFILE'         TO TABLE-1                
068891        MOVE 'USER_ID'                  TO TABLE-ELEMENT-1        
068892        MOVE PARM-USERID                TO HOSTVAR-ELEMENT-1      
CBSI          MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-2        
CBSI          MOVE PB-ACCOUNT-NO              TO HOSTVAR-ELEMENT-2      
068893        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
068894        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
068895     END-IF.                                                      
                                                                        
068896 7802-EXIT.                                                       
068897      EXIT.                                                       
068898                                                                  
C29529*****************************************************************         
C29529* 7900-GET-BANK-NICKNAME                                        *         
C29529*                                                               *         
C29529*     CALLS 9000-SEND-ERROR-RESULT                              *         
C29529*           9900-SQL-ERROR-ROUTINE                              *         
C29529*     CALLED FROM 2500-PROCESS-DRAFT-EPAY                       *         
C29529*     SELECTS CSS_CUSTOMER_BANK                                 *         
C29529*****************************************************************         
C29529 7900-GET-BANK-NICKNAME.                                          
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        SELECT BANK_ACCT_NICKNAME                                 
C29529          INTO :JF-BANK-ACCT-NICKNAME                             
C29529          FROM CSS_BANK_EFT BE                                    
C29529              ,CSS_CUSTOMER_BANK JF                               
C29529         WHERE BE.ACCOUNT_NO       = :BE-ACCOUNT-NO               
C29529           AND BE.CUSTOMER_NO      = JF.CUSTOMER_NO               
C29529           AND JF.CUST_BANK_SEQ_NO = :JF-CUST-BANK-SEQ-NO         
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C29529        MOVE '7900'                     TO ACTIVE-PARAGRAPH       
C29529        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C29529        MOVE 'CSS_BANK_EFT '            TO TABLE-1                
C29529        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C29529        MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7900-EXIT.                                                       
C29529     EXIT.                                                        
C29529                                                                  
C29529*****************************************************************         
C29529* 7910-GET-PMY-BNK-SEQ-NO                                       *         
C29529*                                                               *         
C29529*     CALLS 9000-SEND-ERROR-RESULT                              *         
C29529*           9900-SQL-ERROR-ROUTINE                              *         
C29529*     CALLED FROM 2500-PROCESS-DRAFT-EPAY                       *         
C29529*     SELECTS CSS_BANK_EFT                                      *         
C29529*****************************************************************         
C29529 7910-GET-PMY-BNK-SEQ-NO.                                         
C29529                                                                  
C29529     EXEC SQL                                                     
C29529        SELECT CUST_BANK_SEQ_NO                                   
C29529          INTO :BE-CUST-BANK-SEQ-NO                               
C29529          FROM CSS_BANK_EFT                                       
C29529         WHERE ACCOUNT_NO = :BE-ACCOUNT-NO                        
C29529     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29529                                                                  
C29529     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C29529                                                                  
C29529     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29529        NEXT SENTENCE                                             
C29529     ELSE                                                         
C29529        MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
C29529        MOVE '7910'                     TO ACTIVE-PARAGRAPH       
C29529        MOVE 'SELECT'                   TO ABEND-FUNCTION         
C29529        MOVE 'CSS_BANK_EFT '            TO TABLE-1                
C29529        MOVE 'ACCOUNT_NO'               TO TABLE-ELEMENT-1        
C29529        MOVE BE-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
C29529        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
C29529        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
C29529     END-IF.                                                      
C29529                                                                  
C29529 7910-EXIT.                                                       
C29529     EXIT.                                                        
068898                                                                  
REARCH******************************************************************03490000
REARCH* 8000A-DELETE-GTT-ROWS                                          *03500000
REARCH******************************************************************03570000
REARCH 8000A-DELETE-GTT-ROWS.                                           
REARCH*                                                                         
REARCH     MOVE 'DELETE ROWS'            TO S-SQL-STATEMENT-V.          
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH         DELETE FROM #CSR02357_R1                          
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM SESSION.CSR02357_R1                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
REARCH         NEXT SENTENCE                                            
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
REARCH        MOVE '8000A'               TO ACTIVE-PARAGRAPH            
REARCH        MOVE 'DELETE'              TO ABEND-FUNCTION              
REARCH        MOVE SQLCODE               TO ABEND-SQLCODE               
REARCH        MOVE SPACES                TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH        MOVE 'CSR02357_R1'         TO TABLE-1                     
REARCH        MOVE SPACES                TO TABLE-ELEMENT-1             
REARCH        MOVE SPACES                TO HOSTVAR-ELEMENT-1           
REARCH        PERFORM 9000-SEND-ERROR-RESULT                            
REARCH                                   THRU 9000-EXIT                 
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE                            
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH 8000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************03490000
REARCH* 8100-SEND-RESULT                                               *03500000
REARCH******************************************************************03570000
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH          INSERT INTO #CSR02357_R1                         
REARCH          (                                                       
REARCH               RETURN_CODE                                        
REARCH              ,PYMT_TRAN_TS                                       
REARCH          )                                                       
REARCH          VALUES                                                  
REARCH          (                                                       
REARCH               :S-RETURN-CODE                                     
REARCH              ,:S-PYMT-TRAN-TS                                    
REARCH          )                                                       
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO SESSION.CSR02357_R1                                 
MFA-TR*         (                                                               
MFA-TR*              RETURN_CODE                                                
MFA-TR*             ,PYMT_TRAN_TS                                               
MFA-TR*         )                                                               
MFA-TR*         VALUES                                                          
MFA-TR*         (                                                               
MFA-TR*              :S-RETURN-CODE                                             
MFA-TR*             ,:S-PYMT-TRAN-TS                                            
MFA-TR*         )                                                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH                                                                  
REARCH*                                                                         
REARCH     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH        ADD +1                    TO CTR-ROWS                     
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME         TO ABEND-PROGRAM                
REARCH        MOVE '8100'               TO ACTIVE-PARAGRAPH             
REARCH        MOVE 'INSERT'             TO ABEND-FUNCTION               
REARCH        MOVE SQLCODE              TO ABEND-SQLCODE                
REARCH        MOVE SPACES               TO ABEND-SQL-PREDICATES         
REARCH                                     ABEND-TABLES                 
REARCH        MOVE 'CSR02357_R1'        TO TABLE-1                      
REARCH        MOVE SPACES               TO TABLE-ELEMENT-1              
REARCH        MOVE SPACES               TO HOSTVAR-ELEMENT-1            
REARCH        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
REARCH*                                                                         
073300******************************************************************        
073400* 6530- WRITE MAINTENANCE TRANSACTION.                                    
073500******************************************************************        
073600     EXEC SQL                                                             
073700        INCLUDE CPD00067                                                  
073800     END-EXEC.                                                            
073900                                                                  
073300******************************************************************        
073400* 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
073500******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
073900                                                                  
074000******************************************************************        
074100*       END PROGRAM COPYLIB                                      *        
074200******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
074400                                                                  
