       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02354.                                         
COB303 DATE-WRITTEN.     JAN 8, 1998.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00090000
      *                                                                *00100000
      *  TRANID:        S354                                           *00110000
      *  PROGRAM:       S354                                           *00120000
      *  CALLING SP:    PA_S354                                        *00130042
      *                                                                *00140000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00180000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00190000
      *                                                                *        
      *  THE PROCEDURE WILL BRING BACK THE BILL PULLING STATUS CODES   *        
T15268*                                AND LOCK BOX NO                 *        
      *  WHEN ACCOUNT NUMBER IS PASSED FROM CSS_ACCOUNT.               *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES ROWS FROM THE FOLLOWING TABLE:         *00200043
      *                                                                *        
      *  TABLE                 TABLE ID             DCLGEN             *        
      *  -----                 --------             ------             *        
      *  CSS_ACCOUNT           AT                   TBACCT             *        
T15268*  CSS_ACCT_MISC_INFO    TA                   TBATMISC                    
      *                                                                *        
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  01/08/98    PRA      CREATED.                                 *00280000
T15268*  03/18/98    PRA      UPDATE CSS_ACCT_MISC_INFO W/ LOCK_BOX_NO *        
T15268*                       CHANGE -- INSERT ROW IF NO ROW EXISTS    *        
PCR549*  05/27/98    AMG      ADDED THE ABILITY TO INSERT A ROW INTO   *        
PCR549*                       CSS_OFF_CYCL_ACCT TABLE AND WRITE THE    *        
PCR549*                       MNT TRANS HISTORY AND MNT TRANS DETAILS  *00290000
CBSI  *  12/29/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T20583*  08/18/99    CBSI     LOGIC CHANGED TO CORRECTLY SET CODE-ACCT-*        
T20583*                       BILLED WHEN AN ACCOUNT IS PLACED ON HOLD *        
T20583*                       OR REMOVED FROM HOLD.                    *        
T21805*  10/24/00    FMB      ADDED TABLE ID 72 TO MAINTENANCE         *        
      *                       TRANSACTION HISTORY WHEN CODE_ACCT_BILLED*        
      *                       IS CHANGED.                              *        
T29983*  01/23/04    VIJAY    FROM PANEL 490 WHEN 'RELEASE BILL' OPTION         
      *                       USED,IT'S NOT RELEASING FROM HELD.                
C26296*  01/10/05    MSR      UPDATE RETURN CHECK EXEMPTION IND AND    *        
C26296*                       RETURN CHECK IND IN CSS_ACCT_ATTRIBUTE   *        
C29533*  01/12/05    MSR      UPDATE BILL NOTIFICATION AND NO OF COPIES*        
C29533*                       FIELDS.                                  *        
C31813*  06/03/05    SK88120  UPDATE FOR CONVERT CHECK ELECTRONICALLY  *        
C31813*                       (ARC) INDICATOR.                         *        
T33462*  12/20/05    VIDHU    A CODE VALUE OF 'X' ADDED TO CODE ACCT   *        
T33462*                       BILLED FOR EXCLUDING ACCTS FROM BILLING. *        
REARCH*  03/13/06    CVNS     RPC CONVERTED TO COBOL SP                *        
REARCH*              CHENNAI                                           *        
T33620*  04/05/06    PRIYA    PANEL490 IS INCORRECTLY SETTING THE      *        
T33620*                       OFF_CYCLE_CD O CAUSING THE OOB PROBLEM.  *        
T35434*  10/30/07    MK92804  REPLACED CSS_MODEL_SQL WITH SET STMTS    *        
T35434*                       AND ADDED FOR FETCH ONLY WITH UR FOR     *        
T35434*                       CURSOR SELECTS AND WITH UR FOR SINGLETON *        
T35434*                       SELECTS.                                 *        
C30169*  01/29/08    MSR      ADDED CR EXEMPT CODES FOR FINAL AND      *        
C30169*                       WITE OFF ACCOUNTS                        *        
P00126*  02/26/09    MSR      UPDATE EBILL REGISTER IND ON CUST STATS  *        
P00126*                       TABLE.                                   *        
P00150*  06/08/09    MSR      UPDATE TRANSACTION HISTORY FOR BILL      *        
P00150*                       NOTIFICATIONS.                           *        
A02486*  10/04/10    FMB      UNSET EXTRA POSTAGE FOR PAPERLESS.       *        
A02486*                       RESET EXTRA POSTAGE IF ACCOUNT GOES FROM *        
A02486*                       PAPERLESS TO PAPER AND BILL ADDRESS IS   *        
A02486*                       INTERNATIONAL.                           *        
P00471*  09/01/11    PK98692  UPDATE DPP DROP EXEMPTION INDICATOR IN   *        
P00471*                       CSS_ACCT_ATTRIBUTE TABLE.                *        
P00599*  04/16/12    PK98692  REMOVE 'APPLY LPC' FROM RELEASE BILL     *        
P00599*                       OPTION.                                  *        
P00773*  08/15/13    DB18339  ADDED ACCT 'REVIEW EXEMPT' ATTRIBUTE.    *        
A04860** 05/18/16    MR7E794  REPLACE CSS_WQ_ITEMS_MF WITH             *        
A04860**             ACT116   CSS_WQ_ITEMS.                            *        
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02354'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02354 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      *-------< INCLUDE CSS_ACCOUNT       >                             00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBACCT                                            00640000
           END-EXEC.                                                    00650000
                                                                        
PCR549*-------< INCLUDE CSS_OFF_CYCL_ACCT >                             00620000
PCR549                                                                  
PCR549     EXEC SQL                                                     00630000
PCR549        INCLUDE TBOFFCYL                                          00640000
PCR549     END-EXEC.                                                    00650000
                                                                        
      *---< CSS_MNT_TRANS_HIST >                                                
           EXEC SQL                                                             
              INCLUDE TBMNHIST                                                  
           END-EXEC.                                                            
                                                                        
      *---< CSS_MT_TRN_HST_DET >                                                
           EXEC SQL                                                             
              INCLUDE TBMNHDT                                                   
           END-EXEC.                                                            
                                                                        
T15268*---< CSS_ACCT_MISC_INFO >                                                
T15268     EXEC SQL                                                             
T15268        INCLUDE TBATMISC                                                  
T15268     END-EXEC.                                                            
                                                                        
T20583     EXEC SQL                                                             
T20583       INCLUDE TBBILWDW                                                   
T20583     END-EXEC.                                                            
T20583*                                                                         
T20583     EXEC SQL                                                             
T20583         INCLUDE TBUTLENV                                                 
T20583     END-EXEC.                                                            
T20583*                                                                         
T20583     EXEC SQL                                                             
T20583         INCLUDE TBMTRENV                                                 
T20583     END-EXEC.                                                            
T20583*                                                                         
T20583     EXEC SQL                                                             
T20583         INCLUDE TBRGREAD                                                 
T20583     END-EXEC.                                                            
T20583*                                                                         
C26296     EXEC SQL                                                             
C26296         INCLUDE TBACTATT                                                 
C26296     END-EXEC.                                                            
C26296*                                                                         
C29533     EXEC SQL                                                     00630000
C29533        INCLUDE TBATTRIB                                          00640000
C29533     END-EXEC.                                                    00650000
C29533*                                                                         
C30169     EXEC SQL                                                     00630000
C30169        INCLUDE TBATTDES                                          00640000
C30169     END-EXEC.                                                    00650000
C30169*                                                                         
C30169     EXEC SQL                                                     00630000
C30169        INCLUDE TBFINLWO                                          00640000
C30169     END-EXEC.                                                    00650000
C30169*                                                                         
C30169     EXEC SQL                                                     00630000
C30169        INCLUDE TBFWCLAG                                          00640000
C30169     END-EXEC.                                                    00650000
C30169*                                                                         
C30169     EXEC SQL                                                             
C30169        INCLUDE TBCHGOFF                                                  
C30169     END-EXEC.                                                            
C30169*                                                                         
C30169     EXEC SQL                                                             
C30169        INCLUDE TBUSRPRF                                                  
C30169     END-EXEC.                                                            
C30169*                                                                         
P00126*-------< INCLUDE CSS_CUST_STATS >                                00620000
P00126     EXEC SQL                                                     00630000
P00126        INCLUDE TBCSTSTS                                          00640000
P00126     END-EXEC.                                                    00650000
P00126*-------< INCLUDE CSS_CUSTOMER >                                  00620000
P00126     EXEC SQL                                                     00630000
P00126        INCLUDE TBCUST                                            00640000
P00126     END-EXEC.                                                    00650000
P00150*-------< INCLUDE CSS_EDI_ACCT_DEST >                             00620000
P00150     EXEC SQL                                                     00630000
P00150        INCLUDE TBACDEST                                          00640000
P00150     END-EXEC.                                                    00650000
A02486*-------< INCLUDE CSS_ADDR_FREEFORM >                             00620000
A02486     EXEC SQL                                                     00630000
A02486        INCLUDE TBADRFRE                                          00640000
A02486     END-EXEC.                                                    00650000
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
      *--------< ERROR HANDLING >                                       00880000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       00900000
           COPY CWS00027.                                               00910000
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  00920000
           COPY CWS00303.                                               00930000
ACT116******************************************************************        
ACT116* WORKING STORAGE COPYBOOK FOR SCSCB077                          *        
ACT116******************************************************************        
ACT116*                                                                         
ACT116     EXEC SQL                                                             
ACT116        INCLUDE CWS00077                                                  
ACT116     END-EXEC.                                                            
ACT116*                                                                         
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
                                                                        
       01  GW-LIB-MISC-FIELDS.                                          
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02354'.      
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
REARCH     05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO-TEMP       
REARCH                                 PIC 9(13).                       
REARCH     05  PARM-CUSTOMER-NO-TEMP   PIC X(10).                       
PCR549     05  PARM-CUSTOMER-NO-NUM REDEFINES PARM-CUSTOMER-NO-TEMP     
REARCH                                 PIC 9(10).                       
                                                                        
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(08)  VALUE SPACES.         
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH                                                                  
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                     VALUE 'SESSION.CSR02354_R1'. 
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.          
           05  WS-ACCOUNT-NO-CHAR     PIC X(13).                        
           05  WS-ACCOUNT-NO-INT      PIC 9(13).                        
COB305     05 WS-ACCOUNT-NO-CHK        PIC S9(13)V USAGE COMP-3 VALUE 0.        
           05  WS-F                   PIC X(01) VALUE 'F'.              
           05  WS-TRAN-APPL-NO        PIC S9(4) COMP.                   
           05  WS-PRV-CODE-PERM-BILL  PIC X(01) VALUE SPACE.            
           05  WS-PRV-CODE-TEMP-BILL  PIC X(01) VALUE SPACE.            
T15268     05  WS-PRV-LOCK-BOX-NO     PIC X(07) VALUE SPACES.           
PCR671     05  WS-PRV-CODE-ACCT-BILL  PIC X(01) VALUE SPACE.            
C26296     05  WS-PRV-DNP-EXMP-CD     PIC X(05) VALUE SPACE.            
C26296     05  WS-PRV-RET-CHK-EXMP-CD PIC X(05) VALUE SPACE.            
P00471     05  WS-PRV-DPPDROP-EXMP-CD PIC X(05) VALUE SPACE.            
PCR549     05  WS-DUPLICATE-ROW       PIC S9(9) VALUE -803.             
PCR549*    05  WS-NON-UTILITY         PIC X(01) VALUE 'D'.                      
PCR671     05  WS-MASTER              PIC X(01) VALUE 'M'.              
           05  WS-YES                 PIC X(01) VALUE 'Y'.              
           05  WS-NO                  PIC X(01) VALUE 'N'.              
PCR671     05  WS-HOLD                PIC X(01) VALUE 'H'.              
PCR671     05  WS-RELEASE             PIC X(01) VALUE 'R'.              
PCR671     05  WS-XFER-CONSOLIDATED   PIC X(01) VALUE 'M'.              
PCR671     05  WS-XFER-REGULAR        PIC X(01) VALUE 'T'.              
PCR671     05  WS-XFER-GUARANTOR      PIC X(01) VALUE 'G'.              
P00599*    05  WS-LPC-ONLY            PIC X(01) VALUE 'L'.                      
T33462     05  WS-EXCLUDE             PIC X(01) VALUE 'X'.              
PCR671     05  WS-SPACE               PIC X(01) VALUE ' '.              
PCR671     05  WS-UNCHANGED           PIC X(01) VALUE 'U'.              
PCR671     05  WS-ACCT-ALREADY-BILLED PIC S9(9) COMP VALUE +1.          
T20583     05  WS-COMMON-DATE         PIC X(10).                        
T20583     05  WS-BN-OPEN-DATE        PIC X(10).                        
T20583     05  WS-BN-CLOSE-DATE       PIC X(10).                        
T20583     05  WS-CM-OPEN-DATE        PIC X(10).                        
T20583     05  WS-CM-CLOSE-DATE       PIC X(10).                        
T20583     05  WS-PM-OPEN-DATE        PIC X(10).                        
T20583     05  WS-PM-CLOSE-DATE       PIC X(10).                        
T20583     05  WS-CURR-REV-MONTH      PIC 9(06).                        
T20583     05  WS-PREV-REVENUE-MONTH.                                   
T20583         10 WS-PREV-REV-YYYY    PIC 9(04).                        
T20583         10 WS-PREV-REV-MM      PIC 9(02).                        
T20583     05  WS-PREV-REV-MONTH REDEFINES                              
T20583         WS-PREV-REVENUE-MONTH   PIC 9(06).                       
T20583     05  WS-VERIFIED-READ        PIC X(01)   VALUE 'K'.           
T20583     05  WS-UT-COUNT             PIC S9(04) COMP VALUE ZERO.      
T20583     05  WS-READS-POSTED         PIC S9(04) COMP VALUE ZERO.      
T20583     05  WS-MN-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
T20583     05  WS-RG-AWAITING-RD-COUNT PIC S9(04) COMP VALUE ZERO.      
C26296     05  WS-DNP-EXMP-IND         PIC X(18)  VALUE                 
C26296                                 'AUTODNPDEPEXEMPIND'.            
C26296     05  WS-RET-CHK-EXMP-IND     PIC X(18)  VALUE                 
C26296                                 'AUTORETDEPEXEMPIND'.            
P00471     05  WS-DPPDROP-EXMP-IND     PIC X(18)  VALUE                 
P00471                                 'AUTODPPDRPEXEMPIND'.            
C26296     05  WS-DNP-FLAG             PIC X(01)  VALUE SPACES.         
C26296     05  WS-RETCHK-FLAG          PIC X(01)  VALUE SPACES.         
P00471     05  WS-DPPDROP-FLAG         PIC X(01)  VALUE SPACES.         
P00773     05  WS-REVIEW-EXEMPT-CHG    PIC X(01)  VALUE SPACES.         
C26296     05  WS-ATTRB-VAL-TX         PIC X(22)  VALUE SPACES.         
C29533     05  WS-OLD-NO-COPIES        PIC S9(4) COMP VALUE ZEROS.      
C29533     05  WS-BILL-NOTIFICATION    PIC X(05) VALUE SPACES.          
C29533     05  WS-ATTRIBUTE-TYPE       PIC X(08) VALUE SPACES.          
C31813     05  WS-ARC-IND              PIC X(01) VALUE SPACES.          
C31813     05  WS-PREV-ARC-IND         PIC X(01) VALUE SPACES.          
C30169     05  WS-PREV-CAXMT-CD        PIC X(05) VALUE SPACES.          
C30169     05  WS-PREV-CBXMT-CD        PIC X(05) VALUE SPACES.          
C31813     05  WS-COMMENTS-NO          PIC X(210) VALUE                 
C31813     'PERSONAL CHECK RECEIVED BY MAIL WILL NOT BE CONVERTED TO ELE        
C31813-    'CTRONIC PAYMENT.'.                                                  
C31813     05  WS-COMMENTS-YES         PIC X(210) VALUE                 
C31813     'PERSONAL CHECK RECEIVED BY MAIL WILL BE CONVERTED TO ELECTRO        
C31813-    'NIC PAYMENT. CUSTOMER WILL NOT RECEIVE CANCELED CHECK FROM H        
C31813-    'IS  FINANCIAL INSTITUTION.'.                                        
C30169     05  WS-WQ-MESSAGE           PIC X(250) VALUE SPACES.         
C30169     05  WS-WQ-MESSAGE-TMP       PIC X(250) VALUE SPACES.         
C30169     05  WS-USER-NAME            PIC X(37)  VALUE SPACES.         
C30169     05  WS-PREV-CAXMT-DESC      PIC X(75)  VALUE SPACES.         
C30169     05  WS-CA-EXEMPT-DESC       PIC X(75)  VALUE SPACES.         
C30169     05  WS-PREV-CBXMT-DESC      PIC X(75)  VALUE SPACES.         
C30169     05  WS-CB-EXEMPT-DESC       PIC X(75)  VALUE SPACES.         
C30169     05  WS-CATEGORY-ID          PIC S9(4) USAGE COMP             
C30169                                           VALUE 457.             
P00150     05  WS-PAPERLESS            PIC X(01)  VALUE SPACES.         
A02486     05  WS-INTER-ADD            PIC X(01)  VALUE SPACES.         
ACT116     05  MCSCB077                PIC X(08) VALUE 'MCSCB077'.      
ACT116     05  WS-MCSCB077-RET-CODE    PIC S9(04) COMP VALUE 0.         
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
PCR671     05  ACCT-ON-HOLD-SW         PIC X(01) VALUE 'N'.             
PCR671         88 ACCT-IS-ON-HOLD                VALUE 'Y'.             
PCR671     05  CODE-ACCT-BILLED-SW     PIC X(01) VALUE ' '.             
PCR671         88 CODE-ACCT-BILLED-UNCHANGED     VALUE 'U'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
T20583     05  WS-METER-NOT-READ       PIC X(01) VALUE 'Y'.             
T20583         88 METER-NOT-READ-FOUND           VALUE 'N'.             
C26296     05  WS-DNP-EXMP-CHG         PIC X(01) VALUE 'N'.             
C26296         88 DNP-EXMP-CHG                   VALUE 'Y'.             
C26296     05  WS-RET-CHK-EXMP-CHG     PIC X(01) VALUE 'N'.             
C26296         88 RET-CHK-EXMP-CHG               VALUE 'Y'.             
P00471     05  WS-DPPDROP-EXMP-CHG     PIC X(01) VALUE 'N'.             
P00471         88 DPPDROP-EXMP-CHG               VALUE 'Y'.             
C29533     05  WS-NO-NOTIFICATION     PIC X(01)  VALUE 'N'.             
C29533         88 NO-NOTIFICATION                VALUE 'Y'.             
C29533     05  WS-PAPER-ONLY           PIC X(01) VALUE 'N'.             
C29533         88 PAPER-ONLY                     VALUE 'Y'.             
C30169     05  WS-CA-XMT-CHG           PIC X(01) VALUE 'N'.             
C30169         88 CA-XMT-CHG                     VALUE 'Y'.             
C30169     05  WS-CB-XMT-CHG           PIC X(01) VALUE 'N'.             
C30169         88 CB-XMT-CHG                     VALUE 'Y'.             
T20583*                                                                         
T20583* 7360-FETCH-UTIL-ENVRNMT:                                                
T20583     EXEC SQL                                                     
T20583         DECLARE UTIL_ENVRNMT CURSOR FOR                          
T20583          SELECT ACCOUNT_NO,                                      
T20583                 CODE_UTIL_TYPE,                                  
T20583                 IC_NO,                                           
T20583                 READ_CYCLE,                                      
T20583                 READ_ROUTE                                       
T20583            FROM CSS_UTIL_ENVRNMT WITH(READUNCOMMITTED)                   
T20583           WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                 
T20583             AND (CODE_UTIL_TYPE = 'E'                            
T20583              OR CODE_UTIL_TYPE  = 'G')                           
T20583        ORDER BY ACCOUNT_NO, CODE_UTIL_TYPE, IC_NO                
T35434        FOR READ ONLY                                     
                                                            
T20583     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE UTIL_ENVRNMT CURSOR FOR                                  
MFA-TR*         SELECT ACCOUNT_NO,                                              
MFA-TR*                CODE_UTIL_TYPE,                                          
MFA-TR*                IC_NO,                                                   
MFA-TR*                READ_CYCLE,                                              
MFA-TR*                READ_ROUTE                                               
MFA-TR*           FROM CSS_UTIL_ENVRNMT                                         
MFA-TR*          WHERE ACCOUNT_NO      = :UT-ACCOUNT-NO                         
MFA-TR*            AND (CODE_UTIL_TYPE = 'E'                                    
MFA-TR*             OR CODE_UTIL_TYPE  = 'G')                                   
MFA-TR*       ORDER BY ACCOUNT_NO, CODE_UTIL_TYPE, IC_NO                        
MFA-TR*       FOR FETCH ONLY WITH UR                                            
MFA-TR*       QUERYNO 7350                                                      
MFA-TR*    END-EXEC.                                                            
T20583*                                                                         
                                                                        
REARCH LINKAGE SECTION.                                                 
                                                                        
REARCH 01  PARM-ACCOUNT-NO               PIC X(13).                     
REARCH 01  PARM-CUSTOMER-NO              PIC X(10).                     
REARCH 01  PARM-CREDIT-GROUP             PIC X(01).                     
REARCH 01  PARM-CODE-PERM-BILL           PIC X(01).                     
REARCH 01  PARM-CODE-TEMP-BILL           PIC X(01).                     
REARCH 01  PARM-USER-ID                  PIC X(07).                     
REARCH 01  PARM-RESP-AREA-ID             PIC X(03).                     
REARCH 01  PARM-TRAN-COMMENT-LEN         PIC S9(4) COMP.                
REARCH 01  PARM-TRAN-COMMENT             PIC X(210).                    
REARCH 01  PARM-LOCK-BOX-NO              PIC X(07).                     
REARCH 01  PARM-RELEASE-BILL-OPTN        PIC X(01).                     
REARCH 01  PARM-DNP-EXMP-CD              PIC X(05).                     
REARCH 01  PARM-RET-CHK-EXMP-CD          PIC X(05).                     
REARCH 01  PARM-BILL-NOTIFICATION        PIC X(05).                     
REARCH 01  PARM-EBILL-COPIES             PIC S9(04) COMP.               
REARCH 01  PARM-ARC-IND                  PIC X(01).                     
C30169 01  PARM-CA-EXEMPT                PIC X(05).                     
C30169 01  PARM-CB-EXEMPT                PIC X(05).                     
P00126 01  PARM-EBILL-REGISTER-IND       PIC X(01).                     
P00471 01  PARM-DPPDROP-EXMP-CD          PIC X(05).                     
P00773 01  PARM-REVIEW-EXEMPT-FL         PIC X(01).                     
                                                                        
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                          ,PARM-CUSTOMER-NO                       
REARCH                          ,PARM-CREDIT-GROUP                      
REARCH                          ,PARM-CODE-PERM-BILL                    
REARCH                          ,PARM-CODE-TEMP-BILL                    
REARCH                          ,PARM-USER-ID                           
REARCH                          ,PARM-RESP-AREA-ID                      
REARCH                          ,PARM-TRAN-COMMENT-LEN                  
REARCH                          ,PARM-TRAN-COMMENT                      
REARCH                          ,PARM-LOCK-BOX-NO                       
REARCH                          ,PARM-RELEASE-BILL-OPTN                 
REARCH                          ,PARM-DNP-EXMP-CD                       
REARCH                          ,PARM-RET-CHK-EXMP-CD                   
REARCH                          ,PARM-BILL-NOTIFICATION                 
REARCH                          ,PARM-EBILL-COPIES                      
REARCH                          ,PARM-ARC-IND                           
C30169                          ,PARM-CA-EXEMPT                         
C30169                          ,PARM-CB-EXEMPT                         
P00126                          ,PARM-EBILL-REGISTER-IND                
P00471                          ,PARM-DPPDROP-EXMP-CD                   
P00773                          ,PARM-REVIEW-EXEMPT-FL.                 
                                                                        
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-OUTPUT                                  *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           MOVE '0000'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 0100-INITIALIZE                                                *02240000
      *     CALLS 9000-SEND-ERROR-RESULT                               *02250000
      *           9900-SQL-ERROR-ROUTINE                               *02260000
      *                                                                *02270000
      *     CALLED FROM 0000-MAINLINE                                  *02280000
      *                                                                *02290000
      ******************************************************************02350000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'                  TO ACTIVE-PARAGRAPH.            
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH               :S-RETURN-CODE         AS RETURN_CODE              
REARCH          FROM                                                    
REARCH               CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*              :S-RETURN-CODE         AS RETURN_CODE                      
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************02640000
      * 1000-PROCESS-INPUT                                             *02650000
      *     CALLS 1100-RECEIVE-PARMS                                   *02660000
      *                                                                *02670000
      *     CALLED FROM 0000-MAINLINE                                  *02680000
      *                                                                *02690000
      *     RECEIVE PARMS                                              *02700000
      ******************************************************************02710000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
           MOVE '1000'                  TO ACTIVE-PARAGRAPH.            
                                                                        
REARCH     MOVE PARM-CUSTOMER-NO        TO PARM-CUSTOMER-NO-TEMP.       
REARCH     MOVE PARM-ACCOUNT-NO         TO PARM-ACCOUNT-NO-TEMP.        
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT-NO-CHAR.          
           UNSTRING WS-ACCOUNT-NO-CHAR DELIMITED BY SPACES              
                                        INTO WS-ACCOUNT-NO-INT.         
           MOVE WS-ACCOUNT-NO-INT       TO WS-ACCOUNT-NO.               
           MOVE WS-ACCOUNT-NO-INT       TO WS-ACCOUNT-NO-CHK.           
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      *     CALLS 2100-DESCRIBE-RESULT                                 *03230000
      *           2300-BUILD-RESULT                                    *03240000
      *           2800-TRANSFER-HISTORY                                *        
      *                                                                *03250000
      *     CALLED FROM 0000-MAINLINE                                  *03260000
      *                                                                *03270000
      *     SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS,    *03280000
      *      AND SENDS THEM BACK                                       *03290000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                      TO ACTIVE-PARAGRAPH.        
                                                                        
           PERFORM 2300-BUILD-RESULT        THRU 2300-EXIT.             
           PERFORM 2800-TRANSFER-HISTORY    THRU 2800-EXIT.             
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*  2000A-MOVE-RESULT.                                            *        
REARCH******************************************************************        
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH                                                                  
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH                                                                  
      ******************************************************************06620000
      * 2300-BUILD-RESULT                                              *06630000
      *     CALLS       7000-SELECT-BILL-PULL-CODES                    *06640011
T15268*                 7100-SELECT-LOCK-BOX-NO                        *        
      *                 8000-UPDATE-ACCOUNT                            *        
T15268*                 8025-UPDATE-ACCT-MISC-INFO                     *        
      *                 8100-SEND-RESULT                               *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *06680000
      *                                                                *06690000
      *     BUILD THE RESULT SET DESCRIBED ABOVE                       *06700000
      ******************************************************************06710000
                                                                        
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE '2300'                         TO ACTIVE-PARAGRAPH.     
                                                                        
           PERFORM 7000-SELECT-BILL-PULL-CODES THRU 7000-EXIT.          
                                                                        
A02486* ACCOUNT W/ EXTRA POSTAGE SWITCHING TO PAPERLESS                         
A02486     IF PARM-CODE-PERM-BILL = 'D' AND                             
A02486        WS-PRV-CODE-PERM-BILL = 'D' AND                           
A02486        PARM-BILL-NOTIFICATION = '1' AND                          
A02486        AT-NO-BILL-COPIES > 0                                     
A02486            MOVE 'A' TO PARM-CODE-PERM-BILL
           END-IF.                      
A02486* ACCOUNT W/ INTERNATIONAL ADDRESS SWITCHING FROM PAPERLESS               
A02486     IF PARM-CODE-PERM-BILL = 'A' AND                             
A02486        WS-PRV-CODE-PERM-BILL = 'A' AND                           
A02486       (PARM-BILL-NOTIFICATION = '2' OR '3') AND                  
A02486        AT-NO-BILL-COPIES = 0 AND                                 
A02486        AT-ADDRESS-ID > 0 AND                                     
A02486        AT-ADDRESS-FORMAT = 'B'                                   
A02486            MOVE 'N' TO WS-INTER-ADD                              
A02486            PERFORM 7510-CHECK-ADDRESS THRU 7510-EXIT             
A02486            IF WS-INTER-ADD = 'Y'                                 
A02486                MOVE 'D' TO PARM-CODE-PERM-BILL
                  END-IF
           END-IF.                  
                                                                        
T15268     PERFORM 7100-SELECT-LOCK-BOX-NO     THRU 7100-EXIT.          
PCR671     PERFORM 7150-CHECK-CODE-ACCT-BILL   THRU 7150-EXIT.          
T20583*                                                                         
T20583     IF  PARM-RELEASE-BILL-OPTN = WS-HOLD OR WS-EXCLUDE           
T33462         IF PARM-RELEASE-BILL-OPTN = WS-HOLD                      
T20583            MOVE WS-HOLD                TO AT-CODE-ACCT-BILLED    
T33462         ELSE                                                     
T33462            MOVE WS-EXCLUDE             TO AT-CODE-ACCT-BILLED    
T33462         END-IF                                                   
T20583     ELSE                                                         
T20583         IF  PARM-RELEASE-BILL-OPTN = WS-RELEASE                  
T20583                AND ( AT-CREDIT-GROUP NOT EQUAL 'D' AND 'M' )     
T20583             PERFORM 2400-SET-CODE-ACCT-BILL THRU 2400-EXIT       
T20583         ELSE                                                     
T20583             PERFORM 8035-UPDATE-OFF-CYCLE-TBL THRU 8035-EXIT     
T20583         END-IF                                                   
T20583     END-IF.                                                      
T20583*                                                                         
           PERFORM 8000-UPDATE-ACCOUNT         THRU 8000-EXIT.          
T15268     PERFORM 8025-UPDATE-ACCT-MISC-INFO  THRU 8025-EXIT.          
                                                                        
C26296*                                                                         
C26296     PERFORM 2600-UPDATE-ACCT-ATTRB        THRU 2600-EXIT.        
C29533     PERFORM 2610-GET-BILL-NOTIFICATION    THRU 2610-EXIT.        
C29533     PERFORM 2700-UPDATE-BILL-NOTIFICATION THRU 2700-EXIT.        
C31813     PERFORM 2800-UPDATE-ARC-IND           THRU 2800-UPDATE-EXIT. 
C30169     PERFORM 2900-UPDATE-CRXMT-CD          THRU 2900-EXIT.        
P00126     PERFORM 2950-CHECK-EBILL-IND          THRU 2950-EXIT.        
P00471     PERFORM 2960-UPDATE-DPPDROP-ATTRB     THRU 2960-EXIT.        
P00773     PERFORM 2970-UPDATE-REVIEW-EXEMPT     THRU 2970-EXIT.        
P00150     MOVE WS-ACCOUNT-NO                    TO NF-ACCOUNT-NO.      
P00150     PERFORM 7998-GET-PAPERLESS-IND        THRU 7998-EXIT.        
P00150     IF (WS-PAPERLESS = 'Y' OR                                    
P00150         CE-EBILL-REGISTER-IND = 'Y') AND                         
P00150        WS-BILL-NOTIFICATION = '5'                                
P00150        MOVE '2'                           TO WS-BILL-NOTIFICATION
P00150     END-IF                                                       
REARCH     PERFORM 2000A-MOVE-RESULT             THRU 2000A-EXIT.       
REARCH     ADD +1                                TO   CTR-ROWS.         
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
T20583******************************************************************06620000
T20583** CODE TO SET THE AT-CODE-ACCT-BILLED CORRECTLY IN ALL CASES   **06620000
T20583******************************************************************06620000
T20583 2400-SET-CODE-ACCT-BILL.                                         
T20583*                                                                         
T20583*                                                                         
T20583     MOVE '2400'                     TO ACTIVE-PARAGRAPH.         
T20583*                                                                         
T20583     PERFORM 7310-GET-COMMON-DATE THRU 7310-EXIT.                 
T20583     PERFORM 7315-GET-MAX-REV-MONTH THRU 7315-EXIT.               
T20583     MOVE BN-REVENUE-MONTH           TO WS-CURR-REV-MONTH.        
T20583     MOVE AT-BILL-CYCLE              TO BN-BILL-CYCLE.            
T20583     PERFORM 7320-GET-BILL-WINDOW-DT THRU 7320-EXIT.              
T20583     MOVE WS-BN-OPEN-DATE            TO WS-CM-OPEN-DATE.          
T20583     MOVE WS-BN-CLOSE-DATE           TO WS-CM-CLOSE-DATE.         
T20583     IF  AT-REV-MTH-LST-NRML EQUAL WS-CURR-REV-MONTH              
T20583         EVALUATE TRUE                                            
T20583            WHEN WS-COMMON-DATE < WS-CM-OPEN-DATE                 
T20583                MOVE SPACES          TO AT-CODE-ACCT-BILLED       
T20583            WHEN ( WS-COMMON-DATE >= WS-CM-OPEN-DATE AND          
T20583                   WS-COMMON-DATE <= WS-CM-CLOSE-DATE )           
T20583                MOVE WS-YES          TO AT-CODE-ACCT-BILLED       
T20583            WHEN WS-COMMON-DATE > WS-CM-CLOSE-DATE                
T20583                MOVE SPACES          TO AT-CODE-ACCT-BILLED       
T20583         END-EVALUATE                                             
T20583     ELSE                                                         
T20583         EVALUATE TRUE                                            
T20583            WHEN WS-COMMON-DATE < WS-CM-OPEN-DATE                 
T20583                PERFORM 2410-CHECK-PREV-MONTH THRU 2410-EXIT      
T29983            WHEN ( WS-COMMON-DATE >=  WS-CM-OPEN-DATE AND         
T20583                   WS-COMMON-DATE <= WS-CM-CLOSE-DATE )           
T20583                PERFORM 2420-CHECK-BILL-STAT-OPEN THRU            
T20583                                                  2420-EXIT       
T20583            WHEN WS-COMMON-DATE > WS-CM-CLOSE-DATE                
T33620                MOVE SPACES          TO AT-CODE-ACCT-BILLED       
T33620                MOVE 5665            TO RS-RETURN-CODE            
T20583         END-EVALUATE                                             
T20583     END-IF.                                                      
T20583*                                                                         
T20583 2400-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
T20583 2410-CHECK-PREV-MONTH.                                           
T20583*                                                                         
T20583     MOVE '2410'                     TO ACTIVE-PARAGRAPH.         
T20583*                                                                         
T20583     MOVE WS-CURR-REV-MONTH          TO WS-PREV-REV-MONTH.        
T20583*                                                                         
T20583     COMPUTE WS-PREV-REV-MM = WS-PREV-REV-MM - 1.                 
T20583     IF  WS-PREV-REV-MM = ZEROS                                   
T20583         MOVE 12                     TO WS-PREV-REV-MM            
T20583         COMPUTE WS-PREV-REV-YYYY = WS-PREV-REV-YYYY - 1          
T20583     END-IF.                                                      
T20583*                                                                         
T20583     MOVE WS-PREV-REV-MONTH          TO BN-REVENUE-MONTH.         
T20583     MOVE AT-BILL-CYCLE              TO BN-BILL-CYCLE.            
T20583     PERFORM 7320-GET-BILL-WINDOW-DT THRU 7320-EXIT.              
T20583     MOVE WS-BN-OPEN-DATE            TO WS-PM-OPEN-DATE.          
T20583     MOVE WS-BN-CLOSE-DATE           TO WS-PM-CLOSE-DATE.         
T20583     EVALUATE TRUE                                                
T20583        WHEN WS-COMMON-DATE < WS-PM-OPEN-DATE                     
T20583            MOVE SPACES      TO AT-CODE-ACCT-BILLED               
T20583        WHEN ( WS-COMMON-DATE >= WS-PM-OPEN-DATE AND              
T20583               WS-COMMON-DATE <= WS-PM-CLOSE-DATE )               
T20583            PERFORM 2420-CHECK-BILL-STAT-OPEN THRU 2420-EXIT      
T20583        WHEN WS-COMMON-DATE > WS-PM-CLOSE-DATE                    
T20583            IF  AT-REV-MTH-LST-NRML EQUAL WS-PREV-REV-MONTH       
T20583                              OR ZEROS                            
T20583                MOVE SPACES          TO AT-CODE-ACCT-BILLED       
T20583            ELSE                                                  
T33620                MOVE SPACES          TO AT-CODE-ACCT-BILLED       
T33620                MOVE 5665            TO RS-RETURN-CODE            
T20583            END-IF                                                
T20583     END-EVALUATE.                                                
T20583*                                                                         
T20583 2410-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
T20583******************************************************************06620000
T20583** CHECK BILL STATUS FOR OPEN BILL WINDOW                       **06620000
T20583******************************************************************06620000
T20583 2420-CHECK-BILL-STAT-OPEN.                                       
T20583*                                                                         
T20583     MOVE '2420'                     TO ACTIVE-PARAGRAPH.         
T20583*                                                                         
T20583     PERFORM 2450-CHECK-HELD-RD-ROUTE THRU 2450-EXIT              
T20583     IF WS-UT-COUNT GREATER THAN ZERO                             
T20583        IF WS-READS-POSTED EQUAL WS-UT-COUNT                      
T20583           MOVE WS-RELEASE       TO AT-CODE-ACCT-BILLED           
T20583        ELSE                                                      
T20583           MOVE SPACES           TO AT-CODE-ACCT-BILLED           
T20583        END-IF                                                    
T20583     END-IF.                                                      
T20583 2420-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
T20583******************************************************************06620000
T20583* CHECK TO SEE ALL THE REGISTERS FOR THE ACCT HAVE A READ POSTED *06620000
T20583******************************************************************06620000
T20583 2450-CHECK-HELD-RD-ROUTE.                                        
T20583*                                                                         
T20583     MOVE '2450'                     TO ACTIVE-PARAGRAPH.         
T20583*                                                                         
T20583     MOVE ZERO                       TO WS-UT-COUNT               
T20583                                        WS-READS-POSTED.          
T20583     MOVE WS-ACCOUNT-NO-CHK          TO UT-ACCOUNT-NO             
T20583     PERFORM 7350-OPEN-UTIL-ENVRNMT            THRU 7350-EXIT.    
T20583     PERFORM 7360-FETCH-UTIL-ENVRNMT           THRU 7360-EXIT.    
T20583     PERFORM 2500-CHECK-READ-CODES             THRU 2500-EXIT     
T20583         UNTIL WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND.             
T20583     PERFORM 7370-CLOSE-UTIL-ENVRNMT           THRU 7370-EXIT.    
T20583*                                                                         
T20583 2450-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
T20583******************************************************************06620000
T20583* CHECK TO SEE ALL THE REGISTERS FOR THE ACCT HAVE A READ POSTED *06620000
T20583******************************************************************06620000
T20583 2500-CHECK-READ-CODES.                                           
T20583*                                                                         
T20583     MOVE '2500'                     TO ACTIVE-PARAGRAPH.         
T20583*                                                                         
T20583     MOVE 'Y'                        TO WS-METER-NOT-READ.        
T20583     MOVE ZERO                       TO WS-MN-AWAITING-RD-COUNT   
T20583                                        WS-RG-AWAITING-RD-COUNT.  
T20583     MOVE UT-ACCOUNT-NO              TO MN-ACCOUNT-NO.            
T20583     MOVE UT-CODE-UTIL-TYPE          TO MN-CODE-UTIL-TYPE.        
T20583     MOVE UT-IC-NO                   TO MN-IC-NO.                 
T20583     MOVE 'D'                        TO MN-CODE-CRNT-REG-READ.    
T20583     PERFORM 7400-SELECT-CNT-MTRD-ENVRNMT      THRU 7400-EXIT.    
T20583     IF WS-MN-AWAITING-RD-COUNT > 0                               
T20583         MOVE 'N' TO WS-METER-NOT-READ                            
T20583     ELSE                                                         
T20583         MOVE UT-ACCOUNT-NO          TO RG-ACCOUNT-NO             
T20583         MOVE UT-CODE-UTIL-TYPE      TO RG-CODE-UTIL-TYPE         
T20583         MOVE UT-IC-NO               TO RG-IC-NO                  
T20583         MOVE 'D'                    TO RG-CODE-CRNT-REG-READ     
T20583         MOVE ZERO                   TO WS-RG-AWAITING-RD-COUNT   
T20583         PERFORM 7410-SELECT-CNT-REGISTER-READ THRU 7410-EXIT     
T20583         IF  WS-RG-AWAITING-RD-COUNT GREATER THAN ZERO            
T20583             MOVE WS-N               TO WS-METER-NOT-READ         
T20583         END-IF                                                   
T20583     END-IF.                                                      
T20583     IF METER-NOT-READ-FOUND                                      
T20583         NEXT SENTENCE                                            
T20583     ELSE                                                         
T20583         ADD 1                       TO WS-READS-POSTED           
T20583     END-IF.                                                      
T20583     ADD 1                           TO WS-UT-COUNT.              
T20583     PERFORM 7360-FETCH-UTIL-ENVRNMT THRU 7360-EXIT.              
T20583*                                                                         
T20583 2500-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
C26296******************************************************************06620000
C26296* ADD/UPDATE/DELETE DEPOSIT EXEMPTION CODES IN CSS_ACCT_ATTRIBUTE*06620000
C26296******************************************************************06620000
C26296 2600-UPDATE-ACCT-ATTRB.                                          
C26296*                                                                         
C26296     MOVE WS-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
C26296     MOVE WS-DNP-EXMP-IND            TO YP-ATTRIBUTE-DESC.        
C26296     PERFORM 7500-SELECT-ACCT-ATTRIBUTE        THRU 7500-EXIT.    
C26296     MOVE YP-ATTRIBUTE-VALUE-CD      TO WS-PRV-DNP-EXMP-CD.       
C26296     IF YP-ATTRIBUTE-VALUE-CD NOT EQUAL PARM-DNP-EXMP-CD          
C26296        SET DNP-EXMP-CHG TO TRUE                                  
C26296        IF PARM-DNP-EXMP-CD = SPACES                              
C26296           MOVE 'D'                  TO WS-DNP-FLAG               
C26296           PERFORM 7800-DELETE-ATTRB-CD     THRU 7800-EXIT        
C26296        ELSE                                                      
C26296           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
C26296              MOVE 'I'               TO WS-DNP-FLAG               
P00471              MOVE SPACES            TO YP-STATUS-CD              
C26296              MOVE PARM-DNP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD     
C26296              PERFORM 2650-GET-ATTRB-VAL-TX THRU 2650-EXIT        
C26296              MOVE LENGTH OF WS-ATTRB-VAL-TX                      
C26296                                     TO YP-ATTRIBUTE-VALUE-TX-LEN 
C26296              MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
C26296              PERFORM 7600-INSERT-ATTRB-CD  THRU 7600-EXIT        
C26296          ELSE                                                    
C26296              MOVE 'U'               TO WS-DNP-FLAG               
C26296              MOVE PARM-DNP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD     
C26296              PERFORM 2650-GET-ATTRB-VAL-TX THRU 2650-EXIT        
C26296              MOVE LENGTH OF WS-ATTRB-VAL-TX                      
C26296                                     TO YP-ATTRIBUTE-VALUE-TX-LEN 
C26296              MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
C26296              PERFORM 7700-UPDATE-ATTRB-CD  THRU 7700-EXIT        
C26296          END-IF                                                  
C26296        END-IF                                                    
C26296     END-IF.                                                      
C26296     MOVE WS-RET-CHK-EXMP-IND        TO YP-ATTRIBUTE-DESC.        
C26296     PERFORM 7500-SELECT-ACCT-ATTRIBUTE        THRU 7500-EXIT.    
C26296     MOVE YP-ATTRIBUTE-VALUE-CD      TO WS-PRV-RET-CHK-EXMP-CD.   
C26296     IF YP-ATTRIBUTE-VALUE-CD NOT EQUAL PARM-RET-CHK-EXMP-CD      
C26296        SET RET-CHK-EXMP-CHG TO TRUE                              
C26296        IF PARM-RET-CHK-EXMP-CD = SPACES                          
C26296           MOVE 'D'                  TO WS-RETCHK-FLAG            
C26296           PERFORM 7800-DELETE-ATTRB-CD        THRU 7800-EXIT     
C26296        ELSE                                                      
C26296           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
C26296              MOVE 'I'               TO WS-RETCHK-FLAG            
C26296              MOVE SPACES            TO YP-STATUS-CD              
C26296              MOVE PARM-RET-CHK-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD  
C26296              PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT     
C26296              MOVE LENGTH OF WS-ATTRB-VAL-TX                      
C26296                                     TO YP-ATTRIBUTE-VALUE-TX-LEN 
C26296              MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
C26296              PERFORM 7600-INSERT-ATTRB-CD     THRU 7600-EXIT     
C26296           ELSE                                                   
C26296              MOVE 'U'               TO WS-RETCHK-FLAG            
C26296              MOVE PARM-RET-CHK-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD  
C26296              PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT     
C26296              MOVE LENGTH OF WS-ATTRB-VAL-TX                      
C26296                                     TO YP-ATTRIBUTE-VALUE-TX-LEN 
C26296              MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
C26296              PERFORM 7700-UPDATE-ATTRB-CD     THRU 7700-EXIT     
C26296           END-IF                                                 
C26296        END-IF                                                    
C26296     END-IF.                                                      
C26296*                                                                         
C26296 2600-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C29533******************************************************************        
C29533* 2610-GET-BILL-NOTIFICATION                                     *        
C29533*                                                                *07520000
C29533*     CALLED FROM 2300-BUILD-RESULT                              *        
C29533*                                                                *        
C29533*     SELECT FROM CSS_ACCOUNT AND CSS_ACCT_ATTRIBUTE             *07530029
C29533******************************************************************07550000
C29533*                                                                         
C29533 2610-GET-BILL-NOTIFICATION.                                      
C29533*                                                                         
C29533     MOVE 'EMAIL_BILLNOTIFY'    TO YP-ATTRIBUTE-DESC.             
C29533     PERFORM 7910-CHECK-ACCT-ATTRB THRU 7910-EXIT.                
C29533     IF NO-NOTIFICATION                                           
C29533        MOVE '4'                TO WS-BILL-NOTIFICATION           
C29533     ELSE                                                         
C29533        IF AT-NO-BILL-COPIES EQUAL 0                              
C29533           MOVE '1'             TO WS-BILL-NOTIFICATION           
C29533        ELSE                                                      
C29533           IF AT-NO-BILL-COPIES > 0                               
C29533              MOVE 'EMAIL_PAPERONLY'   TO YP-ATTRIBUTE-DESC       
C29533              MOVE 'EMAIL'             TO WS-ATTRIBUTE-TYPE       
C29533              PERFORM 7920-CHECK-ATTRB THRU 7920-EXIT             
C29533              IF PAPER-ONLY                                       
C29533                 MOVE '3'       TO WS-BILL-NOTIFICATION           
C29533              ELSE                                                
P00150                 MOVE '5'       TO WS-BILL-NOTIFICATION           
C29533              END-IF                                              
C29533           END-IF                                                 
C29533        END-IF                                                    
C29533     END-IF.                                                      
C29533*                                                                         
C29533 2610-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C26296 2650-GET-ATTRB-VAL-TX.                                           
C26296*                                                                         
C26296     EVALUATE YP-ATTRIBUTE-VALUE-CD                               
C26296        WHEN '0'                                                  
C26296            MOVE 'CURRENT MONTH'          TO WS-ATTRB-VAL-TX      
C26296        WHEN '1'                                                  
C26296            MOVE 'CURRENT MONTH +1 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '2'                                                  
C26296            MOVE 'CURRENT MONTH +2 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '3'                                                  
C26296            MOVE 'CURRENT MONTH +3 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '4'                                                  
C26296            MOVE 'CURRENT MONTH +4 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '5'                                                  
C26296            MOVE 'CURRENT MONTH +5 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '6'                                                  
C26296            MOVE 'CURRENT MONTH +6 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '7'                                                  
C26296            MOVE 'CURRENT MONTH +7 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '8'                                                  
C26296            MOVE 'CURRENT MONTH +8 MONTH' TO WS-ATTRB-VAL-TX      
C26296        WHEN '9'                                                  
C26296            MOVE 'CURRENT MONTH +9 MONTH' TO WS-ATTRB-VAL-TX      
P00471        WHEN 'L'                                                  
P00471            MOVE 'INDEFINITE ALL'         TO WS-ATTRB-VAL-TX      
C26296     END-EVALUATE.                                                
C26296*                                                                         
C26296 2650-EXIT.                                                       
C26296     EXIT.                                                        
C29533******************************************************************06620000
C29533* ADD/UPDATE/DELETE BILL NOTIFICATION CODES IN CSS_ACCT_ATTRIBUTE*06620000
C29533******************************************************************06620000
C29533 2700-UPDATE-BILL-NOTIFICATION.                                   
C29533*                                                                         
C29533     MOVE WS-ACCOUNT-NO                   TO AT-ACCOUNT-NO.       
C29533     MOVE AT-NO-BILL-COPIES               TO WS-OLD-NO-COPIES.    
C29533     MOVE PARM-EBILL-COPIES               TO AT-NO-BILL-COPIES.   
C29533     EVALUATE PARM-BILL-NOTIFICATION                              
C29533        WHEN '1'                                                  
C29533             PERFORM 2710-EMAIL-ONLY      THRU 2710-EXIT          
C29533        WHEN '2'                                                  
C29533             PERFORM 2720-EMAIL-PAPER     THRU 2720-EXIT          
C29533        WHEN '3'                                                  
C29533             PERFORM 2730-PAPER-ONLY      THRU 2730-EXIT          
C29533        WHEN '4'                                                  
C29533             PERFORM 2740-NO-BILL-NOTIFY  THRU 2740-EXIT          
C29533     END-EVALUATE.                                                
C29533*                                                                         
C29533 2700-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C29533 2710-EMAIL-ONLY.                                                 
C29533*                                                                         
C29533     IF WS-OLD-NO-COPIES NOT EQUAL ZEROS                          
C29533        MOVE ZEROS                        TO AT-NO-BILL-COPIES    
C29533     END-IF.                                                      
C29533     PERFORM 7900-UPDATE-ACCT             THRU 7900-EXIT.         
C29533     MOVE 'EMAIL_PAPERONLY'               TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29533        PERFORM 7800-DELETE-ATTRB-CD      THRU 7800-EXIT          
C29533     END-IF.                                                      
C29533     MOVE 'EMAIL_BILLNOTIFY'              TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29533        PERFORM 7800-DELETE-ATTRB-CD      THRU 7800-EXIT          
C29533     END-IF.                                                      
C29533*                                                                         
C29533 2710-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C29533 2720-EMAIL-PAPER.                                                
C29533*                                                                         
C29533     PERFORM 7900-UPDATE-ACCT             THRU 7900-EXIT.         
C29533     MOVE 'EMAIL_PAPERONLY'               TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29533        PERFORM 7800-DELETE-ATTRB-CD      THRU 7800-EXIT          
C29533     END-IF.                                                      
C29533     MOVE 'EMAIL_BILLNOTIFY'              TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29533        PERFORM 7800-DELETE-ATTRB-CD      THRU 7800-EXIT          
C29533     END-IF.                                                      
C29533*                                                                         
C29533 2720-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C29533 2730-PAPER-ONLY.                                                 
C29533*                                                                         
C29533     PERFORM 7900-UPDATE-ACCT             THRU 7900-EXIT.         
C29533     MOVE 'EMAIL_PAPERONLY'               TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C29533        MOVE WS-ACCOUNT-NO                TO YP-ACCOUNT-NO        
P00471        MOVE SPACES                       TO YP-STATUS-CD         
C29533        MOVE 'YES'                        TO YP-ATTRIBUTE-VALUE-CD
C29533        MOVE +15                          TO                      
C29533                                        YP-ATTRIBUTE-VALUE-TX-LEN 
C29533        MOVE 'EMAIL_PAPERONLY'            TO                      
C29533                                        YP-ATTRIBUTE-VALUE-TX-TEXT
C29533        PERFORM 7600-INSERT-ATTRB-CD      THRU 7600-EXIT          
C29533     END-IF.                                                      
C29533     MOVE 'EMAIL_BILLNOTIFY'              TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29533        PERFORM 7800-DELETE-ATTRB-CD      THRU 7800-EXIT          
C29533     END-IF.                                                      
C29533*                                                                         
C29533 2730-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C29533 2740-NO-BILL-NOTIFY.                                             
C29533*                                                                         
C29533     IF WS-OLD-NO-COPIES NOT EQUAL ZEROS                          
C29533        MOVE ZEROS                        TO AT-NO-BILL-COPIES    
C29533     END-IF.                                                      
C29533     PERFORM 7900-UPDATE-ACCT             THRU 7900-EXIT.         
C29533     MOVE 'EMAIL_BILLNOTIFY'              TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
C29533        MOVE WS-ACCOUNT-NO                TO YP-ACCOUNT-NO        
P00471        MOVE SPACES                       TO YP-STATUS-CD         
C29533        MOVE 'NO'                         TO YP-ATTRIBUTE-VALUE-CD
C29533        MOVE +16                          TO                      
C29533                                       YP-ATTRIBUTE-VALUE-TX-LEN  
C29533        MOVE 'EMAIL_BILLNOTIFY'           TO                      
C29533                                       YP-ATTRIBUTE-VALUE-TX-TEXT 
C29533        PERFORM 7600-INSERT-ATTRB-CD      THRU 7600-EXIT          
C29533     END-IF.                                                      
C29533     MOVE 'EMAIL_PAPERONLY'               TO YP-ATTRIBUTE-DESC.   
C29533     PERFORM 7500-SELECT-ACCT-ATTRIBUTE   THRU 7500-EXIT          
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C29533        PERFORM 7800-DELETE-ATTRB-CD      THRU 7800-EXIT          
C29533     END-IF.                                                      
C29533*                                                                         
C29533 2740-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C31813******************************************************************06620000
C31813* ADD/DELETE-CONVERT_CHK_ELEC (IN CSS_ACCT_ATTRIBUTE)            *06620000
C31813******************************************************************06620000
C31813 2800-UPDATE-ARC-IND.                                             
C31813*                                                                         
C31813     MOVE WS-ACCOUNT-NO                   TO AT-ACCOUNT-NO.       
C31813     IF PARM-ARC-IND = 'I'                                        
C31813        CONTINUE                                                  
C31813     ELSE                                                         
C31813        PERFORM 7930-CHECK-ARC-IND        THRU 7930-EXIT          
C31813        IF PARM-ARC-IND = WS-PREV-ARC-IND                         
C31813           CONTINUE                                               
C31813        ELSE                                                      
C31813           PERFORM 5000-MAINTENANCE-HISTORY THRU 5000-EXIT        
C31813           MOVE 'PANEL49A'                   TO MH-APPL-PROGRAM-ID
C31813           IF PARM-TRAN-COMMENT = SPACES                          
C31813              IF PARM-ARC-IND = 'N'                               
C31813                 MOVE WS-COMMENTS-NO         TO                   
C31813                                             MH-TRAN-COMMENT-TEXT 
C31813                 MOVE LENGTH OF MH-TRAN-COMMENT-TEXT              
C31813                                           TO MH-TRAN-COMMENT-LEN 
C31813              ELSE                                                
C31813                 MOVE WS-COMMENTS-YES        TO                   
C31813                                             MH-TRAN-COMMENT-TEXT 
C31813                 MOVE LENGTH OF MH-TRAN-COMMENT-TEXT              
C31813                                           TO MH-TRAN-COMMENT-LEN 
C31813              END-IF                                              
C31813           ELSE                                                   
C31813              IF PARM-ARC-IND = 'N'                               
C31813                 STRING PARM-TRAN-COMMENT(1:PARM-TRAN-COMMENT-LEN)
C31813                                          DELIMITED BY SIZE       
C31813                        '-'               DELIMITED BY SIZE       
C31813                        WS-COMMENTS-NO    DELIMITED BY SIZE       
C31813                                     INTO MH-TRAN-COMMENT-TEXT    
C31813                 MOVE LENGTH OF MH-TRAN-COMMENT-TEXT              
C31813                                           TO MH-TRAN-COMMENT-LEN 
C31813              ELSE                                                
C31813                 STRING PARM-TRAN-COMMENT(1:PARM-TRAN-COMMENT-LEN)
C31813                                          DELIMITED BY SIZE       
C31813                        '-'               DELIMITED BY SIZE       
C31813                        WS-COMMENTS-YES   DELIMITED BY SIZE       
C31813                                     INTO MH-TRAN-COMMENT-TEXT    
C31813                 MOVE LENGTH OF MH-TRAN-COMMENT-TEXT              
C31813                                           TO MH-TRAN-COMMENT-LEN 
C31813              END-IF                                              
C31813           END-IF                                                 
C31813           IF PARM-ARC-IND = 'N'                                  
C31813              MOVE WS-ACCOUNT-NO             TO YP-ACCOUNT-NO     
P00471              MOVE SPACES                    TO YP-STATUS-CD      
C31813              MOVE 'CONVERT_CHK_ELEC'        TO YP-ATTRIBUTE-DESC 
C31813              MOVE 'NO'                      TO                   
C31813                                             YP-ATTRIBUTE-VALUE-CD
C31813              MOVE +60                       TO                   
C31813                                        YP-ATTRIBUTE-VALUE-TX-LEN 
C31813              MOVE                                                
C31813     'CONVERT CHECK ELECTRONICALLY FOR PROCESSING -DEFAULT IS YES'
C31813                                     TO YP-ATTRIBUTE-VALUE-TX-TEXT
C31813              PERFORM 7600-INSERT-ATTRB-CD   THRU 7600-EXIT       
C31813****INSERT MNT TRANSACTION DETAILS                                        
C31813              MOVE 'CONV CHK (ARC)'      TO MI-COLUMN-DESC        
C31813              MOVE +3                    TO                       
C31813                                         MI-PRV-COLUMN-VALUE-LEN  
C31813              MOVE 'YES'                 TO                       
C31813                                         MI-PRV-COLUMN-VALUE-TEXT 
C31813              MOVE +2                    TO                       
C31813                                         MI-CHG-COLUMN-VALUE-LEN  
C31813              MOVE 'NO'                  TO                       
C31813                                         MI-CHG-COLUMN-VALUE-TEXT 
C31813              MOVE SPACES                 TO MI-TABLE-ID          
C31813              PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT
C31813           ELSE                                                   
C31813              MOVE WS-ACCOUNT-NO             TO YP-ACCOUNT-NO     
C31813              MOVE 'CONVERT_CHK_ELEC'        TO YP-ATTRIBUTE-DESC 
C31813              PERFORM 7800-DELETE-ATTRB-CD   THRU 7800-EXIT       
C31813****INSERT MNT TRANSACTION DETAILS                                        
C31813              MOVE 'CONV CHK (ARC)'      TO MI-COLUMN-DESC        
C31813              MOVE +2                    TO                       
C31813                                         MI-PRV-COLUMN-VALUE-LEN  
C31813              MOVE 'NO'                  TO                       
C31813                                         MI-PRV-COLUMN-VALUE-TEXT 
C31813              MOVE +3                    TO                       
C31813                                         MI-CHG-COLUMN-VALUE-LEN  
C31813              MOVE 'YES'                 TO                       
C31813                                         MI-CHG-COLUMN-VALUE-TEXT 
C31813              MOVE SPACES                 TO MI-TABLE-ID          
C31813              PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT
C31813           END-IF                                                 
C31813        END-IF                                                    
C31813     END-IF.                                                      
C31813*                                                                         
C31813 2800-UPDATE-EXIT.                                                
C31813     EXIT.                                                        
C31813*                                                                         
      *****************************************************************         
      * 2800-TRANSFER-HISTORY.                                        *         
      *     CALLS       5000-MAINTENANCE-HISTORY                      * 06640011
      *                 5010-MNT-HST-DET                              *         
      *                                                               *         
      *     CALLED FROM 2000-PROCESS-OUTPUT                           * 06680000
      *                                                               *         
      *     INSERTS INTO CSS_MNT_TRANS_HIST & CSS_MT_TRN_HST_DET      *         
      *****************************************************************         
                                                                        
       2800-TRANSFER-HISTORY.                                           
                                                                        
           MOVE '2800'                        TO ACTIVE-PARAGRAPH.      
                                                                        
           PERFORM 5000-MAINTENANCE-HISTORY   THRU 5000-EXIT.           
                                                                        
T33462     IF PARM-RELEASE-BILL-OPTN = WS-EXCLUDE                       
T33462        MOVE +26                   TO MH-TRAN-COMMENT-LEN         
T33462        MOVE 'ACCT EXCLUDED FROM BILLING'                         
T33462                                   TO MH-TRAN-COMMENT-TEXT        
T33462     END-IF                                                       
                                                                        
           IF WS-PRV-CODE-PERM-BILL = PARM-CODE-PERM-BILL               
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE 'PERM PULL CODE'       TO MI-COLUMN-DESC              
             MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN     
             MOVE WS-PRV-CODE-PERM-BILL  TO MI-PRV-COLUMN-VALUE-TEXT    
             MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-CODE-PERM-BILL    TO MI-CHG-COLUMN-VALUE-TEXT    
             MOVE '70'                   TO MI-TABLE-ID                 
             PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
           END-IF.                                                      
                                                                        
           IF WS-PRV-CODE-TEMP-BILL = PARM-CODE-TEMP-BILL               
             NEXT SENTENCE                                              
           ELSE                                                         
             MOVE 'TEMP PULL CODE'       TO MI-COLUMN-DESC              
             MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN     
             MOVE WS-PRV-CODE-TEMP-BILL  TO MI-PRV-COLUMN-VALUE-TEXT    
             MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN     
             MOVE PARM-CODE-TEMP-BILL    TO MI-CHG-COLUMN-VALUE-TEXT    
             MOVE '71'                   TO MI-TABLE-ID                 
             PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
           END-IF.                                                      
                                                                        
T15268     IF WS-PRV-LOCK-BOX-NO    =    PARM-LOCK-BOX-NO               
T15268       NEXT SENTENCE                                              
T15268     ELSE                                                         
T15268       MOVE 'LOCK BOX NO'          TO MI-COLUMN-DESC              
T15268       MOVE +7                     TO MI-PRV-COLUMN-VALUE-LEN     
T15268       MOVE WS-PRV-LOCK-BOX-NO     TO MI-PRV-COLUMN-VALUE-TEXT    
T15268       MOVE +7                     TO MI-CHG-COLUMN-VALUE-LEN     
T15268       MOVE PARM-LOCK-BOX-NO       TO MI-CHG-COLUMN-VALUE-TEXT    
T15268       MOVE SPACES                 TO MI-TABLE-ID                 
T15268       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
T15268     END-IF.                                                      
                                                                        
T20583     IF AT-CODE-ACCT-BILLED NOT EQUAL WS-PRV-CODE-ACCT-BILL       
PCR671       MOVE 'ACCT BILLED CD'       TO MI-COLUMN-DESC              
PCR671       MOVE +1                     TO MI-PRV-COLUMN-VALUE-LEN     
PCR671       MOVE WS-PRV-CODE-ACCT-BILL  TO MI-PRV-COLUMN-VALUE-TEXT    
PCR671       MOVE +1                     TO MI-CHG-COLUMN-VALUE-LEN     
PCR671       MOVE AT-CODE-ACCT-BILLED    TO MI-CHG-COLUMN-VALUE-TEXT    
T21805       MOVE '72'                   TO MI-TABLE-ID                 
PCR671       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
PCR671     END-IF.                                                      
C26296*                                                                         
C26296     IF WS-DNP-FLAG = 'I' AND DNP-EXMP-CHG                        
C26296       MOVE 'DNPAUTODEPEXEMP'      TO MI-COLUMN-DESC              
C26296       MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN     
C26296       MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT    
C26296       MOVE PARM-DNP-EXMP-CD       TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-CHG-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-CHG-COLUMN-VALUE-TEXT    
C26296       MOVE SPACES                 TO MI-TABLE-ID                 
C26296       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C26296     END-IF.                                                      
C26296*                                                                         
C26296     IF WS-DNP-FLAG = 'U' AND DNP-EXMP-CHG                        
C26296       MOVE 'DNPAUTODEPEXEMP'      TO MI-COLUMN-DESC              
C26296       MOVE WS-PRV-DNP-EXMP-CD     TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-PRV-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-PRV-COLUMN-VALUE-TEXT    
C26296       MOVE PARM-DNP-EXMP-CD       TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-CHG-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-CHG-COLUMN-VALUE-TEXT    
C26296       MOVE SPACES                 TO MI-TABLE-ID                 
C26296       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C26296     END-IF.                                                      
C26296*                                                                         
C26296     IF WS-DNP-FLAG = 'D' AND DNP-EXMP-CHG                        
C26296       MOVE 'DNPAUTODEPEXEMP'      TO MI-COLUMN-DESC              
C26296       MOVE WS-PRV-DNP-EXMP-CD     TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-PRV-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-PRV-COLUMN-VALUE-TEXT    
C26296       MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN     
C26296       MOVE '*DELETE*'             TO MI-CHG-COLUMN-VALUE-TEXT    
C26296       MOVE SPACES                 TO MI-TABLE-ID                 
C26296       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C26296     END-IF.                                                      
C26296*                                                                         
C26296     IF WS-RETCHK-FLAG = 'I' AND RET-CHK-EXMP-CHG                 
C26296       MOVE 'RETAUTODEPEXEMP'      TO MI-COLUMN-DESC              
C26296       MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN     
C26296       MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT    
C26296       MOVE PARM-RET-CHK-EXMP-CD   TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-CHG-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-CHG-COLUMN-VALUE-TEXT    
C26296       MOVE SPACES                 TO MI-TABLE-ID                 
C26296       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C26296     END-IF.                                                      
C26296*                                                                         
C26296     IF WS-RETCHK-FLAG = 'U' AND RET-CHK-EXMP-CHG                 
C26296       MOVE 'RETAUTODEPEXEMP'      TO MI-COLUMN-DESC              
C26296       MOVE WS-PRV-RET-CHK-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-PRV-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-PRV-COLUMN-VALUE-TEXT    
C26296       MOVE PARM-RET-CHK-EXMP-CD   TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-CHG-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-CHG-COLUMN-VALUE-TEXT    
C26296       MOVE SPACES                 TO MI-TABLE-ID                 
C26296       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C26296     END-IF.                                                      
C26296*                                                                         
C26296     IF WS-RETCHK-FLAG = 'D' AND RET-CHK-EXMP-CHG                 
C26296       MOVE 'RETAUTODEPEXEMP'      TO MI-COLUMN-DESC              
C26296       MOVE WS-PRV-RET-CHK-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD       
C26296       PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT            
C26296       MOVE LENGTH OF WS-ATTRB-VAL-TX                             
C26296                                   TO MI-PRV-COLUMN-VALUE-LEN     
C26296       MOVE WS-ATTRB-VAL-TX        TO MI-PRV-COLUMN-VALUE-TEXT    
C26296       MOVE +8                     TO MI-CHG-COLUMN-VALUE-LEN     
C26296       MOVE '*DELETE*'             TO MI-CHG-COLUMN-VALUE-TEXT    
C26296       MOVE SPACES                 TO MI-TABLE-ID                 
C26296       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C26296     END-IF.                                                      
C26296*                                                                         
P00471     IF DPPDROP-EXMP-CHG                                          
P00471       MOVE 'DPPDROPEXEMPIND'      TO MI-COLUMN-DESC              
P00471       MOVE WS-PRV-DPPDROP-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD       
P00471       IF YP-ATTRIBUTE-VALUE-CD = SPACES                          
P00471          MOVE +5                    TO MI-PRV-COLUMN-VALUE-LEN   
P00471          MOVE '*NEW*'               TO MI-PRV-COLUMN-VALUE-TEXT  
P00471       ELSE                                                       
P00471          PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT         
P00471          MOVE LENGTH OF WS-ATTRB-VAL-TX                          
P00471                                      TO MI-PRV-COLUMN-VALUE-LEN  
P00471          MOVE WS-ATTRB-VAL-TX        TO MI-PRV-COLUMN-VALUE-TEXT 
P00471       END-IF                                                     
P00471       MOVE PARM-DPPDROP-EXMP-CD TO YP-ATTRIBUTE-VALUE-CD         
P00471       IF YP-ATTRIBUTE-VALUE-CD = SPACES                          
P00471          MOVE +9                    TO MI-CHG-COLUMN-VALUE-LEN   
P00471          MOVE '*DELETED*'           TO MI-CHG-COLUMN-VALUE-TEXT  
P00471       ELSE                                                       
P00471          PERFORM 2650-GET-ATTRB-VAL-TX    THRU 2650-EXIT         
P00471          MOVE LENGTH OF WS-ATTRB-VAL-TX                          
P00471                                      TO MI-CHG-COLUMN-VALUE-LEN  
P00471          MOVE WS-ATTRB-VAL-TX        TO MI-CHG-COLUMN-VALUE-TEXT 
P00471       END-IF                                                     
P00471       MOVE SPACES                 TO MI-TABLE-ID                 
P00471       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
P00471     END-IF.                                                      
P00471*                                                                         
C29533     IF WS-OLD-NO-COPIES NOT EQUAL AT-NO-BILL-COPIES              
C29533       MOVE 'NO BILL COPIES'       TO MI-COLUMN-DESC              
C29533       MOVE +4                     TO MI-PRV-COLUMN-VALUE-LEN     
C29533       MOVE WS-OLD-NO-COPIES       TO MI-PRV-COLUMN-VALUE-TEXT    
C29533       MOVE +4                     TO MI-CHG-COLUMN-VALUE-LEN     
C29533       MOVE AT-NO-BILL-COPIES      TO MI-CHG-COLUMN-VALUE-TEXT    
C29533       MOVE SPACES                 TO MI-TABLE-ID                 
C29533       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C29533     END-IF.                                                      
                                                                        
C29533     IF WS-BILL-NOTIFICATION NOT EQUAL PARM-BILL-NOTIFICATION     
C29533       MOVE 'BILL NOTIFY OPT'      TO MI-COLUMN-DESC              
C29533       EVALUATE WS-BILL-NOTIFICATION                              
C29533         WHEN 1                                                   
C29533          MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN  
C29533          MOVE 'PAPERLESS/EMAIL'      TO MI-PRV-COLUMN-VALUE-TEXT 
C29533         WHEN 2                                                   
C29533          MOVE +15                    TO MI-PRV-COLUMN-VALUE-LEN  
C29533          MOVE 'EMAIL AND PAPER'      TO MI-PRV-COLUMN-VALUE-TEXT 
C29533         WHEN 3                                                   
C29533          MOVE +10                    TO MI-PRV-COLUMN-VALUE-LEN  
C29533          MOVE 'PAPER ONLY'           TO MI-PRV-COLUMN-VALUE-TEXT 
C29533         WHEN 4                                                   
C29533          MOVE +17                    TO MI-PRV-COLUMN-VALUE-LEN  
C29533          MOVE 'NO PAPER/NO EMAIL'    TO MI-PRV-COLUMN-VALUE-TEXT 
P00150         WHEN 5                                                   
P00150          MOVE +25                    TO MI-PRV-COLUMN-VALUE-LEN  
P00150          MOVE 'SYSTEM DEFAULT PAPER ONLY'                        
P00150                                      TO MI-PRV-COLUMN-VALUE-TEXT 
C29533       END-EVALUATE                                               
C29533       EVALUATE PARM-BILL-NOTIFICATION                            
C29533         WHEN 1                                                   
C29533          MOVE +15                    TO MI-CHG-COLUMN-VALUE-LEN  
C29533          MOVE 'PAPERLESS/EMAIL'      TO MI-CHG-COLUMN-VALUE-TEXT 
C29533         WHEN 2                                                   
C29533          MOVE +15                    TO MI-CHG-COLUMN-VALUE-LEN  
C29533          MOVE 'EMAIL AND PAPER'      TO MI-CHG-COLUMN-VALUE-TEXT 
C29533         WHEN 3                                                   
C29533          MOVE +10                    TO MI-CHG-COLUMN-VALUE-LEN  
C29533          MOVE 'PAPER ONLY'           TO MI-CHG-COLUMN-VALUE-TEXT 
C29533         WHEN 4                                                   
C29533          MOVE +17                    TO MI-CHG-COLUMN-VALUE-LEN  
C29533          MOVE 'NO PAPER/NO EMAIL'    TO MI-CHG-COLUMN-VALUE-TEXT 
P00150         WHEN 5                                                   
P00150          MOVE +25                    TO MI-CHG-COLUMN-VALUE-LEN  
P00150          MOVE 'SYSTEM DEFAULT PAPER ONLY'                        
P00150                                      TO MI-CHG-COLUMN-VALUE-TEXT 
C29533       END-EVALUATE                                               
C29533       MOVE SPACES                 TO MI-TABLE-ID                 
C29533       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
C29533     END-IF.                                                      
                                                                        
P00773     IF WS-REVIEW-EXEMPT-CHG = 'I'                                
P00773       MOVE 'ARREARS ACCOUNT REVIEW EXEMPT FROM DEPOSIT'          
P00773                                          TO MH-TRAN-COMMENT-TEXT 
P00773       MOVE +42                           TO MH-TRAN-COMMENT-LEN  
P00773       MOVE 'PANEL490A'            TO MH-APPL-PROGRAM-ID          
P00773       MOVE 'ACCOUNT REVIEW'       TO MI-COLUMN-DESC              
P00773       MOVE +5                     TO MI-PRV-COLUMN-VALUE-LEN     
P00773       MOVE '*NEW*'                TO MI-PRV-COLUMN-VALUE-TEXT    
P00773       MOVE +3                     TO MI-CHG-COLUMN-VALUE-LEN     
P00773       MOVE 'YES'                  TO MI-CHG-COLUMN-VALUE-TEXT    
P00773       MOVE SPACES                 TO MI-TABLE-ID                 
P00773       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
P00773     END-IF.                                                      
P00773     IF WS-REVIEW-EXEMPT-CHG = 'D'                                
P00773       MOVE 'ARREARS ACCOUNT REVIEW EXEMPT FROM DEPOSIT'          
P00773                                          TO MH-TRAN-COMMENT-TEXT 
P00773       MOVE +42                           TO MH-TRAN-COMMENT-LEN  
P00773       MOVE 'PANEL490A'            TO MH-APPL-PROGRAM-ID          
P00773       MOVE 'ACCOUNT REVIEW'       TO MI-COLUMN-DESC              
P00773       MOVE +3                     TO MI-PRV-COLUMN-VALUE-LEN     
P00773       MOVE 'YES'                  TO MI-PRV-COLUMN-VALUE-TEXT    
P00773       MOVE +9                     TO MI-CHG-COLUMN-VALUE-LEN     
P00773       MOVE '*DELETED*'            TO MI-CHG-COLUMN-VALUE-TEXT    
P00773       MOVE SPACES                 TO MI-TABLE-ID                 
P00773       PERFORM 5010-MNT-HST-DETAIL           THRU 5010-EXIT       
P00773     END-IF.                                                      
                                                                        
       2800-EXIT.                                                       
           EXIT.                                                        
                                                                        
C30169*****************************************************************         
C30169* 2900-UPDATE-CRXMT-CD                                          *         
C30169*****************************************************************         
C30169                                                                  
C30169 2900-UPDATE-CRXMT-CD.                                            
C30169                                                                  
C30169     MOVE 'CAEXEMPT'                    TO YP-ATTRIBUTE-DESC.     
C30169     MOVE PARM-USER-ID                  TO PF-USER-ID.            
C30169     PERFORM 7970-SELECT-USER-NAME      THRU 7970-EXIT.           
C30169     PERFORM 7500-SELECT-ACCT-ATTRIBUTE THRU 7500-EXIT.           
C30169     MOVE YP-ATTRIBUTE-VALUE-CD         TO WS-PREV-CAXMT-CD       
C30169     MOVE PARM-CA-EXEMPT                TO YP-ATTRIBUTE-VALUE-CD  
C30169     IF PARM-CA-EXEMPT NOT EQUAL WS-PREV-CAXMT-CD                 
C30169        SET CA-XMT-CHG                  TO TRUE                   
C30169        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00471           MOVE SPACES                  TO YP-STATUS-CD           
C30169           MOVE ZEROS                   TO                        
C30169                                        YP-ATTRIBUTE-VALUE-TX-LEN 
C30169           MOVE SPACES                  TO                        
C30169                                        YP-ATTRIBUTE-VALUE-TX-TEXT
C30169           PERFORM 7600-INSERT-ATTRB-CD THRU 7600-EXIT            
C30169        ELSE                                                      
C30169           PERFORM 7700-UPDATE-ATTRB-CD THRU 7700-EXIT            
C30169        END-IF                                                    
C30169        IF AT-CODE-ACCT-STAT = 'S'                                
C30169        AND PARM-CA-EXEMPT > SPACES                               
C30169           PERFORM 2910-UPDATE-FINWO    THRU 2910-EXIT            
C30169        END-IF                                                    
C30169     END-IF.                                                      
C30169*                                                                         
C30169     MOVE 'CBEXEMPT'                    TO YP-ATTRIBUTE-DESC.     
C30169     PERFORM 7500-SELECT-ACCT-ATTRIBUTE THRU 7500-EXIT.           
C30169     MOVE YP-ATTRIBUTE-VALUE-CD         TO WS-PREV-CBXMT-CD       
C30169     MOVE PARM-CB-EXEMPT                TO YP-ATTRIBUTE-VALUE-CD  
C30169     IF PARM-CB-EXEMPT NOT EQUAL WS-PREV-CBXMT-CD                 
C30169        SET CB-XMT-CHG                  TO TRUE                   
C30169        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00471           MOVE SPACES                  TO YP-STATUS-CD           
C30169           MOVE ZEROS                   TO                        
C30169                                        YP-ATTRIBUTE-VALUE-TX-LEN 
C30169           MOVE SPACES                  TO                        
C30169                                        YP-ATTRIBUTE-VALUE-TX-TEXT
C30169           PERFORM 7600-INSERT-ATTRB-CD THRU 7600-EXIT            
C30169        ELSE                                                      
C30169           PERFORM 7700-UPDATE-ATTRB-CD THRU 7700-EXIT            
C30169        END-IF                                                    
C30169*                                                                         
C30169     END-IF.                                                      
C30169*                                                                         
C30169     PERFORM 5000-MAINTENANCE-HISTORY   THRU 5000-EXIT.           
C30169*                                                                         
C30169     IF WS-PREV-CAXMT-CD = PARM-CA-EXEMPT                         
C30169       NEXT SENTENCE                                              
C30169     ELSE                                                         
C30169       MOVE 'CAEXEMPT'                 TO MI-COLUMN-DESC          
C30169       MOVE 'CA'                       TO KV-FW-ATTRIB-TYPE-CD    
C30169       MOVE WS-PREV-CAXMT-CD           TO KV-FW-ATTR-VALUE-CD     
C30169       IF KV-FW-ATTR-VALUE-CD EQUAL SPACES                        
C30169          MOVE '**NEW**'               TO KV-FW-ATTR-VALUE-DESC   
C30169       ELSE                                                       
C30169          PERFORM 7940-GET-CRXMT-DESC  THRU 7940-EXIT             
C30169       END-IF                                                     
C30169       MOVE KV-FW-ATTR-VALUE-DESC      TO WS-PREV-CAXMT-DESC      
C30169       MOVE LENGTH OF WS-PREV-CAXMT-DESC                          
C30169                                       TO MI-PRV-COLUMN-VALUE-LEN 
C30169       MOVE WS-PREV-CAXMT-DESC         TO MI-PRV-COLUMN-VALUE-TEXT
C30169       MOVE 'CA'                       TO KV-FW-ATTRIB-TYPE-CD    
C30169       MOVE PARM-CA-EXEMPT             TO KV-FW-ATTR-VALUE-CD     
C30169       IF KV-FW-ATTR-VALUE-CD EQUAL SPACES                        
C30169          MOVE '**DELETED**'           TO KV-FW-ATTR-VALUE-DESC   
C30169       ELSE                                                       
C30169          PERFORM 7940-GET-CRXMT-DESC  THRU 7940-EXIT             
C30169       END-IF                                                     
C30169       MOVE KV-FW-ATTR-VALUE-DESC      TO WS-CA-EXEMPT-DESC       
C30169       MOVE LENGTH OF WS-CA-EXEMPT-DESC                           
C30169                                       TO MI-CHG-COLUMN-VALUE-LEN 
C30169       MOVE WS-CA-EXEMPT-DESC          TO MI-CHG-COLUMN-VALUE-TEXT
C30169       MOVE SPACES                     TO MI-TABLE-ID             
C30169       PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT             
C30169*                                                                         
C30169       IF PARM-CA-EXEMPT EQUAL SPACES                             
C30169          IF CB-XMT-CHG                                           
C30169             STRING 'COLLECTION AGENCY EXEMPTION REMOVED;'        
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          ELSE                                                    
C30169             STRING 'COLLECTION AGENCY EXEMPTION REMOVED BY '     
C30169                    DELIMITED BY SIZE                             
C30169                    WS-USER-NAME                                  
C30169                    DELIMITED BY '  '                             
C30169                    '.'                                           
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          END-IF                                                  
C30169       ELSE                                                       
C30169          IF CB-XMT-CHG                                           
C30169             STRING 'COLLECTION AGENCY EXEMPTION SET '            
C30169                    'WITH REASON OF '                             
C30169                    DELIMITED BY SIZE                             
C30169                    WS-CA-EXEMPT-DESC                             
C30169                    DELIMITED BY '  '                             
C30169                    ';'                                           
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          ELSE                                                    
C30169             STRING 'COLLECTION AGENCY EXEMPTION SET '            
C30169                    'WITH REASON OF '                             
C30169                    DELIMITED BY SIZE                             
C30169                    WS-CA-EXEMPT-DESC                             
C30169                    DELIMITED BY '  '                             
C30169                    ' BY '                                        
C30169                    DELIMITED BY SIZE                             
C30169                    WS-USER-NAME                                  
C30169                    DELIMITED BY '  '                             
C30169                    '.'                                           
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          END-IF                                                  
C30169       END-IF                                                     
C30169*                                                                         
C30169       IF CA-XMT-CHG AND CB-XMT-CHG                               
C30169          MOVE WS-WQ-MESSAGE           TO WS-WQ-MESSAGE-TMP       
C30169       ELSE                                                       
C30169          PERFORM 2920-GENERATE-WQ     THRU 2920-EXIT             
C30169       END-IF                                                     
C30169     END-IF.                                                      
C30169*                                                                         
C30169     IF WS-PREV-CBXMT-CD = PARM-CB-EXEMPT                         
C30169       NEXT SENTENCE                                              
C30169     ELSE                                                         
C30169       MOVE 'CBEXEMPT'                 TO MI-COLUMN-DESC          
C30169       MOVE 'CB'                       TO KV-FW-ATTRIB-TYPE-CD    
C30169       MOVE WS-PREV-CBXMT-CD           TO KV-FW-ATTR-VALUE-CD     
C30169       IF KV-FW-ATTR-VALUE-CD EQUAL SPACES                        
C30169          MOVE '**NEW**'               TO KV-FW-ATTR-VALUE-DESC   
C30169       ELSE                                                       
C30169          PERFORM 7940-GET-CRXMT-DESC  THRU 7940-EXIT             
C30169       END-IF                                                     
C30169       MOVE KV-FW-ATTR-VALUE-DESC      TO WS-PREV-CBXMT-DESC      
C30169       MOVE LENGTH OF WS-PREV-CBXMT-DESC                          
C30169                                       TO MI-PRV-COLUMN-VALUE-LEN 
C30169       MOVE WS-PREV-CBXMT-DESC         TO MI-PRV-COLUMN-VALUE-TEXT
C30169       MOVE 'CB'                       TO KV-FW-ATTRIB-TYPE-CD    
C30169       MOVE PARM-CB-EXEMPT             TO KV-FW-ATTR-VALUE-CD     
C30169       IF KV-FW-ATTR-VALUE-CD EQUAL SPACES                        
C30169          MOVE '**DELETED**'           TO KV-FW-ATTR-VALUE-DESC   
C30169       ELSE                                                       
C30169          PERFORM 7940-GET-CRXMT-DESC  THRU 7940-EXIT             
C30169       END-IF                                                     
C30169       MOVE KV-FW-ATTR-VALUE-DESC      TO WS-CB-EXEMPT-DESC       
C30169       MOVE LENGTH OF WS-CB-EXEMPT-DESC                           
C30169                                       TO MI-CHG-COLUMN-VALUE-LEN 
C30169       MOVE WS-CB-EXEMPT-DESC          TO MI-CHG-COLUMN-VALUE-TEXT
C30169       MOVE SPACES                     TO MI-TABLE-ID             
C30169       PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT             
C30169*                                                                         
C30169       IF PARM-CB-EXEMPT EQUAL SPACES                             
C30169          IF CA-XMT-CHG                                           
C30169             STRING WS-WQ-MESSAGE-TMP                             
C30169                    DELIMITED BY '  '                             
C30169                    'CREDIT BUREAU EXEMPTION REMOVED BY '         
C30169                    DELIMITED BY SIZE                             
C30169                    WS-USER-NAME                                  
C30169                    DELIMITED BY '  '                             
C30169                    '.'                                           
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          ELSE                                                    
C30169             STRING 'CREDIT BUREAU EXEMPTION REMOVED BY '         
C30169                    DELIMITED BY SIZE                             
C30169                    WS-USER-NAME                                  
C30169                    DELIMITED BY '  '                             
C30169                    '.'                                           
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          END-IF                                                  
C30169       ELSE                                                       
C30169          IF CA-XMT-CHG                                           
C30169             STRING WS-WQ-MESSAGE-TMP                             
C30169                    DELIMITED BY '  '                             
C30169                    'CREDIT BUREAU EXEMPTION SET WITH REASON OF ' 
C30169                    DELIMITED BY SIZE                             
C30169                    WS-CB-EXEMPT-DESC                             
C30169                    DELIMITED BY '  '                             
C30169                    ' BY '                                        
C30169                    DELIMITED BY SIZE                             
C30169                    WS-USER-NAME                                  
C30169                    DELIMITED BY '  '                             
C30169                    '.'                                           
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          ELSE                                                    
C30169             STRING 'CREDIT BUREAU EXEMPTION SET WITH REASON OF ' 
C30169                    DELIMITED BY SIZE                             
C30169                    WS-CB-EXEMPT-DESC                             
C30169                    DELIMITED BY '  '                             
C30169                    ' BY '                                        
C30169                    DELIMITED BY SIZE                             
C30169                    WS-USER-NAME                                  
C30169                    DELIMITED BY '  '                             
C30169                    '.'                                           
C30169                    DELIMITED BY SIZE                             
C30169               INTO WS-WQ-MESSAGE                                 
C30169          END-IF                                                  
C30169       END-IF                                                     
C30169*                                                                         
C30169       PERFORM 2920-GENERATE-WQ         THRU 2920-EXIT            
C30169     END-IF.                                                      
C30169*                                                                         
C30169                                                                  
C30169 2900-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169* 2910-UPDATE-FINWO                                             *         
C30169*****************************************************************         
C30169*                                                                         
C30169 2910-UPDATE-FINWO.                                               
C30169*                                                                         
C30169     PERFORM 7950-GET-COLL-STATCD       THRU 7950-EXIT.           
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        EVALUATE FW-COLLECT-STATUS-CD                             
C30169           WHEN 'F'                                               
C30169              MOVE '1PLMT'              TO IZ-FW-ACTION-TYPE-CD   
C30169           WHEN 'H'                                               
C30169              MOVE '2PLMT'              TO IZ-FW-ACTION-TYPE-CD   
C30169           WHEN 'J'                                               
C30169              MOVE '3PLMT'              TO IZ-FW-ACTION-TYPE-CD   
C30169           WHEN OTHER                                             
C30169              GO TO 2910-EXIT                                     
C30169        END-EVALUATE                                              
C30169        PERFORM 7960-GET-WO-AMT         THRU 7960-EXIT            
C30169        MOVE CO-AMT-TRANS               TO IZ-WITHDRAW-AM         
C30169        MOVE PARM-CA-EXEMPT             TO IZ-WITHDRAW-REASON-CD  
C30169        PERFORM 8100-UPDATE-FIN-WO      THRU 8100-EXIT            
C30169     END-IF.                                                      
C30169*                                                                         
C30169 2910-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
C30169*****************************************************************         
C30169* 2920-GENERATE-WQ                                              *         
C30169*****************************************************************         
C30169*                                                                         
C30169 2920-GENERATE-WQ.                                                
C30169*                                                                         
ACT116     INITIALIZE CWS00077-FIELDS.                                  
C30169     EXEC SQL                                                     
ACT116         SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-77-DATE-CREATED                   
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     39770000
MFA-TR*        SET :WS-77-DATE-CREATED = CURRENT DATE                   39780000
MFA-TR*    END-EXEC.                                                    39790000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE. 
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
C30169        MOVE WS-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
C30169        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169*                                                                         
ACT116     MOVE WS-CATEGORY-ID            TO WS-77-CATEGORY-ID.         
ACT116     MOVE PARM-RESP-AREA-ID         TO WS-77-RESP-AREA-ID.        
ACT116     MOVE ZEROS                     TO WS-77-SERV-ORDER-NO.       
ACT116     MOVE PARM-USER-ID              TO WS-77-USER-ID-ORIG.        
ACT116     MOVE WS-77-DATE-CREATED        TO WS-77-DATE-REQUIRED.       
ACT116     MOVE WS-ACCOUNT-NO             TO WS-77-ACCOUNT-NO.          
ACT116     MOVE PARM-CUSTOMER-NO-NUM      TO WS-77-CUSTOMER-NO.         
ACT116     MOVE ZEROS                     TO WS-77-PREMISE-NO.          
ACT116     MOVE AT-LOCAL-OFFICE           TO WS-77-LOCAL-OFFICE.        
ACT116     MOVE 5                         TO WS-77-ROUTE-CATEGORY.      
ACT116     MOVE WS-NO                     TO WS-77-PRIORITY.            
ACT116     MOVE WS-WQ-MESSAGE             TO WS-77-COMMENTS-TEXT.       
ACT116     MOVE LENGTH OF WS-WQ-MESSAGE   TO WS-77-COMMENTS-LEN.        
ACT116     MOVE SPACES                    TO WS-77-FREE-FORM-TXT.       
ACT116     MOVE ZERO                      TO WS-77-FREE-FORM-LEN.       
ACT116     MOVE PROGRAM-NAME              TO WS-77-CREATED-BY.          
C30169                                                                  
C30169     PERFORM 8895-INSERT-WORK-QUEUE THRU 8895-EXIT.               
C30169     MOVE SPACES                    TO WS-WQ-MESSAGE.             
C30169*                                                                         
C30169 2920-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
P00126*****************************************************************         
P00126* 2950-CHECK-EBILL-IND                                          *         
P00126*****************************************************************         
P00126*                                                                         
P00126 2950-CHECK-EBILL-IND.                                            
P00126*                                                                         
P00126     MOVE PARM-CUSTOMER-NO-NUM          TO CE-CUSTOMER-NO.        
P00126     PERFORM 7980-SELECT-CUST-STATS     THRU 7980-EXIT.           
P00126     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00126        IF PARM-EBILL-REGISTER-IND = CE-EBILL-REGISTER-IND        
P00126           GO TO 2950-EXIT                                        
P00126        END-IF                                                    
P00126        PERFORM 7985-UPDATE-EBILL       THRU 7985-EXIT            
P00126        IF PARM-EBILL-REGISTER-IND EQUAL SPACES                   
P00126           PERFORM 7995-DELETE-CUST-STATS  THRU 7995-EXIT         
P00126        END-IF                                                    
P00126     ELSE                                                         
P00126        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND AND                  
P00126           PARM-EBILL-REGISTER-IND NOT EQUAL CE-EBILL-REGISTER-IND
P00126           PERFORM 7988-GET-NAME-ID        THRU 7988-EXIT         
P00126           PERFORM 7990-INSERT-EBILL       THRU 7990-EXIT         
P00126        END-IF                                                    
P00126     END-IF.                                                      
P00126     IF PARM-EBILL-REGISTER-IND = CE-EBILL-REGISTER-IND           
P00126       NEXT SENTENCE                                              
P00126     ELSE                                                         
P00126       PERFORM 5000-MAINTENANCE-HISTORY THRU 5000-EXIT            
P00126       MOVE ZEROS                      TO MH-ACCOUNT-NO           
P00126       MOVE CE-CUSTOMER-NO             TO MH-CUSTOMER-NO          
P00126       MOVE 'EBILL'                    TO MI-COLUMN-DESC          
P00126       MOVE 1                          TO MI-PRV-COLUMN-VALUE-LEN 
P00126       IF CE-EBILL-REGISTER-IND EQUAL SPACES                      
P00126          MOVE 'N'                     TO MI-PRV-COLUMN-VALUE-TEXT
P00126       ELSE                                                       
P00126          MOVE CE-EBILL-REGISTER-IND                              
P00126                                       TO MI-PRV-COLUMN-VALUE-TEXT
P00126       END-IF                                                     
P00126       MOVE 1                          TO MI-CHG-COLUMN-VALUE-LEN 
P00126       IF PARM-EBILL-REGISTER-IND EQUAL SPACES                    
P00126          MOVE 'N'                     TO MI-CHG-COLUMN-VALUE-TEXT
P00126       ELSE                                                       
P00126          MOVE PARM-EBILL-REGISTER-IND                            
P00126                                       TO MI-CHG-COLUMN-VALUE-TEXT
P00126       END-IF                                                     
P00126       MOVE SPACES                     TO MI-TABLE-ID             
P00126       PERFORM 5010-MNT-HST-DETAIL     THRU 5010-EXIT             
P00126     END-IF.                                                      
P00126*                                                                         
P00126 2950-EXIT.                                                       
P00126     EXIT.                                                        
P00126*                                                                         
P00471*                                                                         
P00471******************************************************************06620000
P00471* ADD/UPDATE/DELETE DPP DROP EXEMPTION CODE IN CSS_ACCT_ATTRIBUTE*06620000
P00471******************************************************************06620000
P00471 2960-UPDATE-DPPDROP-ATTRB.                                       
P00471*                                                                         
P00471     MOVE WS-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
P00471     MOVE WS-DPPDROP-EXMP-IND        TO YP-ATTRIBUTE-DESC.        
P00471     PERFORM 7500-SELECT-ACCT-ATTRIBUTE        THRU 7500-EXIT.    
P00471     MOVE YP-ATTRIBUTE-VALUE-CD      TO WS-PRV-DPPDROP-EXMP-CD.   
P00471     IF YP-ATTRIBUTE-VALUE-CD NOT EQUAL PARM-DPPDROP-EXMP-CD      
P00471        SET DPPDROP-EXMP-CHG TO TRUE                              
P00471        IF PARM-DPPDROP-EXMP-CD = SPACES                          
P00471           MOVE 'D'                  TO WS-DPPDROP-FLAG           
P00471           PERFORM 7800-DELETE-ATTRB-CD     THRU 7800-EXIT        
P00471        ELSE                                                      
P00471           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                   
P00471              MOVE 'I'                   TO WS-DPPDROP-FLAG       
P00471              MOVE 'A'                   TO YP-STATUS-CD          
P00471              MOVE PARM-DPPDROP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD 
P00471              PERFORM 2650-GET-ATTRB-VAL-TX THRU 2650-EXIT        
P00471              MOVE LENGTH OF WS-ATTRB-VAL-TX                      
P00471                                     TO YP-ATTRIBUTE-VALUE-TX-LEN 
P00471              MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
P00471              PERFORM 7600-INSERT-ATTRB-CD  THRU 7600-EXIT        
P00471          ELSE                                                    
P00471              MOVE 'U'               TO WS-DPPDROP-FLAG           
P00471              MOVE PARM-DPPDROP-EXMP-CD  TO YP-ATTRIBUTE-VALUE-CD 
P00471              PERFORM 2650-GET-ATTRB-VAL-TX THRU 2650-EXIT        
P00471              MOVE LENGTH OF WS-ATTRB-VAL-TX                      
P00471                                     TO YP-ATTRIBUTE-VALUE-TX-LEN 
P00471              MOVE WS-ATTRB-VAL-TX   TO YP-ATTRIBUTE-VALUE-TX-TEXT
P00471              PERFORM 7700-UPDATE-ATTRB-CD  THRU 7700-EXIT        
P00471          END-IF                                                  
P00471        END-IF                                                    
P00471     END-IF.                                                      
P00471*                                                                         
P00471 2960-EXIT.                                                       
P00471     EXIT.                                                        
                                                                        
P00773******************************************************************06620000
P00773* ADD/DELETE ACCT REVIEW EXEMPT FLAG IN CSS_ACCT_ATTRIBUTE       *06620000
P00773******************************************************************06620000
P00773 2970-UPDATE-REVIEW-EXEMPT.                                       
P00773*                                                                         
P00773     MOVE WS-ACCOUNT-NO              TO YP-ACCOUNT-NO.            
P00773     MOVE 'REVIEW EXEMPT'            TO YP-ATTRIBUTE-DESC.        
P00773     PERFORM 7500-SELECT-ACCT-ATTRIBUTE THRU 7500-EXIT.           
P00773     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00773        IF PARM-REVIEW-EXEMPT-FL = 'N'                            
P00773           MOVE 'D'                  TO WS-REVIEW-EXEMPT-CHG      
P00773           PERFORM 7800-DELETE-ATTRB-CD     THRU 7800-EXIT        
P00773        END-IF                                                    
P00773     ELSE                                                         
P00773        IF PARM-REVIEW-EXEMPT-FL = 'Y'                            
P00773           MOVE 'I'                   TO WS-REVIEW-EXEMPT-CHG     
P00773           MOVE 'A'                   TO YP-STATUS-CD             
P00773           MOVE 'YES'                 TO YP-ATTRIBUTE-VALUE-CD    
P00773           MOVE +13               TO YP-ATTRIBUTE-VALUE-TX-LEN    
P00773           MOVE 'REVIEW EXEMPT'   TO YP-ATTRIBUTE-VALUE-TX-TEXT   
P00773           PERFORM 7600-INSERT-ATTRB-CD  THRU 7600-EXIT           
P00773        END-IF                                                    
P00773     END-IF.                                                      
P00773*                                                                         
P00773 2970-EXIT.                                                       
P00773     EXIT.                                                        
P00773*                                                                         
                                                                        
      *****************************************************************         
      * 5000-MAINTENANCE-HISTORY.                                     *         
      *     CALLS       7300-GET-TIMESTAMP                            * 06640011
      *                                                               *         
      *     CALLED FROM 2800-TRANSFER-HISTORY                         * 06680000
      *                                                               *         
      *     PREPARE MAINTENANCE JOURNAL                               *         
      *****************************************************************         
                                                                        
       5000-MAINTENANCE-HISTORY.                                        
                                                                        
           MOVE '5000'                 TO ACTIVE-PARAGRAPH.             
                                                                        
           PERFORM 7300-GET-TIMESTAMP      THRU 7300-EXIT.              
                                                                        
           MOVE WS-F                   TO MH-CODE-TRAN-TYPE.            
           MOVE PARM-RESP-AREA-ID      TO MH-RESP-AREA-ID.              
           MOVE WS-ACCOUNT-NO-CHK      TO MH-ACCOUNT-NO.                
           MOVE ZEROS                  TO MH-CUSTOMER-NO.               
           MOVE ZEROS                  TO MH-PREMISE-NO.                
           MOVE PARM-USER-ID           TO MH-USER-ID.                   
           MOVE 'PANEL490'             TO MH-APPL-PROGRAM-ID.           
           MOVE PARM-TRAN-COMMENT-LEN  TO MH-TRAN-COMMENT-LEN.          
           MOVE PARM-TRAN-COMMENT      TO MH-TRAN-COMMENT-TEXT.         
           MOVE +1                     TO WS-TRAN-APPL-NO.              
                                                                        
       5000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *****************************************************************         
      * 5010-MNT-HST-DETAIL.                                          *         
      *     CALLS       6530-LOAD-MNT-TRANS-HIST                      * 06640011
      *                                                               *         
      *     CALLED FROM 2800-TRANSFER-HISTORY                         * 06680000
      *****************************************************************         
                                                                        
       5010-MNT-HST-DETAIL.                                             
                                                                        
           MOVE '5010'                       TO ACTIVE-PARAGRAPH.       
                                                                        
           MOVE MH-TRANS-HIST-SEQ-NO         TO MI-TRANS-HIST-SEQ-NO.   
           MOVE WS-TRAN-APPL-NO              TO MI-TRAN-APPL-NO.        
           PERFORM 6530-LOAD-MNT-TRANS-HIST  THRU 6530-EXIT.            
           ADD 1                             TO WS-TRAN-APPL-NO.        
                                                                        
       5010-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 6530-LOAD-MNT-TRANS-HIST                                       *        
      *                                                                *        
      *     CALLED FROM 5010-MNT-HST-DETAIL                            *        
      *                                                                *        
      *     JOURNALING ROUTINE                                         *        
      ******************************************************************        
           EXEC SQL                                                             
              INCLUDE CPD00067                                                  
           END-EXEC.                                                            
                                                                        
      ******************************************************************        
      * 7000-SELECT-BILL-PULL-CODES                                    *        
      *     CALLS    9000-SEND-ERROR-RESULT                            *        
      *              9900-SQL-ERROR-ROUTINE                            *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      ******************************************************************        
                                                                        
       7000-SELECT-BILL-PULL-CODES.                                     
                                                                        
           EXEC SQL                                                     
            SELECT CODE_PERM_BILL,                                      
                   CODE_TEMP_BILL                                       
T20583            ,CREDIT_GROUP                                         
T20583            ,BILL_CYCLE                                           
T20583            ,REV_MTH_LST_NRML                                     
C29533            ,NO_BILL_COPIES                                       
C29533            ,COMPANY_NO                                           
C30169            ,LOCAL_OFFICE                                         
C30169            ,CODE_ACCT_STAT                                       
A02486            ,ADDRESS_ID                                           
A02486            ,ADDRESS_FORMAT                                       
             INTO :AT-CODE-PERM-BILL,                                   
                  :AT-CODE-TEMP-BILL                                    
T20583           ,:AT-CREDIT-GROUP                                      
T20583           ,:AT-BILL-CYCLE                                        
T20583           ,:AT-REV-MTH-LST-NRML                                  
C29533           ,:AT-NO-BILL-COPIES                                    
C29533           ,:AT-COMPANY-NO                                        
C30169           ,:AT-LOCAL-OFFICE                                      
C30169           ,:AT-CODE-ACCT-STAT                                    
A02486           ,:AT-ADDRESS-ID                                        
A02486           ,:AT-ADDRESS-FORMAT                                    
             FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                             
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                   
T35434                                                           
                                                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT CODE_PERM_BILL,                                              
MFA-TR*            CODE_TEMP_BILL                                               
MFA-TR*           ,CREDIT_GROUP                                                 
MFA-TR*           ,BILL_CYCLE                                                   
MFA-TR*           ,REV_MTH_LST_NRML                                             
MFA-TR*           ,NO_BILL_COPIES                                               
MFA-TR*           ,COMPANY_NO                                                   
MFA-TR*           ,LOCAL_OFFICE                                                 
MFA-TR*           ,CODE_ACCT_STAT                                               
MFA-TR*           ,ADDRESS_ID                                                   
MFA-TR*           ,ADDRESS_FORMAT                                               
MFA-TR*      INTO :AT-CODE-PERM-BILL,                                           
MFA-TR*           :AT-CODE-TEMP-BILL                                            
MFA-TR*          ,:AT-CREDIT-GROUP                                              
MFA-TR*          ,:AT-BILL-CYCLE                                                
MFA-TR*          ,:AT-REV-MTH-LST-NRML                                          
MFA-TR*          ,:AT-NO-BILL-COPIES                                            
MFA-TR*          ,:AT-COMPANY-NO                                                
MFA-TR*          ,:AT-LOCAL-OFFICE                                              
MFA-TR*          ,:AT-CODE-ACCT-STAT                                            
MFA-TR*          ,:AT-ADDRESS-ID                                                
MFA-TR*          ,:AT-ADDRESS-FORMAT                                            
MFA-TR*      FROM CSS_ACCOUNT                                                   
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7000                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               MOVE AT-CODE-PERM-BILL TO WS-PRV-CODE-PERM-BILL          
               MOVE AT-CODE-TEMP-BILL TO WS-PRV-CODE-TEMP-BILL          
           ELSE                                                         
              MOVE PROGRAM-NAME        TO ABEND-PROGRAM                 
              MOVE '7000'              TO ACTIVE-PARAGRAPH              
              MOVE 'SELECT'            TO ABEND-FUNCTION                
              MOVE SPACES              TO ABEND-SQL-PREDICATES          
                                          ABEND-TABLES                  
              MOVE 'CSS_ACCOUNT'       TO TABLE-1                       
CBSI          MOVE 'ACCOUNT_NO'        TO TABLE-ELEMENT-1               
CBSI          MOVE WS-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1             
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
T15268* 7100-SELECT-LOCK-BOX-NO                                        *        
T15268*     CALLS    9000-SEND-ERROR-RESULT                            *        
T15268*              9900-SQL-ERROR-ROUTINE                            *        
T15268*                                                                *        
T15268*     CALLED FROM 2300-BUILD-RESULT                              *        
T15268******************************************************************        
                                                                        
T15268 7100-SELECT-LOCK-BOX-NO.                                         
                                                                        
T15268     EXEC SQL                                                     
T15268      SELECT LOCK_BOX_NO                                          
T15268       INTO :TA-LOCK-BOX-NO                                       
T15268       FROM CSS_ACCT_MISC_INFO WITH(READUNCOMMITTED)                      
T15268          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                   
T35434                                                           
                                                            
T15268     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT LOCK_BOX_NO                                                  
MFA-TR*      INTO :TA-LOCK-BOX-NO                                               
MFA-TR*      FROM CSS_ACCT_MISC_INFO                                            
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                           
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15268     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T15268     EVALUATE WS-ACTIVE-RETURN-CODE                               
T15268         WHEN SUCCESSFUL-CALL                                     
T15268             MOVE TA-LOCK-BOX-NO  TO WS-PRV-LOCK-BOX-NO           
T15268         WHEN NOT-FOUND                                           
T15268             IF PARM-LOCK-BOX-NO = SPACES                         
T15268                 MOVE SPACES TO WS-PRV-LOCK-BOX-NO                
T15268             ELSE                                                 
T15268                 MOVE '*NEW*  ' TO WS-PRV-LOCK-BOX-NO             
T15268             END-IF                                               
T15268         WHEN OTHER                                               
T15268             MOVE PROGRAM-NAME        TO ABEND-PROGRAM            
T15268             MOVE '7100'              TO ACTIVE-PARAGRAPH         
T15268             MOVE 'SELECT'            TO ABEND-FUNCTION           
T15268             MOVE SPACES              TO ABEND-SQL-PREDICATES     
T15268                                         ABEND-TABLES             
T15268             MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                
CBSI               MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1        
CBSI               MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1      
T15268             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
T15268             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
T15268     END-EVALUATE.                                                
                                                                        
T15268 7100-EXIT.                                                       
T15268     EXIT.                                                        
                                                                        
      ******************************************************************        
PCR671* 7150-CHECK-CODE-ACCT-BILL                                      *        
PCR671*     CALLED FROM   2300-BUILD-RESULT                            *        
PCR671*                                                                *        
PCR671******************************************************************        
PCR671                                                                  
PCR671 7150-CHECK-CODE-ACCT-BILL.                                       
PCR671                                                                  
PCR671     EXEC SQL                                                     
PCR671         SELECT CODE_ACCT_BILLED                                  
PCR671           INTO :AT-CODE-ACCT-BILLED                              
PCR671           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
PCR671          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                   
T35434                                                           
                                                            
PCR671     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT CODE_ACCT_BILLED                                          
MFA-TR*          INTO :AT-CODE-ACCT-BILLED                                      
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                           
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7150                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR671                                                                  
PCR671     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
PCR671                                                                  
PCR671     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR671         MOVE AT-CODE-ACCT-BILLED  TO WS-PRV-CODE-ACCT-BILL       
PCR671     ELSE                                                         
T33620         MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
PCR671         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR671         MOVE '7150'                    TO ACTIVE-PARAGRAPH       
PCR671         MOVE 'SELECT'                  TO ABEND-FUNCTION         
PCR671         MOVE 'CSS_ACCOUNT'             TO TABLE-1                
PCR671         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
PCR671         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR671         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR671         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR671     END-IF.                                                      
PCR671                                                                  
PCR671     IF AT-CODE-ACCT-BILLED = WS-HOLD                             
PCR671         MOVE WS-YES                    TO ACCT-ON-HOLD-SW        
PCR671     END-IF.                                                      
PCR671                                                                  
PCR671 7150-EXIT.                                                       
                                                                        
PCR671******************************************************************        
PCR671* 7175-REMOVE-FROM-OFF-CYCLE                                     *        
PCR671*     CALLED FROM   8000-UPDATE-ACCOUNT                          *        
PCR671*                                                                *        
PCR671******************************************************************        
PCR671                                                                  
PCR671 7175-REMOVE-FROM-OFF-CYCLE.                                      
PCR671                                                                  
PCR671     EXEC SQL                                                     
PCR671         DELETE FROM CSS_OFF_CYCL_ACCT                            
PCR671          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK AND               
PCR671                CODE_BILL_OFF_CYCL = :WS-SPACE                    
                                                            
PCR671     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_OFF_CYCL_ACCT                                    
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK AND                       
MFA-TR*               CODE_BILL_OFF_CYCL = :WS-SPACE                            
MFA-TR*      QUERYNO 7175                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR671                                                                  
PCR671     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
PCR671                                                                  
PCR671     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
PCR671         NEXT SENTENCE                                            
PCR671     ELSE                                                         
T33620         MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
PCR671         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
PCR671         MOVE '7175'                    TO ACTIVE-PARAGRAPH       
PCR671         MOVE 'DELETE'                  TO ABEND-FUNCTION         
PCR671         MOVE 'CSS_OFF_CYCL_ACCT'       TO TABLE-1                
PCR671         MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
PCR671         MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
PCR671         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
PCR671         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
PCR671     END-IF.                                                      
PCR671                                                                  
PCR671 7175-EXIT.                                                       
                                                                        
      ******************************************************************        
      * 7300-GET-TIMESTAMP      JOURNALING ROUTINE                     *        
      *                                                                *        
      *     CALLED FROM 5000-MAINTENANCE-HISTORY                       *        
      ******************************************************************        
                                                                        
       7300-GET-TIMESTAMP.                                              
                                                                        
           EXEC SQL                                                     
T35434       SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), DATEADD( SECOND, 10, 
           CIS.CURRENT$TIMESTAMP() ), 121), ' ', '-'), ':', '.'),
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :MH-TRANS-HIST-SEQ-NO,
              :MH-DATE-TRANS                          
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ044
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SET :MH-TRANS-HIST-SEQ-NO = CURRENT TIMESTAMP + 10 SECONDS         
MFA-TR*         ,:MH-DATE-TRANS = CURRENT DATE                                  
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
T35434        MOVE 'SET'                 TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
T20583* 7310-GET-MAX-REV-MONTH                                         *        
T20583******************************************************************        
T20583                                                                  
T20583 7310-GET-COMMON-DATE.                                            
T20583                                                                  
T20583     EXEC SQL                                                     
T20583       SELECT CIS.SUBSTR3(PARM_DATA,1,10)                              
T20583         INTO :WS-COMMON-DATE                                     
T20583         FROM CSS_JOB_PARM WITH(READUNCOMMITTED)                          
T20583        WHERE PROGRAM_NAME = 'COMMONDATE'                         
T20583          AND COMPANY_NO   = '01'                                 
T20583          AND CMND_CODE    = 'CA00'                               
T20583          AND STATUS       = 'A'                                  
T35434                                                           
                                                            
T20583     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT SUBSTR(PARM_DATA,1,10)                                      
MFA-TR*        INTO :WS-COMMON-DATE                                             
MFA-TR*        FROM CSS_JOB_PARM                                                
MFA-TR*       WHERE PROGRAM_NAME = 'COMMONDATE'                                 
MFA-TR*         AND COMPANY_NO   = '01'                                         
MFA-TR*         AND CMND_CODE    = 'CA00'                                       
MFA-TR*         AND STATUS       = 'A'                                          
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7310                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583                                                                  
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583                                                                  
T20583     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7310'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'SELECT'              TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_JOB_PARM'        TO TABLE-1                     
T20583        MOVE 'PROGRAM_NAME'        TO TABLE-ELEMENT-1             
T20583        MOVE 'CMND_CODE'           TO TABLE-ELEMENT-2             
T20583        MOVE 'COMMONDATE'          TO HOSTVAR-ELEMENT-1           
T20583        MOVE 'CA00'                TO HOSTVAR-ELEMENT-2           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583                                                                  
T20583 7310-EXIT.                                                       
T20583     EXIT.                                                        
T20583                                                                  
T20583******************************************************************        
T20583* 7315-GET-MAX-REV-MONTH                                         *        
T20583******************************************************************        
T20583 7315-GET-MAX-REV-MONTH.                                          
T20583                                                                  
T20583     EXEC SQL                                                     
T20583        SELECT MAX(REVENUE_MONTH)                                 
T20583          INTO :BN-REVENUE-MONTH                                  
T20583          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
T20583         WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                        :WS-COMMON-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-COMMON-DATE
              ) <> 0) OR (LEN(:WS-COMMON-DATE) <> 10), CIS.CHAR2DATE(
                                                        :WS-COMMON-DATE
              ), CONVERT(DATE, :WS-COMMON-DATE) )                     
T35434                                                           
                                                            
T20583     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :WS-COMMON-DATE                             
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7315                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583                                                                  
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583                                                                  
T20583     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7315'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'SELECT'              TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
T20583        MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-1             
T20583        MOVE WS-COMMON-DATE        TO HOSTVAR-ELEMENT-1           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583                                                                  
T20583 7315-EXIT.                                                       
T20583     EXIT.                                                        
T20583******************************************************************        
T20583* 7320-GET-BILL-WINDOW-DT                                        *        
T20583******************************************************************        
T20583                                                                  
T20583 7320-GET-BILL-WINDOW-DT.                                         
T20583                                                                  
T20583     EXEC SQL                                                     
T20583        SELECT MAX(DATE_EXTRACT)                                  
T20583              ,MIN(DATE_EXTRACT)                                  
T20583          INTO :WS-BN-CLOSE-DATE                                  
T20583              ,:WS-BN-OPEN-DATE                                   
T20583          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
T20583         WHERE BILL_CYCLE    = :BN-BILL-CYCLE                     
T20583           AND REVENUE_MONTH = :BN-REVENUE-MONTH                  
T35434                                                           
                                                            
T20583     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(DATE_EXTRACT)                                          
MFA-TR*             ,MIN(DATE_EXTRACT)                                          
MFA-TR*         INTO :WS-BN-CLOSE-DATE                                          
MFA-TR*             ,:WS-BN-OPEN-DATE                                           
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE BILL_CYCLE    = :BN-BILL-CYCLE                             
MFA-TR*          AND REVENUE_MONTH = :BN-REVENUE-MONTH                          
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7320                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583*                                                                         
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583*                                                                         
T20583     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7320'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'SELECT'              TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
T20583        MOVE 'BILL_CYCLE'          TO TABLE-ELEMENT-1             
T20583        MOVE 'REVENUE_MONTH'       TO TABLE-ELEMENT-2             
T20583        MOVE BN-BILL-CYCLE         TO HOSTVAR-ELEMENT-1           
T20583        MOVE BN-REVENUE-MONTH      TO HOSTVAR-ELEMENT-2           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583                                                                  
T20583 7320-EXIT.                                                       
T20583     EXIT.                                                        
T20583                                                                  
T20583                                                                  
T20583******************************************************************        
T20583*                                                                *        
T20583*     7350-OPEN-UTIL-ENVRNMT                                     *        
T20583*                                                                *        
T20583******************************************************************        
T20583 7350-OPEN-UTIL-ENVRNMT.                                          
T20583*                                                                         
T20583     EXEC SQL                                                     
T20583         OPEN UTIL_ENVRNMT                                        
T20583     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583*                                                                         
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583*                                                                         
T20583     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7350'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'OPEN'                TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
T20583        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T20583        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583*                                                                         
T20583 7350-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
T20583******************************************************************        
T20583*                                                                *        
T20583*     7360-FETCH-UTIL-ENVRNMT                                    *        
T20583*                                                                *        
T20583******************************************************************        
T20583 7360-FETCH-UTIL-ENVRNMT.                                         
T20583*                                                                         
T20583     EXEC SQL                                                     
T20583          FETCH UTIL_ENVRNMT                                      
T20583           INTO :UT-ACCOUNT-NO,                                   
T20583                :UT-CODE-UTIL-TYPE,                               
T20583                :UT-IC-NO,                                        
T20583                :UT-READ-CYCLE,                                   
T20583                :UT-READ-ROUTE                                    
T20583     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583*                                                                         
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583*                                                                         
T20583     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7360'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'FETCH'               TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
T20583        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T20583        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583*                                                                         
T20583 7360-EXIT.                                                       
T20583     EXIT.                                                        
T20583******************************************************************        
T20583*                                                                *        
T20583*     7370-CLOSE-UTIL-ENVRNMT                                    *        
T20583*                                                                *        
T20583******************************************************************        
T20583 7370-CLOSE-UTIL-ENVRNMT.                                         
T20583     EXEC SQL                                                     
T20583         CLOSE UTIL_ENVRNMT                                       
T20583     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583*                                                                         
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583*                                                                         
T20583     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7370'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'CLOSE'               TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_UTIL_ENVRNMT'    TO TABLE-1                     
T20583        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T20583        MOVE UT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583*                                                                         
T20583 7370-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
T20583 7400-SELECT-CNT-MTRD-ENVRNMT.                                    
T20583*                                                                         
T20583     EXEC SQL                                                     
T20583        SELECT COUNT(*)                                           
T20583          INTO :WS-MN-AWAITING-RD-COUNT                           
T20583          FROM CSS_MTRD_ENVRNMT WITH(READUNCOMMITTED)                     
T20583         WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO               
T20583           AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE           
T20583           AND IC_NO               = :MN-IC-NO                    
TP8336           AND (CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ       
T20583            OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ)           
T35434                                                           
                                                            
T20583     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT COUNT(*)                                                   
MFA-TR*         INTO :WS-MN-AWAITING-RD-COUNT                                   
MFA-TR*         FROM CSS_MTRD_ENVRNMT                                           
MFA-TR*        WHERE ACCOUNT_NO          = :MN-ACCOUNT-NO                       
MFA-TR*          AND CODE_UTIL_TYPE      = :MN-CODE-UTIL-TYPE                   
MFA-TR*          AND IC_NO               = :MN-IC-NO                            
MFA-TR*          AND (CODE_CRNT_REG_READ = :MN-CODE-CRNT-REG-READ               
MFA-TR*           OR  CODE_CRNT_REG_READ = :WS-VERIFIED-READ)                   
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7400                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583*                                                                         
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583*                                                                         
T20583     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7400'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'SELECT'              TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_MTRD_ENVRNMT'    TO TABLE-1                     
T20583        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T20583        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
T20583        MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
T20583        MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T20583        MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
T20583        MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583*                                                                         
T20583 7400-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
T20583 7410-SELECT-CNT-REGISTER-READ.                                   
T20583*                                                                         
T20583     EXEC SQL                                                     
T20583         SELECT COUNT(*)                                          
T20583           INTO :WS-RG-AWAITING-RD-COUNT                          
T20583           FROM CSS_REGISTER_READ WITH(READUNCOMMITTED)                   
T20583          WHERE ACCOUNT_NO             = :RG-ACCOUNT-NO           
T20583            AND CODE_UTIL_TYPE         = :RG-CODE-UTIL-TYPE       
T20583            AND IC_NO                  = :RG-IC-NO                
T20583            AND (CODE_CRNT_REG_READ    = :RG-CODE-CRNT-REG-READ   
T20583                 OR CODE_CRNT_REG_READ = :WS-VERIFIED-READ)       
T35434                                                           
                                                            
T20583     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT COUNT(*)                                                  
MFA-TR*          INTO :WS-RG-AWAITING-RD-COUNT                                  
MFA-TR*          FROM CSS_REGISTER_READ                                         
MFA-TR*         WHERE ACCOUNT_NO             = :RG-ACCOUNT-NO                   
MFA-TR*           AND CODE_UTIL_TYPE         = :RG-CODE-UTIL-TYPE               
MFA-TR*           AND IC_NO                  = :RG-IC-NO                        
MFA-TR*           AND (CODE_CRNT_REG_READ    = :RG-CODE-CRNT-REG-READ           
MFA-TR*                OR CODE_CRNT_REG_READ = :WS-VERIFIED-READ)               
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7410                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T20583*                                                                         
T20583     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
T20583*                                                                         
T20583     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
T20583        NEXT SENTENCE                                             
T20583     ELSE                                                         
T20583        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
T20583        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T20583        MOVE '7410'                TO ACTIVE-PARAGRAPH            
T20583        MOVE 'SELECT'              TO ABEND-FUNCTION              
T20583        MOVE SPACES                TO ABEND-SQL-PREDICATES        
T20583                                      ABEND-TABLES                
T20583        MOVE 'CSS_REGISTER_READ'   TO TABLE-1                     
T20583        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T20583        MOVE 'CODE_UTIL_TYPE'      TO TABLE-ELEMENT-2             
T20583        MOVE 'IC_NO'               TO TABLE-ELEMENT-3             
T20583        MOVE MN-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T20583        MOVE MN-CODE-UTIL-TYPE     TO HOSTVAR-ELEMENT-2           
T20583        MOVE MN-IC-NO              TO HOSTVAR-ELEMENT-3           
T20583        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T20583        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T20583     END-IF.                                                      
T20583*                                                                         
T20583 7410-EXIT.                                                       
T20583     EXIT.                                                        
T20583*                                                                         
C26296******************************************************************        
C26296**  7500-SELECT-ACCT-ATTRIBUTE                                  **        
C26296**  SELECT DATA FROM CSS_ACCT_ATTRIBUTE TABLE                   **        
C26296**                                                              **        
C26296******************************************************************        
C26296*                                                                         
C26296 7500-SELECT-ACCT-ATTRIBUTE.                                      
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296         SELECT ATTRIBUTE_VALUE_CD                                
C26296               ,ATTRIBUTE_VALUE_DT                                
C26296               ,ATTRIBUTE_VALUE_TX                                
C26296           INTO :YP-ATTRIBUTE-VALUE-CD                            
C26296               ,:YP-ATTRIBUTE-VALUE-DT                            
C26296               ,:YP-ATTRIBUTE-VALUE-TX                            
C26296           FROM CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                  
C26296          WHERE ACCOUNT_NO             = :YP-ACCOUNT-NO           
C26296            AND ATTRIBUTE_DESC         = :YP-ATTRIBUTE-DESC       
T35434                                                           
                                                            
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,ATTRIBUTE_VALUE_TX                                        
MFA-TR*          INTO :YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-DT                                    
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX                                    
MFA-TR*          FROM CSS_ACCT_ATTRIBUTE                                        
MFA-TR*         WHERE ACCOUNT_NO             = :YP-ACCOUNT-NO                   
MFA-TR*           AND ATTRIBUTE_DESC         = :YP-ATTRIBUTE-DESC               
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C26296*                                                                         
C26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
C26296        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C26296           MOVE SPACES             TO YP-ATTRIBUTE-VALUE-CD       
C26296        END-IF                                                    
C26296     ELSE                                                         
C26296        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C26296        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C26296        MOVE '7500'                TO ACTIVE-PARAGRAPH            
C26296        MOVE 'SELECT'              TO ABEND-FUNCTION              
C26296        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C26296        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C26296        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C26296        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C26296        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C26296     END-IF.                                                      
C26296*                                                                         
C26296 7500-EXIT.                                                       
C26296     EXIT.                                                        
                                                                        
A02486 7510-CHECK-ADDRESS.                                              
A02486                                                                  
A02486     EXEC SQL                                                     
A02486         SELECT ADDR_COUNTRY                                      
A02486           INTO :DZ-ADDR-COUNTRY                                  
A02486           FROM CSS_ADDR_FREEFORM WITH(READUNCOMMITTED)                   
A02486          WHERE ADDRESS_ID = :AT-ADDRESS-ID                       
A02486            AND ADDR_COUNTRY > ' '                                
A02486            AND ADDR_COUNTRY <> 'USA'                             
A02486            AND ADDR_COUNTRY <> 'US'                              
A02486            AND ADDR_COUNTRY <> 'UNITED STATES'                   
A02486                                                           
A02486                                                      
A02486     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ053
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT ADDR_COUNTRY                                              
MFA-TR*          INTO :DZ-ADDR-COUNTRY                                          
MFA-TR*          FROM CSS_ADDR_FREEFORM                                         
MFA-TR*         WHERE ADDRESS_ID = :AT-ADDRESS-ID                               
MFA-TR*           AND ADDR_COUNTRY > ' '                                        
MFA-TR*           AND ADDR_COUNTRY = 'USA'                                     
MFA-TR*           AND ADDR_COUNTRY = 'US'                                      
MFA-TR*           AND ADDR_COUNTRY = 'UNITED STATES'                           
MFA-TR*         WITH UR                                                         
MFA-TR*         QUERYNO 7510                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A02486                                                                  
A02486     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
A02486                                                                  
A02486     EVALUATE WS-ACTIVE-RETURN-CODE                               
A02486         WHEN SUCCESSFUL-CALL                                     
A02486             MOVE 'Y' TO WS-INTER-ADD                             
A02486         WHEN NOT-FOUND                                           
A02486             MOVE 'N' TO WS-INTER-ADD                             
A02486         WHEN OTHER                                               
A02486             MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
A02486             MOVE PROGRAM-NAME     TO ABEND-PROGRAM               
A02486             MOVE '7510'           TO ACTIVE-PARAGRAPH            
A02486             MOVE 'SELECT'         TO ABEND-FUNCTION              
A02486             MOVE 'CSS_ADDR_FREEFORM' TO TABLE-1                  
A02486             MOVE 'ADDRESS_ID'     TO TABLE-ELEMENT-1             
A02486             MOVE AT-ADDRESS-ID    TO HOSTVAR-ELEMENT-1           
A02486             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
A02486             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
A02486     END-EVALUATE.                                                
A02486                                                                  
A02486 7510-EXIT.                                                       
A02486     EXIT.                                                        
                                                                        
C26296******************************************************************        
C26296**  7600-INSERT-ATTRB-CD                                        **        
C26296**  INSERT A ROW IN  CSS_ACCT_ATTRIBUTE TABLE                   **        
C26296**                                                              **        
C26296******************************************************************        
C26296*                                                                         
C26296 7600-INSERT-ATTRB-CD.                                            
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296         INSERT INTO CSS_ACCT_ATTRIBUTE                           
C26296               (ACCOUNT_NO                                        
C26296               ,ATTRIBUTE_DESC                                    
C26296               ,ATTRIBUTE_VALUE_CD                                
C26296               ,ATTRIBUTE_VALUE_DT                                
C26296               ,ATTRIBUTE_VALUE_TX                                
P00471               ,STATUS_CD)                                        
C26296         VALUES                                                   
C26296               (:YP-ACCOUNT-NO                                    
C26296               ,:YP-ATTRIBUTE-DESC                                
C26296               ,:YP-ATTRIBUTE-VALUE-CD                            
C26296               ,CAST(SYSDATETIMEOFFSET() AS DATE)                         
C26296               ,:YP-ATTRIBUTE-VALUE-TX                            
P00471               ,:YP-STATUS-CD)                                    
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_ACCT_ATTRIBUTE                                   
MFA-TR*              (ACCOUNT_NO                                                
MFA-TR*              ,ATTRIBUTE_DESC                                            
MFA-TR*              ,ATTRIBUTE_VALUE_CD                                        
MFA-TR*              ,ATTRIBUTE_VALUE_DT                                        
MFA-TR*              ,ATTRIBUTE_VALUE_TX                                        
MFA-TR*              ,STATUS_CD)                                                
MFA-TR*        VALUES                                                           
MFA-TR*              (:YP-ACCOUNT-NO                                            
MFA-TR*              ,:YP-ATTRIBUTE-DESC                                        
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-CD                                    
MFA-TR*              ,CURRENT DATE                                              
MFA-TR*              ,:YP-ATTRIBUTE-VALUE-TX                                    
MFA-TR*              ,:YP-STATUS-CD)                                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C26296*                                                                         
C26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C26296        NEXT SENTENCE                                             
C26296     ELSE                                                         
C26296        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C26296        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C26296        MOVE '7600'                TO ACTIVE-PARAGRAPH            
C26296        MOVE 'INSERT'              TO ABEND-FUNCTION              
C26296        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C26296        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C26296        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C26296        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C26296        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C26296     END-IF.                                                      
C26296*                                                                         
C26296 7600-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296**  7700-UPDATE-ATTRB-CD                                        **        
C26296**  UPDATE CSS_ACCT_ATTRIBUTE                                   **        
C26296**                                                              **        
C26296******************************************************************        
C26296*                                                                         
C26296 7700-UPDATE-ATTRB-CD.                                            
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296         UPDATE CSS_ACCT_ATTRIBUTE                                
C26296            SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD       
C26296               ,ATTRIBUTE_VALUE_DT = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                 
C26296               ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX       
C26296          WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
C26296            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
                                                            
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCT_ATTRIBUTE                                        
MFA-TR*           SET ATTRIBUTE_VALUE_CD = :YP-ATTRIBUTE-VALUE-CD               
MFA-TR*              ,ATTRIBUTE_VALUE_DT = CURRENT DATE                         
MFA-TR*              ,ATTRIBUTE_VALUE_TX = :YP-ATTRIBUTE-VALUE-TX               
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*      QUERYNO 7700                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C26296*                                                                         
C26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C26296        NEXT SENTENCE                                             
C26296     ELSE                                                         
C26296        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C26296        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C26296        MOVE '7700'                TO ACTIVE-PARAGRAPH            
C26296        MOVE 'UPDATE'              TO ABEND-FUNCTION              
C26296        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C26296        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C26296        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C26296        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C26296        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C26296     END-IF.                                                      
C26296*                                                                         
C26296 7700-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C26296******************************************************************        
C26296**  7800-DELETE-ATTRB-CD                                        **        
C26296**  DELETE ROW IN CSS_ACCT_ATTRIBUTE                            **        
C26296**                                                              **        
C26296******************************************************************        
C26296*                                                                         
C26296 7800-DELETE-ATTRB-CD.                                            
C26296*                                                                         
C26296     EXEC SQL                                                     
C26296         DELETE FROM CSS_ACCT_ATTRIBUTE                           
C26296          WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
C26296            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
                                                            
C26296     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DELETE FROM CSS_ACCT_ATTRIBUTE                                   
MFA-TR*         WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                           
MFA-TR*           AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC                       
MFA-TR*      QUERYNO 7800                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296*                                                                         
C26296     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C26296*                                                                         
C26296     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C26296        NEXT SENTENCE                                             
C26296     ELSE                                                         
C26296        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C26296        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C26296        MOVE '7800'                TO ACTIVE-PARAGRAPH            
C26296        MOVE 'DELETE'              TO ABEND-FUNCTION              
C26296        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C26296        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C26296        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C26296        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C26296        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C26296     END-IF.                                                      
C26296*                                                                         
C26296 7800-EXIT.                                                       
C26296     EXIT.                                                        
C26296*                                                                         
C29533******************************************************************        
C29533**  7900-UPDATE-ACCT                                            **        
C29533**  UPDATE NO OF BILL COPIES FIELD ON CSS_ACCOUNT TABLE         **        
C29533**                                                              **        
C29533******************************************************************        
C29533*                                                                         
C29533 7900-UPDATE-ACCT.                                                
C29533*                                                                         
C29533     EXEC SQL                                                     
C29533         UPDATE CSS_ACCOUNT                                       
C29533            SET NO_BILL_COPIES = :AT-NO-BILL-COPIES               
C29533          WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                   
                                                            
C29533     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET NO_BILL_COPIES = :AT-NO-BILL-COPIES                       
MFA-TR*         WHERE ACCOUNT_NO     = :AT-ACCOUNT-NO                           
MFA-TR*      QUERYNO 7900                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533*                                                                         
C29533     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C29533*                                                                         
C29533     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE              
C29533        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29533        MOVE '7900'                TO ACTIVE-PARAGRAPH            
C29533        MOVE 'UPDATE'              TO ABEND-FUNCTION              
C29533        MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
C29533        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C29533        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C29533        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29533        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29533     END-IF.                                                      
C29533*                                                                         
C29533 7900-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C29533******************************************************************07969900
C29533* 7910-CHECK-ACCT-ATTRB                                          *07492029
C29533*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C29533*                 9900-SQL-ERROR-ROUTINE                         *07510000
C29533*                                                                *07520000
C29533*     CALLED FROM 2300-BUILD-RESULT                              *        
C29533*                                                                *        
C29533*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C29533******************************************************************07550000
C29533 7910-CHECK-ACCT-ATTRB.                                           
C29533                                                                  
C29533     EXEC SQL                                                     
C29533          SELECT 'Y'                                              
C29533            INTO :WS-NO-NOTIFICATION                              
C29533            FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                   
C29533                ,CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
C29533           WHERE YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
C29533             AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
C29533             AND WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
C29533             AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
C29533             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
T35434                                                           
                                                            
C29533     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-NO-NOTIFICATION                                      
MFA-TR*           FROM CSS_ATTRIBUTE WZ                                         
MFA-TR*               ,CSS_ACCT_ATTRIBUTE YP                                    
MFA-TR*          WHERE YP.ACCOUNT_NO        = :WS-ACCOUNT-NO                    
MFA-TR*            AND WZ.COMPANY_NO        = :AT-COMPANY-NO                    
MFA-TR*            AND WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC                 
MFA-TR*            AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC                
MFA-TR*            AND WZ.ATTRIBUTE_STAT_CD = 'A'                               
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7910                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29533        MOVE '7800'                TO ACTIVE-PARAGRAPH            
C29533        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29533        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C29533        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C29533        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C29533        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29533        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29533     END-IF.                                                      
C29533                                                                  
C29533 7910-EXIT.                                                       
C29533     EXIT.                                                        
C29533******************************************************************07969900
C29533* 7920-CHECK-ATTRB                                               *07492029
C29533*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C29533*                 9900-SQL-ERROR-ROUTINE                         *07510000
C29533*                                                                *07520000
C29533*     CALLED FROM 2300-BUILD-RESULT                              *        
C29533*                                                                *        
C29533*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C29533******************************************************************07550000
C29533 7920-CHECK-ATTRB.                                                
C29533                                                                  
C29533     EXEC SQL                                                     
C29533          SELECT 'Y'                                              
C29533            INTO :WS-PAPER-ONLY                                   
C29533            FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                   
C29533                ,CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
C29533           WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
C29533             AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
C29533             AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
C29533             AND YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
C29533             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
C29533             AND WZ.ATTRIBUTE_TYPE_TX = :WS-ATTRIBUTE-TYPE        
T35434                                                           
                                                            
C29533     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-PAPER-ONLY                                           
MFA-TR*           FROM CSS_ATTRIBUTE WZ                                         
MFA-TR*               ,CSS_ACCT_ATTRIBUTE YP                                    
MFA-TR*          WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC                 
MFA-TR*            AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC                
MFA-TR*            AND WZ.COMPANY_NO        = :AT-COMPANY-NO                    
MFA-TR*            AND YP.ACCOUNT_NO        = :WS-ACCOUNT-NO                    
MFA-TR*            AND WZ.ATTRIBUTE_STAT_CD = 'A'                               
MFA-TR*            AND WZ.ATTRIBUTE_TYPE_TX = :WS-ATTRIBUTE-TYPE                
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7920                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29533        MOVE '7920'                TO ACTIVE-PARAGRAPH            
C29533        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29533        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C29533        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C29533        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C29533        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29533        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29533     END-IF.                                                      
C29533                                                                  
C29533 7920-EXIT.                                                       
C29533     EXIT.                                                        
C31813******************************************************************07969900
C31813* 7930-CHECK-ARC-IND                                             *07492029
C31813*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C31813*                 9900-SQL-ERROR-ROUTINE                         *07510000
C31813*                                                                *07520000
C31813*     CALLED FROM 2300-BUILD-RESULT                              *        
C31813*                                                                *        
C31813*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C31813******************************************************************07550000
C31813 7930-CHECK-ARC-IND.                                              
C31813                                                                  
C31813     EXEC SQL                                                     
C31813          SELECT 'Y'                                              
C31813            INTO :WS-ARC-IND                                      
C31813            FROM CSS_ATTRIBUTE WZ WITH(READUNCOMMITTED)                   
C31813                ,CSS_ACCT_ATTRIBUTE YP WITH(READUNCOMMITTED)              
C31813           WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
C31813             AND YP.ATTRIBUTE_DESC    = 'CONVERT_CHK_ELEC'        
C31813             AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
C31813             AND YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
C31813             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
C31813             AND WZ.ATTRIBUTE_TYPE_TX = 'ARC'                     
T35434                                                           
                                                            
C31813     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-ARC-IND                                              
MFA-TR*           FROM CSS_ATTRIBUTE WZ                                         
MFA-TR*               ,CSS_ACCT_ATTRIBUTE YP                                    
MFA-TR*          WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC                 
MFA-TR*            AND YP.ATTRIBUTE_DESC    = 'CONVERT_CHK_ELEC'                
MFA-TR*            AND WZ.COMPANY_NO        = :AT-COMPANY-NO                    
MFA-TR*            AND YP.ACCOUNT_NO        = :WS-ACCOUNT-NO                    
MFA-TR*            AND WZ.ATTRIBUTE_STAT_CD = 'A'                               
MFA-TR*            AND WZ.ATTRIBUTE_TYPE_TX = 'ARC'                             
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7930                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31813                                                                  
C31813     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31813                                                                  
C31813     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C31813        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C31813           MOVE WS-N               TO WS-PREV-ARC-IND             
C31813        ELSE                                                      
C31813           MOVE WS-Y               TO WS-PREV-ARC-IND             
C31813        END-IF                                                    
C31813     ELSE                                                         
C31813        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C31813        MOVE '7930'                TO ACTIVE-PARAGRAPH            
C31813        MOVE 'SELECT'              TO ABEND-FUNCTION              
C31813        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C31813        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C31813        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C31813        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C31813        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C31813     END-IF.                                                      
C31813                                                                  
C31813 7930-EXIT.                                                       
C31813     EXIT.                                                        
C30169******************************************************************07969900
C30169* 7940-GET-CRXMT-DESC                                            *07492029
C30169*                                                                *07530029
C30169******************************************************************07550000
C30169 7940-GET-CRXMT-DESC.                                             
C30169                                                                  
C30169     EXEC SQL                                                     
C30169          SELECT FW_ATTR_VALUE_DESC                               
C30169            INTO :KV-FW-ATTR-VALUE-DESC                           
C30169            FROM CSS_FW_ATTRIB_DESC WITH(READUNCOMMITTED)                 
C30169           WHERE FW_ATTRIB_TYPE_CD    = :KV-FW-ATTRIB-TYPE-CD     
C30169             AND FW_ATTR_VALUE_CD     = :KV-FW-ATTR-VALUE-CD      
C30169                                                           
                                                            
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT FW_ATTR_VALUE_DESC                                       
MFA-TR*           INTO :KV-FW-ATTR-VALUE-DESC                                   
MFA-TR*           FROM CSS_FW_ATTRIB_DESC                                       
MFA-TR*          WHERE FW_ATTRIB_TYPE_CD    = :KV-FW-ATTRIB-TYPE-CD             
MFA-TR*            AND FW_ATTR_VALUE_CD     = :KV-FW-ATTR-VALUE-CD              
MFA-TR*          WITH UR                                                        
MFA-TR*      QUERYNO 7940                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C30169        MOVE '7940'                TO ACTIVE-PARAGRAPH            
C30169        MOVE 'SELECT'              TO ABEND-FUNCTION              
C30169        MOVE 'CSS_FW_ATTRIB_DESC'  TO TABLE-1                     
C30169        MOVE 'FW_ATTR_VALUE_CD'    TO TABLE-ELEMENT-1             
C30169        MOVE KV-FW-ATTR-VALUE-CD   TO HOSTVAR-ELEMENT-1           
C30169        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169                                                                  
C30169 7940-EXIT.                                                       
C30169     EXIT.                                                        
C30169******************************************************************07969900
C30169* 7950-GET-COLL-STATCD                                           *07492029
C30169*                                                                *07530029
C30169******************************************************************07550000
C30169 7950-GET-COLL-STATCD.                                            
C30169                                                                  
C30169     EXEC SQL                                                     
C30169          SELECT COLLECT_STATUS_CD                                
C30169            INTO :FW-COLLECT-STATUS-CD                            
C30169            FROM CSS_FINAL_WO WITH(READUNCOMMITTED)                       
C30169           WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                      
                                                                 
                                                            
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT COLLECT_STATUS_CD                                        
MFA-TR*           INTO :FW-COLLECT-STATUS-CD                                    
MFA-TR*           FROM CSS_FINAL_WO                                             
MFA-TR*          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                              
MFA-TR*       WITH UR                                                           
MFA-TR*      QUERYNO 7950                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C30169        MOVE '7950'                TO ACTIVE-PARAGRAPH            
C30169        MOVE 'SELECT'              TO ABEND-FUNCTION              
C30169        MOVE 'CSS_FINAL_WO'        TO TABLE-1                     
C30169        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C30169        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C30169        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169                                                                  
C30169 7950-EXIT.                                                       
C30169     EXIT.                                                        
C30169******************************************************************07969900
C30169* 7960-GET-WO-AMT                                                *07492029
C30169*                                                                *07530029
C30169******************************************************************07550000
C30169 7960-GET-WO-AMT.                                                 
C30169                                                                  
C30169     EXEC SQL                                                     
C30169          SELECT SUM(AMT_TRANS)                                   
C30169            INTO :CO-AMT-TRANS                                    
C30169            FROM CSS_CHRG_OFF WITH(READUNCOMMITTED)                       
C30169           WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                      
                                                                 
                                                            
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT SUM(AMT_TRANS)                                           
MFA-TR*           INTO :CO-AMT-TRANS                                            
MFA-TR*           FROM CSS_CHRG_OFF                                             
MFA-TR*          WHERE ACCOUNT_NO = :WS-ACCOUNT-NO                              
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7960                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C30169           MOVE ZEROS              TO CO-AMT-TRANS                
C30169        END-IF                                                    
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C30169        MOVE '7960'                TO ACTIVE-PARAGRAPH            
C30169        MOVE 'SELECT'              TO ABEND-FUNCTION              
C30169        MOVE 'CSS_CHRG_OFF'        TO TABLE-1                     
C30169        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C30169        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C30169        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169                                                                  
C30169 7960-EXIT.                                                       
C30169     EXIT.                                                        
C30169*****************************************************************         
C30169* 7970-SELECT-USER-NAME                                         *         
C30169*    -- THIS MODULE SELECTS THE USER NAME FOR PROCESSING        *         
C30169*****************************************************************         
C30169 7970-SELECT-USER-NAME.                                           
C30169                                                                  
C30169     MOVE '7970'              TO ACTIVE-PARAGRAPH.                
C30169                                                                  
C30169     EXEC SQL                                                     
C30169       SELECT CIS.CHAR2$CHAR (                                            
C30169              RTRIM(PF.LAST_NAME) + ', ' + RTRIM(PF.FIRST_NAME) + 
           ' ' + RTRIM(PF.MIDDLE_NAME)                               
C30169               , 37)                                              
C30169         INTO :WS-USER-NAME                                       
C30169         FROM CSS_USER_PROFILE PF WITH(READUNCOMMITTED)                   
C30169        WHERE USER_ID   =  :PF-USER-ID                            
                                                                 
                                                            
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ029
MFA-TR* MSQ031
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT CHAR (                                                      
MFA-TR*             RTRIM(PF.LAST_NAME)    || ', ' ||                           
MFA-TR*             RTRIM(PF.FIRST_NAME)   || ' '  ||                           
MFA-TR*             RTRIM(PF.MIDDLE_NAME)                                       
MFA-TR*              , 37)                                                      
MFA-TR*        INTO :WS-USER-NAME                                               
MFA-TR*        FROM CSS_USER_PROFILE PF                                         
MFA-TR*       WHERE USER_ID   =  :PF-USER-ID                                    
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7970                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
C30169       NEXT SENTENCE                                              
C30169     ELSE                                                         
C30169       IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                   
C30169         MOVE PARM-USER-ID         TO WS-USER-NAME                
C30169       ELSE                                                       
C30169         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
C30169         MOVE 'SELECT'             TO ABEND-FUNCTION              
C30169         MOVE SPACES               TO ABEND-SQL-PREDICATES        
C30169                                      ABEND-TABLES                
C30169         MOVE 'CSS_USER_PROFILE'   TO TABLE-1                     
C30169         MOVE 'USER_ID'            TO TABLE-ELEMENT-1             
C30169         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2             
C30169         MOVE PF-USER-ID           TO HOSTVAR-ELEMENT-1           
C30169         MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2           
C30169         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
C30169         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
C30169       END-IF                                                     
C30169     END-IF.                                                      
C30169                                                                  
C30169 7970-EXIT.                                                       
C30169     EXIT.                                                        
P00126*****************************************************************         
P00126* 7980-SELECT-CUST-STATS                                        *         
P00126*    -- THIS MODULE SELECTS EBILL REGISTER IND ON CUST STATS TAB*         
P00126*****************************************************************         
P00126 7980-SELECT-CUST-STATS.                                          
P00126                                                                  
P00126     MOVE '7980'              TO ACTIVE-PARAGRAPH.                
P00126                                                                  
P00126     EXEC SQL                                                     
P00126       SELECT EBILL_REGISTER_IND                                  
P00126         INTO :CE-EBILL-REGISTER-IND                              
P00126         FROM CSS_CUST_STATS WITH(READUNCOMMITTED)                        
P00126        WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                     
P00126          AND CUSTOMER_TYPE = 'C'                                 
                                                                 
                                                            
P00126     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT EBILL_REGISTER_IND                                          
MFA-TR*        INTO :CE-EBILL-REGISTER-IND                                      
MFA-TR*        FROM CSS_CUST_STATS                                              
MFA-TR*       WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                             
MFA-TR*         AND CUSTOMER_TYPE = 'C'                                         
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7980                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00126                                                                  
P00126     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00126                                                                  
P00126     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00126        IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                  
P00126           MOVE SPACES           TO CE-EBILL-REGISTER-IND         
P00126        END-IF                                                    
P00126     ELSE                                                         
P00126       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                 
P00126       MOVE 'SELECT'             TO ABEND-FUNCTION                
P00126       MOVE SPACES               TO ABEND-SQL-PREDICATES          
P00126                                    ABEND-TABLES                  
P00126       MOVE 'CSS_CUST_STATS'     TO TABLE-1                       
P00126       MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1               
P00126       MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2               
P00126       MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1             
P00126       MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2             
P00126       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
P00126       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
P00126     END-IF.                                                      
P00126                                                                  
P00126 7980-EXIT.                                                       
P00126     EXIT.                                                        
P00126*****************************************************************         
P00126* 7985-UPDATE-EBILL                                             *         
P00126*    -- THIS MODULE UPDATES EBILL REGISTER IND ON CUST STATS TAB*         
P00126*****************************************************************         
P00126 7985-UPDATE-EBILL.                                               
P00126                                                                  
P00126     MOVE '7985'              TO ACTIVE-PARAGRAPH.                
P00126                                                                  
P00126     EXEC SQL                                                     
P00126       UPDATE CSS_CUST_STATS                                      
P00126         SET EBILL_REGISTER_IND = :PARM-EBILL-REGISTER-IND        
P00126        WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                     
P00126          AND CUSTOMER_TYPE = 'C'                                 
P00126     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00126                                                                  
P00126     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00126                                                                  
P00126     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00126        NEXT SENTENCE                                             
P00126     ELSE                                                         
P00126       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                 
P00126       MOVE 'UPDATE'             TO ABEND-FUNCTION                
P00126       MOVE SPACES               TO ABEND-SQL-PREDICATES          
P00126                                    ABEND-TABLES                  
P00126       MOVE 'CSS_CUST_STATS'     TO TABLE-1                       
P00126       MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1               
P00126       MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2               
P00126       MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1             
P00126       MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2             
P00126       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
P00126       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
P00126     END-IF.                                                      
P00126                                                                  
P00126 7985-EXIT.                                                       
P00126     EXIT.                                                        
P00126*****************************************************************         
P00126* 7988-GET-NAME-ID                                              *         
P00126*    -- THIS MODULE GETS NAME ID FROM CSS_CUSTOMER              *         
P00126*****************************************************************         
P00126 7988-GET-NAME-ID.                                                
P00126                                                                  
P00126     MOVE '7988'              TO ACTIVE-PARAGRAPH.                
P00126                                                                  
P00126     EXEC SQL                                                     
P00126       SELECT NAME_ID                                             
P00126         INTO :CU-NAME-ID                                         
P00126         FROM CSS_CUSTOMER WITH(READUNCOMMITTED)                          
P00126        WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                     
                                                                 
                                                            
P00126     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      SELECT NAME_ID                                                     
MFA-TR*        INTO :CU-NAME-ID                                                 
MFA-TR*        FROM CSS_CUSTOMER                                                
MFA-TR*       WHERE CUSTOMER_NO   = :CE-CUSTOMER-NO                             
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7988                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00126                                                                  
P00126     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00126                                                                  
P00126     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00126        NEXT SENTENCE                                             
P00126     ELSE                                                         
P00126       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                 
P00126       MOVE 'SELECT'             TO ABEND-FUNCTION                
P00126       MOVE SPACES               TO ABEND-SQL-PREDICATES          
P00126                                    ABEND-TABLES                  
P00126       MOVE 'CSS_CUSTOMER'       TO TABLE-1                       
P00126       MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1               
P00126       MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2               
P00126       MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1             
P00126       MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2             
P00126       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
P00126       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
P00126     END-IF.                                                      
P00126                                                                  
P00126 7988-EXIT.                                                       
P00126     EXIT.                                                        
P00126*****************************************************************         
P00126* 7990-INSERT-EBILL                                             *         
P00126*    -- THIS MODULE INSERTS ROW INTO CSS_CUST_STATS TABLE       *         
P00126*****************************************************************         
P00126 7990-INSERT-EBILL.                                               
P00126                                                                  
P00126     MOVE '7990'              TO ACTIVE-PARAGRAPH.                
P00126                                                                  
P00126     EXEC SQL                                                     
P00126       INSERT INTO CSS_CUST_STATS                                 
P00126              (CUSTOMER_NO                                        
P00126              ,CUSTOMER_TYPE                                      
P00126              ,SSN                                                
P00126              ,NAME_ID                                            
P00126              ,CODE_STATE_ID                                      
P00126              ,DRIVERS_LICENSE_NO                                 
P00126              ,EMPLOYER                                           
P00126              ,EMPLOYED_DATE                                      
P00126              ,OCCUPATION                                         
P00126              ,OTHER_ID_TYPE                                      
P00126              ,OTHER_ID                                           
P00126              ,DRVR_LIC_ISS_DT                                    
P00126              ,DATE_OF_BIRTH                                      
P00126              ,EMPLOYEE_NBR                                       
P00126              ,INTR_CO_IND                                        
P00126              ,EBILL_REGISTER_IND                                 
P00126              ,PASSWORD_HINT_CD                                   
P00126              ,PASSWORD_TX                                        
P00126              ,REFUSED_SSN_FL                                     
P00126              ,LANGUAGE_PREF_CD                                   
P00126              ,DOB_VERIFIED_CD)                                   
P00126       VALUES (:CE-CUSTOMER-NO                                    
P00126              ,'C'                                                
P00126              ,''                                                 
P00126              ,:CU-NAME-ID                                        
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,NULL                                               
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,NULL                                               
P00126              ,NULL                                               
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,:PARM-EBILL-REGISTER-IND                           
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,''                                                 
P00126              ,'')                                                
P00126     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00126                                                                  
P00126     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00126                                                                  
P00126     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
P00126        NEXT SENTENCE                                             
P00126     ELSE                                                         
P00126       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                 
P00126       MOVE 'INSERT'             TO ABEND-FUNCTION                
P00126       MOVE SPACES               TO ABEND-SQL-PREDICATES          
P00126                                    ABEND-TABLES                  
P00126       MOVE 'CSS_CUST_STATS'     TO TABLE-1                       
P00126       MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1               
P00126       MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2               
P00126       MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1             
P00126       MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2             
P00126       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
P00126       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
P00126     END-IF.                                                      
P00126                                                                  
P00126 7990-EXIT.                                                       
P00126     EXIT.                                                        
P00126*****************************************************************         
P00126* 7995-DELETE-CUST-STATS                                        *         
P00126*    -- THIS MODULE DELETES ROW FROM CSS_CUST_STATS TABLE       *         
P00126*****************************************************************         
P00126 7995-DELETE-CUST-STATS.                                          
P00126                                                                  
P00126     MOVE '7995'              TO ACTIVE-PARAGRAPH.                
P00126                                                                  
P00126     EXEC SQL                                                     
P00126        DELETE FROM CSS_CUST_STATS                                
P00126         WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO              
P00126           AND CUSTOMER_TYPE      =  'C'                          
P00126           AND SSN                =  ' '                          
P00126           AND CODE_STATE_ID      =  ' '                          
P00126           AND DRIVERS_LICENSE_NO =  ' '                          
P00126           AND EMPLOYER           =  ' '                          
P00126           AND EMPLOYED_DATE      IS NULL                         
P00126           AND OCCUPATION         =  ' '                          
P00126           AND OTHER_ID_TYPE      =  ' '                          
P00126           AND OTHER_ID           =  ' '                          
P00126           AND DRVR_LIC_ISS_DT    IS NULL                         
P00126           AND DATE_OF_BIRTH      IS NULL                         
P00126           AND EMPLOYEE_NBR       =  ' '                          
P00126           AND INTR_CO_IND        =  ' '                          
P00126           AND EBILL_REGISTER_IND =  ''                           
                                                            
P00126     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*       DELETE FROM CSS_CUST_STATS                                        
MFA-TR*        WHERE CUSTOMER_NO        =  :CE-CUSTOMER-NO                      
MFA-TR*          AND CUSTOMER_TYPE      =  'C'                                  
MFA-TR*          AND SSN                =  ' '                                  
MFA-TR*          AND CODE_STATE_ID      =  ' '                                  
MFA-TR*          AND DRIVERS_LICENSE_NO =  ' '                                  
MFA-TR*          AND EMPLOYER           =  ' '                                  
MFA-TR*          AND EMPLOYED_DATE      IS NULL                                 
MFA-TR*          AND OCCUPATION         =  ' '                                  
MFA-TR*          AND OTHER_ID_TYPE      =  ' '                                  
MFA-TR*          AND OTHER_ID           =  ' '                                  
MFA-TR*          AND DRVR_LIC_ISS_DT    IS NULL                                 
MFA-TR*          AND DATE_OF_BIRTH      IS NULL                                 
MFA-TR*          AND EMPLOYEE_NBR       =  ' '                                  
MFA-TR*          AND INTR_CO_IND        =  ' '                                  
MFA-TR*          AND EBILL_REGISTER_IND =  ''                                   
MFA-TR*      QUERYNO 7995                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00126                                                                  
P00126     MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
P00126                                                                  
P00126     IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL OR NOT-FOUND  
P00126        NEXT SENTENCE                                             
P00126     ELSE                                                         
P00126       MOVE PROGRAM-NAME         TO ABEND-PROGRAM                 
P00126       MOVE 'DELETE'             TO ABEND-FUNCTION                
P00126       MOVE SPACES               TO ABEND-SQL-PREDICATES          
P00126                                    ABEND-TABLES                  
P00126       MOVE 'CSS_CUST_STATS'     TO TABLE-1                       
P00126       MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-1               
P00126       MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2               
P00126       MOVE CE-CUSTOMER-NO       TO HOSTVAR-ELEMENT-1             
P00126       MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-2             
P00126       PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT             
P00126       PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT             
P00126     END-IF.                                                      
P00126                                                                  
P00126 7995-EXIT.                                                       
P00126     EXIT.                                                        
P00150******************************************************************07969900
P00150* 7998-GET-PAPERLESS-IND                                         *07492029
P00150*     SELECT FROM CSS_EDI_ACCT_DEST                              *07530029
P00150******************************************************************07550000
P00150 7998-GET-PAPERLESS-IND.                                          
P00150                                                                  
P00150     EXEC SQL                                                     
P00150          SELECT 'Y'                                              
P00150            INTO :WS-PAPERLESS                                    
P00150            FROM CSS_EDI_ACCT_DEST NF WITH(READUNCOMMITTED)               
P00150           WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                 
P00150             AND NF.STATUS_CD    = 'A'                            
                                                                 
                                                            
P00150     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT 'Y'                                                      
MFA-TR*           INTO :WS-PAPERLESS                                            
MFA-TR*           FROM CSS_EDI_ACCT_DEST NF                                     
MFA-TR*          WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                         
MFA-TR*            AND NF.STATUS_CD    = 'A'                                    
MFA-TR*      WITH UR                                                            
MFA-TR*      QUERYNO 7998                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00150                                                                  
P00150     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00150                                                                  
P00150     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00150        NEXT SENTENCE                                             
P00150     ELSE                                                         
P00150        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00150        MOVE '7998'                TO ACTIVE-PARAGRAPH            
P00150        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00150        MOVE 'CSS_EDI_ACCT_DEST'   TO TABLE-1                     
P00150        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00150        MOVE NF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00150        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00150        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00150     END-IF.                                                      
P00150                                                                  
P00150 7998-EXIT.                                                       
P00150     EXIT.                                                        
P00150                                                                  
      ******************************************************************        
      * 8000-UPDATE-ACCOUNT                                            *        
      *     CALLS    9000-SEND-ERROR-RESULT                            *        
      *              9900-SQL-ERROR-ROUTINE                            *        
      *                                                                *        
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     UPDATE CODE_PERM_BILL AND CODE_TEMP_BILL ON CSS_ACCOUNT    *        
      ******************************************************************        
                                                                        
       8000-UPDATE-ACCOUNT.                                             
                                                                        
T20583     IF (PARM-RELEASE-BILL-OPTN = WS-HOLD AND NOT ACCT-IS-ON-HOLD 
T20583           AND AT-CODE-ACCT-BILLED NOT EQUAL WS-YES)              
T33462            OR PARM-RELEASE-BILL-OPTN = WS-EXCLUDE                
T20583         PERFORM 7175-REMOVE-FROM-OFF-CYCLE THRU 7175-EXIT        
PCR671     END-IF.                                                      
PCR671                                                                  
           EXEC SQL                                                     
               UPDATE CSS_ACCOUNT                                       
                  SET CODE_PERM_BILL  =  :PARM-CODE-PERM-BILL,          
                      CODE_TEMP_BILL  =  :PARM-CODE-TEMP-BILL,          
PCR671                CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED           
                WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                   
                                                            
           END-EXEC                                                     

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCOUNT                                               
MFA-TR*           SET CODE_PERM_BILL  =  :PARM-CODE-PERM-BILL,                  
MFA-TR*               CODE_TEMP_BILL  =  :PARM-CODE-TEMP-BILL,                  
MFA-TR*               CODE_ACCT_BILLED = :AT-CODE-ACCT-BILLED                   
MFA-TR*         WHERE ACCOUNT_NO = :WS-ACCOUNT-NO-CHK                           
MFA-TR*      QUERYNO 8000                                                       
MFA-TR*    END-EXEC                                                             

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
               MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
               MOVE '8000'                    TO ACTIVE-PARAGRAPH       
               MOVE 'UPDATE'                  TO ABEND-FUNCTION         
               MOVE 'CSS_ACCOUNT'             TO TABLE-1                
               MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1        
CBSI           MOVE 'CODE_PERM_BILL'          TO TABLE-ELEMENT-2        
CBSI           MOVE 'CODE_TEMP_BILL'          TO TABLE-ELEMENT-3        
CBSI           MOVE 'CODE_ACCT_BILLED'        TO TABLE-ELEMENT-4        
               MOVE WS-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1      
CBSI           MOVE PARM-CODE-PERM-BILL       TO HOSTVAR-ELEMENT-2      
CBSI           MOVE PARM-CODE-TEMP-BILL       TO HOSTVAR-ELEMENT-3      
CBSI           MOVE AT-CODE-ACCT-BILLED       TO HOSTVAR-ELEMENT-4      
               PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       8000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07969900
T15268* 8025-UPDATE-ACCT-MISC-INFO                                     *        
T15268*     CALLS    9000-SEND-ERROR-RESULT                            *        
T15268*              9900-SQL-ERROR-ROUTINE                            *        
T15268*                                                                *        
T15268*     CALLED FROM 2300-BUILD-RESULT                              *        
T15268*                                                                *        
T15268*     UPDATE LOCK-BOX-NO ON CSS_ACCT_MISC_INFO                   *        
      ******************************************************************        
                                                                        
T15268 8025-UPDATE-ACCT-MISC-INFO.                                      
                                                                        
T15268     EXEC SQL                                                     
T15268         UPDATE CSS_ACCT_MISC_INFO                                
T15268            SET LOCK_BOX_NO  =  :PARM-LOCK-BOX-NO                 
T15268          WHERE ACCOUNT_NO   =  :WS-ACCOUNT-NO-CHK                
                                                            
T15268     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                             
MFA-TR*        UPDATE CSS_ACCT_MISC_INFO                                        
MFA-TR*           SET LOCK_BOX_NO  =  :PARM-LOCK-BOX-NO                         
MFA-TR*         WHERE ACCOUNT_NO   =  :WS-ACCOUNT-NO-CHK                        
MFA-TR*      QUERYNO 8025                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15268     MOVE SQLCODE             TO WS-ACTIVE-RETURN-CODE.           
                                                                        
T15268     EVALUATE WS-ACTIVE-RETURN-CODE                               
T15268         WHEN SUCCESSFUL-CALL                                     
T15268             CONTINUE                                             
T15268         WHEN NOT-FOUND                                           
T15268             IF PARM-LOCK-BOX-NO = SPACES                         
T15268                 CONTINUE                                         
T15268             ELSE                                                 
T15268                 PERFORM 8050-INSERT-ACCT-MISC-INFO THRU 8050-EXIT
T15268             END-IF                                               
T15268         WHEN OTHER                                               
T15268             MOVE PROGRAM-NAME         TO ABEND-PROGRAM           
T15268             MOVE '8025'               TO ACTIVE-PARAGRAPH        
T15268             MOVE 'UPDATE'             TO ABEND-FUNCTION          
T15268             MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                 
T15268             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1         
CBSI               MOVE 'LOCK_BOX_NO'        TO TABLE-ELEMENT-2         
T15268             MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1       
CBSI               MOVE PARM-LOCK-BOX-NO     TO HOSTVAR-ELEMENT-2       
T15268             PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
T15268             PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
T15268     END-EVALUATE.                                                
                                                                        
T15268 8025-EXIT.                                                       
T15268     EXIT.                                                        
                                                                        
T15268******************************************************************        
PCR549* 8035-UPDATE-OFF-CYCLE-TBL                                      *        
PCR549*     CALLS    8075-INSERT-OFF-CYCLE-TBL                         *        
PCR549*                                                                *        
PCR549*     CALLED FROM 2300-BUILD-RESULT                              *        
PCR549*                                                                *        
PCR549*     UPDATE CSS_OFF_CYCL_ACCT TABLE                             *        
PCR549******************************************************************        
PCR549                                                                  
PCR549 8035-UPDATE-OFF-CYCLE-TBL.                                       
PCR549                                                                  
PCR549     MOVE '8035'                       TO ACTIVE-PARAGRAPH.       
PCR549                                                                  
PCR549     EVALUATE PARM-RELEASE-BILL-OPTN                              
T20583        WHEN WS-RELEASE                                           
T20583           MOVE SPACES               TO AT-CODE-ACCT-BILLED       
T20583           MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
T20583           MOVE SPACES               TO OC-CODE-BILL-OFF-CYCL     
T20583           MOVE SPACES               TO OC-CREDIT-LETTER-IND      
T20583           MOVE PARM-CUSTOMER-NO-NUM TO OC-CUSTOMER-NO            
T20583           MOVE ZERO                 TO OC-ITEM-ID                
T20583           PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
PCR671        WHEN WS-XFER-CONSOLIDATED                                 
PCR549           MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
PCR549           MOVE 'M'                  TO OC-CODE-BILL-OFF-CYCL     
PCR549           MOVE SPACES               TO OC-CREDIT-LETTER-IND      
PCR549           MOVE PARM-CUSTOMER-NO-NUM TO OC-CUSTOMER-NO            
PCR549           MOVE ZERO                 TO OC-ITEM-ID                
PCR549           PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
PCR671        WHEN WS-XFER-REGULAR                                      
PCR671           MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
PCR671           MOVE 'T'                  TO OC-CODE-BILL-OFF-CYCL     
PCR671           MOVE SPACES               TO OC-CREDIT-LETTER-IND      
PCR671           MOVE PARM-CUSTOMER-NO-NUM TO OC-CUSTOMER-NO            
PCR671           MOVE ZERO                 TO OC-ITEM-ID                
PCR671           PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
PCR671        WHEN WS-XFER-GUARANTOR                                    
PCR671           MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO             
PCR671           MOVE 'G'                  TO OC-CODE-BILL-OFF-CYCL     
PCR671           MOVE SPACES               TO OC-CREDIT-LETTER-IND      
PCR671           MOVE PARM-CUSTOMER-NO-NUM TO OC-CUSTOMER-NO            
PCR671           MOVE ZERO                 TO OC-ITEM-ID                
PCR671           PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT    
P00599*       WHEN WS-LPC-ONLY                                                  
P00599*          MOVE PARM-ACCOUNT-NO-NUM  TO OC-ACCOUNT-NO                     
P00599*          MOVE 'L'                  TO OC-CODE-BILL-OFF-CYCL             
P00599*          MOVE SPACES               TO OC-CREDIT-LETTER-IND              
P00599*          MOVE PARM-CUSTOMER-NO-NUM TO OC-CUSTOMER-NO                    
P00599*          MOVE ZERO                 TO OC-ITEM-ID                        
P00599*          PERFORM 8075-INSERT-OFF-CYCLE-TBL    THRU 8075-EXIT            
PCR549     END-EVALUATE.                                                
PCR549                                                                  
PCR549 8035-EXIT.                                                       
PCR549     EXIT.                                                        
                                                                        
T15268******************************************************************        
T15268* 8050-INSERT-ACCT-MISC-INFO                                     *        
T15268*     CALLS    9000-SEND-ERROR-RESULT                            *        
T15268*              9900-SQL-ERROR-ROUTINE                            *        
T15268*                                                                *        
T15268*     CALLED FROM 8025-UPDATE-LOCKBOX-NO                         *        
T15268*                                                                *        
T15268*     INSERT ROW W/ ACCT-NO & LOCK-BOX-NO IN CSS_ACCT_MISC_INFO  *        
T15268******************************************************************        
                                                                        
T15268 8050-INSERT-ACCT-MISC-INFO.                                      
                                                                        
T15268     EXEC SQL                                                     
T15268         INSERT INTO CSS_ACCT_MISC_INFO                           
T15268                ( ACCOUNT_NO,                                     
T15268                  LOCK_BOX_NO )                                   
T15268         VALUES ( :WS-ACCOUNT-NO-CHK,                             
                        :PARM-LOCK-BOX-NO )                             
T15268     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15268     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
                                                                        
T15268     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T15268         NEXT SENTENCE                                            
T15268     ELSE                                                         
T15268         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
T15268         MOVE '8050'               TO ACTIVE-PARAGRAPH            
T15268         MOVE 'INSERT'             TO ABEND-FUNCTION              
T15268         MOVE 'CSS_ACCT_MISC_INFO' TO TABLE-1                     
T15268         MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1             
CBSI           MOVE 'LOCK_BOX_NO'        TO TABLE-ELEMENT-2             
T15268         MOVE WS-ACCOUNT-NO        TO HOSTVAR-ELEMENT-1           
CBSI           MOVE PARM-LOCK-BOX-NO     TO HOSTVAR-ELEMENT-2           
T15268         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
T15268         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
T15268     END-IF.                                                      
                                                                        
T15268 8050-EXIT.                                                       
T15268     EXIT.                                                        
                                                                        
      ******************************************************************07969900
PCR549* 8075-INSERT-OFF-CYCLE-TBL                                      *        
PCR549*     CALLS    8080-WRITE-RLS-BILL-HIST                          *        
PCR549*              9000-SEND-ERROR-RESULT                            *        
PCR549*              9900-SQL-ERROR-ROUTINE                            *        
PCR549*                                                                *        
PCR549*     CALLED FROM   2300-BUILD-RESULT                            *        
PCR549*                                                                *        
PCR549*     INSERT ROW INTO CSS_OFF_CYCL_ACCT                          *        
PCR549******************************************************************        
PCR549                                                                  
PCR549 8075-INSERT-OFF-CYCLE-TBL.                                       
PCR549                                                                  
PCR549     MOVE '8075'                       TO ACTIVE-PARAGRAPH.       
PCR549                                                                  
PCR549     EXEC SQL                                                     
PCR549         INSERT INTO CSS_OFF_CYCL_ACCT                            
PCR549                ( ACCOUNT_NO,                                     
PCR549                  CODE_BILL_OFF_CYCL,                             
PCR549                  CREDIT_LETTER_IND,                              
PCR549                  CUSTOMER_NO,                                    
PCR549                  ITEM_ID,                                        
PCR549                  LAST_UPDATE_TS )                                
PCR549         VALUES ( :OC-ACCOUNT-NO,                                 
PCR549                  :OC-CODE-BILL-OFF-CYCL,                         
PCR549                  :OC-CREDIT-LETTER-IND,                          
PCR549                  :OC-CUSTOMER-NO,                                
PCR549                  :OC-ITEM-ID,                                    
PCR549                  CIS.CURRENT$TIMESTAMP() )                             
PCR549     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_OFF_CYCL_ACCT                                    
MFA-TR*               ( ACCOUNT_NO,                                             
MFA-TR*                 CODE_BILL_OFF_CYCL,                                     
MFA-TR*                 CREDIT_LETTER_IND,                                      
MFA-TR*                 CUSTOMER_NO,                                            
MFA-TR*                 ITEM_ID,                                                
MFA-TR*                 LAST_UPDATE_TS )                                        
MFA-TR*        VALUES ( :OC-ACCOUNT-NO,                                         
MFA-TR*                 :OC-CODE-BILL-OFF-CYCL,                                 
MFA-TR*                 :OC-CREDIT-LETTER-IND,                                  
MFA-TR*                 :OC-CUSTOMER-NO,                                        
MFA-TR*                 :OC-ITEM-ID,                                            
MFA-TR*                 CURRENT TIMESTAMP )                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

PCR549                                                                  
PCR549     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
PCR549                                                                  
PCR549     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
PCR549         PERFORM 8080-WRITE-RLS-BILL-HIST  THRU 8080-EXIT         
PCR549     ELSE                                                         
PCR549         IF WS-ACTIVE-RETURN-CODE = WS-DUPLICATE-ROW              
PCR549            NEXT SENTENCE                                         
PCR549         ELSE                                                     
PCR549            MOVE PROGRAM-NAME         TO ABEND-PROGRAM            
PCR549            MOVE '8075'               TO ACTIVE-PARAGRAPH         
PCR549            MOVE 'INSERT'             TO ABEND-FUNCTION           
CBSI              MOVE 'CSS_OFF_CYCL_ACCT'  TO TABLE-1                  
PCR549            MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1          
CBSI              MOVE 'CODE_BILL_OFF_CYCL' TO TABLE-ELEMENT-2          
CBSI              MOVE 'CUSTOMER_NO'        TO TABLE-ELEMENT-3          
CBSI              MOVE 'ITEM_ID'            TO TABLE-ELEMENT-4          
PCR549            MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1       
CBSI              MOVE OC-CODE-BILL-OFF-CYCL TO HOSTVAR-ELEMENT-2       
CBSI              MOVE OC-CUSTOMER-NO        TO HOSTVAR-ELEMENT-3       
CBSI              MOVE OC-ITEM-ID            TO HOSTVAR-ELEMENT-4       
PCR549            PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT         
PCR549            PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT         
PCR549         END-IF                                                   
PCR549     END-IF.                                                      
PCR549                                                                  
PCR549 8075-EXIT.                                                       
PCR549     EXIT.                                                        
                                                                        
PCR549******************************************************************        
PCR549* 8080-WRITE-RLS-BILL-HIST                                       *        
PCR549*     CALLS  7300-GET-TIMESTAMP                                  *        
PCR549*            5010-MNT-HST-DETAIL                                 *        
PCR549*                                                                *        
PCR549*     CALLED FROM   8075-INSERT-OFF-CYCLE-TBL                    *        
PCR549*                                                                *        
PCR549*     WRITE ROWS TO CSS_MNT_TRANS_HIST AND CSS_MT_TRN_HST_DET    *        
PCR549******************************************************************        
PCR549                                                                  
PCR549 8080-WRITE-RLS-BILL-HIST.                                        
PCR549                                                                  
PCR549     MOVE '8080'                    TO ACTIVE-PARAGRAPH.          
PCR549                                                                  
PCR549     PERFORM 7300-GET-TIMESTAMP     THRU 7300-EXIT.               
PCR549                                                                  
PCR549*    *** SET UP HEADER ROW                                                
PCR549     MOVE WS-F                      TO MH-CODE-TRAN-TYPE.         
PCR549     MOVE PARM-RESP-AREA-ID         TO MH-RESP-AREA-ID.           
PCR549     MOVE PARM-ACCOUNT-NO-NUM       TO MH-ACCOUNT-NO.             
PCR549                                                                  
PCR549     IF PARM-CREDIT-GROUP = WS-MASTER                             
PCR549        MOVE ZEROS                  TO MH-CUSTOMER-NO             
PCR549     ELSE                                                         
PCR549        MOVE PARM-CUSTOMER-NO       TO MH-CUSTOMER-NO             
PCR549     END-IF.                                                      
PCR549                                                                  
PCR549     MOVE ZEROS                     TO MH-PREMISE-NO.             
PCR549     MOVE PARM-USER-ID              TO MH-USER-ID.                
PCR549     MOVE 'PANEL490'                TO MH-APPL-PROGRAM-ID.        
PCR549                                                                  
PCR549     EVALUATE PARM-RELEASE-BILL-OPTN                              
PCR671        WHEN WS-RELEASE                                           
T33620           MOVE +16                    TO MH-TRAN-COMMENT-LEN     
T33620           MOVE 'REMOVE FROM HOLD'     TO MH-TRAN-COMMENT-TEXT    
PCR671        WHEN WS-HOLD                                              
PCR671           MOVE +34                    TO MH-TRAN-COMMENT-LEN     
PCR671           MOVE 'ACCT HELD SO THAT IT WILL NOT BILL'              
PCR671                                       TO MH-TRAN-COMMENT-TEXT    
PCR671        WHEN WS-XFER-CONSOLIDATED                                 
PCR671           MOVE +46                    TO MH-TRAN-COMMENT-LEN     
PCR671           MOVE 'ACCT RELEASED TO ACCEPT CONSOLIDATED PEND XFER'  
PCR671                                       TO MH-TRAN-COMMENT-TEXT    
PCR671        WHEN WS-XFER-REGULAR                                      
PCR671           MOVE +41                    TO MH-TRAN-COMMENT-LEN     
PCR671           MOVE 'ACCT RELEASED TO ACCEPT REGULAR PEND XFER'       
PCR671                                       TO MH-TRAN-COMMENT-TEXT    
PCR671        WHEN WS-XFER-GUARANTOR                                    
PCR671           MOVE +43                    TO MH-TRAN-COMMENT-LEN     
PCR671           MOVE 'ACCT RELEASED TO ACCEPT GUARANTOR PEND XFER'     
PCR671                                       TO MH-TRAN-COMMENT-TEXT    
P00599*       WHEN WS-LPC-ONLY                                                  
P00599*          MOVE +30                    TO MH-TRAN-COMMENT-LEN             
P00599*          MOVE 'ACCT RELEASED TO BILL LPC ONLY'                          
P00599*                                      TO MH-TRAN-COMMENT-TEXT            
PCR671     END-EVALUATE.                                                
PCR549                                                                  
PCR549*    *** SET UP DETAIL ROW                                                
PCR549     MOVE +1                        TO WS-TRAN-APPL-NO.           
PCR549                                                                  
PCR549     MOVE 'OFF CYCLE CODE'          TO MI-COLUMN-DESC.            
PCR549     MOVE +12                       TO MI-PRV-COLUMN-VALUE-LEN.   
PCR549     MOVE '**INSERTED**'            TO MI-PRV-COLUMN-VALUE-TEXT.  
PCR549     MOVE +1                        TO MI-CHG-COLUMN-VALUE-LEN.   
PCR549     MOVE OC-CODE-BILL-OFF-CYCL     TO MI-CHG-COLUMN-VALUE-TEXT.  
PCR549     MOVE 'OC'                      TO MI-TABLE-ID.               
PCR549     PERFORM 5010-MNT-HST-DETAIL    THRU 5010-EXIT.               
PCR549                                                                  
PCR549 8080-EXIT.                                                       
PCR549     EXIT.                                                        
C30169******************************************************************07969900
C30169* 8100-UPDATE-FIN-WO                                             *07492029
C30169*                                                                *07530029
C30169******************************************************************07550000
C30169 8100-UPDATE-FIN-WO.                                              
C30169                                                                  
C30169     EXEC SQL                                                     
C30169          UPDATE CSS_FIN_WO_COLLECT                               
C30169             SET WITHDRAW_DT        = CAST(SYSDATETIMEOFFSET() 
           AS DATE)                
C30169                ,WITHDRAW_AM        = :IZ-WITHDRAW-AM             
C30169                ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD      
C30169           WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO               
C30169             AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD        
C30169             AND WITHDRAW_DT >= CAST(SYSDATETIMEOFFSET() AS DATE)         
                                                            
C30169     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         UPDATE CSS_FIN_WO_COLLECT                                       
MFA-TR*            SET WITHDRAW_DT        = CURRENT DATE                        
MFA-TR*               ,WITHDRAW_AM        = :IZ-WITHDRAW-AM                     
MFA-TR*               ,WITHDRAW_REASON_CD = :IZ-WITHDRAW-REASON-CD              
MFA-TR*          WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO                       
MFA-TR*            AND FW_ACTION_TYPE_CD = :IZ-FW-ACTION-TYPE-CD                
MFA-TR*            AND WITHDRAW_DT >= CURRENT DATE                              
MFA-TR*      QUERYNO 8100                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C30169        MOVE '8100'                TO ACTIVE-PARAGRAPH            
C30169        MOVE 'UPDATE'              TO ABEND-FUNCTION              
C30169        MOVE 'CSS_FIN_WO_COLLECT'  TO TABLE-1                     
C30169        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C30169        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C30169        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169                                                                  
C30169 8100-EXIT.                                                       
C30169     EXIT.                                                        
ACT116*                                                                         
ACT116 8895-INSERT-WORK-QUEUE.                                          
ACT116                                                                  
ACT116     CALL MCSCB077 USING CWS00077-FIELDS                          
ACT116                        ,ABEND-FILE                               
ACT116                        ,WS-MCSCB077-RET-CODE.                    
ACT116                                                                  
ACT116     MOVE WS-MCSCB077-RET-CODE         TO WS-ACTIVE-RETURN-CODE.  
ACT116                                                                  
ACT116     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
ACT116         CONTINUE                                                 
ACT116     ELSE                                                         
ACT116         DISPLAY '8895-INSERT-WORK-QUEUE'                         
ACT116         DISPLAY 'CALL MCSCB077         '                         
ACT116         MOVE PROGRAM-NAME       TO ABEND-PROGRAM                 
ACT116         MOVE '8895'             TO ACTIVE-PARAGRAPH              
ACT116         MOVE 'CALL'             TO ABEND-FUNCTION                
ACT116         MOVE 'MCSCB077'         TO TABLE-1                       
ACT116         MOVE 'ACCOUNT_NO'       TO TABLE-ELEMENT-1               
ACT116         MOVE 'PREMISE_NO'       TO TABLE-ELEMENT-2               
ACT116         MOVE 'CUSTOMER_NO'      TO TABLE-ELEMENT-3               
ACT116         MOVE WS-77-ACCOUNT-NO   TO HOSTVAR-ELEMENT-1             
ACT116         MOVE WS-77-PREMISE-NO   TO HOSTVAR-ELEMENT-2             
ACT116         MOVE WS-77-CUSTOMER-NO  TO HOSTVAR-ELEMENT-3             
ACT116         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
ACT116         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
ACT116     END-IF.                                                      
ACT116                                                                  
ACT116 8895-EXIT.                                                       
ACT116     EXIT.                                                        
      ******************************************************************07969900
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     07970000
      ******************************************************************07970100
REARCH     EXEC SQL                                                     07970200
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                    07980000
                                                                        
      ******************************************************************08000000
      * END PROGRAM COPYLIB                                            *08010000
      *     <8100-SEND RESULT & 9000-SEND-ERROR-RESULT>                *        
      ******************************************************************08020000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00321                                                 
REARCH     END-EXEC.                                                            
C30169*                                                                *63030000
C30169******************************************************************63030100
C30169* 9700-PROCESS-ABEND.                                            *63030200
C30169* THIS PARAGRAPH DUPLICATES THE CODE IN CPD0023C, BECAUSE        *63030300
C30169* 9700-PROCESS-ABEND IS NOT APPLICABLE TO THIS PROGRAM           *63030400
C30169*                                                                *63030600
C30169******************************************************************63030700
C30169 9700-PROCESS-ABEND.                                              
C30169*                                                                 63030900
C30169     PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT.               
C30169     PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT.               
C30169*                                                                 63031200
C30169 9700-EXIT.                                                       
C30169     EXIT.                                                        
C30169*                                                                         
