       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.    CSR02353.                                         
COB303 DATE-WRITTEN.     JAN 8, 1998.                                   
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************00060000
      *                SOUTH CAROLINA ELECTRIC & GAS                   *00070000
      *                                                                *00080000
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *00090000
      *                                                                *00100000
      *  TRANID:        S353                                           *00110000
      *  PROGRAM:       S353                                           *00120000
      *  CALLING SP:    PA_S353                                        *00130042
      *                                                                *00140000
      ******************************************************************00150000
      *                 P R O G R A M  S U M M A R Y                   *00160000
      *                                                                *00170000
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *00180000
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *00190000
      *  THIS PROGRAM RETRIEVES ROWS FROM THE FOLLOWING TABLES:        *00200043
      *  CSS_ACCOUNT, CSS_ACCT_MISC_INFO                               *        
      *  THE PROCEDURE WILL BRING BACK CODE-PERM-BILL, CODE-TEMP-BILL  *        
      *  AND LOCK-BOX-NO WHEN ACCOUNT NUMBER IS PASSED.                *        
      *                                                                *        
      ******************************************************************00220000
      *                                                                *00230000
      *                     PROGRAM MODIFICATION LOG                   *00240000
      *                                                                *00250000
      *    DATE    INITIALS   COMMENTS                                 *00260000
      *  --------  --------   ---------------------------------------  *00270000
      *  01/08/98    PRA      CREATED.                                 *00280000
T15268*  03/17/98    PRA      ADDED RETRIEVAL OF LOCK-BOX-NO           *00290000
PCR549*  05/27/98    AMG      ADDED RETRIEVAL OF CREDIT-GROUP          *00290000
CBSI  *  12/29/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T19272*  03/17/99    CBSI     ADDED RETRIEVAL OF CODE-ACCT-BILLED      *        
      *              MADRAS                                            *        
C26296*  01/10/05    MSR      ADDED RETRIEVAL OF DNP EXEMPTION IND AND *        
C26296*                       RETURN CHECK IND.                        *        
C31813*  06/03/05    SK88120  ADDED RETRIEVAL FOR CONVERT CHECK ELECTRO*        
C31813*                      -NICALLY(ARC) INDICATOR.                  *        
REARCH*  03/03/06    CVNS     RPC CONVERTED TO COBOL SP                *        
REARCH*              CHENNAI                                           *        
C30169*  01/28/07    MSR      ADDED CREDIT BUREAU EXEMPT AND COLLECTION*        
C30169*                       AGENCY EXEMPT CODES.                     *        
A00643*  02/18/09    MSR      ADD EBILL REGISTER IND, PAPERLESS FIELDS.*        
P00150*  05/19/09    MSR      DEFAULT BILL NOTIFICATION TO PAPER ONLY. *        
A02365*  02/23/11    DB18339  ADD DEST_ID FROM CSS_EDI_ACCT_DEST.      *        
P00471*  09/01/11    PK98692  ADDED RETRIEVAL OF DPP DROP EXEMPTION IND*        
P00471*                       FROM CSS_ACCT_ATTRIBUTE AND DPP          *        
P00773*  08/15/13    DB18339  ADDED ACCT REVIEW EXEMPT FLAG FROM       *        
P00773*                       CSS_ACCT_ATTRIBUTE                       *        
      ******************************************************************00300000
      ******************************************************************00310000
      *                                                                *00320000
      *                ---- BASIC SEQUENCE STRUCTURE ----              *00330000
      *                                                                *00340000
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *00350000
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *00360000
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *00370000
      *  3000 - 4999  NOT USED                                         *00380000
      *  5000 - 5999  COMMON PROGRAM MODULES                           *00390000
      *  6000 - 6999  COMMON SYSTEM MODULES                            *00400000
      *  7000 - 7999  INPUT MODULES                                    *00410000
      *  8000 - 8999  OUTPUT MODULES                                   *00420000
      *  9000 - 9999  TERMINATION, ABEND, MESSAGING MODULES            *00430000
      *                                                                *00440000
      ******************************************************************00450000
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02353'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02353 STARTS HERE'.                  
                                                                        
      ******************************************************************00540000
      *    DB2 INCLUDES                                                *00550000
      ******************************************************************00560000
                                                                        
           EXEC SQL                                                     00580000
              INCLUDE SQLCA                                             00590000
           END-EXEC.                                                    00600000
                                                                        
      *-------< INCLUDE CSS_ACCOUNT       >                             00620000
                                                                        
           EXEC SQL                                                     00630000
              INCLUDE TBACCT                                            00640000
           END-EXEC.                                                    00650000
                                                                        
      *-------< INCLUDE CSS_ACCT_MISC_INFO >                            00620000
                                                                        
T15268     EXEC SQL                                                     00630000
T15268        INCLUDE TBATMISC                                          00640000
T15268     END-EXEC.                                                    00650000
C26296*-------< INCLUDE CSS_ACCT_ATTRIBUTE >                            00620000
C26296                                                                  
C26296     EXEC SQL                                                     00630000
C26296        INCLUDE TBACTATT                                          00640000
C26296     END-EXEC.                                                    00650000
C29533*-------< INCLUDE CSS_ATTRIBUTE >                                 00620000
C29533                                                                  
C29533     EXEC SQL                                                     00630000
C29533        INCLUDE TBATTRIB                                          00640000
C29533     END-EXEC.                                                    00650000
C31813*-------< INCLUDE CSS_DELIQUENCY >                                00620000
C31813                                                                  
C31813     EXEC SQL                                                     00630000
C31813        INCLUDE TBDELQ                                            00640000
C31813     END-EXEC.                                                    00650000
A00643*-------< INCLUDE CSS_CUST_STATS >                                00620000
A00643                                                                  
A00643     EXEC SQL                                                     00630000
A00643        INCLUDE TBCSTSTS                                          00640000
A00643     END-EXEC.                                                    00650000
A00643*-------< INCLUDE CSS_EDI_ACCT_DEST >                             00620000
A00643                                                                  
A00643     EXEC SQL                                                     00630000
A00643        INCLUDE TBACDEST                                          00640000
A00643     END-EXEC.                                                    00650000
                                                                        
      ******************************************************************00770000
      *    COBOL WORKING STORAGE COPY BOOKS                            *00780000
      ******************************************************************00790000
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >      00810000
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >      00820000
REARCH*    COPY SYGWCOB.                                                00830000
      *--------< ADDED TO SUPPORT CICS RPCS >                           00840000
REARCH*    COPY SYDBCOB.                                                00850000
      *--------<COMMON SYSTEM AREA >                                    00860000
           COPY CCA00001.                                               00870000
      *--------< ERROR HANDLING >                                       00880000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CWSX0010                                                 
REARCH     END-EXEC.                                                            
REARCH*    COPY CWS00010.                                                       
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >       00900000
           COPY CWS00027.                                               00910000
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                  00920000
           COPY CWS00303.                                               00930000
P00471*--------<ACCOUNTS CODE DATA PRESENT >                                    
P00471     COPY CWS00056.                                                       
      ******************************************************************00950000
      *    WORK AREAS                                                  *00960000
      ******************************************************************00970000
                                                                        
       01  WS-MISC.                                                     
REARCH     05  PROGRAM-NAME            PIC X(08) VALUE 'CSR02353'.      
REARCH     05  WS-SQLSTATE             PIC X(05) VALUE '     '.         
           05  NULL-VALUE              PIC S9(09) COMP  VALUE -180.     
                                                                        
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
                                                                        
       01  PARM-FIELDS.                                                 
REARCH*    05  PARM-L                  PIC S9(9) COMP.                  01140000
REARCH*    05  PARM-ID1                PIC S9(9) COMP VALUE 1.          01150000
REARCH*    05  PARM-ACCOUNT-NO         PIC X(13).                       01160003
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
REARCH     05  PARM-ACCOUNT-NO-NUM     REDEFINES PARM-ACCOUNT-NO-TEMP   
                                       PIC 9(13).                       
       01  SNA-FIELDS.                                                  
           05  SNA-SUBC                PIC S9(9) COMP.                  
           05  SNA-CONNECTION-NAME     PIC X(8)  VALUE SPACES.          
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
REARCH*                                                                         
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
REARCH*                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26)                        
REARCH                                     VALUE 'SESSION.CSR02353_R1'. 
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
REARCH*                                                                         
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
           05  RS-RETURN-CODE          PIC S9(9) COMP VALUE 0.          
           05  RS-CODE-PERM-BILL       PIC X(1)  VALUE  SPACES.         
           05  RS-CODE-TEMP-BILL       PIC X(1)  VALUE  SPACES.         
T15268     05  RS-LOCK-BOX-NO          PIC X(7)  VALUE  SPACES.         
PCR549     05  RS-ACCT-CREDIT-GRP      PIC X(1)  VALUE  SPACES.         
T19272     05  RS-CODE-ACCT-BILLED     PIC X(1)  VALUE  SPACES.         
C26296     05  RS-DNP                  PIC X(5)  VALUE  SPACES.         
C26296     05  RS-RETURN-CHECK         PIC X(5)  VALUE  SPACES.         
C29533     05  RS-BILL-NOTIFICATION    PIC X(05) VALUE  SPACES.         
C29533     05  RS-EBILL-COPIES         PIC S9(4) COMP VALUE 0.          
C31813     05  RS-ARC-IND              PIC X(1)  VALUE  SPACES.         
C30169     05  RS-COLL-XMT             PIC X(05) VALUE  SPACES.         
C30169     05  RS-CR-BUREAU-XMT        PIC X(05) VALUE  SPACES.         
A00643     05  RS-PAPERLESS-IND        PIC X(01) VALUE  SPACES.         
A00643     05  RS-EBILL-REGISTER-IND   PIC X(01) VALUE  SPACES.         
A02365     05  RS-DEST-ID              PIC X(10) VALUE  SPACES.         
P00471     05  RS-DPPDROP-XMPT-CD      PIC X(05) VALUE  SPACES.         
P00471     05  RS-DPP                  PIC X(01) VALUE  SPACES.         
P00773     05  RS-REVIEW-EXEMPT        PIC X(01) VALUE  SPACES.         
REARCH*                                                                         
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH     05  S-RETURN-CODE           PIC S9(9) COMP VALUE 0.          
REARCH     05  S-CODE-PERM-BILL        PIC X(1)  VALUE  SPACES.         
REARCH     05  S-CODE-TEMP-BILL        PIC X(1)  VALUE  SPACES.         
REARCH     05  S-LOCK-BOX-NO           PIC X(7)  VALUE  SPACES.         
REARCH     05  S-ACCT-CREDIT-GRP       PIC X(1)  VALUE  SPACES.         
REARCH     05  S-CODE-ACCT-BILLED      PIC X(1)  VALUE  SPACES.         
REARCH     05  S-DNP                   PIC X(5)  VALUE  SPACES.         
REARCH     05  S-RETURN-CHECK          PIC X(5)  VALUE  SPACES.         
REARCH     05  S-BILL-NOTIFICATION     PIC X(05) VALUE  SPACES.         
REARCH     05  S-EBILL-COPIES          PIC S9(4) COMP VALUE 0.          
REARCH     05  S-ARC-IND               PIC X(1)  VALUE  SPACES.         
C30169     05  S-COLL-XMT              PIC X(05) VALUE  SPACES.         
C30169     05  S-CR-BUREAU-XMT         PIC X(05) VALUE  SPACES.         
A00643     05  S-PAPERLESS-IND         PIC X(01) VALUE  SPACES.         
A00643     05  S-EBILL-REGISTER-IND    PIC X(01) VALUE  SPACES.         
A02365     05  S-DEST-ID               PIC X(10) VALUE  SPACES.         
P00471     05  S-DPPDROP-XMPT-CD       PIC X(05) VALUE  SPACES.         
P00471     05  S-DPP                   PIC X(01) VALUE  SPACES.         
P00773     05  S-REVIEW-EXEMPT         PIC X(01) VALUE  SPACES.         
REARCH*                                                                         
REARCH*01  CNS-COLUMN-NAMES.                                                    
REARCH*    05  CNS-RETURN-CODE         PIC X(11) VALUE 'RETURN_CODE'.           
REARCH*    05  CNS-CODE-PERM-BILL      PIC X(11) VALUE 'CODE_PERM  '.           
REARCH*    05  CNS-CODE-TEMP-BILL      PIC X(11) VALUE 'CODE_TEMP  '.           
T15268*    05  CNS-LOCK-BOX-NO         PIC X(11) VALUE 'LOCK_BOX_NO'.           
PCR549*    05  CNS-ACCT-CREDIT-GRP     PIC X(11) VALUE 'CREDIT_GRP '.           
T19272*    05  CNS-CODE-ACCT-BILLED    PIC X(11) VALUE 'CODE_ACCT  '.           
C26296*    05  CNS-DNP                 PIC X(11) VALUE 'DNP        '.           
C26296*    05  CNS-RETURN-CHECK        PIC X(12) VALUE 'RETURN_CHECK'.          
C29533*    05  CNS-BILL-NOTIFICATION   PIC X(17) VALUE                          
C29533*                                          'BILL_NOTIFICATION'.           
C29533*    05  CNS-EBILL-COPIES        PIC X(12) VALUE 'EBILL_COPIES'.          
C31813*    05  CNS-ARC-IND             PIC X(07) VALUE 'ARC_IND'.               
                                                                        
       01  GENERAL-WORKING-STORAGE.                                     
COB305     05 WS-ACCOUNT-NO        PIC S9(13) USAGE COMP-3 VALUE 0.          
           05  WS-ACCOUNT-NO-CHAR     PIC X(13).                        
           05  WS-ACCOUNT-NO-INT      PIC 9(13).                        
COB305     05 WS-ACCOUNT-NO-CHK        PIC S9(13)V USAGE COMP-3 VALUE 0.        
C26296     05  WS-DNP-EXMP-IND        PIC X(18)  VALUE                  
C26296                                'AUTODNPDEPEXEMPIND'.             
C26296     05  WS-RETURN-CHK-IND      PIC X(18)  VALUE                  
C26296                                'AUTORETDEPEXEMPIND'.             
P00471     05  WS-DPPDROP-XMPT-IND    PIC X(18)  VALUE                  
P00471                                'AUTODPPDRPEXEMPIND'.             
C29533     05  WS-ATTRIBUTE-TYPE      PIC X(08)  VALUE SPACES.          
C29533     05  WS-NO-NOTIFICATION     PIC X(01)  VALUE 'N'.             
C29533         88 NO-NOTIFICATION                VALUE 'Y'.             
C29533     05  WS-PAPER-ONLY          PIC X(01)  VALUE 'N'.             
C29533         88 PAPER-ONLY                     VALUE 'Y'.             
C31813     05  WS-ARC-VALID           PIC X(01)  VALUE 'N'.             
C31813         88 VALID-ARC-REGION               VALUE 'Y'.             
C31813     05  WS-ROW-EXIST           PIC X(01)  VALUE 'N'.             
A00643     05  WS-PAPERLESS           PIC X(01)  VALUE SPACES.          
A02365     05  WS-DEST-ID             PIC X(10)  VALUE SPACES.          
P00471     05  WS-A                   PIC X(01)  VALUE 'A'.             
                                                                        
       01  SWITCHES.                                                    
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
HPCCDM*EJECT                                                            02000000
REARCH LINKAGE SECTION.                                                 
REARCH 01  PARM-ACCOUNT-NO             PIC X(13).                       
                                                                        
REARCH PROCEDURE DIVISION USING PARM-ACCOUNT-NO.                        
                                                                        
      ******************************************************************02030000
      * 0000-MAINLINE                                                  *02040000
      *     CALLS 0100-INITIALIZE                                      *02050000
      *           1000-PROCESS-INPUT                                   *02060000
      *           2000-PROCESS-OUTPUT                                  *02070000
      *           9999-END-PROGRAM                                     *02080000
      *                                                                *02090000
      *     CONTROLS THE MAIN PATH OF THE PROGRAM                      *02100000
      ******************************************************************02110000
                                                                        
       0000-MAINLINE.                                                   
                                                                        
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
                                                                        
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02230000
      * 0100-INITIALIZE                                                *02240000
      *     CALLS 9000-SEND-ERROR-RESULT                               *02250000
      *           9900-SQL-ERROR-ROUTINE                               *02260000
      *                                                                *02270000
      *     CALLED FROM 0000-MAINLINE                                  *02280000
      *                                                                *02290000
      *     1. RESET DB2 ERROR HANDLERS                                *02300000
      *     2. ESTABLISH GATEWAY ENVIRONMENT (TDINIT)                  *02310000
      *     3. ACCEPT CLIENT REQUEST/ESTABLISH SNA HANDLE (TDACCEPT)   *02320000
      *     4. DETERMINE IF CLIENT HAS SENT AN RPC PARAMETER (TDRESULT)*02330000
      *                                                                *02340000
      ******************************************************************02350000
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
REARCH          DECLARE C1 CURSOR  FOR                       
REARCH          SELECT                                                  
REARCH                :S-RETURN-CODE               AS RETURN_CODE       
REARCH               ,LTRIM(RTRIM(:S-CODE-PERM-BILL))     AS CODE_PERM         
REARCH               ,LTRIM(RTRIM(:S-CODE-TEMP-BILL))     AS CODE_TEMP         
REARCH               ,LTRIM(RTRIM(:S-LOCK-BOX-NO))        AS LOCK_BOX_NO       
REARCH               ,LTRIM(RTRIM(:S-ACCT-CREDIT-GRP))    AS CREDIT_GRP        
REARCH               ,LTRIM(RTRIM(:S-CODE-ACCT-BILLED))   AS CODE_ACCT         
REARCH               ,LTRIM(RTRIM(:S-DNP))                AS DNP               
REARCH               ,LTRIM(RTRIM(:S-RETURN-CHECK))       AS 
           RETURN_CHECK      
REARCH               ,LTRIM(RTRIM(:S-BILL-NOTIFICATION))  AS 
           BILL_NOTIFICATION 
REARCH               ,:S-EBILL-COPIES              AS EBILL_COPIES      
REARCH               ,LTRIM(RTRIM(:S-ARC-IND))            AS ARC_IND           
C30169               ,LTRIM(RTRIM(:S-COLL-XMT))           AS COLL_XMT          
C30169               ,LTRIM(RTRIM(:S-CR-BUREAU-XMT))      AS 
           CR_BUREAU_XMT     
A00643               ,LTRIM(RTRIM(:S-PAPERLESS-IND))      AS 
           PAPERLESS_IND     
A00643               ,LTRIM(RTRIM(:S-EBILL-REGISTER-IND)) AS 
           EBILL_REGISTER_IND
A02365               ,LTRIM(RTRIM(:S-DEST-ID))            AS DEST_ID           
P00471               ,LTRIM(RTRIM(:S-DPPDROP-XMPT-CD))    AS 
           DPPDROP_XMPT_CD   
P00471               ,LTRIM(RTRIM(:S-DPP))                AS DPP               
P00773               ,LTRIM(RTRIM(:S-REVIEW-EXEMPT))      AS 
           REVIEW_EXEMPT     
REARCH          FROM                                                    
REARCH               CIS.SYSDUMMY1                                   
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR* MSQ029
MFA-TR*    EXEC SQL                                                             
MFA-TR*         DECLARE C1 CURSOR WITH RETURN FOR                               
MFA-TR*         SELECT                                                          
MFA-TR*               :S-RETURN-CODE               AS RETURN_CODE               
MFA-TR*              ,STRIP(:S-CODE-PERM-BILL)     AS CODE_PERM                 
MFA-TR*              ,STRIP(:S-CODE-TEMP-BILL)     AS CODE_TEMP                 
MFA-TR*              ,STRIP(:S-LOCK-BOX-NO)        AS LOCK_BOX_NO               
MFA-TR*              ,STRIP(:S-ACCT-CREDIT-GRP)    AS CREDIT_GRP                
MFA-TR*              ,STRIP(:S-CODE-ACCT-BILLED)   AS CODE_ACCT                 
MFA-TR*              ,STRIP(:S-DNP)                AS DNP                       
MFA-TR*              ,STRIP(:S-RETURN-CHECK)       AS RETURN_CHECK              
MFA-TR*              ,STRIP(:S-BILL-NOTIFICATION)  AS BILL_NOTIFICATION         
MFA-TR*              ,:S-EBILL-COPIES              AS EBILL_COPIES              
MFA-TR*              ,STRIP(:S-ARC-IND)            AS ARC_IND                   
MFA-TR*              ,STRIP(:S-COLL-XMT)           AS COLL_XMT                  
MFA-TR*              ,STRIP(:S-CR-BUREAU-XMT)      AS CR_BUREAU_XMT             
MFA-TR*              ,STRIP(:S-PAPERLESS-IND)      AS PAPERLESS_IND             
MFA-TR*              ,STRIP(:S-EBILL-REGISTER-IND) AS EBILL_REGISTER_IND        
MFA-TR*              ,STRIP(:S-DEST-ID)            AS DEST_ID                   
MFA-TR*              ,STRIP(:S-DPPDROP-XMPT-CD)    AS DPPDROP_XMPT_CD           
MFA-TR*              ,STRIP(:S-DPP)                AS DPP                       
MFA-TR*              ,STRIP(:S-REVIEW-EXEMPT)      AS REVIEW_EXEMPT             
MFA-TR*         FROM                                                            
MFA-TR*              SYSIBM.SYSDUMMY1                                           
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************02640000
      * 1000-PROCESS-INPUT                                             *02650000
      *     CALLS 1100-RECEIVE-PARMS                                   *02660000
      *                                                                *02670000
      *     CALLED FROM 0000-MAINLINE                                  *02680000
      *                                                                *02690000
      *     1. RECEIVE PARMS.                                          *02700000
      ******************************************************************02710000
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
REARCH     MOVE PARM-ACCOUNT-NO         TO PARM-ACCOUNT-NO-TEMP.        
           MOVE PARM-ACCOUNT-NO         TO WS-ACCOUNT-NO-CHAR.          
           UNSTRING WS-ACCOUNT-NO-CHAR DELIMITED BY SPACES              
                                        INTO WS-ACCOUNT-NO-INT.         
           MOVE WS-ACCOUNT-NO-INT       TO WS-ACCOUNT-NO.               
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************03210000
      * 2000-PROCESS-OUTPUT.                                           *03220000
      *     CALLS 2100-DESCRIBE-RESULT                                 *03230000
      *           2300-BUILD-RESULT                                    *03240000
      *                                                                *03250000
      *      CALLED FROM 0000-MAINLINE                                 *03260000
      *                                                                *03270000
      *      SETS UP PARAMETERS TO BE RETURNED, POPULATES THE PARMS    *03280000
      *      AND SENDS THEN BACK                                       *03290000
      ******************************************************************03300000
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           PERFORM 2300-BUILD-RESULT             THRU 2300-EXIT.        
                                                                        
       2000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH******************************************************************        
REARCH*  2000A-MOVE-RESULT.                                            *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH                                                                  
REARCH     MOVE RS-RETURN-CODE        TO S-RETURN-CODE.                 
REARCH     MOVE RS-CODE-PERM-BILL     TO S-CODE-PERM-BILL.              
REARCH     MOVE RS-CODE-TEMP-BILL     TO S-CODE-TEMP-BILL.              
REARCH     MOVE RS-LOCK-BOX-NO        TO S-LOCK-BOX-NO.                 
REARCH     MOVE RS-ACCT-CREDIT-GRP    TO S-ACCT-CREDIT-GRP.             
REARCH     MOVE RS-CODE-ACCT-BILLED   TO S-CODE-ACCT-BILLED.            
REARCH     MOVE RS-DNP                TO S-DNP.                         
REARCH     MOVE RS-RETURN-CHECK       TO S-RETURN-CHECK.                
REARCH     MOVE RS-BILL-NOTIFICATION  TO S-BILL-NOTIFICATION.           
REARCH     MOVE RS-EBILL-COPIES       TO S-EBILL-COPIES.                
REARCH     MOVE RS-ARC-IND            TO S-ARC-IND.                     
C30169     MOVE RS-CR-BUREAU-XMT      TO S-CR-BUREAU-XMT.               
C30169     MOVE RS-COLL-XMT           TO S-COLL-XMT.                    
A00643     MOVE RS-PAPERLESS-IND      TO S-PAPERLESS-IND.               
A00643     MOVE RS-EBILL-REGISTER-IND TO S-EBILL-REGISTER-IND.          
A02365     MOVE RS-DEST-ID            TO S-DEST-ID.                     
P00471     MOVE RS-DPPDROP-XMPT-CD    TO S-DPPDROP-XMPT-CD.             
P00471     MOVE RS-DPP                TO S-DPP.                         
P00773     MOVE RS-REVIEW-EXEMPT      TO S-REVIEW-EXEMPT.               
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
                                                                        
      ******************************************************************06620000
      * 2300-BUILD-RESULT                                              *06630000
      *     CALLS  7300-SELECT-BILL-CODE                               *06640011
T15268*            7400-SELECT-LOCK-BOX-NO                             *        
      *            8100-SEND-RESULT                                    *        
      *                                                                *        
      *     CALLED FROM 2000-PROCESS-OUTPUT                            *06680000
      *                                                                *06690000
      *     BUILD THE RESULT SET DESCRIBED ABOVE.                      *06700000
      ******************************************************************06710000
       2300-BUILD-RESULT.                                               
                                                                        
           MOVE '2300'                          TO ACTIVE-PARAGRAPH.    
                                                                        
           PERFORM 7300-SELECT-BILL-CODE     THRU 7300-EXIT.            
           MOVE AT-CODE-PERM-BILL   TO RS-CODE-PERM-BILL.               
           MOVE AT-CODE-TEMP-BILL   TO RS-CODE-TEMP-BILL.               
PCR549     MOVE AT-CREDIT-GROUP     TO RS-ACCT-CREDIT-GRP.              
T19272     MOVE AT-CODE-ACCT-BILLED TO RS-CODE-ACCT-BILLED.             
P00471     MOVE AT-CODES-DATA-PRESENT TO WS-CODES-DATA-PRESENT.         
P00471     IF WS-CODE-DPP-ACCT = WS-A                                   
P00471        MOVE 'Y' TO RS-DPP                                        
P00471     ELSE                                                         
P00471        MOVE 'N' TO RS-DPP                                        
P00471     END-IF.                                                      
                                                                        
T15268     PERFORM 7400-SELECT-LOCK-BOX-NO   THRU 7400-EXIT.            
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T15268        MOVE TA-LOCK-BOX-NO    TO RS-LOCK-BOX-NO                  
           ELSE                                                         
T15268        MOVE SPACES            TO RS-LOCK-BOX-NO                  
           END-IF.                                                      
C26296*                                                                         
C26296     PERFORM 7500-GET-DNP-EXMP-IND     THRU 7500-EXIT.            
C26296     MOVE YP-ATTRIBUTE-VALUE-CD   TO RS-DNP.                      
C26296     PERFORM 7600-GET-RETURN-CHECK-CD  THRU 7600-EXIT.            
C26296     MOVE YP-ATTRIBUTE-VALUE-CD   TO RS-RETURN-CHECK.             
P00471*                                                                         
P00471     PERFORM 7970-GET-DPPDROP-XMPT-CD  THRU 7970-EXIT.            
P00471     MOVE YP-ATTRIBUTE-VALUE-CD   TO RS-DPPDROP-XMPT-CD.          
                                                                        
P00773     PERFORM 7980-GET-REVIEW-EXEMPT-FL THRU 7980-EXIT.            
P00773     MOVE YP-ATTRIBUTE-VALUE-CD   TO RS-REVIEW-EXEMPT.            
                                                                        
C29533     PERFORM 2400-GET-BILL-NOTIFICATION THRU 2400-EXIT.           
                                                                        
C31813     PERFORM 2500-GET-ARC-IND           THRU 2500-EXIT.           
C30169     PERFORM 2600-GET-CR-XMPT-CD        THRU 2600-EXIT.           
A00643     PERFORM 2700-GET-EBILL-PPRL-IND    THRU 2700-EXIT.           
P00150     IF (RS-PAPERLESS-IND = 'Y' OR                                
P00150         RS-EBILL-REGISTER-IND = 'Y') AND                         
P00150         RS-BILL-NOTIFICATION = '5'                               
P00150         MOVE '2'                       TO RS-BILL-NOTIFICATION   
P00150     END-IF.                                                      
REARCH     PERFORM 2000A-MOVE-RESULT          THRU 2000A-EXIT.          
REARCH     ADD +1                             TO   CTR-ROWS.            
REARCH*    PERFORM 8100-SEND-RESULT     THRU 8100-EXIT.                 06860014
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
                                                                        
C29533*                                                                         
C29533******************************************************************        
C29533* 2400-GET-BILL-NOTIFICATION                                     *        
C29533*                                                                *07520000
C29533*     CALLED FROM 2300-BUILD-RESULT                              *        
C29533*                                                                *        
C29533*     SELECT FROM CSS_ACCOUNT AND CSS_ACCT_ATTRIBUTE             *07530029
C29533******************************************************************07550000
C29533*                                                                         
C29533 2400-GET-BILL-NOTIFICATION.                                      
C29533*                                                                         
C29533     PERFORM 7700-GET-EBILL-COPIES THRU 7700-EXIT.                
C29533     MOVE AT-NO-BILL-COPIES     TO RS-EBILL-COPIES.               
C29533     MOVE 'EMAIL_BILLNOTIFY'    TO YP-ATTRIBUTE-DESC.             
C29533     PERFORM 7800-CHECK-ACCT-ATTRB  THRU 7800-EXIT.               
C29533     IF NO-NOTIFICATION                                           
C29533        MOVE '4'                TO RS-BILL-NOTIFICATION           
C29533     ELSE                                                         
C29533        IF AT-NO-BILL-COPIES EQUAL 0                              
C29533           MOVE '1'             TO RS-BILL-NOTIFICATION           
C29533        ELSE                                                      
C29533           IF AT-NO-BILL-COPIES > 0                               
C29533              MOVE 'EMAIL_PAPERONLY'   TO YP-ATTRIBUTE-DESC       
C29533              MOVE 'EMAIL'             TO WS-ATTRIBUTE-TYPE       
C29533              PERFORM 7900-CHECK-ATTRB THRU 7900-EXIT             
C29533              IF PAPER-ONLY                                       
C29533                 MOVE '3'       TO RS-BILL-NOTIFICATION           
C29533              ELSE                                                
C29533                 MOVE '5'       TO RS-BILL-NOTIFICATION           
C29533              END-IF                                              
C29533           END-IF                                                 
C29533        END-IF                                                    
C29533     END-IF.                                                      
C29533*                                                                         
C29533 2400-EXIT.                                                       
C29533     EXIT.                                                        
C29533*                                                                         
C31813*                                                                         
C31813******************************************************************        
C31813* 2500-GET-ARC-IND                                               *        
C31813*                                                                *07520000
C31813*     CALLED FROM 2300-BUILD-RESULT                              *        
C31813*                                                                *        
C31813*     SELECT FROM CSS_DELINQUENCY AND CSS_ACCT_ATTRIBUTE         *07530029
C31813******************************************************************07550000
C31813*                                                                         
C31813 2500-GET-ARC-IND.                                                
C31813*                                                                         
C31813     PERFORM 8000-CHK-DELINQUENCY     THRU 8000-EXIT.             
C31813     IF VALID-ARC-REGION                                          
C31813        PERFORM 8100-CHK-ARC-IND      THRU 8100-CHK-EXIT          
C31813     ELSE                                                         
C31813        MOVE 'I'                TO RS-ARC-IND                     
C31813     END-IF.                                                      
C31813*                                                                         
C31813 2500-EXIT.                                                       
C31813     EXIT.                                                        
C30169*                                                                         
C30169******************************************************************        
C30169* 2600-GET-CR-XMPT-CD                                            *        
C30169*                                                                *07520000
C30169*     CALLED FROM 2300-BUILD-RESULT                              *        
C30169*                                                                *        
C30169*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C30169******************************************************************07550000
C30169*                                                                         
C30169 2600-GET-CR-XMPT-CD.                                             
C30169*                                                                         
C30169     MOVE WS-ACCOUNT-NO               TO YP-ACCOUNT-NO.           
C30169     MOVE 'CAEXEMPT'                  TO YP-ATTRIBUTE-DESC.       
C30169     PERFORM 7000-GET-ATTR-VAL        THRU 7000-EXIT.             
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        MOVE YP-ATTRIBUTE-VALUE-CD    TO RS-COLL-XMT              
C30169     ELSE                                                         
C30169        MOVE SPACES                   TO RS-COLL-XMT              
C30169        MOVE ZEROS                    TO RS-RETURN-CODE           
C30169     END-IF.                                                      
C30169     MOVE 'CBEXEMPT'                  TO YP-ATTRIBUTE-DESC.       
C30169     PERFORM 7000-GET-ATTR-VAL        THRU 7000-EXIT.             
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
C30169        MOVE YP-ATTRIBUTE-VALUE-CD    TO RS-CR-BUREAU-XMT         
C30169     ELSE                                                         
C30169        MOVE SPACES                   TO RS-CR-BUREAU-XMT         
C30169        MOVE ZEROS                    TO RS-RETURN-CODE           
C30169     END-IF.                                                      
C30169*                                                                         
C30169 2600-EXIT.                                                       
C30169     EXIT.                                                        
A00643*                                                                         
A00643******************************************************************        
A00643* 2700-GET-EBILL-PPRL-IND                                        *        
A00643*                                                                *07520000
A00643* GET EBILL AND PAPERLESS INDICATORS                             *        
A00643*                                                                *        
A00643******************************************************************07550000
A00643*                                                                         
A00643 2700-GET-EBILL-PPRL-IND.                                         
A00643*                                                                         
A00643     MOVE WS-ACCOUNT-NO               TO NF-ACCOUNT-NO            
A00643     PERFORM 7950-GET-PAPERLESS-IND   THRU 7950-EXIT.             
A00643     MOVE WS-PAPERLESS                TO RS-PAPERLESS-IND.        
A02365     MOVE WS-DEST-ID                  TO RS-DEST-ID.              
A00643     MOVE WS-ACCOUNT-NO               TO AT-ACCOUNT-NO            
A00643     PERFORM 7960-GET-EBILL-REG-IND   THRU 7960-EXIT.             
A00643     IF WS-ACTIVE-RETURN-CODE EQUAL NOT-FOUND                     
A00643        MOVE SPACES                   TO CE-EBILL-REGISTER-IND    
A00643     END-IF.                                                      
A00643     MOVE CE-EBILL-REGISTER-IND       TO RS-EBILL-REGISTER-IND.   
A00643*                                                                         
A00643 2700-EXIT.                                                       
A00643     EXIT.                                                        
M30169*                                                                         
C30169******************************************************************07491300
C30169* 7000-GET-CA-ATTR                                               *07492029
C30169*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C30169*                 9900-SQL-ERROR-ROUTINE                         *07510000
C30169*                                                                *07520000
C30169*     CALLED FROM 2600-GET-CR-XMPT-CD                            *        
C30169******************************************************************07550000
C30169 7000-GET-ATTR-VAL.                                               
C30169                                                                  
C30169     EXEC SQL                                                     
C30169         SELECT ATTRIBUTE_VALUE_CD                                
C30169           INTO :YP-ATTRIBUTE-VALUE-CD                            
C30169           FROM CSS_ACCT_ATTRIBUTE YP                             
C30169          WHERE ACCOUNT_NO     = :YP-ACCOUNT-NO                   
C30169            AND ATTRIBUTE_DESC = :YP-ATTRIBUTE-DESC               
C30169     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C30169                                                                  
C30169     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
C30169     MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE.             
C30169                                                                  
C30169     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C30169        NEXT SENTENCE                                             
C30169     ELSE                                                         
C30169        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C30169        MOVE '7000'                TO ACTIVE-PARAGRAPH            
C30169        MOVE 'SELECT'              TO ABEND-FUNCTION              
C30169        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C30169                                      ABEND-TABLES                
C30169        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C30169        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C30169        MOVE YP-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C30169        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C30169        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C30169     END-IF.                                                      
C30169                                                                  
C30169 7000-EXIT.                                                       
C30169     EXIT.                                                        
C30169                                                                  
C30169*                                                                         
      ******************************************************************07491300
      * 7300-SELECT-BILL-CODE                                          *07492029
      *     CALLS       9000-SEND-ERROR-RESULT                         *07500000
      *                 9900-SQL-ERROR-ROUTINE                         *07510000
      *                                                                *07520000
      *     CALLED FROM 2300-BUILD-RESULT                              *        
      *                                                                *        
      *     SELECT FROM CSS_ACCOUNT                                    *07530029
      ******************************************************************07550000
       7300-SELECT-BILL-CODE.                                           
                                                                        
           EXEC SQL                                                     
                SELECT CODE_PERM_BILL,                                  
                       CODE_TEMP_BILL,                                  
PCR549                 CREDIT_GROUP,                                    
T19272                 CODE_ACCT_BILLED,                                
P00471                 CODES_DATA_PRESENT                               
                INTO   :AT-CODE-PERM-BILL,                              
                       :AT-CODE-TEMP-BILL,                              
PCR549                 :AT-CREDIT-GROUP,                                
T19272                 :AT-CODE-ACCT-BILLED,                            
P00471                 :AT-CODES-DATA-PRESENT                           
                FROM CSS_ACCOUNT                                        
                WHERE ACCOUNT_NO   = :WS-ACCOUNT-NO                     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE.                
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
              MOVE '7300'                TO ACTIVE-PARAGRAPH            
              MOVE 'SELECT'              TO ABEND-FUNCTION              
              MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
              MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
              MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************07969900
T15268* 7400-SELECT-LOCK-BOX-NO                                        *07492029
T15268*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
T15268*                 9900-SQL-ERROR-ROUTINE                         *07510000
T15268*                                                                *07520000
T15268*     CALLED FROM 2300-BUILD-RESULT                              *        
T15268*                                                                *        
T15268*     SELECT FROM CSS_ACCT_MISC_INFO                             *07530029
T15268******************************************************************07550000
T15268 7400-SELECT-LOCK-BOX-NO.                                         
                                                                        
T15268     EXEC SQL                                                     
T15268          SELECT LOCK_BOX_NO                                      
T15268          INTO   :TA-LOCK-BOX-NO                                  
T15268          FROM CSS_ACCT_MISC_INFO                                 
T15268          WHERE ACCOUNT_NO   = :WS-ACCOUNT-NO                     
T15268     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
T15268     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
T15268     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T15268        NEXT SENTENCE                                             
T15268     ELSE                                                         
T15268        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
T15268        MOVE '7400'                TO ACTIVE-PARAGRAPH            
T15268        MOVE 'SELECT'              TO ABEND-FUNCTION              
T15268        MOVE SPACES                TO ABEND-SQL-PREDICATES        
                                            ABEND-TABLES                
T15268        MOVE 'CSS_ACCT_MISC_INFO'  TO TABLE-1                     
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
T15268        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
T15268        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T15268        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T15268     END-IF.                                                      
                                                                        
T15268 7400-EXIT.                                                       
T15268     EXIT.                                                        
C26296******************************************************************07969900
C26296* 7500-GET-DNP-EXMP-IND                                          *07492029
C26296*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C26296*                 9900-SQL-ERROR-ROUTINE                         *07510000
C26296*                                                                *07520000
C26296*     CALLED FROM 2300-BUILD-RESULT                              *        
C26296*                                                                *        
C26296*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C26296******************************************************************07550000
C26296 7500-GET-DNP-EXMP-IND.                                           
C26296                                                                  
C26296     EXEC SQL                                                     
C26296          SELECT  ATTRIBUTE_VALUE_CD                              
C26296            INTO  :YP-ATTRIBUTE-VALUE-CD                          
C26296            FROM  CSS_ACCT_ATTRIBUTE                              
C26296          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
C26296            AND ATTRIBUTE_DESC = :WS-DNP-EXMP-IND                 
C26296     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C26296        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C26296           MOVE SPACES             TO YP-ATTRIBUTE-VALUE-CD       
C26296        END-IF                                                    
C26296     ELSE                                                         
C26296        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C26296        MOVE '7500'                TO ACTIVE-PARAGRAPH            
C26296        MOVE 'SELECT'              TO ABEND-FUNCTION              
C26296        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C26296                                      ABEND-TABLES                
C26296        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C26296        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C26296        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C26296        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C26296        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C26296     END-IF.                                                      
C26296                                                                  
C26296 7500-EXIT.                                                       
C26296     EXIT.                                                        
C26296******************************************************************07969900
C26296* 7600-GET-RETURN-CHECK-CD                                       *07492029
C26296*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C26296*                 9900-SQL-ERROR-ROUTINE                         *07510000
C26296*                                                                *07520000
C26296*     CALLED FROM 2300-BUILD-RESULT                              *        
C26296*                                                                *        
C26296*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C26296******************************************************************07550000
C26296 7600-GET-RETURN-CHECK-CD.                                        
C26296                                                                  
C26296     EXEC SQL                                                     
C26296          SELECT  ATTRIBUTE_VALUE_CD                              
C26296            INTO  :YP-ATTRIBUTE-VALUE-CD                          
C26296            FROM  CSS_ACCT_ATTRIBUTE                              
C26296          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                   
C26296            AND ATTRIBUTE_DESC = :WS-RETURN-CHK-IND               
C26296     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C26296                                                                  
C26296     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C26296                                                                  
C26296     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C26296        IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
C26296           MOVE SPACES             TO YP-ATTRIBUTE-VALUE-CD       
C26296        END-IF                                                    
C26296     ELSE                                                         
C26296        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C26296        MOVE '7600'                TO ACTIVE-PARAGRAPH            
C26296        MOVE 'SELECT'              TO ABEND-FUNCTION              
C26296        MOVE SPACES                TO ABEND-SQL-PREDICATES        
C26296                                      ABEND-TABLES                
C26296        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C26296        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C26296        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C26296        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C26296        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C26296     END-IF.                                                      
C26296                                                                  
C26296 7600-EXIT.                                                       
C26296     EXIT.                                                        
C29533******************************************************************07969900
C29533* 7700-GET-EBILL-COPIES                                          *07492029
C29533*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C29533*                 9900-SQL-ERROR-ROUTINE                         *07510000
C29533*                                                                *07520000
C29533*     CALLED FROM 2300-BUILD-RESULT                              *        
C29533*                                                                *        
C29533*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C29533******************************************************************07550000
C29533 7700-GET-EBILL-COPIES.                                           
C29533                                                                  
C29533     EXEC SQL                                                     
C29533          SELECT NO_BILL_COPIES                                   
C29533                ,COMPANY_NO                                       
C29533            INTO :AT-NO-BILL-COPIES                               
C29533                ,:AT-COMPANY-NO                                   
C29533            FROM CSS_ACCOUNT                                      
C29533           WHERE ACCOUNT_NO        = :WS-ACCOUNT-NO               
C29533     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29533        MOVE '7800'                TO ACTIVE-PARAGRAPH            
C29533        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29533        MOVE 'CSS_ACCOUNT'         TO TABLE-1                     
C29533        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C29533        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C29533        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29533        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29533     END-IF.                                                      
C29533                                                                  
C29533 7700-EXIT.                                                       
C29533     EXIT.                                                        
C29533******************************************************************07969900
C29533* 7800-CHECK-ACCT-ATTRB                                          *07492029
C29533*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C29533*                 9900-SQL-ERROR-ROUTINE                         *07510000
C29533*                                                                *07520000
C29533*     CALLED FROM 2300-BUILD-RESULT                              *        
C29533*                                                                *        
C29533*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C29533******************************************************************07550000
C29533 7800-CHECK-ACCT-ATTRB.                                           
C29533                                                                  
C29533     EXEC SQL                                                     
C29533          SELECT 'Y'                                              
C29533            INTO :WS-NO-NOTIFICATION                              
C29533            FROM CSS_ATTRIBUTE WZ                                 
C29533                ,CSS_ACCT_ATTRIBUTE YP                            
C29533           WHERE YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
C29533             AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
C29533             AND WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
C29533             AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
C29533             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
C29533     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29533        MOVE '7800'                TO ACTIVE-PARAGRAPH            
C29533        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29533        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C29533        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C29533        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C29533        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29533        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29533     END-IF.                                                      
C29533                                                                  
C29533 7800-EXIT.                                                       
C29533     EXIT.                                                        
C29533******************************************************************07969900
C29533* 7900-CHECK-ATTRB                                               *07492029
C29533*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C29533*                 9900-SQL-ERROR-ROUTINE                         *07510000
C29533*                                                                *07520000
C29533*     CALLED FROM 2300-BUILD-RESULT                              *        
C29533*                                                                *        
C29533*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C29533******************************************************************07550000
C29533 7900-CHECK-ATTRB.                                                
C29533                                                                  
C29533     EXEC SQL                                                     
C29533          SELECT 'Y'                                              
C29533            INTO :WS-PAPER-ONLY                                   
C29533            FROM CSS_ATTRIBUTE WZ                                 
C29533                ,CSS_ACCT_ATTRIBUTE YP                            
C29533           WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
C29533             AND YP.ATTRIBUTE_DESC    = :YP-ATTRIBUTE-DESC        
C29533             AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
C29533             AND YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
C29533             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
C29533             AND WZ.ATTRIBUTE_TYPE_TX = :WS-ATTRIBUTE-TYPE        
C29533     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C29533                                                                  
C29533     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C29533                                                                  
C29533     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C29533        NEXT SENTENCE                                             
C29533     ELSE                                                         
C29533        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C29533        MOVE '7900'                TO ACTIVE-PARAGRAPH            
C29533        MOVE 'SELECT'              TO ABEND-FUNCTION              
C29533        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C29533        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C29533        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C29533        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C29533        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C29533     END-IF.                                                      
C29533                                                                  
C29533 7900-EXIT.                                                       
C29533     EXIT.                                                        
A00643******************************************************************07969900
A00643* 7950-GET-PAPERLESS-IND                                         *07492029
A00643*     SELECT FROM CSS_EDI_ACCT_DEST                              *07530029
A00643******************************************************************07550000
A00643 7950-GET-PAPERLESS-IND.                                          
A00643                                                                  
A00643     EXEC SQL                                                     
A00643          SELECT 'Y',                                             
A02365                 NF.DEST_ID                                       
A00643            INTO :WS-PAPERLESS,                                   
A02365                 :WS-DEST-ID                                      
A00643            FROM CSS_EDI_ACCT_DEST NF WITH(READUNCOMMITTED)               
A00643           WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                 
A00643             AND NF.STATUS_CD    = 'A'                            
A00643                                                           
A00643                                                      
A00643     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT 'Y',                                                     
MFA-TR*                NF.DEST_ID                                               
MFA-TR*           INTO :WS-PAPERLESS,                                           
MFA-TR*                :WS-DEST-ID                                              
MFA-TR*           FROM CSS_EDI_ACCT_DEST NF                                     
MFA-TR*          WHERE NF.ACCOUNT_NO   = :NF-ACCOUNT-NO                         
MFA-TR*            AND NF.STATUS_CD    = 'A'                                    
MFA-TR*            WITH UR                                                      
MFA-TR*            QUERYNO 7950                                                 
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00643                                                                  
A00643     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00643                                                                  
A00643     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00643        NEXT SENTENCE                                             
A00643     ELSE                                                         
A00643        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00643        MOVE '7950'                TO ACTIVE-PARAGRAPH            
A00643        MOVE 'SELECT'              TO ABEND-FUNCTION              
A00643        MOVE 'CSS_EDI_ACCT_DEST'   TO TABLE-1                     
A00643        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A00643        MOVE NF-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A00643        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A00643        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A00643     END-IF.                                                      
A00643                                                                  
A00643 7950-EXIT.                                                       
A00643     EXIT.                                                        
A00643                                                                  
A00643******************************************************************07969900
A00643* 7960-GET-EBILL-REG-IND                                         *07492029
A00643*     SELECT FROM CSS_CUST_STATS                                 *07530029
A00643******************************************************************07550000
A00643 7960-GET-EBILL-REG-IND.                                          
A00643                                                                  
A00643     EXEC SQL                                                     
A00643          SELECT TOP(1) EBILL_REGISTER_IND                               
A00643            INTO :CE-EBILL-REGISTER-IND                           
A00643            FROM CSS_CUST_STATS CE                                
A00643                ,CSS_ACCOUNT AT                                   
A00643           WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                
A00643             AND AT.CUSTOMER_NO   = CE.CUSTOMER_NO                
A00643             AND CE.CUSTOMER_TYPE = 'C'                           
A00643                                              
A00643     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ020
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT EBILL_REGISTER_IND                                       
MFA-TR*           INTO :CE-EBILL-REGISTER-IND                                   
MFA-TR*           FROM CSS_CUST_STATS CE                                        
MFA-TR*               ,CSS_ACCOUNT AT                                           
MFA-TR*          WHERE AT.ACCOUNT_NO    = :AT-ACCOUNT-NO                        
MFA-TR*            AND AT.CUSTOMER_NO   = CE.CUSTOMER_NO                        
MFA-TR*            AND CE.CUSTOMER_TYPE = 'C'                                   
MFA-TR*       FETCH FIRST ROW ONLY                                              
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

A00643                                                                  
A00643     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
A00643                                                                  
A00643     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
A00643        NEXT SENTENCE                                             
A00643     ELSE                                                         
A00643        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
A00643        MOVE '7960'                TO ACTIVE-PARAGRAPH            
A00643        MOVE 'SELECT'              TO ABEND-FUNCTION              
A00643        MOVE 'CSS_CUST_STATS'      TO TABLE-1                     
A00643        MOVE 'CSS_NAME_ACCT_XREF'  TO TABLE-1                     
A00643        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
A00643        MOVE AT-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
A00643        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
A00643        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
A00643     END-IF.                                                      
A00643                                                                  
A00643 7960-EXIT.                                                       
A00643     EXIT.                                                        
                                                                        
P00471******************************************************************07969900
P00471* 7970-GET-DPPDROP-XMPT-CD                                       *07492029
P00471*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
P00471*                 9900-SQL-ERROR-ROUTINE                         *07510000
P00471*                                                                *07520000
P00471*     CALLED FROM 2300-BUILD-RESULT                              *        
P00471*                                                                *        
P00471*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
P00471******************************************************************07550000
P00471 7970-GET-DPPDROP-XMPT-CD.                                        
P00471                                                                  
P00471     MOVE SPACES             TO YP-ATTRIBUTE-VALUE-CD             
P00471*                                                                         
P00471     EXEC SQL                                                     
P00471          SELECT  ATTRIBUTE_VALUE_CD                              
P00471            INTO  :YP-ATTRIBUTE-VALUE-CD                          
P00471            FROM  CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                
P00471           WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                  
P00471             AND ATTRIBUTE_DESC = :WS-DPPDROP-XMPT-IND            
P00471                                                           
P00471                                                      
P00471     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT  ATTRIBUTE_VALUE_CD                                      
MFA-TR*           INTO  :YP-ATTRIBUTE-VALUE-CD                                  
MFA-TR*           FROM  CSS_ACCT_ATTRIBUTE                              07930211
MFA-TR*          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                  07930314
MFA-TR*            AND ATTRIBUTE_DESC = :WS-DPPDROP-XMPT-IND            07930411
MFA-TR*         WITH UR                                                 07930411
MFA-TR*         QUERYNO 7970                                            07930411
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00471                                                                  
P00471     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00471                                                                  
P00471     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00471        NEXT SENTENCE                                             
P00471     ELSE                                                         
P00471        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00471        MOVE '7970'                TO ACTIVE-PARAGRAPH            
P00471        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00471        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00471                                      ABEND-TABLES                
P00471        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
P00471        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00471        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00471        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00471        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00471     END-IF.                                                      
P00471                                                                  
P00471 7970-EXIT.                                                       
P00471     EXIT.                                                        
                                                                        
P00773******************************************************************07969900
P00773* 7980-GET-REVIEW-EXEMPT-FL                                      *07492029
P00773*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
P00773*                 9900-SQL-ERROR-ROUTINE                         *07510000
P00773*                                                                *07520000
P00773*     CALLED FROM 2300-BUILD-RESULT                              *        
P00773*                                                                *        
P00773*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
P00773******************************************************************07550000
P00773 7980-GET-REVIEW-EXEMPT-FL.                                       
P00773                                                                  
P00773     MOVE 'N'                TO YP-ATTRIBUTE-VALUE-CD.            
P00773                                                                  
P00773     EXEC SQL                                                     
P00773          SELECT  ATTRIBUTE_VALUE_CD                              
P00773            INTO  :YP-ATTRIBUTE-VALUE-CD                          
P00773            FROM  CSS_ACCT_ATTRIBUTE WITH(READUNCOMMITTED)                
P00773           WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                  
P00773             AND ATTRIBUTE_DESC = 'REVIEW EXEMPT'                 
P00773                                                           
P00773                                                      
P00773     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                     07922011
MFA-TR*         SELECT  ATTRIBUTE_VALUE_CD                                      
MFA-TR*           INTO  :YP-ATTRIBUTE-VALUE-CD                                  
MFA-TR*           FROM  CSS_ACCT_ATTRIBUTE                              07930211
MFA-TR*          WHERE ACCOUNT_NO     = :WS-ACCOUNT-NO                  07930314
MFA-TR*            AND ATTRIBUTE_DESC = 'REVIEW EXEMPT'                 07930411
MFA-TR*         WITH UR                                                 07930411
MFA-TR*         QUERYNO 7980                                            07930411
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00773                                                                  
P00773     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00773                                                                  
P00773     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
P00773        NEXT SENTENCE                                             
P00773     ELSE                                                         
P00773        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
P00773        MOVE '7980'                TO ACTIVE-PARAGRAPH            
P00773        MOVE 'SELECT'              TO ABEND-FUNCTION              
P00773        MOVE SPACES                TO ABEND-SQL-PREDICATES        
P00773                                      ABEND-TABLES                
P00773        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
P00773        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
P00773        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
P00773        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
P00773        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
P00773     END-IF.                                                      
P00773                                                                  
P00773 7980-EXIT.                                                       
P00773     EXIT.                                                        
                                                                        
C31813******************************************************************07969900
C31813* 8000-CHK-DELINQUENCY                                           *07492029
C31813*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C31813*                 9900-SQL-ERROR-ROUTINE                         *07510000
C31813*                                                                *07520000
C31813*     CALLED FROM 2300-BUILD-RESULT                              *        
C31813*                                                                *        
C31813*     SELECT FROM CSS_DELINQUENCY                                *07530029
C31813******************************************************************07550000
C31813 8000-CHK-DELINQUENCY.                                            
C31813                                                                  
C31813     EXEC SQL                                                     
C31813          SELECT DELINQ_VALUE                                     
C31813            INTO :C8-DELINQ-VALUE                                 
C31813            FROM CSS_DELINQUENCY                                  
C31813           WHERE DELINQ_CD            = 'ARC-IND-INVALID'         
C31813             AND COMPANY_NO           = '01'                      
C31813     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31813                                                                  
C31813     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31813                                                                  
C31813     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C31813        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C31813           MOVE WS-N             TO WS-ARC-VALID                  
C31813        ELSE                                                      
C31813           MOVE WS-Y             TO WS-ARC-VALID                  
C31813        END-IF                                                    
C31813     ELSE                                                         
C31813        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C31813        MOVE '8000'                TO ACTIVE-PARAGRAPH            
C31813        MOVE 'SELECT'              TO ABEND-FUNCTION              
C31813        MOVE 'CSS_DELINQUENCY'     TO TABLE-1                     
C31813        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C31813        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C31813     END-IF.                                                      
C31813                                                                  
C31813 8000-EXIT.                                                       
C31813     EXIT.                                                        
                                                                        
C31813******************************************************************07969900
C31813* 8100-CHK-ARC-IND                                               *07492029
C31813*     CALLS       9000-SEND-ERROR-RESULT                         *07500000
C31813*                 9900-SQL-ERROR-ROUTINE                         *07510000
C31813*                                                                *07520000
C31813*     CALLED FROM 2300-BUILD-RESULT                              *        
C31813*                                                                *        
C31813*     SELECT FROM CSS_ACCT_ATTRIBUTE                             *07530029
C31813******************************************************************07550000
C31813 8100-CHK-ARC-IND.                                                
C31813                                                                  
C31813     EXEC SQL                                                     
C31813          SELECT 'Y'                                              
C31813            INTO :WS-ROW-EXIST                                    
C31813            FROM CSS_ATTRIBUTE WZ                                 
C31813                ,CSS_ACCT_ATTRIBUTE YP                            
C31813           WHERE WZ.ATTRIBUTE_DESC    = YP.ATTRIBUTE_DESC         
C31813             AND YP.ATTRIBUTE_DESC    = 'CONVERT_CHK_ELEC'        
C31813             AND WZ.COMPANY_NO        = :AT-COMPANY-NO            
C31813             AND YP.ACCOUNT_NO        = :WS-ACCOUNT-NO            
C31813             AND WZ.ATTRIBUTE_STAT_CD = 'A'                       
C31813             AND WZ.ATTRIBUTE_TYPE_TX = 'ARC'                     
C31813     END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

C31813                                                                  
C31813     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
C31813                                                                  
C31813     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
C31813        IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                
C31813           MOVE WS-N               TO RS-ARC-IND                  
C31813        ELSE                                                      
C31813           MOVE WS-Y               TO RS-ARC-IND                  
C31813        END-IF                                                    
C31813     ELSE                                                         
C31813        MOVE PROGRAM-NAME          TO ABEND-PROGRAM               
C31813        MOVE '8100'                TO ACTIVE-PARAGRAPH            
C31813        MOVE 'SELECT'              TO ABEND-FUNCTION              
C31813        MOVE 'CSS_ACCT_ATTRIBUTE'  TO TABLE-1                     
C31813        MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-1             
C31813        MOVE WS-ACCOUNT-NO         TO HOSTVAR-ELEMENT-1           
C31813        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
C31813        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
C31813     END-IF.                                                      
C31813                                                                  
C31813 8100-CHK-EXIT.                                                   
C31813     EXIT.                                                        
                                                                        
      ******************************************************************07969900
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                     07970000
      ******************************************************************07970100
           EXEC SQL                                                     07970200
REARCH        INCLUDE CPDSP300                                                  
REARCH*       INCLUDE CPD00300                                          07971000
           END-EXEC.                                                    07980000
                                                                        
      ******************************************************************08000000
      *       END PROGRAM COPYLIB                                      *08010000
      ******************************************************************08020000
REARCH     EXEC SQL                                                             
REARCH         INCLUDE CPD00321                                                 
REARCH     END-EXEC.                                                            
REARCH*    COPY CPD00302.                                                       
