       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.   CSR02350.                                          
COB303 DATE-WRITTEN.     APR  16, 1997.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      *  THIS PROGRAM IS EXECUTED VIA A REMOTE PROCEDURE CALL (RPC).   *        
      *                                                                *        
      *  TRANID:        S350                                           *        
      *  PROGRAM:       S350                                           *        
      *  CALLING SP:    PA_S350                                        *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM IS A REMOTE PROCEDURE CALL MADE FROM             *        
      *  DESKTOP 2000 VIA THE SYBASE NETGATEWAY.                       *        
      *  THIS PROGRAM UPDATES THE CIA DISTRIBUTION PANEL (PANEL487).   *        
      *                                                                *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/16/97  CHANDRA    PROCEDURE ORIGINALLY CODED               *        
      *  11/03/97  PD         ADD GL NO TO PARAMETER LIST AND DO       *        
      *                       MISC DEBIT.                              *        
T15804*  04/07/98  PD         WHEN ADDING CHARGE TRAN TYPE SHOULD BE S *        
PCR640*   07/01/98     KLP   PCR640 CHANGES. CHECK FOR AR-LOCKOUT BEFOR*        
      *                      PROCEDING                                 *        
T17129*   08/04/98  SV       ADD ACCOUNTING PERIOD TO PANEL 487.       *        
T17754*   09/21/98  SV       INSERT CSS_CONNECT_CHRG WHEN SETTING UP RCC        
T17642*   09/28/98  SV       TO UPDATE TRAN COMMENTS IN AR_TRANS_HIST  *        
T18186*   10/22/98  SV       UPDATE AR_CNTL CORRECTLY WHEN DEBITING RCC*        
      *                      ADVANCE COLLECTION                        *        
T18451*   11/30/98  SV       HANDLE UNUSED CREDIT (IF EXISTS) FOR PPL'S         
      *                      < 50 WHEN DEBITING THE ACCOUNT            *        
CBSI  *  12/31/98   CBSI      ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *             MADRAS    ABEND PARAMETERS                         *        
T18773*   01/14/99  SV       UPDATE AR_CNTL CORRECTLY WHEN DEBITING CNT*        
T18873*   01/15/99  SV       USE ALLOCATION % FROM CSS_LOCAL_OFFICE TO          
      *                      DECIDE THE RCNT_TYPE_NO OF CSS_CONNECT_CHRG        
T20669*   09/10/99  KSB      DO NOT CHANGE STATUS OF CONTRACT TO PAID           
      *                      IF AMT-MO-PYMT = 9999.99                           
T21115*  11/29/99   CBSI      CALL SUB ROUTINE SCSCA182 AND CHECK IF   *        
T21115*             MADRAS    THE PARM-LAST-UPDATE-TS AND THE ONE      *        
T21115*                       OBTAINED FROM THE SUB ROUTINE ARE SAME,  *        
T21115*                       IF THEY ARE SAME UPDATES AR_CNTL ELSE    *        
T21115*                       SENDS ERROR MSG TO THE PANEL             *        
T24436** 08/10/01  COVANSYS   COPYBOOK CPD00061 CHANGED TO SUB        **        
T24436**           CHENNAI    PROGRAM  SCSCO061.                      **        
C26130*  06/28/02  SRIDEVI    SETTING WS-CODE-BUDGET WHEN PYMT PRTY LVL         
C26130*                       IS 50 AS AGAINST WS-CODE-EPP-OFFER      **        
C23844*  03/17/03  BB18179    SETTING USER-ID TO SYSTEM FOR SERVICE    *        
      *                       CARE CONVERSION CALLS (VIA TCL PROGRAM). *        
      *                       ADDITIONALLY, SETTING APPL_PROGRAM_ID TO *        
      *                       PANEL487B FOR BILL PRINT LINE ITEM DESC. *        
C28322*  06/07/03  BB18179    SETTING USER-ID TO SYSTEM FOR EMC XFER.  *        
REARCH*  10/10/05  CVNS       RPC TO COBOL SP CONVERSION               *        
REARCH*            CHENNAI                                             *        
C33832*  03/06/07  JS83520    ADD DROPDOWN FOR CONTRACTS TO INDICATE   *        
C33832*                       PRINCIPAL OR PAYOFF                      *        
C36956*  11/05/08  VP94820    BUDGET BILLING CHANGES                   *        
A00956*  03/26/09  CVNS       REPLACE CPD00006 WITH CPD0006A.          *        
A00956*            CHENNAI                                             *        
P00253*  03/29/10  VP94820    USE NEW APPL PGM ID FOR REV PROTECTION   *        
P00253*                       CHARGES.                                 *        
P00253*  07/15/10  AA97148    USE NEW APPL PGM ID FOR REV PROTECTION   *        
P00253*                       MISC DEBITS.                             *        
P00453*  04/05/11  AA97148    MODIFY THE PROGRAM TO USE PYMT PRTY LVL  *        
P00453*                       50 FOR PAY-AND-GO ACCOUNTS ALSO.         *        
P00453*  05/18/11  AA97148    REPLACED 'PAG' WITH 'PRP AND 'PAY-AND-GO'*        
P00453*                       WITH 'PRE-PAY-PLAN'.                     *        
P00794*  07/14/14  SS7F226    ADDED LOGIC FOR PSNC AND SEB TO INSERT   *        
P00794*                       'RECCHGTAX' AS FACTOR ID INTO FIXED_FCTR *        
P00794*                       AND INSERT FCTOR AND DURTION IN MNT TBLS *        
ACT087*  04/10/15  VIJAY      FIX CODE TO CREATE FACTOR ONLY FOR RCC   *        
ACT180*  09/18/15  VIJAY      DO NOT PROCESS FOR MASTER ACCOUNTS.      *        
ACT180*  A05136               DO NOT PROCESS FOR MASTER ACCOUNTS.      *        
P00774*  05/13/16  VENKAT.P   GET USER ID VIA INPUT PARM.              *        
ACT201*  06/27/16  SS7F226    CHANGES TO HANDLE NULL EXCEPTION(7650-)  *        
ACT201*             A05460    ON CSS_BILL_WINDOW FOR WEEK END/HOLIDAYS.*        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02350'.
MSQ017     COPY MFASQLM.
                                                                        
       01  WS-START                                   PIC X(40) VALUE   
REARCH     'WORKING STORAGE FOR CSR02350 STARTS HERE'.                  
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBACCT                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARTYPE                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHIST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARHDT                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDEPHST                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDEPREQ                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFARCV                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTINF                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBJCNTL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBBTJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMSJRNL                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCDJRNL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCDCNTL                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBUSRPRF                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBGLATNO                                                  
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBPREM                                                    
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
             INCLUDE TBCUST                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE TBMODEL                                                   
           END-EXEC.                                                            
                                                                        
PCR640     EXEC SQL                                                             
              INCLUDE TBARLOCK                                                  
           END-EXEC.                                                            
                                                                        
T17754     EXEC SQL                                                     01020000
              INCLUDE TBCCCHRG                                          01030000
           END-EXEC.                                                    01040000
T17754                                                                  
                                                                        
T18873     EXEC SQL                                                     01020000
              INCLUDE TBLOCOFC                                          01030000
           END-EXEC.                                                    01040000
T18873                                                                  
P00794******************************************************************        
P00794*  CSS_FIXED_FCTR.       FF                                      *        
P00794******************************************************************        
P00794     EXEC SQL                                                             
P00794         INCLUDE TBFXDFCT                                                 
P00794     END-EXEC.                                                            
P00794*                                                                         
P00794*****************************************************************         
P00794* CSS_MNT_TRANS_HIST     MH                                     *         
P00794*****************************************************************         
P00794     EXEC SQL                                                             
P00794        INCLUDE TBMNHIST                                                  
P00794     END-EXEC.                                                            
P00794*                                                                         
P00794*****************************************************************         
P00794* CSS_MT_TRN_HST_DET     MI                                     *         
P00794*****************************************************************         
P00794*                                                                         
P00794     EXEC SQL                                                             
P00794        INCLUDE TBMNHDT                                                   
P00794     END-EXEC.                                                            
P00794*                                                                         
P00794******************************************************************        
P00794*  CSS_BILL_WINDOW.      BN                                      *        
P00794******************************************************************        
P00794     EXEC SQL                                                             
P00794         INCLUDE TBBILWDW                                                 
P00794     END-EXEC.                                                            
P00794*                                                                         
P00794*****************************************************************         
P00794* CSS_DELINQUENCY        C8                                     *         
P00794*****************************************************************         
P00794     EXEC SQL                                                     01460000
P00794       INCLUDE TBDELQ                                             01470000
P00794     END-EXEC.                                                    01480000
P00794*                                                                         
P00794*****************************************************************         
P00794* CSS_UTIL_ENVRNMT       UT                                     *         
P00794*****************************************************************         
P00794     EXEC SQL                                                     01500000
P00794       INCLUDE TBUTLENV                                           01510000
P00794     END-EXEC.                                                    01520000
P00794*                                                                 01530000
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
REARCH*    COPY SYGWCOB.                                                        
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
REARCH*    COPY SYDBCOB.                                                        
                                                                        
      *--------<COMMON SYSTEM AREA >                                            
           COPY CCA00001.                                                       
                                                                        
      *--------< ERROR HANDLING >                                               
REARCH*    COPY CWS00010.                                                       
REARCH     EXEC SQL                                                             
REARCH       INCLUDE CWSX0010                                                   
REARCH     END-EXEC.                                                            
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
           COPY CWS00056.                                                       
                                                                        
           EXEC SQL                                                             
A00956        INCLUDE CWS0013B                                                  
           END-EXEC.                                                            
                                                                        
           COPY CWS00061.                                                       
T24436     COPY CWS0061L.                                                       
           COPY CJF00101.                                                       
                                                                        
       01  WS-CSR-VARIABLES.                                            
           05 WS-CSR-PYMT-PRIORITY-LVL PIC S9(4) USAGE COMP.            
           05 WS-CSR-ITEM-ID           PIC S9(9) USAGE COMP.            
COB305     05 WS-CSR-AMT-DAY-00        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-AMT-DAY-30        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-AMT-DAY-60        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-AMT-DAY-90        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-UNUSED-CR        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-FULL-BALANCE        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-ORIG-BALANCE        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-CSR-STATUS-CODE       PIC X(1)  VALUE SPACE.           
           05 WS-CSR-STATUS-CODE-DESC  PIC X(11) VALUE SPACES.          
           05 WS-CSR-SOURCE-TBL        PIC X(15) VALUE SPACES.          
COB305     05 WS-CSR-BILL-BALANCE        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-CSR-RECV-TYPE         PIC X(3)  VALUE SPACES.          
           05 WS-CSR-RECV-TYPE-DESC    PIC X(25) VALUE SPACES.          
      *                                                                         
       01  WS-PAR-LITERALS.                                             
           05  WS-VALUE-4              PIC S9(04) COMP VALUE +4.        
           05  WS-VALUE-6              PIC S9(04) COMP VALUE +6.        
           05  WS-VALUE-19             PIC S9(04) COMP VALUE +19.       
           05  WS-VALUE-20             PIC S9(04) COMP VALUE +20.       
           05  WS-VALUE-29             PIC S9(04) COMP VALUE +29.       
           05  WS-VALUE-30             PIC S9(04) COMP VALUE +30.       
           05  WS-VALUE-39             PIC S9(04) COMP VALUE +39.       
           05  WS-VALUE-40             PIC S9(04) COMP VALUE +40.       
           05  WS-VALUE-45             PIC S9(04) COMP VALUE +45.       
           05  WS-VALUE-50             PIC S9(04) COMP VALUE +50.       
           05  WS-VALUE-60             PIC S9(04) COMP VALUE +60.       
           05  WS-VALUE-68             PIC S9(04) COMP VALUE +68.       
           05  WS-VALUE-70             PIC S9(04) COMP VALUE +70.       
           05  WS-VALUE-75             PIC S9(04) COMP VALUE +75.       
           05  WS-VALUE-80             PIC S9(04) COMP VALUE +80.       
           05  WS-VALUE-90             PIC S9(04) COMP VALUE +90.       
           05  WS-VALUE-100            PIC S9(04) COMP VALUE +100.      
           05  WS-VALUE-110            PIC S9(04) COMP VALUE +110.      
           05  WS-VALUE-129            PIC S9(04) COMP VALUE +129.      
           05  WS-VALUE-999            PIC S9(04) COMP VALUE +999.      
REARCH     05  WS-SUBROUTINE-IDS.                                       
REARCH         10  MCSCA182              PIC X(8) VALUE 'MCSCA182'.     
REARCH         10  MCSCO061              PIC X(8) VALUE 'MCSCO061'.     
      *                                                                         
       01  WS-MISC.                                                     
           05 WS-A                      PIC  X(01) VALUE 'A'.           
           05 WS-B                      PIC  X(01) VALUE 'B'.           
           05 WS-D                      PIC  X(01) VALUE 'D'.           
           05 WS-E                      PIC  X(01) VALUE 'E'.           
           05 WS-USER-ID                PIC  X(08) VALUE SPACES.        
           05 WS-YES                    PIC  X(03) VALUE 'YES'.         
           05 WS-998                    PIC  X(03) VALUE '998'.         
           05 WS-100                    PIC S9(03) VALUE +100.          
           05 WS-01                     PIC  X(02) VALUE '01'.          
           05 WS-SUB                    PIC  S9(04) COMP VALUE +0.      
REARCH     05 PROGRAM-NAME              PIC  X(8)  VALUE 'CSR02350'.    
REARCH     05 WS-SQLSTATE               PIC  X(05) VALUE '     '.       
           05 WS-ACCOUNT-NO             PIC  X(13).                     
           05 WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                 
                                        PIC  9(13).                     
           05 WS-ACCOUNT-NO-COMP3       PIC S9(13) COMP-3 VALUE +0.     
                                                                        
           05 WS-PAYMENT-BREAKDOWN.                                     
              10  WS-RECV-TYPE          PIC  X(03).                     
              10  WS-ITEM-ID            PIC  X(09).                     
              10  WS-AMT-DIR-PYMT       PIC  X(11).                     
              10  WS-AMT-DIR-PYMT-NUM   REDEFINES WS-AMT-DIR-PYMT       
                                        PIC  S9(09)V99.                 
              10  WS-INPUT-GL-NO        PIC  X(07).                     
              10  WS-INPUT-GL-NO-NUM    REDEFINES WS-INPUT-GL-NO        
                                        PIC  S999V9999.                 
C33832        10  WS-CNT-PAY-AHEAD      PIC  X(01).                     
C33832     05 WS-CNT-PRINCPL-PAYOFF     PIC  X(01) VALUE SPACES.        
           05 WS-CURR-ACCOUNT-NUM       PIC  S9(13) COMP-3 VALUE +0.    
           05 WS-CURR-RECEIVABLE-TYPE   PIC  X(03).                     
           05 WS-CURR-PYMT-PRIORITY-LVL PIC  S9(4) USAGE COMP.          
           05 WS-CURR-ITEM-ID           PIC  S9(9) USAGE COMP.          
           05 WS-CURR-CORR-AMT          PIC  S9(09)V99 USAGE COMP-3     
                                                       VALUE ZERO.      
           05 WS-REM-DEP-CORR-AMT       PIC  S9(09)V99 USAGE COMP-3     
                                                       VALUE ZERO.      
           05 WS-CURR-INPUT-GL-NO       PIC  S999V9999 USAGE COMP-3     
                                                       VALUE ZERO.      
           05 WS-CURRENT-TIMESTAMP      PIC X(26).                      
           05 WS-CURRENT-DATE           PIC X(10).                      
           05 WS-EPP-OFFER-DATE-NI      PIC S9(04) COMP VALUE ZERO.     
           05 WS-DATE-ORIG-PYMT-IND     PIC S9(04) COMP VALUE +0.       
           05 WS-DR-NULL-IND-1          PIC S9(04) COMP VALUE +0.       
           05 WS-DR-NULL-IND-2          PIC S9(04) COMP VALUE +0.       
           05 WS-DR-NULL-IND-3          PIC S9(04) COMP VALUE +0.       
           05 WS-DEP-CERT-NULL-IND      PIC S9(04) COMP VALUE +0.       
           05 WS-AR-AMT-ORIG-ENTERED    PIC S9(9)V9(2) USAGE COMP-3     
                                                       VALUE ZERO.      
T17129     05  WS-PAR-ACCT-PERIOD       PIC S9(06) COMP-3 VALUE +0.     
T17754     05  WS-NULL-DATE-CCC-BILLED  PIC S9(04) COMP.                
T18186     05  WS-AMT-TRAN-BALANCE    PIC S9(9)V99 USAGE COMP-3 VALUE 0.
T18186     05  WS-AMT-AR-DAY-00       PIC S9(9)V99 USAGE COMP-3 VALUE 0.
T18451     05  WS-DIFF-AMT            PIC S9(9)V99 USAGE COMP-3 VALUE 0.
CBSI       05  WS-AMT-TRAN-BALANCE-ED PIC -(9)9.99 .                    
CBSI       05  WS-AC-AMT-AR-DAY-00-ED PIC -(9)9.99 .                    
CBSI       05  WS-DV-AMT-DAY-00-ED    PIC -(9)9.99 .                    
CBSI       05  WS-AC-AMT-UNUSED-CR-ED PIC -(9)9.99 .                    
CBSI       05  WS-DP-DEP-PAY-AMT-ED   PIC -(9)9.99 .                    
CBSI       05  WS-AT-TOTAL-AR-BALANCE-ED PIC -(9)9.99 .                 
CBSI       05  WS-AR-AMT-ORIG-ENTERED-ED PIC -(9)9.99 .                 
CBSI       05  WS-AC-AMT-TRAN-BALANCE-ED PIC -(9)9.99 .                 
T21115     05  WS-LAST-UPDATE-TS       PIC X(26).                       
T24436     05  WS-EIBRESP              PIC S9(8) COMP SYNC VALUE ZERO.  
P00794     05  WS-DATABASE             PIC 9(01) VALUE ZERO.            
P00794         88 CSR-DATABASE                   VALUE 1.               
P00794         88 SEB-DATABASE                   VALUE 2.               
P00794     05  WS-COMPANY-NO           PIC X(02) VALUE '  '.            
P00794         88 SCEG                           VALUE '01'.            
P00794         88 PSNC                           VALUE '26'.            
P00794     05  WS-REVENUE-MONTH        PIC X(06).                       
P00794     05  FILLER REDEFINES WS-REVENUE-MONTH.                       
P00794         10  WS-REVMTH-CCYY      PIC 9(04).                       
P00794         10  WS-REVMTH-MM        PIC 9(02).                       
P00794     05 WS-RCC-COMMENT           PIC X(50) VALUE                  
P00794         'INSERT RCC - CHARGE AMOUNT TO BE TAXED ONLY.'.          
P00794     05  WS-FACT-VAL-Z           PIC -Z(09).9(06).                
P00794     05  WS-FACTOR-TEXT          PIC 9(9).9(6).                   
P00794     05  WS-NULL-IND-FF          PIC S9(04) COMP VALUE 0.         
P00794     05  WS-NULL-VALUE           PIC S9(04) COMP VALUE 0.         
P00794     05  WS-EFF-DATE-FROM.                                        
P00794         10  WS-EFF-DATE-FROM-YYYY PIC X(4) VALUE SPACES.         
P00794         10  WS-DASH-1             PIC X(1) VALUE '-'.            
P00794         10  WS-EFF-DATE-FROM-MM   PIC X(2) VALUE SPACES.         
P00794         10  WS-DASH-2             PIC X(1) VALUE '-'.            
P00794         10  WS-EFF-DATE-FROM-DD   PIC X(2) VALUE '01'.           
      *                                                                         
       01  WS-GL-PPL-TABLE.                                             
           05  WS-PPL-AR-TYPE-NSC       PIC S9(4) COMP VALUE  +019.     
           05  WS-PPL-AR-TYPE-NSA       PIC S9(4) COMP VALUE  +020.     
           05  WS-PPL-AR-TYPE-NSN       PIC S9(4) COMP VALUE  +029.     
           05  WS-PPL-AR-TYPE-LPC       PIC S9(4) COMP VALUE  +030.     
           05  WS-PPL-AR-TYPE-LPN       PIC S9(4) COMP VALUE  +039.     
           05  WS-PPL-AR-TYPE-UTE       PIC S9(4) COMP VALUE  +040.     
           05  WS-PPL-AR-TYPE-UTG       PIC S9(4) COMP VALUE  +045.     
           05  WS-PPL-AR-TYPE-EPP       PIC S9(4) COMP VALUE  +050.     
           05  WS-PPL-AR-TYPE-RCC       PIC S9(4) COMP VALUE  +060.     
           05  WS-PPL-AR-TYPE-CIA       PIC S9(4) COMP VALUE  +070.     
           05  WS-PPL-AR-TYPE-DEP       PIC S9(4) COMP VALUE  +080.     
           05  WS-PPL-AR-TYPE-DFA       PIC S9(4) COMP VALUE  +090.     
           05  WS-PPL-AR-TYPE-DPP       PIC S9(4) COMP VALUE  +090.     
           05  WS-PPL-AR-TYPE-CNT       PIC S9(4) COMP VALUE  +100.     
           05  WS-PPL-AR-TYPE-RVC       PIC S9(4) COMP VALUE  +110.     
           05  WS-PPL-AR-TYPE-PJS       PIC S9(4) COMP VALUE  +129.     
           05  WS-PPL-AR-TYPE-ADJ       PIC S9(4) COMP VALUE  +999.     
      *                                                                         
       01  SWITCHES.                                                    
           05  WS-NSC-DONE-IND          PIC X(01) VALUE 'N'.            
               88 NSC-ROW-NOT-SEND                VALUE 'N'.            
               88 NSC-ROW-SEND                    VALUE 'Y'.            
      *                                                                         
           05  ALL-DONE-SW              PIC X(01) VALUE 'N'.            
               88 NOT-ALL-DONE                    VALUE 'N'.            
               88 ALL-DONE                        VALUE 'Y'.            
      *                                                                         
           05  SEND-DONE-SW             PIC X(01) VALUE 'Y'.            
               88 SEND-DONE-ERROR                 VALUE 'N'.            
               88 SEND-DONE-OK                    VALUE 'Y'.            
      *                                                                         
           05  JRNL-DONE-SW             PIC X(01) VALUE 'N'.            
               88 DEBIT-JRNL-DONE                 VALUE 'Y'.            
               88 DEBIT-JRNL-NOT-DONE             VALUE 'N'.            
C33832*                                                                         
C33832     05  CNT-PRINCPL-PAYOFF-SW    PIC X(01) VALUE 'N'.            
C33832         88 CNT-PRINCPL-PAYOFF              VALUE 'Y'.            
C33832         88 NO-CNT-PRINCPL-PAYOFF           VALUE 'N'.            
      *                                                                         
C23844     05  SERV-CARE-CONV-SW        PIC X(01) VALUE 'N'.            
C23844         88 SERV-CARE-CONVERSION            VALUE 'Y'.            
HPCCDM*    EJECT                                                                
      *                                                                         
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  GTT-NAME                PIC X(26) VALUE                  
REARCH                                     'SESSION.CSR02350_R1'.       
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN          PIC S9(04) COMP.                 
REARCH         49 GTT-ROW-CHAR         PIC X(1024).                     
REARCH     05  GTT-SQLCODE             PIC S9(9) COMP.                  
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC  X(13).                      
REARCH     05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO-TEMP       
REARCH                                 PIC  9(13).                      
REARCH     05  PARM-CIA-DEBIT-AMT-TEMP PIC  X(11).                      
REARCH     05  PARM-CIA-DEBIT-AMT-NUM  REDEFINES                        
REARCH         PARM-CIA-DEBIT-AMT-TEMP PIC  S9(09)V99.                  
REARCH     05  PARM-GL-ACCT-NO-TEMP    PIC  X(07).                      
REARCH     05  PARM-GL-ACCT-NO-NUM     REDEFINES                        
REARCH         PARM-GL-ACCT-NO-TEMP    PIC  S9(03)V9999.                
REARCH     05  PARM-ACCTING-PERIOD-TMP PIC  X(06).                      
REARCH     05  PARM-ACCTING-PERIOD-NUM REDEFINES                        
REARCH         PARM-ACCTING-PERIOD-TMP PIC  S9(06).                     
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
       01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE           PIC S9(9)  COMP VALUE   0.      
            05 RS-ERROR-MESSAGE1        PIC X(05)  VALUE 'NOERR'.       
            05 RS-ERROR-MESSAGE2        PIC X(05)  VALUE 'NOERR'.       
            05 RS-ERROR-MESSAGE3        PIC X(05)  VALUE 'NOERR'.       
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH      05 S-RETURN-CODE            PIC S9(9)  COMP VALUE   0.      
REARCH      05 S-ERROR-MESSAGE1         PIC X(05)  VALUE 'NOERR'.       
REARCH      05 S-ERROR-MESSAGE2         PIC X(05)  VALUE 'NOERR'.       
REARCH      05 S-ERROR-MESSAGE3         PIC X(05)  VALUE 'NOERR'.       
                                                                        
T21115 COPY CWS00182.                                                           
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                     
                 DECLARE DEP-PAY-HIST CURSOR FOR                        
                 SELECT   ACCOUNT_NO                                    
                        , DEPOSIT_CERT_NO                               
                        , DEP_PAY_DT                                    
                        , DEP_PAY_AMT                                   
                   FROM   CSS_DEP_PAY_HST WITH(READUNCOMMITTED)                 
                  WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO            
                    AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO       
                  ORDER BY DEP_PAY_DT DESC                              
P00453              FOR READ ONLY                               
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DECLARE DEP-PAY-HIST CURSOR FOR                                
MFA-TR*          SELECT   ACCOUNT_NO                                            
MFA-TR*                 , DEPOSIT_CERT_NO                                       
MFA-TR*                 , DEP_PAY_DT                                            
MFA-TR*                 , DEP_PAY_AMT                                           
MFA-TR*            FROM   CSS_DEP_PAY_HST                                       
MFA-TR*           WHERE   ACCOUNT_NO        = :DP-ACCOUNT-NO                    
MFA-TR*             AND   DEPOSIT_CERT_NO   = :DP-DEPOSIT-CERT-NO               
MFA-TR*           ORDER BY DEP_PAY_DT DESC                                      
MFA-TR*             FOR FETCH ONLY WITH UR                                      
MFA-TR*         QUERYNO 7300                                                    
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH 01 PARM-ACCOUNT-NO         PIC  X(13).                           
REARCH 01 PARM-CIA-DEBIT-AMT      PIC  X(11).                           
REARCH 01 PARM-GL-ACCT-NO         PIC  X(07).                           
REARCH 01 PARM-NO-ROWS            PIC  S9(04) COMP.                     
C33832 01 PARM-DIR-PAY-1          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-2          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-3          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-4          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-5          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-6          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-7          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-8          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-9          PIC  X(31).                           
C33832 01 PARM-DIR-PAY-10         PIC  X(31).                           
C33832 01 PARM-DIR-PAY-11         PIC  X(31).                           
C33832 01 PARM-DIR-PAY-12         PIC  X(31).                           
C33832 01 PARM-DIR-PAY-13         PIC  X(31).                           
C33832 01 PARM-DIR-PAY-14         PIC  X(31).                           
C33832 01 PARM-DIR-PAY-15         PIC  X(31).                           
REARCH 01 PARM-ACCTING-PERIOD     PIC  X(6).                            
REARCH 01 PARM-COMMENT-LEN        PIC  S9(04) COMP.                     
REARCH 01 PARM-COMMENT-TEXT       PIC  X(210).                          
REARCH 01 PARM-LAST-UPDATE-TS     PIC  X(26).                           
P00774 01 PARM-USER-ID            PIC X(07).                            
REARCH*                                                                         
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                           PARM-CIA-DEBIT-AMT                     
REARCH                           PARM-GL-ACCT-NO                        
REARCH                           PARM-NO-ROWS                           
REARCH                           PARM-DIR-PAY-1                         
REARCH                           PARM-DIR-PAY-2                         
REARCH                           PARM-DIR-PAY-3                         
REARCH                           PARM-DIR-PAY-4                         
REARCH                           PARM-DIR-PAY-5                         
REARCH                           PARM-DIR-PAY-6                         
REARCH                           PARM-DIR-PAY-7                         
REARCH                           PARM-DIR-PAY-8                         
REARCH                           PARM-DIR-PAY-9                         
REARCH                           PARM-DIR-PAY-10                        
REARCH                           PARM-DIR-PAY-11                        
REARCH                           PARM-DIR-PAY-12                        
REARCH                           PARM-DIR-PAY-13                        
REARCH                           PARM-DIR-PAY-14                        
REARCH                           PARM-DIR-PAY-15                        
REARCH                           PARM-ACCTING-PERIOD                    
REARCH                           PARM-COMMENT-LEN                       
REARCH                           PARM-COMMENT-TEXT                      
P00774                           PARM-LAST-UPDATE-TS                    
P00774                           PARM-USER-ID.                          

SCA006        SET WS-GL-SUB TO 1.
REARCH*                                                                         
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     EXEC SQL                                                     
A00956         DECLARE C1 CURSOR  WITH ROWSET POSITIONING FOR
REARCH         SELECT                                                   
REARCH              :S-RETURN-CODE      AS RETURN_CODE                  
REARCH             ,:S-ERROR-MESSAGE1   AS ERROR_MESSAGE1               
REARCH             ,:S-ERROR-MESSAGE2   AS ERROR_MESSAGE2               
REARCH             ,:S-ERROR-MESSAGE3   AS ERROR_MESSAGE3               
REARCH         FROM                                                     
REARCH              CIS.SYSDUMMY1                                    
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ027
MFA-TR*    EXEC SQL                                                             
MFA-TR*        DECLARE C1 CURSOR WITH RETURN WITH ROWSET POSITIONING FOR        
MFA-TR*        SELECT                                                           
MFA-TR*             :S-RETURN-CODE      AS RETURN_CODE                          
MFA-TR*            ,:S-ERROR-MESSAGE1   AS ERROR_MESSAGE1                       
MFA-TR*            ,:S-ERROR-MESSAGE2   AS ERROR_MESSAGE2                       
MFA-TR*            ,:S-ERROR-MESSAGE3   AS ERROR_MESSAGE3                       
MFA-TR*        FROM                                                             
MFA-TR*             SYSIBM.SYSDUMMY1                                            
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
                                                                        
       0100-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
                                                                        
P00774     MOVE PARM-USER-ID        TO WS-USER-ID                       
T21115     INITIALIZE SCSCA182-LINK-RECORD.                             
REARCH     MOVE PARM-ACCOUNT-NO           TO PARM-ACCOUNT-NO-TEMP.      
REARCH     MOVE PARM-CIA-DEBIT-AMT        TO PARM-CIA-DEBIT-AMT-TEMP.   
REARCH     MOVE PARM-GL-ACCT-NO           TO PARM-GL-ACCT-NO-TEMP.      
REARCH     MOVE PARM-ACCTING-PERIOD       TO PARM-ACCTING-PERIOD-TMP.   
REARCH     MOVE PARM-ACCTING-PERIOD-NUM   TO WS-PAR-ACCT-PERIOD.        
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.             
           MOVE WS-ACCOUNT-NO-COMP3 TO AC-ACCOUNT-NO.                   
T21115     MOVE PARM-ACCOUNT-NO     TO SCSCA182-ACCOUNT-NO.             
C23844     IF PARM-GL-ACCT-NO EQUAL '1840300'                           
C23844        IF WS-USER-ID EQUAL 'BB18179' OR                          
C23844           WS-USER-ID EQUAL 'ZS18179'                             
C23844              MOVE 'SYSTEM'            TO WS-USER-ID              
C23844              SET SERV-CARE-CONVERSION TO TRUE                    
C23844        END-IF                                                    
C28322     ELSE                                                         
C28322       IF PARM-GL-ACCT-NO EQUAL '4159010'                         
C28322          IF WS-USER-ID EQUAL 'BB18179' OR                        
C28322             WS-USER-ID EQUAL 'ZS18179'                           
C28322                MOVE 'SYSTEM'          TO WS-USER-ID              
C28322        END-IF                                                    
C23844     END-IF
           END-IF.                                                      
                                                                        
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
REARCH                                                                  
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
                                                                        
PCR640***********                                                               
      * DO NOT PROCEED IF SYSTEM IS LOCKED                                      
      ***********                                                               
           PERFORM 7999-SELECT-AL THRU 7999-SELECT-AL-EXIT              
           IF AL-AR-LOCKOUT-IND = 'Y'                                   
              MOVE 5000 TO RS-RETURN-CODE                               
REARCH        PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT                
REARCH        ADD +1                     TO   CTR-ROWS                  
              PERFORM 9999-END-PROGRAM      THRU 9999-EXIT              
           END-IF.                                                      
                                                                        
REARCH*                                                                         
REARCH     CALL MCSCA182  USING  SCSCA182-ACCOUNT-NO                    
REARCH                           SCSCA182-RETURN-CODE                   
REARCH                           SCSCA182-LAST-UPDATE-TS                
REARCH                           ABEND-FILE.                            
T21115     IF  SCSCA182-RETURN-CODE NOT EQUAL TO ZERO                   
T21115         MOVE PROGRAM-NAME               TO ABEND-PROGRAM         
T21115         MOVE SCSCA182-RETURN-CODE       TO WS-ACTIVE-RETURN-CODE 
T21115                                            SQLCODE               
REARCH                                            RS-RETURN-CODE        
REARCH         PERFORM 2000A-MOVE-RESULT       THRU 2000A-EXIT          
REARCH         ADD +1                          TO   CTR-ROWS            
T21115         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21115         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21115     ELSE                                                         
T21115         MOVE SCSCA182-LAST-UPDATE-TS    TO WS-LAST-UPDATE-TS     
T21115         IF  PARM-LAST-UPDATE-TS = WS-LAST-UPDATE-TS              
T21115             NEXT SENTENCE                                        
T21115         ELSE                                                     
T21115             MOVE 5272                   TO RS-RETURN-CODE        
REARCH             PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT           
REARCH             ADD +1                     TO   CTR-ROWS             
T21115             GO TO 2000-EXIT                                      
T21115         END-IF                                                   
T21115     END-IF.                                                      
      *                                                                 10601000
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*****************************************************************         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*****************************************************************         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE      TO S-RETURN-CODE.                   
REARCH     MOVE RS-ERROR-MESSAGE1   TO S-ERROR-MESSAGE1.                
REARCH     MOVE RS-ERROR-MESSAGE2   TO S-ERROR-MESSAGE2.                
REARCH     MOVE RS-ERROR-MESSAGE3   TO S-ERROR-MESSAGE3.                
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
              MOVE '2200'               TO ACTIVE-PARAGRAPH.            
              MOVE PARM-ACCOUNT-NO      TO WS-ACCOUNT-NO.               
              MOVE WS-ACCOUNT-NO-NUM    TO WS-ACCOUNT-NO-COMP3.         
              MOVE WS-ACCOUNT-NO-COMP3  TO AC-ACCOUNT-NO.               
T17129        MOVE PARM-ACCTING-PERIOD  TO WS-PAR-ACCT-PERIOD.          
      *                                                                         
              PERFORM 2300-PROCESS-ALL-PPTY THRU 2300-EXIT.             
      *                                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO   RS-RETURN-CODE.        
REARCH        PERFORM 2000A-MOVE-RESULT     THRU 2000A-EXIT.            
REARCH        ADD +1                        TO   CTR-ROWS.              
      *                                                                         
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2300-PROCESS-EACH-PPTY.                                                 
      * **********************************************************              
       2300-PROCESS-ALL-PPTY.                                           
                                                                        
           PERFORM 7400-GET-CURRENT-TIMESTAMP                           
              THRU 7400-EXIT                                            
      *                                                                         
           PERFORM 7500-SELECT-ACCOUNT                                  
              THRU 7500-EXIT                                            
      *                                                                         
           MOVE AT-CODES-DATA-PRESENT  TO WS-CODES-DATA-PRESENT         
      *                                                                         
           PERFORM 7510-SELECT-PREMISE                                  
              THRU 7510-EXIT                                            
      *                                                                         
           PERFORM 7520-SELECT-CUSTOMER                                 
              THRU 7520-EXIT                                            
      *                                                                         
C33832     PERFORM 2800-CONTRACT-PAY-AHEAD                              
C33832        THRU 2800-EXIT                                            
C33832*                                                                         
           PERFORM 3000-JRNL-SETUP                                      
              THRU 3000-EXIT                                            
                                                                        
           IF (  PARM-CIA-DEBIT-AMT-NUM > 0 )                           
                 MOVE WS-ACCOUNT-NO-COMP3    TO WS-CURR-ACCOUNT-NUM     
                 MOVE 'CIA'                  TO WS-CURR-RECEIVABLE-TYPE 
                 MOVE 3                      TO WS-CURR-ITEM-ID         
                 MOVE PARM-CIA-DEBIT-AMT-NUM TO WS-CURR-CORR-AMT        
                 SUBTRACT WS-CURR-CORR-AMT   FROM AT-TOTAL-AR-BALANCE   
                 MOVE WS-PPL-AR-TYPE-CIA   TO WS-CURR-PYMT-PRIORITY-LVL 
                 PERFORM 2700-PROCESS-CIA-DEBIT                         
                    THRU 2700-EXIT                                      
                                                                        
                 SET DEBIT-JRNL-DONE TO TRUE                            
           END-IF                                                       
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3 TO AC-ACCOUNT-NO.                   
           INITIALIZE WS-AR-AMT-ORIG-ENTERED                            
                                                                        
           IF ( DEBIT-JRNL-DONE )                                       
                PERFORM 7400-GET-CURRENT-TIMESTAMP                      
                   THRU 7400-EXIT                                       
                MOVE ZERO                 TO AU-TRAN-APPL-NO            
                MOVE ZERO                 TO WS-100-JRNL-TRAN-APPL-NO   
                MOVE WS-CURRENT-TIMESTAMP TO AR-TRANS-HIST-SEQ-NO       
                MOVE WS-CURRENT-TIMESTAMP TO AU-TRANS-HIST-SEQ-NO       
           END-IF                                                       
                                                                        
           PERFORM VARYING WS-SUB FROM 1 BY 1                           
              UNTIL WS-SUB > PARM-NO-ROWS                               
                                                                        
              EVALUATE WS-SUB                                           
                 WHEN 1                                                 
                      MOVE  PARM-DIR-PAY-1  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 2                                                 
                      MOVE  PARM-DIR-PAY-2  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 3                                                 
                      MOVE  PARM-DIR-PAY-3  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 4                                                 
                      MOVE  PARM-DIR-PAY-4  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 5                                                 
                      MOVE  PARM-DIR-PAY-5  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 6                                                 
                      MOVE  PARM-DIR-PAY-6  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 7                                                 
                      MOVE  PARM-DIR-PAY-7  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 8                                                 
                      MOVE  PARM-DIR-PAY-8  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 9                                                 
                      MOVE  PARM-DIR-PAY-9  TO WS-PAYMENT-BREAKDOWN     
                 WHEN 10                                                
                      MOVE  PARM-DIR-PAY-10 TO WS-PAYMENT-BREAKDOWN     
                 WHEN 11                                                
                      MOVE  PARM-DIR-PAY-11 TO WS-PAYMENT-BREAKDOWN     
                 WHEN 12                                                
                      MOVE  PARM-DIR-PAY-12 TO WS-PAYMENT-BREAKDOWN     
                 WHEN 13                                                
                      MOVE  PARM-DIR-PAY-13 TO WS-PAYMENT-BREAKDOWN     
                 WHEN 14                                                
                      MOVE  PARM-DIR-PAY-14 TO WS-PAYMENT-BREAKDOWN     
                 WHEN 15                                                
                      MOVE  PARM-DIR-PAY-15 TO WS-PAYMENT-BREAKDOWN     
              END-EVALUATE                                              
                                                                        
              MOVE WS-ACCOUNT-NO-COMP3 TO WS-CURR-ACCOUNT-NUM           
              MOVE WS-RECV-TYPE        TO WS-CURR-RECEIVABLE-TYPE       
              MOVE WS-ITEM-ID          TO WS-CURR-ITEM-ID               
              MOVE WS-AMT-DIR-PYMT-NUM TO WS-CURR-CORR-AMT              
PCR586        IF ( PARM-GL-ACCT-NO-NUM > ZERO )                         
PCR586            MOVE PARM-GL-ACCT-NO-NUM TO WS-CURR-INPUT-GL-NO       
PCR586        ELSE                                                      
                  MOVE ZERO                TO WS-CURR-INPUT-GL-NO       
PCR586        END-IF                                                    
              ADD  WS-CURR-CORR-AMT    TO AT-TOTAL-AR-BALANCE           
                                                                        
              PERFORM 2400-PROCESS-EACH-PPTY                            
                 THRU 2400-EXIT                                         
                                                                        
              PERFORM 3040-JRNL-CHARGES                                 
                 THRU 3040-EXIT                                         
                                                                        
           END-PERFORM.                                                 
                                                                        
           MOVE WS-CODES-DATA-PRESENT TO AT-CODES-DATA-PRESENT          
           PERFORM 7530-UPDATE-ACCOUNT      THRU 7530-EXIT.             
           MOVE WS-AR-AMT-ORIG-ENTERED TO   AR-AMT-ORIG-ENTERED         
           PERFORM 7630-UPDATE-AR-TRAN      THRU 7630-EXIT.             
                                                                        
           MOVE WS-JRNL-CNTRL-ONLY           TO WS-JRNL-OPERATION-RQST. 
           PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.             
           IF WS-JRNL-RTRN-CODE NOT = WS-JRNL-SUCCESS                   
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '2300'                    TO ACTIVE-PARAGRAPH        
              MOVE 'USERABEN'                TO ABEND-FUNCTION          
              MOVE WS-Y                      TO WS-USER-FORCE-ABEND     
              MOVE 'JRNL UPD NOT SUCCESSFUL' TO DSNTIAR-MESSAGE-1       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2400-PROCESS-EACH-PPTY.                                                 
      * **********************************************************              
       2400-PROCESS-EACH-PPTY.                                          
                                                                        
              EVALUATE WS-CURR-RECEIVABLE-TYPE                          
                 WHEN 'NSC'                                             
                       MOVE WS-PPL-AR-TYPE-NSC                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2410-PROCESS-LT-50-PPTY                  
                          THRU 2410-EXIT                                
                 WHEN 'NSA'                                             
                       MOVE WS-PPL-AR-TYPE-NSA                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2410-PROCESS-LT-50-PPTY                  
                          THRU 2410-EXIT                                
                 WHEN 'NSN'                                             
                       MOVE WS-PPL-AR-TYPE-NSN                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2410-PROCESS-LT-50-PPTY                  
                          THRU 2410-EXIT                                
                 WHEN 'LPC'                                             
                       MOVE WS-PPL-AR-TYPE-LPC                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2410-PROCESS-LT-50-PPTY                  
                          THRU 2410-EXIT                                
                 WHEN 'LPN'                                             
                       MOVE WS-PPL-AR-TYPE-LPN                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2410-PROCESS-LT-50-PPTY                  
                          THRU 2410-EXIT                                
                 WHEN 'UTE'                                             
                       MOVE WS-PPL-AR-TYPE-UTE                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2410-PROCESS-LT-50-PPTY                  
                          THRU 2410-EXIT                                
                 WHEN 'UTG'                                             
                       MOVE WS-PPL-AR-TYPE-UTG                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2410-PROCESS-LT-50-PPTY                  
                          THRU 2410-EXIT                                
                 WHEN 'BBP'                                             
P00453           WHEN 'PRP'                                             
                       MOVE WS-PPL-AR-TYPE-EPP                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2420-PROCESS-EPP-RCC-PJS-PPTY            
                          THRU 2420-EXIT                                
                 WHEN 'RCC'                                             
                       MOVE WS-PPL-AR-TYPE-RCC                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2420-PROCESS-EPP-RCC-PJS-PPTY            
                          THRU 2420-EXIT                                
                 WHEN 'CIA'                                             
                       MOVE WS-PPL-AR-TYPE-CIA                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       IF ( WS-CURR-ITEM-ID = 3 )                       
                          PERFORM 2430-PROCESS-CIA-DB-PPTY              
                             THRU 2430-EXIT                             
                       ELSE                                             
                          PERFORM 2440-PROCESS-CIA-CR-PPTY              
                             THRU 2440-EXIT                             
                       END-IF                                           
                 WHEN 'DEP'                                             
                       MOVE WS-PPL-AR-TYPE-DEP                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2450-PROCESS-DEP-PPTY                    
                          THRU 2450-EXIT                                
                 WHEN 'DPP'                                             
                       MOVE WS-PPL-AR-TYPE-DPP                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2460-PROCESS-DPP-PPTY                    
                          THRU 2460-EXIT                                
                 WHEN 'DFA'                                             
                       MOVE WS-PPL-AR-TYPE-DFA                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2470-PROCESS-DFA-PPTY                    
                          THRU 2470-EXIT                                
                 WHEN 'CNT'                                             
                       MOVE WS-PPL-AR-TYPE-CNT                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2480-PROCESS-CNT-PPTY                    
                          THRU 2480-EXIT                                
                 WHEN 'PJS'                                             
                       MOVE WS-PPL-AR-TYPE-PJS                          
                         TO WS-CURR-PYMT-PRIORITY-LVL                   
                       PERFORM 2420-PROCESS-EPP-RCC-PJS-PPTY            
                          THRU 2420-EXIT                                
              END-EVALUATE.                                             
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2410-PROCESS-LT-50-PPTY                                                 
      * **********************************************************              
       2410-PROCESS-LT-50-PPTY.                                         
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T18451        IF AC-AMT-UNUSED-CR < 0                                   
T18451          ADD WS-CURR-CORR-AMT TO AC-AMT-UNUSED-CR GIVING         
T18451              WS-DIFF-AMT                                         
T18451          IF  WS-DIFF-AMT <= 0                                    
T18451             MOVE  WS-DIFF-AMT    TO  AC-AMT-UNUSED-CR            
T18451             PERFORM 7040-UPD-ARCNTL-UNUSED-CR                    
T18451                   THRU 7040-EXIT                                 
T18451          ELSE                                                    
T18451             ADD   WS-DIFF-AMT    TO  AC-AMT-AR-DAY-00            
T18451             PERFORM 7020-UPD-ARCNTL-ZERO-DAY-ONLY                
T18451                   THRU 7020-EXIT                                 
T18451          END-IF                                                  
T18451        ELSE                                                      
T18451          ADD  WS-CURR-CORR-AMT   TO  AC-AMT-AR-DAY-00            
T18451             PERFORM 7020-UPD-ARCNTL-ZERO-DAY-ONLY                
T18451                   THRU 7020-EXIT                                 
T18451        END-IF                                                    
           ELSE                                                         
               MOVE WS-CURR-CORR-AMT          TO   AC-AMT-AR-DAY-00     
               PERFORM 7010-INSERT-AR-CNTL                              
                  THRU 7010-EXIT                                        
           END-IF.                                                      
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2420-PROCESS-EPP-RCC-PJS-PPTY                                           
      * **********************************************************              
       2420-PROCESS-EPP-RCC-PJS-PPTY.                                   
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
T17754                                         CC-ACCOUNT-NO.           
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
T17754                                         CC-PYMT-PRIORITY-LVL.    
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
T17754                                         CC-CCC-ITEM-ID.          
      *                                                                         
           PERFORM 2425-UPD-INS-EPP-RCC-PJS-PPTY                        
              THRU 2425-EXIT                                            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
T18186     MOVE ZERO                      TO   WS-AMT-AR-DAY-00         
      *                                                                         
           PERFORM 2426-SUM-00-DAY                                      
              THRU 2426-EXIT.                                           
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           MOVE WS-AMT-AR-DAY-00          TO   AC-AMT-AR-DAY-00         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                    
                                          THRU 7030-EXIT                
           ELSE                                                         
               PERFORM 7010-INSERT-AR-CNTL THRU 7010-EXIT               
T18186     END-IF.                                                      
      *                                                                         
T17754     IF WS-CURR-RECEIVABLE-TYPE = 'RCC'                           
               PERFORM 7540-SELECT-CONN-CHRG     THRU 7540-EXIT         
               IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                     
T18873            MOVE AT-COMPANY-NO      TO B1-COMPANY-NO              
T18873            MOVE AT-LOCAL-OFFICE    TO B1-LOCAL-OFFICE            
T18873            PERFORM 7541-SELECT-LOCAL-OFFICE  THRU 7541-EXIT      
T18873            IF B1-ELEC-REV-ALLOC-PCT = 100                        
T18873               MOVE '004'    TO   CC-RCNCT-TYPE-NO                
                  ELSE                                                  
T18873               IF B1-ELEC-REV-ALLOC-PCT = 0                       
T18873                  MOVE '005' TO   CC-RCNCT-TYPE-NO                
                     ELSE                                               
T18873                  MOVE '001' TO   CC-RCNCT-TYPE-NO                
                     END-IF                                             
                  END-IF                                                
                  MOVE WS-CURR-CORR-AMT   TO CC-AMT-TRANS               
                                             CC-AMT-ORIG-ENTERED        
                  MOVE ZEROES             TO CC-AMT-TAX-XCISE           
                                             CC-AMT-TAX-STATE           
                                             CC-AMT-TAX-CITY            
                                             CC-AMT-TAX-OTHER           
                  MOVE WS-CURRENT-DATE    TO CC-DATE-TRANS              
                  MOVE SPACES             TO CC-DATE-CCC-BILLED         
                  MOVE -1                 TO WS-NULL-DATE-CCC-BILLED    
                  MOVE 'B'                TO CC-CODE-CCC-TYPE           
                  PERFORM 8030-INSERT-CCC THRU 8030-EXIT                
               END-IF                                                   
P00794*                                                                 03790000
P00794         MOVE ZERO                         TO WS-DATABASE         
P00794         MOVE '01'                         TO C8-COMPANY-NO       
P00794         MOVE 'DATABASE'                   TO C8-DELINQ-CD        
P00794         PERFORM 7610-SELECT-DELINQUENCY    THRU 7610-EXIT        
P00794         MOVE C8-DELINQ-VALUE              TO WS-DATABASE         
P00794*                                                                 03790000
P00794         MOVE AT-COMPANY-NO                TO WS-COMPANY-NO       
ACT180         IF (SEB-DATABASE OR PSNC)                                
ACT180            AND AT-MST-SUB-ACCT-IND NOT = 'M'                     
P00794           MOVE AT-ACCOUNT-NO             TO UT-ACCOUNT-NO        
P00794                                             FF-ACCOUNT-NO        
P00794           PERFORM 7640-GET-UTIL-ENV       THRU 7640-EXIT         
P00794*                                                                 03790000
P00794           PERFORM 7650-GET-MIN-REV-MO     THRU 7650-EXIT         
P00794*                                                                 03790000
P00794           PERFORM 2850-SETUP-VAL-FXD-FCTR THRU 2850-EXIT         
P00794*                                                                 03790000
P00794           PERFORM 2900-SETUP-VAL-MNT-TRAN THRU 2900-EXIT         
P00794*                                                                         
P00794         END-IF                                                   
ACT087     END-IF.                                                      
                                                                        
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2425-UPD-INS-EPP-RCC-PJS-PPTY                                           
      * **********************************************************              
       2425-UPD-INS-EPP-RCC-PJS-PPTY.                                   
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T18186        MOVE  AC-AMT-AR-DAY-00         TO   WS-AMT-AR-DAY-00      
              MOVE  AC-AMT-TRAN-BALANCE      TO   WS-AMT-TRAN-BALANCE   
              ADD   WS-CURR-CORR-AMT         TO   WS-AMT-AR-DAY-00      
                                                  WS-AMT-TRAN-BALANCE   
              IF WS-CURR-RECEIVABLE-TYPE = 'RCC' OR 'PJS'               
                IF AC-AMT-TRAN-BALANCE < 0                              
                  IF WS-AMT-TRAN-BALANCE < 0                            
                     MOVE   0                 TO   WS-AMT-AR-DAY-00     
                  ELSE                                                  
                     IF WS-AMT-TRAN-BALANCE < WS-AMT-AR-DAY-00          
                       MOVE  WS-AMT-TRAN-BALANCE   TO   WS-AMT-AR-DAY-00
                     END-IF                                             
                  END-IF                                                
                  SUBTRACT WS-CURR-CORR-AMT   FROM AT-TOTAL-AR-BALANCE  
                  ADD      WS-AMT-AR-DAY-00   TO   AT-TOTAL-AR-BALANCE  
                END-IF                                                  
              END-IF                                                    
              MOVE  WS-AMT-AR-DAY-00         TO   AC-AMT-AR-DAY-00      
T18186        MOVE  WS-AMT-TRAN-BALANCE      TO   AC-AMT-TRAN-BALANCE   
                                                                        
               PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                   
                  THRU 7030-EXIT                                        
           ELSE                                                         
               MOVE WS-CURR-CORR-AMT          TO   AC-AMT-AR-DAY-00     
                                                   AC-AMT-TRAN-BALANCE  
               PERFORM 7010-INSERT-AR-CNTL                              
                  THRU 7010-EXIT                                        
           END-IF.                                                      
      *                                                                         
       2425-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T18186 2426-SUM-00-DAY.                                                 
                                                                        
           EXEC SQL                                                     
               SELECT  SUM(AMT_AR_DAY_00)                               
               INTO    :WS-AMT-AR-DAY-00                                
               FROM    CSS_AR_CNTL WITH(READUNCOMMITTED)                        
               WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO               
               AND     PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL        
               AND     ITEM_ID           > :AC-ITEM-ID                  
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  SUM(AMT_AR_DAY_00)                                       
MFA-TR*        INTO    :WS-AMT-AR-DAY-00                                        
MFA-TR*        FROM    CSS_AR_CNTL                                              
MFA-TR*        WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO                       
MFA-TR*        AND     PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                
MFA-TR*        AND     ITEM_ID           > :AC-ITEM-ID                          
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 2426                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE '2426'                    TO   ACTIVE-PARAGRAPH      
CBSI          MOVE 'SELECT'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_AR_CNTL      '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'ITEM-ID     '            TO   TABLE-ELEMENT-3       
              MOVE AC-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE AC-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE AC-ITEM-ID                TO   HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       2426-EXIT.                                                       
T18186      EXIT.                                                       
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2430-PROCESS-CIA-DB-PPTY                                                
      * **********************************************************              
       2430-PROCESS-CIA-DB-PPTY.                                        
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2435-UPD-INS-CIA-DB-PPTY                             
              THRU 2435-EXIT                                            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2435-UPD-INS-CIA-DB-PPTY                             
              THRU 2435-EXIT.                                           
      *                                                                         
       2430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2435-UPD-INS-CIA-DB-PPTY                                                
      * **********************************************************              
       2435-UPD-INS-CIA-DB-PPTY.                                        
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD WS-CURR-CORR-AMT           TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                   ADD WS-CURR-CORR-AMT       TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                   
                  THRU 7030-EXIT                                        
           ELSE                                                         
               MOVE WS-CURR-CORR-AMT          TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                   MOVE WS-CURR-CORR-AMT      TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7010-INSERT-AR-CNTL                              
                  THRU 7010-EXIT                                        
           END-IF.                                                      
      *                                                                         
       2435-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2440-PROCESS-CIA-CR-PPTY                                                
      * **********************************************************              
       2440-PROCESS-CIA-CR-PPTY.                                        
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2445-UPD-DEL-CIA-CR-PPTY                             
              THRU 2445-EXIT                                            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2445-UPD-DEL-CIA-CR-PPTY                             
              THRU 2445-EXIT.                                           
      *                                                                         
       2440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2445-UPD-DEL-CIA-CR-PPTY                                                
      * **********************************************************              
       2445-UPD-DEL-CIA-CR-PPTY.                                        
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD WS-CURR-CORR-AMT           TO   AC-AMT-UNUSED-CR     
               IF ( AC-ITEM-ID  > 0 )                                   
                   ADD WS-CURR-CORR-AMT       TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
                                                                        
               IF ( AC-AMT-AR-DAY-00 EQUAL ZERO AND                     
                    AC-AMT-AR-DAY-30 EQUAL ZERO AND                     
                    AC-AMT-AR-DAY-60 EQUAL ZERO AND                     
                    AC-AMT-AR-DAY-90 EQUAL ZERO AND                     
                    AC-AMT-UNUSED-CR EQUAL ZERO AND                     
                    AC-AMT-TRAN-BALANCE EQUAL ZERO )                    
                     PERFORM 7050-DEL-ARCNTL                            
                     THRU 7050-EXIT                                     
                     IF ( AC-ITEM-ID = 0 )                              
                        MOVE SPACES TO WS-CODE-CIA                      
                     END-IF                                             
               ELSE                                                     
                     PERFORM 7040-UPD-ARCNTL-UNUSED-CR                  
                        THRU 7040-EXIT                                  
                     IF AC-ITEM-ID > 0                                  
                       PERFORM 7045-UPD-ARCNTL-TRANBAL                  
                          THRU 7045-EXIT                                
                     END-IF                                             
               END-IF                                                   
           END-IF.                                                      
      *                                                                         
       2445-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2450-PROCESS-DEP-PPTY                                                   
      * **********************************************************              
       2450-PROCESS-DEP-PPTY.                                           
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
                                                                        
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
                                                                        
           MOVE WS-CURR-ACCOUNT-NUM       TO   DO-ACCOUNT-NO            
           MOVE WS-CURR-ITEM-ID           TO   DO-DEPOSIT-CERT-NO       
      *                                                                         
           PERFORM 2455-UPD-INS-DEP-PPTY                                
              THRU 2455-EXIT                                            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2455-UPD-INS-DEP-PPTY                                
              THRU 2455-EXIT.                                           
      *                                                                         
           PERFORM 7200-UPD-CSS-DEP-ON-HAND                             
              THRU 7200-EXIT.                                           
      *                                                                         
           PERFORM 2600-ADJUST-DEP-PAY-HIST                             
              THRU 2600-EXIT.                                           
      *                                                                         
           PERFORM 7600-SELECT-DEP-REQ     THRU 7600-EXIT               
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 MOVE WS-ACCOUNT-NO-COMP3 TO DR-ACCOUNT-NO              
                 MOVE WS-CURR-ITEM-ID     TO DR-DEP-ITEM-ID             
                 MOVE 80                  TO DR-PYMT-PRIORITY-LVL       
                 MOVE WS-CURR-CORR-AMT    TO DR-AMT-MO-PYMT             
                 MOVE WS-CURR-CORR-AMT    TO DR-AMT-ORIG-ENTERED        
                 MOVE WS-CURRENT-DATE     TO DR-DATE-PYMT-START         
                 MOVE WS-CURRENT-DATE     TO DR-DATE-TRAN               
                 MOVE ZERO                TO WS-DR-NULL-IND-1           
                 MOVE ZERO                TO WS-DR-NULL-IND-2           
                 MOVE 'A'                 TO DR-DEP-ACTION-CODE         
                 MOVE 'N'                 TO DR-DEP-BILL-OPTION-CD      
                 MOVE 1                   TO DR-NO-SCHED-PYMTS          
                 MOVE 0                   TO DR-REBILLED-DEP-AMT        
                 MOVE -1                  TO WS-DR-NULL-IND-3           
                 MOVE 'U'                 TO DR-SERVICE-TYPE-CD         
                 PERFORM 7620-INSERT-DEP-REQ    THRU 7620-EXIT          
              END-IF                                                    
           END-IF.                                                      
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2455-UPD-INS-DEP-PPTY                                                   
      * **********************************************************              
       2455-UPD-INS-DEP-PPTY.                                           
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD WS-CURR-CORR-AMT           TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                   ADD WS-CURR-CORR-AMT       TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                   
                  THRU 7030-EXIT                                        
           ELSE                                                         
               MOVE WS-CURR-CORR-AMT          TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                   MOVE WS-CURR-CORR-AMT      TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7010-INSERT-AR-CNTL                              
                  THRU 7010-EXIT                                        
           END-IF.                                                      
      *                                                                         
       2455-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2460-PROCESS-DPP-PPTY                                                   
      * **********************************************************              
       2460-PROCESS-DPP-PPTY.                                           
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2465-UPD-INS-DPP-PPTY                                
              THRU 2465-EXIT                                            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2465-UPD-INS-DPP-PPTY                                
              THRU 2465-EXIT.                                           
      *                                                                         
           PERFORM 2500-UPD-INS-90-90-ROW                               
              THRU 2500-EXIT                                            
      *                                                                         
           MOVE WS-B               TO DA-CODE-DFA-TYPE                  
           MOVE WS-A               TO DA-CODE-DFA-STATUS                
      *                                                                         
           MOVE WS-CURR-ACCOUNT-NUM       TO DA-ACCOUNT-NO              
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO DA-PYMT-PRIORITY-LVL       
           MOVE WS-CURR-ITEM-ID           TO DA-DFA-ITEM-ID             
           PERFORM 7100-UPD-CSS-DFA-STATUS                              
              THRU 7100-EXIT.                                           
      *                                                                         
       2460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2465-UPD-INS-DPP-PPTY                                                   
      * **********************************************************              
       2465-UPD-INS-DPP-PPTY.                                           
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD WS-CURR-CORR-AMT           TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                  ADD WS-CURR-CORR-AMT        TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                   
                  THRU 7030-EXIT                                        
           ELSE                                                         
               MOVE WS-CURR-CORR-AMT          TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                  MOVE WS-CURR-CORR-AMT       TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7010-INSERT-AR-CNTL                              
                  THRU 7010-EXIT                                        
           END-IF.                                                      
      *                                                                         
       2465-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2470-PROCESS-DFA-PPTY                                                   
      * **********************************************************              
       2470-PROCESS-DFA-PPTY.                                           
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2475-UPD-INS-DFA-PPTY                                
              THRU 2475-EXIT                                            
      *                                                                         
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2475-UPD-INS-DFA-PPTY                                
              THRU 2475-EXIT.                                           
      *                                                                         
           MOVE WS-A    TO DA-CODE-DFA-TYPE                             
           MOVE WS-A    TO DA-CODE-DFA-STATUS                           
      *                                                                         
           MOVE WS-CURR-ACCOUNT-NUM       TO DA-ACCOUNT-NO              
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO DA-PYMT-PRIORITY-LVL       
           MOVE WS-CURR-ITEM-ID           TO DA-DFA-ITEM-ID             
      *                                                                         
           PERFORM 7100-UPD-CSS-DFA-STATUS                              
              THRU 7100-EXIT.                                           
      *                                                                         
       2470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2475-UPD-INS-DFA-PPTY                                                   
      * **********************************************************              
       2475-UPD-INS-DFA-PPTY.                                           
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD WS-CURR-CORR-AMT           TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                  ADD WS-CURR-CORR-AMT        TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                   
                  THRU 7030-EXIT                                        
           ELSE                                                         
               MOVE WS-CURR-CORR-AMT          TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                  MOVE WS-CURR-CORR-AMT      TO   AC-AMT-TRAN-BALANCE   
               END-IF                                                   
               PERFORM 7010-INSERT-AR-CNTL                              
                  THRU 7010-EXIT                                        
           END-IF.                                                      
      *                                                                         
       2475-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2480-PROCESS-CNT-PPTY                                                   
      * **********************************************************              
       2480-PROCESS-CNT-PPTY.                                           
                                                                        
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2485-UPD-INS-CNT-PPTY                                
              THRU 2485-EXIT                                            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
T18773     MOVE ZERO                      TO   WS-AMT-AR-DAY-00         
      *                                                                         
           PERFORM 2426-SUM-00-DAY                                      
              THRU 2426-EXIT.                                           
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           MOVE WS-AMT-AR-DAY-00          TO   AC-AMT-AR-DAY-00         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                    
                                          THRU 7030-EXIT                
           ELSE                                                         
               PERFORM 7010-INSERT-AR-CNTL THRU 7010-EXIT               
T18873     END-IF.                                                      
      *                                                                         
           MOVE WS-CURR-ACCOUNT-NUM       TO CT-ACCOUNT-NO              
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO CT-PYMT-PRIORITY-LVL       
           MOVE WS-CURR-ITEM-ID           TO CT-CNT-ITEM-ID             
      *                                                                         
           PERFORM 7355-SELECT-CONTRACT                                 
              THRU 7355-EXIT.                                           
      *                                                                         
T20669     IF ( CT-CNT-STATUS-CD EQUAL WS-E )                           
T20669        NEXT SENTENCE                                             
T20669     ELSE                                                         
T20669        IF (CT-AMT-MO-PYMT = 99999.99)                            
T20669           MOVE WS-E TO CT-CNT-STATUS-CD                          
T20669           PERFORM 7350-UPDATE-CONTRACT                           
T20669              THRU 7350-EXIT                                      
T20669        ELSE                                                      
                 MOVE WS-B TO CT-CNT-STATUS-CD                          
                 PERFORM 7350-UPDATE-CONTRACT                           
                    THRU 7350-EXIT                                      
              END-IF                                                    
           END-IF.                                                      
      *                                                                         
       2480-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2485-UPD-INS-CNT-PPTY                                                   
      * **********************************************************              
       2485-UPD-INS-CNT-PPTY.                                           
      *                                                                         
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
T18773        MOVE  AC-AMT-AR-DAY-00         TO   WS-AMT-AR-DAY-00      
              MOVE  AC-AMT-TRAN-BALANCE      TO   WS-AMT-TRAN-BALANCE   
              ADD   WS-CURR-CORR-AMT         TO   WS-AMT-AR-DAY-00      
                                                  WS-AMT-TRAN-BALANCE   
              IF AC-AMT-TRAN-BALANCE < 0                                
                 IF WS-AMT-TRAN-BALANCE < 0                             
                    MOVE   0                 TO   WS-AMT-AR-DAY-00      
                 ELSE                                                   
                    IF WS-AMT-TRAN-BALANCE < WS-AMT-AR-DAY-00           
                      MOVE  WS-AMT-TRAN-BALANCE   TO   WS-AMT-AR-DAY-00 
                    END-IF                                              
                 END-IF                                                 
                 SUBTRACT WS-CURR-CORR-AMT   FROM AT-TOTAL-AR-BALANCE   
                 ADD      WS-AMT-AR-DAY-00   TO   AT-TOTAL-AR-BALANCE   
              END-IF                                                    
              MOVE  WS-AMT-AR-DAY-00         TO   AC-AMT-AR-DAY-00      
T18773        MOVE  WS-AMT-TRAN-BALANCE      TO   AC-AMT-TRAN-BALANCE   
               PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL                   
                  THRU 7030-EXIT                                        
           ELSE                                                         
               MOVE WS-CURR-CORR-AMT          TO   AC-AMT-AR-DAY-00     
               IF ( AC-ITEM-ID  > 0 )                                   
                  MOVE WS-CURR-CORR-AMT       TO   AC-AMT-TRAN-BALANCE  
               END-IF                                                   
               PERFORM 7010-INSERT-AR-CNTL                              
                  THRU 7010-EXIT                                        
           END-IF.                                                      
      *                                                                         
       2485-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 2500-UPD-INS-90-90-ROW                                                  
      ******************************************************************        
       2500-UPD-INS-90-90-ROW.                                          
           MOVE '2500'               TO ACTIVE-PARAGRAPH.               
                                                                        
           INITIALIZE                     DCLCSS-DFA-RECVBLE            
           MOVE WS-CURR-ACCOUNT-NUM       TO DV-ACCOUNT-NO              
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO DV-PYMT-PRIORITY-LVL       
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO DV-DFA-PYMT-PRIORITY       
           MOVE WS-CURR-ITEM-ID           TO DV-AGREEMENT-NO            
                                                                        
           PERFORM 7110-SELECT-DFA-RECVBLE                              
              THRU 7110-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               ADD WS-CURR-CORR-AMT           TO   DV-AMT-CONTRACT-DEFR 
               ADD WS-CURR-CORR-AMT           TO   DV-AMT-DAY-00        
               PERFORM 7120-UPDATE-DFA-RECVBLE                          
                  THRU 7120-EXIT                                        
           ELSE                                                         
               INITIALIZE                     DCLCSS-DFA-RECVBLE        
               MOVE WS-CURR-ACCOUNT-NUM       TO DV-ACCOUNT-NO          
               MOVE WS-CURR-PYMT-PRIORITY-LVL TO DV-PYMT-PRIORITY-LVL   
               MOVE WS-CURR-PYMT-PRIORITY-LVL TO DV-DFA-PYMT-PRIORITY   
               MOVE WS-CURR-ITEM-ID           TO DV-AGREEMENT-NO        
               MOVE WS-CURR-CORR-AMT          TO DV-AMT-CONTRACT-DEFR   
               MOVE WS-CURR-CORR-AMT          TO DV-AMT-DAY-00          
               PERFORM 7130-INSERT-DFA-RECVBLE                          
                  THRU 7130-EXIT                                        
           END-IF.                                                      
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      * **********************************************************              
      * 2600-ADJUST-DEP-PAY-HIST.                                               
      * **********************************************************              
       2600-ADJUST-DEP-PAY-HIST.                                        
                                                                        
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.             
           MOVE WS-ACCOUNT-NO-COMP3 TO DP-ACCOUNT-NO                    
           MOVE WS-CURR-ITEM-ID     TO DP-DEPOSIT-CERT-NO               
           MOVE WS-CURR-CORR-AMT    TO WS-REM-DEP-CORR-AMT              
                                                                        
           PERFORM 7300-OPEN-DEP-PAY-HIST                               
              THRU 7300-EXIT                                            
                                                                        
           PERFORM UNTIL WS-REM-DEP-CORR-AMT <= 0                       
                                                                        
               PERFORM 7310-FETCH-DEP-PAY-HIST                          
                  THRU 7310-EXIT                                        
                                                                        
               IF ( DP-DEP-PAY-AMT >= WS-REM-DEP-CORR-AMT )             
                    SUBTRACT WS-REM-DEP-CORR-AMT FROM DP-DEP-PAY-AMT    
                    MOVE ZERO TO  WS-REM-DEP-CORR-AMT                   
                    PERFORM 7340-UPDATE-DEP-PAY-HIST                    
                       THRU 7340-EXIT                                   
               ELSE                                                     
                    PERFORM 7330-DELETE-DEP-PAY-HIST                    
                       THRU 7330-EXIT                                   
                    SUBTRACT DP-DEP-PAY-AMT FROM WS-REM-DEP-CORR-AMT    
               END-IF                                                   
                                                                        
                                                                        
           END-PERFORM.                                                 
                                                                        
           PERFORM 7320-CLOSE-DEP-PAY-HIST                              
              THRU 7320-EXIT.                                           
      *                                                                         
       2600-EXIT.                                                       
           EXIT.                                                        
      * ***********************************************************             
      * 2700-PROCESS-CIA-DEBIT.                                                 
      * ***********************************************************             
       2700-PROCESS-CIA-DEBIT.                                          
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE WS-CURR-ITEM-ID           TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2705-UPD-DEL-CIA-DEBIT                               
              THRU 2705-EXIT                                            
      *                                                                         
           INITIALIZE DCLCSS-AR-CNTL                                    
           MOVE WS-CURR-ACCOUNT-NUM       TO   AC-ACCOUNT-NO            
           MOVE WS-CURR-PYMT-PRIORITY-LVL TO   AC-PYMT-PRIORITY-LVL     
           MOVE ZERO                      TO   AC-ITEM-ID               
      *                                                                         
           PERFORM 2705-UPD-DEL-CIA-DEBIT                               
              THRU 2705-EXIT.                                           
      *                                                                         
       2700-EXIT.                                                       
           EXIT.                                                        
      * ***********************************************************             
      * 2705-UPD-DEL-CIA-DEBIT.                                                 
      *  - THIS PARA IS SUPPOSED TO PROCESS THE CIA DEBIT COMING                
      *     UPPER DATA WINDOWS OF THE PANEL# XXX. CIA-3 ROW FROM                
      *     THE BOTTOM DATA WINDOW WILL BE PROCESSED SIMILLAR TO                
      *     OTHER CHARGES.                                                      
      * ***********************************************************             
       2705-UPD-DEL-CIA-DEBIT.                                          
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT                                            
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
               SUBTRACT WS-CURR-CORR-AMT     FROM   AC-AMT-AR-DAY-00    
               IF ( AC-ITEM-ID  > 0 )                                   
                   SUBTRACT WS-CURR-CORR-AMT  FROM AC-AMT-TRAN-BALANCE  
               END-IF                                                   
                                                                        
               IF ( AC-AMT-AR-DAY-00 EQUAL ZERO AND                     
                    AC-AMT-AR-DAY-30 EQUAL ZERO AND                     
                    AC-AMT-AR-DAY-60 EQUAL ZERO AND                     
                    AC-AMT-AR-DAY-90 EQUAL ZERO AND                     
                    AC-AMT-UNUSED-CR EQUAL ZERO AND                     
                    AC-AMT-TRAN-BALANCE EQUAL ZERO )                    
                      PERFORM 7050-DEL-ARCNTL                           
                         THRU 7050-EXIT                                 
                      IF ( AC-ITEM-ID = 0 )                             
                         MOVE SPACES TO WS-CODE-CIA                     
                      END-IF                                            
               ELSE                                                     
                      PERFORM 7030-UPD-ARCNTL-ZERO-N-TRANBAL            
                         THRU 7030-EXIT                                 
               END-IF                                                   
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE '2705'                    TO   ACTIVE-PARAGRAPH      
CBSI          MOVE 'SELECT'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_AR_CNTL      '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'ITEM-ID     '            TO   TABLE-ELEMENT-3       
              MOVE AC-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE AC-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE AC-ITEM-ID                TO   HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
      *                                                                         
       2705-EXIT.                                                       
           EXIT.                                                        
      ******************************************************************        
      * 2710-UPDATE-CODES-DATA.                                       *         
      ******************************************************************        
       2710-UPDATE-CODES-DATA.                                          
           EVALUATE AC-PYMT-PRIORITY-LVL                                
            WHEN WS-PPL-AR-TYPE-NSC                                     
                 MOVE 'A'   TO WS-CODE-NSF-CHK-CHG                      
            WHEN WS-PPL-AR-TYPE-NSA                                     
                 MOVE 'A'   TO WS-CODE-NSF-CHK-AMT                      
            WHEN WS-PPL-AR-TYPE-NSN                                     
                 MOVE 'A'   TO WS-CODE-NSF-CHK-AMT                      
            WHEN WS-PPL-AR-TYPE-LPC                                     
                 MOVE 'A'   TO WS-CODE-LPC                              
            WHEN WS-PPL-AR-TYPE-LPN                                     
                 MOVE 'A'   TO WS-CODE-LPC                              
            WHEN WS-PPL-AR-TYPE-UTE                                     
                 MOVE 'A'   TO WS-CODE-UTL                              
            WHEN WS-PPL-AR-TYPE-UTG                                     
                 MOVE 'A'   TO WS-CODE-UTL                              
            WHEN WS-PPL-AR-TYPE-EPP                                     
C26130*          MOVE 'A'   TO WS-CODE-EPP-OFFER                                
C26130           MOVE 'A'   TO WS-CODE-BUDGET                           
            WHEN WS-PPL-AR-TYPE-RCC                                     
                 MOVE 'A'   TO WS-CODE-CONNECT-CHRG                     
            WHEN WS-PPL-AR-TYPE-CIA                                     
                 MOVE 'A'   TO WS-CODE-CIA                              
            WHEN WS-PPL-AR-TYPE-DEP                                     
                 MOVE 'A'   TO WS-CODE-DEP-REQ                          
                 MOVE 'A'   TO WS-CODE-DEP-ON-HAND                      
            WHEN WS-PPL-AR-TYPE-DFA                                     
                 IF ( AC-ITEM-ID >= 40000000 )                          
                    MOVE 'A'   TO WS-CODE-DFA-ACCT                      
                 ELSE                                                   
                    IF ( AC-ITEM-ID >= 30000000 )                       
                          MOVE 'A'   TO WS-CODE-DPP-ACCT                
                    END-IF                                              
                 END-IF                                                 
            WHEN WS-PPL-AR-TYPE-CNT                                     
                 MOVE 'A'   TO WS-CODE-CONTRACT                         
            WHEN WS-PPL-AR-TYPE-PJS                                     
                 MOVE 'A'   TO WS-CODE-PROJECT-SHARE                    
           END-EVALUATE.                                                
                                                                        
       2710-EXIT.                                                       
           EXIT.                                                        
C33832*************************************************************             
C33832* 2800-CONTRACT-PAY-AHEAD.                                                
C33832*************************************************************             
C33832 2800-CONTRACT-PAY-AHEAD.                                         
C33832                                                                  
C33832     SET NO-CNT-PRINCPL-PAYOFF        TO TRUE                     
C33832     PERFORM VARYING WS-SUB FROM 1 BY 1                           
C33832        UNTIL WS-SUB > PARM-NO-ROWS OR CNT-PRINCPL-PAYOFF         
C33832                                                                  
C33832        EVALUATE WS-SUB                                           
C33832           WHEN 1                                                 
C33832                MOVE  PARM-DIR-PAY-1  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 2                                                 
C33832                MOVE  PARM-DIR-PAY-2  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 3                                                 
C33832                MOVE  PARM-DIR-PAY-3  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 4                                                 
C33832                MOVE  PARM-DIR-PAY-4  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 5                                                 
C33832                MOVE  PARM-DIR-PAY-5  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 6                                                 
C33832                MOVE  PARM-DIR-PAY-6  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 7                                                 
C33832                MOVE  PARM-DIR-PAY-7  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 8                                                 
C33832                MOVE  PARM-DIR-PAY-8  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 9                                                 
C33832                MOVE  PARM-DIR-PAY-9  TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 10                                                
C33832                MOVE  PARM-DIR-PAY-10 TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 11                                                
C33832                MOVE  PARM-DIR-PAY-11 TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 12                                                
C33832                MOVE  PARM-DIR-PAY-12 TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 13                                                
C33832                MOVE  PARM-DIR-PAY-13 TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 14                                                
C33832                MOVE  PARM-DIR-PAY-14 TO WS-PAYMENT-BREAKDOWN     
C33832           WHEN 15                                                
C33832                MOVE  PARM-DIR-PAY-15 TO WS-PAYMENT-BREAKDOWN     
C33832        END-EVALUATE                                              
C33832                                                                  
C33832        IF WS-RECV-TYPE = 'CIA'                                   
C33832           IF WS-CNT-PAY-AHEAD = 'P' OR 'O'                       
C33832              MOVE WS-CNT-PAY-AHEAD   TO WS-CNT-PRINCPL-PAYOFF    
C33832              SET CNT-PRINCPL-PAYOFF  TO TRUE                     
C33832           ELSE                                                   
C33832              MOVE SPACES             TO WS-CNT-PRINCPL-PAYOFF    
C33832           END-IF                                                 
C33832        END-IF                                                    
C33832     END-PERFORM                                                  
C33832     .                                                            
C33832 2800-EXIT.                                                       
C33832     EXIT.                                                        
C33832*                                                                         
P00794******************************************************************        
P00794* 2850-SETUP-VAL-FXD-FCTR.                                                
P00794******************************************************************        
P00794 2850-SETUP-VAL-FXD-FCTR.                                         
P00794                                                                  
P00794     MOVE UT-IC-NO                     TO FF-IC-NO.               
P00794     MOVE UT-CODE-UTIL-TYPE            TO FF-CODE-UTIL-TYPE.      
P00794     PERFORM 7750-GET-MAX-SEQ-NO        THRU 7750-EXIT.           
P00794     ADD 1                             TO FF-FIXED-FCTR-SEQ-NO.   
P00794     MOVE 'RECCHGTAX'                  TO FF-FACTOR-ID.           
P00794     MOVE '10'                         TO FF-CMPNT-ID-CD.         
P00794     MOVE 'B'                          TO FF-CODE-SEASON.         
P00794     MOVE 'R'                          TO FF-INSTR-USE-TYPE-CD.   
P00794     MOVE 0                            TO FF-CODE-TIME-PERIOD.    
P00794     MOVE BN-REVENUE-MONTH             TO WS-REVENUE-MONTH.       
P00794     MOVE WS-REVMTH-CCYY               TO WS-EFF-DATE-FROM-YYYY.  
P00794     MOVE WS-REVMTH-MM                 TO WS-EFF-DATE-FROM-MM.    
P00794     MOVE WS-EFF-DATE-FROM             TO FF-EFF-DATE-FROM.       
P00794     MOVE '2999-12-31'                 TO FF-EFF-DATE-TO.         
P00794     MOVE '00'                         TO FF-FIXED-FCTR-TYP-CD.   
P00794     MOVE WS-AMT-DIR-PYMT-NUM          TO FF-FACTOR.              
P00794     MOVE 0                            TO FF-FAC-CHRG-BASE-AM.    
P00794     MOVE 0                            TO FF-RT-PKG-OPT-SEQ-NO.   
P00794     MOVE 1                            TO FF-DURATION-REMAIN-NO.  
P00794     MOVE 0                            TO WS-NULL-VALUE.          
P00794     MOVE WS-CURRENT-TIMESTAMP         TO FF-LAST-UPDATE-TS.      
P00794                                                                  
P00794     PERFORM 8090-INSERT-FACTOR         THRU 8090-EXIT.           
P00794*                                                                         
P00794 2850-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
P00794* 2900-SETUP-VAL-MNT-TRAN.                                                
P00794******************************************************************        
P00794 2900-SETUP-VAL-MNT-TRAN.                                         
P00794                                                                  
P00794********** DATA FOR CSS_MNT_TRANS_HIST                                    
P00794     MOVE WS-CURRENT-TIMESTAMP         TO MH-TRANS-HIST-SEQ-NO    
P00794     MOVE WS-CURRENT-DATE              TO MH-DATE-TRANS           
P00794     MOVE 'F'                          TO MH-CODE-TRAN-TYPE       
P00794     MOVE SPACES                       TO MH-RESP-AREA-ID         
P00794     MOVE AT-ACCOUNT-NO                TO MH-ACCOUNT-NO           
P00794     MOVE AT-CUSTOMER-NO               TO MH-CUSTOMER-NO          
P00794     MOVE AT-PREMISE-NO                TO MH-PREMISE-NO           
P00794     MOVE 'SYSTEM'                     TO MH-USER-ID              
P00794     MOVE +50                          TO MH-TRAN-COMMENT-LEN     
P00794     MOVE WS-RCC-COMMENT               TO MH-TRAN-COMMENT-TEXT    
P00794     MOVE 'PCSCA099'                   TO MH-APPL-PROGRAM-ID      
P00794     MOVE +0                           TO MH-ENTITY-KEY-DESC-LEN  
P00794     MOVE SPACES                       TO MH-ENTITY-KEY-DESC-TEXT 
P00794********** DATA FOR CSS_MT_TRN_HST_DET                                    
P00794     MOVE WS-CURRENT-TIMESTAMP         TO MI-TRANS-HIST-SEQ-NO    
P00794     MOVE 1                            TO MI-TRAN-APPL-NO         
P00794     MOVE 'FACTOR VALUE'               TO MI-COLUMN-DESC          
P00794     MOVE SPACES                       TO MI-TABLE-ID             
P00794     MOVE 7                            TO MI-PRV-COLUMN-VALUE-LEN 
P00794     MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
P00794     MOVE FF-FACTOR                    TO WS-FACTOR-TEXT          
P00794     MOVE WS-FACTOR-TEXT               TO WS-FACT-VAL-Z           
P00794     MOVE WS-FACT-VAL-Z                TO MI-CHG-COLUMN-VALUE-TEXT
P00794     MOVE LENGTH OF MI-CHG-COLUMN-VALUE-TEXT                      
P00794                                       TO MI-CHG-COLUMN-VALUE-LEN 
P00794*                                                                         
P00794     PERFORM 8300-INSERT-MN-TRANS-HIST  THRU 8300-EXIT            
P00794     PERFORM 8400-INSERT-MN-TRN-HST-DET THRU 8400-EXIT            
P00794*                                                                         
P00794     MOVE WS-CURRENT-TIMESTAMP         TO MI-TRANS-HIST-SEQ-NO    
P00794     MOVE 2                            TO MI-TRAN-APPL-NO         
P00794     MOVE 'DURATION'                   TO MI-COLUMN-DESC          
P00794     MOVE +7                           TO MI-PRV-COLUMN-VALUE-LEN 
P00794     MOVE '**NEW**'                    TO MI-PRV-COLUMN-VALUE-TEXT
P00794     MOVE +01                          TO MI-CHG-COLUMN-VALUE-LEN 
P00794     MOVE '1'                          TO MI-CHG-COLUMN-VALUE-TEXT
P00794     MOVE SPACES                       TO MI-TABLE-ID             
P00794     PERFORM 8400-INSERT-MN-TRN-HST-DET THRU 8400-EXIT.           
P00794                                                                  
P00794 2900-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
      * ***********************************************************             
      * 3000-JRNL-SETUP.                                                        
      * ***********************************************************             
       3000-JRNL-SETUP.                                                 
                                                                        
           INITIALIZE                        DCLCSS-AR-TRANS-HIST       
           INITIALIZE                        DCLCSS-AR-TRN-HST-DET      
           MOVE  0                           TO AU-TRAN-APPL-NO.        
           PERFORM 3010-SET-100-JRNL-VARS    THRU 3010-EXIT.            
           PERFORM 3020-SET-AR-VALUES        THRU 3020-EXIT.            
           PERFORM 3030-CASH-DRAWER-101      THRU 3030-EXIT.            
                                                                        
       3000-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3010-SET-100-JRNL-VARS.                                          
             MOVE '3010'               TO ACTIVE-PARAGRAPH.             
T24436       PERFORM 9350-LINK-SCSCO061     THRU 9350-EXIT.             
REARCH*      PERFORM 0700-LOAD-GL-NO-VALUES THRU 0700-EXIT.                     
                                                                        
             MOVE AT-COMPANY-NO TO WS-100-COMPANY-NO.                   
             MOVE AT-COMPANY-NO TO BJ-COMPANY-NO.                       
                                                                        
      *******************************************************                   
      * THESE FILEDS WERE POPULATED BY CALLING CPD00020     *                   
      * (PARAGRAPH 5970) TO ACCESS APPLICATION TABLE 50.    *                   
      *******************************************************                   
             MOVE 9             TO WS-TRAN-OPER-LEVEL.                  
             MOVE 1             TO WS-TRAN-OCAP-FIELD.                  
             MOVE 1             TO WS-TRAN-OCAP-VALUE.                  
             MOVE 'C'           TO WS-TRAN-JRNL-TYPE.                   
             MOVE 'N'           TO WS-TRAN-HOLD-EXEMPT-FLAG.            
                                                                        
      *******************************************************                   
      * THESE FILEDS WERE POPULATED BY CALLING CPD00021     *                   
      * (PARAGRAPH 5980) TO VERIFY USER-ID.                 *                   
      *******************************************************                   
             MOVE WS-USER-ID         TO WS-JRNL-OL-TEMP-ID.             
             MOVE WS-JRNL-CK-OPER-ID TO WS-JRNL-OPERATION-RQST.         
             PERFORM 6400-ONLINE-JRNL-ROUTINE THRU 6400-EXIT.           
             MOVE WS-JRNL-OL-OPR-LOC TO WS-TERM-LOC.                    
                                                                        
      ********************************************************                  
      * CHANGES FOR IMPLEMENTING FIELD CASH SYSTEM.          *                  
      ********************************************************                  
             MOVE WS-01                TO WS-JRNL-OL-COMPANY.           
             MOVE WS-998               TO WS-JRNL-OL-LOC-OFF.           
             MOVE WS-998               TO WS-JRNL-OL-REPORT-NO.         
             MOVE WS-CURRENT-DATE      TO WS-JRNL-OL-REPORT-DT.         
             MOVE 9999                 TO WS-JRNL-OL-CASH-DRWR.         
             MOVE 'CD'                 TO WS-JRNL-OL-AUTH-TYPE.         
                                                                        
             MOVE WS-TERM-LOC          TO WS-JRNL-OL-TERM-LOC           
                                          WS-JRNL-OL-CASH-LOC           
                                          WS-JRNL-OL-OPR-LOC.           
      *                                                                         
             MOVE WS-JRNL-VALIDATE-OPER TO WS-JRNL-OPERATION-RQST.      
             MOVE 'C'                   TO WS-JRNL-SOURCE-CODE.         
                                                                        
             PERFORM 6400-ONLINE-JRNL-ROUTINE      THRU 6400-EXIT.      
      *                                                                         
             MOVE 'A'                  TO WS-100-JRNL-SORT-ID.          
             MOVE AT-COMPANY-NO        TO WS-100-COMPANY-NO.            
             MOVE WS-ACCOUNT-NO-COMP3  TO WS-100-ACCT-NO.               
             MOVE AT-CUSTOMER-NO       TO WS-100-CUSTOMER-NO.           
             MOVE PR-PREMISE-NO        TO WS-100-PREMISE-NO.            
             MOVE AU-TRAN-APPL-NO      TO WS-100-JRNL-TRAN-APPL-NO.     
             MOVE AT-DATE-LAST-ACTION  TO WS-100-DATE-LAST-ACTION.      
             MOVE 'C'                  TO WS-100-CODE-ENTRY-SOURCE.     
             MOVE AT-LOCAL-OFFICE      TO WS-100-LOCAL-OFFICE-CD        
                                          WS-JRNL-OL-CASH-LOC.          
             MOVE SPACES               TO WS-100-TRANS-ERRORS.          
             MOVE 'S350'               TO WS-100-CODE-TERMINAL-TRAN.    
                                                                        
       3010-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3020-SET-AR-VALUES.                                              
                                                                        
           MOVE AT-ACCOUNT-NO         TO AR-ACCOUNT-NO                  
                                         AU-ACCOUNT-NO.                 
T15804     IF PARM-CIA-DEBIT-AMT-NUM > 0                                
              MOVE 'A'                   TO AR-CODE-TRAN-TYPE           
T15804     ELSE                                                         
T15804        MOVE 'S'                   TO AR-CODE-TRAN-TYPE           
T15804     END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO           
                                         AU-TRANS-HIST-SEQ-NO.          
           MOVE PF-RESP-AREA-ID       TO AR-RESP-AREA-ID.               
           MOVE WS-CURRENT-DATE       TO AR-DATE-TRANS.                 
           MOVE WS-AR-CIA-GL-NO (WS-GL-SUB)   TO AU-GL-ACCT-CREDIT.     
           MOVE 0                     TO AU-CODE-AR-AGE.                
           MOVE WS-CURR-ITEM-ID       TO AU-ITEM-ID.                    
           IF PARM-GL-ACCT-NO-NUM > 0 THEN                              
C23844        IF PARM-GL-ACCT-NO EQUAL '1840300'                        
C23844           AND SERV-CARE-CONVERSION                               
C23844               MOVE 'PANEL487B'  TO AR-APPL-PROGRAM-ID            
C23844        ELSE                                                      
C33832           EVALUATE WS-CNT-PRINCPL-PAYOFF                         
C33832              WHEN 'P'                                            
C33832                 MOVE 'PANEL487C' TO AR-APPL-PROGRAM-ID           
C33832              WHEN 'O'                                            
C33832                 MOVE 'PANEL487D' TO AR-APPL-PROGRAM-ID           
C33832              WHEN OTHER                                          
                       MOVE 'PANEL487A' TO AR-APPL-PROGRAM-ID           
C33832           END-EVALUATE                                           
C23844        END-IF                                                    
           ELSE                                                         
              MOVE 'PANEL487'          TO AR-APPL-PROGRAM-ID            
           END-IF.                                                      
P00253*                                                                         
P00253     EVALUATE PARM-COMMENT-TEXT                                   
P00253       WHEN 'REVENUE PROTECTION ELEC UTILITY CHARGES'             
P00253          MOVE 'PANEL161B'       TO AR-APPL-PROGRAM-ID            
P00253       WHEN 'REVENUE PROTECTION KW UTILITY CHARGES'               
P00253          MOVE 'PANEL161C'       TO AR-APPL-PROGRAM-ID            
P00253       WHEN 'REVENUE PROTECTION KVA UTILITY CHARGES'              
P00253          MOVE 'PANEL161D'       TO AR-APPL-PROGRAM-ID            
P00253       WHEN 'REVENUE PROTECTION GAS UTILITY CHARGES'              
P00253          MOVE 'PANEL161E'       TO AR-APPL-PROGRAM-ID            
P00253       WHEN OTHER                                                 
P00253          CONTINUE                                                
P00253     END-EVALUATE.                                                
P00253*                                                                         
           MOVE SPACES                TO AR-PYMT-FACILITY-CD.           
           MOVE '01'                  TO AR-CASH-COMPANY-NO.            
           MOVE '998'                 TO AR-CASH-LOCAL-OFFICE.          
           MOVE '998'                 TO AR-CASH-REPORT-NO.             
           MOVE WS-CURRENT-DATE       TO AR-DATE-CASH-REPORT.           
           MOVE 9999                  TO AR-CASH-DRAWER-ID.             
           MOVE PF-USER-ID            TO AR-USER-ID.                    
           MOVE AT-COMPANY-NO         TO AR-COMPANY-NO.                 
           MOVE SPACES                TO AR-PYMT-RCPT-PRNTD-CD.         
T17642     MOVE PARM-COMMENT-LEN      TO AR-TRAN-COMMENT-LEN.           
T17642     MOVE PARM-COMMENT-TEXT     TO AR-TRAN-COMMENT-TEXT.          
           MOVE SPACES                TO AR-RECORD-ONLY-FL.             
           MOVE SPACES                TO AR-DATE-ORIG-PYMT.             
           MOVE -1                    TO WS-DATE-ORIG-PYMT-IND.         
           MOVE SPACES                TO AU-CODE-CONTRACT-TYPE.         
           MOVE SPACES                TO AU-CURRENCY-TYPE               
           MOVE AU-CURRENCY-TYPE      TO WS-JRNL-CURRENCY-TYPE.         
           MOVE SPACES                TO AR-PYMT-REFUNDED-IND.          
           MOVE SPACES                TO WS-JRNL-CODE-PYMT-FACILITY.    
           MOVE SPACES                TO WS-JRNL-CURRENCY-TYPE.         
                                                                        
       3020-EXIT.                                                       
           EXIT.                                                        
      * ***********************************************************             
      * 3030-CASH-DRAWER-101.                                                   
      * ***********************************************************             
       3030-CASH-DRAWER-101.                                            
      *                                                                         
      *                                                                         
           MOVE 101                     TO WS-101-JRNL-FORMAT-NO.       
                                                                        
           MOVE '998'                   TO WS-101-CASH-DRAWER-USED      
      *                                                                         
T17129     MOVE WS-PAR-ACCT-PERIOD      TO WS-101-REVENUE-MONTH.        
           MOVE AU-CODE-AR-AGE          TO WS-101-AR-AGE.               
           MOVE WS-CURRENT-DATE         TO WS-101-DATE-AR-BILLED.       
           MOVE WS-CURR-ITEM-ID         TO WS-101-ITEM-ID-NO.           
           MOVE 0                       TO WS-101-DETAIL-END-BAL.       
           MOVE 0                       TO WS-101-DETAIL-END-AR-BAL.    
           MOVE AT-TOTAL-AR-BALANCE     TO WS-101-ACCT-END-AR-BAL.      
           MOVE SPACES                  TO WS-101-FUNCTION-CODE.        
           MOVE PR-REV-DISTRICT-CD      TO WS-101-CODE-REVENUE-DISTRICT.
           MOVE CU-CODE-EMPL-ACCT       TO WS-101-CODE-EMPL-ACCT.       
           MOVE AT-CODE-COMPANY-ACCT    TO WS-101-CODE-COMPANY-ACCT.    
           MOVE AT-CODE-ACCT-STAT       TO WS-101-CODE-ACCOUNT-STATUS.  
           MOVE PR-CODE-PREMISE-STAT    TO WS-101-CODE-PREMISE-STATUS.  
      *******************************************************                   
      * POPULATE CWS00013 VARIABLES.                        *                   
      *******************************************************                   
           MOVE SPACES                  TO WS-JRNL-CURRENCY-TYPE.       
           MOVE SPACES                  TO WS-JRNL-CODE-PYMT-FACILITY.  
      *                                                                         
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
      *                                                                         
                                                                        
       3030-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3040-JRNL-CHARGES.                                               
                                                                        
            EVALUATE AC-PYMT-PRIORITY-LVL                               
             WHEN WS-VALUE-19                                           
              MOVE WS-AR-NSC-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-20                                           
              MOVE WS-AR-NSA-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-29                                           
              MOVE WS-AR-NSN-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-30                                           
              MOVE WS-AR-LPC-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-39                                           
              MOVE WS-AR-LPN-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-40                                           
              MOVE WS-AR-UTE-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-45                                           
              MOVE WS-AR-UTG-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-50                                           
              MOVE WS-AR-BUD-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-60                                           
              MOVE WS-AR-CCC-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-70                                           
              MOVE WS-AR-CIA-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-80                                           
              MOVE WS-AR-DEP-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-90                                           
              MOVE WS-AR-DFA-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-100                                          
              MOVE WS-AR-CNT-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
             WHEN WS-VALUE-129                                          
              MOVE WS-AR-PJS-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT      
            END-EVALUATE                                                
                                                                        
ZZZ        IF ( WS-CURR-INPUT-GL-NO > ZERO )                            
ZZZ            MOVE WS-CURR-INPUT-GL-NO         TO AU-GL-ACCT-CREDIT    
ZZZ        ELSE                                                         
ZZZ            MOVE WS-AR-CIA-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-CREDIT    
ZZZ        END-IF                                                       
                                                                        
XXX        ADD  WS-CURR-CORR-AMT      TO WS-AR-AMT-ORIG-ENTERED.        
XXX        MOVE WS-CURR-CORR-AMT      TO AU-AMT-POSTED.                 
XXX        MOVE AT-TOTAL-AR-BALANCE   TO AR-AMT-BILLED-UNPAID           
           MOVE AT-TOTAL-AR-BALANCE   TO WS-101-ACCT-END-AR-BAL         
XXX        MOVE AU-AMT-POSTED         TO AR-AMT-ORIG-ENTERED.           
XXX        MOVE PARM-CIA-DEBIT-AMT-NUM TO WS-101-AMOUNT-ENTERED.        
XXX        MOVE AU-AMT-POSTED         TO WS-101-AMT-POSTED.             
                                                                        
           MOVE WS-CURR-CORR-AMT      TO WS-JRNL-RCV-DEBIT-AMT.         
           MOVE WS-CURR-CORR-AMT      TO WS-JRNL-GEN-LEG-CREDIT-AMT.    
           ADD  1                     TO AU-TRAN-APPL-NO.               
           MOVE AU-TRAN-APPL-NO       TO WS-100-JRNL-TRAN-APPL-NO       
           MOVE AU-GL-ACCT-CREDIT     TO WS-101-ACCT-GEN-LED-CR.        
           MOVE AU-GL-ACCT-DEBIT      TO WS-101-ACCT-GEN-LED-DR.        
           MOVE 0                     TO WS-101-DETAIL-END-BAL.         
           MOVE 0                     TO WS-101-DETAIL-END-AR-BAL.      
           MOVE WS-CURR-ITEM-ID       TO WS-101-ITEM-ID-NO.             
           MOVE WS-CURR-ITEM-ID       TO AC-ITEM-ID.                    
                                                                        
           PERFORM 7000-SELECT-AR-CNTL                                  
              THRU 7000-EXIT.                                           
                                                                        
           COMPUTE WS-101-DETAIL-END-AR-BAL =   AC-AMT-AR-DAY-00        
                                             +  AC-AMT-AR-DAY-30        
                                             +  AC-AMT-AR-DAY-60        
                                             +  AC-AMT-AR-DAY-90        
                                             +  AC-AMT-UNUSED-CR        
           END-COMPUTE.                                                 
                                                                        
                                                                        
           IF AC-PYMT-PRIORITY-LVL < 50                                 
              MOVE WS-101-DETAIL-END-AR-BAL TO WS-101-DETAIL-END-BAL    
           ELSE                                                         
              MOVE AC-AMT-TRAN-BALANCE      TO WS-101-DETAIL-END-BAL    
           END-IF                                                       
                                                                        
           IF WS-101-ITEM-ID-NO = 0                                     
              MOVE ZERO                     TO WS-101-DETAIL-END-BAL    
              MOVE ZERO                     TO WS-101-DETAIL-END-AR-BAL 
           END-IF                                                       
                                                                        
           MOVE CJF00101              TO WS-100-USER-DEFINED-AREA.      
           MOVE WS-JRNL-ONLY          TO WS-JRNL-OPERATION-RQST.        
           PERFORM 6400-ONLINE-JRNL-ROUTINE       THRU 6400-EXIT.       
           IF WS-JRNL-RTRN-CODE NOT = WS-JRNL-SUCCESS                   
               PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT        
               PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT        
           END-IF.                                                      
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST  THRU 6500-EXIT.       
                                                                        
       3040-EXIT.                                                       
           EXIT.                                                        
                                                                        
       3050-JRNL-CIA-DEBIT.                                             
                                                                        
XXX        MOVE WS-CURR-CORR-AMT        TO AU-AMT-POSTED.               
XXX        MOVE AT-TOTAL-AR-BALANCE     TO AR-AMT-BILLED-UNPAID         
XXX        MOVE AU-AMT-POSTED           TO AR-AMT-ORIG-ENTERED.         
XXX        MOVE WS-CURR-CORR-AMT        TO WS-101-AMOUNT-ENTERED.       
XXX        MOVE AU-AMT-POSTED           TO WS-101-AMT-POSTED.           
                                                                        
           MOVE WS-CURR-CORR-AMT        TO WS-JRNL-RCV-CREDIT-AMT.      
           MOVE WS-CURR-CORR-AMT        TO WS-JRNL-CASH-DEBIT-AMT.      
           MOVE WS-AR-CIA-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-CREDIT        
           MOVE WS-CLR-CASH-GL-NO (WS-GL-SUB) TO AU-GL-ACCT-DEBIT       
           ADD  1                       TO AU-TRAN-APPL-NO.             
           MOVE AU-TRAN-APPL-NO         TO WS-100-JRNL-TRAN-APPL-NO     
           MOVE AU-GL-ACCT-CREDIT       TO WS-101-ACCT-GEN-LED-CR.      
           MOVE AU-GL-ACCT-DEBIT        TO WS-101-ACCT-GEN-LED-DR.      
           MOVE CJF00101                TO WS-100-USER-DEFINED-AREA.    
           MOVE WS-JRNL-ONLY            TO WS-JRNL-OPERATION-RQST.      
           PERFORM 6400-ONLINE-JRNL-ROUTINE       THRU 6400-EXIT.       
           IF WS-JRNL-RTRN-CODE NOT = WS-JRNL-SUCCESS                   
               PERFORM 9000-SEND-ERROR-RESULT     THRU 9000-EXIT        
               PERFORM 9900-SQL-ERROR-ROUTINE     THRU 9900-EXIT        
           END-IF.                                                      
           PERFORM 6500-ONLINE-LOAD-AR-TRAN-HIST  THRU 6500-EXIT.       
                                                                        
       3050-EXIT.                                                       
           EXIT.                                                        
                                                                        
      * **********************************************************              
      * 7000-SELECT-AR-CNTL.                                                    
      * **********************************************************              
       7000-SELECT-AR-CNTL.                                             
      *                                                                         
           EXEC SQL                                                     
                 SELECT   AMT_AR_DAY_00                                 
                        , AMT_AR_DAY_30                                 
                        , AMT_AR_DAY_60                                 
                        , AMT_AR_DAY_90                                 
                        , AMT_TRAN_BALANCE                              
                        , AMT_UNUSED_CR                                 
                        , REPLACE(REPLACE(CONVERT(CHAR(26), 
           LAST_UPDATE_TS, 121), ' ', '-'), ':', '.') LAST_UPDATE_TS           
                        , TOT_SUMM_UNBILLED                             
                   INTO   :AC-AMT-AR-DAY-00                             
                        , :AC-AMT-AR-DAY-30                             
                        , :AC-AMT-AR-DAY-60                             
                        , :AC-AMT-AR-DAY-90                             
                        , :AC-AMT-TRAN-BALANCE                          
                        , :AC-AMT-UNUSED-CR                             
                        , :AC-LAST-UPDATE-TS                            
                        , :AC-TOT-SUMM-UNBILLED                         
                   FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                     
                  WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO            
                    AND   PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL     
                    AND   ITEM_ID           = :AC-ITEM-ID               
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT   AMT_AR_DAY_00                                         
MFA-TR*                 , AMT_AR_DAY_30                                         
MFA-TR*                 , AMT_AR_DAY_60                                         
MFA-TR*                 , AMT_AR_DAY_90                                         
MFA-TR*                 , AMT_TRAN_BALANCE                                      
MFA-TR*                 , AMT_UNUSED_CR                                         
MFA-TR*                 , LAST_UPDATE_TS                                        
MFA-TR*                 , TOT_SUMM_UNBILLED                                     
MFA-TR*            INTO   :AC-AMT-AR-DAY-00                                     
MFA-TR*                 , :AC-AMT-AR-DAY-30                                     
MFA-TR*                 , :AC-AMT-AR-DAY-60                                     
MFA-TR*                 , :AC-AMT-AR-DAY-90                                     
MFA-TR*                 , :AC-AMT-TRAN-BALANCE                                  
MFA-TR*                 , :AC-AMT-UNUSED-CR                                     
MFA-TR*                 , :AC-LAST-UPDATE-TS                                    
MFA-TR*                 , :AC-TOT-SUMM-UNBILLED                                 
MFA-TR*            FROM   CSS_AR_CNTL                                           
MFA-TR*           WHERE   ACCOUNT_NO        = :AC-ACCOUNT-NO                    
MFA-TR*             AND   PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL             
MFA-TR*             AND   ITEM_ID           = :AC-ITEM-ID                       
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7000                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
              OR WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE '7000'                    TO   ACTIVE-PARAGRAPH      
CBSI          MOVE 'SELECT'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_AR_CNTL      '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'ITEM-ID     '            TO   TABLE-ELEMENT-3       
              MOVE AC-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE AC-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE AC-ITEM-ID                TO   HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7010-INSERT-AR-CNTL                                            *        
      ******************************************************************        
       7010-INSERT-AR-CNTL.                                             
           MOVE '7010'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_AR_CNTL                                 
                       (  ACCOUNT_NO                                    
                        , AMT_AR_DAY_00                                 
                        , AMT_AR_DAY_30                                 
                        , AMT_AR_DAY_60                                 
                        , AMT_AR_DAY_90                                 
                        , AMT_TRAN_BALANCE                              
                        , AMT_UNUSED_CR                                 
                        , ITEM_ID                                       
                        , LAST_UPDATE_TS                                
                        , PYMT_PRIORITY_LVL                             
                        , TOT_SUMM_UNBILLED )                           
                VALUES (  :AC-ACCOUNT-NO                                
                        , :AC-AMT-AR-DAY-00                             
                        , :AC-AMT-AR-DAY-30                             
                        , :AC-AMT-AR-DAY-60                             
                        , :AC-AMT-AR-DAY-90                             
                        , :AC-AMT-TRAN-BALANCE                          
                        , :AC-AMT-UNUSED-CR                             
                        , :AC-ITEM-ID                                   
                        , CIS.CHAR2TIMESTAMP(:WS-CURRENT-TIMESTAMP)             
                        , :AC-PYMT-PRIORITY-LVL                         
                        , :AC-TOT-SUMM-UNBILLED )                       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_AR_CNTL                                         
MFA-TR*                (  ACCOUNT_NO                                            
MFA-TR*                 , AMT_AR_DAY_00                                         
MFA-TR*                 , AMT_AR_DAY_30                                         
MFA-TR*                 , AMT_AR_DAY_60                                         
MFA-TR*                 , AMT_AR_DAY_90                                         
MFA-TR*                 , AMT_TRAN_BALANCE                                      
MFA-TR*                 , AMT_UNUSED_CR                                         
MFA-TR*                 , ITEM_ID                                               
MFA-TR*                 , LAST_UPDATE_TS                                        
MFA-TR*                 , PYMT_PRIORITY_LVL                                     
MFA-TR*                 , TOT_SUMM_UNBILLED )                                   
MFA-TR*         VALUES (  :AC-ACCOUNT-NO                                        
MFA-TR*                 , :AC-AMT-AR-DAY-00                                     
MFA-TR*                 , :AC-AMT-AR-DAY-30                                     
MFA-TR*                 , :AC-AMT-AR-DAY-60                                     
MFA-TR*                 , :AC-AMT-AR-DAY-90                                     
MFA-TR*                 , :AC-AMT-TRAN-BALANCE                                  
MFA-TR*                 , :AC-AMT-UNUSED-CR                                     
MFA-TR*                 , :AC-ITEM-ID                                           
MFA-TR*                 , :WS-CURRENT-TIMESTAMP                                 
MFA-TR*                 , :AC-PYMT-PRIORITY-LVL                                 
MFA-TR*                 , :AC-TOT-SUMM-UNBILLED )                               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              PERFORM 2710-UPDATE-CODES-DATA THRU 2710-EXIT             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO   RS-RETURN-CODE        
T18186        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7010'                    TO   ACTIVE-PARAGRAPH      
CBSI          MOVE 'INSERT'                  TO   ABEND-FUNCTION        
              MOVE SPACES                    TO   ABEND-TABLES          
              MOVE SPACES                    TO   ABEND-SQL-PREDICATES  
              MOVE 'CSS_AR_CNTL   '          TO   TABLE-1               
              MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'ITEM-ID     '            TO   TABLE-ELEMENT-3       
CBSI          MOVE 'AMT_TRAN_BALANCE'        TO   TABLE-ELEMENT-4       
              MOVE AC-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE AC-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
              MOVE AC-ITEM-ID                TO   HOSTVAR-ELEMENT-3     
CBSI          MOVE AC-AMT-TRAN-BALANCE      TO WS-AC-AMT-TRAN-BALANCE-ED
CBSI          MOVE WS-AC-AMT-TRAN-BALANCE-ED TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
       7010-EXIT.                                                       
            EXIT.                                                       
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7020-UPD-ARCNTL-ZERO-DAY-ONLY.                                 *        
      ******************************************************************        
       7020-UPD-ARCNTL-ZERO-DAY-ONLY.                                   
           MOVE '7020'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00              
                   , LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_CNTL                                                
MFA-TR*         SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00                      
MFA-TR*            , LAST_UPDATE_TS    = :WS-CURRENT-TIMESTAMP                  
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
CBSI          MOVE 'UPDATE'                   TO   ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-2      
              MOVE 'ITEM-ID     '             TO   TABLE-ELEMENT-3      
CBSI          MOVE 'AMT_AR_DAY_00'            TO   TABLE-ELEMENT-4      
              MOVE AC-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE AC-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-2    
              MOVE AC-ITEM-ID                 TO   HOSTVAR-ELEMENT-3    
CBSI          MOVE AC-AMT-AR-DAY-00          TO   WS-AC-AMT-AR-DAY-00-ED
CBSI          MOVE WS-AC-AMT-AR-DAY-00-ED    TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7020-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7030-UPD-ARCNTL-ZERO-N-TRANBAL.                                *        
      ******************************************************************        
       7030-UPD-ARCNTL-ZERO-N-TRANBAL.                                  
           MOVE '7030'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00              
                   , AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE           
                   , LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_CNTL                                                
MFA-TR*         SET  AMT_AR_DAY_00     = :AC-AMT-AR-DAY-00                      
MFA-TR*            , AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE                   
MFA-TR*            , LAST_UPDATE_TS    = :WS-CURRENT-TIMESTAMP                  
MFA-TR*        WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                         
MFA-TR*          AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL                  
MFA-TR*          AND ITEM_ID           = :AC-ITEM-ID                            
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
CBSI          MOVE 'UPDATE'                   TO   ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-2      
              MOVE 'ITEM-ID     '             TO   TABLE-ELEMENT-3      
CBSI          MOVE 'LAST_UPDATE_TS'           TO   TABLE-ELEMENT-4      
              MOVE AC-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE AC-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-2    
              MOVE AC-ITEM-ID                 TO   HOSTVAR-ELEMENT-3    
CBSI          MOVE WS-CURRENT-TIMESTAMP       TO   HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7030-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7040-UPD-ARCNTL-UNUSED-CR.                                              
      ******************************************************************        
       7040-UPD-ARCNTL-UNUSED-CR.                                       
           MOVE '7040'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                SET  AMT_UNUSED_CR     = :AC-AMT-UNUSED-CR              
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
CBSI          MOVE 'UPDATE'                   TO   ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-2      
              MOVE 'ITEM-ID     '             TO   TABLE-ELEMENT-3      
CBSI          MOVE 'AMT_UNUSED_CR'            TO   TABLE-ELEMENT-4      
              MOVE AC-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE AC-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-2    
              MOVE AC-ITEM-ID                 TO   HOSTVAR-ELEMENT-3    
CBSI          MOVE AC-AMT-UNUSED-CR          TO   WS-AC-AMT-UNUSED-CR-ED
CBSI          MOVE WS-AC-AMT-UNUSED-CR-ED    TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7040-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7045-UPD-ARCNTL-TRANBAL.                                                
      ******************************************************************        
       7045-UPD-ARCNTL-TRANBAL.                                         
           MOVE '7045'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_CNTL                                        
                SET  AMT_TRAN_BALANCE  = :AC-AMT-TRAN-BALANCE           
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
CBSI          MOVE 'UPDATE'                   TO   ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-2      
              MOVE 'ITEM-ID     '             TO   TABLE-ELEMENT-3      
CBSI          MOVE 'AMT_TRAN_BALANCE'         TO   TABLE-ELEMENT-4      
              MOVE AC-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE AC-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-2    
              MOVE AC-ITEM-ID                 TO   HOSTVAR-ELEMENT-3    
CBSI          MOVE AC-AMT-TRAN-BALANCE       TO   WS-AMT-TRAN-BALANCE-ED
CBSI          MOVE WS-AMT-TRAN-BALANCE-ED     TO   HOSTVAR-ELEMENT-4    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7045-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7050-DEL-ARCNTL.                                                        
      ******************************************************************        
       7050-DEL-ARCNTL.                                                 
           MOVE '7050'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              DELETE FROM CSS_AR_CNTL                                   
               WHERE ACCOUNT_NO        = :AC-ACCOUNT-NO                 
                 AND PYMT_PRIORITY_LVL = :AC-PYMT-PRIORITY-LVL          
                 AND ITEM_ID           = :AC-ITEM-ID                    
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
CBSI          MOVE 'DELETE'                   TO   ABEND-FUNCTION       
              MOVE 'CSS_AR_CNTL       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
              MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-2      
              MOVE 'ITEM-ID     '             TO   TABLE-ELEMENT-3      
              MOVE AC-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
              MOVE AC-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-2    
              MOVE AC-ITEM-ID                 TO   HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7050-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7100-UPD-CSS-DFA-STATUS.                                                
      ******************************************************************        
       7100-UPD-CSS-DFA-STATUS.                                         
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
                 UPDATE CSS_DFA_ACCT                                    
                    SET   CODE_DFA_STATUS   = :DA-CODE-DFA-STATUS       
                  WHERE   ACCOUNT_NO        = :DA-ACCOUNT-NO            
                    AND   PYMT_PRIORITY_LVL = :DA-PYMT-PRIORITY-LVL     
                    AND   DFA_ITEM_ID       = :DA-DFA-ITEM-ID           
                    AND   CODE_DFA_TYPE     = :DA-CODE-DFA-TYPE         
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
              OR WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'UPDATE'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_DFA_ACCT     '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'DFA_ITEM_ID      '       TO   TABLE-ELEMENT-3       
CBSI          MOVE 'CODE_DFA_TYPE'           TO   TABLE-ELEMENT-4       
              MOVE DA-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DA-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE DA-DFA-ITEM-ID            TO   HOSTVAR-ELEMENT-3     
CBSI          MOVE DA-CODE-DFA-TYPE          TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7110-SELECT-DFA-RECVBLE.                                                
      ******************************************************************        
       7110-SELECT-DFA-RECVBLE.                                         
           MOVE '7110'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                 SELECT   ACCOUNT_NO                                    
                        , PYMT_PRIORITY_LVL                             
                        , AGREEMENT_NO                                  
                        , AMT_CONTRACT_DEFR                             
                        , AMT_DAY_00                                    
                        , AMT_DAY_30                                    
                        , AMT_DAY_60                                    
                        , AMT_DAY_90                                    
                        , DFA_PYMT_PRIORITY                             
                   INTO   :DV-ACCOUNT-NO                                
                        , :DV-PYMT-PRIORITY-LVL                         
                        , :DV-AGREEMENT-NO                              
                        , :DV-AMT-CONTRACT-DEFR                         
                        , :DV-AMT-DAY-00                                
                        , :DV-AMT-DAY-30                                
                        , :DV-AMT-DAY-60                                
                        , :DV-AMT-DAY-90                                
                        , :DV-DFA-PYMT-PRIORITY                         
                   FROM   CSS_DFA_RECVBLE WITH(READUNCOMMITTED)                 
                  WHERE   ACCOUNT_NO        = :DV-ACCOUNT-NO            
                    AND   PYMT_PRIORITY_LVL = :DV-PYMT-PRIORITY-LVL     
                    AND   DFA_PYMT_PRIORITY = :DV-DFA-PYMT-PRIORITY     
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT   ACCOUNT_NO                                            
MFA-TR*                 , PYMT_PRIORITY_LVL                                     
MFA-TR*                 , AGREEMENT_NO                                          
MFA-TR*                 , AMT_CONTRACT_DEFR                                     
MFA-TR*                 , AMT_DAY_00                                            
MFA-TR*                 , AMT_DAY_30                                            
MFA-TR*                 , AMT_DAY_60                                            
MFA-TR*                 , AMT_DAY_90                                            
MFA-TR*                 , DFA_PYMT_PRIORITY                                     
MFA-TR*            INTO   :DV-ACCOUNT-NO                                        
MFA-TR*                 , :DV-PYMT-PRIORITY-LVL                                 
MFA-TR*                 , :DV-AGREEMENT-NO                                      
MFA-TR*                 , :DV-AMT-CONTRACT-DEFR                                 
MFA-TR*                 , :DV-AMT-DAY-00                                        
MFA-TR*                 , :DV-AMT-DAY-30                                        
MFA-TR*                 , :DV-AMT-DAY-60                                        
MFA-TR*                 , :DV-AMT-DAY-90                                        
MFA-TR*                 , :DV-DFA-PYMT-PRIORITY                                 
MFA-TR*            FROM   CSS_DFA_RECVBLE                                       
MFA-TR*           WHERE   ACCOUNT_NO        = :DV-ACCOUNT-NO                    
MFA-TR*             AND   PYMT_PRIORITY_LVL = :DV-PYMT-PRIORITY-LVL             
MFA-TR*             AND   DFA_PYMT_PRIORITY = :DV-DFA-PYMT-PRIORITY             
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7110                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
              OR WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'SELECT'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_DFA_RECVBLE  '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
CBSI          MOVE 'DFA_PYMT_PRIORITY'       TO   TABLE-ELEMENT-3       
              MOVE DV-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DV-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE DV-DFA-PYMT-PRIORITY      TO   HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7110-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7120-UPDATE-DFA-RECVBLE.                                                
      ******************************************************************        
       7120-UPDATE-DFA-RECVBLE.                                         
           MOVE '7120'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                 UPDATE CSS_DFA_RECVBLE                                 
                    SET   AMT_CONTRACT_DEFR  = :DV-AMT-CONTRACT-DEFR    
                        , AMT_DAY_00         = :DV-AMT-DAY-00           
                  WHERE   ACCOUNT_NO        = :DV-ACCOUNT-NO            
                    AND   PYMT_PRIORITY_LVL = :DV-PYMT-PRIORITY-LVL     
                    AND   DFA_PYMT_PRIORITY = :DV-DFA-PYMT-PRIORITY     
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'UPDATE'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_DFA_RECVBLE  '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
CBSI          MOVE 'DFA_PYMT_PRIORITY'       TO   TABLE-ELEMENT-3       
CBSI          MOVE 'AMT_DAY_00'              TO   TABLE-ELEMENT-4       
              MOVE DV-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DV-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE DV-DFA-PYMT-PRIORITY      TO   HOSTVAR-ELEMENT-3     
CBSI          MOVE DV-AMT-DAY-00             TO   WS-DV-AMT-DAY-00-ED   
CBSI          MOVE WS-DV-AMT-DAY-00-ED       TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7120-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7130-INSERT-DFA-RECVBLE.                                                
      ******************************************************************        
       7130-INSERT-DFA-RECVBLE.                                         
           MOVE '7130'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                 INSERT INTO CSS_DFA_RECVBLE                            
                      (   ACCOUNT_NO                                    
                        , PYMT_PRIORITY_LVL                             
                        , AGREEMENT_NO                                  
                        , AMT_CONTRACT_DEFR                             
                        , AMT_DAY_00                                    
                        , AMT_DAY_30                                    
                        , AMT_DAY_60                                    
                        , AMT_DAY_90                                    
                        , DFA_PYMT_PRIORITY                             
                       )                                                
                  VALUES ( :DV-ACCOUNT-NO                               
                          ,:DV-PYMT-PRIORITY-LVL                        
                          ,:DV-AGREEMENT-NO                             
                          ,:DV-AMT-CONTRACT-DEFR                        
                          ,:DV-AMT-DAY-00                               
                          ,:DV-AMT-DAY-30                               
                          ,:DV-AMT-DAY-60                               
                          ,:DV-AMT-DAY-90                               
                          ,:DV-DFA-PYMT-PRIORITY                        
                          )                                             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'INSERT'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_DFA_RECVBLE  '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'AGREEMENT_NO     '       TO   TABLE-ELEMENT-3       
              MOVE 'DFA_PYMT_PRIORITY'       TO   TABLE-ELEMENT-4       
              MOVE DV-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DV-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE DV-AGREEMENT-NO           TO   HOSTVAR-ELEMENT-3     
CBSI          MOVE DV-DFA-PYMT-PRIORITY      TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7130-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7200-UPD-CSS-DEP-ON-HAND.                                               
      ******************************************************************        
       7200-UPD-CSS-DEP-ON-HAND.                                        
           MOVE '7200'               TO ACTIVE-PARAGRAPH.               
           MOVE -1                   TO WS-DEP-CERT-NULL-IND            
                                                                        
           EXEC SQL                                                     
                 UPDATE CSS_DEP_ON_HAND                                 
                    SET DEPOSIT_STATUS_CD  = :WS-A                      
                      , DATE_CERT_ISSUE    = IIF(TRY_CONVERT(DATE, 
                                                   :DO-DATE-CERT-ISSUE 
                                                  :WS-DEP-CERT-NULL-IND
              ) IS NULL OR (PATINDEX('%.%', :DO-DATE-CERT-ISSUE 
                                                  :WS-DEP-CERT-NULL-IND
              ) <> 0) OR (LEN(:DO-DATE-CERT-ISSUE :WS-DEP-CERT-NULL-IND
              ) <> 10), CIS.CHAR2DATE(:DO-DATE-CERT-ISSUE 
                                                  :WS-DEP-CERT-NULL-IND
              ), CONVERT(DATE, :DO-DATE-CERT-ISSUE 
                                                  :WS-DEP-CERT-NULL-IND
              ) )      
                  WHERE ACCOUNT_NO         = :DO-ACCOUNT-NO             
                    AND DEPOSIT_CERT_NO    = :DO-DEPOSIT-CERT-NO        
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*          UPDATE CSS_DEP_ON_HAND                                         
MFA-TR*             SET DEPOSIT_STATUS_CD  = :WS-A                              
MFA-TR*               , DATE_CERT_ISSUE    = :DO-DATE-CERT-ISSUE                
MFA-TR*                                      :WS-DEP-CERT-NULL-IND              
MFA-TR*           WHERE ACCOUNT_NO         = :DO-ACCOUNT-NO                     
MFA-TR*             AND DEPOSIT_CERT_NO    = :DO-DEPOSIT-CERT-NO                
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'UPDATE'                  TO   ABEND-FUNCTION        
              MOVE 'CSS_DEP_ON_HAND  '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'DEPOSIT_CERT_NO  '       TO   TABLE-ELEMENT-2       
CBSI          MOVE 'DEPOSIT_STATUS_CD'       TO   TABLE-ELEMENT-3       
CBSI          MOVE 'DATE_CERT_ISSUE  '       TO   TABLE-ELEMENT-4       
              MOVE DO-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DO-DEPOSIT-CERT-NO        TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE WS-A                      TO   HOSTVAR-ELEMENT-3     
CBSI          MOVE DO-DATE-CERT-ISSUE        TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      *                                                                         
      ******************************************************************        
      * 7300-OPEN-DEP-PAY-HIST.                                                 
      ******************************************************************        
       7300-OPEN-DEP-PAY-HIST.                                          
           MOVE '7300'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
                 OPEN DEP-PAY-HIST                                      
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'OPEN'                    TO   ABEND-FUNCTION        
              MOVE 'CSS_DEP_PAY_HST  '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'DEPOSIT_CERT_NO  '       TO   TABLE-ELEMENT-2       
              MOVE DP-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DP-DEPOSIT-CERT-NO        TO   HOSTVAR-ELEMENT-2     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
      *                                                                         
      ******************************************************************        
      * 7310-FETCH-DEP-PAY-HIST.                                                
      ******************************************************************        
       7310-FETCH-DEP-PAY-HIST.                                         
           MOVE '7310'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
                 FETCH DEP-PAY-HIST                                     
                 INTO  :DP-ACCOUNT-NO                                   
                     , :DP-DEPOSIT-CERT-NO                              
                     , :DP-DEP-PAY-DT                                   
                     , :DP-DEP-PAY-AMT                                  
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'FETCH'                   TO   ABEND-FUNCTION        
              MOVE 'CSS_DEP_PAY_HST  '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'DEPOSIT_CERT_NO  '       TO   TABLE-ELEMENT-2       
              MOVE DP-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DP-DEPOSIT-CERT-NO        TO   HOSTVAR-ELEMENT-2     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7310-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7320-CLOSE-DEP-PAY-HIST.                                                
      ******************************************************************        
       7320-CLOSE-DEP-PAY-HIST.                                         
           MOVE '7320'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
                 CLOSE DEP-PAY-HIST                                     
           END-EXEC                                                     

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'CLOSE'                   TO  ABEND-FUNCTION         
              MOVE 'CSS_DEP_PAY_HST  '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'DEPOSIT_CERT_NO  '       TO   TABLE-ELEMENT-2       
              MOVE DP-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DP-DEPOSIT-CERT-NO        TO   HOSTVAR-ELEMENT-2     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7320-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 7330-DELETE-DEP-PAY-HIST.                                               
      ******************************************************************        
       7330-DELETE-DEP-PAY-HIST.                                        
           MOVE '7330'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                 DELETE FROM CSS_DEP_PAY_HST                            
                  WHERE ACCOUNT_NO      = :DP-ACCOUNT-NO                
                    AND DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO           
                    AND DEP_PAY_DT      = IIF(TRY_CONVERT(DATE, 
                                                         :DP-DEP-PAY-DT
              ) IS NULL OR (PATINDEX('%.%', :DP-DEP-PAY-DT
              ) <> 0) OR (LEN(:DP-DEP-PAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :DP-DEP-PAY-DT
              ), CONVERT(DATE, :DP-DEP-PAY-DT) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*          DELETE FROM CSS_DEP_PAY_HST                                    
MFA-TR*           WHERE ACCOUNT_NO      = :DP-ACCOUNT-NO                        
MFA-TR*             AND DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO                   
MFA-TR*             AND DEP_PAY_DT      = :DP-DEP-PAY-DT                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'DELETE'                  TO  ABEND-FUNCTION         
              MOVE 'CSS_DEP_PAY_HIST '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'DEPOSIT_CERT_NO  '       TO   TABLE-ELEMENT-2       
CBSI          MOVE 'DEP_PAY_DT'              TO   TABLE-ELEMENT-3       
              MOVE DP-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DP-DEPOSIT-CERT-NO        TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE DP-DEP-PAY-DT             TO   HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7330-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7340-UPDATE-DEP-PAY-HIST.                                               
      ******************************************************************        
       7340-UPDATE-DEP-PAY-HIST.                                        
           MOVE '7340'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                 UPDATE CSS_DEP_PAY_HST                                 
                  SET DEP_PAY_AMT       = :DP-DEP-PAY-AMT               
                  WHERE ACCOUNT_NO      = :DP-ACCOUNT-NO                
                    AND DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO           
                    AND DEP_PAY_DT      = IIF(TRY_CONVERT(DATE, 
                                                         :DP-DEP-PAY-DT
              ) IS NULL OR (PATINDEX('%.%', :DP-DEP-PAY-DT
              ) <> 0) OR (LEN(:DP-DEP-PAY-DT) <> 10), CIS.CHAR2DATE(
                                                         :DP-DEP-PAY-DT
              ), CONVERT(DATE, :DP-DEP-PAY-DT) )                
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*          UPDATE CSS_DEP_PAY_HST                                         
MFA-TR*           SET DEP_PAY_AMT       = :DP-DEP-PAY-AMT                       
MFA-TR*           WHERE ACCOUNT_NO      = :DP-ACCOUNT-NO                        
MFA-TR*             AND DEPOSIT_CERT_NO = :DP-DEPOSIT-CERT-NO                   
MFA-TR*             AND DEP_PAY_DT      = :DP-DEP-PAY-DT                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'UPDATE'                  TO  ABEND-FUNCTION         
              MOVE 'CSS_DEP_PAY_HIST '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'DEPOSIT_CERT_NO  '       TO   TABLE-ELEMENT-2       
CBSI          MOVE 'DEP_PAY_DT'              TO   TABLE-ELEMENT-3       
CBSI          MOVE 'DEP_PAY_AMT'             TO   TABLE-ELEMENT-4       
              MOVE DP-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE DP-DEPOSIT-CERT-NO        TO   HOSTVAR-ELEMENT-2     
CBSI          MOVE DP-DEP-PAY-DT             TO   HOSTVAR-ELEMENT-3     
CBSI          MOVE DP-DEP-PAY-AMT            TO   WS-DP-DEP-PAY-AMT-ED  
CBSI          MOVE WS-DP-DEP-PAY-AMT-ED      TO   HOSTVAR-ELEMENT-4     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7340-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7350-UPDATE-CONTRACT.                                                   
      ******************************************************************        
       7350-UPDATE-CONTRACT.                                            
           MOVE '7350'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                 UPDATE CSS_CONTRACT                                    
                  SET CNT_STATUS_CD       = :CT-CNT-STATUS-CD           
                  WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO              
                    AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL       
                    AND CNT_ITEM_ID       = :CT-CNT-ITEM-ID             
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'UPDATE'                  TO  ABEND-FUNCTION         
              MOVE 'CSS_CONTRACT     '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'CNT_ITEM_ID      '       TO   TABLE-ELEMENT-3       
CBSI          MOVE 'CNT_STATUS_CD'           TO   TABLE-ELEMENT-4       
              MOVE CT-ACCOUNT-NO       TO   HOSTVAR-ELEMENT-1           
              MOVE CT-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
              MOVE CT-CNT-ITEM-ID       TO   HOSTVAR-ELEMENT-3          
CBSI          MOVE CT-CNT-STATUS-CD          TO HOSTVAR-ELEMENT-4       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7350-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ******************************************************************        
      * 7355-SELECT-CONTRACT.                                                   
      ******************************************************************        
       7355-SELECT-CONTRACT.                                            
           MOVE '7355'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
                 SELECT CNT_STATUS_CD,                                  
T20669                  AMT_MO_PYMT                                     
                   INTO :CT-CNT-STATUS-CD,                              
T20669                  :CT-AMT-MO-PYMT                                 
                   FROM CSS_CONTRACT WITH(READUNCOMMITTED)                      
                  WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO              
                    AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL       
                    AND CNT_ITEM_ID       = :CT-CNT-ITEM-ID             
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT CNT_STATUS_CD,                                          
MFA-TR*                 AMT_MO_PYMT                                             
MFA-TR*            INTO :CT-CNT-STATUS-CD,                                      
MFA-TR*                 :CT-AMT-MO-PYMT                                         
MFA-TR*            FROM CSS_CONTRACT                                            
MFA-TR*           WHERE ACCOUNT_NO        = :CT-ACCOUNT-NO                      
MFA-TR*             AND PYMT_PRIORITY_LVL = :CT-PYMT-PRIORITY-LVL               
MFA-TR*             AND CNT_ITEM_ID       = :CT-CNT-ITEM-ID                     
MFA-TR*            WITH UR                                                      
MFA-TR*         QUERYNO 7355                                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
                                                                        
           IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE SQLCODE                   TO   RS-RETURN-CODE        
              MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE 'SELECT '                 TO   ABEND-FUNCTION        
              MOVE 'CSS_CONTRACT     '       TO   TABLE-1               
              MOVE 'ACCOUNT_NO       '       TO   TABLE-ELEMENT-1       
              MOVE 'PYMT_PRIORITY_LVL'       TO   TABLE-ELEMENT-2       
              MOVE 'CNT_ITEM_ID      '       TO   TABLE-ELEMENT-3       
              MOVE CT-ACCOUNT-NO             TO   HOSTVAR-ELEMENT-1     
              MOVE CT-PYMT-PRIORITY-LVL      TO   HOSTVAR-ELEMENT-2     
              MOVE CT-CNT-ITEM-ID            TO   HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
       7355-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
HPCCDM*    EJECT                                                                
      ****************************************************************          
      * 7400-GET-CURRENT-TIMESTAMP.                               *             
      ****************************************************************          
                                                                        
       7400-GET-CURRENT-TIMESTAMP.                                      
           EXEC SQL                                                     
                SELECT
              REPLACE(REPLACE(CONVERT(CHAR(26), CIS.CURRENT$TIMESTAMP()
           , 121), ' ', '-'), ':', '.')
            INTO
              :WS-CURRENT-TIMESTAMP           
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-TIMESTAMP = CURRENT TIMESTAMP                   
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
CBSI       MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
CBSI       IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
CBSI           NEXT SENTENCE                                            
CBSI       ELSE                                                         
CBSI          MOVE SQLCODE                   TO   RS-RETURN-CODE        
CBSI          MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE '7400'                    TO   ACTIVE-PARAGRAPH      
CBSI          MOVE 'SET'                     TO   ABEND-FUNCTION        
CBSI          MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
CBSI          MOVE PARM-ACCOUNT-NO           TO   HOSTVAR-ELEMENT-1     
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
CBSI       END-IF.                                                      
           EXEC SQL                                                     
                SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE                     
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SET :WS-CURRENT-DATE = CURRENT DATE                             
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

CBSI       MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE   
CBSI       IF WS-ACTIVE-RETURN-CODE     EQUAL  SUCCESSFUL-CALL          
CBSI           NEXT SENTENCE                                            
CBSI       ELSE                                                         
CBSI          MOVE SQLCODE                   TO   RS-RETURN-CODE        
CBSI          MOVE PROGRAM-NAME              TO   ABEND-PROGRAM         
CBSI          MOVE '7400'                    TO   ACTIVE-PARAGRAPH      
CBSI          MOVE 'SET'                     TO   ABEND-FUNCTION        
CBSI          MOVE 'ACCOUNT_NO    '          TO   TABLE-ELEMENT-1       
CBSI          MOVE PARM-ACCOUNT-NO           TO   HOSTVAR-ELEMENT-1     
CBSI          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
CBSI          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
CBSI       END-IF.                                                      
                                                                        
           MOVE WS-CURRENT-TIMESTAMP  TO AR-TRANS-HIST-SEQ-NO.          
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7500-SELECT-ACCOUNT.                                             
           MOVE '7500' TO ACTIVE-PARAGRAPH.                             
           MOVE WS-ACCOUNT-NO-COMP3   TO AT-ACCOUNT-NO.                 
           EXEC SQL                                                     
               SELECT  CODE_COMPANY_ACCT, DATE_LAST_ACTION,             
                       CODE_ACCT_STAT,COMPANY_NO, PREMISE_NO,           
                       TOTAL_AR_BALANCE, CUSTOMER_NO ,                  
                       CODES_DATA_PRESENT,                              
                       LOCAL_OFFICE,                                    
                       REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS,                        
                       EPP_OFFER_AMOUNT,                                
                       EPP_OFFER_DATE                                   
ACT180               , MST_SUB_ACCT_IND                                 
ACT201               , BILL_CYCLE                                       
               INTO  :AT-CODE-COMPANY-ACCT, :AT-DATE-LAST-ACTION,       
                     :AT-CODE-ACCT-STAT,:AT-COMPANY-NO, :AT-PREMISE-NO, 
                     :AT-TOTAL-AR-BALANCE, :AT-CUSTOMER-NO,             
                     :AT-CODES-DATA-PRESENT, :AT-LOCAL-OFFICE,          
                     :AT-LAST-UPDATE-TS,                                
                     :AT-EPP-OFFER-AMOUNT,                              
                     :AT-EPP-OFFER-DATE :WS-EPP-OFFER-DATE-NI           
ACT180              ,:AT-MST-SUB-ACCT-IND                               
ACT201              ,:AT-BILL-CYCLE                                     
               FROM    CSS_ACCOUNT WITH(READUNCOMMITTED)                        
               WHERE   ACCOUNT_NO  = :AT-ACCOUNT-NO                     
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_COMPANY_ACCT, DATE_LAST_ACTION,                     
MFA-TR*                CODE_ACCT_STAT,COMPANY_NO, PREMISE_NO,                   
MFA-TR*                TOTAL_AR_BALANCE, CUSTOMER_NO ,                          
MFA-TR*                CODES_DATA_PRESENT,                                      
MFA-TR*                LOCAL_OFFICE,                                            
MFA-TR*                LAST_UPDATE_TS,                                          
MFA-TR*                EPP_OFFER_AMOUNT,                                        
MFA-TR*                EPP_OFFER_DATE                                           
MFA-TR*              , MST_SUB_ACCT_IND                                         
MFA-TR*              , BILL_CYCLE                                               
MFA-TR*        INTO  :AT-CODE-COMPANY-ACCT, :AT-DATE-LAST-ACTION,               
MFA-TR*              :AT-CODE-ACCT-STAT,:AT-COMPANY-NO, :AT-PREMISE-NO,         
MFA-TR*              :AT-TOTAL-AR-BALANCE, :AT-CUSTOMER-NO,                     
MFA-TR*              :AT-CODES-DATA-PRESENT, :AT-LOCAL-OFFICE,                  
MFA-TR*              :AT-LAST-UPDATE-TS,                                        
MFA-TR*              :AT-EPP-OFFER-AMOUNT,                                      
MFA-TR*              :AT-EPP-OFFER-DATE :WS-EPP-OFFER-DATE-NI                   
MFA-TR*             ,:AT-MST-SUB-ACCT-IND                                       
MFA-TR*             ,:AT-BILL-CYCLE                                             
MFA-TR*        FROM    CSS_ACCOUNT                                              
MFA-TR*        WHERE   ACCOUNT_NO  = :AT-ACCOUNT-NO                             
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7500                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
           ELSE                                                         
              MOVE SPACES         TO ABEND-TABLES                       
              MOVE SPACES         TO ABEND-SQL-PREDICATES               
REARCH        MOVE 'CSR02350'     TO ABEND-PROGRAM                      
              MOVE 'SELECT'       TO ABEND-FUNCTION                     
              MOVE 'CSS_ACCOUNT'  TO TABLE-1                            
              MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-1                    
              MOVE AT-ACCOUNT-NO  TO HOSTVAR-ELEMENT-1                  
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7510-SELECT-PREMISE.                                             
           MOVE '7510' TO ACTIVE-PARAGRAPH.                             
                                                                        
           MOVE AT-PREMISE-NO            TO PR-PREMISE-NO.              
                                                                        
           EXEC SQL                                                     
               SELECT  CODE_PREMISE_STAT,                               
                       REV_DISTRICT_CD,                                 
                       LOCAL_OFFICE                                     
               INTO    :PR-CODE-PREMISE-STAT,                           
                       :PR-REV-DISTRICT-CD,                             
                       :PR-LOCAL-OFFICE                                 
               FROM    CSS_PREMISE WITH(READUNCOMMITTED)                        
               WHERE   PREMISE_NO = :PR-PREMISE-NO                      
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT  CODE_PREMISE_STAT,                                       
MFA-TR*                REV_DISTRICT_CD,                                         
MFA-TR*                LOCAL_OFFICE                                             
MFA-TR*        INTO    :PR-CODE-PREMISE-STAT,                                   
MFA-TR*                :PR-REV-DISTRICT-CD,                                     
MFA-TR*                :PR-LOCAL-OFFICE                                         
MFA-TR*        FROM    CSS_PREMISE                                              
MFA-TR*        WHERE   PREMISE_NO = :PR-PREMISE-NO                              
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7510                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
             ELSE                                                       
               MOVE SPACES         TO ABEND-TABLES                      
               MOVE SPACES         TO ABEND-SQL-PREDICATES              
REARCH         MOVE 'CSR02350'     TO ABEND-PROGRAM                     
               MOVE 'SELECT'       TO ABEND-FUNCTION                    
               MOVE 'CSS_PREMISE'  TO TABLE-1                           
               MOVE 'PREMISE_NO'   TO TABLE-ELEMENT-1                   
CBSI           MOVE 'ACCOUNT_NO'   TO TABLE-ELEMENT-2                   
               MOVE PR-PREMISE-NO  TO HOSTVAR-ELEMENT-1                 
CBSI           MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-2                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
                                                                        
       7510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       7520-SELECT-CUSTOMER.                                            
           MOVE '7520' TO ACTIVE-PARAGRAPH.                             
           EXEC SQL                                                     
              SELECT   CODE_EMPL_ACCT                                   
                    ,  CODE_CUST_STATUS                                 
              INTO    :CU-CODE-EMPL-ACCT                                
                    , :CU-CODE-CUST-STATUS                              
              FROM     CSS_CUSTOMER WITH(READUNCOMMITTED)                       
              WHERE    CUSTOMER_NO = :AT-CUSTOMER-NO                    
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT   CODE_EMPL_ACCT                                           
MFA-TR*             ,  CODE_CUST_STATUS                                         
MFA-TR*       INTO    :CU-CODE-EMPL-ACCT                                        
MFA-TR*             , :CU-CODE-CUST-STATUS                                      
MFA-TR*       FROM     CSS_CUSTOMER                                             
MFA-TR*       WHERE    CUSTOMER_NO = :AT-CUSTOMER-NO                            
MFA-TR*        WITH UR                                                          
MFA-TR*     QUERYNO 7520                                                        
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
                 NEXT SENTENCE                                          
             ELSE                                                       
               MOVE SPACES          TO ABEND-TABLES                     
               MOVE SPACES          TO ABEND-SQL-PREDICATES             
REARCH         MOVE 'CSR02350'      TO ABEND-PROGRAM                    
               MOVE 'SELECT'        TO ABEND-FUNCTION                   
               MOVE 'CSS_CUSTOMER'  TO TABLE-1                          
               MOVE 'CUSTOMER_NO'   TO TABLE-ELEMENT-1                  
CBSI           MOVE 'ACCOUNT_NO'    TO TABLE-ELEMENT-2                  
               MOVE AT-CUSTOMER-NO  TO HOSTVAR-ELEMENT-1                
CBSI           MOVE PARM-ACCOUNT-NO TO HOSTVAR-ELEMENT-2                
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT
           END-IF.           
       7520-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7030-UPDATE_ACCOUNT.                                                    
      ******************************************************************        
       7530-UPDATE-ACCOUNT.                                             
           MOVE '7530'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_ACCOUNT                                        
                SET  TOTAL_AR_BALANCE  = :AT-TOTAL-AR-BALANCE           
                   , CODES_DATA_PRESENT= :AT-CODES-DATA-PRESENT         
                   , LAST_UPDATE_TS    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )          
               WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                 
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_ACCOUNT                                                
MFA-TR*         SET  TOTAL_AR_BALANCE  = :AT-TOTAL-AR-BALANCE                   
MFA-TR*            , CODES_DATA_PRESENT= :AT-CODES-DATA-PRESENT                 
MFA-TR*            , LAST_UPDATE_TS    = :WS-CURRENT-TIMESTAMP                  
MFA-TR*        WHERE ACCOUNT_NO        = :AT-ACCOUNT-NO                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
CBSI          MOVE 'UPDATE'                   TO   ABEND-FUNCTION       
              MOVE 'CSS_ACCOUNT       '       TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
CBSI          MOVE 'LAST_UPDATE_TS'           TO   TABLE-ELEMENT-2      
CBSI          MOVE 'TOTAL_AR_BALANCE'         TO   TABLE-ELEMENT-3      
              MOVE AT-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
CBSI          MOVE WS-CURRENT-TIMESTAMP       TO   HOSTVAR-ELEMENT-2    
CBSI          MOVE AT-TOTAL-AR-BALANCE      TO WS-AT-TOTAL-AR-BALANCE-ED
CBSI          MOVE WS-AT-TOTAL-AR-BALANCE-ED  TO   HOSTVAR-ELEMENT-3    
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7530-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
                                                                        
T17754******************************************************************21910000
      *                                                                *21920000
      * 7540-SELECT-CONN-CHRG                                          *21930000
      *                                                                *21940000
      ******************************************************************21950000
       7540-SELECT-CONN-CHRG.                                           
                                                                        
           EXEC SQL                                                     
               SELECT ACCOUNT_NO   ,   PYMT_PRIORITY_LVL,               
                    CCC_ITEM_ID    ,   AMT_ORIG_ENTERED ,               
                    CODE_CCC_TYPE  ,   AMT_TAX_STATE    ,               
                    AMT_TAX_CITY   ,   AMT_TAX_XCISE    ,               
                    AMT_TAX_OTHER  ,   AMT_TRANS        ,               
                    DATE_CCC_BILLED,   DATE_TRANS       ,               
                    REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
               INTO :CC-ACCOUNT-NO   , :CC-PYMT-PRIORITY-LVL   ,        
                    :CC-CCC-ITEM-ID  , :CC-AMT-ORIG-ENTERED    ,        
                    :CC-CODE-CCC-TYPE, :CC-AMT-TAX-STATE       ,        
                    :CC-AMT-TAX-CITY , :CC-AMT-TAX-XCISE       ,        
                    :CC-AMT-TAX-OTHER, :CC-AMT-TRANS           ,        
                    :CC-DATE-CCC-BILLED :WS-NULL-DATE-CCC-BILLED,        
                    :CC-DATE-TRANS   , :CC-LAST-UPDATE-TS               
                                                                        
               FROM CSS_CONNECT_CHRG WITH(READUNCOMMITTED)                      
               WHERE  ACCOUNT_NO        = :CC-ACCOUNT-NO                
                 AND  PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL         
                 AND  CCC_ITEM_ID       = :CC-CCC-ITEM-ID               
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                     21980000
MFA-TR*        SELECT ACCOUNT_NO   ,   PYMT_PRIORITY_LVL,               21990000
MFA-TR*             CCC_ITEM_ID    ,   AMT_ORIG_ENTERED ,               22000000
MFA-TR*             CODE_CCC_TYPE  ,   AMT_TAX_STATE    ,               22010000
MFA-TR*             AMT_TAX_CITY   ,   AMT_TAX_XCISE    ,               22020000
MFA-TR*             AMT_TAX_OTHER  ,   AMT_TRANS        ,               22030000
MFA-TR*             DATE_CCC_BILLED,   DATE_TRANS       ,               22040000
MFA-TR*             LAST_UPDATE_TS                                      22050000
MFA-TR*        INTO :CC-ACCOUNT-NO   , :CC-PYMT-PRIORITY-LVL   ,        22060000
MFA-TR*             :CC-CCC-ITEM-ID  , :CC-AMT-ORIG-ENTERED    ,        22070000
MFA-TR*             :CC-CODE-CCC-TYPE, :CC-AMT-TAX-STATE       ,        22080000
MFA-TR*             :CC-AMT-TAX-CITY , :CC-AMT-TAX-XCISE       ,        22090000
MFA-TR*             :CC-AMT-TAX-OTHER, :CC-AMT-TRANS           ,        22100000
MFA-TR*             :CC-DATE-CCC-BILLED:WS-NULL-DATE-CCC-BILLED,        22110000
MFA-TR*             :CC-DATE-TRANS   , :CC-LAST-UPDATE-TS               22120000
MFA-TR*                                                                 22130000
MFA-TR*        FROM CSS_CONNECT_CHRG                                    22140000
MFA-TR*        WHERE  ACCOUNT_NO        = :CC-ACCOUNT-NO                22150000
MFA-TR*          AND  PYMT_PRIORITY_LVL = :CC-PYMT-PRIORITY-LVL         22160000
MFA-TR*          AND  CCC_ITEM_ID       = :CC-CCC-ITEM-ID               22170000
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7540                                                       
MFA-TR*    END-EXEC.                                                    22180000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7540'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
CBSI          MOVE 'CSS_CONNECT_CHRG'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
CBSI          MOVE 'CCC_ITEM_ID'             TO TABLE-ELEMENT-3         
              MOVE CC-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1       
              MOVE CC-PYMT-PRIORITY-LVL      TO HOSTVAR-ELEMENT-2       
              MOVE CC-CCC-ITEM-ID            TO HOSTVAR-ELEMENT-3       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
T17754 7540-EXIT.                                                       
           EXIT.                                                        
                                                                        
T18873**************************************************************            
      * SELECT THE ELEC & GAS ALLOCATION % FROM THE LOC OFF TABLE. *            
      **************************************************************            
       7541-SELECT-LOCAL-OFFICE.                                        
                                                                        
           EXEC SQL                                                     
              SELECT ELEC_REV_ALLOC_PCT                                 
                INTO :B1-ELEC-REV-ALLOC-PCT                             
                FROM CSS_LOCAL_OFFICE WITH(READUNCOMMITTED)                     
               WHERE COMPANY_NO        = :B1-COMPANY-NO                 
                 AND LOCAL_OFFICE      = :B1-LOCAL-OFFICE               
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT ELEC_REV_ALLOC_PCT                                         
MFA-TR*         INTO :B1-ELEC-REV-ALLOC-PCT                                     
MFA-TR*         FROM CSS_LOCAL_OFFICE                                           
MFA-TR*        WHERE COMPANY_NO        = :B1-COMPANY-NO                         
MFA-TR*          AND LOCAL_OFFICE      = :B1-LOCAL-OFFICE                       
MFA-TR*         WITH UR                                                         
MFA-TR*      QUERYNO 7541                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '7541'                    TO ACTIVE-PARAGRAPH        
              MOVE 'SELECT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_LOCAL_OFFICE'        TO TABLE-1                 
              MOVE 'COMPANY-NO'              TO TABLE-ELEMENT-1         
              MOVE 'LOCAL-OFFICE'            TO TABLE-ELEMENT-2         
              MOVE B1-COMPANY-NO             TO HOSTVAR-ELEMENT-1       
              MOVE B1-LOCAL-OFFICE           TO HOSTVAR-ELEMENT-2       
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
            END-IF.                                                     
T17754 7541-EXIT.                                                       
T18873     EXIT.                                                        
                                                                        
       7600-SELECT-DEP-REQ.                                             
           MOVE '7600'               TO ACTIVE-PARAGRAPH.               
                                                                        
           MOVE WS-ACCOUNT-NO-COMP3  TO DR-ACCOUNT-NO.                  
           MOVE WS-CURR-ITEM-ID      TO DR-DEP-ITEM-ID.                 
                                                                        
           EXEC SQL                                                     
                 SELECT AMT_MO_PYMT,                                    
                        AMT_ORIG_ENTERED,                               
                        DATE_PYMT_START,                                
                        DATE_TRAN,                                      
                        DEP_ACTION_CODE,                                
                        DEP_BILL_OPTION_CD,                             
                        NO_SCHED_PYMTS,                                 
                        REBILLED_DEP_AMT,                               
                        REBILLED_DEP_DATE,                              
                        SERVICE_TYPE_CD                                 
                 INTO   :DR-AMT-MO-PYMT,                                
                        :DR-AMT-ORIG-ENTERED,                           
                        :DR-DATE-PYMT-START :WS-DR-NULL-IND-1,           
                        :DR-DATE-TRAN :WS-DR-NULL-IND-2,                 
                        :DR-DEP-ACTION-CODE,                            
                        :DR-DEP-BILL-OPTION-CD,                         
                        :DR-NO-SCHED-PYMTS,                             
                        :DR-REBILLED-DEP-AMT,                           
                        :DR-REBILLED-DEP-DATE :WS-DR-NULL-IND-3,         
                        :DR-SERVICE-TYPE-CD                             
                 FROM   CSS_DEP_REQ WITH(READUNCOMMITTED)                       
                 WHERE  ACCOUNT_NO        = :DR-ACCOUNT-NO              
                 AND    DEP_ITEM_ID       = :DR-DEP-ITEM-ID             
                 AND    PYMT_PRIORITY_LVL =  80                         
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*          SELECT AMT_MO_PYMT,                                            
MFA-TR*                 AMT_ORIG_ENTERED,                                       
MFA-TR*                 DATE_PYMT_START,                                        
MFA-TR*                 DATE_TRAN,                                              
MFA-TR*                 DEP_ACTION_CODE,                                        
MFA-TR*                 DEP_BILL_OPTION_CD,                                     
MFA-TR*                 NO_SCHED_PYMTS,                                         
MFA-TR*                 REBILLED_DEP_AMT,                                       
MFA-TR*                 REBILLED_DEP_DATE,                                      
MFA-TR*                 SERVICE_TYPE_CD                                         
MFA-TR*          INTO   :DR-AMT-MO-PYMT,                                        
MFA-TR*                 :DR-AMT-ORIG-ENTERED,                                   
MFA-TR*                 :DR-DATE-PYMT-START:WS-DR-NULL-IND-1,                   
MFA-TR*                 :DR-DATE-TRAN:WS-DR-NULL-IND-2,                         
MFA-TR*                 :DR-DEP-ACTION-CODE,                                    
MFA-TR*                 :DR-DEP-BILL-OPTION-CD,                                 
MFA-TR*                 :DR-NO-SCHED-PYMTS,                                     
MFA-TR*                 :DR-REBILLED-DEP-AMT,                                   
MFA-TR*                 :DR-REBILLED-DEP-DATE:WS-DR-NULL-IND-3,                 
MFA-TR*                 :DR-SERVICE-TYPE-CD                                     
MFA-TR*          FROM   CSS_DEP_REQ                                             
MFA-TR*          WHERE  ACCOUNT_NO        = :DR-ACCOUNT-NO                      
MFA-TR*          AND    DEP_ITEM_ID       = :DR-DEP-ITEM-ID                     
MFA-TR*          AND    PYMT_PRIORITY_LVL =  80                                 
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7600                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE                       TO WS-ACTIVE-RETURN-CODE  
                                                 RS-RETURN-CODE.        
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
                                    OR NOT-FOUND                        
              NEXT SENTENCE                                             
           ELSE                                                         
                 MOVE PROGRAM-NAME               TO ABEND-PROGRAM       
CBSI             MOVE 'SELECT'                   TO ABEND-FUNCTION      
                 MOVE 'CSS_DEP_REQ'              TO TABLE-1             
                 MOVE 'ACCOUNT_NO    '           TO TABLE-ELEMENT-1     
CBSI             MOVE 'DEP_ITEM_ID   '           TO TABLE-ELEMENT-2     
                 MOVE WS-ACCOUNT-NO-COMP3        TO HOSTVAR-ELEMENT-1   
CBSI             MOVE DR-DEP-ITEM-ID             TO HOSTVAR-ELEMENT-2   
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
           END-IF.                                                      
       7600-EXIT.                                                       
           EXIT.                                                        
P00794*                                                                         
P00794******************************************************************        
P00794* 7610-SELECT-DELINQUENCY.                                                
P00794******************************************************************        
P00794 7610-SELECT-DELINQUENCY.                                         
P00794                                                                  
P00794     EXEC SQL                                                     
P00794        SELECT DELINQ_VALUE                                       
P00794          INTO :C8-DELINQ-VALUE                                   
P00794          FROM CSS_DELINQUENCY                                    
P00794         WHERE DELINQ_CD  = :C8-DELINQ-CD                         
P00794           AND COMPANY_NO = :C8-COMPANY-NO                        
P00794                                                      
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR*    EXEC SQL                                                     22420000
MFA-TR*       SELECT DELINQ_VALUE                                       22430000
MFA-TR*         INTO :C8-DELINQ-VALUE                                   22440000
MFA-TR*         FROM CSS_DELINQUENCY                                    22450000
MFA-TR*        WHERE DELINQ_CD  = :C8-DELINQ-CD                         22460000
MFA-TR*          AND COMPANY_NO = :C8-COMPANY-NO                                
MFA-TR*      QUERYNO 7610                                                       
MFA-TR*    END-EXEC.                                                    22470000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794                                                                  
P00794     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00794                                                                  
P00794     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00794        CONTINUE                                                  
P00794     ELSE                                                         
P00794         MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
P00794         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
P00794         MOVE '7610'                   TO ACTIVE-PARAGRAPH        
P00794         MOVE 'SELECT'                 TO ABEND-FUNCTION          
P00794         MOVE 'CSS_DELINQUENCY'        TO TABLE-1                 
P00794         MOVE 'DELINQ_CD'              TO TABLE-ELEMENT-1         
P00794         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-2         
P00794         MOVE C8-DELINQ-CD             TO HOSTVAR-ELEMENT-1       
P00794         MOVE WS-ACCOUNT-NO-NUM        TO HOSTVAR-ELEMENT-2       
P00794         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00794         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00794     END-IF.                                                      
P00794                                                                  
P00794 7610-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
P00794******************************************************************        
P00794* 7640-GET-UTIL-ENV.                                             *        
P00794******************************************************************        
P00794*                                                                         
P00794 7640-GET-UTIL-ENV.                                               
P00794*                                                                         
P00794     EXEC SQL                                                     
P00794        SELECT TOP(1) IC_NO,
              CODE_UTIL_TYPE                                     
P00794          INTO :UT-IC-NO,                                         
P00794               :UT-CODE-UTIL-TYPE                                 
P00794          FROM CSS_UTIL_ENVRNMT UT WITH(READUNCOMMITTED)                  
P00794         WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                        
P00794                                     
P00794                                                      
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ020
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT IC_NO,                                                     
MFA-TR*              CODE_UTIL_TYPE                                             
MFA-TR*         INTO :UT-IC-NO,                                                 
MFA-TR*              :UT-CODE-UTIL-TYPE                                         
MFA-TR*         FROM CSS_UTIL_ENVRNMT UT                                        
MFA-TR*        WHERE ACCOUNT_NO = :UT-ACCOUNT-NO                                
MFA-TR*        FETCH FIRST 1 ROW ONLY WITH UR                                   
MFA-TR*      QUERYNO 7640                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794                                                                  
P00794     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00794     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00794         CONTINUE                                                 
P00794     ELSE                                                         
P00794         MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
P00794         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
P00794         MOVE '7640'                   TO ACTIVE-PARAGRAPH        
P00794         MOVE 'SELECT'                 TO ABEND-FUNCTION          
P00794         MOVE 'CSS_UTIL_ENVRNMT'       TO TABLE-1                 
P00794         MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1         
P00794         MOVE UT-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1       
P00794         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00794         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00794     END-IF.                                                      
P00794*                                                                         
P00794 7640-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
P00794******************************************************************        
P00794* 7650-GET-MIN-REV-MO.                                           *        
P00794******************************************************************        
P00794*                                                                         
P00794 7650-GET-MIN-REV-MO.                                             
P00794*                                                                         
P00794     EXEC SQL                                                     
P00794        SELECT MIN(REVENUE_MONTH)                                 
P00794          INTO :BN-REVENUE-MONTH                                  
P00794          FROM CSS_BILL_WINDOW BN WITH(READUNCOMMITTED)                   
ACT201         WHERE BN.DATE_EXTRACT >= IIF(TRY_CONVERT(DATE, 
                                                       :WS-CURRENT-DATE
              ) IS NULL OR (PATINDEX('%.%', :WS-CURRENT-DATE
              ) <> 0) OR (LEN(:WS-CURRENT-DATE) <> 10), CIS.CHAR2DATE(
                                                       :WS-CURRENT-DATE
              ), CONVERT(DATE, :WS-CURRENT-DATE) )                
ACT201           AND BN.BILL_CYCLE    = :AT-BILL-CYCLE                  
P00794                                                           
P00794                                                      
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MIN(REVENUE_MONTH)                                         
MFA-TR*         INTO :BN-REVENUE-MONTH                                          
MFA-TR*         FROM CSS_BILL_WINDOW BN                                         
MFA-TR*        WHERE BN.DATE_EXTRACT >= :WS-CURRENT-DATE                        
MFA-TR*          AND BN.BILL_CYCLE    = :AT-BILL-CYCLE                          
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7650                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794                                                                  
P00794     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00794     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00794         CONTINUE                                                 
P00794     ELSE                                                         
P00794         MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE          
P00794         MOVE PROGRAM-NAME             TO ABEND-PROGRAM           
P00794         MOVE '7650'                   TO ACTIVE-PARAGRAPH        
P00794         MOVE 'SELECT'                 TO ABEND-FUNCTION          
P00794         MOVE 'CSS_BILL_WINDOW'        TO TABLE-1                 
P00794         MOVE 'CURRENT-DATE'           TO TABLE-ELEMENT-1         
P00794         MOVE WS-CURRENT-DATE          TO HOSTVAR-ELEMENT-1       
P00794         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00794         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00794     END-IF.                                                      
P00794*                                                                         
P00794 7650-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
P00794******************************************************************        
P00794* 7750-GET-MAX-SEQ-NO.                                                    
P00794******************************************************************        
P00794*                                                                         
P00794 7750-GET-MAX-SEQ-NO.                                             
P00794                                                                  
P00794     EXEC SQL                                                     
P00794        SELECT MAX(FIXED_FCTR_SEQ_NO)                             
P00794          INTO :FF-FIXED-FCTR-SEQ-NO :WS-NULL-IND-FF               
P00794          FROM CSS_FIXED_FCTR FF WITH(READUNCOMMITTED)                    
P00794         WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                 
P00794           AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE             
P00794           AND FF.IC_NO          = :FF-IC-NO                      
P00794                                                           
P00794                                                      
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*       SELECT MAX(FIXED_FCTR_SEQ_NO)                                     
MFA-TR*         INTO :FF-FIXED-FCTR-SEQ-NO:WS-NULL-IND-FF                       
MFA-TR*         FROM CSS_FIXED_FCTR FF                                          
MFA-TR*        WHERE FF.ACCOUNT_NO     = :FF-ACCOUNT-NO                         
MFA-TR*          AND FF.CODE_UTIL_TYPE = :FF-CODE-UTIL-TYPE                     
MFA-TR*          AND FF.IC_NO          = :FF-IC-NO                              
MFA-TR*        WITH UR                                                          
MFA-TR*      QUERYNO 7750                                                       
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794                                                                  
P00794     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
P00794                                                                  
P00794     EVALUATE WS-ACTIVE-RETURN-CODE                               
P00794         WHEN SUCCESSFUL-CALL                                     
P00794              CONTINUE                                            
P00794         WHEN NOT-FOUND                                           
P00794             IF WS-NULL-IND-FF < 0                                
P00794                MOVE 0 TO FF-FIXED-FCTR-SEQ-NO                    
P00794             END-IF                                               
P00794         WHEN OTHER                                               
P00794          MOVE WS-ACTIVE-RETURN-CODE   TO RS-RETURN-CODE          
P00794          MOVE PROGRAM-NAME            TO ABEND-PROGRAM           
P00794          MOVE '7750'                  TO ACTIVE-PARAGRAPH        
P00794          MOVE 'SELECT'                TO ABEND-FUNCTION          
P00794          MOVE 'CSS_FIXED_FACTOR'      TO TABLE-1                 
P00794          MOVE 'FF-ACCOUNT-NO'         TO TABLE-ELEMENT-1         
P00794          MOVE 'FF-CODE-UTIL-TYPE'     TO TABLE-ELEMENT-2         
P00794          MOVE 'FF-IC-NO'              TO TABLE-ELEMENT-3         
P00794          MOVE FF-ACCOUNT-NO           TO HOSTVAR-ELEMENT-1       
P00794          MOVE FF-CODE-UTIL-TYPE       TO HOSTVAR-ELEMENT-2       
P00794          MOVE FF-IC-NO                TO HOSTVAR-ELEMENT-3       
P00794          PERFORM 9000-SEND-ERROR-RESULT                          
P00794                                        THRU 9000-EXIT            
P00794          PERFORM 9900-SQL-ERROR-ROUTINE                          
P00794                                        THRU 9900-EXIT            
P00794     END-EVALUATE.                                                
P00794                                                                  
P00794 7750-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
P00794******************************************************************        
       7620-INSERT-DEP-REQ.                                             
           MOVE '7620'                      TO ACTIVE-PARAGRAPH.        
      *                                                                         
           EXEC SQL                                                     
                INSERT INTO CSS_DEP_REQ                                 
                       (ACCOUNT_NO,                                     
                        AMT_MO_PYMT,                                    
                        AMT_ORIG_ENTERED,                               
                        DATE_PYMT_START,                                
                        DATE_TRAN,                                      
                        DEP_ACTION_CODE,                                
                        DEP_BILL_OPTION_CD,                             
                        DEP_ITEM_ID,                                    
                        NO_SCHED_PYMTS,                                 
                        PYMT_PRIORITY_LVL,                              
                        REBILLED_DEP_AMT,                               
                        REBILLED_DEP_DATE,                              
                        SERVICE_TYPE_CD)                                
                VALUES  (:DR-ACCOUNT-NO,                                
                        :DR-AMT-MO-PYMT,                                
                        :DR-AMT-ORIG-ENTERED,                           
                        IIF(TRY_CONVERT(DATE, :DR-DATE-PYMT-START 
                                              :WS-DR-NULL-IND-1
              ) IS NULL OR (PATINDEX('%.%', :DR-DATE-PYMT-START 
                                                      :WS-DR-NULL-IND-1
              ) <> 0) OR (LEN(:DR-DATE-PYMT-START :WS-DR-NULL-IND-1
              ) <> 10), CIS.CHAR2DATE(:DR-DATE-PYMT-START 
                                                      :WS-DR-NULL-IND-1
              ), CONVERT(DATE, :DR-DATE-PYMT-START :WS-DR-NULL-IND-1
              ) ),           
                        IIF(TRY_CONVERT(DATE, :DR-DATE-TRAN 
                                              :WS-DR-NULL-IND-2
              ) IS NULL OR (PATINDEX('%.%', :DR-DATE-TRAN 
                                                      :WS-DR-NULL-IND-2
              ) <> 0) OR (LEN(:DR-DATE-TRAN :WS-DR-NULL-IND-2
              ) <> 10), CIS.CHAR2DATE(:DR-DATE-TRAN :WS-DR-NULL-IND-2
              ), CONVERT(DATE, :DR-DATE-TRAN :WS-DR-NULL-IND-2) ),             
                        :DR-DEP-ACTION-CODE,                            
                        :DR-DEP-BILL-OPTION-CD,                         
                        :DR-DEP-ITEM-ID,                                
                        :DR-NO-SCHED-PYMTS,                             
                        :DR-PYMT-PRIORITY-LVL,                          
                        :DR-REBILLED-DEP-AMT,                           
                        IIF(TRY_CONVERT(DATE, :DR-REBILLED-DEP-DATE 
                                              :WS-DR-NULL-IND-3
              ) IS NULL OR (PATINDEX('%.%', :DR-REBILLED-DEP-DATE 
                                                      :WS-DR-NULL-IND-3
              ) <> 0) OR (LEN(:DR-REBILLED-DEP-DATE :WS-DR-NULL-IND-3
              ) <> 10), CIS.CHAR2DATE(:DR-REBILLED-DEP-DATE 
                                                      :WS-DR-NULL-IND-3
              ), CONVERT(DATE, :DR-REBILLED-DEP-DATE :WS-DR-NULL-IND-3
              ) ),         
                        :DR-SERVICE-TYPE-CD)                            
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_DEP_REQ                                         
MFA-TR*                (ACCOUNT_NO,                                             
MFA-TR*                 AMT_MO_PYMT,                                            
MFA-TR*                 AMT_ORIG_ENTERED,                                       
MFA-TR*                 DATE_PYMT_START,                                        
MFA-TR*                 DATE_TRAN,                                              
MFA-TR*                 DEP_ACTION_CODE,                                        
MFA-TR*                 DEP_BILL_OPTION_CD,                                     
MFA-TR*                 DEP_ITEM_ID,                                            
MFA-TR*                 NO_SCHED_PYMTS,                                         
MFA-TR*                 PYMT_PRIORITY_LVL,                                      
MFA-TR*                 REBILLED_DEP_AMT,                                       
MFA-TR*                 REBILLED_DEP_DATE,                                      
MFA-TR*                 SERVICE_TYPE_CD)                                        
MFA-TR*         VALUES  (:DR-ACCOUNT-NO,                                        
MFA-TR*                 :DR-AMT-MO-PYMT,                                        
MFA-TR*                 :DR-AMT-ORIG-ENTERED,                                   
MFA-TR*                 :DR-DATE-PYMT-START:WS-DR-NULL-IND-1,                   
MFA-TR*                 :DR-DATE-TRAN:WS-DR-NULL-IND-2,                         
MFA-TR*                 :DR-DEP-ACTION-CODE,                                    
MFA-TR*                 :DR-DEP-BILL-OPTION-CD,                                 
MFA-TR*                 :DR-DEP-ITEM-ID,                                        
MFA-TR*                 :DR-NO-SCHED-PYMTS,                                     
MFA-TR*                 :DR-PYMT-PRIORITY-LVL,                                  
MFA-TR*                 :DR-REBILLED-DEP-AMT,                                   
MFA-TR*                 :DR-REBILLED-DEP-DATE:WS-DR-NULL-IND-3,                 
MFA-TR*                 :DR-SERVICE-TYPE-CD)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                     TO WS-ACTIVE-RETURN-CODE.   
           IF WS-ACTIVE-RETURN-CODE EQUAL SUCCESSFUL-CALL               
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE    TO RS-RETURN-CODE           
              MOVE '7620'                   TO ACTIVE-PARAGRAPH         
              MOVE SPACES                   TO ABEND-TABLES             
                                               ABEND-SQL-PREDICATES     
              MOVE 'CSS_DEP_REQ   '         TO TABLE-1                  
              MOVE 'ACCOUNT_NO'             TO TABLE-ELEMENT-1          
              MOVE WS-ACCOUNT-NO-COMP3      TO HOSTVAR-ELEMENT-1        
CBSI          MOVE 'PYMT_PRIORITY_LVL'      TO TABLE-ELEMENT-2          
CBSI          MOVE 'DATE_PYMT_START'        TO TABLE-ELEMENT-3          
CBSI          MOVE 'DATE_TRAN'              TO TABLE-ELEMENT-4          
              MOVE DR-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-2        
CBSI          MOVE DR-DATE-PYMT-START       TO HOSTVAR-ELEMENT-3        
CBSI          MOVE DR-DATE-TRAN             TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT                            
                                          THRU 9000-EXIT                
              PERFORM 9900-SQL-ERROR-ROUTINE                            
                                          THRU 9900-EXIT                
           END-IF.                                                      
       7620-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
      ******************************************************************        
      * 7630-UPDATE-AR-TRAN.                                                    
      ******************************************************************        
       7630-UPDATE-AR-TRAN.                                             
           MOVE '7630'               TO ACTIVE-PARAGRAPH.               
                                                                        
           EXEC SQL                                                     
              UPDATE CSS_AR_TRANS_HIST                                  
                SET  AMT_ORIG_ENTERED     = :AR-AMT-ORIG-ENTERED        
               WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO              
                 AND TRANS_HIST_SEQ_NO    = CIS.CHAR2TIMESTAMP(
                                                  :WS-CURRENT-TIMESTAMP
              )       
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*       UPDATE CSS_AR_TRANS_HIST                                          
MFA-TR*         SET  AMT_ORIG_ENTERED     = :AR-AMT-ORIG-ENTERED                
MFA-TR*        WHERE ACCOUNT_NO           = :AT-ACCOUNT-NO                      
MFA-TR*          AND TRANS_HIST_SEQ_NO    = :WS-CURRENT-TIMESTAMP               
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME               TO   ABEND-PROGRAM        
CBSI          MOVE 'UPDATE'                   TO   ABEND-FUNCTION       
CBSI          MOVE 'CSS_AR_TRANS_HIST  '      TO   TABLE-1              
              MOVE 'ACCOUNT_NO    '           TO   TABLE-ELEMENT-1      
CBSI          MOVE 'TRANS_HIST_SEQ_NO'        TO   TABLE-ELEMENT-2      
CBSI          MOVE 'AMT_ORIG_ENTERED'         TO   TABLE-ELEMENT-3      
              MOVE AT-ACCOUNT-NO              TO   HOSTVAR-ELEMENT-1    
CBSI          MOVE WS-CURRENT-TIMESTAMP       TO   HOSTVAR-ELEMENT-2    
CBSI          MOVE AR-AMT-ORIG-ENTERED      TO WS-AR-AMT-ORIG-ENTERED-ED
CBSI          MOVE WS-AR-AMT-ORIG-ENTERED-ED TO   HOSTVAR-ELEMENT-3     
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       7630-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
      *                                                                         
      * 7999-CHECK AR-LOCKOUT                                                   
PCR640     EXEC SQL                                                             
PCR640         INCLUDE CPD00075                                                 
PCR640     END-EXEC.                                                            
      *                                                                         
      ******************************************************************        
      *                                                                *24160000
      * 8030-INSERT-CCC                                                *24170000
      *                                                                *24180000
      ******************************************************************24190000
       8030-INSERT-CCC.                                                 
                                                                        
           EXEC SQL                                                     
               INSERT INTO CSS_CONNECT_CHRG                             
                  ( ACCOUNT_NO,                                         
                    PYMT_PRIORITY_LVL,                                  
                    CCC_ITEM_ID,                                        
                    AMT_ORIG_ENTERED,                                   
                    CODE_CCC_TYPE,                                      
                    AMT_TAX_STATE,                                      
                    AMT_TAX_CITY,                                       
                    AMT_TAX_XCISE,                                      
                    AMT_TAX_OTHER,                                      
                    AMT_TRANS,                                          
                    DATE_CCC_BILLED,                                    
                    DATE_TRANS,                                         
                    RCNCT_TYPE_NO)                                      
               VALUES                                                   
                  (:CC-ACCOUNT-NO,                                      
                   :CC-PYMT-PRIORITY-LVL,                               
                   :CC-CCC-ITEM-ID,                                     
                   :CC-AMT-ORIG-ENTERED,                                
                   :CC-CODE-CCC-TYPE,                                   
                   :CC-AMT-TAX-STATE,                                   
                   :CC-AMT-TAX-CITY,                                    
                   :CC-AMT-TAX-XCISE,                                   
                   :CC-AMT-TAX-OTHER,                                   
                   :CC-AMT-TRANS,                                       
                   IIF(TRY_CONVERT(DATE, :CC-DATE-CCC-BILLED 
                                         :WS-NULL-DATE-CCC-BILLED
              ) IS NULL OR (PATINDEX('%.%', :CC-DATE-CCC-BILLED 
                                               :WS-NULL-DATE-CCC-BILLED
              ) <> 0) OR (LEN(:CC-DATE-CCC-BILLED 
                                               :WS-NULL-DATE-CCC-BILLED
              ) <> 10), CIS.CHAR2DATE(:CC-DATE-CCC-BILLED 
                                               :WS-NULL-DATE-CCC-BILLED
              ), CONVERT(DATE, :CC-DATE-CCC-BILLED 
                                               :WS-NULL-DATE-CCC-BILLED
              ) ),         
                   IIF(TRY_CONVERT(DATE, :CC-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :CC-DATE-TRANS
              ) <> 0) OR (LEN(:CC-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :CC-DATE-TRANS
              ), CONVERT(DATE, :CC-DATE-TRANS) ),                              
                   :CC-RCNCT-TYPE-NO)                                   
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                     24220000
MFA-TR*        INSERT INTO CSS_CONNECT_CHRG                             24230000
MFA-TR*           ( ACCOUNT_NO,                                         24240000
MFA-TR*             PYMT_PRIORITY_LVL,                                  24250000
MFA-TR*             CCC_ITEM_ID,                                        24260000
MFA-TR*             AMT_ORIG_ENTERED,                                   24270000
MFA-TR*             CODE_CCC_TYPE,                                      24280000
MFA-TR*             AMT_TAX_STATE,                                      24290000
MFA-TR*             AMT_TAX_CITY,                                       24300000
MFA-TR*             AMT_TAX_XCISE,                                      24310000
MFA-TR*             AMT_TAX_OTHER,                                      24320000
MFA-TR*             AMT_TRANS,                                          24330000
MFA-TR*             DATE_CCC_BILLED,                                    24340000
MFA-TR*             DATE_TRANS,                                         24350000
MFA-TR*             RCNCT_TYPE_NO)                                      24360000
MFA-TR*        VALUES                                                   24370000
MFA-TR*           (:CC-ACCOUNT-NO,                                      24380000
MFA-TR*            :CC-PYMT-PRIORITY-LVL,                               24390000
MFA-TR*            :CC-CCC-ITEM-ID,                                     24400000
MFA-TR*            :CC-AMT-ORIG-ENTERED,                                24410000
MFA-TR*            :CC-CODE-CCC-TYPE,                                   24420000
MFA-TR*            :CC-AMT-TAX-STATE,                                   24430000
MFA-TR*            :CC-AMT-TAX-CITY,                                    24440000
MFA-TR*            :CC-AMT-TAX-XCISE,                                   24450000
MFA-TR*            :CC-AMT-TAX-OTHER,                                   24460000
MFA-TR*            :CC-AMT-TRANS,                                       24470000
MFA-TR*            :CC-DATE-CCC-BILLED:WS-NULL-DATE-CCC-BILLED,         24480000
MFA-TR*            :CC-DATE-TRANS,                                      24490000
MFA-TR*            :CC-RCNCT-TYPE-NO)                                   24500000
MFA-TR*    END-EXEC.                                                    24510000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND OR SUCCESSFUL-CALL      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE          
              MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
              MOVE '8030'                    TO ACTIVE-PARAGRAPH        
              MOVE 'INSERT'                  TO ABEND-FUNCTION          
              MOVE 'CSS_CONNECT_CHRG'        TO TABLE-1                 
              MOVE 'ACCOUNT_NO'              TO TABLE-ELEMENT-1         
              MOVE 'PYMT_PRIORITY_LVL'       TO TABLE-ELEMENT-2         
              MOVE 'CCC_ITEM_ID'             TO TABLE-ELEMENT-3         
CBSI          MOVE 'DATE_CCC_BILLED'         TO TABLE-ELEMENT-4         
              MOVE CC-ACCOUNT-NO            TO HOSTVAR-ELEMENT-1        
              MOVE CC-PYMT-PRIORITY-LVL     TO HOSTVAR-ELEMENT-2        
              MOVE CC-CCC-ITEM-ID           TO HOSTVAR-ELEMENT-3        
CBSI          MOVE CC-DATE-CCC-BILLED       TO HOSTVAR-ELEMENT-4        
              PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
              PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
           END-IF.                                                      
                                                                        
T17754 8030-EXIT.                                                       
           EXIT.                                                        
P00794*****************************************************************         
P00794* 8090-INSERT-FACTOR.                                           *         
P00794*****************************************************************         
P00794 8090-INSERT-FACTOR.                                              
P00794                                                                  
P00794     EXEC SQL                                                     
P00794         INSERT INTO CSS_FIXED_FCTR                               
P00794                (ACCOUNT_NO        ,                              
P00794                 CODE_UTIL_TYPE    ,                              
P00794                 IC_NO             ,                              
P00794                 FIXED_FCTR_SEQ_NO ,                              
P00794                 FACTOR_ID         ,                              
P00794                 EFF_DATE_FROM     ,                              
P00794                 CMPNT_ID_CD       ,                              
P00794                 CODE_SEASON       ,                              
P00794                 INSTR_USE_TYPE_CD ,                              
P00794                 CODE_TIME_PERIOD  ,                              
P00794                 EFF_DATE_TO       ,                              
P00794                 FIXED_FCTR_TYP_CD ,                              
P00794                 FACTOR            ,                              
P00794                 FAC_CHRG_BASE_AM  ,                              
P00794                 LAST_UPDATE_TS    ,                              
P00794                 DURATION_REMAIN_NO,                              
P00794                 RT_PKG_OPT_SEQ_NO)                               
P00794         VALUES                                                   
P00794                (:FF-ACCOUNT-NO       ,                           
P00794                 :FF-CODE-UTIL-TYPE   ,                           
P00794                 :FF-IC-NO            ,                           
P00794                 :FF-FIXED-FCTR-SEQ-NO,                           
P00794                 :FF-FACTOR-ID        ,                           
P00794                 IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-FROM
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-FROM
              ) <> 0) OR (LEN(:FF-EFF-DATE-FROM) <> 10), CIS.CHAR2DATE(
                                                      :FF-EFF-DATE-FROM
              ), CONVERT(DATE, :FF-EFF-DATE-FROM) )    ,                       
P00794                 :FF-CMPNT-ID-CD      ,                           
P00794                 :FF-CODE-SEASON      ,                           
P00794                 :FF-INSTR-USE-TYPE-CD,                           
P00794                 :FF-CODE-TIME-PERIOD ,                           
P00794                 IIF(TRY_CONVERT(DATE, :FF-EFF-DATE-TO
              ) IS NULL OR (PATINDEX('%.%', :FF-EFF-DATE-TO
              ) <> 0) OR (LEN(:FF-EFF-DATE-TO) <> 10), CIS.CHAR2DATE(
                                                        :FF-EFF-DATE-TO
              ), CONVERT(DATE, :FF-EFF-DATE-TO) )      ,                       
P00794                 :FF-FIXED-FCTR-TYP-CD,                           
P00794                 :FF-FACTOR           ,                           
P00794                 :FF-FAC-CHRG-BASE-AM ,                           
P00794                 CIS.CHAR2TIMESTAMP(:FF-LAST-UPDATE-TS)   ,               
P00794                 :FF-DURATION-REMAIN-NO :WS-NULL-VALUE,           
P00794                 :FF-RT-PKG-OPT-SEQ-NO)                           
P00794                                                                  
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO CSS_FIXED_FCTR                                       
MFA-TR*               (ACCOUNT_NO        ,                                      
MFA-TR*                CODE_UTIL_TYPE    ,                                      
MFA-TR*                IC_NO             ,                                      
MFA-TR*                FIXED_FCTR_SEQ_NO ,                                      
MFA-TR*                FACTOR_ID         ,                                      
MFA-TR*                EFF_DATE_FROM     ,                                      
MFA-TR*                CMPNT_ID_CD       ,                                      
MFA-TR*                CODE_SEASON       ,                                      
MFA-TR*                INSTR_USE_TYPE_CD ,                                      
MFA-TR*                CODE_TIME_PERIOD  ,                                      
MFA-TR*                EFF_DATE_TO       ,                                      
MFA-TR*                FIXED_FCTR_TYP_CD ,                                      
MFA-TR*                FACTOR            ,                                      
MFA-TR*                FAC_CHRG_BASE_AM  ,                                      
MFA-TR*                LAST_UPDATE_TS    ,                                      
MFA-TR*                DURATION_REMAIN_NO,                                      
MFA-TR*                RT_PKG_OPT_SEQ_NO)                                       
MFA-TR*        VALUES                                                           
MFA-TR*               (:FF-ACCOUNT-NO       ,                                   
MFA-TR*                :FF-CODE-UTIL-TYPE   ,                                   
MFA-TR*                :FF-IC-NO            ,                                   
MFA-TR*                :FF-FIXED-FCTR-SEQ-NO,                                   
MFA-TR*                :FF-FACTOR-ID        ,                                   
MFA-TR*                :FF-EFF-DATE-FROM    ,                                   
MFA-TR*                :FF-CMPNT-ID-CD      ,                                   
MFA-TR*                :FF-CODE-SEASON      ,                                   
MFA-TR*                :FF-INSTR-USE-TYPE-CD,                                   
MFA-TR*                :FF-CODE-TIME-PERIOD ,                                   
MFA-TR*                :FF-EFF-DATE-TO      ,                                   
MFA-TR*                :FF-FIXED-FCTR-TYP-CD,                                   
MFA-TR*                :FF-FACTOR           ,                                   
MFA-TR*                :FF-FAC-CHRG-BASE-AM ,                                   
MFA-TR*                :FF-LAST-UPDATE-TS   ,                                   
MFA-TR*                :FF-DURATION-REMAIN-NO :WS-NULL-VALUE,                   
MFA-TR*                :FF-RT-PKG-OPT-SEQ-NO)                                   
MFA-TR*                                                                         
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794                                                                  
P00794     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
P00794                                                                  
P00794     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
P00794        CONTINUE                                                  
P00794     ELSE                                                         
P00794          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
P00794          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
P00794          MOVE '8090'                    TO ACTIVE-PARAGRAPH      
P00794          MOVE 'INSERT'                  TO ABEND-FUNCTION        
P00794          MOVE 'CSS_FIXED_FACTOR'        TO TABLE-1               
P00794          MOVE 'FF-ACCOUNT-NO'           TO TABLE-ELEMENT-1       
P00794          MOVE 'FF-CODE-UTIL-TYPE'       TO TABLE-ELEMENT-2       
P00794          MOVE 'FF-IC-NO'                TO TABLE-ELEMENT-3       
P00794          MOVE FF-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
P00794          MOVE FF-CODE-UTIL-TYPE         TO HOSTVAR-ELEMENT-2     
P00794          MOVE FF-IC-NO                  TO HOSTVAR-ELEMENT-3     
P00794          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
P00794          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
P00794     END-IF.                                                      
P00794                                                                  
P00794 8090-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
P00794******************************************************************        
P00794* 8300-INSERT-MN-TRANS-HIST.                                              
P00794* INSERT A ROW INTO CSS_MNT_TRANS_HIST.                          *        
P00794******************************************************************        
P00794*                                                                         
P00794 8300-INSERT-MN-TRANS-HIST.                                       
P00794*                                                                         
P00794     EXEC SQL                                                     
P00794          INSERT INTO CSS_MNT_TRANS_HIST                          
P00794               ( TRANS_HIST_SEQ_NO,                               
P00794                 DATE_TRANS,                                      
P00794                 CODE_TRAN_TYPE,                                  
P00794                 RESP_AREA_ID,                                    
P00794                 ACCOUNT_NO,                                      
P00794                 CUSTOMER_NO,                                     
P00794                 PREMISE_NO,                                      
P00794                 USER_ID,                                         
P00794                 APPL_PROGRAM_ID,                                 
P00794                 TRAN_COMMENT,                                    
P00794                 ENTITY_KEY_DESC)                                 
P00794          VALUES                                                  
P00794               ( CIS.CHAR2TIMESTAMP(:MH-TRANS-HIST-SEQ-NO),               
P00794                 IIF(TRY_CONVERT(DATE, :MH-DATE-TRANS
              ) IS NULL OR (PATINDEX('%.%', :MH-DATE-TRANS
              ) <> 0) OR (LEN(:MH-DATE-TRANS) <> 10), CIS.CHAR2DATE(
                                                         :MH-DATE-TRANS
              ), CONVERT(DATE, :MH-DATE-TRANS) ),                              
P00794                 :MH-CODE-TRAN-TYPE,                              
P00794                 :MH-RESP-AREA-ID,                                
P00794                 :MH-ACCOUNT-NO,                                  
P00794                 :MH-CUSTOMER-NO,                                 
P00794                 :MH-PREMISE-NO,                                  
P00794                 :MH-USER-ID,                                     
P00794                 :MH-APPL-PROGRAM-ID,                             
P00794                 :MH-TRAN-COMMENT,                                
P00794                 :MH-ENTITY-KEY-DESC)                             
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MNT_TRANS_HIST                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                DATE_TRANS,                                              
MFA-TR*                CODE_TRAN_TYPE,                                          
MFA-TR*                RESP_AREA_ID,                                            
MFA-TR*                ACCOUNT_NO,                                              
MFA-TR*                CUSTOMER_NO,                                             
MFA-TR*                PREMISE_NO,                                              
MFA-TR*                USER_ID,                                                 
MFA-TR*                APPL_PROGRAM_ID,                                         
MFA-TR*                TRAN_COMMENT,                                            
MFA-TR*                ENTITY_KEY_DESC)                                         
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MH-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MH-DATE-TRANS,                                          
MFA-TR*                :MH-CODE-TRAN-TYPE,                                      
MFA-TR*                :MH-RESP-AREA-ID,                                        
MFA-TR*                :MH-ACCOUNT-NO,                                          
MFA-TR*                :MH-CUSTOMER-NO,                                         
MFA-TR*                :MH-PREMISE-NO,                                          
MFA-TR*                :MH-USER-ID,                                             
MFA-TR*                :MH-APPL-PROGRAM-ID,                                     
MFA-TR*                :MH-TRAN-COMMENT,                                        
MFA-TR*                :MH-ENTITY-KEY-DESC)                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794*                                                                         
P00794     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00794*                                                                         
P00794     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00794         CONTINUE                                                 
P00794     ELSE                                                         
P00794          MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE        
P00794          MOVE PROGRAM-NAME              TO ABEND-PROGRAM         
P00794          MOVE '8300'                    TO ACTIVE-PARAGRAPH      
P00794          MOVE 'INSERT'                  TO ABEND-FUNCTION        
P00794          MOVE 'CSS_MNT_TRANS_HIST'      TO TABLE-1               
P00794          MOVE 'MH-ACCOUNT-NO'           TO TABLE-ELEMENT-1       
P00794          MOVE 'MH-TRANS-HIST-SEQ-NO'    TO TABLE-ELEMENT-2       
P00794          MOVE 'MH-DATE-TRANS'           TO TABLE-ELEMENT-3       
P00794          MOVE MH-ACCOUNT-NO             TO HOSTVAR-ELEMENT-1     
P00794          MOVE MH-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2     
P00794          MOVE MH-DATE-TRANS             TO HOSTVAR-ELEMENT-3     
P00794          PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT           
P00794          PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT           
P00794     END-IF.                                                      
P00794*                                                                         
P00794 8300-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
P00794******************************************************************        
P00794* 8400-INSERT-MN-TRN-HST-DET.                                             
P00794* INSERT A ROW INTO CSS_MT_TRN_HST_DET.                          *        
P00794******************************************************************        
P00794*                                                                         
P00794 8400-INSERT-MN-TRN-HST-DET.                                      
P00794*                                                                         
P00794     EXEC SQL                                                     
P00794          INSERT INTO CSS_MT_TRN_HST_DET                          
P00794               ( TRANS_HIST_SEQ_NO,                               
P00794                 TRAN_APPL_NO,                                    
P00794                 COLUMN_DESC,                                     
P00794                 TABLE_ID,                                        
P00794                 PRV_COLUMN_VALUE,                                
P00794                 CHG_COLUMN_VALUE)                                
P00794          VALUES                                                  
P00794               ( CIS.CHAR2TIMESTAMP(:MI-TRANS-HIST-SEQ-NO),               
P00794                 :MI-TRAN-APPL-NO,                                
P00794                 :MI-COLUMN-DESC,                                 
P00794                 :MI-TABLE-ID,                                    
P00794                 :MI-PRV-COLUMN-VALUE,                            
P00794                 :MI-CHG-COLUMN-VALUE)                            
P00794     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ054
MFA-TR*    EXEC SQL                                                             
MFA-TR*         INSERT INTO CSS_MT_TRN_HST_DET                                  
MFA-TR*              ( TRANS_HIST_SEQ_NO,                                       
MFA-TR*                TRAN_APPL_NO,                                            
MFA-TR*                COLUMN_DESC,                                             
MFA-TR*                TABLE_ID,                                                
MFA-TR*                PRV_COLUMN_VALUE,                                        
MFA-TR*                CHG_COLUMN_VALUE)                                        
MFA-TR*         VALUES                                                          
MFA-TR*              ( :MI-TRANS-HIST-SEQ-NO,                                   
MFA-TR*                :MI-TRAN-APPL-NO,                                        
MFA-TR*                :MI-COLUMN-DESC,                                         
MFA-TR*                :MI-TABLE-ID,                                            
MFA-TR*                :MI-PRV-COLUMN-VALUE,                                    
MFA-TR*                :MI-CHG-COLUMN-VALUE)                                    
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

P00794*                                                                         
P00794     MOVE SQLCODE                    TO WS-ACTIVE-RETURN-CODE.    
P00794*                                                                         
P00794     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                  
P00794         CONTINUE                                                 
P00794     ELSE                                                         
P00794         MOVE WS-ACTIVE-RETURN-CODE     TO RS-RETURN-CODE         
P00794         MOVE PROGRAM-NAME              TO ABEND-PROGRAM          
P00794         MOVE '8400'                    TO ACTIVE-PARAGRAPH       
P00794         MOVE 'INSERT'                  TO ABEND-FUNCTION         
P00794         MOVE 'CSS_MT_TRN_HST_DET'      TO TABLE-1                
P00794         MOVE 'MH-TRANS-HIST-SEQ-NO'    TO TABLE-ELEMENT-1        
P00794         MOVE 'MI-TRAN-APPL-NO'         TO TABLE-ELEMENT-3        
P00794         MOVE MI-TRANS-HIST-SEQ-NO      TO HOSTVAR-ELEMENT-2      
P00794         MOVE MI-TRAN-APPL-NO           TO HOSTVAR-ELEMENT-3      
P00794         PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT            
P00794         PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT            
P00794     END-IF.                                                      
P00794*                                                                         
P00794 8400-EXIT.                                                       
P00794     EXIT.                                                        
P00794*                                                                         
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
           EXEC SQL                                                             
A00956       INCLUDE CPD0006A                                                   
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
              INCLUDE CPD00008                                                  
           END-EXEC.                                                            
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
T21115     EXEC SQL                                                             
T21115        INCLUDE CPD0023C                                                  
T21115     END-EXEC.                                                            
T21115                                                                  
      ******************************************************************        
      * LOADING GL NUMBERS                                                      
      ******************************************************************        
REARCH* 9350-LINK-SCSCO061.                                            *        
REARCH*    CALLS THE SUBPROGRAM SCSCO061*                                       
REARCH******************************************************************        
REARCH*                                                                         
REARCH 9350-LINK-SCSCO061.                                              
REARCH     MOVE SPACES                    TO ABEND-FUNCTION.            
REARCH     MOVE PROGRAM-NAME              TO WS-CPD00061-CALLING-PGM.   
REARCH*                                                                         
REARCH     CALL MCSCO061  USING  WS-GL-ACCT-NAME                        
REARCH                           WS-GL-ACCT-MAJOR-FIELDS                
REARCH                           WS-VALID-COMPANY-NOS                   
REARCH                           WS-GL-NAME-INFO                        
REARCH                           WS-GL-ACCT-NO-TABLE                    
REARCH                           ABEND-FILE                             
REARCH                           RS-RETURN-CODE.                        
REARCH                                                                  
T24436     MOVE RS-RETURN-CODE            TO WS-ACTIVE-RETURN-CODE,     
T24436                                       SQLCODE.                   
T24436     IF ABEND-FUNCTION  > SPACES                                  
REARCH        PERFORM 2000A-MOVE-RESULT   THRU 2000A-EXIT               
REARCH        ADD +1                      TO CTR-ROWS                   
T24436        PERFORM 9700-PROCESS-ABEND  THRU 9700-EXIT                
T24436     END-IF.                                                      
T24436                                                                  
T24436 9350-EXIT.                                                       
T24436     EXIT.                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00321                                                  
REARCH     END-EXEC.                                                            
REARCH*                                                                         
