       IDENTIFICATION DIVISION.                                         
       PROGRAM-ID.       CSR02349.                                      
COB303 DATE-WRITTEN.     APR  16, 1997.                                 
       DATE-COMPILED.                                                   
                                                                        
      ******************************************************************        
      *                SOUTH CAROLINA ELECTRIC & GAS                   *        
      *                                                                *        
      ******************************************************************        
      *                 P R O G R A M  S U M M A R Y                   *        
      *                                                                *        
      *  THIS PROGRAM RETRIEVES FOR THE CIS DISTRIBUTION PANEL         *        
      *  (PANEL487).                                                   *        
      ******************************************************************        
      *                                                                *        
      *                     PROGRAM MODIFICATION LOG                   *        
      *                                                                *        
      *    DATE    INITIALS   COMMENTS                                 *        
      *  --------  --------   ---------------------------------------  *        
      *  04/16/97  CHANDRA    PROCEDURE ORIGINALLY CODED               *        
      *                                                                *        
      *  07/14/97  CHANDRA    SELECT THE PJS STATUS FROM               *        
      *                       CSS_PROJ_SHARE. REMOVE EDITS TO CHECK THE*        
      *                       EXISTANCE OF CIS DEBIT ROW IN AR_CNTL    *        
T17129*  08/05/98    SV       ADD ACCTING PERIOD TO PANEL 487.         *00572202
T17550*  08/28/98    SV       ADD CODE BILL TYPE TO PANEL 487          *        
T17741*  09/06/98    SV       ADDED CHECK TO ENSURE THIS IS A VALID    *00572202
T17741*                       BUSINESS DAY PRIOR TO GETTING REVENUE    *00572202
T17741*                       MONTH. IF IT IS NOT, THEN THE NEXT       *00572202
T17741*                       BUSINESS DAY IS DETERMINED.              *00572202
CBSI  *  12/28/98    CBSI     ABEND LOG MODIFIED TO INCLUDE ALL THE    *        
CBSI  *              MADRAS   ABEND PARAMETERS                         *        
T21115*  11/26/99    CBSI     MODIFIED RESULT SET TO SEND LAST-UPDAT-TS*        
T21115*              CHENNAI  TO PANEL 487                             *        
REARCH*  07/18/05    CVNS     RPC TO COBOL SP CONVERSION               *        
REARCH*              CHENNAI                                           *        
T34097*  02/08/07   COVANSYS   1. NEED TO REPLACE MODEL_SQL WITH SET   *        
T34097*                           COMMAND                              *        
T33832*  03/09/07   JS83520   ADDED NEW COLUMN CNT-PAY-AHEAD           *        
P00453*  04/05/11   AA97148   1. MOVE RECV-TYPE AS 'PAG' FOR THE       *        
P00453*                          PAY-AND-GO ACCOUNTS.                  *        
P00453*                       2. ADDED QUERY NO FOR ALL SQL'S.         *        
P00453*                       3. ADDED WITH UR TO AVOID -911.          *        
P00453*  05/18/11   AA97148   REPLACED 'PAG' WITH 'PRP AND 'PAY-AND-GO'*        
P00453*                       WITH 'PRE-PAY-PLAN'.                     *        
ACT278*  10/08/16   TP7R341   REMOVE UNWANTED COLUMN FROM CONTRACT INFO*        
ACT278*   A05460              USER TABLE                               *        
      ******************************************************************        
      ******************************************************************        
      *                                                                *        
      *                ---- BASIC SEQUENCE STRUCTURE ----              *        
      *                                                                *        
      *  0000 - 0999  MAIN CONTROL PATH AND INITIALIZATION             *        
      *  1000 - 1999  INPUT PROCESSING CONTROL PATH                    *        
      *  2000 - 2999  OUTPUT PROCESSING CONTROL PATH                   *        
      *  3000 - 4999  NOT USED                                         *        
      *  5000 - 5999  COMMON PROGRAM MODULES                           *        
      *  6000 - 6999  COMMON SYSTEM MODULES                            *        
      *  7000 - 7999  INPUT MODULES                                    *        
      *  8000 - 8999  OUTPUT MODULES                                   *        
      *  9000 - 9999  TERMINATION,ABEND, MESSAGING MODULES             *        
      *                                                                *        
      ******************************************************************        
                                                                        
       ENVIRONMENT DIVISION.                                            
       DATA DIVISION.                                                   
       WORKING-STORAGE SECTION.                                         

MSQ002  01 MFA-CSRERLOG.
MSQ002    05 ARG-5 PIC X(255).
MSQ002    05 ARG-6 PIC X(255).
MSQ002    05 ARG-7 PIC X(447).

MSQ017 01 MFA-PROGRAM-ID PIC X(8) VALUE 'CSR02349'.
MSQ017     COPY MFASQLM.
                                                                        
REARCH 01  WS-START                                   PIC X(44) VALUE   
REARCH     'WORKING STORAGE FOR RPC CSR02349 STARTS HERE'.              
                                                                        
      ******************************************************************        
      *    DB2 INCLUDES                                                *        
      ******************************************************************        
                                                                        
           EXEC SQL                                                             
              INCLUDE SQLCA                                                     
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARCNTL                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBARTYPE                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDFAACT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTRCT                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBCNTINF                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBDEPHND                                                 
           END-EXEC.                                                            
                                                                        
           EXEC SQL                                                             
               INCLUDE TBACCT                                                   
           END-EXEC.                                                            
                                                                        
T17129     EXEC SQL                                                             
T17129        INCLUDE TBBILWDW                                                  
T17129     END-EXEC.                                                    01490000
                                                                        
T17741     EXEC SQL                                                             
T17741        INCLUDE TBHLDAY                                                   
T17741     END-EXEC.                                                    01490000
      ******************************************************************        
      *    COBOL WORKING STORAGE COPY BOOKS                            *        
      ******************************************************************        
                                                                        
      *--------< CONTAINS THE COBOL EQUATES NEEDED FOR USING THE >              
      *--------< SYBASE OPEN SERVER FOR CICS FACILITIES.         >              
                                                                        
      *--------< ADDED TO SUPPORT CICS RPCS >                                   
           COPY SYDBCOB.                                                        
                                                                        
      *--------< ERROR HANDLING >                                               
                                                                        
REARCH     EXEC SQL                                                             
REARCH          INCLUDE CWSX0010                                                
REARCH     END-EXEC.                                                            
                                                                        
      *--------< ERROR WORK AREA - SUPPORTS ONLINE/CSR JOURNALS >               
           COPY CWS00027.                                                       
      *--------< SUPPORTS DB2 AND SQL ERROR CHECKING >                          
           COPY CWS00303.                                                       
                                                                        
           COPY CWS00056.                                                       
T17741     EXEC SQL                                                     01600000
T17741         INCLUDE CWS00315                                         01600000
T17741     END-EXEC.                                                    01600000
                                                                        
       01  WS-CSR-VARIABLES.                                            
           05 WS-CSR-PYMT-PRIORITY-LVL PIC S9(4) USAGE COMP.            
           05 WS-CSR-ITEM-ID           PIC S9(9) USAGE COMP.            
COB305     05 WS-CSR-AMT-DAY-00        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-AMT-DAY-30        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-AMT-DAY-60        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-AMT-DAY-90        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-UNUSED-CR        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-FULL-BALANCE        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
COB305     05 WS-CSR-ORIG-BALANCE        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-CSR-STATUS-CODE       PIC X(1)  VALUE SPACE.           
           05 WS-CSR-STATUS-CODE-DESC  PIC X(11) VALUE SPACES.          
           05 WS-CSR-SOURCE-TBL        PIC X(15) VALUE SPACES.          
COB305     05 WS-CSR-BILL-BALANCE        PIC S999999999V99 USAGE COMP-3 
COB305       VALUE 0.  
           05 WS-CSR-RECV-TYPE         PIC X(3)  VALUE SPACES.          
           05 WS-CSR-RECV-TYPE-DESC    PIC X(25) VALUE SPACES.          
           05 WS-CSR-ITEM-ID-CHAR      PIC 9(9)  VALUE ZERO.            
           05 WS-CSR-ITEM-ID-CHAR-ALL REDEFINES  WS-CSR-ITEM-ID-CHAR.   
              10 FILLER                PIC X(1).                        
              10 CSR-ITEM-ID-YYYY      PIC X(4).                        
              10 CSR-ITEM-ID-MM        PIC X(2).                        
              10 CSR-ITEM-ID-DD        PIC X(2).                        
           05 WS-CSR-ITEM-ID-DATE.                                      
              10 CSR-ITEM-ID-DATE-YYYY PIC X(4).                        
              10 FILLER                PIC X(1) VALUE '-'.              
              10 CSR-ITEM-ID-DATE-MM   PIC X(2).                        
              10 FILLER                PIC X(1) VALUE '-'.              
              10 CSR-ITEM-ID-DATE-DD   PIC X(2).                        
      *                                                                         
       01  WS-MISC.                                                     
P00453     05 WS-A                     PIC X(1)  VALUE 'A'.             
           05 WS-D                     PIC X(01) VALUE 'D'.             
           05 WS-E                     PIC X(01) VALUE 'E'.             
           05 WS-YES                   PIC X(03) VALUE 'YES'.           
REARCH     05 PROGRAM-NAME             PIC X(8)  VALUE 'CSR02349'.      
REARCH     05 WS-SQLSTATE              PIC X(05) VALUE '     '.         
           05  WS-ACCOUNT-NO            PIC  X(13).                     
           05  WS-ACCOUNT-NO-NUM REDEFINES WS-ACCOUNT-NO                
                                        PIC  9(13).                     
           05  WS-ACCOUNT-NO-COMP3      PIC S9(13) COMP-3 VALUE +0.     
T17129     05  WS-SUB                   PIC 9(01) VALUE 1.              
T17129     05  WS-REVENUE-MONTH.                                        
T17129         10  WS-REVENUE-MONTH-NUM  PIC 9(6).                      
T17741     05  WS-BUSINESS-DAY          PIC X(10).                      
T17741     05  WS-REVENUE-EXISTS        PIC X(1) VALUE 'N'.             
T17741     05  WS-CURRENT-DATE-DB2      PIC X(10)  VALUE SPACES.        
      *                                                                         
       01  WS-GL-PPL-TABLE.                                             
           05  WS-PPL-AR-TYPE-NSC         PIC S9(4) COMP VALUE  +019.   
           05  WS-PPL-AR-TYPE-NSA         PIC S9(4) COMP VALUE  +020.   
           05  WS-PPL-AR-TYPE-NSN         PIC S9(4) COMP VALUE  +029.   
           05  WS-PPL-AR-TYPE-LPC         PIC S9(4) COMP VALUE  +030.   
           05  WS-PPL-AR-TYPE-LPN         PIC S9(4) COMP VALUE  +039.   
           05  WS-PPL-AR-TYPE-UTE         PIC S9(4) COMP VALUE  +040.   
           05  WS-PPL-AR-TYPE-UTG         PIC S9(4) COMP VALUE  +045.   
           05  WS-PPL-AR-TYPE-EPP         PIC S9(4) COMP VALUE  +050.   
           05  WS-PPL-AR-TYPE-CCC         PIC S9(4) COMP VALUE  +060.   
           05  WS-PPL-AR-TYPE-RCC         PIC S9(4) COMP VALUE  +060.   
           05  WS-PPL-AR-TYPE-CIA         PIC S9(4) COMP VALUE  +070.   
           05  WS-PPL-AR-TYPE-DEP         PIC S9(4) COMP VALUE  +080.   
           05  WS-PPL-AR-TYPE-DFA         PIC S9(4) COMP VALUE  +090.   
           05  WS-PPL-AR-TYPE-CNT         PIC S9(4) COMP VALUE  +100.   
           05  WS-PPL-AR-TYPE-RVC         PIC S9(4) COMP VALUE  +110.   
           05  WS-PPL-AR-TYPE-PJS         PIC S9(4) COMP VALUE  +129.   
           05  WS-PPL-AR-TYPE-ADJ         PIC S9(4) COMP VALUE  +999.   
      *                                                                         
       01  SWITCHES.                                                    
           05  WS-NSC-DONE-IND         PIC X(01) VALUE 'N'.             
               88 NSC-ROW-NOT-SEND               VALUE 'N'.             
               88 NSC-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-NSA-DONE-IND         PIC X(01) VALUE 'N'.             
               88 NSA-ROW-NOT-SEND               VALUE 'N'.             
               88 NSA-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-NSN-DONE-IND         PIC X(01) VALUE 'N'.             
               88 NSN-ROW-NOT-SEND               VALUE 'N'.             
               88 NSN-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-LPC-DONE-IND         PIC X(01) VALUE 'N'.             
               88 LPC-ROW-NOT-SEND               VALUE 'N'.             
               88 LPC-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-LPN-DONE-IND         PIC X(01) VALUE 'N'.             
               88 LPN-ROW-NOT-SEND               VALUE 'N'.             
               88 LPN-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-UTE-DONE-IND         PIC X(01) VALUE 'N'.             
               88 UTE-ROW-NOT-SEND               VALUE 'N'.             
               88 UTE-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-UTG-DONE-IND         PIC X(01) VALUE 'N'.             
               88 UTG-ROW-NOT-SEND               VALUE 'N'.             
               88 UTG-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-EPP-DONE-IND         PIC X(01) VALUE 'N'.             
               88 EPP-ROW-NOT-SEND               VALUE 'N'.             
               88 EPP-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-RCC-DONE-IND         PIC X(01) VALUE 'N'.             
               88 RCC-ROW-NOT-SEND               VALUE 'N'.             
               88 RCC-ROW-SEND                   VALUE 'Y'.             
      *                                                                         
           05  WS-CIA-DEBIT-DONE-IND   PIC X(01) VALUE 'N'.             
               88 CIA-DEBIT-ROW-NOT-SEND         VALUE 'N'.             
               88 CIA-DEBIT-ROW-SEND             VALUE 'Y'.             
      *                                                                         
           05  WS-CIA-DEBIT-ROW-IND    PIC X(01) VALUE 'N'.             
               88 CIA-DEBIT-ROW-NOT-EXIST        VALUE 'N'.             
               88 CIA-DEBIT-ROW-EXIST            VALUE 'Y'.             
      *                                                                         
           05  WS-VALID-ROW-FLAG       PIC X(01) VALUE 'Y'.             
               88 NOT-VALID-TO-SEND              VALUE 'N'.             
               88 VALID-TO-SEND                  VALUE 'Y'.             
      *                                                                         
           05  ALL-DONE-SW             PIC X(01) VALUE 'N'.             
               88 NOT-ALL-DONE                   VALUE 'N'.             
               88 ALL-DONE                       VALUE 'Y'.             
      *                                                                         
           05  SEND-DONE-SW            PIC X(01) VALUE 'Y'.             
               88 SEND-DONE-ERROR                VALUE 'N'.             
               88 SEND-DONE-OK                   VALUE 'Y'.             
HPCCDM*    EJECT                                                                
      *                                                                         
       01  FILLER                      PIC X(11) VALUE 'PARM FIELDS'.   
      *                                                                         
       01  PARM-FIELDS.                                                 
REARCH     05  PARM-ACCOUNT-NO-TEMP    PIC X(13).                       
REARCH     05  PARM-ACCOUNT-NO-NUM REDEFINES PARM-ACCOUNT-NO-TEMP       
REARCH                                 PIC 9(13).                       
                                                                        
       01  COUNTER-FIELDS.                                              
           05  CTR-COLUMN              PIC S9(9) COMP VALUE 1.          
           05  CTR-ROWS                PIC S9(9) COMP VALUE 0.          
           05  WS-ROW-COUNT            PIC S9(9) COMP VALUE 0.          
                                                                        
       01  WORK-FIELDS.                                                 
           05  MAX-LENGTH-PARM         PIC S9(9) COMP.                  
           05  WRKLEN1                 PIC S9(9) COMP.                  
           05  WRKLEN2                 PIC S9(9) COMP.                  
           05  WRK-DONE-STATUS         PIC S9(9) COMP.                  
           05  WS-DATE-NULL-IND-1      PIC S9(04) COMP VALUE +0.        
           05  WS-DATE-NULL-IND-2      PIC S9(04) COMP VALUE +0.        
                                                                        
                                                                        
       01  FILLER  PIC X(32) VALUE 'THIS IS THE ROW RETURN AREA.'.      
                                                                        
REARCH 01  CSRERLOG-P.                                                  
REARCH     10  S-SP-NAME                 PIC X(18) VALUE SPACES.        
REARCH     10  S-SQLCODE                 PIC S9(9) COMP VALUE 0.        
REARCH     10  S-SQLSTATE                PIC X(5)  VALUE ' '.           
REARCH     10  S-TABLE-NAME              PIC X(18) VALUE SPACES.        
REARCH     10  S-HOST-VARIABLES.                                        
REARCH         49  S-HOST-VARIABLES-L    PIC S9(4) USAGE COMP.          
REARCH         49  S-HOST-VARIABLES-V    PIC X(255).                    
REARCH     10  S-SQL-STATEMENT.                                         
REARCH         49  S-SQL-STATEMENT-L     PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-STATEMENT-V     PIC X(255).                    
REARCH     10  S-SQL-DESCRIPTION.                                       
REARCH         49  S-SQL-DESCRIPTION-L   PIC S9(4) USAGE COMP.          
REARCH         49  S-SQL-DESCRIPTION-V   PIC X(255).                    
                                                                        
REARCH 01  GTT-MISC-FIELDS.                                             
REARCH     05  ROWICMS                   PIC X(07) VALUE 'ROWICMS'.     
REARCH     05  GTT-NAME                  PIC X(26) VALUE                
REARCH                                       'SESSION.CSR02349_R1'.     
REARCH     05  GTT-ROW.                                                 
REARCH         49 GTT-ROW-LEN            PIC S9(04) COMP.               
REARCH         49 GTT-ROW-CHAR           PIC X(1024).                   
REARCH     05  GTT-SQLCODE               PIC S9(9) COMP.                
                                                                        
       01  TDS-RETURN-FIELDS.                                           
            05 RS-RETURN-CODE           PIC S9(9)  COMP VALUE   0.      
            05 RS-PYMT-PRIORITY-LVL     PIC S9(04) COMP VALUE  +0.      
            05 RS-ITEM-ID               PIC S9(09) COMP VALUE  +0.      
            05 RS-BILL-BALANCE-AMT      PIC S9(9)V9(2)  COMP-3 VALUE 0. 
            05 RS-FULL-BALANCE-AMT      PIC S9(9)V9(2)  COMP-3 VALUE 0. 
            05 RS-ORIG-BALANCE-AMT      PIC S9(11)V9(2) COMP-3 VALUE 0. 
            05 RS-STATUS-CODE           PIC X(1)        VALUE SPACE.    
            05 RS-STATUS-CODE-DESC      PIC X(11)       VALUE SPACE.    
            05 RS-SOURCE-TBL            PIC X(15)       VALUE SPACES.   
            05 RS-RECV-TYPE             PIC X(3)        VALUE SPACES.   
            05 RS-RECV-TYPE-DESC        PIC X(25)       VALUE SPACES.   
T17129     05  RS-REVENUE-MONTH-1       PIC X(6)  VALUE SPACES.         
T17129     05  RS-REVENUE-MONTH-2       PIC X(6)  VALUE SPACES.         
T17550     05  RS-CODE-BILL-TYPE        PIC X(1)  VALUE SPACES.         
T21115     05  RS-LAST-UPDATE-TS        PIC X(26) VALUE SPACES.         
REARCH      05 RS-CHARGE-AMT            PIC S9(9)V9(2)  COMP-3 VALUE 0. 
REARCH      05 RS-CHANGE-FLAG           PIC X(01) VALUE SPACES.         
REARCH      05 RS-GL-NO                 PIC S9(3)V9(4)  COMP-3 VALUE 0. 
C33832      05 RS-CNT-PAY-AHEAD         PIC X(01) VALUE SPACES.         
                                                                        
REARCH 01  GTT-RETURN-FIELDS.                                           
REARCH      05 S-RETURN-CODE            PIC S9(9)  COMP VALUE   0.      
REARCH      05 S-PYMT-PRIORITY-LVL      PIC S9(04) COMP VALUE  +0.      
REARCH      05 S-ITEM-ID                PIC S9(09) COMP VALUE  +0.      
REARCH      05 S-BILL-BALANCE-AMT       PIC S9(9)V9(2)  COMP-3 VALUE 0. 
REARCH      05 S-FULL-BALANCE-AMT       PIC S9(9)V9(2)  COMP-3 VALUE 0. 
REARCH      05 S-ORIG-BALANCE-AMT       PIC S9(11)V9(2) COMP-3 VALUE 0. 
REARCH      05 S-STATUS-CODE            PIC X(1)        VALUE SPACE.    
REARCH      05 S-STATUS-CODE-DESC       PIC X(11)       VALUE SPACE.    
REARCH      05 S-SOURCE-TBL             PIC X(15)       VALUE SPACES.   
REARCH      05 S-RECV-TYPE              PIC X(3)        VALUE SPACES.   
REARCH      05 S-RECV-TYPE-DESC         PIC X(25)       VALUE SPACES.   
REARCH      05 S-REVENUE-MONTH-1        PIC X(6)  VALUE SPACES.         
REARCH      05 S-REVENUE-MONTH-2        PIC X(6)  VALUE SPACES.         
REARCH      05 S-CODE-BILL-TYPE         PIC X(1)  VALUE SPACES.         
REARCH      05 S-LAST-UPDATE-TS         PIC X(26) VALUE SPACES.         
REARCH      05 S-CHARGE-AMT             PIC S9(9)V9(2)  COMP-3 VALUE 0. 
REARCH      05 S-CHANGE-FLAG            PIC X(01) VALUE SPACES.         
REARCH      05 S-GL-NO                  PIC S9(3)V9(4)  COMP-3 VALUE 0. 
C33832      05 S-CNT-PAY-AHEAD          PIC X(01) VALUE SPACES.         
                                                                        
REARCH LINKAGE SECTION.                                                 
REARCH*                                                                         
REARCH 01  PARM-ACCOUNT-NO              PIC X(13).                      
REARCH 01  PARM-MISC-DEBIT              PIC X(01).                      
                                                                        
      ******************************************************************        
      *    CURSOR DECLARATIONS                                         *        
      ******************************************************************        
                                                                        
      ******************************************************************        
      **  THE FOLLOWING DECLARES THE CURSOR FOR RETRIEVING A SET OF   **        
      **  ROWS FROM THE CSS_AR_TRANS_HIST TABLE.                      **        
      ******************************************************************        
           EXEC SQL                                                     
             DECLARE ALL-PPTY-ROWS CURSOR FOR                           
             SELECT   PYMT_PRIORITY_LVL                                 
                    , ITEM_ID                                           
                    , AMT_AR_DAY_00                                     
                    , AMT_AR_DAY_30                                     
                    , AMT_AR_DAY_60                                     
                    , AMT_AR_DAY_90                                     
                    , AMT_UNUSED_CR                                     
                    , AMT_TRAN_BALANCE                                  
                    , 0                                                 
                    , 'A'                                               
                    ,'CSS_AR_CNTL    '                                  
             FROM   CSS_AR_CNTL WITH(READUNCOMMITTED)                           
             WHERE  ACCOUNT_NO               = :AC-ACCOUNT-NO           
               AND  (     PYMT_PRIORITY_LVL <=  70                      
                    OR (  PYMT_PRIORITY_LVL  =  90                      
                      AND ITEM_ID < 30000000                            
                       ))                                               
             UNION                                                      
             SELECT   A.PYMT_PRIORITY_LVL                               
                    , A.ITEM_ID                                         
                    , A.AMT_AR_DAY_00                                   
                    , A.AMT_AR_DAY_30                                   
                    , A.AMT_AR_DAY_60                                   
                    , A.AMT_AR_DAY_90                                   
                    , A.AMT_UNUSED_CR                                   
                    , A.AMT_TRAN_BALANCE                                
                    , 0                                                 
                    , B.SHARE_STATUS_CD                                 
                    ,'CSS_AR_CNTL    '                                  
             FROM   CSS_AR_CNTL A WITH(READUNCOMMITTED), CSS_PROJ_SHARE 
           B WITH(READUNCOMMITTED)                     
             WHERE  A.ACCOUNT_NO           = :AC-ACCOUNT-NO             
               AND  A.PYMT_PRIORITY_LVL    = 129                        
               AND  A.ACCOUNT_NO           = B.ACCOUNT_NO               
               AND  A.PYMT_PRIORITY_LVL    = B.PYMT_PRIORITY_LVL        
               AND  A.ITEM_ID              = B.ITEM_ID                  
             UNION                                                      
             SELECT   PYMT_PRIORITY_LVL                                 
                    , CNT_ITEM_ID                                       
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , AMT_ORIG_ENTERED                                  
                    , CNT_STATUS_CD                                     
                    ,'CSS_CONTRACT   '                                  
             FROM   CSS_CONTRACT WITH(READUNCOMMITTED)                          
             WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                  
               AND  CNT_STATUS_CD IN ( 'A','B', 'C', 'D', 'E' )         
             UNION                                                      
             SELECT   80                                                
                    , DEPOSIT_CERT_NO                                   
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , AMT_DEPOSIT                                       
                    , DEPOSIT_STATUS_CD                                 
                    ,'CSS_DEP_ON_HAND'                                  
             FROM   CSS_DEP_ON_HAND WITH(READUNCOMMITTED)                       
             WHERE  ACCOUNT_NO         = :AC-ACCOUNT-NO                 
               AND  DEPOSIT_STATUS_CD  IN ( 'A' , 'P' )                 
             UNION                                                      
             SELECT   PYMT_PRIORITY_LVL                                 
                    , DFA_ITEM_ID                                       
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , 0                                                 
                    , AMT_ORIG_ENTERED                                  
                    , CODE_DFA_STATUS                                   
                    ,'CSS_DFA_ACCT   '                                  
             FROM   CSS_DFA_ACCT WITH(READUNCOMMITTED)                          
             WHERE  ACCOUNT_NO         = :AC-ACCOUNT-NO                 
               AND  ( CODE_DFA_TYPE    = 'A'                            
                     OR ( CODE_DFA_TYPE = 'B' AND                       
                          DFA_ITEM_ID = (                               
                                   SELECT  MAX(DFA_ITEM_ID)             
                                     FROM  CSS_DFA_ACCT
                           WITH(READUNCOMMITTED)                 
                                    WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO 
                                      AND  PYMT_PRIORITY_LVL  = 90      
                                      AND  CODE_DFA_TYPE      = 'B'     
                                        )                               
                        )                                               
                    )                                                   
             ORDER BY 1,2,3,4,5,6,7,8,9,10                              
P00453         FOR READ ONLY                                    
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*      DECLARE ALL-PPTY-ROWS CURSOR FOR                                   
MFA-TR*      SELECT   PYMT_PRIORITY_LVL                                         
MFA-TR*             , ITEM_ID                                                   
MFA-TR*             , AMT_AR_DAY_00                                             
MFA-TR*             , AMT_AR_DAY_30                                             
MFA-TR*             , AMT_AR_DAY_60                                             
MFA-TR*             , AMT_AR_DAY_90                                             
MFA-TR*             , AMT_UNUSED_CR                                             
MFA-TR*             , AMT_TRAN_BALANCE                                          
MFA-TR*             , 0                                                         
MFA-TR*             , 'A'                                                       
MFA-TR*             ,'CSS_AR_CNTL    '                                          
MFA-TR*      FROM   CSS_AR_CNTL                                                 
MFA-TR*      WHERE  ACCOUNT_NO               = :AC-ACCOUNT-NO                   
MFA-TR*        AND  (     PYMT_PRIORITY_LVL <=  70                              
MFA-TR*             OR (  PYMT_PRIORITY_LVL  =  90                              
MFA-TR*               AND ITEM_ID < 30000000                                    
MFA-TR*                ))                                                       
MFA-TR*      UNION                                                              
MFA-TR*      SELECT   A.PYMT_PRIORITY_LVL                                       
MFA-TR*             , A.ITEM_ID                                                 
MFA-TR*             , A.AMT_AR_DAY_00                                           
MFA-TR*             , A.AMT_AR_DAY_30                                           
MFA-TR*             , A.AMT_AR_DAY_60                                           
MFA-TR*             , A.AMT_AR_DAY_90                                           
MFA-TR*             , A.AMT_UNUSED_CR                                           
MFA-TR*             , A.AMT_TRAN_BALANCE                                        
MFA-TR*             , 0                                                         
MFA-TR*             , B.SHARE_STATUS_CD                                         
MFA-TR*             ,'CSS_AR_CNTL    '                                          
MFA-TR*      FROM   CSS_AR_CNTL A, CSS_PROJ_SHARE B                             
MFA-TR*      WHERE  A.ACCOUNT_NO           = :AC-ACCOUNT-NO                     
MFA-TR*        AND  A.PYMT_PRIORITY_LVL    = 129                                
MFA-TR*        AND  A.ACCOUNT_NO           = B.ACCOUNT_NO                       
MFA-TR*        AND  A.PYMT_PRIORITY_LVL    = B.PYMT_PRIORITY_LVL                
MFA-TR*        AND  A.ITEM_ID              = B.ITEM_ID                          
MFA-TR*      UNION                                                              
MFA-TR*      SELECT   PYMT_PRIORITY_LVL                                         
MFA-TR*             , CNT_ITEM_ID                                               
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , AMT_ORIG_ENTERED                                          
MFA-TR*             , CNT_STATUS_CD                                             
MFA-TR*             ,'CSS_CONTRACT   '                                          
MFA-TR*      FROM   CSS_CONTRACT                                                
MFA-TR*      WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                          
MFA-TR*        AND  CNT_STATUS_CD IN ( 'A','B', 'C', 'D', 'E' )                 
MFA-TR*      UNION                                                              
MFA-TR*      SELECT   80                                                        
MFA-TR*             , DEPOSIT_CERT_NO                                           
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , AMT_DEPOSIT                                               
MFA-TR*             , DEPOSIT_STATUS_CD                                         
MFA-TR*             ,'CSS_DEP_ON_HAND'                                          
MFA-TR*      FROM   CSS_DEP_ON_HAND                                             
MFA-TR*      WHERE  ACCOUNT_NO         = :AC-ACCOUNT-NO                         
MFA-TR*        AND  DEPOSIT_STATUS_CD  IN ( 'A' , 'P' )                         
MFA-TR*      UNION                                                              
MFA-TR*      SELECT   PYMT_PRIORITY_LVL                                         
MFA-TR*             , DFA_ITEM_ID                                               
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , 0                                                         
MFA-TR*             , AMT_ORIG_ENTERED                                          
MFA-TR*             , CODE_DFA_STATUS                                           
MFA-TR*             ,'CSS_DFA_ACCT   '                                          
MFA-TR*      FROM   CSS_DFA_ACCT                                                
MFA-TR*      WHERE  ACCOUNT_NO         = :AC-ACCOUNT-NO                         
MFA-TR*        AND  ( CODE_DFA_TYPE    = 'A'                                    
MFA-TR*              OR ( CODE_DFA_TYPE = 'B' AND                               
MFA-TR*                   DFA_ITEM_ID = (                                       
MFA-TR*                            SELECT  MAX(DFA_ITEM_ID)                     
MFA-TR*                              FROM  CSS_DFA_ACCT                         
MFA-TR*                             WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO         
MFA-TR*                               AND  PYMT_PRIORITY_LVL  = 90              
MFA-TR*                               AND  CODE_DFA_TYPE      = 'B'             
MFA-TR*                                 )                                       
MFA-TR*                 )                                                       
MFA-TR*             )                                                           
MFA-TR*      ORDER BY 1,2,3,4,5,6,7,8,9,10                                      
MFA-TR*        FOR FETCH ONLY WITH UR                                           
MFA-TR*    QUERYNO 7000                                                         
MFA-TR*    END-EXEC.                                                            
                                                                        
T17129     EXEC SQL DECLARE BILWDW-CURSOR CURSOR FOR                    
T17129        SELECT DISTINCT(REVENUE_MONTH)                            
T17129          FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                      
T17741         WHERE DATE_EXTRACT = IIF(TRY_CONVERT(DATE, 
                                                       :WS-BUSINESS-DAY
              ) IS NULL OR (PATINDEX('%.%', :WS-BUSINESS-DAY
              ) <> 0) OR (LEN(:WS-BUSINESS-DAY) <> 10), CIS.CHAR2DATE(
                                                       :WS-BUSINESS-DAY
              ), CONVERT(DATE, :WS-BUSINESS-DAY) )                    
T17129        ORDER BY REVENUE_MONTH DESC                               
P00453          FOR READ ONLY                                   
P00453                                                      
T17129     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ004
MFA-TR* MSQ022
MFA-TR* MSQ054
MFA-TR*    EXEC SQL DECLARE BILWDW-CURSOR CURSOR FOR                            
MFA-TR*       SELECT DISTINCT(REVENUE_MONTH)                                    
MFA-TR*         FROM CSS_BILL_WINDOW                                            
MFA-TR*        WHERE DATE_EXTRACT = :WS-BUSINESS-DAY                            
MFA-TR*       ORDER BY REVENUE_MONTH DESC                                       
MFA-TR*         FOR FETCH ONLY WITH UR                                          
MFA-TR*     QUERYNO 2301                                                        
MFA-TR*    END-EXEC.                                                            
HPCCDM*EJECT                                                                    
REARCH PROCEDURE DIVISION USING  PARM-ACCOUNT-NO                        
REARCH                          ,PARM-MISC-DEBIT.                       
                                                                        
      ******************************************************************        
      * 0000-MAINLINE                                                  *        
      ******************************************************************        
                                                                        
       0000-MAINLINE.                                                   
           PERFORM 0100-INITIALIZE     THRU 0100-EXIT.                  
           PERFORM 1000-PROCESS-INPUT  THRU 1000-EXIT.                  
           PERFORM 2000-PROCESS-OUTPUT THRU 2000-EXIT.                  
           PERFORM 9999-END-PROGRAM    THRU 9999-EXIT.                  
       0000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 0100-INITIALIZE                                                *        
      ******************************************************************        
                                                                        
       0100-INITIALIZE.                                                 
                                                                        
           MOVE '0100'          TO ACTIVE-PARAGRAPH.                    
                                                                        
           EXEC SQL WHENEVER SQLWARNING CONTINUE END-EXEC.              
           EXEC SQL WHENEVER SQLERROR   CONTINUE END-EXEC.              
           EXEC SQL WHENEVER NOT FOUND  CONTINUE END-EXEC.              
                                                                        
REARCH     PERFORM 0100A-DECLARE-GTT    THRU 0100A-EXIT.                
REARCH*                                                                         
REARCH     EXEC SQL                                                     
REARCH                                                                  
REARCH         DECLARE C1 CURSOR  FOR                        
REARCH         SELECT                                                   
REARCH              RETURN_CODE                                         
REARCH             ,PYMT_PRIORITY_LVL                                   
REARCH             ,ITEM_ID                                             
REARCH             ,BILL_BALANCE_AMT                                    
REARCH             ,FULL_BALANCE_AMT                                    
REARCH             ,ORIG_BALANCE_AMT                                    
REARCH             ,STATUS_CODE                                         
REARCH             ,LTRIM(RTRIM(STATUS_CODE_DESC))   AS STATUS_CODE_DESC       
REARCH             ,LTRIM(RTRIM(SOURCE_TBL))         AS SOURCE_TBL             
REARCH             ,RECV_TYPE                                           
REARCH             ,LTRIM(RTRIM(RECV_TYPE_DESC))     AS RECV_TYPE_DESC         
REARCH             ,LTRIM(RTRIM(REVENUE_MONTH_1))    AS REVENUE_MONTH_1        
REARCH             ,LTRIM(RTRIM(REVENUE_MONTH_2))    AS REVENUE_MONTH_2        
REARCH             ,CODE_BILL_TYPE                                      
REARCH             ,LTRIM(RTRIM(LAST_UPDATE_TS))     AS LAST_UPDATE_TS         
REARCH             ,CHARGE_AMT                                          
REARCH             ,CHANGE_FLAG                                         
REARCH             ,GL_NO                                               
REARCH         FROM                                                     
REARCH             #CSR02349_R1                                  
REARCH     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ029
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*                                                                         
MFA-TR*        DECLARE C1 CURSOR WITH RETURN FOR                                
MFA-TR*        SELECT                                                           
MFA-TR*             RETURN_CODE                                                 
MFA-TR*            ,PYMT_PRIORITY_LVL                                           
MFA-TR*            ,ITEM_ID                                                     
MFA-TR*            ,BILL_BALANCE_AMT                                            
MFA-TR*            ,FULL_BALANCE_AMT                                            
MFA-TR*            ,ORIG_BALANCE_AMT                                            
MFA-TR*            ,STATUS_CODE                                                 
MFA-TR*            ,STRIP(STATUS_CODE_DESC)   AS STATUS_CODE_DESC               
MFA-TR*            ,STRIP(SOURCE_TBL)         AS SOURCE_TBL                     
MFA-TR*            ,RECV_TYPE                                                   
MFA-TR*            ,STRIP(RECV_TYPE_DESC)     AS RECV_TYPE_DESC                 
MFA-TR*            ,STRIP(REVENUE_MONTH_1)    AS REVENUE_MONTH_1                
MFA-TR*            ,STRIP(REVENUE_MONTH_2)    AS REVENUE_MONTH_2                
MFA-TR*            ,CODE_BILL_TYPE                                              
MFA-TR*            ,STRIP(LAST_UPDATE_TS)     AS LAST_UPDATE_TS                 
MFA-TR*            ,CHARGE_AMT                                                  
MFA-TR*            ,CHANGE_FLAG                                                 
MFA-TR*            ,GL_NO                                                       
MFA-TR*        FROM                                                             
MFA-TR*            SESSION.CSR02349_R1                                          
MFA-TR*    END-EXEC.                                                            
REARCH*                                                                         
       0100-EXIT.                                                       
           EXIT.                                                        
REARCH*                                                                         
REARCH******************************************************************        
REARCH* 0100A-DECLARE-GTT                                              *        
REARCH*                                                                *        
REARCH*     DECLARING GLOBAL TEMPORARY TABLE AND CHECKING TO DELETE    *        
REARCH*     GTT ROWS IF IT EXISTS.                                     *        
REARCH*                                                                *        
REARCH******************************************************************        
REARCH*                                                                         
REARCH 0100A-DECLARE-GTT.                                               
REARCH*                                                                         
REARCH     MOVE 'DECLARE GLOBAL TEMPORARY TABLE CSR02349_R1'            
REARCH                                   TO S-SQL-STATEMENT-V.          
REARCH     EXEC SQL
             CALL CIS.DROP_TEMP_TABLE('#CSR02349_R1')
           END-EXEC
           EXEC SQL
             CREATE TABLE #CSR02349_R1
              (                                                        
REARCH             RETURN_CODE          INT                         
REARCH            ,PYMT_PRIORITY_LVL    SMALLINT                        
REARCH            ,ITEM_ID              INT                         
REARCH            ,BILL_BALANCE_AMT     DECIMAL(11,2)                   
REARCH            ,FULL_BALANCE_AMT     DECIMAL(11,2)                   
REARCH            ,ORIG_BALANCE_AMT     DECIMAL(13,2)                   
REARCH            ,STATUS_CODE CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH            ,STATUS_CODE_DESC CHAR(11)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
REARCH            ,SOURCE_TBL CHAR(15)  COLLATE LATIN1_GENERAL_100_BIN2         
REARCH            ,RECV_TYPE CHAR(03)  COLLATE LATIN1_GENERAL_100_BIN2          
REARCH            ,RECV_TYPE_DESC CHAR(25)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
REARCH            ,REVENUE_MONTH_1 CHAR(06)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
REARCH            ,REVENUE_MONTH_2 CHAR(06)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
REARCH            ,CODE_BILL_TYPE CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
REARCH            ,LAST_UPDATE_TS CHAR(26)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
REARCH            ,CHARGE_AMT           DECIMAL(11,2)                   
REARCH            ,CHANGE_FLAG CHAR(01)  COLLATE LATIN1_GENERAL_100_BIN2        
REARCH            ,GL_NO                DECIMAL(7,4)                    
C33832            ,CNT_PAY_AHEAD CHAR(01)  COLLATE 
                                LATIN1_GENERAL_100_BIN2                        
REARCH         )
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH     MOVE SQLSTATE                 TO WS-SQLSTATE.                
REARCH     MOVE SQLCODE                  TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
REARCH     OR WS-SQLSTATE = '42710'                                     
REARCH        NEXT SENTENCE                                             
REARCH     ELSE                                                         
REARCH        MOVE PROGRAM-NAME       TO ABEND-PROGRAM                  
REARCH        MOVE SQLCODE            TO ABEND-SQLCODE                  
REARCH        MOVE SQLSTATE           TO ABEND-SQLSTATE                 
REARCH        MOVE '0100A'            TO ACTIVE-PARAGRAPH               
REARCH        MOVE 'DECLARE GTT'      TO ABEND-FUNCTION                 
REARCH        MOVE SPACES             TO ABEND-SQL-PREDICATES           
REARCH                                   ABEND-TABLES                   
REARCH        MOVE 'CSR02349_R1'      TO TABLE-1                        
REARCH        MOVE SPACES             TO TABLE-ELEMENT-1                
REARCH        MOVE SPACES             TO HOSTVAR-ELEMENT-1              
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 0100A-EXIT.                                                      
REARCH     EXIT.                                                        
REARCH*                                                                         
      ******************************************************************        
      * 0200-INITIALIZE-RS.                                            *        
      ******************************************************************        
                                                                        
       0200-INITIALIZE-RS.                                              
                                                                        
           INITIALIZE     RS-PYMT-PRIORITY-LVL                          
                          RS-ITEM-ID                                    
                          RS-BILL-BALANCE-AMT                           
                          RS-FULL-BALANCE-AMT                           
                          RS-STATUS-CODE                                
                          RS-STATUS-CODE-DESC                           
                          RS-SOURCE-TBL                                 
                          RS-ORIG-BALANCE-AMT                           
                          RS-RECV-TYPE                                  
                          RS-RECV-TYPE-DESC.                            
                                                                        
       0200-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 1000-PROCESS-INPUT                                             *        
      ******************************************************************        
                                                                        
       1000-PROCESS-INPUT.                                              
REARCH     MOVE PARM-ACCOUNT-NO                                         
REARCH                              TO PARM-ACCOUNT-NO-TEMP.            
           MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                   
           MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.             
           MOVE WS-ACCOUNT-NO-COMP3 TO AC-ACCOUNT-NO                    
                                       AT-ACCOUNT-NO.                   
       1000-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2000-PROCESS-OUTPUT.                                           *        
      ******************************************************************        
                                                                        
       2000-PROCESS-OUTPUT.                                             
                                                                        
           MOVE '2000'                           TO ACTIVE-PARAGRAPH.   
           PERFORM 2200-BUILD-RESULT             THRU 2200-EXIT.        
       2000-EXIT.                                                       
           EXIT.                                                        
REARCH*****************************************************************         
REARCH*                                                               *         
REARCH* 2000A-MOVE-RESULT.                                            *         
REARCH*                                                               *         
REARCH*****************************************************************         
REARCH*                                                                         
REARCH 2000A-MOVE-RESULT.                                               
REARCH*                                                                         
REARCH     MOVE RS-RETURN-CODE           TO S-RETURN-CODE               
REARCH     MOVE RS-PYMT-PRIORITY-LVL     TO S-PYMT-PRIORITY-LVL         
REARCH     MOVE RS-ITEM-ID               TO S-ITEM-ID                   
REARCH     MOVE RS-BILL-BALANCE-AMT      TO S-BILL-BALANCE-AMT          
REARCH     MOVE RS-FULL-BALANCE-AMT      TO S-FULL-BALANCE-AMT          
REARCH     MOVE RS-ORIG-BALANCE-AMT      TO S-ORIG-BALANCE-AMT          
REARCH     MOVE RS-STATUS-CODE           TO S-STATUS-CODE               
REARCH     MOVE RS-STATUS-CODE-DESC      TO S-STATUS-CODE-DESC          
REARCH     MOVE RS-SOURCE-TBL            TO S-SOURCE-TBL                
REARCH     MOVE RS-RECV-TYPE             TO S-RECV-TYPE                 
REARCH     MOVE RS-RECV-TYPE-DESC        TO S-RECV-TYPE-DESC            
REARCH     MOVE RS-REVENUE-MONTH-1       TO S-REVENUE-MONTH-1           
REARCH     MOVE RS-REVENUE-MONTH-2       TO S-REVENUE-MONTH-2           
REARCH     MOVE RS-CODE-BILL-TYPE        TO S-CODE-BILL-TYPE            
REARCH     MOVE RS-LAST-UPDATE-TS        TO S-LAST-UPDATE-TS            
REARCH     MOVE RS-CHARGE-AMT            TO S-CHARGE-AMT                
REARCH     MOVE RS-CHANGE-FLAG           TO S-CHANGE-FLAG               
REARCH     MOVE RS-GL-NO                 TO S-GL-NO                     
C33832     MOVE RS-CNT-PAY-AHEAD         TO S-CNT-PAY-AHEAD.            
REARCH*                                                                         
REARCH 2000A-EXIT.                                                      
REARCH     EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2200-BUILD-RESULT                                              *        
      ******************************************************************        
                                                                        
       2200-BUILD-RESULT.                                               
                                                                        
              MOVE '2200'               TO ACTIVE-PARAGRAPH.            
              MOVE PARM-ACCOUNT-NO     TO WS-ACCOUNT-NO.                
              MOVE WS-ACCOUNT-NO-NUM   TO WS-ACCOUNT-NO-COMP3.          
              MOVE WS-ACCOUNT-NO-COMP3     TO AC-ACCOUNT-NO.            
                                                                        
T17741        PERFORM 2304-CHECK-BUSINESS-DAY THRU 2304-EXIT            
T17129        PERFORM 2301-OPEN-BILWDW     THRU 2301-EXIT.              
T17129        PERFORM 2302-FETCH-BILWDW    THRU 2302-EXIT               
T17129                UNTIL SQLCODE = NOT-FOUND OR                      
T17129                WS-SUB > 2.                                       
T17129        PERFORM 2303-CLOSE-BILWDW    THRU 2303-EXIT.              
              PERFORM 7500-CHECK-CIA-DEBIT-ROW         THRU 7500-EXIT.  
T21115        PERFORM 2600-GET-LAST-UPDATE-TS          THRU 2600-EXIT.  
                                                                        
              PERFORM 7000-OPEN-ALL-PPTY-CURSOR        THRU 7000-EXIT.  
              PERFORM 2205-PROCESS-ALL-PPTY-CURSOR     THRU 2205-EXIT.  
              PERFORM 7200-CLOSE-ALL-PPTY-CURSOR       THRU 7200-EXIT.  
                                                                        
              PERFORM 2400-SEND-MISSING-PPTYS          THRU 2400-EXIT.  
                                                                        
       2200-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T17129 2301-OPEN-BILWDW.                                                
                                                                        
           EXEC SQL                                                     
              OPEN BILWDW-CURSOR                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2301'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'OPEN'          TO ABEND-FUNCTION                    
              MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
CBSI          MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-1              
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2              
CBSI          MOVE WS-BUSINESS-DAY      TO HOSTVAR-ELEMENT-1            
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2            
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
       2301-EXIT.                                                       
           EXIT.                                                        
                                                                        
       2302-FETCH-BILWDW.                                               
                                                                        
           EXEC SQL                                                     
              FETCH BILWDW-CURSOR                                       
               INTO :BN-REVENUE-MONTH                                   
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              IF WS-SUB = 1                                             
                 MOVE BN-REVENUE-MONTH     TO WS-REVENUE-MONTH-NUM      
                 MOVE WS-REVENUE-MONTH-NUM TO RS-REVENUE-MONTH-1        
              ELSE                                                      
                 MOVE BN-REVENUE-MONTH     TO WS-REVENUE-MONTH-NUM      
                 MOVE WS-REVENUE-MONTH-NUM TO RS-REVENUE-MONTH-2        
              END-IF                                                    
              ADD     1                TO WS-SUB                        
           ELSE                                                         
              IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                      
                 NEXT SENTENCE                                          
              ELSE                                                      
                 MOVE PROGRAM-NAME    TO ABEND-PROGRAM                  
                 MOVE '2302'          TO ACTIVE-PARAGRAPH               
CBSI             MOVE 'FETCH'              TO ABEND-FUNCTION            
                 MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                   
CBSI             MOVE 'DATE_EXTRACT'       TO TABLE-ELEMENT-1           
CBSI             MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-2           
CBSI             MOVE WS-BUSINESS-DAY      TO HOSTVAR-ELEMENT-1         
CBSI             MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-2         
                 PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT         
                 PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT         
              END-IF                                                    
           END-IF.                                                      
                                                                        
       2302-EXIT.                                                       
            EXIT.                                                       
                                                                        
       2303-CLOSE-BILWDW.                                               
                                                                        
           EXEC SQL                                                     
              CLOSE BILWDW-CURSOR                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
                                                                        
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE PROGRAM-NAME    TO ABEND-PROGRAM                     
              MOVE '2303'          TO ACTIVE-PARAGRAPH                  
CBSI          MOVE 'CLOSE'         TO ABEND-FUNCTION                    
              MOVE 'CSS_BILL_WINDOW'     TO TABLE-1                     
CBSI          MOVE 'DATE_EXTRACT'        TO TABLE-ELEMENT-1             
CBSI          MOVE 'ACCOUNT_NO'          TO TABLE-ELEMENT-2             
CBSI          MOVE WS-BUSINESS-DAY       TO HOSTVAR-ELEMENT-1           
CBSI          MOVE PARM-ACCOUNT-NO       TO HOSTVAR-ELEMENT-2           
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
                                                                        
17129  2303-EXIT.                                                       
            EXIT.                                                       
                                                                        
      ******************************************************************        
T17741*2304-CHECK-BUSINESS-DAY                                          15850000
T17741******************************************************************15860000
T17741 2304-CHECK-BUSINESS-DAY.                                         
T17741                                                                  
T17741     EXEC SQL                                                     
T34097       SELECT
              CAST(SYSDATETIMEOFFSET() AS DATE)
            INTO
              :WS-CURRENT-DATE-DB2                    
T17741     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ006
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     15890000
MFA-TR*      SET :WS-CURRENT-DATE-DB2 = CURRENT DATE                            
MFA-TR*    END-EXEC.                                                    15930000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17741                                                                  
T17741     MOVE SQLCODE                      TO WS-ACTIVE-RETURN-CODE.  
T17741     MOVE SQLCODE                      TO RS-RETURN-CODE.         
T17741                                                                  
T17741     IF SQLCODE = SUCCESSFUL-CALL                                 
T17741        MOVE WS-CURRENT-DATE-DB2 TO WS-NEW-BUSINESS-DAY           
T17741     ELSE                                                         
T17741        MOVE PROGRAM-NAME              TO ABEND-PROGRAM           
T17741        MOVE '2304'                    TO ACTIVE-PARAGRAPH        
T34097        MOVE 'SET'                     TO ABEND-FUNCTION          
T17741        PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT             
T17741        PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT             
T17741     END-IF.                                                      
T17741     PERFORM  7120-SELECT-BILL-WINDOW THRU 7120-EXIT.             
T17741     MOVE 'N'  TO   WS-REVENUE-EXISTS.                            
T17741     IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
T17741        PERFORM 6500-GET-NEXT-BUSINESS-DAY                        
T17741                      THRU 6500-NEXT-BUSINESS-DAY-EXIT            
T17741                UNTIL NEXT-BUSINESS-DAY-FOUND                     
T17741     END-IF.                                                      
T17741     MOVE WS-NEW-BUSINESS-DAY TO WS-BUSINESS-DAY.                 
T17741                                                                  
T17741 2304-EXIT.                                                       
T17741      EXIT.                                                       
      ******************************************************************        
      * 2205-PROCESS-ALL-PPTY-CURSOR                                   *        
      ******************************************************************        
                                                                        
       2205-PROCESS-ALL-PPTY-CURSOR.                                    
                                                                        
           MOVE '2205'               TO ACTIVE-PARAGRAPH.               
                                                                        
           PERFORM 7100-FETCH-ALL-PPTY-CURSOR    THRU  7100-EXIT.       
           IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                         
               MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE             
           END-IF                                                       
                                                                        
           PERFORM 2215-PROCESS-EACH-ROW             THRU 2215-EXIT     
           UNTIL WS-ACTIVE-RETURN-CODE = NOT-FOUND.                     
                                                                        
       2205-EXIT.                                                       
           EXIT.                                                        
                                                                        
      ******************************************************************        
      * 2215-PROCESS-EACH-ROW                                          *        
      ******************************************************************        
                                                                        
       2215-PROCESS-EACH-ROW.                                           
                                                                        
           MOVE '2215'               TO ACTIVE-PARAGRAPH.               
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
              SET VALID-TO-SEND        TO TRUE                          
                                                                        
              EVALUATE WS-CSR-PYMT-PRIORITY-LVL                         
                 WHEN WS-PPL-AR-TYPE-RCC                                
                       SET RCC-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-NSC                                
                       SET NSC-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-NSA                                
                       SET NSA-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-NSN                                
                       SET NSN-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-LPC                                
                       SET LPC-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-LPN                                
                       SET LPN-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-UTE                                
                       SET UTE-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-UTG                                
                       SET UTG-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-EPP                                
                       SET EPP-ROW-SEND TO TRUE                         
                 WHEN WS-PPL-AR-TYPE-CIA                                
                       IF ( WS-CSR-ITEM-ID = 3 )                        
                           SET CIA-DEBIT-ROW-SEND TO TRUE               
                       END-IF                                           
                 WHEN WS-PPL-AR-TYPE-DFA                                
                       PERFORM 2300-SELECT-FULL-AMT THRU 2300-EXIT      
                       IF ( WS-CSR-ITEM-ID < 30000000 )                 
                           MOVE WS-CSR-ITEM-ID   TO                     
                                WS-CSR-ITEM-ID-CHAR                     
                           MOVE CSR-ITEM-ID-YYYY TO                     
                                CSR-ITEM-ID-DATE-YYYY                   
                           MOVE CSR-ITEM-ID-MM   TO                     
                                CSR-ITEM-ID-DATE-MM                     
                           MOVE CSR-ITEM-ID-DD   TO                     
                                CSR-ITEM-ID-DATE-DD                     
                                                                        
                           INITIALIZE DA-FRST-ERNST-PAY-DT              
                                      WS-DATE-NULL-IND-1                
                                      DA-FRST-ERNST-PAY-AMT             
                                      DA-SCND-ERNST-PAY-DT              
                                      WS-DATE-NULL-IND-2                
                                      DA-SCND-ERNST-PAY-AMT             
                                                                        
                           PERFORM 7600-SELECT-DFA-ACCT-EARN            
                              THRU 7600-EXIT                            
                                                                        
                           IF ( WS-CSR-ITEM-ID-DATE EQUAL               
                                      DA-FRST-ERNST-PAY-DT )            
                               MOVE DA-FRST-ERNST-PAY-AMT TO            
                                    WS-CSR-ORIG-BALANCE                 
                           END-IF                                       
                           IF ( WS-CSR-ITEM-ID-DATE EQUAL               
                                      DA-SCND-ERNST-PAY-DT )            
                               MOVE DA-SCND-ERNST-PAY-AMT TO            
                                    WS-CSR-ORIG-BALANCE                 
                           END-IF                                       
                       END-IF                                           
                 WHEN WS-PPL-AR-TYPE-DEP                                
                       PERFORM 2300-SELECT-FULL-AMT THRU 2300-EXIT      
                 WHEN WS-PPL-AR-TYPE-CNT                                
                       PERFORM 2300-SELECT-FULL-AMT THRU 2300-EXIT      
              END-EVALUATE                                              
                                                                        
              MOVE WS-CSR-PYMT-PRIORITY-LVL TO RS-PYMT-PRIORITY-LVL     
              MOVE WS-CSR-ITEM-ID           TO RS-ITEM-ID               
              MOVE WS-CSR-BILL-BALANCE      TO RS-BILL-BALANCE-AMT      
              MOVE WS-CSR-FULL-BALANCE      TO RS-FULL-BALANCE-AMT      
              MOVE WS-CSR-STATUS-CODE       TO RS-STATUS-CODE           
              MOVE WS-CSR-STATUS-CODE-DESC  TO RS-STATUS-CODE-DESC      
              MOVE WS-CSR-SOURCE-TBL        TO RS-SOURCE-TBL            
              MOVE WS-CSR-ORIG-BALANCE      TO RS-ORIG-BALANCE-AMT      
              MOVE WS-CSR-RECV-TYPE         TO RS-RECV-TYPE             
              MOVE WS-CSR-RECV-TYPE-DESC    TO RS-RECV-TYPE-DESC        
                                                                        
              IF  WS-CSR-PYMT-PRIORITY-LVL >= 50                        
                  AND  WS-CSR-ITEM-ID EQUAL ZERO                        
                  NEXT SENTENCE                                         
              ELSE                                                      
                PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                 
                IF VALID-TO-SEND                                        
REARCH             PERFORM 2000A-MOVE-RESULT  THRU 2000A-EXIT           
                   PERFORM 8100-SEND-RESULT THRU 8100-EXIT              
                END-IF                                                  
              END-IF                                                    
           END-IF.                                                      
                                                                        
           SET     VALID-TO-SEND              TO   TRUE                 
           PERFORM 0200-INITIALIZE-RS         THRU 0200-EXIT.           
           PERFORM 7100-FETCH-ALL-PPTY-CURSOR THRU 7100-EXIT.           
                                                                        
       2215-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
                                                                        
       2300-SELECT-FULL-AMT.                                            
            PERFORM 7300-SELECT-AR-FULL-AMT THRU 7300-EXIT.             
                                                                        
       2300-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2400-SEND-MISSING-PPTYS.                                         
                                                                        
             IF NSC-ROW-NOT-SEND                                        
                PERFORM 0200-INITIALIZE-RS THRU 0200-EXIT               
                PERFORM 2410-SEND-NSC-PPTY THRU 2410-EXIT               
             END-IF.                                                    
             IF NSA-ROW-NOT-SEND                                        
                PERFORM 0200-INITIALIZE-RS THRU 0200-EXIT               
                PERFORM 2420-SEND-NSA-PPTY THRU 2420-EXIT               
             END-IF.                                                    
             IF NSN-ROW-NOT-SEND                                        
                PERFORM 0200-INITIALIZE-RS THRU 0200-EXIT               
                PERFORM 2430-SEND-NSN-PPTY THRU 2430-EXIT               
             END-IF.                                                    
                                                                        
             IF LPC-ROW-NOT-SEND                                        
                PERFORM 0200-INITIALIZE-RS THRU 0200-EXIT               
                PERFORM 2440-SEND-LPC-PPTY THRU 2440-EXIT               
             END-IF.                                                    
             IF LPN-ROW-NOT-SEND                                        
                PERFORM 0200-INITIALIZE-RS THRU 0200-EXIT               
                PERFORM 2450-SEND-LPN-PPTY THRU 2450-EXIT               
             END-IF.                                                    
                                                                        
             IF UTE-ROW-NOT-SEND AND EPP-ROW-NOT-SEND                   
                    AND PARM-MISC-DEBIT = 'Y'                           
                PERFORM 0200-INITIALIZE-RS THRU 0200-EXIT               
                PERFORM 2480-SEND-UTE-PPTY THRU 2480-EXIT               
             END-IF.                                                    
                                                                        
             IF UTG-ROW-NOT-SEND AND EPP-ROW-NOT-SEND                   
                    AND PARM-MISC-DEBIT = 'Y'                           
                PERFORM 0200-INITIALIZE-RS THRU 0200-EXIT               
                PERFORM 2490-SEND-UTG-PPTY THRU 2490-EXIT               
             END-IF.                                                    
                                                                        
             IF RCC-ROW-NOT-SEND                                        
                PERFORM 0200-INITIALIZE-RS       THRU 0200-EXIT         
                PERFORM 2470-SEND-RCC-PPTY       THRU 2470-EXIT         
             END-IF.                                                    
                                                                        
             IF CIA-DEBIT-ROW-NOT-SEND                                  
                PERFORM 0200-INITIALIZE-RS       THRU 0200-EXIT         
                PERFORM 2460-SEND-CIA-DEBIT-PPTY THRU 2460-EXIT         
             END-IF.                                                    
                                                                        
                                                                        
       2400-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2410-SEND-NSC-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-NSC  TO   RS-PYMT-PRIORITY-LVL          
            MOVE ZERO                TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-BILL-BALANCE-AMT           
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2410-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2420-SEND-NSA-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-NSA  TO   RS-PYMT-PRIORITY-LVL          
            MOVE ZERO                TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-BILL-BALANCE-AMT           
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2420-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2430-SEND-NSN-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-NSN  TO   RS-PYMT-PRIORITY-LVL          
            MOVE ZERO                TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-BILL-BALANCE-AMT           
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2430-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2440-SEND-LPC-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-LPC  TO   RS-PYMT-PRIORITY-LVL          
            MOVE ZERO                TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-BILL-BALANCE-AMT           
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2440-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2450-SEND-LPN-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-LPN  TO   RS-PYMT-PRIORITY-LVL          
            MOVE ZERO                TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2450-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2480-SEND-UTE-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-UTE  TO   RS-PYMT-PRIORITY-LVL          
            MOVE ZERO                TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT  THRU 8100-EXIT                 
            END-IF.                                                     
       2480-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2490-SEND-UTG-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-UTG  TO   RS-PYMT-PRIORITY-LVL          
            MOVE ZERO                TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2490-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2460-SEND-CIA-DEBIT-PPTY.                                        
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-CIA  TO   RS-PYMT-PRIORITY-LVL          
            MOVE 3                   TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE SPACE               TO   RS-STATUS-CODE                
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO TRUE                            
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2460-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2470-SEND-RCC-PPTY.                                              
            MOVE ZERO                TO   RS-RETURN-CODE                
            MOVE WS-PPL-AR-TYPE-RCC  TO   RS-PYMT-PRIORITY-LVL          
            MOVE +1                  TO   RS-ITEM-ID                    
            MOVE ZERO                TO   RS-FULL-BALANCE-AMT           
            MOVE ZERO                TO   RS-ORIG-BALANCE-AMT           
            MOVE 'CSS_AR_CNTL    '   TO   RS-SOURCE-TBL                 
            SET VALID-TO-SEND        TO   TRUE                          
            MOVE SPACE               TO   WS-CSR-STATUS-CODE            
            MOVE SPACES              TO   RS-STATUS-CODE                
            MOVE SPACES              TO   RS-STATUS-CODE-DESC           
            PERFORM 2500-XLAT-CODES  THRU 2500-EXIT                     
            IF VALID-TO-SEND                                            
REARCH         PERFORM 2000A-MOVE-RESULT THRU 2000A-EXIT                
               PERFORM 8100-SEND-RESULT THRU 8100-EXIT                  
            END-IF.                                                     
       2470-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2500-XLAT-CODES.                                                 
                                                                        
            MOVE RS-PYMT-PRIORITY-LVL       TO L5-PYMT-PRIORITY-LVL     
            PERFORM 7400-SELECT-AR-TYPE     THRU 7400-EXIT              
            MOVE L5-AR-TYPE-SHORT-DESC      TO RS-RECV-TYPE             
            MOVE L5-AR-TYPE-LONG-DESC       TO RS-RECV-TYPE-DESC        
                                                                        
            IF ( L5-AR-TYPE-SHORT-DESC = 'CNT' )                        
               MOVE WS-ACCOUNT-NO-COMP3     TO   CT-ACCOUNT-NO          
               MOVE RS-PYMT-PRIORITY-LVL    TO   CT-PYMT-PRIORITY-LVL   
               MOVE RS-ITEM-ID              TO   CT-CNT-ITEM-ID         
               MOVE SPACES                  TO   K6-CNT-NAME-DESC       
               PERFORM 7410-SELECT-CNT-DESC THRU 7410-EXIT              
               MOVE K6-CNT-NAME-DESC        TO   RS-RECV-TYPE-DESC      
T17550         MOVE CT-CODE-BILL-TYPE       TO   RS-CODE-BILL-TYPE      
            END-IF                                                      
            IF ( L5-AR-TYPE-SHORT-DESC = 'DFA' )                        
               IF ( RS-ITEM-ID < 40000000 )                             
                  MOVE 'DPP'                   TO RS-RECV-TYPE          
                  MOVE 'DEFERRED PAYMENT PLAN' TO RS-RECV-TYPE-DESC     
               END-IF                                                   
            END-IF                                                      
P00453      IF WS-CODE-PRE-PAY-PLAN  = WS-A AND                         
P00453         L5-AR-TYPE-SHORT-DESC = 'BBP'                            
P00453         MOVE 'PRP'                      TO RS-RECV-TYPE          
P00453         MOVE 'PRE-PAY-PLAN'             TO RS-RECV-TYPE-DESC     
P00453      END-IF.                                                     
                                                                        
            IF ( RS-PYMT-PRIORITY-LVL < 50 )                            
               MOVE SPACE               TO WS-CSR-STATUS-CODE           
               MOVE SPACE               TO RS-STATUS-CODE               
               MOVE SPACES              TO RS-STATUS-CODE-DESC          
            ELSE                                                        
               IF RS-PYMT-PRIORITY-LVL = 60                             
                  AND RCC-ROW-NOT-SEND                                  
                 CONTINUE                                               
               ELSE                                                     
                 PERFORM 2510-XLAT-STATUS-CODES THRU 2510-EXIT          
               END-IF                                                   
            END-IF.                                                     
                                                                        
       2500-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
       2510-XLAT-STATUS-CODES.                                          
                                                                        
           EVALUATE RS-PYMT-PRIORITY-LVL                                
      *                                                                         
              WHEN WS-PPL-AR-TYPE-CNT                                   
                   EVALUATE RS-STATUS-CODE                              
                      WHEN 'A'                                          
                           MOVE 'PENDING    ' TO RS-STATUS-CODE-DESC    
                      WHEN 'B'                                          
                           MOVE 'ACTIVE     ' TO RS-STATUS-CODE-DESC    
                      WHEN 'C'                                          
                           MOVE 'PAID       ' TO RS-STATUS-CODE-DESC    
                      WHEN 'D'                                          
                           MOVE 'CANCEL     ' TO RS-STATUS-CODE-DESC    
                      WHEN 'E'                                          
                           MOVE 'CLOSED     ' TO RS-STATUS-CODE-DESC    
                      WHEN 'R'                                          
                           MOVE 'TRANSFERRED' TO RS-STATUS-CODE-DESC    
                   END-EVALUATE                                         
      *                                                                         
              WHEN WS-PPL-AR-TYPE-DFA                                   
                   EVALUATE RS-STATUS-CODE                              
                      WHEN 'A'                                          
                           MOVE 'ACTIVE     ' TO RS-STATUS-CODE-DESC    
                      WHEN 'R'                                          
                           MOVE 'CANCEL     ' TO RS-STATUS-CODE-DESC    
                      WHEN 'C'                                          
                           MOVE 'COMPLETE   ' TO RS-STATUS-CODE-DESC    
                      WHEN 'N'                                          
                           MOVE 'NEW        ' TO RS-STATUS-CODE-DESC    
                   END-EVALUATE                                         
      *                                                                         
              WHEN WS-PPL-AR-TYPE-DEP                                   
                   EVALUATE RS-STATUS-CODE                              
                      WHEN 'A'                                          
                           MOVE 'BILLING    ' TO RS-STATUS-CODE-DESC    
                      WHEN 'P'                                          
                           MOVE 'PAID       ' TO RS-STATUS-CODE-DESC    
                      WHEN 'R'                                          
                           MOVE 'REFUNDED   ' TO RS-STATUS-CODE-DESC    
                      WHEN 'T'                                          
                           MOVE 'TRANSFERRED' TO RS-STATUS-CODE-DESC    
                   END-EVALUATE                                         
      *                                                                         
              WHEN WS-PPL-AR-TYPE-PJS                                   
                   EVALUATE RS-STATUS-CODE                              
                      WHEN 'A'                                          
                           MOVE 'ACTIVE     ' TO RS-STATUS-CODE-DESC    
                      WHEN 'I'                                          
                           MOVE 'INACTIVE   ' TO RS-STATUS-CODE-DESC    
                      WHEN 'O'                                          
                           MOVE 'ONE TIME   ' TO RS-STATUS-CODE-DESC    
                   END-EVALUATE                                         
      *                                                                         
              WHEN WS-PPL-AR-TYPE-CIA                                   
                      MOVE SPACE         TO WS-CSR-STATUS-CODE          
                      MOVE SPACE         TO RS-STATUS-CODE              
                      MOVE SPACES        TO RS-STATUS-CODE-DESC         
      *                                                                         
              WHEN OTHER                                                
                      MOVE 'ACTIVE     ' TO RS-STATUS-CODE-DESC         
      *                                                                         
           END-EVALUATE.                                                
                                                                        
       2510-EXIT.                                                       
           EXIT.                                                        
      *                                                                         
T21115****************************************************************          
T21115*GETS THE LAST-UPDATE-TS FROM CSS_ACCOUNT                      *          
T21115****************************************************************          
T21115 2600-GET-LAST-UPDATE-TS.                                         
T21115*                                                                         
T21115     PERFORM 7700-SELECT-UPDATE-TS       THRU 7700-EXIT.          
T21115     MOVE AT-LAST-UPDATE-TS              TO RS-LAST-UPDATE-TS.    
P00453     MOVE AT-CODES-DATA-PRESENT          TO WS-CODES-DATA-PRESENT.
T21115*                                                                         
T21115 2600-EXIT.                                                       
T21115     EXIT.                                                        
T21115*                                                                         
T17741     EXEC SQL                                                     23760000
              INCLUDE CPD0315B                                          23770000
T17741     END-EXEC.                                                    23780000
                                                                        
T17741******************************************************************16880000
T17741* 7120-SELECT-BILL-WINDOW                                        *16890000
T17741******************************************************************16900000
T17741 7120-SELECT-BILL-WINDOW.                                         
T17741                                                                  
T17741     EXEC SQL                                                     
T17741      SELECT DISTINCT 'Y'                                         
T17741        INTO :WS-REVENUE-EXISTS                                   
T17741        FROM CSS_BILL_WINDOW WITH(READUNCOMMITTED)                        
T17741      WHERE DATE_EXTRACT = CAST(SYSDATETIMEOFFSET() AS DATE)              
P00453                                                           
P00453                                                      
T17741     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ028
MFA-TR*    EXEC SQL                                                     16930000
MFA-TR*     SELECT DISTINCT 'Y'                                         16940000
MFA-TR*       INTO :WS-REVENUE-EXISTS                                   16940000
MFA-TR*       FROM CSS_BILL_WINDOW                                      16940000
MFA-TR*     WHERE DATE_EXTRACT = CURRENT DATE                                   
MFA-TR*       WITH UR                                                           
MFA-TR*    QUERYNO 7120                                                         
MFA-TR*    END-EXEC.                                                    16950000

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T17741                                                                  
T17741     MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
T17741                                                                  
T17741     IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
T17741        NEXT SENTENCE                                             
T17741     ELSE                                                         
T17741        MOVE PROGRAM-NAME     TO ABEND-PROGRAM                    
T17741        MOVE '7120'           TO ACTIVE-PARAGRAPH                 
T17741        MOVE 'SELECT        ' TO ABEND-FUNCTION                   
T17741        MOVE 'CSS_BILL_WINDOW'    TO TABLE-1                      
CBSI          MOVE 'ACCOUNT_NO'         TO TABLE-ELEMENT-1              
CBSI          MOVE PARM-ACCOUNT-NO      TO HOSTVAR-ELEMENT-1            
T17741        PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
T17741        PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
T17741     END-IF.                                                      
T17741                                                                  
T17741 7120-EXIT.                                                       
T17741     EXIT.                                                        
                                                                        
       7000-OPEN-ALL-PPTY-CURSOR.                                       
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OPEN THE CURSOR USED TO FETCH     **        
      **  ROWS FROM THE CSS_AR_TRAN_HIST TABLE.                       **        
      ******************************************************************        
      *                                                                         
           MOVE '7000'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               OPEN ALL-PPTY-ROWS                                       
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'OPEN'                     TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_AR_CNTL'              TO TABLE-1                
CBSI          MOVE 'CSS_PROJ_SHARE'           TO TABLE-2                
CBSI          MOVE 'CSS_CONTRACT'             TO TABLE-3                
CBSI          MOVE 'CSS_DEP_ON_HAND'          TO TABLE-4                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7000-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7100-FETCH-ALL-PPTY-CURSOR.                                      
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO OBTAIN THE NEXT ROW FROM THE      **        
      **  CSS_AR_TRANS_HIST TABLE.                                    **        
      ******************************************************************        
      *                                                                         
           MOVE '7100'               TO ACTIVE-PARAGRAPH.               
           INITIALIZE WS-CSR-VARIABLES.                                 
                                                                        
           EXEC SQL                                                     
               FETCH ALL-PPTY-ROWS                                      
               INTO   :WS-CSR-PYMT-PRIORITY-LVL                         
                    , :WS-CSR-ITEM-ID                                   
                    , :WS-CSR-AMT-DAY-00                                
                    , :WS-CSR-AMT-DAY-30                                
                    , :WS-CSR-AMT-DAY-60                                
                    , :WS-CSR-AMT-DAY-90                                
                    , :WS-CSR-UNUSED-CR                                 
                    , :WS-CSR-FULL-BALANCE                              
                    , :WS-CSR-ORIG-BALANCE                              
                    , :WS-CSR-STATUS-CODE                               
                    , :WS-CSR-SOURCE-TBL                                
                                                                        
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
                                                                        
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
                                         OR NOT-FOUND                   
               COMPUTE WS-CSR-BILL-BALANCE = WS-CSR-AMT-DAY-00 +        
                                             WS-CSR-AMT-DAY-30 +        
                                             WS-CSR-AMT-DAY-60 +        
                                             WS-CSR-AMT-DAY-90 +        
                                             WS-CSR-UNUSED-CR           
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'FETCH'                    TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_AR_CNTL'              TO TABLE-1                
CBSI          MOVE 'CSS_PROJ_SHARE'           TO TABLE-2                
CBSI          MOVE 'CSS_CONTRACT'             TO TABLE-3                
CBSI          MOVE 'CSS_DEP_ON_HAND'          TO TABLE-4                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7100-EXIT.                                                       
           EXIT.                                                        
HPCCDM*EJECT                                                                    
       7200-CLOSE-ALL-PPTY-CURSOR.                                      
      ******************************************************************        
      **  THIS PARAGRAPH IS USED TO CLOSE THE CURSOR USED TO FETCH    **        
      **  ROWS FROM THE CSS_AR_TRANS_HIST TABLE.                      **        
      ******************************************************************        
      *                                                                         
           MOVE '7200'               TO ACTIVE-PARAGRAPH.               
           EXEC SQL                                                     
               CLOSE ALL-PPTY-ROWS                                      
           END-EXEC.                                                    

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL             
               NEXT SENTENCE                                            
           ELSE                                                         
              MOVE PROGRAM-NAME               TO ABEND-PROGRAM          
CBSI          MOVE 'CLOSE'                    TO ABEND-FUNCTION         
CBSI          MOVE 'CSS_AR_CNTL'              TO TABLE-1                
CBSI          MOVE 'CSS_PROJ_SHARE'           TO TABLE-2                
CBSI          MOVE 'CSS_CONTRACT'             TO TABLE-3                
CBSI          MOVE 'CSS_DEP_ON_HAND'          TO TABLE-4                
              MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1        
              MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1      
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT
           END-IF.           
                                                                        
       7200-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7300-SELECT-AR-FULL-AMT.                                         
                                                                        
           MOVE '7300'               TO ACTIVE-PARAGRAPH.               
           MOVE ZERO                 TO WS-CSR-BILL-BALANCE             
           MOVE ZERO                 TO WS-CSR-FULL-BALANCE             
           INITIALIZE                AC-AMT-AR-DAY-00                   
                                     AC-AMT-AR-DAY-30                   
                                     AC-AMT-AR-DAY-60                   
                                     AC-AMT-AR-DAY-90                   
                                     AC-AMT-UNUSED-CR                   
                                     AC-AMT-TRAN-BALANCE                
                                                                        
           EXEC SQL                                                     
            SELECT  AMT_AR_DAY_00                                       
                  , AMT_AR_DAY_30                                       
                  , AMT_AR_DAY_60                                       
                  , AMT_AR_DAY_90                                       
                  , AMT_UNUSED_CR                                       
                  , AMT_TRAN_BALANCE                                    
             INTO  :AC-AMT-AR-DAY-00                                    
                 , :AC-AMT-AR-DAY-30                                    
                 , :AC-AMT-AR-DAY-60                                    
                 , :AC-AMT-AR-DAY-90                                    
                 , :AC-AMT-UNUSED-CR                                    
                 , :AC-AMT-TRAN-BALANCE                                 
             FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                            
            WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                   
              AND  PYMT_PRIORITY_LVL = :WS-CSR-PYMT-PRIORITY-LVL        
              AND  ITEM_ID           = :WS-CSR-ITEM-ID                  
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  AMT_AR_DAY_00                                               
MFA-TR*           , AMT_AR_DAY_30                                               
MFA-TR*           , AMT_AR_DAY_60                                               
MFA-TR*           , AMT_AR_DAY_90                                               
MFA-TR*           , AMT_UNUSED_CR                                               
MFA-TR*           , AMT_TRAN_BALANCE                                            
MFA-TR*      INTO  :AC-AMT-AR-DAY-00                                            
MFA-TR*          , :AC-AMT-AR-DAY-30                                            
MFA-TR*          , :AC-AMT-AR-DAY-60                                            
MFA-TR*          , :AC-AMT-AR-DAY-90                                            
MFA-TR*          , :AC-AMT-UNUSED-CR                                            
MFA-TR*          , :AC-AMT-TRAN-BALANCE                                         
MFA-TR*      FROM  CSS_AR_CNTL                                                  
MFA-TR*     WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                           
MFA-TR*       AND  PYMT_PRIORITY_LVL = :WS-CSR-PYMT-PRIORITY-LVL                
MFA-TR*       AND  ITEM_ID           = :WS-CSR-ITEM-ID                          
MFA-TR*      WITH UR                                                            
MFA-TR*   QUERYNO 7300                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL  NOT-FOUND                   
               NEXT SENTENCE                                            
           ELSE IF WS-ACTIVE-RETURN-CODE  EQUAL  SUCCESSFUL-CALL        
                   COMPUTE WS-CSR-BILL-BALANCE = AC-AMT-AR-DAY-00  +    
                                                 AC-AMT-AR-DAY-30  +    
                                                 AC-AMT-AR-DAY-60  +    
                                                 AC-AMT-AR-DAY-90  +    
                                                 AC-AMT-UNUSED-CR       
                   MOVE   AC-AMT-TRAN-BALANCE TO WS-CSR-FULL-BALANCE    
                ELSE                                                    
                   MOVE PROGRAM-NAME               TO ABEND-PROGRAM     
CBSI               MOVE 'SELECT'                   TO ABEND-FUNCTION    
                   MOVE 'CSS_AR_CNTL   '           TO TABLE-1           
                   MOVE 'ACCOUNT_NO  '             TO TABLE-ELEMENT-1   
CBSI               MOVE 'PYMT_PRIORITY_LVL'        TO TABLE-ELEMENT-2   
CBSI               MOVE 'ITEM_ID'                  TO TABLE-ELEMENT-3   
                   MOVE AC-ACCOUNT-NO              TO HOSTVAR-ELEMENT-1 
CBSI               MOVE WS-CSR-PYMT-PRIORITY-LVL   TO HOSTVAR-ELEMENT-2 
CBSI               MOVE WS-CSR-ITEM-ID             TO HOSTVAR-ELEMENT-3 
                   PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT       
                   PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT       
                END-IF                                                  
            END-IF.                                                     
                                                                        
       7300-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7400-SELECT-AR-TYPE.                                             
                                                                        
           MOVE '7400'               TO ACTIVE-PARAGRAPH.               
           INITIALIZE                L5-AR-TYPE-SHORT-DESC              
                                     L5-AR-TYPE-LONG-DESC               
                                                                        
           EXEC SQL                                                     
            SELECT  PYMT_PRIORITY_LVL                                   
                  , AR_TYPE_SHORT_DESC                                  
                  , AR_TYPE_LONG_DESC                                   
             INTO  :L5-PYMT-PRIORITY-LVL                                
                 , :L5-AR-TYPE-SHORT-DESC                               
                 , :L5-AR-TYPE-LONG-DESC                                
             FROM  CSS_AR_TYPE WITH(READUNCOMMITTED)                            
            WHERE  PYMT_PRIORITY_LVL = :L5-PYMT-PRIORITY-LVL            
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT  PYMT_PRIORITY_LVL                                           
MFA-TR*           , AR_TYPE_SHORT_DESC                                          
MFA-TR*           , AR_TYPE_LONG_DESC                                           
MFA-TR*      INTO  :L5-PYMT-PRIORITY-LVL                                        
MFA-TR*          , :L5-AR-TYPE-SHORT-DESC                                       
MFA-TR*          , :L5-AR-TYPE-LONG-DESC                                        
MFA-TR*      FROM  CSS_AR_TYPE                                                  
MFA-TR*     WHERE  PYMT_PRIORITY_LVL = :L5-PYMT-PRIORITY-LVL                    
MFA-TR*      WITH UR                                                            
MFA-TR*   QUERYNO 7400                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

      *                                                                         
           MOVE SQLCODE                TO WS-ACTIVE-RETURN-CODE.        
      *                                                                         
           IF WS-ACTIVE-RETURN-CODE  EQUAL SUCCESSFUL-CALL OR NOT-FOUND 
               NEXT SENTENCE                                            
           ELSE                                                         
               MOVE PROGRAM-NAME               TO   ABEND-PROGRAM       
CBSI           MOVE 'SELECT'                   TO   ABEND-FUNCTION      
               MOVE 'CSS_AR_TYPE   '           TO   TABLE-1             
               MOVE 'PYMT_PRIORITY_LVL'        TO   TABLE-ELEMENT-1     
CBSI           MOVE 'ACCOUNT_NO'               TO   TABLE-ELEMENT-2     
               MOVE L5-PYMT-PRIORITY-LVL       TO   HOSTVAR-ELEMENT-1   
CBSI           MOVE PARM-ACCOUNT-NO            TO   HOSTVAR-ELEMENT-2   
               PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
               PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
            END-IF.                                                     
                                                                        
       7400-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7410-SELECT-CNT-DESC.                                            
           EXEC SQL                                                     
                SELECT  K6.CNT_NAME_DESC                                
T17550                , CT.CODE_BILL_TYPE                               
                  INTO :K6-CNT-NAME-DESC                                
T17550               , :CT-CODE-BILL-TYPE                               
                FROM   CSS_CONTRACT CT WITH(READUNCOMMITTED)                    
                     , CSS_CONTRACT_INFO K6 WITH(READUNCOMMITTED)               
                WHERE  CT.ACCOUNT_NO         = :CT-ACCOUNT-NO           
                  AND  CT.PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL    
                  AND  CT.CNT_ITEM_ID        = :CT-CNT-ITEM-ID          
                  AND  CT.CNT_NAME_CD        = K6.CNT_NAME_CD           
                  AND  CT.CODE_CONTRACT_TYPE = K6.CODE_CONTRACT_TYPE    
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  K6.CNT_NAME_DESC                                        
MFA-TR*               , CT.CODE_BILL_TYPE                                       
MFA-TR*           INTO :K6-CNT-NAME-DESC                                        
MFA-TR*              , :CT-CODE-BILL-TYPE                                       
MFA-TR*         FROM   CSS_CONTRACT CT                                          
MFA-TR*              , CSS_CONTRACT_INFO K6                                     
MFA-TR*         WHERE  CT.ACCOUNT_NO         = :CT-ACCOUNT-NO                   
MFA-TR*           AND  CT.PYMT_PRIORITY_LVL  = :CT-PYMT-PRIORITY-LVL            
MFA-TR*           AND  CT.CNT_ITEM_ID        = :CT-CNT-ITEM-ID                  
MFA-TR*           AND  CT.CNT_NAME_CD        = K6.CNT_NAME_CD                   
MFA-TR*           AND  CT.CODE_CONTRACT_TYPE = K6.CODE_CONTRACT_TYPE            
MFA-TR*          WITH UR                                                        
MFA-TR*       QUERYNO 7410                                                      
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO   RS-RETURN-CODE            
              MOVE PROGRAM-NAME          TO   ABEND-PROGRAM             
CBSI          MOVE '7410'                TO   ACTIVE-PARAGRAPH          
              MOVE 'SELECT'              TO   ABEND-FUNCTION            
              MOVE SPACES                TO   ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
              MOVE 'CSS_CONTRACT'        TO   TABLE-1                   
              MOVE 'CSS_CONTRACT_INFO'   TO   TABLE-2                   
CBSI          MOVE 'ACCOUNT_NO'          TO   TABLE-ELEMENT-1           
CBSI          MOVE 'PYMT_PRIORITY_LVL'   TO   TABLE-ELEMENT-2           
CBSI          MOVE 'CNT_ITEM_ID'         TO   TABLE-ELEMENT-3           
              MOVE CT-ACCOUNT-NO         TO   HOSTVAR-ELEMENT-1         
              MOVE CT-PYMT-PRIORITY-LVL  TO   HOSTVAR-ELEMENT-2         
              MOVE CT-CNT-ITEM-ID        TO   HOSTVAR-ELEMENT-3         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7410-EXIT.                                                       
           EXIT.                                                        
                                                                        
HPCCDM*EJECT                                                                    
       7500-CHECK-CIA-DEBIT-ROW.                                        
           EXEC SQL                                                     
                SELECT  'Y'                                             
                  INTO :WS-CIA-DEBIT-ROW-IND                            
                  FROM  CSS_AR_CNTL WITH(READUNCOMMITTED)                       
                 WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO              
                   AND  PYMT_PRIORITY_LVL = 70                          
                   AND  ITEM_ID           = 3                           
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*         SELECT  'Y'                                                     
MFA-TR*           INTO :WS-CIA-DEBIT-ROW-IND                                    
MFA-TR*           FROM  CSS_AR_CNTL                                             
MFA-TR*          WHERE  ACCOUNT_NO        = :AC-ACCOUNT-NO                      
MFA-TR*            AND  PYMT_PRIORITY_LVL = 70                                  
MFA-TR*            AND  ITEM_ID           = 3                                   
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7500                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL                   
              NEXT SENTENCE                                             
           ELSE IF WS-ACTIVE-RETURN-CODE = NOT-FOUND                    
                   MOVE 'N'  TO WS-CIA-DEBIT-ROW-IND                    
                ELSE                                                    
                   MOVE WS-ACTIVE-RETURN-CODE TO RS-RETURN-CODE         
                   MOVE PROGRAM-NAME          TO  ABEND-PROGRAM         
                   MOVE '7500'                TO  ACTIVE-PARAGRAPH      
                   MOVE 'SELECT'              TO  ABEND-FUNCTION        
                   MOVE SPACES                TO  ABEND-SQL-PREDICATES  
                                                  ABEND-TABLES          
CBSI               MOVE 'CSS_AR_CNTL'         TO  TABLE-1               
CBSI               MOVE 'ACCOUNT_NO'          TO  TABLE-ELEMENT-1       
CBSI               MOVE AC-ACCOUNT-NO         TO  HOSTVAR-ELEMENT-1     
                   PERFORM 9000-SEND-ERROR-RESULT THRU 9000-EXIT        
                   PERFORM 9900-SQL-ERROR-ROUTINE THRU 9900-EXIT        
                END-IF
           END-IF.                                                 
       7500-EXIT.                                                       
           EXIT.                                                        
                                                                        
       7600-SELECT-DFA-ACCT-EARN.                                       
           EXEC SQL                                                     
            SELECT   FRST_ERNST_PAY_DT                                  
                   , FRST_ERNST_PAY_AMT                                 
                   , SCND_ERNST_PAY_DT                                  
                   , SCND_ERNST_PAY_AMT                                 
             INTO    :DA-FRST-ERNST-PAY-DT :WS-DATE-NULL-IND-1          
                   , :DA-FRST-ERNST-PAY-AMT                             
                   , :DA-SCND-ERNST-PAY-DT :WS-DATE-NULL-IND-2          
                   , :DA-SCND-ERNST-PAY-AMT                             
            FROM   CSS_DFA_ACCT WITH(READUNCOMMITTED)                           
            WHERE  ACCOUNT_NO         = :AC-ACCOUNT-NO                  
              AND  PYMT_PRIORITY_LVL  = 90                              
              AND  CODE_DFA_TYPE      = 'B'                             
              AND  DFA_ITEM_ID   = (                                    
                                   SELECT  MAX(DFA_ITEM_ID)             
                                     FROM  CSS_DFA_ACCT
                           WITH(READUNCOMMITTED)                 
                                    WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO 
                                      AND  PYMT_PRIORITY_LVL  = 90      
                                      AND  CODE_DFA_TYPE      = 'B'     
                                   )                                    
P00453                                                           
P00453                                                      
           END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR*    EXEC SQL                                                             
MFA-TR*     SELECT   FRST_ERNST_PAY_DT                                          
MFA-TR*            , FRST_ERNST_PAY_AMT                                         
MFA-TR*            , SCND_ERNST_PAY_DT                                          
MFA-TR*            , SCND_ERNST_PAY_AMT                                         
MFA-TR*      INTO    :DA-FRST-ERNST-PAY-DT :WS-DATE-NULL-IND-1                  
MFA-TR*            , :DA-FRST-ERNST-PAY-AMT                                     
MFA-TR*            , :DA-SCND-ERNST-PAY-DT :WS-DATE-NULL-IND-2                  
MFA-TR*            , :DA-SCND-ERNST-PAY-AMT                                     
MFA-TR*     FROM   CSS_DFA_ACCT                                                 
MFA-TR*     WHERE  ACCOUNT_NO         = :AC-ACCOUNT-NO                          
MFA-TR*       AND  PYMT_PRIORITY_LVL  = 90                                      
MFA-TR*       AND  CODE_DFA_TYPE      = 'B'                                     
MFA-TR*       AND  DFA_ITEM_ID   = (                                            
MFA-TR*                            SELECT  MAX(DFA_ITEM_ID)                     
MFA-TR*                              FROM  CSS_DFA_ACCT                         
MFA-TR*                             WHERE  ACCOUNT_NO  = :AC-ACCOUNT-NO         
MFA-TR*                               AND  PYMT_PRIORITY_LVL  = 90              
MFA-TR*                               AND  CODE_DFA_TYPE      = 'B'             
MFA-TR*                            )                                            
MFA-TR*      WITH UR                                                            
MFA-TR*   QUERYNO 7600                                                          
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

                                                                        
           MOVE SQLCODE TO WS-ACTIVE-RETURN-CODE.                       
           IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND      
              NEXT SENTENCE                                             
           ELSE                                                         
              MOVE WS-ACTIVE-RETURN-CODE TO   RS-RETURN-CODE            
              MOVE PROGRAM-NAME          TO   ABEND-PROGRAM             
CBSI          MOVE '7600'                TO   ACTIVE-PARAGRAPH          
              MOVE 'SELECT'              TO   ABEND-FUNCTION            
              MOVE SPACES                TO   ABEND-SQL-PREDICATES      
                                              ABEND-TABLES              
CBSI          MOVE 'CSS_DFA_ACCT'        TO   TABLE-1                   
CBSI          MOVE 'ACCOUNT_NO'          TO   TABLE-ELEMENT-1           
CBSI          MOVE AC-ACCOUNT-NO         TO   HOSTVAR-ELEMENT-1         
              PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT            
              PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT            
           END-IF.                                                      
       7600-EXIT.                                                       
           EXIT.                                                        
                                                                        
T21115*                                                                         
T21115******************************************************************        
T21115* GETS LAST_UPDATE_TS FROM CSS_ACCOUNT FOR THE PARM-ACCOUNT-NO   *        
T21115******************************************************************        
T21115 7700-SELECT-UPDATE-TS.                                           
T21115*                                                                         
T21115     EXEC SQL                                                     
T21115         SELECT REPLACE(REPLACE(CONVERT(CHAR(26), LAST_UPDATE_TS
           , 121), ' ', '-'), ':', '.') LAST_UPDATE_TS                         
P00453               ,CODES_DATA_PRESENT                                
T21115           INTO :AT-LAST-UPDATE-TS                                
P00453               ,:AT-CODES-DATA-PRESENT                            
T21115           FROM CSS_ACCOUNT WITH(READUNCOMMITTED)                         
T21115           WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                      
P00453                                                           
P00453                                                      
T21115     END-EXEC.                                                    

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ003
MFA-TR* MSQ022
MFA-TR* MSQ061
MFA-TR*    EXEC SQL                                                             
MFA-TR*        SELECT LAST_UPDATE_TS                                            
MFA-TR*              ,CODES_DATA_PRESENT                                        
MFA-TR*          INTO :AT-LAST-UPDATE-TS                                        
MFA-TR*              ,:AT-CODES-DATA-PRESENT                            16247201
MFA-TR*          FROM CSS_ACCOUNT                                               
MFA-TR*          WHERE ACCOUNT_NO = :AT-ACCOUNT-NO                              
MFA-TR*           WITH UR                                                       
MFA-TR*        QUERYNO 7700                                                     
MFA-TR*    END-EXEC.                                                            

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

T21115*                                                                         
T21115     MOVE SQLCODE                   TO WS-ACTIVE-RETURN-CODE.     
T21115     IF  WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
T21115         NEXT SENTENCE                                            
T21115     ELSE                                                         
T21115         MOVE WS-ACTIVE-RETURN-CODE TO   RS-RETURN-CODE           
T21115         MOVE PROGRAM-NAME          TO   ABEND-PROGRAM            
T21115         MOVE '7700'                TO   ACTIVE-PARAGRAPH         
T21115         MOVE 'SELECT'              TO   ABEND-FUNCTION           
T21115         MOVE SPACES                TO   ABEND-SQL-PREDICATES     
T21115                                         ABEND-TABLES             
T21115         MOVE 'CSS_ACCOUNT'         TO   TABLE-1                  
T21115         MOVE 'ACCOUNT_NO'          TO   TABLE-ELEMENT-1          
T21115         MOVE AT-ACCOUNT-NO         TO   HOSTVAR-ELEMENT-1        
T21115         PERFORM 9000-SEND-ERROR-RESULT  THRU 9000-EXIT           
T21115         PERFORM 9900-SQL-ERROR-ROUTINE  THRU 9900-EXIT           
T21115     END-IF.                                                      
T21115*                                                                         
T21115 7700-EXIT.                                                       
T21115     EXIT.                                                        
HPCCDM*EJECT                                                                    
REARCH******************************************************************        
REARCH* 8100-SEND-RESULT                                               *        
REARCH******************************************************************        
REARCH 8100-SEND-RESULT.                                                
REARCH                                                                  
REARCH     EXEC SQL                                                     
REARCH         INSERT INTO #CSR02349_R1                          
REARCH         (                                                        
REARCH             RETURN_CODE                                          
REARCH            ,PYMT_PRIORITY_LVL                                    
REARCH            ,ITEM_ID                                              
REARCH            ,BILL_BALANCE_AMT                                     
REARCH            ,FULL_BALANCE_AMT                                     
REARCH            ,ORIG_BALANCE_AMT                                     
REARCH            ,STATUS_CODE                                          
REARCH            ,STATUS_CODE_DESC                                     
REARCH            ,SOURCE_TBL                                           
REARCH            ,RECV_TYPE                                            
REARCH            ,RECV_TYPE_DESC                                       
REARCH            ,REVENUE_MONTH_1                                      
REARCH            ,REVENUE_MONTH_2                                      
REARCH            ,CODE_BILL_TYPE                                       
REARCH            ,LAST_UPDATE_TS                                       
REARCH            ,CHARGE_AMT                                           
REARCH            ,CHANGE_FLAG                                          
REARCH            ,GL_NO                                                
C33832            ,CNT_PAY_AHEAD                                        
REARCH         )                                                        
REARCH         VALUES                                                   
REARCH         (                                                        
REARCH             :S-RETURN-CODE                                       
REARCH            ,:S-PYMT-PRIORITY-LVL                                 
REARCH            ,:S-ITEM-ID                                           
REARCH            ,:S-BILL-BALANCE-AMT                                  
REARCH            ,:S-FULL-BALANCE-AMT                                  
REARCH            ,:S-ORIG-BALANCE-AMT                                  
REARCH            ,:S-STATUS-CODE                                       
REARCH            ,:S-STATUS-CODE-DESC                                  
REARCH            ,:S-SOURCE-TBL                                        
REARCH            ,:S-RECV-TYPE                                         
REARCH            ,:S-RECV-TYPE-DESC                                    
REARCH            ,:S-REVENUE-MONTH-1                                   
REARCH            ,:S-REVENUE-MONTH-2                                   
REARCH            ,:S-CODE-BILL-TYPE                                    
REARCH            ,:S-LAST-UPDATE-TS                                    
REARCH            ,:S-CHARGE-AMT                                        
REARCH            ,:S-CHANGE-FLAG                                       
REARCH            ,:S-GL-NO                                             
C33832            ,:S-CNT-PAY-AHEAD                                     
REARCH         )                                                        
REARCH      END-EXEC.                                                   

MFA-TR* TRANSFORMATION LIST
MFA-TR* MSQ049
MFA-TR*    EXEC SQL                                                             
MFA-TR*        INSERT INTO SESSION.CSR02349_R1                                  
MFA-TR*        (                                                                
MFA-TR*            RETURN_CODE                                                  
MFA-TR*           ,PYMT_PRIORITY_LVL                                            
MFA-TR*           ,ITEM_ID                                                      
MFA-TR*           ,BILL_BALANCE_AMT                                             
MFA-TR*           ,FULL_BALANCE_AMT                                             
MFA-TR*           ,ORIG_BALANCE_AMT                                             
MFA-TR*           ,STATUS_CODE                                                  
MFA-TR*           ,STATUS_CODE_DESC                                             
MFA-TR*           ,SOURCE_TBL                                                   
MFA-TR*           ,RECV_TYPE                                                    
MFA-TR*           ,RECV_TYPE_DESC                                               
MFA-TR*           ,REVENUE_MONTH_1                                              
MFA-TR*           ,REVENUE_MONTH_2                                              
MFA-TR*           ,CODE_BILL_TYPE                                               
MFA-TR*           ,LAST_UPDATE_TS                                               
MFA-TR*           ,CHARGE_AMT                                                   
MFA-TR*           ,CHANGE_FLAG                                                  
MFA-TR*           ,GL_NO                                                        
MFA-TR*           ,CNT_PAY_AHEAD                                                
MFA-TR*        )                                                                
MFA-TR*        VALUES                                                           
MFA-TR*        (                                                                
MFA-TR*            :S-RETURN-CODE                                               
MFA-TR*           ,:S-PYMT-PRIORITY-LVL                                         
MFA-TR*           ,:S-ITEM-ID                                                   
MFA-TR*           ,:S-BILL-BALANCE-AMT                                          
MFA-TR*           ,:S-FULL-BALANCE-AMT                                          
MFA-TR*           ,:S-ORIG-BALANCE-AMT                                          
MFA-TR*           ,:S-STATUS-CODE                                               
MFA-TR*           ,:S-STATUS-CODE-DESC                                          
MFA-TR*           ,:S-SOURCE-TBL                                                
MFA-TR*           ,:S-RECV-TYPE                                                 
MFA-TR*           ,:S-RECV-TYPE-DESC                                            
MFA-TR*           ,:S-REVENUE-MONTH-1                                           
MFA-TR*           ,:S-REVENUE-MONTH-2                                           
MFA-TR*           ,:S-CODE-BILL-TYPE                                            
MFA-TR*           ,:S-LAST-UPDATE-TS                                            
MFA-TR*           ,:S-CHARGE-AMT                                                
MFA-TR*           ,:S-CHANGE-FLAG                                               
MFA-TR*           ,:S-GL-NO                                                     
MFA-TR*           ,:S-CNT-PAY-AHEAD                                             
MFA-TR*        )                                                                
MFA-TR*     END-EXEC.                                                           

MSQ017     CALL "MFASQLCA"
MSQ017       USING SQLCA, BY VALUE MFA-PROGRAM-ID, "0", "0", "0",
MSQ017       BY REFERENCE MFSQLMESSAGETEXT
MSQ017     END-CALL

REARCH*                                                                         
REARCH      MOVE SQLCODE                 TO WS-ACTIVE-RETURN-CODE.      
REARCH*                                                                         
REARCH      IF WS-ACTIVE-RETURN-CODE = SUCCESSFUL-CALL OR NOT-FOUND     
REARCH         ADD 1                     TO CTR-ROWS                    
REARCH      ELSE                                                        
REARCH         MOVE PROGRAM-NAME         TO ABEND-PROGRAM               
REARCH         MOVE '8100'               TO ACTIVE-PARAGRAPH            
REARCH         MOVE 'INSERT'             TO ABEND-FUNCTION              
REARCH         MOVE SPACES               TO ABEND-SQL-PREDICATES        
REARCH                                      ABEND-TABLES                
REARCH         MOVE 'CSR02349_R1'        TO TABLE-1                     
REARCH         MOVE SPACES               TO TABLE-ELEMENT-1             
REARCH         MOVE SPACES               TO HOSTVAR-ELEMENT-1           
REARCH         PERFORM 9900-SQL-ERROR-ROUTINE                           
REARCH                                   THRU 9900-EXIT                 
REARCH     END-IF.                                                      
REARCH*                                                                         
REARCH 8100-EXIT.                                                       
REARCH     EXIT.                                                        
      ******************************************************************        
      * 9900- JOURNALING / ERROR HANDLING INCLUDE *                             
      ******************************************************************        
                                                                        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPDSP300                                                  
REARCH     END-EXEC.                                                            
                                                                        
      ******************************************************************        
      *       END PROGRAM COPYLIB                                      *        
      ******************************************************************        
REARCH     EXEC SQL                                                             
REARCH        INCLUDE CPD00320                                                  
REARCH     END-EXEC.                                                            
                                                                        
